/*****************************************************************************\

Copyright (c) Intel Corporation (2009-2017).

    INTEL MAKES NO WARRANTY OF ANY KIND REGARDING THE CODE.  THIS CODE IS
    LICENSED ON AN "AS IS" BASIS AND INTEL WILL NOT PROVIDE ANY SUPPORT,
    ASSISTANCE, INSTALLATION, TRAINING OR OTHER SERVICES.  INTEL DOES NOT
    PROVIDE ANY UPDATES, ENHANCEMENTS OR EXTENSIONS.  INTEL SPECIFICALLY
    DISCLAIMS ANY WARRANTY OF MERCHANTABILITY, NONINFRINGEMENT, FITNESS FOR ANY
    PARTICULAR PURPOSE, OR ANY OTHER WARRANTY.  Intel disclaims all liability,
    including liability for infringement of any proprietary rights, relating to
    use of the code. No license, express or implied, by estoppel or otherwise,
    to any intellectual property rights is granted herein.

  \file linux_resource_linker.cpp

\*****************************************************************************/

#include <stdio.h>
#include <string.h>

int main(int argc, char **argv)
{
    FILE *input;
    FILE *output;

    if (!argv[1] || !strcmp(argv[1], "-h") || !strcmp(argv[1], "--help") || !argv[2] || !argv[3])
    {
        printf("Usage: bif_linker [input file] [output file] [symbol base name]\n");
        return 0;
    }

    input = fopen(argv[1], "rb");
    if (!input)
    {
        printf("Unable to open input file for reading (%s)\n", argv[1]);
        return 1;
    }

    output = fopen(argv[2], "wb");
    if (!output)
    {
        printf("Unable to open output file for writing (%s)\n", argv[2]);
        return 1;
    }

    fprintf(output, "// This file is auto generated by bo_linker, DO NOT EDIT\n\n");
    fprintf(output, "unsigned char __attribute__((visibility(\"default\"))) %s[] =\n{\n    ", argv[3]);

    int count = 0;
    int is_eol;
    unsigned char data;
    while(fread(&data, 1, 1, input))
    {
    	is_eol = count ? !(count % 20) : 0;
        fprintf(output, "%s0x%.2x, ", is_eol? "\n    ":"", data);
        count++;
    }
    fprintf(output, "0x00\n};\n\n");

    fprintf(output, "unsigned int __attribute__((visibility(\"default\"))) %s_size = %d;\n\n", argv[3], count);
    fclose(input);
    fclose(output);

}
