// This file is generated by WOK (CPPExt).
// Please do not edit this file; modify original file instead.
// The copyright and license terms as defined for the original file apply to 
// this header file considered to be the "object code" form of the original source.

#ifndef _IGESSolid_TopoBuilder_HeaderFile
#define _IGESSolid_TopoBuilder_HeaderFile

#ifndef _Standard_HeaderFile
#include <Standard.hxx>
#endif
#ifndef _Standard_DefineAlloc_HeaderFile
#include <Standard_DefineAlloc.hxx>
#endif
#ifndef _Standard_Macro_HeaderFile
#include <Standard_Macro.hxx>
#endif

#ifndef _Handle_IGESSolid_ManifoldSolid_HeaderFile
#include <Handle_IGESSolid_ManifoldSolid.hxx>
#endif
#ifndef _Handle_IGESSolid_Shell_HeaderFile
#include <Handle_IGESSolid_Shell.hxx>
#endif
#ifndef _Standard_Integer_HeaderFile
#include <Standard_Integer.hxx>
#endif
#ifndef _Handle_TColStd_HSequenceOfTransient_HeaderFile
#include <Handle_TColStd_HSequenceOfTransient.hxx>
#endif
#ifndef _Handle_TColStd_HSequenceOfInteger_HeaderFile
#include <Handle_TColStd_HSequenceOfInteger.hxx>
#endif
#ifndef _Handle_IGESSolid_Face_HeaderFile
#include <Handle_IGESSolid_Face.hxx>
#endif
#ifndef _Handle_IGESData_IGESEntity_HeaderFile
#include <Handle_IGESData_IGESEntity.hxx>
#endif
#ifndef _Handle_IGESSolid_Loop_HeaderFile
#include <Handle_IGESSolid_Loop.hxx>
#endif
#ifndef _Handle_IGESSolid_EdgeList_HeaderFile
#include <Handle_IGESSolid_EdgeList.hxx>
#endif
#ifndef _Handle_IGESSolid_VertexList_HeaderFile
#include <Handle_IGESSolid_VertexList.hxx>
#endif
#ifndef _Handle_TColgp_HSequenceOfXYZ_HeaderFile
#include <Handle_TColgp_HSequenceOfXYZ.hxx>
#endif
class IGESSolid_ManifoldSolid;
class IGESSolid_Shell;
class TColStd_HSequenceOfTransient;
class TColStd_HSequenceOfInteger;
class IGESSolid_Face;
class IGESData_IGESEntity;
class IGESSolid_Loop;
class IGESSolid_EdgeList;
class IGESSolid_VertexList;
class TColgp_HSequenceOfXYZ;
class Standard_DomainError;
class gp_XYZ;


//! This class manages the creation of an IGES Topologic entity <br>
//!           (BREP : ManifoldSolid, Shell, Face) <br>
//!           This includes definiting of Vertex and Edge Lists, <br>
//!           building of Edges and Loops <br>
class IGESSolid_TopoBuilder  {
public:

  DEFINE_STANDARD_ALLOC

  //! Creates an empty TopoBuilder <br>
//!           This creates also a unique VertexList and a unique EdgeList, <br>
//!           empty, but which can be referenced from starting <br>
  Standard_EXPORT   IGESSolid_TopoBuilder();
  //! Resets the TopoBuilder for an entirely new operation <br>
//!           (with a new EdgeList, a new VertexList, new Shells, ...) <br>
  Standard_EXPORT     void Clear() ;
  //! Adds a Vertex to the VertexList <br>
  Standard_EXPORT     void AddVertex(const gp_XYZ& val) ;
  //! Returns the count of already recorded Vertices <br>
  Standard_EXPORT     Standard_Integer NbVertices() const;
  //! Returns a Vertex, given its rank <br>
  Standard_EXPORT    const gp_XYZ& Vertex(const Standard_Integer num) const;
  //! Returns the VertexList. It can be referenced, but it remains <br>
//!           empty until call to EndShell or EndSolid <br>
  Standard_EXPORT     Handle_IGESSolid_VertexList VertexList() const;
  //! Adds an Edge (3D) to the EdgeList, defined by a Curve and <br>
//!           two number of Vertex, for start and end <br>
  Standard_EXPORT     void AddEdge(const Handle(IGESData_IGESEntity)& curve,const Standard_Integer vstart,const Standard_Integer vend) ;
  //! Returns the count of recorded Edges (3D) <br>
  Standard_EXPORT     Standard_Integer NbEdges() const;
  //! Returns the definition of an Edge (3D) given its rank <br>
  Standard_EXPORT     void Edge(const Standard_Integer num,Handle(IGESData_IGESEntity)& curve,Standard_Integer& vstart,Standard_Integer& vend) const;
  //! Returns the EdgeList. It can be referenced, but it remains <br>
//!           empty until call to EndShell or EndSolid <br>
  Standard_EXPORT     Handle_IGESSolid_EdgeList EdgeList() const;
  //! Begins the definition of a new Loop : it is the Current Loop <br>
//!           All Edges (UV) defined by MakeEdge/EndEdge will be added in it <br>
//!           The Loop can then be referenced but is empty. It will be <br>
//!           filled with its Edges(UV) by EndLoop (from SetOuter/AddInner) <br>
  Standard_EXPORT     void MakeLoop() ;
  //! Defines an Edge(UV), to be added in the current Loop by EndEdge <br>
//!           <edgetype> gives the type of the edge <br>
//!           <edge3d> identifies the Edge(3D) used as support <br>
//!           The EdgeList is allways the current one <br>
//!           <orientation gives the orientation flag <br>
//!           It is then necessary to : <br>
//!           - give the parametric curves <br>
//!           - close the definition of this edge(UV) by EndEdge, else <br>
//!             the next call to MakeEdge will erase this one <br>
  Standard_EXPORT     void MakeEdge(const Standard_Integer edgetype,const Standard_Integer edge3d,const Standard_Integer orientation) ;
  //! Adds a Parametric Curve (UV) to the current Edge(UV) <br>
  Standard_EXPORT     void AddCurveUV(const Handle(IGESData_IGESEntity)& curve,const Standard_Integer iso) ;
  //! Closes the definition of an Edge(UV) and adds it to the <br>
//!           current Loop <br>
  Standard_EXPORT     void EndEdge() ;
  //! Begins the definition of a new Face, on a surface <br>
//!           All Loops defined by MakeLoop will be added in it, according <br>
//!           the closing call : SetOuter for the Outer Loop (by default, <br>
//!           if SetOuter is not called, no OuterLoop is defined); <br>
//!           AddInner for the list of Inner Loops (there can be none) <br>
  Standard_EXPORT     void MakeFace(const Handle(IGESData_IGESEntity)& surface) ;
  //! Closes the current Loop and sets it Loop as Outer Loop. If no <br>
//!           current Loop has yet been defined, does nothing. <br>
  Standard_EXPORT     void SetOuter() ;
  //! Closes the current Loop and adds it to the list of Inner Loops <br>
//!           for the current Face <br>
  Standard_EXPORT     void AddInner() ;
  //! Closes the definition of the current Face, fills it and adds <br>
//!           it to the current Shell with an orientation flag (0/1) <br>
  Standard_EXPORT     void EndFace(const Standard_Integer orientation) ;
  //! Begins the definition of a new Shell (either Simple or in a <br>
//!           Solid) <br>
  Standard_EXPORT     void MakeShell() ;
  //! Closes the whole definition as that of a simple Shell <br>
  Standard_EXPORT     void EndSimpleShell() ;
  //! Closes the definition of the current Shell as for the Main <br>
//!           Shell of a Solid, with an orientation flag (0/1) <br>
  Standard_EXPORT     void SetMainShell(const Standard_Integer orientation) ;
  //! Closes the definition of the current Shell and adds it to the <br>
//!           list of Void Shells of a Solid, with an orientation flag (0/1) <br>
  Standard_EXPORT     void AddVoidShell(const Standard_Integer orientation) ;
  //! Closes the whole definition as that of a ManifoldSolid <br>
//!           Its call is exclusive from that of EndSimpleShell <br>
  Standard_EXPORT     void EndSolid() ;
  //! Returns the current Shell. The current Shell is created empty <br>
//!           by MakeShell and filled by EndShell <br>
  Standard_EXPORT     Handle_IGESSolid_Shell Shell() const;
  //! Returns the current ManifoldSolid. It is created empty by <br>
//!           Create and filled by EndSolid <br>
  Standard_EXPORT     Handle_IGESSolid_ManifoldSolid Solid() const;





protected:

  //! Closes the definition of Vertex and Edge Lists <br>
//!  Warning : Called only by EndSimpleShell and EndSolid <br>
  Standard_EXPORT     void EndLists() ;
  //! Closes the definition of a Loop and fills it <br>
//!  Warning : EndLoop should not be called directly but through <br>
//!           SetOuter or AddInner, which work on the current Face <br>
  Standard_EXPORT     void EndLoop() ;
  //! Closes the definition of the current Shell <br>
//!  Warning : EndShell should not be called directly but through <br>
//!           EndSimpleShell (for a simple Shell), SetMainShell (for main <br>
//!           Shell of a Solid) or AddVoidShell (to a Solid) <br>
  Standard_EXPORT     void EndShell() ;




private:



Handle_IGESSolid_ManifoldSolid thesolid;
Handle_IGESSolid_Shell themains;
Standard_Integer themflag;
Handle_TColStd_HSequenceOfTransient thevoids;
Handle_TColStd_HSequenceOfInteger thevflag;
Handle_IGESSolid_Shell theshell;
Handle_TColStd_HSequenceOfTransient thefaces;
Handle_TColStd_HSequenceOfInteger thefflag;
Handle_IGESSolid_Face theface;
Handle_IGESData_IGESEntity thesurf;
Standard_Integer theouter;
Handle_TColStd_HSequenceOfTransient theinner;
Handle_IGESSolid_Loop theloop;
Handle_TColStd_HSequenceOfInteger theetype;
Handle_TColStd_HSequenceOfInteger thee3d;
Handle_TColStd_HSequenceOfInteger theeflag;
Handle_TColStd_HSequenceOfTransient theeuv;
Handle_TColStd_HSequenceOfInteger theisol;
Handle_TColStd_HSequenceOfTransient thecuruv;
Handle_TColStd_HSequenceOfTransient theiso;
Handle_IGESSolid_EdgeList theedgel;
Handle_TColStd_HSequenceOfTransient thecur3d;
Handle_TColStd_HSequenceOfInteger thevstar;
Handle_TColStd_HSequenceOfInteger thevend;
Handle_IGESSolid_VertexList thevertl;
Handle_TColgp_HSequenceOfXYZ thepoint;


};





// other Inline functions and methods (like "C++: function call" methods)


#endif
