'use strict';
var path = require('path');
module.exports = {
  mode: 'development',
  target: 'node',
  resolve: {
    modules: ['/usr/lib/nodejs', '.'],
  },
  resolveLoader: {
    modules: ['/usr/lib/nodejs'],
  },
  output: {
    libraryTarget: 'umd'
  },
  module: { rules: [ {test: /\.js$/, loader: 'babel-loader', options: { presets: [ 'es2015' ], plugins: ['add-module-exports'] } }] },
  externals: {
    'd3-array': {
      commonjs: 'd3-array',
      commonjs2: 'd3-array',
      amd: 'd3-array',
      root: '_'
    },
    'd3-collection': {
      commonjs: 'd3-collection',
      commonjs2: 'd3-collection',
      amd: 'd3-collection',
      root: '_'
    },
    'd3-color': {
      commonjs: 'd3-color',
      commonjs2: 'd3-color',
      amd: 'd3-color',
      root: '_'
    },
    'd3-format': {
      commonjs: 'd3-format',
      commonjs2: 'd3-format',
      amd: 'd3-format',
      root: '_'
    },
    'd3-interpolate': {
      commonjs: 'd3-interpolate',
      commonjs2: 'd3-interpolate',
      amd: 'd3-interpolate',
      root: '_'
    },
    'd3-time': {
      commonjs: 'd3-time',
      commonjs2: 'd3-time',
      amd: 'd3-time',
      root: '_'
    },
    'd3-time-format': {
      commonjs: 'd3-time-format',
      commonjs2: 'd3-time-format',
      amd: 'd3-time-format',
      root: '_'
    }
  }
};
