
Neovim client library and GUI, in Qt5.

[![Build Status](https://circleci.com/gh/equalsraf/neovim-qt.svg?style=svg)](https://circleci.com/gh/equalsraf/neovim-qt)
[![Build status](https://ci.appveyor.com/api/projects/status/c252f54mfjcuud8x/branch/master?svg=true)](https://ci.appveyor.com/project/equalsraf/neovim-qt/branch/master)
[![Build Status](https://travis-ci.org/equalsraf/neovim-qt.svg?branch=master)](https://travis-ci.org/equalsraf/neovim-qt)
[![Coverage Status](https://coveralls.io/repos/equalsraf/neovim-qt/badge.svg?branch=tb-refactor)](https://coveralls.io/r/equalsraf/neovim-qt)
[![Downloads](https://img.shields.io/github/downloads/equalsraf/neovim-qt/total.svg?maxAge=2592000)](https://github.com/equalsraf/neovim-qt/releases)

## Requirements

* Qt5
* Neovim

## Building

You can build using CMake and your build system of choice. It should build in any
system where Qt5 and Msgpack can build.

For Unix call

    $ mkdir build
    $ cd build
    $ cmake -DCMAKE_BUILD_TYPE=Release ..
    $ make

for Windows both MSVC and Mingw are supported. Use the following

    $ mkdir build
    $ cd build
    $ cmake -DCMAKE_BUILD_TYPE=Release ..
    $ cmake --build .

For MSVC build you may have to specify the VS version and build type. Always make sure the VS versions matches your Qt libraries.

	$ mkdir build
	$ cd build
	$ cmake -G "Visual Studio 14" -DCMAKE_BUILD_TYPE=Release ..
	$ cmake --build . --config Release --target install

The binaries will be under build/bin/. The GUI binary is called nvim-qt. Run make install to install it, or execute from the source setting the environment variable NVIM_QT_RUNTIME as the path holding the GUI shim plugin

	$ NVIM_QT_RUNTIME_PATH=../src/gui/runtime bin/nvim-qt

See the [wiki](https://github.com/equalsraf/neovim-qt/wiki/Build) for detailed build instructions.

## Using the GUI

Run **nvim-qt**, the **nvim** binary must be in your $PATH. Check `nvim-qt --help` for additional options.

Commands for interacting with the GUI are regular commands, available in the documentation [:help nvim-gui-shim](./src/gui/runtime/doc/nvim_gui_shim.txt). For example to change the font call

	:Guifont DejaVu Sans Mono:h13

To disable the GUI tabline and use the nvim TUI tabline, call

	:GuiTabline 0

You can set GUI options on startup, in the GUI configuration file (:help ginit.vim).

In recent versions of Neovim you can also use regular options (in init.vim) that have the same effect:

- set guifont=DejaVu\ Sans\ Mono:h11
- set linespace=4

## Development

The *NeovimConnector* class is used to setup the connection to Neovim. It also
provides you with low level methods for RPC - in general you should be using
the signals/slots in the QObject returned by NeovimConnector::neovimObject()

1. To call a function call the corresponding slot
2. The result of the call is delivered by the corresponding signal,
   by convention these signals are named 'on\_' + slot\_name
3. The Neovim() class is automagically generated from the Neovim
   metadata
5. For Neovim functions that take the **Object** type we use **QVariant**
6. To catch Neovim Notifications connect to the Neovim::neovimNotification
   signal

### To Update the RPC bindings

Part of the code is auto-generated by calling Neovim to get the API metadata,
and generating C++ code. This is done using a python script
(generate\_bindings.py) if you just want to use neovim-qt as is you don't need
to worry about this, I already include the generated code in the repository.

The bindings source templates are stored under the bindings/ folder the 
generated code is in src/auto/.

To generate the bindings yourself you need

- python
- python-msgpack
- jinja2

Just run `make bindings` in Unix or the equivalent build command in Windows.

