program genoverlayusa

	implicit none

	include 'netcdf.inc'

	integer			:: ncid, err, dimid_segment, nsegs, varid_segment_directory, &
				   varid_verts, naspects, dimid_verts, nverts, i
	character*1000		:: mapfile
	real, allocatable 	:: verts(:)
	integer*4, allocatable 	:: dir(:,:)

	mapfile = '/home/pierce/lib/coastlines_and_geography/OUTLUSAM.nc'

	!--------------
	! Open map file
	!--------------
	err = nf_open(mapfile,0,ncid)
	if( err /= 0 ) then
		write(0,*) 'Error opening file ', trim(mapfile)
		call exit(-1)
	endif

	!--------------
	! Get file info
	!--------------
	err = nf_inq_dimid( ncid, 'segment', dimid_segment )
	if( err /= 0 ) then
		write(0,*) 'Error trying to find dim segment in file', trim(mapfile)
		call exit(-1)
	endif

	err = nf_inq_varid( ncid, 'segment_directory', varid_segment_directory )
	if( err /= 0 ) then
		write(0,*) 'Error trying to find var segment_directory in file', trim(mapfile)
		call exit(-1)
	endif

	err = nf_inq_dimid( ncid, 'verts', dimid_verts )
	if( err /= 0 ) then
		write(0,*) 'Error trying to find dim verts in file', trim(mapfile)
		call exit(-1)
	endif

	err = nf_inq_varid( ncid, 'verts', varid_verts )
	if( err /= 0 ) then
		write(0,*) 'Error trying to find var segment_directory in file', trim(mapfile)
		call exit(-1)
	endif

	err = nf_inq_dimlen( ncid, dimid_segment, nsegs  )
	err = nf_inq_dimlen( ncid, dimid_verts,   nverts )
	write(0,*) 'nsegs=', nsegs, ' nverts=', nverts

	naspects = 6

	!----------------------
	! Get segment directory
	!----------------------
	allocate(dir(naspects,nsegs))
	err = nf_get_var_int( ncid, varid_segment_directory, dir )
	if( err /= 0 ) then
		write(0,*) 'Error trying to read varid_segment_directory'
		call exit(-1)
	endif

	!----------
	! Get verts
	!----------
	allocate(verts(nverts))
	err = nf_get_var_real( ncid, varid_verts, verts )
	if( err /= 0 ) then
		write(0,*) 'Error trying to read varid_verts'
		call exit(-1)
	endif

	do i=1, nverts, 2
		print *, verts(i+1), verts(i)
		print *, verts(i+1)-360, verts(i)
	enddo

end program genoverlayusa


