/* $Id: Field_type.cpp 436427 2014-05-28 13:24:42Z chenj $
 * ===========================================================================
 *
 *                            PUBLIC DOMAIN NOTICE
 *               National Center for Biotechnology Information
 *
 *  This software/database is a "United States Government Work" under the
 *  terms of the United States Copyright Act.  It was written as part of
 *  the author's official duties as a United States Government employee and
 *  thus cannot be copyrighted.  This software/database is freely available
 *  to the public for use. The National Library of Medicine and the U.S.
 *  Government have not placed any restriction on its use or reproduction.
 *
 *  Although all reasonable efforts have been taken to ensure the accuracy
 *  and reliability of the software and data, the NLM and the U.S.
 *  Government do not and cannot warrant the performance or results that
 *  may be obtained by using this software or data. The NLM and the U.S.
 *  Government disclaim all warranties, express or implied, including
 *  warranties of performance, merchantability or fitness for any particular
 *  purpose.
 *
 *  Please cite the author in any work or product based on this material.
 *
 * ===========================================================================
 *
 * Author:  J. Chen
 *
 * File Description:
 *   if a feat matches to CField_type
 *
 * Remark:
 *   This code was originally generated by application DATATOOL
 *   using the following specifications:
 *   'macro.asn'.
 */

// standard includes
#include <ncbi_pch.hpp>

// generated includes
#include <objects/macro/Field_type.hpp>

// generated classes

BEGIN_NCBI_SCOPE

BEGIN_objects_SCOPE // namespace ncbi::objects::

// destructor
CField_type::~CField_type(void)
{
}

struct s_cgp2feattype_featqual {
  ECDSGeneProt_field cdsgp;
  EMacro_feature_type feat_type;
  EFeat_qual_legal legal_qual;
} Cgp2FeatType_FeatQual;

static const s_cgp2feattype_featqual cgp_ftype_fqual[] = {
 { eCDSGeneProt_field_cds_comment, eMacro_feature_type_cds, eFeat_qual_legal_note},
 { eCDSGeneProt_field_cds_inference, eMacro_feature_type_cds, eFeat_qual_legal_inference},
 { eCDSGeneProt_field_codon_start, eMacro_feature_type_cds, eFeat_qual_legal_codon_start},
 { eCDSGeneProt_field_gene_locus, eMacro_feature_type_gene, eFeat_qual_legal_gene},
 { eCDSGeneProt_field_gene_description, eMacro_feature_type_gene, eFeat_qual_legal_gene_description},
 { eCDSGeneProt_field_gene_comment, eMacro_feature_type_gene, eFeat_qual_legal_note},
 { eCDSGeneProt_field_gene_allele, eMacro_feature_type_gene, eFeat_qual_legal_allele},
 { eCDSGeneProt_field_gene_maploc, eMacro_feature_type_gene, eFeat_qual_legal_map},
 { eCDSGeneProt_field_gene_locus_tag, eMacro_feature_type_gene, eFeat_qual_legal_locus_tag},
 { eCDSGeneProt_field_gene_locus_tag, eMacro_feature_type_gene, eFeat_qual_legal_locus_tag},
 { eCDSGeneProt_field_gene_synonym, eMacro_feature_type_gene, eFeat_qual_legal_synonym},
 { eCDSGeneProt_field_gene_old_locus_tag, eMacro_feature_type_gene, eFeat_qual_legal_old_locus_tag},
 { eCDSGeneProt_field_gene_inference, eMacro_feature_type_gene, eFeat_qual_legal_inference},
 { eCDSGeneProt_field_mrna_product, eMacro_feature_type_mRNA, eFeat_qual_legal_product},
 { eCDSGeneProt_field_mrna_comment, eMacro_feature_type_mRNA, eFeat_qual_legal_note},
 { eCDSGeneProt_field_prot_name, eMacro_feature_type_prot, eFeat_qual_legal_product},
 { eCDSGeneProt_field_prot_description, eMacro_feature_type_prot, eFeat_qual_legal_description},
 { eCDSGeneProt_field_prot_ec_number, eMacro_feature_type_prot, eFeat_qual_legal_ec_number},
 { eCDSGeneProt_field_prot_activity, eMacro_feature_type_prot, eFeat_qual_legal_activity},
 { eCDSGeneProt_field_prot_comment, eMacro_feature_type_prot, eFeat_qual_legal_note},
 { eCDSGeneProt_field_mat_peptide_name, eMacro_feature_type_mat_peptide_aa, eFeat_qual_legal_product},
 { eCDSGeneProt_field_mat_peptide_description, eMacro_feature_type_mat_peptide_aa, eFeat_qual_legal_description},
 { eCDSGeneProt_field_mat_peptide_ec_number, eMacro_feature_type_mat_peptide_aa,eFeat_qual_legal_ec_number},
 { eCDSGeneProt_field_mat_peptide_activity, eMacro_feature_type_mat_peptide_aa, eFeat_qual_legal_activity},
 { eCDSGeneProt_field_mat_peptide_comment, eMacro_feature_type_mat_peptide_aa, eFeat_qual_legal_note}
};

CRef <CFeature_field> CField_type :: FeatureFieldFromCDSGeneProtField (ECDSGeneProt_field cgp_field)
{
   CRef <CFeature_field> feat_field(new CFeature_field);
   CRef <CFeat_qual_choice> f_qual;
   for (unsigned i=0; i< ArraySize(cgp_ftype_fqual); i++) {
     if (cgp_field == cgp_ftype_fqual[i].cdsgp) {
        feat_field->SetType(cgp_ftype_fqual[i].feat_type);
        f_qual->SetLegal_qual(cgp_ftype_fqual[i].legal_qual);
        feat_field->SetField(*f_qual);
        return feat_field;
     } 
   }
   return (CRef <CFeature_field> (0));
};

static const string dblink_name[] = {
   "Trace Assembly Archive",
   "BioSample",
   "ProbeDB",
   "Sequence Read Archive",
   "BioProject",
   "Assembly"
};

string CField_type :: GetDBLinkFieldFromUserObject(const CUser_object& user_obj, EDBLink_field_type dblink_tp, const CString_constraint& str_cons)
{
  string str(kEmptyStr);
  if (user_obj.GetType().IsStr() && user_obj.GetType().GetStr() == "DBLink") {
    string field_name = dblink_name[(int)dblink_tp];
    ITERATE (vector <CRef <CUser_field> >, it, user_obj.GetData()) {
       if ( (*it)->GetLabel().IsStr() 
                && ((*it)->GetLabel().GetStr() == field_name) ) {
          if ( (*it)->GetData().IsStrs()) {
             ITERATE (vector <CStringUTF8>, sit, (*it)->GetData().GetStrs()) {
                str = CUtf8::AsSingleByteString(*sit, eEncoding_Ascii);
                if (str_cons.Empty() || str_cons.Match(str)) {
                   break;
                }
                else str = kEmptyStr;
             }
          }
          else if ( (*it)->GetData().IsInts() ) {
             ITERATE (vector <int>, iit, (*it)->GetData().GetInts()) {
                str = NStr::IntToString(*iit);
                if (str_cons.Empty() || str_cons.Match(str)) {
                   break;
                }
                else str = kEmptyStr;
             }
          }
          if (!str.empty()) {
             break;
          }
       }
    }
  }
  return str;
};

END_objects_SCOPE // namespace ncbi::objects::

END_NCBI_SCOPE

/* Original file checksum: lines: 57, chars: 1723, CRC32: cfffbaf9 */
