from distutils.core import setup, Extension
from distutils.sysconfig import *
from distutils.util import *
import os
import numpy

data_files = []

# Include gsl dlls for the win32 distribution
if get_platform() == "win32":
    dlls = ["mlpy\gslwin\libgsl-0.dll", "mlpy\gslwin\libgslcblas-0.dll"]
    data_files += [("Lib\site-packages\mlpy", dlls)]

## Python include
py_include = get_python_inc()

## Numpy header files
numpy_lib = os.path.split(numpy.__file__)[0]
numpy_include = os.path.join(numpy_lib, 'core/include')

## Numpy Support include
numpysupport_include = 'mlpy/numpysupport'

## Extra compile args
extra_compile_args = ['-Wno-strict-prototypes']

##### Includes #####

base_include  = [py_include, numpy_include]

## Svmcore include
svmcore_include = base_include + [numpysupport_include, 'mlpy/svmcore/include']

## Nncore include
nncore_include = base_include + [numpysupport_include, 'mlpy/nncore/include']

## Canberracore include
canberracore_include = base_include + [numpysupport_include]

####################

##### Sources ######

## Svmcore sources
svmcore_sources = ['mlpy/svmcore/src/alloc.c', 'mlpy/svmcore/src/sort.c',
                   'mlpy/svmcore/src/sampling.c', 'mlpy/svmcore/src/unique.c',
                   'mlpy/svmcore/src/dist.c', 'mlpy/svmcore/src/svm.c',
                   'mlpy/svmcore/src/matrix.c', 'mlpy/svmcore/src/rsfn.c',
                   'mlpy/svmcore/src/rnd.c', 'mlpy/svmcore/svmcore.c',
                   'mlpy/numpysupport/numpysupport.c']

## Nncore sources
nncore_sources = ['mlpy/nncore/src/alloc.c', 'mlpy/nncore/src/sort.c',
                  'mlpy/nncore/src/unique.c', 'mlpy/nncore/src/dist.c',
                  'mlpy/nncore/src/nn.c', 'mlpy/nncore/nncore.c',
                  'mlpy/numpysupport/numpysupport.c']

## Canberracore sources
canberracore_sources = ['mlpy/canberracore/canberracore.c',
                        'mlpy/numpysupport/numpysupport.c']

####################


# Setup
setup(name = 'MLPY',
      version = '2.2.0',
      requires = ['numpy (>= 1.1.0)', 'gsl (>= 1.8)'],
      description = 'mlpy - Machine Learning Py - high-performance Python package for predictive modeling',
      author = 'mlpy Developers - FBK-MPBA',
      author_email = 'albanese@fbk.eu',
      url = 'https://mlpy.fbk.eu',
      download_url = 'https://mlpy.fbk.eu/wiki/MlpyDownloads',
      license='GPLv3',
      classifiers=['Development Status :: 5 - Production/Stable',
                   'Intended Audience :: Science/Research',
                   'Intended Audience :: Developers',
                   'License :: OSI Approved :: GNU General Public License (GPL)',
                   'Natural Language :: English',
                   'Operating System :: POSIX :: Linux',
                   'Operating System :: POSIX :: BSD',
                   'Operating System :: Unix',
                   'Operating System :: MacOS :: MacOS X',
                   'Operating System :: Microsoft :: Windows',
                   'Programming Language :: C',
                   'Programming Language :: Python',
                   'Topic :: Scientific/Engineering :: Artificial Intelligence',
                   ],
      packages=['mlpy'],
      ext_modules=[Extension('mlpy.svmcore', svmcore_sources,
                             include_dirs=svmcore_include,
                             extra_compile_args=extra_compile_args),
                   Extension('mlpy.nncore', nncore_sources,
                             include_dirs=nncore_include,
                             extra_compile_args=extra_compile_args),
                   Extension('mlpy.canberracore', canberracore_sources,
                             include_dirs=canberracore_include,
                             extra_compile_args=extra_compile_args),
                   Extension('mlpy.hccore', ['mlpy/hccore/hccore.c'],
                             include_dirs=base_include,
                             extra_compile_args=extra_compile_args),
                   Extension('mlpy.dwtcore', ['mlpy/dwtcore/dwt.c'],
                             include_dirs=base_include,
                             extra_compile_args=extra_compile_args,
                             libraries=['gsl', 'gslcblas', 'm']),
                   Extension('mlpy.uwtcore', ['mlpy/uwtcore/uwt.c'],
                             include_dirs=base_include,
                             extra_compile_args=extra_compile_args,
                             libraries=['gsl', 'gslcblas', 'm']),
                   Extension('mlpy.gslpy', ['mlpy/gslpy.c'],
                             include_dirs=base_include,
                             extra_compile_args=extra_compile_args,
                             libraries=['gsl', 'gslcblas', 'm']),
                   Extension('mlpy.cwb', ['mlpy/cwt/cwb.c'],
                             include_dirs=base_include,
                             extra_compile_args=extra_compile_args,
                             libraries=['gsl', 'gslcblas', 'm']),
                   Extension('mlpy.peaksd', ['mlpy/peaksd.c'],
                             include_dirs=base_include,
                             extra_compile_args=extra_compile_args),
                   Extension('mlpy.misc', ['mlpy/misc.c'],
                             include_dirs=base_include,
                             extra_compile_args=extra_compile_args),
                   Extension('mlpy.dtwcore', ['mlpy/dtwcore/dtwcore.c'],
                             include_dirs=base_include,
                             extra_compile_args=extra_compile_args),
                   Extension('mlpy.kmeanscore', ['mlpy/kmeanscore/kmeanscore.c'],
                             include_dirs=base_include,
                             extra_compile_args=extra_compile_args,
                             libraries=['gsl', 'gslcblas', 'm']),
                   Extension('mlpy.kernel', ['mlpy/kernel/kernel.c'],
                             include_dirs=base_include,
                             extra_compile_args=extra_compile_args,
                             libraries=['m']),
                   Extension('mlpy.spectralreg', ['mlpy/spectralreg/spectralreg.c'],
                             include_dirs=base_include,
                             extra_compile_args=extra_compile_args),
                   ],
      scripts=['mlpy/tools/irelief-sigma', 'mlpy/tools/srda-landscape',
               'mlpy/tools/svm-landscape', 'mlpy/tools/fda-landscape',
               'mlpy/tools/knn-landscape', 'mlpy/tools/pda-landscape',
               'mlpy/tools/dlda-landscape', 'mlpy/tools/borda',
               'mlpy/tools/canberra', 'mlpy/tools/canberraq'],
      data_files = data_files
      )
