C **************************** LICENSE START ***********************************
C
C Copyright 2012 ECMWF and INPE. This software is distributed under the terms
C of the Apache License version 2.0. In applying this license, ECMWF does not
C waive the privileges and immunities granted to it by virtue of its status as
C an Intergovernmental Organization or submit itself to any jurisdiction.
C
C ***************************** LICENSE END ************************************

      SUBROUTINE SPECGRAPH (MTRUNCS,ILEV,ILVL,A,LNOCYC,NTMIN,
     +                      NTLIM,IERROR)
C
C     F. II             ECMWF           AUG-96
C     SEND SPECTRA (GRAPH MODE) TO MAIN APPLICATION
C
C     INPUT :
C       MTRUNCS         : TRUNCATE OUTPUT VALUE
C       ILEV            : NUMBER OF CURVES TO BE PLOTTED
C       ILVL            : STEPS VALUES
C       A               : ARRAY OF DATA
C       LNOCYC          : T - SUBTRACTS OUT THE DIURNAL CYCLE
C       NTMIN           : X-AXIS MIN VALUE
C       NTLIM           : X-AXIS MAX VALUE
C
C     OUTPUT :
C     IERROR             : 0 - NO ERROR,  1 - ERROR
C

      IMPLICIT NONE

#include <grbsh.hf>

      integer cputenv

      REAL            A(JLEV*JMTRUNC)
      INTEGER         MTRUNCS,ILEV,ILVL(JLEV),NTMIN,NTLIM,IERROR
      LOGICAL         LNOCYC

      INTEGER         ITRUNC          !MTRUNCS+1
      INTEGER         ITLIM           !MINIMUM VALUE(NTLIM,MTRUNCS)
      INTEGER         ILVLN(JLEV)     !ILVL SUBSET
      INTEGER         ILEVN           !NEW ILEV VALUE
      INTEGER         II,JJ,III,JJJ   !AUXILIARIES VARIABLES
      REAL            YMIN,YMAX	!AXIS MIN/MAX VALUES
      REAL            RAUX		!AUXILIARY VARIABLE
C
C               1.0 INITIALIZE DATA
C
      IERROR = 0
      ITRUNC = MTRUNCS + 1
      IF (ILEV.GT.JLEV .OR. ITRUNC.GT.JMTRUNC) THEN
         WRITE(*,'(4X,''ARRAYS TOO SMALL; ILEV,MTRUNCS = '',
     +           I4,1X,I4)')ILEV,MTRUNCS
         JJ=cputenv('SPECTRA_ENV=MEMORY ERROR - SUBROUTINE SPECGRAPH')
         IERROR = 1
         RETURN
      ENDIF

      IF (LNOCYC) THEN                !SUBTRACT OUT THE DAILY CYCLE
         ILEVN = 0
         II = 0
         DO 10 JJ=1,ILEV
            IF(MOD(ILVL(JJ),12).NE.0) GOTO 10
            IF(MOD(ILVL(JJ),24).EQ.0) THEN
               III=1
            ELSE
               III=2
            ENDIF
            ILEVN = ILEVN + 1
            ILVLN(ILEVN) = ILVL(JJ)
            DO 12 JJJ=1,ITRUNC
               II  =  II + 1
               A(II) = A(ITRUNC*(JJ  -1)+JJJ) -
     @                 A(ITRUNC*(ILEV-III)+JJJ)
 12         CONTINUE
 10      CONTINUE
      ELSE
         ILEVN = ILEV
         DO 14 JJ=1,ILEV
            ILVLN(JJ) = ILVL(JJ)
 14      CONTINUE
      ENDIF
C
C               2.0 FIND OUT THE MIN/MAX VALUES FOR VERTICAL AXIS
C
      ITLIM = MIN0(NTLIM,ITRUNC-1)
      YMAX = -1.E20
      YMIN =  1.E20
      DO 50 JJ=1,ILEVN
         DO 55 II=NTMIN,ITLIM
            YMAX = MAX(YMAX,A(ITRUNC*(JJ-1)+II+1))
            YMIN = MIN(YMIN,A(ITRUNC*(JJ-1)+II+1))
 55      CONTINUE
 50   CONTINUE
      RAUX = (YMAX-YMIN)/10.
      YMAX = YMAX+RAUX
      YMIN = YMIN-RAUX

      CALL MFI_RETURN_NUMBER(YMIN)         ! SEND VERTICAL AXIS LIMITS
      CALL MFI_RETURN_NUMBER(YMAX)
      CALL MFI_RETURN_NUMBER(REAL(ILEVN))  ! SEND NUMBER OF CURVERS
C
C               3.0 LOOP OVER CURVES
C
      DO 70 III=1,ILEVN

         CALL MFI_RETURN_NUMBER(REAL(ILVLN(III)))  ! SEND INITIAL STEP

C        DEFINE X/Y VALUES

C        II = 0
         CALL MFI_RETURN_NUMBER(REAL(ITLIM-NTMIN+1))  ! SEND NUMBER OF SPECTRA VALUES
         DO 72 JJ=NTMIN,ITLIM
C           II = II + 1
C           B(II) = A(ITRUNC*(IN-1) + JJ + 1)
C           XARAY(II) = REAL(JJ)
            CALL MFI_RETURN_NUMBER(A(ITRUNC*(III-1) + JJ + 1))  ! SEND SPECTRA VALUES
            CALL MFI_RETURN_NUMBER(REAL(JJ))
 72      CONTINUE
 70   CONTINUE

      RETURN
      END
