/***************************** LICENSE START ***********************************

 Copyright 2012 ECMWF and INPE. This software is distributed under the terms
 of the Apache License version 2.0. In applying this license, ECMWF does not
 waive the privileges and immunities granted to it by virtue of its status as
 an Intergovernmental Organization or submit itself to any jurisdiction.

 ***************************** LICENSE END *************************************/

#ifndef MvQMarsCatalog_H
#define MvQMarsCatalog_H

#include <QObject>
#include <QProcess>

#include "json_spirit.h"

class MvQMarsCatalogNode
{
public:
    MvQMarsCatalogNode(QString name) :
        name_(name),
        axis_(false){};

    QString name() { return name_; }
    QStringList items() { return items_; }
    QString selection() { return selection_; }
    void setItems(QStringList);
    void setSelection(QString);
    bool isSelectionValid();
    int selectionIndex() { return items_.indexOf(selection_); }
    void setAxis(bool b) { axis_ = b; }
    bool isAxis() { return axis_; }

protected:
    QString name_;
    QStringList items_;
    QString selection_;
    bool axis_;
};


class MvQMarsCatalogData
{
public:
    MvQMarsCatalogData();
    ~MvQMarsCatalogData();

    void init();
    void setSelection(QString node, QString value);
    MvQMarsCatalogNode* node(QString);
    void clear();
    void update(QString);
    QString catalogPathToJason();
    QString catalogPathToRequest();
    QString catalogPathToMacro();
    QList<MvQMarsCatalogNode*> data() { return data_; }

protected:
    void decodeJson_tree(const json_spirit::Array&);
    void decodeJson_axis(const json_spirit::Object&);
    void decodeJson_choices(const json_spirit::Object&);

    QList<MvQMarsCatalogNode*> data_;
};


class MvQMarsCatalog : public QObject
{
    Q_OBJECT

public:
    MvQMarsCatalog();
    void fetch(MvQMarsCatalogData*);
    bool isFetchRunning()
    {
        if (proc_ && proc_->state() != QProcess::NotRunning)
            return true;
        else
            return false;
    }

public slots:
    void slotFetchFinished(int, QProcess::ExitStatus);
    void slotFetchError(QProcess::ProcessError);
    void slotready();

signals:
    void fetchFinished(QString, bool);
    void logUpdated();
    void statusMessage(QString);

protected:
    QString procCommand_;
    QString procScript_;
    QProcess* proc_;
    QString apiPath_;
};

#endif