/***************************** LICENSE START ***********************************

 Copyright 2012 ECMWF and INPE. This software is distributed under the terms
 of the Apache License version 2.0. In applying this license, ECMWF does not
 waive the privileges and immunities granted to it by virtue of its status as
 an Intergovernmental Organization or submit itself to any jurisdiction.

 ***************************** LICENSE END *************************************/

#include <QHBoxLayout>
#include <QLabel>
#include <QLineEdit>
#include <QPushButton>

#include "MvQAbstractSearchLine.h"

MvQAbstractSearchLine::MvQAbstractSearchLine(QString searchLabelText,QWidget* parent) : QWidget(parent)
{
	layout_= new QHBoxLayout;
	layout_->setContentsMargins(0,0,0,0);
  	setLayout(layout_);
	
  	label_ = new QLabel(tr("&Find"));
	
	searchLine_= new QLineEdit;
	searchLine_->setMinimumWidth(200);

	label_->setBuddy(searchLine_);
	
	nextPb_ = new QPushButton(tr("&Next"));
	nextPb_->setIcon(QIcon(QPixmap(QString::fromUtf8(":/find/next.svg"))));

	prevPb_= new QPushButton(tr("&Previous"));
	prevPb_->setIcon(QIcon(QPixmap(QString::fromUtf8(":/find/prev.svg"))));	

	layout_->addWidget(label_);	
	layout_->addWidget(searchLine_);
	layout_->addWidget(nextPb_);
	layout_->addWidget(prevPb_);
	layout_->addStretch(1);

	connect(searchLine_, SIGNAL( textChanged(QString)), 
		this, SLOT(slotFind(QString)));

	connect(searchLine_, SIGNAL( returnPressed()), 
		this, SLOT(slotFindNext()));

	connect(nextPb_, SIGNAL(clicked()), 
		this, SLOT(slotFindNext()));

	connect(prevPb_, SIGNAL(clicked()), 
		this, SLOT(slotFindPrev()));


	oriColour_=QColor(searchLine_->palette().color(QPalette::Base));
	redColour_=QColor(255,102,102);
	greenColour_=QColor(186,249,206);
	
	status_=true;
}

MvQAbstractSearchLine::~MvQAbstractSearchLine()
{
	clear();
}

void MvQAbstractSearchLine::clear()
{
	searchLine_->clear();	
}
	
void MvQAbstractSearchLine::updateButtons(bool found)
{
	status_=found;

	if(searchLine_->text().isEmpty())
	{
	  	QPalette p=searchLine_->palette();
		p.setColor(QPalette::Base,oriColour_);
		searchLine_->setPalette(p);
	}	
	else
	{
		if(!found)	
		{
			QPalette p=searchLine_->palette();
			p.setColor(QPalette::Base,redColour_);
			searchLine_->setPalette(p);
		}
		else 
		{
			QPalette p=searchLine_->palette();
			p.setColor(QPalette::Base,greenColour_);
			searchLine_->setPalette(p);
		}
	}	
}
