# Automatically generated code: EDIT AT YOUR OWN RISK
from traits import api as traits
from traitsui.item import Item, spring
from traitsui.group import HGroup
from traitsui.view import View

from tvtk import vtk_module as vtk
from tvtk import tvtk_base
from tvtk.tvtk_base_handler import TVTKBaseHandler
from tvtk import messenger
from tvtk.tvtk_base import deref_vtk
from tvtk import array_handler
from tvtk.array_handler import deref_array
from tvtk.tvtk_classes.tvtk_helper import wrap_vtk

nan = float('nan')


def InstanceEditor(*args, **kw):
    from traitsui.editors.api import InstanceEditor as Editor
    return Editor(view_name="handler.view")

try:
    long
except NameError:
    # Silly workaround for Python3.
    long = int

inf = float('inf')

from tvtk.tvtk_classes.interactor_style3d import InteractorStyle3D


class VRInteractorStyle(InteractorStyle3D):
    r"""
    VRInteractorStyle - Extended from InteractorStyle3D to override
    command methods.
    
    Superclass: InteractorStyle3D
    
    This abstract class defines an interactor style in a virtual reality
    context.
    
    """
    def __init__(self, obj=None, update=True, **traits):
        tvtk_base.TVTKBase.__init__(self, vtk.vtkVRInteractorStyle, obj, update, **traits)
    
    grab_with_ray = tvtk_base.false_bool_trait(desc=\
        r"""
        Specify if the grab mode uses the ray to grab distant objects.
        Default is set to on.
        """
    )

    def _grab_with_ray_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetGrabWithRay,
                        self.grab_with_ray_)

    hover_pick = tvtk_base.false_bool_trait(desc=\
        r"""
        Indicates if picking should be updated every frame. If so, the
        interaction picker will try to pick a prop and rays will be
        updated accordingly. Default is set to off.
        """
    )

    def _hover_pick_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetHoverPick,
                        self.hover_pick_)

    def _get_interactor(self):
        return wrap_vtk(self._vtk_obj.GetInteractor())
    def _set_interactor(self, arg):
        old_val = self._get_interactor()
        self._wrap_call(self._vtk_obj.SetInteractor,
                        deref_vtk(arg))
        self.trait_property_changed('interactor', old_val, arg)
    interactor = traits.Property(_get_interactor, _set_interactor, desc=\
        r"""
        
        """
    )

    def _get_style(self):
        return self._vtk_obj.GetStyle()
    def _set_style(self, arg):
        old_val = self._get_style()
        self._wrap_call(self._vtk_obj.SetStyle,
                        arg)
        self.trait_property_changed('style', old_val, arg)
    style = traits.Property(_get_style, _set_style, desc=\
        r"""
        
        """
    )

    def get_interaction_state(self, *args):
        """
        get_interaction_state(self, device:EventDataDevice) -> int
        C++: int get_interaction_state(EventDataDevice device)
        Return interaction state for the specified device (dolly, pick,
        none, etc...).
        """
        my_args = [deref_vtk(x) for x in args]
        ret = self._wrap_call(self._vtk_obj.GetInteractionState, *my_args)
        return ret

    def _get_menu(self):
        return wrap_vtk(self._vtk_obj.GetMenu())
    menu = traits.Property(_get_menu, desc=\
        r"""
        Return the menu to allow the user to add options to it.
        """
    )

    def add_tooltip_for_input(self, *args):
        """
        add_tooltip_for_input(self, device:EventDataDevice,
            input:EventDataDeviceInput, text:str=...) -> None
        C++: void add_tooltip_for_input(EventDataDevice device,
            EventDataDeviceInput input, const std::string &text="")
        Define the helper text that goes with an input.
        """
        my_args = [deref_vtk(x) for x in args]
        ret = self._wrap_call(self._vtk_obj.AddTooltipForInput, *my_args)
        return ret

    def clip(self, *args):
        """
        clip(self, __a:EventDataDevice3D) -> None
        C++: void clip(EventDataDevice3D *)"""
        my_args = [deref_vtk(x) for x in args]
        ret = self._wrap_call(self._vtk_obj.Clip, *my_args)
        return ret

    def elevation3d(self, *args):
        """
        elevation3d(self, __a:EventDataDevice3D) -> None
        C++: void elevation3d(EventDataDevice3D *)
        Move the camera following the "Z" axis (elevation) using the
        thumbstick/trackpad position (up/down).
        """
        my_args = [deref_vtk(x) for x in args]
        ret = self._wrap_call(self._vtk_obj.Elevation3D, *my_args)
        return ret

    def end_clip(self, *args):
        """
        end_clip(self, __a:EventDataDevice3D) -> None
        C++: void end_clip(EventDataDevice3D *)"""
        my_args = [deref_vtk(x) for x in args]
        ret = self._wrap_call(self._vtk_obj.EndClip, *my_args)
        return ret

    def end_load_cam_pose(self, *args):
        """
        end_load_cam_pose(self, __a:EventDataDevice3D) -> None
        C++: void end_load_cam_pose(EventDataDevice3D *)"""
        my_args = [deref_vtk(x) for x in args]
        ret = self._wrap_call(self._vtk_obj.EndLoadCamPose, *my_args)
        return ret

    def end_movement3d(self, *args):
        """
        end_movement3d(self, __a:EventDataDevice3D) -> None
        C++: void end_movement3d(EventDataDevice3D *)"""
        my_args = [deref_vtk(x) for x in args]
        ret = self._wrap_call(self._vtk_obj.EndMovement3D, *my_args)
        return ret

    def end_pick(self, *args):
        """
        end_pick(self, __a:EventDataDevice3D) -> None
        C++: void end_pick(EventDataDevice3D *)"""
        my_args = [deref_vtk(x) for x in args]
        ret = self._wrap_call(self._vtk_obj.EndPick, *my_args)
        return ret

    def end_position_prop(self, *args):
        """
        end_position_prop(self, __a:EventDataDevice3D) -> None
        C++: void end_position_prop(EventDataDevice3D *)"""
        my_args = [deref_vtk(x) for x in args]
        ret = self._wrap_call(self._vtk_obj.EndPositionProp, *my_args)
        return ret

    def ground_movement3d(self, *args):
        """
        ground_movement3d(self, __a:EventDataDevice3D) -> None
        C++: void ground_movement3d(EventDataDevice3D *)
        Move the camera on the "XY" plan (ground) using the
        thumbstick/trackpad position (up/down and left/right), according
        to the headset view direction.
        """
        my_args = [deref_vtk(x) for x in args]
        ret = self._wrap_call(self._vtk_obj.GroundMovement3D, *my_args)
        return ret

    def hide_billboard(self):
        """
        hide_billboard(self) -> None
        C++: void hide_billboard()"""
        ret = self._vtk_obj.HideBillboard()
        return ret
        

    def hide_pick_actor(self):
        """
        hide_pick_actor(self) -> None
        C++: void hide_pick_actor()
        Hide the pick actor (sphere or polydata).
        """
        ret = self._vtk_obj.HidePickActor()
        return ret
        

    def hide_ray(self, *args):
        """
        hide_ray(self, controller:EventDataDevice) -> None
        C++: void hide_ray(EventDataDevice controller)"""
        my_args = [deref_vtk(x) for x in args]
        ret = self._wrap_call(self._vtk_obj.HideRay, *my_args)
        return ret

    def load_next_camera_pose(self):
        """
        load_next_camera_pose(self) -> None
        C++: virtual void load_next_camera_pose()"""
        ret = self._vtk_obj.LoadNextCameraPose()
        return ret
        

    def make_controls_helper(self):
        """
        make_controls_helper(self) -> VRControlsHelper
        C++: virtual VRControlsHelper *make_controls_helper()
        Creates a new controls_helper suitable for use with the child
        class.
        """
        ret = wrap_vtk(self._vtk_obj.MakeControlsHelper())
        return ret
        

    def map_input_to_action(self, *args):
        """
        map_input_to_action(self, eid:Command.EventIds, state:int) -> None
        C++: void map_input_to_action(Command::EventIds eid, int state)
        map_input_to_action(self, eid:Command.EventIds,
            action:EventDataAction, state:int) -> None
        C++: void map_input_to_action(Command::EventIds eid,
            EventDataAction action, int state)
        Map controller inputs to actions. Actions are defined by a
        VTKIS_*STATE*, interaction entry points, and the corresponding
        method for interaction.
        """
        ret = self._wrap_call(self._vtk_obj.MapInputToAction, *args)
        return ret

    def probe_data(self, *args):
        """
        probe_data(self, controller:EventDataDevice) -> None
        C++: void probe_data(EventDataDevice controller)
        Methods for interaction.
        """
        my_args = [deref_vtk(x) for x in args]
        ret = self._wrap_call(self._vtk_obj.ProbeData, *my_args)
        return ret

    def set_draw_controls(self, *args):
        """
        set_draw_controls(self, __a:bool) -> None
        C++: void set_draw_controls(bool)"""
        ret = self._wrap_call(self._vtk_obj.SetDrawControls, *args)
        return ret

    def setup_actions(self, *args):
        """
        setup_actions(self, iren:RenderWindowInteractor) -> None
        C++: virtual void setup_actions(RenderWindowInteractor *iren)
        Setup default actions defined with an action path and a
        corresponding command.
        """
        my_args = [deref_vtk(x) for x in args]
        ret = self._wrap_call(self._vtk_obj.SetupActions, *my_args)
        return ret

    def show_billboard(self, *args):
        """
        show_billboard(self, text:str) -> None
        C++: void show_billboard(const std::string &text)
        Show/hide billboard with given text string.
        """
        ret = self._wrap_call(self._vtk_obj.ShowBillboard, *args)
        return ret

    def show_pick_cell(self, *args):
        """
        show_pick_cell(self, cell:Cell, __b:Prop3D) -> None
        C++: void show_pick_cell(Cell *cell, Prop3D *)
        Make the pick actor a polydata built from the points and edges of
        the given cell, and show it.
        """
        my_args = [deref_vtk(x) for x in args]
        ret = self._wrap_call(self._vtk_obj.ShowPickCell, *my_args)
        return ret

    def show_pick_sphere(self, *args):
        """
        show_pick_sphere(self, pos:[float, ...], radius:float,
            __c:Prop3D) -> None
        C++: void show_pick_sphere(double *pos, double radius, Prop3D *)
        Make the pick actor a sphere of given radius centered at given
        position, and show it.
        """
        my_args = [deref_vtk(x) for x in args]
        ret = self._wrap_call(self._vtk_obj.ShowPickSphere, *my_args)
        return ret

    def show_ray(self, *args):
        """
        show_ray(self, controller:EventDataDevice) -> None
        C++: void show_ray(EventDataDevice controller)
        Show/hide the ray for the specified controller.
        """
        my_args = [deref_vtk(x) for x in args]
        ret = self._wrap_call(self._vtk_obj.ShowRay, *my_args)
        return ret

    def start_clip(self, *args):
        """
        start_clip(self, __a:EventDataDevice3D) -> None
        C++: void start_clip(EventDataDevice3D *)"""
        my_args = [deref_vtk(x) for x in args]
        ret = self._wrap_call(self._vtk_obj.StartClip, *my_args)
        return ret

    def start_load_cam_pose(self, *args):
        """
        start_load_cam_pose(self, __a:EventDataDevice3D) -> None
        C++: void start_load_cam_pose(EventDataDevice3D *)"""
        my_args = [deref_vtk(x) for x in args]
        ret = self._wrap_call(self._vtk_obj.StartLoadCamPose, *my_args)
        return ret

    def start_movement3d(self, *args):
        """
        start_movement3d(self, interactionState:int,
            __b:EventDataDevice3D) -> None
        C++: void start_movement3d(int interactionState,
            EventDataDevice3D *)"""
        my_args = [deref_vtk(x) for x in args]
        ret = self._wrap_call(self._vtk_obj.StartMovement3D, *my_args)
        return ret

    def start_pick(self, *args):
        """
        start_pick(self, __a:EventDataDevice3D) -> None
        C++: void start_pick(EventDataDevice3D *)
        Interaction mode entry points.
        """
        my_args = [deref_vtk(x) for x in args]
        ret = self._wrap_call(self._vtk_obj.StartPick, *my_args)
        return ret

    def start_position_prop(self, *args):
        """
        start_position_prop(self, __a:EventDataDevice3D) -> None
        C++: void start_position_prop(EventDataDevice3D *)"""
        my_args = [deref_vtk(x) for x in args]
        ret = self._wrap_call(self._vtk_obj.StartPositionProp, *my_args)
        return ret

    def toggle_draw_controls(self):
        """
        toggle_draw_controls(self) -> None
        C++: void toggle_draw_controls()
        Control visibility of descriptive tooltips for controller/HMD
        models.
        """
        ret = self._vtk_obj.ToggleDrawControls()
        return ret
        

    _updateable_traits_ = \
    (('grab_with_ray', 'GetGrabWithRay'), ('hover_pick', 'GetHoverPick'),
    ('auto_adjust_camera_clipping_range',
    'GetAutoAdjustCameraClippingRange'), ('handle_observers',
    'GetHandleObservers'), ('use_timers', 'GetUseTimers'), ('enabled',
    'GetEnabled'), ('key_press_activation', 'GetKeyPressActivation'),
    ('picking_managed', 'GetPickingManaged'), ('debug', 'GetDebug'),
    ('global_warning_display', 'GetGlobalWarningDisplay'),
    ('dolly_physical_speed', 'GetDollyPhysicalSpeed'),
    ('mouse_wheel_motion_factor', 'GetMouseWheelMotionFactor'),
    ('pick_color', 'GetPickColor'), ('timer_duration',
    'GetTimerDuration'), ('key_press_activation_value',
    'GetKeyPressActivationValue'), ('priority', 'GetPriority'),
    ('object_name', 'GetObjectName'), ('reference_count',
    'GetReferenceCount'))
    
    _allow_update_failure_ = \
    ()
    
    _full_traitnames_list_ = \
    (['auto_adjust_camera_clipping_range', 'debug', 'enabled',
    'global_warning_display', 'grab_with_ray', 'handle_observers',
    'hover_pick', 'key_press_activation', 'picking_managed', 'use_timers',
    'dolly_physical_speed', 'key_press_activation_value',
    'mouse_wheel_motion_factor', 'object_name', 'pick_color', 'priority',
    'timer_duration'])
    
    def trait_view(self, name=None, view_element=None):
        if view_element is not None or name not in (None, '', 'traits_view', 'full_traits_view', 'view'):
            return super(VRInteractorStyle, self).trait_view(name, view_element)
        if name == 'full_traits_view':
            full_traits_view = \
            View((Item("handler._full_traits_list",show_label=False)),
            title='Edit VRInteractorStyle properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return full_traits_view
        elif name == 'view':
            view = \
            View((['auto_adjust_camera_clipping_range', 'enabled',
            'grab_with_ray', 'handle_observers', 'hover_pick',
            'key_press_activation', 'picking_managed', 'use_timers'], [],
            ['dolly_physical_speed', 'key_press_activation_value',
            'mouse_wheel_motion_factor', 'object_name', 'pick_color', 'priority',
            'timer_duration']),
            title='Edit VRInteractorStyle properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return view
        elif name in (None, 'traits_view'):
            traits_view = \
            View((HGroup(spring, "handler.view_type", show_border=True), 
            Item("handler.info.object", editor = InstanceEditor(view_name="handler.view"), style = "custom", show_label=False)),
            title='Edit VRInteractorStyle properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return traits_view
            

