# Automatically generated code: EDIT AT YOUR OWN RISK
from traits import api as traits
from traitsui.item import Item, spring
from traitsui.group import HGroup
from traitsui.view import View

from tvtk import vtk_module as vtk
from tvtk import tvtk_base
from tvtk.tvtk_base_handler import TVTKBaseHandler
from tvtk import messenger
from tvtk.tvtk_base import deref_vtk
from tvtk import array_handler
from tvtk.array_handler import deref_array
from tvtk.tvtk_classes.tvtk_helper import wrap_vtk

nan = float('nan')


def InstanceEditor(*args, **kw):
    from traitsui.editors.api import InstanceEditor as Editor
    return Editor(view_name="handler.view")

try:
    long
except NameError:
    # Silly workaround for Python3.
    long = int

inf = float('inf')

from tvtk.tvtk_classes.pass_input_type_algorithm import PassInputTypeAlgorithm


class AlignImageDataSetFilter(PassInputTypeAlgorithm):
    r"""
    AlignImageDataSetFilter - align collection of image datasets to
    use a global origin
    
    Superclass: PassInputTypeAlgorithm
    
    When dealing with a collection of image datasets, either in a
    composite dataset or in a distributed environment, it is not uncommon
    to have each dataset have its own unique origin such that the extents
    for each start at 0. However, if the images are parts of a whole,
    then several filters like ExtractVOI that simply use extents fail
    to execute correctly. Such filters require that all parts use the
    same global origin and set local extents accordingly. This filter can
    be used to align such image datasets. Essentially, this filter
    ensures all image datasets have the same origin and each blocks
    extents are set relative to that origin. This requires that all
    images have the same spacing.
    
    """
    def __init__(self, obj=None, update=True, **traits):
        tvtk_base.TVTKBase.__init__(self, vtk.vtkAlignImageDataSetFilter, obj, update, **traits)
    
    def _get_controller(self):
        return wrap_vtk(self._vtk_obj.GetController())
    def _set_controller(self, arg):
        old_val = self._get_controller()
        self._wrap_call(self._vtk_obj.SetController,
                        deref_vtk(arg))
        self.trait_property_changed('controller', old_val, arg)
    controller = traits.Property(_get_controller, _set_controller, desc=\
        r"""
        
        """
    )

    minimum_extent = traits.Array(enter_set=True, auto_set=False, shape=(3,), dtype="int", value=(0, 0, 0), cols=3, desc=\
        r"""
        Specify the global minimum extent to use. By default this is set
        to `(0,0,0)`.
        """
    )

    def _minimum_extent_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetMinimumExtent,
                        self.minimum_extent)

    def _get_input(self):
        return wrap_vtk(self._vtk_obj.GetInput())
    input = traits.Property(_get_input, desc=\
        r"""
        Get the input data object. This method is not recommended for
        use, but lots of old style filters use it.
        """
    )

    _updateable_traits_ = \
    (('abort_execute', 'GetAbortExecute'), ('release_data_flag',
    'GetReleaseDataFlag'), ('debug', 'GetDebug'),
    ('global_warning_display', 'GetGlobalWarningDisplay'),
    ('minimum_extent', 'GetMinimumExtent'), ('progress_text',
    'GetProgressText'), ('object_name', 'GetObjectName'),
    ('reference_count', 'GetReferenceCount'))
    
    _allow_update_failure_ = \
    ()
    
    _full_traitnames_list_ = \
    (['abort_execute', 'debug', 'global_warning_display',
    'release_data_flag', 'minimum_extent', 'object_name',
    'progress_text'])
    
    def trait_view(self, name=None, view_element=None):
        if view_element is not None or name not in (None, '', 'traits_view', 'full_traits_view', 'view'):
            return super(AlignImageDataSetFilter, self).trait_view(name, view_element)
        if name == 'full_traits_view':
            full_traits_view = \
            View((Item("handler._full_traits_list",show_label=False)),
            title='Edit AlignImageDataSetFilter properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return full_traits_view
        elif name == 'view':
            view = \
            View(([], [], ['minimum_extent', 'object_name']),
            title='Edit AlignImageDataSetFilter properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return view
        elif name in (None, 'traits_view'):
            traits_view = \
            View((HGroup(spring, "handler.view_type", show_border=True), 
            Item("handler.info.object", editor = InstanceEditor(view_name="handler.view"), style = "custom", show_label=False)),
            title='Edit AlignImageDataSetFilter properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return traits_view
            

