#include <glib-object.h>
#include <dbus/dbus-glib.h>

G_BEGIN_DECLS

/**
 * SwCoreIface:
 *
 * Dummy typedef representing any implementation of this interface.
 */
typedef struct _SwCoreIface SwCoreIface;

/**
 * SwCoreIfaceClass:
 *
 * The class of SwCoreIface.
 */
typedef struct _SwCoreIfaceClass SwCoreIfaceClass;

GType sw_core_iface_get_type (void);
#define SW_TYPE_CORE_IFACE \
  (sw_core_iface_get_type ())
#define SW_CORE_IFACE(obj) \
  (G_TYPE_CHECK_INSTANCE_CAST((obj), SW_TYPE_CORE_IFACE, SwCoreIface))
#define SW_IS_CORE_IFACE(obj) \
  (G_TYPE_CHECK_INSTANCE_TYPE((obj), SW_TYPE_CORE_IFACE))
#define SW_CORE_IFACE_GET_CLASS(obj) \
  (G_TYPE_INSTANCE_GET_INTERFACE((obj), SW_TYPE_CORE_IFACE, SwCoreIfaceClass))


typedef void (*sw_core_iface_get_services_impl) (SwCoreIface *self,
    DBusGMethodInvocation *context);
void sw_core_iface_implement_get_services (SwCoreIfaceClass *klass, sw_core_iface_get_services_impl impl);
/**
 * sw_core_iface_return_from_get_services:
 * @context: The D-Bus method invocation context
 * @out_services: const gchar ** (FIXME, generate documentation)
 *
 * Return successfully by calling dbus_g_method_return().
 * This inline function exists only to provide type-safety.
 */
static inline
/* this comment is to stop gtkdoc realising this is static */
void sw_core_iface_return_from_get_services (DBusGMethodInvocation *context,
    const gchar **out_services);
static inline void
sw_core_iface_return_from_get_services (DBusGMethodInvocation *context,
    const gchar **out_services)
{
  dbus_g_method_return (context,
      out_services);
}

typedef void (*sw_core_iface_is_online_impl) (SwCoreIface *self,
    DBusGMethodInvocation *context);
void sw_core_iface_implement_is_online (SwCoreIfaceClass *klass, sw_core_iface_is_online_impl impl);
/**
 * sw_core_iface_return_from_is_online:
 * @context: The D-Bus method invocation context
 * @out_online: gboolean  (FIXME, generate documentation)
 *
 * Return successfully by calling dbus_g_method_return().
 * This inline function exists only to provide type-safety.
 */
static inline
/* this comment is to stop gtkdoc realising this is static */
void sw_core_iface_return_from_is_online (DBusGMethodInvocation *context,
    gboolean out_online);
static inline void
sw_core_iface_return_from_is_online (DBusGMethodInvocation *context,
    gboolean out_online)
{
  dbus_g_method_return (context,
      out_online);
}

void sw_core_iface_emit_online_changed (gpointer instance,
    gboolean arg_online);


G_END_DECLS
