#!/usr/bin/env perl
use strict;
use warnings;

use Test::More;
use Math::Prime::Util::GMP qw/logint/;

plan tests => 3 + 3;

###### logint
is_deeply( [map { logint($_,2) } 1..200], [map { int(log($_)/log(2)+1e-10) } 1..200], "logint base 2: 0 .. 200" );
is_deeply( [map { logint($_,3) } 1..200], [map { int(log($_)/log(3)+1e-10) } 1..200], "logint base 3: 0 .. 200" );
is_deeply( [map { logint($_,5) } 1..200], [map { int(log($_)/log(5)+1e-10) } 1..200], "logint base 5: 0 .. 200" );

is( logint("233349236278210673",7), 20, "logint(60-bit,7)" );
is( logint("8824000603628887473157759741572043613",6), 47, "logint(126-bit,6)" );
is( logint("12841630529324618690287110381024741207371090179054523401854513591767425374457280095597649697919029190278407309341833680028605778112128570812016955380129295876600127312188291407079013497446287431320527980160505080524812571294840028995335345592184264326254446305749914233193992625682904647212036252113576546596062062464401756311648529888232954547576231328407052208485920256657311799529213960967111911206103842380105407308374781735405670900846649002502353725558253344044022532656221148888022031071712032093046661627118122155915729513695717804720429536273861067955818055216144138275313683450748773099367019013281325666619",3), 1291, "logint(2048-bit,3)" );
