/*
 * Decompiled with CFR 0.152.
 */
package org.boehn.kmlframework.todo;

import java.io.File;
import java.io.IOException;
import java.util.Hashtable;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.boehn.kmlframework.coordinates.CartesianCoordinate;
import org.boehn.kmlframework.todo.GraphicalModel;
import org.boehn.kmlframework.todo.MapObject;
import org.boehn.kmlframework.todo.MapObjectClass;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class ModelObjectFactory {
    private String fileName;
    private Hashtable<String, MapObjectClass> mapObjectClasses;

    public ModelObjectFactory(String fileName) throws IOException, ParserConfigurationException, SAXException {
        this.fileName = fileName;
        this.loadFile();
    }

    public MapObject createMapObject(String className) {
        return new MapObject(this.getMapObjectClass(className));
    }

    public MapObjectClass getMapObjectClass(String className) {
        MapObjectClass mapObjectClass = this.mapObjectClasses.get(className);
        if (mapObjectClass == null) {
            mapObjectClass = new MapObjectClass(className);
            this.mapObjectClasses.put(className, mapObjectClass);
        }
        return mapObjectClass;
    }

    public void loadFile() throws IOException, ParserConfigurationException, SAXException {
        this.mapObjectClasses = new Hashtable();
        DocumentBuilder documentBuilder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
        Document document = documentBuilder.parse(new File(this.fileName));
        NodeList documentNodes = document.getChildNodes();
        int i = 0;
        while (i < documentNodes.getLength()) {
            Node objectClassesNode = documentNodes.item(i);
            if ("mapObjectClasses".equals(objectClassesNode.getNodeName()) && objectClassesNode.getChildNodes().getLength() > 0) {
                NodeList objectClassesChildren = objectClassesNode.getChildNodes();
                int j = 0;
                while (j < objectClassesChildren.getLength()) {
                    Node mapObjectClassNode = objectClassesChildren.item(j);
                    if ("mapObjectClass".equals(mapObjectClassNode.getNodeName())) {
                        NamedNodeMap mapObjectClassAttributes = mapObjectClassNode.getAttributes();
                        MapObjectClass mapObjectClass = new MapObjectClass(mapObjectClassAttributes.getNamedItem("className").getNodeValue());
                        if (mapObjectClassAttributes.getNamedItem("showTail") != null) {
                            mapObjectClass.setShowTail(new Boolean(mapObjectClassAttributes.getNamedItem("showTail").getNodeValue()));
                        }
                        if (mapObjectClassAttributes.getNamedItem("showModel") != null) {
                            mapObjectClass.setShowModels(new Boolean(mapObjectClassAttributes.getNamedItem("showModel").getNodeValue()));
                        }
                        if (mapObjectClassAttributes.getNamedItem("visibleFrom") != null) {
                            mapObjectClass.setVisibleFrom(new Integer(mapObjectClassAttributes.getNamedItem("visibleFrom").getNodeValue()));
                        }
                        if (mapObjectClassAttributes.getNamedItem("visibleTo") != null) {
                            mapObjectClass.setVisibleTo(new Integer(mapObjectClassAttributes.getNamedItem("visibleTo").getNodeValue()));
                        }
                        if (mapObjectClassAttributes.getNamedItem("tailHistoryLimit") != null) {
                            mapObjectClass.setTailHistoryLimit(new Integer(mapObjectClassAttributes.getNamedItem("tailHistoryLimit").getNodeValue()));
                        }
                        if (mapObjectClassAttributes.getNamedItem("tailVisibleFrom") != null) {
                            mapObjectClass.setTailVisibleFrom(new Integer(mapObjectClassAttributes.getNamedItem("tailVisibleFrom").getNodeValue()));
                        }
                        if (mapObjectClassAttributes.getNamedItem("tailVisibleTo") != null) {
                            mapObjectClass.setTailVisibleTo(new Integer(mapObjectClassAttributes.getNamedItem("tailVisibleTo").getNodeValue()));
                        }
                        mapObjectClassAttributes.getNamedItem("styleUrl");
                        NodeList mapObjectClassChildren = mapObjectClassNode.getChildNodes();
                        int k = 0;
                        while (k < mapObjectClassChildren.getLength()) {
                            Node mapObjectClassChild = mapObjectClassChildren.item(k);
                            if ("model".equals(mapObjectClassChild.getNodeName())) {
                                GraphicalModel model = new GraphicalModel();
                                NamedNodeMap modelAttributes = mapObjectClassChild.getAttributes();
                                if (modelAttributes.getNamedItem("visibleFrom") != null) {
                                    model.setVisibleFrom(new Integer(modelAttributes.getNamedItem("visibleFrom").getNodeValue()));
                                }
                                if (modelAttributes.getNamedItem("visibleTo") != null) {
                                    model.setVisibleTo(new Integer(modelAttributes.getNamedItem("visibleTo").getNodeValue()));
                                }
                                NodeList modelChildren = mapObjectClassChild.getChildNodes();
                                int l = 0;
                                while (l < modelChildren.getLength()) {
                                    Node modelChild = modelChildren.item(l);
                                    if ("polygon".equals(modelChild.getNodeName()) || "path".equals(modelChild.getNodeName())) {
                                        "polygon".equals(modelChild.getNodeName());
                                        NamedNodeMap modelChildAttributes = modelChild.getAttributes();
                                        modelChildAttributes.getNamedItem("altitudeMode");
                                        modelChildAttributes.getNamedItem("extrude");
                                        NodeList pathChildren = modelChild.getChildNodes();
                                        int m = 0;
                                        while (m < pathChildren.getLength()) {
                                            Node pathChild = pathChildren.item(m);
                                            if ("coordinate".equals(pathChild.getNodeName())) {
                                                NamedNodeMap coordinateAttributes = pathChild.getAttributes();
                                                CartesianCoordinate cartesianCoordinate = new CartesianCoordinate(Double.parseDouble(coordinateAttributes.getNamedItem("x").getNodeValue()), Double.parseDouble(coordinateAttributes.getNamedItem("y").getNodeValue()), Double.parseDouble(coordinateAttributes.getNamedItem("z").getNodeValue()));
                                            }
                                            ++m;
                                        }
                                    }
                                    ++l;
                                }
                                mapObjectClass.addModel(model);
                            }
                            ++k;
                        }
                        this.mapObjectClasses.put(mapObjectClass.getClassName(), mapObjectClass);
                    }
                    ++j;
                }
                break;
            }
            ++i;
        }
    }
}

