/*
 * Decompiled with CFR 0.152.
 */
package java.lang;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import sun.misc.CVM;

public final class StringBuffer
implements Serializable,
CharSequence {
    private char[] value;
    private int count;
    private boolean shared;
    static final long serialVersionUID = 3388685877147921107L;
    private static final StringBuffer NULL = new StringBuffer("null");

    public StringBuffer() {
        this(16);
    }

    public StringBuffer(int n) {
        this.value = new char[n];
        this.shared = false;
    }

    public StringBuffer(String string) {
        this(string.length() + 16);
        this.append(string);
    }

    public synchronized int length() {
        return this.count;
    }

    private int lengthSimpleSync() {
        if (CVM.simpleLockGrab(this)) {
            int n = this.count;
            CVM.simpleLockRelease(this);
            return n;
        }
        return this.length();
    }

    int lengthNoSync() {
        return this.count;
    }

    public synchronized int capacity() {
        return this.value.length;
    }

    private int capacitySimpleSync() {
        if (CVM.simpleLockGrab(this)) {
            int n = this.value.length;
            CVM.simpleLockRelease(this);
            return n;
        }
        return this.capacity();
    }

    private final void copy() {
        char[] cArray = new char[this.value.length];
        if (this.count != 0) {
            CVM.copyCharArray(this.value, 0, cArray, 0, this.count);
        }
        this.value = cArray;
        this.shared = false;
    }

    public synchronized void ensureCapacity(int n) {
        if (n > this.value.length) {
            this.expandCapacity(n);
        }
    }

    private native void expandCapacity(int var1);

    public synchronized void setLength(int n) {
        if (n < 0) {
            throw new StringIndexOutOfBoundsException(n);
        }
        if (n > this.value.length) {
            this.expandCapacity(n);
        }
        if (this.count < n) {
            if (this.shared) {
                this.copy();
            }
            while (this.count < n) {
                this.value[this.count] = '\u0000';
                ++this.count;
            }
        } else {
            this.count = n;
            if (this.shared) {
                if (n > 0) {
                    this.copy();
                } else {
                    this.value = new char[16];
                    this.shared = false;
                }
            }
        }
    }

    public synchronized char charAt(int n) {
        if (n < 0 || n >= this.count) {
            throw new StringIndexOutOfBoundsException(n);
        }
        return this.value[n];
    }

    private char charAtSimpleSync(int n) {
        if (CVM.simpleLockGrab(this)) {
            boolean bl;
            char c;
            if (n >= 0 && n < this.count) {
                c = this.value[n];
                bl = true;
            } else {
                c = '\u0000';
                bl = false;
            }
            CVM.simpleLockRelease(this);
            if (bl) {
                return c;
            }
        }
        return this.charAt(n);
    }

    public synchronized void getChars(int n, int n2, char[] cArray, int n3) {
        if (n3 < 0 || (long)n3 + (long)n2 - (long)n > (long)cArray.length) {
            throw new StringIndexOutOfBoundsException();
        }
        if (n < 0) {
            throw new StringIndexOutOfBoundsException(n);
        }
        if (n2 < 0 || n2 > this.count) {
            throw new StringIndexOutOfBoundsException(n2);
        }
        if (n > n2) {
            throw new StringIndexOutOfBoundsException("srcBegin > srcEnd");
        }
        if (n2 != n) {
            CVM.copyCharArray(this.value, n, cArray, n3, n2 - n);
        }
    }

    public synchronized void setCharAt(int n, char c) {
        if (n < 0 || n >= this.count) {
            throw new StringIndexOutOfBoundsException(n);
        }
        if (this.shared) {
            this.copy();
        }
        this.value[n] = c;
    }

    public synchronized StringBuffer append(Object object) {
        return this.append(String.valueOf(object));
    }

    public synchronized StringBuffer append(String string) {
        int n;
        int n2;
        if (string == null) {
            string = String.valueOf(string);
        }
        if ((n2 = this.count + (n = string.length())) > this.value.length) {
            this.expandCapacity(n2);
        }
        string.getChars(0, n, this.value, this.count);
        this.count = n2;
        return this;
    }

    public synchronized StringBuffer append(StringBuffer stringBuffer) {
        int n;
        int n2;
        if (stringBuffer == null) {
            stringBuffer = NULL;
        }
        if ((n2 = this.count + (n = stringBuffer.length())) > this.value.length) {
            this.expandCapacity(n2);
        }
        stringBuffer.getChars(0, n, this.value, this.count);
        this.count = n2;
        return this;
    }

    public synchronized native StringBuffer append(char[] var1);

    public synchronized native StringBuffer append(char[] var1, int var2, int var3);

    public StringBuffer append(boolean bl) {
        return this.append(String.valueOf(bl));
    }

    public synchronized StringBuffer append(char c) {
        int n = this.count + 1;
        if (n > this.value.length) {
            this.expandCapacity(n);
        }
        this.value[this.count++] = c;
        return this;
    }

    private StringBuffer appendSimpleSync(char c) {
        if (CVM.simpleLockGrab(this)) {
            boolean bl;
            if (this.count + 1 <= this.value.length) {
                this.value[this.count++] = c;
                bl = true;
            } else {
                bl = false;
            }
            CVM.simpleLockRelease(this);
            if (bl) {
                return this;
            }
        }
        return this.append(c);
    }

    public synchronized StringBuffer append(int n) {
        Integer.appendTo(n, this);
        return this;
    }

    public synchronized StringBuffer append(long l) {
        Long.appendTo(l, this);
        return this;
    }

    public synchronized StringBuffer append(float f) {
        new FloatingDecimal(f).appendTo(this);
        return this;
    }

    public synchronized StringBuffer append(double d) {
        new FloatingDecimal(d).appendTo(this);
        return this;
    }

    public synchronized StringBuffer delete(int n, int n2) {
        if (n < 0) {
            throw new StringIndexOutOfBoundsException(n);
        }
        if (n2 > this.count) {
            n2 = this.count;
        }
        if (n > n2) {
            throw new StringIndexOutOfBoundsException();
        }
        int n3 = n2 - n;
        if (n3 > 0) {
            if (this.shared) {
                this.copy();
            }
            if (this.count != n2) {
                CVM.copyCharArray(this.value, n + n3, this.value, n, this.count - n2);
            }
            this.count -= n3;
        }
        return this;
    }

    public synchronized StringBuffer deleteCharAt(int n) {
        if (n < 0 || n >= this.count) {
            throw new StringIndexOutOfBoundsException();
        }
        if (this.shared) {
            this.copy();
        }
        if (this.count - n - 1 != 0) {
            CVM.copyCharArray(this.value, n + 1, this.value, n, this.count - n - 1);
        }
        --this.count;
        return this;
    }

    public synchronized StringBuffer replace(int n, int n2, String string) {
        if (n < 0) {
            throw new StringIndexOutOfBoundsException(n);
        }
        if (n2 > this.count) {
            n2 = this.count;
        }
        if (n > n2) {
            throw new StringIndexOutOfBoundsException();
        }
        int n3 = string.length();
        int n4 = this.count + n3 - (n2 - n);
        if (n4 > this.value.length) {
            this.expandCapacity(n4);
        } else if (this.shared) {
            this.copy();
        }
        if (this.count != n2) {
            CVM.copyCharArray(this.value, n2, this.value, n + n3, this.count - n2);
        }
        string.getChars(0, n3, this.value, n);
        this.count = n4;
        return this;
    }

    public synchronized String substring(int n) {
        return this.substring(n, this.count);
    }

    public CharSequence subSequence(int n, int n2) {
        return this.substring(n, n2);
    }

    public synchronized String substring(int n, int n2) {
        if (n < 0) {
            throw new StringIndexOutOfBoundsException(n);
        }
        if (n2 > this.count) {
            throw new StringIndexOutOfBoundsException(n2);
        }
        if (n > n2) {
            throw new StringIndexOutOfBoundsException(n2 - n);
        }
        return new String(this.value, n, n2 - n);
    }

    public synchronized StringBuffer insert(int n, char[] cArray, int n2, int n3) {
        if (n < 0 || n > this.count) {
            throw new StringIndexOutOfBoundsException();
        }
        if (n2 < 0 || n2 + n3 < 0 || n2 + n3 > cArray.length) {
            throw new StringIndexOutOfBoundsException(n2);
        }
        if (n3 < 0) {
            throw new StringIndexOutOfBoundsException(n3);
        }
        int n4 = this.count + n3;
        if (n4 > this.value.length) {
            this.expandCapacity(n4);
        } else if (this.shared) {
            this.copy();
        }
        if (this.count != n) {
            CVM.copyCharArray(this.value, n, this.value, n + n3, this.count - n);
        }
        if (n3 != 0) {
            CVM.copyCharArray(cArray, n2, this.value, n, n3);
        }
        this.count = n4;
        return this;
    }

    public synchronized StringBuffer insert(int n, Object object) {
        return this.insert(n, String.valueOf(object));
    }

    public synchronized StringBuffer insert(int n, String string) {
        int n2;
        int n3;
        if (n < 0 || n > this.count) {
            throw new StringIndexOutOfBoundsException();
        }
        if (string == null) {
            string = String.valueOf(string);
        }
        if ((n3 = this.count + (n2 = string.length())) > this.value.length) {
            this.expandCapacity(n3);
        } else if (this.shared) {
            this.copy();
        }
        if (this.count != n) {
            CVM.copyCharArray(this.value, n, this.value, n + n2, this.count - n);
        }
        string.getChars(0, n2, this.value, n);
        this.count = n3;
        return this;
    }

    public synchronized StringBuffer insert(int n, char[] cArray) {
        if (n < 0 || n > this.count) {
            throw new StringIndexOutOfBoundsException();
        }
        int n2 = cArray.length;
        int n3 = this.count + n2;
        if (n3 > this.value.length) {
            this.expandCapacity(n3);
        } else if (this.shared) {
            this.copy();
        }
        if (this.count != n) {
            CVM.copyCharArray(this.value, n, this.value, n + n2, this.count - n);
        }
        if (n2 != 0) {
            CVM.copyCharArray(cArray, 0, this.value, n, n2);
        }
        this.count = n3;
        return this;
    }

    public StringBuffer insert(int n, boolean bl) {
        return this.insert(n, String.valueOf(bl));
    }

    public synchronized StringBuffer insert(int n, char c) {
        int n2 = this.count + 1;
        if (n2 > this.value.length) {
            this.expandCapacity(n2);
        } else if (this.shared) {
            this.copy();
        }
        if (n < 0 || n > this.count) {
            throw new StringIndexOutOfBoundsException(n);
        }
        if (this.count != n) {
            CVM.copyCharArray(this.value, n, this.value, n + 1, this.count - n);
        }
        this.value[n] = c;
        this.count = n2;
        return this;
    }

    public StringBuffer insert(int n, int n2) {
        return this.insert(n, String.valueOf(n2));
    }

    public StringBuffer insert(int n, long l) {
        return this.insert(n, String.valueOf(l));
    }

    public StringBuffer insert(int n, float f) {
        return this.insert(n, String.valueOf(f));
    }

    public StringBuffer insert(int n, double d) {
        return this.insert(n, String.valueOf(d));
    }

    public int indexOf(String string) {
        return this.indexOf(string, 0);
    }

    public synchronized int indexOf(String string, int n) {
        return String.indexOf(this.value, 0, this.count, string.toCharArray(), 0, string.length(), n);
    }

    public synchronized int lastIndexOf(String string) {
        return this.lastIndexOf(string, this.count);
    }

    public synchronized int lastIndexOf(String string, int n) {
        return String.lastIndexOf(this.value, 0, this.count, string.toCharArray(), 0, string.length(), n);
    }

    public synchronized StringBuffer reverse() {
        if (this.shared) {
            this.copy();
        }
        int n = this.count - 1;
        for (int i = n - 1 >> 1; i >= 0; --i) {
            char c = this.value[i];
            this.value[i] = this.value[n - i];
            this.value[n - i] = c;
        }
        return this;
    }

    public String toString() {
        return new String(this);
    }

    final void setShared() {
        this.shared = true;
    }

    final char[] getValue() {
        return this.value;
    }

    private synchronized void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        this.value = (char[])this.value.clone();
        this.shared = false;
    }
}

