/*
 * Port of listen-and-print.c using libindicate-qt
 *
 * Copyright 2009 Canonical Ltd.
 *
 * Authors:
 * - Aurélien Gâteau <aurelien.gateau@canonical.com>
 *
 * License: LGPL v2.1 or LGPL v3
 */
#ifndef QLISTEN_AND_PRINT_H
#define QLISTEN_AND_PRINT_H

#include <QApplication>
#include <QObject>

#include <qindicatelistener.h>

class Controller : public QObject
{
Q_OBJECT
public Q_SLOTS:
    void slotServerAdded(QIndicate::Listener::Server* server, const QString& type);
    void slotServerRemoved(QIndicate::Listener::Server* server, const QString& type);

    void slotIndicatorAdded(QIndicate::Listener::Server* server, QIndicate::Listener::Indicator* indicator);
    void slotIndicatorRemoved(QIndicate::Listener::Server* server, QIndicate::Listener::Indicator* indicator);
    void slotIndicatorModified(QIndicate::Listener::Server* server, QIndicate::Listener::Indicator* indicator, const QString&);

    void doShowProperty(QIndicate::Listener::Server* server, QIndicate::Listener::Indicator* indicator, const QString& key, const QByteArray& value);

public:
    void showProperty(QIndicate::Listener::Server* server, QIndicate::Listener::Indicator* indicator, const QString&);

    QIndicate::Listener* mListener;
};

#endif /* QLISTEN_AND_PRINT_H */
