#! /bin/bash

_HERE=`dirname $0`
pushd $_HERE > /dev/null || exit 1
_HERE=$(pwd)
popd > /dev/null
echo "_HERE=$_HERE"
_LIBS="$_HERE/_shared/3rdparty"
ORIG_ANT_HOME="$_LIBS/ant/1.6beta"
echo "ORIG_ANT_HOME=$ORIG_ANT_HOME"

# Setup our required ant directory + required classpath
ANT_HOME="$_LIBS/ant/.tmp"
echo "ANT_HOME=$ANT_HOME"
ANT_LIB=$ANT_HOME/lib
if [ -d $ANT_HOME ]; then
    rm -rf $ANT_HOME
fi
mkdir $ANT_HOME || exit 1
cp -R $ORIG_ANT_HOME/* $ANT_HOME/.

cp $_LIBS/bcel/5.1/bcel-5.1.jar $ANT_LIB/.
cp $_LIBS/junit/3.8.1/junit.jar $ANT_LIB/.

# For the Xalan stuff, we need to ensure that the right one is used.
cp $_LIBS/xalan/2.5.1/xalan.jar $ANT_LIB/.
cp $_LIBS/xerces/2.4.0/xercesImpl.jar $ANT_LIB/.
cp $_LIBS/xerces/2.4.0/xml-apis.jar $ANT_LIB/.
cp $_LIBS/xerces/2.4.0/xercesImpl.jar $ANT_LIB/.

BOOTPATH="$ANT_LIB/xalan.jar:$ANT_LIB/xml-apis.jar:$ANT_LIB/xercesImpl.jar"

case "`uname`" in
  CYGWIN*) BOOTPATH=`cygpath --windows --path "$BOOTPATH"` ;;
esac
ANT_OPTS="$ANT_OPTS -Xbootclasspath/p:$BOOTPATH"
export ANT_OPTS
echo ANT_OPTS=$ANT_OPTS

$ANT_HOME/bin/ant $*
X=$?
rm -rf $ANT_HOME
exit $X
