/*
 * Decompiled with CFR 0.152.
 */
package com.google.caliper.runner;

import com.google.caliper.runner.ConsoleWriter;
import com.google.caliper.runner.ScenarioSelection;
import com.google.caliper.util.ShortDuration;
import java.io.PrintWriter;

public class DefaultConsoleWriter
implements ConsoleWriter {
    private final PrintWriter writer;

    public DefaultConsoleWriter(PrintWriter writer) {
        this.writer = writer;
    }

    @Override
    public void flush() {
        this.writer.flush();
    }

    @Override
    public void print(String s) {
        this.writer.print(s);
    }

    @Override
    public void describe(ScenarioSelection selection) {
        this.writer.println("Scenario selection: ");
        this.writer.println("  Benchmark methods: " + selection.benchmarkMethods());
        this.writer.println("  User parameters:   " + selection.userParameters());
        this.writer.println("  Virtual machines:  " + selection.vms());
        this.writer.println("  VM parameters:     " + selection.vmArguments());
        this.writer.println("  Selection type:    " + selection.selectionType());
        this.writer.println();
    }

    @Override
    public void beforeDryRun(int scenarioCount) {
        this.writer.format("This selection yields %s scenarios.%n", scenarioCount);
    }

    @Override
    public void beforeRun(int trials, int scenarioCount, ShortDuration estimate) {
        this.writer.format("Measuring %s trials each of %s scenarios. ", trials, scenarioCount);
        if (estimate.equals(ShortDuration.zero())) {
            this.writer.println("(Cannot estimate runtime.)");
        } else {
            this.writer.format("Estimated runtime: %s.%n", estimate);
        }
    }

    @Override
    public void afterRun(ShortDuration elapsed) {
        this.writer.format("Execution complete: %s.%n", elapsed);
    }

    @Override
    public void skippedScenarios(int nSkipped) {
        this.writer.format("%d scenarios were skipped.%n", nSkipped);
    }
}

