------------------------------------------------------------------------------
--                             G N A T C O L L                              --
--                                                                          --
--                     Copyright (C) 2009-2017, AdaCore                     --
--                                                                          --
-- This library is free software;  you can redistribute it and/or modify it --
-- under terms of the  GNU General Public License  as published by the Free --
-- Software  Foundation;  either version 3,  or (at your  option) any later --
-- version. This library is distributed in the hope that it will be useful, --
-- but WITHOUT ANY WARRANTY;  without even the implied warranty of MERCHAN- --
-- TABILITY or FITNESS FOR A PARTICULAR PURPOSE.                            --
--                                                                          --
--                                                                          --
--                                                                          --
--                                                                          --
--                                                                          --
-- You should have received a copy of the GNU General Public License and    --
-- a copy of the GCC Runtime Library Exception along with this program;     --
-- see the files COPYING3 and COPYING.RUNTIME respectively.  If not, see    --
-- <http://www.gnu.org/licenses/>.                                          --
--                                                                          --
------------------------------------------------------------------------------

with GNAT.IO;                use GNAT.IO;
with GNATCOLL.GMP.Integers;  use GNATCOLL.GMP.Integers;

procedure Test_Operators is

   A, B, C : Big_Integer;

begin
   Set (A, "2");
   Set (B, A ** 5);

   Set (C, B - A);
   if C /= 30 then
      Put_Line ("test_operators failed: 32 - 2 should = 30");
      return;
   end if;

   Set (A, A + 100);
   if A /= 102 then
      Put_Line ("test_operators failed: A + 100 should = 102");
      return;
   end if;

   Set (A, B * C);
   if A /= 960 then
      Put_Line ("test_operators failed: B * C should = 960");
      return;
   end if;

   Set (C, A / 10);
   if C /= 96 then
      Put_Line ("test_operators failed: A / 10 should = 96");
      return;
   end if;

   Put_Line ("test_operators passed");
end Test_Operators;
