/*******************************************************************************/
/* Permission is hereby granted, free of charge, to any person or organization */
/* obtaining a copy of the software and accompanying documentation covered by  */
/* this license (the "Software") to use, reproduce, display, distribute,       */
/* execute, and transmit the Software, and to prepare derivative works of the  */
/* Software, and to permit third-parties to whom the Software is furnished to  */
/* do so, all subject to the following:                                        */
/*                                                                             */
/* The copyright notices in the Software and this entire statement, including  */
/* the above license grant, this restriction and the following disclaimer,     */
/* must be included in all copies of the Software, in whole or in part, and    */
/* all derivative works of the Software, unless such copies or derivative      */
/* works are solely in the form of machine-executable object code generated by */
/* a source language processor.                                                */
/*                                                                             */
/* THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR  */
/* IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,    */
/* FITNESS FOR A PARTICULAR PURPOSE, TITLE AND NON-INFRINGEMENT. IN NO EVENT   */
/* SHALL THE COPYRIGHT HOLDERS OR ANYONE DISTRIBUTING THE SOFTWARE BE LIABLE   */
/* FOR ANY DAMAGES OR OTHER LIABILITY, WHETHER IN CONTRACT, TORT OR OTHERWISE, */
/* ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER */
/* DEALINGS IN THE SOFTWARE.                                                   */
/*******************************************************************************/

#include <config.h>

#include <lfp/string.h>
#include <lfp/stdlib.h>
#include <lfp/errno.h>

#include "utils.h"

#if defined(HAVE___XPG_STRERROR_R)
int __xpg_strerror_r (int errnum, char *buf, size_t buflen);
#endif

int lfp_strerror (int errnum, char *buf, size_t buflen)
{
    SYSCHECK(EINVAL, buf == NULL);
#if defined(HAVE___XPG_STRERROR_R)
    return __xpg_strerror_r(errnum, buf, buflen);
#else
    return strerror_r(errnum, buf, buflen);
#endif // HAVE___XPG_STRERROR_R
}

size_t lfp_strnlen(const char *s, size_t maxlen)
{
#if defined(HAVE_STRNLEN)
    return strnlen(s, maxlen);
#else
    for (size_t i = 0; i < maxlen; i++) {
        if (s[i] == '\0') {
            return i;
        }
    }
    return maxlen;
#endif
}

char *lfp_strndup(const char *s, size_t maxlen)
{
#if defined(HAVE_STRNDUP)
    return strndup(s, maxlen);
#else
    if (s == NULL) {
        return NULL;
    } else {
        size_t len = lfp_strnlen(s, maxlen);
        char *newstr = malloc(len + 1);
        if (newstr == NULL) {
            return NULL;
        } else {
            memcpy(newstr, s, len);
            newstr[len] = '\0';
            return newstr;
        }
    }
#endif
}
