/* 
 * E-XML Library:  For XML, XML-RPC, HTTP, and related.
 * Copyright (C) 2002-2008  Elias Ross
 * 
 * genman@noderunner.net
 * http://noderunner.net/~genman
 * 
 * 1025 NE 73RD ST
 * SEATTLE WA 98115
 * USA
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 * 
 * $Id$
 */

package net.noderunner.exml;

import java.io.Reader;

/**
 * Used for ignoring (or blocking) the obtaining of  
 * external entities.  This class is a singleton.
 *
 * @see NullReader
 */
public final class NullResolver
	implements SystemLiteralResolver
{
	static SystemLiteralResolver resolver = new NullResolver();

	private NullResolver() {
	}

	/**
	 * Returns the sole <code>NullResolver</code> instance.
	 */
	public static SystemLiteralResolver getInstance() {
		return resolver;
	}

	/**
	 * Returns a dummy <code>NullReader</code>.
	 */
	public Reader resolve(String literal) {
		return NullReader.getInstance();
	}
}

