/*
 * Decompiled with CFR 0.152.
 */
package org.apache.harmony.jndi.internal.parser;

import java.io.IOException;
import java.util.List;
import javax.naming.InvalidNameException;
import org.apache.harmony.jndi.internal.nls.Messages;
import org.apache.harmony.jndi.internal.parser.AttributeTypeAndValuePair;
import org.apache.harmony.jndi.internal.parser.LdapParser;
import org.apache.harmony.jndi.internal.parser.LdapTypeAndValueList;
import org.apache.harmony.jndi.internal.parser.RelaxedDnParser;

public class LdapRdnParser
implements LdapParser {
    private static String name = null;
    LdapTypeAndValueList list = new LdapTypeAndValueList();
    private List<AttributeTypeAndValuePair> attrList;
    private List<AttributeTypeAndValuePair> listAll;
    private RelaxedDnParser parser = null;

    public LdapRdnParser(String name) {
        LdapRdnParser.name = name.endsWith("+") ? name.substring(0, name.lastIndexOf(43)) : name;
    }

    public List getList() throws InvalidNameException {
        try {
            this.checkTypeRestrictions(name);
            this.parser = new RelaxedDnParser(name);
            this.listAll = this.parser.parse();
        }
        catch (IOException e) {
            throw (InvalidNameException)new InvalidNameException(String.valueOf(Messages.getString("ldap.17")) + name).initCause(e);
        }
        this.attrList = (List)((Object)this.listAll.get(0));
        for (AttributeTypeAndValuePair element : this.attrList) {
            this.list.put(element.getType(), element.getValue());
        }
        return this.list.toAttributeList();
    }

    private void checkTypeRestrictions(String rdn) throws InvalidNameException {
        int in = rdn.indexOf("=");
        try {
            if (rdn.substring(0, in).length() == 0) {
                throw new InvalidNameException(String.valueOf(Messages.getString("ldap.18")) + rdn);
            }
        }
        catch (StringIndexOutOfBoundsException stringIndexOutOfBoundsException) {
            throw new InvalidNameException(String.valueOf(Messages.getString("ldap.17")) + rdn);
        }
    }

    public static String escapeValue(Object obj) {
        if (obj instanceof String) {
            String val = String.valueOf(obj);
            return LdapRdnParser.getEscaped(val.toCharArray());
        }
        if (obj instanceof byte[]) {
            return LdapRdnParser.getHexValues((byte[])obj);
        }
        throw new ClassCastException(Messages.getString("ldap.19"));
    }

    private static String getEscaped(char[] chars) {
        StringBuffer sb = new StringBuffer();
        int leftSpaceCnt = 0;
        int rightSpaceCnt = 0;
        int pos = chars.length - 1;
        while (pos >= 0 && chars[pos] == ' ') {
            ++rightSpaceCnt;
            --pos;
        }
        int i = 0;
        while (i <= pos && chars[i] == ' ') {
            ++leftSpaceCnt;
            sb.append("\\ ");
            ++i;
        }
        i = leftSpaceCnt;
        while (i < chars.length - rightSpaceCnt) {
            if (LdapRdnParser.isSpecialChar(chars, i)) {
                sb.append('\\');
            }
            sb.append(new Character(chars[i]));
            ++i;
        }
        i = 0;
        while (i < rightSpaceCnt) {
            sb.append("\\ ");
            ++i;
        }
        return sb.toString();
    }

    private static String getHexValues(byte[] byteArray) {
        StringBuffer sb = new StringBuffer();
        int i = 0;
        while (i < byteArray.length) {
            sb.append(Integer.toHexString(byteArray[i] >> 4 & 0xF));
            sb.append(Integer.toHexString(byteArray[i] & 0xF));
            ++i;
        }
        return String.valueOf('#') + sb.toString();
    }

    public static Object unescapeValue(String val) {
        if (val.startsWith("#") && LdapRdnParser.numeralCounter(val)) {
            return LdapRdnParser.getByteFromHexString(val);
        }
        if (val.startsWith("#")) {
            return LdapRdnParser.getByteFromHexString(val);
        }
        String tmpVal = val.trim();
        if (tmpVal.length() > 0 && tmpVal.charAt(0) == '\"' && tmpVal.charAt(tmpVal.length() - 1) == '\"') {
            val = tmpVal.length() == 1 ? "" : tmpVal.substring(1, tmpVal.length() - 1);
        }
        int pos = val.length() - 1;
        boolean trailingSpace = false;
        while (pos >= 0 && val.charAt(pos) == ' ') {
            trailingSpace = true;
            --pos;
        }
        char[] chars = pos >= 0 && val.charAt(pos) == '\\' && trailingSpace ? (String.valueOf(new String(val.trim())) + " ").toCharArray() : new String(val.trim()).toCharArray();
        return LdapRdnParser.getUnEscapedValues(chars);
    }

    private static boolean numeralCounter(String val) {
        int counter = 0;
        int i = 0;
        while (i < val.length()) {
            if (val.charAt(i) == '#') {
                ++counter;
            }
            ++i;
        }
        return counter == 1;
    }

    private static String getUnEscapedValues(char[] chars) {
        StringBuffer sb = new StringBuffer();
        boolean trailing20h = false;
        int i = 0;
        while (i < chars.length) {
            block10: {
                trailing20h = false;
                if (chars[i] != '\\') {
                    sb.append(chars[i]);
                } else {
                    try {
                        if (chars[i + 1] == ' ') break block10;
                        if (chars[i + 1] == '\\') {
                            sb.append('\\');
                            ++i;
                            break block10;
                        }
                        if (LdapRdnParser.isSpecialChar(chars, i + 1) || LdapRdnParser.isSpecialChar(chars, i + 2)) break block10;
                        try {
                            sb.append(RelaxedDnParser.hexToUTF8(new String(chars, i + 1, 2)));
                            if (sb.charAt(sb.length() - 1) == ' ') {
                                trailing20h = true;
                            }
                            i += 2;
                        }
                        catch (IOException iOException) {
                            throw new IllegalArgumentException(Messages.getString("ldap.1A"));
                        }
                    }
                    catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                        sb.append(chars[i]);
                    }
                }
            }
            ++i;
        }
        if (trailing20h && sb.length() > 0 && sb.charAt(sb.length() - 1) == ' ') {
            sb = sb.deleteCharAt(sb.length() - 1);
        }
        return sb.toString();
    }

    private static byte[] getByteFromHexString(String val) {
        String str = val.substring(val.indexOf("#") + 1);
        if (str.length() % 2 != 0) {
            throw new IllegalArgumentException(Messages.getString("ldap.1A"));
        }
        byte[] ret = null;
        try {
            ret = new byte[str.length() / 2];
            int i = 0;
            while (i < ret.length) {
                ret[i] = (byte)Integer.parseInt(str.substring(2 * i, 2 * i + 2), 16);
                ++i;
            }
        }
        catch (NumberFormatException numberFormatException) {
            throw new IllegalArgumentException(String.valueOf(Messages.getString("ldap.17")) + val);
        }
        return ret;
    }

    private static boolean isSpecialChar(char[] chars, int index) {
        switch (chars[index]) {
            case '\"': 
            case '#': 
            case '+': 
            case ',': 
            case ';': 
            case '<': 
            case '=': 
            case '>': 
            case '\\': {
                return true;
            }
        }
        return false;
    }
}

