/*
 * Decompiled with CFR 0.152.
 */
package org.apache.harmony.sql.tests.java.sql;

import java.io.ByteArrayOutputStream;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.lang.reflect.Method;
import java.sql.Connection;
import java.sql.Driver;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.Enumeration;
import java.util.Properties;
import junit.framework.TestCase;
import org.apache.harmony.sql.tests.java.sql.DriverManagerTest;
import org.apache.harmony.sql.tests.java.sql.TestHelper_ClassLoader;
import tests.support.Support_Exec;

/*
 * Exception performing whole class analysis ignored.
 */
public class DriverManagerTest
extends TestCase {
    static final String DRIVER1 = "org.apache.harmony.sql.tests.java.sql.TestHelper_Driver1";
    static final String DRIVER2 = "org.apache.harmony.sql.tests.java.sql.TestHelper_Driver2";
    static final String DRIVER3 = "org.apache.harmony.sql.tests.java.sql.TestHelper_Driver3";
    static final String DRIVER4 = "org.apache.harmony.sql.tests.java.sql.TestHelper_Driver4";
    static final String DRIVER5 = "org.apache.harmony.sql.tests.java.sql.TestHelper_Driver5";
    static final String INVALIDDRIVER1 = "abc.klm.Foo";
    static String[] driverNames = new String[]{"org.apache.harmony.sql.tests.java.sql.TestHelper_Driver1", "org.apache.harmony.sql.tests.java.sql.TestHelper_Driver2", "org.apache.harmony.sql.tests.java.sql.TestHelper_Driver4", "org.apache.harmony.sql.tests.java.sql.TestHelper_Driver5"};
    static int numberLoaded;
    static String baseURL1;
    static String baseURL4;
    static final String JDBC_PROPERTY = "jdbc.drivers";
    static TestHelper_ClassLoader testClassLoader;
    static String validConnectionURL;
    static String invalidConnectionURL1;
    static String invalidConnectionURL2;
    static String invalidConnectionURL3;
    static String[] invalidConnectionURLs;
    static String validURL1;
    static String validURL2;
    static String invalidURL1;
    static String invalidURL2;
    static String[] validURLs;
    static String[] invalidURLs;
    static String exceptionMsg1;
    static int timeout1;
    static String testMessage;
    static int validTimeout1;
    static int validTimeout2;
    static int[] validTimeouts;
    static int invalidTimeout1;
    static ByteArrayOutputStream outputStream2;
    static PrintStream testPrintStream;
    static ByteArrayOutputStream outputStream;
    static PrintWriter testPrintWriter;
    static boolean driversLoaded;

    static {
        baseURL1 = "jdbc:mikes1";
        baseURL4 = "jdbc:mikes4";
        testClassLoader = new TestHelper_ClassLoader();
        validConnectionURL = "jdbc:mikes1:data1";
        invalidConnectionURL1 = "jdbc:mikes1:data2";
        invalidConnectionURL2 = "xyz1:abc3:456q";
        invalidConnectionURL3 = null;
        invalidConnectionURLs = new String[]{invalidConnectionURL2, invalidConnectionURL3};
        validURL1 = "jdbc:mikes1";
        validURL2 = "jdbc:mikes2";
        invalidURL1 = "xyz:acb";
        invalidURL2 = null;
        validURLs = new String[]{validURL1, validURL2};
        invalidURLs = new String[]{invalidURL1, invalidURL2};
        exceptionMsg1 = "No suitable driver";
        timeout1 = 25;
        testMessage = "DriverManagerTest: test message for print stream";
        validTimeout1 = 15;
        validTimeout2 = 0;
        validTimeouts = new int[]{validTimeout1, validTimeout2};
        invalidTimeout1 = -10;
        outputStream2 = new ByteArrayOutputStream();
        testPrintStream = new PrintStream(outputStream2);
        outputStream = new ByteArrayOutputStream();
        testPrintWriter = new PrintWriter(outputStream);
        driversLoaded = false;
    }

    public void setUp() {
        numberLoaded = DriverManagerTest.loadDrivers();
    }

    public void testDeregisterDriver() throws SQLException {
        Driver driver = DriverManager.getDriver(baseURL4);
        DriverManager.deregisterDriver(driver);
        DriverManagerTest.assertFalse((String)"testDeregisterDriver: Driver was not deregistered.", (boolean)DriverManagerTest.isDriverLoaded((Driver)driver));
        DriverManager.registerDriver(driver);
        DriverManagerTest.assertTrue((String)"testDeregisterDriver: Driver did not reload.", (boolean)DriverManagerTest.isDriverLoaded((Driver)driver));
        DriverManager.deregisterDriver(null);
        driver = DriverManager.getDriver(baseURL1);
        try {
            Class<?> clazz = Class.forName("org.apache.harmony.sql.tests.java.sql.TestHelper_DriverManager", true, (ClassLoader)testClassLoader);
            Class[] classArray = new Class[]{Class.forName("java.sql.Driver")};
            Method method = clazz.getDeclaredMethod("setDriver", classArray);
            Object[] objectArray = new Object[]{driver};
            method.invoke(null, objectArray);
        }
        catch (Exception exception) {
            System.out.println("testDeregisterDriver: Got exception allocating TestHelper");
            exception.printStackTrace();
            return;
        }
        DriverManagerTest.assertTrue((String)"testDeregisterDriver: Driver was incorrectly deregistered.", (boolean)DriverManagerTest.isDriverLoaded((Driver)driver));
    }

    static void printClassLoader(Object object) {
        Class<?> clazz = object.getClass();
        ClassLoader classLoader = clazz.getClassLoader();
        System.out.println("ClassLoader is: " + classLoader.toString() + " for object: " + object.toString());
    }

    static boolean isDriverLoaded(Driver driver) {
        Enumeration<Driver> enumeration = DriverManager.getDrivers();
        while (enumeration.hasMoreElements()) {
            if (enumeration.nextElement() != driver) continue;
            return true;
        }
        return false;
    }

    public void testGetConnectionString() throws SQLException {
        Connection connection = null;
        connection = DriverManager.getConnection(validConnectionURL);
        DriverManagerTest.assertNotNull((Object)connection);
        DriverManagerTest.assertNotNull((Object)DriverManager.getConnection(invalidConnectionURL1));
        String[] stringArray = invalidConnectionURLs;
        int n = 0;
        int n2 = stringArray.length;
        while (n < n2) {
            String string = stringArray[n];
            try {
                connection = DriverManager.getConnection(string);
                DriverManagerTest.fail((String)"Should throw SQLException");
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
            ++n;
        }
    }

    public void test_getConnection_LStringLProperties() {
        try {
            DriverManager.getConnection("fff", new Properties());
            DriverManagerTest.fail((String)"Should throw SQLException.");
        }
        catch (SQLException sQLException) {
            DriverManagerTest.assertEquals((String)"08001", (String)sQLException.getSQLState());
        }
        try {
            DriverManager.getConnection(null, new Properties());
            DriverManagerTest.fail((String)"Should throw SQLException.");
        }
        catch (SQLException sQLException) {
            DriverManagerTest.assertEquals((String)"08001", (String)sQLException.getSQLState());
        }
    }

    public void testGetConnectionStringProperties() throws SQLException {
        String string = "jdbc:mikes1:data2";
        String string2 = "theuser";
        String string3 = "thepassword";
        String string4 = "xyz:abc1:foo";
        String string5 = "jdbc:mikes1:crazyone";
        String string6 = "";
        String string7 = "jonny nouser";
        String string8 = "whizz";
        Object var9_9 = null;
        Properties properties = new Properties();
        properties.setProperty("user", string2);
        properties.setProperty("password", string3);
        Properties properties2 = new Properties();
        properties2.setProperty("user", string7);
        properties2.setProperty("password", string8);
        String[] stringArray = new String[4];
        stringArray[1] = string4;
        stringArray[2] = string5;
        stringArray[3] = string6;
        String[] stringArray2 = stringArray;
        Properties[] propertiesArray = new Properties[]{var9_9, properties2};
        Connection connection = null;
        connection = DriverManager.getConnection(string, properties);
        DriverManagerTest.assertNotNull((Object)connection);
        int n = 0;
        while (n < stringArray2.length) {
            connection = null;
            try {
                connection = DriverManager.getConnection(stringArray2[n], properties);
                DriverManagerTest.fail((String)"Should throw SQLException");
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
            ++n;
        }
        Properties[] propertiesArray2 = propertiesArray;
        int n2 = 0;
        int n3 = propertiesArray2.length;
        while (n2 < n3) {
            Properties properties3 = propertiesArray2[n2];
            DriverManagerTest.assertNotNull((Object)DriverManager.getConnection(string, properties3));
            ++n2;
        }
    }

    public void testGetConnectionStringStringString() throws SQLException {
        String[] stringArray;
        String string = "jdbc:mikes1:data2";
        String string2 = "theuser";
        String string3 = "thepassword";
        String string4 = "xyz:abc1:foo";
        String string5 = "jonny nouser";
        String string6 = "whizz";
        String[] stringArray2 = new String[3];
        stringArray2[1] = string2;
        stringArray2[2] = string3;
        String[] stringArray3 = stringArray2;
        String[] stringArray4 = new String[3];
        stringArray4[0] = string;
        stringArray4[2] = string3;
        String[] stringArray5 = stringArray4;
        String[] stringArray6 = new String[3];
        stringArray6[0] = string;
        stringArray6[1] = string2;
        String[] stringArray7 = stringArray6;
        String[] stringArray8 = new String[]{string4, string2, string3};
        String[] stringArray9 = new String[]{string, string5, string6};
        String[] stringArray10 = new String[]{string, string2, string6};
        String[][] stringArrayArray = new String[][]{stringArray3, stringArray8};
        String[][] stringArrayArray2 = new String[][]{stringArray5, stringArray7, stringArray9, stringArray10};
        Connection connection = null;
        connection = DriverManager.getConnection(string, string2, string3);
        DriverManagerTest.assertNotNull((Object)connection);
        String[][] stringArrayArray3 = stringArrayArray;
        int n = 0;
        int n2 = stringArrayArray3.length;
        while (n < n2) {
            stringArray = stringArrayArray3[n];
            connection = null;
            try {
                connection = DriverManager.getConnection(stringArray[0], stringArray[1], stringArray[2]);
                DriverManagerTest.fail((String)"Should throw SQLException.");
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
            ++n;
        }
        stringArrayArray3 = stringArrayArray2;
        n = 0;
        n2 = stringArrayArray3.length;
        while (n < n2) {
            stringArray = stringArrayArray3[n];
            DriverManagerTest.assertNotNull((Object)DriverManager.getConnection(stringArray[0], stringArray[1], stringArray[2]));
            ++n;
        }
    }

    public void testGetDriver() throws SQLException {
        String[] stringArray = validURLs;
        int n = 0;
        int n2 = stringArray.length;
        while (n < n2) {
            String string = stringArray[n];
            Driver driver = DriverManager.getDriver(string);
            DriverManagerTest.assertNotNull((Object)driver);
            ++n;
        }
    }

    public void testGetDrivers() {
        Enumeration<Driver> enumeration = DriverManager.getDrivers();
        int n = 0;
        while (enumeration.hasMoreElements()) {
            Driver driver = enumeration.nextElement();
            DriverManagerTest.assertNotNull((Object)driver);
            ++n;
        }
        DriverManagerTest.assertTrue((String)"testGetDrivers: Don't see all the loaded drivers - ", (n >= numberLoaded ? 1 : 0) != 0);
    }

    public void testGetLoginTimeout() {
        DriverManager.setLoginTimeout(timeout1);
        DriverManagerTest.assertEquals((int)timeout1, (int)DriverManager.getLoginTimeout());
    }

    public void testGetLogStream() {
        DriverManagerTest.assertNull((Object)DriverManager.getLogStream());
        DriverManager.setLogStream(testPrintStream);
        DriverManagerTest.assertTrue((DriverManager.getLogStream() == testPrintStream ? 1 : 0) != 0);
        DriverManager.setLogStream(null);
    }

    public void testGetLogWriter() {
        DriverManagerTest.assertNull((Object)DriverManager.getLogWriter());
        DriverManager.setLogWriter(testPrintWriter);
        DriverManagerTest.assertTrue((DriverManager.getLogWriter() == testPrintWriter ? 1 : 0) != 0);
        DriverManager.setLogWriter(null);
    }

    public void testPrintln() {
        DriverManager.println(testMessage);
        DriverManager.setLogWriter(testPrintWriter);
        DriverManager.println(testMessage);
        String string = outputStream.toString();
        DriverManagerTest.assertTrue((boolean)string.startsWith(testMessage));
        DriverManager.setLogWriter(null);
        DriverManager.setLogStream(testPrintStream);
        DriverManager.println(testMessage);
        string = outputStream2.toString();
        DriverManagerTest.assertTrue((boolean)string.startsWith(testMessage));
        DriverManager.setLogStream(null);
    }

    public void testRegisterDriver() throws ClassNotFoundException, SQLException, IllegalAccessException, InstantiationException {
        String string = "org.apache.harmony.sql.tests.java.sql.TestHelper_Driver3";
        try {
            DriverManager.registerDriver(null);
            DriverManagerTest.fail((String)"Should throw NullPointerException.");
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        Driver driver = null;
        Class<?> clazz = Class.forName(string);
        driver = (Driver)clazz.newInstance();
        DriverManager.registerDriver(driver);
        DriverManagerTest.assertTrue((String)"testRegisterDriver: driver not in loaded set", (boolean)DriverManagerTest.isDriverLoaded((Driver)driver));
    }

    public void testSetLoginTimeout() {
        int[] nArray = validTimeouts;
        int n = 0;
        int n2 = nArray.length;
        while (n < n2) {
            int n3 = nArray[n];
            DriverManager.setLoginTimeout(n3);
            DriverManagerTest.assertEquals((int)n3, (int)DriverManager.getLoginTimeout());
            ++n;
        }
        DriverManager.setLoginTimeout(invalidTimeout1);
        DriverManagerTest.assertEquals((int)invalidTimeout1, (int)DriverManager.getLoginTimeout());
    }

    public void testSetLogStream() {
        DriverManager.setLogStream(testPrintStream);
        DriverManagerTest.assertSame((Object)testPrintStream, (Object)DriverManager.getLogStream());
        DriverManager.setLogStream(null);
        DriverManagerTest.assertNull((Object)DriverManager.getLogStream());
        TestSecurityManager testSecurityManager = new TestSecurityManager(this);
        System.setSecurityManager((SecurityManager)testSecurityManager);
        testSecurityManager.setLogAccess(false);
        try {
            DriverManager.setLogStream(testPrintStream);
            DriverManagerTest.fail((String)"Should throw SecurityException.");
        }
        catch (SecurityException securityException) {
            // empty catch block
        }
        testSecurityManager.setLogAccess(true);
        DriverManager.setLogStream(testPrintStream);
        System.setSecurityManager(null);
    }

    public void testSetLogWriter() {
        DriverManager.setLogWriter(testPrintWriter);
        DriverManagerTest.assertSame((Object)testPrintWriter, (Object)DriverManager.getLogWriter());
        DriverManager.setLogWriter(null);
        DriverManagerTest.assertNull((String)"testDriverManager: Log writer not null:", (Object)DriverManager.getLogWriter());
        TestSecurityManager testSecurityManager = new TestSecurityManager(this);
        System.setSecurityManager((SecurityManager)testSecurityManager);
        testSecurityManager.setLogAccess(false);
        try {
            DriverManager.setLogWriter(testPrintWriter);
            DriverManagerTest.fail((String)"Should throw SecurityException.");
        }
        catch (SecurityException securityException) {
            // empty catch block
        }
        testSecurityManager.setLogAccess(true);
        DriverManager.setLogWriter(testPrintWriter);
        System.setSecurityManager(null);
    }

    private static int loadDrivers() {
        if (driversLoaded) {
            return numberLoaded;
        }
        int n = 0;
        String[] stringArray = driverNames;
        int n2 = 0;
        int n3 = stringArray.length;
        while (n2 < n3) {
            String string = stringArray[n2];
            try {
                Class<?> clazz = Class.forName(string);
                DriverManagerTest.assertNotNull(clazz);
                ++n;
            }
            catch (ClassNotFoundException classNotFoundException) {
                System.out.println("DriverManagerTest: failed to load Driver: " + string);
            }
            ++n2;
        }
        driversLoaded = true;
        return n;
    }

    public void test_registerDriver_MultiTimes() throws SQLException {
        int n = 10;
        int n2 = 1;
        DummyDriver dummyDriver = new DummyDriver(null, null);
        DriverManager.registerDriver((Driver)new BadDummyDriver(null));
        int n3 = 0;
        while (n3 < n) {
            DriverManager.registerDriver((Driver)dummyDriver);
            ++n3;
        }
        DriverManager.registerDriver((Driver)new BadDummyDriver(null));
        n3 = 0;
        while (n3 < n2) {
            DriverManager.deregisterDriver((Driver)dummyDriver);
            ++n3;
        }
        Driver driver = DriverManager.getDriver("jdbc:dummy_protocol:dummy_subname");
        DriverManagerTest.assertNotNull((Object)driver);
    }

    public void test_initClass() throws Exception {
        String[] stringArray = new String[]{"org/apache/harmony/sql/tests/java/sql/TestMainForDriver"};
        String string = Support_Exec.execJava((String[])stringArray, null, (boolean)true);
        DriverManagerTest.assertEquals((String)"", (String)string);
    }
}

