/*
 * Decompiled with CFR 0.152.
 */
package org.cojen.classfile.constant;

import java.io.DataOutput;
import java.io.IOException;
import org.cojen.classfile.ConstantInfo;

public class ConstantDoubleInfo
extends ConstantInfo {
    private final double mValue;

    public ConstantDoubleInfo(double value) {
        super(6);
        this.mValue = value;
    }

    public double getValue() {
        return this.mValue;
    }

    public int hashCode() {
        long bits = Double.doubleToLongBits(this.mValue);
        return (int)(bits ^ bits >>> 32);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof ConstantDoubleInfo) {
            ConstantDoubleInfo other = (ConstantDoubleInfo)obj;
            return this.mValue == other.mValue;
        }
        return false;
    }

    protected int getEntryCount() {
        return 2;
    }

    public void writeTo(DataOutput dout) throws IOException {
        super.writeTo(dout);
        dout.writeDouble(this.mValue);
    }

    public String toString() {
        return "CONSTANT_Double_info: " + this.mValue;
    }
}

