/* assembly to compute the key powers */

#include "crypto_asm_hidden.h"
// linker define poly1305_maax_g8_keypowers
// linker use mask2
// linker use mask2c

#define mask2  CRYPTO_SHARED_NAMESPACE(mask2)
#define mask2c CRYPTO_SHARED_NAMESPACE(mask2c)

#include "poly1305_keypowers_asm.h"
		
	.p2align 5
	
ASM_HIDDEN _CRYPTO_SHARED_NAMESPACE(poly1305_maax_g8_keypowers)
ASM_HIDDEN CRYPTO_SHARED_NAMESPACE(poly1305_maax_g8_keypowers)
.global _CRYPTO_SHARED_NAMESPACE(poly1305_maax_g8_keypowers)
.global CRYPTO_SHARED_NAMESPACE(poly1305_maax_g8_keypowers)
_CRYPTO_SHARED_NAMESPACE(poly1305_maax_g8_keypowers):
CRYPTO_SHARED_NAMESPACE(poly1305_maax_g8_keypowers):
	
	movq 	%rsp,%r11
	andq    $-32,%rsp
	subq 	$64,%rsp

	movq 	%r11,0(%rsp)
	movq 	%r12,8(%rsp)
	movq 	%r13,16(%rsp)
	movq 	%r14,24(%rsp)
	movq 	%r15,32(%rsp)
	movq 	%rbx,40(%rsp)
	movq 	%rbp,48(%rsp)

	/* key = tau */
	movq    0(%rdi),%r14
	movq    8(%rdi),%r15
	
	/* tau^2 */	
	fe1305_tau_square()	
	cmp	$3,%rsi
	je	.L
	
	/* tau^3 */	
	fe1305_mul_tau_taun(1,2)	
	cmp	$4,%rsi
	je	.L
	
	/* tau^4 */
	movq    24(%rdi),%r8
	movq    32(%rdi),%r9
	movq    40(%rdi),%r10
	fe1305_tau_squaren(3)	
	cmp	$5,%rsi
	je	.L	
	
	/* tau^5 */	
	fe1305_mul_tau_taun(3,4)	
	cmp	$6,%rsi
	je	.L	
	
	/* tau^6 */	
	fe1305_mul_tau_taun(4,5)	
	cmp	$7,%rsi
	je	.L	
	
	/* tau^7 */	
	fe1305_mul_tau_taun(5,6)	
	cmp	$8,%rsi
	je	.L
	
	/* tau^8 */	
	movq    72(%rdi),%r8
	movq    80(%rdi),%r9
	movq    88(%rdi),%r10	
	fe1305_tau_squaren(7)	
	
.L:
	movq 	0(%rsp),%r11
	movq 	8(%rsp),%r12
	movq 	16(%rsp),%r13
	movq 	24(%rsp),%r14
	movq 	32(%rsp),%r15
	movq 	40(%rsp),%rbx
	movq 	48(%rsp),%rbp

	movq 	%r11,%rsp

	ret
