## API Report File for "@lumino/application"

> Do not edit this file. It is a report generated by [API Extractor](https://api-extractor.com/).

```ts

import { CommandRegistry } from '@lumino/commands';
import { ContextMenu } from '@lumino/widgets';
import { Menu } from '@lumino/widgets';
import { Token } from '@lumino/coreutils';
import { Widget } from '@lumino/widgets';

// @public
export class Application<T extends Widget = Widget> {
    constructor(options: Application.IOptions<T>);
    activateDeferredPlugins(): Promise<void>;
    activatePlugin(id: string): Promise<void>;
    protected addEventListeners(): void;
    protected attachShell(id: string): void;
    readonly commands: CommandRegistry;
    readonly contextMenu: ContextMenu;
    deactivatePlugin(id: string): Promise<string[]>;
    get deferredPlugins(): string[];
    deregisterPlugin(id: string, force?: boolean): void;
    protected evtContextMenu(event: PointerEvent): void;
    protected evtKeydown(event: KeyboardEvent): void;
    protected evtResize(event: Event): void;
    getPluginDescription(id: string): string;
    handleEvent(event: Event): void;
    hasPlugin(id: string): boolean;
    isPluginActivated(id: string): boolean;
    listPlugins(): string[];
    registerPlugin(plugin: IPlugin<this, any>): void;
    registerPlugins(plugins: IPlugin<this, any>[]): void;
    resolveOptionalService<U>(token: Token<U>): Promise<U | null>;
    resolveRequiredService<U>(token: Token<U>): Promise<U>;
    readonly shell: T;
    start(options?: Application.IStartOptions): Promise<void>;
    get started(): Promise<void>;
}

// @public
export namespace Application {
    export interface IOptions<T extends Widget> {
        contextMenuRenderer?: Menu.IRenderer;
        shell: T;
    }
    export interface IStartOptions {
        bubblingKeydown?: boolean;
        hostID?: string;
        ignorePlugins?: string[];
        startPlugins?: string[];
    }
}

// @public
export interface IPlugin<T extends Application, U> {
    activate: (app: T, ...args: any[]) => U | Promise<U>;
    autoStart?: boolean | 'defer';
    deactivate?: ((app: T, ...args: any[]) => void | Promise<void>) | null;
    description?: string;
    id: string;
    optional?: Token<any>[];
    provides?: Token<U> | null;
    requires?: Token<any>[];
}

// (No @packageDocumentation comment for this package)

```
