#! /bin/sh

PROJECT=LongoMatch
FILE=
CONFIGURE=configure.ac

: ${AUTOCONF=autoconf}
: ${AUTOHEADER=autoheader}
: ${AUTOMAKE=automake}
: ${LIBTOOLIZE=libtoolize}
: ${INTLTOOLIZE=intltoolize}
: ${ACLOCAL=aclocal}
: ${LIBTOOL=libtool}

aclocalinclude="-I build/m4/shamrock -I build/m4/shave $ACLOCAL_FLAGS"

case $CC in
*xlc | *xlc\ * | *lcc | *lcc\ *) am_opt=--include-deps;;
esac

(grep "^AM_PROG_LIBTOOL" $CONFIGURE >/dev/null) && {
    echo "Running $LIBTOOLIZE ..."
    $LIBTOOLIZE --force --copy --automake
}

(grep "^IT_PROG_INTLTOOL" $CONFIGURE >/dev/null) && {
    echo "Running $INTLTOOLIZE ..."
    $INTLTOOLIZE --force --copy --automake
}

echo "Running $ACLOCAL $aclocalinclude ..."
$ACLOCAL $aclocalinclude

echo "Running $AUTOMAKE --gnu $am_opt ..."
$AUTOMAKE --add-missing --gnu $am_opt

echo "Running $AUTOCONF ..."
$AUTOCONF
