/*
 * Copyright (c) Members of the EGEE Collaboration. 2004-2010. 
 * See http://www.eu-egee.org/partners/ for details on the copyright
 * holders.  
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"); 
 * you may not use this file except in compliance with the License. 
 * You may obtain a copy of the License at 
 * 
 *     http://www.apache.org/licenses/LICENSE-2.0 
 * 
 * Unless required by applicable law or agreed to in writing, software 
 * distributed under the License is distributed on an "AS IS" BASIS, 
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. 
 * See the License for the specific language governing permissions and 
 * limitations under the License.
 */


/**
    \file   _lcmaps_return_account_from_pem.h
    \brief  This file holds implementation details of the \a lcmaps_return_account_from_pem
    interface that users of the API should not need to deal with.
    \author Dennis van Dok is taking all the blame


    \ingroup LcmapsHiddenInterface
*/

#ifndef _LCMAPS_RETURN_ACCOUNT_FROM_PEM_H
#define _LCMAPS_RETURN_ACCOUNT_FROM_PEM_H


# ifdef LCMAPS_USE_DLOPEN

/* Needed for NULL */
#include <stdio.h>

/*!
  \brief The name of the shared object that implements the interface.
  
  This is passed straight to dlopen().
*/
#define LCMAPS_LIB_RETURN_ACCOUNT_FROM_PEM "liblcmaps_return_account_from_pem" LIBSUFF

/**
    \brief LCMAPS Handle implementation.

    This struct contains all the LCMAPS functions to be filled using dlsym().

*/
typedef struct _lcmaps_handle_return_account_from_pem_s {
    const char *libfilename; /**< the name of the library file to dlopen() for this interface */
    const char *helpername; /**< the name of the helper library in case LCMAPS is really old */
    void *handle, /**< handle to the LCMAPS interface library obtained from dlopen() */
	*helper;   /**< handles to the optional helper (needed for the 'old' API to
			provide missing symbols) */
    char *errmsg; /**< the error string obtained from either dlopen() or dlsym() */
    lcmaps_init_t *lcmaps_init; /**< handle to the lcmaps_init() function */
    lcmaps_account_info_init_t *lcmaps_account_info_init; /**< */
    lcmaps_return_account_from_pem_t *lcmaps_return_account_from_pem; /**< */
    lcmaps_term_t *lcmaps_term; /**< */
    lcmaps_account_info_clean_t *lcmaps_account_info_clean;  /**< */
    /* Remainder is for 'new' API */
    /* LCMAPS_HANDLE_VERSION_MEMBERS; */
    getMajorVersion_t *getMajorVersion;  /**< */
    lcmaps_get_major_version_t *lcmaps_get_major_version;  /**< */
    lcmaps_get_minor_version_t *lcmaps_get_minor_version;  /**< */
    lcmaps_get_patch_version_t *lcmaps_get_patch_version;  /**< */
    /* If the above cannot be found (old lcmaps) these values will be
       set to 0 */
    int majorversion,  /**< */ 
	minorversion,  /**< */
	patchversion; /**< the version numbers to retrieve, or 0 if not present*/
    /* Next three is the 'OSG API' */
    lcmaps_disable_voms_attributes_verification_t *lcmaps_disable_voms_attributes_verification;  /**< */
    lcmaps_enable_voms_attributes_verification_t *lcmaps_enable_voms_attributes_verification; /**< */
    lcmaps_is_set_to_verify_voms_attributes_t *lcmaps_is_set_to_verify_voms_attributes; /**< */
    /* Plus the new two more fine-grained functions */
    lcmaps_set_voms_attributes_verification_t *lcmaps_set_voms_attributes_verification;
    lcmaps_get_voms_attributes_verification_t *lcmaps_get_voms_attributes_verification;
    /* Verification time of proxies */
    lcmaps_set_voms_verification_time_t *lcmaps_set_voms_verification_time;
    lcmaps_get_voms_verification_time_t *lcmaps_get_voms_verification_time;
} _lcmaps_handle_return_account_from_pem_t;

/**
   \brief The declarator of the handle object 

   Be careful to line up the initializers with the members of _lcmaps_handle_return_account_from_pem_t.

   \see _lcmaps_handle_return_account_from_pem_t

*/
#define _LCMAPS_DECL_HANDLE_RETURN_ACCOUNT_FROM_PEM(l)	\
    _lcmaps_handle_return_account_from_pem_t l = {	\
	LCMAPS_LIB_RETURN_ACCOUNT_FROM_PEM,		\
	LCMAPS_FIXVOMSHACKSO,				\
	NULL,						\
	NULL,						\
	NULL,						\
        NULL,						\
        NULL,						\
        NULL,						\
        NULL,						\
        NULL,						\
        NULL,						\
        NULL,						\
        NULL,						\
        NULL,						\
        -1,-1,-1,					\
        NULL,						\
        NULL,						\
        NULL,						\
        NULL,						\
        NULL,						\
        NULL,						\
        NULL,						\
    };


/**
   \brief  Initializer of the handle object

   The user has a choice to use either _LCMAPS_DECL_HANDLE_RETURN_ACCOUNT_FROM_PEM
   or have a separate declaration of a handle object, e.g. for dynamic allocation.
   This  macro should be called to do the initialization.

   \see _lcmaps_handle_return_account_from_pem_t
 */
#define _LCMAPS_INIT_HANDLE_RETURN_ACCOUNT_FROM_PEM(l)			\
    (									\
    (l)->libfilename = LCMAPS_LIB_RETURN_ACCOUNT_FROM_PEM,		\
    (l)->helpername = LCMAPS_FIXVOMSHACKSO,				\
    (l)->handle = (l)->helper = NULL,					\
    (l)->errmsg = NULL,							\
    (l)->majorversion = (l)->minorversion = (l)->patchversion = -1,	\
    (l)->lcmaps_init = NULL,						\
    (l)->lcmaps_account_info_init = NULL,				\
    (l)->lcmaps_return_account_from_pem = NULL,				\
    (l)->lcmaps_term = NULL,						\
    (l)->lcmaps_account_info_clean = NULL,				\
    (l)->getMajorVersion = NULL,					\
    (l)->lcmaps_disable_voms_attributes_verification = NULL,		\
    (l)->lcmaps_enable_voms_attributes_verification = NULL,		\
    (l)->lcmaps_is_set_to_verify_voms_attributes = NULL,		\
    (l)->lcmaps_set_voms_attributes_verification = NULL,		\
    (l)->lcmaps_get_voms_attributes_verification = NULL,		\
    (l)->lcmaps_set_voms_verification_time = NULL,			\
    (l)->lcmaps_get_voms_verification_time = NULL,			\
    1									\
    )


/* The single macro to call to initialize lcmaps */
#define _LCMAPS_LOAD_RETURN_ACCOUNT_FROM_PEM(l)				\
    (									\
     _LCMAPS_LOAD_INTERFACE_WITH_FIX(l)					\
     && LCMAPS_LOAD_FUNC(l,lcmaps_init)					\
     && LCMAPS_LOAD_FUNC(l,lcmaps_account_info_init)			\
     && LCMAPS_LOAD_FUNC(l,lcmaps_return_account_from_pem)		\
     && LCMAPS_LOAD_FUNC(l,lcmaps_term)					\
     && LCMAPS_LOAD_FUNC(l,lcmaps_account_info_clean)			\
    )	    

# else /* LCMAPS_USE_DLOPEN */

typedef void * _lcmaps_handle_return_account_from_pem_t;

#define _LCMAPS_DECL_HANDLE_RETURN_ACCOUNT_FROM_PEM(l)	\
    _lcmaps_handle_return_account_from_pem_t l = NULL;

#define _LCMAPS_INIT_HANDLE_RETURN_ACCOUNT_FROM_PEM(l) (*(l) = NULL)
#define _LCMAPS_LOAD_RETURN_ACCOUNT_FROM_PEM(l) (1)

# endif /* LCMAPS_USE_DLOPEN */

#endif /* _LCMAPS_RETURN_ACCOUNT_FROM_PEM_H */
