package latexDraw.ui.dialog;

import java.awt.*;

import javax.swing.*;
import javax.swing.border.CompoundBorder;
import javax.swing.border.EmptyBorder;
import javax.swing.border.TitledBorder;
import javax.swing.event.ChangeEvent;

import latexDraw.figures.Figure;
import latexDraw.figures.Line;
import latexDraw.lang.LaTeXDrawLang;
import latexDraw.ui.DrawPanel;
import latexDraw.util.LaTeXDrawPoint2D;

/** 
 * This class defines the frame which allows to change the parameters of lines.<br>
 *<br>
 * This file is part of LaTeXDraw<br>
 * Copyright (c) 2005-2008 Arnaud BLOUIN<br>
 *<br>
 *  LaTeXDraw is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.<br>
 *<br>
 *  LaTeXDraw is distributed without any warranty; without even the 
 *  implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
 *  PURPOSE. See the GNU General Public License for more details.<br>
 *<br>
 * 01/20/06<br>
 * @author Arnaud BLOUIN<br>
 * @version 2.0.0<br>
 */
public class ParametersLineFrame extends AbstractParametersFrame
{
	private static final long serialVersionUID = 1L;
	
	/** The left X-coordinates field */
	protected JSpinner leftXField;
	
	/** The left Y-coordinates field */
	protected JSpinner leftYField;
	
	/** The right X-coordinates field */
	protected JSpinner rightXField;
	
	/** The right Y-coordinates field */
	protected JSpinner rightYField;
	
	/** The label of the left X-coordinate choice */
	public static final String LABEL_LEFTX = "X left";//$NON-NLS-1$
	
	/** The label of the left Y-coordinate choice */
	public static final String LABEL_LEFTY = "Y left";//$NON-NLS-1$
	
	/** The label of the right X-coordinate choice */
	public static final String LABEL_RIGHTX = "X right";//$NON-NLS-1$
	
	/** The label of the right Y-coordinate choice */
	public static final String LABEL_RIGHTY = "Y right";//$NON-NLS-1$
	
	
	
	/**
	 * The constructor by default
	 */
	public ParametersLineFrame(Frame parent, DrawPanel p, boolean attachToMainFrame)
	{
		super(parent, p, attachToMainFrame);
		try
		{
	  		Dimension dim = Toolkit.getDefaultToolkit().getScreenSize();
	  		JPanel pButton  = createButtonsPanel(this);
	  		JTabbedPane tabbedPane = new JTabbedPane();
	  		JPanel pGeneral = new JPanel();
	  		pGeneral.setLayout(new BoxLayout(pGeneral, BoxLayout.Y_AXIS));
	  		JPanel coordP = new JPanel(new GridBagLayout());
	  		GridBagConstraints constraint = new GridBagConstraints();
	    	constraint.gridx = 0;
	     	constraint.gridy = 0;
	     	constraint.gridwidth = 1;
	     	constraint.gridheight = 1;
	     	constraint.weightx = 0.1;
	     	constraint.weighty = 0.1;
	     	constraint.fill = GridBagConstraints.NONE;
	     	constraint.anchor = GridBagConstraints.CENTER;
	     	coordP.add(new JLabel(LaTeXDrawLang.getDialogFrameString("ParametersLineFrame.0")) //$NON-NLS-1$
	     					, constraint);
	  		
	     	SpinnerModel model = new SpinnerNumberModel(0,0,10000,0.1);
	     	leftXField = new JSpinner(model);
	     	leftXField.setEditor(new JSpinner.NumberEditor(leftXField, "0.0"));//$NON-NLS-1$
	     	leftXField.addChangeListener(this);
	     	leftXField.setName(LABEL_LEFTX);
	     	constraint.gridx = 1;
	     	coordP.add(leftXField, constraint);
	  		
	    	constraint.gridx++;
	    	coordP.add(new JLabel(LaTeXDrawLang.getDialogFrameString("ParametersLineFrame.1")), constraint); //$NON-NLS-1$
	  		
	     	model = new SpinnerNumberModel(0,0,10000,0.1);
	     	leftYField = new JSpinner(model);
	     	leftYField.setEditor(new JSpinner.NumberEditor(leftYField, "0.0"));//$NON-NLS-1$
	     	leftYField.addChangeListener(this);
	     	leftYField.setName(LABEL_LEFTY);
	     	constraint.gridx++;
	     	coordP.add(leftYField, constraint);
	     	
	    	constraint.gridx = 0;	constraint.gridy++;
	    	coordP.add(new JLabel(LaTeXDrawLang.getDialogFrameString("ParametersLineFrame.2")), constraint); //$NON-NLS-1$
	  		
	     	model = new SpinnerNumberModel(0,0,10000,0.1);
	     	rightXField = new JSpinner(model);
	     	rightXField.setEditor(new JSpinner.NumberEditor(rightXField, "0.0"));//$NON-NLS-1$
	     	rightXField.addChangeListener(this);
	     	rightXField.setName(LABEL_RIGHTX);
	     	constraint.gridx++;	
	     	coordP.add(rightXField, constraint);
	     	
	    	constraint.gridx++;
	    	coordP.add(new JLabel(LaTeXDrawLang.getDialogFrameString("ParametersLineFrame.3")), constraint); //$NON-NLS-1$
	  		
	     	model = new SpinnerNumberModel(0,0,10000,0.1);
	     	rightYField = new JSpinner(model);
	     	rightYField.setEditor(new JSpinner.NumberEditor(rightYField, "0.0"));//$NON-NLS-1$
	     	rightYField.addChangeListener(this);
	     	rightYField.setName(LABEL_RIGHTY);
	     	constraint.gridx++;
	     	coordP.add(rightYField, constraint);
	     	
	     	constraint.gridx = 0;	constraint.gridy++;
	     	coordP.add(new JLabel(LABEL_ROTATION), constraint);
	     	constraint.gridx++;
	     	coordP.add(rotationField, constraint);
	     	
	     	coordP.setBorder(new CompoundBorder(new TitledBorder(null, LABEL_POSITION_DIMENSIONS, 
							  TitledBorder.LEFT, TitledBorder.TOP), new EmptyBorder(0,0,0,0)));
	     	
	     	pGeneral.add(coordP);
	     	pGeneral.add(createBordersPanel(false));
	     	pGeneral.add(createDoubleLinePanel());
	     	pGeneral.add(createShadowPanel());
	     	tabbedPane.add(LABEL_GENERAL, pGeneral);
	     	
	     	tabbedPane.addTab(TITLE_TABBED_PANE_GENERAL, pGeneral);
	     	tabbedPane.addTab(NAME_TABBEDPANE_ARROW, createArrowPanel(false, true));
	     	BoxLayout bl = new BoxLayout(getContentPane(), BoxLayout.Y_AXIS);
	     	getContentPane().setLayout(bl);
	     	getContentPane().add(glimpsePanelZoom);
	     	getContentPane().add(tabbedPane);
			getContentPane().add(pButton);
	  		pack();
	  		setLocation(dim.width/2-getWidth()/2, dim.height/2-getHeight()/2);
			setVisible(false);
		}
		catch(Exception e)
		{
			e.printStackTrace(); 
			ExceptionFrameDialog.showExceptionDialog(e);
		}
	}
	
	
	
	@Override
	public void setFigureFrameField()
	{
		Line l = (Line)figure;
		LaTeXDrawPoint2D pt1 = l.getPt1(), pt2 = l.getPt2();
		
		leftYField.setValue(pt1.y);
		rightYField.setValue(pt2.y);
		leftXField.setValue(pt1.x);
		rightXField.setValue(pt2.x);
	}

	
	
	@Override
	public void stateChanged(ChangeEvent e) 
	{
		try
		{
			Object o = e.getSource();
			Line l = (Line) glimpsePanel.getGlimpseFigure();
			
			if(o instanceof JSpinner)
			{
				String name = ((JSpinner)o).getName();
				LaTeXDrawPoint2D p1 = l.getPt1(), p2 = l.getPt2();
				
				if(name.equals(LABEL_LEFTX))
				{
					setModified(true);
					p1.x = Double.valueOf(leftXField.getValue().toString()).doubleValue();
					glimpsePanel.repaint();
					return ;
				}
				
				if(name.equals(LABEL_LEFTY))
				{
					setModified(true);
					p1.y = Double.valueOf(leftYField.getValue().toString()).doubleValue(); 
					glimpsePanel.repaint();
					return ;
				}
				
				if(name.equals(LABEL_RIGHTX))
				{
					setModified(true);
					p2.x = Double.valueOf(rightXField.getValue().toString()).doubleValue();
					glimpsePanel.repaint();
					return ;
				}
				
				if(name.equals(LABEL_RIGHTY))
				{
					setModified(true);
					p2.y = Double.valueOf(rightYField.getValue().toString()).doubleValue();
					glimpsePanel.repaint();
					return ;
				}
			}
		}catch(Exception ex)
		{
			ex.printStackTrace(); 
			ExceptionFrameDialog.showExceptionDialog(ex);
		}
		
		super.stateChanged(e);
	}
	
	
	
	@Override
	public void saveParameters()
	{
		Line l = (Line)figure;
		LaTeXDrawPoint2D p1 = l.getPt1(), p2 = l.getPt2();

		p1.x = Double.valueOf(leftXField.getValue().toString()).doubleValue();
		p2.x = Double.valueOf(rightXField.getValue().toString()).doubleValue();
		p1.y = Double.valueOf(leftYField.getValue().toString()).doubleValue();
		p2.y = Double.valueOf(rightYField.getValue().toString()).doubleValue();

		super.saveParameters();
	}
	
	
	
	@Override
	public void setVisible(boolean visible, Figure selected, boolean deleteOnCancel, boolean isFramedBox) 
	{
		try
		{
			if(!(selected instanceof Line))
				throw new ClassCastException();
			
			super.setVisible(visible, selected, deleteOnCancel, isFramedBox);
		}
		catch(Exception ex)
		{
			ex.printStackTrace(); 
			ExceptionFrameDialog.showExceptionDialog(ex);
		}	
	}
}
