/* -*- c++ -*- ----------------------------------------------------------
   LAMMPS - Large-scale Atomic/Molecular Massively Parallel Simulator
   https://www.lammps.org/, Sandia National Laboratories
   LAMMPS development team: developers@lammps.org

   Copyright (2003) Sandia Corporation.  Under the terms of Contract
   DE-AC04-94AL85000 with Sandia Corporation, the U.S. Government retains
   certain rights in this software.  This software is distributed under
   the GNU General Public License.

   See the README file in the top-level LAMMPS directory.
------------------------------------------------------------------------- */

#ifdef COMPUTE_CLASS
// clang-format off
ComputeStyle(fragment/atom,ComputeFragmentAtom);
// clang-format on
#else

#ifndef LMP_COMPUTE_FRAGMENT_ATOM_H
#define LMP_COMPUTE_FRAGMENT_ATOM_H

#include "compute.h"

namespace LAMMPS_NS {

class ComputeFragmentAtom : public Compute {
 public:
  ComputeFragmentAtom(class LAMMPS *, int, char **);
  ~ComputeFragmentAtom() override;
  void init() override;
  void compute_peratom() override;
  int pack_forward_comm(int, int *, double *, int, int *) override;
  void unpack_forward_comm(int, int, double *) override;
  double memory_usage() override;

 private:
  int nmax, commflag, singleflag;
  int *stack, *clist, *markflag;
  double *fragmentID;
};

}    // namespace LAMMPS_NS

#endif
#endif
