/***************************************************************************
 *   Copyright (C) 2008-2011 by Marcel Hasler                              *
 *   mahasler@gmail.com                                                    *
 *                                                                         *
 *   This file is part of KOSD.                                            *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation, either version 3 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the          *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program. If not, see <http://www.gnu.org/licenses/>.  *
 ***************************************************************************/

#ifndef KOSD_H
#define KOSD_H

#include "kosd_export.h"

#include <QString>
#include <QStringList>

class KOSD_EXPORT KOsd
{
public:
    static void showBattery(unsigned char percent, bool plugged);
    static void showBrightness(unsigned char percent);
    static void showVolume(unsigned char percent, bool muted);
    static void showCustom(const QString &svg, const QStringList &elements, const QString &text, unsigned char percent);
    static void showCustom(const QString &pixmap, const QString &text, unsigned char percent);
    static void parseConfiguration();

private:
    KOsd();
    ~KOsd();
};

#endif // KOSD_H
