/*
 *		Copyright (C) 2013, 2014, 2015 by the Konclude Developer Team.
 *
 *		This file is part of the reasoning system Konclude.
 *		For details and support, see <http://konclude.com/>.
 *
 *		Konclude is free software: you can redistribute it and/or modify it under
 *		the terms of version 2.1 of the GNU Lesser General Public License (LGPL2.1)
 *		as published by the Free Software Foundation.
 *
 *		You should have received a copy of the GNU Lesser General Public License
 *		along with Konclude. If not, see <http://www.gnu.org/licenses/>.
 *
 *		Konclude is distributed in the hope that it will be useful,
 *		but WITHOUT ANY WARRANTY; without even the implied warranty of
 *		MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. For more
 *		details, see GNU Lesser General Public License.
 *
 */

#include "CReasonerEvaluationStartEvent.h"


namespace Konclude {

	namespace Test {

		namespace Evaluation {

			namespace Events {


				CReasonerEvaluationStartEvent::CReasonerEvaluationStartEvent(const QString& initFile, const QString& testFile, const QString& addressString, CConfiguration* configuration, CCallbackData* callbackData) 
						: CCustomEvent(EVENTTYPE) {

					mInitFileString = initFile;
					mTestFileString = testFile;
					mAddressString = addressString;
					mConfiguration = configuration;
					mCallbackData = callbackData;
				}


				CReasonerEvaluationStartEvent::~CReasonerEvaluationStartEvent() {
				}

				QString CReasonerEvaluationStartEvent::getInitFileString() {
					return mInitFileString;
				}

				QString CReasonerEvaluationStartEvent::getTestFileString() {
					return mTestFileString;
				}

				CCallbackData* CReasonerEvaluationStartEvent::getCallback() {
					return mCallbackData;
				}

				QString CReasonerEvaluationStartEvent::getAddressString() {
					return mAddressString;
				}

				CConfiguration* CReasonerEvaluationStartEvent::getConfiguration() {
					return mConfiguration;
				}


			}; // end namespace Events

		}; // end namespace Evaluation

	}; // end namespace Test

}; // end namespace Konclude
