#ifndef DRW_CPTABLE936_H
#define DRW_CPTABLE936_H

//Chinese PRC GBK (XGB)

//first entry in this tables are 0x80
#define CPOFFSET936 0x80
#define CPLENGHT936 21791
#define NOTFOUND936 0x003F

//Table 949 one byte
static const int DRW_Table936[] = {
    0x20AC  //1 #EURO SIGN 0x80
//    0xF8F5  //2 #EURO SIGN 0x80
};

//Table 936
static const int DRW_LeadTable936[] = {
    0, //1#DBCS LEAD BYTE 0x81
    190, //2#DBCS LEAD BYTE 0x82
    380, //3#DBCS LEAD BYTE 0x83
    570, //4#DBCS LEAD BYTE 0x84
    760, //5#DBCS LEAD BYTE 0x85
    950, //6#DBCS LEAD BYTE 0x86
    1140, //7#DBCS LEAD BYTE 0x87
    1330, //8#DBCS LEAD BYTE 0x88
    1520, //9#DBCS LEAD BYTE 0x89
    1710, //10#DBCS LEAD BYTE 0x8A
    1900, //11#DBCS LEAD BYTE 0x8B
    2090, //12#DBCS LEAD BYTE 0x8C
    2280, //13#DBCS LEAD BYTE 0x8D
    2470, //14#DBCS LEAD BYTE 0x8E
    2660, //15#DBCS LEAD BYTE 0x8F
    2850, //16#DBCS LEAD BYTE 0x90
    3040, //17#DBCS LEAD BYTE 0x91
    3230, //18#DBCS LEAD BYTE 0x92
    3420, //19#DBCS LEAD BYTE 0x93
    3610, //20#DBCS LEAD BYTE 0x94
    3800, //21#DBCS LEAD BYTE 0x95
    3990, //22#DBCS LEAD BYTE 0x96
    4180, //23#DBCS LEAD BYTE 0x97
    4370, //24#DBCS LEAD BYTE 0x98
    4560, //25#DBCS LEAD BYTE 0x99
    4750, //26#DBCS LEAD BYTE 0x9A
    4940, //27#DBCS LEAD BYTE 0x9B
    5130, //28#DBCS LEAD BYTE 0x9C
    5320, //29#DBCS LEAD BYTE 0x9D
    5510, //30#DBCS LEAD BYTE 0x9E
    5700, //31#DBCS LEAD BYTE 0x9F
    5906, //32#DBCS LEAD BYTE 0xA0
    6080, //33#DBCS LEAD BYTE 0xA1
    6174, //34#DBCS LEAD BYTE 0xA2
    6256, //35#DBCS LEAD BYTE 0xA3
    6350, //36#DBCS LEAD BYTE 0xA4
    6433, //37#DBCS LEAD BYTE 0xA5
    6519, //38#DBCS LEAD BYTE 0xA6
    6586, //39#DBCS LEAD BYTE 0xA7
    6652, //40#DBCS LEAD BYTE 0xA8
    6804, //41#DBCS LEAD BYTE 0xA9
    6948, //42#DBCS LEAD BYTE 0xAA
    7044, //43#DBCS LEAD BYTE 0xAB
    7140, //44#DBCS LEAD BYTE 0xAC
    7236, //45#DBCS LEAD BYTE 0xAD
    7332, //46#DBCS LEAD BYTE 0xAE
    7428, //47#DBCS LEAD BYTE 0xAF
    7524, //48#DBCS LEAD BYTE 0xB0
    7714, //49#DBCS LEAD BYTE 0xB1
    7904, //50#DBCS LEAD BYTE 0xB2
    8094, //51#DBCS LEAD BYTE 0xB3
    8284, //52#DBCS LEAD BYTE 0xB4
    8474, //53#DBCS LEAD BYTE 0xB5
    8664, //54#DBCS LEAD BYTE 0xB6
    8854, //55#DBCS LEAD BYTE 0xB7
    9044, //56#DBCS LEAD BYTE 0xB8
    9224, //57#DBCS LEAD BYTE 0xB9
    9424, //58#DBCS LEAD BYTE 0xBA
    9614, //59#DBCS LEAD BYTE 0xBB
    9804, //60#DBCS LEAD BYTE 0xBC
    9994, //61#DBCS LEAD BYTE 0xBD
    10184, //62#DBCS LEAD BYTE 0xBE
    10374, //63#DBCS LEAD BYTE 0xBF
    10564, //64#DBCS LEAD BYTE 0xC0
    10754, //65#DBCS LEAD BYTE 0xC1
    10944, //66#DBCS LEAD BYTE 0xC2
    11134, //67#DBCS LEAD BYTE 0xC3
    11324, //68#DBCS LEAD BYTE 0xC4
    11514, //69#DBCS LEAD BYTE 0xC5
    11704, //70#DBCS LEAD BYTE 0xC6
    11894, //71#DBCS LEAD BYTE 0xC7
    12084, //72#DBCS LEAD BYTE 0xC8
    12274, //73#DBCS LEAD BYTE 0xC9
    12464, //74#DBCS LEAD BYTE 0xCA
    12654, //75#DBCS LEAD BYTE 0xCB
    12844, //76#DBCS LEAD BYTE 0xCC
    13034, //77#DBCS LEAD BYTE 0xCD
    13224, //78#DBCS LEAD BYTE 0xCE
    13414, //79#DBCS LEAD BYTE 0xCF
    13604, //80#DBCS LEAD BYTE 0xD0
    13794, //81#DBCS LEAD BYTE 0xD1
    13984, //82#DBCS LEAD BYTE 0xD2
    14174, //83#DBCS LEAD BYTE 0xD3
    14364, //84#DBCS LEAD BYTE 0xD4
    14554, //85#DBCS LEAD BYTE 0xD5
    14744, //86#DBCS LEAD BYTE 0xD6
    14934, //87#DBCS LEAD BYTE 0xD7
    15119, //88#DBCS LEAD BYTE 0xD8
    15309, //89#DBCS LEAD BYTE 0xD9
    15499, //90#DBCS LEAD BYTE 0xDA
    15689, //91#DBCS LEAD BYTE 0xDB
    15879, //92#DBCS LEAD BYTE 0xDC
    16069, //93#DBCS LEAD BYTE 0xDD
    16259, //94#DBCS LEAD BYTE 0xDE
    16449, //95#DBCS LEAD BYTE 0xDF
    16639, //96#DBCS LEAD BYTE 0xE0
    16829, //97#DBCS LEAD BYTE 0xE1
    17019, //98#DBCS LEAD BYTE 0xE2
    17209, //99#DBCS LEAD BYTE 0xE3
    17399, //100#DBCS LEAD BYTE 0xE4
    17589, //101#DBCS LEAD BYTE 0xE5
    17779, //102#DBCS LEAD BYTE 0xE6
    17969, //103#DBCS LEAD BYTE 0xE7
    18159, //104#DBCS LEAD BYTE 0xE8
    18349, //105#DBCS LEAD BYTE 0xE9
    18539, //106#DBCS LEAD BYTE 0xEA
    18729, //107#DBCS LEAD BYTE 0xEB
    18919, //108#DBCS LEAD BYTE 0xEC
    19109, //109#DBCS LEAD BYTE 0xED
    19299, //110#DBCS LEAD BYTE 0xEE
    19489, //111#DBCS LEAD BYTE 0xEF
    19679, //112#DBCS LEAD BYTE 0xF0
    19869, //113#DBCS LEAD BYTE 0xF1
    20059, //114#DBCS LEAD BYTE 0xF2
    20249, //115#DBCS LEAD BYTE 0xF3
    20439, //116#DBCS LEAD BYTE 0xF4
    20659, //117#DBCS LEAD BYTE 0xF5
    20819, //118#DBCS LEAD BYTE 0xF6
    21009, //119#DBCS LEAD BYTE 0xF7
    21199, //120#DBCS LEAD BYTE 0xF8
    21295, //121#DBCS LEAD BYTE 0xF9
    21391, //122#DBCS LEAD BYTE 0xFA
    21487, //123#DBCS LEAD BYTE 0xFB
    21583, //124#DBCS LEAD BYTE 0xFC
    21679, //125#DBCS LEAD BYTE 0xFD
    21775, //126#DBCS LEAD BYTE 0xFE
    21791, //127#UNDEFINED 0xFF, END OF TABLE
};

//Table 936 tail byte
static const int DRW_DoubleTable936[][2] = {
    {0x8140, 0x4E02}, //1 #CJK UNIFIED IDEOGRAPH
    {0x8141, 0x4E04}, //2 #CJK UNIFIED IDEOGRAPH
    {0x8142, 0x4E05}, //3 #CJK UNIFIED IDEOGRAPH
    {0x8143, 0x4E06}, //4 #CJK UNIFIED IDEOGRAPH
    {0x8144, 0x4E0F}, //5 #CJK UNIFIED IDEOGRAPH
    {0x8145, 0x4E12}, //6 #CJK UNIFIED IDEOGRAPH
    {0x8146, 0x4E17}, //7 #CJK UNIFIED IDEOGRAPH
    {0x8147, 0x4E1F}, //8 #CJK UNIFIED IDEOGRAPH
    {0x8148, 0x4E20}, //9 #CJK UNIFIED IDEOGRAPH
    {0x8149, 0x4E21}, //10 #CJK UNIFIED IDEOGRAPH
    {0x814A, 0x4E23}, //11 #CJK UNIFIED IDEOGRAPH
    {0x814B, 0x4E26}, //12 #CJK UNIFIED IDEOGRAPH
    {0x814C, 0x4E29}, //13 #CJK UNIFIED IDEOGRAPH
    {0x814D, 0x4E2E}, //14 #CJK UNIFIED IDEOGRAPH
    {0x814E, 0x4E2F}, //15 #CJK UNIFIED IDEOGRAPH
    {0x814F, 0x4E31}, //16 #CJK UNIFIED IDEOGRAPH
    {0x8150, 0x4E33}, //17 #CJK UNIFIED IDEOGRAPH
    {0x8151, 0x4E35}, //18 #CJK UNIFIED IDEOGRAPH
    {0x8152, 0x4E37}, //19 #CJK UNIFIED IDEOGRAPH
    {0x8153, 0x4E3C}, //20 #CJK UNIFIED IDEOGRAPH
    {0x8154, 0x4E40}, //21 #CJK UNIFIED IDEOGRAPH
    {0x8155, 0x4E41}, //22 #CJK UNIFIED IDEOGRAPH
    {0x8156, 0x4E42}, //23 #CJK UNIFIED IDEOGRAPH
    {0x8157, 0x4E44}, //24 #CJK UNIFIED IDEOGRAPH
    {0x8158, 0x4E46}, //25 #CJK UNIFIED IDEOGRAPH
    {0x8159, 0x4E4A}, //26 #CJK UNIFIED IDEOGRAPH
    {0x815A, 0x4E51}, //27 #CJK UNIFIED IDEOGRAPH
    {0x815B, 0x4E55}, //28 #CJK UNIFIED IDEOGRAPH
    {0x815C, 0x4E57}, //29 #CJK UNIFIED IDEOGRAPH
    {0x815D, 0x4E5A}, //30 #CJK UNIFIED IDEOGRAPH
    {0x815E, 0x4E5B}, //31 #CJK UNIFIED IDEOGRAPH
    {0x815F, 0x4E62}, //32 #CJK UNIFIED IDEOGRAPH
    {0x8160, 0x4E63}, //33 #CJK UNIFIED IDEOGRAPH
    {0x8161, 0x4E64}, //34 #CJK UNIFIED IDEOGRAPH
    {0x8162, 0x4E65}, //35 #CJK UNIFIED IDEOGRAPH
    {0x8163, 0x4E67}, //36 #CJK UNIFIED IDEOGRAPH
    {0x8164, 0x4E68}, //37 #CJK UNIFIED IDEOGRAPH
    {0x8165, 0x4E6A}, //38 #CJK UNIFIED IDEOGRAPH
    {0x8166, 0x4E6B}, //39 #CJK UNIFIED IDEOGRAPH
    {0x8167, 0x4E6C}, //40 #CJK UNIFIED IDEOGRAPH
    {0x8168, 0x4E6D}, //41 #CJK UNIFIED IDEOGRAPH
    {0x8169, 0x4E6E}, //42 #CJK UNIFIED IDEOGRAPH
    {0x816A, 0x4E6F}, //43 #CJK UNIFIED IDEOGRAPH
    {0x816B, 0x4E72}, //44 #CJK UNIFIED IDEOGRAPH
    {0x816C, 0x4E74}, //45 #CJK UNIFIED IDEOGRAPH
    {0x816D, 0x4E75}, //46 #CJK UNIFIED IDEOGRAPH
    {0x816E, 0x4E76}, //47 #CJK UNIFIED IDEOGRAPH
    {0x816F, 0x4E77}, //48 #CJK UNIFIED IDEOGRAPH
    {0x8170, 0x4E78}, //49 #CJK UNIFIED IDEOGRAPH
    {0x8171, 0x4E79}, //50 #CJK UNIFIED IDEOGRAPH
    {0x8172, 0x4E7A}, //51 #CJK UNIFIED IDEOGRAPH
    {0x8173, 0x4E7B}, //52 #CJK UNIFIED IDEOGRAPH
    {0x8174, 0x4E7C}, //53 #CJK UNIFIED IDEOGRAPH
    {0x8175, 0x4E7D}, //54 #CJK UNIFIED IDEOGRAPH
    {0x8176, 0x4E7F}, //55 #CJK UNIFIED IDEOGRAPH
    {0x8177, 0x4E80}, //56 #CJK UNIFIED IDEOGRAPH
    {0x8178, 0x4E81}, //57 #CJK UNIFIED IDEOGRAPH
    {0x8179, 0x4E82}, //58 #CJK UNIFIED IDEOGRAPH
    {0x817A, 0x4E83}, //59 #CJK UNIFIED IDEOGRAPH
    {0x817B, 0x4E84}, //60 #CJK UNIFIED IDEOGRAPH
    {0x817C, 0x4E85}, //61 #CJK UNIFIED IDEOGRAPH
    {0x817D, 0x4E87}, //62 #CJK UNIFIED IDEOGRAPH
    {0x817E, 0x4E8A}, //63 #CJK UNIFIED IDEOGRAPH
    {0x8180, 0x4E90}, //64 #CJK UNIFIED IDEOGRAPH
    {0x8181, 0x4E96}, //65 #CJK UNIFIED IDEOGRAPH
    {0x8182, 0x4E97}, //66 #CJK UNIFIED IDEOGRAPH
    {0x8183, 0x4E99}, //67 #CJK UNIFIED IDEOGRAPH
    {0x8184, 0x4E9C}, //68 #CJK UNIFIED IDEOGRAPH
    {0x8185, 0x4E9D}, //69 #CJK UNIFIED IDEOGRAPH
    {0x8186, 0x4E9E}, //70 #CJK UNIFIED IDEOGRAPH
    {0x8187, 0x4EA3}, //71 #CJK UNIFIED IDEOGRAPH
    {0x8188, 0x4EAA}, //72 #CJK UNIFIED IDEOGRAPH
    {0x8189, 0x4EAF}, //73 #CJK UNIFIED IDEOGRAPH
    {0x818A, 0x4EB0}, //74 #CJK UNIFIED IDEOGRAPH
    {0x818B, 0x4EB1}, //75 #CJK UNIFIED IDEOGRAPH
    {0x818C, 0x4EB4}, //76 #CJK UNIFIED IDEOGRAPH
    {0x818D, 0x4EB6}, //77 #CJK UNIFIED IDEOGRAPH
    {0x818E, 0x4EB7}, //78 #CJK UNIFIED IDEOGRAPH
    {0x818F, 0x4EB8}, //79 #CJK UNIFIED IDEOGRAPH
    {0x8190, 0x4EB9}, //80 #CJK UNIFIED IDEOGRAPH
    {0x8191, 0x4EBC}, //81 #CJK UNIFIED IDEOGRAPH
    {0x8192, 0x4EBD}, //82 #CJK UNIFIED IDEOGRAPH
    {0x8193, 0x4EBE}, //83 #CJK UNIFIED IDEOGRAPH
    {0x8194, 0x4EC8}, //84 #CJK UNIFIED IDEOGRAPH
    {0x8195, 0x4ECC}, //85 #CJK UNIFIED IDEOGRAPH
    {0x8196, 0x4ECF}, //86 #CJK UNIFIED IDEOGRAPH
    {0x8197, 0x4ED0}, //87 #CJK UNIFIED IDEOGRAPH
    {0x8198, 0x4ED2}, //88 #CJK UNIFIED IDEOGRAPH
    {0x8199, 0x4EDA}, //89 #CJK UNIFIED IDEOGRAPH
    {0x819A, 0x4EDB}, //90 #CJK UNIFIED IDEOGRAPH
    {0x819B, 0x4EDC}, //91 #CJK UNIFIED IDEOGRAPH
    {0x819C, 0x4EE0}, //92 #CJK UNIFIED IDEOGRAPH
    {0x819D, 0x4EE2}, //93 #CJK UNIFIED IDEOGRAPH
    {0x819E, 0x4EE6}, //94 #CJK UNIFIED IDEOGRAPH
    {0x819F, 0x4EE7}, //95 #CJK UNIFIED IDEOGRAPH
    {0x81A0, 0x4EE9}, //96 #CJK UNIFIED IDEOGRAPH
    {0x81A1, 0x4EED}, //97 #CJK UNIFIED IDEOGRAPH
    {0x81A2, 0x4EEE}, //98 #CJK UNIFIED IDEOGRAPH
    {0x81A3, 0x4EEF}, //99 #CJK UNIFIED IDEOGRAPH
    {0x81A4, 0x4EF1}, //100 #CJK UNIFIED IDEOGRAPH
    {0x81A5, 0x4EF4}, //101 #CJK UNIFIED IDEOGRAPH
    {0x81A6, 0x4EF8}, //102 #CJK UNIFIED IDEOGRAPH
    {0x81A7, 0x4EF9}, //103 #CJK UNIFIED IDEOGRAPH
    {0x81A8, 0x4EFA}, //104 #CJK UNIFIED IDEOGRAPH
    {0x81A9, 0x4EFC}, //105 #CJK UNIFIED IDEOGRAPH
    {0x81AA, 0x4EFE}, //106 #CJK UNIFIED IDEOGRAPH
    {0x81AB, 0x4F00}, //107 #CJK UNIFIED IDEOGRAPH
    {0x81AC, 0x4F02}, //108 #CJK UNIFIED IDEOGRAPH
    {0x81AD, 0x4F03}, //109 #CJK UNIFIED IDEOGRAPH
    {0x81AE, 0x4F04}, //110 #CJK UNIFIED IDEOGRAPH
    {0x81AF, 0x4F05}, //111 #CJK UNIFIED IDEOGRAPH
    {0x81B0, 0x4F06}, //112 #CJK UNIFIED IDEOGRAPH
    {0x81B1, 0x4F07}, //113 #CJK UNIFIED IDEOGRAPH
    {0x81B2, 0x4F08}, //114 #CJK UNIFIED IDEOGRAPH
    {0x81B3, 0x4F0B}, //115 #CJK UNIFIED IDEOGRAPH
    {0x81B4, 0x4F0C}, //116 #CJK UNIFIED IDEOGRAPH
    {0x81B5, 0x4F12}, //117 #CJK UNIFIED IDEOGRAPH
    {0x81B6, 0x4F13}, //118 #CJK UNIFIED IDEOGRAPH
    {0x81B7, 0x4F14}, //119 #CJK UNIFIED IDEOGRAPH
    {0x81B8, 0x4F15}, //120 #CJK UNIFIED IDEOGRAPH
    {0x81B9, 0x4F16}, //121 #CJK UNIFIED IDEOGRAPH
    {0x81BA, 0x4F1C}, //122 #CJK UNIFIED IDEOGRAPH
    {0x81BB, 0x4F1D}, //123 #CJK UNIFIED IDEOGRAPH
    {0x81BC, 0x4F21}, //124 #CJK UNIFIED IDEOGRAPH
    {0x81BD, 0x4F23}, //125 #CJK UNIFIED IDEOGRAPH
    {0x81BE, 0x4F28}, //126 #CJK UNIFIED IDEOGRAPH
    {0x81BF, 0x4F29}, //127 #CJK UNIFIED IDEOGRAPH
    {0x81C0, 0x4F2C}, //128 #CJK UNIFIED IDEOGRAPH
    {0x81C1, 0x4F2D}, //129 #CJK UNIFIED IDEOGRAPH
    {0x81C2, 0x4F2E}, //130 #CJK UNIFIED IDEOGRAPH
    {0x81C3, 0x4F31}, //131 #CJK UNIFIED IDEOGRAPH
    {0x81C4, 0x4F33}, //132 #CJK UNIFIED IDEOGRAPH
    {0x81C5, 0x4F35}, //133 #CJK UNIFIED IDEOGRAPH
    {0x81C6, 0x4F37}, //134 #CJK UNIFIED IDEOGRAPH
    {0x81C7, 0x4F39}, //135 #CJK UNIFIED IDEOGRAPH
    {0x81C8, 0x4F3B}, //136 #CJK UNIFIED IDEOGRAPH
    {0x81C9, 0x4F3E}, //137 #CJK UNIFIED IDEOGRAPH
    {0x81CA, 0x4F3F}, //138 #CJK UNIFIED IDEOGRAPH
    {0x81CB, 0x4F40}, //139 #CJK UNIFIED IDEOGRAPH
    {0x81CC, 0x4F41}, //140 #CJK UNIFIED IDEOGRAPH
    {0x81CD, 0x4F42}, //141 #CJK UNIFIED IDEOGRAPH
    {0x81CE, 0x4F44}, //142 #CJK UNIFIED IDEOGRAPH
    {0x81CF, 0x4F45}, //143 #CJK UNIFIED IDEOGRAPH
    {0x81D0, 0x4F47}, //144 #CJK UNIFIED IDEOGRAPH
    {0x81D1, 0x4F48}, //145 #CJK UNIFIED IDEOGRAPH
    {0x81D2, 0x4F49}, //146 #CJK UNIFIED IDEOGRAPH
    {0x81D3, 0x4F4A}, //147 #CJK UNIFIED IDEOGRAPH
    {0x81D4, 0x4F4B}, //148 #CJK UNIFIED IDEOGRAPH
    {0x81D5, 0x4F4C}, //149 #CJK UNIFIED IDEOGRAPH
    {0x81D6, 0x4F52}, //150 #CJK UNIFIED IDEOGRAPH
    {0x81D7, 0x4F54}, //151 #CJK UNIFIED IDEOGRAPH
    {0x81D8, 0x4F56}, //152 #CJK UNIFIED IDEOGRAPH
    {0x81D9, 0x4F61}, //153 #CJK UNIFIED IDEOGRAPH
    {0x81DA, 0x4F62}, //154 #CJK UNIFIED IDEOGRAPH
    {0x81DB, 0x4F66}, //155 #CJK UNIFIED IDEOGRAPH
    {0x81DC, 0x4F68}, //156 #CJK UNIFIED IDEOGRAPH
    {0x81DD, 0x4F6A}, //157 #CJK UNIFIED IDEOGRAPH
    {0x81DE, 0x4F6B}, //158 #CJK UNIFIED IDEOGRAPH
    {0x81DF, 0x4F6D}, //159 #CJK UNIFIED IDEOGRAPH
    {0x81E0, 0x4F6E}, //160 #CJK UNIFIED IDEOGRAPH
    {0x81E1, 0x4F71}, //161 #CJK UNIFIED IDEOGRAPH
    {0x81E2, 0x4F72}, //162 #CJK UNIFIED IDEOGRAPH
    {0x81E3, 0x4F75}, //163 #CJK UNIFIED IDEOGRAPH
    {0x81E4, 0x4F77}, //164 #CJK UNIFIED IDEOGRAPH
    {0x81E5, 0x4F78}, //165 #CJK UNIFIED IDEOGRAPH
    {0x81E6, 0x4F79}, //166 #CJK UNIFIED IDEOGRAPH
    {0x81E7, 0x4F7A}, //167 #CJK UNIFIED IDEOGRAPH
    {0x81E8, 0x4F7D}, //168 #CJK UNIFIED IDEOGRAPH
    {0x81E9, 0x4F80}, //169 #CJK UNIFIED IDEOGRAPH
    {0x81EA, 0x4F81}, //170 #CJK UNIFIED IDEOGRAPH
    {0x81EB, 0x4F82}, //171 #CJK UNIFIED IDEOGRAPH
    {0x81EC, 0x4F85}, //172 #CJK UNIFIED IDEOGRAPH
    {0x81ED, 0x4F86}, //173 #CJK UNIFIED IDEOGRAPH
    {0x81EE, 0x4F87}, //174 #CJK UNIFIED IDEOGRAPH
    {0x81EF, 0x4F8A}, //175 #CJK UNIFIED IDEOGRAPH
    {0x81F0, 0x4F8C}, //176 #CJK UNIFIED IDEOGRAPH
    {0x81F1, 0x4F8E}, //177 #CJK UNIFIED IDEOGRAPH
    {0x81F2, 0x4F90}, //178 #CJK UNIFIED IDEOGRAPH
    {0x81F3, 0x4F92}, //179 #CJK UNIFIED IDEOGRAPH
    {0x81F4, 0x4F93}, //180 #CJK UNIFIED IDEOGRAPH
    {0x81F5, 0x4F95}, //181 #CJK UNIFIED IDEOGRAPH
    {0x81F6, 0x4F96}, //182 #CJK UNIFIED IDEOGRAPH
    {0x81F7, 0x4F98}, //183 #CJK UNIFIED IDEOGRAPH
    {0x81F8, 0x4F99}, //184 #CJK UNIFIED IDEOGRAPH
    {0x81F9, 0x4F9A}, //185 #CJK UNIFIED IDEOGRAPH
    {0x81FA, 0x4F9C}, //186 #CJK UNIFIED IDEOGRAPH
    {0x81FB, 0x4F9E}, //187 #CJK UNIFIED IDEOGRAPH
    {0x81FC, 0x4F9F}, //188 #CJK UNIFIED IDEOGRAPH
    {0x81FD, 0x4FA1}, //189 #CJK UNIFIED IDEOGRAPH
    {0x81FE, 0x4FA2}, //190 #CJK UNIFIED IDEOGRAPH
    {0x8240, 0x4FA4}, //191 #CJK UNIFIED IDEOGRAPH
    {0x8241, 0x4FAB}, //192 #CJK UNIFIED IDEOGRAPH
    {0x8242, 0x4FAD}, //193 #CJK UNIFIED IDEOGRAPH
    {0x8243, 0x4FB0}, //194 #CJK UNIFIED IDEOGRAPH
    {0x8244, 0x4FB1}, //195 #CJK UNIFIED IDEOGRAPH
    {0x8245, 0x4FB2}, //196 #CJK UNIFIED IDEOGRAPH
    {0x8246, 0x4FB3}, //197 #CJK UNIFIED IDEOGRAPH
    {0x8247, 0x4FB4}, //198 #CJK UNIFIED IDEOGRAPH
    {0x8248, 0x4FB6}, //199 #CJK UNIFIED IDEOGRAPH
    {0x8249, 0x4FB7}, //200 #CJK UNIFIED IDEOGRAPH
    {0x824A, 0x4FB8}, //201 #CJK UNIFIED IDEOGRAPH
    {0x824B, 0x4FB9}, //202 #CJK UNIFIED IDEOGRAPH
    {0x824C, 0x4FBA}, //203 #CJK UNIFIED IDEOGRAPH
    {0x824D, 0x4FBB}, //204 #CJK UNIFIED IDEOGRAPH
    {0x824E, 0x4FBC}, //205 #CJK UNIFIED IDEOGRAPH
    {0x824F, 0x4FBD}, //206 #CJK UNIFIED IDEOGRAPH
    {0x8250, 0x4FBE}, //207 #CJK UNIFIED IDEOGRAPH
    {0x8251, 0x4FC0}, //208 #CJK UNIFIED IDEOGRAPH
    {0x8252, 0x4FC1}, //209 #CJK UNIFIED IDEOGRAPH
    {0x8253, 0x4FC2}, //210 #CJK UNIFIED IDEOGRAPH
    {0x8254, 0x4FC6}, //211 #CJK UNIFIED IDEOGRAPH
    {0x8255, 0x4FC7}, //212 #CJK UNIFIED IDEOGRAPH
    {0x8256, 0x4FC8}, //213 #CJK UNIFIED IDEOGRAPH
    {0x8257, 0x4FC9}, //214 #CJK UNIFIED IDEOGRAPH
    {0x8258, 0x4FCB}, //215 #CJK UNIFIED IDEOGRAPH
    {0x8259, 0x4FCC}, //216 #CJK UNIFIED IDEOGRAPH
    {0x825A, 0x4FCD}, //217 #CJK UNIFIED IDEOGRAPH
    {0x825B, 0x4FD2}, //218 #CJK UNIFIED IDEOGRAPH
    {0x825C, 0x4FD3}, //219 #CJK UNIFIED IDEOGRAPH
    {0x825D, 0x4FD4}, //220 #CJK UNIFIED IDEOGRAPH
    {0x825E, 0x4FD5}, //221 #CJK UNIFIED IDEOGRAPH
    {0x825F, 0x4FD6}, //222 #CJK UNIFIED IDEOGRAPH
    {0x8260, 0x4FD9}, //223 #CJK UNIFIED IDEOGRAPH
    {0x8261, 0x4FDB}, //224 #CJK UNIFIED IDEOGRAPH
    {0x8262, 0x4FE0}, //225 #CJK UNIFIED IDEOGRAPH
    {0x8263, 0x4FE2}, //226 #CJK UNIFIED IDEOGRAPH
    {0x8264, 0x4FE4}, //227 #CJK UNIFIED IDEOGRAPH
    {0x8265, 0x4FE5}, //228 #CJK UNIFIED IDEOGRAPH
    {0x8266, 0x4FE7}, //229 #CJK UNIFIED IDEOGRAPH
    {0x8267, 0x4FEB}, //230 #CJK UNIFIED IDEOGRAPH
    {0x8268, 0x4FEC}, //231 #CJK UNIFIED IDEOGRAPH
    {0x8269, 0x4FF0}, //232 #CJK UNIFIED IDEOGRAPH
    {0x826A, 0x4FF2}, //233 #CJK UNIFIED IDEOGRAPH
    {0x826B, 0x4FF4}, //234 #CJK UNIFIED IDEOGRAPH
    {0x826C, 0x4FF5}, //235 #CJK UNIFIED IDEOGRAPH
    {0x826D, 0x4FF6}, //236 #CJK UNIFIED IDEOGRAPH
    {0x826E, 0x4FF7}, //237 #CJK UNIFIED IDEOGRAPH
    {0x826F, 0x4FF9}, //238 #CJK UNIFIED IDEOGRAPH
    {0x8270, 0x4FFB}, //239 #CJK UNIFIED IDEOGRAPH
    {0x8271, 0x4FFC}, //240 #CJK UNIFIED IDEOGRAPH
    {0x8272, 0x4FFD}, //241 #CJK UNIFIED IDEOGRAPH
    {0x8273, 0x4FFF}, //242 #CJK UNIFIED IDEOGRAPH
    {0x8274, 0x5000}, //243 #CJK UNIFIED IDEOGRAPH
    {0x8275, 0x5001}, //244 #CJK UNIFIED IDEOGRAPH
    {0x8276, 0x5002}, //245 #CJK UNIFIED IDEOGRAPH
    {0x8277, 0x5003}, //246 #CJK UNIFIED IDEOGRAPH
    {0x8278, 0x5004}, //247 #CJK UNIFIED IDEOGRAPH
    {0x8279, 0x5005}, //248 #CJK UNIFIED IDEOGRAPH
    {0x827A, 0x5006}, //249 #CJK UNIFIED IDEOGRAPH
    {0x827B, 0x5007}, //250 #CJK UNIFIED IDEOGRAPH
    {0x827C, 0x5008}, //251 #CJK UNIFIED IDEOGRAPH
    {0x827D, 0x5009}, //252 #CJK UNIFIED IDEOGRAPH
    {0x827E, 0x500A}, //253 #CJK UNIFIED IDEOGRAPH
    {0x8280, 0x500B}, //254 #CJK UNIFIED IDEOGRAPH
    {0x8281, 0x500E}, //255 #CJK UNIFIED IDEOGRAPH
    {0x8282, 0x5010}, //256 #CJK UNIFIED IDEOGRAPH
    {0x8283, 0x5011}, //257 #CJK UNIFIED IDEOGRAPH
    {0x8284, 0x5013}, //258 #CJK UNIFIED IDEOGRAPH
    {0x8285, 0x5015}, //259 #CJK UNIFIED IDEOGRAPH
    {0x8286, 0x5016}, //260 #CJK UNIFIED IDEOGRAPH
    {0x8287, 0x5017}, //261 #CJK UNIFIED IDEOGRAPH
    {0x8288, 0x501B}, //262 #CJK UNIFIED IDEOGRAPH
    {0x8289, 0x501D}, //263 #CJK UNIFIED IDEOGRAPH
    {0x828A, 0x501E}, //264 #CJK UNIFIED IDEOGRAPH
    {0x828B, 0x5020}, //265 #CJK UNIFIED IDEOGRAPH
    {0x828C, 0x5022}, //266 #CJK UNIFIED IDEOGRAPH
    {0x828D, 0x5023}, //267 #CJK UNIFIED IDEOGRAPH
    {0x828E, 0x5024}, //268 #CJK UNIFIED IDEOGRAPH
    {0x828F, 0x5027}, //269 #CJK UNIFIED IDEOGRAPH
    {0x8290, 0x502B}, //270 #CJK UNIFIED IDEOGRAPH
    {0x8291, 0x502F}, //271 #CJK UNIFIED IDEOGRAPH
    {0x8292, 0x5030}, //272 #CJK UNIFIED IDEOGRAPH
    {0x8293, 0x5031}, //273 #CJK UNIFIED IDEOGRAPH
    {0x8294, 0x5032}, //274 #CJK UNIFIED IDEOGRAPH
    {0x8295, 0x5033}, //275 #CJK UNIFIED IDEOGRAPH
    {0x8296, 0x5034}, //276 #CJK UNIFIED IDEOGRAPH
    {0x8297, 0x5035}, //277 #CJK UNIFIED IDEOGRAPH
    {0x8298, 0x5036}, //278 #CJK UNIFIED IDEOGRAPH
    {0x8299, 0x5037}, //279 #CJK UNIFIED IDEOGRAPH
    {0x829A, 0x5038}, //280 #CJK UNIFIED IDEOGRAPH
    {0x829B, 0x5039}, //281 #CJK UNIFIED IDEOGRAPH
    {0x829C, 0x503B}, //282 #CJK UNIFIED IDEOGRAPH
    {0x829D, 0x503D}, //283 #CJK UNIFIED IDEOGRAPH
    {0x829E, 0x503F}, //284 #CJK UNIFIED IDEOGRAPH
    {0x829F, 0x5040}, //285 #CJK UNIFIED IDEOGRAPH
    {0x82A0, 0x5041}, //286 #CJK UNIFIED IDEOGRAPH
    {0x82A1, 0x5042}, //287 #CJK UNIFIED IDEOGRAPH
    {0x82A2, 0x5044}, //288 #CJK UNIFIED IDEOGRAPH
    {0x82A3, 0x5045}, //289 #CJK UNIFIED IDEOGRAPH
    {0x82A4, 0x5046}, //290 #CJK UNIFIED IDEOGRAPH
    {0x82A5, 0x5049}, //291 #CJK UNIFIED IDEOGRAPH
    {0x82A6, 0x504A}, //292 #CJK UNIFIED IDEOGRAPH
    {0x82A7, 0x504B}, //293 #CJK UNIFIED IDEOGRAPH
    {0x82A8, 0x504D}, //294 #CJK UNIFIED IDEOGRAPH
    {0x82A9, 0x5050}, //295 #CJK UNIFIED IDEOGRAPH
    {0x82AA, 0x5051}, //296 #CJK UNIFIED IDEOGRAPH
    {0x82AB, 0x5052}, //297 #CJK UNIFIED IDEOGRAPH
    {0x82AC, 0x5053}, //298 #CJK UNIFIED IDEOGRAPH
    {0x82AD, 0x5054}, //299 #CJK UNIFIED IDEOGRAPH
    {0x82AE, 0x5056}, //300 #CJK UNIFIED IDEOGRAPH
    {0x82AF, 0x5057}, //301 #CJK UNIFIED IDEOGRAPH
    {0x82B0, 0x5058}, //302 #CJK UNIFIED IDEOGRAPH
    {0x82B1, 0x5059}, //303 #CJK UNIFIED IDEOGRAPH
    {0x82B2, 0x505B}, //304 #CJK UNIFIED IDEOGRAPH
    {0x82B3, 0x505D}, //305 #CJK UNIFIED IDEOGRAPH
    {0x82B4, 0x505E}, //306 #CJK UNIFIED IDEOGRAPH
    {0x82B5, 0x505F}, //307 #CJK UNIFIED IDEOGRAPH
    {0x82B6, 0x5060}, //308 #CJK UNIFIED IDEOGRAPH
    {0x82B7, 0x5061}, //309 #CJK UNIFIED IDEOGRAPH
    {0x82B8, 0x5062}, //310 #CJK UNIFIED IDEOGRAPH
    {0x82B9, 0x5063}, //311 #CJK UNIFIED IDEOGRAPH
    {0x82BA, 0x5064}, //312 #CJK UNIFIED IDEOGRAPH
    {0x82BB, 0x5066}, //313 #CJK UNIFIED IDEOGRAPH
    {0x82BC, 0x5067}, //314 #CJK UNIFIED IDEOGRAPH
    {0x82BD, 0x5068}, //315 #CJK UNIFIED IDEOGRAPH
    {0x82BE, 0x5069}, //316 #CJK UNIFIED IDEOGRAPH
    {0x82BF, 0x506A}, //317 #CJK UNIFIED IDEOGRAPH
    {0x82C0, 0x506B}, //318 #CJK UNIFIED IDEOGRAPH
    {0x82C1, 0x506D}, //319 #CJK UNIFIED IDEOGRAPH
    {0x82C2, 0x506E}, //320 #CJK UNIFIED IDEOGRAPH
    {0x82C3, 0x506F}, //321 #CJK UNIFIED IDEOGRAPH
    {0x82C4, 0x5070}, //322 #CJK UNIFIED IDEOGRAPH
    {0x82C5, 0x5071}, //323 #CJK UNIFIED IDEOGRAPH
    {0x82C6, 0x5072}, //324 #CJK UNIFIED IDEOGRAPH
    {0x82C7, 0x5073}, //325 #CJK UNIFIED IDEOGRAPH
    {0x82C8, 0x5074}, //326 #CJK UNIFIED IDEOGRAPH
    {0x82C9, 0x5075}, //327 #CJK UNIFIED IDEOGRAPH
    {0x82CA, 0x5078}, //328 #CJK UNIFIED IDEOGRAPH
    {0x82CB, 0x5079}, //329 #CJK UNIFIED IDEOGRAPH
    {0x82CC, 0x507A}, //330 #CJK UNIFIED IDEOGRAPH
    {0x82CD, 0x507C}, //331 #CJK UNIFIED IDEOGRAPH
    {0x82CE, 0x507D}, //332 #CJK UNIFIED IDEOGRAPH
    {0x82CF, 0x5081}, //333 #CJK UNIFIED IDEOGRAPH
    {0x82D0, 0x5082}, //334 #CJK UNIFIED IDEOGRAPH
    {0x82D1, 0x5083}, //335 #CJK UNIFIED IDEOGRAPH
    {0x82D2, 0x5084}, //336 #CJK UNIFIED IDEOGRAPH
    {0x82D3, 0x5086}, //337 #CJK UNIFIED IDEOGRAPH
    {0x82D4, 0x5087}, //338 #CJK UNIFIED IDEOGRAPH
    {0x82D5, 0x5089}, //339 #CJK UNIFIED IDEOGRAPH
    {0x82D6, 0x508A}, //340 #CJK UNIFIED IDEOGRAPH
    {0x82D7, 0x508B}, //341 #CJK UNIFIED IDEOGRAPH
    {0x82D8, 0x508C}, //342 #CJK UNIFIED IDEOGRAPH
    {0x82D9, 0x508E}, //343 #CJK UNIFIED IDEOGRAPH
    {0x82DA, 0x508F}, //344 #CJK UNIFIED IDEOGRAPH
    {0x82DB, 0x5090}, //345 #CJK UNIFIED IDEOGRAPH
    {0x82DC, 0x5091}, //346 #CJK UNIFIED IDEOGRAPH
    {0x82DD, 0x5092}, //347 #CJK UNIFIED IDEOGRAPH
    {0x82DE, 0x5093}, //348 #CJK UNIFIED IDEOGRAPH
    {0x82DF, 0x5094}, //349 #CJK UNIFIED IDEOGRAPH
    {0x82E0, 0x5095}, //350 #CJK UNIFIED IDEOGRAPH
    {0x82E1, 0x5096}, //351 #CJK UNIFIED IDEOGRAPH
    {0x82E2, 0x5097}, //352 #CJK UNIFIED IDEOGRAPH
    {0x82E3, 0x5098}, //353 #CJK UNIFIED IDEOGRAPH
    {0x82E4, 0x5099}, //354 #CJK UNIFIED IDEOGRAPH
    {0x82E5, 0x509A}, //355 #CJK UNIFIED IDEOGRAPH
    {0x82E6, 0x509B}, //356 #CJK UNIFIED IDEOGRAPH
    {0x82E7, 0x509C}, //357 #CJK UNIFIED IDEOGRAPH
    {0x82E8, 0x509D}, //358 #CJK UNIFIED IDEOGRAPH
    {0x82E9, 0x509E}, //359 #CJK UNIFIED IDEOGRAPH
    {0x82EA, 0x509F}, //360 #CJK UNIFIED IDEOGRAPH
    {0x82EB, 0x50A0}, //361 #CJK UNIFIED IDEOGRAPH
    {0x82EC, 0x50A1}, //362 #CJK UNIFIED IDEOGRAPH
    {0x82ED, 0x50A2}, //363 #CJK UNIFIED IDEOGRAPH
    {0x82EE, 0x50A4}, //364 #CJK UNIFIED IDEOGRAPH
    {0x82EF, 0x50A6}, //365 #CJK UNIFIED IDEOGRAPH
    {0x82F0, 0x50AA}, //366 #CJK UNIFIED IDEOGRAPH
    {0x82F1, 0x50AB}, //367 #CJK UNIFIED IDEOGRAPH
    {0x82F2, 0x50AD}, //368 #CJK UNIFIED IDEOGRAPH
    {0x82F3, 0x50AE}, //369 #CJK UNIFIED IDEOGRAPH
    {0x82F4, 0x50AF}, //370 #CJK UNIFIED IDEOGRAPH
    {0x82F5, 0x50B0}, //371 #CJK UNIFIED IDEOGRAPH
    {0x82F6, 0x50B1}, //372 #CJK UNIFIED IDEOGRAPH
    {0x82F7, 0x50B3}, //373 #CJK UNIFIED IDEOGRAPH
    {0x82F8, 0x50B4}, //374 #CJK UNIFIED IDEOGRAPH
    {0x82F9, 0x50B5}, //375 #CJK UNIFIED IDEOGRAPH
    {0x82FA, 0x50B6}, //376 #CJK UNIFIED IDEOGRAPH
    {0x82FB, 0x50B7}, //377 #CJK UNIFIED IDEOGRAPH
    {0x82FC, 0x50B8}, //378 #CJK UNIFIED IDEOGRAPH
    {0x82FD, 0x50B9}, //379 #CJK UNIFIED IDEOGRAPH
    {0x82FE, 0x50BC}, //380 #CJK UNIFIED IDEOGRAPH
    {0x8340, 0x50BD}, //381 #CJK UNIFIED IDEOGRAPH
    {0x8341, 0x50BE}, //382 #CJK UNIFIED IDEOGRAPH
    {0x8342, 0x50BF}, //383 #CJK UNIFIED IDEOGRAPH
    {0x8343, 0x50C0}, //384 #CJK UNIFIED IDEOGRAPH
    {0x8344, 0x50C1}, //385 #CJK UNIFIED IDEOGRAPH
    {0x8345, 0x50C2}, //386 #CJK UNIFIED IDEOGRAPH
    {0x8346, 0x50C3}, //387 #CJK UNIFIED IDEOGRAPH
    {0x8347, 0x50C4}, //388 #CJK UNIFIED IDEOGRAPH
    {0x8348, 0x50C5}, //389 #CJK UNIFIED IDEOGRAPH
    {0x8349, 0x50C6}, //390 #CJK UNIFIED IDEOGRAPH
    {0x834A, 0x50C7}, //391 #CJK UNIFIED IDEOGRAPH
    {0x834B, 0x50C8}, //392 #CJK UNIFIED IDEOGRAPH
    {0x834C, 0x50C9}, //393 #CJK UNIFIED IDEOGRAPH
    {0x834D, 0x50CA}, //394 #CJK UNIFIED IDEOGRAPH
    {0x834E, 0x50CB}, //395 #CJK UNIFIED IDEOGRAPH
    {0x834F, 0x50CC}, //396 #CJK UNIFIED IDEOGRAPH
    {0x8350, 0x50CD}, //397 #CJK UNIFIED IDEOGRAPH
    {0x8351, 0x50CE}, //398 #CJK UNIFIED IDEOGRAPH
    {0x8352, 0x50D0}, //399 #CJK UNIFIED IDEOGRAPH
    {0x8353, 0x50D1}, //400 #CJK UNIFIED IDEOGRAPH
    {0x8354, 0x50D2}, //401 #CJK UNIFIED IDEOGRAPH
    {0x8355, 0x50D3}, //402 #CJK UNIFIED IDEOGRAPH
    {0x8356, 0x50D4}, //403 #CJK UNIFIED IDEOGRAPH
    {0x8357, 0x50D5}, //404 #CJK UNIFIED IDEOGRAPH
    {0x8358, 0x50D7}, //405 #CJK UNIFIED IDEOGRAPH
    {0x8359, 0x50D8}, //406 #CJK UNIFIED IDEOGRAPH
    {0x835A, 0x50D9}, //407 #CJK UNIFIED IDEOGRAPH
    {0x835B, 0x50DB}, //408 #CJK UNIFIED IDEOGRAPH
    {0x835C, 0x50DC}, //409 #CJK UNIFIED IDEOGRAPH
    {0x835D, 0x50DD}, //410 #CJK UNIFIED IDEOGRAPH
    {0x835E, 0x50DE}, //411 #CJK UNIFIED IDEOGRAPH
    {0x835F, 0x50DF}, //412 #CJK UNIFIED IDEOGRAPH
    {0x8360, 0x50E0}, //413 #CJK UNIFIED IDEOGRAPH
    {0x8361, 0x50E1}, //414 #CJK UNIFIED IDEOGRAPH
    {0x8362, 0x50E2}, //415 #CJK UNIFIED IDEOGRAPH
    {0x8363, 0x50E3}, //416 #CJK UNIFIED IDEOGRAPH
    {0x8364, 0x50E4}, //417 #CJK UNIFIED IDEOGRAPH
    {0x8365, 0x50E5}, //418 #CJK UNIFIED IDEOGRAPH
    {0x8366, 0x50E8}, //419 #CJK UNIFIED IDEOGRAPH
    {0x8367, 0x50E9}, //420 #CJK UNIFIED IDEOGRAPH
    {0x8368, 0x50EA}, //421 #CJK UNIFIED IDEOGRAPH
    {0x8369, 0x50EB}, //422 #CJK UNIFIED IDEOGRAPH
    {0x836A, 0x50EF}, //423 #CJK UNIFIED IDEOGRAPH
    {0x836B, 0x50F0}, //424 #CJK UNIFIED IDEOGRAPH
    {0x836C, 0x50F1}, //425 #CJK UNIFIED IDEOGRAPH
    {0x836D, 0x50F2}, //426 #CJK UNIFIED IDEOGRAPH
    {0x836E, 0x50F4}, //427 #CJK UNIFIED IDEOGRAPH
    {0x836F, 0x50F6}, //428 #CJK UNIFIED IDEOGRAPH
    {0x8370, 0x50F7}, //429 #CJK UNIFIED IDEOGRAPH
    {0x8371, 0x50F8}, //430 #CJK UNIFIED IDEOGRAPH
    {0x8372, 0x50F9}, //431 #CJK UNIFIED IDEOGRAPH
    {0x8373, 0x50FA}, //432 #CJK UNIFIED IDEOGRAPH
    {0x8374, 0x50FC}, //433 #CJK UNIFIED IDEOGRAPH
    {0x8375, 0x50FD}, //434 #CJK UNIFIED IDEOGRAPH
    {0x8376, 0x50FE}, //435 #CJK UNIFIED IDEOGRAPH
    {0x8377, 0x50FF}, //436 #CJK UNIFIED IDEOGRAPH
    {0x8378, 0x5100}, //437 #CJK UNIFIED IDEOGRAPH
    {0x8379, 0x5101}, //438 #CJK UNIFIED IDEOGRAPH
    {0x837A, 0x5102}, //439 #CJK UNIFIED IDEOGRAPH
    {0x837B, 0x5103}, //440 #CJK UNIFIED IDEOGRAPH
    {0x837C, 0x5104}, //441 #CJK UNIFIED IDEOGRAPH
    {0x837D, 0x5105}, //442 #CJK UNIFIED IDEOGRAPH
    {0x837E, 0x5108}, //443 #CJK UNIFIED IDEOGRAPH
    {0x8380, 0x5109}, //444 #CJK UNIFIED IDEOGRAPH
    {0x8381, 0x510A}, //445 #CJK UNIFIED IDEOGRAPH
    {0x8382, 0x510C}, //446 #CJK UNIFIED IDEOGRAPH
    {0x8383, 0x510D}, //447 #CJK UNIFIED IDEOGRAPH
    {0x8384, 0x510E}, //448 #CJK UNIFIED IDEOGRAPH
    {0x8385, 0x510F}, //449 #CJK UNIFIED IDEOGRAPH
    {0x8386, 0x5110}, //450 #CJK UNIFIED IDEOGRAPH
    {0x8387, 0x5111}, //451 #CJK UNIFIED IDEOGRAPH
    {0x8388, 0x5113}, //452 #CJK UNIFIED IDEOGRAPH
    {0x8389, 0x5114}, //453 #CJK UNIFIED IDEOGRAPH
    {0x838A, 0x5115}, //454 #CJK UNIFIED IDEOGRAPH
    {0x838B, 0x5116}, //455 #CJK UNIFIED IDEOGRAPH
    {0x838C, 0x5117}, //456 #CJK UNIFIED IDEOGRAPH
    {0x838D, 0x5118}, //457 #CJK UNIFIED IDEOGRAPH
    {0x838E, 0x5119}, //458 #CJK UNIFIED IDEOGRAPH
    {0x838F, 0x511A}, //459 #CJK UNIFIED IDEOGRAPH
    {0x8390, 0x511B}, //460 #CJK UNIFIED IDEOGRAPH
    {0x8391, 0x511C}, //461 #CJK UNIFIED IDEOGRAPH
    {0x8392, 0x511D}, //462 #CJK UNIFIED IDEOGRAPH
    {0x8393, 0x511E}, //463 #CJK UNIFIED IDEOGRAPH
    {0x8394, 0x511F}, //464 #CJK UNIFIED IDEOGRAPH
    {0x8395, 0x5120}, //465 #CJK UNIFIED IDEOGRAPH
    {0x8396, 0x5122}, //466 #CJK UNIFIED IDEOGRAPH
    {0x8397, 0x5123}, //467 #CJK UNIFIED IDEOGRAPH
    {0x8398, 0x5124}, //468 #CJK UNIFIED IDEOGRAPH
    {0x8399, 0x5125}, //469 #CJK UNIFIED IDEOGRAPH
    {0x839A, 0x5126}, //470 #CJK UNIFIED IDEOGRAPH
    {0x839B, 0x5127}, //471 #CJK UNIFIED IDEOGRAPH
    {0x839C, 0x5128}, //472 #CJK UNIFIED IDEOGRAPH
    {0x839D, 0x5129}, //473 #CJK UNIFIED IDEOGRAPH
    {0x839E, 0x512A}, //474 #CJK UNIFIED IDEOGRAPH
    {0x839F, 0x512B}, //475 #CJK UNIFIED IDEOGRAPH
    {0x83A0, 0x512C}, //476 #CJK UNIFIED IDEOGRAPH
    {0x83A1, 0x512D}, //477 #CJK UNIFIED IDEOGRAPH
    {0x83A2, 0x512E}, //478 #CJK UNIFIED IDEOGRAPH
    {0x83A3, 0x512F}, //479 #CJK UNIFIED IDEOGRAPH
    {0x83A4, 0x5130}, //480 #CJK UNIFIED IDEOGRAPH
    {0x83A5, 0x5131}, //481 #CJK UNIFIED IDEOGRAPH
    {0x83A6, 0x5132}, //482 #CJK UNIFIED IDEOGRAPH
    {0x83A7, 0x5133}, //483 #CJK UNIFIED IDEOGRAPH
    {0x83A8, 0x5134}, //484 #CJK UNIFIED IDEOGRAPH
    {0x83A9, 0x5135}, //485 #CJK UNIFIED IDEOGRAPH
    {0x83AA, 0x5136}, //486 #CJK UNIFIED IDEOGRAPH
    {0x83AB, 0x5137}, //487 #CJK UNIFIED IDEOGRAPH
    {0x83AC, 0x5138}, //488 #CJK UNIFIED IDEOGRAPH
    {0x83AD, 0x5139}, //489 #CJK UNIFIED IDEOGRAPH
    {0x83AE, 0x513A}, //490 #CJK UNIFIED IDEOGRAPH
    {0x83AF, 0x513B}, //491 #CJK UNIFIED IDEOGRAPH
    {0x83B0, 0x513C}, //492 #CJK UNIFIED IDEOGRAPH
    {0x83B1, 0x513D}, //493 #CJK UNIFIED IDEOGRAPH
    {0x83B2, 0x513E}, //494 #CJK UNIFIED IDEOGRAPH
    {0x83B3, 0x5142}, //495 #CJK UNIFIED IDEOGRAPH
    {0x83B4, 0x5147}, //496 #CJK UNIFIED IDEOGRAPH
    {0x83B5, 0x514A}, //497 #CJK UNIFIED IDEOGRAPH
    {0x83B6, 0x514C}, //498 #CJK UNIFIED IDEOGRAPH
    {0x83B7, 0x514E}, //499 #CJK UNIFIED IDEOGRAPH
    {0x83B8, 0x514F}, //500 #CJK UNIFIED IDEOGRAPH
    {0x83B9, 0x5150}, //501 #CJK UNIFIED IDEOGRAPH
    {0x83BA, 0x5152}, //502 #CJK UNIFIED IDEOGRAPH
    {0x83BB, 0x5153}, //503 #CJK UNIFIED IDEOGRAPH
    {0x83BC, 0x5157}, //504 #CJK UNIFIED IDEOGRAPH
    {0x83BD, 0x5158}, //505 #CJK UNIFIED IDEOGRAPH
    {0x83BE, 0x5159}, //506 #CJK UNIFIED IDEOGRAPH
    {0x83BF, 0x515B}, //507 #CJK UNIFIED IDEOGRAPH
    {0x83C0, 0x515D}, //508 #CJK UNIFIED IDEOGRAPH
    {0x83C1, 0x515E}, //509 #CJK UNIFIED IDEOGRAPH
    {0x83C2, 0x515F}, //510 #CJK UNIFIED IDEOGRAPH
    {0x83C3, 0x5160}, //511 #CJK UNIFIED IDEOGRAPH
    {0x83C4, 0x5161}, //512 #CJK UNIFIED IDEOGRAPH
    {0x83C5, 0x5163}, //513 #CJK UNIFIED IDEOGRAPH
    {0x83C6, 0x5164}, //514 #CJK UNIFIED IDEOGRAPH
    {0x83C7, 0x5166}, //515 #CJK UNIFIED IDEOGRAPH
    {0x83C8, 0x5167}, //516 #CJK UNIFIED IDEOGRAPH
    {0x83C9, 0x5169}, //517 #CJK UNIFIED IDEOGRAPH
    {0x83CA, 0x516A}, //518 #CJK UNIFIED IDEOGRAPH
    {0x83CB, 0x516F}, //519 #CJK UNIFIED IDEOGRAPH
    {0x83CC, 0x5172}, //520 #CJK UNIFIED IDEOGRAPH
    {0x83CD, 0x517A}, //521 #CJK UNIFIED IDEOGRAPH
    {0x83CE, 0x517E}, //522 #CJK UNIFIED IDEOGRAPH
    {0x83CF, 0x517F}, //523 #CJK UNIFIED IDEOGRAPH
    {0x83D0, 0x5183}, //524 #CJK UNIFIED IDEOGRAPH
    {0x83D1, 0x5184}, //525 #CJK UNIFIED IDEOGRAPH
    {0x83D2, 0x5186}, //526 #CJK UNIFIED IDEOGRAPH
    {0x83D3, 0x5187}, //527 #CJK UNIFIED IDEOGRAPH
    {0x83D4, 0x518A}, //528 #CJK UNIFIED IDEOGRAPH
    {0x83D5, 0x518B}, //529 #CJK UNIFIED IDEOGRAPH
    {0x83D6, 0x518E}, //530 #CJK UNIFIED IDEOGRAPH
    {0x83D7, 0x518F}, //531 #CJK UNIFIED IDEOGRAPH
    {0x83D8, 0x5190}, //532 #CJK UNIFIED IDEOGRAPH
    {0x83D9, 0x5191}, //533 #CJK UNIFIED IDEOGRAPH
    {0x83DA, 0x5193}, //534 #CJK UNIFIED IDEOGRAPH
    {0x83DB, 0x5194}, //535 #CJK UNIFIED IDEOGRAPH
    {0x83DC, 0x5198}, //536 #CJK UNIFIED IDEOGRAPH
    {0x83DD, 0x519A}, //537 #CJK UNIFIED IDEOGRAPH
    {0x83DE, 0x519D}, //538 #CJK UNIFIED IDEOGRAPH
    {0x83DF, 0x519E}, //539 #CJK UNIFIED IDEOGRAPH
    {0x83E0, 0x519F}, //540 #CJK UNIFIED IDEOGRAPH
    {0x83E1, 0x51A1}, //541 #CJK UNIFIED IDEOGRAPH
    {0x83E2, 0x51A3}, //542 #CJK UNIFIED IDEOGRAPH
    {0x83E3, 0x51A6}, //543 #CJK UNIFIED IDEOGRAPH
    {0x83E4, 0x51A7}, //544 #CJK UNIFIED IDEOGRAPH
    {0x83E5, 0x51A8}, //545 #CJK UNIFIED IDEOGRAPH
    {0x83E6, 0x51A9}, //546 #CJK UNIFIED IDEOGRAPH
    {0x83E7, 0x51AA}, //547 #CJK UNIFIED IDEOGRAPH
    {0x83E8, 0x51AD}, //548 #CJK UNIFIED IDEOGRAPH
    {0x83E9, 0x51AE}, //549 #CJK UNIFIED IDEOGRAPH
    {0x83EA, 0x51B4}, //550 #CJK UNIFIED IDEOGRAPH
    {0x83EB, 0x51B8}, //551 #CJK UNIFIED IDEOGRAPH
    {0x83EC, 0x51B9}, //552 #CJK UNIFIED IDEOGRAPH
    {0x83ED, 0x51BA}, //553 #CJK UNIFIED IDEOGRAPH
    {0x83EE, 0x51BE}, //554 #CJK UNIFIED IDEOGRAPH
    {0x83EF, 0x51BF}, //555 #CJK UNIFIED IDEOGRAPH
    {0x83F0, 0x51C1}, //556 #CJK UNIFIED IDEOGRAPH
    {0x83F1, 0x51C2}, //557 #CJK UNIFIED IDEOGRAPH
    {0x83F2, 0x51C3}, //558 #CJK UNIFIED IDEOGRAPH
    {0x83F3, 0x51C5}, //559 #CJK UNIFIED IDEOGRAPH
    {0x83F4, 0x51C8}, //560 #CJK UNIFIED IDEOGRAPH
    {0x83F5, 0x51CA}, //561 #CJK UNIFIED IDEOGRAPH
    {0x83F6, 0x51CD}, //562 #CJK UNIFIED IDEOGRAPH
    {0x83F7, 0x51CE}, //563 #CJK UNIFIED IDEOGRAPH
    {0x83F8, 0x51D0}, //564 #CJK UNIFIED IDEOGRAPH
    {0x83F9, 0x51D2}, //565 #CJK UNIFIED IDEOGRAPH
    {0x83FA, 0x51D3}, //566 #CJK UNIFIED IDEOGRAPH
    {0x83FB, 0x51D4}, //567 #CJK UNIFIED IDEOGRAPH
    {0x83FC, 0x51D5}, //568 #CJK UNIFIED IDEOGRAPH
    {0x83FD, 0x51D6}, //569 #CJK UNIFIED IDEOGRAPH
    {0x83FE, 0x51D7}, //570 #CJK UNIFIED IDEOGRAPH
    {0x8440, 0x51D8}, //571 #CJK UNIFIED IDEOGRAPH
    {0x8441, 0x51D9}, //572 #CJK UNIFIED IDEOGRAPH
    {0x8442, 0x51DA}, //573 #CJK UNIFIED IDEOGRAPH
    {0x8443, 0x51DC}, //574 #CJK UNIFIED IDEOGRAPH
    {0x8444, 0x51DE}, //575 #CJK UNIFIED IDEOGRAPH
    {0x8445, 0x51DF}, //576 #CJK UNIFIED IDEOGRAPH
    {0x8446, 0x51E2}, //577 #CJK UNIFIED IDEOGRAPH
    {0x8447, 0x51E3}, //578 #CJK UNIFIED IDEOGRAPH
    {0x8448, 0x51E5}, //579 #CJK UNIFIED IDEOGRAPH
    {0x8449, 0x51E6}, //580 #CJK UNIFIED IDEOGRAPH
    {0x844A, 0x51E7}, //581 #CJK UNIFIED IDEOGRAPH
    {0x844B, 0x51E8}, //582 #CJK UNIFIED IDEOGRAPH
    {0x844C, 0x51E9}, //583 #CJK UNIFIED IDEOGRAPH
    {0x844D, 0x51EA}, //584 #CJK UNIFIED IDEOGRAPH
    {0x844E, 0x51EC}, //585 #CJK UNIFIED IDEOGRAPH
    {0x844F, 0x51EE}, //586 #CJK UNIFIED IDEOGRAPH
    {0x8450, 0x51F1}, //587 #CJK UNIFIED IDEOGRAPH
    {0x8451, 0x51F2}, //588 #CJK UNIFIED IDEOGRAPH
    {0x8452, 0x51F4}, //589 #CJK UNIFIED IDEOGRAPH
    {0x8453, 0x51F7}, //590 #CJK UNIFIED IDEOGRAPH
    {0x8454, 0x51FE}, //591 #CJK UNIFIED IDEOGRAPH
    {0x8455, 0x5204}, //592 #CJK UNIFIED IDEOGRAPH
    {0x8456, 0x5205}, //593 #CJK UNIFIED IDEOGRAPH
    {0x8457, 0x5209}, //594 #CJK UNIFIED IDEOGRAPH
    {0x8458, 0x520B}, //595 #CJK UNIFIED IDEOGRAPH
    {0x8459, 0x520C}, //596 #CJK UNIFIED IDEOGRAPH
    {0x845A, 0x520F}, //597 #CJK UNIFIED IDEOGRAPH
    {0x845B, 0x5210}, //598 #CJK UNIFIED IDEOGRAPH
    {0x845C, 0x5213}, //599 #CJK UNIFIED IDEOGRAPH
    {0x845D, 0x5214}, //600 #CJK UNIFIED IDEOGRAPH
    {0x845E, 0x5215}, //601 #CJK UNIFIED IDEOGRAPH
    {0x845F, 0x521C}, //602 #CJK UNIFIED IDEOGRAPH
    {0x8460, 0x521E}, //603 #CJK UNIFIED IDEOGRAPH
    {0x8461, 0x521F}, //604 #CJK UNIFIED IDEOGRAPH
    {0x8462, 0x5221}, //605 #CJK UNIFIED IDEOGRAPH
    {0x8463, 0x5222}, //606 #CJK UNIFIED IDEOGRAPH
    {0x8464, 0x5223}, //607 #CJK UNIFIED IDEOGRAPH
    {0x8465, 0x5225}, //608 #CJK UNIFIED IDEOGRAPH
    {0x8466, 0x5226}, //609 #CJK UNIFIED IDEOGRAPH
    {0x8467, 0x5227}, //610 #CJK UNIFIED IDEOGRAPH
    {0x8468, 0x522A}, //611 #CJK UNIFIED IDEOGRAPH
    {0x8469, 0x522C}, //612 #CJK UNIFIED IDEOGRAPH
    {0x846A, 0x522F}, //613 #CJK UNIFIED IDEOGRAPH
    {0x846B, 0x5231}, //614 #CJK UNIFIED IDEOGRAPH
    {0x846C, 0x5232}, //615 #CJK UNIFIED IDEOGRAPH
    {0x846D, 0x5234}, //616 #CJK UNIFIED IDEOGRAPH
    {0x846E, 0x5235}, //617 #CJK UNIFIED IDEOGRAPH
    {0x846F, 0x523C}, //618 #CJK UNIFIED IDEOGRAPH
    {0x8470, 0x523E}, //619 #CJK UNIFIED IDEOGRAPH
    {0x8471, 0x5244}, //620 #CJK UNIFIED IDEOGRAPH
    {0x8472, 0x5245}, //621 #CJK UNIFIED IDEOGRAPH
    {0x8473, 0x5246}, //622 #CJK UNIFIED IDEOGRAPH
    {0x8474, 0x5247}, //623 #CJK UNIFIED IDEOGRAPH
    {0x8475, 0x5248}, //624 #CJK UNIFIED IDEOGRAPH
    {0x8476, 0x5249}, //625 #CJK UNIFIED IDEOGRAPH
    {0x8477, 0x524B}, //626 #CJK UNIFIED IDEOGRAPH
    {0x8478, 0x524E}, //627 #CJK UNIFIED IDEOGRAPH
    {0x8479, 0x524F}, //628 #CJK UNIFIED IDEOGRAPH
    {0x847A, 0x5252}, //629 #CJK UNIFIED IDEOGRAPH
    {0x847B, 0x5253}, //630 #CJK UNIFIED IDEOGRAPH
    {0x847C, 0x5255}, //631 #CJK UNIFIED IDEOGRAPH
    {0x847D, 0x5257}, //632 #CJK UNIFIED IDEOGRAPH
    {0x847E, 0x5258}, //633 #CJK UNIFIED IDEOGRAPH
    {0x8480, 0x5259}, //634 #CJK UNIFIED IDEOGRAPH
    {0x8481, 0x525A}, //635 #CJK UNIFIED IDEOGRAPH
    {0x8482, 0x525B}, //636 #CJK UNIFIED IDEOGRAPH
    {0x8483, 0x525D}, //637 #CJK UNIFIED IDEOGRAPH
    {0x8484, 0x525F}, //638 #CJK UNIFIED IDEOGRAPH
    {0x8485, 0x5260}, //639 #CJK UNIFIED IDEOGRAPH
    {0x8486, 0x5262}, //640 #CJK UNIFIED IDEOGRAPH
    {0x8487, 0x5263}, //641 #CJK UNIFIED IDEOGRAPH
    {0x8488, 0x5264}, //642 #CJK UNIFIED IDEOGRAPH
    {0x8489, 0x5266}, //643 #CJK UNIFIED IDEOGRAPH
    {0x848A, 0x5268}, //644 #CJK UNIFIED IDEOGRAPH
    {0x848B, 0x526B}, //645 #CJK UNIFIED IDEOGRAPH
    {0x848C, 0x526C}, //646 #CJK UNIFIED IDEOGRAPH
    {0x848D, 0x526D}, //647 #CJK UNIFIED IDEOGRAPH
    {0x848E, 0x526E}, //648 #CJK UNIFIED IDEOGRAPH
    {0x848F, 0x5270}, //649 #CJK UNIFIED IDEOGRAPH
    {0x8490, 0x5271}, //650 #CJK UNIFIED IDEOGRAPH
    {0x8491, 0x5273}, //651 #CJK UNIFIED IDEOGRAPH
    {0x8492, 0x5274}, //652 #CJK UNIFIED IDEOGRAPH
    {0x8493, 0x5275}, //653 #CJK UNIFIED IDEOGRAPH
    {0x8494, 0x5276}, //654 #CJK UNIFIED IDEOGRAPH
    {0x8495, 0x5277}, //655 #CJK UNIFIED IDEOGRAPH
    {0x8496, 0x5278}, //656 #CJK UNIFIED IDEOGRAPH
    {0x8497, 0x5279}, //657 #CJK UNIFIED IDEOGRAPH
    {0x8498, 0x527A}, //658 #CJK UNIFIED IDEOGRAPH
    {0x8499, 0x527B}, //659 #CJK UNIFIED IDEOGRAPH
    {0x849A, 0x527C}, //660 #CJK UNIFIED IDEOGRAPH
    {0x849B, 0x527E}, //661 #CJK UNIFIED IDEOGRAPH
    {0x849C, 0x5280}, //662 #CJK UNIFIED IDEOGRAPH
    {0x849D, 0x5283}, //663 #CJK UNIFIED IDEOGRAPH
    {0x849E, 0x5284}, //664 #CJK UNIFIED IDEOGRAPH
    {0x849F, 0x5285}, //665 #CJK UNIFIED IDEOGRAPH
    {0x84A0, 0x5286}, //666 #CJK UNIFIED IDEOGRAPH
    {0x84A1, 0x5287}, //667 #CJK UNIFIED IDEOGRAPH
    {0x84A2, 0x5289}, //668 #CJK UNIFIED IDEOGRAPH
    {0x84A3, 0x528A}, //669 #CJK UNIFIED IDEOGRAPH
    {0x84A4, 0x528B}, //670 #CJK UNIFIED IDEOGRAPH
    {0x84A5, 0x528C}, //671 #CJK UNIFIED IDEOGRAPH
    {0x84A6, 0x528D}, //672 #CJK UNIFIED IDEOGRAPH
    {0x84A7, 0x528E}, //673 #CJK UNIFIED IDEOGRAPH
    {0x84A8, 0x528F}, //674 #CJK UNIFIED IDEOGRAPH
    {0x84A9, 0x5291}, //675 #CJK UNIFIED IDEOGRAPH
    {0x84AA, 0x5292}, //676 #CJK UNIFIED IDEOGRAPH
    {0x84AB, 0x5294}, //677 #CJK UNIFIED IDEOGRAPH
    {0x84AC, 0x5295}, //678 #CJK UNIFIED IDEOGRAPH
    {0x84AD, 0x5296}, //679 #CJK UNIFIED IDEOGRAPH
    {0x84AE, 0x5297}, //680 #CJK UNIFIED IDEOGRAPH
    {0x84AF, 0x5298}, //681 #CJK UNIFIED IDEOGRAPH
    {0x84B0, 0x5299}, //682 #CJK UNIFIED IDEOGRAPH
    {0x84B1, 0x529A}, //683 #CJK UNIFIED IDEOGRAPH
    {0x84B2, 0x529C}, //684 #CJK UNIFIED IDEOGRAPH
    {0x84B3, 0x52A4}, //685 #CJK UNIFIED IDEOGRAPH
    {0x84B4, 0x52A5}, //686 #CJK UNIFIED IDEOGRAPH
    {0x84B5, 0x52A6}, //687 #CJK UNIFIED IDEOGRAPH
    {0x84B6, 0x52A7}, //688 #CJK UNIFIED IDEOGRAPH
    {0x84B7, 0x52AE}, //689 #CJK UNIFIED IDEOGRAPH
    {0x84B8, 0x52AF}, //690 #CJK UNIFIED IDEOGRAPH
    {0x84B9, 0x52B0}, //691 #CJK UNIFIED IDEOGRAPH
    {0x84BA, 0x52B4}, //692 #CJK UNIFIED IDEOGRAPH
    {0x84BB, 0x52B5}, //693 #CJK UNIFIED IDEOGRAPH
    {0x84BC, 0x52B6}, //694 #CJK UNIFIED IDEOGRAPH
    {0x84BD, 0x52B7}, //695 #CJK UNIFIED IDEOGRAPH
    {0x84BE, 0x52B8}, //696 #CJK UNIFIED IDEOGRAPH
    {0x84BF, 0x52B9}, //697 #CJK UNIFIED IDEOGRAPH
    {0x84C0, 0x52BA}, //698 #CJK UNIFIED IDEOGRAPH
    {0x84C1, 0x52BB}, //699 #CJK UNIFIED IDEOGRAPH
    {0x84C2, 0x52BC}, //700 #CJK UNIFIED IDEOGRAPH
    {0x84C3, 0x52BD}, //701 #CJK UNIFIED IDEOGRAPH
    {0x84C4, 0x52C0}, //702 #CJK UNIFIED IDEOGRAPH
    {0x84C5, 0x52C1}, //703 #CJK UNIFIED IDEOGRAPH
    {0x84C6, 0x52C2}, //704 #CJK UNIFIED IDEOGRAPH
    {0x84C7, 0x52C4}, //705 #CJK UNIFIED IDEOGRAPH
    {0x84C8, 0x52C5}, //706 #CJK UNIFIED IDEOGRAPH
    {0x84C9, 0x52C6}, //707 #CJK UNIFIED IDEOGRAPH
    {0x84CA, 0x52C8}, //708 #CJK UNIFIED IDEOGRAPH
    {0x84CB, 0x52CA}, //709 #CJK UNIFIED IDEOGRAPH
    {0x84CC, 0x52CC}, //710 #CJK UNIFIED IDEOGRAPH
    {0x84CD, 0x52CD}, //711 #CJK UNIFIED IDEOGRAPH
    {0x84CE, 0x52CE}, //712 #CJK UNIFIED IDEOGRAPH
    {0x84CF, 0x52CF}, //713 #CJK UNIFIED IDEOGRAPH
    {0x84D0, 0x52D1}, //714 #CJK UNIFIED IDEOGRAPH
    {0x84D1, 0x52D3}, //715 #CJK UNIFIED IDEOGRAPH
    {0x84D2, 0x52D4}, //716 #CJK UNIFIED IDEOGRAPH
    {0x84D3, 0x52D5}, //717 #CJK UNIFIED IDEOGRAPH
    {0x84D4, 0x52D7}, //718 #CJK UNIFIED IDEOGRAPH
    {0x84D5, 0x52D9}, //719 #CJK UNIFIED IDEOGRAPH
    {0x84D6, 0x52DA}, //720 #CJK UNIFIED IDEOGRAPH
    {0x84D7, 0x52DB}, //721 #CJK UNIFIED IDEOGRAPH
    {0x84D8, 0x52DC}, //722 #CJK UNIFIED IDEOGRAPH
    {0x84D9, 0x52DD}, //723 #CJK UNIFIED IDEOGRAPH
    {0x84DA, 0x52DE}, //724 #CJK UNIFIED IDEOGRAPH
    {0x84DB, 0x52E0}, //725 #CJK UNIFIED IDEOGRAPH
    {0x84DC, 0x52E1}, //726 #CJK UNIFIED IDEOGRAPH
    {0x84DD, 0x52E2}, //727 #CJK UNIFIED IDEOGRAPH
    {0x84DE, 0x52E3}, //728 #CJK UNIFIED IDEOGRAPH
    {0x84DF, 0x52E5}, //729 #CJK UNIFIED IDEOGRAPH
    {0x84E0, 0x52E6}, //730 #CJK UNIFIED IDEOGRAPH
    {0x84E1, 0x52E7}, //731 #CJK UNIFIED IDEOGRAPH
    {0x84E2, 0x52E8}, //732 #CJK UNIFIED IDEOGRAPH
    {0x84E3, 0x52E9}, //733 #CJK UNIFIED IDEOGRAPH
    {0x84E4, 0x52EA}, //734 #CJK UNIFIED IDEOGRAPH
    {0x84E5, 0x52EB}, //735 #CJK UNIFIED IDEOGRAPH
    {0x84E6, 0x52EC}, //736 #CJK UNIFIED IDEOGRAPH
    {0x84E7, 0x52ED}, //737 #CJK UNIFIED IDEOGRAPH
    {0x84E8, 0x52EE}, //738 #CJK UNIFIED IDEOGRAPH
    {0x84E9, 0x52EF}, //739 #CJK UNIFIED IDEOGRAPH
    {0x84EA, 0x52F1}, //740 #CJK UNIFIED IDEOGRAPH
    {0x84EB, 0x52F2}, //741 #CJK UNIFIED IDEOGRAPH
    {0x84EC, 0x52F3}, //742 #CJK UNIFIED IDEOGRAPH
    {0x84ED, 0x52F4}, //743 #CJK UNIFIED IDEOGRAPH
    {0x84EE, 0x52F5}, //744 #CJK UNIFIED IDEOGRAPH
    {0x84EF, 0x52F6}, //745 #CJK UNIFIED IDEOGRAPH
    {0x84F0, 0x52F7}, //746 #CJK UNIFIED IDEOGRAPH
    {0x84F1, 0x52F8}, //747 #CJK UNIFIED IDEOGRAPH
    {0x84F2, 0x52FB}, //748 #CJK UNIFIED IDEOGRAPH
    {0x84F3, 0x52FC}, //749 #CJK UNIFIED IDEOGRAPH
    {0x84F4, 0x52FD}, //750 #CJK UNIFIED IDEOGRAPH
    {0x84F5, 0x5301}, //751 #CJK UNIFIED IDEOGRAPH
    {0x84F6, 0x5302}, //752 #CJK UNIFIED IDEOGRAPH
    {0x84F7, 0x5303}, //753 #CJK UNIFIED IDEOGRAPH
    {0x84F8, 0x5304}, //754 #CJK UNIFIED IDEOGRAPH
    {0x84F9, 0x5307}, //755 #CJK UNIFIED IDEOGRAPH
    {0x84FA, 0x5309}, //756 #CJK UNIFIED IDEOGRAPH
    {0x84FB, 0x530A}, //757 #CJK UNIFIED IDEOGRAPH
    {0x84FC, 0x530B}, //758 #CJK UNIFIED IDEOGRAPH
    {0x84FD, 0x530C}, //759 #CJK UNIFIED IDEOGRAPH
    {0x84FE, 0x530E}, //760 #CJK UNIFIED IDEOGRAPH
    {0x8540, 0x5311}, //761 #CJK UNIFIED IDEOGRAPH
    {0x8541, 0x5312}, //762 #CJK UNIFIED IDEOGRAPH
    {0x8542, 0x5313}, //763 #CJK UNIFIED IDEOGRAPH
    {0x8543, 0x5314}, //764 #CJK UNIFIED IDEOGRAPH
    {0x8544, 0x5318}, //765 #CJK UNIFIED IDEOGRAPH
    {0x8545, 0x531B}, //766 #CJK UNIFIED IDEOGRAPH
    {0x8546, 0x531C}, //767 #CJK UNIFIED IDEOGRAPH
    {0x8547, 0x531E}, //768 #CJK UNIFIED IDEOGRAPH
    {0x8548, 0x531F}, //769 #CJK UNIFIED IDEOGRAPH
    {0x8549, 0x5322}, //770 #CJK UNIFIED IDEOGRAPH
    {0x854A, 0x5324}, //771 #CJK UNIFIED IDEOGRAPH
    {0x854B, 0x5325}, //772 #CJK UNIFIED IDEOGRAPH
    {0x854C, 0x5327}, //773 #CJK UNIFIED IDEOGRAPH
    {0x854D, 0x5328}, //774 #CJK UNIFIED IDEOGRAPH
    {0x854E, 0x5329}, //775 #CJK UNIFIED IDEOGRAPH
    {0x854F, 0x532B}, //776 #CJK UNIFIED IDEOGRAPH
    {0x8550, 0x532C}, //777 #CJK UNIFIED IDEOGRAPH
    {0x8551, 0x532D}, //778 #CJK UNIFIED IDEOGRAPH
    {0x8552, 0x532F}, //779 #CJK UNIFIED IDEOGRAPH
    {0x8553, 0x5330}, //780 #CJK UNIFIED IDEOGRAPH
    {0x8554, 0x5331}, //781 #CJK UNIFIED IDEOGRAPH
    {0x8555, 0x5332}, //782 #CJK UNIFIED IDEOGRAPH
    {0x8556, 0x5333}, //783 #CJK UNIFIED IDEOGRAPH
    {0x8557, 0x5334}, //784 #CJK UNIFIED IDEOGRAPH
    {0x8558, 0x5335}, //785 #CJK UNIFIED IDEOGRAPH
    {0x8559, 0x5336}, //786 #CJK UNIFIED IDEOGRAPH
    {0x855A, 0x5337}, //787 #CJK UNIFIED IDEOGRAPH
    {0x855B, 0x5338}, //788 #CJK UNIFIED IDEOGRAPH
    {0x855C, 0x533C}, //789 #CJK UNIFIED IDEOGRAPH
    {0x855D, 0x533D}, //790 #CJK UNIFIED IDEOGRAPH
    {0x855E, 0x5340}, //791 #CJK UNIFIED IDEOGRAPH
    {0x855F, 0x5342}, //792 #CJK UNIFIED IDEOGRAPH
    {0x8560, 0x5344}, //793 #CJK UNIFIED IDEOGRAPH
    {0x8561, 0x5346}, //794 #CJK UNIFIED IDEOGRAPH
    {0x8562, 0x534B}, //795 #CJK UNIFIED IDEOGRAPH
    {0x8563, 0x534C}, //796 #CJK UNIFIED IDEOGRAPH
    {0x8564, 0x534D}, //797 #CJK UNIFIED IDEOGRAPH
    {0x8565, 0x5350}, //798 #CJK UNIFIED IDEOGRAPH
    {0x8566, 0x5354}, //799 #CJK UNIFIED IDEOGRAPH
    {0x8567, 0x5358}, //800 #CJK UNIFIED IDEOGRAPH
    {0x8568, 0x5359}, //801 #CJK UNIFIED IDEOGRAPH
    {0x8569, 0x535B}, //802 #CJK UNIFIED IDEOGRAPH
    {0x856A, 0x535D}, //803 #CJK UNIFIED IDEOGRAPH
    {0x856B, 0x5365}, //804 #CJK UNIFIED IDEOGRAPH
    {0x856C, 0x5368}, //805 #CJK UNIFIED IDEOGRAPH
    {0x856D, 0x536A}, //806 #CJK UNIFIED IDEOGRAPH
    {0x856E, 0x536C}, //807 #CJK UNIFIED IDEOGRAPH
    {0x856F, 0x536D}, //808 #CJK UNIFIED IDEOGRAPH
    {0x8570, 0x5372}, //809 #CJK UNIFIED IDEOGRAPH
    {0x8571, 0x5376}, //810 #CJK UNIFIED IDEOGRAPH
    {0x8572, 0x5379}, //811 #CJK UNIFIED IDEOGRAPH
    {0x8573, 0x537B}, //812 #CJK UNIFIED IDEOGRAPH
    {0x8574, 0x537C}, //813 #CJK UNIFIED IDEOGRAPH
    {0x8575, 0x537D}, //814 #CJK UNIFIED IDEOGRAPH
    {0x8576, 0x537E}, //815 #CJK UNIFIED IDEOGRAPH
    {0x8577, 0x5380}, //816 #CJK UNIFIED IDEOGRAPH
    {0x8578, 0x5381}, //817 #CJK UNIFIED IDEOGRAPH
    {0x8579, 0x5383}, //818 #CJK UNIFIED IDEOGRAPH
    {0x857A, 0x5387}, //819 #CJK UNIFIED IDEOGRAPH
    {0x857B, 0x5388}, //820 #CJK UNIFIED IDEOGRAPH
    {0x857C, 0x538A}, //821 #CJK UNIFIED IDEOGRAPH
    {0x857D, 0x538E}, //822 #CJK UNIFIED IDEOGRAPH
    {0x857E, 0x538F}, //823 #CJK UNIFIED IDEOGRAPH
    {0x8580, 0x5390}, //824 #CJK UNIFIED IDEOGRAPH
    {0x8581, 0x5391}, //825 #CJK UNIFIED IDEOGRAPH
    {0x8582, 0x5392}, //826 #CJK UNIFIED IDEOGRAPH
    {0x8583, 0x5393}, //827 #CJK UNIFIED IDEOGRAPH
    {0x8584, 0x5394}, //828 #CJK UNIFIED IDEOGRAPH
    {0x8585, 0x5396}, //829 #CJK UNIFIED IDEOGRAPH
    {0x8586, 0x5397}, //830 #CJK UNIFIED IDEOGRAPH
    {0x8587, 0x5399}, //831 #CJK UNIFIED IDEOGRAPH
    {0x8588, 0x539B}, //832 #CJK UNIFIED IDEOGRAPH
    {0x8589, 0x539C}, //833 #CJK UNIFIED IDEOGRAPH
    {0x858A, 0x539E}, //834 #CJK UNIFIED IDEOGRAPH
    {0x858B, 0x53A0}, //835 #CJK UNIFIED IDEOGRAPH
    {0x858C, 0x53A1}, //836 #CJK UNIFIED IDEOGRAPH
    {0x858D, 0x53A4}, //837 #CJK UNIFIED IDEOGRAPH
    {0x858E, 0x53A7}, //838 #CJK UNIFIED IDEOGRAPH
    {0x858F, 0x53AA}, //839 #CJK UNIFIED IDEOGRAPH
    {0x8590, 0x53AB}, //840 #CJK UNIFIED IDEOGRAPH
    {0x8591, 0x53AC}, //841 #CJK UNIFIED IDEOGRAPH
    {0x8592, 0x53AD}, //842 #CJK UNIFIED IDEOGRAPH
    {0x8593, 0x53AF}, //843 #CJK UNIFIED IDEOGRAPH
    {0x8594, 0x53B0}, //844 #CJK UNIFIED IDEOGRAPH
    {0x8595, 0x53B1}, //845 #CJK UNIFIED IDEOGRAPH
    {0x8596, 0x53B2}, //846 #CJK UNIFIED IDEOGRAPH
    {0x8597, 0x53B3}, //847 #CJK UNIFIED IDEOGRAPH
    {0x8598, 0x53B4}, //848 #CJK UNIFIED IDEOGRAPH
    {0x8599, 0x53B5}, //849 #CJK UNIFIED IDEOGRAPH
    {0x859A, 0x53B7}, //850 #CJK UNIFIED IDEOGRAPH
    {0x859B, 0x53B8}, //851 #CJK UNIFIED IDEOGRAPH
    {0x859C, 0x53B9}, //852 #CJK UNIFIED IDEOGRAPH
    {0x859D, 0x53BA}, //853 #CJK UNIFIED IDEOGRAPH
    {0x859E, 0x53BC}, //854 #CJK UNIFIED IDEOGRAPH
    {0x859F, 0x53BD}, //855 #CJK UNIFIED IDEOGRAPH
    {0x85A0, 0x53BE}, //856 #CJK UNIFIED IDEOGRAPH
    {0x85A1, 0x53C0}, //857 #CJK UNIFIED IDEOGRAPH
    {0x85A2, 0x53C3}, //858 #CJK UNIFIED IDEOGRAPH
    {0x85A3, 0x53C4}, //859 #CJK UNIFIED IDEOGRAPH
    {0x85A4, 0x53C5}, //860 #CJK UNIFIED IDEOGRAPH
    {0x85A5, 0x53C6}, //861 #CJK UNIFIED IDEOGRAPH
    {0x85A6, 0x53C7}, //862 #CJK UNIFIED IDEOGRAPH
    {0x85A7, 0x53CE}, //863 #CJK UNIFIED IDEOGRAPH
    {0x85A8, 0x53CF}, //864 #CJK UNIFIED IDEOGRAPH
    {0x85A9, 0x53D0}, //865 #CJK UNIFIED IDEOGRAPH
    {0x85AA, 0x53D2}, //866 #CJK UNIFIED IDEOGRAPH
    {0x85AB, 0x53D3}, //867 #CJK UNIFIED IDEOGRAPH
    {0x85AC, 0x53D5}, //868 #CJK UNIFIED IDEOGRAPH
    {0x85AD, 0x53DA}, //869 #CJK UNIFIED IDEOGRAPH
    {0x85AE, 0x53DC}, //870 #CJK UNIFIED IDEOGRAPH
    {0x85AF, 0x53DD}, //871 #CJK UNIFIED IDEOGRAPH
    {0x85B0, 0x53DE}, //872 #CJK UNIFIED IDEOGRAPH
    {0x85B1, 0x53E1}, //873 #CJK UNIFIED IDEOGRAPH
    {0x85B2, 0x53E2}, //874 #CJK UNIFIED IDEOGRAPH
    {0x85B3, 0x53E7}, //875 #CJK UNIFIED IDEOGRAPH
    {0x85B4, 0x53F4}, //876 #CJK UNIFIED IDEOGRAPH
    {0x85B5, 0x53FA}, //877 #CJK UNIFIED IDEOGRAPH
    {0x85B6, 0x53FE}, //878 #CJK UNIFIED IDEOGRAPH
    {0x85B7, 0x53FF}, //879 #CJK UNIFIED IDEOGRAPH
    {0x85B8, 0x5400}, //880 #CJK UNIFIED IDEOGRAPH
    {0x85B9, 0x5402}, //881 #CJK UNIFIED IDEOGRAPH
    {0x85BA, 0x5405}, //882 #CJK UNIFIED IDEOGRAPH
    {0x85BB, 0x5407}, //883 #CJK UNIFIED IDEOGRAPH
    {0x85BC, 0x540B}, //884 #CJK UNIFIED IDEOGRAPH
    {0x85BD, 0x5414}, //885 #CJK UNIFIED IDEOGRAPH
    {0x85BE, 0x5418}, //886 #CJK UNIFIED IDEOGRAPH
    {0x85BF, 0x5419}, //887 #CJK UNIFIED IDEOGRAPH
    {0x85C0, 0x541A}, //888 #CJK UNIFIED IDEOGRAPH
    {0x85C1, 0x541C}, //889 #CJK UNIFIED IDEOGRAPH
    {0x85C2, 0x5422}, //890 #CJK UNIFIED IDEOGRAPH
    {0x85C3, 0x5424}, //891 #CJK UNIFIED IDEOGRAPH
    {0x85C4, 0x5425}, //892 #CJK UNIFIED IDEOGRAPH
    {0x85C5, 0x542A}, //893 #CJK UNIFIED IDEOGRAPH
    {0x85C6, 0x5430}, //894 #CJK UNIFIED IDEOGRAPH
    {0x85C7, 0x5433}, //895 #CJK UNIFIED IDEOGRAPH
    {0x85C8, 0x5436}, //896 #CJK UNIFIED IDEOGRAPH
    {0x85C9, 0x5437}, //897 #CJK UNIFIED IDEOGRAPH
    {0x85CA, 0x543A}, //898 #CJK UNIFIED IDEOGRAPH
    {0x85CB, 0x543D}, //899 #CJK UNIFIED IDEOGRAPH
    {0x85CC, 0x543F}, //900 #CJK UNIFIED IDEOGRAPH
    {0x85CD, 0x5441}, //901 #CJK UNIFIED IDEOGRAPH
    {0x85CE, 0x5442}, //902 #CJK UNIFIED IDEOGRAPH
    {0x85CF, 0x5444}, //903 #CJK UNIFIED IDEOGRAPH
    {0x85D0, 0x5445}, //904 #CJK UNIFIED IDEOGRAPH
    {0x85D1, 0x5447}, //905 #CJK UNIFIED IDEOGRAPH
    {0x85D2, 0x5449}, //906 #CJK UNIFIED IDEOGRAPH
    {0x85D3, 0x544C}, //907 #CJK UNIFIED IDEOGRAPH
    {0x85D4, 0x544D}, //908 #CJK UNIFIED IDEOGRAPH
    {0x85D5, 0x544E}, //909 #CJK UNIFIED IDEOGRAPH
    {0x85D6, 0x544F}, //910 #CJK UNIFIED IDEOGRAPH
    {0x85D7, 0x5451}, //911 #CJK UNIFIED IDEOGRAPH
    {0x85D8, 0x545A}, //912 #CJK UNIFIED IDEOGRAPH
    {0x85D9, 0x545D}, //913 #CJK UNIFIED IDEOGRAPH
    {0x85DA, 0x545E}, //914 #CJK UNIFIED IDEOGRAPH
    {0x85DB, 0x545F}, //915 #CJK UNIFIED IDEOGRAPH
    {0x85DC, 0x5460}, //916 #CJK UNIFIED IDEOGRAPH
    {0x85DD, 0x5461}, //917 #CJK UNIFIED IDEOGRAPH
    {0x85DE, 0x5463}, //918 #CJK UNIFIED IDEOGRAPH
    {0x85DF, 0x5465}, //919 #CJK UNIFIED IDEOGRAPH
    {0x85E0, 0x5467}, //920 #CJK UNIFIED IDEOGRAPH
    {0x85E1, 0x5469}, //921 #CJK UNIFIED IDEOGRAPH
    {0x85E2, 0x546A}, //922 #CJK UNIFIED IDEOGRAPH
    {0x85E3, 0x546B}, //923 #CJK UNIFIED IDEOGRAPH
    {0x85E4, 0x546C}, //924 #CJK UNIFIED IDEOGRAPH
    {0x85E5, 0x546D}, //925 #CJK UNIFIED IDEOGRAPH
    {0x85E6, 0x546E}, //926 #CJK UNIFIED IDEOGRAPH
    {0x85E7, 0x546F}, //927 #CJK UNIFIED IDEOGRAPH
    {0x85E8, 0x5470}, //928 #CJK UNIFIED IDEOGRAPH
    {0x85E9, 0x5474}, //929 #CJK UNIFIED IDEOGRAPH
    {0x85EA, 0x5479}, //930 #CJK UNIFIED IDEOGRAPH
    {0x85EB, 0x547A}, //931 #CJK UNIFIED IDEOGRAPH
    {0x85EC, 0x547E}, //932 #CJK UNIFIED IDEOGRAPH
    {0x85ED, 0x547F}, //933 #CJK UNIFIED IDEOGRAPH
    {0x85EE, 0x5481}, //934 #CJK UNIFIED IDEOGRAPH
    {0x85EF, 0x5483}, //935 #CJK UNIFIED IDEOGRAPH
    {0x85F0, 0x5485}, //936 #CJK UNIFIED IDEOGRAPH
    {0x85F1, 0x5487}, //937 #CJK UNIFIED IDEOGRAPH
    {0x85F2, 0x5488}, //938 #CJK UNIFIED IDEOGRAPH
    {0x85F3, 0x5489}, //939 #CJK UNIFIED IDEOGRAPH
    {0x85F4, 0x548A}, //940 #CJK UNIFIED IDEOGRAPH
    {0x85F5, 0x548D}, //941 #CJK UNIFIED IDEOGRAPH
    {0x85F6, 0x5491}, //942 #CJK UNIFIED IDEOGRAPH
    {0x85F7, 0x5493}, //943 #CJK UNIFIED IDEOGRAPH
    {0x85F8, 0x5497}, //944 #CJK UNIFIED IDEOGRAPH
    {0x85F9, 0x5498}, //945 #CJK UNIFIED IDEOGRAPH
    {0x85FA, 0x549C}, //946 #CJK UNIFIED IDEOGRAPH
    {0x85FB, 0x549E}, //947 #CJK UNIFIED IDEOGRAPH
    {0x85FC, 0x549F}, //948 #CJK UNIFIED IDEOGRAPH
    {0x85FD, 0x54A0}, //949 #CJK UNIFIED IDEOGRAPH
    {0x85FE, 0x54A1}, //950 #CJK UNIFIED IDEOGRAPH
    {0x8640, 0x54A2}, //951 #CJK UNIFIED IDEOGRAPH
    {0x8641, 0x54A5}, //952 #CJK UNIFIED IDEOGRAPH
    {0x8642, 0x54AE}, //953 #CJK UNIFIED IDEOGRAPH
    {0x8643, 0x54B0}, //954 #CJK UNIFIED IDEOGRAPH
    {0x8644, 0x54B2}, //955 #CJK UNIFIED IDEOGRAPH
    {0x8645, 0x54B5}, //956 #CJK UNIFIED IDEOGRAPH
    {0x8646, 0x54B6}, //957 #CJK UNIFIED IDEOGRAPH
    {0x8647, 0x54B7}, //958 #CJK UNIFIED IDEOGRAPH
    {0x8648, 0x54B9}, //959 #CJK UNIFIED IDEOGRAPH
    {0x8649, 0x54BA}, //960 #CJK UNIFIED IDEOGRAPH
    {0x864A, 0x54BC}, //961 #CJK UNIFIED IDEOGRAPH
    {0x864B, 0x54BE}, //962 #CJK UNIFIED IDEOGRAPH
    {0x864C, 0x54C3}, //963 #CJK UNIFIED IDEOGRAPH
    {0x864D, 0x54C5}, //964 #CJK UNIFIED IDEOGRAPH
    {0x864E, 0x54CA}, //965 #CJK UNIFIED IDEOGRAPH
    {0x864F, 0x54CB}, //966 #CJK UNIFIED IDEOGRAPH
    {0x8650, 0x54D6}, //967 #CJK UNIFIED IDEOGRAPH
    {0x8651, 0x54D8}, //968 #CJK UNIFIED IDEOGRAPH
    {0x8652, 0x54DB}, //969 #CJK UNIFIED IDEOGRAPH
    {0x8653, 0x54E0}, //970 #CJK UNIFIED IDEOGRAPH
    {0x8654, 0x54E1}, //971 #CJK UNIFIED IDEOGRAPH
    {0x8655, 0x54E2}, //972 #CJK UNIFIED IDEOGRAPH
    {0x8656, 0x54E3}, //973 #CJK UNIFIED IDEOGRAPH
    {0x8657, 0x54E4}, //974 #CJK UNIFIED IDEOGRAPH
    {0x8658, 0x54EB}, //975 #CJK UNIFIED IDEOGRAPH
    {0x8659, 0x54EC}, //976 #CJK UNIFIED IDEOGRAPH
    {0x865A, 0x54EF}, //977 #CJK UNIFIED IDEOGRAPH
    {0x865B, 0x54F0}, //978 #CJK UNIFIED IDEOGRAPH
    {0x865C, 0x54F1}, //979 #CJK UNIFIED IDEOGRAPH
    {0x865D, 0x54F4}, //980 #CJK UNIFIED IDEOGRAPH
    {0x865E, 0x54F5}, //981 #CJK UNIFIED IDEOGRAPH
    {0x865F, 0x54F6}, //982 #CJK UNIFIED IDEOGRAPH
    {0x8660, 0x54F7}, //983 #CJK UNIFIED IDEOGRAPH
    {0x8661, 0x54F8}, //984 #CJK UNIFIED IDEOGRAPH
    {0x8662, 0x54F9}, //985 #CJK UNIFIED IDEOGRAPH
    {0x8663, 0x54FB}, //986 #CJK UNIFIED IDEOGRAPH
    {0x8664, 0x54FE}, //987 #CJK UNIFIED IDEOGRAPH
    {0x8665, 0x5500}, //988 #CJK UNIFIED IDEOGRAPH
    {0x8666, 0x5502}, //989 #CJK UNIFIED IDEOGRAPH
    {0x8667, 0x5503}, //990 #CJK UNIFIED IDEOGRAPH
    {0x8668, 0x5504}, //991 #CJK UNIFIED IDEOGRAPH
    {0x8669, 0x5505}, //992 #CJK UNIFIED IDEOGRAPH
    {0x866A, 0x5508}, //993 #CJK UNIFIED IDEOGRAPH
    {0x866B, 0x550A}, //994 #CJK UNIFIED IDEOGRAPH
    {0x866C, 0x550B}, //995 #CJK UNIFIED IDEOGRAPH
    {0x866D, 0x550C}, //996 #CJK UNIFIED IDEOGRAPH
    {0x866E, 0x550D}, //997 #CJK UNIFIED IDEOGRAPH
    {0x866F, 0x550E}, //998 #CJK UNIFIED IDEOGRAPH
    {0x8670, 0x5512}, //999 #CJK UNIFIED IDEOGRAPH
    {0x8671, 0x5513}, //1000 #CJK UNIFIED IDEOGRAPH
    {0x8672, 0x5515}, //1001 #CJK UNIFIED IDEOGRAPH
    {0x8673, 0x5516}, //1002 #CJK UNIFIED IDEOGRAPH
    {0x8674, 0x5517}, //1003 #CJK UNIFIED IDEOGRAPH
    {0x8675, 0x5518}, //1004 #CJK UNIFIED IDEOGRAPH
    {0x8676, 0x5519}, //1005 #CJK UNIFIED IDEOGRAPH
    {0x8677, 0x551A}, //1006 #CJK UNIFIED IDEOGRAPH
    {0x8678, 0x551C}, //1007 #CJK UNIFIED IDEOGRAPH
    {0x8679, 0x551D}, //1008 #CJK UNIFIED IDEOGRAPH
    {0x867A, 0x551E}, //1009 #CJK UNIFIED IDEOGRAPH
    {0x867B, 0x551F}, //1010 #CJK UNIFIED IDEOGRAPH
    {0x867C, 0x5521}, //1011 #CJK UNIFIED IDEOGRAPH
    {0x867D, 0x5525}, //1012 #CJK UNIFIED IDEOGRAPH
    {0x867E, 0x5526}, //1013 #CJK UNIFIED IDEOGRAPH
    {0x8680, 0x5528}, //1014 #CJK UNIFIED IDEOGRAPH
    {0x8681, 0x5529}, //1015 #CJK UNIFIED IDEOGRAPH
    {0x8682, 0x552B}, //1016 #CJK UNIFIED IDEOGRAPH
    {0x8683, 0x552D}, //1017 #CJK UNIFIED IDEOGRAPH
    {0x8684, 0x5532}, //1018 #CJK UNIFIED IDEOGRAPH
    {0x8685, 0x5534}, //1019 #CJK UNIFIED IDEOGRAPH
    {0x8686, 0x5535}, //1020 #CJK UNIFIED IDEOGRAPH
    {0x8687, 0x5536}, //1021 #CJK UNIFIED IDEOGRAPH
    {0x8688, 0x5538}, //1022 #CJK UNIFIED IDEOGRAPH
    {0x8689, 0x5539}, //1023 #CJK UNIFIED IDEOGRAPH
    {0x868A, 0x553A}, //1024 #CJK UNIFIED IDEOGRAPH
    {0x868B, 0x553B}, //1025 #CJK UNIFIED IDEOGRAPH
    {0x868C, 0x553D}, //1026 #CJK UNIFIED IDEOGRAPH
    {0x868D, 0x5540}, //1027 #CJK UNIFIED IDEOGRAPH
    {0x868E, 0x5542}, //1028 #CJK UNIFIED IDEOGRAPH
    {0x868F, 0x5545}, //1029 #CJK UNIFIED IDEOGRAPH
    {0x8690, 0x5547}, //1030 #CJK UNIFIED IDEOGRAPH
    {0x8691, 0x5548}, //1031 #CJK UNIFIED IDEOGRAPH
    {0x8692, 0x554B}, //1032 #CJK UNIFIED IDEOGRAPH
    {0x8693, 0x554C}, //1033 #CJK UNIFIED IDEOGRAPH
    {0x8694, 0x554D}, //1034 #CJK UNIFIED IDEOGRAPH
    {0x8695, 0x554E}, //1035 #CJK UNIFIED IDEOGRAPH
    {0x8696, 0x554F}, //1036 #CJK UNIFIED IDEOGRAPH
    {0x8697, 0x5551}, //1037 #CJK UNIFIED IDEOGRAPH
    {0x8698, 0x5552}, //1038 #CJK UNIFIED IDEOGRAPH
    {0x8699, 0x5553}, //1039 #CJK UNIFIED IDEOGRAPH
    {0x869A, 0x5554}, //1040 #CJK UNIFIED IDEOGRAPH
    {0x869B, 0x5557}, //1041 #CJK UNIFIED IDEOGRAPH
    {0x869C, 0x5558}, //1042 #CJK UNIFIED IDEOGRAPH
    {0x869D, 0x5559}, //1043 #CJK UNIFIED IDEOGRAPH
    {0x869E, 0x555A}, //1044 #CJK UNIFIED IDEOGRAPH
    {0x869F, 0x555B}, //1045 #CJK UNIFIED IDEOGRAPH
    {0x86A0, 0x555D}, //1046 #CJK UNIFIED IDEOGRAPH
    {0x86A1, 0x555E}, //1047 #CJK UNIFIED IDEOGRAPH
    {0x86A2, 0x555F}, //1048 #CJK UNIFIED IDEOGRAPH
    {0x86A3, 0x5560}, //1049 #CJK UNIFIED IDEOGRAPH
    {0x86A4, 0x5562}, //1050 #CJK UNIFIED IDEOGRAPH
    {0x86A5, 0x5563}, //1051 #CJK UNIFIED IDEOGRAPH
    {0x86A6, 0x5568}, //1052 #CJK UNIFIED IDEOGRAPH
    {0x86A7, 0x5569}, //1053 #CJK UNIFIED IDEOGRAPH
    {0x86A8, 0x556B}, //1054 #CJK UNIFIED IDEOGRAPH
    {0x86A9, 0x556F}, //1055 #CJK UNIFIED IDEOGRAPH
    {0x86AA, 0x5570}, //1056 #CJK UNIFIED IDEOGRAPH
    {0x86AB, 0x5571}, //1057 #CJK UNIFIED IDEOGRAPH
    {0x86AC, 0x5572}, //1058 #CJK UNIFIED IDEOGRAPH
    {0x86AD, 0x5573}, //1059 #CJK UNIFIED IDEOGRAPH
    {0x86AE, 0x5574}, //1060 #CJK UNIFIED IDEOGRAPH
    {0x86AF, 0x5579}, //1061 #CJK UNIFIED IDEOGRAPH
    {0x86B0, 0x557A}, //1062 #CJK UNIFIED IDEOGRAPH
    {0x86B1, 0x557D}, //1063 #CJK UNIFIED IDEOGRAPH
    {0x86B2, 0x557F}, //1064 #CJK UNIFIED IDEOGRAPH
    {0x86B3, 0x5585}, //1065 #CJK UNIFIED IDEOGRAPH
    {0x86B4, 0x5586}, //1066 #CJK UNIFIED IDEOGRAPH
    {0x86B5, 0x558C}, //1067 #CJK UNIFIED IDEOGRAPH
    {0x86B6, 0x558D}, //1068 #CJK UNIFIED IDEOGRAPH
    {0x86B7, 0x558E}, //1069 #CJK UNIFIED IDEOGRAPH
    {0x86B8, 0x5590}, //1070 #CJK UNIFIED IDEOGRAPH
    {0x86B9, 0x5592}, //1071 #CJK UNIFIED IDEOGRAPH
    {0x86BA, 0x5593}, //1072 #CJK UNIFIED IDEOGRAPH
    {0x86BB, 0x5595}, //1073 #CJK UNIFIED IDEOGRAPH
    {0x86BC, 0x5596}, //1074 #CJK UNIFIED IDEOGRAPH
    {0x86BD, 0x5597}, //1075 #CJK UNIFIED IDEOGRAPH
    {0x86BE, 0x559A}, //1076 #CJK UNIFIED IDEOGRAPH
    {0x86BF, 0x559B}, //1077 #CJK UNIFIED IDEOGRAPH
    {0x86C0, 0x559E}, //1078 #CJK UNIFIED IDEOGRAPH
    {0x86C1, 0x55A0}, //1079 #CJK UNIFIED IDEOGRAPH
    {0x86C2, 0x55A1}, //1080 #CJK UNIFIED IDEOGRAPH
    {0x86C3, 0x55A2}, //1081 #CJK UNIFIED IDEOGRAPH
    {0x86C4, 0x55A3}, //1082 #CJK UNIFIED IDEOGRAPH
    {0x86C5, 0x55A4}, //1083 #CJK UNIFIED IDEOGRAPH
    {0x86C6, 0x55A5}, //1084 #CJK UNIFIED IDEOGRAPH
    {0x86C7, 0x55A6}, //1085 #CJK UNIFIED IDEOGRAPH
    {0x86C8, 0x55A8}, //1086 #CJK UNIFIED IDEOGRAPH
    {0x86C9, 0x55A9}, //1087 #CJK UNIFIED IDEOGRAPH
    {0x86CA, 0x55AA}, //1088 #CJK UNIFIED IDEOGRAPH
    {0x86CB, 0x55AB}, //1089 #CJK UNIFIED IDEOGRAPH
    {0x86CC, 0x55AC}, //1090 #CJK UNIFIED IDEOGRAPH
    {0x86CD, 0x55AD}, //1091 #CJK UNIFIED IDEOGRAPH
    {0x86CE, 0x55AE}, //1092 #CJK UNIFIED IDEOGRAPH
    {0x86CF, 0x55AF}, //1093 #CJK UNIFIED IDEOGRAPH
    {0x86D0, 0x55B0}, //1094 #CJK UNIFIED IDEOGRAPH
    {0x86D1, 0x55B2}, //1095 #CJK UNIFIED IDEOGRAPH
    {0x86D2, 0x55B4}, //1096 #CJK UNIFIED IDEOGRAPH
    {0x86D3, 0x55B6}, //1097 #CJK UNIFIED IDEOGRAPH
    {0x86D4, 0x55B8}, //1098 #CJK UNIFIED IDEOGRAPH
    {0x86D5, 0x55BA}, //1099 #CJK UNIFIED IDEOGRAPH
    {0x86D6, 0x55BC}, //1100 #CJK UNIFIED IDEOGRAPH
    {0x86D7, 0x55BF}, //1101 #CJK UNIFIED IDEOGRAPH
    {0x86D8, 0x55C0}, //1102 #CJK UNIFIED IDEOGRAPH
    {0x86D9, 0x55C1}, //1103 #CJK UNIFIED IDEOGRAPH
    {0x86DA, 0x55C2}, //1104 #CJK UNIFIED IDEOGRAPH
    {0x86DB, 0x55C3}, //1105 #CJK UNIFIED IDEOGRAPH
    {0x86DC, 0x55C6}, //1106 #CJK UNIFIED IDEOGRAPH
    {0x86DD, 0x55C7}, //1107 #CJK UNIFIED IDEOGRAPH
    {0x86DE, 0x55C8}, //1108 #CJK UNIFIED IDEOGRAPH
    {0x86DF, 0x55CA}, //1109 #CJK UNIFIED IDEOGRAPH
    {0x86E0, 0x55CB}, //1110 #CJK UNIFIED IDEOGRAPH
    {0x86E1, 0x55CE}, //1111 #CJK UNIFIED IDEOGRAPH
    {0x86E2, 0x55CF}, //1112 #CJK UNIFIED IDEOGRAPH
    {0x86E3, 0x55D0}, //1113 #CJK UNIFIED IDEOGRAPH
    {0x86E4, 0x55D5}, //1114 #CJK UNIFIED IDEOGRAPH
    {0x86E5, 0x55D7}, //1115 #CJK UNIFIED IDEOGRAPH
    {0x86E6, 0x55D8}, //1116 #CJK UNIFIED IDEOGRAPH
    {0x86E7, 0x55D9}, //1117 #CJK UNIFIED IDEOGRAPH
    {0x86E8, 0x55DA}, //1118 #CJK UNIFIED IDEOGRAPH
    {0x86E9, 0x55DB}, //1119 #CJK UNIFIED IDEOGRAPH
    {0x86EA, 0x55DE}, //1120 #CJK UNIFIED IDEOGRAPH
    {0x86EB, 0x55E0}, //1121 #CJK UNIFIED IDEOGRAPH
    {0x86EC, 0x55E2}, //1122 #CJK UNIFIED IDEOGRAPH
    {0x86ED, 0x55E7}, //1123 #CJK UNIFIED IDEOGRAPH
    {0x86EE, 0x55E9}, //1124 #CJK UNIFIED IDEOGRAPH
    {0x86EF, 0x55ED}, //1125 #CJK UNIFIED IDEOGRAPH
    {0x86F0, 0x55EE}, //1126 #CJK UNIFIED IDEOGRAPH
    {0x86F1, 0x55F0}, //1127 #CJK UNIFIED IDEOGRAPH
    {0x86F2, 0x55F1}, //1128 #CJK UNIFIED IDEOGRAPH
    {0x86F3, 0x55F4}, //1129 #CJK UNIFIED IDEOGRAPH
    {0x86F4, 0x55F6}, //1130 #CJK UNIFIED IDEOGRAPH
    {0x86F5, 0x55F8}, //1131 #CJK UNIFIED IDEOGRAPH
    {0x86F6, 0x55F9}, //1132 #CJK UNIFIED IDEOGRAPH
    {0x86F7, 0x55FA}, //1133 #CJK UNIFIED IDEOGRAPH
    {0x86F8, 0x55FB}, //1134 #CJK UNIFIED IDEOGRAPH
    {0x86F9, 0x55FC}, //1135 #CJK UNIFIED IDEOGRAPH
    {0x86FA, 0x55FF}, //1136 #CJK UNIFIED IDEOGRAPH
    {0x86FB, 0x5602}, //1137 #CJK UNIFIED IDEOGRAPH
    {0x86FC, 0x5603}, //1138 #CJK UNIFIED IDEOGRAPH
    {0x86FD, 0x5604}, //1139 #CJK UNIFIED IDEOGRAPH
    {0x86FE, 0x5605}, //1140 #CJK UNIFIED IDEOGRAPH
    {0x8740, 0x5606}, //1141 #CJK UNIFIED IDEOGRAPH
    {0x8741, 0x5607}, //1142 #CJK UNIFIED IDEOGRAPH
    {0x8742, 0x560A}, //1143 #CJK UNIFIED IDEOGRAPH
    {0x8743, 0x560B}, //1144 #CJK UNIFIED IDEOGRAPH
    {0x8744, 0x560D}, //1145 #CJK UNIFIED IDEOGRAPH
    {0x8745, 0x5610}, //1146 #CJK UNIFIED IDEOGRAPH
    {0x8746, 0x5611}, //1147 #CJK UNIFIED IDEOGRAPH
    {0x8747, 0x5612}, //1148 #CJK UNIFIED IDEOGRAPH
    {0x8748, 0x5613}, //1149 #CJK UNIFIED IDEOGRAPH
    {0x8749, 0x5614}, //1150 #CJK UNIFIED IDEOGRAPH
    {0x874A, 0x5615}, //1151 #CJK UNIFIED IDEOGRAPH
    {0x874B, 0x5616}, //1152 #CJK UNIFIED IDEOGRAPH
    {0x874C, 0x5617}, //1153 #CJK UNIFIED IDEOGRAPH
    {0x874D, 0x5619}, //1154 #CJK UNIFIED IDEOGRAPH
    {0x874E, 0x561A}, //1155 #CJK UNIFIED IDEOGRAPH
    {0x874F, 0x561C}, //1156 #CJK UNIFIED IDEOGRAPH
    {0x8750, 0x561D}, //1157 #CJK UNIFIED IDEOGRAPH
    {0x8751, 0x5620}, //1158 #CJK UNIFIED IDEOGRAPH
    {0x8752, 0x5621}, //1159 #CJK UNIFIED IDEOGRAPH
    {0x8753, 0x5622}, //1160 #CJK UNIFIED IDEOGRAPH
    {0x8754, 0x5625}, //1161 #CJK UNIFIED IDEOGRAPH
    {0x8755, 0x5626}, //1162 #CJK UNIFIED IDEOGRAPH
    {0x8756, 0x5628}, //1163 #CJK UNIFIED IDEOGRAPH
    {0x8757, 0x5629}, //1164 #CJK UNIFIED IDEOGRAPH
    {0x8758, 0x562A}, //1165 #CJK UNIFIED IDEOGRAPH
    {0x8759, 0x562B}, //1166 #CJK UNIFIED IDEOGRAPH
    {0x875A, 0x562E}, //1167 #CJK UNIFIED IDEOGRAPH
    {0x875B, 0x562F}, //1168 #CJK UNIFIED IDEOGRAPH
    {0x875C, 0x5630}, //1169 #CJK UNIFIED IDEOGRAPH
    {0x875D, 0x5633}, //1170 #CJK UNIFIED IDEOGRAPH
    {0x875E, 0x5635}, //1171 #CJK UNIFIED IDEOGRAPH
    {0x875F, 0x5637}, //1172 #CJK UNIFIED IDEOGRAPH
    {0x8760, 0x5638}, //1173 #CJK UNIFIED IDEOGRAPH
    {0x8761, 0x563A}, //1174 #CJK UNIFIED IDEOGRAPH
    {0x8762, 0x563C}, //1175 #CJK UNIFIED IDEOGRAPH
    {0x8763, 0x563D}, //1176 #CJK UNIFIED IDEOGRAPH
    {0x8764, 0x563E}, //1177 #CJK UNIFIED IDEOGRAPH
    {0x8765, 0x5640}, //1178 #CJK UNIFIED IDEOGRAPH
    {0x8766, 0x5641}, //1179 #CJK UNIFIED IDEOGRAPH
    {0x8767, 0x5642}, //1180 #CJK UNIFIED IDEOGRAPH
    {0x8768, 0x5643}, //1181 #CJK UNIFIED IDEOGRAPH
    {0x8769, 0x5644}, //1182 #CJK UNIFIED IDEOGRAPH
    {0x876A, 0x5645}, //1183 #CJK UNIFIED IDEOGRAPH
    {0x876B, 0x5646}, //1184 #CJK UNIFIED IDEOGRAPH
    {0x876C, 0x5647}, //1185 #CJK UNIFIED IDEOGRAPH
    {0x876D, 0x5648}, //1186 #CJK UNIFIED IDEOGRAPH
    {0x876E, 0x5649}, //1187 #CJK UNIFIED IDEOGRAPH
    {0x876F, 0x564A}, //1188 #CJK UNIFIED IDEOGRAPH
    {0x8770, 0x564B}, //1189 #CJK UNIFIED IDEOGRAPH
    {0x8771, 0x564F}, //1190 #CJK UNIFIED IDEOGRAPH
    {0x8772, 0x5650}, //1191 #CJK UNIFIED IDEOGRAPH
    {0x8773, 0x5651}, //1192 #CJK UNIFIED IDEOGRAPH
    {0x8774, 0x5652}, //1193 #CJK UNIFIED IDEOGRAPH
    {0x8775, 0x5653}, //1194 #CJK UNIFIED IDEOGRAPH
    {0x8776, 0x5655}, //1195 #CJK UNIFIED IDEOGRAPH
    {0x8777, 0x5656}, //1196 #CJK UNIFIED IDEOGRAPH
    {0x8778, 0x565A}, //1197 #CJK UNIFIED IDEOGRAPH
    {0x8779, 0x565B}, //1198 #CJK UNIFIED IDEOGRAPH
    {0x877A, 0x565D}, //1199 #CJK UNIFIED IDEOGRAPH
    {0x877B, 0x565E}, //1200 #CJK UNIFIED IDEOGRAPH
    {0x877C, 0x565F}, //1201 #CJK UNIFIED IDEOGRAPH
    {0x877D, 0x5660}, //1202 #CJK UNIFIED IDEOGRAPH
    {0x877E, 0x5661}, //1203 #CJK UNIFIED IDEOGRAPH
    {0x8780, 0x5663}, //1204 #CJK UNIFIED IDEOGRAPH
    {0x8781, 0x5665}, //1205 #CJK UNIFIED IDEOGRAPH
    {0x8782, 0x5666}, //1206 #CJK UNIFIED IDEOGRAPH
    {0x8783, 0x5667}, //1207 #CJK UNIFIED IDEOGRAPH
    {0x8784, 0x566D}, //1208 #CJK UNIFIED IDEOGRAPH
    {0x8785, 0x566E}, //1209 #CJK UNIFIED IDEOGRAPH
    {0x8786, 0x566F}, //1210 #CJK UNIFIED IDEOGRAPH
    {0x8787, 0x5670}, //1211 #CJK UNIFIED IDEOGRAPH
    {0x8788, 0x5672}, //1212 #CJK UNIFIED IDEOGRAPH
    {0x8789, 0x5673}, //1213 #CJK UNIFIED IDEOGRAPH
    {0x878A, 0x5674}, //1214 #CJK UNIFIED IDEOGRAPH
    {0x878B, 0x5675}, //1215 #CJK UNIFIED IDEOGRAPH
    {0x878C, 0x5677}, //1216 #CJK UNIFIED IDEOGRAPH
    {0x878D, 0x5678}, //1217 #CJK UNIFIED IDEOGRAPH
    {0x878E, 0x5679}, //1218 #CJK UNIFIED IDEOGRAPH
    {0x878F, 0x567A}, //1219 #CJK UNIFIED IDEOGRAPH
    {0x8790, 0x567D}, //1220 #CJK UNIFIED IDEOGRAPH
    {0x8791, 0x567E}, //1221 #CJK UNIFIED IDEOGRAPH
    {0x8792, 0x567F}, //1222 #CJK UNIFIED IDEOGRAPH
    {0x8793, 0x5680}, //1223 #CJK UNIFIED IDEOGRAPH
    {0x8794, 0x5681}, //1224 #CJK UNIFIED IDEOGRAPH
    {0x8795, 0x5682}, //1225 #CJK UNIFIED IDEOGRAPH
    {0x8796, 0x5683}, //1226 #CJK UNIFIED IDEOGRAPH
    {0x8797, 0x5684}, //1227 #CJK UNIFIED IDEOGRAPH
    {0x8798, 0x5687}, //1228 #CJK UNIFIED IDEOGRAPH
    {0x8799, 0x5688}, //1229 #CJK UNIFIED IDEOGRAPH
    {0x879A, 0x5689}, //1230 #CJK UNIFIED IDEOGRAPH
    {0x879B, 0x568A}, //1231 #CJK UNIFIED IDEOGRAPH
    {0x879C, 0x568B}, //1232 #CJK UNIFIED IDEOGRAPH
    {0x879D, 0x568C}, //1233 #CJK UNIFIED IDEOGRAPH
    {0x879E, 0x568D}, //1234 #CJK UNIFIED IDEOGRAPH
    {0x879F, 0x5690}, //1235 #CJK UNIFIED IDEOGRAPH
    {0x87A0, 0x5691}, //1236 #CJK UNIFIED IDEOGRAPH
    {0x87A1, 0x5692}, //1237 #CJK UNIFIED IDEOGRAPH
    {0x87A2, 0x5694}, //1238 #CJK UNIFIED IDEOGRAPH
    {0x87A3, 0x5695}, //1239 #CJK UNIFIED IDEOGRAPH
    {0x87A4, 0x5696}, //1240 #CJK UNIFIED IDEOGRAPH
    {0x87A5, 0x5697}, //1241 #CJK UNIFIED IDEOGRAPH
    {0x87A6, 0x5698}, //1242 #CJK UNIFIED IDEOGRAPH
    {0x87A7, 0x5699}, //1243 #CJK UNIFIED IDEOGRAPH
    {0x87A8, 0x569A}, //1244 #CJK UNIFIED IDEOGRAPH
    {0x87A9, 0x569B}, //1245 #CJK UNIFIED IDEOGRAPH
    {0x87AA, 0x569C}, //1246 #CJK UNIFIED IDEOGRAPH
    {0x87AB, 0x569D}, //1247 #CJK UNIFIED IDEOGRAPH
    {0x87AC, 0x569E}, //1248 #CJK UNIFIED IDEOGRAPH
    {0x87AD, 0x569F}, //1249 #CJK UNIFIED IDEOGRAPH
    {0x87AE, 0x56A0}, //1250 #CJK UNIFIED IDEOGRAPH
    {0x87AF, 0x56A1}, //1251 #CJK UNIFIED IDEOGRAPH
    {0x87B0, 0x56A2}, //1252 #CJK UNIFIED IDEOGRAPH
    {0x87B1, 0x56A4}, //1253 #CJK UNIFIED IDEOGRAPH
    {0x87B2, 0x56A5}, //1254 #CJK UNIFIED IDEOGRAPH
    {0x87B3, 0x56A6}, //1255 #CJK UNIFIED IDEOGRAPH
    {0x87B4, 0x56A7}, //1256 #CJK UNIFIED IDEOGRAPH
    {0x87B5, 0x56A8}, //1257 #CJK UNIFIED IDEOGRAPH
    {0x87B6, 0x56A9}, //1258 #CJK UNIFIED IDEOGRAPH
    {0x87B7, 0x56AA}, //1259 #CJK UNIFIED IDEOGRAPH
    {0x87B8, 0x56AB}, //1260 #CJK UNIFIED IDEOGRAPH
    {0x87B9, 0x56AC}, //1261 #CJK UNIFIED IDEOGRAPH
    {0x87BA, 0x56AD}, //1262 #CJK UNIFIED IDEOGRAPH
    {0x87BB, 0x56AE}, //1263 #CJK UNIFIED IDEOGRAPH
    {0x87BC, 0x56B0}, //1264 #CJK UNIFIED IDEOGRAPH
    {0x87BD, 0x56B1}, //1265 #CJK UNIFIED IDEOGRAPH
    {0x87BE, 0x56B2}, //1266 #CJK UNIFIED IDEOGRAPH
    {0x87BF, 0x56B3}, //1267 #CJK UNIFIED IDEOGRAPH
    {0x87C0, 0x56B4}, //1268 #CJK UNIFIED IDEOGRAPH
    {0x87C1, 0x56B5}, //1269 #CJK UNIFIED IDEOGRAPH
    {0x87C2, 0x56B6}, //1270 #CJK UNIFIED IDEOGRAPH
    {0x87C3, 0x56B8}, //1271 #CJK UNIFIED IDEOGRAPH
    {0x87C4, 0x56B9}, //1272 #CJK UNIFIED IDEOGRAPH
    {0x87C5, 0x56BA}, //1273 #CJK UNIFIED IDEOGRAPH
    {0x87C6, 0x56BB}, //1274 #CJK UNIFIED IDEOGRAPH
    {0x87C7, 0x56BD}, //1275 #CJK UNIFIED IDEOGRAPH
    {0x87C8, 0x56BE}, //1276 #CJK UNIFIED IDEOGRAPH
    {0x87C9, 0x56BF}, //1277 #CJK UNIFIED IDEOGRAPH
    {0x87CA, 0x56C0}, //1278 #CJK UNIFIED IDEOGRAPH
    {0x87CB, 0x56C1}, //1279 #CJK UNIFIED IDEOGRAPH
    {0x87CC, 0x56C2}, //1280 #CJK UNIFIED IDEOGRAPH
    {0x87CD, 0x56C3}, //1281 #CJK UNIFIED IDEOGRAPH
    {0x87CE, 0x56C4}, //1282 #CJK UNIFIED IDEOGRAPH
    {0x87CF, 0x56C5}, //1283 #CJK UNIFIED IDEOGRAPH
    {0x87D0, 0x56C6}, //1284 #CJK UNIFIED IDEOGRAPH
    {0x87D1, 0x56C7}, //1285 #CJK UNIFIED IDEOGRAPH
    {0x87D2, 0x56C8}, //1286 #CJK UNIFIED IDEOGRAPH
    {0x87D3, 0x56C9}, //1287 #CJK UNIFIED IDEOGRAPH
    {0x87D4, 0x56CB}, //1288 #CJK UNIFIED IDEOGRAPH
    {0x87D5, 0x56CC}, //1289 #CJK UNIFIED IDEOGRAPH
    {0x87D6, 0x56CD}, //1290 #CJK UNIFIED IDEOGRAPH
    {0x87D7, 0x56CE}, //1291 #CJK UNIFIED IDEOGRAPH
    {0x87D8, 0x56CF}, //1292 #CJK UNIFIED IDEOGRAPH
    {0x87D9, 0x56D0}, //1293 #CJK UNIFIED IDEOGRAPH
    {0x87DA, 0x56D1}, //1294 #CJK UNIFIED IDEOGRAPH
    {0x87DB, 0x56D2}, //1295 #CJK UNIFIED IDEOGRAPH
    {0x87DC, 0x56D3}, //1296 #CJK UNIFIED IDEOGRAPH
    {0x87DD, 0x56D5}, //1297 #CJK UNIFIED IDEOGRAPH
    {0x87DE, 0x56D6}, //1298 #CJK UNIFIED IDEOGRAPH
    {0x87DF, 0x56D8}, //1299 #CJK UNIFIED IDEOGRAPH
    {0x87E0, 0x56D9}, //1300 #CJK UNIFIED IDEOGRAPH
    {0x87E1, 0x56DC}, //1301 #CJK UNIFIED IDEOGRAPH
    {0x87E2, 0x56E3}, //1302 #CJK UNIFIED IDEOGRAPH
    {0x87E3, 0x56E5}, //1303 #CJK UNIFIED IDEOGRAPH
    {0x87E4, 0x56E6}, //1304 #CJK UNIFIED IDEOGRAPH
    {0x87E5, 0x56E7}, //1305 #CJK UNIFIED IDEOGRAPH
    {0x87E6, 0x56E8}, //1306 #CJK UNIFIED IDEOGRAPH
    {0x87E7, 0x56E9}, //1307 #CJK UNIFIED IDEOGRAPH
    {0x87E8, 0x56EA}, //1308 #CJK UNIFIED IDEOGRAPH
    {0x87E9, 0x56EC}, //1309 #CJK UNIFIED IDEOGRAPH
    {0x87EA, 0x56EE}, //1310 #CJK UNIFIED IDEOGRAPH
    {0x87EB, 0x56EF}, //1311 #CJK UNIFIED IDEOGRAPH
    {0x87EC, 0x56F2}, //1312 #CJK UNIFIED IDEOGRAPH
    {0x87ED, 0x56F3}, //1313 #CJK UNIFIED IDEOGRAPH
    {0x87EE, 0x56F6}, //1314 #CJK UNIFIED IDEOGRAPH
    {0x87EF, 0x56F7}, //1315 #CJK UNIFIED IDEOGRAPH
    {0x87F0, 0x56F8}, //1316 #CJK UNIFIED IDEOGRAPH
    {0x87F1, 0x56FB}, //1317 #CJK UNIFIED IDEOGRAPH
    {0x87F2, 0x56FC}, //1318 #CJK UNIFIED IDEOGRAPH
    {0x87F3, 0x5700}, //1319 #CJK UNIFIED IDEOGRAPH
    {0x87F4, 0x5701}, //1320 #CJK UNIFIED IDEOGRAPH
    {0x87F5, 0x5702}, //1321 #CJK UNIFIED IDEOGRAPH
    {0x87F6, 0x5705}, //1322 #CJK UNIFIED IDEOGRAPH
    {0x87F7, 0x5707}, //1323 #CJK UNIFIED IDEOGRAPH
    {0x87F8, 0x570B}, //1324 #CJK UNIFIED IDEOGRAPH
    {0x87F9, 0x570C}, //1325 #CJK UNIFIED IDEOGRAPH
    {0x87FA, 0x570D}, //1326 #CJK UNIFIED IDEOGRAPH
    {0x87FB, 0x570E}, //1327 #CJK UNIFIED IDEOGRAPH
    {0x87FC, 0x570F}, //1328 #CJK UNIFIED IDEOGRAPH
    {0x87FD, 0x5710}, //1329 #CJK UNIFIED IDEOGRAPH
    {0x87FE, 0x5711}, //1330 #CJK UNIFIED IDEOGRAPH
    {0x8840, 0x5712}, //1331 #CJK UNIFIED IDEOGRAPH
    {0x8841, 0x5713}, //1332 #CJK UNIFIED IDEOGRAPH
    {0x8842, 0x5714}, //1333 #CJK UNIFIED IDEOGRAPH
    {0x8843, 0x5715}, //1334 #CJK UNIFIED IDEOGRAPH
    {0x8844, 0x5716}, //1335 #CJK UNIFIED IDEOGRAPH
    {0x8845, 0x5717}, //1336 #CJK UNIFIED IDEOGRAPH
    {0x8846, 0x5718}, //1337 #CJK UNIFIED IDEOGRAPH
    {0x8847, 0x5719}, //1338 #CJK UNIFIED IDEOGRAPH
    {0x8848, 0x571A}, //1339 #CJK UNIFIED IDEOGRAPH
    {0x8849, 0x571B}, //1340 #CJK UNIFIED IDEOGRAPH
    {0x884A, 0x571D}, //1341 #CJK UNIFIED IDEOGRAPH
    {0x884B, 0x571E}, //1342 #CJK UNIFIED IDEOGRAPH
    {0x884C, 0x5720}, //1343 #CJK UNIFIED IDEOGRAPH
    {0x884D, 0x5721}, //1344 #CJK UNIFIED IDEOGRAPH
    {0x884E, 0x5722}, //1345 #CJK UNIFIED IDEOGRAPH
    {0x884F, 0x5724}, //1346 #CJK UNIFIED IDEOGRAPH
    {0x8850, 0x5725}, //1347 #CJK UNIFIED IDEOGRAPH
    {0x8851, 0x5726}, //1348 #CJK UNIFIED IDEOGRAPH
    {0x8852, 0x5727}, //1349 #CJK UNIFIED IDEOGRAPH
    {0x8853, 0x572B}, //1350 #CJK UNIFIED IDEOGRAPH
    {0x8854, 0x5731}, //1351 #CJK UNIFIED IDEOGRAPH
    {0x8855, 0x5732}, //1352 #CJK UNIFIED IDEOGRAPH
    {0x8856, 0x5734}, //1353 #CJK UNIFIED IDEOGRAPH
    {0x8857, 0x5735}, //1354 #CJK UNIFIED IDEOGRAPH
    {0x8858, 0x5736}, //1355 #CJK UNIFIED IDEOGRAPH
    {0x8859, 0x5737}, //1356 #CJK UNIFIED IDEOGRAPH
    {0x885A, 0x5738}, //1357 #CJK UNIFIED IDEOGRAPH
    {0x885B, 0x573C}, //1358 #CJK UNIFIED IDEOGRAPH
    {0x885C, 0x573D}, //1359 #CJK UNIFIED IDEOGRAPH
    {0x885D, 0x573F}, //1360 #CJK UNIFIED IDEOGRAPH
    {0x885E, 0x5741}, //1361 #CJK UNIFIED IDEOGRAPH
    {0x885F, 0x5743}, //1362 #CJK UNIFIED IDEOGRAPH
    {0x8860, 0x5744}, //1363 #CJK UNIFIED IDEOGRAPH
    {0x8861, 0x5745}, //1364 #CJK UNIFIED IDEOGRAPH
    {0x8862, 0x5746}, //1365 #CJK UNIFIED IDEOGRAPH
    {0x8863, 0x5748}, //1366 #CJK UNIFIED IDEOGRAPH
    {0x8864, 0x5749}, //1367 #CJK UNIFIED IDEOGRAPH
    {0x8865, 0x574B}, //1368 #CJK UNIFIED IDEOGRAPH
    {0x8866, 0x5752}, //1369 #CJK UNIFIED IDEOGRAPH
    {0x8867, 0x5753}, //1370 #CJK UNIFIED IDEOGRAPH
    {0x8868, 0x5754}, //1371 #CJK UNIFIED IDEOGRAPH
    {0x8869, 0x5755}, //1372 #CJK UNIFIED IDEOGRAPH
    {0x886A, 0x5756}, //1373 #CJK UNIFIED IDEOGRAPH
    {0x886B, 0x5758}, //1374 #CJK UNIFIED IDEOGRAPH
    {0x886C, 0x5759}, //1375 #CJK UNIFIED IDEOGRAPH
    {0x886D, 0x5762}, //1376 #CJK UNIFIED IDEOGRAPH
    {0x886E, 0x5763}, //1377 #CJK UNIFIED IDEOGRAPH
    {0x886F, 0x5765}, //1378 #CJK UNIFIED IDEOGRAPH
    {0x8870, 0x5767}, //1379 #CJK UNIFIED IDEOGRAPH
    {0x8871, 0x576C}, //1380 #CJK UNIFIED IDEOGRAPH
    {0x8872, 0x576E}, //1381 #CJK UNIFIED IDEOGRAPH
    {0x8873, 0x5770}, //1382 #CJK UNIFIED IDEOGRAPH
    {0x8874, 0x5771}, //1383 #CJK UNIFIED IDEOGRAPH
    {0x8875, 0x5772}, //1384 #CJK UNIFIED IDEOGRAPH
    {0x8876, 0x5774}, //1385 #CJK UNIFIED IDEOGRAPH
    {0x8877, 0x5775}, //1386 #CJK UNIFIED IDEOGRAPH
    {0x8878, 0x5778}, //1387 #CJK UNIFIED IDEOGRAPH
    {0x8879, 0x5779}, //1388 #CJK UNIFIED IDEOGRAPH
    {0x887A, 0x577A}, //1389 #CJK UNIFIED IDEOGRAPH
    {0x887B, 0x577D}, //1390 #CJK UNIFIED IDEOGRAPH
    {0x887C, 0x577E}, //1391 #CJK UNIFIED IDEOGRAPH
    {0x887D, 0x577F}, //1392 #CJK UNIFIED IDEOGRAPH
    {0x887E, 0x5780}, //1393 #CJK UNIFIED IDEOGRAPH
    {0x8880, 0x5781}, //1394 #CJK UNIFIED IDEOGRAPH
    {0x8881, 0x5787}, //1395 #CJK UNIFIED IDEOGRAPH
    {0x8882, 0x5788}, //1396 #CJK UNIFIED IDEOGRAPH
    {0x8883, 0x5789}, //1397 #CJK UNIFIED IDEOGRAPH
    {0x8884, 0x578A}, //1398 #CJK UNIFIED IDEOGRAPH
    {0x8885, 0x578D}, //1399 #CJK UNIFIED IDEOGRAPH
    {0x8886, 0x578E}, //1400 #CJK UNIFIED IDEOGRAPH
    {0x8887, 0x578F}, //1401 #CJK UNIFIED IDEOGRAPH
    {0x8888, 0x5790}, //1402 #CJK UNIFIED IDEOGRAPH
    {0x8889, 0x5791}, //1403 #CJK UNIFIED IDEOGRAPH
    {0x888A, 0x5794}, //1404 #CJK UNIFIED IDEOGRAPH
    {0x888B, 0x5795}, //1405 #CJK UNIFIED IDEOGRAPH
    {0x888C, 0x5796}, //1406 #CJK UNIFIED IDEOGRAPH
    {0x888D, 0x5797}, //1407 #CJK UNIFIED IDEOGRAPH
    {0x888E, 0x5798}, //1408 #CJK UNIFIED IDEOGRAPH
    {0x888F, 0x5799}, //1409 #CJK UNIFIED IDEOGRAPH
    {0x8890, 0x579A}, //1410 #CJK UNIFIED IDEOGRAPH
    {0x8891, 0x579C}, //1411 #CJK UNIFIED IDEOGRAPH
    {0x8892, 0x579D}, //1412 #CJK UNIFIED IDEOGRAPH
    {0x8893, 0x579E}, //1413 #CJK UNIFIED IDEOGRAPH
    {0x8894, 0x579F}, //1414 #CJK UNIFIED IDEOGRAPH
    {0x8895, 0x57A5}, //1415 #CJK UNIFIED IDEOGRAPH
    {0x8896, 0x57A8}, //1416 #CJK UNIFIED IDEOGRAPH
    {0x8897, 0x57AA}, //1417 #CJK UNIFIED IDEOGRAPH
    {0x8898, 0x57AC}, //1418 #CJK UNIFIED IDEOGRAPH
    {0x8899, 0x57AF}, //1419 #CJK UNIFIED IDEOGRAPH
    {0x889A, 0x57B0}, //1420 #CJK UNIFIED IDEOGRAPH
    {0x889B, 0x57B1}, //1421 #CJK UNIFIED IDEOGRAPH
    {0x889C, 0x57B3}, //1422 #CJK UNIFIED IDEOGRAPH
    {0x889D, 0x57B5}, //1423 #CJK UNIFIED IDEOGRAPH
    {0x889E, 0x57B6}, //1424 #CJK UNIFIED IDEOGRAPH
    {0x889F, 0x57B7}, //1425 #CJK UNIFIED IDEOGRAPH
    {0x88A0, 0x57B9}, //1426 #CJK UNIFIED IDEOGRAPH
    {0x88A1, 0x57BA}, //1427 #CJK UNIFIED IDEOGRAPH
    {0x88A2, 0x57BB}, //1428 #CJK UNIFIED IDEOGRAPH
    {0x88A3, 0x57BC}, //1429 #CJK UNIFIED IDEOGRAPH
    {0x88A4, 0x57BD}, //1430 #CJK UNIFIED IDEOGRAPH
    {0x88A5, 0x57BE}, //1431 #CJK UNIFIED IDEOGRAPH
    {0x88A6, 0x57BF}, //1432 #CJK UNIFIED IDEOGRAPH
    {0x88A7, 0x57C0}, //1433 #CJK UNIFIED IDEOGRAPH
    {0x88A8, 0x57C1}, //1434 #CJK UNIFIED IDEOGRAPH
    {0x88A9, 0x57C4}, //1435 #CJK UNIFIED IDEOGRAPH
    {0x88AA, 0x57C5}, //1436 #CJK UNIFIED IDEOGRAPH
    {0x88AB, 0x57C6}, //1437 #CJK UNIFIED IDEOGRAPH
    {0x88AC, 0x57C7}, //1438 #CJK UNIFIED IDEOGRAPH
    {0x88AD, 0x57C8}, //1439 #CJK UNIFIED IDEOGRAPH
    {0x88AE, 0x57C9}, //1440 #CJK UNIFIED IDEOGRAPH
    {0x88AF, 0x57CA}, //1441 #CJK UNIFIED IDEOGRAPH
    {0x88B0, 0x57CC}, //1442 #CJK UNIFIED IDEOGRAPH
    {0x88B1, 0x57CD}, //1443 #CJK UNIFIED IDEOGRAPH
    {0x88B2, 0x57D0}, //1444 #CJK UNIFIED IDEOGRAPH
    {0x88B3, 0x57D1}, //1445 #CJK UNIFIED IDEOGRAPH
    {0x88B4, 0x57D3}, //1446 #CJK UNIFIED IDEOGRAPH
    {0x88B5, 0x57D6}, //1447 #CJK UNIFIED IDEOGRAPH
    {0x88B6, 0x57D7}, //1448 #CJK UNIFIED IDEOGRAPH
    {0x88B7, 0x57DB}, //1449 #CJK UNIFIED IDEOGRAPH
    {0x88B8, 0x57DC}, //1450 #CJK UNIFIED IDEOGRAPH
    {0x88B9, 0x57DE}, //1451 #CJK UNIFIED IDEOGRAPH
    {0x88BA, 0x57E1}, //1452 #CJK UNIFIED IDEOGRAPH
    {0x88BB, 0x57E2}, //1453 #CJK UNIFIED IDEOGRAPH
    {0x88BC, 0x57E3}, //1454 #CJK UNIFIED IDEOGRAPH
    {0x88BD, 0x57E5}, //1455 #CJK UNIFIED IDEOGRAPH
    {0x88BE, 0x57E6}, //1456 #CJK UNIFIED IDEOGRAPH
    {0x88BF, 0x57E7}, //1457 #CJK UNIFIED IDEOGRAPH
    {0x88C0, 0x57E8}, //1458 #CJK UNIFIED IDEOGRAPH
    {0x88C1, 0x57E9}, //1459 #CJK UNIFIED IDEOGRAPH
    {0x88C2, 0x57EA}, //1460 #CJK UNIFIED IDEOGRAPH
    {0x88C3, 0x57EB}, //1461 #CJK UNIFIED IDEOGRAPH
    {0x88C4, 0x57EC}, //1462 #CJK UNIFIED IDEOGRAPH
    {0x88C5, 0x57EE}, //1463 #CJK UNIFIED IDEOGRAPH
    {0x88C6, 0x57F0}, //1464 #CJK UNIFIED IDEOGRAPH
    {0x88C7, 0x57F1}, //1465 #CJK UNIFIED IDEOGRAPH
    {0x88C8, 0x57F2}, //1466 #CJK UNIFIED IDEOGRAPH
    {0x88C9, 0x57F3}, //1467 #CJK UNIFIED IDEOGRAPH
    {0x88CA, 0x57F5}, //1468 #CJK UNIFIED IDEOGRAPH
    {0x88CB, 0x57F6}, //1469 #CJK UNIFIED IDEOGRAPH
    {0x88CC, 0x57F7}, //1470 #CJK UNIFIED IDEOGRAPH
    {0x88CD, 0x57FB}, //1471 #CJK UNIFIED IDEOGRAPH
    {0x88CE, 0x57FC}, //1472 #CJK UNIFIED IDEOGRAPH
    {0x88CF, 0x57FE}, //1473 #CJK UNIFIED IDEOGRAPH
    {0x88D0, 0x57FF}, //1474 #CJK UNIFIED IDEOGRAPH
    {0x88D1, 0x5801}, //1475 #CJK UNIFIED IDEOGRAPH
    {0x88D2, 0x5803}, //1476 #CJK UNIFIED IDEOGRAPH
    {0x88D3, 0x5804}, //1477 #CJK UNIFIED IDEOGRAPH
    {0x88D4, 0x5805}, //1478 #CJK UNIFIED IDEOGRAPH
    {0x88D5, 0x5808}, //1479 #CJK UNIFIED IDEOGRAPH
    {0x88D6, 0x5809}, //1480 #CJK UNIFIED IDEOGRAPH
    {0x88D7, 0x580A}, //1481 #CJK UNIFIED IDEOGRAPH
    {0x88D8, 0x580C}, //1482 #CJK UNIFIED IDEOGRAPH
    {0x88D9, 0x580E}, //1483 #CJK UNIFIED IDEOGRAPH
    {0x88DA, 0x580F}, //1484 #CJK UNIFIED IDEOGRAPH
    {0x88DB, 0x5810}, //1485 #CJK UNIFIED IDEOGRAPH
    {0x88DC, 0x5812}, //1486 #CJK UNIFIED IDEOGRAPH
    {0x88DD, 0x5813}, //1487 #CJK UNIFIED IDEOGRAPH
    {0x88DE, 0x5814}, //1488 #CJK UNIFIED IDEOGRAPH
    {0x88DF, 0x5816}, //1489 #CJK UNIFIED IDEOGRAPH
    {0x88E0, 0x5817}, //1490 #CJK UNIFIED IDEOGRAPH
    {0x88E1, 0x5818}, //1491 #CJK UNIFIED IDEOGRAPH
    {0x88E2, 0x581A}, //1492 #CJK UNIFIED IDEOGRAPH
    {0x88E3, 0x581B}, //1493 #CJK UNIFIED IDEOGRAPH
    {0x88E4, 0x581C}, //1494 #CJK UNIFIED IDEOGRAPH
    {0x88E5, 0x581D}, //1495 #CJK UNIFIED IDEOGRAPH
    {0x88E6, 0x581F}, //1496 #CJK UNIFIED IDEOGRAPH
    {0x88E7, 0x5822}, //1497 #CJK UNIFIED IDEOGRAPH
    {0x88E8, 0x5823}, //1498 #CJK UNIFIED IDEOGRAPH
    {0x88E9, 0x5825}, //1499 #CJK UNIFIED IDEOGRAPH
    {0x88EA, 0x5826}, //1500 #CJK UNIFIED IDEOGRAPH
    {0x88EB, 0x5827}, //1501 #CJK UNIFIED IDEOGRAPH
    {0x88EC, 0x5828}, //1502 #CJK UNIFIED IDEOGRAPH
    {0x88ED, 0x5829}, //1503 #CJK UNIFIED IDEOGRAPH
    {0x88EE, 0x582B}, //1504 #CJK UNIFIED IDEOGRAPH
    {0x88EF, 0x582C}, //1505 #CJK UNIFIED IDEOGRAPH
    {0x88F0, 0x582D}, //1506 #CJK UNIFIED IDEOGRAPH
    {0x88F1, 0x582E}, //1507 #CJK UNIFIED IDEOGRAPH
    {0x88F2, 0x582F}, //1508 #CJK UNIFIED IDEOGRAPH
    {0x88F3, 0x5831}, //1509 #CJK UNIFIED IDEOGRAPH
    {0x88F4, 0x5832}, //1510 #CJK UNIFIED IDEOGRAPH
    {0x88F5, 0x5833}, //1511 #CJK UNIFIED IDEOGRAPH
    {0x88F6, 0x5834}, //1512 #CJK UNIFIED IDEOGRAPH
    {0x88F7, 0x5836}, //1513 #CJK UNIFIED IDEOGRAPH
    {0x88F8, 0x5837}, //1514 #CJK UNIFIED IDEOGRAPH
    {0x88F9, 0x5838}, //1515 #CJK UNIFIED IDEOGRAPH
    {0x88FA, 0x5839}, //1516 #CJK UNIFIED IDEOGRAPH
    {0x88FB, 0x583A}, //1517 #CJK UNIFIED IDEOGRAPH
    {0x88FC, 0x583B}, //1518 #CJK UNIFIED IDEOGRAPH
    {0x88FD, 0x583C}, //1519 #CJK UNIFIED IDEOGRAPH
    {0x88FE, 0x583D}, //1520 #CJK UNIFIED IDEOGRAPH
    {0x8940, 0x583E}, //1521 #CJK UNIFIED IDEOGRAPH
    {0x8941, 0x583F}, //1522 #CJK UNIFIED IDEOGRAPH
    {0x8942, 0x5840}, //1523 #CJK UNIFIED IDEOGRAPH
    {0x8943, 0x5841}, //1524 #CJK UNIFIED IDEOGRAPH
    {0x8944, 0x5842}, //1525 #CJK UNIFIED IDEOGRAPH
    {0x8945, 0x5843}, //1526 #CJK UNIFIED IDEOGRAPH
    {0x8946, 0x5845}, //1527 #CJK UNIFIED IDEOGRAPH
    {0x8947, 0x5846}, //1528 #CJK UNIFIED IDEOGRAPH
    {0x8948, 0x5847}, //1529 #CJK UNIFIED IDEOGRAPH
    {0x8949, 0x5848}, //1530 #CJK UNIFIED IDEOGRAPH
    {0x894A, 0x5849}, //1531 #CJK UNIFIED IDEOGRAPH
    {0x894B, 0x584A}, //1532 #CJK UNIFIED IDEOGRAPH
    {0x894C, 0x584B}, //1533 #CJK UNIFIED IDEOGRAPH
    {0x894D, 0x584E}, //1534 #CJK UNIFIED IDEOGRAPH
    {0x894E, 0x584F}, //1535 #CJK UNIFIED IDEOGRAPH
    {0x894F, 0x5850}, //1536 #CJK UNIFIED IDEOGRAPH
    {0x8950, 0x5852}, //1537 #CJK UNIFIED IDEOGRAPH
    {0x8951, 0x5853}, //1538 #CJK UNIFIED IDEOGRAPH
    {0x8952, 0x5855}, //1539 #CJK UNIFIED IDEOGRAPH
    {0x8953, 0x5856}, //1540 #CJK UNIFIED IDEOGRAPH
    {0x8954, 0x5857}, //1541 #CJK UNIFIED IDEOGRAPH
    {0x8955, 0x5859}, //1542 #CJK UNIFIED IDEOGRAPH
    {0x8956, 0x585A}, //1543 #CJK UNIFIED IDEOGRAPH
    {0x8957, 0x585B}, //1544 #CJK UNIFIED IDEOGRAPH
    {0x8958, 0x585C}, //1545 #CJK UNIFIED IDEOGRAPH
    {0x8959, 0x585D}, //1546 #CJK UNIFIED IDEOGRAPH
    {0x895A, 0x585F}, //1547 #CJK UNIFIED IDEOGRAPH
    {0x895B, 0x5860}, //1548 #CJK UNIFIED IDEOGRAPH
    {0x895C, 0x5861}, //1549 #CJK UNIFIED IDEOGRAPH
    {0x895D, 0x5862}, //1550 #CJK UNIFIED IDEOGRAPH
    {0x895E, 0x5863}, //1551 #CJK UNIFIED IDEOGRAPH
    {0x895F, 0x5864}, //1552 #CJK UNIFIED IDEOGRAPH
    {0x8960, 0x5866}, //1553 #CJK UNIFIED IDEOGRAPH
    {0x8961, 0x5867}, //1554 #CJK UNIFIED IDEOGRAPH
    {0x8962, 0x5868}, //1555 #CJK UNIFIED IDEOGRAPH
    {0x8963, 0x5869}, //1556 #CJK UNIFIED IDEOGRAPH
    {0x8964, 0x586A}, //1557 #CJK UNIFIED IDEOGRAPH
    {0x8965, 0x586D}, //1558 #CJK UNIFIED IDEOGRAPH
    {0x8966, 0x586E}, //1559 #CJK UNIFIED IDEOGRAPH
    {0x8967, 0x586F}, //1560 #CJK UNIFIED IDEOGRAPH
    {0x8968, 0x5870}, //1561 #CJK UNIFIED IDEOGRAPH
    {0x8969, 0x5871}, //1562 #CJK UNIFIED IDEOGRAPH
    {0x896A, 0x5872}, //1563 #CJK UNIFIED IDEOGRAPH
    {0x896B, 0x5873}, //1564 #CJK UNIFIED IDEOGRAPH
    {0x896C, 0x5874}, //1565 #CJK UNIFIED IDEOGRAPH
    {0x896D, 0x5875}, //1566 #CJK UNIFIED IDEOGRAPH
    {0x896E, 0x5876}, //1567 #CJK UNIFIED IDEOGRAPH
    {0x896F, 0x5877}, //1568 #CJK UNIFIED IDEOGRAPH
    {0x8970, 0x5878}, //1569 #CJK UNIFIED IDEOGRAPH
    {0x8971, 0x5879}, //1570 #CJK UNIFIED IDEOGRAPH
    {0x8972, 0x587A}, //1571 #CJK UNIFIED IDEOGRAPH
    {0x8973, 0x587B}, //1572 #CJK UNIFIED IDEOGRAPH
    {0x8974, 0x587C}, //1573 #CJK UNIFIED IDEOGRAPH
    {0x8975, 0x587D}, //1574 #CJK UNIFIED IDEOGRAPH
    {0x8976, 0x587F}, //1575 #CJK UNIFIED IDEOGRAPH
    {0x8977, 0x5882}, //1576 #CJK UNIFIED IDEOGRAPH
    {0x8978, 0x5884}, //1577 #CJK UNIFIED IDEOGRAPH
    {0x8979, 0x5886}, //1578 #CJK UNIFIED IDEOGRAPH
    {0x897A, 0x5887}, //1579 #CJK UNIFIED IDEOGRAPH
    {0x897B, 0x5888}, //1580 #CJK UNIFIED IDEOGRAPH
    {0x897C, 0x588A}, //1581 #CJK UNIFIED IDEOGRAPH
    {0x897D, 0x588B}, //1582 #CJK UNIFIED IDEOGRAPH
    {0x897E, 0x588C}, //1583 #CJK UNIFIED IDEOGRAPH
    {0x8980, 0x588D}, //1584 #CJK UNIFIED IDEOGRAPH
    {0x8981, 0x588E}, //1585 #CJK UNIFIED IDEOGRAPH
    {0x8982, 0x588F}, //1586 #CJK UNIFIED IDEOGRAPH
    {0x8983, 0x5890}, //1587 #CJK UNIFIED IDEOGRAPH
    {0x8984, 0x5891}, //1588 #CJK UNIFIED IDEOGRAPH
    {0x8985, 0x5894}, //1589 #CJK UNIFIED IDEOGRAPH
    {0x8986, 0x5895}, //1590 #CJK UNIFIED IDEOGRAPH
    {0x8987, 0x5896}, //1591 #CJK UNIFIED IDEOGRAPH
    {0x8988, 0x5897}, //1592 #CJK UNIFIED IDEOGRAPH
    {0x8989, 0x5898}, //1593 #CJK UNIFIED IDEOGRAPH
    {0x898A, 0x589B}, //1594 #CJK UNIFIED IDEOGRAPH
    {0x898B, 0x589C}, //1595 #CJK UNIFIED IDEOGRAPH
    {0x898C, 0x589D}, //1596 #CJK UNIFIED IDEOGRAPH
    {0x898D, 0x58A0}, //1597 #CJK UNIFIED IDEOGRAPH
    {0x898E, 0x58A1}, //1598 #CJK UNIFIED IDEOGRAPH
    {0x898F, 0x58A2}, //1599 #CJK UNIFIED IDEOGRAPH
    {0x8990, 0x58A3}, //1600 #CJK UNIFIED IDEOGRAPH
    {0x8991, 0x58A4}, //1601 #CJK UNIFIED IDEOGRAPH
    {0x8992, 0x58A5}, //1602 #CJK UNIFIED IDEOGRAPH
    {0x8993, 0x58A6}, //1603 #CJK UNIFIED IDEOGRAPH
    {0x8994, 0x58A7}, //1604 #CJK UNIFIED IDEOGRAPH
    {0x8995, 0x58AA}, //1605 #CJK UNIFIED IDEOGRAPH
    {0x8996, 0x58AB}, //1606 #CJK UNIFIED IDEOGRAPH
    {0x8997, 0x58AC}, //1607 #CJK UNIFIED IDEOGRAPH
    {0x8998, 0x58AD}, //1608 #CJK UNIFIED IDEOGRAPH
    {0x8999, 0x58AE}, //1609 #CJK UNIFIED IDEOGRAPH
    {0x899A, 0x58AF}, //1610 #CJK UNIFIED IDEOGRAPH
    {0x899B, 0x58B0}, //1611 #CJK UNIFIED IDEOGRAPH
    {0x899C, 0x58B1}, //1612 #CJK UNIFIED IDEOGRAPH
    {0x899D, 0x58B2}, //1613 #CJK UNIFIED IDEOGRAPH
    {0x899E, 0x58B3}, //1614 #CJK UNIFIED IDEOGRAPH
    {0x899F, 0x58B4}, //1615 #CJK UNIFIED IDEOGRAPH
    {0x89A0, 0x58B5}, //1616 #CJK UNIFIED IDEOGRAPH
    {0x89A1, 0x58B6}, //1617 #CJK UNIFIED IDEOGRAPH
    {0x89A2, 0x58B7}, //1618 #CJK UNIFIED IDEOGRAPH
    {0x89A3, 0x58B8}, //1619 #CJK UNIFIED IDEOGRAPH
    {0x89A4, 0x58B9}, //1620 #CJK UNIFIED IDEOGRAPH
    {0x89A5, 0x58BA}, //1621 #CJK UNIFIED IDEOGRAPH
    {0x89A6, 0x58BB}, //1622 #CJK UNIFIED IDEOGRAPH
    {0x89A7, 0x58BD}, //1623 #CJK UNIFIED IDEOGRAPH
    {0x89A8, 0x58BE}, //1624 #CJK UNIFIED IDEOGRAPH
    {0x89A9, 0x58BF}, //1625 #CJK UNIFIED IDEOGRAPH
    {0x89AA, 0x58C0}, //1626 #CJK UNIFIED IDEOGRAPH
    {0x89AB, 0x58C2}, //1627 #CJK UNIFIED IDEOGRAPH
    {0x89AC, 0x58C3}, //1628 #CJK UNIFIED IDEOGRAPH
    {0x89AD, 0x58C4}, //1629 #CJK UNIFIED IDEOGRAPH
    {0x89AE, 0x58C6}, //1630 #CJK UNIFIED IDEOGRAPH
    {0x89AF, 0x58C7}, //1631 #CJK UNIFIED IDEOGRAPH
    {0x89B0, 0x58C8}, //1632 #CJK UNIFIED IDEOGRAPH
    {0x89B1, 0x58C9}, //1633 #CJK UNIFIED IDEOGRAPH
    {0x89B2, 0x58CA}, //1634 #CJK UNIFIED IDEOGRAPH
    {0x89B3, 0x58CB}, //1635 #CJK UNIFIED IDEOGRAPH
    {0x89B4, 0x58CC}, //1636 #CJK UNIFIED IDEOGRAPH
    {0x89B5, 0x58CD}, //1637 #CJK UNIFIED IDEOGRAPH
    {0x89B6, 0x58CE}, //1638 #CJK UNIFIED IDEOGRAPH
    {0x89B7, 0x58CF}, //1639 #CJK UNIFIED IDEOGRAPH
    {0x89B8, 0x58D0}, //1640 #CJK UNIFIED IDEOGRAPH
    {0x89B9, 0x58D2}, //1641 #CJK UNIFIED IDEOGRAPH
    {0x89BA, 0x58D3}, //1642 #CJK UNIFIED IDEOGRAPH
    {0x89BB, 0x58D4}, //1643 #CJK UNIFIED IDEOGRAPH
    {0x89BC, 0x58D6}, //1644 #CJK UNIFIED IDEOGRAPH
    {0x89BD, 0x58D7}, //1645 #CJK UNIFIED IDEOGRAPH
    {0x89BE, 0x58D8}, //1646 #CJK UNIFIED IDEOGRAPH
    {0x89BF, 0x58D9}, //1647 #CJK UNIFIED IDEOGRAPH
    {0x89C0, 0x58DA}, //1648 #CJK UNIFIED IDEOGRAPH
    {0x89C1, 0x58DB}, //1649 #CJK UNIFIED IDEOGRAPH
    {0x89C2, 0x58DC}, //1650 #CJK UNIFIED IDEOGRAPH
    {0x89C3, 0x58DD}, //1651 #CJK UNIFIED IDEOGRAPH
    {0x89C4, 0x58DE}, //1652 #CJK UNIFIED IDEOGRAPH
    {0x89C5, 0x58DF}, //1653 #CJK UNIFIED IDEOGRAPH
    {0x89C6, 0x58E0}, //1654 #CJK UNIFIED IDEOGRAPH
    {0x89C7, 0x58E1}, //1655 #CJK UNIFIED IDEOGRAPH
    {0x89C8, 0x58E2}, //1656 #CJK UNIFIED IDEOGRAPH
    {0x89C9, 0x58E3}, //1657 #CJK UNIFIED IDEOGRAPH
    {0x89CA, 0x58E5}, //1658 #CJK UNIFIED IDEOGRAPH
    {0x89CB, 0x58E6}, //1659 #CJK UNIFIED IDEOGRAPH
    {0x89CC, 0x58E7}, //1660 #CJK UNIFIED IDEOGRAPH
    {0x89CD, 0x58E8}, //1661 #CJK UNIFIED IDEOGRAPH
    {0x89CE, 0x58E9}, //1662 #CJK UNIFIED IDEOGRAPH
    {0x89CF, 0x58EA}, //1663 #CJK UNIFIED IDEOGRAPH
    {0x89D0, 0x58ED}, //1664 #CJK UNIFIED IDEOGRAPH
    {0x89D1, 0x58EF}, //1665 #CJK UNIFIED IDEOGRAPH
    {0x89D2, 0x58F1}, //1666 #CJK UNIFIED IDEOGRAPH
    {0x89D3, 0x58F2}, //1667 #CJK UNIFIED IDEOGRAPH
    {0x89D4, 0x58F4}, //1668 #CJK UNIFIED IDEOGRAPH
    {0x89D5, 0x58F5}, //1669 #CJK UNIFIED IDEOGRAPH
    {0x89D6, 0x58F7}, //1670 #CJK UNIFIED IDEOGRAPH
    {0x89D7, 0x58F8}, //1671 #CJK UNIFIED IDEOGRAPH
    {0x89D8, 0x58FA}, //1672 #CJK UNIFIED IDEOGRAPH
    {0x89D9, 0x58FB}, //1673 #CJK UNIFIED IDEOGRAPH
    {0x89DA, 0x58FC}, //1674 #CJK UNIFIED IDEOGRAPH
    {0x89DB, 0x58FD}, //1675 #CJK UNIFIED IDEOGRAPH
    {0x89DC, 0x58FE}, //1676 #CJK UNIFIED IDEOGRAPH
    {0x89DD, 0x58FF}, //1677 #CJK UNIFIED IDEOGRAPH
    {0x89DE, 0x5900}, //1678 #CJK UNIFIED IDEOGRAPH
    {0x89DF, 0x5901}, //1679 #CJK UNIFIED IDEOGRAPH
    {0x89E0, 0x5903}, //1680 #CJK UNIFIED IDEOGRAPH
    {0x89E1, 0x5905}, //1681 #CJK UNIFIED IDEOGRAPH
    {0x89E2, 0x5906}, //1682 #CJK UNIFIED IDEOGRAPH
    {0x89E3, 0x5908}, //1683 #CJK UNIFIED IDEOGRAPH
    {0x89E4, 0x5909}, //1684 #CJK UNIFIED IDEOGRAPH
    {0x89E5, 0x590A}, //1685 #CJK UNIFIED IDEOGRAPH
    {0x89E6, 0x590B}, //1686 #CJK UNIFIED IDEOGRAPH
    {0x89E7, 0x590C}, //1687 #CJK UNIFIED IDEOGRAPH
    {0x89E8, 0x590E}, //1688 #CJK UNIFIED IDEOGRAPH
    {0x89E9, 0x5910}, //1689 #CJK UNIFIED IDEOGRAPH
    {0x89EA, 0x5911}, //1690 #CJK UNIFIED IDEOGRAPH
    {0x89EB, 0x5912}, //1691 #CJK UNIFIED IDEOGRAPH
    {0x89EC, 0x5913}, //1692 #CJK UNIFIED IDEOGRAPH
    {0x89ED, 0x5917}, //1693 #CJK UNIFIED IDEOGRAPH
    {0x89EE, 0x5918}, //1694 #CJK UNIFIED IDEOGRAPH
    {0x89EF, 0x591B}, //1695 #CJK UNIFIED IDEOGRAPH
    {0x89F0, 0x591D}, //1696 #CJK UNIFIED IDEOGRAPH
    {0x89F1, 0x591E}, //1697 #CJK UNIFIED IDEOGRAPH
    {0x89F2, 0x5920}, //1698 #CJK UNIFIED IDEOGRAPH
    {0x89F3, 0x5921}, //1699 #CJK UNIFIED IDEOGRAPH
    {0x89F4, 0x5922}, //1700 #CJK UNIFIED IDEOGRAPH
    {0x89F5, 0x5923}, //1701 #CJK UNIFIED IDEOGRAPH
    {0x89F6, 0x5926}, //1702 #CJK UNIFIED IDEOGRAPH
    {0x89F7, 0x5928}, //1703 #CJK UNIFIED IDEOGRAPH
    {0x89F8, 0x592C}, //1704 #CJK UNIFIED IDEOGRAPH
    {0x89F9, 0x5930}, //1705 #CJK UNIFIED IDEOGRAPH
    {0x89FA, 0x5932}, //1706 #CJK UNIFIED IDEOGRAPH
    {0x89FB, 0x5933}, //1707 #CJK UNIFIED IDEOGRAPH
    {0x89FC, 0x5935}, //1708 #CJK UNIFIED IDEOGRAPH
    {0x89FD, 0x5936}, //1709 #CJK UNIFIED IDEOGRAPH
    {0x89FE, 0x593B}, //1710 #CJK UNIFIED IDEOGRAPH
    {0x8A40, 0x593D}, //1711 #CJK UNIFIED IDEOGRAPH
    {0x8A41, 0x593E}, //1712 #CJK UNIFIED IDEOGRAPH
    {0x8A42, 0x593F}, //1713 #CJK UNIFIED IDEOGRAPH
    {0x8A43, 0x5940}, //1714 #CJK UNIFIED IDEOGRAPH
    {0x8A44, 0x5943}, //1715 #CJK UNIFIED IDEOGRAPH
    {0x8A45, 0x5945}, //1716 #CJK UNIFIED IDEOGRAPH
    {0x8A46, 0x5946}, //1717 #CJK UNIFIED IDEOGRAPH
    {0x8A47, 0x594A}, //1718 #CJK UNIFIED IDEOGRAPH
    {0x8A48, 0x594C}, //1719 #CJK UNIFIED IDEOGRAPH
    {0x8A49, 0x594D}, //1720 #CJK UNIFIED IDEOGRAPH
    {0x8A4A, 0x5950}, //1721 #CJK UNIFIED IDEOGRAPH
    {0x8A4B, 0x5952}, //1722 #CJK UNIFIED IDEOGRAPH
    {0x8A4C, 0x5953}, //1723 #CJK UNIFIED IDEOGRAPH
    {0x8A4D, 0x5959}, //1724 #CJK UNIFIED IDEOGRAPH
    {0x8A4E, 0x595B}, //1725 #CJK UNIFIED IDEOGRAPH
    {0x8A4F, 0x595C}, //1726 #CJK UNIFIED IDEOGRAPH
    {0x8A50, 0x595D}, //1727 #CJK UNIFIED IDEOGRAPH
    {0x8A51, 0x595E}, //1728 #CJK UNIFIED IDEOGRAPH
    {0x8A52, 0x595F}, //1729 #CJK UNIFIED IDEOGRAPH
    {0x8A53, 0x5961}, //1730 #CJK UNIFIED IDEOGRAPH
    {0x8A54, 0x5963}, //1731 #CJK UNIFIED IDEOGRAPH
    {0x8A55, 0x5964}, //1732 #CJK UNIFIED IDEOGRAPH
    {0x8A56, 0x5966}, //1733 #CJK UNIFIED IDEOGRAPH
    {0x8A57, 0x5967}, //1734 #CJK UNIFIED IDEOGRAPH
    {0x8A58, 0x5968}, //1735 #CJK UNIFIED IDEOGRAPH
    {0x8A59, 0x5969}, //1736 #CJK UNIFIED IDEOGRAPH
    {0x8A5A, 0x596A}, //1737 #CJK UNIFIED IDEOGRAPH
    {0x8A5B, 0x596B}, //1738 #CJK UNIFIED IDEOGRAPH
    {0x8A5C, 0x596C}, //1739 #CJK UNIFIED IDEOGRAPH
    {0x8A5D, 0x596D}, //1740 #CJK UNIFIED IDEOGRAPH
    {0x8A5E, 0x596E}, //1741 #CJK UNIFIED IDEOGRAPH
    {0x8A5F, 0x596F}, //1742 #CJK UNIFIED IDEOGRAPH
    {0x8A60, 0x5970}, //1743 #CJK UNIFIED IDEOGRAPH
    {0x8A61, 0x5971}, //1744 #CJK UNIFIED IDEOGRAPH
    {0x8A62, 0x5972}, //1745 #CJK UNIFIED IDEOGRAPH
    {0x8A63, 0x5975}, //1746 #CJK UNIFIED IDEOGRAPH
    {0x8A64, 0x5977}, //1747 #CJK UNIFIED IDEOGRAPH
    {0x8A65, 0x597A}, //1748 #CJK UNIFIED IDEOGRAPH
    {0x8A66, 0x597B}, //1749 #CJK UNIFIED IDEOGRAPH
    {0x8A67, 0x597C}, //1750 #CJK UNIFIED IDEOGRAPH
    {0x8A68, 0x597E}, //1751 #CJK UNIFIED IDEOGRAPH
    {0x8A69, 0x597F}, //1752 #CJK UNIFIED IDEOGRAPH
    {0x8A6A, 0x5980}, //1753 #CJK UNIFIED IDEOGRAPH
    {0x8A6B, 0x5985}, //1754 #CJK UNIFIED IDEOGRAPH
    {0x8A6C, 0x5989}, //1755 #CJK UNIFIED IDEOGRAPH
    {0x8A6D, 0x598B}, //1756 #CJK UNIFIED IDEOGRAPH
    {0x8A6E, 0x598C}, //1757 #CJK UNIFIED IDEOGRAPH
    {0x8A6F, 0x598E}, //1758 #CJK UNIFIED IDEOGRAPH
    {0x8A70, 0x598F}, //1759 #CJK UNIFIED IDEOGRAPH
    {0x8A71, 0x5990}, //1760 #CJK UNIFIED IDEOGRAPH
    {0x8A72, 0x5991}, //1761 #CJK UNIFIED IDEOGRAPH
    {0x8A73, 0x5994}, //1762 #CJK UNIFIED IDEOGRAPH
    {0x8A74, 0x5995}, //1763 #CJK UNIFIED IDEOGRAPH
    {0x8A75, 0x5998}, //1764 #CJK UNIFIED IDEOGRAPH
    {0x8A76, 0x599A}, //1765 #CJK UNIFIED IDEOGRAPH
    {0x8A77, 0x599B}, //1766 #CJK UNIFIED IDEOGRAPH
    {0x8A78, 0x599C}, //1767 #CJK UNIFIED IDEOGRAPH
    {0x8A79, 0x599D}, //1768 #CJK UNIFIED IDEOGRAPH
    {0x8A7A, 0x599F}, //1769 #CJK UNIFIED IDEOGRAPH
    {0x8A7B, 0x59A0}, //1770 #CJK UNIFIED IDEOGRAPH
    {0x8A7C, 0x59A1}, //1771 #CJK UNIFIED IDEOGRAPH
    {0x8A7D, 0x59A2}, //1772 #CJK UNIFIED IDEOGRAPH
    {0x8A7E, 0x59A6}, //1773 #CJK UNIFIED IDEOGRAPH
    {0x8A80, 0x59A7}, //1774 #CJK UNIFIED IDEOGRAPH
    {0x8A81, 0x59AC}, //1775 #CJK UNIFIED IDEOGRAPH
    {0x8A82, 0x59AD}, //1776 #CJK UNIFIED IDEOGRAPH
    {0x8A83, 0x59B0}, //1777 #CJK UNIFIED IDEOGRAPH
    {0x8A84, 0x59B1}, //1778 #CJK UNIFIED IDEOGRAPH
    {0x8A85, 0x59B3}, //1779 #CJK UNIFIED IDEOGRAPH
    {0x8A86, 0x59B4}, //1780 #CJK UNIFIED IDEOGRAPH
    {0x8A87, 0x59B5}, //1781 #CJK UNIFIED IDEOGRAPH
    {0x8A88, 0x59B6}, //1782 #CJK UNIFIED IDEOGRAPH
    {0x8A89, 0x59B7}, //1783 #CJK UNIFIED IDEOGRAPH
    {0x8A8A, 0x59B8}, //1784 #CJK UNIFIED IDEOGRAPH
    {0x8A8B, 0x59BA}, //1785 #CJK UNIFIED IDEOGRAPH
    {0x8A8C, 0x59BC}, //1786 #CJK UNIFIED IDEOGRAPH
    {0x8A8D, 0x59BD}, //1787 #CJK UNIFIED IDEOGRAPH
    {0x8A8E, 0x59BF}, //1788 #CJK UNIFIED IDEOGRAPH
    {0x8A8F, 0x59C0}, //1789 #CJK UNIFIED IDEOGRAPH
    {0x8A90, 0x59C1}, //1790 #CJK UNIFIED IDEOGRAPH
    {0x8A91, 0x59C2}, //1791 #CJK UNIFIED IDEOGRAPH
    {0x8A92, 0x59C3}, //1792 #CJK UNIFIED IDEOGRAPH
    {0x8A93, 0x59C4}, //1793 #CJK UNIFIED IDEOGRAPH
    {0x8A94, 0x59C5}, //1794 #CJK UNIFIED IDEOGRAPH
    {0x8A95, 0x59C7}, //1795 #CJK UNIFIED IDEOGRAPH
    {0x8A96, 0x59C8}, //1796 #CJK UNIFIED IDEOGRAPH
    {0x8A97, 0x59C9}, //1797 #CJK UNIFIED IDEOGRAPH
    {0x8A98, 0x59CC}, //1798 #CJK UNIFIED IDEOGRAPH
    {0x8A99, 0x59CD}, //1799 #CJK UNIFIED IDEOGRAPH
    {0x8A9A, 0x59CE}, //1800 #CJK UNIFIED IDEOGRAPH
    {0x8A9B, 0x59CF}, //1801 #CJK UNIFIED IDEOGRAPH
    {0x8A9C, 0x59D5}, //1802 #CJK UNIFIED IDEOGRAPH
    {0x8A9D, 0x59D6}, //1803 #CJK UNIFIED IDEOGRAPH
    {0x8A9E, 0x59D9}, //1804 #CJK UNIFIED IDEOGRAPH
    {0x8A9F, 0x59DB}, //1805 #CJK UNIFIED IDEOGRAPH
    {0x8AA0, 0x59DE}, //1806 #CJK UNIFIED IDEOGRAPH
    {0x8AA1, 0x59DF}, //1807 #CJK UNIFIED IDEOGRAPH
    {0x8AA2, 0x59E0}, //1808 #CJK UNIFIED IDEOGRAPH
    {0x8AA3, 0x59E1}, //1809 #CJK UNIFIED IDEOGRAPH
    {0x8AA4, 0x59E2}, //1810 #CJK UNIFIED IDEOGRAPH
    {0x8AA5, 0x59E4}, //1811 #CJK UNIFIED IDEOGRAPH
    {0x8AA6, 0x59E6}, //1812 #CJK UNIFIED IDEOGRAPH
    {0x8AA7, 0x59E7}, //1813 #CJK UNIFIED IDEOGRAPH
    {0x8AA8, 0x59E9}, //1814 #CJK UNIFIED IDEOGRAPH
    {0x8AA9, 0x59EA}, //1815 #CJK UNIFIED IDEOGRAPH
    {0x8AAA, 0x59EB}, //1816 #CJK UNIFIED IDEOGRAPH
    {0x8AAB, 0x59ED}, //1817 #CJK UNIFIED IDEOGRAPH
    {0x8AAC, 0x59EE}, //1818 #CJK UNIFIED IDEOGRAPH
    {0x8AAD, 0x59EF}, //1819 #CJK UNIFIED IDEOGRAPH
    {0x8AAE, 0x59F0}, //1820 #CJK UNIFIED IDEOGRAPH
    {0x8AAF, 0x59F1}, //1821 #CJK UNIFIED IDEOGRAPH
    {0x8AB0, 0x59F2}, //1822 #CJK UNIFIED IDEOGRAPH
    {0x8AB1, 0x59F3}, //1823 #CJK UNIFIED IDEOGRAPH
    {0x8AB2, 0x59F4}, //1824 #CJK UNIFIED IDEOGRAPH
    {0x8AB3, 0x59F5}, //1825 #CJK UNIFIED IDEOGRAPH
    {0x8AB4, 0x59F6}, //1826 #CJK UNIFIED IDEOGRAPH
    {0x8AB5, 0x59F7}, //1827 #CJK UNIFIED IDEOGRAPH
    {0x8AB6, 0x59F8}, //1828 #CJK UNIFIED IDEOGRAPH
    {0x8AB7, 0x59FA}, //1829 #CJK UNIFIED IDEOGRAPH
    {0x8AB8, 0x59FC}, //1830 #CJK UNIFIED IDEOGRAPH
    {0x8AB9, 0x59FD}, //1831 #CJK UNIFIED IDEOGRAPH
    {0x8ABA, 0x59FE}, //1832 #CJK UNIFIED IDEOGRAPH
    {0x8ABB, 0x5A00}, //1833 #CJK UNIFIED IDEOGRAPH
    {0x8ABC, 0x5A02}, //1834 #CJK UNIFIED IDEOGRAPH
    {0x8ABD, 0x5A0A}, //1835 #CJK UNIFIED IDEOGRAPH
    {0x8ABE, 0x5A0B}, //1836 #CJK UNIFIED IDEOGRAPH
    {0x8ABF, 0x5A0D}, //1837 #CJK UNIFIED IDEOGRAPH
    {0x8AC0, 0x5A0E}, //1838 #CJK UNIFIED IDEOGRAPH
    {0x8AC1, 0x5A0F}, //1839 #CJK UNIFIED IDEOGRAPH
    {0x8AC2, 0x5A10}, //1840 #CJK UNIFIED IDEOGRAPH
    {0x8AC3, 0x5A12}, //1841 #CJK UNIFIED IDEOGRAPH
    {0x8AC4, 0x5A14}, //1842 #CJK UNIFIED IDEOGRAPH
    {0x8AC5, 0x5A15}, //1843 #CJK UNIFIED IDEOGRAPH
    {0x8AC6, 0x5A16}, //1844 #CJK UNIFIED IDEOGRAPH
    {0x8AC7, 0x5A17}, //1845 #CJK UNIFIED IDEOGRAPH
    {0x8AC8, 0x5A19}, //1846 #CJK UNIFIED IDEOGRAPH
    {0x8AC9, 0x5A1A}, //1847 #CJK UNIFIED IDEOGRAPH
    {0x8ACA, 0x5A1B}, //1848 #CJK UNIFIED IDEOGRAPH
    {0x8ACB, 0x5A1D}, //1849 #CJK UNIFIED IDEOGRAPH
    {0x8ACC, 0x5A1E}, //1850 #CJK UNIFIED IDEOGRAPH
    {0x8ACD, 0x5A21}, //1851 #CJK UNIFIED IDEOGRAPH
    {0x8ACE, 0x5A22}, //1852 #CJK UNIFIED IDEOGRAPH
    {0x8ACF, 0x5A24}, //1853 #CJK UNIFIED IDEOGRAPH
    {0x8AD0, 0x5A26}, //1854 #CJK UNIFIED IDEOGRAPH
    {0x8AD1, 0x5A27}, //1855 #CJK UNIFIED IDEOGRAPH
    {0x8AD2, 0x5A28}, //1856 #CJK UNIFIED IDEOGRAPH
    {0x8AD3, 0x5A2A}, //1857 #CJK UNIFIED IDEOGRAPH
    {0x8AD4, 0x5A2B}, //1858 #CJK UNIFIED IDEOGRAPH
    {0x8AD5, 0x5A2C}, //1859 #CJK UNIFIED IDEOGRAPH
    {0x8AD6, 0x5A2D}, //1860 #CJK UNIFIED IDEOGRAPH
    {0x8AD7, 0x5A2E}, //1861 #CJK UNIFIED IDEOGRAPH
    {0x8AD8, 0x5A2F}, //1862 #CJK UNIFIED IDEOGRAPH
    {0x8AD9, 0x5A30}, //1863 #CJK UNIFIED IDEOGRAPH
    {0x8ADA, 0x5A33}, //1864 #CJK UNIFIED IDEOGRAPH
    {0x8ADB, 0x5A35}, //1865 #CJK UNIFIED IDEOGRAPH
    {0x8ADC, 0x5A37}, //1866 #CJK UNIFIED IDEOGRAPH
    {0x8ADD, 0x5A38}, //1867 #CJK UNIFIED IDEOGRAPH
    {0x8ADE, 0x5A39}, //1868 #CJK UNIFIED IDEOGRAPH
    {0x8ADF, 0x5A3A}, //1869 #CJK UNIFIED IDEOGRAPH
    {0x8AE0, 0x5A3B}, //1870 #CJK UNIFIED IDEOGRAPH
    {0x8AE1, 0x5A3D}, //1871 #CJK UNIFIED IDEOGRAPH
    {0x8AE2, 0x5A3E}, //1872 #CJK UNIFIED IDEOGRAPH
    {0x8AE3, 0x5A3F}, //1873 #CJK UNIFIED IDEOGRAPH
    {0x8AE4, 0x5A41}, //1874 #CJK UNIFIED IDEOGRAPH
    {0x8AE5, 0x5A42}, //1875 #CJK UNIFIED IDEOGRAPH
    {0x8AE6, 0x5A43}, //1876 #CJK UNIFIED IDEOGRAPH
    {0x8AE7, 0x5A44}, //1877 #CJK UNIFIED IDEOGRAPH
    {0x8AE8, 0x5A45}, //1878 #CJK UNIFIED IDEOGRAPH
    {0x8AE9, 0x5A47}, //1879 #CJK UNIFIED IDEOGRAPH
    {0x8AEA, 0x5A48}, //1880 #CJK UNIFIED IDEOGRAPH
    {0x8AEB, 0x5A4B}, //1881 #CJK UNIFIED IDEOGRAPH
    {0x8AEC, 0x5A4C}, //1882 #CJK UNIFIED IDEOGRAPH
    {0x8AED, 0x5A4D}, //1883 #CJK UNIFIED IDEOGRAPH
    {0x8AEE, 0x5A4E}, //1884 #CJK UNIFIED IDEOGRAPH
    {0x8AEF, 0x5A4F}, //1885 #CJK UNIFIED IDEOGRAPH
    {0x8AF0, 0x5A50}, //1886 #CJK UNIFIED IDEOGRAPH
    {0x8AF1, 0x5A51}, //1887 #CJK UNIFIED IDEOGRAPH
    {0x8AF2, 0x5A52}, //1888 #CJK UNIFIED IDEOGRAPH
    {0x8AF3, 0x5A53}, //1889 #CJK UNIFIED IDEOGRAPH
    {0x8AF4, 0x5A54}, //1890 #CJK UNIFIED IDEOGRAPH
    {0x8AF5, 0x5A56}, //1891 #CJK UNIFIED IDEOGRAPH
    {0x8AF6, 0x5A57}, //1892 #CJK UNIFIED IDEOGRAPH
    {0x8AF7, 0x5A58}, //1893 #CJK UNIFIED IDEOGRAPH
    {0x8AF8, 0x5A59}, //1894 #CJK UNIFIED IDEOGRAPH
    {0x8AF9, 0x5A5B}, //1895 #CJK UNIFIED IDEOGRAPH
    {0x8AFA, 0x5A5C}, //1896 #CJK UNIFIED IDEOGRAPH
    {0x8AFB, 0x5A5D}, //1897 #CJK UNIFIED IDEOGRAPH
    {0x8AFC, 0x5A5E}, //1898 #CJK UNIFIED IDEOGRAPH
    {0x8AFD, 0x5A5F}, //1899 #CJK UNIFIED IDEOGRAPH
    {0x8AFE, 0x5A60}, //1900 #CJK UNIFIED IDEOGRAPH
    {0x8B40, 0x5A61}, //1901 #CJK UNIFIED IDEOGRAPH
    {0x8B41, 0x5A63}, //1902 #CJK UNIFIED IDEOGRAPH
    {0x8B42, 0x5A64}, //1903 #CJK UNIFIED IDEOGRAPH
    {0x8B43, 0x5A65}, //1904 #CJK UNIFIED IDEOGRAPH
    {0x8B44, 0x5A66}, //1905 #CJK UNIFIED IDEOGRAPH
    {0x8B45, 0x5A68}, //1906 #CJK UNIFIED IDEOGRAPH
    {0x8B46, 0x5A69}, //1907 #CJK UNIFIED IDEOGRAPH
    {0x8B47, 0x5A6B}, //1908 #CJK UNIFIED IDEOGRAPH
    {0x8B48, 0x5A6C}, //1909 #CJK UNIFIED IDEOGRAPH
    {0x8B49, 0x5A6D}, //1910 #CJK UNIFIED IDEOGRAPH
    {0x8B4A, 0x5A6E}, //1911 #CJK UNIFIED IDEOGRAPH
    {0x8B4B, 0x5A6F}, //1912 #CJK UNIFIED IDEOGRAPH
    {0x8B4C, 0x5A70}, //1913 #CJK UNIFIED IDEOGRAPH
    {0x8B4D, 0x5A71}, //1914 #CJK UNIFIED IDEOGRAPH
    {0x8B4E, 0x5A72}, //1915 #CJK UNIFIED IDEOGRAPH
    {0x8B4F, 0x5A73}, //1916 #CJK UNIFIED IDEOGRAPH
    {0x8B50, 0x5A78}, //1917 #CJK UNIFIED IDEOGRAPH
    {0x8B51, 0x5A79}, //1918 #CJK UNIFIED IDEOGRAPH
    {0x8B52, 0x5A7B}, //1919 #CJK UNIFIED IDEOGRAPH
    {0x8B53, 0x5A7C}, //1920 #CJK UNIFIED IDEOGRAPH
    {0x8B54, 0x5A7D}, //1921 #CJK UNIFIED IDEOGRAPH
    {0x8B55, 0x5A7E}, //1922 #CJK UNIFIED IDEOGRAPH
    {0x8B56, 0x5A80}, //1923 #CJK UNIFIED IDEOGRAPH
    {0x8B57, 0x5A81}, //1924 #CJK UNIFIED IDEOGRAPH
    {0x8B58, 0x5A82}, //1925 #CJK UNIFIED IDEOGRAPH
    {0x8B59, 0x5A83}, //1926 #CJK UNIFIED IDEOGRAPH
    {0x8B5A, 0x5A84}, //1927 #CJK UNIFIED IDEOGRAPH
    {0x8B5B, 0x5A85}, //1928 #CJK UNIFIED IDEOGRAPH
    {0x8B5C, 0x5A86}, //1929 #CJK UNIFIED IDEOGRAPH
    {0x8B5D, 0x5A87}, //1930 #CJK UNIFIED IDEOGRAPH
    {0x8B5E, 0x5A88}, //1931 #CJK UNIFIED IDEOGRAPH
    {0x8B5F, 0x5A89}, //1932 #CJK UNIFIED IDEOGRAPH
    {0x8B60, 0x5A8A}, //1933 #CJK UNIFIED IDEOGRAPH
    {0x8B61, 0x5A8B}, //1934 #CJK UNIFIED IDEOGRAPH
    {0x8B62, 0x5A8C}, //1935 #CJK UNIFIED IDEOGRAPH
    {0x8B63, 0x5A8D}, //1936 #CJK UNIFIED IDEOGRAPH
    {0x8B64, 0x5A8E}, //1937 #CJK UNIFIED IDEOGRAPH
    {0x8B65, 0x5A8F}, //1938 #CJK UNIFIED IDEOGRAPH
    {0x8B66, 0x5A90}, //1939 #CJK UNIFIED IDEOGRAPH
    {0x8B67, 0x5A91}, //1940 #CJK UNIFIED IDEOGRAPH
    {0x8B68, 0x5A93}, //1941 #CJK UNIFIED IDEOGRAPH
    {0x8B69, 0x5A94}, //1942 #CJK UNIFIED IDEOGRAPH
    {0x8B6A, 0x5A95}, //1943 #CJK UNIFIED IDEOGRAPH
    {0x8B6B, 0x5A96}, //1944 #CJK UNIFIED IDEOGRAPH
    {0x8B6C, 0x5A97}, //1945 #CJK UNIFIED IDEOGRAPH
    {0x8B6D, 0x5A98}, //1946 #CJK UNIFIED IDEOGRAPH
    {0x8B6E, 0x5A99}, //1947 #CJK UNIFIED IDEOGRAPH
    {0x8B6F, 0x5A9C}, //1948 #CJK UNIFIED IDEOGRAPH
    {0x8B70, 0x5A9D}, //1949 #CJK UNIFIED IDEOGRAPH
    {0x8B71, 0x5A9E}, //1950 #CJK UNIFIED IDEOGRAPH
    {0x8B72, 0x5A9F}, //1951 #CJK UNIFIED IDEOGRAPH
    {0x8B73, 0x5AA0}, //1952 #CJK UNIFIED IDEOGRAPH
    {0x8B74, 0x5AA1}, //1953 #CJK UNIFIED IDEOGRAPH
    {0x8B75, 0x5AA2}, //1954 #CJK UNIFIED IDEOGRAPH
    {0x8B76, 0x5AA3}, //1955 #CJK UNIFIED IDEOGRAPH
    {0x8B77, 0x5AA4}, //1956 #CJK UNIFIED IDEOGRAPH
    {0x8B78, 0x5AA5}, //1957 #CJK UNIFIED IDEOGRAPH
    {0x8B79, 0x5AA6}, //1958 #CJK UNIFIED IDEOGRAPH
    {0x8B7A, 0x5AA7}, //1959 #CJK UNIFIED IDEOGRAPH
    {0x8B7B, 0x5AA8}, //1960 #CJK UNIFIED IDEOGRAPH
    {0x8B7C, 0x5AA9}, //1961 #CJK UNIFIED IDEOGRAPH
    {0x8B7D, 0x5AAB}, //1962 #CJK UNIFIED IDEOGRAPH
    {0x8B7E, 0x5AAC}, //1963 #CJK UNIFIED IDEOGRAPH
    {0x8B80, 0x5AAD}, //1964 #CJK UNIFIED IDEOGRAPH
    {0x8B81, 0x5AAE}, //1965 #CJK UNIFIED IDEOGRAPH
    {0x8B82, 0x5AAF}, //1966 #CJK UNIFIED IDEOGRAPH
    {0x8B83, 0x5AB0}, //1967 #CJK UNIFIED IDEOGRAPH
    {0x8B84, 0x5AB1}, //1968 #CJK UNIFIED IDEOGRAPH
    {0x8B85, 0x5AB4}, //1969 #CJK UNIFIED IDEOGRAPH
    {0x8B86, 0x5AB6}, //1970 #CJK UNIFIED IDEOGRAPH
    {0x8B87, 0x5AB7}, //1971 #CJK UNIFIED IDEOGRAPH
    {0x8B88, 0x5AB9}, //1972 #CJK UNIFIED IDEOGRAPH
    {0x8B89, 0x5ABA}, //1973 #CJK UNIFIED IDEOGRAPH
    {0x8B8A, 0x5ABB}, //1974 #CJK UNIFIED IDEOGRAPH
    {0x8B8B, 0x5ABC}, //1975 #CJK UNIFIED IDEOGRAPH
    {0x8B8C, 0x5ABD}, //1976 #CJK UNIFIED IDEOGRAPH
    {0x8B8D, 0x5ABF}, //1977 #CJK UNIFIED IDEOGRAPH
    {0x8B8E, 0x5AC0}, //1978 #CJK UNIFIED IDEOGRAPH
    {0x8B8F, 0x5AC3}, //1979 #CJK UNIFIED IDEOGRAPH
    {0x8B90, 0x5AC4}, //1980 #CJK UNIFIED IDEOGRAPH
    {0x8B91, 0x5AC5}, //1981 #CJK UNIFIED IDEOGRAPH
    {0x8B92, 0x5AC6}, //1982 #CJK UNIFIED IDEOGRAPH
    {0x8B93, 0x5AC7}, //1983 #CJK UNIFIED IDEOGRAPH
    {0x8B94, 0x5AC8}, //1984 #CJK UNIFIED IDEOGRAPH
    {0x8B95, 0x5ACA}, //1985 #CJK UNIFIED IDEOGRAPH
    {0x8B96, 0x5ACB}, //1986 #CJK UNIFIED IDEOGRAPH
    {0x8B97, 0x5ACD}, //1987 #CJK UNIFIED IDEOGRAPH
    {0x8B98, 0x5ACE}, //1988 #CJK UNIFIED IDEOGRAPH
    {0x8B99, 0x5ACF}, //1989 #CJK UNIFIED IDEOGRAPH
    {0x8B9A, 0x5AD0}, //1990 #CJK UNIFIED IDEOGRAPH
    {0x8B9B, 0x5AD1}, //1991 #CJK UNIFIED IDEOGRAPH
    {0x8B9C, 0x5AD3}, //1992 #CJK UNIFIED IDEOGRAPH
    {0x8B9D, 0x5AD5}, //1993 #CJK UNIFIED IDEOGRAPH
    {0x8B9E, 0x5AD7}, //1994 #CJK UNIFIED IDEOGRAPH
    {0x8B9F, 0x5AD9}, //1995 #CJK UNIFIED IDEOGRAPH
    {0x8BA0, 0x5ADA}, //1996 #CJK UNIFIED IDEOGRAPH
    {0x8BA1, 0x5ADB}, //1997 #CJK UNIFIED IDEOGRAPH
    {0x8BA2, 0x5ADD}, //1998 #CJK UNIFIED IDEOGRAPH
    {0x8BA3, 0x5ADE}, //1999 #CJK UNIFIED IDEOGRAPH
    {0x8BA4, 0x5ADF}, //2000 #CJK UNIFIED IDEOGRAPH
    {0x8BA5, 0x5AE2}, //2001 #CJK UNIFIED IDEOGRAPH
    {0x8BA6, 0x5AE4}, //2002 #CJK UNIFIED IDEOGRAPH
    {0x8BA7, 0x5AE5}, //2003 #CJK UNIFIED IDEOGRAPH
    {0x8BA8, 0x5AE7}, //2004 #CJK UNIFIED IDEOGRAPH
    {0x8BA9, 0x5AE8}, //2005 #CJK UNIFIED IDEOGRAPH
    {0x8BAA, 0x5AEA}, //2006 #CJK UNIFIED IDEOGRAPH
    {0x8BAB, 0x5AEC}, //2007 #CJK UNIFIED IDEOGRAPH
    {0x8BAC, 0x5AED}, //2008 #CJK UNIFIED IDEOGRAPH
    {0x8BAD, 0x5AEE}, //2009 #CJK UNIFIED IDEOGRAPH
    {0x8BAE, 0x5AEF}, //2010 #CJK UNIFIED IDEOGRAPH
    {0x8BAF, 0x5AF0}, //2011 #CJK UNIFIED IDEOGRAPH
    {0x8BB0, 0x5AF2}, //2012 #CJK UNIFIED IDEOGRAPH
    {0x8BB1, 0x5AF3}, //2013 #CJK UNIFIED IDEOGRAPH
    {0x8BB2, 0x5AF4}, //2014 #CJK UNIFIED IDEOGRAPH
    {0x8BB3, 0x5AF5}, //2015 #CJK UNIFIED IDEOGRAPH
    {0x8BB4, 0x5AF6}, //2016 #CJK UNIFIED IDEOGRAPH
    {0x8BB5, 0x5AF7}, //2017 #CJK UNIFIED IDEOGRAPH
    {0x8BB6, 0x5AF8}, //2018 #CJK UNIFIED IDEOGRAPH
    {0x8BB7, 0x5AF9}, //2019 #CJK UNIFIED IDEOGRAPH
    {0x8BB8, 0x5AFA}, //2020 #CJK UNIFIED IDEOGRAPH
    {0x8BB9, 0x5AFB}, //2021 #CJK UNIFIED IDEOGRAPH
    {0x8BBA, 0x5AFC}, //2022 #CJK UNIFIED IDEOGRAPH
    {0x8BBB, 0x5AFD}, //2023 #CJK UNIFIED IDEOGRAPH
    {0x8BBC, 0x5AFE}, //2024 #CJK UNIFIED IDEOGRAPH
    {0x8BBD, 0x5AFF}, //2025 #CJK UNIFIED IDEOGRAPH
    {0x8BBE, 0x5B00}, //2026 #CJK UNIFIED IDEOGRAPH
    {0x8BBF, 0x5B01}, //2027 #CJK UNIFIED IDEOGRAPH
    {0x8BC0, 0x5B02}, //2028 #CJK UNIFIED IDEOGRAPH
    {0x8BC1, 0x5B03}, //2029 #CJK UNIFIED IDEOGRAPH
    {0x8BC2, 0x5B04}, //2030 #CJK UNIFIED IDEOGRAPH
    {0x8BC3, 0x5B05}, //2031 #CJK UNIFIED IDEOGRAPH
    {0x8BC4, 0x5B06}, //2032 #CJK UNIFIED IDEOGRAPH
    {0x8BC5, 0x5B07}, //2033 #CJK UNIFIED IDEOGRAPH
    {0x8BC6, 0x5B08}, //2034 #CJK UNIFIED IDEOGRAPH
    {0x8BC7, 0x5B0A}, //2035 #CJK UNIFIED IDEOGRAPH
    {0x8BC8, 0x5B0B}, //2036 #CJK UNIFIED IDEOGRAPH
    {0x8BC9, 0x5B0C}, //2037 #CJK UNIFIED IDEOGRAPH
    {0x8BCA, 0x5B0D}, //2038 #CJK UNIFIED IDEOGRAPH
    {0x8BCB, 0x5B0E}, //2039 #CJK UNIFIED IDEOGRAPH
    {0x8BCC, 0x5B0F}, //2040 #CJK UNIFIED IDEOGRAPH
    {0x8BCD, 0x5B10}, //2041 #CJK UNIFIED IDEOGRAPH
    {0x8BCE, 0x5B11}, //2042 #CJK UNIFIED IDEOGRAPH
    {0x8BCF, 0x5B12}, //2043 #CJK UNIFIED IDEOGRAPH
    {0x8BD0, 0x5B13}, //2044 #CJK UNIFIED IDEOGRAPH
    {0x8BD1, 0x5B14}, //2045 #CJK UNIFIED IDEOGRAPH
    {0x8BD2, 0x5B15}, //2046 #CJK UNIFIED IDEOGRAPH
    {0x8BD3, 0x5B18}, //2047 #CJK UNIFIED IDEOGRAPH
    {0x8BD4, 0x5B19}, //2048 #CJK UNIFIED IDEOGRAPH
    {0x8BD5, 0x5B1A}, //2049 #CJK UNIFIED IDEOGRAPH
    {0x8BD6, 0x5B1B}, //2050 #CJK UNIFIED IDEOGRAPH
    {0x8BD7, 0x5B1C}, //2051 #CJK UNIFIED IDEOGRAPH
    {0x8BD8, 0x5B1D}, //2052 #CJK UNIFIED IDEOGRAPH
    {0x8BD9, 0x5B1E}, //2053 #CJK UNIFIED IDEOGRAPH
    {0x8BDA, 0x5B1F}, //2054 #CJK UNIFIED IDEOGRAPH
    {0x8BDB, 0x5B20}, //2055 #CJK UNIFIED IDEOGRAPH
    {0x8BDC, 0x5B21}, //2056 #CJK UNIFIED IDEOGRAPH
    {0x8BDD, 0x5B22}, //2057 #CJK UNIFIED IDEOGRAPH
    {0x8BDE, 0x5B23}, //2058 #CJK UNIFIED IDEOGRAPH
    {0x8BDF, 0x5B24}, //2059 #CJK UNIFIED IDEOGRAPH
    {0x8BE0, 0x5B25}, //2060 #CJK UNIFIED IDEOGRAPH
    {0x8BE1, 0x5B26}, //2061 #CJK UNIFIED IDEOGRAPH
    {0x8BE2, 0x5B27}, //2062 #CJK UNIFIED IDEOGRAPH
    {0x8BE3, 0x5B28}, //2063 #CJK UNIFIED IDEOGRAPH
    {0x8BE4, 0x5B29}, //2064 #CJK UNIFIED IDEOGRAPH
    {0x8BE5, 0x5B2A}, //2065 #CJK UNIFIED IDEOGRAPH
    {0x8BE6, 0x5B2B}, //2066 #CJK UNIFIED IDEOGRAPH
    {0x8BE7, 0x5B2C}, //2067 #CJK UNIFIED IDEOGRAPH
    {0x8BE8, 0x5B2D}, //2068 #CJK UNIFIED IDEOGRAPH
    {0x8BE9, 0x5B2E}, //2069 #CJK UNIFIED IDEOGRAPH
    {0x8BEA, 0x5B2F}, //2070 #CJK UNIFIED IDEOGRAPH
    {0x8BEB, 0x5B30}, //2071 #CJK UNIFIED IDEOGRAPH
    {0x8BEC, 0x5B31}, //2072 #CJK UNIFIED IDEOGRAPH
    {0x8BED, 0x5B33}, //2073 #CJK UNIFIED IDEOGRAPH
    {0x8BEE, 0x5B35}, //2074 #CJK UNIFIED IDEOGRAPH
    {0x8BEF, 0x5B36}, //2075 #CJK UNIFIED IDEOGRAPH
    {0x8BF0, 0x5B38}, //2076 #CJK UNIFIED IDEOGRAPH
    {0x8BF1, 0x5B39}, //2077 #CJK UNIFIED IDEOGRAPH
    {0x8BF2, 0x5B3A}, //2078 #CJK UNIFIED IDEOGRAPH
    {0x8BF3, 0x5B3B}, //2079 #CJK UNIFIED IDEOGRAPH
    {0x8BF4, 0x5B3C}, //2080 #CJK UNIFIED IDEOGRAPH
    {0x8BF5, 0x5B3D}, //2081 #CJK UNIFIED IDEOGRAPH
    {0x8BF6, 0x5B3E}, //2082 #CJK UNIFIED IDEOGRAPH
    {0x8BF7, 0x5B3F}, //2083 #CJK UNIFIED IDEOGRAPH
    {0x8BF8, 0x5B41}, //2084 #CJK UNIFIED IDEOGRAPH
    {0x8BF9, 0x5B42}, //2085 #CJK UNIFIED IDEOGRAPH
    {0x8BFA, 0x5B43}, //2086 #CJK UNIFIED IDEOGRAPH
    {0x8BFB, 0x5B44}, //2087 #CJK UNIFIED IDEOGRAPH
    {0x8BFC, 0x5B45}, //2088 #CJK UNIFIED IDEOGRAPH
    {0x8BFD, 0x5B46}, //2089 #CJK UNIFIED IDEOGRAPH
    {0x8BFE, 0x5B47}, //2090 #CJK UNIFIED IDEOGRAPH
    {0x8C40, 0x5B48}, //2091 #CJK UNIFIED IDEOGRAPH
    {0x8C41, 0x5B49}, //2092 #CJK UNIFIED IDEOGRAPH
    {0x8C42, 0x5B4A}, //2093 #CJK UNIFIED IDEOGRAPH
    {0x8C43, 0x5B4B}, //2094 #CJK UNIFIED IDEOGRAPH
    {0x8C44, 0x5B4C}, //2095 #CJK UNIFIED IDEOGRAPH
    {0x8C45, 0x5B4D}, //2096 #CJK UNIFIED IDEOGRAPH
    {0x8C46, 0x5B4E}, //2097 #CJK UNIFIED IDEOGRAPH
    {0x8C47, 0x5B4F}, //2098 #CJK UNIFIED IDEOGRAPH
    {0x8C48, 0x5B52}, //2099 #CJK UNIFIED IDEOGRAPH
    {0x8C49, 0x5B56}, //2100 #CJK UNIFIED IDEOGRAPH
    {0x8C4A, 0x5B5E}, //2101 #CJK UNIFIED IDEOGRAPH
    {0x8C4B, 0x5B60}, //2102 #CJK UNIFIED IDEOGRAPH
    {0x8C4C, 0x5B61}, //2103 #CJK UNIFIED IDEOGRAPH
    {0x8C4D, 0x5B67}, //2104 #CJK UNIFIED IDEOGRAPH
    {0x8C4E, 0x5B68}, //2105 #CJK UNIFIED IDEOGRAPH
    {0x8C4F, 0x5B6B}, //2106 #CJK UNIFIED IDEOGRAPH
    {0x8C50, 0x5B6D}, //2107 #CJK UNIFIED IDEOGRAPH
    {0x8C51, 0x5B6E}, //2108 #CJK UNIFIED IDEOGRAPH
    {0x8C52, 0x5B6F}, //2109 #CJK UNIFIED IDEOGRAPH
    {0x8C53, 0x5B72}, //2110 #CJK UNIFIED IDEOGRAPH
    {0x8C54, 0x5B74}, //2111 #CJK UNIFIED IDEOGRAPH
    {0x8C55, 0x5B76}, //2112 #CJK UNIFIED IDEOGRAPH
    {0x8C56, 0x5B77}, //2113 #CJK UNIFIED IDEOGRAPH
    {0x8C57, 0x5B78}, //2114 #CJK UNIFIED IDEOGRAPH
    {0x8C58, 0x5B79}, //2115 #CJK UNIFIED IDEOGRAPH
    {0x8C59, 0x5B7B}, //2116 #CJK UNIFIED IDEOGRAPH
    {0x8C5A, 0x5B7C}, //2117 #CJK UNIFIED IDEOGRAPH
    {0x8C5B, 0x5B7E}, //2118 #CJK UNIFIED IDEOGRAPH
    {0x8C5C, 0x5B7F}, //2119 #CJK UNIFIED IDEOGRAPH
    {0x8C5D, 0x5B82}, //2120 #CJK UNIFIED IDEOGRAPH
    {0x8C5E, 0x5B86}, //2121 #CJK UNIFIED IDEOGRAPH
    {0x8C5F, 0x5B8A}, //2122 #CJK UNIFIED IDEOGRAPH
    {0x8C60, 0x5B8D}, //2123 #CJK UNIFIED IDEOGRAPH
    {0x8C61, 0x5B8E}, //2124 #CJK UNIFIED IDEOGRAPH
    {0x8C62, 0x5B90}, //2125 #CJK UNIFIED IDEOGRAPH
    {0x8C63, 0x5B91}, //2126 #CJK UNIFIED IDEOGRAPH
    {0x8C64, 0x5B92}, //2127 #CJK UNIFIED IDEOGRAPH
    {0x8C65, 0x5B94}, //2128 #CJK UNIFIED IDEOGRAPH
    {0x8C66, 0x5B96}, //2129 #CJK UNIFIED IDEOGRAPH
    {0x8C67, 0x5B9F}, //2130 #CJK UNIFIED IDEOGRAPH
    {0x8C68, 0x5BA7}, //2131 #CJK UNIFIED IDEOGRAPH
    {0x8C69, 0x5BA8}, //2132 #CJK UNIFIED IDEOGRAPH
    {0x8C6A, 0x5BA9}, //2133 #CJK UNIFIED IDEOGRAPH
    {0x8C6B, 0x5BAC}, //2134 #CJK UNIFIED IDEOGRAPH
    {0x8C6C, 0x5BAD}, //2135 #CJK UNIFIED IDEOGRAPH
    {0x8C6D, 0x5BAE}, //2136 #CJK UNIFIED IDEOGRAPH
    {0x8C6E, 0x5BAF}, //2137 #CJK UNIFIED IDEOGRAPH
    {0x8C6F, 0x5BB1}, //2138 #CJK UNIFIED IDEOGRAPH
    {0x8C70, 0x5BB2}, //2139 #CJK UNIFIED IDEOGRAPH
    {0x8C71, 0x5BB7}, //2140 #CJK UNIFIED IDEOGRAPH
    {0x8C72, 0x5BBA}, //2141 #CJK UNIFIED IDEOGRAPH
    {0x8C73, 0x5BBB}, //2142 #CJK UNIFIED IDEOGRAPH
    {0x8C74, 0x5BBC}, //2143 #CJK UNIFIED IDEOGRAPH
    {0x8C75, 0x5BC0}, //2144 #CJK UNIFIED IDEOGRAPH
    {0x8C76, 0x5BC1}, //2145 #CJK UNIFIED IDEOGRAPH
    {0x8C77, 0x5BC3}, //2146 #CJK UNIFIED IDEOGRAPH
    {0x8C78, 0x5BC8}, //2147 #CJK UNIFIED IDEOGRAPH
    {0x8C79, 0x5BC9}, //2148 #CJK UNIFIED IDEOGRAPH
    {0x8C7A, 0x5BCA}, //2149 #CJK UNIFIED IDEOGRAPH
    {0x8C7B, 0x5BCB}, //2150 #CJK UNIFIED IDEOGRAPH
    {0x8C7C, 0x5BCD}, //2151 #CJK UNIFIED IDEOGRAPH
    {0x8C7D, 0x5BCE}, //2152 #CJK UNIFIED IDEOGRAPH
    {0x8C7E, 0x5BCF}, //2153 #CJK UNIFIED IDEOGRAPH
    {0x8C80, 0x5BD1}, //2154 #CJK UNIFIED IDEOGRAPH
    {0x8C81, 0x5BD4}, //2155 #CJK UNIFIED IDEOGRAPH
    {0x8C82, 0x5BD5}, //2156 #CJK UNIFIED IDEOGRAPH
    {0x8C83, 0x5BD6}, //2157 #CJK UNIFIED IDEOGRAPH
    {0x8C84, 0x5BD7}, //2158 #CJK UNIFIED IDEOGRAPH
    {0x8C85, 0x5BD8}, //2159 #CJK UNIFIED IDEOGRAPH
    {0x8C86, 0x5BD9}, //2160 #CJK UNIFIED IDEOGRAPH
    {0x8C87, 0x5BDA}, //2161 #CJK UNIFIED IDEOGRAPH
    {0x8C88, 0x5BDB}, //2162 #CJK UNIFIED IDEOGRAPH
    {0x8C89, 0x5BDC}, //2163 #CJK UNIFIED IDEOGRAPH
    {0x8C8A, 0x5BE0}, //2164 #CJK UNIFIED IDEOGRAPH
    {0x8C8B, 0x5BE2}, //2165 #CJK UNIFIED IDEOGRAPH
    {0x8C8C, 0x5BE3}, //2166 #CJK UNIFIED IDEOGRAPH
    {0x8C8D, 0x5BE6}, //2167 #CJK UNIFIED IDEOGRAPH
    {0x8C8E, 0x5BE7}, //2168 #CJK UNIFIED IDEOGRAPH
    {0x8C8F, 0x5BE9}, //2169 #CJK UNIFIED IDEOGRAPH
    {0x8C90, 0x5BEA}, //2170 #CJK UNIFIED IDEOGRAPH
    {0x8C91, 0x5BEB}, //2171 #CJK UNIFIED IDEOGRAPH
    {0x8C92, 0x5BEC}, //2172 #CJK UNIFIED IDEOGRAPH
    {0x8C93, 0x5BED}, //2173 #CJK UNIFIED IDEOGRAPH
    {0x8C94, 0x5BEF}, //2174 #CJK UNIFIED IDEOGRAPH
    {0x8C95, 0x5BF1}, //2175 #CJK UNIFIED IDEOGRAPH
    {0x8C96, 0x5BF2}, //2176 #CJK UNIFIED IDEOGRAPH
    {0x8C97, 0x5BF3}, //2177 #CJK UNIFIED IDEOGRAPH
    {0x8C98, 0x5BF4}, //2178 #CJK UNIFIED IDEOGRAPH
    {0x8C99, 0x5BF5}, //2179 #CJK UNIFIED IDEOGRAPH
    {0x8C9A, 0x5BF6}, //2180 #CJK UNIFIED IDEOGRAPH
    {0x8C9B, 0x5BF7}, //2181 #CJK UNIFIED IDEOGRAPH
    {0x8C9C, 0x5BFD}, //2182 #CJK UNIFIED IDEOGRAPH
    {0x8C9D, 0x5BFE}, //2183 #CJK UNIFIED IDEOGRAPH
    {0x8C9E, 0x5C00}, //2184 #CJK UNIFIED IDEOGRAPH
    {0x8C9F, 0x5C02}, //2185 #CJK UNIFIED IDEOGRAPH
    {0x8CA0, 0x5C03}, //2186 #CJK UNIFIED IDEOGRAPH
    {0x8CA1, 0x5C05}, //2187 #CJK UNIFIED IDEOGRAPH
    {0x8CA2, 0x5C07}, //2188 #CJK UNIFIED IDEOGRAPH
    {0x8CA3, 0x5C08}, //2189 #CJK UNIFIED IDEOGRAPH
    {0x8CA4, 0x5C0B}, //2190 #CJK UNIFIED IDEOGRAPH
    {0x8CA5, 0x5C0C}, //2191 #CJK UNIFIED IDEOGRAPH
    {0x8CA6, 0x5C0D}, //2192 #CJK UNIFIED IDEOGRAPH
    {0x8CA7, 0x5C0E}, //2193 #CJK UNIFIED IDEOGRAPH
    {0x8CA8, 0x5C10}, //2194 #CJK UNIFIED IDEOGRAPH
    {0x8CA9, 0x5C12}, //2195 #CJK UNIFIED IDEOGRAPH
    {0x8CAA, 0x5C13}, //2196 #CJK UNIFIED IDEOGRAPH
    {0x8CAB, 0x5C17}, //2197 #CJK UNIFIED IDEOGRAPH
    {0x8CAC, 0x5C19}, //2198 #CJK UNIFIED IDEOGRAPH
    {0x8CAD, 0x5C1B}, //2199 #CJK UNIFIED IDEOGRAPH
    {0x8CAE, 0x5C1E}, //2200 #CJK UNIFIED IDEOGRAPH
    {0x8CAF, 0x5C1F}, //2201 #CJK UNIFIED IDEOGRAPH
    {0x8CB0, 0x5C20}, //2202 #CJK UNIFIED IDEOGRAPH
    {0x8CB1, 0x5C21}, //2203 #CJK UNIFIED IDEOGRAPH
    {0x8CB2, 0x5C23}, //2204 #CJK UNIFIED IDEOGRAPH
    {0x8CB3, 0x5C26}, //2205 #CJK UNIFIED IDEOGRAPH
    {0x8CB4, 0x5C28}, //2206 #CJK UNIFIED IDEOGRAPH
    {0x8CB5, 0x5C29}, //2207 #CJK UNIFIED IDEOGRAPH
    {0x8CB6, 0x5C2A}, //2208 #CJK UNIFIED IDEOGRAPH
    {0x8CB7, 0x5C2B}, //2209 #CJK UNIFIED IDEOGRAPH
    {0x8CB8, 0x5C2D}, //2210 #CJK UNIFIED IDEOGRAPH
    {0x8CB9, 0x5C2E}, //2211 #CJK UNIFIED IDEOGRAPH
    {0x8CBA, 0x5C2F}, //2212 #CJK UNIFIED IDEOGRAPH
    {0x8CBB, 0x5C30}, //2213 #CJK UNIFIED IDEOGRAPH
    {0x8CBC, 0x5C32}, //2214 #CJK UNIFIED IDEOGRAPH
    {0x8CBD, 0x5C33}, //2215 #CJK UNIFIED IDEOGRAPH
    {0x8CBE, 0x5C35}, //2216 #CJK UNIFIED IDEOGRAPH
    {0x8CBF, 0x5C36}, //2217 #CJK UNIFIED IDEOGRAPH
    {0x8CC0, 0x5C37}, //2218 #CJK UNIFIED IDEOGRAPH
    {0x8CC1, 0x5C43}, //2219 #CJK UNIFIED IDEOGRAPH
    {0x8CC2, 0x5C44}, //2220 #CJK UNIFIED IDEOGRAPH
    {0x8CC3, 0x5C46}, //2221 #CJK UNIFIED IDEOGRAPH
    {0x8CC4, 0x5C47}, //2222 #CJK UNIFIED IDEOGRAPH
    {0x8CC5, 0x5C4C}, //2223 #CJK UNIFIED IDEOGRAPH
    {0x8CC6, 0x5C4D}, //2224 #CJK UNIFIED IDEOGRAPH
    {0x8CC7, 0x5C52}, //2225 #CJK UNIFIED IDEOGRAPH
    {0x8CC8, 0x5C53}, //2226 #CJK UNIFIED IDEOGRAPH
    {0x8CC9, 0x5C54}, //2227 #CJK UNIFIED IDEOGRAPH
    {0x8CCA, 0x5C56}, //2228 #CJK UNIFIED IDEOGRAPH
    {0x8CCB, 0x5C57}, //2229 #CJK UNIFIED IDEOGRAPH
    {0x8CCC, 0x5C58}, //2230 #CJK UNIFIED IDEOGRAPH
    {0x8CCD, 0x5C5A}, //2231 #CJK UNIFIED IDEOGRAPH
    {0x8CCE, 0x5C5B}, //2232 #CJK UNIFIED IDEOGRAPH
    {0x8CCF, 0x5C5C}, //2233 #CJK UNIFIED IDEOGRAPH
    {0x8CD0, 0x5C5D}, //2234 #CJK UNIFIED IDEOGRAPH
    {0x8CD1, 0x5C5F}, //2235 #CJK UNIFIED IDEOGRAPH
    {0x8CD2, 0x5C62}, //2236 #CJK UNIFIED IDEOGRAPH
    {0x8CD3, 0x5C64}, //2237 #CJK UNIFIED IDEOGRAPH
    {0x8CD4, 0x5C67}, //2238 #CJK UNIFIED IDEOGRAPH
    {0x8CD5, 0x5C68}, //2239 #CJK UNIFIED IDEOGRAPH
    {0x8CD6, 0x5C69}, //2240 #CJK UNIFIED IDEOGRAPH
    {0x8CD7, 0x5C6A}, //2241 #CJK UNIFIED IDEOGRAPH
    {0x8CD8, 0x5C6B}, //2242 #CJK UNIFIED IDEOGRAPH
    {0x8CD9, 0x5C6C}, //2243 #CJK UNIFIED IDEOGRAPH
    {0x8CDA, 0x5C6D}, //2244 #CJK UNIFIED IDEOGRAPH
    {0x8CDB, 0x5C70}, //2245 #CJK UNIFIED IDEOGRAPH
    {0x8CDC, 0x5C72}, //2246 #CJK UNIFIED IDEOGRAPH
    {0x8CDD, 0x5C73}, //2247 #CJK UNIFIED IDEOGRAPH
    {0x8CDE, 0x5C74}, //2248 #CJK UNIFIED IDEOGRAPH
    {0x8CDF, 0x5C75}, //2249 #CJK UNIFIED IDEOGRAPH
    {0x8CE0, 0x5C76}, //2250 #CJK UNIFIED IDEOGRAPH
    {0x8CE1, 0x5C77}, //2251 #CJK UNIFIED IDEOGRAPH
    {0x8CE2, 0x5C78}, //2252 #CJK UNIFIED IDEOGRAPH
    {0x8CE3, 0x5C7B}, //2253 #CJK UNIFIED IDEOGRAPH
    {0x8CE4, 0x5C7C}, //2254 #CJK UNIFIED IDEOGRAPH
    {0x8CE5, 0x5C7D}, //2255 #CJK UNIFIED IDEOGRAPH
    {0x8CE6, 0x5C7E}, //2256 #CJK UNIFIED IDEOGRAPH
    {0x8CE7, 0x5C80}, //2257 #CJK UNIFIED IDEOGRAPH
    {0x8CE8, 0x5C83}, //2258 #CJK UNIFIED IDEOGRAPH
    {0x8CE9, 0x5C84}, //2259 #CJK UNIFIED IDEOGRAPH
    {0x8CEA, 0x5C85}, //2260 #CJK UNIFIED IDEOGRAPH
    {0x8CEB, 0x5C86}, //2261 #CJK UNIFIED IDEOGRAPH
    {0x8CEC, 0x5C87}, //2262 #CJK UNIFIED IDEOGRAPH
    {0x8CED, 0x5C89}, //2263 #CJK UNIFIED IDEOGRAPH
    {0x8CEE, 0x5C8A}, //2264 #CJK UNIFIED IDEOGRAPH
    {0x8CEF, 0x5C8B}, //2265 #CJK UNIFIED IDEOGRAPH
    {0x8CF0, 0x5C8E}, //2266 #CJK UNIFIED IDEOGRAPH
    {0x8CF1, 0x5C8F}, //2267 #CJK UNIFIED IDEOGRAPH
    {0x8CF2, 0x5C92}, //2268 #CJK UNIFIED IDEOGRAPH
    {0x8CF3, 0x5C93}, //2269 #CJK UNIFIED IDEOGRAPH
    {0x8CF4, 0x5C95}, //2270 #CJK UNIFIED IDEOGRAPH
    {0x8CF5, 0x5C9D}, //2271 #CJK UNIFIED IDEOGRAPH
    {0x8CF6, 0x5C9E}, //2272 #CJK UNIFIED IDEOGRAPH
    {0x8CF7, 0x5C9F}, //2273 #CJK UNIFIED IDEOGRAPH
    {0x8CF8, 0x5CA0}, //2274 #CJK UNIFIED IDEOGRAPH
    {0x8CF9, 0x5CA1}, //2275 #CJK UNIFIED IDEOGRAPH
    {0x8CFA, 0x5CA4}, //2276 #CJK UNIFIED IDEOGRAPH
    {0x8CFB, 0x5CA5}, //2277 #CJK UNIFIED IDEOGRAPH
    {0x8CFC, 0x5CA6}, //2278 #CJK UNIFIED IDEOGRAPH
    {0x8CFD, 0x5CA7}, //2279 #CJK UNIFIED IDEOGRAPH
    {0x8CFE, 0x5CA8}, //2280 #CJK UNIFIED IDEOGRAPH
    {0x8D40, 0x5CAA}, //2281 #CJK UNIFIED IDEOGRAPH
    {0x8D41, 0x5CAE}, //2282 #CJK UNIFIED IDEOGRAPH
    {0x8D42, 0x5CAF}, //2283 #CJK UNIFIED IDEOGRAPH
    {0x8D43, 0x5CB0}, //2284 #CJK UNIFIED IDEOGRAPH
    {0x8D44, 0x5CB2}, //2285 #CJK UNIFIED IDEOGRAPH
    {0x8D45, 0x5CB4}, //2286 #CJK UNIFIED IDEOGRAPH
    {0x8D46, 0x5CB6}, //2287 #CJK UNIFIED IDEOGRAPH
    {0x8D47, 0x5CB9}, //2288 #CJK UNIFIED IDEOGRAPH
    {0x8D48, 0x5CBA}, //2289 #CJK UNIFIED IDEOGRAPH
    {0x8D49, 0x5CBB}, //2290 #CJK UNIFIED IDEOGRAPH
    {0x8D4A, 0x5CBC}, //2291 #CJK UNIFIED IDEOGRAPH
    {0x8D4B, 0x5CBE}, //2292 #CJK UNIFIED IDEOGRAPH
    {0x8D4C, 0x5CC0}, //2293 #CJK UNIFIED IDEOGRAPH
    {0x8D4D, 0x5CC2}, //2294 #CJK UNIFIED IDEOGRAPH
    {0x8D4E, 0x5CC3}, //2295 #CJK UNIFIED IDEOGRAPH
    {0x8D4F, 0x5CC5}, //2296 #CJK UNIFIED IDEOGRAPH
    {0x8D50, 0x5CC6}, //2297 #CJK UNIFIED IDEOGRAPH
    {0x8D51, 0x5CC7}, //2298 #CJK UNIFIED IDEOGRAPH
    {0x8D52, 0x5CC8}, //2299 #CJK UNIFIED IDEOGRAPH
    {0x8D53, 0x5CC9}, //2300 #CJK UNIFIED IDEOGRAPH
    {0x8D54, 0x5CCA}, //2301 #CJK UNIFIED IDEOGRAPH
    {0x8D55, 0x5CCC}, //2302 #CJK UNIFIED IDEOGRAPH
    {0x8D56, 0x5CCD}, //2303 #CJK UNIFIED IDEOGRAPH
    {0x8D57, 0x5CCE}, //2304 #CJK UNIFIED IDEOGRAPH
    {0x8D58, 0x5CCF}, //2305 #CJK UNIFIED IDEOGRAPH
    {0x8D59, 0x5CD0}, //2306 #CJK UNIFIED IDEOGRAPH
    {0x8D5A, 0x5CD1}, //2307 #CJK UNIFIED IDEOGRAPH
    {0x8D5B, 0x5CD3}, //2308 #CJK UNIFIED IDEOGRAPH
    {0x8D5C, 0x5CD4}, //2309 #CJK UNIFIED IDEOGRAPH
    {0x8D5D, 0x5CD5}, //2310 #CJK UNIFIED IDEOGRAPH
    {0x8D5E, 0x5CD6}, //2311 #CJK UNIFIED IDEOGRAPH
    {0x8D5F, 0x5CD7}, //2312 #CJK UNIFIED IDEOGRAPH
    {0x8D60, 0x5CD8}, //2313 #CJK UNIFIED IDEOGRAPH
    {0x8D61, 0x5CDA}, //2314 #CJK UNIFIED IDEOGRAPH
    {0x8D62, 0x5CDB}, //2315 #CJK UNIFIED IDEOGRAPH
    {0x8D63, 0x5CDC}, //2316 #CJK UNIFIED IDEOGRAPH
    {0x8D64, 0x5CDD}, //2317 #CJK UNIFIED IDEOGRAPH
    {0x8D65, 0x5CDE}, //2318 #CJK UNIFIED IDEOGRAPH
    {0x8D66, 0x5CDF}, //2319 #CJK UNIFIED IDEOGRAPH
    {0x8D67, 0x5CE0}, //2320 #CJK UNIFIED IDEOGRAPH
    {0x8D68, 0x5CE2}, //2321 #CJK UNIFIED IDEOGRAPH
    {0x8D69, 0x5CE3}, //2322 #CJK UNIFIED IDEOGRAPH
    {0x8D6A, 0x5CE7}, //2323 #CJK UNIFIED IDEOGRAPH
    {0x8D6B, 0x5CE9}, //2324 #CJK UNIFIED IDEOGRAPH
    {0x8D6C, 0x5CEB}, //2325 #CJK UNIFIED IDEOGRAPH
    {0x8D6D, 0x5CEC}, //2326 #CJK UNIFIED IDEOGRAPH
    {0x8D6E, 0x5CEE}, //2327 #CJK UNIFIED IDEOGRAPH
    {0x8D6F, 0x5CEF}, //2328 #CJK UNIFIED IDEOGRAPH
    {0x8D70, 0x5CF1}, //2329 #CJK UNIFIED IDEOGRAPH
    {0x8D71, 0x5CF2}, //2330 #CJK UNIFIED IDEOGRAPH
    {0x8D72, 0x5CF3}, //2331 #CJK UNIFIED IDEOGRAPH
    {0x8D73, 0x5CF4}, //2332 #CJK UNIFIED IDEOGRAPH
    {0x8D74, 0x5CF5}, //2333 #CJK UNIFIED IDEOGRAPH
    {0x8D75, 0x5CF6}, //2334 #CJK UNIFIED IDEOGRAPH
    {0x8D76, 0x5CF7}, //2335 #CJK UNIFIED IDEOGRAPH
    {0x8D77, 0x5CF8}, //2336 #CJK UNIFIED IDEOGRAPH
    {0x8D78, 0x5CF9}, //2337 #CJK UNIFIED IDEOGRAPH
    {0x8D79, 0x5CFA}, //2338 #CJK UNIFIED IDEOGRAPH
    {0x8D7A, 0x5CFC}, //2339 #CJK UNIFIED IDEOGRAPH
    {0x8D7B, 0x5CFD}, //2340 #CJK UNIFIED IDEOGRAPH
    {0x8D7C, 0x5CFE}, //2341 #CJK UNIFIED IDEOGRAPH
    {0x8D7D, 0x5CFF}, //2342 #CJK UNIFIED IDEOGRAPH
    {0x8D7E, 0x5D00}, //2343 #CJK UNIFIED IDEOGRAPH
    {0x8D80, 0x5D01}, //2344 #CJK UNIFIED IDEOGRAPH
    {0x8D81, 0x5D04}, //2345 #CJK UNIFIED IDEOGRAPH
    {0x8D82, 0x5D05}, //2346 #CJK UNIFIED IDEOGRAPH
    {0x8D83, 0x5D08}, //2347 #CJK UNIFIED IDEOGRAPH
    {0x8D84, 0x5D09}, //2348 #CJK UNIFIED IDEOGRAPH
    {0x8D85, 0x5D0A}, //2349 #CJK UNIFIED IDEOGRAPH
    {0x8D86, 0x5D0B}, //2350 #CJK UNIFIED IDEOGRAPH
    {0x8D87, 0x5D0C}, //2351 #CJK UNIFIED IDEOGRAPH
    {0x8D88, 0x5D0D}, //2352 #CJK UNIFIED IDEOGRAPH
    {0x8D89, 0x5D0F}, //2353 #CJK UNIFIED IDEOGRAPH
    {0x8D8A, 0x5D10}, //2354 #CJK UNIFIED IDEOGRAPH
    {0x8D8B, 0x5D11}, //2355 #CJK UNIFIED IDEOGRAPH
    {0x8D8C, 0x5D12}, //2356 #CJK UNIFIED IDEOGRAPH
    {0x8D8D, 0x5D13}, //2357 #CJK UNIFIED IDEOGRAPH
    {0x8D8E, 0x5D15}, //2358 #CJK UNIFIED IDEOGRAPH
    {0x8D8F, 0x5D17}, //2359 #CJK UNIFIED IDEOGRAPH
    {0x8D90, 0x5D18}, //2360 #CJK UNIFIED IDEOGRAPH
    {0x8D91, 0x5D19}, //2361 #CJK UNIFIED IDEOGRAPH
    {0x8D92, 0x5D1A}, //2362 #CJK UNIFIED IDEOGRAPH
    {0x8D93, 0x5D1C}, //2363 #CJK UNIFIED IDEOGRAPH
    {0x8D94, 0x5D1D}, //2364 #CJK UNIFIED IDEOGRAPH
    {0x8D95, 0x5D1F}, //2365 #CJK UNIFIED IDEOGRAPH
    {0x8D96, 0x5D20}, //2366 #CJK UNIFIED IDEOGRAPH
    {0x8D97, 0x5D21}, //2367 #CJK UNIFIED IDEOGRAPH
    {0x8D98, 0x5D22}, //2368 #CJK UNIFIED IDEOGRAPH
    {0x8D99, 0x5D23}, //2369 #CJK UNIFIED IDEOGRAPH
    {0x8D9A, 0x5D25}, //2370 #CJK UNIFIED IDEOGRAPH
    {0x8D9B, 0x5D28}, //2371 #CJK UNIFIED IDEOGRAPH
    {0x8D9C, 0x5D2A}, //2372 #CJK UNIFIED IDEOGRAPH
    {0x8D9D, 0x5D2B}, //2373 #CJK UNIFIED IDEOGRAPH
    {0x8D9E, 0x5D2C}, //2374 #CJK UNIFIED IDEOGRAPH
    {0x8D9F, 0x5D2F}, //2375 #CJK UNIFIED IDEOGRAPH
    {0x8DA0, 0x5D30}, //2376 #CJK UNIFIED IDEOGRAPH
    {0x8DA1, 0x5D31}, //2377 #CJK UNIFIED IDEOGRAPH
    {0x8DA2, 0x5D32}, //2378 #CJK UNIFIED IDEOGRAPH
    {0x8DA3, 0x5D33}, //2379 #CJK UNIFIED IDEOGRAPH
    {0x8DA4, 0x5D35}, //2380 #CJK UNIFIED IDEOGRAPH
    {0x8DA5, 0x5D36}, //2381 #CJK UNIFIED IDEOGRAPH
    {0x8DA6, 0x5D37}, //2382 #CJK UNIFIED IDEOGRAPH
    {0x8DA7, 0x5D38}, //2383 #CJK UNIFIED IDEOGRAPH
    {0x8DA8, 0x5D39}, //2384 #CJK UNIFIED IDEOGRAPH
    {0x8DA9, 0x5D3A}, //2385 #CJK UNIFIED IDEOGRAPH
    {0x8DAA, 0x5D3B}, //2386 #CJK UNIFIED IDEOGRAPH
    {0x8DAB, 0x5D3C}, //2387 #CJK UNIFIED IDEOGRAPH
    {0x8DAC, 0x5D3F}, //2388 #CJK UNIFIED IDEOGRAPH
    {0x8DAD, 0x5D40}, //2389 #CJK UNIFIED IDEOGRAPH
    {0x8DAE, 0x5D41}, //2390 #CJK UNIFIED IDEOGRAPH
    {0x8DAF, 0x5D42}, //2391 #CJK UNIFIED IDEOGRAPH
    {0x8DB0, 0x5D43}, //2392 #CJK UNIFIED IDEOGRAPH
    {0x8DB1, 0x5D44}, //2393 #CJK UNIFIED IDEOGRAPH
    {0x8DB2, 0x5D45}, //2394 #CJK UNIFIED IDEOGRAPH
    {0x8DB3, 0x5D46}, //2395 #CJK UNIFIED IDEOGRAPH
    {0x8DB4, 0x5D48}, //2396 #CJK UNIFIED IDEOGRAPH
    {0x8DB5, 0x5D49}, //2397 #CJK UNIFIED IDEOGRAPH
    {0x8DB6, 0x5D4D}, //2398 #CJK UNIFIED IDEOGRAPH
    {0x8DB7, 0x5D4E}, //2399 #CJK UNIFIED IDEOGRAPH
    {0x8DB8, 0x5D4F}, //2400 #CJK UNIFIED IDEOGRAPH
    {0x8DB9, 0x5D50}, //2401 #CJK UNIFIED IDEOGRAPH
    {0x8DBA, 0x5D51}, //2402 #CJK UNIFIED IDEOGRAPH
    {0x8DBB, 0x5D52}, //2403 #CJK UNIFIED IDEOGRAPH
    {0x8DBC, 0x5D53}, //2404 #CJK UNIFIED IDEOGRAPH
    {0x8DBD, 0x5D54}, //2405 #CJK UNIFIED IDEOGRAPH
    {0x8DBE, 0x5D55}, //2406 #CJK UNIFIED IDEOGRAPH
    {0x8DBF, 0x5D56}, //2407 #CJK UNIFIED IDEOGRAPH
    {0x8DC0, 0x5D57}, //2408 #CJK UNIFIED IDEOGRAPH
    {0x8DC1, 0x5D59}, //2409 #CJK UNIFIED IDEOGRAPH
    {0x8DC2, 0x5D5A}, //2410 #CJK UNIFIED IDEOGRAPH
    {0x8DC3, 0x5D5C}, //2411 #CJK UNIFIED IDEOGRAPH
    {0x8DC4, 0x5D5E}, //2412 #CJK UNIFIED IDEOGRAPH
    {0x8DC5, 0x5D5F}, //2413 #CJK UNIFIED IDEOGRAPH
    {0x8DC6, 0x5D60}, //2414 #CJK UNIFIED IDEOGRAPH
    {0x8DC7, 0x5D61}, //2415 #CJK UNIFIED IDEOGRAPH
    {0x8DC8, 0x5D62}, //2416 #CJK UNIFIED IDEOGRAPH
    {0x8DC9, 0x5D63}, //2417 #CJK UNIFIED IDEOGRAPH
    {0x8DCA, 0x5D64}, //2418 #CJK UNIFIED IDEOGRAPH
    {0x8DCB, 0x5D65}, //2419 #CJK UNIFIED IDEOGRAPH
    {0x8DCC, 0x5D66}, //2420 #CJK UNIFIED IDEOGRAPH
    {0x8DCD, 0x5D67}, //2421 #CJK UNIFIED IDEOGRAPH
    {0x8DCE, 0x5D68}, //2422 #CJK UNIFIED IDEOGRAPH
    {0x8DCF, 0x5D6A}, //2423 #CJK UNIFIED IDEOGRAPH
    {0x8DD0, 0x5D6D}, //2424 #CJK UNIFIED IDEOGRAPH
    {0x8DD1, 0x5D6E}, //2425 #CJK UNIFIED IDEOGRAPH
    {0x8DD2, 0x5D70}, //2426 #CJK UNIFIED IDEOGRAPH
    {0x8DD3, 0x5D71}, //2427 #CJK UNIFIED IDEOGRAPH
    {0x8DD4, 0x5D72}, //2428 #CJK UNIFIED IDEOGRAPH
    {0x8DD5, 0x5D73}, //2429 #CJK UNIFIED IDEOGRAPH
    {0x8DD6, 0x5D75}, //2430 #CJK UNIFIED IDEOGRAPH
    {0x8DD7, 0x5D76}, //2431 #CJK UNIFIED IDEOGRAPH
    {0x8DD8, 0x5D77}, //2432 #CJK UNIFIED IDEOGRAPH
    {0x8DD9, 0x5D78}, //2433 #CJK UNIFIED IDEOGRAPH
    {0x8DDA, 0x5D79}, //2434 #CJK UNIFIED IDEOGRAPH
    {0x8DDB, 0x5D7A}, //2435 #CJK UNIFIED IDEOGRAPH
    {0x8DDC, 0x5D7B}, //2436 #CJK UNIFIED IDEOGRAPH
    {0x8DDD, 0x5D7C}, //2437 #CJK UNIFIED IDEOGRAPH
    {0x8DDE, 0x5D7D}, //2438 #CJK UNIFIED IDEOGRAPH
    {0x8DDF, 0x5D7E}, //2439 #CJK UNIFIED IDEOGRAPH
    {0x8DE0, 0x5D7F}, //2440 #CJK UNIFIED IDEOGRAPH
    {0x8DE1, 0x5D80}, //2441 #CJK UNIFIED IDEOGRAPH
    {0x8DE2, 0x5D81}, //2442 #CJK UNIFIED IDEOGRAPH
    {0x8DE3, 0x5D83}, //2443 #CJK UNIFIED IDEOGRAPH
    {0x8DE4, 0x5D84}, //2444 #CJK UNIFIED IDEOGRAPH
    {0x8DE5, 0x5D85}, //2445 #CJK UNIFIED IDEOGRAPH
    {0x8DE6, 0x5D86}, //2446 #CJK UNIFIED IDEOGRAPH
    {0x8DE7, 0x5D87}, //2447 #CJK UNIFIED IDEOGRAPH
    {0x8DE8, 0x5D88}, //2448 #CJK UNIFIED IDEOGRAPH
    {0x8DE9, 0x5D89}, //2449 #CJK UNIFIED IDEOGRAPH
    {0x8DEA, 0x5D8A}, //2450 #CJK UNIFIED IDEOGRAPH
    {0x8DEB, 0x5D8B}, //2451 #CJK UNIFIED IDEOGRAPH
    {0x8DEC, 0x5D8C}, //2452 #CJK UNIFIED IDEOGRAPH
    {0x8DED, 0x5D8D}, //2453 #CJK UNIFIED IDEOGRAPH
    {0x8DEE, 0x5D8E}, //2454 #CJK UNIFIED IDEOGRAPH
    {0x8DEF, 0x5D8F}, //2455 #CJK UNIFIED IDEOGRAPH
    {0x8DF0, 0x5D90}, //2456 #CJK UNIFIED IDEOGRAPH
    {0x8DF1, 0x5D91}, //2457 #CJK UNIFIED IDEOGRAPH
    {0x8DF2, 0x5D92}, //2458 #CJK UNIFIED IDEOGRAPH
    {0x8DF3, 0x5D93}, //2459 #CJK UNIFIED IDEOGRAPH
    {0x8DF4, 0x5D94}, //2460 #CJK UNIFIED IDEOGRAPH
    {0x8DF5, 0x5D95}, //2461 #CJK UNIFIED IDEOGRAPH
    {0x8DF6, 0x5D96}, //2462 #CJK UNIFIED IDEOGRAPH
    {0x8DF7, 0x5D97}, //2463 #CJK UNIFIED IDEOGRAPH
    {0x8DF8, 0x5D98}, //2464 #CJK UNIFIED IDEOGRAPH
    {0x8DF9, 0x5D9A}, //2465 #CJK UNIFIED IDEOGRAPH
    {0x8DFA, 0x5D9B}, //2466 #CJK UNIFIED IDEOGRAPH
    {0x8DFB, 0x5D9C}, //2467 #CJK UNIFIED IDEOGRAPH
    {0x8DFC, 0x5D9E}, //2468 #CJK UNIFIED IDEOGRAPH
    {0x8DFD, 0x5D9F}, //2469 #CJK UNIFIED IDEOGRAPH
    {0x8DFE, 0x5DA0}, //2470 #CJK UNIFIED IDEOGRAPH
    {0x8E40, 0x5DA1}, //2471 #CJK UNIFIED IDEOGRAPH
    {0x8E41, 0x5DA2}, //2472 #CJK UNIFIED IDEOGRAPH
    {0x8E42, 0x5DA3}, //2473 #CJK UNIFIED IDEOGRAPH
    {0x8E43, 0x5DA4}, //2474 #CJK UNIFIED IDEOGRAPH
    {0x8E44, 0x5DA5}, //2475 #CJK UNIFIED IDEOGRAPH
    {0x8E45, 0x5DA6}, //2476 #CJK UNIFIED IDEOGRAPH
    {0x8E46, 0x5DA7}, //2477 #CJK UNIFIED IDEOGRAPH
    {0x8E47, 0x5DA8}, //2478 #CJK UNIFIED IDEOGRAPH
    {0x8E48, 0x5DA9}, //2479 #CJK UNIFIED IDEOGRAPH
    {0x8E49, 0x5DAA}, //2480 #CJK UNIFIED IDEOGRAPH
    {0x8E4A, 0x5DAB}, //2481 #CJK UNIFIED IDEOGRAPH
    {0x8E4B, 0x5DAC}, //2482 #CJK UNIFIED IDEOGRAPH
    {0x8E4C, 0x5DAD}, //2483 #CJK UNIFIED IDEOGRAPH
    {0x8E4D, 0x5DAE}, //2484 #CJK UNIFIED IDEOGRAPH
    {0x8E4E, 0x5DAF}, //2485 #CJK UNIFIED IDEOGRAPH
    {0x8E4F, 0x5DB0}, //2486 #CJK UNIFIED IDEOGRAPH
    {0x8E50, 0x5DB1}, //2487 #CJK UNIFIED IDEOGRAPH
    {0x8E51, 0x5DB2}, //2488 #CJK UNIFIED IDEOGRAPH
    {0x8E52, 0x5DB3}, //2489 #CJK UNIFIED IDEOGRAPH
    {0x8E53, 0x5DB4}, //2490 #CJK UNIFIED IDEOGRAPH
    {0x8E54, 0x5DB5}, //2491 #CJK UNIFIED IDEOGRAPH
    {0x8E55, 0x5DB6}, //2492 #CJK UNIFIED IDEOGRAPH
    {0x8E56, 0x5DB8}, //2493 #CJK UNIFIED IDEOGRAPH
    {0x8E57, 0x5DB9}, //2494 #CJK UNIFIED IDEOGRAPH
    {0x8E58, 0x5DBA}, //2495 #CJK UNIFIED IDEOGRAPH
    {0x8E59, 0x5DBB}, //2496 #CJK UNIFIED IDEOGRAPH
    {0x8E5A, 0x5DBC}, //2497 #CJK UNIFIED IDEOGRAPH
    {0x8E5B, 0x5DBD}, //2498 #CJK UNIFIED IDEOGRAPH
    {0x8E5C, 0x5DBE}, //2499 #CJK UNIFIED IDEOGRAPH
    {0x8E5D, 0x5DBF}, //2500 #CJK UNIFIED IDEOGRAPH
    {0x8E5E, 0x5DC0}, //2501 #CJK UNIFIED IDEOGRAPH
    {0x8E5F, 0x5DC1}, //2502 #CJK UNIFIED IDEOGRAPH
    {0x8E60, 0x5DC2}, //2503 #CJK UNIFIED IDEOGRAPH
    {0x8E61, 0x5DC3}, //2504 #CJK UNIFIED IDEOGRAPH
    {0x8E62, 0x5DC4}, //2505 #CJK UNIFIED IDEOGRAPH
    {0x8E63, 0x5DC6}, //2506 #CJK UNIFIED IDEOGRAPH
    {0x8E64, 0x5DC7}, //2507 #CJK UNIFIED IDEOGRAPH
    {0x8E65, 0x5DC8}, //2508 #CJK UNIFIED IDEOGRAPH
    {0x8E66, 0x5DC9}, //2509 #CJK UNIFIED IDEOGRAPH
    {0x8E67, 0x5DCA}, //2510 #CJK UNIFIED IDEOGRAPH
    {0x8E68, 0x5DCB}, //2511 #CJK UNIFIED IDEOGRAPH
    {0x8E69, 0x5DCC}, //2512 #CJK UNIFIED IDEOGRAPH
    {0x8E6A, 0x5DCE}, //2513 #CJK UNIFIED IDEOGRAPH
    {0x8E6B, 0x5DCF}, //2514 #CJK UNIFIED IDEOGRAPH
    {0x8E6C, 0x5DD0}, //2515 #CJK UNIFIED IDEOGRAPH
    {0x8E6D, 0x5DD1}, //2516 #CJK UNIFIED IDEOGRAPH
    {0x8E6E, 0x5DD2}, //2517 #CJK UNIFIED IDEOGRAPH
    {0x8E6F, 0x5DD3}, //2518 #CJK UNIFIED IDEOGRAPH
    {0x8E70, 0x5DD4}, //2519 #CJK UNIFIED IDEOGRAPH
    {0x8E71, 0x5DD5}, //2520 #CJK UNIFIED IDEOGRAPH
    {0x8E72, 0x5DD6}, //2521 #CJK UNIFIED IDEOGRAPH
    {0x8E73, 0x5DD7}, //2522 #CJK UNIFIED IDEOGRAPH
    {0x8E74, 0x5DD8}, //2523 #CJK UNIFIED IDEOGRAPH
    {0x8E75, 0x5DD9}, //2524 #CJK UNIFIED IDEOGRAPH
    {0x8E76, 0x5DDA}, //2525 #CJK UNIFIED IDEOGRAPH
    {0x8E77, 0x5DDC}, //2526 #CJK UNIFIED IDEOGRAPH
    {0x8E78, 0x5DDF}, //2527 #CJK UNIFIED IDEOGRAPH
    {0x8E79, 0x5DE0}, //2528 #CJK UNIFIED IDEOGRAPH
    {0x8E7A, 0x5DE3}, //2529 #CJK UNIFIED IDEOGRAPH
    {0x8E7B, 0x5DE4}, //2530 #CJK UNIFIED IDEOGRAPH
    {0x8E7C, 0x5DEA}, //2531 #CJK UNIFIED IDEOGRAPH
    {0x8E7D, 0x5DEC}, //2532 #CJK UNIFIED IDEOGRAPH
    {0x8E7E, 0x5DED}, //2533 #CJK UNIFIED IDEOGRAPH
    {0x8E80, 0x5DF0}, //2534 #CJK UNIFIED IDEOGRAPH
    {0x8E81, 0x5DF5}, //2535 #CJK UNIFIED IDEOGRAPH
    {0x8E82, 0x5DF6}, //2536 #CJK UNIFIED IDEOGRAPH
    {0x8E83, 0x5DF8}, //2537 #CJK UNIFIED IDEOGRAPH
    {0x8E84, 0x5DF9}, //2538 #CJK UNIFIED IDEOGRAPH
    {0x8E85, 0x5DFA}, //2539 #CJK UNIFIED IDEOGRAPH
    {0x8E86, 0x5DFB}, //2540 #CJK UNIFIED IDEOGRAPH
    {0x8E87, 0x5DFC}, //2541 #CJK UNIFIED IDEOGRAPH
    {0x8E88, 0x5DFF}, //2542 #CJK UNIFIED IDEOGRAPH
    {0x8E89, 0x5E00}, //2543 #CJK UNIFIED IDEOGRAPH
    {0x8E8A, 0x5E04}, //2544 #CJK UNIFIED IDEOGRAPH
    {0x8E8B, 0x5E07}, //2545 #CJK UNIFIED IDEOGRAPH
    {0x8E8C, 0x5E09}, //2546 #CJK UNIFIED IDEOGRAPH
    {0x8E8D, 0x5E0A}, //2547 #CJK UNIFIED IDEOGRAPH
    {0x8E8E, 0x5E0B}, //2548 #CJK UNIFIED IDEOGRAPH
    {0x8E8F, 0x5E0D}, //2549 #CJK UNIFIED IDEOGRAPH
    {0x8E90, 0x5E0E}, //2550 #CJK UNIFIED IDEOGRAPH
    {0x8E91, 0x5E12}, //2551 #CJK UNIFIED IDEOGRAPH
    {0x8E92, 0x5E13}, //2552 #CJK UNIFIED IDEOGRAPH
    {0x8E93, 0x5E17}, //2553 #CJK UNIFIED IDEOGRAPH
    {0x8E94, 0x5E1E}, //2554 #CJK UNIFIED IDEOGRAPH
    {0x8E95, 0x5E1F}, //2555 #CJK UNIFIED IDEOGRAPH
    {0x8E96, 0x5E20}, //2556 #CJK UNIFIED IDEOGRAPH
    {0x8E97, 0x5E21}, //2557 #CJK UNIFIED IDEOGRAPH
    {0x8E98, 0x5E22}, //2558 #CJK UNIFIED IDEOGRAPH
    {0x8E99, 0x5E23}, //2559 #CJK UNIFIED IDEOGRAPH
    {0x8E9A, 0x5E24}, //2560 #CJK UNIFIED IDEOGRAPH
    {0x8E9B, 0x5E25}, //2561 #CJK UNIFIED IDEOGRAPH
    {0x8E9C, 0x5E28}, //2562 #CJK UNIFIED IDEOGRAPH
    {0x8E9D, 0x5E29}, //2563 #CJK UNIFIED IDEOGRAPH
    {0x8E9E, 0x5E2A}, //2564 #CJK UNIFIED IDEOGRAPH
    {0x8E9F, 0x5E2B}, //2565 #CJK UNIFIED IDEOGRAPH
    {0x8EA0, 0x5E2C}, //2566 #CJK UNIFIED IDEOGRAPH
    {0x8EA1, 0x5E2F}, //2567 #CJK UNIFIED IDEOGRAPH
    {0x8EA2, 0x5E30}, //2568 #CJK UNIFIED IDEOGRAPH
    {0x8EA3, 0x5E32}, //2569 #CJK UNIFIED IDEOGRAPH
    {0x8EA4, 0x5E33}, //2570 #CJK UNIFIED IDEOGRAPH
    {0x8EA5, 0x5E34}, //2571 #CJK UNIFIED IDEOGRAPH
    {0x8EA6, 0x5E35}, //2572 #CJK UNIFIED IDEOGRAPH
    {0x8EA7, 0x5E36}, //2573 #CJK UNIFIED IDEOGRAPH
    {0x8EA8, 0x5E39}, //2574 #CJK UNIFIED IDEOGRAPH
    {0x8EA9, 0x5E3A}, //2575 #CJK UNIFIED IDEOGRAPH
    {0x8EAA, 0x5E3E}, //2576 #CJK UNIFIED IDEOGRAPH
    {0x8EAB, 0x5E3F}, //2577 #CJK UNIFIED IDEOGRAPH
    {0x8EAC, 0x5E40}, //2578 #CJK UNIFIED IDEOGRAPH
    {0x8EAD, 0x5E41}, //2579 #CJK UNIFIED IDEOGRAPH
    {0x8EAE, 0x5E43}, //2580 #CJK UNIFIED IDEOGRAPH
    {0x8EAF, 0x5E46}, //2581 #CJK UNIFIED IDEOGRAPH
    {0x8EB0, 0x5E47}, //2582 #CJK UNIFIED IDEOGRAPH
    {0x8EB1, 0x5E48}, //2583 #CJK UNIFIED IDEOGRAPH
    {0x8EB2, 0x5E49}, //2584 #CJK UNIFIED IDEOGRAPH
    {0x8EB3, 0x5E4A}, //2585 #CJK UNIFIED IDEOGRAPH
    {0x8EB4, 0x5E4B}, //2586 #CJK UNIFIED IDEOGRAPH
    {0x8EB5, 0x5E4D}, //2587 #CJK UNIFIED IDEOGRAPH
    {0x8EB6, 0x5E4E}, //2588 #CJK UNIFIED IDEOGRAPH
    {0x8EB7, 0x5E4F}, //2589 #CJK UNIFIED IDEOGRAPH
    {0x8EB8, 0x5E50}, //2590 #CJK UNIFIED IDEOGRAPH
    {0x8EB9, 0x5E51}, //2591 #CJK UNIFIED IDEOGRAPH
    {0x8EBA, 0x5E52}, //2592 #CJK UNIFIED IDEOGRAPH
    {0x8EBB, 0x5E53}, //2593 #CJK UNIFIED IDEOGRAPH
    {0x8EBC, 0x5E56}, //2594 #CJK UNIFIED IDEOGRAPH
    {0x8EBD, 0x5E57}, //2595 #CJK UNIFIED IDEOGRAPH
    {0x8EBE, 0x5E58}, //2596 #CJK UNIFIED IDEOGRAPH
    {0x8EBF, 0x5E59}, //2597 #CJK UNIFIED IDEOGRAPH
    {0x8EC0, 0x5E5A}, //2598 #CJK UNIFIED IDEOGRAPH
    {0x8EC1, 0x5E5C}, //2599 #CJK UNIFIED IDEOGRAPH
    {0x8EC2, 0x5E5D}, //2600 #CJK UNIFIED IDEOGRAPH
    {0x8EC3, 0x5E5F}, //2601 #CJK UNIFIED IDEOGRAPH
    {0x8EC4, 0x5E60}, //2602 #CJK UNIFIED IDEOGRAPH
    {0x8EC5, 0x5E63}, //2603 #CJK UNIFIED IDEOGRAPH
    {0x8EC6, 0x5E64}, //2604 #CJK UNIFIED IDEOGRAPH
    {0x8EC7, 0x5E65}, //2605 #CJK UNIFIED IDEOGRAPH
    {0x8EC8, 0x5E66}, //2606 #CJK UNIFIED IDEOGRAPH
    {0x8EC9, 0x5E67}, //2607 #CJK UNIFIED IDEOGRAPH
    {0x8ECA, 0x5E68}, //2608 #CJK UNIFIED IDEOGRAPH
    {0x8ECB, 0x5E69}, //2609 #CJK UNIFIED IDEOGRAPH
    {0x8ECC, 0x5E6A}, //2610 #CJK UNIFIED IDEOGRAPH
    {0x8ECD, 0x5E6B}, //2611 #CJK UNIFIED IDEOGRAPH
    {0x8ECE, 0x5E6C}, //2612 #CJK UNIFIED IDEOGRAPH
    {0x8ECF, 0x5E6D}, //2613 #CJK UNIFIED IDEOGRAPH
    {0x8ED0, 0x5E6E}, //2614 #CJK UNIFIED IDEOGRAPH
    {0x8ED1, 0x5E6F}, //2615 #CJK UNIFIED IDEOGRAPH
    {0x8ED2, 0x5E70}, //2616 #CJK UNIFIED IDEOGRAPH
    {0x8ED3, 0x5E71}, //2617 #CJK UNIFIED IDEOGRAPH
    {0x8ED4, 0x5E75}, //2618 #CJK UNIFIED IDEOGRAPH
    {0x8ED5, 0x5E77}, //2619 #CJK UNIFIED IDEOGRAPH
    {0x8ED6, 0x5E79}, //2620 #CJK UNIFIED IDEOGRAPH
    {0x8ED7, 0x5E7E}, //2621 #CJK UNIFIED IDEOGRAPH
    {0x8ED8, 0x5E81}, //2622 #CJK UNIFIED IDEOGRAPH
    {0x8ED9, 0x5E82}, //2623 #CJK UNIFIED IDEOGRAPH
    {0x8EDA, 0x5E83}, //2624 #CJK UNIFIED IDEOGRAPH
    {0x8EDB, 0x5E85}, //2625 #CJK UNIFIED IDEOGRAPH
    {0x8EDC, 0x5E88}, //2626 #CJK UNIFIED IDEOGRAPH
    {0x8EDD, 0x5E89}, //2627 #CJK UNIFIED IDEOGRAPH
    {0x8EDE, 0x5E8C}, //2628 #CJK UNIFIED IDEOGRAPH
    {0x8EDF, 0x5E8D}, //2629 #CJK UNIFIED IDEOGRAPH
    {0x8EE0, 0x5E8E}, //2630 #CJK UNIFIED IDEOGRAPH
    {0x8EE1, 0x5E92}, //2631 #CJK UNIFIED IDEOGRAPH
    {0x8EE2, 0x5E98}, //2632 #CJK UNIFIED IDEOGRAPH
    {0x8EE3, 0x5E9B}, //2633 #CJK UNIFIED IDEOGRAPH
    {0x8EE4, 0x5E9D}, //2634 #CJK UNIFIED IDEOGRAPH
    {0x8EE5, 0x5EA1}, //2635 #CJK UNIFIED IDEOGRAPH
    {0x8EE6, 0x5EA2}, //2636 #CJK UNIFIED IDEOGRAPH
    {0x8EE7, 0x5EA3}, //2637 #CJK UNIFIED IDEOGRAPH
    {0x8EE8, 0x5EA4}, //2638 #CJK UNIFIED IDEOGRAPH
    {0x8EE9, 0x5EA8}, //2639 #CJK UNIFIED IDEOGRAPH
    {0x8EEA, 0x5EA9}, //2640 #CJK UNIFIED IDEOGRAPH
    {0x8EEB, 0x5EAA}, //2641 #CJK UNIFIED IDEOGRAPH
    {0x8EEC, 0x5EAB}, //2642 #CJK UNIFIED IDEOGRAPH
    {0x8EED, 0x5EAC}, //2643 #CJK UNIFIED IDEOGRAPH
    {0x8EEE, 0x5EAE}, //2644 #CJK UNIFIED IDEOGRAPH
    {0x8EEF, 0x5EAF}, //2645 #CJK UNIFIED IDEOGRAPH
    {0x8EF0, 0x5EB0}, //2646 #CJK UNIFIED IDEOGRAPH
    {0x8EF1, 0x5EB1}, //2647 #CJK UNIFIED IDEOGRAPH
    {0x8EF2, 0x5EB2}, //2648 #CJK UNIFIED IDEOGRAPH
    {0x8EF3, 0x5EB4}, //2649 #CJK UNIFIED IDEOGRAPH
    {0x8EF4, 0x5EBA}, //2650 #CJK UNIFIED IDEOGRAPH
    {0x8EF5, 0x5EBB}, //2651 #CJK UNIFIED IDEOGRAPH
    {0x8EF6, 0x5EBC}, //2652 #CJK UNIFIED IDEOGRAPH
    {0x8EF7, 0x5EBD}, //2653 #CJK UNIFIED IDEOGRAPH
    {0x8EF8, 0x5EBF}, //2654 #CJK UNIFIED IDEOGRAPH
    {0x8EF9, 0x5EC0}, //2655 #CJK UNIFIED IDEOGRAPH
    {0x8EFA, 0x5EC1}, //2656 #CJK UNIFIED IDEOGRAPH
    {0x8EFB, 0x5EC2}, //2657 #CJK UNIFIED IDEOGRAPH
    {0x8EFC, 0x5EC3}, //2658 #CJK UNIFIED IDEOGRAPH
    {0x8EFD, 0x5EC4}, //2659 #CJK UNIFIED IDEOGRAPH
    {0x8EFE, 0x5EC5}, //2660 #CJK UNIFIED IDEOGRAPH
    {0x8F40, 0x5EC6}, //2661 #CJK UNIFIED IDEOGRAPH
    {0x8F41, 0x5EC7}, //2662 #CJK UNIFIED IDEOGRAPH
    {0x8F42, 0x5EC8}, //2663 #CJK UNIFIED IDEOGRAPH
    {0x8F43, 0x5ECB}, //2664 #CJK UNIFIED IDEOGRAPH
    {0x8F44, 0x5ECC}, //2665 #CJK UNIFIED IDEOGRAPH
    {0x8F45, 0x5ECD}, //2666 #CJK UNIFIED IDEOGRAPH
    {0x8F46, 0x5ECE}, //2667 #CJK UNIFIED IDEOGRAPH
    {0x8F47, 0x5ECF}, //2668 #CJK UNIFIED IDEOGRAPH
    {0x8F48, 0x5ED0}, //2669 #CJK UNIFIED IDEOGRAPH
    {0x8F49, 0x5ED4}, //2670 #CJK UNIFIED IDEOGRAPH
    {0x8F4A, 0x5ED5}, //2671 #CJK UNIFIED IDEOGRAPH
    {0x8F4B, 0x5ED7}, //2672 #CJK UNIFIED IDEOGRAPH
    {0x8F4C, 0x5ED8}, //2673 #CJK UNIFIED IDEOGRAPH
    {0x8F4D, 0x5ED9}, //2674 #CJK UNIFIED IDEOGRAPH
    {0x8F4E, 0x5EDA}, //2675 #CJK UNIFIED IDEOGRAPH
    {0x8F4F, 0x5EDC}, //2676 #CJK UNIFIED IDEOGRAPH
    {0x8F50, 0x5EDD}, //2677 #CJK UNIFIED IDEOGRAPH
    {0x8F51, 0x5EDE}, //2678 #CJK UNIFIED IDEOGRAPH
    {0x8F52, 0x5EDF}, //2679 #CJK UNIFIED IDEOGRAPH
    {0x8F53, 0x5EE0}, //2680 #CJK UNIFIED IDEOGRAPH
    {0x8F54, 0x5EE1}, //2681 #CJK UNIFIED IDEOGRAPH
    {0x8F55, 0x5EE2}, //2682 #CJK UNIFIED IDEOGRAPH
    {0x8F56, 0x5EE3}, //2683 #CJK UNIFIED IDEOGRAPH
    {0x8F57, 0x5EE4}, //2684 #CJK UNIFIED IDEOGRAPH
    {0x8F58, 0x5EE5}, //2685 #CJK UNIFIED IDEOGRAPH
    {0x8F59, 0x5EE6}, //2686 #CJK UNIFIED IDEOGRAPH
    {0x8F5A, 0x5EE7}, //2687 #CJK UNIFIED IDEOGRAPH
    {0x8F5B, 0x5EE9}, //2688 #CJK UNIFIED IDEOGRAPH
    {0x8F5C, 0x5EEB}, //2689 #CJK UNIFIED IDEOGRAPH
    {0x8F5D, 0x5EEC}, //2690 #CJK UNIFIED IDEOGRAPH
    {0x8F5E, 0x5EED}, //2691 #CJK UNIFIED IDEOGRAPH
    {0x8F5F, 0x5EEE}, //2692 #CJK UNIFIED IDEOGRAPH
    {0x8F60, 0x5EEF}, //2693 #CJK UNIFIED IDEOGRAPH
    {0x8F61, 0x5EF0}, //2694 #CJK UNIFIED IDEOGRAPH
    {0x8F62, 0x5EF1}, //2695 #CJK UNIFIED IDEOGRAPH
    {0x8F63, 0x5EF2}, //2696 #CJK UNIFIED IDEOGRAPH
    {0x8F64, 0x5EF3}, //2697 #CJK UNIFIED IDEOGRAPH
    {0x8F65, 0x5EF5}, //2698 #CJK UNIFIED IDEOGRAPH
    {0x8F66, 0x5EF8}, //2699 #CJK UNIFIED IDEOGRAPH
    {0x8F67, 0x5EF9}, //2700 #CJK UNIFIED IDEOGRAPH
    {0x8F68, 0x5EFB}, //2701 #CJK UNIFIED IDEOGRAPH
    {0x8F69, 0x5EFC}, //2702 #CJK UNIFIED IDEOGRAPH
    {0x8F6A, 0x5EFD}, //2703 #CJK UNIFIED IDEOGRAPH
    {0x8F6B, 0x5F05}, //2704 #CJK UNIFIED IDEOGRAPH
    {0x8F6C, 0x5F06}, //2705 #CJK UNIFIED IDEOGRAPH
    {0x8F6D, 0x5F07}, //2706 #CJK UNIFIED IDEOGRAPH
    {0x8F6E, 0x5F09}, //2707 #CJK UNIFIED IDEOGRAPH
    {0x8F6F, 0x5F0C}, //2708 #CJK UNIFIED IDEOGRAPH
    {0x8F70, 0x5F0D}, //2709 #CJK UNIFIED IDEOGRAPH
    {0x8F71, 0x5F0E}, //2710 #CJK UNIFIED IDEOGRAPH
    {0x8F72, 0x5F10}, //2711 #CJK UNIFIED IDEOGRAPH
    {0x8F73, 0x5F12}, //2712 #CJK UNIFIED IDEOGRAPH
    {0x8F74, 0x5F14}, //2713 #CJK UNIFIED IDEOGRAPH
    {0x8F75, 0x5F16}, //2714 #CJK UNIFIED IDEOGRAPH
    {0x8F76, 0x5F19}, //2715 #CJK UNIFIED IDEOGRAPH
    {0x8F77, 0x5F1A}, //2716 #CJK UNIFIED IDEOGRAPH
    {0x8F78, 0x5F1C}, //2717 #CJK UNIFIED IDEOGRAPH
    {0x8F79, 0x5F1D}, //2718 #CJK UNIFIED IDEOGRAPH
    {0x8F7A, 0x5F1E}, //2719 #CJK UNIFIED IDEOGRAPH
    {0x8F7B, 0x5F21}, //2720 #CJK UNIFIED IDEOGRAPH
    {0x8F7C, 0x5F22}, //2721 #CJK UNIFIED IDEOGRAPH
    {0x8F7D, 0x5F23}, //2722 #CJK UNIFIED IDEOGRAPH
    {0x8F7E, 0x5F24}, //2723 #CJK UNIFIED IDEOGRAPH
    {0x8F80, 0x5F28}, //2724 #CJK UNIFIED IDEOGRAPH
    {0x8F81, 0x5F2B}, //2725 #CJK UNIFIED IDEOGRAPH
    {0x8F82, 0x5F2C}, //2726 #CJK UNIFIED IDEOGRAPH
    {0x8F83, 0x5F2E}, //2727 #CJK UNIFIED IDEOGRAPH
    {0x8F84, 0x5F30}, //2728 #CJK UNIFIED IDEOGRAPH
    {0x8F85, 0x5F32}, //2729 #CJK UNIFIED IDEOGRAPH
    {0x8F86, 0x5F33}, //2730 #CJK UNIFIED IDEOGRAPH
    {0x8F87, 0x5F34}, //2731 #CJK UNIFIED IDEOGRAPH
    {0x8F88, 0x5F35}, //2732 #CJK UNIFIED IDEOGRAPH
    {0x8F89, 0x5F36}, //2733 #CJK UNIFIED IDEOGRAPH
    {0x8F8A, 0x5F37}, //2734 #CJK UNIFIED IDEOGRAPH
    {0x8F8B, 0x5F38}, //2735 #CJK UNIFIED IDEOGRAPH
    {0x8F8C, 0x5F3B}, //2736 #CJK UNIFIED IDEOGRAPH
    {0x8F8D, 0x5F3D}, //2737 #CJK UNIFIED IDEOGRAPH
    {0x8F8E, 0x5F3E}, //2738 #CJK UNIFIED IDEOGRAPH
    {0x8F8F, 0x5F3F}, //2739 #CJK UNIFIED IDEOGRAPH
    {0x8F90, 0x5F41}, //2740 #CJK UNIFIED IDEOGRAPH
    {0x8F91, 0x5F42}, //2741 #CJK UNIFIED IDEOGRAPH
    {0x8F92, 0x5F43}, //2742 #CJK UNIFIED IDEOGRAPH
    {0x8F93, 0x5F44}, //2743 #CJK UNIFIED IDEOGRAPH
    {0x8F94, 0x5F45}, //2744 #CJK UNIFIED IDEOGRAPH
    {0x8F95, 0x5F46}, //2745 #CJK UNIFIED IDEOGRAPH
    {0x8F96, 0x5F47}, //2746 #CJK UNIFIED IDEOGRAPH
    {0x8F97, 0x5F48}, //2747 #CJK UNIFIED IDEOGRAPH
    {0x8F98, 0x5F49}, //2748 #CJK UNIFIED IDEOGRAPH
    {0x8F99, 0x5F4A}, //2749 #CJK UNIFIED IDEOGRAPH
    {0x8F9A, 0x5F4B}, //2750 #CJK UNIFIED IDEOGRAPH
    {0x8F9B, 0x5F4C}, //2751 #CJK UNIFIED IDEOGRAPH
    {0x8F9C, 0x5F4D}, //2752 #CJK UNIFIED IDEOGRAPH
    {0x8F9D, 0x5F4E}, //2753 #CJK UNIFIED IDEOGRAPH
    {0x8F9E, 0x5F4F}, //2754 #CJK UNIFIED IDEOGRAPH
    {0x8F9F, 0x5F51}, //2755 #CJK UNIFIED IDEOGRAPH
    {0x8FA0, 0x5F54}, //2756 #CJK UNIFIED IDEOGRAPH
    {0x8FA1, 0x5F59}, //2757 #CJK UNIFIED IDEOGRAPH
    {0x8FA2, 0x5F5A}, //2758 #CJK UNIFIED IDEOGRAPH
    {0x8FA3, 0x5F5B}, //2759 #CJK UNIFIED IDEOGRAPH
    {0x8FA4, 0x5F5C}, //2760 #CJK UNIFIED IDEOGRAPH
    {0x8FA5, 0x5F5E}, //2761 #CJK UNIFIED IDEOGRAPH
    {0x8FA6, 0x5F5F}, //2762 #CJK UNIFIED IDEOGRAPH
    {0x8FA7, 0x5F60}, //2763 #CJK UNIFIED IDEOGRAPH
    {0x8FA8, 0x5F63}, //2764 #CJK UNIFIED IDEOGRAPH
    {0x8FA9, 0x5F65}, //2765 #CJK UNIFIED IDEOGRAPH
    {0x8FAA, 0x5F67}, //2766 #CJK UNIFIED IDEOGRAPH
    {0x8FAB, 0x5F68}, //2767 #CJK UNIFIED IDEOGRAPH
    {0x8FAC, 0x5F6B}, //2768 #CJK UNIFIED IDEOGRAPH
    {0x8FAD, 0x5F6E}, //2769 #CJK UNIFIED IDEOGRAPH
    {0x8FAE, 0x5F6F}, //2770 #CJK UNIFIED IDEOGRAPH
    {0x8FAF, 0x5F72}, //2771 #CJK UNIFIED IDEOGRAPH
    {0x8FB0, 0x5F74}, //2772 #CJK UNIFIED IDEOGRAPH
    {0x8FB1, 0x5F75}, //2773 #CJK UNIFIED IDEOGRAPH
    {0x8FB2, 0x5F76}, //2774 #CJK UNIFIED IDEOGRAPH
    {0x8FB3, 0x5F78}, //2775 #CJK UNIFIED IDEOGRAPH
    {0x8FB4, 0x5F7A}, //2776 #CJK UNIFIED IDEOGRAPH
    {0x8FB5, 0x5F7D}, //2777 #CJK UNIFIED IDEOGRAPH
    {0x8FB6, 0x5F7E}, //2778 #CJK UNIFIED IDEOGRAPH
    {0x8FB7, 0x5F7F}, //2779 #CJK UNIFIED IDEOGRAPH
    {0x8FB8, 0x5F83}, //2780 #CJK UNIFIED IDEOGRAPH
    {0x8FB9, 0x5F86}, //2781 #CJK UNIFIED IDEOGRAPH
    {0x8FBA, 0x5F8D}, //2782 #CJK UNIFIED IDEOGRAPH
    {0x8FBB, 0x5F8E}, //2783 #CJK UNIFIED IDEOGRAPH
    {0x8FBC, 0x5F8F}, //2784 #CJK UNIFIED IDEOGRAPH
    {0x8FBD, 0x5F91}, //2785 #CJK UNIFIED IDEOGRAPH
    {0x8FBE, 0x5F93}, //2786 #CJK UNIFIED IDEOGRAPH
    {0x8FBF, 0x5F94}, //2787 #CJK UNIFIED IDEOGRAPH
    {0x8FC0, 0x5F96}, //2788 #CJK UNIFIED IDEOGRAPH
    {0x8FC1, 0x5F9A}, //2789 #CJK UNIFIED IDEOGRAPH
    {0x8FC2, 0x5F9B}, //2790 #CJK UNIFIED IDEOGRAPH
    {0x8FC3, 0x5F9D}, //2791 #CJK UNIFIED IDEOGRAPH
    {0x8FC4, 0x5F9E}, //2792 #CJK UNIFIED IDEOGRAPH
    {0x8FC5, 0x5F9F}, //2793 #CJK UNIFIED IDEOGRAPH
    {0x8FC6, 0x5FA0}, //2794 #CJK UNIFIED IDEOGRAPH
    {0x8FC7, 0x5FA2}, //2795 #CJK UNIFIED IDEOGRAPH
    {0x8FC8, 0x5FA3}, //2796 #CJK UNIFIED IDEOGRAPH
    {0x8FC9, 0x5FA4}, //2797 #CJK UNIFIED IDEOGRAPH
    {0x8FCA, 0x5FA5}, //2798 #CJK UNIFIED IDEOGRAPH
    {0x8FCB, 0x5FA6}, //2799 #CJK UNIFIED IDEOGRAPH
    {0x8FCC, 0x5FA7}, //2800 #CJK UNIFIED IDEOGRAPH
    {0x8FCD, 0x5FA9}, //2801 #CJK UNIFIED IDEOGRAPH
    {0x8FCE, 0x5FAB}, //2802 #CJK UNIFIED IDEOGRAPH
    {0x8FCF, 0x5FAC}, //2803 #CJK UNIFIED IDEOGRAPH
    {0x8FD0, 0x5FAF}, //2804 #CJK UNIFIED IDEOGRAPH
    {0x8FD1, 0x5FB0}, //2805 #CJK UNIFIED IDEOGRAPH
    {0x8FD2, 0x5FB1}, //2806 #CJK UNIFIED IDEOGRAPH
    {0x8FD3, 0x5FB2}, //2807 #CJK UNIFIED IDEOGRAPH
    {0x8FD4, 0x5FB3}, //2808 #CJK UNIFIED IDEOGRAPH
    {0x8FD5, 0x5FB4}, //2809 #CJK UNIFIED IDEOGRAPH
    {0x8FD6, 0x5FB6}, //2810 #CJK UNIFIED IDEOGRAPH
    {0x8FD7, 0x5FB8}, //2811 #CJK UNIFIED IDEOGRAPH
    {0x8FD8, 0x5FB9}, //2812 #CJK UNIFIED IDEOGRAPH
    {0x8FD9, 0x5FBA}, //2813 #CJK UNIFIED IDEOGRAPH
    {0x8FDA, 0x5FBB}, //2814 #CJK UNIFIED IDEOGRAPH
    {0x8FDB, 0x5FBE}, //2815 #CJK UNIFIED IDEOGRAPH
    {0x8FDC, 0x5FBF}, //2816 #CJK UNIFIED IDEOGRAPH
    {0x8FDD, 0x5FC0}, //2817 #CJK UNIFIED IDEOGRAPH
    {0x8FDE, 0x5FC1}, //2818 #CJK UNIFIED IDEOGRAPH
    {0x8FDF, 0x5FC2}, //2819 #CJK UNIFIED IDEOGRAPH
    {0x8FE0, 0x5FC7}, //2820 #CJK UNIFIED IDEOGRAPH
    {0x8FE1, 0x5FC8}, //2821 #CJK UNIFIED IDEOGRAPH
    {0x8FE2, 0x5FCA}, //2822 #CJK UNIFIED IDEOGRAPH
    {0x8FE3, 0x5FCB}, //2823 #CJK UNIFIED IDEOGRAPH
    {0x8FE4, 0x5FCE}, //2824 #CJK UNIFIED IDEOGRAPH
    {0x8FE5, 0x5FD3}, //2825 #CJK UNIFIED IDEOGRAPH
    {0x8FE6, 0x5FD4}, //2826 #CJK UNIFIED IDEOGRAPH
    {0x8FE7, 0x5FD5}, //2827 #CJK UNIFIED IDEOGRAPH
    {0x8FE8, 0x5FDA}, //2828 #CJK UNIFIED IDEOGRAPH
    {0x8FE9, 0x5FDB}, //2829 #CJK UNIFIED IDEOGRAPH
    {0x8FEA, 0x5FDC}, //2830 #CJK UNIFIED IDEOGRAPH
    {0x8FEB, 0x5FDE}, //2831 #CJK UNIFIED IDEOGRAPH
    {0x8FEC, 0x5FDF}, //2832 #CJK UNIFIED IDEOGRAPH
    {0x8FED, 0x5FE2}, //2833 #CJK UNIFIED IDEOGRAPH
    {0x8FEE, 0x5FE3}, //2834 #CJK UNIFIED IDEOGRAPH
    {0x8FEF, 0x5FE5}, //2835 #CJK UNIFIED IDEOGRAPH
    {0x8FF0, 0x5FE6}, //2836 #CJK UNIFIED IDEOGRAPH
    {0x8FF1, 0x5FE8}, //2837 #CJK UNIFIED IDEOGRAPH
    {0x8FF2, 0x5FE9}, //2838 #CJK UNIFIED IDEOGRAPH
    {0x8FF3, 0x5FEC}, //2839 #CJK UNIFIED IDEOGRAPH
    {0x8FF4, 0x5FEF}, //2840 #CJK UNIFIED IDEOGRAPH
    {0x8FF5, 0x5FF0}, //2841 #CJK UNIFIED IDEOGRAPH
    {0x8FF6, 0x5FF2}, //2842 #CJK UNIFIED IDEOGRAPH
    {0x8FF7, 0x5FF3}, //2843 #CJK UNIFIED IDEOGRAPH
    {0x8FF8, 0x5FF4}, //2844 #CJK UNIFIED IDEOGRAPH
    {0x8FF9, 0x5FF6}, //2845 #CJK UNIFIED IDEOGRAPH
    {0x8FFA, 0x5FF7}, //2846 #CJK UNIFIED IDEOGRAPH
    {0x8FFB, 0x5FF9}, //2847 #CJK UNIFIED IDEOGRAPH
    {0x8FFC, 0x5FFA}, //2848 #CJK UNIFIED IDEOGRAPH
    {0x8FFD, 0x5FFC}, //2849 #CJK UNIFIED IDEOGRAPH
    {0x8FFE, 0x6007}, //2850 #CJK UNIFIED IDEOGRAPH
    {0x9040, 0x6008}, //2851 #CJK UNIFIED IDEOGRAPH
    {0x9041, 0x6009}, //2852 #CJK UNIFIED IDEOGRAPH
    {0x9042, 0x600B}, //2853 #CJK UNIFIED IDEOGRAPH
    {0x9043, 0x600C}, //2854 #CJK UNIFIED IDEOGRAPH
    {0x9044, 0x6010}, //2855 #CJK UNIFIED IDEOGRAPH
    {0x9045, 0x6011}, //2856 #CJK UNIFIED IDEOGRAPH
    {0x9046, 0x6013}, //2857 #CJK UNIFIED IDEOGRAPH
    {0x9047, 0x6017}, //2858 #CJK UNIFIED IDEOGRAPH
    {0x9048, 0x6018}, //2859 #CJK UNIFIED IDEOGRAPH
    {0x9049, 0x601A}, //2860 #CJK UNIFIED IDEOGRAPH
    {0x904A, 0x601E}, //2861 #CJK UNIFIED IDEOGRAPH
    {0x904B, 0x601F}, //2862 #CJK UNIFIED IDEOGRAPH
    {0x904C, 0x6022}, //2863 #CJK UNIFIED IDEOGRAPH
    {0x904D, 0x6023}, //2864 #CJK UNIFIED IDEOGRAPH
    {0x904E, 0x6024}, //2865 #CJK UNIFIED IDEOGRAPH
    {0x904F, 0x602C}, //2866 #CJK UNIFIED IDEOGRAPH
    {0x9050, 0x602D}, //2867 #CJK UNIFIED IDEOGRAPH
    {0x9051, 0x602E}, //2868 #CJK UNIFIED IDEOGRAPH
    {0x9052, 0x6030}, //2869 #CJK UNIFIED IDEOGRAPH
    {0x9053, 0x6031}, //2870 #CJK UNIFIED IDEOGRAPH
    {0x9054, 0x6032}, //2871 #CJK UNIFIED IDEOGRAPH
    {0x9055, 0x6033}, //2872 #CJK UNIFIED IDEOGRAPH
    {0x9056, 0x6034}, //2873 #CJK UNIFIED IDEOGRAPH
    {0x9057, 0x6036}, //2874 #CJK UNIFIED IDEOGRAPH
    {0x9058, 0x6037}, //2875 #CJK UNIFIED IDEOGRAPH
    {0x9059, 0x6038}, //2876 #CJK UNIFIED IDEOGRAPH
    {0x905A, 0x6039}, //2877 #CJK UNIFIED IDEOGRAPH
    {0x905B, 0x603A}, //2878 #CJK UNIFIED IDEOGRAPH
    {0x905C, 0x603D}, //2879 #CJK UNIFIED IDEOGRAPH
    {0x905D, 0x603E}, //2880 #CJK UNIFIED IDEOGRAPH
    {0x905E, 0x6040}, //2881 #CJK UNIFIED IDEOGRAPH
    {0x905F, 0x6044}, //2882 #CJK UNIFIED IDEOGRAPH
    {0x9060, 0x6045}, //2883 #CJK UNIFIED IDEOGRAPH
    {0x9061, 0x6046}, //2884 #CJK UNIFIED IDEOGRAPH
    {0x9062, 0x6047}, //2885 #CJK UNIFIED IDEOGRAPH
    {0x9063, 0x6048}, //2886 #CJK UNIFIED IDEOGRAPH
    {0x9064, 0x6049}, //2887 #CJK UNIFIED IDEOGRAPH
    {0x9065, 0x604A}, //2888 #CJK UNIFIED IDEOGRAPH
    {0x9066, 0x604C}, //2889 #CJK UNIFIED IDEOGRAPH
    {0x9067, 0x604E}, //2890 #CJK UNIFIED IDEOGRAPH
    {0x9068, 0x604F}, //2891 #CJK UNIFIED IDEOGRAPH
    {0x9069, 0x6051}, //2892 #CJK UNIFIED IDEOGRAPH
    {0x906A, 0x6053}, //2893 #CJK UNIFIED IDEOGRAPH
    {0x906B, 0x6054}, //2894 #CJK UNIFIED IDEOGRAPH
    {0x906C, 0x6056}, //2895 #CJK UNIFIED IDEOGRAPH
    {0x906D, 0x6057}, //2896 #CJK UNIFIED IDEOGRAPH
    {0x906E, 0x6058}, //2897 #CJK UNIFIED IDEOGRAPH
    {0x906F, 0x605B}, //2898 #CJK UNIFIED IDEOGRAPH
    {0x9070, 0x605C}, //2899 #CJK UNIFIED IDEOGRAPH
    {0x9071, 0x605E}, //2900 #CJK UNIFIED IDEOGRAPH
    {0x9072, 0x605F}, //2901 #CJK UNIFIED IDEOGRAPH
    {0x9073, 0x6060}, //2902 #CJK UNIFIED IDEOGRAPH
    {0x9074, 0x6061}, //2903 #CJK UNIFIED IDEOGRAPH
    {0x9075, 0x6065}, //2904 #CJK UNIFIED IDEOGRAPH
    {0x9076, 0x6066}, //2905 #CJK UNIFIED IDEOGRAPH
    {0x9077, 0x606E}, //2906 #CJK UNIFIED IDEOGRAPH
    {0x9078, 0x6071}, //2907 #CJK UNIFIED IDEOGRAPH
    {0x9079, 0x6072}, //2908 #CJK UNIFIED IDEOGRAPH
    {0x907A, 0x6074}, //2909 #CJK UNIFIED IDEOGRAPH
    {0x907B, 0x6075}, //2910 #CJK UNIFIED IDEOGRAPH
    {0x907C, 0x6077}, //2911 #CJK UNIFIED IDEOGRAPH
    {0x907D, 0x607E}, //2912 #CJK UNIFIED IDEOGRAPH
    {0x907E, 0x6080}, //2913 #CJK UNIFIED IDEOGRAPH
    {0x9080, 0x6081}, //2914 #CJK UNIFIED IDEOGRAPH
    {0x9081, 0x6082}, //2915 #CJK UNIFIED IDEOGRAPH
    {0x9082, 0x6085}, //2916 #CJK UNIFIED IDEOGRAPH
    {0x9083, 0x6086}, //2917 #CJK UNIFIED IDEOGRAPH
    {0x9084, 0x6087}, //2918 #CJK UNIFIED IDEOGRAPH
    {0x9085, 0x6088}, //2919 #CJK UNIFIED IDEOGRAPH
    {0x9086, 0x608A}, //2920 #CJK UNIFIED IDEOGRAPH
    {0x9087, 0x608B}, //2921 #CJK UNIFIED IDEOGRAPH
    {0x9088, 0x608E}, //2922 #CJK UNIFIED IDEOGRAPH
    {0x9089, 0x608F}, //2923 #CJK UNIFIED IDEOGRAPH
    {0x908A, 0x6090}, //2924 #CJK UNIFIED IDEOGRAPH
    {0x908B, 0x6091}, //2925 #CJK UNIFIED IDEOGRAPH
    {0x908C, 0x6093}, //2926 #CJK UNIFIED IDEOGRAPH
    {0x908D, 0x6095}, //2927 #CJK UNIFIED IDEOGRAPH
    {0x908E, 0x6097}, //2928 #CJK UNIFIED IDEOGRAPH
    {0x908F, 0x6098}, //2929 #CJK UNIFIED IDEOGRAPH
    {0x9090, 0x6099}, //2930 #CJK UNIFIED IDEOGRAPH
    {0x9091, 0x609C}, //2931 #CJK UNIFIED IDEOGRAPH
    {0x9092, 0x609E}, //2932 #CJK UNIFIED IDEOGRAPH
    {0x9093, 0x60A1}, //2933 #CJK UNIFIED IDEOGRAPH
    {0x9094, 0x60A2}, //2934 #CJK UNIFIED IDEOGRAPH
    {0x9095, 0x60A4}, //2935 #CJK UNIFIED IDEOGRAPH
    {0x9096, 0x60A5}, //2936 #CJK UNIFIED IDEOGRAPH
    {0x9097, 0x60A7}, //2937 #CJK UNIFIED IDEOGRAPH
    {0x9098, 0x60A9}, //2938 #CJK UNIFIED IDEOGRAPH
    {0x9099, 0x60AA}, //2939 #CJK UNIFIED IDEOGRAPH
    {0x909A, 0x60AE}, //2940 #CJK UNIFIED IDEOGRAPH
    {0x909B, 0x60B0}, //2941 #CJK UNIFIED IDEOGRAPH
    {0x909C, 0x60B3}, //2942 #CJK UNIFIED IDEOGRAPH
    {0x909D, 0x60B5}, //2943 #CJK UNIFIED IDEOGRAPH
    {0x909E, 0x60B6}, //2944 #CJK UNIFIED IDEOGRAPH
    {0x909F, 0x60B7}, //2945 #CJK UNIFIED IDEOGRAPH
    {0x90A0, 0x60B9}, //2946 #CJK UNIFIED IDEOGRAPH
    {0x90A1, 0x60BA}, //2947 #CJK UNIFIED IDEOGRAPH
    {0x90A2, 0x60BD}, //2948 #CJK UNIFIED IDEOGRAPH
    {0x90A3, 0x60BE}, //2949 #CJK UNIFIED IDEOGRAPH
    {0x90A4, 0x60BF}, //2950 #CJK UNIFIED IDEOGRAPH
    {0x90A5, 0x60C0}, //2951 #CJK UNIFIED IDEOGRAPH
    {0x90A6, 0x60C1}, //2952 #CJK UNIFIED IDEOGRAPH
    {0x90A7, 0x60C2}, //2953 #CJK UNIFIED IDEOGRAPH
    {0x90A8, 0x60C3}, //2954 #CJK UNIFIED IDEOGRAPH
    {0x90A9, 0x60C4}, //2955 #CJK UNIFIED IDEOGRAPH
    {0x90AA, 0x60C7}, //2956 #CJK UNIFIED IDEOGRAPH
    {0x90AB, 0x60C8}, //2957 #CJK UNIFIED IDEOGRAPH
    {0x90AC, 0x60C9}, //2958 #CJK UNIFIED IDEOGRAPH
    {0x90AD, 0x60CC}, //2959 #CJK UNIFIED IDEOGRAPH
    {0x90AE, 0x60CD}, //2960 #CJK UNIFIED IDEOGRAPH
    {0x90AF, 0x60CE}, //2961 #CJK UNIFIED IDEOGRAPH
    {0x90B0, 0x60CF}, //2962 #CJK UNIFIED IDEOGRAPH
    {0x90B1, 0x60D0}, //2963 #CJK UNIFIED IDEOGRAPH
    {0x90B2, 0x60D2}, //2964 #CJK UNIFIED IDEOGRAPH
    {0x90B3, 0x60D3}, //2965 #CJK UNIFIED IDEOGRAPH
    {0x90B4, 0x60D4}, //2966 #CJK UNIFIED IDEOGRAPH
    {0x90B5, 0x60D6}, //2967 #CJK UNIFIED IDEOGRAPH
    {0x90B6, 0x60D7}, //2968 #CJK UNIFIED IDEOGRAPH
    {0x90B7, 0x60D9}, //2969 #CJK UNIFIED IDEOGRAPH
    {0x90B8, 0x60DB}, //2970 #CJK UNIFIED IDEOGRAPH
    {0x90B9, 0x60DE}, //2971 #CJK UNIFIED IDEOGRAPH
    {0x90BA, 0x60E1}, //2972 #CJK UNIFIED IDEOGRAPH
    {0x90BB, 0x60E2}, //2973 #CJK UNIFIED IDEOGRAPH
    {0x90BC, 0x60E3}, //2974 #CJK UNIFIED IDEOGRAPH
    {0x90BD, 0x60E4}, //2975 #CJK UNIFIED IDEOGRAPH
    {0x90BE, 0x60E5}, //2976 #CJK UNIFIED IDEOGRAPH
    {0x90BF, 0x60EA}, //2977 #CJK UNIFIED IDEOGRAPH
    {0x90C0, 0x60F1}, //2978 #CJK UNIFIED IDEOGRAPH
    {0x90C1, 0x60F2}, //2979 #CJK UNIFIED IDEOGRAPH
    {0x90C2, 0x60F5}, //2980 #CJK UNIFIED IDEOGRAPH
    {0x90C3, 0x60F7}, //2981 #CJK UNIFIED IDEOGRAPH
    {0x90C4, 0x60F8}, //2982 #CJK UNIFIED IDEOGRAPH
    {0x90C5, 0x60FB}, //2983 #CJK UNIFIED IDEOGRAPH
    {0x90C6, 0x60FC}, //2984 #CJK UNIFIED IDEOGRAPH
    {0x90C7, 0x60FD}, //2985 #CJK UNIFIED IDEOGRAPH
    {0x90C8, 0x60FE}, //2986 #CJK UNIFIED IDEOGRAPH
    {0x90C9, 0x60FF}, //2987 #CJK UNIFIED IDEOGRAPH
    {0x90CA, 0x6102}, //2988 #CJK UNIFIED IDEOGRAPH
    {0x90CB, 0x6103}, //2989 #CJK UNIFIED IDEOGRAPH
    {0x90CC, 0x6104}, //2990 #CJK UNIFIED IDEOGRAPH
    {0x90CD, 0x6105}, //2991 #CJK UNIFIED IDEOGRAPH
    {0x90CE, 0x6107}, //2992 #CJK UNIFIED IDEOGRAPH
    {0x90CF, 0x610A}, //2993 #CJK UNIFIED IDEOGRAPH
    {0x90D0, 0x610B}, //2994 #CJK UNIFIED IDEOGRAPH
    {0x90D1, 0x610C}, //2995 #CJK UNIFIED IDEOGRAPH
    {0x90D2, 0x6110}, //2996 #CJK UNIFIED IDEOGRAPH
    {0x90D3, 0x6111}, //2997 #CJK UNIFIED IDEOGRAPH
    {0x90D4, 0x6112}, //2998 #CJK UNIFIED IDEOGRAPH
    {0x90D5, 0x6113}, //2999 #CJK UNIFIED IDEOGRAPH
    {0x90D6, 0x6114}, //3000 #CJK UNIFIED IDEOGRAPH
    {0x90D7, 0x6116}, //3001 #CJK UNIFIED IDEOGRAPH
    {0x90D8, 0x6117}, //3002 #CJK UNIFIED IDEOGRAPH
    {0x90D9, 0x6118}, //3003 #CJK UNIFIED IDEOGRAPH
    {0x90DA, 0x6119}, //3004 #CJK UNIFIED IDEOGRAPH
    {0x90DB, 0x611B}, //3005 #CJK UNIFIED IDEOGRAPH
    {0x90DC, 0x611C}, //3006 #CJK UNIFIED IDEOGRAPH
    {0x90DD, 0x611D}, //3007 #CJK UNIFIED IDEOGRAPH
    {0x90DE, 0x611E}, //3008 #CJK UNIFIED IDEOGRAPH
    {0x90DF, 0x6121}, //3009 #CJK UNIFIED IDEOGRAPH
    {0x90E0, 0x6122}, //3010 #CJK UNIFIED IDEOGRAPH
    {0x90E1, 0x6125}, //3011 #CJK UNIFIED IDEOGRAPH
    {0x90E2, 0x6128}, //3012 #CJK UNIFIED IDEOGRAPH
    {0x90E3, 0x6129}, //3013 #CJK UNIFIED IDEOGRAPH
    {0x90E4, 0x612A}, //3014 #CJK UNIFIED IDEOGRAPH
    {0x90E5, 0x612C}, //3015 #CJK UNIFIED IDEOGRAPH
    {0x90E6, 0x612D}, //3016 #CJK UNIFIED IDEOGRAPH
    {0x90E7, 0x612E}, //3017 #CJK UNIFIED IDEOGRAPH
    {0x90E8, 0x612F}, //3018 #CJK UNIFIED IDEOGRAPH
    {0x90E9, 0x6130}, //3019 #CJK UNIFIED IDEOGRAPH
    {0x90EA, 0x6131}, //3020 #CJK UNIFIED IDEOGRAPH
    {0x90EB, 0x6132}, //3021 #CJK UNIFIED IDEOGRAPH
    {0x90EC, 0x6133}, //3022 #CJK UNIFIED IDEOGRAPH
    {0x90ED, 0x6134}, //3023 #CJK UNIFIED IDEOGRAPH
    {0x90EE, 0x6135}, //3024 #CJK UNIFIED IDEOGRAPH
    {0x90EF, 0x6136}, //3025 #CJK UNIFIED IDEOGRAPH
    {0x90F0, 0x6137}, //3026 #CJK UNIFIED IDEOGRAPH
    {0x90F1, 0x6138}, //3027 #CJK UNIFIED IDEOGRAPH
    {0x90F2, 0x6139}, //3028 #CJK UNIFIED IDEOGRAPH
    {0x90F3, 0x613A}, //3029 #CJK UNIFIED IDEOGRAPH
    {0x90F4, 0x613B}, //3030 #CJK UNIFIED IDEOGRAPH
    {0x90F5, 0x613C}, //3031 #CJK UNIFIED IDEOGRAPH
    {0x90F6, 0x613D}, //3032 #CJK UNIFIED IDEOGRAPH
    {0x90F7, 0x613E}, //3033 #CJK UNIFIED IDEOGRAPH
    {0x90F8, 0x6140}, //3034 #CJK UNIFIED IDEOGRAPH
    {0x90F9, 0x6141}, //3035 #CJK UNIFIED IDEOGRAPH
    {0x90FA, 0x6142}, //3036 #CJK UNIFIED IDEOGRAPH
    {0x90FB, 0x6143}, //3037 #CJK UNIFIED IDEOGRAPH
    {0x90FC, 0x6144}, //3038 #CJK UNIFIED IDEOGRAPH
    {0x90FD, 0x6145}, //3039 #CJK UNIFIED IDEOGRAPH
    {0x90FE, 0x6146}, //3040 #CJK UNIFIED IDEOGRAPH
    {0x9140, 0x6147}, //3041 #CJK UNIFIED IDEOGRAPH
    {0x9141, 0x6149}, //3042 #CJK UNIFIED IDEOGRAPH
    {0x9142, 0x614B}, //3043 #CJK UNIFIED IDEOGRAPH
    {0x9143, 0x614D}, //3044 #CJK UNIFIED IDEOGRAPH
    {0x9144, 0x614F}, //3045 #CJK UNIFIED IDEOGRAPH
    {0x9145, 0x6150}, //3046 #CJK UNIFIED IDEOGRAPH
    {0x9146, 0x6152}, //3047 #CJK UNIFIED IDEOGRAPH
    {0x9147, 0x6153}, //3048 #CJK UNIFIED IDEOGRAPH
    {0x9148, 0x6154}, //3049 #CJK UNIFIED IDEOGRAPH
    {0x9149, 0x6156}, //3050 #CJK UNIFIED IDEOGRAPH
    {0x914A, 0x6157}, //3051 #CJK UNIFIED IDEOGRAPH
    {0x914B, 0x6158}, //3052 #CJK UNIFIED IDEOGRAPH
    {0x914C, 0x6159}, //3053 #CJK UNIFIED IDEOGRAPH
    {0x914D, 0x615A}, //3054 #CJK UNIFIED IDEOGRAPH
    {0x914E, 0x615B}, //3055 #CJK UNIFIED IDEOGRAPH
    {0x914F, 0x615C}, //3056 #CJK UNIFIED IDEOGRAPH
    {0x9150, 0x615E}, //3057 #CJK UNIFIED IDEOGRAPH
    {0x9151, 0x615F}, //3058 #CJK UNIFIED IDEOGRAPH
    {0x9152, 0x6160}, //3059 #CJK UNIFIED IDEOGRAPH
    {0x9153, 0x6161}, //3060 #CJK UNIFIED IDEOGRAPH
    {0x9154, 0x6163}, //3061 #CJK UNIFIED IDEOGRAPH
    {0x9155, 0x6164}, //3062 #CJK UNIFIED IDEOGRAPH
    {0x9156, 0x6165}, //3063 #CJK UNIFIED IDEOGRAPH
    {0x9157, 0x6166}, //3064 #CJK UNIFIED IDEOGRAPH
    {0x9158, 0x6169}, //3065 #CJK UNIFIED IDEOGRAPH
    {0x9159, 0x616A}, //3066 #CJK UNIFIED IDEOGRAPH
    {0x915A, 0x616B}, //3067 #CJK UNIFIED IDEOGRAPH
    {0x915B, 0x616C}, //3068 #CJK UNIFIED IDEOGRAPH
    {0x915C, 0x616D}, //3069 #CJK UNIFIED IDEOGRAPH
    {0x915D, 0x616E}, //3070 #CJK UNIFIED IDEOGRAPH
    {0x915E, 0x616F}, //3071 #CJK UNIFIED IDEOGRAPH
    {0x915F, 0x6171}, //3072 #CJK UNIFIED IDEOGRAPH
    {0x9160, 0x6172}, //3073 #CJK UNIFIED IDEOGRAPH
    {0x9161, 0x6173}, //3074 #CJK UNIFIED IDEOGRAPH
    {0x9162, 0x6174}, //3075 #CJK UNIFIED IDEOGRAPH
    {0x9163, 0x6176}, //3076 #CJK UNIFIED IDEOGRAPH
    {0x9164, 0x6178}, //3077 #CJK UNIFIED IDEOGRAPH
    {0x9165, 0x6179}, //3078 #CJK UNIFIED IDEOGRAPH
    {0x9166, 0x617A}, //3079 #CJK UNIFIED IDEOGRAPH
    {0x9167, 0x617B}, //3080 #CJK UNIFIED IDEOGRAPH
    {0x9168, 0x617C}, //3081 #CJK UNIFIED IDEOGRAPH
    {0x9169, 0x617D}, //3082 #CJK UNIFIED IDEOGRAPH
    {0x916A, 0x617E}, //3083 #CJK UNIFIED IDEOGRAPH
    {0x916B, 0x617F}, //3084 #CJK UNIFIED IDEOGRAPH
    {0x916C, 0x6180}, //3085 #CJK UNIFIED IDEOGRAPH
    {0x916D, 0x6181}, //3086 #CJK UNIFIED IDEOGRAPH
    {0x916E, 0x6182}, //3087 #CJK UNIFIED IDEOGRAPH
    {0x916F, 0x6183}, //3088 #CJK UNIFIED IDEOGRAPH
    {0x9170, 0x6184}, //3089 #CJK UNIFIED IDEOGRAPH
    {0x9171, 0x6185}, //3090 #CJK UNIFIED IDEOGRAPH
    {0x9172, 0x6186}, //3091 #CJK UNIFIED IDEOGRAPH
    {0x9173, 0x6187}, //3092 #CJK UNIFIED IDEOGRAPH
    {0x9174, 0x6188}, //3093 #CJK UNIFIED IDEOGRAPH
    {0x9175, 0x6189}, //3094 #CJK UNIFIED IDEOGRAPH
    {0x9176, 0x618A}, //3095 #CJK UNIFIED IDEOGRAPH
    {0x9177, 0x618C}, //3096 #CJK UNIFIED IDEOGRAPH
    {0x9178, 0x618D}, //3097 #CJK UNIFIED IDEOGRAPH
    {0x9179, 0x618F}, //3098 #CJK UNIFIED IDEOGRAPH
    {0x917A, 0x6190}, //3099 #CJK UNIFIED IDEOGRAPH
    {0x917B, 0x6191}, //3100 #CJK UNIFIED IDEOGRAPH
    {0x917C, 0x6192}, //3101 #CJK UNIFIED IDEOGRAPH
    {0x917D, 0x6193}, //3102 #CJK UNIFIED IDEOGRAPH
    {0x917E, 0x6195}, //3103 #CJK UNIFIED IDEOGRAPH
    {0x9180, 0x6196}, //3104 #CJK UNIFIED IDEOGRAPH
    {0x9181, 0x6197}, //3105 #CJK UNIFIED IDEOGRAPH
    {0x9182, 0x6198}, //3106 #CJK UNIFIED IDEOGRAPH
    {0x9183, 0x6199}, //3107 #CJK UNIFIED IDEOGRAPH
    {0x9184, 0x619A}, //3108 #CJK UNIFIED IDEOGRAPH
    {0x9185, 0x619B}, //3109 #CJK UNIFIED IDEOGRAPH
    {0x9186, 0x619C}, //3110 #CJK UNIFIED IDEOGRAPH
    {0x9187, 0x619E}, //3111 #CJK UNIFIED IDEOGRAPH
    {0x9188, 0x619F}, //3112 #CJK UNIFIED IDEOGRAPH
    {0x9189, 0x61A0}, //3113 #CJK UNIFIED IDEOGRAPH
    {0x918A, 0x61A1}, //3114 #CJK UNIFIED IDEOGRAPH
    {0x918B, 0x61A2}, //3115 #CJK UNIFIED IDEOGRAPH
    {0x918C, 0x61A3}, //3116 #CJK UNIFIED IDEOGRAPH
    {0x918D, 0x61A4}, //3117 #CJK UNIFIED IDEOGRAPH
    {0x918E, 0x61A5}, //3118 #CJK UNIFIED IDEOGRAPH
    {0x918F, 0x61A6}, //3119 #CJK UNIFIED IDEOGRAPH
    {0x9190, 0x61AA}, //3120 #CJK UNIFIED IDEOGRAPH
    {0x9191, 0x61AB}, //3121 #CJK UNIFIED IDEOGRAPH
    {0x9192, 0x61AD}, //3122 #CJK UNIFIED IDEOGRAPH
    {0x9193, 0x61AE}, //3123 #CJK UNIFIED IDEOGRAPH
    {0x9194, 0x61AF}, //3124 #CJK UNIFIED IDEOGRAPH
    {0x9195, 0x61B0}, //3125 #CJK UNIFIED IDEOGRAPH
    {0x9196, 0x61B1}, //3126 #CJK UNIFIED IDEOGRAPH
    {0x9197, 0x61B2}, //3127 #CJK UNIFIED IDEOGRAPH
    {0x9198, 0x61B3}, //3128 #CJK UNIFIED IDEOGRAPH
    {0x9199, 0x61B4}, //3129 #CJK UNIFIED IDEOGRAPH
    {0x919A, 0x61B5}, //3130 #CJK UNIFIED IDEOGRAPH
    {0x919B, 0x61B6}, //3131 #CJK UNIFIED IDEOGRAPH
    {0x919C, 0x61B8}, //3132 #CJK UNIFIED IDEOGRAPH
    {0x919D, 0x61B9}, //3133 #CJK UNIFIED IDEOGRAPH
    {0x919E, 0x61BA}, //3134 #CJK UNIFIED IDEOGRAPH
    {0x919F, 0x61BB}, //3135 #CJK UNIFIED IDEOGRAPH
    {0x91A0, 0x61BC}, //3136 #CJK UNIFIED IDEOGRAPH
    {0x91A1, 0x61BD}, //3137 #CJK UNIFIED IDEOGRAPH
    {0x91A2, 0x61BF}, //3138 #CJK UNIFIED IDEOGRAPH
    {0x91A3, 0x61C0}, //3139 #CJK UNIFIED IDEOGRAPH
    {0x91A4, 0x61C1}, //3140 #CJK UNIFIED IDEOGRAPH
    {0x91A5, 0x61C3}, //3141 #CJK UNIFIED IDEOGRAPH
    {0x91A6, 0x61C4}, //3142 #CJK UNIFIED IDEOGRAPH
    {0x91A7, 0x61C5}, //3143 #CJK UNIFIED IDEOGRAPH
    {0x91A8, 0x61C6}, //3144 #CJK UNIFIED IDEOGRAPH
    {0x91A9, 0x61C7}, //3145 #CJK UNIFIED IDEOGRAPH
    {0x91AA, 0x61C9}, //3146 #CJK UNIFIED IDEOGRAPH
    {0x91AB, 0x61CC}, //3147 #CJK UNIFIED IDEOGRAPH
    {0x91AC, 0x61CD}, //3148 #CJK UNIFIED IDEOGRAPH
    {0x91AD, 0x61CE}, //3149 #CJK UNIFIED IDEOGRAPH
    {0x91AE, 0x61CF}, //3150 #CJK UNIFIED IDEOGRAPH
    {0x91AF, 0x61D0}, //3151 #CJK UNIFIED IDEOGRAPH
    {0x91B0, 0x61D3}, //3152 #CJK UNIFIED IDEOGRAPH
    {0x91B1, 0x61D5}, //3153 #CJK UNIFIED IDEOGRAPH
    {0x91B2, 0x61D6}, //3154 #CJK UNIFIED IDEOGRAPH
    {0x91B3, 0x61D7}, //3155 #CJK UNIFIED IDEOGRAPH
    {0x91B4, 0x61D8}, //3156 #CJK UNIFIED IDEOGRAPH
    {0x91B5, 0x61D9}, //3157 #CJK UNIFIED IDEOGRAPH
    {0x91B6, 0x61DA}, //3158 #CJK UNIFIED IDEOGRAPH
    {0x91B7, 0x61DB}, //3159 #CJK UNIFIED IDEOGRAPH
    {0x91B8, 0x61DC}, //3160 #CJK UNIFIED IDEOGRAPH
    {0x91B9, 0x61DD}, //3161 #CJK UNIFIED IDEOGRAPH
    {0x91BA, 0x61DE}, //3162 #CJK UNIFIED IDEOGRAPH
    {0x91BB, 0x61DF}, //3163 #CJK UNIFIED IDEOGRAPH
    {0x91BC, 0x61E0}, //3164 #CJK UNIFIED IDEOGRAPH
    {0x91BD, 0x61E1}, //3165 #CJK UNIFIED IDEOGRAPH
    {0x91BE, 0x61E2}, //3166 #CJK UNIFIED IDEOGRAPH
    {0x91BF, 0x61E3}, //3167 #CJK UNIFIED IDEOGRAPH
    {0x91C0, 0x61E4}, //3168 #CJK UNIFIED IDEOGRAPH
    {0x91C1, 0x61E5}, //3169 #CJK UNIFIED IDEOGRAPH
    {0x91C2, 0x61E7}, //3170 #CJK UNIFIED IDEOGRAPH
    {0x91C3, 0x61E8}, //3171 #CJK UNIFIED IDEOGRAPH
    {0x91C4, 0x61E9}, //3172 #CJK UNIFIED IDEOGRAPH
    {0x91C5, 0x61EA}, //3173 #CJK UNIFIED IDEOGRAPH
    {0x91C6, 0x61EB}, //3174 #CJK UNIFIED IDEOGRAPH
    {0x91C7, 0x61EC}, //3175 #CJK UNIFIED IDEOGRAPH
    {0x91C8, 0x61ED}, //3176 #CJK UNIFIED IDEOGRAPH
    {0x91C9, 0x61EE}, //3177 #CJK UNIFIED IDEOGRAPH
    {0x91CA, 0x61EF}, //3178 #CJK UNIFIED IDEOGRAPH
    {0x91CB, 0x61F0}, //3179 #CJK UNIFIED IDEOGRAPH
    {0x91CC, 0x61F1}, //3180 #CJK UNIFIED IDEOGRAPH
    {0x91CD, 0x61F2}, //3181 #CJK UNIFIED IDEOGRAPH
    {0x91CE, 0x61F3}, //3182 #CJK UNIFIED IDEOGRAPH
    {0x91CF, 0x61F4}, //3183 #CJK UNIFIED IDEOGRAPH
    {0x91D0, 0x61F6}, //3184 #CJK UNIFIED IDEOGRAPH
    {0x91D1, 0x61F7}, //3185 #CJK UNIFIED IDEOGRAPH
    {0x91D2, 0x61F8}, //3186 #CJK UNIFIED IDEOGRAPH
    {0x91D3, 0x61F9}, //3187 #CJK UNIFIED IDEOGRAPH
    {0x91D4, 0x61FA}, //3188 #CJK UNIFIED IDEOGRAPH
    {0x91D5, 0x61FB}, //3189 #CJK UNIFIED IDEOGRAPH
    {0x91D6, 0x61FC}, //3190 #CJK UNIFIED IDEOGRAPH
    {0x91D7, 0x61FD}, //3191 #CJK UNIFIED IDEOGRAPH
    {0x91D8, 0x61FE}, //3192 #CJK UNIFIED IDEOGRAPH
    {0x91D9, 0x6200}, //3193 #CJK UNIFIED IDEOGRAPH
    {0x91DA, 0x6201}, //3194 #CJK UNIFIED IDEOGRAPH
    {0x91DB, 0x6202}, //3195 #CJK UNIFIED IDEOGRAPH
    {0x91DC, 0x6203}, //3196 #CJK UNIFIED IDEOGRAPH
    {0x91DD, 0x6204}, //3197 #CJK UNIFIED IDEOGRAPH
    {0x91DE, 0x6205}, //3198 #CJK UNIFIED IDEOGRAPH
    {0x91DF, 0x6207}, //3199 #CJK UNIFIED IDEOGRAPH
    {0x91E0, 0x6209}, //3200 #CJK UNIFIED IDEOGRAPH
    {0x91E1, 0x6213}, //3201 #CJK UNIFIED IDEOGRAPH
    {0x91E2, 0x6214}, //3202 #CJK UNIFIED IDEOGRAPH
    {0x91E3, 0x6219}, //3203 #CJK UNIFIED IDEOGRAPH
    {0x91E4, 0x621C}, //3204 #CJK UNIFIED IDEOGRAPH
    {0x91E5, 0x621D}, //3205 #CJK UNIFIED IDEOGRAPH
    {0x91E6, 0x621E}, //3206 #CJK UNIFIED IDEOGRAPH
    {0x91E7, 0x6220}, //3207 #CJK UNIFIED IDEOGRAPH
    {0x91E8, 0x6223}, //3208 #CJK UNIFIED IDEOGRAPH
    {0x91E9, 0x6226}, //3209 #CJK UNIFIED IDEOGRAPH
    {0x91EA, 0x6227}, //3210 #CJK UNIFIED IDEOGRAPH
    {0x91EB, 0x6228}, //3211 #CJK UNIFIED IDEOGRAPH
    {0x91EC, 0x6229}, //3212 #CJK UNIFIED IDEOGRAPH
    {0x91ED, 0x622B}, //3213 #CJK UNIFIED IDEOGRAPH
    {0x91EE, 0x622D}, //3214 #CJK UNIFIED IDEOGRAPH
    {0x91EF, 0x622F}, //3215 #CJK UNIFIED IDEOGRAPH
    {0x91F0, 0x6230}, //3216 #CJK UNIFIED IDEOGRAPH
    {0x91F1, 0x6231}, //3217 #CJK UNIFIED IDEOGRAPH
    {0x91F2, 0x6232}, //3218 #CJK UNIFIED IDEOGRAPH
    {0x91F3, 0x6235}, //3219 #CJK UNIFIED IDEOGRAPH
    {0x91F4, 0x6236}, //3220 #CJK UNIFIED IDEOGRAPH
    {0x91F5, 0x6238}, //3221 #CJK UNIFIED IDEOGRAPH
    {0x91F6, 0x6239}, //3222 #CJK UNIFIED IDEOGRAPH
    {0x91F7, 0x623A}, //3223 #CJK UNIFIED IDEOGRAPH
    {0x91F8, 0x623B}, //3224 #CJK UNIFIED IDEOGRAPH
    {0x91F9, 0x623C}, //3225 #CJK UNIFIED IDEOGRAPH
    {0x91FA, 0x6242}, //3226 #CJK UNIFIED IDEOGRAPH
    {0x91FB, 0x6244}, //3227 #CJK UNIFIED IDEOGRAPH
    {0x91FC, 0x6245}, //3228 #CJK UNIFIED IDEOGRAPH
    {0x91FD, 0x6246}, //3229 #CJK UNIFIED IDEOGRAPH
    {0x91FE, 0x624A}, //3230 #CJK UNIFIED IDEOGRAPH
    {0x9240, 0x624F}, //3231 #CJK UNIFIED IDEOGRAPH
    {0x9241, 0x6250}, //3232 #CJK UNIFIED IDEOGRAPH
    {0x9242, 0x6255}, //3233 #CJK UNIFIED IDEOGRAPH
    {0x9243, 0x6256}, //3234 #CJK UNIFIED IDEOGRAPH
    {0x9244, 0x6257}, //3235 #CJK UNIFIED IDEOGRAPH
    {0x9245, 0x6259}, //3236 #CJK UNIFIED IDEOGRAPH
    {0x9246, 0x625A}, //3237 #CJK UNIFIED IDEOGRAPH
    {0x9247, 0x625C}, //3238 #CJK UNIFIED IDEOGRAPH
    {0x9248, 0x625D}, //3239 #CJK UNIFIED IDEOGRAPH
    {0x9249, 0x625E}, //3240 #CJK UNIFIED IDEOGRAPH
    {0x924A, 0x625F}, //3241 #CJK UNIFIED IDEOGRAPH
    {0x924B, 0x6260}, //3242 #CJK UNIFIED IDEOGRAPH
    {0x924C, 0x6261}, //3243 #CJK UNIFIED IDEOGRAPH
    {0x924D, 0x6262}, //3244 #CJK UNIFIED IDEOGRAPH
    {0x924E, 0x6264}, //3245 #CJK UNIFIED IDEOGRAPH
    {0x924F, 0x6265}, //3246 #CJK UNIFIED IDEOGRAPH
    {0x9250, 0x6268}, //3247 #CJK UNIFIED IDEOGRAPH
    {0x9251, 0x6271}, //3248 #CJK UNIFIED IDEOGRAPH
    {0x9252, 0x6272}, //3249 #CJK UNIFIED IDEOGRAPH
    {0x9253, 0x6274}, //3250 #CJK UNIFIED IDEOGRAPH
    {0x9254, 0x6275}, //3251 #CJK UNIFIED IDEOGRAPH
    {0x9255, 0x6277}, //3252 #CJK UNIFIED IDEOGRAPH
    {0x9256, 0x6278}, //3253 #CJK UNIFIED IDEOGRAPH
    {0x9257, 0x627A}, //3254 #CJK UNIFIED IDEOGRAPH
    {0x9258, 0x627B}, //3255 #CJK UNIFIED IDEOGRAPH
    {0x9259, 0x627D}, //3256 #CJK UNIFIED IDEOGRAPH
    {0x925A, 0x6281}, //3257 #CJK UNIFIED IDEOGRAPH
    {0x925B, 0x6282}, //3258 #CJK UNIFIED IDEOGRAPH
    {0x925C, 0x6283}, //3259 #CJK UNIFIED IDEOGRAPH
    {0x925D, 0x6285}, //3260 #CJK UNIFIED IDEOGRAPH
    {0x925E, 0x6286}, //3261 #CJK UNIFIED IDEOGRAPH
    {0x925F, 0x6287}, //3262 #CJK UNIFIED IDEOGRAPH
    {0x9260, 0x6288}, //3263 #CJK UNIFIED IDEOGRAPH
    {0x9261, 0x628B}, //3264 #CJK UNIFIED IDEOGRAPH
    {0x9262, 0x628C}, //3265 #CJK UNIFIED IDEOGRAPH
    {0x9263, 0x628D}, //3266 #CJK UNIFIED IDEOGRAPH
    {0x9264, 0x628E}, //3267 #CJK UNIFIED IDEOGRAPH
    {0x9265, 0x628F}, //3268 #CJK UNIFIED IDEOGRAPH
    {0x9266, 0x6290}, //3269 #CJK UNIFIED IDEOGRAPH
    {0x9267, 0x6294}, //3270 #CJK UNIFIED IDEOGRAPH
    {0x9268, 0x6299}, //3271 #CJK UNIFIED IDEOGRAPH
    {0x9269, 0x629C}, //3272 #CJK UNIFIED IDEOGRAPH
    {0x926A, 0x629D}, //3273 #CJK UNIFIED IDEOGRAPH
    {0x926B, 0x629E}, //3274 #CJK UNIFIED IDEOGRAPH
    {0x926C, 0x62A3}, //3275 #CJK UNIFIED IDEOGRAPH
    {0x926D, 0x62A6}, //3276 #CJK UNIFIED IDEOGRAPH
    {0x926E, 0x62A7}, //3277 #CJK UNIFIED IDEOGRAPH
    {0x926F, 0x62A9}, //3278 #CJK UNIFIED IDEOGRAPH
    {0x9270, 0x62AA}, //3279 #CJK UNIFIED IDEOGRAPH
    {0x9271, 0x62AD}, //3280 #CJK UNIFIED IDEOGRAPH
    {0x9272, 0x62AE}, //3281 #CJK UNIFIED IDEOGRAPH
    {0x9273, 0x62AF}, //3282 #CJK UNIFIED IDEOGRAPH
    {0x9274, 0x62B0}, //3283 #CJK UNIFIED IDEOGRAPH
    {0x9275, 0x62B2}, //3284 #CJK UNIFIED IDEOGRAPH
    {0x9276, 0x62B3}, //3285 #CJK UNIFIED IDEOGRAPH
    {0x9277, 0x62B4}, //3286 #CJK UNIFIED IDEOGRAPH
    {0x9278, 0x62B6}, //3287 #CJK UNIFIED IDEOGRAPH
    {0x9279, 0x62B7}, //3288 #CJK UNIFIED IDEOGRAPH
    {0x927A, 0x62B8}, //3289 #CJK UNIFIED IDEOGRAPH
    {0x927B, 0x62BA}, //3290 #CJK UNIFIED IDEOGRAPH
    {0x927C, 0x62BE}, //3291 #CJK UNIFIED IDEOGRAPH
    {0x927D, 0x62C0}, //3292 #CJK UNIFIED IDEOGRAPH
    {0x927E, 0x62C1}, //3293 #CJK UNIFIED IDEOGRAPH
    {0x9280, 0x62C3}, //3294 #CJK UNIFIED IDEOGRAPH
    {0x9281, 0x62CB}, //3295 #CJK UNIFIED IDEOGRAPH
    {0x9282, 0x62CF}, //3296 #CJK UNIFIED IDEOGRAPH
    {0x9283, 0x62D1}, //3297 #CJK UNIFIED IDEOGRAPH
    {0x9284, 0x62D5}, //3298 #CJK UNIFIED IDEOGRAPH
    {0x9285, 0x62DD}, //3299 #CJK UNIFIED IDEOGRAPH
    {0x9286, 0x62DE}, //3300 #CJK UNIFIED IDEOGRAPH
    {0x9287, 0x62E0}, //3301 #CJK UNIFIED IDEOGRAPH
    {0x9288, 0x62E1}, //3302 #CJK UNIFIED IDEOGRAPH
    {0x9289, 0x62E4}, //3303 #CJK UNIFIED IDEOGRAPH
    {0x928A, 0x62EA}, //3304 #CJK UNIFIED IDEOGRAPH
    {0x928B, 0x62EB}, //3305 #CJK UNIFIED IDEOGRAPH
    {0x928C, 0x62F0}, //3306 #CJK UNIFIED IDEOGRAPH
    {0x928D, 0x62F2}, //3307 #CJK UNIFIED IDEOGRAPH
    {0x928E, 0x62F5}, //3308 #CJK UNIFIED IDEOGRAPH
    {0x928F, 0x62F8}, //3309 #CJK UNIFIED IDEOGRAPH
    {0x9290, 0x62F9}, //3310 #CJK UNIFIED IDEOGRAPH
    {0x9291, 0x62FA}, //3311 #CJK UNIFIED IDEOGRAPH
    {0x9292, 0x62FB}, //3312 #CJK UNIFIED IDEOGRAPH
    {0x9293, 0x6300}, //3313 #CJK UNIFIED IDEOGRAPH
    {0x9294, 0x6303}, //3314 #CJK UNIFIED IDEOGRAPH
    {0x9295, 0x6304}, //3315 #CJK UNIFIED IDEOGRAPH
    {0x9296, 0x6305}, //3316 #CJK UNIFIED IDEOGRAPH
    {0x9297, 0x6306}, //3317 #CJK UNIFIED IDEOGRAPH
    {0x9298, 0x630A}, //3318 #CJK UNIFIED IDEOGRAPH
    {0x9299, 0x630B}, //3319 #CJK UNIFIED IDEOGRAPH
    {0x929A, 0x630C}, //3320 #CJK UNIFIED IDEOGRAPH
    {0x929B, 0x630D}, //3321 #CJK UNIFIED IDEOGRAPH
    {0x929C, 0x630F}, //3322 #CJK UNIFIED IDEOGRAPH
    {0x929D, 0x6310}, //3323 #CJK UNIFIED IDEOGRAPH
    {0x929E, 0x6312}, //3324 #CJK UNIFIED IDEOGRAPH
    {0x929F, 0x6313}, //3325 #CJK UNIFIED IDEOGRAPH
    {0x92A0, 0x6314}, //3326 #CJK UNIFIED IDEOGRAPH
    {0x92A1, 0x6315}, //3327 #CJK UNIFIED IDEOGRAPH
    {0x92A2, 0x6317}, //3328 #CJK UNIFIED IDEOGRAPH
    {0x92A3, 0x6318}, //3329 #CJK UNIFIED IDEOGRAPH
    {0x92A4, 0x6319}, //3330 #CJK UNIFIED IDEOGRAPH
    {0x92A5, 0x631C}, //3331 #CJK UNIFIED IDEOGRAPH
    {0x92A6, 0x6326}, //3332 #CJK UNIFIED IDEOGRAPH
    {0x92A7, 0x6327}, //3333 #CJK UNIFIED IDEOGRAPH
    {0x92A8, 0x6329}, //3334 #CJK UNIFIED IDEOGRAPH
    {0x92A9, 0x632C}, //3335 #CJK UNIFIED IDEOGRAPH
    {0x92AA, 0x632D}, //3336 #CJK UNIFIED IDEOGRAPH
    {0x92AB, 0x632E}, //3337 #CJK UNIFIED IDEOGRAPH
    {0x92AC, 0x6330}, //3338 #CJK UNIFIED IDEOGRAPH
    {0x92AD, 0x6331}, //3339 #CJK UNIFIED IDEOGRAPH
    {0x92AE, 0x6333}, //3340 #CJK UNIFIED IDEOGRAPH
    {0x92AF, 0x6334}, //3341 #CJK UNIFIED IDEOGRAPH
    {0x92B0, 0x6335}, //3342 #CJK UNIFIED IDEOGRAPH
    {0x92B1, 0x6336}, //3343 #CJK UNIFIED IDEOGRAPH
    {0x92B2, 0x6337}, //3344 #CJK UNIFIED IDEOGRAPH
    {0x92B3, 0x6338}, //3345 #CJK UNIFIED IDEOGRAPH
    {0x92B4, 0x633B}, //3346 #CJK UNIFIED IDEOGRAPH
    {0x92B5, 0x633C}, //3347 #CJK UNIFIED IDEOGRAPH
    {0x92B6, 0x633E}, //3348 #CJK UNIFIED IDEOGRAPH
    {0x92B7, 0x633F}, //3349 #CJK UNIFIED IDEOGRAPH
    {0x92B8, 0x6340}, //3350 #CJK UNIFIED IDEOGRAPH
    {0x92B9, 0x6341}, //3351 #CJK UNIFIED IDEOGRAPH
    {0x92BA, 0x6344}, //3352 #CJK UNIFIED IDEOGRAPH
    {0x92BB, 0x6347}, //3353 #CJK UNIFIED IDEOGRAPH
    {0x92BC, 0x6348}, //3354 #CJK UNIFIED IDEOGRAPH
    {0x92BD, 0x634A}, //3355 #CJK UNIFIED IDEOGRAPH
    {0x92BE, 0x6351}, //3356 #CJK UNIFIED IDEOGRAPH
    {0x92BF, 0x6352}, //3357 #CJK UNIFIED IDEOGRAPH
    {0x92C0, 0x6353}, //3358 #CJK UNIFIED IDEOGRAPH
    {0x92C1, 0x6354}, //3359 #CJK UNIFIED IDEOGRAPH
    {0x92C2, 0x6356}, //3360 #CJK UNIFIED IDEOGRAPH
    {0x92C3, 0x6357}, //3361 #CJK UNIFIED IDEOGRAPH
    {0x92C4, 0x6358}, //3362 #CJK UNIFIED IDEOGRAPH
    {0x92C5, 0x6359}, //3363 #CJK UNIFIED IDEOGRAPH
    {0x92C6, 0x635A}, //3364 #CJK UNIFIED IDEOGRAPH
    {0x92C7, 0x635B}, //3365 #CJK UNIFIED IDEOGRAPH
    {0x92C8, 0x635C}, //3366 #CJK UNIFIED IDEOGRAPH
    {0x92C9, 0x635D}, //3367 #CJK UNIFIED IDEOGRAPH
    {0x92CA, 0x6360}, //3368 #CJK UNIFIED IDEOGRAPH
    {0x92CB, 0x6364}, //3369 #CJK UNIFIED IDEOGRAPH
    {0x92CC, 0x6365}, //3370 #CJK UNIFIED IDEOGRAPH
    {0x92CD, 0x6366}, //3371 #CJK UNIFIED IDEOGRAPH
    {0x92CE, 0x6368}, //3372 #CJK UNIFIED IDEOGRAPH
    {0x92CF, 0x636A}, //3373 #CJK UNIFIED IDEOGRAPH
    {0x92D0, 0x636B}, //3374 #CJK UNIFIED IDEOGRAPH
    {0x92D1, 0x636C}, //3375 #CJK UNIFIED IDEOGRAPH
    {0x92D2, 0x636F}, //3376 #CJK UNIFIED IDEOGRAPH
    {0x92D3, 0x6370}, //3377 #CJK UNIFIED IDEOGRAPH
    {0x92D4, 0x6372}, //3378 #CJK UNIFIED IDEOGRAPH
    {0x92D5, 0x6373}, //3379 #CJK UNIFIED IDEOGRAPH
    {0x92D6, 0x6374}, //3380 #CJK UNIFIED IDEOGRAPH
    {0x92D7, 0x6375}, //3381 #CJK UNIFIED IDEOGRAPH
    {0x92D8, 0x6378}, //3382 #CJK UNIFIED IDEOGRAPH
    {0x92D9, 0x6379}, //3383 #CJK UNIFIED IDEOGRAPH
    {0x92DA, 0x637C}, //3384 #CJK UNIFIED IDEOGRAPH
    {0x92DB, 0x637D}, //3385 #CJK UNIFIED IDEOGRAPH
    {0x92DC, 0x637E}, //3386 #CJK UNIFIED IDEOGRAPH
    {0x92DD, 0x637F}, //3387 #CJK UNIFIED IDEOGRAPH
    {0x92DE, 0x6381}, //3388 #CJK UNIFIED IDEOGRAPH
    {0x92DF, 0x6383}, //3389 #CJK UNIFIED IDEOGRAPH
    {0x92E0, 0x6384}, //3390 #CJK UNIFIED IDEOGRAPH
    {0x92E1, 0x6385}, //3391 #CJK UNIFIED IDEOGRAPH
    {0x92E2, 0x6386}, //3392 #CJK UNIFIED IDEOGRAPH
    {0x92E3, 0x638B}, //3393 #CJK UNIFIED IDEOGRAPH
    {0x92E4, 0x638D}, //3394 #CJK UNIFIED IDEOGRAPH
    {0x92E5, 0x6391}, //3395 #CJK UNIFIED IDEOGRAPH
    {0x92E6, 0x6393}, //3396 #CJK UNIFIED IDEOGRAPH
    {0x92E7, 0x6394}, //3397 #CJK UNIFIED IDEOGRAPH
    {0x92E8, 0x6395}, //3398 #CJK UNIFIED IDEOGRAPH
    {0x92E9, 0x6397}, //3399 #CJK UNIFIED IDEOGRAPH
    {0x92EA, 0x6399}, //3400 #CJK UNIFIED IDEOGRAPH
    {0x92EB, 0x639A}, //3401 #CJK UNIFIED IDEOGRAPH
    {0x92EC, 0x639B}, //3402 #CJK UNIFIED IDEOGRAPH
    {0x92ED, 0x639C}, //3403 #CJK UNIFIED IDEOGRAPH
    {0x92EE, 0x639D}, //3404 #CJK UNIFIED IDEOGRAPH
    {0x92EF, 0x639E}, //3405 #CJK UNIFIED IDEOGRAPH
    {0x92F0, 0x639F}, //3406 #CJK UNIFIED IDEOGRAPH
    {0x92F1, 0x63A1}, //3407 #CJK UNIFIED IDEOGRAPH
    {0x92F2, 0x63A4}, //3408 #CJK UNIFIED IDEOGRAPH
    {0x92F3, 0x63A6}, //3409 #CJK UNIFIED IDEOGRAPH
    {0x92F4, 0x63AB}, //3410 #CJK UNIFIED IDEOGRAPH
    {0x92F5, 0x63AF}, //3411 #CJK UNIFIED IDEOGRAPH
    {0x92F6, 0x63B1}, //3412 #CJK UNIFIED IDEOGRAPH
    {0x92F7, 0x63B2}, //3413 #CJK UNIFIED IDEOGRAPH
    {0x92F8, 0x63B5}, //3414 #CJK UNIFIED IDEOGRAPH
    {0x92F9, 0x63B6}, //3415 #CJK UNIFIED IDEOGRAPH
    {0x92FA, 0x63B9}, //3416 #CJK UNIFIED IDEOGRAPH
    {0x92FB, 0x63BB}, //3417 #CJK UNIFIED IDEOGRAPH
    {0x92FC, 0x63BD}, //3418 #CJK UNIFIED IDEOGRAPH
    {0x92FD, 0x63BF}, //3419 #CJK UNIFIED IDEOGRAPH
    {0x92FE, 0x63C0}, //3420 #CJK UNIFIED IDEOGRAPH
    {0x9340, 0x63C1}, //3421 #CJK UNIFIED IDEOGRAPH
    {0x9341, 0x63C2}, //3422 #CJK UNIFIED IDEOGRAPH
    {0x9342, 0x63C3}, //3423 #CJK UNIFIED IDEOGRAPH
    {0x9343, 0x63C5}, //3424 #CJK UNIFIED IDEOGRAPH
    {0x9344, 0x63C7}, //3425 #CJK UNIFIED IDEOGRAPH
    {0x9345, 0x63C8}, //3426 #CJK UNIFIED IDEOGRAPH
    {0x9346, 0x63CA}, //3427 #CJK UNIFIED IDEOGRAPH
    {0x9347, 0x63CB}, //3428 #CJK UNIFIED IDEOGRAPH
    {0x9348, 0x63CC}, //3429 #CJK UNIFIED IDEOGRAPH
    {0x9349, 0x63D1}, //3430 #CJK UNIFIED IDEOGRAPH
    {0x934A, 0x63D3}, //3431 #CJK UNIFIED IDEOGRAPH
    {0x934B, 0x63D4}, //3432 #CJK UNIFIED IDEOGRAPH
    {0x934C, 0x63D5}, //3433 #CJK UNIFIED IDEOGRAPH
    {0x934D, 0x63D7}, //3434 #CJK UNIFIED IDEOGRAPH
    {0x934E, 0x63D8}, //3435 #CJK UNIFIED IDEOGRAPH
    {0x934F, 0x63D9}, //3436 #CJK UNIFIED IDEOGRAPH
    {0x9350, 0x63DA}, //3437 #CJK UNIFIED IDEOGRAPH
    {0x9351, 0x63DB}, //3438 #CJK UNIFIED IDEOGRAPH
    {0x9352, 0x63DC}, //3439 #CJK UNIFIED IDEOGRAPH
    {0x9353, 0x63DD}, //3440 #CJK UNIFIED IDEOGRAPH
    {0x9354, 0x63DF}, //3441 #CJK UNIFIED IDEOGRAPH
    {0x9355, 0x63E2}, //3442 #CJK UNIFIED IDEOGRAPH
    {0x9356, 0x63E4}, //3443 #CJK UNIFIED IDEOGRAPH
    {0x9357, 0x63E5}, //3444 #CJK UNIFIED IDEOGRAPH
    {0x9358, 0x63E6}, //3445 #CJK UNIFIED IDEOGRAPH
    {0x9359, 0x63E7}, //3446 #CJK UNIFIED IDEOGRAPH
    {0x935A, 0x63E8}, //3447 #CJK UNIFIED IDEOGRAPH
    {0x935B, 0x63EB}, //3448 #CJK UNIFIED IDEOGRAPH
    {0x935C, 0x63EC}, //3449 #CJK UNIFIED IDEOGRAPH
    {0x935D, 0x63EE}, //3450 #CJK UNIFIED IDEOGRAPH
    {0x935E, 0x63EF}, //3451 #CJK UNIFIED IDEOGRAPH
    {0x935F, 0x63F0}, //3452 #CJK UNIFIED IDEOGRAPH
    {0x9360, 0x63F1}, //3453 #CJK UNIFIED IDEOGRAPH
    {0x9361, 0x63F3}, //3454 #CJK UNIFIED IDEOGRAPH
    {0x9362, 0x63F5}, //3455 #CJK UNIFIED IDEOGRAPH
    {0x9363, 0x63F7}, //3456 #CJK UNIFIED IDEOGRAPH
    {0x9364, 0x63F9}, //3457 #CJK UNIFIED IDEOGRAPH
    {0x9365, 0x63FA}, //3458 #CJK UNIFIED IDEOGRAPH
    {0x9366, 0x63FB}, //3459 #CJK UNIFIED IDEOGRAPH
    {0x9367, 0x63FC}, //3460 #CJK UNIFIED IDEOGRAPH
    {0x9368, 0x63FE}, //3461 #CJK UNIFIED IDEOGRAPH
    {0x9369, 0x6403}, //3462 #CJK UNIFIED IDEOGRAPH
    {0x936A, 0x6404}, //3463 #CJK UNIFIED IDEOGRAPH
    {0x936B, 0x6406}, //3464 #CJK UNIFIED IDEOGRAPH
    {0x936C, 0x6407}, //3465 #CJK UNIFIED IDEOGRAPH
    {0x936D, 0x6408}, //3466 #CJK UNIFIED IDEOGRAPH
    {0x936E, 0x6409}, //3467 #CJK UNIFIED IDEOGRAPH
    {0x936F, 0x640A}, //3468 #CJK UNIFIED IDEOGRAPH
    {0x9370, 0x640D}, //3469 #CJK UNIFIED IDEOGRAPH
    {0x9371, 0x640E}, //3470 #CJK UNIFIED IDEOGRAPH
    {0x9372, 0x6411}, //3471 #CJK UNIFIED IDEOGRAPH
    {0x9373, 0x6412}, //3472 #CJK UNIFIED IDEOGRAPH
    {0x9374, 0x6415}, //3473 #CJK UNIFIED IDEOGRAPH
    {0x9375, 0x6416}, //3474 #CJK UNIFIED IDEOGRAPH
    {0x9376, 0x6417}, //3475 #CJK UNIFIED IDEOGRAPH
    {0x9377, 0x6418}, //3476 #CJK UNIFIED IDEOGRAPH
    {0x9378, 0x6419}, //3477 #CJK UNIFIED IDEOGRAPH
    {0x9379, 0x641A}, //3478 #CJK UNIFIED IDEOGRAPH
    {0x937A, 0x641D}, //3479 #CJK UNIFIED IDEOGRAPH
    {0x937B, 0x641F}, //3480 #CJK UNIFIED IDEOGRAPH
    {0x937C, 0x6422}, //3481 #CJK UNIFIED IDEOGRAPH
    {0x937D, 0x6423}, //3482 #CJK UNIFIED IDEOGRAPH
    {0x937E, 0x6424}, //3483 #CJK UNIFIED IDEOGRAPH
    {0x9380, 0x6425}, //3484 #CJK UNIFIED IDEOGRAPH
    {0x9381, 0x6427}, //3485 #CJK UNIFIED IDEOGRAPH
    {0x9382, 0x6428}, //3486 #CJK UNIFIED IDEOGRAPH
    {0x9383, 0x6429}, //3487 #CJK UNIFIED IDEOGRAPH
    {0x9384, 0x642B}, //3488 #CJK UNIFIED IDEOGRAPH
    {0x9385, 0x642E}, //3489 #CJK UNIFIED IDEOGRAPH
    {0x9386, 0x642F}, //3490 #CJK UNIFIED IDEOGRAPH
    {0x9387, 0x6430}, //3491 #CJK UNIFIED IDEOGRAPH
    {0x9388, 0x6431}, //3492 #CJK UNIFIED IDEOGRAPH
    {0x9389, 0x6432}, //3493 #CJK UNIFIED IDEOGRAPH
    {0x938A, 0x6433}, //3494 #CJK UNIFIED IDEOGRAPH
    {0x938B, 0x6435}, //3495 #CJK UNIFIED IDEOGRAPH
    {0x938C, 0x6436}, //3496 #CJK UNIFIED IDEOGRAPH
    {0x938D, 0x6437}, //3497 #CJK UNIFIED IDEOGRAPH
    {0x938E, 0x6438}, //3498 #CJK UNIFIED IDEOGRAPH
    {0x938F, 0x6439}, //3499 #CJK UNIFIED IDEOGRAPH
    {0x9390, 0x643B}, //3500 #CJK UNIFIED IDEOGRAPH
    {0x9391, 0x643C}, //3501 #CJK UNIFIED IDEOGRAPH
    {0x9392, 0x643E}, //3502 #CJK UNIFIED IDEOGRAPH
    {0x9393, 0x6440}, //3503 #CJK UNIFIED IDEOGRAPH
    {0x9394, 0x6442}, //3504 #CJK UNIFIED IDEOGRAPH
    {0x9395, 0x6443}, //3505 #CJK UNIFIED IDEOGRAPH
    {0x9396, 0x6449}, //3506 #CJK UNIFIED IDEOGRAPH
    {0x9397, 0x644B}, //3507 #CJK UNIFIED IDEOGRAPH
    {0x9398, 0x644C}, //3508 #CJK UNIFIED IDEOGRAPH
    {0x9399, 0x644D}, //3509 #CJK UNIFIED IDEOGRAPH
    {0x939A, 0x644E}, //3510 #CJK UNIFIED IDEOGRAPH
    {0x939B, 0x644F}, //3511 #CJK UNIFIED IDEOGRAPH
    {0x939C, 0x6450}, //3512 #CJK UNIFIED IDEOGRAPH
    {0x939D, 0x6451}, //3513 #CJK UNIFIED IDEOGRAPH
    {0x939E, 0x6453}, //3514 #CJK UNIFIED IDEOGRAPH
    {0x939F, 0x6455}, //3515 #CJK UNIFIED IDEOGRAPH
    {0x93A0, 0x6456}, //3516 #CJK UNIFIED IDEOGRAPH
    {0x93A1, 0x6457}, //3517 #CJK UNIFIED IDEOGRAPH
    {0x93A2, 0x6459}, //3518 #CJK UNIFIED IDEOGRAPH
    {0x93A3, 0x645A}, //3519 #CJK UNIFIED IDEOGRAPH
    {0x93A4, 0x645B}, //3520 #CJK UNIFIED IDEOGRAPH
    {0x93A5, 0x645C}, //3521 #CJK UNIFIED IDEOGRAPH
    {0x93A6, 0x645D}, //3522 #CJK UNIFIED IDEOGRAPH
    {0x93A7, 0x645F}, //3523 #CJK UNIFIED IDEOGRAPH
    {0x93A8, 0x6460}, //3524 #CJK UNIFIED IDEOGRAPH
    {0x93A9, 0x6461}, //3525 #CJK UNIFIED IDEOGRAPH
    {0x93AA, 0x6462}, //3526 #CJK UNIFIED IDEOGRAPH
    {0x93AB, 0x6463}, //3527 #CJK UNIFIED IDEOGRAPH
    {0x93AC, 0x6464}, //3528 #CJK UNIFIED IDEOGRAPH
    {0x93AD, 0x6465}, //3529 #CJK UNIFIED IDEOGRAPH
    {0x93AE, 0x6466}, //3530 #CJK UNIFIED IDEOGRAPH
    {0x93AF, 0x6468}, //3531 #CJK UNIFIED IDEOGRAPH
    {0x93B0, 0x646A}, //3532 #CJK UNIFIED IDEOGRAPH
    {0x93B1, 0x646B}, //3533 #CJK UNIFIED IDEOGRAPH
    {0x93B2, 0x646C}, //3534 #CJK UNIFIED IDEOGRAPH
    {0x93B3, 0x646E}, //3535 #CJK UNIFIED IDEOGRAPH
    {0x93B4, 0x646F}, //3536 #CJK UNIFIED IDEOGRAPH
    {0x93B5, 0x6470}, //3537 #CJK UNIFIED IDEOGRAPH
    {0x93B6, 0x6471}, //3538 #CJK UNIFIED IDEOGRAPH
    {0x93B7, 0x6472}, //3539 #CJK UNIFIED IDEOGRAPH
    {0x93B8, 0x6473}, //3540 #CJK UNIFIED IDEOGRAPH
    {0x93B9, 0x6474}, //3541 #CJK UNIFIED IDEOGRAPH
    {0x93BA, 0x6475}, //3542 #CJK UNIFIED IDEOGRAPH
    {0x93BB, 0x6476}, //3543 #CJK UNIFIED IDEOGRAPH
    {0x93BC, 0x6477}, //3544 #CJK UNIFIED IDEOGRAPH
    {0x93BD, 0x647B}, //3545 #CJK UNIFIED IDEOGRAPH
    {0x93BE, 0x647C}, //3546 #CJK UNIFIED IDEOGRAPH
    {0x93BF, 0x647D}, //3547 #CJK UNIFIED IDEOGRAPH
    {0x93C0, 0x647E}, //3548 #CJK UNIFIED IDEOGRAPH
    {0x93C1, 0x647F}, //3549 #CJK UNIFIED IDEOGRAPH
    {0x93C2, 0x6480}, //3550 #CJK UNIFIED IDEOGRAPH
    {0x93C3, 0x6481}, //3551 #CJK UNIFIED IDEOGRAPH
    {0x93C4, 0x6483}, //3552 #CJK UNIFIED IDEOGRAPH
    {0x93C5, 0x6486}, //3553 #CJK UNIFIED IDEOGRAPH
    {0x93C6, 0x6488}, //3554 #CJK UNIFIED IDEOGRAPH
    {0x93C7, 0x6489}, //3555 #CJK UNIFIED IDEOGRAPH
    {0x93C8, 0x648A}, //3556 #CJK UNIFIED IDEOGRAPH
    {0x93C9, 0x648B}, //3557 #CJK UNIFIED IDEOGRAPH
    {0x93CA, 0x648C}, //3558 #CJK UNIFIED IDEOGRAPH
    {0x93CB, 0x648D}, //3559 #CJK UNIFIED IDEOGRAPH
    {0x93CC, 0x648E}, //3560 #CJK UNIFIED IDEOGRAPH
    {0x93CD, 0x648F}, //3561 #CJK UNIFIED IDEOGRAPH
    {0x93CE, 0x6490}, //3562 #CJK UNIFIED IDEOGRAPH
    {0x93CF, 0x6493}, //3563 #CJK UNIFIED IDEOGRAPH
    {0x93D0, 0x6494}, //3564 #CJK UNIFIED IDEOGRAPH
    {0x93D1, 0x6497}, //3565 #CJK UNIFIED IDEOGRAPH
    {0x93D2, 0x6498}, //3566 #CJK UNIFIED IDEOGRAPH
    {0x93D3, 0x649A}, //3567 #CJK UNIFIED IDEOGRAPH
    {0x93D4, 0x649B}, //3568 #CJK UNIFIED IDEOGRAPH
    {0x93D5, 0x649C}, //3569 #CJK UNIFIED IDEOGRAPH
    {0x93D6, 0x649D}, //3570 #CJK UNIFIED IDEOGRAPH
    {0x93D7, 0x649F}, //3571 #CJK UNIFIED IDEOGRAPH
    {0x93D8, 0x64A0}, //3572 #CJK UNIFIED IDEOGRAPH
    {0x93D9, 0x64A1}, //3573 #CJK UNIFIED IDEOGRAPH
    {0x93DA, 0x64A2}, //3574 #CJK UNIFIED IDEOGRAPH
    {0x93DB, 0x64A3}, //3575 #CJK UNIFIED IDEOGRAPH
    {0x93DC, 0x64A5}, //3576 #CJK UNIFIED IDEOGRAPH
    {0x93DD, 0x64A6}, //3577 #CJK UNIFIED IDEOGRAPH
    {0x93DE, 0x64A7}, //3578 #CJK UNIFIED IDEOGRAPH
    {0x93DF, 0x64A8}, //3579 #CJK UNIFIED IDEOGRAPH
    {0x93E0, 0x64AA}, //3580 #CJK UNIFIED IDEOGRAPH
    {0x93E1, 0x64AB}, //3581 #CJK UNIFIED IDEOGRAPH
    {0x93E2, 0x64AF}, //3582 #CJK UNIFIED IDEOGRAPH
    {0x93E3, 0x64B1}, //3583 #CJK UNIFIED IDEOGRAPH
    {0x93E4, 0x64B2}, //3584 #CJK UNIFIED IDEOGRAPH
    {0x93E5, 0x64B3}, //3585 #CJK UNIFIED IDEOGRAPH
    {0x93E6, 0x64B4}, //3586 #CJK UNIFIED IDEOGRAPH
    {0x93E7, 0x64B6}, //3587 #CJK UNIFIED IDEOGRAPH
    {0x93E8, 0x64B9}, //3588 #CJK UNIFIED IDEOGRAPH
    {0x93E9, 0x64BB}, //3589 #CJK UNIFIED IDEOGRAPH
    {0x93EA, 0x64BD}, //3590 #CJK UNIFIED IDEOGRAPH
    {0x93EB, 0x64BE}, //3591 #CJK UNIFIED IDEOGRAPH
    {0x93EC, 0x64BF}, //3592 #CJK UNIFIED IDEOGRAPH
    {0x93ED, 0x64C1}, //3593 #CJK UNIFIED IDEOGRAPH
    {0x93EE, 0x64C3}, //3594 #CJK UNIFIED IDEOGRAPH
    {0x93EF, 0x64C4}, //3595 #CJK UNIFIED IDEOGRAPH
    {0x93F0, 0x64C6}, //3596 #CJK UNIFIED IDEOGRAPH
    {0x93F1, 0x64C7}, //3597 #CJK UNIFIED IDEOGRAPH
    {0x93F2, 0x64C8}, //3598 #CJK UNIFIED IDEOGRAPH
    {0x93F3, 0x64C9}, //3599 #CJK UNIFIED IDEOGRAPH
    {0x93F4, 0x64CA}, //3600 #CJK UNIFIED IDEOGRAPH
    {0x93F5, 0x64CB}, //3601 #CJK UNIFIED IDEOGRAPH
    {0x93F6, 0x64CC}, //3602 #CJK UNIFIED IDEOGRAPH
    {0x93F7, 0x64CF}, //3603 #CJK UNIFIED IDEOGRAPH
    {0x93F8, 0x64D1}, //3604 #CJK UNIFIED IDEOGRAPH
    {0x93F9, 0x64D3}, //3605 #CJK UNIFIED IDEOGRAPH
    {0x93FA, 0x64D4}, //3606 #CJK UNIFIED IDEOGRAPH
    {0x93FB, 0x64D5}, //3607 #CJK UNIFIED IDEOGRAPH
    {0x93FC, 0x64D6}, //3608 #CJK UNIFIED IDEOGRAPH
    {0x93FD, 0x64D9}, //3609 #CJK UNIFIED IDEOGRAPH
    {0x93FE, 0x64DA}, //3610 #CJK UNIFIED IDEOGRAPH
    {0x9440, 0x64DB}, //3611 #CJK UNIFIED IDEOGRAPH
    {0x9441, 0x64DC}, //3612 #CJK UNIFIED IDEOGRAPH
    {0x9442, 0x64DD}, //3613 #CJK UNIFIED IDEOGRAPH
    {0x9443, 0x64DF}, //3614 #CJK UNIFIED IDEOGRAPH
    {0x9444, 0x64E0}, //3615 #CJK UNIFIED IDEOGRAPH
    {0x9445, 0x64E1}, //3616 #CJK UNIFIED IDEOGRAPH
    {0x9446, 0x64E3}, //3617 #CJK UNIFIED IDEOGRAPH
    {0x9447, 0x64E5}, //3618 #CJK UNIFIED IDEOGRAPH
    {0x9448, 0x64E7}, //3619 #CJK UNIFIED IDEOGRAPH
    {0x9449, 0x64E8}, //3620 #CJK UNIFIED IDEOGRAPH
    {0x944A, 0x64E9}, //3621 #CJK UNIFIED IDEOGRAPH
    {0x944B, 0x64EA}, //3622 #CJK UNIFIED IDEOGRAPH
    {0x944C, 0x64EB}, //3623 #CJK UNIFIED IDEOGRAPH
    {0x944D, 0x64EC}, //3624 #CJK UNIFIED IDEOGRAPH
    {0x944E, 0x64ED}, //3625 #CJK UNIFIED IDEOGRAPH
    {0x944F, 0x64EE}, //3626 #CJK UNIFIED IDEOGRAPH
    {0x9450, 0x64EF}, //3627 #CJK UNIFIED IDEOGRAPH
    {0x9451, 0x64F0}, //3628 #CJK UNIFIED IDEOGRAPH
    {0x9452, 0x64F1}, //3629 #CJK UNIFIED IDEOGRAPH
    {0x9453, 0x64F2}, //3630 #CJK UNIFIED IDEOGRAPH
    {0x9454, 0x64F3}, //3631 #CJK UNIFIED IDEOGRAPH
    {0x9455, 0x64F4}, //3632 #CJK UNIFIED IDEOGRAPH
    {0x9456, 0x64F5}, //3633 #CJK UNIFIED IDEOGRAPH
    {0x9457, 0x64F6}, //3634 #CJK UNIFIED IDEOGRAPH
    {0x9458, 0x64F7}, //3635 #CJK UNIFIED IDEOGRAPH
    {0x9459, 0x64F8}, //3636 #CJK UNIFIED IDEOGRAPH
    {0x945A, 0x64F9}, //3637 #CJK UNIFIED IDEOGRAPH
    {0x945B, 0x64FA}, //3638 #CJK UNIFIED IDEOGRAPH
    {0x945C, 0x64FB}, //3639 #CJK UNIFIED IDEOGRAPH
    {0x945D, 0x64FC}, //3640 #CJK UNIFIED IDEOGRAPH
    {0x945E, 0x64FD}, //3641 #CJK UNIFIED IDEOGRAPH
    {0x945F, 0x64FE}, //3642 #CJK UNIFIED IDEOGRAPH
    {0x9460, 0x64FF}, //3643 #CJK UNIFIED IDEOGRAPH
    {0x9461, 0x6501}, //3644 #CJK UNIFIED IDEOGRAPH
    {0x9462, 0x6502}, //3645 #CJK UNIFIED IDEOGRAPH
    {0x9463, 0x6503}, //3646 #CJK UNIFIED IDEOGRAPH
    {0x9464, 0x6504}, //3647 #CJK UNIFIED IDEOGRAPH
    {0x9465, 0x6505}, //3648 #CJK UNIFIED IDEOGRAPH
    {0x9466, 0x6506}, //3649 #CJK UNIFIED IDEOGRAPH
    {0x9467, 0x6507}, //3650 #CJK UNIFIED IDEOGRAPH
    {0x9468, 0x6508}, //3651 #CJK UNIFIED IDEOGRAPH
    {0x9469, 0x650A}, //3652 #CJK UNIFIED IDEOGRAPH
    {0x946A, 0x650B}, //3653 #CJK UNIFIED IDEOGRAPH
    {0x946B, 0x650C}, //3654 #CJK UNIFIED IDEOGRAPH
    {0x946C, 0x650D}, //3655 #CJK UNIFIED IDEOGRAPH
    {0x946D, 0x650E}, //3656 #CJK UNIFIED IDEOGRAPH
    {0x946E, 0x650F}, //3657 #CJK UNIFIED IDEOGRAPH
    {0x946F, 0x6510}, //3658 #CJK UNIFIED IDEOGRAPH
    {0x9470, 0x6511}, //3659 #CJK UNIFIED IDEOGRAPH
    {0x9471, 0x6513}, //3660 #CJK UNIFIED IDEOGRAPH
    {0x9472, 0x6514}, //3661 #CJK UNIFIED IDEOGRAPH
    {0x9473, 0x6515}, //3662 #CJK UNIFIED IDEOGRAPH
    {0x9474, 0x6516}, //3663 #CJK UNIFIED IDEOGRAPH
    {0x9475, 0x6517}, //3664 #CJK UNIFIED IDEOGRAPH
    {0x9476, 0x6519}, //3665 #CJK UNIFIED IDEOGRAPH
    {0x9477, 0x651A}, //3666 #CJK UNIFIED IDEOGRAPH
    {0x9478, 0x651B}, //3667 #CJK UNIFIED IDEOGRAPH
    {0x9479, 0x651C}, //3668 #CJK UNIFIED IDEOGRAPH
    {0x947A, 0x651D}, //3669 #CJK UNIFIED IDEOGRAPH
    {0x947B, 0x651E}, //3670 #CJK UNIFIED IDEOGRAPH
    {0x947C, 0x651F}, //3671 #CJK UNIFIED IDEOGRAPH
    {0x947D, 0x6520}, //3672 #CJK UNIFIED IDEOGRAPH
    {0x947E, 0x6521}, //3673 #CJK UNIFIED IDEOGRAPH
    {0x9480, 0x6522}, //3674 #CJK UNIFIED IDEOGRAPH
    {0x9481, 0x6523}, //3675 #CJK UNIFIED IDEOGRAPH
    {0x9482, 0x6524}, //3676 #CJK UNIFIED IDEOGRAPH
    {0x9483, 0x6526}, //3677 #CJK UNIFIED IDEOGRAPH
    {0x9484, 0x6527}, //3678 #CJK UNIFIED IDEOGRAPH
    {0x9485, 0x6528}, //3679 #CJK UNIFIED IDEOGRAPH
    {0x9486, 0x6529}, //3680 #CJK UNIFIED IDEOGRAPH
    {0x9487, 0x652A}, //3681 #CJK UNIFIED IDEOGRAPH
    {0x9488, 0x652C}, //3682 #CJK UNIFIED IDEOGRAPH
    {0x9489, 0x652D}, //3683 #CJK UNIFIED IDEOGRAPH
    {0x948A, 0x6530}, //3684 #CJK UNIFIED IDEOGRAPH
    {0x948B, 0x6531}, //3685 #CJK UNIFIED IDEOGRAPH
    {0x948C, 0x6532}, //3686 #CJK UNIFIED IDEOGRAPH
    {0x948D, 0x6533}, //3687 #CJK UNIFIED IDEOGRAPH
    {0x948E, 0x6537}, //3688 #CJK UNIFIED IDEOGRAPH
    {0x948F, 0x653A}, //3689 #CJK UNIFIED IDEOGRAPH
    {0x9490, 0x653C}, //3690 #CJK UNIFIED IDEOGRAPH
    {0x9491, 0x653D}, //3691 #CJK UNIFIED IDEOGRAPH
    {0x9492, 0x6540}, //3692 #CJK UNIFIED IDEOGRAPH
    {0x9493, 0x6541}, //3693 #CJK UNIFIED IDEOGRAPH
    {0x9494, 0x6542}, //3694 #CJK UNIFIED IDEOGRAPH
    {0x9495, 0x6543}, //3695 #CJK UNIFIED IDEOGRAPH
    {0x9496, 0x6544}, //3696 #CJK UNIFIED IDEOGRAPH
    {0x9497, 0x6546}, //3697 #CJK UNIFIED IDEOGRAPH
    {0x9498, 0x6547}, //3698 #CJK UNIFIED IDEOGRAPH
    {0x9499, 0x654A}, //3699 #CJK UNIFIED IDEOGRAPH
    {0x949A, 0x654B}, //3700 #CJK UNIFIED IDEOGRAPH
    {0x949B, 0x654D}, //3701 #CJK UNIFIED IDEOGRAPH
    {0x949C, 0x654E}, //3702 #CJK UNIFIED IDEOGRAPH
    {0x949D, 0x6550}, //3703 #CJK UNIFIED IDEOGRAPH
    {0x949E, 0x6552}, //3704 #CJK UNIFIED IDEOGRAPH
    {0x949F, 0x6553}, //3705 #CJK UNIFIED IDEOGRAPH
    {0x94A0, 0x6554}, //3706 #CJK UNIFIED IDEOGRAPH
    {0x94A1, 0x6557}, //3707 #CJK UNIFIED IDEOGRAPH
    {0x94A2, 0x6558}, //3708 #CJK UNIFIED IDEOGRAPH
    {0x94A3, 0x655A}, //3709 #CJK UNIFIED IDEOGRAPH
    {0x94A4, 0x655C}, //3710 #CJK UNIFIED IDEOGRAPH
    {0x94A5, 0x655F}, //3711 #CJK UNIFIED IDEOGRAPH
    {0x94A6, 0x6560}, //3712 #CJK UNIFIED IDEOGRAPH
    {0x94A7, 0x6561}, //3713 #CJK UNIFIED IDEOGRAPH
    {0x94A8, 0x6564}, //3714 #CJK UNIFIED IDEOGRAPH
    {0x94A9, 0x6565}, //3715 #CJK UNIFIED IDEOGRAPH
    {0x94AA, 0x6567}, //3716 #CJK UNIFIED IDEOGRAPH
    {0x94AB, 0x6568}, //3717 #CJK UNIFIED IDEOGRAPH
    {0x94AC, 0x6569}, //3718 #CJK UNIFIED IDEOGRAPH
    {0x94AD, 0x656A}, //3719 #CJK UNIFIED IDEOGRAPH
    {0x94AE, 0x656D}, //3720 #CJK UNIFIED IDEOGRAPH
    {0x94AF, 0x656E}, //3721 #CJK UNIFIED IDEOGRAPH
    {0x94B0, 0x656F}, //3722 #CJK UNIFIED IDEOGRAPH
    {0x94B1, 0x6571}, //3723 #CJK UNIFIED IDEOGRAPH
    {0x94B2, 0x6573}, //3724 #CJK UNIFIED IDEOGRAPH
    {0x94B3, 0x6575}, //3725 #CJK UNIFIED IDEOGRAPH
    {0x94B4, 0x6576}, //3726 #CJK UNIFIED IDEOGRAPH
    {0x94B5, 0x6578}, //3727 #CJK UNIFIED IDEOGRAPH
    {0x94B6, 0x6579}, //3728 #CJK UNIFIED IDEOGRAPH
    {0x94B7, 0x657A}, //3729 #CJK UNIFIED IDEOGRAPH
    {0x94B8, 0x657B}, //3730 #CJK UNIFIED IDEOGRAPH
    {0x94B9, 0x657C}, //3731 #CJK UNIFIED IDEOGRAPH
    {0x94BA, 0x657D}, //3732 #CJK UNIFIED IDEOGRAPH
    {0x94BB, 0x657E}, //3733 #CJK UNIFIED IDEOGRAPH
    {0x94BC, 0x657F}, //3734 #CJK UNIFIED IDEOGRAPH
    {0x94BD, 0x6580}, //3735 #CJK UNIFIED IDEOGRAPH
    {0x94BE, 0x6581}, //3736 #CJK UNIFIED IDEOGRAPH
    {0x94BF, 0x6582}, //3737 #CJK UNIFIED IDEOGRAPH
    {0x94C0, 0x6583}, //3738 #CJK UNIFIED IDEOGRAPH
    {0x94C1, 0x6584}, //3739 #CJK UNIFIED IDEOGRAPH
    {0x94C2, 0x6585}, //3740 #CJK UNIFIED IDEOGRAPH
    {0x94C3, 0x6586}, //3741 #CJK UNIFIED IDEOGRAPH
    {0x94C4, 0x6588}, //3742 #CJK UNIFIED IDEOGRAPH
    {0x94C5, 0x6589}, //3743 #CJK UNIFIED IDEOGRAPH
    {0x94C6, 0x658A}, //3744 #CJK UNIFIED IDEOGRAPH
    {0x94C7, 0x658D}, //3745 #CJK UNIFIED IDEOGRAPH
    {0x94C8, 0x658E}, //3746 #CJK UNIFIED IDEOGRAPH
    {0x94C9, 0x658F}, //3747 #CJK UNIFIED IDEOGRAPH
    {0x94CA, 0x6592}, //3748 #CJK UNIFIED IDEOGRAPH
    {0x94CB, 0x6594}, //3749 #CJK UNIFIED IDEOGRAPH
    {0x94CC, 0x6595}, //3750 #CJK UNIFIED IDEOGRAPH
    {0x94CD, 0x6596}, //3751 #CJK UNIFIED IDEOGRAPH
    {0x94CE, 0x6598}, //3752 #CJK UNIFIED IDEOGRAPH
    {0x94CF, 0x659A}, //3753 #CJK UNIFIED IDEOGRAPH
    {0x94D0, 0x659D}, //3754 #CJK UNIFIED IDEOGRAPH
    {0x94D1, 0x659E}, //3755 #CJK UNIFIED IDEOGRAPH
    {0x94D2, 0x65A0}, //3756 #CJK UNIFIED IDEOGRAPH
    {0x94D3, 0x65A2}, //3757 #CJK UNIFIED IDEOGRAPH
    {0x94D4, 0x65A3}, //3758 #CJK UNIFIED IDEOGRAPH
    {0x94D5, 0x65A6}, //3759 #CJK UNIFIED IDEOGRAPH
    {0x94D6, 0x65A8}, //3760 #CJK UNIFIED IDEOGRAPH
    {0x94D7, 0x65AA}, //3761 #CJK UNIFIED IDEOGRAPH
    {0x94D8, 0x65AC}, //3762 #CJK UNIFIED IDEOGRAPH
    {0x94D9, 0x65AE}, //3763 #CJK UNIFIED IDEOGRAPH
    {0x94DA, 0x65B1}, //3764 #CJK UNIFIED IDEOGRAPH
    {0x94DB, 0x65B2}, //3765 #CJK UNIFIED IDEOGRAPH
    {0x94DC, 0x65B3}, //3766 #CJK UNIFIED IDEOGRAPH
    {0x94DD, 0x65B4}, //3767 #CJK UNIFIED IDEOGRAPH
    {0x94DE, 0x65B5}, //3768 #CJK UNIFIED IDEOGRAPH
    {0x94DF, 0x65B6}, //3769 #CJK UNIFIED IDEOGRAPH
    {0x94E0, 0x65B7}, //3770 #CJK UNIFIED IDEOGRAPH
    {0x94E1, 0x65B8}, //3771 #CJK UNIFIED IDEOGRAPH
    {0x94E2, 0x65BA}, //3772 #CJK UNIFIED IDEOGRAPH
    {0x94E3, 0x65BB}, //3773 #CJK UNIFIED IDEOGRAPH
    {0x94E4, 0x65BE}, //3774 #CJK UNIFIED IDEOGRAPH
    {0x94E5, 0x65BF}, //3775 #CJK UNIFIED IDEOGRAPH
    {0x94E6, 0x65C0}, //3776 #CJK UNIFIED IDEOGRAPH
    {0x94E7, 0x65C2}, //3777 #CJK UNIFIED IDEOGRAPH
    {0x94E8, 0x65C7}, //3778 #CJK UNIFIED IDEOGRAPH
    {0x94E9, 0x65C8}, //3779 #CJK UNIFIED IDEOGRAPH
    {0x94EA, 0x65C9}, //3780 #CJK UNIFIED IDEOGRAPH
    {0x94EB, 0x65CA}, //3781 #CJK UNIFIED IDEOGRAPH
    {0x94EC, 0x65CD}, //3782 #CJK UNIFIED IDEOGRAPH
    {0x94ED, 0x65D0}, //3783 #CJK UNIFIED IDEOGRAPH
    {0x94EE, 0x65D1}, //3784 #CJK UNIFIED IDEOGRAPH
    {0x94EF, 0x65D3}, //3785 #CJK UNIFIED IDEOGRAPH
    {0x94F0, 0x65D4}, //3786 #CJK UNIFIED IDEOGRAPH
    {0x94F1, 0x65D5}, //3787 #CJK UNIFIED IDEOGRAPH
    {0x94F2, 0x65D8}, //3788 #CJK UNIFIED IDEOGRAPH
    {0x94F3, 0x65D9}, //3789 #CJK UNIFIED IDEOGRAPH
    {0x94F4, 0x65DA}, //3790 #CJK UNIFIED IDEOGRAPH
    {0x94F5, 0x65DB}, //3791 #CJK UNIFIED IDEOGRAPH
    {0x94F6, 0x65DC}, //3792 #CJK UNIFIED IDEOGRAPH
    {0x94F7, 0x65DD}, //3793 #CJK UNIFIED IDEOGRAPH
    {0x94F8, 0x65DE}, //3794 #CJK UNIFIED IDEOGRAPH
    {0x94F9, 0x65DF}, //3795 #CJK UNIFIED IDEOGRAPH
    {0x94FA, 0x65E1}, //3796 #CJK UNIFIED IDEOGRAPH
    {0x94FB, 0x65E3}, //3797 #CJK UNIFIED IDEOGRAPH
    {0x94FC, 0x65E4}, //3798 #CJK UNIFIED IDEOGRAPH
    {0x94FD, 0x65EA}, //3799 #CJK UNIFIED IDEOGRAPH
    {0x94FE, 0x65EB}, //3800 #CJK UNIFIED IDEOGRAPH
    {0x9540, 0x65F2}, //3801 #CJK UNIFIED IDEOGRAPH
    {0x9541, 0x65F3}, //3802 #CJK UNIFIED IDEOGRAPH
    {0x9542, 0x65F4}, //3803 #CJK UNIFIED IDEOGRAPH
    {0x9543, 0x65F5}, //3804 #CJK UNIFIED IDEOGRAPH
    {0x9544, 0x65F8}, //3805 #CJK UNIFIED IDEOGRAPH
    {0x9545, 0x65F9}, //3806 #CJK UNIFIED IDEOGRAPH
    {0x9546, 0x65FB}, //3807 #CJK UNIFIED IDEOGRAPH
    {0x9547, 0x65FC}, //3808 #CJK UNIFIED IDEOGRAPH
    {0x9548, 0x65FD}, //3809 #CJK UNIFIED IDEOGRAPH
    {0x9549, 0x65FE}, //3810 #CJK UNIFIED IDEOGRAPH
    {0x954A, 0x65FF}, //3811 #CJK UNIFIED IDEOGRAPH
    {0x954B, 0x6601}, //3812 #CJK UNIFIED IDEOGRAPH
    {0x954C, 0x6604}, //3813 #CJK UNIFIED IDEOGRAPH
    {0x954D, 0x6605}, //3814 #CJK UNIFIED IDEOGRAPH
    {0x954E, 0x6607}, //3815 #CJK UNIFIED IDEOGRAPH
    {0x954F, 0x6608}, //3816 #CJK UNIFIED IDEOGRAPH
    {0x9550, 0x6609}, //3817 #CJK UNIFIED IDEOGRAPH
    {0x9551, 0x660B}, //3818 #CJK UNIFIED IDEOGRAPH
    {0x9552, 0x660D}, //3819 #CJK UNIFIED IDEOGRAPH
    {0x9553, 0x6610}, //3820 #CJK UNIFIED IDEOGRAPH
    {0x9554, 0x6611}, //3821 #CJK UNIFIED IDEOGRAPH
    {0x9555, 0x6612}, //3822 #CJK UNIFIED IDEOGRAPH
    {0x9556, 0x6616}, //3823 #CJK UNIFIED IDEOGRAPH
    {0x9557, 0x6617}, //3824 #CJK UNIFIED IDEOGRAPH
    {0x9558, 0x6618}, //3825 #CJK UNIFIED IDEOGRAPH
    {0x9559, 0x661A}, //3826 #CJK UNIFIED IDEOGRAPH
    {0x955A, 0x661B}, //3827 #CJK UNIFIED IDEOGRAPH
    {0x955B, 0x661C}, //3828 #CJK UNIFIED IDEOGRAPH
    {0x955C, 0x661E}, //3829 #CJK UNIFIED IDEOGRAPH
    {0x955D, 0x6621}, //3830 #CJK UNIFIED IDEOGRAPH
    {0x955E, 0x6622}, //3831 #CJK UNIFIED IDEOGRAPH
    {0x955F, 0x6623}, //3832 #CJK UNIFIED IDEOGRAPH
    {0x9560, 0x6624}, //3833 #CJK UNIFIED IDEOGRAPH
    {0x9561, 0x6626}, //3834 #CJK UNIFIED IDEOGRAPH
    {0x9562, 0x6629}, //3835 #CJK UNIFIED IDEOGRAPH
    {0x9563, 0x662A}, //3836 #CJK UNIFIED IDEOGRAPH
    {0x9564, 0x662B}, //3837 #CJK UNIFIED IDEOGRAPH
    {0x9565, 0x662C}, //3838 #CJK UNIFIED IDEOGRAPH
    {0x9566, 0x662E}, //3839 #CJK UNIFIED IDEOGRAPH
    {0x9567, 0x6630}, //3840 #CJK UNIFIED IDEOGRAPH
    {0x9568, 0x6632}, //3841 #CJK UNIFIED IDEOGRAPH
    {0x9569, 0x6633}, //3842 #CJK UNIFIED IDEOGRAPH
    {0x956A, 0x6637}, //3843 #CJK UNIFIED IDEOGRAPH
    {0x956B, 0x6638}, //3844 #CJK UNIFIED IDEOGRAPH
    {0x956C, 0x6639}, //3845 #CJK UNIFIED IDEOGRAPH
    {0x956D, 0x663A}, //3846 #CJK UNIFIED IDEOGRAPH
    {0x956E, 0x663B}, //3847 #CJK UNIFIED IDEOGRAPH
    {0x956F, 0x663D}, //3848 #CJK UNIFIED IDEOGRAPH
    {0x9570, 0x663F}, //3849 #CJK UNIFIED IDEOGRAPH
    {0x9571, 0x6640}, //3850 #CJK UNIFIED IDEOGRAPH
    {0x9572, 0x6642}, //3851 #CJK UNIFIED IDEOGRAPH
    {0x9573, 0x6644}, //3852 #CJK UNIFIED IDEOGRAPH
    {0x9574, 0x6645}, //3853 #CJK UNIFIED IDEOGRAPH
    {0x9575, 0x6646}, //3854 #CJK UNIFIED IDEOGRAPH
    {0x9576, 0x6647}, //3855 #CJK UNIFIED IDEOGRAPH
    {0x9577, 0x6648}, //3856 #CJK UNIFIED IDEOGRAPH
    {0x9578, 0x6649}, //3857 #CJK UNIFIED IDEOGRAPH
    {0x9579, 0x664A}, //3858 #CJK UNIFIED IDEOGRAPH
    {0x957A, 0x664D}, //3859 #CJK UNIFIED IDEOGRAPH
    {0x957B, 0x664E}, //3860 #CJK UNIFIED IDEOGRAPH
    {0x957C, 0x6650}, //3861 #CJK UNIFIED IDEOGRAPH
    {0x957D, 0x6651}, //3862 #CJK UNIFIED IDEOGRAPH
    {0x957E, 0x6658}, //3863 #CJK UNIFIED IDEOGRAPH
    {0x9580, 0x6659}, //3864 #CJK UNIFIED IDEOGRAPH
    {0x9581, 0x665B}, //3865 #CJK UNIFIED IDEOGRAPH
    {0x9582, 0x665C}, //3866 #CJK UNIFIED IDEOGRAPH
    {0x9583, 0x665D}, //3867 #CJK UNIFIED IDEOGRAPH
    {0x9584, 0x665E}, //3868 #CJK UNIFIED IDEOGRAPH
    {0x9585, 0x6660}, //3869 #CJK UNIFIED IDEOGRAPH
    {0x9586, 0x6662}, //3870 #CJK UNIFIED IDEOGRAPH
    {0x9587, 0x6663}, //3871 #CJK UNIFIED IDEOGRAPH
    {0x9588, 0x6665}, //3872 #CJK UNIFIED IDEOGRAPH
    {0x9589, 0x6667}, //3873 #CJK UNIFIED IDEOGRAPH
    {0x958A, 0x6669}, //3874 #CJK UNIFIED IDEOGRAPH
    {0x958B, 0x666A}, //3875 #CJK UNIFIED IDEOGRAPH
    {0x958C, 0x666B}, //3876 #CJK UNIFIED IDEOGRAPH
    {0x958D, 0x666C}, //3877 #CJK UNIFIED IDEOGRAPH
    {0x958E, 0x666D}, //3878 #CJK UNIFIED IDEOGRAPH
    {0x958F, 0x6671}, //3879 #CJK UNIFIED IDEOGRAPH
    {0x9590, 0x6672}, //3880 #CJK UNIFIED IDEOGRAPH
    {0x9591, 0x6673}, //3881 #CJK UNIFIED IDEOGRAPH
    {0x9592, 0x6675}, //3882 #CJK UNIFIED IDEOGRAPH
    {0x9593, 0x6678}, //3883 #CJK UNIFIED IDEOGRAPH
    {0x9594, 0x6679}, //3884 #CJK UNIFIED IDEOGRAPH
    {0x9595, 0x667B}, //3885 #CJK UNIFIED IDEOGRAPH
    {0x9596, 0x667C}, //3886 #CJK UNIFIED IDEOGRAPH
    {0x9597, 0x667D}, //3887 #CJK UNIFIED IDEOGRAPH
    {0x9598, 0x667F}, //3888 #CJK UNIFIED IDEOGRAPH
    {0x9599, 0x6680}, //3889 #CJK UNIFIED IDEOGRAPH
    {0x959A, 0x6681}, //3890 #CJK UNIFIED IDEOGRAPH
    {0x959B, 0x6683}, //3891 #CJK UNIFIED IDEOGRAPH
    {0x959C, 0x6685}, //3892 #CJK UNIFIED IDEOGRAPH
    {0x959D, 0x6686}, //3893 #CJK UNIFIED IDEOGRAPH
    {0x959E, 0x6688}, //3894 #CJK UNIFIED IDEOGRAPH
    {0x959F, 0x6689}, //3895 #CJK UNIFIED IDEOGRAPH
    {0x95A0, 0x668A}, //3896 #CJK UNIFIED IDEOGRAPH
    {0x95A1, 0x668B}, //3897 #CJK UNIFIED IDEOGRAPH
    {0x95A2, 0x668D}, //3898 #CJK UNIFIED IDEOGRAPH
    {0x95A3, 0x668E}, //3899 #CJK UNIFIED IDEOGRAPH
    {0x95A4, 0x668F}, //3900 #CJK UNIFIED IDEOGRAPH
    {0x95A5, 0x6690}, //3901 #CJK UNIFIED IDEOGRAPH
    {0x95A6, 0x6692}, //3902 #CJK UNIFIED IDEOGRAPH
    {0x95A7, 0x6693}, //3903 #CJK UNIFIED IDEOGRAPH
    {0x95A8, 0x6694}, //3904 #CJK UNIFIED IDEOGRAPH
    {0x95A9, 0x6695}, //3905 #CJK UNIFIED IDEOGRAPH
    {0x95AA, 0x6698}, //3906 #CJK UNIFIED IDEOGRAPH
    {0x95AB, 0x6699}, //3907 #CJK UNIFIED IDEOGRAPH
    {0x95AC, 0x669A}, //3908 #CJK UNIFIED IDEOGRAPH
    {0x95AD, 0x669B}, //3909 #CJK UNIFIED IDEOGRAPH
    {0x95AE, 0x669C}, //3910 #CJK UNIFIED IDEOGRAPH
    {0x95AF, 0x669E}, //3911 #CJK UNIFIED IDEOGRAPH
    {0x95B0, 0x669F}, //3912 #CJK UNIFIED IDEOGRAPH
    {0x95B1, 0x66A0}, //3913 #CJK UNIFIED IDEOGRAPH
    {0x95B2, 0x66A1}, //3914 #CJK UNIFIED IDEOGRAPH
    {0x95B3, 0x66A2}, //3915 #CJK UNIFIED IDEOGRAPH
    {0x95B4, 0x66A3}, //3916 #CJK UNIFIED IDEOGRAPH
    {0x95B5, 0x66A4}, //3917 #CJK UNIFIED IDEOGRAPH
    {0x95B6, 0x66A5}, //3918 #CJK UNIFIED IDEOGRAPH
    {0x95B7, 0x66A6}, //3919 #CJK UNIFIED IDEOGRAPH
    {0x95B8, 0x66A9}, //3920 #CJK UNIFIED IDEOGRAPH
    {0x95B9, 0x66AA}, //3921 #CJK UNIFIED IDEOGRAPH
    {0x95BA, 0x66AB}, //3922 #CJK UNIFIED IDEOGRAPH
    {0x95BB, 0x66AC}, //3923 #CJK UNIFIED IDEOGRAPH
    {0x95BC, 0x66AD}, //3924 #CJK UNIFIED IDEOGRAPH
    {0x95BD, 0x66AF}, //3925 #CJK UNIFIED IDEOGRAPH
    {0x95BE, 0x66B0}, //3926 #CJK UNIFIED IDEOGRAPH
    {0x95BF, 0x66B1}, //3927 #CJK UNIFIED IDEOGRAPH
    {0x95C0, 0x66B2}, //3928 #CJK UNIFIED IDEOGRAPH
    {0x95C1, 0x66B3}, //3929 #CJK UNIFIED IDEOGRAPH
    {0x95C2, 0x66B5}, //3930 #CJK UNIFIED IDEOGRAPH
    {0x95C3, 0x66B6}, //3931 #CJK UNIFIED IDEOGRAPH
    {0x95C4, 0x66B7}, //3932 #CJK UNIFIED IDEOGRAPH
    {0x95C5, 0x66B8}, //3933 #CJK UNIFIED IDEOGRAPH
    {0x95C6, 0x66BA}, //3934 #CJK UNIFIED IDEOGRAPH
    {0x95C7, 0x66BB}, //3935 #CJK UNIFIED IDEOGRAPH
    {0x95C8, 0x66BC}, //3936 #CJK UNIFIED IDEOGRAPH
    {0x95C9, 0x66BD}, //3937 #CJK UNIFIED IDEOGRAPH
    {0x95CA, 0x66BF}, //3938 #CJK UNIFIED IDEOGRAPH
    {0x95CB, 0x66C0}, //3939 #CJK UNIFIED IDEOGRAPH
    {0x95CC, 0x66C1}, //3940 #CJK UNIFIED IDEOGRAPH
    {0x95CD, 0x66C2}, //3941 #CJK UNIFIED IDEOGRAPH
    {0x95CE, 0x66C3}, //3942 #CJK UNIFIED IDEOGRAPH
    {0x95CF, 0x66C4}, //3943 #CJK UNIFIED IDEOGRAPH
    {0x95D0, 0x66C5}, //3944 #CJK UNIFIED IDEOGRAPH
    {0x95D1, 0x66C6}, //3945 #CJK UNIFIED IDEOGRAPH
    {0x95D2, 0x66C7}, //3946 #CJK UNIFIED IDEOGRAPH
    {0x95D3, 0x66C8}, //3947 #CJK UNIFIED IDEOGRAPH
    {0x95D4, 0x66C9}, //3948 #CJK UNIFIED IDEOGRAPH
    {0x95D5, 0x66CA}, //3949 #CJK UNIFIED IDEOGRAPH
    {0x95D6, 0x66CB}, //3950 #CJK UNIFIED IDEOGRAPH
    {0x95D7, 0x66CC}, //3951 #CJK UNIFIED IDEOGRAPH
    {0x95D8, 0x66CD}, //3952 #CJK UNIFIED IDEOGRAPH
    {0x95D9, 0x66CE}, //3953 #CJK UNIFIED IDEOGRAPH
    {0x95DA, 0x66CF}, //3954 #CJK UNIFIED IDEOGRAPH
    {0x95DB, 0x66D0}, //3955 #CJK UNIFIED IDEOGRAPH
    {0x95DC, 0x66D1}, //3956 #CJK UNIFIED IDEOGRAPH
    {0x95DD, 0x66D2}, //3957 #CJK UNIFIED IDEOGRAPH
    {0x95DE, 0x66D3}, //3958 #CJK UNIFIED IDEOGRAPH
    {0x95DF, 0x66D4}, //3959 #CJK UNIFIED IDEOGRAPH
    {0x95E0, 0x66D5}, //3960 #CJK UNIFIED IDEOGRAPH
    {0x95E1, 0x66D6}, //3961 #CJK UNIFIED IDEOGRAPH
    {0x95E2, 0x66D7}, //3962 #CJK UNIFIED IDEOGRAPH
    {0x95E3, 0x66D8}, //3963 #CJK UNIFIED IDEOGRAPH
    {0x95E4, 0x66DA}, //3964 #CJK UNIFIED IDEOGRAPH
    {0x95E5, 0x66DE}, //3965 #CJK UNIFIED IDEOGRAPH
    {0x95E6, 0x66DF}, //3966 #CJK UNIFIED IDEOGRAPH
    {0x95E7, 0x66E0}, //3967 #CJK UNIFIED IDEOGRAPH
    {0x95E8, 0x66E1}, //3968 #CJK UNIFIED IDEOGRAPH
    {0x95E9, 0x66E2}, //3969 #CJK UNIFIED IDEOGRAPH
    {0x95EA, 0x66E3}, //3970 #CJK UNIFIED IDEOGRAPH
    {0x95EB, 0x66E4}, //3971 #CJK UNIFIED IDEOGRAPH
    {0x95EC, 0x66E5}, //3972 #CJK UNIFIED IDEOGRAPH
    {0x95ED, 0x66E7}, //3973 #CJK UNIFIED IDEOGRAPH
    {0x95EE, 0x66E8}, //3974 #CJK UNIFIED IDEOGRAPH
    {0x95EF, 0x66EA}, //3975 #CJK UNIFIED IDEOGRAPH
    {0x95F0, 0x66EB}, //3976 #CJK UNIFIED IDEOGRAPH
    {0x95F1, 0x66EC}, //3977 #CJK UNIFIED IDEOGRAPH
    {0x95F2, 0x66ED}, //3978 #CJK UNIFIED IDEOGRAPH
    {0x95F3, 0x66EE}, //3979 #CJK UNIFIED IDEOGRAPH
    {0x95F4, 0x66EF}, //3980 #CJK UNIFIED IDEOGRAPH
    {0x95F5, 0x66F1}, //3981 #CJK UNIFIED IDEOGRAPH
    {0x95F6, 0x66F5}, //3982 #CJK UNIFIED IDEOGRAPH
    {0x95F7, 0x66F6}, //3983 #CJK UNIFIED IDEOGRAPH
    {0x95F8, 0x66F8}, //3984 #CJK UNIFIED IDEOGRAPH
    {0x95F9, 0x66FA}, //3985 #CJK UNIFIED IDEOGRAPH
    {0x95FA, 0x66FB}, //3986 #CJK UNIFIED IDEOGRAPH
    {0x95FB, 0x66FD}, //3987 #CJK UNIFIED IDEOGRAPH
    {0x95FC, 0x6701}, //3988 #CJK UNIFIED IDEOGRAPH
    {0x95FD, 0x6702}, //3989 #CJK UNIFIED IDEOGRAPH
    {0x95FE, 0x6703}, //3990 #CJK UNIFIED IDEOGRAPH
    {0x9640, 0x6704}, //3991 #CJK UNIFIED IDEOGRAPH
    {0x9641, 0x6705}, //3992 #CJK UNIFIED IDEOGRAPH
    {0x9642, 0x6706}, //3993 #CJK UNIFIED IDEOGRAPH
    {0x9643, 0x6707}, //3994 #CJK UNIFIED IDEOGRAPH
    {0x9644, 0x670C}, //3995 #CJK UNIFIED IDEOGRAPH
    {0x9645, 0x670E}, //3996 #CJK UNIFIED IDEOGRAPH
    {0x9646, 0x670F}, //3997 #CJK UNIFIED IDEOGRAPH
    {0x9647, 0x6711}, //3998 #CJK UNIFIED IDEOGRAPH
    {0x9648, 0x6712}, //3999 #CJK UNIFIED IDEOGRAPH
    {0x9649, 0x6713}, //4000 #CJK UNIFIED IDEOGRAPH
    {0x964A, 0x6716}, //4001 #CJK UNIFIED IDEOGRAPH
    {0x964B, 0x6718}, //4002 #CJK UNIFIED IDEOGRAPH
    {0x964C, 0x6719}, //4003 #CJK UNIFIED IDEOGRAPH
    {0x964D, 0x671A}, //4004 #CJK UNIFIED IDEOGRAPH
    {0x964E, 0x671C}, //4005 #CJK UNIFIED IDEOGRAPH
    {0x964F, 0x671E}, //4006 #CJK UNIFIED IDEOGRAPH
    {0x9650, 0x6720}, //4007 #CJK UNIFIED IDEOGRAPH
    {0x9651, 0x6721}, //4008 #CJK UNIFIED IDEOGRAPH
    {0x9652, 0x6722}, //4009 #CJK UNIFIED IDEOGRAPH
    {0x9653, 0x6723}, //4010 #CJK UNIFIED IDEOGRAPH
    {0x9654, 0x6724}, //4011 #CJK UNIFIED IDEOGRAPH
    {0x9655, 0x6725}, //4012 #CJK UNIFIED IDEOGRAPH
    {0x9656, 0x6727}, //4013 #CJK UNIFIED IDEOGRAPH
    {0x9657, 0x6729}, //4014 #CJK UNIFIED IDEOGRAPH
    {0x9658, 0x672E}, //4015 #CJK UNIFIED IDEOGRAPH
    {0x9659, 0x6730}, //4016 #CJK UNIFIED IDEOGRAPH
    {0x965A, 0x6732}, //4017 #CJK UNIFIED IDEOGRAPH
    {0x965B, 0x6733}, //4018 #CJK UNIFIED IDEOGRAPH
    {0x965C, 0x6736}, //4019 #CJK UNIFIED IDEOGRAPH
    {0x965D, 0x6737}, //4020 #CJK UNIFIED IDEOGRAPH
    {0x965E, 0x6738}, //4021 #CJK UNIFIED IDEOGRAPH
    {0x965F, 0x6739}, //4022 #CJK UNIFIED IDEOGRAPH
    {0x9660, 0x673B}, //4023 #CJK UNIFIED IDEOGRAPH
    {0x9661, 0x673C}, //4024 #CJK UNIFIED IDEOGRAPH
    {0x9662, 0x673E}, //4025 #CJK UNIFIED IDEOGRAPH
    {0x9663, 0x673F}, //4026 #CJK UNIFIED IDEOGRAPH
    {0x9664, 0x6741}, //4027 #CJK UNIFIED IDEOGRAPH
    {0x9665, 0x6744}, //4028 #CJK UNIFIED IDEOGRAPH
    {0x9666, 0x6745}, //4029 #CJK UNIFIED IDEOGRAPH
    {0x9667, 0x6747}, //4030 #CJK UNIFIED IDEOGRAPH
    {0x9668, 0x674A}, //4031 #CJK UNIFIED IDEOGRAPH
    {0x9669, 0x674B}, //4032 #CJK UNIFIED IDEOGRAPH
    {0x966A, 0x674D}, //4033 #CJK UNIFIED IDEOGRAPH
    {0x966B, 0x6752}, //4034 #CJK UNIFIED IDEOGRAPH
    {0x966C, 0x6754}, //4035 #CJK UNIFIED IDEOGRAPH
    {0x966D, 0x6755}, //4036 #CJK UNIFIED IDEOGRAPH
    {0x966E, 0x6757}, //4037 #CJK UNIFIED IDEOGRAPH
    {0x966F, 0x6758}, //4038 #CJK UNIFIED IDEOGRAPH
    {0x9670, 0x6759}, //4039 #CJK UNIFIED IDEOGRAPH
    {0x9671, 0x675A}, //4040 #CJK UNIFIED IDEOGRAPH
    {0x9672, 0x675B}, //4041 #CJK UNIFIED IDEOGRAPH
    {0x9673, 0x675D}, //4042 #CJK UNIFIED IDEOGRAPH
    {0x9674, 0x6762}, //4043 #CJK UNIFIED IDEOGRAPH
    {0x9675, 0x6763}, //4044 #CJK UNIFIED IDEOGRAPH
    {0x9676, 0x6764}, //4045 #CJK UNIFIED IDEOGRAPH
    {0x9677, 0x6766}, //4046 #CJK UNIFIED IDEOGRAPH
    {0x9678, 0x6767}, //4047 #CJK UNIFIED IDEOGRAPH
    {0x9679, 0x676B}, //4048 #CJK UNIFIED IDEOGRAPH
    {0x967A, 0x676C}, //4049 #CJK UNIFIED IDEOGRAPH
    {0x967B, 0x676E}, //4050 #CJK UNIFIED IDEOGRAPH
    {0x967C, 0x6771}, //4051 #CJK UNIFIED IDEOGRAPH
    {0x967D, 0x6774}, //4052 #CJK UNIFIED IDEOGRAPH
    {0x967E, 0x6776}, //4053 #CJK UNIFIED IDEOGRAPH
    {0x9680, 0x6778}, //4054 #CJK UNIFIED IDEOGRAPH
    {0x9681, 0x6779}, //4055 #CJK UNIFIED IDEOGRAPH
    {0x9682, 0x677A}, //4056 #CJK UNIFIED IDEOGRAPH
    {0x9683, 0x677B}, //4057 #CJK UNIFIED IDEOGRAPH
    {0x9684, 0x677D}, //4058 #CJK UNIFIED IDEOGRAPH
    {0x9685, 0x6780}, //4059 #CJK UNIFIED IDEOGRAPH
    {0x9686, 0x6782}, //4060 #CJK UNIFIED IDEOGRAPH
    {0x9687, 0x6783}, //4061 #CJK UNIFIED IDEOGRAPH
    {0x9688, 0x6785}, //4062 #CJK UNIFIED IDEOGRAPH
    {0x9689, 0x6786}, //4063 #CJK UNIFIED IDEOGRAPH
    {0x968A, 0x6788}, //4064 #CJK UNIFIED IDEOGRAPH
    {0x968B, 0x678A}, //4065 #CJK UNIFIED IDEOGRAPH
    {0x968C, 0x678C}, //4066 #CJK UNIFIED IDEOGRAPH
    {0x968D, 0x678D}, //4067 #CJK UNIFIED IDEOGRAPH
    {0x968E, 0x678E}, //4068 #CJK UNIFIED IDEOGRAPH
    {0x968F, 0x678F}, //4069 #CJK UNIFIED IDEOGRAPH
    {0x9690, 0x6791}, //4070 #CJK UNIFIED IDEOGRAPH
    {0x9691, 0x6792}, //4071 #CJK UNIFIED IDEOGRAPH
    {0x9692, 0x6793}, //4072 #CJK UNIFIED IDEOGRAPH
    {0x9693, 0x6794}, //4073 #CJK UNIFIED IDEOGRAPH
    {0x9694, 0x6796}, //4074 #CJK UNIFIED IDEOGRAPH
    {0x9695, 0x6799}, //4075 #CJK UNIFIED IDEOGRAPH
    {0x9696, 0x679B}, //4076 #CJK UNIFIED IDEOGRAPH
    {0x9697, 0x679F}, //4077 #CJK UNIFIED IDEOGRAPH
    {0x9698, 0x67A0}, //4078 #CJK UNIFIED IDEOGRAPH
    {0x9699, 0x67A1}, //4079 #CJK UNIFIED IDEOGRAPH
    {0x969A, 0x67A4}, //4080 #CJK UNIFIED IDEOGRAPH
    {0x969B, 0x67A6}, //4081 #CJK UNIFIED IDEOGRAPH
    {0x969C, 0x67A9}, //4082 #CJK UNIFIED IDEOGRAPH
    {0x969D, 0x67AC}, //4083 #CJK UNIFIED IDEOGRAPH
    {0x969E, 0x67AE}, //4084 #CJK UNIFIED IDEOGRAPH
    {0x969F, 0x67B1}, //4085 #CJK UNIFIED IDEOGRAPH
    {0x96A0, 0x67B2}, //4086 #CJK UNIFIED IDEOGRAPH
    {0x96A1, 0x67B4}, //4087 #CJK UNIFIED IDEOGRAPH
    {0x96A2, 0x67B9}, //4088 #CJK UNIFIED IDEOGRAPH
    {0x96A3, 0x67BA}, //4089 #CJK UNIFIED IDEOGRAPH
    {0x96A4, 0x67BB}, //4090 #CJK UNIFIED IDEOGRAPH
    {0x96A5, 0x67BC}, //4091 #CJK UNIFIED IDEOGRAPH
    {0x96A6, 0x67BD}, //4092 #CJK UNIFIED IDEOGRAPH
    {0x96A7, 0x67BE}, //4093 #CJK UNIFIED IDEOGRAPH
    {0x96A8, 0x67BF}, //4094 #CJK UNIFIED IDEOGRAPH
    {0x96A9, 0x67C0}, //4095 #CJK UNIFIED IDEOGRAPH
    {0x96AA, 0x67C2}, //4096 #CJK UNIFIED IDEOGRAPH
    {0x96AB, 0x67C5}, //4097 #CJK UNIFIED IDEOGRAPH
    {0x96AC, 0x67C6}, //4098 #CJK UNIFIED IDEOGRAPH
    {0x96AD, 0x67C7}, //4099 #CJK UNIFIED IDEOGRAPH
    {0x96AE, 0x67C8}, //4100 #CJK UNIFIED IDEOGRAPH
    {0x96AF, 0x67C9}, //4101 #CJK UNIFIED IDEOGRAPH
    {0x96B0, 0x67CA}, //4102 #CJK UNIFIED IDEOGRAPH
    {0x96B1, 0x67CB}, //4103 #CJK UNIFIED IDEOGRAPH
    {0x96B2, 0x67CC}, //4104 #CJK UNIFIED IDEOGRAPH
    {0x96B3, 0x67CD}, //4105 #CJK UNIFIED IDEOGRAPH
    {0x96B4, 0x67CE}, //4106 #CJK UNIFIED IDEOGRAPH
    {0x96B5, 0x67D5}, //4107 #CJK UNIFIED IDEOGRAPH
    {0x96B6, 0x67D6}, //4108 #CJK UNIFIED IDEOGRAPH
    {0x96B7, 0x67D7}, //4109 #CJK UNIFIED IDEOGRAPH
    {0x96B8, 0x67DB}, //4110 #CJK UNIFIED IDEOGRAPH
    {0x96B9, 0x67DF}, //4111 #CJK UNIFIED IDEOGRAPH
    {0x96BA, 0x67E1}, //4112 #CJK UNIFIED IDEOGRAPH
    {0x96BB, 0x67E3}, //4113 #CJK UNIFIED IDEOGRAPH
    {0x96BC, 0x67E4}, //4114 #CJK UNIFIED IDEOGRAPH
    {0x96BD, 0x67E6}, //4115 #CJK UNIFIED IDEOGRAPH
    {0x96BE, 0x67E7}, //4116 #CJK UNIFIED IDEOGRAPH
    {0x96BF, 0x67E8}, //4117 #CJK UNIFIED IDEOGRAPH
    {0x96C0, 0x67EA}, //4118 #CJK UNIFIED IDEOGRAPH
    {0x96C1, 0x67EB}, //4119 #CJK UNIFIED IDEOGRAPH
    {0x96C2, 0x67ED}, //4120 #CJK UNIFIED IDEOGRAPH
    {0x96C3, 0x67EE}, //4121 #CJK UNIFIED IDEOGRAPH
    {0x96C4, 0x67F2}, //4122 #CJK UNIFIED IDEOGRAPH
    {0x96C5, 0x67F5}, //4123 #CJK UNIFIED IDEOGRAPH
    {0x96C6, 0x67F6}, //4124 #CJK UNIFIED IDEOGRAPH
    {0x96C7, 0x67F7}, //4125 #CJK UNIFIED IDEOGRAPH
    {0x96C8, 0x67F8}, //4126 #CJK UNIFIED IDEOGRAPH
    {0x96C9, 0x67F9}, //4127 #CJK UNIFIED IDEOGRAPH
    {0x96CA, 0x67FA}, //4128 #CJK UNIFIED IDEOGRAPH
    {0x96CB, 0x67FB}, //4129 #CJK UNIFIED IDEOGRAPH
    {0x96CC, 0x67FC}, //4130 #CJK UNIFIED IDEOGRAPH
    {0x96CD, 0x67FE}, //4131 #CJK UNIFIED IDEOGRAPH
    {0x96CE, 0x6801}, //4132 #CJK UNIFIED IDEOGRAPH
    {0x96CF, 0x6802}, //4133 #CJK UNIFIED IDEOGRAPH
    {0x96D0, 0x6803}, //4134 #CJK UNIFIED IDEOGRAPH
    {0x96D1, 0x6804}, //4135 #CJK UNIFIED IDEOGRAPH
    {0x96D2, 0x6806}, //4136 #CJK UNIFIED IDEOGRAPH
    {0x96D3, 0x680D}, //4137 #CJK UNIFIED IDEOGRAPH
    {0x96D4, 0x6810}, //4138 #CJK UNIFIED IDEOGRAPH
    {0x96D5, 0x6812}, //4139 #CJK UNIFIED IDEOGRAPH
    {0x96D6, 0x6814}, //4140 #CJK UNIFIED IDEOGRAPH
    {0x96D7, 0x6815}, //4141 #CJK UNIFIED IDEOGRAPH
    {0x96D8, 0x6818}, //4142 #CJK UNIFIED IDEOGRAPH
    {0x96D9, 0x6819}, //4143 #CJK UNIFIED IDEOGRAPH
    {0x96DA, 0x681A}, //4144 #CJK UNIFIED IDEOGRAPH
    {0x96DB, 0x681B}, //4145 #CJK UNIFIED IDEOGRAPH
    {0x96DC, 0x681C}, //4146 #CJK UNIFIED IDEOGRAPH
    {0x96DD, 0x681E}, //4147 #CJK UNIFIED IDEOGRAPH
    {0x96DE, 0x681F}, //4148 #CJK UNIFIED IDEOGRAPH
    {0x96DF, 0x6820}, //4149 #CJK UNIFIED IDEOGRAPH
    {0x96E0, 0x6822}, //4150 #CJK UNIFIED IDEOGRAPH
    {0x96E1, 0x6823}, //4151 #CJK UNIFIED IDEOGRAPH
    {0x96E2, 0x6824}, //4152 #CJK UNIFIED IDEOGRAPH
    {0x96E3, 0x6825}, //4153 #CJK UNIFIED IDEOGRAPH
    {0x96E4, 0x6826}, //4154 #CJK UNIFIED IDEOGRAPH
    {0x96E5, 0x6827}, //4155 #CJK UNIFIED IDEOGRAPH
    {0x96E6, 0x6828}, //4156 #CJK UNIFIED IDEOGRAPH
    {0x96E7, 0x682B}, //4157 #CJK UNIFIED IDEOGRAPH
    {0x96E8, 0x682C}, //4158 #CJK UNIFIED IDEOGRAPH
    {0x96E9, 0x682D}, //4159 #CJK UNIFIED IDEOGRAPH
    {0x96EA, 0x682E}, //4160 #CJK UNIFIED IDEOGRAPH
    {0x96EB, 0x682F}, //4161 #CJK UNIFIED IDEOGRAPH
    {0x96EC, 0x6830}, //4162 #CJK UNIFIED IDEOGRAPH
    {0x96ED, 0x6831}, //4163 #CJK UNIFIED IDEOGRAPH
    {0x96EE, 0x6834}, //4164 #CJK UNIFIED IDEOGRAPH
    {0x96EF, 0x6835}, //4165 #CJK UNIFIED IDEOGRAPH
    {0x96F0, 0x6836}, //4166 #CJK UNIFIED IDEOGRAPH
    {0x96F1, 0x683A}, //4167 #CJK UNIFIED IDEOGRAPH
    {0x96F2, 0x683B}, //4168 #CJK UNIFIED IDEOGRAPH
    {0x96F3, 0x683F}, //4169 #CJK UNIFIED IDEOGRAPH
    {0x96F4, 0x6847}, //4170 #CJK UNIFIED IDEOGRAPH
    {0x96F5, 0x684B}, //4171 #CJK UNIFIED IDEOGRAPH
    {0x96F6, 0x684D}, //4172 #CJK UNIFIED IDEOGRAPH
    {0x96F7, 0x684F}, //4173 #CJK UNIFIED IDEOGRAPH
    {0x96F8, 0x6852}, //4174 #CJK UNIFIED IDEOGRAPH
    {0x96F9, 0x6856}, //4175 #CJK UNIFIED IDEOGRAPH
    {0x96FA, 0x6857}, //4176 #CJK UNIFIED IDEOGRAPH
    {0x96FB, 0x6858}, //4177 #CJK UNIFIED IDEOGRAPH
    {0x96FC, 0x6859}, //4178 #CJK UNIFIED IDEOGRAPH
    {0x96FD, 0x685A}, //4179 #CJK UNIFIED IDEOGRAPH
    {0x96FE, 0x685B}, //4180 #CJK UNIFIED IDEOGRAPH
    {0x9740, 0x685C}, //4181 #CJK UNIFIED IDEOGRAPH
    {0x9741, 0x685D}, //4182 #CJK UNIFIED IDEOGRAPH
    {0x9742, 0x685E}, //4183 #CJK UNIFIED IDEOGRAPH
    {0x9743, 0x685F}, //4184 #CJK UNIFIED IDEOGRAPH
    {0x9744, 0x686A}, //4185 #CJK UNIFIED IDEOGRAPH
    {0x9745, 0x686C}, //4186 #CJK UNIFIED IDEOGRAPH
    {0x9746, 0x686D}, //4187 #CJK UNIFIED IDEOGRAPH
    {0x9747, 0x686E}, //4188 #CJK UNIFIED IDEOGRAPH
    {0x9748, 0x686F}, //4189 #CJK UNIFIED IDEOGRAPH
    {0x9749, 0x6870}, //4190 #CJK UNIFIED IDEOGRAPH
    {0x974A, 0x6871}, //4191 #CJK UNIFIED IDEOGRAPH
    {0x974B, 0x6872}, //4192 #CJK UNIFIED IDEOGRAPH
    {0x974C, 0x6873}, //4193 #CJK UNIFIED IDEOGRAPH
    {0x974D, 0x6875}, //4194 #CJK UNIFIED IDEOGRAPH
    {0x974E, 0x6878}, //4195 #CJK UNIFIED IDEOGRAPH
    {0x974F, 0x6879}, //4196 #CJK UNIFIED IDEOGRAPH
    {0x9750, 0x687A}, //4197 #CJK UNIFIED IDEOGRAPH
    {0x9751, 0x687B}, //4198 #CJK UNIFIED IDEOGRAPH
    {0x9752, 0x687C}, //4199 #CJK UNIFIED IDEOGRAPH
    {0x9753, 0x687D}, //4200 #CJK UNIFIED IDEOGRAPH
    {0x9754, 0x687E}, //4201 #CJK UNIFIED IDEOGRAPH
    {0x9755, 0x687F}, //4202 #CJK UNIFIED IDEOGRAPH
    {0x9756, 0x6880}, //4203 #CJK UNIFIED IDEOGRAPH
    {0x9757, 0x6882}, //4204 #CJK UNIFIED IDEOGRAPH
    {0x9758, 0x6884}, //4205 #CJK UNIFIED IDEOGRAPH
    {0x9759, 0x6887}, //4206 #CJK UNIFIED IDEOGRAPH
    {0x975A, 0x6888}, //4207 #CJK UNIFIED IDEOGRAPH
    {0x975B, 0x6889}, //4208 #CJK UNIFIED IDEOGRAPH
    {0x975C, 0x688A}, //4209 #CJK UNIFIED IDEOGRAPH
    {0x975D, 0x688B}, //4210 #CJK UNIFIED IDEOGRAPH
    {0x975E, 0x688C}, //4211 #CJK UNIFIED IDEOGRAPH
    {0x975F, 0x688D}, //4212 #CJK UNIFIED IDEOGRAPH
    {0x9760, 0x688E}, //4213 #CJK UNIFIED IDEOGRAPH
    {0x9761, 0x6890}, //4214 #CJK UNIFIED IDEOGRAPH
    {0x9762, 0x6891}, //4215 #CJK UNIFIED IDEOGRAPH
    {0x9763, 0x6892}, //4216 #CJK UNIFIED IDEOGRAPH
    {0x9764, 0x6894}, //4217 #CJK UNIFIED IDEOGRAPH
    {0x9765, 0x6895}, //4218 #CJK UNIFIED IDEOGRAPH
    {0x9766, 0x6896}, //4219 #CJK UNIFIED IDEOGRAPH
    {0x9767, 0x6898}, //4220 #CJK UNIFIED IDEOGRAPH
    {0x9768, 0x6899}, //4221 #CJK UNIFIED IDEOGRAPH
    {0x9769, 0x689A}, //4222 #CJK UNIFIED IDEOGRAPH
    {0x976A, 0x689B}, //4223 #CJK UNIFIED IDEOGRAPH
    {0x976B, 0x689C}, //4224 #CJK UNIFIED IDEOGRAPH
    {0x976C, 0x689D}, //4225 #CJK UNIFIED IDEOGRAPH
    {0x976D, 0x689E}, //4226 #CJK UNIFIED IDEOGRAPH
    {0x976E, 0x689F}, //4227 #CJK UNIFIED IDEOGRAPH
    {0x976F, 0x68A0}, //4228 #CJK UNIFIED IDEOGRAPH
    {0x9770, 0x68A1}, //4229 #CJK UNIFIED IDEOGRAPH
    {0x9771, 0x68A3}, //4230 #CJK UNIFIED IDEOGRAPH
    {0x9772, 0x68A4}, //4231 #CJK UNIFIED IDEOGRAPH
    {0x9773, 0x68A5}, //4232 #CJK UNIFIED IDEOGRAPH
    {0x9774, 0x68A9}, //4233 #CJK UNIFIED IDEOGRAPH
    {0x9775, 0x68AA}, //4234 #CJK UNIFIED IDEOGRAPH
    {0x9776, 0x68AB}, //4235 #CJK UNIFIED IDEOGRAPH
    {0x9777, 0x68AC}, //4236 #CJK UNIFIED IDEOGRAPH
    {0x9778, 0x68AE}, //4237 #CJK UNIFIED IDEOGRAPH
    {0x9779, 0x68B1}, //4238 #CJK UNIFIED IDEOGRAPH
    {0x977A, 0x68B2}, //4239 #CJK UNIFIED IDEOGRAPH
    {0x977B, 0x68B4}, //4240 #CJK UNIFIED IDEOGRAPH
    {0x977C, 0x68B6}, //4241 #CJK UNIFIED IDEOGRAPH
    {0x977D, 0x68B7}, //4242 #CJK UNIFIED IDEOGRAPH
    {0x977E, 0x68B8}, //4243 #CJK UNIFIED IDEOGRAPH
    {0x9780, 0x68B9}, //4244 #CJK UNIFIED IDEOGRAPH
    {0x9781, 0x68BA}, //4245 #CJK UNIFIED IDEOGRAPH
    {0x9782, 0x68BB}, //4246 #CJK UNIFIED IDEOGRAPH
    {0x9783, 0x68BC}, //4247 #CJK UNIFIED IDEOGRAPH
    {0x9784, 0x68BD}, //4248 #CJK UNIFIED IDEOGRAPH
    {0x9785, 0x68BE}, //4249 #CJK UNIFIED IDEOGRAPH
    {0x9786, 0x68BF}, //4250 #CJK UNIFIED IDEOGRAPH
    {0x9787, 0x68C1}, //4251 #CJK UNIFIED IDEOGRAPH
    {0x9788, 0x68C3}, //4252 #CJK UNIFIED IDEOGRAPH
    {0x9789, 0x68C4}, //4253 #CJK UNIFIED IDEOGRAPH
    {0x978A, 0x68C5}, //4254 #CJK UNIFIED IDEOGRAPH
    {0x978B, 0x68C6}, //4255 #CJK UNIFIED IDEOGRAPH
    {0x978C, 0x68C7}, //4256 #CJK UNIFIED IDEOGRAPH
    {0x978D, 0x68C8}, //4257 #CJK UNIFIED IDEOGRAPH
    {0x978E, 0x68CA}, //4258 #CJK UNIFIED IDEOGRAPH
    {0x978F, 0x68CC}, //4259 #CJK UNIFIED IDEOGRAPH
    {0x9790, 0x68CE}, //4260 #CJK UNIFIED IDEOGRAPH
    {0x9791, 0x68CF}, //4261 #CJK UNIFIED IDEOGRAPH
    {0x9792, 0x68D0}, //4262 #CJK UNIFIED IDEOGRAPH
    {0x9793, 0x68D1}, //4263 #CJK UNIFIED IDEOGRAPH
    {0x9794, 0x68D3}, //4264 #CJK UNIFIED IDEOGRAPH
    {0x9795, 0x68D4}, //4265 #CJK UNIFIED IDEOGRAPH
    {0x9796, 0x68D6}, //4266 #CJK UNIFIED IDEOGRAPH
    {0x9797, 0x68D7}, //4267 #CJK UNIFIED IDEOGRAPH
    {0x9798, 0x68D9}, //4268 #CJK UNIFIED IDEOGRAPH
    {0x9799, 0x68DB}, //4269 #CJK UNIFIED IDEOGRAPH
    {0x979A, 0x68DC}, //4270 #CJK UNIFIED IDEOGRAPH
    {0x979B, 0x68DD}, //4271 #CJK UNIFIED IDEOGRAPH
    {0x979C, 0x68DE}, //4272 #CJK UNIFIED IDEOGRAPH
    {0x979D, 0x68DF}, //4273 #CJK UNIFIED IDEOGRAPH
    {0x979E, 0x68E1}, //4274 #CJK UNIFIED IDEOGRAPH
    {0x979F, 0x68E2}, //4275 #CJK UNIFIED IDEOGRAPH
    {0x97A0, 0x68E4}, //4276 #CJK UNIFIED IDEOGRAPH
    {0x97A1, 0x68E5}, //4277 #CJK UNIFIED IDEOGRAPH
    {0x97A2, 0x68E6}, //4278 #CJK UNIFIED IDEOGRAPH
    {0x97A3, 0x68E7}, //4279 #CJK UNIFIED IDEOGRAPH
    {0x97A4, 0x68E8}, //4280 #CJK UNIFIED IDEOGRAPH
    {0x97A5, 0x68E9}, //4281 #CJK UNIFIED IDEOGRAPH
    {0x97A6, 0x68EA}, //4282 #CJK UNIFIED IDEOGRAPH
    {0x97A7, 0x68EB}, //4283 #CJK UNIFIED IDEOGRAPH
    {0x97A8, 0x68EC}, //4284 #CJK UNIFIED IDEOGRAPH
    {0x97A9, 0x68ED}, //4285 #CJK UNIFIED IDEOGRAPH
    {0x97AA, 0x68EF}, //4286 #CJK UNIFIED IDEOGRAPH
    {0x97AB, 0x68F2}, //4287 #CJK UNIFIED IDEOGRAPH
    {0x97AC, 0x68F3}, //4288 #CJK UNIFIED IDEOGRAPH
    {0x97AD, 0x68F4}, //4289 #CJK UNIFIED IDEOGRAPH
    {0x97AE, 0x68F6}, //4290 #CJK UNIFIED IDEOGRAPH
    {0x97AF, 0x68F7}, //4291 #CJK UNIFIED IDEOGRAPH
    {0x97B0, 0x68F8}, //4292 #CJK UNIFIED IDEOGRAPH
    {0x97B1, 0x68FB}, //4293 #CJK UNIFIED IDEOGRAPH
    {0x97B2, 0x68FD}, //4294 #CJK UNIFIED IDEOGRAPH
    {0x97B3, 0x68FE}, //4295 #CJK UNIFIED IDEOGRAPH
    {0x97B4, 0x68FF}, //4296 #CJK UNIFIED IDEOGRAPH
    {0x97B5, 0x6900}, //4297 #CJK UNIFIED IDEOGRAPH
    {0x97B6, 0x6902}, //4298 #CJK UNIFIED IDEOGRAPH
    {0x97B7, 0x6903}, //4299 #CJK UNIFIED IDEOGRAPH
    {0x97B8, 0x6904}, //4300 #CJK UNIFIED IDEOGRAPH
    {0x97B9, 0x6906}, //4301 #CJK UNIFIED IDEOGRAPH
    {0x97BA, 0x6907}, //4302 #CJK UNIFIED IDEOGRAPH
    {0x97BB, 0x6908}, //4303 #CJK UNIFIED IDEOGRAPH
    {0x97BC, 0x6909}, //4304 #CJK UNIFIED IDEOGRAPH
    {0x97BD, 0x690A}, //4305 #CJK UNIFIED IDEOGRAPH
    {0x97BE, 0x690C}, //4306 #CJK UNIFIED IDEOGRAPH
    {0x97BF, 0x690F}, //4307 #CJK UNIFIED IDEOGRAPH
    {0x97C0, 0x6911}, //4308 #CJK UNIFIED IDEOGRAPH
    {0x97C1, 0x6913}, //4309 #CJK UNIFIED IDEOGRAPH
    {0x97C2, 0x6914}, //4310 #CJK UNIFIED IDEOGRAPH
    {0x97C3, 0x6915}, //4311 #CJK UNIFIED IDEOGRAPH
    {0x97C4, 0x6916}, //4312 #CJK UNIFIED IDEOGRAPH
    {0x97C5, 0x6917}, //4313 #CJK UNIFIED IDEOGRAPH
    {0x97C6, 0x6918}, //4314 #CJK UNIFIED IDEOGRAPH
    {0x97C7, 0x6919}, //4315 #CJK UNIFIED IDEOGRAPH
    {0x97C8, 0x691A}, //4316 #CJK UNIFIED IDEOGRAPH
    {0x97C9, 0x691B}, //4317 #CJK UNIFIED IDEOGRAPH
    {0x97CA, 0x691C}, //4318 #CJK UNIFIED IDEOGRAPH
    {0x97CB, 0x691D}, //4319 #CJK UNIFIED IDEOGRAPH
    {0x97CC, 0x691E}, //4320 #CJK UNIFIED IDEOGRAPH
    {0x97CD, 0x6921}, //4321 #CJK UNIFIED IDEOGRAPH
    {0x97CE, 0x6922}, //4322 #CJK UNIFIED IDEOGRAPH
    {0x97CF, 0x6923}, //4323 #CJK UNIFIED IDEOGRAPH
    {0x97D0, 0x6925}, //4324 #CJK UNIFIED IDEOGRAPH
    {0x97D1, 0x6926}, //4325 #CJK UNIFIED IDEOGRAPH
    {0x97D2, 0x6927}, //4326 #CJK UNIFIED IDEOGRAPH
    {0x97D3, 0x6928}, //4327 #CJK UNIFIED IDEOGRAPH
    {0x97D4, 0x6929}, //4328 #CJK UNIFIED IDEOGRAPH
    {0x97D5, 0x692A}, //4329 #CJK UNIFIED IDEOGRAPH
    {0x97D6, 0x692B}, //4330 #CJK UNIFIED IDEOGRAPH
    {0x97D7, 0x692C}, //4331 #CJK UNIFIED IDEOGRAPH
    {0x97D8, 0x692E}, //4332 #CJK UNIFIED IDEOGRAPH
    {0x97D9, 0x692F}, //4333 #CJK UNIFIED IDEOGRAPH
    {0x97DA, 0x6931}, //4334 #CJK UNIFIED IDEOGRAPH
    {0x97DB, 0x6932}, //4335 #CJK UNIFIED IDEOGRAPH
    {0x97DC, 0x6933}, //4336 #CJK UNIFIED IDEOGRAPH
    {0x97DD, 0x6935}, //4337 #CJK UNIFIED IDEOGRAPH
    {0x97DE, 0x6936}, //4338 #CJK UNIFIED IDEOGRAPH
    {0x97DF, 0x6937}, //4339 #CJK UNIFIED IDEOGRAPH
    {0x97E0, 0x6938}, //4340 #CJK UNIFIED IDEOGRAPH
    {0x97E1, 0x693A}, //4341 #CJK UNIFIED IDEOGRAPH
    {0x97E2, 0x693B}, //4342 #CJK UNIFIED IDEOGRAPH
    {0x97E3, 0x693C}, //4343 #CJK UNIFIED IDEOGRAPH
    {0x97E4, 0x693E}, //4344 #CJK UNIFIED IDEOGRAPH
    {0x97E5, 0x6940}, //4345 #CJK UNIFIED IDEOGRAPH
    {0x97E6, 0x6941}, //4346 #CJK UNIFIED IDEOGRAPH
    {0x97E7, 0x6943}, //4347 #CJK UNIFIED IDEOGRAPH
    {0x97E8, 0x6944}, //4348 #CJK UNIFIED IDEOGRAPH
    {0x97E9, 0x6945}, //4349 #CJK UNIFIED IDEOGRAPH
    {0x97EA, 0x6946}, //4350 #CJK UNIFIED IDEOGRAPH
    {0x97EB, 0x6947}, //4351 #CJK UNIFIED IDEOGRAPH
    {0x97EC, 0x6948}, //4352 #CJK UNIFIED IDEOGRAPH
    {0x97ED, 0x6949}, //4353 #CJK UNIFIED IDEOGRAPH
    {0x97EE, 0x694A}, //4354 #CJK UNIFIED IDEOGRAPH
    {0x97EF, 0x694B}, //4355 #CJK UNIFIED IDEOGRAPH
    {0x97F0, 0x694C}, //4356 #CJK UNIFIED IDEOGRAPH
    {0x97F1, 0x694D}, //4357 #CJK UNIFIED IDEOGRAPH
    {0x97F2, 0x694E}, //4358 #CJK UNIFIED IDEOGRAPH
    {0x97F3, 0x694F}, //4359 #CJK UNIFIED IDEOGRAPH
    {0x97F4, 0x6950}, //4360 #CJK UNIFIED IDEOGRAPH
    {0x97F5, 0x6951}, //4361 #CJK UNIFIED IDEOGRAPH
    {0x97F6, 0x6952}, //4362 #CJK UNIFIED IDEOGRAPH
    {0x97F7, 0x6953}, //4363 #CJK UNIFIED IDEOGRAPH
    {0x97F8, 0x6955}, //4364 #CJK UNIFIED IDEOGRAPH
    {0x97F9, 0x6956}, //4365 #CJK UNIFIED IDEOGRAPH
    {0x97FA, 0x6958}, //4366 #CJK UNIFIED IDEOGRAPH
    {0x97FB, 0x6959}, //4367 #CJK UNIFIED IDEOGRAPH
    {0x97FC, 0x695B}, //4368 #CJK UNIFIED IDEOGRAPH
    {0x97FD, 0x695C}, //4369 #CJK UNIFIED IDEOGRAPH
    {0x97FE, 0x695F}, //4370 #CJK UNIFIED IDEOGRAPH
    {0x9840, 0x6961}, //4371 #CJK UNIFIED IDEOGRAPH
    {0x9841, 0x6962}, //4372 #CJK UNIFIED IDEOGRAPH
    {0x9842, 0x6964}, //4373 #CJK UNIFIED IDEOGRAPH
    {0x9843, 0x6965}, //4374 #CJK UNIFIED IDEOGRAPH
    {0x9844, 0x6967}, //4375 #CJK UNIFIED IDEOGRAPH
    {0x9845, 0x6968}, //4376 #CJK UNIFIED IDEOGRAPH
    {0x9846, 0x6969}, //4377 #CJK UNIFIED IDEOGRAPH
    {0x9847, 0x696A}, //4378 #CJK UNIFIED IDEOGRAPH
    {0x9848, 0x696C}, //4379 #CJK UNIFIED IDEOGRAPH
    {0x9849, 0x696D}, //4380 #CJK UNIFIED IDEOGRAPH
    {0x984A, 0x696F}, //4381 #CJK UNIFIED IDEOGRAPH
    {0x984B, 0x6970}, //4382 #CJK UNIFIED IDEOGRAPH
    {0x984C, 0x6972}, //4383 #CJK UNIFIED IDEOGRAPH
    {0x984D, 0x6973}, //4384 #CJK UNIFIED IDEOGRAPH
    {0x984E, 0x6974}, //4385 #CJK UNIFIED IDEOGRAPH
    {0x984F, 0x6975}, //4386 #CJK UNIFIED IDEOGRAPH
    {0x9850, 0x6976}, //4387 #CJK UNIFIED IDEOGRAPH
    {0x9851, 0x697A}, //4388 #CJK UNIFIED IDEOGRAPH
    {0x9852, 0x697B}, //4389 #CJK UNIFIED IDEOGRAPH
    {0x9853, 0x697D}, //4390 #CJK UNIFIED IDEOGRAPH
    {0x9854, 0x697E}, //4391 #CJK UNIFIED IDEOGRAPH
    {0x9855, 0x697F}, //4392 #CJK UNIFIED IDEOGRAPH
    {0x9856, 0x6981}, //4393 #CJK UNIFIED IDEOGRAPH
    {0x9857, 0x6983}, //4394 #CJK UNIFIED IDEOGRAPH
    {0x9858, 0x6985}, //4395 #CJK UNIFIED IDEOGRAPH
    {0x9859, 0x698A}, //4396 #CJK UNIFIED IDEOGRAPH
    {0x985A, 0x698B}, //4397 #CJK UNIFIED IDEOGRAPH
    {0x985B, 0x698C}, //4398 #CJK UNIFIED IDEOGRAPH
    {0x985C, 0x698E}, //4399 #CJK UNIFIED IDEOGRAPH
    {0x985D, 0x698F}, //4400 #CJK UNIFIED IDEOGRAPH
    {0x985E, 0x6990}, //4401 #CJK UNIFIED IDEOGRAPH
    {0x985F, 0x6991}, //4402 #CJK UNIFIED IDEOGRAPH
    {0x9860, 0x6992}, //4403 #CJK UNIFIED IDEOGRAPH
    {0x9861, 0x6993}, //4404 #CJK UNIFIED IDEOGRAPH
    {0x9862, 0x6996}, //4405 #CJK UNIFIED IDEOGRAPH
    {0x9863, 0x6997}, //4406 #CJK UNIFIED IDEOGRAPH
    {0x9864, 0x6999}, //4407 #CJK UNIFIED IDEOGRAPH
    {0x9865, 0x699A}, //4408 #CJK UNIFIED IDEOGRAPH
    {0x9866, 0x699D}, //4409 #CJK UNIFIED IDEOGRAPH
    {0x9867, 0x699E}, //4410 #CJK UNIFIED IDEOGRAPH
    {0x9868, 0x699F}, //4411 #CJK UNIFIED IDEOGRAPH
    {0x9869, 0x69A0}, //4412 #CJK UNIFIED IDEOGRAPH
    {0x986A, 0x69A1}, //4413 #CJK UNIFIED IDEOGRAPH
    {0x986B, 0x69A2}, //4414 #CJK UNIFIED IDEOGRAPH
    {0x986C, 0x69A3}, //4415 #CJK UNIFIED IDEOGRAPH
    {0x986D, 0x69A4}, //4416 #CJK UNIFIED IDEOGRAPH
    {0x986E, 0x69A5}, //4417 #CJK UNIFIED IDEOGRAPH
    {0x986F, 0x69A6}, //4418 #CJK UNIFIED IDEOGRAPH
    {0x9870, 0x69A9}, //4419 #CJK UNIFIED IDEOGRAPH
    {0x9871, 0x69AA}, //4420 #CJK UNIFIED IDEOGRAPH
    {0x9872, 0x69AC}, //4421 #CJK UNIFIED IDEOGRAPH
    {0x9873, 0x69AE}, //4422 #CJK UNIFIED IDEOGRAPH
    {0x9874, 0x69AF}, //4423 #CJK UNIFIED IDEOGRAPH
    {0x9875, 0x69B0}, //4424 #CJK UNIFIED IDEOGRAPH
    {0x9876, 0x69B2}, //4425 #CJK UNIFIED IDEOGRAPH
    {0x9877, 0x69B3}, //4426 #CJK UNIFIED IDEOGRAPH
    {0x9878, 0x69B5}, //4427 #CJK UNIFIED IDEOGRAPH
    {0x9879, 0x69B6}, //4428 #CJK UNIFIED IDEOGRAPH
    {0x987A, 0x69B8}, //4429 #CJK UNIFIED IDEOGRAPH
    {0x987B, 0x69B9}, //4430 #CJK UNIFIED IDEOGRAPH
    {0x987C, 0x69BA}, //4431 #CJK UNIFIED IDEOGRAPH
    {0x987D, 0x69BC}, //4432 #CJK UNIFIED IDEOGRAPH
    {0x987E, 0x69BD}, //4433 #CJK UNIFIED IDEOGRAPH
    {0x9880, 0x69BE}, //4434 #CJK UNIFIED IDEOGRAPH
    {0x9881, 0x69BF}, //4435 #CJK UNIFIED IDEOGRAPH
    {0x9882, 0x69C0}, //4436 #CJK UNIFIED IDEOGRAPH
    {0x9883, 0x69C2}, //4437 #CJK UNIFIED IDEOGRAPH
    {0x9884, 0x69C3}, //4438 #CJK UNIFIED IDEOGRAPH
    {0x9885, 0x69C4}, //4439 #CJK UNIFIED IDEOGRAPH
    {0x9886, 0x69C5}, //4440 #CJK UNIFIED IDEOGRAPH
    {0x9887, 0x69C6}, //4441 #CJK UNIFIED IDEOGRAPH
    {0x9888, 0x69C7}, //4442 #CJK UNIFIED IDEOGRAPH
    {0x9889, 0x69C8}, //4443 #CJK UNIFIED IDEOGRAPH
    {0x988A, 0x69C9}, //4444 #CJK UNIFIED IDEOGRAPH
    {0x988B, 0x69CB}, //4445 #CJK UNIFIED IDEOGRAPH
    {0x988C, 0x69CD}, //4446 #CJK UNIFIED IDEOGRAPH
    {0x988D, 0x69CF}, //4447 #CJK UNIFIED IDEOGRAPH
    {0x988E, 0x69D1}, //4448 #CJK UNIFIED IDEOGRAPH
    {0x988F, 0x69D2}, //4449 #CJK UNIFIED IDEOGRAPH
    {0x9890, 0x69D3}, //4450 #CJK UNIFIED IDEOGRAPH
    {0x9891, 0x69D5}, //4451 #CJK UNIFIED IDEOGRAPH
    {0x9892, 0x69D6}, //4452 #CJK UNIFIED IDEOGRAPH
    {0x9893, 0x69D7}, //4453 #CJK UNIFIED IDEOGRAPH
    {0x9894, 0x69D8}, //4454 #CJK UNIFIED IDEOGRAPH
    {0x9895, 0x69D9}, //4455 #CJK UNIFIED IDEOGRAPH
    {0x9896, 0x69DA}, //4456 #CJK UNIFIED IDEOGRAPH
    {0x9897, 0x69DC}, //4457 #CJK UNIFIED IDEOGRAPH
    {0x9898, 0x69DD}, //4458 #CJK UNIFIED IDEOGRAPH
    {0x9899, 0x69DE}, //4459 #CJK UNIFIED IDEOGRAPH
    {0x989A, 0x69E1}, //4460 #CJK UNIFIED IDEOGRAPH
    {0x989B, 0x69E2}, //4461 #CJK UNIFIED IDEOGRAPH
    {0x989C, 0x69E3}, //4462 #CJK UNIFIED IDEOGRAPH
    {0x989D, 0x69E4}, //4463 #CJK UNIFIED IDEOGRAPH
    {0x989E, 0x69E5}, //4464 #CJK UNIFIED IDEOGRAPH
    {0x989F, 0x69E6}, //4465 #CJK UNIFIED IDEOGRAPH
    {0x98A0, 0x69E7}, //4466 #CJK UNIFIED IDEOGRAPH
    {0x98A1, 0x69E8}, //4467 #CJK UNIFIED IDEOGRAPH
    {0x98A2, 0x69E9}, //4468 #CJK UNIFIED IDEOGRAPH
    {0x98A3, 0x69EA}, //4469 #CJK UNIFIED IDEOGRAPH
    {0x98A4, 0x69EB}, //4470 #CJK UNIFIED IDEOGRAPH
    {0x98A5, 0x69EC}, //4471 #CJK UNIFIED IDEOGRAPH
    {0x98A6, 0x69EE}, //4472 #CJK UNIFIED IDEOGRAPH
    {0x98A7, 0x69EF}, //4473 #CJK UNIFIED IDEOGRAPH
    {0x98A8, 0x69F0}, //4474 #CJK UNIFIED IDEOGRAPH
    {0x98A9, 0x69F1}, //4475 #CJK UNIFIED IDEOGRAPH
    {0x98AA, 0x69F3}, //4476 #CJK UNIFIED IDEOGRAPH
    {0x98AB, 0x69F4}, //4477 #CJK UNIFIED IDEOGRAPH
    {0x98AC, 0x69F5}, //4478 #CJK UNIFIED IDEOGRAPH
    {0x98AD, 0x69F6}, //4479 #CJK UNIFIED IDEOGRAPH
    {0x98AE, 0x69F7}, //4480 #CJK UNIFIED IDEOGRAPH
    {0x98AF, 0x69F8}, //4481 #CJK UNIFIED IDEOGRAPH
    {0x98B0, 0x69F9}, //4482 #CJK UNIFIED IDEOGRAPH
    {0x98B1, 0x69FA}, //4483 #CJK UNIFIED IDEOGRAPH
    {0x98B2, 0x69FB}, //4484 #CJK UNIFIED IDEOGRAPH
    {0x98B3, 0x69FC}, //4485 #CJK UNIFIED IDEOGRAPH
    {0x98B4, 0x69FE}, //4486 #CJK UNIFIED IDEOGRAPH
    {0x98B5, 0x6A00}, //4487 #CJK UNIFIED IDEOGRAPH
    {0x98B6, 0x6A01}, //4488 #CJK UNIFIED IDEOGRAPH
    {0x98B7, 0x6A02}, //4489 #CJK UNIFIED IDEOGRAPH
    {0x98B8, 0x6A03}, //4490 #CJK UNIFIED IDEOGRAPH
    {0x98B9, 0x6A04}, //4491 #CJK UNIFIED IDEOGRAPH
    {0x98BA, 0x6A05}, //4492 #CJK UNIFIED IDEOGRAPH
    {0x98BB, 0x6A06}, //4493 #CJK UNIFIED IDEOGRAPH
    {0x98BC, 0x6A07}, //4494 #CJK UNIFIED IDEOGRAPH
    {0x98BD, 0x6A08}, //4495 #CJK UNIFIED IDEOGRAPH
    {0x98BE, 0x6A09}, //4496 #CJK UNIFIED IDEOGRAPH
    {0x98BF, 0x6A0B}, //4497 #CJK UNIFIED IDEOGRAPH
    {0x98C0, 0x6A0C}, //4498 #CJK UNIFIED IDEOGRAPH
    {0x98C1, 0x6A0D}, //4499 #CJK UNIFIED IDEOGRAPH
    {0x98C2, 0x6A0E}, //4500 #CJK UNIFIED IDEOGRAPH
    {0x98C3, 0x6A0F}, //4501 #CJK UNIFIED IDEOGRAPH
    {0x98C4, 0x6A10}, //4502 #CJK UNIFIED IDEOGRAPH
    {0x98C5, 0x6A11}, //4503 #CJK UNIFIED IDEOGRAPH
    {0x98C6, 0x6A12}, //4504 #CJK UNIFIED IDEOGRAPH
    {0x98C7, 0x6A13}, //4505 #CJK UNIFIED IDEOGRAPH
    {0x98C8, 0x6A14}, //4506 #CJK UNIFIED IDEOGRAPH
    {0x98C9, 0x6A15}, //4507 #CJK UNIFIED IDEOGRAPH
    {0x98CA, 0x6A16}, //4508 #CJK UNIFIED IDEOGRAPH
    {0x98CB, 0x6A19}, //4509 #CJK UNIFIED IDEOGRAPH
    {0x98CC, 0x6A1A}, //4510 #CJK UNIFIED IDEOGRAPH
    {0x98CD, 0x6A1B}, //4511 #CJK UNIFIED IDEOGRAPH
    {0x98CE, 0x6A1C}, //4512 #CJK UNIFIED IDEOGRAPH
    {0x98CF, 0x6A1D}, //4513 #CJK UNIFIED IDEOGRAPH
    {0x98D0, 0x6A1E}, //4514 #CJK UNIFIED IDEOGRAPH
    {0x98D1, 0x6A20}, //4515 #CJK UNIFIED IDEOGRAPH
    {0x98D2, 0x6A22}, //4516 #CJK UNIFIED IDEOGRAPH
    {0x98D3, 0x6A23}, //4517 #CJK UNIFIED IDEOGRAPH
    {0x98D4, 0x6A24}, //4518 #CJK UNIFIED IDEOGRAPH
    {0x98D5, 0x6A25}, //4519 #CJK UNIFIED IDEOGRAPH
    {0x98D6, 0x6A26}, //4520 #CJK UNIFIED IDEOGRAPH
    {0x98D7, 0x6A27}, //4521 #CJK UNIFIED IDEOGRAPH
    {0x98D8, 0x6A29}, //4522 #CJK UNIFIED IDEOGRAPH
    {0x98D9, 0x6A2B}, //4523 #CJK UNIFIED IDEOGRAPH
    {0x98DA, 0x6A2C}, //4524 #CJK UNIFIED IDEOGRAPH
    {0x98DB, 0x6A2D}, //4525 #CJK UNIFIED IDEOGRAPH
    {0x98DC, 0x6A2E}, //4526 #CJK UNIFIED IDEOGRAPH
    {0x98DD, 0x6A30}, //4527 #CJK UNIFIED IDEOGRAPH
    {0x98DE, 0x6A32}, //4528 #CJK UNIFIED IDEOGRAPH
    {0x98DF, 0x6A33}, //4529 #CJK UNIFIED IDEOGRAPH
    {0x98E0, 0x6A34}, //4530 #CJK UNIFIED IDEOGRAPH
    {0x98E1, 0x6A36}, //4531 #CJK UNIFIED IDEOGRAPH
    {0x98E2, 0x6A37}, //4532 #CJK UNIFIED IDEOGRAPH
    {0x98E3, 0x6A38}, //4533 #CJK UNIFIED IDEOGRAPH
    {0x98E4, 0x6A39}, //4534 #CJK UNIFIED IDEOGRAPH
    {0x98E5, 0x6A3A}, //4535 #CJK UNIFIED IDEOGRAPH
    {0x98E6, 0x6A3B}, //4536 #CJK UNIFIED IDEOGRAPH
    {0x98E7, 0x6A3C}, //4537 #CJK UNIFIED IDEOGRAPH
    {0x98E8, 0x6A3F}, //4538 #CJK UNIFIED IDEOGRAPH
    {0x98E9, 0x6A40}, //4539 #CJK UNIFIED IDEOGRAPH
    {0x98EA, 0x6A41}, //4540 #CJK UNIFIED IDEOGRAPH
    {0x98EB, 0x6A42}, //4541 #CJK UNIFIED IDEOGRAPH
    {0x98EC, 0x6A43}, //4542 #CJK UNIFIED IDEOGRAPH
    {0x98ED, 0x6A45}, //4543 #CJK UNIFIED IDEOGRAPH
    {0x98EE, 0x6A46}, //4544 #CJK UNIFIED IDEOGRAPH
    {0x98EF, 0x6A48}, //4545 #CJK UNIFIED IDEOGRAPH
    {0x98F0, 0x6A49}, //4546 #CJK UNIFIED IDEOGRAPH
    {0x98F1, 0x6A4A}, //4547 #CJK UNIFIED IDEOGRAPH
    {0x98F2, 0x6A4B}, //4548 #CJK UNIFIED IDEOGRAPH
    {0x98F3, 0x6A4C}, //4549 #CJK UNIFIED IDEOGRAPH
    {0x98F4, 0x6A4D}, //4550 #CJK UNIFIED IDEOGRAPH
    {0x98F5, 0x6A4E}, //4551 #CJK UNIFIED IDEOGRAPH
    {0x98F6, 0x6A4F}, //4552 #CJK UNIFIED IDEOGRAPH
    {0x98F7, 0x6A51}, //4553 #CJK UNIFIED IDEOGRAPH
    {0x98F8, 0x6A52}, //4554 #CJK UNIFIED IDEOGRAPH
    {0x98F9, 0x6A53}, //4555 #CJK UNIFIED IDEOGRAPH
    {0x98FA, 0x6A54}, //4556 #CJK UNIFIED IDEOGRAPH
    {0x98FB, 0x6A55}, //4557 #CJK UNIFIED IDEOGRAPH
    {0x98FC, 0x6A56}, //4558 #CJK UNIFIED IDEOGRAPH
    {0x98FD, 0x6A57}, //4559 #CJK UNIFIED IDEOGRAPH
    {0x98FE, 0x6A5A}, //4560 #CJK UNIFIED IDEOGRAPH
    {0x9940, 0x6A5C}, //4561 #CJK UNIFIED IDEOGRAPH
    {0x9941, 0x6A5D}, //4562 #CJK UNIFIED IDEOGRAPH
    {0x9942, 0x6A5E}, //4563 #CJK UNIFIED IDEOGRAPH
    {0x9943, 0x6A5F}, //4564 #CJK UNIFIED IDEOGRAPH
    {0x9944, 0x6A60}, //4565 #CJK UNIFIED IDEOGRAPH
    {0x9945, 0x6A62}, //4566 #CJK UNIFIED IDEOGRAPH
    {0x9946, 0x6A63}, //4567 #CJK UNIFIED IDEOGRAPH
    {0x9947, 0x6A64}, //4568 #CJK UNIFIED IDEOGRAPH
    {0x9948, 0x6A66}, //4569 #CJK UNIFIED IDEOGRAPH
    {0x9949, 0x6A67}, //4570 #CJK UNIFIED IDEOGRAPH
    {0x994A, 0x6A68}, //4571 #CJK UNIFIED IDEOGRAPH
    {0x994B, 0x6A69}, //4572 #CJK UNIFIED IDEOGRAPH
    {0x994C, 0x6A6A}, //4573 #CJK UNIFIED IDEOGRAPH
    {0x994D, 0x6A6B}, //4574 #CJK UNIFIED IDEOGRAPH
    {0x994E, 0x6A6C}, //4575 #CJK UNIFIED IDEOGRAPH
    {0x994F, 0x6A6D}, //4576 #CJK UNIFIED IDEOGRAPH
    {0x9950, 0x6A6E}, //4577 #CJK UNIFIED IDEOGRAPH
    {0x9951, 0x6A6F}, //4578 #CJK UNIFIED IDEOGRAPH
    {0x9952, 0x6A70}, //4579 #CJK UNIFIED IDEOGRAPH
    {0x9953, 0x6A72}, //4580 #CJK UNIFIED IDEOGRAPH
    {0x9954, 0x6A73}, //4581 #CJK UNIFIED IDEOGRAPH
    {0x9955, 0x6A74}, //4582 #CJK UNIFIED IDEOGRAPH
    {0x9956, 0x6A75}, //4583 #CJK UNIFIED IDEOGRAPH
    {0x9957, 0x6A76}, //4584 #CJK UNIFIED IDEOGRAPH
    {0x9958, 0x6A77}, //4585 #CJK UNIFIED IDEOGRAPH
    {0x9959, 0x6A78}, //4586 #CJK UNIFIED IDEOGRAPH
    {0x995A, 0x6A7A}, //4587 #CJK UNIFIED IDEOGRAPH
    {0x995B, 0x6A7B}, //4588 #CJK UNIFIED IDEOGRAPH
    {0x995C, 0x6A7D}, //4589 #CJK UNIFIED IDEOGRAPH
    {0x995D, 0x6A7E}, //4590 #CJK UNIFIED IDEOGRAPH
    {0x995E, 0x6A7F}, //4591 #CJK UNIFIED IDEOGRAPH
    {0x995F, 0x6A81}, //4592 #CJK UNIFIED IDEOGRAPH
    {0x9960, 0x6A82}, //4593 #CJK UNIFIED IDEOGRAPH
    {0x9961, 0x6A83}, //4594 #CJK UNIFIED IDEOGRAPH
    {0x9962, 0x6A85}, //4595 #CJK UNIFIED IDEOGRAPH
    {0x9963, 0x6A86}, //4596 #CJK UNIFIED IDEOGRAPH
    {0x9964, 0x6A87}, //4597 #CJK UNIFIED IDEOGRAPH
    {0x9965, 0x6A88}, //4598 #CJK UNIFIED IDEOGRAPH
    {0x9966, 0x6A89}, //4599 #CJK UNIFIED IDEOGRAPH
    {0x9967, 0x6A8A}, //4600 #CJK UNIFIED IDEOGRAPH
    {0x9968, 0x6A8B}, //4601 #CJK UNIFIED IDEOGRAPH
    {0x9969, 0x6A8C}, //4602 #CJK UNIFIED IDEOGRAPH
    {0x996A, 0x6A8D}, //4603 #CJK UNIFIED IDEOGRAPH
    {0x996B, 0x6A8F}, //4604 #CJK UNIFIED IDEOGRAPH
    {0x996C, 0x6A92}, //4605 #CJK UNIFIED IDEOGRAPH
    {0x996D, 0x6A93}, //4606 #CJK UNIFIED IDEOGRAPH
    {0x996E, 0x6A94}, //4607 #CJK UNIFIED IDEOGRAPH
    {0x996F, 0x6A95}, //4608 #CJK UNIFIED IDEOGRAPH
    {0x9970, 0x6A96}, //4609 #CJK UNIFIED IDEOGRAPH
    {0x9971, 0x6A98}, //4610 #CJK UNIFIED IDEOGRAPH
    {0x9972, 0x6A99}, //4611 #CJK UNIFIED IDEOGRAPH
    {0x9973, 0x6A9A}, //4612 #CJK UNIFIED IDEOGRAPH
    {0x9974, 0x6A9B}, //4613 #CJK UNIFIED IDEOGRAPH
    {0x9975, 0x6A9C}, //4614 #CJK UNIFIED IDEOGRAPH
    {0x9976, 0x6A9D}, //4615 #CJK UNIFIED IDEOGRAPH
    {0x9977, 0x6A9E}, //4616 #CJK UNIFIED IDEOGRAPH
    {0x9978, 0x6A9F}, //4617 #CJK UNIFIED IDEOGRAPH
    {0x9979, 0x6AA1}, //4618 #CJK UNIFIED IDEOGRAPH
    {0x997A, 0x6AA2}, //4619 #CJK UNIFIED IDEOGRAPH
    {0x997B, 0x6AA3}, //4620 #CJK UNIFIED IDEOGRAPH
    {0x997C, 0x6AA4}, //4621 #CJK UNIFIED IDEOGRAPH
    {0x997D, 0x6AA5}, //4622 #CJK UNIFIED IDEOGRAPH
    {0x997E, 0x6AA6}, //4623 #CJK UNIFIED IDEOGRAPH
    {0x9980, 0x6AA7}, //4624 #CJK UNIFIED IDEOGRAPH
    {0x9981, 0x6AA8}, //4625 #CJK UNIFIED IDEOGRAPH
    {0x9982, 0x6AAA}, //4626 #CJK UNIFIED IDEOGRAPH
    {0x9983, 0x6AAD}, //4627 #CJK UNIFIED IDEOGRAPH
    {0x9984, 0x6AAE}, //4628 #CJK UNIFIED IDEOGRAPH
    {0x9985, 0x6AAF}, //4629 #CJK UNIFIED IDEOGRAPH
    {0x9986, 0x6AB0}, //4630 #CJK UNIFIED IDEOGRAPH
    {0x9987, 0x6AB1}, //4631 #CJK UNIFIED IDEOGRAPH
    {0x9988, 0x6AB2}, //4632 #CJK UNIFIED IDEOGRAPH
    {0x9989, 0x6AB3}, //4633 #CJK UNIFIED IDEOGRAPH
    {0x998A, 0x6AB4}, //4634 #CJK UNIFIED IDEOGRAPH
    {0x998B, 0x6AB5}, //4635 #CJK UNIFIED IDEOGRAPH
    {0x998C, 0x6AB6}, //4636 #CJK UNIFIED IDEOGRAPH
    {0x998D, 0x6AB7}, //4637 #CJK UNIFIED IDEOGRAPH
    {0x998E, 0x6AB8}, //4638 #CJK UNIFIED IDEOGRAPH
    {0x998F, 0x6AB9}, //4639 #CJK UNIFIED IDEOGRAPH
    {0x9990, 0x6ABA}, //4640 #CJK UNIFIED IDEOGRAPH
    {0x9991, 0x6ABB}, //4641 #CJK UNIFIED IDEOGRAPH
    {0x9992, 0x6ABC}, //4642 #CJK UNIFIED IDEOGRAPH
    {0x9993, 0x6ABD}, //4643 #CJK UNIFIED IDEOGRAPH
    {0x9994, 0x6ABE}, //4644 #CJK UNIFIED IDEOGRAPH
    {0x9995, 0x6ABF}, //4645 #CJK UNIFIED IDEOGRAPH
    {0x9996, 0x6AC0}, //4646 #CJK UNIFIED IDEOGRAPH
    {0x9997, 0x6AC1}, //4647 #CJK UNIFIED IDEOGRAPH
    {0x9998, 0x6AC2}, //4648 #CJK UNIFIED IDEOGRAPH
    {0x9999, 0x6AC3}, //4649 #CJK UNIFIED IDEOGRAPH
    {0x999A, 0x6AC4}, //4650 #CJK UNIFIED IDEOGRAPH
    {0x999B, 0x6AC5}, //4651 #CJK UNIFIED IDEOGRAPH
    {0x999C, 0x6AC6}, //4652 #CJK UNIFIED IDEOGRAPH
    {0x999D, 0x6AC7}, //4653 #CJK UNIFIED IDEOGRAPH
    {0x999E, 0x6AC8}, //4654 #CJK UNIFIED IDEOGRAPH
    {0x999F, 0x6AC9}, //4655 #CJK UNIFIED IDEOGRAPH
    {0x99A0, 0x6ACA}, //4656 #CJK UNIFIED IDEOGRAPH
    {0x99A1, 0x6ACB}, //4657 #CJK UNIFIED IDEOGRAPH
    {0x99A2, 0x6ACC}, //4658 #CJK UNIFIED IDEOGRAPH
    {0x99A3, 0x6ACD}, //4659 #CJK UNIFIED IDEOGRAPH
    {0x99A4, 0x6ACE}, //4660 #CJK UNIFIED IDEOGRAPH
    {0x99A5, 0x6ACF}, //4661 #CJK UNIFIED IDEOGRAPH
    {0x99A6, 0x6AD0}, //4662 #CJK UNIFIED IDEOGRAPH
    {0x99A7, 0x6AD1}, //4663 #CJK UNIFIED IDEOGRAPH
    {0x99A8, 0x6AD2}, //4664 #CJK UNIFIED IDEOGRAPH
    {0x99A9, 0x6AD3}, //4665 #CJK UNIFIED IDEOGRAPH
    {0x99AA, 0x6AD4}, //4666 #CJK UNIFIED IDEOGRAPH
    {0x99AB, 0x6AD5}, //4667 #CJK UNIFIED IDEOGRAPH
    {0x99AC, 0x6AD6}, //4668 #CJK UNIFIED IDEOGRAPH
    {0x99AD, 0x6AD7}, //4669 #CJK UNIFIED IDEOGRAPH
    {0x99AE, 0x6AD8}, //4670 #CJK UNIFIED IDEOGRAPH
    {0x99AF, 0x6AD9}, //4671 #CJK UNIFIED IDEOGRAPH
    {0x99B0, 0x6ADA}, //4672 #CJK UNIFIED IDEOGRAPH
    {0x99B1, 0x6ADB}, //4673 #CJK UNIFIED IDEOGRAPH
    {0x99B2, 0x6ADC}, //4674 #CJK UNIFIED IDEOGRAPH
    {0x99B3, 0x6ADD}, //4675 #CJK UNIFIED IDEOGRAPH
    {0x99B4, 0x6ADE}, //4676 #CJK UNIFIED IDEOGRAPH
    {0x99B5, 0x6ADF}, //4677 #CJK UNIFIED IDEOGRAPH
    {0x99B6, 0x6AE0}, //4678 #CJK UNIFIED IDEOGRAPH
    {0x99B7, 0x6AE1}, //4679 #CJK UNIFIED IDEOGRAPH
    {0x99B8, 0x6AE2}, //4680 #CJK UNIFIED IDEOGRAPH
    {0x99B9, 0x6AE3}, //4681 #CJK UNIFIED IDEOGRAPH
    {0x99BA, 0x6AE4}, //4682 #CJK UNIFIED IDEOGRAPH
    {0x99BB, 0x6AE5}, //4683 #CJK UNIFIED IDEOGRAPH
    {0x99BC, 0x6AE6}, //4684 #CJK UNIFIED IDEOGRAPH
    {0x99BD, 0x6AE7}, //4685 #CJK UNIFIED IDEOGRAPH
    {0x99BE, 0x6AE8}, //4686 #CJK UNIFIED IDEOGRAPH
    {0x99BF, 0x6AE9}, //4687 #CJK UNIFIED IDEOGRAPH
    {0x99C0, 0x6AEA}, //4688 #CJK UNIFIED IDEOGRAPH
    {0x99C1, 0x6AEB}, //4689 #CJK UNIFIED IDEOGRAPH
    {0x99C2, 0x6AEC}, //4690 #CJK UNIFIED IDEOGRAPH
    {0x99C3, 0x6AED}, //4691 #CJK UNIFIED IDEOGRAPH
    {0x99C4, 0x6AEE}, //4692 #CJK UNIFIED IDEOGRAPH
    {0x99C5, 0x6AEF}, //4693 #CJK UNIFIED IDEOGRAPH
    {0x99C6, 0x6AF0}, //4694 #CJK UNIFIED IDEOGRAPH
    {0x99C7, 0x6AF1}, //4695 #CJK UNIFIED IDEOGRAPH
    {0x99C8, 0x6AF2}, //4696 #CJK UNIFIED IDEOGRAPH
    {0x99C9, 0x6AF3}, //4697 #CJK UNIFIED IDEOGRAPH
    {0x99CA, 0x6AF4}, //4698 #CJK UNIFIED IDEOGRAPH
    {0x99CB, 0x6AF5}, //4699 #CJK UNIFIED IDEOGRAPH
    {0x99CC, 0x6AF6}, //4700 #CJK UNIFIED IDEOGRAPH
    {0x99CD, 0x6AF7}, //4701 #CJK UNIFIED IDEOGRAPH
    {0x99CE, 0x6AF8}, //4702 #CJK UNIFIED IDEOGRAPH
    {0x99CF, 0x6AF9}, //4703 #CJK UNIFIED IDEOGRAPH
    {0x99D0, 0x6AFA}, //4704 #CJK UNIFIED IDEOGRAPH
    {0x99D1, 0x6AFB}, //4705 #CJK UNIFIED IDEOGRAPH
    {0x99D2, 0x6AFC}, //4706 #CJK UNIFIED IDEOGRAPH
    {0x99D3, 0x6AFD}, //4707 #CJK UNIFIED IDEOGRAPH
    {0x99D4, 0x6AFE}, //4708 #CJK UNIFIED IDEOGRAPH
    {0x99D5, 0x6AFF}, //4709 #CJK UNIFIED IDEOGRAPH
    {0x99D6, 0x6B00}, //4710 #CJK UNIFIED IDEOGRAPH
    {0x99D7, 0x6B01}, //4711 #CJK UNIFIED IDEOGRAPH
    {0x99D8, 0x6B02}, //4712 #CJK UNIFIED IDEOGRAPH
    {0x99D9, 0x6B03}, //4713 #CJK UNIFIED IDEOGRAPH
    {0x99DA, 0x6B04}, //4714 #CJK UNIFIED IDEOGRAPH
    {0x99DB, 0x6B05}, //4715 #CJK UNIFIED IDEOGRAPH
    {0x99DC, 0x6B06}, //4716 #CJK UNIFIED IDEOGRAPH
    {0x99DD, 0x6B07}, //4717 #CJK UNIFIED IDEOGRAPH
    {0x99DE, 0x6B08}, //4718 #CJK UNIFIED IDEOGRAPH
    {0x99DF, 0x6B09}, //4719 #CJK UNIFIED IDEOGRAPH
    {0x99E0, 0x6B0A}, //4720 #CJK UNIFIED IDEOGRAPH
    {0x99E1, 0x6B0B}, //4721 #CJK UNIFIED IDEOGRAPH
    {0x99E2, 0x6B0C}, //4722 #CJK UNIFIED IDEOGRAPH
    {0x99E3, 0x6B0D}, //4723 #CJK UNIFIED IDEOGRAPH
    {0x99E4, 0x6B0E}, //4724 #CJK UNIFIED IDEOGRAPH
    {0x99E5, 0x6B0F}, //4725 #CJK UNIFIED IDEOGRAPH
    {0x99E6, 0x6B10}, //4726 #CJK UNIFIED IDEOGRAPH
    {0x99E7, 0x6B11}, //4727 #CJK UNIFIED IDEOGRAPH
    {0x99E8, 0x6B12}, //4728 #CJK UNIFIED IDEOGRAPH
    {0x99E9, 0x6B13}, //4729 #CJK UNIFIED IDEOGRAPH
    {0x99EA, 0x6B14}, //4730 #CJK UNIFIED IDEOGRAPH
    {0x99EB, 0x6B15}, //4731 #CJK UNIFIED IDEOGRAPH
    {0x99EC, 0x6B16}, //4732 #CJK UNIFIED IDEOGRAPH
    {0x99ED, 0x6B17}, //4733 #CJK UNIFIED IDEOGRAPH
    {0x99EE, 0x6B18}, //4734 #CJK UNIFIED IDEOGRAPH
    {0x99EF, 0x6B19}, //4735 #CJK UNIFIED IDEOGRAPH
    {0x99F0, 0x6B1A}, //4736 #CJK UNIFIED IDEOGRAPH
    {0x99F1, 0x6B1B}, //4737 #CJK UNIFIED IDEOGRAPH
    {0x99F2, 0x6B1C}, //4738 #CJK UNIFIED IDEOGRAPH
    {0x99F3, 0x6B1D}, //4739 #CJK UNIFIED IDEOGRAPH
    {0x99F4, 0x6B1E}, //4740 #CJK UNIFIED IDEOGRAPH
    {0x99F5, 0x6B1F}, //4741 #CJK UNIFIED IDEOGRAPH
    {0x99F6, 0x6B25}, //4742 #CJK UNIFIED IDEOGRAPH
    {0x99F7, 0x6B26}, //4743 #CJK UNIFIED IDEOGRAPH
    {0x99F8, 0x6B28}, //4744 #CJK UNIFIED IDEOGRAPH
    {0x99F9, 0x6B29}, //4745 #CJK UNIFIED IDEOGRAPH
    {0x99FA, 0x6B2A}, //4746 #CJK UNIFIED IDEOGRAPH
    {0x99FB, 0x6B2B}, //4747 #CJK UNIFIED IDEOGRAPH
    {0x99FC, 0x6B2C}, //4748 #CJK UNIFIED IDEOGRAPH
    {0x99FD, 0x6B2D}, //4749 #CJK UNIFIED IDEOGRAPH
    {0x99FE, 0x6B2E}, //4750 #CJK UNIFIED IDEOGRAPH
    {0x9A40, 0x6B2F}, //4751 #CJK UNIFIED IDEOGRAPH
    {0x9A41, 0x6B30}, //4752 #CJK UNIFIED IDEOGRAPH
    {0x9A42, 0x6B31}, //4753 #CJK UNIFIED IDEOGRAPH
    {0x9A43, 0x6B33}, //4754 #CJK UNIFIED IDEOGRAPH
    {0x9A44, 0x6B34}, //4755 #CJK UNIFIED IDEOGRAPH
    {0x9A45, 0x6B35}, //4756 #CJK UNIFIED IDEOGRAPH
    {0x9A46, 0x6B36}, //4757 #CJK UNIFIED IDEOGRAPH
    {0x9A47, 0x6B38}, //4758 #CJK UNIFIED IDEOGRAPH
    {0x9A48, 0x6B3B}, //4759 #CJK UNIFIED IDEOGRAPH
    {0x9A49, 0x6B3C}, //4760 #CJK UNIFIED IDEOGRAPH
    {0x9A4A, 0x6B3D}, //4761 #CJK UNIFIED IDEOGRAPH
    {0x9A4B, 0x6B3F}, //4762 #CJK UNIFIED IDEOGRAPH
    {0x9A4C, 0x6B40}, //4763 #CJK UNIFIED IDEOGRAPH
    {0x9A4D, 0x6B41}, //4764 #CJK UNIFIED IDEOGRAPH
    {0x9A4E, 0x6B42}, //4765 #CJK UNIFIED IDEOGRAPH
    {0x9A4F, 0x6B44}, //4766 #CJK UNIFIED IDEOGRAPH
    {0x9A50, 0x6B45}, //4767 #CJK UNIFIED IDEOGRAPH
    {0x9A51, 0x6B48}, //4768 #CJK UNIFIED IDEOGRAPH
    {0x9A52, 0x6B4A}, //4769 #CJK UNIFIED IDEOGRAPH
    {0x9A53, 0x6B4B}, //4770 #CJK UNIFIED IDEOGRAPH
    {0x9A54, 0x6B4D}, //4771 #CJK UNIFIED IDEOGRAPH
    {0x9A55, 0x6B4E}, //4772 #CJK UNIFIED IDEOGRAPH
    {0x9A56, 0x6B4F}, //4773 #CJK UNIFIED IDEOGRAPH
    {0x9A57, 0x6B50}, //4774 #CJK UNIFIED IDEOGRAPH
    {0x9A58, 0x6B51}, //4775 #CJK UNIFIED IDEOGRAPH
    {0x9A59, 0x6B52}, //4776 #CJK UNIFIED IDEOGRAPH
    {0x9A5A, 0x6B53}, //4777 #CJK UNIFIED IDEOGRAPH
    {0x9A5B, 0x6B54}, //4778 #CJK UNIFIED IDEOGRAPH
    {0x9A5C, 0x6B55}, //4779 #CJK UNIFIED IDEOGRAPH
    {0x9A5D, 0x6B56}, //4780 #CJK UNIFIED IDEOGRAPH
    {0x9A5E, 0x6B57}, //4781 #CJK UNIFIED IDEOGRAPH
    {0x9A5F, 0x6B58}, //4782 #CJK UNIFIED IDEOGRAPH
    {0x9A60, 0x6B5A}, //4783 #CJK UNIFIED IDEOGRAPH
    {0x9A61, 0x6B5B}, //4784 #CJK UNIFIED IDEOGRAPH
    {0x9A62, 0x6B5C}, //4785 #CJK UNIFIED IDEOGRAPH
    {0x9A63, 0x6B5D}, //4786 #CJK UNIFIED IDEOGRAPH
    {0x9A64, 0x6B5E}, //4787 #CJK UNIFIED IDEOGRAPH
    {0x9A65, 0x6B5F}, //4788 #CJK UNIFIED IDEOGRAPH
    {0x9A66, 0x6B60}, //4789 #CJK UNIFIED IDEOGRAPH
    {0x9A67, 0x6B61}, //4790 #CJK UNIFIED IDEOGRAPH
    {0x9A68, 0x6B68}, //4791 #CJK UNIFIED IDEOGRAPH
    {0x9A69, 0x6B69}, //4792 #CJK UNIFIED IDEOGRAPH
    {0x9A6A, 0x6B6B}, //4793 #CJK UNIFIED IDEOGRAPH
    {0x9A6B, 0x6B6C}, //4794 #CJK UNIFIED IDEOGRAPH
    {0x9A6C, 0x6B6D}, //4795 #CJK UNIFIED IDEOGRAPH
    {0x9A6D, 0x6B6E}, //4796 #CJK UNIFIED IDEOGRAPH
    {0x9A6E, 0x6B6F}, //4797 #CJK UNIFIED IDEOGRAPH
    {0x9A6F, 0x6B70}, //4798 #CJK UNIFIED IDEOGRAPH
    {0x9A70, 0x6B71}, //4799 #CJK UNIFIED IDEOGRAPH
    {0x9A71, 0x6B72}, //4800 #CJK UNIFIED IDEOGRAPH
    {0x9A72, 0x6B73}, //4801 #CJK UNIFIED IDEOGRAPH
    {0x9A73, 0x6B74}, //4802 #CJK UNIFIED IDEOGRAPH
    {0x9A74, 0x6B75}, //4803 #CJK UNIFIED IDEOGRAPH
    {0x9A75, 0x6B76}, //4804 #CJK UNIFIED IDEOGRAPH
    {0x9A76, 0x6B77}, //4805 #CJK UNIFIED IDEOGRAPH
    {0x9A77, 0x6B78}, //4806 #CJK UNIFIED IDEOGRAPH
    {0x9A78, 0x6B7A}, //4807 #CJK UNIFIED IDEOGRAPH
    {0x9A79, 0x6B7D}, //4808 #CJK UNIFIED IDEOGRAPH
    {0x9A7A, 0x6B7E}, //4809 #CJK UNIFIED IDEOGRAPH
    {0x9A7B, 0x6B7F}, //4810 #CJK UNIFIED IDEOGRAPH
    {0x9A7C, 0x6B80}, //4811 #CJK UNIFIED IDEOGRAPH
    {0x9A7D, 0x6B85}, //4812 #CJK UNIFIED IDEOGRAPH
    {0x9A7E, 0x6B88}, //4813 #CJK UNIFIED IDEOGRAPH
    {0x9A80, 0x6B8C}, //4814 #CJK UNIFIED IDEOGRAPH
    {0x9A81, 0x6B8E}, //4815 #CJK UNIFIED IDEOGRAPH
    {0x9A82, 0x6B8F}, //4816 #CJK UNIFIED IDEOGRAPH
    {0x9A83, 0x6B90}, //4817 #CJK UNIFIED IDEOGRAPH
    {0x9A84, 0x6B91}, //4818 #CJK UNIFIED IDEOGRAPH
    {0x9A85, 0x6B94}, //4819 #CJK UNIFIED IDEOGRAPH
    {0x9A86, 0x6B95}, //4820 #CJK UNIFIED IDEOGRAPH
    {0x9A87, 0x6B97}, //4821 #CJK UNIFIED IDEOGRAPH
    {0x9A88, 0x6B98}, //4822 #CJK UNIFIED IDEOGRAPH
    {0x9A89, 0x6B99}, //4823 #CJK UNIFIED IDEOGRAPH
    {0x9A8A, 0x6B9C}, //4824 #CJK UNIFIED IDEOGRAPH
    {0x9A8B, 0x6B9D}, //4825 #CJK UNIFIED IDEOGRAPH
    {0x9A8C, 0x6B9E}, //4826 #CJK UNIFIED IDEOGRAPH
    {0x9A8D, 0x6B9F}, //4827 #CJK UNIFIED IDEOGRAPH
    {0x9A8E, 0x6BA0}, //4828 #CJK UNIFIED IDEOGRAPH
    {0x9A8F, 0x6BA2}, //4829 #CJK UNIFIED IDEOGRAPH
    {0x9A90, 0x6BA3}, //4830 #CJK UNIFIED IDEOGRAPH
    {0x9A91, 0x6BA4}, //4831 #CJK UNIFIED IDEOGRAPH
    {0x9A92, 0x6BA5}, //4832 #CJK UNIFIED IDEOGRAPH
    {0x9A93, 0x6BA6}, //4833 #CJK UNIFIED IDEOGRAPH
    {0x9A94, 0x6BA7}, //4834 #CJK UNIFIED IDEOGRAPH
    {0x9A95, 0x6BA8}, //4835 #CJK UNIFIED IDEOGRAPH
    {0x9A96, 0x6BA9}, //4836 #CJK UNIFIED IDEOGRAPH
    {0x9A97, 0x6BAB}, //4837 #CJK UNIFIED IDEOGRAPH
    {0x9A98, 0x6BAC}, //4838 #CJK UNIFIED IDEOGRAPH
    {0x9A99, 0x6BAD}, //4839 #CJK UNIFIED IDEOGRAPH
    {0x9A9A, 0x6BAE}, //4840 #CJK UNIFIED IDEOGRAPH
    {0x9A9B, 0x6BAF}, //4841 #CJK UNIFIED IDEOGRAPH
    {0x9A9C, 0x6BB0}, //4842 #CJK UNIFIED IDEOGRAPH
    {0x9A9D, 0x6BB1}, //4843 #CJK UNIFIED IDEOGRAPH
    {0x9A9E, 0x6BB2}, //4844 #CJK UNIFIED IDEOGRAPH
    {0x9A9F, 0x6BB6}, //4845 #CJK UNIFIED IDEOGRAPH
    {0x9AA0, 0x6BB8}, //4846 #CJK UNIFIED IDEOGRAPH
    {0x9AA1, 0x6BB9}, //4847 #CJK UNIFIED IDEOGRAPH
    {0x9AA2, 0x6BBA}, //4848 #CJK UNIFIED IDEOGRAPH
    {0x9AA3, 0x6BBB}, //4849 #CJK UNIFIED IDEOGRAPH
    {0x9AA4, 0x6BBC}, //4850 #CJK UNIFIED IDEOGRAPH
    {0x9AA5, 0x6BBD}, //4851 #CJK UNIFIED IDEOGRAPH
    {0x9AA6, 0x6BBE}, //4852 #CJK UNIFIED IDEOGRAPH
    {0x9AA7, 0x6BC0}, //4853 #CJK UNIFIED IDEOGRAPH
    {0x9AA8, 0x6BC3}, //4854 #CJK UNIFIED IDEOGRAPH
    {0x9AA9, 0x6BC4}, //4855 #CJK UNIFIED IDEOGRAPH
    {0x9AAA, 0x6BC6}, //4856 #CJK UNIFIED IDEOGRAPH
    {0x9AAB, 0x6BC7}, //4857 #CJK UNIFIED IDEOGRAPH
    {0x9AAC, 0x6BC8}, //4858 #CJK UNIFIED IDEOGRAPH
    {0x9AAD, 0x6BC9}, //4859 #CJK UNIFIED IDEOGRAPH
    {0x9AAE, 0x6BCA}, //4860 #CJK UNIFIED IDEOGRAPH
    {0x9AAF, 0x6BCC}, //4861 #CJK UNIFIED IDEOGRAPH
    {0x9AB0, 0x6BCE}, //4862 #CJK UNIFIED IDEOGRAPH
    {0x9AB1, 0x6BD0}, //4863 #CJK UNIFIED IDEOGRAPH
    {0x9AB2, 0x6BD1}, //4864 #CJK UNIFIED IDEOGRAPH
    {0x9AB3, 0x6BD8}, //4865 #CJK UNIFIED IDEOGRAPH
    {0x9AB4, 0x6BDA}, //4866 #CJK UNIFIED IDEOGRAPH
    {0x9AB5, 0x6BDC}, //4867 #CJK UNIFIED IDEOGRAPH
    {0x9AB6, 0x6BDD}, //4868 #CJK UNIFIED IDEOGRAPH
    {0x9AB7, 0x6BDE}, //4869 #CJK UNIFIED IDEOGRAPH
    {0x9AB8, 0x6BDF}, //4870 #CJK UNIFIED IDEOGRAPH
    {0x9AB9, 0x6BE0}, //4871 #CJK UNIFIED IDEOGRAPH
    {0x9ABA, 0x6BE2}, //4872 #CJK UNIFIED IDEOGRAPH
    {0x9ABB, 0x6BE3}, //4873 #CJK UNIFIED IDEOGRAPH
    {0x9ABC, 0x6BE4}, //4874 #CJK UNIFIED IDEOGRAPH
    {0x9ABD, 0x6BE5}, //4875 #CJK UNIFIED IDEOGRAPH
    {0x9ABE, 0x6BE6}, //4876 #CJK UNIFIED IDEOGRAPH
    {0x9ABF, 0x6BE7}, //4877 #CJK UNIFIED IDEOGRAPH
    {0x9AC0, 0x6BE8}, //4878 #CJK UNIFIED IDEOGRAPH
    {0x9AC1, 0x6BE9}, //4879 #CJK UNIFIED IDEOGRAPH
    {0x9AC2, 0x6BEC}, //4880 #CJK UNIFIED IDEOGRAPH
    {0x9AC3, 0x6BED}, //4881 #CJK UNIFIED IDEOGRAPH
    {0x9AC4, 0x6BEE}, //4882 #CJK UNIFIED IDEOGRAPH
    {0x9AC5, 0x6BF0}, //4883 #CJK UNIFIED IDEOGRAPH
    {0x9AC6, 0x6BF1}, //4884 #CJK UNIFIED IDEOGRAPH
    {0x9AC7, 0x6BF2}, //4885 #CJK UNIFIED IDEOGRAPH
    {0x9AC8, 0x6BF4}, //4886 #CJK UNIFIED IDEOGRAPH
    {0x9AC9, 0x6BF6}, //4887 #CJK UNIFIED IDEOGRAPH
    {0x9ACA, 0x6BF7}, //4888 #CJK UNIFIED IDEOGRAPH
    {0x9ACB, 0x6BF8}, //4889 #CJK UNIFIED IDEOGRAPH
    {0x9ACC, 0x6BFA}, //4890 #CJK UNIFIED IDEOGRAPH
    {0x9ACD, 0x6BFB}, //4891 #CJK UNIFIED IDEOGRAPH
    {0x9ACE, 0x6BFC}, //4892 #CJK UNIFIED IDEOGRAPH
    {0x9ACF, 0x6BFE}, //4893 #CJK UNIFIED IDEOGRAPH
    {0x9AD0, 0x6BFF}, //4894 #CJK UNIFIED IDEOGRAPH
    {0x9AD1, 0x6C00}, //4895 #CJK UNIFIED IDEOGRAPH
    {0x9AD2, 0x6C01}, //4896 #CJK UNIFIED IDEOGRAPH
    {0x9AD3, 0x6C02}, //4897 #CJK UNIFIED IDEOGRAPH
    {0x9AD4, 0x6C03}, //4898 #CJK UNIFIED IDEOGRAPH
    {0x9AD5, 0x6C04}, //4899 #CJK UNIFIED IDEOGRAPH
    {0x9AD6, 0x6C08}, //4900 #CJK UNIFIED IDEOGRAPH
    {0x9AD7, 0x6C09}, //4901 #CJK UNIFIED IDEOGRAPH
    {0x9AD8, 0x6C0A}, //4902 #CJK UNIFIED IDEOGRAPH
    {0x9AD9, 0x6C0B}, //4903 #CJK UNIFIED IDEOGRAPH
    {0x9ADA, 0x6C0C}, //4904 #CJK UNIFIED IDEOGRAPH
    {0x9ADB, 0x6C0E}, //4905 #CJK UNIFIED IDEOGRAPH
    {0x9ADC, 0x6C12}, //4906 #CJK UNIFIED IDEOGRAPH
    {0x9ADD, 0x6C17}, //4907 #CJK UNIFIED IDEOGRAPH
    {0x9ADE, 0x6C1C}, //4908 #CJK UNIFIED IDEOGRAPH
    {0x9ADF, 0x6C1D}, //4909 #CJK UNIFIED IDEOGRAPH
    {0x9AE0, 0x6C1E}, //4910 #CJK UNIFIED IDEOGRAPH
    {0x9AE1, 0x6C20}, //4911 #CJK UNIFIED IDEOGRAPH
    {0x9AE2, 0x6C23}, //4912 #CJK UNIFIED IDEOGRAPH
    {0x9AE3, 0x6C25}, //4913 #CJK UNIFIED IDEOGRAPH
    {0x9AE4, 0x6C2B}, //4914 #CJK UNIFIED IDEOGRAPH
    {0x9AE5, 0x6C2C}, //4915 #CJK UNIFIED IDEOGRAPH
    {0x9AE6, 0x6C2D}, //4916 #CJK UNIFIED IDEOGRAPH
    {0x9AE7, 0x6C31}, //4917 #CJK UNIFIED IDEOGRAPH
    {0x9AE8, 0x6C33}, //4918 #CJK UNIFIED IDEOGRAPH
    {0x9AE9, 0x6C36}, //4919 #CJK UNIFIED IDEOGRAPH
    {0x9AEA, 0x6C37}, //4920 #CJK UNIFIED IDEOGRAPH
    {0x9AEB, 0x6C39}, //4921 #CJK UNIFIED IDEOGRAPH
    {0x9AEC, 0x6C3A}, //4922 #CJK UNIFIED IDEOGRAPH
    {0x9AED, 0x6C3B}, //4923 #CJK UNIFIED IDEOGRAPH
    {0x9AEE, 0x6C3C}, //4924 #CJK UNIFIED IDEOGRAPH
    {0x9AEF, 0x6C3E}, //4925 #CJK UNIFIED IDEOGRAPH
    {0x9AF0, 0x6C3F}, //4926 #CJK UNIFIED IDEOGRAPH
    {0x9AF1, 0x6C43}, //4927 #CJK UNIFIED IDEOGRAPH
    {0x9AF2, 0x6C44}, //4928 #CJK UNIFIED IDEOGRAPH
    {0x9AF3, 0x6C45}, //4929 #CJK UNIFIED IDEOGRAPH
    {0x9AF4, 0x6C48}, //4930 #CJK UNIFIED IDEOGRAPH
    {0x9AF5, 0x6C4B}, //4931 #CJK UNIFIED IDEOGRAPH
    {0x9AF6, 0x6C4C}, //4932 #CJK UNIFIED IDEOGRAPH
    {0x9AF7, 0x6C4D}, //4933 #CJK UNIFIED IDEOGRAPH
    {0x9AF8, 0x6C4E}, //4934 #CJK UNIFIED IDEOGRAPH
    {0x9AF9, 0x6C4F}, //4935 #CJK UNIFIED IDEOGRAPH
    {0x9AFA, 0x6C51}, //4936 #CJK UNIFIED IDEOGRAPH
    {0x9AFB, 0x6C52}, //4937 #CJK UNIFIED IDEOGRAPH
    {0x9AFC, 0x6C53}, //4938 #CJK UNIFIED IDEOGRAPH
    {0x9AFD, 0x6C56}, //4939 #CJK UNIFIED IDEOGRAPH
    {0x9AFE, 0x6C58}, //4940 #CJK UNIFIED IDEOGRAPH
    {0x9B40, 0x6C59}, //4941 #CJK UNIFIED IDEOGRAPH
    {0x9B41, 0x6C5A}, //4942 #CJK UNIFIED IDEOGRAPH
    {0x9B42, 0x6C62}, //4943 #CJK UNIFIED IDEOGRAPH
    {0x9B43, 0x6C63}, //4944 #CJK UNIFIED IDEOGRAPH
    {0x9B44, 0x6C65}, //4945 #CJK UNIFIED IDEOGRAPH
    {0x9B45, 0x6C66}, //4946 #CJK UNIFIED IDEOGRAPH
    {0x9B46, 0x6C67}, //4947 #CJK UNIFIED IDEOGRAPH
    {0x9B47, 0x6C6B}, //4948 #CJK UNIFIED IDEOGRAPH
    {0x9B48, 0x6C6C}, //4949 #CJK UNIFIED IDEOGRAPH
    {0x9B49, 0x6C6D}, //4950 #CJK UNIFIED IDEOGRAPH
    {0x9B4A, 0x6C6E}, //4951 #CJK UNIFIED IDEOGRAPH
    {0x9B4B, 0x6C6F}, //4952 #CJK UNIFIED IDEOGRAPH
    {0x9B4C, 0x6C71}, //4953 #CJK UNIFIED IDEOGRAPH
    {0x9B4D, 0x6C73}, //4954 #CJK UNIFIED IDEOGRAPH
    {0x9B4E, 0x6C75}, //4955 #CJK UNIFIED IDEOGRAPH
    {0x9B4F, 0x6C77}, //4956 #CJK UNIFIED IDEOGRAPH
    {0x9B50, 0x6C78}, //4957 #CJK UNIFIED IDEOGRAPH
    {0x9B51, 0x6C7A}, //4958 #CJK UNIFIED IDEOGRAPH
    {0x9B52, 0x6C7B}, //4959 #CJK UNIFIED IDEOGRAPH
    {0x9B53, 0x6C7C}, //4960 #CJK UNIFIED IDEOGRAPH
    {0x9B54, 0x6C7F}, //4961 #CJK UNIFIED IDEOGRAPH
    {0x9B55, 0x6C80}, //4962 #CJK UNIFIED IDEOGRAPH
    {0x9B56, 0x6C84}, //4963 #CJK UNIFIED IDEOGRAPH
    {0x9B57, 0x6C87}, //4964 #CJK UNIFIED IDEOGRAPH
    {0x9B58, 0x6C8A}, //4965 #CJK UNIFIED IDEOGRAPH
    {0x9B59, 0x6C8B}, //4966 #CJK UNIFIED IDEOGRAPH
    {0x9B5A, 0x6C8D}, //4967 #CJK UNIFIED IDEOGRAPH
    {0x9B5B, 0x6C8E}, //4968 #CJK UNIFIED IDEOGRAPH
    {0x9B5C, 0x6C91}, //4969 #CJK UNIFIED IDEOGRAPH
    {0x9B5D, 0x6C92}, //4970 #CJK UNIFIED IDEOGRAPH
    {0x9B5E, 0x6C95}, //4971 #CJK UNIFIED IDEOGRAPH
    {0x9B5F, 0x6C96}, //4972 #CJK UNIFIED IDEOGRAPH
    {0x9B60, 0x6C97}, //4973 #CJK UNIFIED IDEOGRAPH
    {0x9B61, 0x6C98}, //4974 #CJK UNIFIED IDEOGRAPH
    {0x9B62, 0x6C9A}, //4975 #CJK UNIFIED IDEOGRAPH
    {0x9B63, 0x6C9C}, //4976 #CJK UNIFIED IDEOGRAPH
    {0x9B64, 0x6C9D}, //4977 #CJK UNIFIED IDEOGRAPH
    {0x9B65, 0x6C9E}, //4978 #CJK UNIFIED IDEOGRAPH
    {0x9B66, 0x6CA0}, //4979 #CJK UNIFIED IDEOGRAPH
    {0x9B67, 0x6CA2}, //4980 #CJK UNIFIED IDEOGRAPH
    {0x9B68, 0x6CA8}, //4981 #CJK UNIFIED IDEOGRAPH
    {0x9B69, 0x6CAC}, //4982 #CJK UNIFIED IDEOGRAPH
    {0x9B6A, 0x6CAF}, //4983 #CJK UNIFIED IDEOGRAPH
    {0x9B6B, 0x6CB0}, //4984 #CJK UNIFIED IDEOGRAPH
    {0x9B6C, 0x6CB4}, //4985 #CJK UNIFIED IDEOGRAPH
    {0x9B6D, 0x6CB5}, //4986 #CJK UNIFIED IDEOGRAPH
    {0x9B6E, 0x6CB6}, //4987 #CJK UNIFIED IDEOGRAPH
    {0x9B6F, 0x6CB7}, //4988 #CJK UNIFIED IDEOGRAPH
    {0x9B70, 0x6CBA}, //4989 #CJK UNIFIED IDEOGRAPH
    {0x9B71, 0x6CC0}, //4990 #CJK UNIFIED IDEOGRAPH
    {0x9B72, 0x6CC1}, //4991 #CJK UNIFIED IDEOGRAPH
    {0x9B73, 0x6CC2}, //4992 #CJK UNIFIED IDEOGRAPH
    {0x9B74, 0x6CC3}, //4993 #CJK UNIFIED IDEOGRAPH
    {0x9B75, 0x6CC6}, //4994 #CJK UNIFIED IDEOGRAPH
    {0x9B76, 0x6CC7}, //4995 #CJK UNIFIED IDEOGRAPH
    {0x9B77, 0x6CC8}, //4996 #CJK UNIFIED IDEOGRAPH
    {0x9B78, 0x6CCB}, //4997 #CJK UNIFIED IDEOGRAPH
    {0x9B79, 0x6CCD}, //4998 #CJK UNIFIED IDEOGRAPH
    {0x9B7A, 0x6CCE}, //4999 #CJK UNIFIED IDEOGRAPH
    {0x9B7B, 0x6CCF}, //5000 #CJK UNIFIED IDEOGRAPH
    {0x9B7C, 0x6CD1}, //5001 #CJK UNIFIED IDEOGRAPH
    {0x9B7D, 0x6CD2}, //5002 #CJK UNIFIED IDEOGRAPH
    {0x9B7E, 0x6CD8}, //5003 #CJK UNIFIED IDEOGRAPH
    {0x9B80, 0x6CD9}, //5004 #CJK UNIFIED IDEOGRAPH
    {0x9B81, 0x6CDA}, //5005 #CJK UNIFIED IDEOGRAPH
    {0x9B82, 0x6CDC}, //5006 #CJK UNIFIED IDEOGRAPH
    {0x9B83, 0x6CDD}, //5007 #CJK UNIFIED IDEOGRAPH
    {0x9B84, 0x6CDF}, //5008 #CJK UNIFIED IDEOGRAPH
    {0x9B85, 0x6CE4}, //5009 #CJK UNIFIED IDEOGRAPH
    {0x9B86, 0x6CE6}, //5010 #CJK UNIFIED IDEOGRAPH
    {0x9B87, 0x6CE7}, //5011 #CJK UNIFIED IDEOGRAPH
    {0x9B88, 0x6CE9}, //5012 #CJK UNIFIED IDEOGRAPH
    {0x9B89, 0x6CEC}, //5013 #CJK UNIFIED IDEOGRAPH
    {0x9B8A, 0x6CED}, //5014 #CJK UNIFIED IDEOGRAPH
    {0x9B8B, 0x6CF2}, //5015 #CJK UNIFIED IDEOGRAPH
    {0x9B8C, 0x6CF4}, //5016 #CJK UNIFIED IDEOGRAPH
    {0x9B8D, 0x6CF9}, //5017 #CJK UNIFIED IDEOGRAPH
    {0x9B8E, 0x6CFF}, //5018 #CJK UNIFIED IDEOGRAPH
    {0x9B8F, 0x6D00}, //5019 #CJK UNIFIED IDEOGRAPH
    {0x9B90, 0x6D02}, //5020 #CJK UNIFIED IDEOGRAPH
    {0x9B91, 0x6D03}, //5021 #CJK UNIFIED IDEOGRAPH
    {0x9B92, 0x6D05}, //5022 #CJK UNIFIED IDEOGRAPH
    {0x9B93, 0x6D06}, //5023 #CJK UNIFIED IDEOGRAPH
    {0x9B94, 0x6D08}, //5024 #CJK UNIFIED IDEOGRAPH
    {0x9B95, 0x6D09}, //5025 #CJK UNIFIED IDEOGRAPH
    {0x9B96, 0x6D0A}, //5026 #CJK UNIFIED IDEOGRAPH
    {0x9B97, 0x6D0D}, //5027 #CJK UNIFIED IDEOGRAPH
    {0x9B98, 0x6D0F}, //5028 #CJK UNIFIED IDEOGRAPH
    {0x9B99, 0x6D10}, //5029 #CJK UNIFIED IDEOGRAPH
    {0x9B9A, 0x6D11}, //5030 #CJK UNIFIED IDEOGRAPH
    {0x9B9B, 0x6D13}, //5031 #CJK UNIFIED IDEOGRAPH
    {0x9B9C, 0x6D14}, //5032 #CJK UNIFIED IDEOGRAPH
    {0x9B9D, 0x6D15}, //5033 #CJK UNIFIED IDEOGRAPH
    {0x9B9E, 0x6D16}, //5034 #CJK UNIFIED IDEOGRAPH
    {0x9B9F, 0x6D18}, //5035 #CJK UNIFIED IDEOGRAPH
    {0x9BA0, 0x6D1C}, //5036 #CJK UNIFIED IDEOGRAPH
    {0x9BA1, 0x6D1D}, //5037 #CJK UNIFIED IDEOGRAPH
    {0x9BA2, 0x6D1F}, //5038 #CJK UNIFIED IDEOGRAPH
    {0x9BA3, 0x6D20}, //5039 #CJK UNIFIED IDEOGRAPH
    {0x9BA4, 0x6D21}, //5040 #CJK UNIFIED IDEOGRAPH
    {0x9BA5, 0x6D22}, //5041 #CJK UNIFIED IDEOGRAPH
    {0x9BA6, 0x6D23}, //5042 #CJK UNIFIED IDEOGRAPH
    {0x9BA7, 0x6D24}, //5043 #CJK UNIFIED IDEOGRAPH
    {0x9BA8, 0x6D26}, //5044 #CJK UNIFIED IDEOGRAPH
    {0x9BA9, 0x6D28}, //5045 #CJK UNIFIED IDEOGRAPH
    {0x9BAA, 0x6D29}, //5046 #CJK UNIFIED IDEOGRAPH
    {0x9BAB, 0x6D2C}, //5047 #CJK UNIFIED IDEOGRAPH
    {0x9BAC, 0x6D2D}, //5048 #CJK UNIFIED IDEOGRAPH
    {0x9BAD, 0x6D2F}, //5049 #CJK UNIFIED IDEOGRAPH
    {0x9BAE, 0x6D30}, //5050 #CJK UNIFIED IDEOGRAPH
    {0x9BAF, 0x6D34}, //5051 #CJK UNIFIED IDEOGRAPH
    {0x9BB0, 0x6D36}, //5052 #CJK UNIFIED IDEOGRAPH
    {0x9BB1, 0x6D37}, //5053 #CJK UNIFIED IDEOGRAPH
    {0x9BB2, 0x6D38}, //5054 #CJK UNIFIED IDEOGRAPH
    {0x9BB3, 0x6D3A}, //5055 #CJK UNIFIED IDEOGRAPH
    {0x9BB4, 0x6D3F}, //5056 #CJK UNIFIED IDEOGRAPH
    {0x9BB5, 0x6D40}, //5057 #CJK UNIFIED IDEOGRAPH
    {0x9BB6, 0x6D42}, //5058 #CJK UNIFIED IDEOGRAPH
    {0x9BB7, 0x6D44}, //5059 #CJK UNIFIED IDEOGRAPH
    {0x9BB8, 0x6D49}, //5060 #CJK UNIFIED IDEOGRAPH
    {0x9BB9, 0x6D4C}, //5061 #CJK UNIFIED IDEOGRAPH
    {0x9BBA, 0x6D50}, //5062 #CJK UNIFIED IDEOGRAPH
    {0x9BBB, 0x6D55}, //5063 #CJK UNIFIED IDEOGRAPH
    {0x9BBC, 0x6D56}, //5064 #CJK UNIFIED IDEOGRAPH
    {0x9BBD, 0x6D57}, //5065 #CJK UNIFIED IDEOGRAPH
    {0x9BBE, 0x6D58}, //5066 #CJK UNIFIED IDEOGRAPH
    {0x9BBF, 0x6D5B}, //5067 #CJK UNIFIED IDEOGRAPH
    {0x9BC0, 0x6D5D}, //5068 #CJK UNIFIED IDEOGRAPH
    {0x9BC1, 0x6D5F}, //5069 #CJK UNIFIED IDEOGRAPH
    {0x9BC2, 0x6D61}, //5070 #CJK UNIFIED IDEOGRAPH
    {0x9BC3, 0x6D62}, //5071 #CJK UNIFIED IDEOGRAPH
    {0x9BC4, 0x6D64}, //5072 #CJK UNIFIED IDEOGRAPH
    {0x9BC5, 0x6D65}, //5073 #CJK UNIFIED IDEOGRAPH
    {0x9BC6, 0x6D67}, //5074 #CJK UNIFIED IDEOGRAPH
    {0x9BC7, 0x6D68}, //5075 #CJK UNIFIED IDEOGRAPH
    {0x9BC8, 0x6D6B}, //5076 #CJK UNIFIED IDEOGRAPH
    {0x9BC9, 0x6D6C}, //5077 #CJK UNIFIED IDEOGRAPH
    {0x9BCA, 0x6D6D}, //5078 #CJK UNIFIED IDEOGRAPH
    {0x9BCB, 0x6D70}, //5079 #CJK UNIFIED IDEOGRAPH
    {0x9BCC, 0x6D71}, //5080 #CJK UNIFIED IDEOGRAPH
    {0x9BCD, 0x6D72}, //5081 #CJK UNIFIED IDEOGRAPH
    {0x9BCE, 0x6D73}, //5082 #CJK UNIFIED IDEOGRAPH
    {0x9BCF, 0x6D75}, //5083 #CJK UNIFIED IDEOGRAPH
    {0x9BD0, 0x6D76}, //5084 #CJK UNIFIED IDEOGRAPH
    {0x9BD1, 0x6D79}, //5085 #CJK UNIFIED IDEOGRAPH
    {0x9BD2, 0x6D7A}, //5086 #CJK UNIFIED IDEOGRAPH
    {0x9BD3, 0x6D7B}, //5087 #CJK UNIFIED IDEOGRAPH
    {0x9BD4, 0x6D7D}, //5088 #CJK UNIFIED IDEOGRAPH
    {0x9BD5, 0x6D7E}, //5089 #CJK UNIFIED IDEOGRAPH
    {0x9BD6, 0x6D7F}, //5090 #CJK UNIFIED IDEOGRAPH
    {0x9BD7, 0x6D80}, //5091 #CJK UNIFIED IDEOGRAPH
    {0x9BD8, 0x6D81}, //5092 #CJK UNIFIED IDEOGRAPH
    {0x9BD9, 0x6D83}, //5093 #CJK UNIFIED IDEOGRAPH
    {0x9BDA, 0x6D84}, //5094 #CJK UNIFIED IDEOGRAPH
    {0x9BDB, 0x6D86}, //5095 #CJK UNIFIED IDEOGRAPH
    {0x9BDC, 0x6D87}, //5096 #CJK UNIFIED IDEOGRAPH
    {0x9BDD, 0x6D8A}, //5097 #CJK UNIFIED IDEOGRAPH
    {0x9BDE, 0x6D8B}, //5098 #CJK UNIFIED IDEOGRAPH
    {0x9BDF, 0x6D8D}, //5099 #CJK UNIFIED IDEOGRAPH
    {0x9BE0, 0x6D8F}, //5100 #CJK UNIFIED IDEOGRAPH
    {0x9BE1, 0x6D90}, //5101 #CJK UNIFIED IDEOGRAPH
    {0x9BE2, 0x6D92}, //5102 #CJK UNIFIED IDEOGRAPH
    {0x9BE3, 0x6D96}, //5103 #CJK UNIFIED IDEOGRAPH
    {0x9BE4, 0x6D97}, //5104 #CJK UNIFIED IDEOGRAPH
    {0x9BE5, 0x6D98}, //5105 #CJK UNIFIED IDEOGRAPH
    {0x9BE6, 0x6D99}, //5106 #CJK UNIFIED IDEOGRAPH
    {0x9BE7, 0x6D9A}, //5107 #CJK UNIFIED IDEOGRAPH
    {0x9BE8, 0x6D9C}, //5108 #CJK UNIFIED IDEOGRAPH
    {0x9BE9, 0x6DA2}, //5109 #CJK UNIFIED IDEOGRAPH
    {0x9BEA, 0x6DA5}, //5110 #CJK UNIFIED IDEOGRAPH
    {0x9BEB, 0x6DAC}, //5111 #CJK UNIFIED IDEOGRAPH
    {0x9BEC, 0x6DAD}, //5112 #CJK UNIFIED IDEOGRAPH
    {0x9BED, 0x6DB0}, //5113 #CJK UNIFIED IDEOGRAPH
    {0x9BEE, 0x6DB1}, //5114 #CJK UNIFIED IDEOGRAPH
    {0x9BEF, 0x6DB3}, //5115 #CJK UNIFIED IDEOGRAPH
    {0x9BF0, 0x6DB4}, //5116 #CJK UNIFIED IDEOGRAPH
    {0x9BF1, 0x6DB6}, //5117 #CJK UNIFIED IDEOGRAPH
    {0x9BF2, 0x6DB7}, //5118 #CJK UNIFIED IDEOGRAPH
    {0x9BF3, 0x6DB9}, //5119 #CJK UNIFIED IDEOGRAPH
    {0x9BF4, 0x6DBA}, //5120 #CJK UNIFIED IDEOGRAPH
    {0x9BF5, 0x6DBB}, //5121 #CJK UNIFIED IDEOGRAPH
    {0x9BF6, 0x6DBC}, //5122 #CJK UNIFIED IDEOGRAPH
    {0x9BF7, 0x6DBD}, //5123 #CJK UNIFIED IDEOGRAPH
    {0x9BF8, 0x6DBE}, //5124 #CJK UNIFIED IDEOGRAPH
    {0x9BF9, 0x6DC1}, //5125 #CJK UNIFIED IDEOGRAPH
    {0x9BFA, 0x6DC2}, //5126 #CJK UNIFIED IDEOGRAPH
    {0x9BFB, 0x6DC3}, //5127 #CJK UNIFIED IDEOGRAPH
    {0x9BFC, 0x6DC8}, //5128 #CJK UNIFIED IDEOGRAPH
    {0x9BFD, 0x6DC9}, //5129 #CJK UNIFIED IDEOGRAPH
    {0x9BFE, 0x6DCA}, //5130 #CJK UNIFIED IDEOGRAPH
    {0x9C40, 0x6DCD}, //5131 #CJK UNIFIED IDEOGRAPH
    {0x9C41, 0x6DCE}, //5132 #CJK UNIFIED IDEOGRAPH
    {0x9C42, 0x6DCF}, //5133 #CJK UNIFIED IDEOGRAPH
    {0x9C43, 0x6DD0}, //5134 #CJK UNIFIED IDEOGRAPH
    {0x9C44, 0x6DD2}, //5135 #CJK UNIFIED IDEOGRAPH
    {0x9C45, 0x6DD3}, //5136 #CJK UNIFIED IDEOGRAPH
    {0x9C46, 0x6DD4}, //5137 #CJK UNIFIED IDEOGRAPH
    {0x9C47, 0x6DD5}, //5138 #CJK UNIFIED IDEOGRAPH
    {0x9C48, 0x6DD7}, //5139 #CJK UNIFIED IDEOGRAPH
    {0x9C49, 0x6DDA}, //5140 #CJK UNIFIED IDEOGRAPH
    {0x9C4A, 0x6DDB}, //5141 #CJK UNIFIED IDEOGRAPH
    {0x9C4B, 0x6DDC}, //5142 #CJK UNIFIED IDEOGRAPH
    {0x9C4C, 0x6DDF}, //5143 #CJK UNIFIED IDEOGRAPH
    {0x9C4D, 0x6DE2}, //5144 #CJK UNIFIED IDEOGRAPH
    {0x9C4E, 0x6DE3}, //5145 #CJK UNIFIED IDEOGRAPH
    {0x9C4F, 0x6DE5}, //5146 #CJK UNIFIED IDEOGRAPH
    {0x9C50, 0x6DE7}, //5147 #CJK UNIFIED IDEOGRAPH
    {0x9C51, 0x6DE8}, //5148 #CJK UNIFIED IDEOGRAPH
    {0x9C52, 0x6DE9}, //5149 #CJK UNIFIED IDEOGRAPH
    {0x9C53, 0x6DEA}, //5150 #CJK UNIFIED IDEOGRAPH
    {0x9C54, 0x6DED}, //5151 #CJK UNIFIED IDEOGRAPH
    {0x9C55, 0x6DEF}, //5152 #CJK UNIFIED IDEOGRAPH
    {0x9C56, 0x6DF0}, //5153 #CJK UNIFIED IDEOGRAPH
    {0x9C57, 0x6DF2}, //5154 #CJK UNIFIED IDEOGRAPH
    {0x9C58, 0x6DF4}, //5155 #CJK UNIFIED IDEOGRAPH
    {0x9C59, 0x6DF5}, //5156 #CJK UNIFIED IDEOGRAPH
    {0x9C5A, 0x6DF6}, //5157 #CJK UNIFIED IDEOGRAPH
    {0x9C5B, 0x6DF8}, //5158 #CJK UNIFIED IDEOGRAPH
    {0x9C5C, 0x6DFA}, //5159 #CJK UNIFIED IDEOGRAPH
    {0x9C5D, 0x6DFD}, //5160 #CJK UNIFIED IDEOGRAPH
    {0x9C5E, 0x6DFE}, //5161 #CJK UNIFIED IDEOGRAPH
    {0x9C5F, 0x6DFF}, //5162 #CJK UNIFIED IDEOGRAPH
    {0x9C60, 0x6E00}, //5163 #CJK UNIFIED IDEOGRAPH
    {0x9C61, 0x6E01}, //5164 #CJK UNIFIED IDEOGRAPH
    {0x9C62, 0x6E02}, //5165 #CJK UNIFIED IDEOGRAPH
    {0x9C63, 0x6E03}, //5166 #CJK UNIFIED IDEOGRAPH
    {0x9C64, 0x6E04}, //5167 #CJK UNIFIED IDEOGRAPH
    {0x9C65, 0x6E06}, //5168 #CJK UNIFIED IDEOGRAPH
    {0x9C66, 0x6E07}, //5169 #CJK UNIFIED IDEOGRAPH
    {0x9C67, 0x6E08}, //5170 #CJK UNIFIED IDEOGRAPH
    {0x9C68, 0x6E09}, //5171 #CJK UNIFIED IDEOGRAPH
    {0x9C69, 0x6E0B}, //5172 #CJK UNIFIED IDEOGRAPH
    {0x9C6A, 0x6E0F}, //5173 #CJK UNIFIED IDEOGRAPH
    {0x9C6B, 0x6E12}, //5174 #CJK UNIFIED IDEOGRAPH
    {0x9C6C, 0x6E13}, //5175 #CJK UNIFIED IDEOGRAPH
    {0x9C6D, 0x6E15}, //5176 #CJK UNIFIED IDEOGRAPH
    {0x9C6E, 0x6E18}, //5177 #CJK UNIFIED IDEOGRAPH
    {0x9C6F, 0x6E19}, //5178 #CJK UNIFIED IDEOGRAPH
    {0x9C70, 0x6E1B}, //5179 #CJK UNIFIED IDEOGRAPH
    {0x9C71, 0x6E1C}, //5180 #CJK UNIFIED IDEOGRAPH
    {0x9C72, 0x6E1E}, //5181 #CJK UNIFIED IDEOGRAPH
    {0x9C73, 0x6E1F}, //5182 #CJK UNIFIED IDEOGRAPH
    {0x9C74, 0x6E22}, //5183 #CJK UNIFIED IDEOGRAPH
    {0x9C75, 0x6E26}, //5184 #CJK UNIFIED IDEOGRAPH
    {0x9C76, 0x6E27}, //5185 #CJK UNIFIED IDEOGRAPH
    {0x9C77, 0x6E28}, //5186 #CJK UNIFIED IDEOGRAPH
    {0x9C78, 0x6E2A}, //5187 #CJK UNIFIED IDEOGRAPH
    {0x9C79, 0x6E2C}, //5188 #CJK UNIFIED IDEOGRAPH
    {0x9C7A, 0x6E2E}, //5189 #CJK UNIFIED IDEOGRAPH
    {0x9C7B, 0x6E30}, //5190 #CJK UNIFIED IDEOGRAPH
    {0x9C7C, 0x6E31}, //5191 #CJK UNIFIED IDEOGRAPH
    {0x9C7D, 0x6E33}, //5192 #CJK UNIFIED IDEOGRAPH
    {0x9C7E, 0x6E35}, //5193 #CJK UNIFIED IDEOGRAPH
    {0x9C80, 0x6E36}, //5194 #CJK UNIFIED IDEOGRAPH
    {0x9C81, 0x6E37}, //5195 #CJK UNIFIED IDEOGRAPH
    {0x9C82, 0x6E39}, //5196 #CJK UNIFIED IDEOGRAPH
    {0x9C83, 0x6E3B}, //5197 #CJK UNIFIED IDEOGRAPH
    {0x9C84, 0x6E3C}, //5198 #CJK UNIFIED IDEOGRAPH
    {0x9C85, 0x6E3D}, //5199 #CJK UNIFIED IDEOGRAPH
    {0x9C86, 0x6E3E}, //5200 #CJK UNIFIED IDEOGRAPH
    {0x9C87, 0x6E3F}, //5201 #CJK UNIFIED IDEOGRAPH
    {0x9C88, 0x6E40}, //5202 #CJK UNIFIED IDEOGRAPH
    {0x9C89, 0x6E41}, //5203 #CJK UNIFIED IDEOGRAPH
    {0x9C8A, 0x6E42}, //5204 #CJK UNIFIED IDEOGRAPH
    {0x9C8B, 0x6E45}, //5205 #CJK UNIFIED IDEOGRAPH
    {0x9C8C, 0x6E46}, //5206 #CJK UNIFIED IDEOGRAPH
    {0x9C8D, 0x6E47}, //5207 #CJK UNIFIED IDEOGRAPH
    {0x9C8E, 0x6E48}, //5208 #CJK UNIFIED IDEOGRAPH
    {0x9C8F, 0x6E49}, //5209 #CJK UNIFIED IDEOGRAPH
    {0x9C90, 0x6E4A}, //5210 #CJK UNIFIED IDEOGRAPH
    {0x9C91, 0x6E4B}, //5211 #CJK UNIFIED IDEOGRAPH
    {0x9C92, 0x6E4C}, //5212 #CJK UNIFIED IDEOGRAPH
    {0x9C93, 0x6E4F}, //5213 #CJK UNIFIED IDEOGRAPH
    {0x9C94, 0x6E50}, //5214 #CJK UNIFIED IDEOGRAPH
    {0x9C95, 0x6E51}, //5215 #CJK UNIFIED IDEOGRAPH
    {0x9C96, 0x6E52}, //5216 #CJK UNIFIED IDEOGRAPH
    {0x9C97, 0x6E55}, //5217 #CJK UNIFIED IDEOGRAPH
    {0x9C98, 0x6E57}, //5218 #CJK UNIFIED IDEOGRAPH
    {0x9C99, 0x6E59}, //5219 #CJK UNIFIED IDEOGRAPH
    {0x9C9A, 0x6E5A}, //5220 #CJK UNIFIED IDEOGRAPH
    {0x9C9B, 0x6E5C}, //5221 #CJK UNIFIED IDEOGRAPH
    {0x9C9C, 0x6E5D}, //5222 #CJK UNIFIED IDEOGRAPH
    {0x9C9D, 0x6E5E}, //5223 #CJK UNIFIED IDEOGRAPH
    {0x9C9E, 0x6E60}, //5224 #CJK UNIFIED IDEOGRAPH
    {0x9C9F, 0x6E61}, //5225 #CJK UNIFIED IDEOGRAPH
    {0x9CA0, 0x6E62}, //5226 #CJK UNIFIED IDEOGRAPH
    {0x9CA1, 0x6E63}, //5227 #CJK UNIFIED IDEOGRAPH
    {0x9CA2, 0x6E64}, //5228 #CJK UNIFIED IDEOGRAPH
    {0x9CA3, 0x6E65}, //5229 #CJK UNIFIED IDEOGRAPH
    {0x9CA4, 0x6E66}, //5230 #CJK UNIFIED IDEOGRAPH
    {0x9CA5, 0x6E67}, //5231 #CJK UNIFIED IDEOGRAPH
    {0x9CA6, 0x6E68}, //5232 #CJK UNIFIED IDEOGRAPH
    {0x9CA7, 0x6E69}, //5233 #CJK UNIFIED IDEOGRAPH
    {0x9CA8, 0x6E6A}, //5234 #CJK UNIFIED IDEOGRAPH
    {0x9CA9, 0x6E6C}, //5235 #CJK UNIFIED IDEOGRAPH
    {0x9CAA, 0x6E6D}, //5236 #CJK UNIFIED IDEOGRAPH
    {0x9CAB, 0x6E6F}, //5237 #CJK UNIFIED IDEOGRAPH
    {0x9CAC, 0x6E70}, //5238 #CJK UNIFIED IDEOGRAPH
    {0x9CAD, 0x6E71}, //5239 #CJK UNIFIED IDEOGRAPH
    {0x9CAE, 0x6E72}, //5240 #CJK UNIFIED IDEOGRAPH
    {0x9CAF, 0x6E73}, //5241 #CJK UNIFIED IDEOGRAPH
    {0x9CB0, 0x6E74}, //5242 #CJK UNIFIED IDEOGRAPH
    {0x9CB1, 0x6E75}, //5243 #CJK UNIFIED IDEOGRAPH
    {0x9CB2, 0x6E76}, //5244 #CJK UNIFIED IDEOGRAPH
    {0x9CB3, 0x6E77}, //5245 #CJK UNIFIED IDEOGRAPH
    {0x9CB4, 0x6E78}, //5246 #CJK UNIFIED IDEOGRAPH
    {0x9CB5, 0x6E79}, //5247 #CJK UNIFIED IDEOGRAPH
    {0x9CB6, 0x6E7A}, //5248 #CJK UNIFIED IDEOGRAPH
    {0x9CB7, 0x6E7B}, //5249 #CJK UNIFIED IDEOGRAPH
    {0x9CB8, 0x6E7C}, //5250 #CJK UNIFIED IDEOGRAPH
    {0x9CB9, 0x6E7D}, //5251 #CJK UNIFIED IDEOGRAPH
    {0x9CBA, 0x6E80}, //5252 #CJK UNIFIED IDEOGRAPH
    {0x9CBB, 0x6E81}, //5253 #CJK UNIFIED IDEOGRAPH
    {0x9CBC, 0x6E82}, //5254 #CJK UNIFIED IDEOGRAPH
    {0x9CBD, 0x6E84}, //5255 #CJK UNIFIED IDEOGRAPH
    {0x9CBE, 0x6E87}, //5256 #CJK UNIFIED IDEOGRAPH
    {0x9CBF, 0x6E88}, //5257 #CJK UNIFIED IDEOGRAPH
    {0x9CC0, 0x6E8A}, //5258 #CJK UNIFIED IDEOGRAPH
    {0x9CC1, 0x6E8B}, //5259 #CJK UNIFIED IDEOGRAPH
    {0x9CC2, 0x6E8C}, //5260 #CJK UNIFIED IDEOGRAPH
    {0x9CC3, 0x6E8D}, //5261 #CJK UNIFIED IDEOGRAPH
    {0x9CC4, 0x6E8E}, //5262 #CJK UNIFIED IDEOGRAPH
    {0x9CC5, 0x6E91}, //5263 #CJK UNIFIED IDEOGRAPH
    {0x9CC6, 0x6E92}, //5264 #CJK UNIFIED IDEOGRAPH
    {0x9CC7, 0x6E93}, //5265 #CJK UNIFIED IDEOGRAPH
    {0x9CC8, 0x6E94}, //5266 #CJK UNIFIED IDEOGRAPH
    {0x9CC9, 0x6E95}, //5267 #CJK UNIFIED IDEOGRAPH
    {0x9CCA, 0x6E96}, //5268 #CJK UNIFIED IDEOGRAPH
    {0x9CCB, 0x6E97}, //5269 #CJK UNIFIED IDEOGRAPH
    {0x9CCC, 0x6E99}, //5270 #CJK UNIFIED IDEOGRAPH
    {0x9CCD, 0x6E9A}, //5271 #CJK UNIFIED IDEOGRAPH
    {0x9CCE, 0x6E9B}, //5272 #CJK UNIFIED IDEOGRAPH
    {0x9CCF, 0x6E9D}, //5273 #CJK UNIFIED IDEOGRAPH
    {0x9CD0, 0x6E9E}, //5274 #CJK UNIFIED IDEOGRAPH
    {0x9CD1, 0x6EA0}, //5275 #CJK UNIFIED IDEOGRAPH
    {0x9CD2, 0x6EA1}, //5276 #CJK UNIFIED IDEOGRAPH
    {0x9CD3, 0x6EA3}, //5277 #CJK UNIFIED IDEOGRAPH
    {0x9CD4, 0x6EA4}, //5278 #CJK UNIFIED IDEOGRAPH
    {0x9CD5, 0x6EA6}, //5279 #CJK UNIFIED IDEOGRAPH
    {0x9CD6, 0x6EA8}, //5280 #CJK UNIFIED IDEOGRAPH
    {0x9CD7, 0x6EA9}, //5281 #CJK UNIFIED IDEOGRAPH
    {0x9CD8, 0x6EAB}, //5282 #CJK UNIFIED IDEOGRAPH
    {0x9CD9, 0x6EAC}, //5283 #CJK UNIFIED IDEOGRAPH
    {0x9CDA, 0x6EAD}, //5284 #CJK UNIFIED IDEOGRAPH
    {0x9CDB, 0x6EAE}, //5285 #CJK UNIFIED IDEOGRAPH
    {0x9CDC, 0x6EB0}, //5286 #CJK UNIFIED IDEOGRAPH
    {0x9CDD, 0x6EB3}, //5287 #CJK UNIFIED IDEOGRAPH
    {0x9CDE, 0x6EB5}, //5288 #CJK UNIFIED IDEOGRAPH
    {0x9CDF, 0x6EB8}, //5289 #CJK UNIFIED IDEOGRAPH
    {0x9CE0, 0x6EB9}, //5290 #CJK UNIFIED IDEOGRAPH
    {0x9CE1, 0x6EBC}, //5291 #CJK UNIFIED IDEOGRAPH
    {0x9CE2, 0x6EBE}, //5292 #CJK UNIFIED IDEOGRAPH
    {0x9CE3, 0x6EBF}, //5293 #CJK UNIFIED IDEOGRAPH
    {0x9CE4, 0x6EC0}, //5294 #CJK UNIFIED IDEOGRAPH
    {0x9CE5, 0x6EC3}, //5295 #CJK UNIFIED IDEOGRAPH
    {0x9CE6, 0x6EC4}, //5296 #CJK UNIFIED IDEOGRAPH
    {0x9CE7, 0x6EC5}, //5297 #CJK UNIFIED IDEOGRAPH
    {0x9CE8, 0x6EC6}, //5298 #CJK UNIFIED IDEOGRAPH
    {0x9CE9, 0x6EC8}, //5299 #CJK UNIFIED IDEOGRAPH
    {0x9CEA, 0x6EC9}, //5300 #CJK UNIFIED IDEOGRAPH
    {0x9CEB, 0x6ECA}, //5301 #CJK UNIFIED IDEOGRAPH
    {0x9CEC, 0x6ECC}, //5302 #CJK UNIFIED IDEOGRAPH
    {0x9CED, 0x6ECD}, //5303 #CJK UNIFIED IDEOGRAPH
    {0x9CEE, 0x6ECE}, //5304 #CJK UNIFIED IDEOGRAPH
    {0x9CEF, 0x6ED0}, //5305 #CJK UNIFIED IDEOGRAPH
    {0x9CF0, 0x6ED2}, //5306 #CJK UNIFIED IDEOGRAPH
    {0x9CF1, 0x6ED6}, //5307 #CJK UNIFIED IDEOGRAPH
    {0x9CF2, 0x6ED8}, //5308 #CJK UNIFIED IDEOGRAPH
    {0x9CF3, 0x6ED9}, //5309 #CJK UNIFIED IDEOGRAPH
    {0x9CF4, 0x6EDB}, //5310 #CJK UNIFIED IDEOGRAPH
    {0x9CF5, 0x6EDC}, //5311 #CJK UNIFIED IDEOGRAPH
    {0x9CF6, 0x6EDD}, //5312 #CJK UNIFIED IDEOGRAPH
    {0x9CF7, 0x6EE3}, //5313 #CJK UNIFIED IDEOGRAPH
    {0x9CF8, 0x6EE7}, //5314 #CJK UNIFIED IDEOGRAPH
    {0x9CF9, 0x6EEA}, //5315 #CJK UNIFIED IDEOGRAPH
    {0x9CFA, 0x6EEB}, //5316 #CJK UNIFIED IDEOGRAPH
    {0x9CFB, 0x6EEC}, //5317 #CJK UNIFIED IDEOGRAPH
    {0x9CFC, 0x6EED}, //5318 #CJK UNIFIED IDEOGRAPH
    {0x9CFD, 0x6EEE}, //5319 #CJK UNIFIED IDEOGRAPH
    {0x9CFE, 0x6EEF}, //5320 #CJK UNIFIED IDEOGRAPH
    {0x9D40, 0x6EF0}, //5321 #CJK UNIFIED IDEOGRAPH
    {0x9D41, 0x6EF1}, //5322 #CJK UNIFIED IDEOGRAPH
    {0x9D42, 0x6EF2}, //5323 #CJK UNIFIED IDEOGRAPH
    {0x9D43, 0x6EF3}, //5324 #CJK UNIFIED IDEOGRAPH
    {0x9D44, 0x6EF5}, //5325 #CJK UNIFIED IDEOGRAPH
    {0x9D45, 0x6EF6}, //5326 #CJK UNIFIED IDEOGRAPH
    {0x9D46, 0x6EF7}, //5327 #CJK UNIFIED IDEOGRAPH
    {0x9D47, 0x6EF8}, //5328 #CJK UNIFIED IDEOGRAPH
    {0x9D48, 0x6EFA}, //5329 #CJK UNIFIED IDEOGRAPH
    {0x9D49, 0x6EFB}, //5330 #CJK UNIFIED IDEOGRAPH
    {0x9D4A, 0x6EFC}, //5331 #CJK UNIFIED IDEOGRAPH
    {0x9D4B, 0x6EFD}, //5332 #CJK UNIFIED IDEOGRAPH
    {0x9D4C, 0x6EFE}, //5333 #CJK UNIFIED IDEOGRAPH
    {0x9D4D, 0x6EFF}, //5334 #CJK UNIFIED IDEOGRAPH
    {0x9D4E, 0x6F00}, //5335 #CJK UNIFIED IDEOGRAPH
    {0x9D4F, 0x6F01}, //5336 #CJK UNIFIED IDEOGRAPH
    {0x9D50, 0x6F03}, //5337 #CJK UNIFIED IDEOGRAPH
    {0x9D51, 0x6F04}, //5338 #CJK UNIFIED IDEOGRAPH
    {0x9D52, 0x6F05}, //5339 #CJK UNIFIED IDEOGRAPH
    {0x9D53, 0x6F07}, //5340 #CJK UNIFIED IDEOGRAPH
    {0x9D54, 0x6F08}, //5341 #CJK UNIFIED IDEOGRAPH
    {0x9D55, 0x6F0A}, //5342 #CJK UNIFIED IDEOGRAPH
    {0x9D56, 0x6F0B}, //5343 #CJK UNIFIED IDEOGRAPH
    {0x9D57, 0x6F0C}, //5344 #CJK UNIFIED IDEOGRAPH
    {0x9D58, 0x6F0D}, //5345 #CJK UNIFIED IDEOGRAPH
    {0x9D59, 0x6F0E}, //5346 #CJK UNIFIED IDEOGRAPH
    {0x9D5A, 0x6F10}, //5347 #CJK UNIFIED IDEOGRAPH
    {0x9D5B, 0x6F11}, //5348 #CJK UNIFIED IDEOGRAPH
    {0x9D5C, 0x6F12}, //5349 #CJK UNIFIED IDEOGRAPH
    {0x9D5D, 0x6F16}, //5350 #CJK UNIFIED IDEOGRAPH
    {0x9D5E, 0x6F17}, //5351 #CJK UNIFIED IDEOGRAPH
    {0x9D5F, 0x6F18}, //5352 #CJK UNIFIED IDEOGRAPH
    {0x9D60, 0x6F19}, //5353 #CJK UNIFIED IDEOGRAPH
    {0x9D61, 0x6F1A}, //5354 #CJK UNIFIED IDEOGRAPH
    {0x9D62, 0x6F1B}, //5355 #CJK UNIFIED IDEOGRAPH
    {0x9D63, 0x6F1C}, //5356 #CJK UNIFIED IDEOGRAPH
    {0x9D64, 0x6F1D}, //5357 #CJK UNIFIED IDEOGRAPH
    {0x9D65, 0x6F1E}, //5358 #CJK UNIFIED IDEOGRAPH
    {0x9D66, 0x6F1F}, //5359 #CJK UNIFIED IDEOGRAPH
    {0x9D67, 0x6F21}, //5360 #CJK UNIFIED IDEOGRAPH
    {0x9D68, 0x6F22}, //5361 #CJK UNIFIED IDEOGRAPH
    {0x9D69, 0x6F23}, //5362 #CJK UNIFIED IDEOGRAPH
    {0x9D6A, 0x6F25}, //5363 #CJK UNIFIED IDEOGRAPH
    {0x9D6B, 0x6F26}, //5364 #CJK UNIFIED IDEOGRAPH
    {0x9D6C, 0x6F27}, //5365 #CJK UNIFIED IDEOGRAPH
    {0x9D6D, 0x6F28}, //5366 #CJK UNIFIED IDEOGRAPH
    {0x9D6E, 0x6F2C}, //5367 #CJK UNIFIED IDEOGRAPH
    {0x9D6F, 0x6F2E}, //5368 #CJK UNIFIED IDEOGRAPH
    {0x9D70, 0x6F30}, //5369 #CJK UNIFIED IDEOGRAPH
    {0x9D71, 0x6F32}, //5370 #CJK UNIFIED IDEOGRAPH
    {0x9D72, 0x6F34}, //5371 #CJK UNIFIED IDEOGRAPH
    {0x9D73, 0x6F35}, //5372 #CJK UNIFIED IDEOGRAPH
    {0x9D74, 0x6F37}, //5373 #CJK UNIFIED IDEOGRAPH
    {0x9D75, 0x6F38}, //5374 #CJK UNIFIED IDEOGRAPH
    {0x9D76, 0x6F39}, //5375 #CJK UNIFIED IDEOGRAPH
    {0x9D77, 0x6F3A}, //5376 #CJK UNIFIED IDEOGRAPH
    {0x9D78, 0x6F3B}, //5377 #CJK UNIFIED IDEOGRAPH
    {0x9D79, 0x6F3C}, //5378 #CJK UNIFIED IDEOGRAPH
    {0x9D7A, 0x6F3D}, //5379 #CJK UNIFIED IDEOGRAPH
    {0x9D7B, 0x6F3F}, //5380 #CJK UNIFIED IDEOGRAPH
    {0x9D7C, 0x6F40}, //5381 #CJK UNIFIED IDEOGRAPH
    {0x9D7D, 0x6F41}, //5382 #CJK UNIFIED IDEOGRAPH
    {0x9D7E, 0x6F42}, //5383 #CJK UNIFIED IDEOGRAPH
    {0x9D80, 0x6F43}, //5384 #CJK UNIFIED IDEOGRAPH
    {0x9D81, 0x6F44}, //5385 #CJK UNIFIED IDEOGRAPH
    {0x9D82, 0x6F45}, //5386 #CJK UNIFIED IDEOGRAPH
    {0x9D83, 0x6F48}, //5387 #CJK UNIFIED IDEOGRAPH
    {0x9D84, 0x6F49}, //5388 #CJK UNIFIED IDEOGRAPH
    {0x9D85, 0x6F4A}, //5389 #CJK UNIFIED IDEOGRAPH
    {0x9D86, 0x6F4C}, //5390 #CJK UNIFIED IDEOGRAPH
    {0x9D87, 0x6F4E}, //5391 #CJK UNIFIED IDEOGRAPH
    {0x9D88, 0x6F4F}, //5392 #CJK UNIFIED IDEOGRAPH
    {0x9D89, 0x6F50}, //5393 #CJK UNIFIED IDEOGRAPH
    {0x9D8A, 0x6F51}, //5394 #CJK UNIFIED IDEOGRAPH
    {0x9D8B, 0x6F52}, //5395 #CJK UNIFIED IDEOGRAPH
    {0x9D8C, 0x6F53}, //5396 #CJK UNIFIED IDEOGRAPH
    {0x9D8D, 0x6F54}, //5397 #CJK UNIFIED IDEOGRAPH
    {0x9D8E, 0x6F55}, //5398 #CJK UNIFIED IDEOGRAPH
    {0x9D8F, 0x6F56}, //5399 #CJK UNIFIED IDEOGRAPH
    {0x9D90, 0x6F57}, //5400 #CJK UNIFIED IDEOGRAPH
    {0x9D91, 0x6F59}, //5401 #CJK UNIFIED IDEOGRAPH
    {0x9D92, 0x6F5A}, //5402 #CJK UNIFIED IDEOGRAPH
    {0x9D93, 0x6F5B}, //5403 #CJK UNIFIED IDEOGRAPH
    {0x9D94, 0x6F5D}, //5404 #CJK UNIFIED IDEOGRAPH
    {0x9D95, 0x6F5F}, //5405 #CJK UNIFIED IDEOGRAPH
    {0x9D96, 0x6F60}, //5406 #CJK UNIFIED IDEOGRAPH
    {0x9D97, 0x6F61}, //5407 #CJK UNIFIED IDEOGRAPH
    {0x9D98, 0x6F63}, //5408 #CJK UNIFIED IDEOGRAPH
    {0x9D99, 0x6F64}, //5409 #CJK UNIFIED IDEOGRAPH
    {0x9D9A, 0x6F65}, //5410 #CJK UNIFIED IDEOGRAPH
    {0x9D9B, 0x6F67}, //5411 #CJK UNIFIED IDEOGRAPH
    {0x9D9C, 0x6F68}, //5412 #CJK UNIFIED IDEOGRAPH
    {0x9D9D, 0x6F69}, //5413 #CJK UNIFIED IDEOGRAPH
    {0x9D9E, 0x6F6A}, //5414 #CJK UNIFIED IDEOGRAPH
    {0x9D9F, 0x6F6B}, //5415 #CJK UNIFIED IDEOGRAPH
    {0x9DA0, 0x6F6C}, //5416 #CJK UNIFIED IDEOGRAPH
    {0x9DA1, 0x6F6F}, //5417 #CJK UNIFIED IDEOGRAPH
    {0x9DA2, 0x6F70}, //5418 #CJK UNIFIED IDEOGRAPH
    {0x9DA3, 0x6F71}, //5419 #CJK UNIFIED IDEOGRAPH
    {0x9DA4, 0x6F73}, //5420 #CJK UNIFIED IDEOGRAPH
    {0x9DA5, 0x6F75}, //5421 #CJK UNIFIED IDEOGRAPH
    {0x9DA6, 0x6F76}, //5422 #CJK UNIFIED IDEOGRAPH
    {0x9DA7, 0x6F77}, //5423 #CJK UNIFIED IDEOGRAPH
    {0x9DA8, 0x6F79}, //5424 #CJK UNIFIED IDEOGRAPH
    {0x9DA9, 0x6F7B}, //5425 #CJK UNIFIED IDEOGRAPH
    {0x9DAA, 0x6F7D}, //5426 #CJK UNIFIED IDEOGRAPH
    {0x9DAB, 0x6F7E}, //5427 #CJK UNIFIED IDEOGRAPH
    {0x9DAC, 0x6F7F}, //5428 #CJK UNIFIED IDEOGRAPH
    {0x9DAD, 0x6F80}, //5429 #CJK UNIFIED IDEOGRAPH
    {0x9DAE, 0x6F81}, //5430 #CJK UNIFIED IDEOGRAPH
    {0x9DAF, 0x6F82}, //5431 #CJK UNIFIED IDEOGRAPH
    {0x9DB0, 0x6F83}, //5432 #CJK UNIFIED IDEOGRAPH
    {0x9DB1, 0x6F85}, //5433 #CJK UNIFIED IDEOGRAPH
    {0x9DB2, 0x6F86}, //5434 #CJK UNIFIED IDEOGRAPH
    {0x9DB3, 0x6F87}, //5435 #CJK UNIFIED IDEOGRAPH
    {0x9DB4, 0x6F8A}, //5436 #CJK UNIFIED IDEOGRAPH
    {0x9DB5, 0x6F8B}, //5437 #CJK UNIFIED IDEOGRAPH
    {0x9DB6, 0x6F8F}, //5438 #CJK UNIFIED IDEOGRAPH
    {0x9DB7, 0x6F90}, //5439 #CJK UNIFIED IDEOGRAPH
    {0x9DB8, 0x6F91}, //5440 #CJK UNIFIED IDEOGRAPH
    {0x9DB9, 0x6F92}, //5441 #CJK UNIFIED IDEOGRAPH
    {0x9DBA, 0x6F93}, //5442 #CJK UNIFIED IDEOGRAPH
    {0x9DBB, 0x6F94}, //5443 #CJK UNIFIED IDEOGRAPH
    {0x9DBC, 0x6F95}, //5444 #CJK UNIFIED IDEOGRAPH
    {0x9DBD, 0x6F96}, //5445 #CJK UNIFIED IDEOGRAPH
    {0x9DBE, 0x6F97}, //5446 #CJK UNIFIED IDEOGRAPH
    {0x9DBF, 0x6F98}, //5447 #CJK UNIFIED IDEOGRAPH
    {0x9DC0, 0x6F99}, //5448 #CJK UNIFIED IDEOGRAPH
    {0x9DC1, 0x6F9A}, //5449 #CJK UNIFIED IDEOGRAPH
    {0x9DC2, 0x6F9B}, //5450 #CJK UNIFIED IDEOGRAPH
    {0x9DC3, 0x6F9D}, //5451 #CJK UNIFIED IDEOGRAPH
    {0x9DC4, 0x6F9E}, //5452 #CJK UNIFIED IDEOGRAPH
    {0x9DC5, 0x6F9F}, //5453 #CJK UNIFIED IDEOGRAPH
    {0x9DC6, 0x6FA0}, //5454 #CJK UNIFIED IDEOGRAPH
    {0x9DC7, 0x6FA2}, //5455 #CJK UNIFIED IDEOGRAPH
    {0x9DC8, 0x6FA3}, //5456 #CJK UNIFIED IDEOGRAPH
    {0x9DC9, 0x6FA4}, //5457 #CJK UNIFIED IDEOGRAPH
    {0x9DCA, 0x6FA5}, //5458 #CJK UNIFIED IDEOGRAPH
    {0x9DCB, 0x6FA6}, //5459 #CJK UNIFIED IDEOGRAPH
    {0x9DCC, 0x6FA8}, //5460 #CJK UNIFIED IDEOGRAPH
    {0x9DCD, 0x6FA9}, //5461 #CJK UNIFIED IDEOGRAPH
    {0x9DCE, 0x6FAA}, //5462 #CJK UNIFIED IDEOGRAPH
    {0x9DCF, 0x6FAB}, //5463 #CJK UNIFIED IDEOGRAPH
    {0x9DD0, 0x6FAC}, //5464 #CJK UNIFIED IDEOGRAPH
    {0x9DD1, 0x6FAD}, //5465 #CJK UNIFIED IDEOGRAPH
    {0x9DD2, 0x6FAE}, //5466 #CJK UNIFIED IDEOGRAPH
    {0x9DD3, 0x6FAF}, //5467 #CJK UNIFIED IDEOGRAPH
    {0x9DD4, 0x6FB0}, //5468 #CJK UNIFIED IDEOGRAPH
    {0x9DD5, 0x6FB1}, //5469 #CJK UNIFIED IDEOGRAPH
    {0x9DD6, 0x6FB2}, //5470 #CJK UNIFIED IDEOGRAPH
    {0x9DD7, 0x6FB4}, //5471 #CJK UNIFIED IDEOGRAPH
    {0x9DD8, 0x6FB5}, //5472 #CJK UNIFIED IDEOGRAPH
    {0x9DD9, 0x6FB7}, //5473 #CJK UNIFIED IDEOGRAPH
    {0x9DDA, 0x6FB8}, //5474 #CJK UNIFIED IDEOGRAPH
    {0x9DDB, 0x6FBA}, //5475 #CJK UNIFIED IDEOGRAPH
    {0x9DDC, 0x6FBB}, //5476 #CJK UNIFIED IDEOGRAPH
    {0x9DDD, 0x6FBC}, //5477 #CJK UNIFIED IDEOGRAPH
    {0x9DDE, 0x6FBD}, //5478 #CJK UNIFIED IDEOGRAPH
    {0x9DDF, 0x6FBE}, //5479 #CJK UNIFIED IDEOGRAPH
    {0x9DE0, 0x6FBF}, //5480 #CJK UNIFIED IDEOGRAPH
    {0x9DE1, 0x6FC1}, //5481 #CJK UNIFIED IDEOGRAPH
    {0x9DE2, 0x6FC3}, //5482 #CJK UNIFIED IDEOGRAPH
    {0x9DE3, 0x6FC4}, //5483 #CJK UNIFIED IDEOGRAPH
    {0x9DE4, 0x6FC5}, //5484 #CJK UNIFIED IDEOGRAPH
    {0x9DE5, 0x6FC6}, //5485 #CJK UNIFIED IDEOGRAPH
    {0x9DE6, 0x6FC7}, //5486 #CJK UNIFIED IDEOGRAPH
    {0x9DE7, 0x6FC8}, //5487 #CJK UNIFIED IDEOGRAPH
    {0x9DE8, 0x6FCA}, //5488 #CJK UNIFIED IDEOGRAPH
    {0x9DE9, 0x6FCB}, //5489 #CJK UNIFIED IDEOGRAPH
    {0x9DEA, 0x6FCC}, //5490 #CJK UNIFIED IDEOGRAPH
    {0x9DEB, 0x6FCD}, //5491 #CJK UNIFIED IDEOGRAPH
    {0x9DEC, 0x6FCE}, //5492 #CJK UNIFIED IDEOGRAPH
    {0x9DED, 0x6FCF}, //5493 #CJK UNIFIED IDEOGRAPH
    {0x9DEE, 0x6FD0}, //5494 #CJK UNIFIED IDEOGRAPH
    {0x9DEF, 0x6FD3}, //5495 #CJK UNIFIED IDEOGRAPH
    {0x9DF0, 0x6FD4}, //5496 #CJK UNIFIED IDEOGRAPH
    {0x9DF1, 0x6FD5}, //5497 #CJK UNIFIED IDEOGRAPH
    {0x9DF2, 0x6FD6}, //5498 #CJK UNIFIED IDEOGRAPH
    {0x9DF3, 0x6FD7}, //5499 #CJK UNIFIED IDEOGRAPH
    {0x9DF4, 0x6FD8}, //5500 #CJK UNIFIED IDEOGRAPH
    {0x9DF5, 0x6FD9}, //5501 #CJK UNIFIED IDEOGRAPH
    {0x9DF6, 0x6FDA}, //5502 #CJK UNIFIED IDEOGRAPH
    {0x9DF7, 0x6FDB}, //5503 #CJK UNIFIED IDEOGRAPH
    {0x9DF8, 0x6FDC}, //5504 #CJK UNIFIED IDEOGRAPH
    {0x9DF9, 0x6FDD}, //5505 #CJK UNIFIED IDEOGRAPH
    {0x9DFA, 0x6FDF}, //5506 #CJK UNIFIED IDEOGRAPH
    {0x9DFB, 0x6FE2}, //5507 #CJK UNIFIED IDEOGRAPH
    {0x9DFC, 0x6FE3}, //5508 #CJK UNIFIED IDEOGRAPH
    {0x9DFD, 0x6FE4}, //5509 #CJK UNIFIED IDEOGRAPH
    {0x9DFE, 0x6FE5}, //5510 #CJK UNIFIED IDEOGRAPH
    {0x9E40, 0x6FE6}, //5511 #CJK UNIFIED IDEOGRAPH
    {0x9E41, 0x6FE7}, //5512 #CJK UNIFIED IDEOGRAPH
    {0x9E42, 0x6FE8}, //5513 #CJK UNIFIED IDEOGRAPH
    {0x9E43, 0x6FE9}, //5514 #CJK UNIFIED IDEOGRAPH
    {0x9E44, 0x6FEA}, //5515 #CJK UNIFIED IDEOGRAPH
    {0x9E45, 0x6FEB}, //5516 #CJK UNIFIED IDEOGRAPH
    {0x9E46, 0x6FEC}, //5517 #CJK UNIFIED IDEOGRAPH
    {0x9E47, 0x6FED}, //5518 #CJK UNIFIED IDEOGRAPH
    {0x9E48, 0x6FF0}, //5519 #CJK UNIFIED IDEOGRAPH
    {0x9E49, 0x6FF1}, //5520 #CJK UNIFIED IDEOGRAPH
    {0x9E4A, 0x6FF2}, //5521 #CJK UNIFIED IDEOGRAPH
    {0x9E4B, 0x6FF3}, //5522 #CJK UNIFIED IDEOGRAPH
    {0x9E4C, 0x6FF4}, //5523 #CJK UNIFIED IDEOGRAPH
    {0x9E4D, 0x6FF5}, //5524 #CJK UNIFIED IDEOGRAPH
    {0x9E4E, 0x6FF6}, //5525 #CJK UNIFIED IDEOGRAPH
    {0x9E4F, 0x6FF7}, //5526 #CJK UNIFIED IDEOGRAPH
    {0x9E50, 0x6FF8}, //5527 #CJK UNIFIED IDEOGRAPH
    {0x9E51, 0x6FF9}, //5528 #CJK UNIFIED IDEOGRAPH
    {0x9E52, 0x6FFA}, //5529 #CJK UNIFIED IDEOGRAPH
    {0x9E53, 0x6FFB}, //5530 #CJK UNIFIED IDEOGRAPH
    {0x9E54, 0x6FFC}, //5531 #CJK UNIFIED IDEOGRAPH
    {0x9E55, 0x6FFD}, //5532 #CJK UNIFIED IDEOGRAPH
    {0x9E56, 0x6FFE}, //5533 #CJK UNIFIED IDEOGRAPH
    {0x9E57, 0x6FFF}, //5534 #CJK UNIFIED IDEOGRAPH
    {0x9E58, 0x7000}, //5535 #CJK UNIFIED IDEOGRAPH
    {0x9E59, 0x7001}, //5536 #CJK UNIFIED IDEOGRAPH
    {0x9E5A, 0x7002}, //5537 #CJK UNIFIED IDEOGRAPH
    {0x9E5B, 0x7003}, //5538 #CJK UNIFIED IDEOGRAPH
    {0x9E5C, 0x7004}, //5539 #CJK UNIFIED IDEOGRAPH
    {0x9E5D, 0x7005}, //5540 #CJK UNIFIED IDEOGRAPH
    {0x9E5E, 0x7006}, //5541 #CJK UNIFIED IDEOGRAPH
    {0x9E5F, 0x7007}, //5542 #CJK UNIFIED IDEOGRAPH
    {0x9E60, 0x7008}, //5543 #CJK UNIFIED IDEOGRAPH
    {0x9E61, 0x7009}, //5544 #CJK UNIFIED IDEOGRAPH
    {0x9E62, 0x700A}, //5545 #CJK UNIFIED IDEOGRAPH
    {0x9E63, 0x700B}, //5546 #CJK UNIFIED IDEOGRAPH
    {0x9E64, 0x700C}, //5547 #CJK UNIFIED IDEOGRAPH
    {0x9E65, 0x700D}, //5548 #CJK UNIFIED IDEOGRAPH
    {0x9E66, 0x700E}, //5549 #CJK UNIFIED IDEOGRAPH
    {0x9E67, 0x700F}, //5550 #CJK UNIFIED IDEOGRAPH
    {0x9E68, 0x7010}, //5551 #CJK UNIFIED IDEOGRAPH
    {0x9E69, 0x7012}, //5552 #CJK UNIFIED IDEOGRAPH
    {0x9E6A, 0x7013}, //5553 #CJK UNIFIED IDEOGRAPH
    {0x9E6B, 0x7014}, //5554 #CJK UNIFIED IDEOGRAPH
    {0x9E6C, 0x7015}, //5555 #CJK UNIFIED IDEOGRAPH
    {0x9E6D, 0x7016}, //5556 #CJK UNIFIED IDEOGRAPH
    {0x9E6E, 0x7017}, //5557 #CJK UNIFIED IDEOGRAPH
    {0x9E6F, 0x7018}, //5558 #CJK UNIFIED IDEOGRAPH
    {0x9E70, 0x7019}, //5559 #CJK UNIFIED IDEOGRAPH
    {0x9E71, 0x701C}, //5560 #CJK UNIFIED IDEOGRAPH
    {0x9E72, 0x701D}, //5561 #CJK UNIFIED IDEOGRAPH
    {0x9E73, 0x701E}, //5562 #CJK UNIFIED IDEOGRAPH
    {0x9E74, 0x701F}, //5563 #CJK UNIFIED IDEOGRAPH
    {0x9E75, 0x7020}, //5564 #CJK UNIFIED IDEOGRAPH
    {0x9E76, 0x7021}, //5565 #CJK UNIFIED IDEOGRAPH
    {0x9E77, 0x7022}, //5566 #CJK UNIFIED IDEOGRAPH
    {0x9E78, 0x7024}, //5567 #CJK UNIFIED IDEOGRAPH
    {0x9E79, 0x7025}, //5568 #CJK UNIFIED IDEOGRAPH
    {0x9E7A, 0x7026}, //5569 #CJK UNIFIED IDEOGRAPH
    {0x9E7B, 0x7027}, //5570 #CJK UNIFIED IDEOGRAPH
    {0x9E7C, 0x7028}, //5571 #CJK UNIFIED IDEOGRAPH
    {0x9E7D, 0x7029}, //5572 #CJK UNIFIED IDEOGRAPH
    {0x9E7E, 0x702A}, //5573 #CJK UNIFIED IDEOGRAPH
    {0x9E80, 0x702B}, //5574 #CJK UNIFIED IDEOGRAPH
    {0x9E81, 0x702C}, //5575 #CJK UNIFIED IDEOGRAPH
    {0x9E82, 0x702D}, //5576 #CJK UNIFIED IDEOGRAPH
    {0x9E83, 0x702E}, //5577 #CJK UNIFIED IDEOGRAPH
    {0x9E84, 0x702F}, //5578 #CJK UNIFIED IDEOGRAPH
    {0x9E85, 0x7030}, //5579 #CJK UNIFIED IDEOGRAPH
    {0x9E86, 0x7031}, //5580 #CJK UNIFIED IDEOGRAPH
    {0x9E87, 0x7032}, //5581 #CJK UNIFIED IDEOGRAPH
    {0x9E88, 0x7033}, //5582 #CJK UNIFIED IDEOGRAPH
    {0x9E89, 0x7034}, //5583 #CJK UNIFIED IDEOGRAPH
    {0x9E8A, 0x7036}, //5584 #CJK UNIFIED IDEOGRAPH
    {0x9E8B, 0x7037}, //5585 #CJK UNIFIED IDEOGRAPH
    {0x9E8C, 0x7038}, //5586 #CJK UNIFIED IDEOGRAPH
    {0x9E8D, 0x703A}, //5587 #CJK UNIFIED IDEOGRAPH
    {0x9E8E, 0x703B}, //5588 #CJK UNIFIED IDEOGRAPH
    {0x9E8F, 0x703C}, //5589 #CJK UNIFIED IDEOGRAPH
    {0x9E90, 0x703D}, //5590 #CJK UNIFIED IDEOGRAPH
    {0x9E91, 0x703E}, //5591 #CJK UNIFIED IDEOGRAPH
    {0x9E92, 0x703F}, //5592 #CJK UNIFIED IDEOGRAPH
    {0x9E93, 0x7040}, //5593 #CJK UNIFIED IDEOGRAPH
    {0x9E94, 0x7041}, //5594 #CJK UNIFIED IDEOGRAPH
    {0x9E95, 0x7042}, //5595 #CJK UNIFIED IDEOGRAPH
    {0x9E96, 0x7043}, //5596 #CJK UNIFIED IDEOGRAPH
    {0x9E97, 0x7044}, //5597 #CJK UNIFIED IDEOGRAPH
    {0x9E98, 0x7045}, //5598 #CJK UNIFIED IDEOGRAPH
    {0x9E99, 0x7046}, //5599 #CJK UNIFIED IDEOGRAPH
    {0x9E9A, 0x7047}, //5600 #CJK UNIFIED IDEOGRAPH
    {0x9E9B, 0x7048}, //5601 #CJK UNIFIED IDEOGRAPH
    {0x9E9C, 0x7049}, //5602 #CJK UNIFIED IDEOGRAPH
    {0x9E9D, 0x704A}, //5603 #CJK UNIFIED IDEOGRAPH
    {0x9E9E, 0x704B}, //5604 #CJK UNIFIED IDEOGRAPH
    {0x9E9F, 0x704D}, //5605 #CJK UNIFIED IDEOGRAPH
    {0x9EA0, 0x704E}, //5606 #CJK UNIFIED IDEOGRAPH
    {0x9EA1, 0x7050}, //5607 #CJK UNIFIED IDEOGRAPH
    {0x9EA2, 0x7051}, //5608 #CJK UNIFIED IDEOGRAPH
    {0x9EA3, 0x7052}, //5609 #CJK UNIFIED IDEOGRAPH
    {0x9EA4, 0x7053}, //5610 #CJK UNIFIED IDEOGRAPH
    {0x9EA5, 0x7054}, //5611 #CJK UNIFIED IDEOGRAPH
    {0x9EA6, 0x7055}, //5612 #CJK UNIFIED IDEOGRAPH
    {0x9EA7, 0x7056}, //5613 #CJK UNIFIED IDEOGRAPH
    {0x9EA8, 0x7057}, //5614 #CJK UNIFIED IDEOGRAPH
    {0x9EA9, 0x7058}, //5615 #CJK UNIFIED IDEOGRAPH
    {0x9EAA, 0x7059}, //5616 #CJK UNIFIED IDEOGRAPH
    {0x9EAB, 0x705A}, //5617 #CJK UNIFIED IDEOGRAPH
    {0x9EAC, 0x705B}, //5618 #CJK UNIFIED IDEOGRAPH
    {0x9EAD, 0x705C}, //5619 #CJK UNIFIED IDEOGRAPH
    {0x9EAE, 0x705D}, //5620 #CJK UNIFIED IDEOGRAPH
    {0x9EAF, 0x705F}, //5621 #CJK UNIFIED IDEOGRAPH
    {0x9EB0, 0x7060}, //5622 #CJK UNIFIED IDEOGRAPH
    {0x9EB1, 0x7061}, //5623 #CJK UNIFIED IDEOGRAPH
    {0x9EB2, 0x7062}, //5624 #CJK UNIFIED IDEOGRAPH
    {0x9EB3, 0x7063}, //5625 #CJK UNIFIED IDEOGRAPH
    {0x9EB4, 0x7064}, //5626 #CJK UNIFIED IDEOGRAPH
    {0x9EB5, 0x7065}, //5627 #CJK UNIFIED IDEOGRAPH
    {0x9EB6, 0x7066}, //5628 #CJK UNIFIED IDEOGRAPH
    {0x9EB7, 0x7067}, //5629 #CJK UNIFIED IDEOGRAPH
    {0x9EB8, 0x7068}, //5630 #CJK UNIFIED IDEOGRAPH
    {0x9EB9, 0x7069}, //5631 #CJK UNIFIED IDEOGRAPH
    {0x9EBA, 0x706A}, //5632 #CJK UNIFIED IDEOGRAPH
    {0x9EBB, 0x706E}, //5633 #CJK UNIFIED IDEOGRAPH
    {0x9EBC, 0x7071}, //5634 #CJK UNIFIED IDEOGRAPH
    {0x9EBD, 0x7072}, //5635 #CJK UNIFIED IDEOGRAPH
    {0x9EBE, 0x7073}, //5636 #CJK UNIFIED IDEOGRAPH
    {0x9EBF, 0x7074}, //5637 #CJK UNIFIED IDEOGRAPH
    {0x9EC0, 0x7077}, //5638 #CJK UNIFIED IDEOGRAPH
    {0x9EC1, 0x7079}, //5639 #CJK UNIFIED IDEOGRAPH
    {0x9EC2, 0x707A}, //5640 #CJK UNIFIED IDEOGRAPH
    {0x9EC3, 0x707B}, //5641 #CJK UNIFIED IDEOGRAPH
    {0x9EC4, 0x707D}, //5642 #CJK UNIFIED IDEOGRAPH
    {0x9EC5, 0x7081}, //5643 #CJK UNIFIED IDEOGRAPH
    {0x9EC6, 0x7082}, //5644 #CJK UNIFIED IDEOGRAPH
    {0x9EC7, 0x7083}, //5645 #CJK UNIFIED IDEOGRAPH
    {0x9EC8, 0x7084}, //5646 #CJK UNIFIED IDEOGRAPH
    {0x9EC9, 0x7086}, //5647 #CJK UNIFIED IDEOGRAPH
    {0x9ECA, 0x7087}, //5648 #CJK UNIFIED IDEOGRAPH
    {0x9ECB, 0x7088}, //5649 #CJK UNIFIED IDEOGRAPH
    {0x9ECC, 0x708B}, //5650 #CJK UNIFIED IDEOGRAPH
    {0x9ECD, 0x708C}, //5651 #CJK UNIFIED IDEOGRAPH
    {0x9ECE, 0x708D}, //5652 #CJK UNIFIED IDEOGRAPH
    {0x9ECF, 0x708F}, //5653 #CJK UNIFIED IDEOGRAPH
    {0x9ED0, 0x7090}, //5654 #CJK UNIFIED IDEOGRAPH
    {0x9ED1, 0x7091}, //5655 #CJK UNIFIED IDEOGRAPH
    {0x9ED2, 0x7093}, //5656 #CJK UNIFIED IDEOGRAPH
    {0x9ED3, 0x7097}, //5657 #CJK UNIFIED IDEOGRAPH
    {0x9ED4, 0x7098}, //5658 #CJK UNIFIED IDEOGRAPH
    {0x9ED5, 0x709A}, //5659 #CJK UNIFIED IDEOGRAPH
    {0x9ED6, 0x709B}, //5660 #CJK UNIFIED IDEOGRAPH
    {0x9ED7, 0x709E}, //5661 #CJK UNIFIED IDEOGRAPH
    {0x9ED8, 0x709F}, //5662 #CJK UNIFIED IDEOGRAPH
    {0x9ED9, 0x70A0}, //5663 #CJK UNIFIED IDEOGRAPH
    {0x9EDA, 0x70A1}, //5664 #CJK UNIFIED IDEOGRAPH
    {0x9EDB, 0x70A2}, //5665 #CJK UNIFIED IDEOGRAPH
    {0x9EDC, 0x70A3}, //5666 #CJK UNIFIED IDEOGRAPH
    {0x9EDD, 0x70A4}, //5667 #CJK UNIFIED IDEOGRAPH
    {0x9EDE, 0x70A5}, //5668 #CJK UNIFIED IDEOGRAPH
    {0x9EDF, 0x70A6}, //5669 #CJK UNIFIED IDEOGRAPH
    {0x9EE0, 0x70A7}, //5670 #CJK UNIFIED IDEOGRAPH
    {0x9EE1, 0x70A8}, //5671 #CJK UNIFIED IDEOGRAPH
    {0x9EE2, 0x70A9}, //5672 #CJK UNIFIED IDEOGRAPH
    {0x9EE3, 0x70AA}, //5673 #CJK UNIFIED IDEOGRAPH
    {0x9EE4, 0x70B0}, //5674 #CJK UNIFIED IDEOGRAPH
    {0x9EE5, 0x70B2}, //5675 #CJK UNIFIED IDEOGRAPH
    {0x9EE6, 0x70B4}, //5676 #CJK UNIFIED IDEOGRAPH
    {0x9EE7, 0x70B5}, //5677 #CJK UNIFIED IDEOGRAPH
    {0x9EE8, 0x70B6}, //5678 #CJK UNIFIED IDEOGRAPH
    {0x9EE9, 0x70BA}, //5679 #CJK UNIFIED IDEOGRAPH
    {0x9EEA, 0x70BE}, //5680 #CJK UNIFIED IDEOGRAPH
    {0x9EEB, 0x70BF}, //5681 #CJK UNIFIED IDEOGRAPH
    {0x9EEC, 0x70C4}, //5682 #CJK UNIFIED IDEOGRAPH
    {0x9EED, 0x70C5}, //5683 #CJK UNIFIED IDEOGRAPH
    {0x9EEE, 0x70C6}, //5684 #CJK UNIFIED IDEOGRAPH
    {0x9EEF, 0x70C7}, //5685 #CJK UNIFIED IDEOGRAPH
    {0x9EF0, 0x70C9}, //5686 #CJK UNIFIED IDEOGRAPH
    {0x9EF1, 0x70CB}, //5687 #CJK UNIFIED IDEOGRAPH
    {0x9EF2, 0x70CC}, //5688 #CJK UNIFIED IDEOGRAPH
    {0x9EF3, 0x70CD}, //5689 #CJK UNIFIED IDEOGRAPH
    {0x9EF4, 0x70CE}, //5690 #CJK UNIFIED IDEOGRAPH
    {0x9EF5, 0x70CF}, //5691 #CJK UNIFIED IDEOGRAPH
    {0x9EF6, 0x70D0}, //5692 #CJK UNIFIED IDEOGRAPH
    {0x9EF7, 0x70D1}, //5693 #CJK UNIFIED IDEOGRAPH
    {0x9EF8, 0x70D2}, //5694 #CJK UNIFIED IDEOGRAPH
    {0x9EF9, 0x70D3}, //5695 #CJK UNIFIED IDEOGRAPH
    {0x9EFA, 0x70D4}, //5696 #CJK UNIFIED IDEOGRAPH
    {0x9EFB, 0x70D5}, //5697 #CJK UNIFIED IDEOGRAPH
    {0x9EFC, 0x70D6}, //5698 #CJK UNIFIED IDEOGRAPH
    {0x9EFD, 0x70D7}, //5699 #CJK UNIFIED IDEOGRAPH
    {0x9EFE, 0x70DA}, //5700 #CJK UNIFIED IDEOGRAPH
    {0x9F40, 0x70DC}, //5701 #CJK UNIFIED IDEOGRAPH
    {0x9F41, 0x70DD}, //5702 #CJK UNIFIED IDEOGRAPH
    {0x9F42, 0x70DE}, //5703 #CJK UNIFIED IDEOGRAPH
    {0x9F43, 0x70E0}, //5704 #CJK UNIFIED IDEOGRAPH
    {0x9F44, 0x70E1}, //5705 #CJK UNIFIED IDEOGRAPH
    {0x9F45, 0x70E2}, //5706 #CJK UNIFIED IDEOGRAPH
    {0x9F46, 0x70E3}, //5707 #CJK UNIFIED IDEOGRAPH
    {0x9F47, 0x70E5}, //5708 #CJK UNIFIED IDEOGRAPH
    {0x9F48, 0x70EA}, //5709 #CJK UNIFIED IDEOGRAPH
    {0x9F49, 0x70EE}, //5710 #CJK UNIFIED IDEOGRAPH
    {0x9F4A, 0x70F0}, //5711 #CJK UNIFIED IDEOGRAPH
    {0x9F4B, 0x70F1}, //5712 #CJK UNIFIED IDEOGRAPH
    {0x9F4C, 0x70F2}, //5713 #CJK UNIFIED IDEOGRAPH
    {0x9F4D, 0x70F3}, //5714 #CJK UNIFIED IDEOGRAPH
    {0x9F4E, 0x70F4}, //5715 #CJK UNIFIED IDEOGRAPH
    {0x9F4F, 0x70F5}, //5716 #CJK UNIFIED IDEOGRAPH
    {0x9F50, 0x70F6}, //5717 #CJK UNIFIED IDEOGRAPH
    {0x9F51, 0x70F8}, //5718 #CJK UNIFIED IDEOGRAPH
    {0x9F52, 0x70FA}, //5719 #CJK UNIFIED IDEOGRAPH
    {0x9F53, 0x70FB}, //5720 #CJK UNIFIED IDEOGRAPH
    {0x9F54, 0x70FC}, //5721 #CJK UNIFIED IDEOGRAPH
    {0x9F55, 0x70FE}, //5722 #CJK UNIFIED IDEOGRAPH
    {0x9F56, 0x70FF}, //5723 #CJK UNIFIED IDEOGRAPH
    {0x9F57, 0x7100}, //5724 #CJK UNIFIED IDEOGRAPH
    {0x9F58, 0x7101}, //5725 #CJK UNIFIED IDEOGRAPH
    {0x9F59, 0x7102}, //5726 #CJK UNIFIED IDEOGRAPH
    {0x9F5A, 0x7103}, //5727 #CJK UNIFIED IDEOGRAPH
    {0x9F5B, 0x7104}, //5728 #CJK UNIFIED IDEOGRAPH
    {0x9F5C, 0x7105}, //5729 #CJK UNIFIED IDEOGRAPH
    {0x9F5D, 0x7106}, //5730 #CJK UNIFIED IDEOGRAPH
    {0x9F5E, 0x7107}, //5731 #CJK UNIFIED IDEOGRAPH
    {0x9F5F, 0x7108}, //5732 #CJK UNIFIED IDEOGRAPH
    {0x9F60, 0x710B}, //5733 #CJK UNIFIED IDEOGRAPH
    {0x9F61, 0x710C}, //5734 #CJK UNIFIED IDEOGRAPH
    {0x9F62, 0x710D}, //5735 #CJK UNIFIED IDEOGRAPH
    {0x9F63, 0x710E}, //5736 #CJK UNIFIED IDEOGRAPH
    {0x9F64, 0x710F}, //5737 #CJK UNIFIED IDEOGRAPH
    {0x9F65, 0x7111}, //5738 #CJK UNIFIED IDEOGRAPH
    {0x9F66, 0x7112}, //5739 #CJK UNIFIED IDEOGRAPH
    {0x9F67, 0x7114}, //5740 #CJK UNIFIED IDEOGRAPH
    {0x9F68, 0x7117}, //5741 #CJK UNIFIED IDEOGRAPH
    {0x9F69, 0x711B}, //5742 #CJK UNIFIED IDEOGRAPH
    {0x9F6A, 0x711C}, //5743 #CJK UNIFIED IDEOGRAPH
    {0x9F6B, 0x711D}, //5744 #CJK UNIFIED IDEOGRAPH
    {0x9F6C, 0x711E}, //5745 #CJK UNIFIED IDEOGRAPH
    {0x9F6D, 0x711F}, //5746 #CJK UNIFIED IDEOGRAPH
    {0x9F6E, 0x7120}, //5747 #CJK UNIFIED IDEOGRAPH
    {0x9F6F, 0x7121}, //5748 #CJK UNIFIED IDEOGRAPH
    {0x9F70, 0x7122}, //5749 #CJK UNIFIED IDEOGRAPH
    {0x9F71, 0x7123}, //5750 #CJK UNIFIED IDEOGRAPH
    {0x9F72, 0x7124}, //5751 #CJK UNIFIED IDEOGRAPH
    {0x9F73, 0x7125}, //5752 #CJK UNIFIED IDEOGRAPH
    {0x9F74, 0x7127}, //5753 #CJK UNIFIED IDEOGRAPH
    {0x9F75, 0x7128}, //5754 #CJK UNIFIED IDEOGRAPH
    {0x9F76, 0x7129}, //5755 #CJK UNIFIED IDEOGRAPH
    {0x9F77, 0x712A}, //5756 #CJK UNIFIED IDEOGRAPH
    {0x9F78, 0x712B}, //5757 #CJK UNIFIED IDEOGRAPH
    {0x9F79, 0x712C}, //5758 #CJK UNIFIED IDEOGRAPH
    {0x9F7A, 0x712D}, //5759 #CJK UNIFIED IDEOGRAPH
    {0x9F7B, 0x712E}, //5760 #CJK UNIFIED IDEOGRAPH
    {0x9F7C, 0x7132}, //5761 #CJK UNIFIED IDEOGRAPH
    {0x9F7D, 0x7133}, //5762 #CJK UNIFIED IDEOGRAPH
    {0x9F7E, 0x7134}, //5763 #CJK UNIFIED IDEOGRAPH
    {0x9F80, 0x7135}, //5764 #CJK UNIFIED IDEOGRAPH
    {0x9F81, 0x7137}, //5765 #CJK UNIFIED IDEOGRAPH
    {0x9F82, 0x7138}, //5766 #CJK UNIFIED IDEOGRAPH
    {0x9F83, 0x7139}, //5767 #CJK UNIFIED IDEOGRAPH
    {0x9F84, 0x713A}, //5768 #CJK UNIFIED IDEOGRAPH
    {0x9F85, 0x713B}, //5769 #CJK UNIFIED IDEOGRAPH
    {0x9F86, 0x713C}, //5770 #CJK UNIFIED IDEOGRAPH
    {0x9F87, 0x713D}, //5771 #CJK UNIFIED IDEOGRAPH
    {0x9F88, 0x713E}, //5772 #CJK UNIFIED IDEOGRAPH
    {0x9F89, 0x713F}, //5773 #CJK UNIFIED IDEOGRAPH
    {0x9F8A, 0x7140}, //5774 #CJK UNIFIED IDEOGRAPH
    {0x9F8B, 0x7141}, //5775 #CJK UNIFIED IDEOGRAPH
    {0x9F8C, 0x7142}, //5776 #CJK UNIFIED IDEOGRAPH
    {0x9F8D, 0x7143}, //5777 #CJK UNIFIED IDEOGRAPH
    {0x9F8E, 0x7144}, //5778 #CJK UNIFIED IDEOGRAPH
    {0x9F8F, 0x7146}, //5779 #CJK UNIFIED IDEOGRAPH
    {0x9F90, 0x7147}, //5780 #CJK UNIFIED IDEOGRAPH
    {0x9F91, 0x7148}, //5781 #CJK UNIFIED IDEOGRAPH
    {0x9F92, 0x7149}, //5782 #CJK UNIFIED IDEOGRAPH
    {0x9F93, 0x714B}, //5783 #CJK UNIFIED IDEOGRAPH
    {0x9F94, 0x714D}, //5784 #CJK UNIFIED IDEOGRAPH
    {0x9F95, 0x714F}, //5785 #CJK UNIFIED IDEOGRAPH
    {0x9F96, 0x7150}, //5786 #CJK UNIFIED IDEOGRAPH
    {0x9F97, 0x7151}, //5787 #CJK UNIFIED IDEOGRAPH
    {0x9F98, 0x7152}, //5788 #CJK UNIFIED IDEOGRAPH
    {0x9F99, 0x7153}, //5789 #CJK UNIFIED IDEOGRAPH
    {0x9F9A, 0x7154}, //5790 #CJK UNIFIED IDEOGRAPH
    {0x9F9B, 0x7155}, //5791 #CJK UNIFIED IDEOGRAPH
    {0x9F9C, 0x7156}, //5792 #CJK UNIFIED IDEOGRAPH
    {0x9F9D, 0x7157}, //5793 #CJK UNIFIED IDEOGRAPH
    {0x9F9E, 0x7158}, //5794 #CJK UNIFIED IDEOGRAPH
    {0x9F9F, 0x7159}, //5795 #CJK UNIFIED IDEOGRAPH
    {0x9FA0, 0x715A}, //5796 #CJK UNIFIED IDEOGRAPH
    {0x9FA1, 0x715B}, //5797 #CJK UNIFIED IDEOGRAPH
    {0x9FA2, 0x715D}, //5798 #CJK UNIFIED IDEOGRAPH
    {0x9FA3, 0x715F}, //5799 #CJK UNIFIED IDEOGRAPH
    {0x9FA4, 0x7160}, //5800 #CJK UNIFIED IDEOGRAPH
    {0x9FA5, 0x7161}, //5801 #CJK UNIFIED IDEOGRAPH
    {0x9FA6, 0x7162}, //5802 #CJK UNIFIED IDEOGRAPH
    {0x9FA7, 0x7163}, //5803 #CJK UNIFIED IDEOGRAPH
    {0x9FA8, 0x7165}, //5804 #CJK UNIFIED IDEOGRAPH
    {0x9FA9, 0x7169}, //5805 #CJK UNIFIED IDEOGRAPH
    {0x9FAA, 0x716A}, //5806 #CJK UNIFIED IDEOGRAPH
    {0x9FAB, 0x716B}, //5807 #CJK UNIFIED IDEOGRAPH
    {0x9FAC, 0x716C}, //5808 #CJK UNIFIED IDEOGRAPH
    {0x9FAD, 0x716D}, //5809 #CJK UNIFIED IDEOGRAPH
    {0x9FAE, 0x716F}, //5810 #CJK UNIFIED IDEOGRAPH
    {0x9FAF, 0x7170}, //5811 #CJK UNIFIED IDEOGRAPH
    {0x9FB0, 0x7171}, //5812 #CJK UNIFIED IDEOGRAPH
    {0x9FB1, 0x7174}, //5813 #CJK UNIFIED IDEOGRAPH
    {0x9FB2, 0x7175}, //5814 #CJK UNIFIED IDEOGRAPH
    {0x9FB3, 0x7176}, //5815 #CJK UNIFIED IDEOGRAPH
    {0x9FB4, 0x7177}, //5816 #CJK UNIFIED IDEOGRAPH
    {0x9FB5, 0x7179}, //5817 #CJK UNIFIED IDEOGRAPH
    {0x9FB6, 0x717B}, //5818 #CJK UNIFIED IDEOGRAPH
    {0x9FB7, 0x717C}, //5819 #CJK UNIFIED IDEOGRAPH
    {0x9FB8, 0x717E}, //5820 #CJK UNIFIED IDEOGRAPH
    {0x9FB9, 0x717F}, //5821 #CJK UNIFIED IDEOGRAPH
    {0x9FBA, 0x7180}, //5822 #CJK UNIFIED IDEOGRAPH
    {0x9FBB, 0x7181}, //5823 #CJK UNIFIED IDEOGRAPH
    {0x9FBC, 0x7182}, //5824 #CJK UNIFIED IDEOGRAPH
    {0x9FBD, 0x7183}, //5825 #CJK UNIFIED IDEOGRAPH
    {0x9FBE, 0x7185}, //5826 #CJK UNIFIED IDEOGRAPH
    {0x9FBF, 0x7186}, //5827 #CJK UNIFIED IDEOGRAPH
    {0x9FC0, 0x7187}, //5828 #CJK UNIFIED IDEOGRAPH
    {0x9FC1, 0x7188}, //5829 #CJK UNIFIED IDEOGRAPH
    {0x9FC2, 0x7189}, //5830 #CJK UNIFIED IDEOGRAPH
    {0x9FC3, 0x718B}, //5831 #CJK UNIFIED IDEOGRAPH
    {0x9FC4, 0x718C}, //5832 #CJK UNIFIED IDEOGRAPH
    {0x9FC5, 0x718D}, //5833 #CJK UNIFIED IDEOGRAPH
    {0x9FC6, 0x718E}, //5834 #CJK UNIFIED IDEOGRAPH
    {0x9FC7, 0x7190}, //5835 #CJK UNIFIED IDEOGRAPH
    {0x9FC8, 0x7191}, //5836 #CJK UNIFIED IDEOGRAPH
    {0x9FC9, 0x7192}, //5837 #CJK UNIFIED IDEOGRAPH
    {0x9FCA, 0x7193}, //5838 #CJK UNIFIED IDEOGRAPH
    {0x9FCB, 0x7195}, //5839 #CJK UNIFIED IDEOGRAPH
    {0x9FCC, 0x7196}, //5840 #CJK UNIFIED IDEOGRAPH
    {0x9FCD, 0x7197}, //5841 #CJK UNIFIED IDEOGRAPH
    {0x9FCE, 0x719A}, //5842 #CJK UNIFIED IDEOGRAPH
    {0x9FCF, 0x719B}, //5843 #CJK UNIFIED IDEOGRAPH
    {0x9FD0, 0x719C}, //5844 #CJK UNIFIED IDEOGRAPH
    {0x9FD1, 0x719D}, //5845 #CJK UNIFIED IDEOGRAPH
    {0x9FD2, 0x719E}, //5846 #CJK UNIFIED IDEOGRAPH
    {0x9FD3, 0x71A1}, //5847 #CJK UNIFIED IDEOGRAPH
    {0x9FD4, 0x71A2}, //5848 #CJK UNIFIED IDEOGRAPH
    {0x9FD5, 0x71A3}, //5849 #CJK UNIFIED IDEOGRAPH
    {0x9FD6, 0x71A4}, //5850 #CJK UNIFIED IDEOGRAPH
    {0x9FD7, 0x71A5}, //5851 #CJK UNIFIED IDEOGRAPH
    {0x9FD8, 0x71A6}, //5852 #CJK UNIFIED IDEOGRAPH
    {0x9FD9, 0x71A7}, //5853 #CJK UNIFIED IDEOGRAPH
    {0x9FDA, 0x71A9}, //5854 #CJK UNIFIED IDEOGRAPH
    {0x9FDB, 0x71AA}, //5855 #CJK UNIFIED IDEOGRAPH
    {0x9FDC, 0x71AB}, //5856 #CJK UNIFIED IDEOGRAPH
    {0x9FDD, 0x71AD}, //5857 #CJK UNIFIED IDEOGRAPH
    {0x9FDE, 0x71AE}, //5858 #CJK UNIFIED IDEOGRAPH
    {0x9FDF, 0x71AF}, //5859 #CJK UNIFIED IDEOGRAPH
    {0x9FE0, 0x71B0}, //5860 #CJK UNIFIED IDEOGRAPH
    {0x9FE1, 0x71B1}, //5861 #CJK UNIFIED IDEOGRAPH
    {0x9FE2, 0x71B2}, //5862 #CJK UNIFIED IDEOGRAPH
    {0x9FE3, 0x71B4}, //5863 #CJK UNIFIED IDEOGRAPH
    {0x9FE4, 0x71B6}, //5864 #CJK UNIFIED IDEOGRAPH
    {0x9FE5, 0x71B7}, //5865 #CJK UNIFIED IDEOGRAPH
    {0x9FE6, 0x71B8}, //5866 #CJK UNIFIED IDEOGRAPH
    {0x9FE7, 0x71BA}, //5867 #CJK UNIFIED IDEOGRAPH
    {0x9FE8, 0x71BB}, //5868 #CJK UNIFIED IDEOGRAPH
    {0x9FE9, 0x71BC}, //5869 #CJK UNIFIED IDEOGRAPH
    {0x9FEA, 0x71BD}, //5870 #CJK UNIFIED IDEOGRAPH
    {0x9FEB, 0x71BE}, //5871 #CJK UNIFIED IDEOGRAPH
    {0x9FEC, 0x71BF}, //5872 #CJK UNIFIED IDEOGRAPH
    {0x9FED, 0x71C0}, //5873 #CJK UNIFIED IDEOGRAPH
    {0x9FEE, 0x71C1}, //5874 #CJK UNIFIED IDEOGRAPH
    {0x9FEF, 0x71C2}, //5875 #CJK UNIFIED IDEOGRAPH
    {0x9FF0, 0x71C4}, //5876 #CJK UNIFIED IDEOGRAPH
    {0x9FF1, 0x71C5}, //5877 #CJK UNIFIED IDEOGRAPH
    {0x9FF2, 0x71C6}, //5878 #CJK UNIFIED IDEOGRAPH
    {0x9FF3, 0x71C7}, //5879 #CJK UNIFIED IDEOGRAPH
    {0x9FF4, 0x71C8}, //5880 #CJK UNIFIED IDEOGRAPH
    {0x9FF5, 0x71C9}, //5881 #CJK UNIFIED IDEOGRAPH
    {0x9FF6, 0x71CA}, //5882 #CJK UNIFIED IDEOGRAPH
    {0x9FF7, 0x71CB}, //5883 #CJK UNIFIED IDEOGRAPH
    {0x9FF8, 0x71CC}, //5884 #CJK UNIFIED IDEOGRAPH
    {0x9FF9, 0x71CD}, //5885 #CJK UNIFIED IDEOGRAPH
    {0x9FFA, 0x71CF}, //5886 #CJK UNIFIED IDEOGRAPH
    {0x9FFB, 0x71D0}, //5887 #CJK UNIFIED IDEOGRAPH
    {0x9FFC, 0x71D1}, //5888 #CJK UNIFIED IDEOGRAPH
    {0x9FFD, 0x71D2}, //5889 #CJK UNIFIED IDEOGRAPH
    {0x9FFE, 0x71D3}, //5890 #CJK UNIFIED IDEOGRAPH
    {0xA040, 0x71D6}, //5891 #CJK UNIFIED IDEOGRAPH
    {0xA041, 0x71D7}, //5892 #CJK UNIFIED IDEOGRAPH
    {0xA042, 0x71D8}, //5893 #CJK UNIFIED IDEOGRAPH
    {0xA043, 0x71D9}, //5894 #CJK UNIFIED IDEOGRAPH
    {0xA044, 0x71DA}, //5895 #CJK UNIFIED IDEOGRAPH
    {0xA045, 0x71DB}, //5896 #CJK UNIFIED IDEOGRAPH
    {0xA046, 0x71DC}, //5897 #CJK UNIFIED IDEOGRAPH
    {0xA047, 0x71DD}, //5898 #CJK UNIFIED IDEOGRAPH
    {0xA048, 0x71DE}, //5899 #CJK UNIFIED IDEOGRAPH
    {0xA049, 0x71DF}, //5900 #CJK UNIFIED IDEOGRAPH
    {0xA04A, 0x71E1}, //5901 #CJK UNIFIED IDEOGRAPH
    {0xA04B, 0x71E2}, //5902 #CJK UNIFIED IDEOGRAPH
    {0xA04C, 0x71E3}, //5903 #CJK UNIFIED IDEOGRAPH
    {0xA04D, 0x71E4}, //5904 #CJK UNIFIED IDEOGRAPH
    {0xA04E, 0x71E6}, //5905 #CJK UNIFIED IDEOGRAPH
    {0xA04F, 0x71E8}, //5906 #CJK UNIFIED IDEOGRAPH
    {0xA050, 0x71E9}, //5907 #CJK UNIFIED IDEOGRAPH
    {0xA051, 0x71EA}, //5908 #CJK UNIFIED IDEOGRAPH
    {0xA052, 0x71EB}, //5909 #CJK UNIFIED IDEOGRAPH
    {0xA053, 0x71EC}, //5910 #CJK UNIFIED IDEOGRAPH
    {0xA054, 0x71ED}, //5911 #CJK UNIFIED IDEOGRAPH
    {0xA055, 0x71EF}, //5912 #CJK UNIFIED IDEOGRAPH
    {0xA056, 0x71F0}, //5913 #CJK UNIFIED IDEOGRAPH
    {0xA057, 0x71F1}, //5914 #CJK UNIFIED IDEOGRAPH
    {0xA058, 0x71F2}, //5915 #CJK UNIFIED IDEOGRAPH
    {0xA059, 0x71F3}, //5916 #CJK UNIFIED IDEOGRAPH
    {0xA05A, 0x71F4}, //5917 #CJK UNIFIED IDEOGRAPH
    {0xA05B, 0x71F5}, //5918 #CJK UNIFIED IDEOGRAPH
    {0xA05C, 0x71F6}, //5919 #CJK UNIFIED IDEOGRAPH
    {0xA05D, 0x71F7}, //5920 #CJK UNIFIED IDEOGRAPH
    {0xA05E, 0x71F8}, //5921 #CJK UNIFIED IDEOGRAPH
    {0xA05F, 0x71FA}, //5922 #CJK UNIFIED IDEOGRAPH
    {0xA060, 0x71FB}, //5923 #CJK UNIFIED IDEOGRAPH
    {0xA061, 0x71FC}, //5924 #CJK UNIFIED IDEOGRAPH
    {0xA062, 0x71FD}, //5925 #CJK UNIFIED IDEOGRAPH
    {0xA063, 0x71FE}, //5926 #CJK UNIFIED IDEOGRAPH
    {0xA064, 0x71FF}, //5927 #CJK UNIFIED IDEOGRAPH
    {0xA065, 0x7200}, //5928 #CJK UNIFIED IDEOGRAPH
    {0xA066, 0x7201}, //5929 #CJK UNIFIED IDEOGRAPH
    {0xA067, 0x7202}, //5930 #CJK UNIFIED IDEOGRAPH
    {0xA068, 0x7203}, //5931 #CJK UNIFIED IDEOGRAPH
    {0xA069, 0x7204}, //5932 #CJK UNIFIED IDEOGRAPH
    {0xA06A, 0x7205}, //5933 #CJK UNIFIED IDEOGRAPH
    {0xA06B, 0x7207}, //5934 #CJK UNIFIED IDEOGRAPH
    {0xA06C, 0x7208}, //5935 #CJK UNIFIED IDEOGRAPH
    {0xA06D, 0x7209}, //5936 #CJK UNIFIED IDEOGRAPH
    {0xA06E, 0x720A}, //5937 #CJK UNIFIED IDEOGRAPH
    {0xA06F, 0x720B}, //5938 #CJK UNIFIED IDEOGRAPH
    {0xA070, 0x720C}, //5939 #CJK UNIFIED IDEOGRAPH
    {0xA071, 0x720D}, //5940 #CJK UNIFIED IDEOGRAPH
    {0xA072, 0x720E}, //5941 #CJK UNIFIED IDEOGRAPH
    {0xA073, 0x720F}, //5942 #CJK UNIFIED IDEOGRAPH
    {0xA074, 0x7210}, //5943 #CJK UNIFIED IDEOGRAPH
    {0xA075, 0x7211}, //5944 #CJK UNIFIED IDEOGRAPH
    {0xA076, 0x7212}, //5945 #CJK UNIFIED IDEOGRAPH
    {0xA077, 0x7213}, //5946 #CJK UNIFIED IDEOGRAPH
    {0xA078, 0x7214}, //5947 #CJK UNIFIED IDEOGRAPH
    {0xA079, 0x7215}, //5948 #CJK UNIFIED IDEOGRAPH
    {0xA07A, 0x7216}, //5949 #CJK UNIFIED IDEOGRAPH
    {0xA07B, 0x7217}, //5950 #CJK UNIFIED IDEOGRAPH
    {0xA07C, 0x7218}, //5951 #CJK UNIFIED IDEOGRAPH
    {0xA07D, 0x7219}, //5952 #CJK UNIFIED IDEOGRAPH
    {0xA07E, 0x721A}, //5953 #CJK UNIFIED IDEOGRAPH
    {0xA080, 0x721B}, //5954 #CJK UNIFIED IDEOGRAPH
    {0xA081, 0x721C}, //5955 #CJK UNIFIED IDEOGRAPH
    {0xA082, 0x721E}, //5956 #CJK UNIFIED IDEOGRAPH
    {0xA083, 0x721F}, //5957 #CJK UNIFIED IDEOGRAPH
    {0xA084, 0x7220}, //5958 #CJK UNIFIED IDEOGRAPH
    {0xA085, 0x7221}, //5959 #CJK UNIFIED IDEOGRAPH
    {0xA086, 0x7222}, //5960 #CJK UNIFIED IDEOGRAPH
    {0xA087, 0x7223}, //5961 #CJK UNIFIED IDEOGRAPH
    {0xA088, 0x7224}, //5962 #CJK UNIFIED IDEOGRAPH
    {0xA089, 0x7225}, //5963 #CJK UNIFIED IDEOGRAPH
    {0xA08A, 0x7226}, //5964 #CJK UNIFIED IDEOGRAPH
    {0xA08B, 0x7227}, //5965 #CJK UNIFIED IDEOGRAPH
    {0xA08C, 0x7229}, //5966 #CJK UNIFIED IDEOGRAPH
    {0xA08D, 0x722B}, //5967 #CJK UNIFIED IDEOGRAPH
    {0xA08E, 0x722D}, //5968 #CJK UNIFIED IDEOGRAPH
    {0xA08F, 0x722E}, //5969 #CJK UNIFIED IDEOGRAPH
    {0xA090, 0x722F}, //5970 #CJK UNIFIED IDEOGRAPH
    {0xA091, 0x7232}, //5971 #CJK UNIFIED IDEOGRAPH
    {0xA092, 0x7233}, //5972 #CJK UNIFIED IDEOGRAPH
    {0xA093, 0x7234}, //5973 #CJK UNIFIED IDEOGRAPH
    {0xA094, 0x723A}, //5974 #CJK UNIFIED IDEOGRAPH
    {0xA095, 0x723C}, //5975 #CJK UNIFIED IDEOGRAPH
    {0xA096, 0x723E}, //5976 #CJK UNIFIED IDEOGRAPH
    {0xA097, 0x7240}, //5977 #CJK UNIFIED IDEOGRAPH
    {0xA098, 0x7241}, //5978 #CJK UNIFIED IDEOGRAPH
    {0xA099, 0x7242}, //5979 #CJK UNIFIED IDEOGRAPH
    {0xA09A, 0x7243}, //5980 #CJK UNIFIED IDEOGRAPH
    {0xA09B, 0x7244}, //5981 #CJK UNIFIED IDEOGRAPH
    {0xA09C, 0x7245}, //5982 #CJK UNIFIED IDEOGRAPH
    {0xA09D, 0x7246}, //5983 #CJK UNIFIED IDEOGRAPH
    {0xA09E, 0x7249}, //5984 #CJK UNIFIED IDEOGRAPH
    {0xA09F, 0x724A}, //5985 #CJK UNIFIED IDEOGRAPH
    {0xA0A0, 0x724B}, //5986 #CJK UNIFIED IDEOGRAPH
    {0xA0A1, 0x724E}, //5987 #CJK UNIFIED IDEOGRAPH
    {0xA0A2, 0x724F}, //5988 #CJK UNIFIED IDEOGRAPH
    {0xA0A3, 0x7250}, //5989 #CJK UNIFIED IDEOGRAPH
    {0xA0A4, 0x7251}, //5990 #CJK UNIFIED IDEOGRAPH
    {0xA0A5, 0x7253}, //5991 #CJK UNIFIED IDEOGRAPH
    {0xA0A6, 0x7254}, //5992 #CJK UNIFIED IDEOGRAPH
    {0xA0A7, 0x7255}, //5993 #CJK UNIFIED IDEOGRAPH
    {0xA0A8, 0x7257}, //5994 #CJK UNIFIED IDEOGRAPH
    {0xA0A9, 0x7258}, //5995 #CJK UNIFIED IDEOGRAPH
    {0xA0AA, 0x725A}, //5996 #CJK UNIFIED IDEOGRAPH
    {0xA0AB, 0x725C}, //5997 #CJK UNIFIED IDEOGRAPH
    {0xA0AC, 0x725E}, //5998 #CJK UNIFIED IDEOGRAPH
    {0xA0AD, 0x7260}, //5999 #CJK UNIFIED IDEOGRAPH
    {0xA0AE, 0x7263}, //6000 #CJK UNIFIED IDEOGRAPH
    {0xA0AF, 0x7264}, //6001 #CJK UNIFIED IDEOGRAPH
    {0xA0B0, 0x7265}, //6002 #CJK UNIFIED IDEOGRAPH
    {0xA0B1, 0x7268}, //6003 #CJK UNIFIED IDEOGRAPH
    {0xA0B2, 0x726A}, //6004 #CJK UNIFIED IDEOGRAPH
    {0xA0B3, 0x726B}, //6005 #CJK UNIFIED IDEOGRAPH
    {0xA0B4, 0x726C}, //6006 #CJK UNIFIED IDEOGRAPH
    {0xA0B5, 0x726D}, //6007 #CJK UNIFIED IDEOGRAPH
    {0xA0B6, 0x7270}, //6008 #CJK UNIFIED IDEOGRAPH
    {0xA0B7, 0x7271}, //6009 #CJK UNIFIED IDEOGRAPH
    {0xA0B8, 0x7273}, //6010 #CJK UNIFIED IDEOGRAPH
    {0xA0B9, 0x7274}, //6011 #CJK UNIFIED IDEOGRAPH
    {0xA0BA, 0x7276}, //6012 #CJK UNIFIED IDEOGRAPH
    {0xA0BB, 0x7277}, //6013 #CJK UNIFIED IDEOGRAPH
    {0xA0BC, 0x7278}, //6014 #CJK UNIFIED IDEOGRAPH
    {0xA0BD, 0x727B}, //6015 #CJK UNIFIED IDEOGRAPH
    {0xA0BE, 0x727C}, //6016 #CJK UNIFIED IDEOGRAPH
    {0xA0BF, 0x727D}, //6017 #CJK UNIFIED IDEOGRAPH
    {0xA0C0, 0x7282}, //6018 #CJK UNIFIED IDEOGRAPH
    {0xA0C1, 0x7283}, //6019 #CJK UNIFIED IDEOGRAPH
    {0xA0C2, 0x7285}, //6020 #CJK UNIFIED IDEOGRAPH
    {0xA0C3, 0x7286}, //6021 #CJK UNIFIED IDEOGRAPH
    {0xA0C4, 0x7287}, //6022 #CJK UNIFIED IDEOGRAPH
    {0xA0C5, 0x7288}, //6023 #CJK UNIFIED IDEOGRAPH
    {0xA0C6, 0x7289}, //6024 #CJK UNIFIED IDEOGRAPH
    {0xA0C7, 0x728C}, //6025 #CJK UNIFIED IDEOGRAPH
    {0xA0C8, 0x728E}, //6026 #CJK UNIFIED IDEOGRAPH
    {0xA0C9, 0x7290}, //6027 #CJK UNIFIED IDEOGRAPH
    {0xA0CA, 0x7291}, //6028 #CJK UNIFIED IDEOGRAPH
    {0xA0CB, 0x7293}, //6029 #CJK UNIFIED IDEOGRAPH
    {0xA0CC, 0x7294}, //6030 #CJK UNIFIED IDEOGRAPH
    {0xA0CD, 0x7295}, //6031 #CJK UNIFIED IDEOGRAPH
    {0xA0CE, 0x7296}, //6032 #CJK UNIFIED IDEOGRAPH
    {0xA0CF, 0x7297}, //6033 #CJK UNIFIED IDEOGRAPH
    {0xA0D0, 0x7298}, //6034 #CJK UNIFIED IDEOGRAPH
    {0xA0D1, 0x7299}, //6035 #CJK UNIFIED IDEOGRAPH
    {0xA0D2, 0x729A}, //6036 #CJK UNIFIED IDEOGRAPH
    {0xA0D3, 0x729B}, //6037 #CJK UNIFIED IDEOGRAPH
    {0xA0D4, 0x729C}, //6038 #CJK UNIFIED IDEOGRAPH
    {0xA0D5, 0x729D}, //6039 #CJK UNIFIED IDEOGRAPH
    {0xA0D6, 0x729E}, //6040 #CJK UNIFIED IDEOGRAPH
    {0xA0D7, 0x72A0}, //6041 #CJK UNIFIED IDEOGRAPH
    {0xA0D8, 0x72A1}, //6042 #CJK UNIFIED IDEOGRAPH
    {0xA0D9, 0x72A2}, //6043 #CJK UNIFIED IDEOGRAPH
    {0xA0DA, 0x72A3}, //6044 #CJK UNIFIED IDEOGRAPH
    {0xA0DB, 0x72A4}, //6045 #CJK UNIFIED IDEOGRAPH
    {0xA0DC, 0x72A5}, //6046 #CJK UNIFIED IDEOGRAPH
    {0xA0DD, 0x72A6}, //6047 #CJK UNIFIED IDEOGRAPH
    {0xA0DE, 0x72A7}, //6048 #CJK UNIFIED IDEOGRAPH
    {0xA0DF, 0x72A8}, //6049 #CJK UNIFIED IDEOGRAPH
    {0xA0E0, 0x72A9}, //6050 #CJK UNIFIED IDEOGRAPH
    {0xA0E1, 0x72AA}, //6051 #CJK UNIFIED IDEOGRAPH
    {0xA0E2, 0x72AB}, //6052 #CJK UNIFIED IDEOGRAPH
    {0xA0E3, 0x72AE}, //6053 #CJK UNIFIED IDEOGRAPH
    {0xA0E4, 0x72B1}, //6054 #CJK UNIFIED IDEOGRAPH
    {0xA0E5, 0x72B2}, //6055 #CJK UNIFIED IDEOGRAPH
    {0xA0E6, 0x72B3}, //6056 #CJK UNIFIED IDEOGRAPH
    {0xA0E7, 0x72B5}, //6057 #CJK UNIFIED IDEOGRAPH
    {0xA0E8, 0x72BA}, //6058 #CJK UNIFIED IDEOGRAPH
    {0xA0E9, 0x72BB}, //6059 #CJK UNIFIED IDEOGRAPH
    {0xA0EA, 0x72BC}, //6060 #CJK UNIFIED IDEOGRAPH
    {0xA0EB, 0x72BD}, //6061 #CJK UNIFIED IDEOGRAPH
    {0xA0EC, 0x72BE}, //6062 #CJK UNIFIED IDEOGRAPH
    {0xA0ED, 0x72BF}, //6063 #CJK UNIFIED IDEOGRAPH
    {0xA0EE, 0x72C0}, //6064 #CJK UNIFIED IDEOGRAPH
    {0xA0EF, 0x72C5}, //6065 #CJK UNIFIED IDEOGRAPH
    {0xA0F0, 0x72C6}, //6066 #CJK UNIFIED IDEOGRAPH
    {0xA0F1, 0x72C7}, //6067 #CJK UNIFIED IDEOGRAPH
    {0xA0F2, 0x72C9}, //6068 #CJK UNIFIED IDEOGRAPH
    {0xA0F3, 0x72CA}, //6069 #CJK UNIFIED IDEOGRAPH
    {0xA0F4, 0x72CB}, //6070 #CJK UNIFIED IDEOGRAPH
    {0xA0F5, 0x72CC}, //6071 #CJK UNIFIED IDEOGRAPH
    {0xA0F6, 0x72CF}, //6072 #CJK UNIFIED IDEOGRAPH
    {0xA0F7, 0x72D1}, //6073 #CJK UNIFIED IDEOGRAPH
    {0xA0F8, 0x72D3}, //6074 #CJK UNIFIED IDEOGRAPH
    {0xA0F9, 0x72D4}, //6075 #CJK UNIFIED IDEOGRAPH
    {0xA0FA, 0x72D5}, //6076 #CJK UNIFIED IDEOGRAPH
    {0xA0FB, 0x72D6}, //6077 #CJK UNIFIED IDEOGRAPH
    {0xA0FC, 0x72D8}, //6078 #CJK UNIFIED IDEOGRAPH
    {0xA0FD, 0x72DA}, //6079 #CJK UNIFIED IDEOGRAPH
    {0xA0FE, 0x72DB}, //6080 #CJK UNIFIED IDEOGRAPH
    {0xA1A1, 0x3000}, //6081 #IDEOGRAPHIC SPACE
    {0xA1A2, 0x3001}, //6082 #IDEOGRAPHIC COMMA
    {0xA1A3, 0x3002}, //6083 #IDEOGRAPHIC FULL STOP
    {0xA1A4, 0x00B7}, //6084 #MIDDLE DOT
    {0xA1A5, 0x02C9}, //6085 #MODIFIER LETTER MACRON
    {0xA1A6, 0x02C7}, //6086 #CARON
    {0xA1A7, 0x00A8}, //6087 #DIAERESIS
    {0xA1A8, 0x3003}, //6088 #DITTO MARK
    {0xA1A9, 0x3005}, //6089 #IDEOGRAPHIC ITERATION MARK
    {0xA1AA, 0x2014}, //6090 #EM DASH
    {0xA1AB, 0xFF5E}, //6091 #FULLWIDTH TILDE
    {0xA1AC, 0x2016}, //6092 #DOUBLE VERTICAL LINE
    {0xA1AD, 0x2026}, //6093 #HORIZONTAL ELLIPSIS
    {0xA1AE, 0x2018}, //6094 #LEFT SINGLE QUOTATION MARK
    {0xA1AF, 0x2019}, //6095 #RIGHT SINGLE QUOTATION MARK
    {0xA1B0, 0x201C}, //6096 #LEFT DOUBLE QUOTATION MARK
    {0xA1B1, 0x201D}, //6097 #RIGHT DOUBLE QUOTATION MARK
    {0xA1B2, 0x3014}, //6098 #LEFT TORTOISE SHELL BRACKET
    {0xA1B3, 0x3015}, //6099 #RIGHT TORTOISE SHELL BRACKET
    {0xA1B4, 0x3008}, //6100 #LEFT ANGLE BRACKET
    {0xA1B5, 0x3009}, //6101 #RIGHT ANGLE BRACKET
    {0xA1B6, 0x300A}, //6102 #LEFT DOUBLE ANGLE BRACKET
    {0xA1B7, 0x300B}, //6103 #RIGHT DOUBLE ANGLE BRACKET
    {0xA1B8, 0x300C}, //6104 #LEFT CORNER BRACKET
    {0xA1B9, 0x300D}, //6105 #RIGHT CORNER BRACKET
    {0xA1BA, 0x300E}, //6106 #LEFT WHITE CORNER BRACKET
    {0xA1BB, 0x300F}, //6107 #RIGHT WHITE CORNER BRACKET
    {0xA1BC, 0x3016}, //6108 #LEFT WHITE LENTICULAR BRACKET
    {0xA1BD, 0x3017}, //6109 #RIGHT WHITE LENTICULAR BRACKET
    {0xA1BE, 0x3010}, //6110 #LEFT BLACK LENTICULAR BRACKET
    {0xA1BF, 0x3011}, //6111 #RIGHT BLACK LENTICULAR BRACKET
    {0xA1C0, 0x00B1}, //6112 #PLUS-MINUS SIGN
    {0xA1C1, 0x00D7}, //6113 #MULTIPLICATION SIGN
    {0xA1C2, 0x00F7}, //6114 #DIVISION SIGN
    {0xA1C3, 0x2236}, //6115 #RATIO
    {0xA1C4, 0x2227}, //6116 #LOGICAL AND
    {0xA1C5, 0x2228}, //6117 #LOGICAL OR
    {0xA1C6, 0x2211}, //6118 #N-ARY SUMMATION
    {0xA1C7, 0x220F}, //6119 #N-ARY PRODUCT
    {0xA1C8, 0x222A}, //6120 #UNION
    {0xA1C9, 0x2229}, //6121 #INTERSECTION
    {0xA1CA, 0x2208}, //6122 #ELEMENT OF
    {0xA1CB, 0x2237}, //6123 #PROPORTION
    {0xA1CC, 0x221A}, //6124 #SQUARE ROOT
    {0xA1CD, 0x22A5}, //6125 #UP TACK
    {0xA1CE, 0x2225}, //6126 #PARALLEL TO
    {0xA1CF, 0x2220}, //6127 #ANGLE
    {0xA1D0, 0x2312}, //6128 #ARC
    {0xA1D1, 0x2299}, //6129 #CIRCLED DOT OPERATOR
    {0xA1D2, 0x222B}, //6130 #INTEGRAL
    {0xA1D3, 0x222E}, //6131 #CONTOUR INTEGRAL
    {0xA1D4, 0x2261}, //6132 #IDENTICAL TO
    {0xA1D5, 0x224C}, //6133 #ALL EQUAL TO
    {0xA1D6, 0x2248}, //6134 #ALMOST EQUAL TO
    {0xA1D7, 0x223D}, //6135 #REVERSED TILDE
    {0xA1D8, 0x221D}, //6136 #PROPORTIONAL TO
    {0xA1D9, 0x2260}, //6137 #NOT EQUAL TO
    {0xA1DA, 0x226E}, //6138 #NOT LESS-THAN
    {0xA1DB, 0x226F}, //6139 #NOT GREATER-THAN
    {0xA1DC, 0x2264}, //6140 #LESS-THAN OR EQUAL TO
    {0xA1DD, 0x2265}, //6141 #GREATER-THAN OR EQUAL TO
    {0xA1DE, 0x221E}, //6142 #INFINITY
    {0xA1DF, 0x2235}, //6143 #BECAUSE
    {0xA1E0, 0x2234}, //6144 #THEREFORE
    {0xA1E1, 0x2642}, //6145 #MALE SIGN
    {0xA1E2, 0x2640}, //6146 #FEMALE SIGN
    {0xA1E3, 0x00B0}, //6147 #DEGREE SIGN
    {0xA1E4, 0x2032}, //6148 #PRIME
    {0xA1E5, 0x2033}, //6149 #DOUBLE PRIME
    {0xA1E6, 0x2103}, //6150 #DEGREE CELSIUS
    {0xA1E7, 0xFF04}, //6151 #FULLWIDTH DOLLAR SIGN
    {0xA1E8, 0x00A4}, //6152 #CURRENCY SIGN
    {0xA1E9, 0xFFE0}, //6153 #FULLWIDTH CENT SIGN
    {0xA1EA, 0xFFE1}, //6154 #FULLWIDTH POUND SIGN
    {0xA1EB, 0x2030}, //6155 #PER MILLE SIGN
    {0xA1EC, 0x00A7}, //6156 #SECTION SIGN
    {0xA1ED, 0x2116}, //6157 #NUMERO SIGN
    {0xA1EE, 0x2606}, //6158 #WHITE STAR
    {0xA1EF, 0x2605}, //6159 #BLACK STAR
    {0xA1F0, 0x25CB}, //6160 #WHITE CIRCLE
    {0xA1F1, 0x25CF}, //6161 #BLACK CIRCLE
    {0xA1F2, 0x25CE}, //6162 #BULLSEYE
    {0xA1F3, 0x25C7}, //6163 #WHITE DIAMOND
    {0xA1F4, 0x25C6}, //6164 #BLACK DIAMOND
    {0xA1F5, 0x25A1}, //6165 #WHITE SQUARE
    {0xA1F6, 0x25A0}, //6166 #BLACK SQUARE
    {0xA1F7, 0x25B3}, //6167 #WHITE UP-POINTING TRIANGLE
    {0xA1F8, 0x25B2}, //6168 #BLACK UP-POINTING TRIANGLE
    {0xA1F9, 0x203B}, //6169 #REFERENCE MARK
    {0xA1FA, 0x2192}, //6170 #RIGHTWARDS ARROW
    {0xA1FB, 0x2190}, //6171 #LEFTWARDS ARROW
    {0xA1FC, 0x2191}, //6172 #UPWARDS ARROW
    {0xA1FD, 0x2193}, //6173 #DOWNWARDS ARROW
    {0xA1FE, 0x3013}, //6174 #GETA MARK
    {0xA2A1, 0x2170}, //6175 #SMALL ROMAN NUMERAL ONE
    {0xA2A2, 0x2171}, //6176 #SMALL ROMAN NUMERAL TWO
    {0xA2A3, 0x2172}, //6177 #SMALL ROMAN NUMERAL THREE
    {0xA2A4, 0x2173}, //6178 #SMALL ROMAN NUMERAL FOUR
    {0xA2A5, 0x2174}, //6179 #SMALL ROMAN NUMERAL FIVE
    {0xA2A6, 0x2175}, //6180 #SMALL ROMAN NUMERAL SIX
    {0xA2A7, 0x2176}, //6181 #SMALL ROMAN NUMERAL SEVEN
    {0xA2A8, 0x2177}, //6182 #SMALL ROMAN NUMERAL EIGHT
    {0xA2A9, 0x2178}, //6183 #SMALL ROMAN NUMERAL NINE
    {0xA2AA, 0x2179}, //6184 #SMALL ROMAN NUMERAL TEN
    {0xA2B1, 0x2488}, //6185 #DIGIT ONE FULL STOP
    {0xA2B2, 0x2489}, //6186 #DIGIT TWO FULL STOP
    {0xA2B3, 0x248A}, //6187 #DIGIT THREE FULL STOP
    {0xA2B4, 0x248B}, //6188 #DIGIT FOUR FULL STOP
    {0xA2B5, 0x248C}, //6189 #DIGIT FIVE FULL STOP
    {0xA2B6, 0x248D}, //6190 #DIGIT SIX FULL STOP
    {0xA2B7, 0x248E}, //6191 #DIGIT SEVEN FULL STOP
    {0xA2B8, 0x248F}, //6192 #DIGIT EIGHT FULL STOP
    {0xA2B9, 0x2490}, //6193 #DIGIT NINE FULL STOP
    {0xA2BA, 0x2491}, //6194 #NUMBER TEN FULL STOP
    {0xA2BB, 0x2492}, //6195 #NUMBER ELEVEN FULL STOP
    {0xA2BC, 0x2493}, //6196 #NUMBER TWELVE FULL STOP
    {0xA2BD, 0x2494}, //6197 #NUMBER THIRTEEN FULL STOP
    {0xA2BE, 0x2495}, //6198 #NUMBER FOURTEEN FULL STOP
    {0xA2BF, 0x2496}, //6199 #NUMBER FIFTEEN FULL STOP
    {0xA2C0, 0x2497}, //6200 #NUMBER SIXTEEN FULL STOP
    {0xA2C1, 0x2498}, //6201 #NUMBER SEVENTEEN FULL STOP
    {0xA2C2, 0x2499}, //6202 #NUMBER EIGHTEEN FULL STOP
    {0xA2C3, 0x249A}, //6203 #NUMBER NINETEEN FULL STOP
    {0xA2C4, 0x249B}, //6204 #NUMBER TWENTY FULL STOP
    {0xA2C5, 0x2474}, //6205 #PARENTHESIZED DIGIT ONE
    {0xA2C6, 0x2475}, //6206 #PARENTHESIZED DIGIT TWO
    {0xA2C7, 0x2476}, //6207 #PARENTHESIZED DIGIT THREE
    {0xA2C8, 0x2477}, //6208 #PARENTHESIZED DIGIT FOUR
    {0xA2C9, 0x2478}, //6209 #PARENTHESIZED DIGIT FIVE
    {0xA2CA, 0x2479}, //6210 #PARENTHESIZED DIGIT SIX
    {0xA2CB, 0x247A}, //6211 #PARENTHESIZED DIGIT SEVEN
    {0xA2CC, 0x247B}, //6212 #PARENTHESIZED DIGIT EIGHT
    {0xA2CD, 0x247C}, //6213 #PARENTHESIZED DIGIT NINE
    {0xA2CE, 0x247D}, //6214 #PARENTHESIZED NUMBER TEN
    {0xA2CF, 0x247E}, //6215 #PARENTHESIZED NUMBER ELEVEN
    {0xA2D0, 0x247F}, //6216 #PARENTHESIZED NUMBER TWELVE
    {0xA2D1, 0x2480}, //6217 #PARENTHESIZED NUMBER THIRTEEN
    {0xA2D2, 0x2481}, //6218 #PARENTHESIZED NUMBER FOURTEEN
    {0xA2D3, 0x2482}, //6219 #PARENTHESIZED NUMBER FIFTEEN
    {0xA2D4, 0x2483}, //6220 #PARENTHESIZED NUMBER SIXTEEN
    {0xA2D5, 0x2484}, //6221 #PARENTHESIZED NUMBER SEVENTEEN
    {0xA2D6, 0x2485}, //6222 #PARENTHESIZED NUMBER EIGHTEEN
    {0xA2D7, 0x2486}, //6223 #PARENTHESIZED NUMBER NINETEEN
    {0xA2D8, 0x2487}, //6224 #PARENTHESIZED NUMBER TWENTY
    {0xA2D9, 0x2460}, //6225 #CIRCLED DIGIT ONE
    {0xA2DA, 0x2461}, //6226 #CIRCLED DIGIT TWO
    {0xA2DB, 0x2462}, //6227 #CIRCLED DIGIT THREE
    {0xA2DC, 0x2463}, //6228 #CIRCLED DIGIT FOUR
    {0xA2DD, 0x2464}, //6229 #CIRCLED DIGIT FIVE
    {0xA2DE, 0x2465}, //6230 #CIRCLED DIGIT SIX
    {0xA2DF, 0x2466}, //6231 #CIRCLED DIGIT SEVEN
    {0xA2E0, 0x2467}, //6232 #CIRCLED DIGIT EIGHT
    {0xA2E1, 0x2468}, //6233 #CIRCLED DIGIT NINE
    {0xA2E2, 0x2469}, //6234 #CIRCLED NUMBER TEN
    {0xA2E5, 0x3220}, //6235 #PARENTHESIZED IDEOGRAPH ONE
    {0xA2E6, 0x3221}, //6236 #PARENTHESIZED IDEOGRAPH TWO
    {0xA2E7, 0x3222}, //6237 #PARENTHESIZED IDEOGRAPH THREE
    {0xA2E8, 0x3223}, //6238 #PARENTHESIZED IDEOGRAPH FOUR
    {0xA2E9, 0x3224}, //6239 #PARENTHESIZED IDEOGRAPH FIVE
    {0xA2EA, 0x3225}, //6240 #PARENTHESIZED IDEOGRAPH SIX
    {0xA2EB, 0x3226}, //6241 #PARENTHESIZED IDEOGRAPH SEVEN
    {0xA2EC, 0x3227}, //6242 #PARENTHESIZED IDEOGRAPH EIGHT
    {0xA2ED, 0x3228}, //6243 #PARENTHESIZED IDEOGRAPH NINE
    {0xA2EE, 0x3229}, //6244 #PARENTHESIZED IDEOGRAPH TEN
    {0xA2F1, 0x2160}, //6245 #ROMAN NUMERAL ONE
    {0xA2F2, 0x2161}, //6246 #ROMAN NUMERAL TWO
    {0xA2F3, 0x2162}, //6247 #ROMAN NUMERAL THREE
    {0xA2F4, 0x2163}, //6248 #ROMAN NUMERAL FOUR
    {0xA2F5, 0x2164}, //6249 #ROMAN NUMERAL FIVE
    {0xA2F6, 0x2165}, //6250 #ROMAN NUMERAL SIX
    {0xA2F7, 0x2166}, //6251 #ROMAN NUMERAL SEVEN
    {0xA2F8, 0x2167}, //6252 #ROMAN NUMERAL EIGHT
    {0xA2F9, 0x2168}, //6253 #ROMAN NUMERAL NINE
    {0xA2FA, 0x2169}, //6254 #ROMAN NUMERAL TEN
    {0xA2FB, 0x216A}, //6255 #ROMAN NUMERAL ELEVEN
    {0xA2FC, 0x216B}, //6256 #ROMAN NUMERAL TWELVE
    {0xA3A1, 0xFF01}, //6257 #FULLWIDTH EXCLAMATION MARK
    {0xA3A2, 0xFF02}, //6258 #FULLWIDTH QUOTATION MARK
    {0xA3A3, 0xFF03}, //6259 #FULLWIDTH NUMBER SIGN
    {0xA3A4, 0xFFE5}, //6260 #FULLWIDTH YEN SIGN
    {0xA3A5, 0xFF05}, //6261 #FULLWIDTH PERCENT SIGN
    {0xA3A6, 0xFF06}, //6262 #FULLWIDTH AMPERSAND
    {0xA3A7, 0xFF07}, //6263 #FULLWIDTH APOSTROPHE
    {0xA3A8, 0xFF08}, //6264 #FULLWIDTH LEFT PARENTHESIS
    {0xA3A9, 0xFF09}, //6265 #FULLWIDTH RIGHT PARENTHESIS
    {0xA3AA, 0xFF0A}, //6266 #FULLWIDTH ASTERISK
    {0xA3AB, 0xFF0B}, //6267 #FULLWIDTH PLUS SIGN
    {0xA3AC, 0xFF0C}, //6268 #FULLWIDTH COMMA
    {0xA3AD, 0xFF0D}, //6269 #FULLWIDTH HYPHEN-MINUS
    {0xA3AE, 0xFF0E}, //6270 #FULLWIDTH FULL STOP
    {0xA3AF, 0xFF0F}, //6271 #FULLWIDTH SOLIDUS
    {0xA3B0, 0xFF10}, //6272 #FULLWIDTH DIGIT ZERO
    {0xA3B1, 0xFF11}, //6273 #FULLWIDTH DIGIT ONE
    {0xA3B2, 0xFF12}, //6274 #FULLWIDTH DIGIT TWO
    {0xA3B3, 0xFF13}, //6275 #FULLWIDTH DIGIT THREE
    {0xA3B4, 0xFF14}, //6276 #FULLWIDTH DIGIT FOUR
    {0xA3B5, 0xFF15}, //6277 #FULLWIDTH DIGIT FIVE
    {0xA3B6, 0xFF16}, //6278 #FULLWIDTH DIGIT SIX
    {0xA3B7, 0xFF17}, //6279 #FULLWIDTH DIGIT SEVEN
    {0xA3B8, 0xFF18}, //6280 #FULLWIDTH DIGIT EIGHT
    {0xA3B9, 0xFF19}, //6281 #FULLWIDTH DIGIT NINE
    {0xA3BA, 0xFF1A}, //6282 #FULLWIDTH COLON
    {0xA3BB, 0xFF1B}, //6283 #FULLWIDTH SEMICOLON
    {0xA3BC, 0xFF1C}, //6284 #FULLWIDTH LESS-THAN SIGN
    {0xA3BD, 0xFF1D}, //6285 #FULLWIDTH EQUALS SIGN
    {0xA3BE, 0xFF1E}, //6286 #FULLWIDTH GREATER-THAN SIGN
    {0xA3BF, 0xFF1F}, //6287 #FULLWIDTH QUESTION MARK
    {0xA3C0, 0xFF20}, //6288 #FULLWIDTH COMMERCIAL AT
    {0xA3C1, 0xFF21}, //6289 #FULLWIDTH LATIN CAPITAL LETTER A
    {0xA3C2, 0xFF22}, //6290 #FULLWIDTH LATIN CAPITAL LETTER B
    {0xA3C3, 0xFF23}, //6291 #FULLWIDTH LATIN CAPITAL LETTER C
    {0xA3C4, 0xFF24}, //6292 #FULLWIDTH LATIN CAPITAL LETTER D
    {0xA3C5, 0xFF25}, //6293 #FULLWIDTH LATIN CAPITAL LETTER E
    {0xA3C6, 0xFF26}, //6294 #FULLWIDTH LATIN CAPITAL LETTER F
    {0xA3C7, 0xFF27}, //6295 #FULLWIDTH LATIN CAPITAL LETTER G
    {0xA3C8, 0xFF28}, //6296 #FULLWIDTH LATIN CAPITAL LETTER H
    {0xA3C9, 0xFF29}, //6297 #FULLWIDTH LATIN CAPITAL LETTER I
    {0xA3CA, 0xFF2A}, //6298 #FULLWIDTH LATIN CAPITAL LETTER J
    {0xA3CB, 0xFF2B}, //6299 #FULLWIDTH LATIN CAPITAL LETTER K
    {0xA3CC, 0xFF2C}, //6300 #FULLWIDTH LATIN CAPITAL LETTER L
    {0xA3CD, 0xFF2D}, //6301 #FULLWIDTH LATIN CAPITAL LETTER M
    {0xA3CE, 0xFF2E}, //6302 #FULLWIDTH LATIN CAPITAL LETTER N
    {0xA3CF, 0xFF2F}, //6303 #FULLWIDTH LATIN CAPITAL LETTER O
    {0xA3D0, 0xFF30}, //6304 #FULLWIDTH LATIN CAPITAL LETTER P
    {0xA3D1, 0xFF31}, //6305 #FULLWIDTH LATIN CAPITAL LETTER Q
    {0xA3D2, 0xFF32}, //6306 #FULLWIDTH LATIN CAPITAL LETTER R
    {0xA3D3, 0xFF33}, //6307 #FULLWIDTH LATIN CAPITAL LETTER S
    {0xA3D4, 0xFF34}, //6308 #FULLWIDTH LATIN CAPITAL LETTER T
    {0xA3D5, 0xFF35}, //6309 #FULLWIDTH LATIN CAPITAL LETTER U
    {0xA3D6, 0xFF36}, //6310 #FULLWIDTH LATIN CAPITAL LETTER V
    {0xA3D7, 0xFF37}, //6311 #FULLWIDTH LATIN CAPITAL LETTER W
    {0xA3D8, 0xFF38}, //6312 #FULLWIDTH LATIN CAPITAL LETTER X
    {0xA3D9, 0xFF39}, //6313 #FULLWIDTH LATIN CAPITAL LETTER Y
    {0xA3DA, 0xFF3A}, //6314 #FULLWIDTH LATIN CAPITAL LETTER Z
    {0xA3DB, 0xFF3B}, //6315 #FULLWIDTH LEFT SQUARE BRACKET
    {0xA3DC, 0xFF3C}, //6316 #FULLWIDTH REVERSE SOLIDUS
    {0xA3DD, 0xFF3D}, //6317 #FULLWIDTH RIGHT SQUARE BRACKET
    {0xA3DE, 0xFF3E}, //6318 #FULLWIDTH CIRCUMFLEX ACCENT
    {0xA3DF, 0xFF3F}, //6319 #FULLWIDTH LOW LINE
    {0xA3E0, 0xFF40}, //6320 #FULLWIDTH GRAVE ACCENT
    {0xA3E1, 0xFF41}, //6321 #FULLWIDTH LATIN SMALL LETTER A
    {0xA3E2, 0xFF42}, //6322 #FULLWIDTH LATIN SMALL LETTER B
    {0xA3E3, 0xFF43}, //6323 #FULLWIDTH LATIN SMALL LETTER C
    {0xA3E4, 0xFF44}, //6324 #FULLWIDTH LATIN SMALL LETTER D
    {0xA3E5, 0xFF45}, //6325 #FULLWIDTH LATIN SMALL LETTER E
    {0xA3E6, 0xFF46}, //6326 #FULLWIDTH LATIN SMALL LETTER F
    {0xA3E7, 0xFF47}, //6327 #FULLWIDTH LATIN SMALL LETTER G
    {0xA3E8, 0xFF48}, //6328 #FULLWIDTH LATIN SMALL LETTER H
    {0xA3E9, 0xFF49}, //6329 #FULLWIDTH LATIN SMALL LETTER I
    {0xA3EA, 0xFF4A}, //6330 #FULLWIDTH LATIN SMALL LETTER J
    {0xA3EB, 0xFF4B}, //6331 #FULLWIDTH LATIN SMALL LETTER K
    {0xA3EC, 0xFF4C}, //6332 #FULLWIDTH LATIN SMALL LETTER L
    {0xA3ED, 0xFF4D}, //6333 #FULLWIDTH LATIN SMALL LETTER M
    {0xA3EE, 0xFF4E}, //6334 #FULLWIDTH LATIN SMALL LETTER N
    {0xA3EF, 0xFF4F}, //6335 #FULLWIDTH LATIN SMALL LETTER O
    {0xA3F0, 0xFF50}, //6336 #FULLWIDTH LATIN SMALL LETTER P
    {0xA3F1, 0xFF51}, //6337 #FULLWIDTH LATIN SMALL LETTER Q
    {0xA3F2, 0xFF52}, //6338 #FULLWIDTH LATIN SMALL LETTER R
    {0xA3F3, 0xFF53}, //6339 #FULLWIDTH LATIN SMALL LETTER S
    {0xA3F4, 0xFF54}, //6340 #FULLWIDTH LATIN SMALL LETTER T
    {0xA3F5, 0xFF55}, //6341 #FULLWIDTH LATIN SMALL LETTER U
    {0xA3F6, 0xFF56}, //6342 #FULLWIDTH LATIN SMALL LETTER V
    {0xA3F7, 0xFF57}, //6343 #FULLWIDTH LATIN SMALL LETTER W
    {0xA3F8, 0xFF58}, //6344 #FULLWIDTH LATIN SMALL LETTER X
    {0xA3F9, 0xFF59}, //6345 #FULLWIDTH LATIN SMALL LETTER Y
    {0xA3FA, 0xFF5A}, //6346 #FULLWIDTH LATIN SMALL LETTER Z
    {0xA3FB, 0xFF5B}, //6347 #FULLWIDTH LEFT CURLY BRACKET
    {0xA3FC, 0xFF5C}, //6348 #FULLWIDTH VERTICAL LINE
    {0xA3FD, 0xFF5D}, //6349 #FULLWIDTH RIGHT CURLY BRACKET
    {0xA3FE, 0xFFE3}, //6350 #FULLWIDTH MACRON
    {0xA4A1, 0x3041}, //6351 #HIRAGANA LETTER SMALL A
    {0xA4A2, 0x3042}, //6352 #HIRAGANA LETTER A
    {0xA4A3, 0x3043}, //6353 #HIRAGANA LETTER SMALL I
    {0xA4A4, 0x3044}, //6354 #HIRAGANA LETTER I
    {0xA4A5, 0x3045}, //6355 #HIRAGANA LETTER SMALL U
    {0xA4A6, 0x3046}, //6356 #HIRAGANA LETTER U
    {0xA4A7, 0x3047}, //6357 #HIRAGANA LETTER SMALL E
    {0xA4A8, 0x3048}, //6358 #HIRAGANA LETTER E
    {0xA4A9, 0x3049}, //6359 #HIRAGANA LETTER SMALL O
    {0xA4AA, 0x304A}, //6360 #HIRAGANA LETTER O
    {0xA4AB, 0x304B}, //6361 #HIRAGANA LETTER KA
    {0xA4AC, 0x304C}, //6362 #HIRAGANA LETTER GA
    {0xA4AD, 0x304D}, //6363 #HIRAGANA LETTER KI
    {0xA4AE, 0x304E}, //6364 #HIRAGANA LETTER GI
    {0xA4AF, 0x304F}, //6365 #HIRAGANA LETTER KU
    {0xA4B0, 0x3050}, //6366 #HIRAGANA LETTER GU
    {0xA4B1, 0x3051}, //6367 #HIRAGANA LETTER KE
    {0xA4B2, 0x3052}, //6368 #HIRAGANA LETTER GE
    {0xA4B3, 0x3053}, //6369 #HIRAGANA LETTER KO
    {0xA4B4, 0x3054}, //6370 #HIRAGANA LETTER GO
    {0xA4B5, 0x3055}, //6371 #HIRAGANA LETTER SA
    {0xA4B6, 0x3056}, //6372 #HIRAGANA LETTER ZA
    {0xA4B7, 0x3057}, //6373 #HIRAGANA LETTER SI
    {0xA4B8, 0x3058}, //6374 #HIRAGANA LETTER ZI
    {0xA4B9, 0x3059}, //6375 #HIRAGANA LETTER SU
    {0xA4BA, 0x305A}, //6376 #HIRAGANA LETTER ZU
    {0xA4BB, 0x305B}, //6377 #HIRAGANA LETTER SE
    {0xA4BC, 0x305C}, //6378 #HIRAGANA LETTER ZE
    {0xA4BD, 0x305D}, //6379 #HIRAGANA LETTER SO
    {0xA4BE, 0x305E}, //6380 #HIRAGANA LETTER ZO
    {0xA4BF, 0x305F}, //6381 #HIRAGANA LETTER TA
    {0xA4C0, 0x3060}, //6382 #HIRAGANA LETTER DA
    {0xA4C1, 0x3061}, //6383 #HIRAGANA LETTER TI
    {0xA4C2, 0x3062}, //6384 #HIRAGANA LETTER DI
    {0xA4C3, 0x3063}, //6385 #HIRAGANA LETTER SMALL TU
    {0xA4C4, 0x3064}, //6386 #HIRAGANA LETTER TU
    {0xA4C5, 0x3065}, //6387 #HIRAGANA LETTER DU
    {0xA4C6, 0x3066}, //6388 #HIRAGANA LETTER TE
    {0xA4C7, 0x3067}, //6389 #HIRAGANA LETTER DE
    {0xA4C8, 0x3068}, //6390 #HIRAGANA LETTER TO
    {0xA4C9, 0x3069}, //6391 #HIRAGANA LETTER DO
    {0xA4CA, 0x306A}, //6392 #HIRAGANA LETTER NA
    {0xA4CB, 0x306B}, //6393 #HIRAGANA LETTER NI
    {0xA4CC, 0x306C}, //6394 #HIRAGANA LETTER NU
    {0xA4CD, 0x306D}, //6395 #HIRAGANA LETTER NE
    {0xA4CE, 0x306E}, //6396 #HIRAGANA LETTER NO
    {0xA4CF, 0x306F}, //6397 #HIRAGANA LETTER HA
    {0xA4D0, 0x3070}, //6398 #HIRAGANA LETTER BA
    {0xA4D1, 0x3071}, //6399 #HIRAGANA LETTER PA
    {0xA4D2, 0x3072}, //6400 #HIRAGANA LETTER HI
    {0xA4D3, 0x3073}, //6401 #HIRAGANA LETTER BI
    {0xA4D4, 0x3074}, //6402 #HIRAGANA LETTER PI
    {0xA4D5, 0x3075}, //6403 #HIRAGANA LETTER HU
    {0xA4D6, 0x3076}, //6404 #HIRAGANA LETTER BU
    {0xA4D7, 0x3077}, //6405 #HIRAGANA LETTER PU
    {0xA4D8, 0x3078}, //6406 #HIRAGANA LETTER HE
    {0xA4D9, 0x3079}, //6407 #HIRAGANA LETTER BE
    {0xA4DA, 0x307A}, //6408 #HIRAGANA LETTER PE
    {0xA4DB, 0x307B}, //6409 #HIRAGANA LETTER HO
    {0xA4DC, 0x307C}, //6410 #HIRAGANA LETTER BO
    {0xA4DD, 0x307D}, //6411 #HIRAGANA LETTER PO
    {0xA4DE, 0x307E}, //6412 #HIRAGANA LETTER MA
    {0xA4DF, 0x307F}, //6413 #HIRAGANA LETTER MI
    {0xA4E0, 0x3080}, //6414 #HIRAGANA LETTER MU
    {0xA4E1, 0x3081}, //6415 #HIRAGANA LETTER ME
    {0xA4E2, 0x3082}, //6416 #HIRAGANA LETTER MO
    {0xA4E3, 0x3083}, //6417 #HIRAGANA LETTER SMALL YA
    {0xA4E4, 0x3084}, //6418 #HIRAGANA LETTER YA
    {0xA4E5, 0x3085}, //6419 #HIRAGANA LETTER SMALL YU
    {0xA4E6, 0x3086}, //6420 #HIRAGANA LETTER YU
    {0xA4E7, 0x3087}, //6421 #HIRAGANA LETTER SMALL YO
    {0xA4E8, 0x3088}, //6422 #HIRAGANA LETTER YO
    {0xA4E9, 0x3089}, //6423 #HIRAGANA LETTER RA
    {0xA4EA, 0x308A}, //6424 #HIRAGANA LETTER RI
    {0xA4EB, 0x308B}, //6425 #HIRAGANA LETTER RU
    {0xA4EC, 0x308C}, //6426 #HIRAGANA LETTER RE
    {0xA4ED, 0x308D}, //6427 #HIRAGANA LETTER RO
    {0xA4EE, 0x308E}, //6428 #HIRAGANA LETTER SMALL WA
    {0xA4EF, 0x308F}, //6429 #HIRAGANA LETTER WA
    {0xA4F0, 0x3090}, //6430 #HIRAGANA LETTER WI
    {0xA4F1, 0x3091}, //6431 #HIRAGANA LETTER WE
    {0xA4F2, 0x3092}, //6432 #HIRAGANA LETTER WO
    {0xA4F3, 0x3093}, //6433 #HIRAGANA LETTER N
    {0xA5A1, 0x30A1}, //6434 #KATAKANA LETTER SMALL A
    {0xA5A2, 0x30A2}, //6435 #KATAKANA LETTER A
    {0xA5A3, 0x30A3}, //6436 #KATAKANA LETTER SMALL I
    {0xA5A4, 0x30A4}, //6437 #KATAKANA LETTER I
    {0xA5A5, 0x30A5}, //6438 #KATAKANA LETTER SMALL U
    {0xA5A6, 0x30A6}, //6439 #KATAKANA LETTER U
    {0xA5A7, 0x30A7}, //6440 #KATAKANA LETTER SMALL E
    {0xA5A8, 0x30A8}, //6441 #KATAKANA LETTER E
    {0xA5A9, 0x30A9}, //6442 #KATAKANA LETTER SMALL O
    {0xA5AA, 0x30AA}, //6443 #KATAKANA LETTER O
    {0xA5AB, 0x30AB}, //6444 #KATAKANA LETTER KA
    {0xA5AC, 0x30AC}, //6445 #KATAKANA LETTER GA
    {0xA5AD, 0x30AD}, //6446 #KATAKANA LETTER KI
    {0xA5AE, 0x30AE}, //6447 #KATAKANA LETTER GI
    {0xA5AF, 0x30AF}, //6448 #KATAKANA LETTER KU
    {0xA5B0, 0x30B0}, //6449 #KATAKANA LETTER GU
    {0xA5B1, 0x30B1}, //6450 #KATAKANA LETTER KE
    {0xA5B2, 0x30B2}, //6451 #KATAKANA LETTER GE
    {0xA5B3, 0x30B3}, //6452 #KATAKANA LETTER KO
    {0xA5B4, 0x30B4}, //6453 #KATAKANA LETTER GO
    {0xA5B5, 0x30B5}, //6454 #KATAKANA LETTER SA
    {0xA5B6, 0x30B6}, //6455 #KATAKANA LETTER ZA
    {0xA5B7, 0x30B7}, //6456 #KATAKANA LETTER SI
    {0xA5B8, 0x30B8}, //6457 #KATAKANA LETTER ZI
    {0xA5B9, 0x30B9}, //6458 #KATAKANA LETTER SU
    {0xA5BA, 0x30BA}, //6459 #KATAKANA LETTER ZU
    {0xA5BB, 0x30BB}, //6460 #KATAKANA LETTER SE
    {0xA5BC, 0x30BC}, //6461 #KATAKANA LETTER ZE
    {0xA5BD, 0x30BD}, //6462 #KATAKANA LETTER SO
    {0xA5BE, 0x30BE}, //6463 #KATAKANA LETTER ZO
    {0xA5BF, 0x30BF}, //6464 #KATAKANA LETTER TA
    {0xA5C0, 0x30C0}, //6465 #KATAKANA LETTER DA
    {0xA5C1, 0x30C1}, //6466 #KATAKANA LETTER TI
    {0xA5C2, 0x30C2}, //6467 #KATAKANA LETTER DI
    {0xA5C3, 0x30C3}, //6468 #KATAKANA LETTER SMALL TU
    {0xA5C4, 0x30C4}, //6469 #KATAKANA LETTER TU
    {0xA5C5, 0x30C5}, //6470 #KATAKANA LETTER DU
    {0xA5C6, 0x30C6}, //6471 #KATAKANA LETTER TE
    {0xA5C7, 0x30C7}, //6472 #KATAKANA LETTER DE
    {0xA5C8, 0x30C8}, //6473 #KATAKANA LETTER TO
    {0xA5C9, 0x30C9}, //6474 #KATAKANA LETTER DO
    {0xA5CA, 0x30CA}, //6475 #KATAKANA LETTER NA
    {0xA5CB, 0x30CB}, //6476 #KATAKANA LETTER NI
    {0xA5CC, 0x30CC}, //6477 #KATAKANA LETTER NU
    {0xA5CD, 0x30CD}, //6478 #KATAKANA LETTER NE
    {0xA5CE, 0x30CE}, //6479 #KATAKANA LETTER NO
    {0xA5CF, 0x30CF}, //6480 #KATAKANA LETTER HA
    {0xA5D0, 0x30D0}, //6481 #KATAKANA LETTER BA
    {0xA5D1, 0x30D1}, //6482 #KATAKANA LETTER PA
    {0xA5D2, 0x30D2}, //6483 #KATAKANA LETTER HI
    {0xA5D3, 0x30D3}, //6484 #KATAKANA LETTER BI
    {0xA5D4, 0x30D4}, //6485 #KATAKANA LETTER PI
    {0xA5D5, 0x30D5}, //6486 #KATAKANA LETTER HU
    {0xA5D6, 0x30D6}, //6487 #KATAKANA LETTER BU
    {0xA5D7, 0x30D7}, //6488 #KATAKANA LETTER PU
    {0xA5D8, 0x30D8}, //6489 #KATAKANA LETTER HE
    {0xA5D9, 0x30D9}, //6490 #KATAKANA LETTER BE
    {0xA5DA, 0x30DA}, //6491 #KATAKANA LETTER PE
    {0xA5DB, 0x30DB}, //6492 #KATAKANA LETTER HO
    {0xA5DC, 0x30DC}, //6493 #KATAKANA LETTER BO
    {0xA5DD, 0x30DD}, //6494 #KATAKANA LETTER PO
    {0xA5DE, 0x30DE}, //6495 #KATAKANA LETTER MA
    {0xA5DF, 0x30DF}, //6496 #KATAKANA LETTER MI
    {0xA5E0, 0x30E0}, //6497 #KATAKANA LETTER MU
    {0xA5E1, 0x30E1}, //6498 #KATAKANA LETTER ME
    {0xA5E2, 0x30E2}, //6499 #KATAKANA LETTER MO
    {0xA5E3, 0x30E3}, //6500 #KATAKANA LETTER SMALL YA
    {0xA5E4, 0x30E4}, //6501 #KATAKANA LETTER YA
    {0xA5E5, 0x30E5}, //6502 #KATAKANA LETTER SMALL YU
    {0xA5E6, 0x30E6}, //6503 #KATAKANA LETTER YU
    {0xA5E7, 0x30E7}, //6504 #KATAKANA LETTER SMALL YO
    {0xA5E8, 0x30E8}, //6505 #KATAKANA LETTER YO
    {0xA5E9, 0x30E9}, //6506 #KATAKANA LETTER RA
    {0xA5EA, 0x30EA}, //6507 #KATAKANA LETTER RI
    {0xA5EB, 0x30EB}, //6508 #KATAKANA LETTER RU
    {0xA5EC, 0x30EC}, //6509 #KATAKANA LETTER RE
    {0xA5ED, 0x30ED}, //6510 #KATAKANA LETTER RO
    {0xA5EE, 0x30EE}, //6511 #KATAKANA LETTER SMALL WA
    {0xA5EF, 0x30EF}, //6512 #KATAKANA LETTER WA
    {0xA5F0, 0x30F0}, //6513 #KATAKANA LETTER WI
    {0xA5F1, 0x30F1}, //6514 #KATAKANA LETTER WE
    {0xA5F2, 0x30F2}, //6515 #KATAKANA LETTER WO
    {0xA5F3, 0x30F3}, //6516 #KATAKANA LETTER N
    {0xA5F4, 0x30F4}, //6517 #KATAKANA LETTER VU
    {0xA5F5, 0x30F5}, //6518 #KATAKANA LETTER SMALL KA
    {0xA5F6, 0x30F6}, //6519 #KATAKANA LETTER SMALL KE
    {0xA6A1, 0x0391}, //6520 #GREEK CAPITAL LETTER ALPHA
    {0xA6A2, 0x0392}, //6521 #GREEK CAPITAL LETTER BETA
    {0xA6A3, 0x0393}, //6522 #GREEK CAPITAL LETTER GAMMA
    {0xA6A4, 0x0394}, //6523 #GREEK CAPITAL LETTER DELTA
    {0xA6A5, 0x0395}, //6524 #GREEK CAPITAL LETTER EPSILON
    {0xA6A6, 0x0396}, //6525 #GREEK CAPITAL LETTER ZETA
    {0xA6A7, 0x0397}, //6526 #GREEK CAPITAL LETTER ETA
    {0xA6A8, 0x0398}, //6527 #GREEK CAPITAL LETTER THETA
    {0xA6A9, 0x0399}, //6528 #GREEK CAPITAL LETTER IOTA
    {0xA6AA, 0x039A}, //6529 #GREEK CAPITAL LETTER KAPPA
    {0xA6AB, 0x039B}, //6530 #GREEK CAPITAL LETTER LAMDA
    {0xA6AC, 0x039C}, //6531 #GREEK CAPITAL LETTER MU
    {0xA6AD, 0x039D}, //6532 #GREEK CAPITAL LETTER NU
    {0xA6AE, 0x039E}, //6533 #GREEK CAPITAL LETTER XI
    {0xA6AF, 0x039F}, //6534 #GREEK CAPITAL LETTER OMICRON
    {0xA6B0, 0x03A0}, //6535 #GREEK CAPITAL LETTER PI
    {0xA6B1, 0x03A1}, //6536 #GREEK CAPITAL LETTER RHO
    {0xA6B2, 0x03A3}, //6537 #GREEK CAPITAL LETTER SIGMA
    {0xA6B3, 0x03A4}, //6538 #GREEK CAPITAL LETTER TAU
    {0xA6B4, 0x03A5}, //6539 #GREEK CAPITAL LETTER UPSILON
    {0xA6B5, 0x03A6}, //6540 #GREEK CAPITAL LETTER PHI
    {0xA6B6, 0x03A7}, //6541 #GREEK CAPITAL LETTER CHI
    {0xA6B7, 0x03A8}, //6542 #GREEK CAPITAL LETTER PSI
    {0xA6B8, 0x03A9}, //6543 #GREEK CAPITAL LETTER OMEGA
    {0xA6C1, 0x03B1}, //6544 #GREEK SMALL LETTER ALPHA
    {0xA6C2, 0x03B2}, //6545 #GREEK SMALL LETTER BETA
    {0xA6C3, 0x03B3}, //6546 #GREEK SMALL LETTER GAMMA
    {0xA6C4, 0x03B4}, //6547 #GREEK SMALL LETTER DELTA
    {0xA6C5, 0x03B5}, //6548 #GREEK SMALL LETTER EPSILON
    {0xA6C6, 0x03B6}, //6549 #GREEK SMALL LETTER ZETA
    {0xA6C7, 0x03B7}, //6550 #GREEK SMALL LETTER ETA
    {0xA6C8, 0x03B8}, //6551 #GREEK SMALL LETTER THETA
    {0xA6C9, 0x03B9}, //6552 #GREEK SMALL LETTER IOTA
    {0xA6CA, 0x03BA}, //6553 #GREEK SMALL LETTER KAPPA
    {0xA6CB, 0x03BB}, //6554 #GREEK SMALL LETTER LAMDA
    {0xA6CC, 0x03BC}, //6555 #GREEK SMALL LETTER MU
    {0xA6CD, 0x03BD}, //6556 #GREEK SMALL LETTER NU
    {0xA6CE, 0x03BE}, //6557 #GREEK SMALL LETTER XI
    {0xA6CF, 0x03BF}, //6558 #GREEK SMALL LETTER OMICRON
    {0xA6D0, 0x03C0}, //6559 #GREEK SMALL LETTER PI
    {0xA6D1, 0x03C1}, //6560 #GREEK SMALL LETTER RHO
    {0xA6D2, 0x03C3}, //6561 #GREEK SMALL LETTER SIGMA
    {0xA6D3, 0x03C4}, //6562 #GREEK SMALL LETTER TAU
    {0xA6D4, 0x03C5}, //6563 #GREEK SMALL LETTER UPSILON
    {0xA6D5, 0x03C6}, //6564 #GREEK SMALL LETTER PHI
    {0xA6D6, 0x03C7}, //6565 #GREEK SMALL LETTER CHI
    {0xA6D7, 0x03C8}, //6566 #GREEK SMALL LETTER PSI
    {0xA6D8, 0x03C9}, //6567 #GREEK SMALL LETTER OMEGA
    {0xA6E0, 0xFE35}, //6568 #PRESENTATION FORM FOR VERTICAL LEFT PARENTHESIS
    {0xA6E1, 0xFE36}, //6569 #PRESENTATION FORM FOR VERTICAL RIGHT PARENTHESIS
    {0xA6E2, 0xFE39}, //6570 #PRESENTATION FORM FOR VERTICAL LEFT TORTOISE SHELL BRACKET
    {0xA6E3, 0xFE3A}, //6571 #PRESENTATION FORM FOR VERTICAL RIGHT TORTOISE SHELL BRACKET
    {0xA6E4, 0xFE3F}, //6572 #PRESENTATION FORM FOR VERTICAL LEFT ANGLE BRACKET
    {0xA6E5, 0xFE40}, //6573 #PRESENTATION FORM FOR VERTICAL RIGHT ANGLE BRACKET
    {0xA6E6, 0xFE3D}, //6574 #PRESENTATION FORM FOR VERTICAL LEFT DOUBLE ANGLE BRACKET
    {0xA6E7, 0xFE3E}, //6575 #PRESENTATION FORM FOR VERTICAL RIGHT DOUBLE ANGLE BRACKET
    {0xA6E8, 0xFE41}, //6576 #PRESENTATION FORM FOR VERTICAL LEFT CORNER BRACKET
    {0xA6E9, 0xFE42}, //6577 #PRESENTATION FORM FOR VERTICAL RIGHT CORNER BRACKET
    {0xA6EA, 0xFE43}, //6578 #PRESENTATION FORM FOR VERTICAL LEFT WHITE CORNER BRACKET
    {0xA6EB, 0xFE44}, //6579 #PRESENTATION FORM FOR VERTICAL RIGHT WHITE CORNER BRACKET
    {0xA6EE, 0xFE3B}, //6580 #PRESENTATION FORM FOR VERTICAL LEFT BLACK LENTICULAR BRACKET
    {0xA6EF, 0xFE3C}, //6581 #PRESENTATION FORM FOR VERTICAL RIGHT BLACK LENTICULAR BRACKET
    {0xA6F0, 0xFE37}, //6582 #PRESENTATION FORM FOR VERTICAL LEFT CURLY BRACKET
    {0xA6F1, 0xFE38}, //6583 #PRESENTATION FORM FOR VERTICAL RIGHT CURLY BRACKET
    {0xA6F2, 0xFE31}, //6584 #PRESENTATION FORM FOR VERTICAL EM DASH
    {0xA6F4, 0xFE33}, //6585 #PRESENTATION FORM FOR VERTICAL LOW LINE
    {0xA6F5, 0xFE34}, //6586 #PRESENTATION FORM FOR VERTICAL WAVY LOW LINE
    {0xA7A1, 0x0410}, //6587 #CYRILLIC CAPITAL LETTER A
    {0xA7A2, 0x0411}, //6588 #CYRILLIC CAPITAL LETTER BE
    {0xA7A3, 0x0412}, //6589 #CYRILLIC CAPITAL LETTER VE
    {0xA7A4, 0x0413}, //6590 #CYRILLIC CAPITAL LETTER GHE
    {0xA7A5, 0x0414}, //6591 #CYRILLIC CAPITAL LETTER DE
    {0xA7A6, 0x0415}, //6592 #CYRILLIC CAPITAL LETTER IE
    {0xA7A7, 0x0401}, //6593 #CYRILLIC CAPITAL LETTER IO
    {0xA7A8, 0x0416}, //6594 #CYRILLIC CAPITAL LETTER ZHE
    {0xA7A9, 0x0417}, //6595 #CYRILLIC CAPITAL LETTER ZE
    {0xA7AA, 0x0418}, //6596 #CYRILLIC CAPITAL LETTER I
    {0xA7AB, 0x0419}, //6597 #CYRILLIC CAPITAL LETTER SHORT I
    {0xA7AC, 0x041A}, //6598 #CYRILLIC CAPITAL LETTER KA
    {0xA7AD, 0x041B}, //6599 #CYRILLIC CAPITAL LETTER EL
    {0xA7AE, 0x041C}, //6600 #CYRILLIC CAPITAL LETTER EM
    {0xA7AF, 0x041D}, //6601 #CYRILLIC CAPITAL LETTER EN
    {0xA7B0, 0x041E}, //6602 #CYRILLIC CAPITAL LETTER O
    {0xA7B1, 0x041F}, //6603 #CYRILLIC CAPITAL LETTER PE
    {0xA7B2, 0x0420}, //6604 #CYRILLIC CAPITAL LETTER ER
    {0xA7B3, 0x0421}, //6605 #CYRILLIC CAPITAL LETTER ES
    {0xA7B4, 0x0422}, //6606 #CYRILLIC CAPITAL LETTER TE
    {0xA7B5, 0x0423}, //6607 #CYRILLIC CAPITAL LETTER U
    {0xA7B6, 0x0424}, //6608 #CYRILLIC CAPITAL LETTER EF
    {0xA7B7, 0x0425}, //6609 #CYRILLIC CAPITAL LETTER HA
    {0xA7B8, 0x0426}, //6610 #CYRILLIC CAPITAL LETTER TSE
    {0xA7B9, 0x0427}, //6611 #CYRILLIC CAPITAL LETTER CHE
    {0xA7BA, 0x0428}, //6612 #CYRILLIC CAPITAL LETTER SHA
    {0xA7BB, 0x0429}, //6613 #CYRILLIC CAPITAL LETTER SHCHA
    {0xA7BC, 0x042A}, //6614 #CYRILLIC CAPITAL LETTER HARD SIGN
    {0xA7BD, 0x042B}, //6615 #CYRILLIC CAPITAL LETTER YERU
    {0xA7BE, 0x042C}, //6616 #CYRILLIC CAPITAL LETTER SOFT SIGN
    {0xA7BF, 0x042D}, //6617 #CYRILLIC CAPITAL LETTER E
    {0xA7C0, 0x042E}, //6618 #CYRILLIC CAPITAL LETTER YU
    {0xA7C1, 0x042F}, //6619 #CYRILLIC CAPITAL LETTER YA
    {0xA7D1, 0x0430}, //6620 #CYRILLIC SMALL LETTER A
    {0xA7D2, 0x0431}, //6621 #CYRILLIC SMALL LETTER BE
    {0xA7D3, 0x0432}, //6622 #CYRILLIC SMALL LETTER VE
    {0xA7D4, 0x0433}, //6623 #CYRILLIC SMALL LETTER GHE
    {0xA7D5, 0x0434}, //6624 #CYRILLIC SMALL LETTER DE
    {0xA7D6, 0x0435}, //6625 #CYRILLIC SMALL LETTER IE
    {0xA7D7, 0x0451}, //6626 #CYRILLIC SMALL LETTER IO
    {0xA7D8, 0x0436}, //6627 #CYRILLIC SMALL LETTER ZHE
    {0xA7D9, 0x0437}, //6628 #CYRILLIC SMALL LETTER ZE
    {0xA7DA, 0x0438}, //6629 #CYRILLIC SMALL LETTER I
    {0xA7DB, 0x0439}, //6630 #CYRILLIC SMALL LETTER SHORT I
    {0xA7DC, 0x043A}, //6631 #CYRILLIC SMALL LETTER KA
    {0xA7DD, 0x043B}, //6632 #CYRILLIC SMALL LETTER EL
    {0xA7DE, 0x043C}, //6633 #CYRILLIC SMALL LETTER EM
    {0xA7DF, 0x043D}, //6634 #CYRILLIC SMALL LETTER EN
    {0xA7E0, 0x043E}, //6635 #CYRILLIC SMALL LETTER O
    {0xA7E1, 0x043F}, //6636 #CYRILLIC SMALL LETTER PE
    {0xA7E2, 0x0440}, //6637 #CYRILLIC SMALL LETTER ER
    {0xA7E3, 0x0441}, //6638 #CYRILLIC SMALL LETTER ES
    {0xA7E4, 0x0442}, //6639 #CYRILLIC SMALL LETTER TE
    {0xA7E5, 0x0443}, //6640 #CYRILLIC SMALL LETTER U
    {0xA7E6, 0x0444}, //6641 #CYRILLIC SMALL LETTER EF
    {0xA7E7, 0x0445}, //6642 #CYRILLIC SMALL LETTER HA
    {0xA7E8, 0x0446}, //6643 #CYRILLIC SMALL LETTER TSE
    {0xA7E9, 0x0447}, //6644 #CYRILLIC SMALL LETTER CHE
    {0xA7EA, 0x0448}, //6645 #CYRILLIC SMALL LETTER SHA
    {0xA7EB, 0x0449}, //6646 #CYRILLIC SMALL LETTER SHCHA
    {0xA7EC, 0x044A}, //6647 #CYRILLIC SMALL LETTER HARD SIGN
    {0xA7ED, 0x044B}, //6648 #CYRILLIC SMALL LETTER YERU
    {0xA7EE, 0x044C}, //6649 #CYRILLIC SMALL LETTER SOFT SIGN
    {0xA7EF, 0x044D}, //6650 #CYRILLIC SMALL LETTER E
    {0xA7F0, 0x044E}, //6651 #CYRILLIC SMALL LETTER YU
    {0xA7F1, 0x044F}, //6652 #CYRILLIC SMALL LETTER YA
    {0xA840, 0x02CA}, //6653 #MODIFIER LETTER ACUTE ACCENT
    {0xA841, 0x02CB}, //6654 #MODIFIER LETTER GRAVE ACCENT
    {0xA842, 0x02D9}, //6655 #DOT ABOVE
    {0xA843, 0x2013}, //6656 #EN DASH
    {0xA844, 0x2015}, //6657 #HORIZONTAL BAR
    {0xA845, 0x2025}, //6658 #TWO DOT LEADER
    {0xA846, 0x2035}, //6659 #REVERSED PRIME
    {0xA847, 0x2105}, //6660 #CARE OF
    {0xA848, 0x2109}, //6661 #DEGREE FAHRENHEIT
    {0xA849, 0x2196}, //6662 #NORTH WEST ARROW
    {0xA84A, 0x2197}, //6663 #NORTH EAST ARROW
    {0xA84B, 0x2198}, //6664 #SOUTH EAST ARROW
    {0xA84C, 0x2199}, //6665 #SOUTH WEST ARROW
    {0xA84D, 0x2215}, //6666 #DIVISION SLASH
    {0xA84E, 0x221F}, //6667 #RIGHT ANGLE
    {0xA84F, 0x2223}, //6668 #DIVIDES
    {0xA850, 0x2252}, //6669 #APPROXIMATELY EQUAL TO OR THE IMAGE OF
    {0xA851, 0x2266}, //6670 #LESS-THAN OVER EQUAL TO
    {0xA852, 0x2267}, //6671 #GREATER-THAN OVER EQUAL TO
    {0xA853, 0x22BF}, //6672 #RIGHT TRIANGLE
    {0xA854, 0x2550}, //6673 #BOX DRAWINGS DOUBLE HORIZONTAL
    {0xA855, 0x2551}, //6674 #BOX DRAWINGS DOUBLE VERTICAL
    {0xA856, 0x2552}, //6675 #BOX DRAWINGS DOWN SINGLE AND RIGHT DOUBLE
    {0xA857, 0x2553}, //6676 #BOX DRAWINGS DOWN DOUBLE AND RIGHT SINGLE
    {0xA858, 0x2554}, //6677 #BOX DRAWINGS DOUBLE DOWN AND RIGHT
    {0xA859, 0x2555}, //6678 #BOX DRAWINGS DOWN SINGLE AND LEFT DOUBLE
    {0xA85A, 0x2556}, //6679 #BOX DRAWINGS DOWN DOUBLE AND LEFT SINGLE
    {0xA85B, 0x2557}, //6680 #BOX DRAWINGS DOUBLE DOWN AND LEFT
    {0xA85C, 0x2558}, //6681 #BOX DRAWINGS UP SINGLE AND RIGHT DOUBLE
    {0xA85D, 0x2559}, //6682 #BOX DRAWINGS UP DOUBLE AND RIGHT SINGLE
    {0xA85E, 0x255A}, //6683 #BOX DRAWINGS DOUBLE UP AND RIGHT
    {0xA85F, 0x255B}, //6684 #BOX DRAWINGS UP SINGLE AND LEFT DOUBLE
    {0xA860, 0x255C}, //6685 #BOX DRAWINGS UP DOUBLE AND LEFT SINGLE
    {0xA861, 0x255D}, //6686 #BOX DRAWINGS DOUBLE UP AND LEFT
    {0xA862, 0x255E}, //6687 #BOX DRAWINGS VERTICAL SINGLE AND RIGHT DOUBLE
    {0xA863, 0x255F}, //6688 #BOX DRAWINGS VERTICAL DOUBLE AND RIGHT SINGLE
    {0xA864, 0x2560}, //6689 #BOX DRAWINGS DOUBLE VERTICAL AND RIGHT
    {0xA865, 0x2561}, //6690 #BOX DRAWINGS VERTICAL SINGLE AND LEFT DOUBLE
    {0xA866, 0x2562}, //6691 #BOX DRAWINGS VERTICAL DOUBLE AND LEFT SINGLE
    {0xA867, 0x2563}, //6692 #BOX DRAWINGS DOUBLE VERTICAL AND LEFT
    {0xA868, 0x2564}, //6693 #BOX DRAWINGS DOWN SINGLE AND HORIZONTAL DOUBLE
    {0xA869, 0x2565}, //6694 #BOX DRAWINGS DOWN DOUBLE AND HORIZONTAL SINGLE
    {0xA86A, 0x2566}, //6695 #BOX DRAWINGS DOUBLE DOWN AND HORIZONTAL
    {0xA86B, 0x2567}, //6696 #BOX DRAWINGS UP SINGLE AND HORIZONTAL DOUBLE
    {0xA86C, 0x2568}, //6697 #BOX DRAWINGS UP DOUBLE AND HORIZONTAL SINGLE
    {0xA86D, 0x2569}, //6698 #BOX DRAWINGS DOUBLE UP AND HORIZONTAL
    {0xA86E, 0x256A}, //6699 #BOX DRAWINGS VERTICAL SINGLE AND HORIZONTAL DOUBLE
    {0xA86F, 0x256B}, //6700 #BOX DRAWINGS VERTICAL DOUBLE AND HORIZONTAL SINGLE
    {0xA870, 0x256C}, //6701 #BOX DRAWINGS DOUBLE VERTICAL AND HORIZONTAL
    {0xA871, 0x256D}, //6702 #BOX DRAWINGS LIGHT ARC DOWN AND RIGHT
    {0xA872, 0x256E}, //6703 #BOX DRAWINGS LIGHT ARC DOWN AND LEFT
    {0xA873, 0x256F}, //6704 #BOX DRAWINGS LIGHT ARC UP AND LEFT
    {0xA874, 0x2570}, //6705 #BOX DRAWINGS LIGHT ARC UP AND RIGHT
    {0xA875, 0x2571}, //6706 #BOX DRAWINGS LIGHT DIAGONAL UPPER RIGHT TO LOWER LEFT
    {0xA876, 0x2572}, //6707 #BOX DRAWINGS LIGHT DIAGONAL UPPER LEFT TO LOWER RIGHT
    {0xA877, 0x2573}, //6708 #BOX DRAWINGS LIGHT DIAGONAL CROSS
    {0xA878, 0x2581}, //6709 #LOWER ONE EIGHTH BLOCK
    {0xA879, 0x2582}, //6710 #LOWER ONE QUARTER BLOCK
    {0xA87A, 0x2583}, //6711 #LOWER THREE EIGHTHS BLOCK
    {0xA87B, 0x2584}, //6712 #LOWER HALF BLOCK
    {0xA87C, 0x2585}, //6713 #LOWER FIVE EIGHTHS BLOCK
    {0xA87D, 0x2586}, //6714 #LOWER THREE QUARTERS BLOCK
    {0xA87E, 0x2587}, //6715 #LOWER SEVEN EIGHTHS BLOCK
    {0xA880, 0x2588}, //6716 #FULL BLOCK
    {0xA881, 0x2589}, //6717 #LEFT SEVEN EIGHTHS BLOCK
    {0xA882, 0x258A}, //6718 #LEFT THREE QUARTERS BLOCK
    {0xA883, 0x258B}, //6719 #LEFT FIVE EIGHTHS BLOCK
    {0xA884, 0x258C}, //6720 #LEFT HALF BLOCK
    {0xA885, 0x258D}, //6721 #LEFT THREE EIGHTHS BLOCK
    {0xA886, 0x258E}, //6722 #LEFT ONE QUARTER BLOCK
    {0xA887, 0x258F}, //6723 #LEFT ONE EIGHTH BLOCK
    {0xA888, 0x2593}, //6724 #DARK SHADE
    {0xA889, 0x2594}, //6725 #UPPER ONE EIGHTH BLOCK
    {0xA88A, 0x2595}, //6726 #RIGHT ONE EIGHTH BLOCK
    {0xA88B, 0x25BC}, //6727 #BLACK DOWN-POINTING TRIANGLE
    {0xA88C, 0x25BD}, //6728 #WHITE DOWN-POINTING TRIANGLE
    {0xA88D, 0x25E2}, //6729 #BLACK LOWER RIGHT TRIANGLE
    {0xA88E, 0x25E3}, //6730 #BLACK LOWER LEFT TRIANGLE
    {0xA88F, 0x25E4}, //6731 #BLACK UPPER LEFT TRIANGLE
    {0xA890, 0x25E5}, //6732 #BLACK UPPER RIGHT TRIANGLE
    {0xA891, 0x2609}, //6733 #SUN
    {0xA892, 0x2295}, //6734 #CIRCLED PLUS
    {0xA893, 0x3012}, //6735 #POSTAL MARK
    {0xA894, 0x301D}, //6736 #REVERSED DOUBLE PRIME QUOTATION MARK
    {0xA895, 0x301E}, //6737 #DOUBLE PRIME QUOTATION MARK
    {0xA8A1, 0x0101}, //6738 #LATIN SMALL LETTER A WITH MACRON
    {0xA8A2, 0x00E1}, //6739 #LATIN SMALL LETTER A WITH ACUTE
    {0xA8A3, 0x01CE}, //6740 #LATIN SMALL LETTER A WITH CARON
    {0xA8A4, 0x00E0}, //6741 #LATIN SMALL LETTER A WITH GRAVE
    {0xA8A5, 0x0113}, //6742 #LATIN SMALL LETTER E WITH MACRON
    {0xA8A6, 0x00E9}, //6743 #LATIN SMALL LETTER E WITH ACUTE
    {0xA8A7, 0x011B}, //6744 #LATIN SMALL LETTER E WITH CARON
    {0xA8A8, 0x00E8}, //6745 #LATIN SMALL LETTER E WITH GRAVE
    {0xA8A9, 0x012B}, //6746 #LATIN SMALL LETTER I WITH MACRON
    {0xA8AA, 0x00ED}, //6747 #LATIN SMALL LETTER I WITH ACUTE
    {0xA8AB, 0x01D0}, //6748 #LATIN SMALL LETTER I WITH CARON
    {0xA8AC, 0x00EC}, //6749 #LATIN SMALL LETTER I WITH GRAVE
    {0xA8AD, 0x014D}, //6750 #LATIN SMALL LETTER O WITH MACRON
    {0xA8AE, 0x00F3}, //6751 #LATIN SMALL LETTER O WITH ACUTE
    {0xA8AF, 0x01D2}, //6752 #LATIN SMALL LETTER O WITH CARON
    {0xA8B0, 0x00F2}, //6753 #LATIN SMALL LETTER O WITH GRAVE
    {0xA8B1, 0x016B}, //6754 #LATIN SMALL LETTER U WITH MACRON
    {0xA8B2, 0x00FA}, //6755 #LATIN SMALL LETTER U WITH ACUTE
    {0xA8B3, 0x01D4}, //6756 #LATIN SMALL LETTER U WITH CARON
    {0xA8B4, 0x00F9}, //6757 #LATIN SMALL LETTER U WITH GRAVE
    {0xA8B5, 0x01D6}, //6758 #LATIN SMALL LETTER U WITH DIAERESIS AND MACRON
    {0xA8B6, 0x01D8}, //6759 #LATIN SMALL LETTER U WITH DIAERESIS AND ACUTE
    {0xA8B7, 0x01DA}, //6760 #LATIN SMALL LETTER U WITH DIAERESIS AND CARON
    {0xA8B8, 0x01DC}, //6761 #LATIN SMALL LETTER U WITH DIAERESIS AND GRAVE
    {0xA8B9, 0x00FC}, //6762 #LATIN SMALL LETTER U WITH DIAERESIS
    {0xA8BA, 0x00EA}, //6763 #LATIN SMALL LETTER E WITH CIRCUMFLEX
    {0xA8BB, 0x0251}, //6764 #LATIN SMALL LETTER ALPHA
    {0xA8BD, 0x0144}, //6765 #LATIN SMALL LETTER N WITH ACUTE
    {0xA8BE, 0x0148}, //6766 #LATIN SMALL LETTER N WITH CARON
    {0xA8C0, 0x0261}, //6767 #LATIN SMALL LETTER SCRIPT G
    {0xA8C5, 0x3105}, //6768 #BOPOMOFO LETTER B
    {0xA8C6, 0x3106}, //6769 #BOPOMOFO LETTER P
    {0xA8C7, 0x3107}, //6770 #BOPOMOFO LETTER M
    {0xA8C8, 0x3108}, //6771 #BOPOMOFO LETTER F
    {0xA8C9, 0x3109}, //6772 #BOPOMOFO LETTER D
    {0xA8CA, 0x310A}, //6773 #BOPOMOFO LETTER T
    {0xA8CB, 0x310B}, //6774 #BOPOMOFO LETTER N
    {0xA8CC, 0x310C}, //6775 #BOPOMOFO LETTER L
    {0xA8CD, 0x310D}, //6776 #BOPOMOFO LETTER G
    {0xA8CE, 0x310E}, //6777 #BOPOMOFO LETTER K
    {0xA8CF, 0x310F}, //6778 #BOPOMOFO LETTER H
    {0xA8D0, 0x3110}, //6779 #BOPOMOFO LETTER J
    {0xA8D1, 0x3111}, //6780 #BOPOMOFO LETTER Q
    {0xA8D2, 0x3112}, //6781 #BOPOMOFO LETTER X
    {0xA8D3, 0x3113}, //6782 #BOPOMOFO LETTER ZH
    {0xA8D4, 0x3114}, //6783 #BOPOMOFO LETTER CH
    {0xA8D5, 0x3115}, //6784 #BOPOMOFO LETTER SH
    {0xA8D6, 0x3116}, //6785 #BOPOMOFO LETTER R
    {0xA8D7, 0x3117}, //6786 #BOPOMOFO LETTER Z
    {0xA8D8, 0x3118}, //6787 #BOPOMOFO LETTER C
    {0xA8D9, 0x3119}, //6788 #BOPOMOFO LETTER S
    {0xA8DA, 0x311A}, //6789 #BOPOMOFO LETTER A
    {0xA8DB, 0x311B}, //6790 #BOPOMOFO LETTER O
    {0xA8DC, 0x311C}, //6791 #BOPOMOFO LETTER E
    {0xA8DD, 0x311D}, //6792 #BOPOMOFO LETTER EH
    {0xA8DE, 0x311E}, //6793 #BOPOMOFO LETTER AI
    {0xA8DF, 0x311F}, //6794 #BOPOMOFO LETTER EI
    {0xA8E0, 0x3120}, //6795 #BOPOMOFO LETTER AU
    {0xA8E1, 0x3121}, //6796 #BOPOMOFO LETTER OU
    {0xA8E2, 0x3122}, //6797 #BOPOMOFO LETTER AN
    {0xA8E3, 0x3123}, //6798 #BOPOMOFO LETTER EN
    {0xA8E4, 0x3124}, //6799 #BOPOMOFO LETTER ANG
    {0xA8E5, 0x3125}, //6800 #BOPOMOFO LETTER ENG
    {0xA8E6, 0x3126}, //6801 #BOPOMOFO LETTER ER
    {0xA8E7, 0x3127}, //6802 #BOPOMOFO LETTER I
    {0xA8E8, 0x3128}, //6803 #BOPOMOFO LETTER U
    {0xA8E9, 0x3129}, //6804 #BOPOMOFO LETTER IU
    {0xA940, 0x3021}, //6805 #HANGZHOU NUMERAL ONE
    {0xA941, 0x3022}, //6806 #HANGZHOU NUMERAL TWO
    {0xA942, 0x3023}, //6807 #HANGZHOU NUMERAL THREE
    {0xA943, 0x3024}, //6808 #HANGZHOU NUMERAL FOUR
    {0xA944, 0x3025}, //6809 #HANGZHOU NUMERAL FIVE
    {0xA945, 0x3026}, //6810 #HANGZHOU NUMERAL SIX
    {0xA946, 0x3027}, //6811 #HANGZHOU NUMERAL SEVEN
    {0xA947, 0x3028}, //6812 #HANGZHOU NUMERAL EIGHT
    {0xA948, 0x3029}, //6813 #HANGZHOU NUMERAL NINE
    {0xA949, 0x32A3}, //6814 #CIRCLED IDEOGRAPH CORRECT
    {0xA94A, 0x338E}, //6815 #SQUARE MG
    {0xA94B, 0x338F}, //6816 #SQUARE KG
    {0xA94C, 0x339C}, //6817 #SQUARE MM
    {0xA94D, 0x339D}, //6818 #SQUARE CM
    {0xA94E, 0x339E}, //6819 #SQUARE KM
    {0xA94F, 0x33A1}, //6820 #SQUARE M SQUARED
    {0xA950, 0x33C4}, //6821 #SQUARE CC
    {0xA951, 0x33CE}, //6822 #SQUARE KM CAPITAL
    {0xA952, 0x33D1}, //6823 #SQUARE LN
    {0xA953, 0x33D2}, //6824 #SQUARE LOG
    {0xA954, 0x33D5}, //6825 #SQUARE MIL
    {0xA955, 0xFE30}, //6826 #PRESENTATION FORM FOR VERTICAL TWO DOT LEADER
    {0xA956, 0xFFE2}, //6827 #FULLWIDTH NOT SIGN
    {0xA957, 0xFFE4}, //6828 #FULLWIDTH BROKEN BAR
    {0xA959, 0x2121}, //6829 #TELEPHONE SIGN
    {0xA95A, 0x3231}, //6830 #PARENTHESIZED IDEOGRAPH STOCK
    {0xA95C, 0x2010}, //6831 #HYPHEN
    {0xA960, 0x30FC}, //6832 #KATAKANA-HIRAGANA PROLONGED SOUND MARK
    {0xA961, 0x309B}, //6833 #KATAKANA-HIRAGANA VOICED SOUND MARK
    {0xA962, 0x309C}, //6834 #KATAKANA-HIRAGANA SEMI-VOICED SOUND MARK
    {0xA963, 0x30FD}, //6835 #KATAKANA ITERATION MARK
    {0xA964, 0x30FE}, //6836 #KATAKANA VOICED ITERATION MARK
    {0xA965, 0x3006}, //6837 #IDEOGRAPHIC CLOSING MARK
    {0xA966, 0x309D}, //6838 #HIRAGANA ITERATION MARK
    {0xA967, 0x309E}, //6839 #HIRAGANA VOICED ITERATION MARK
    {0xA968, 0xFE49}, //6840 #DASHED OVERLINE
    {0xA969, 0xFE4A}, //6841 #CENTRELINE OVERLINE
    {0xA96A, 0xFE4B}, //6842 #WAVY OVERLINE
    {0xA96B, 0xFE4C}, //6843 #DOUBLE WAVY OVERLINE
    {0xA96C, 0xFE4D}, //6844 #DASHED LOW LINE
    {0xA96D, 0xFE4E}, //6845 #CENTRELINE LOW LINE
    {0xA96E, 0xFE4F}, //6846 #WAVY LOW LINE
    {0xA96F, 0xFE50}, //6847 #SMALL COMMA
    {0xA970, 0xFE51}, //6848 #SMALL IDEOGRAPHIC COMMA
    {0xA971, 0xFE52}, //6849 #SMALL FULL STOP
    {0xA972, 0xFE54}, //6850 #SMALL SEMICOLON
    {0xA973, 0xFE55}, //6851 #SMALL COLON
    {0xA974, 0xFE56}, //6852 #SMALL QUESTION MARK
    {0xA975, 0xFE57}, //6853 #SMALL EXCLAMATION MARK
    {0xA976, 0xFE59}, //6854 #SMALL LEFT PARENTHESIS
    {0xA977, 0xFE5A}, //6855 #SMALL RIGHT PARENTHESIS
    {0xA978, 0xFE5B}, //6856 #SMALL LEFT CURLY BRACKET
    {0xA979, 0xFE5C}, //6857 #SMALL RIGHT CURLY BRACKET
    {0xA97A, 0xFE5D}, //6858 #SMALL LEFT TORTOISE SHELL BRACKET
    {0xA97B, 0xFE5E}, //6859 #SMALL RIGHT TORTOISE SHELL BRACKET
    {0xA97C, 0xFE5F}, //6860 #SMALL NUMBER SIGN
    {0xA97D, 0xFE60}, //6861 #SMALL AMPERSAND
    {0xA97E, 0xFE61}, //6862 #SMALL ASTERISK
    {0xA980, 0xFE62}, //6863 #SMALL PLUS SIGN
    {0xA981, 0xFE63}, //6864 #SMALL HYPHEN-MINUS
    {0xA982, 0xFE64}, //6865 #SMALL LESS-THAN SIGN
    {0xA983, 0xFE65}, //6866 #SMALL GREATER-THAN SIGN
    {0xA984, 0xFE66}, //6867 #SMALL EQUALS SIGN
    {0xA985, 0xFE68}, //6868 #SMALL REVERSE SOLIDUS
    {0xA986, 0xFE69}, //6869 #SMALL DOLLAR SIGN
    {0xA987, 0xFE6A}, //6870 #SMALL PERCENT SIGN
    {0xA988, 0xFE6B}, //6871 #SMALL COMMERCIAL AT
    {0xA996, 0x3007}, //6872 #IDEOGRAPHIC NUMBER ZERO
    {0xA9A4, 0x2500}, //6873 #BOX DRAWINGS LIGHT HORIZONTAL
    {0xA9A5, 0x2501}, //6874 #BOX DRAWINGS HEAVY HORIZONTAL
    {0xA9A6, 0x2502}, //6875 #BOX DRAWINGS LIGHT VERTICAL
    {0xA9A7, 0x2503}, //6876 #BOX DRAWINGS HEAVY VERTICAL
    {0xA9A8, 0x2504}, //6877 #BOX DRAWINGS LIGHT TRIPLE DASH HORIZONTAL
    {0xA9A9, 0x2505}, //6878 #BOX DRAWINGS HEAVY TRIPLE DASH HORIZONTAL
    {0xA9AA, 0x2506}, //6879 #BOX DRAWINGS LIGHT TRIPLE DASH VERTICAL
    {0xA9AB, 0x2507}, //6880 #BOX DRAWINGS HEAVY TRIPLE DASH VERTICAL
    {0xA9AC, 0x2508}, //6881 #BOX DRAWINGS LIGHT QUADRUPLE DASH HORIZONTAL
    {0xA9AD, 0x2509}, //6882 #BOX DRAWINGS HEAVY QUADRUPLE DASH HORIZONTAL
    {0xA9AE, 0x250A}, //6883 #BOX DRAWINGS LIGHT QUADRUPLE DASH VERTICAL
    {0xA9AF, 0x250B}, //6884 #BOX DRAWINGS HEAVY QUADRUPLE DASH VERTICAL
    {0xA9B0, 0x250C}, //6885 #BOX DRAWINGS LIGHT DOWN AND RIGHT
    {0xA9B1, 0x250D}, //6886 #BOX DRAWINGS DOWN LIGHT AND RIGHT HEAVY
    {0xA9B2, 0x250E}, //6887 #BOX DRAWINGS DOWN HEAVY AND RIGHT LIGHT
    {0xA9B3, 0x250F}, //6888 #BOX DRAWINGS HEAVY DOWN AND RIGHT
    {0xA9B4, 0x2510}, //6889 #BOX DRAWINGS LIGHT DOWN AND LEFT
    {0xA9B5, 0x2511}, //6890 #BOX DRAWINGS DOWN LIGHT AND LEFT HEAVY
    {0xA9B6, 0x2512}, //6891 #BOX DRAWINGS DOWN HEAVY AND LEFT LIGHT
    {0xA9B7, 0x2513}, //6892 #BOX DRAWINGS HEAVY DOWN AND LEFT
    {0xA9B8, 0x2514}, //6893 #BOX DRAWINGS LIGHT UP AND RIGHT
    {0xA9B9, 0x2515}, //6894 #BOX DRAWINGS UP LIGHT AND RIGHT HEAVY
    {0xA9BA, 0x2516}, //6895 #BOX DRAWINGS UP HEAVY AND RIGHT LIGHT
    {0xA9BB, 0x2517}, //6896 #BOX DRAWINGS HEAVY UP AND RIGHT
    {0xA9BC, 0x2518}, //6897 #BOX DRAWINGS LIGHT UP AND LEFT
    {0xA9BD, 0x2519}, //6898 #BOX DRAWINGS UP LIGHT AND LEFT HEAVY
    {0xA9BE, 0x251A}, //6899 #BOX DRAWINGS UP HEAVY AND LEFT LIGHT
    {0xA9BF, 0x251B}, //6900 #BOX DRAWINGS HEAVY UP AND LEFT
    {0xA9C0, 0x251C}, //6901 #BOX DRAWINGS LIGHT VERTICAL AND RIGHT
    {0xA9C1, 0x251D}, //6902 #BOX DRAWINGS VERTICAL LIGHT AND RIGHT HEAVY
    {0xA9C2, 0x251E}, //6903 #BOX DRAWINGS UP HEAVY AND RIGHT DOWN LIGHT
    {0xA9C3, 0x251F}, //6904 #BOX DRAWINGS DOWN HEAVY AND RIGHT UP LIGHT
    {0xA9C4, 0x2520}, //6905 #BOX DRAWINGS VERTICAL HEAVY AND RIGHT LIGHT
    {0xA9C5, 0x2521}, //6906 #BOX DRAWINGS DOWN LIGHT AND RIGHT UP HEAVY
    {0xA9C6, 0x2522}, //6907 #BOX DRAWINGS UP LIGHT AND RIGHT DOWN HEAVY
    {0xA9C7, 0x2523}, //6908 #BOX DRAWINGS HEAVY VERTICAL AND RIGHT
    {0xA9C8, 0x2524}, //6909 #BOX DRAWINGS LIGHT VERTICAL AND LEFT
    {0xA9C9, 0x2525}, //6910 #BOX DRAWINGS VERTICAL LIGHT AND LEFT HEAVY
    {0xA9CA, 0x2526}, //6911 #BOX DRAWINGS UP HEAVY AND LEFT DOWN LIGHT
    {0xA9CB, 0x2527}, //6912 #BOX DRAWINGS DOWN HEAVY AND LEFT UP LIGHT
    {0xA9CC, 0x2528}, //6913 #BOX DRAWINGS VERTICAL HEAVY AND LEFT LIGHT
    {0xA9CD, 0x2529}, //6914 #BOX DRAWINGS DOWN LIGHT AND LEFT UP HEAVY
    {0xA9CE, 0x252A}, //6915 #BOX DRAWINGS UP LIGHT AND LEFT DOWN HEAVY
    {0xA9CF, 0x252B}, //6916 #BOX DRAWINGS HEAVY VERTICAL AND LEFT
    {0xA9D0, 0x252C}, //6917 #BOX DRAWINGS LIGHT DOWN AND HORIZONTAL
    {0xA9D1, 0x252D}, //6918 #BOX DRAWINGS LEFT HEAVY AND RIGHT DOWN LIGHT
    {0xA9D2, 0x252E}, //6919 #BOX DRAWINGS RIGHT HEAVY AND LEFT DOWN LIGHT
    {0xA9D3, 0x252F}, //6920 #BOX DRAWINGS DOWN LIGHT AND HORIZONTAL HEAVY
    {0xA9D4, 0x2530}, //6921 #BOX DRAWINGS DOWN HEAVY AND HORIZONTAL LIGHT
    {0xA9D5, 0x2531}, //6922 #BOX DRAWINGS RIGHT LIGHT AND LEFT DOWN HEAVY
    {0xA9D6, 0x2532}, //6923 #BOX DRAWINGS LEFT LIGHT AND RIGHT DOWN HEAVY
    {0xA9D7, 0x2533}, //6924 #BOX DRAWINGS HEAVY DOWN AND HORIZONTAL
    {0xA9D8, 0x2534}, //6925 #BOX DRAWINGS LIGHT UP AND HORIZONTAL
    {0xA9D9, 0x2535}, //6926 #BOX DRAWINGS LEFT HEAVY AND RIGHT UP LIGHT
    {0xA9DA, 0x2536}, //6927 #BOX DRAWINGS RIGHT HEAVY AND LEFT UP LIGHT
    {0xA9DB, 0x2537}, //6928 #BOX DRAWINGS UP LIGHT AND HORIZONTAL HEAVY
    {0xA9DC, 0x2538}, //6929 #BOX DRAWINGS UP HEAVY AND HORIZONTAL LIGHT
    {0xA9DD, 0x2539}, //6930 #BOX DRAWINGS RIGHT LIGHT AND LEFT UP HEAVY
    {0xA9DE, 0x253A}, //6931 #BOX DRAWINGS LEFT LIGHT AND RIGHT UP HEAVY
    {0xA9DF, 0x253B}, //6932 #BOX DRAWINGS HEAVY UP AND HORIZONTAL
    {0xA9E0, 0x253C}, //6933 #BOX DRAWINGS LIGHT VERTICAL AND HORIZONTAL
    {0xA9E1, 0x253D}, //6934 #BOX DRAWINGS LEFT HEAVY AND RIGHT VERTICAL LIGHT
    {0xA9E2, 0x253E}, //6935 #BOX DRAWINGS RIGHT HEAVY AND LEFT VERTICAL LIGHT
    {0xA9E3, 0x253F}, //6936 #BOX DRAWINGS VERTICAL LIGHT AND HORIZONTAL HEAVY
    {0xA9E4, 0x2540}, //6937 #BOX DRAWINGS UP HEAVY AND DOWN HORIZONTAL LIGHT
    {0xA9E5, 0x2541}, //6938 #BOX DRAWINGS DOWN HEAVY AND UP HORIZONTAL LIGHT
    {0xA9E6, 0x2542}, //6939 #BOX DRAWINGS VERTICAL HEAVY AND HORIZONTAL LIGHT
    {0xA9E7, 0x2543}, //6940 #BOX DRAWINGS LEFT UP HEAVY AND RIGHT DOWN LIGHT
    {0xA9E8, 0x2544}, //6941 #BOX DRAWINGS RIGHT UP HEAVY AND LEFT DOWN LIGHT
    {0xA9E9, 0x2545}, //6942 #BOX DRAWINGS LEFT DOWN HEAVY AND RIGHT UP LIGHT
    {0xA9EA, 0x2546}, //6943 #BOX DRAWINGS RIGHT DOWN HEAVY AND LEFT UP LIGHT
    {0xA9EB, 0x2547}, //6944 #BOX DRAWINGS DOWN LIGHT AND UP HORIZONTAL HEAVY
    {0xA9EC, 0x2548}, //6945 #BOX DRAWINGS UP LIGHT AND DOWN HORIZONTAL HEAVY
    {0xA9ED, 0x2549}, //6946 #BOX DRAWINGS RIGHT LIGHT AND LEFT VERTICAL HEAVY
    {0xA9EE, 0x254A}, //6947 #BOX DRAWINGS LEFT LIGHT AND RIGHT VERTICAL HEAVY
    {0xA9EF, 0x254B}, //6948 #BOX DRAWINGS HEAVY VERTICAL AND HORIZONTAL
    {0xAA40, 0x72DC}, //6949 #CJK UNIFIED IDEOGRAPH
    {0xAA41, 0x72DD}, //6950 #CJK UNIFIED IDEOGRAPH
    {0xAA42, 0x72DF}, //6951 #CJK UNIFIED IDEOGRAPH
    {0xAA43, 0x72E2}, //6952 #CJK UNIFIED IDEOGRAPH
    {0xAA44, 0x72E3}, //6953 #CJK UNIFIED IDEOGRAPH
    {0xAA45, 0x72E4}, //6954 #CJK UNIFIED IDEOGRAPH
    {0xAA46, 0x72E5}, //6955 #CJK UNIFIED IDEOGRAPH
    {0xAA47, 0x72E6}, //6956 #CJK UNIFIED IDEOGRAPH
    {0xAA48, 0x72E7}, //6957 #CJK UNIFIED IDEOGRAPH
    {0xAA49, 0x72EA}, //6958 #CJK UNIFIED IDEOGRAPH
    {0xAA4A, 0x72EB}, //6959 #CJK UNIFIED IDEOGRAPH
    {0xAA4B, 0x72F5}, //6960 #CJK UNIFIED IDEOGRAPH
    {0xAA4C, 0x72F6}, //6961 #CJK UNIFIED IDEOGRAPH
    {0xAA4D, 0x72F9}, //6962 #CJK UNIFIED IDEOGRAPH
    {0xAA4E, 0x72FD}, //6963 #CJK UNIFIED IDEOGRAPH
    {0xAA4F, 0x72FE}, //6964 #CJK UNIFIED IDEOGRAPH
    {0xAA50, 0x72FF}, //6965 #CJK UNIFIED IDEOGRAPH
    {0xAA51, 0x7300}, //6966 #CJK UNIFIED IDEOGRAPH
    {0xAA52, 0x7302}, //6967 #CJK UNIFIED IDEOGRAPH
    {0xAA53, 0x7304}, //6968 #CJK UNIFIED IDEOGRAPH
    {0xAA54, 0x7305}, //6969 #CJK UNIFIED IDEOGRAPH
    {0xAA55, 0x7306}, //6970 #CJK UNIFIED IDEOGRAPH
    {0xAA56, 0x7307}, //6971 #CJK UNIFIED IDEOGRAPH
    {0xAA57, 0x7308}, //6972 #CJK UNIFIED IDEOGRAPH
    {0xAA58, 0x7309}, //6973 #CJK UNIFIED IDEOGRAPH
    {0xAA59, 0x730B}, //6974 #CJK UNIFIED IDEOGRAPH
    {0xAA5A, 0x730C}, //6975 #CJK UNIFIED IDEOGRAPH
    {0xAA5B, 0x730D}, //6976 #CJK UNIFIED IDEOGRAPH
    {0xAA5C, 0x730F}, //6977 #CJK UNIFIED IDEOGRAPH
    {0xAA5D, 0x7310}, //6978 #CJK UNIFIED IDEOGRAPH
    {0xAA5E, 0x7311}, //6979 #CJK UNIFIED IDEOGRAPH
    {0xAA5F, 0x7312}, //6980 #CJK UNIFIED IDEOGRAPH
    {0xAA60, 0x7314}, //6981 #CJK UNIFIED IDEOGRAPH
    {0xAA61, 0x7318}, //6982 #CJK UNIFIED IDEOGRAPH
    {0xAA62, 0x7319}, //6983 #CJK UNIFIED IDEOGRAPH
    {0xAA63, 0x731A}, //6984 #CJK UNIFIED IDEOGRAPH
    {0xAA64, 0x731F}, //6985 #CJK UNIFIED IDEOGRAPH
    {0xAA65, 0x7320}, //6986 #CJK UNIFIED IDEOGRAPH
    {0xAA66, 0x7323}, //6987 #CJK UNIFIED IDEOGRAPH
    {0xAA67, 0x7324}, //6988 #CJK UNIFIED IDEOGRAPH
    {0xAA68, 0x7326}, //6989 #CJK UNIFIED IDEOGRAPH
    {0xAA69, 0x7327}, //6990 #CJK UNIFIED IDEOGRAPH
    {0xAA6A, 0x7328}, //6991 #CJK UNIFIED IDEOGRAPH
    {0xAA6B, 0x732D}, //6992 #CJK UNIFIED IDEOGRAPH
    {0xAA6C, 0x732F}, //6993 #CJK UNIFIED IDEOGRAPH
    {0xAA6D, 0x7330}, //6994 #CJK UNIFIED IDEOGRAPH
    {0xAA6E, 0x7332}, //6995 #CJK UNIFIED IDEOGRAPH
    {0xAA6F, 0x7333}, //6996 #CJK UNIFIED IDEOGRAPH
    {0xAA70, 0x7335}, //6997 #CJK UNIFIED IDEOGRAPH
    {0xAA71, 0x7336}, //6998 #CJK UNIFIED IDEOGRAPH
    {0xAA72, 0x733A}, //6999 #CJK UNIFIED IDEOGRAPH
    {0xAA73, 0x733B}, //7000 #CJK UNIFIED IDEOGRAPH
    {0xAA74, 0x733C}, //7001 #CJK UNIFIED IDEOGRAPH
    {0xAA75, 0x733D}, //7002 #CJK UNIFIED IDEOGRAPH
    {0xAA76, 0x7340}, //7003 #CJK UNIFIED IDEOGRAPH
    {0xAA77, 0x7341}, //7004 #CJK UNIFIED IDEOGRAPH
    {0xAA78, 0x7342}, //7005 #CJK UNIFIED IDEOGRAPH
    {0xAA79, 0x7343}, //7006 #CJK UNIFIED IDEOGRAPH
    {0xAA7A, 0x7344}, //7007 #CJK UNIFIED IDEOGRAPH
    {0xAA7B, 0x7345}, //7008 #CJK UNIFIED IDEOGRAPH
    {0xAA7C, 0x7346}, //7009 #CJK UNIFIED IDEOGRAPH
    {0xAA7D, 0x7347}, //7010 #CJK UNIFIED IDEOGRAPH
    {0xAA7E, 0x7348}, //7011 #CJK UNIFIED IDEOGRAPH
    {0xAA80, 0x7349}, //7012 #CJK UNIFIED IDEOGRAPH
    {0xAA81, 0x734A}, //7013 #CJK UNIFIED IDEOGRAPH
    {0xAA82, 0x734B}, //7014 #CJK UNIFIED IDEOGRAPH
    {0xAA83, 0x734C}, //7015 #CJK UNIFIED IDEOGRAPH
    {0xAA84, 0x734E}, //7016 #CJK UNIFIED IDEOGRAPH
    {0xAA85, 0x734F}, //7017 #CJK UNIFIED IDEOGRAPH
    {0xAA86, 0x7351}, //7018 #CJK UNIFIED IDEOGRAPH
    {0xAA87, 0x7353}, //7019 #CJK UNIFIED IDEOGRAPH
    {0xAA88, 0x7354}, //7020 #CJK UNIFIED IDEOGRAPH
    {0xAA89, 0x7355}, //7021 #CJK UNIFIED IDEOGRAPH
    {0xAA8A, 0x7356}, //7022 #CJK UNIFIED IDEOGRAPH
    {0xAA8B, 0x7358}, //7023 #CJK UNIFIED IDEOGRAPH
    {0xAA8C, 0x7359}, //7024 #CJK UNIFIED IDEOGRAPH
    {0xAA8D, 0x735A}, //7025 #CJK UNIFIED IDEOGRAPH
    {0xAA8E, 0x735B}, //7026 #CJK UNIFIED IDEOGRAPH
    {0xAA8F, 0x735C}, //7027 #CJK UNIFIED IDEOGRAPH
    {0xAA90, 0x735D}, //7028 #CJK UNIFIED IDEOGRAPH
    {0xAA91, 0x735E}, //7029 #CJK UNIFIED IDEOGRAPH
    {0xAA92, 0x735F}, //7030 #CJK UNIFIED IDEOGRAPH
    {0xAA93, 0x7361}, //7031 #CJK UNIFIED IDEOGRAPH
    {0xAA94, 0x7362}, //7032 #CJK UNIFIED IDEOGRAPH
    {0xAA95, 0x7363}, //7033 #CJK UNIFIED IDEOGRAPH
    {0xAA96, 0x7364}, //7034 #CJK UNIFIED IDEOGRAPH
    {0xAA97, 0x7365}, //7035 #CJK UNIFIED IDEOGRAPH
    {0xAA98, 0x7366}, //7036 #CJK UNIFIED IDEOGRAPH
    {0xAA99, 0x7367}, //7037 #CJK UNIFIED IDEOGRAPH
    {0xAA9A, 0x7368}, //7038 #CJK UNIFIED IDEOGRAPH
    {0xAA9B, 0x7369}, //7039 #CJK UNIFIED IDEOGRAPH
    {0xAA9C, 0x736A}, //7040 #CJK UNIFIED IDEOGRAPH
    {0xAA9D, 0x736B}, //7041 #CJK UNIFIED IDEOGRAPH
    {0xAA9E, 0x736E}, //7042 #CJK UNIFIED IDEOGRAPH
    {0xAA9F, 0x7370}, //7043 #CJK UNIFIED IDEOGRAPH
    {0xAAA0, 0x7371}, //7044 #CJK UNIFIED IDEOGRAPH
    {0xAB40, 0x7372}, //7045 #CJK UNIFIED IDEOGRAPH
    {0xAB41, 0x7373}, //7046 #CJK UNIFIED IDEOGRAPH
    {0xAB42, 0x7374}, //7047 #CJK UNIFIED IDEOGRAPH
    {0xAB43, 0x7375}, //7048 #CJK UNIFIED IDEOGRAPH
    {0xAB44, 0x7376}, //7049 #CJK UNIFIED IDEOGRAPH
    {0xAB45, 0x7377}, //7050 #CJK UNIFIED IDEOGRAPH
    {0xAB46, 0x7378}, //7051 #CJK UNIFIED IDEOGRAPH
    {0xAB47, 0x7379}, //7052 #CJK UNIFIED IDEOGRAPH
    {0xAB48, 0x737A}, //7053 #CJK UNIFIED IDEOGRAPH
    {0xAB49, 0x737B}, //7054 #CJK UNIFIED IDEOGRAPH
    {0xAB4A, 0x737C}, //7055 #CJK UNIFIED IDEOGRAPH
    {0xAB4B, 0x737D}, //7056 #CJK UNIFIED IDEOGRAPH
    {0xAB4C, 0x737F}, //7057 #CJK UNIFIED IDEOGRAPH
    {0xAB4D, 0x7380}, //7058 #CJK UNIFIED IDEOGRAPH
    {0xAB4E, 0x7381}, //7059 #CJK UNIFIED IDEOGRAPH
    {0xAB4F, 0x7382}, //7060 #CJK UNIFIED IDEOGRAPH
    {0xAB50, 0x7383}, //7061 #CJK UNIFIED IDEOGRAPH
    {0xAB51, 0x7385}, //7062 #CJK UNIFIED IDEOGRAPH
    {0xAB52, 0x7386}, //7063 #CJK UNIFIED IDEOGRAPH
    {0xAB53, 0x7388}, //7064 #CJK UNIFIED IDEOGRAPH
    {0xAB54, 0x738A}, //7065 #CJK UNIFIED IDEOGRAPH
    {0xAB55, 0x738C}, //7066 #CJK UNIFIED IDEOGRAPH
    {0xAB56, 0x738D}, //7067 #CJK UNIFIED IDEOGRAPH
    {0xAB57, 0x738F}, //7068 #CJK UNIFIED IDEOGRAPH
    {0xAB58, 0x7390}, //7069 #CJK UNIFIED IDEOGRAPH
    {0xAB59, 0x7392}, //7070 #CJK UNIFIED IDEOGRAPH
    {0xAB5A, 0x7393}, //7071 #CJK UNIFIED IDEOGRAPH
    {0xAB5B, 0x7394}, //7072 #CJK UNIFIED IDEOGRAPH
    {0xAB5C, 0x7395}, //7073 #CJK UNIFIED IDEOGRAPH
    {0xAB5D, 0x7397}, //7074 #CJK UNIFIED IDEOGRAPH
    {0xAB5E, 0x7398}, //7075 #CJK UNIFIED IDEOGRAPH
    {0xAB5F, 0x7399}, //7076 #CJK UNIFIED IDEOGRAPH
    {0xAB60, 0x739A}, //7077 #CJK UNIFIED IDEOGRAPH
    {0xAB61, 0x739C}, //7078 #CJK UNIFIED IDEOGRAPH
    {0xAB62, 0x739D}, //7079 #CJK UNIFIED IDEOGRAPH
    {0xAB63, 0x739E}, //7080 #CJK UNIFIED IDEOGRAPH
    {0xAB64, 0x73A0}, //7081 #CJK UNIFIED IDEOGRAPH
    {0xAB65, 0x73A1}, //7082 #CJK UNIFIED IDEOGRAPH
    {0xAB66, 0x73A3}, //7083 #CJK UNIFIED IDEOGRAPH
    {0xAB67, 0x73A4}, //7084 #CJK UNIFIED IDEOGRAPH
    {0xAB68, 0x73A5}, //7085 #CJK UNIFIED IDEOGRAPH
    {0xAB69, 0x73A6}, //7086 #CJK UNIFIED IDEOGRAPH
    {0xAB6A, 0x73A7}, //7087 #CJK UNIFIED IDEOGRAPH
    {0xAB6B, 0x73A8}, //7088 #CJK UNIFIED IDEOGRAPH
    {0xAB6C, 0x73AA}, //7089 #CJK UNIFIED IDEOGRAPH
    {0xAB6D, 0x73AC}, //7090 #CJK UNIFIED IDEOGRAPH
    {0xAB6E, 0x73AD}, //7091 #CJK UNIFIED IDEOGRAPH
    {0xAB6F, 0x73B1}, //7092 #CJK UNIFIED IDEOGRAPH
    {0xAB70, 0x73B4}, //7093 #CJK UNIFIED IDEOGRAPH
    {0xAB71, 0x73B5}, //7094 #CJK UNIFIED IDEOGRAPH
    {0xAB72, 0x73B6}, //7095 #CJK UNIFIED IDEOGRAPH
    {0xAB73, 0x73B8}, //7096 #CJK UNIFIED IDEOGRAPH
    {0xAB74, 0x73B9}, //7097 #CJK UNIFIED IDEOGRAPH
    {0xAB75, 0x73BC}, //7098 #CJK UNIFIED IDEOGRAPH
    {0xAB76, 0x73BD}, //7099 #CJK UNIFIED IDEOGRAPH
    {0xAB77, 0x73BE}, //7100 #CJK UNIFIED IDEOGRAPH
    {0xAB78, 0x73BF}, //7101 #CJK UNIFIED IDEOGRAPH
    {0xAB79, 0x73C1}, //7102 #CJK UNIFIED IDEOGRAPH
    {0xAB7A, 0x73C3}, //7103 #CJK UNIFIED IDEOGRAPH
    {0xAB7B, 0x73C4}, //7104 #CJK UNIFIED IDEOGRAPH
    {0xAB7C, 0x73C5}, //7105 #CJK UNIFIED IDEOGRAPH
    {0xAB7D, 0x73C6}, //7106 #CJK UNIFIED IDEOGRAPH
    {0xAB7E, 0x73C7}, //7107 #CJK UNIFIED IDEOGRAPH
    {0xAB80, 0x73CB}, //7108 #CJK UNIFIED IDEOGRAPH
    {0xAB81, 0x73CC}, //7109 #CJK UNIFIED IDEOGRAPH
    {0xAB82, 0x73CE}, //7110 #CJK UNIFIED IDEOGRAPH
    {0xAB83, 0x73D2}, //7111 #CJK UNIFIED IDEOGRAPH
    {0xAB84, 0x73D3}, //7112 #CJK UNIFIED IDEOGRAPH
    {0xAB85, 0x73D4}, //7113 #CJK UNIFIED IDEOGRAPH
    {0xAB86, 0x73D5}, //7114 #CJK UNIFIED IDEOGRAPH
    {0xAB87, 0x73D6}, //7115 #CJK UNIFIED IDEOGRAPH
    {0xAB88, 0x73D7}, //7116 #CJK UNIFIED IDEOGRAPH
    {0xAB89, 0x73D8}, //7117 #CJK UNIFIED IDEOGRAPH
    {0xAB8A, 0x73DA}, //7118 #CJK UNIFIED IDEOGRAPH
    {0xAB8B, 0x73DB}, //7119 #CJK UNIFIED IDEOGRAPH
    {0xAB8C, 0x73DC}, //7120 #CJK UNIFIED IDEOGRAPH
    {0xAB8D, 0x73DD}, //7121 #CJK UNIFIED IDEOGRAPH
    {0xAB8E, 0x73DF}, //7122 #CJK UNIFIED IDEOGRAPH
    {0xAB8F, 0x73E1}, //7123 #CJK UNIFIED IDEOGRAPH
    {0xAB90, 0x73E2}, //7124 #CJK UNIFIED IDEOGRAPH
    {0xAB91, 0x73E3}, //7125 #CJK UNIFIED IDEOGRAPH
    {0xAB92, 0x73E4}, //7126 #CJK UNIFIED IDEOGRAPH
    {0xAB93, 0x73E6}, //7127 #CJK UNIFIED IDEOGRAPH
    {0xAB94, 0x73E8}, //7128 #CJK UNIFIED IDEOGRAPH
    {0xAB95, 0x73EA}, //7129 #CJK UNIFIED IDEOGRAPH
    {0xAB96, 0x73EB}, //7130 #CJK UNIFIED IDEOGRAPH
    {0xAB97, 0x73EC}, //7131 #CJK UNIFIED IDEOGRAPH
    {0xAB98, 0x73EE}, //7132 #CJK UNIFIED IDEOGRAPH
    {0xAB99, 0x73EF}, //7133 #CJK UNIFIED IDEOGRAPH
    {0xAB9A, 0x73F0}, //7134 #CJK UNIFIED IDEOGRAPH
    {0xAB9B, 0x73F1}, //7135 #CJK UNIFIED IDEOGRAPH
    {0xAB9C, 0x73F3}, //7136 #CJK UNIFIED IDEOGRAPH
    {0xAB9D, 0x73F4}, //7137 #CJK UNIFIED IDEOGRAPH
    {0xAB9E, 0x73F5}, //7138 #CJK UNIFIED IDEOGRAPH
    {0xAB9F, 0x73F6}, //7139 #CJK UNIFIED IDEOGRAPH
    {0xABA0, 0x73F7}, //7140 #CJK UNIFIED IDEOGRAPH
    {0xAC40, 0x73F8}, //7141 #CJK UNIFIED IDEOGRAPH
    {0xAC41, 0x73F9}, //7142 #CJK UNIFIED IDEOGRAPH
    {0xAC42, 0x73FA}, //7143 #CJK UNIFIED IDEOGRAPH
    {0xAC43, 0x73FB}, //7144 #CJK UNIFIED IDEOGRAPH
    {0xAC44, 0x73FC}, //7145 #CJK UNIFIED IDEOGRAPH
    {0xAC45, 0x73FD}, //7146 #CJK UNIFIED IDEOGRAPH
    {0xAC46, 0x73FE}, //7147 #CJK UNIFIED IDEOGRAPH
    {0xAC47, 0x73FF}, //7148 #CJK UNIFIED IDEOGRAPH
    {0xAC48, 0x7400}, //7149 #CJK UNIFIED IDEOGRAPH
    {0xAC49, 0x7401}, //7150 #CJK UNIFIED IDEOGRAPH
    {0xAC4A, 0x7402}, //7151 #CJK UNIFIED IDEOGRAPH
    {0xAC4B, 0x7404}, //7152 #CJK UNIFIED IDEOGRAPH
    {0xAC4C, 0x7407}, //7153 #CJK UNIFIED IDEOGRAPH
    {0xAC4D, 0x7408}, //7154 #CJK UNIFIED IDEOGRAPH
    {0xAC4E, 0x740B}, //7155 #CJK UNIFIED IDEOGRAPH
    {0xAC4F, 0x740C}, //7156 #CJK UNIFIED IDEOGRAPH
    {0xAC50, 0x740D}, //7157 #CJK UNIFIED IDEOGRAPH
    {0xAC51, 0x740E}, //7158 #CJK UNIFIED IDEOGRAPH
    {0xAC52, 0x7411}, //7159 #CJK UNIFIED IDEOGRAPH
    {0xAC53, 0x7412}, //7160 #CJK UNIFIED IDEOGRAPH
    {0xAC54, 0x7413}, //7161 #CJK UNIFIED IDEOGRAPH
    {0xAC55, 0x7414}, //7162 #CJK UNIFIED IDEOGRAPH
    {0xAC56, 0x7415}, //7163 #CJK UNIFIED IDEOGRAPH
    {0xAC57, 0x7416}, //7164 #CJK UNIFIED IDEOGRAPH
    {0xAC58, 0x7417}, //7165 #CJK UNIFIED IDEOGRAPH
    {0xAC59, 0x7418}, //7166 #CJK UNIFIED IDEOGRAPH
    {0xAC5A, 0x7419}, //7167 #CJK UNIFIED IDEOGRAPH
    {0xAC5B, 0x741C}, //7168 #CJK UNIFIED IDEOGRAPH
    {0xAC5C, 0x741D}, //7169 #CJK UNIFIED IDEOGRAPH
    {0xAC5D, 0x741E}, //7170 #CJK UNIFIED IDEOGRAPH
    {0xAC5E, 0x741F}, //7171 #CJK UNIFIED IDEOGRAPH
    {0xAC5F, 0x7420}, //7172 #CJK UNIFIED IDEOGRAPH
    {0xAC60, 0x7421}, //7173 #CJK UNIFIED IDEOGRAPH
    {0xAC61, 0x7423}, //7174 #CJK UNIFIED IDEOGRAPH
    {0xAC62, 0x7424}, //7175 #CJK UNIFIED IDEOGRAPH
    {0xAC63, 0x7427}, //7176 #CJK UNIFIED IDEOGRAPH
    {0xAC64, 0x7429}, //7177 #CJK UNIFIED IDEOGRAPH
    {0xAC65, 0x742B}, //7178 #CJK UNIFIED IDEOGRAPH
    {0xAC66, 0x742D}, //7179 #CJK UNIFIED IDEOGRAPH
    {0xAC67, 0x742F}, //7180 #CJK UNIFIED IDEOGRAPH
    {0xAC68, 0x7431}, //7181 #CJK UNIFIED IDEOGRAPH
    {0xAC69, 0x7432}, //7182 #CJK UNIFIED IDEOGRAPH
    {0xAC6A, 0x7437}, //7183 #CJK UNIFIED IDEOGRAPH
    {0xAC6B, 0x7438}, //7184 #CJK UNIFIED IDEOGRAPH
    {0xAC6C, 0x7439}, //7185 #CJK UNIFIED IDEOGRAPH
    {0xAC6D, 0x743A}, //7186 #CJK UNIFIED IDEOGRAPH
    {0xAC6E, 0x743B}, //7187 #CJK UNIFIED IDEOGRAPH
    {0xAC6F, 0x743D}, //7188 #CJK UNIFIED IDEOGRAPH
    {0xAC70, 0x743E}, //7189 #CJK UNIFIED IDEOGRAPH
    {0xAC71, 0x743F}, //7190 #CJK UNIFIED IDEOGRAPH
    {0xAC72, 0x7440}, //7191 #CJK UNIFIED IDEOGRAPH
    {0xAC73, 0x7442}, //7192 #CJK UNIFIED IDEOGRAPH
    {0xAC74, 0x7443}, //7193 #CJK UNIFIED IDEOGRAPH
    {0xAC75, 0x7444}, //7194 #CJK UNIFIED IDEOGRAPH
    {0xAC76, 0x7445}, //7195 #CJK UNIFIED IDEOGRAPH
    {0xAC77, 0x7446}, //7196 #CJK UNIFIED IDEOGRAPH
    {0xAC78, 0x7447}, //7197 #CJK UNIFIED IDEOGRAPH
    {0xAC79, 0x7448}, //7198 #CJK UNIFIED IDEOGRAPH
    {0xAC7A, 0x7449}, //7199 #CJK UNIFIED IDEOGRAPH
    {0xAC7B, 0x744A}, //7200 #CJK UNIFIED IDEOGRAPH
    {0xAC7C, 0x744B}, //7201 #CJK UNIFIED IDEOGRAPH
    {0xAC7D, 0x744C}, //7202 #CJK UNIFIED IDEOGRAPH
    {0xAC7E, 0x744D}, //7203 #CJK UNIFIED IDEOGRAPH
    {0xAC80, 0x744E}, //7204 #CJK UNIFIED IDEOGRAPH
    {0xAC81, 0x744F}, //7205 #CJK UNIFIED IDEOGRAPH
    {0xAC82, 0x7450}, //7206 #CJK UNIFIED IDEOGRAPH
    {0xAC83, 0x7451}, //7207 #CJK UNIFIED IDEOGRAPH
    {0xAC84, 0x7452}, //7208 #CJK UNIFIED IDEOGRAPH
    {0xAC85, 0x7453}, //7209 #CJK UNIFIED IDEOGRAPH
    {0xAC86, 0x7454}, //7210 #CJK UNIFIED IDEOGRAPH
    {0xAC87, 0x7456}, //7211 #CJK UNIFIED IDEOGRAPH
    {0xAC88, 0x7458}, //7212 #CJK UNIFIED IDEOGRAPH
    {0xAC89, 0x745D}, //7213 #CJK UNIFIED IDEOGRAPH
    {0xAC8A, 0x7460}, //7214 #CJK UNIFIED IDEOGRAPH
    {0xAC8B, 0x7461}, //7215 #CJK UNIFIED IDEOGRAPH
    {0xAC8C, 0x7462}, //7216 #CJK UNIFIED IDEOGRAPH
    {0xAC8D, 0x7463}, //7217 #CJK UNIFIED IDEOGRAPH
    {0xAC8E, 0x7464}, //7218 #CJK UNIFIED IDEOGRAPH
    {0xAC8F, 0x7465}, //7219 #CJK UNIFIED IDEOGRAPH
    {0xAC90, 0x7466}, //7220 #CJK UNIFIED IDEOGRAPH
    {0xAC91, 0x7467}, //7221 #CJK UNIFIED IDEOGRAPH
    {0xAC92, 0x7468}, //7222 #CJK UNIFIED IDEOGRAPH
    {0xAC93, 0x7469}, //7223 #CJK UNIFIED IDEOGRAPH
    {0xAC94, 0x746A}, //7224 #CJK UNIFIED IDEOGRAPH
    {0xAC95, 0x746B}, //7225 #CJK UNIFIED IDEOGRAPH
    {0xAC96, 0x746C}, //7226 #CJK UNIFIED IDEOGRAPH
    {0xAC97, 0x746E}, //7227 #CJK UNIFIED IDEOGRAPH
    {0xAC98, 0x746F}, //7228 #CJK UNIFIED IDEOGRAPH
    {0xAC99, 0x7471}, //7229 #CJK UNIFIED IDEOGRAPH
    {0xAC9A, 0x7472}, //7230 #CJK UNIFIED IDEOGRAPH
    {0xAC9B, 0x7473}, //7231 #CJK UNIFIED IDEOGRAPH
    {0xAC9C, 0x7474}, //7232 #CJK UNIFIED IDEOGRAPH
    {0xAC9D, 0x7475}, //7233 #CJK UNIFIED IDEOGRAPH
    {0xAC9E, 0x7478}, //7234 #CJK UNIFIED IDEOGRAPH
    {0xAC9F, 0x7479}, //7235 #CJK UNIFIED IDEOGRAPH
    {0xACA0, 0x747A}, //7236 #CJK UNIFIED IDEOGRAPH
    {0xAD40, 0x747B}, //7237 #CJK UNIFIED IDEOGRAPH
    {0xAD41, 0x747C}, //7238 #CJK UNIFIED IDEOGRAPH
    {0xAD42, 0x747D}, //7239 #CJK UNIFIED IDEOGRAPH
    {0xAD43, 0x747F}, //7240 #CJK UNIFIED IDEOGRAPH
    {0xAD44, 0x7482}, //7241 #CJK UNIFIED IDEOGRAPH
    {0xAD45, 0x7484}, //7242 #CJK UNIFIED IDEOGRAPH
    {0xAD46, 0x7485}, //7243 #CJK UNIFIED IDEOGRAPH
    {0xAD47, 0x7486}, //7244 #CJK UNIFIED IDEOGRAPH
    {0xAD48, 0x7488}, //7245 #CJK UNIFIED IDEOGRAPH
    {0xAD49, 0x7489}, //7246 #CJK UNIFIED IDEOGRAPH
    {0xAD4A, 0x748A}, //7247 #CJK UNIFIED IDEOGRAPH
    {0xAD4B, 0x748C}, //7248 #CJK UNIFIED IDEOGRAPH
    {0xAD4C, 0x748D}, //7249 #CJK UNIFIED IDEOGRAPH
    {0xAD4D, 0x748F}, //7250 #CJK UNIFIED IDEOGRAPH
    {0xAD4E, 0x7491}, //7251 #CJK UNIFIED IDEOGRAPH
    {0xAD4F, 0x7492}, //7252 #CJK UNIFIED IDEOGRAPH
    {0xAD50, 0x7493}, //7253 #CJK UNIFIED IDEOGRAPH
    {0xAD51, 0x7494}, //7254 #CJK UNIFIED IDEOGRAPH
    {0xAD52, 0x7495}, //7255 #CJK UNIFIED IDEOGRAPH
    {0xAD53, 0x7496}, //7256 #CJK UNIFIED IDEOGRAPH
    {0xAD54, 0x7497}, //7257 #CJK UNIFIED IDEOGRAPH
    {0xAD55, 0x7498}, //7258 #CJK UNIFIED IDEOGRAPH
    {0xAD56, 0x7499}, //7259 #CJK UNIFIED IDEOGRAPH
    {0xAD57, 0x749A}, //7260 #CJK UNIFIED IDEOGRAPH
    {0xAD58, 0x749B}, //7261 #CJK UNIFIED IDEOGRAPH
    {0xAD59, 0x749D}, //7262 #CJK UNIFIED IDEOGRAPH
    {0xAD5A, 0x749F}, //7263 #CJK UNIFIED IDEOGRAPH
    {0xAD5B, 0x74A0}, //7264 #CJK UNIFIED IDEOGRAPH
    {0xAD5C, 0x74A1}, //7265 #CJK UNIFIED IDEOGRAPH
    {0xAD5D, 0x74A2}, //7266 #CJK UNIFIED IDEOGRAPH
    {0xAD5E, 0x74A3}, //7267 #CJK UNIFIED IDEOGRAPH
    {0xAD5F, 0x74A4}, //7268 #CJK UNIFIED IDEOGRAPH
    {0xAD60, 0x74A5}, //7269 #CJK UNIFIED IDEOGRAPH
    {0xAD61, 0x74A6}, //7270 #CJK UNIFIED IDEOGRAPH
    {0xAD62, 0x74AA}, //7271 #CJK UNIFIED IDEOGRAPH
    {0xAD63, 0x74AB}, //7272 #CJK UNIFIED IDEOGRAPH
    {0xAD64, 0x74AC}, //7273 #CJK UNIFIED IDEOGRAPH
    {0xAD65, 0x74AD}, //7274 #CJK UNIFIED IDEOGRAPH
    {0xAD66, 0x74AE}, //7275 #CJK UNIFIED IDEOGRAPH
    {0xAD67, 0x74AF}, //7276 #CJK UNIFIED IDEOGRAPH
    {0xAD68, 0x74B0}, //7277 #CJK UNIFIED IDEOGRAPH
    {0xAD69, 0x74B1}, //7278 #CJK UNIFIED IDEOGRAPH
    {0xAD6A, 0x74B2}, //7279 #CJK UNIFIED IDEOGRAPH
    {0xAD6B, 0x74B3}, //7280 #CJK UNIFIED IDEOGRAPH
    {0xAD6C, 0x74B4}, //7281 #CJK UNIFIED IDEOGRAPH
    {0xAD6D, 0x74B5}, //7282 #CJK UNIFIED IDEOGRAPH
    {0xAD6E, 0x74B6}, //7283 #CJK UNIFIED IDEOGRAPH
    {0xAD6F, 0x74B7}, //7284 #CJK UNIFIED IDEOGRAPH
    {0xAD70, 0x74B8}, //7285 #CJK UNIFIED IDEOGRAPH
    {0xAD71, 0x74B9}, //7286 #CJK UNIFIED IDEOGRAPH
    {0xAD72, 0x74BB}, //7287 #CJK UNIFIED IDEOGRAPH
    {0xAD73, 0x74BC}, //7288 #CJK UNIFIED IDEOGRAPH
    {0xAD74, 0x74BD}, //7289 #CJK UNIFIED IDEOGRAPH
    {0xAD75, 0x74BE}, //7290 #CJK UNIFIED IDEOGRAPH
    {0xAD76, 0x74BF}, //7291 #CJK UNIFIED IDEOGRAPH
    {0xAD77, 0x74C0}, //7292 #CJK UNIFIED IDEOGRAPH
    {0xAD78, 0x74C1}, //7293 #CJK UNIFIED IDEOGRAPH
    {0xAD79, 0x74C2}, //7294 #CJK UNIFIED IDEOGRAPH
    {0xAD7A, 0x74C3}, //7295 #CJK UNIFIED IDEOGRAPH
    {0xAD7B, 0x74C4}, //7296 #CJK UNIFIED IDEOGRAPH
    {0xAD7C, 0x74C5}, //7297 #CJK UNIFIED IDEOGRAPH
    {0xAD7D, 0x74C6}, //7298 #CJK UNIFIED IDEOGRAPH
    {0xAD7E, 0x74C7}, //7299 #CJK UNIFIED IDEOGRAPH
    {0xAD80, 0x74C8}, //7300 #CJK UNIFIED IDEOGRAPH
    {0xAD81, 0x74C9}, //7301 #CJK UNIFIED IDEOGRAPH
    {0xAD82, 0x74CA}, //7302 #CJK UNIFIED IDEOGRAPH
    {0xAD83, 0x74CB}, //7303 #CJK UNIFIED IDEOGRAPH
    {0xAD84, 0x74CC}, //7304 #CJK UNIFIED IDEOGRAPH
    {0xAD85, 0x74CD}, //7305 #CJK UNIFIED IDEOGRAPH
    {0xAD86, 0x74CE}, //7306 #CJK UNIFIED IDEOGRAPH
    {0xAD87, 0x74CF}, //7307 #CJK UNIFIED IDEOGRAPH
    {0xAD88, 0x74D0}, //7308 #CJK UNIFIED IDEOGRAPH
    {0xAD89, 0x74D1}, //7309 #CJK UNIFIED IDEOGRAPH
    {0xAD8A, 0x74D3}, //7310 #CJK UNIFIED IDEOGRAPH
    {0xAD8B, 0x74D4}, //7311 #CJK UNIFIED IDEOGRAPH
    {0xAD8C, 0x74D5}, //7312 #CJK UNIFIED IDEOGRAPH
    {0xAD8D, 0x74D6}, //7313 #CJK UNIFIED IDEOGRAPH
    {0xAD8E, 0x74D7}, //7314 #CJK UNIFIED IDEOGRAPH
    {0xAD8F, 0x74D8}, //7315 #CJK UNIFIED IDEOGRAPH
    {0xAD90, 0x74D9}, //7316 #CJK UNIFIED IDEOGRAPH
    {0xAD91, 0x74DA}, //7317 #CJK UNIFIED IDEOGRAPH
    {0xAD92, 0x74DB}, //7318 #CJK UNIFIED IDEOGRAPH
    {0xAD93, 0x74DD}, //7319 #CJK UNIFIED IDEOGRAPH
    {0xAD94, 0x74DF}, //7320 #CJK UNIFIED IDEOGRAPH
    {0xAD95, 0x74E1}, //7321 #CJK UNIFIED IDEOGRAPH
    {0xAD96, 0x74E5}, //7322 #CJK UNIFIED IDEOGRAPH
    {0xAD97, 0x74E7}, //7323 #CJK UNIFIED IDEOGRAPH
    {0xAD98, 0x74E8}, //7324 #CJK UNIFIED IDEOGRAPH
    {0xAD99, 0x74E9}, //7325 #CJK UNIFIED IDEOGRAPH
    {0xAD9A, 0x74EA}, //7326 #CJK UNIFIED IDEOGRAPH
    {0xAD9B, 0x74EB}, //7327 #CJK UNIFIED IDEOGRAPH
    {0xAD9C, 0x74EC}, //7328 #CJK UNIFIED IDEOGRAPH
    {0xAD9D, 0x74ED}, //7329 #CJK UNIFIED IDEOGRAPH
    {0xAD9E, 0x74F0}, //7330 #CJK UNIFIED IDEOGRAPH
    {0xAD9F, 0x74F1}, //7331 #CJK UNIFIED IDEOGRAPH
    {0xADA0, 0x74F2}, //7332 #CJK UNIFIED IDEOGRAPH
    {0xAE40, 0x74F3}, //7333 #CJK UNIFIED IDEOGRAPH
    {0xAE41, 0x74F5}, //7334 #CJK UNIFIED IDEOGRAPH
    {0xAE42, 0x74F8}, //7335 #CJK UNIFIED IDEOGRAPH
    {0xAE43, 0x74F9}, //7336 #CJK UNIFIED IDEOGRAPH
    {0xAE44, 0x74FA}, //7337 #CJK UNIFIED IDEOGRAPH
    {0xAE45, 0x74FB}, //7338 #CJK UNIFIED IDEOGRAPH
    {0xAE46, 0x74FC}, //7339 #CJK UNIFIED IDEOGRAPH
    {0xAE47, 0x74FD}, //7340 #CJK UNIFIED IDEOGRAPH
    {0xAE48, 0x74FE}, //7341 #CJK UNIFIED IDEOGRAPH
    {0xAE49, 0x7500}, //7342 #CJK UNIFIED IDEOGRAPH
    {0xAE4A, 0x7501}, //7343 #CJK UNIFIED IDEOGRAPH
    {0xAE4B, 0x7502}, //7344 #CJK UNIFIED IDEOGRAPH
    {0xAE4C, 0x7503}, //7345 #CJK UNIFIED IDEOGRAPH
    {0xAE4D, 0x7505}, //7346 #CJK UNIFIED IDEOGRAPH
    {0xAE4E, 0x7506}, //7347 #CJK UNIFIED IDEOGRAPH
    {0xAE4F, 0x7507}, //7348 #CJK UNIFIED IDEOGRAPH
    {0xAE50, 0x7508}, //7349 #CJK UNIFIED IDEOGRAPH
    {0xAE51, 0x7509}, //7350 #CJK UNIFIED IDEOGRAPH
    {0xAE52, 0x750A}, //7351 #CJK UNIFIED IDEOGRAPH
    {0xAE53, 0x750B}, //7352 #CJK UNIFIED IDEOGRAPH
    {0xAE54, 0x750C}, //7353 #CJK UNIFIED IDEOGRAPH
    {0xAE55, 0x750E}, //7354 #CJK UNIFIED IDEOGRAPH
    {0xAE56, 0x7510}, //7355 #CJK UNIFIED IDEOGRAPH
    {0xAE57, 0x7512}, //7356 #CJK UNIFIED IDEOGRAPH
    {0xAE58, 0x7514}, //7357 #CJK UNIFIED IDEOGRAPH
    {0xAE59, 0x7515}, //7358 #CJK UNIFIED IDEOGRAPH
    {0xAE5A, 0x7516}, //7359 #CJK UNIFIED IDEOGRAPH
    {0xAE5B, 0x7517}, //7360 #CJK UNIFIED IDEOGRAPH
    {0xAE5C, 0x751B}, //7361 #CJK UNIFIED IDEOGRAPH
    {0xAE5D, 0x751D}, //7362 #CJK UNIFIED IDEOGRAPH
    {0xAE5E, 0x751E}, //7363 #CJK UNIFIED IDEOGRAPH
    {0xAE5F, 0x7520}, //7364 #CJK UNIFIED IDEOGRAPH
    {0xAE60, 0x7521}, //7365 #CJK UNIFIED IDEOGRAPH
    {0xAE61, 0x7522}, //7366 #CJK UNIFIED IDEOGRAPH
    {0xAE62, 0x7523}, //7367 #CJK UNIFIED IDEOGRAPH
    {0xAE63, 0x7524}, //7368 #CJK UNIFIED IDEOGRAPH
    {0xAE64, 0x7526}, //7369 #CJK UNIFIED IDEOGRAPH
    {0xAE65, 0x7527}, //7370 #CJK UNIFIED IDEOGRAPH
    {0xAE66, 0x752A}, //7371 #CJK UNIFIED IDEOGRAPH
    {0xAE67, 0x752E}, //7372 #CJK UNIFIED IDEOGRAPH
    {0xAE68, 0x7534}, //7373 #CJK UNIFIED IDEOGRAPH
    {0xAE69, 0x7536}, //7374 #CJK UNIFIED IDEOGRAPH
    {0xAE6A, 0x7539}, //7375 #CJK UNIFIED IDEOGRAPH
    {0xAE6B, 0x753C}, //7376 #CJK UNIFIED IDEOGRAPH
    {0xAE6C, 0x753D}, //7377 #CJK UNIFIED IDEOGRAPH
    {0xAE6D, 0x753F}, //7378 #CJK UNIFIED IDEOGRAPH
    {0xAE6E, 0x7541}, //7379 #CJK UNIFIED IDEOGRAPH
    {0xAE6F, 0x7542}, //7380 #CJK UNIFIED IDEOGRAPH
    {0xAE70, 0x7543}, //7381 #CJK UNIFIED IDEOGRAPH
    {0xAE71, 0x7544}, //7382 #CJK UNIFIED IDEOGRAPH
    {0xAE72, 0x7546}, //7383 #CJK UNIFIED IDEOGRAPH
    {0xAE73, 0x7547}, //7384 #CJK UNIFIED IDEOGRAPH
    {0xAE74, 0x7549}, //7385 #CJK UNIFIED IDEOGRAPH
    {0xAE75, 0x754A}, //7386 #CJK UNIFIED IDEOGRAPH
    {0xAE76, 0x754D}, //7387 #CJK UNIFIED IDEOGRAPH
    {0xAE77, 0x7550}, //7388 #CJK UNIFIED IDEOGRAPH
    {0xAE78, 0x7551}, //7389 #CJK UNIFIED IDEOGRAPH
    {0xAE79, 0x7552}, //7390 #CJK UNIFIED IDEOGRAPH
    {0xAE7A, 0x7553}, //7391 #CJK UNIFIED IDEOGRAPH
    {0xAE7B, 0x7555}, //7392 #CJK UNIFIED IDEOGRAPH
    {0xAE7C, 0x7556}, //7393 #CJK UNIFIED IDEOGRAPH
    {0xAE7D, 0x7557}, //7394 #CJK UNIFIED IDEOGRAPH
    {0xAE7E, 0x7558}, //7395 #CJK UNIFIED IDEOGRAPH
    {0xAE80, 0x755D}, //7396 #CJK UNIFIED IDEOGRAPH
    {0xAE81, 0x755E}, //7397 #CJK UNIFIED IDEOGRAPH
    {0xAE82, 0x755F}, //7398 #CJK UNIFIED IDEOGRAPH
    {0xAE83, 0x7560}, //7399 #CJK UNIFIED IDEOGRAPH
    {0xAE84, 0x7561}, //7400 #CJK UNIFIED IDEOGRAPH
    {0xAE85, 0x7562}, //7401 #CJK UNIFIED IDEOGRAPH
    {0xAE86, 0x7563}, //7402 #CJK UNIFIED IDEOGRAPH
    {0xAE87, 0x7564}, //7403 #CJK UNIFIED IDEOGRAPH
    {0xAE88, 0x7567}, //7404 #CJK UNIFIED IDEOGRAPH
    {0xAE89, 0x7568}, //7405 #CJK UNIFIED IDEOGRAPH
    {0xAE8A, 0x7569}, //7406 #CJK UNIFIED IDEOGRAPH
    {0xAE8B, 0x756B}, //7407 #CJK UNIFIED IDEOGRAPH
    {0xAE8C, 0x756C}, //7408 #CJK UNIFIED IDEOGRAPH
    {0xAE8D, 0x756D}, //7409 #CJK UNIFIED IDEOGRAPH
    {0xAE8E, 0x756E}, //7410 #CJK UNIFIED IDEOGRAPH
    {0xAE8F, 0x756F}, //7411 #CJK UNIFIED IDEOGRAPH
    {0xAE90, 0x7570}, //7412 #CJK UNIFIED IDEOGRAPH
    {0xAE91, 0x7571}, //7413 #CJK UNIFIED IDEOGRAPH
    {0xAE92, 0x7573}, //7414 #CJK UNIFIED IDEOGRAPH
    {0xAE93, 0x7575}, //7415 #CJK UNIFIED IDEOGRAPH
    {0xAE94, 0x7576}, //7416 #CJK UNIFIED IDEOGRAPH
    {0xAE95, 0x7577}, //7417 #CJK UNIFIED IDEOGRAPH
    {0xAE96, 0x757A}, //7418 #CJK UNIFIED IDEOGRAPH
    {0xAE97, 0x757B}, //7419 #CJK UNIFIED IDEOGRAPH
    {0xAE98, 0x757C}, //7420 #CJK UNIFIED IDEOGRAPH
    {0xAE99, 0x757D}, //7421 #CJK UNIFIED IDEOGRAPH
    {0xAE9A, 0x757E}, //7422 #CJK UNIFIED IDEOGRAPH
    {0xAE9B, 0x7580}, //7423 #CJK UNIFIED IDEOGRAPH
    {0xAE9C, 0x7581}, //7424 #CJK UNIFIED IDEOGRAPH
    {0xAE9D, 0x7582}, //7425 #CJK UNIFIED IDEOGRAPH
    {0xAE9E, 0x7584}, //7426 #CJK UNIFIED IDEOGRAPH
    {0xAE9F, 0x7585}, //7427 #CJK UNIFIED IDEOGRAPH
    {0xAEA0, 0x7587}, //7428 #CJK UNIFIED IDEOGRAPH
    {0xAF40, 0x7588}, //7429 #CJK UNIFIED IDEOGRAPH
    {0xAF41, 0x7589}, //7430 #CJK UNIFIED IDEOGRAPH
    {0xAF42, 0x758A}, //7431 #CJK UNIFIED IDEOGRAPH
    {0xAF43, 0x758C}, //7432 #CJK UNIFIED IDEOGRAPH
    {0xAF44, 0x758D}, //7433 #CJK UNIFIED IDEOGRAPH
    {0xAF45, 0x758E}, //7434 #CJK UNIFIED IDEOGRAPH
    {0xAF46, 0x7590}, //7435 #CJK UNIFIED IDEOGRAPH
    {0xAF47, 0x7593}, //7436 #CJK UNIFIED IDEOGRAPH
    {0xAF48, 0x7595}, //7437 #CJK UNIFIED IDEOGRAPH
    {0xAF49, 0x7598}, //7438 #CJK UNIFIED IDEOGRAPH
    {0xAF4A, 0x759B}, //7439 #CJK UNIFIED IDEOGRAPH
    {0xAF4B, 0x759C}, //7440 #CJK UNIFIED IDEOGRAPH
    {0xAF4C, 0x759E}, //7441 #CJK UNIFIED IDEOGRAPH
    {0xAF4D, 0x75A2}, //7442 #CJK UNIFIED IDEOGRAPH
    {0xAF4E, 0x75A6}, //7443 #CJK UNIFIED IDEOGRAPH
    {0xAF4F, 0x75A7}, //7444 #CJK UNIFIED IDEOGRAPH
    {0xAF50, 0x75A8}, //7445 #CJK UNIFIED IDEOGRAPH
    {0xAF51, 0x75A9}, //7446 #CJK UNIFIED IDEOGRAPH
    {0xAF52, 0x75AA}, //7447 #CJK UNIFIED IDEOGRAPH
    {0xAF53, 0x75AD}, //7448 #CJK UNIFIED IDEOGRAPH
    {0xAF54, 0x75B6}, //7449 #CJK UNIFIED IDEOGRAPH
    {0xAF55, 0x75B7}, //7450 #CJK UNIFIED IDEOGRAPH
    {0xAF56, 0x75BA}, //7451 #CJK UNIFIED IDEOGRAPH
    {0xAF57, 0x75BB}, //7452 #CJK UNIFIED IDEOGRAPH
    {0xAF58, 0x75BF}, //7453 #CJK UNIFIED IDEOGRAPH
    {0xAF59, 0x75C0}, //7454 #CJK UNIFIED IDEOGRAPH
    {0xAF5A, 0x75C1}, //7455 #CJK UNIFIED IDEOGRAPH
    {0xAF5B, 0x75C6}, //7456 #CJK UNIFIED IDEOGRAPH
    {0xAF5C, 0x75CB}, //7457 #CJK UNIFIED IDEOGRAPH
    {0xAF5D, 0x75CC}, //7458 #CJK UNIFIED IDEOGRAPH
    {0xAF5E, 0x75CE}, //7459 #CJK UNIFIED IDEOGRAPH
    {0xAF5F, 0x75CF}, //7460 #CJK UNIFIED IDEOGRAPH
    {0xAF60, 0x75D0}, //7461 #CJK UNIFIED IDEOGRAPH
    {0xAF61, 0x75D1}, //7462 #CJK UNIFIED IDEOGRAPH
    {0xAF62, 0x75D3}, //7463 #CJK UNIFIED IDEOGRAPH
    {0xAF63, 0x75D7}, //7464 #CJK UNIFIED IDEOGRAPH
    {0xAF64, 0x75D9}, //7465 #CJK UNIFIED IDEOGRAPH
    {0xAF65, 0x75DA}, //7466 #CJK UNIFIED IDEOGRAPH
    {0xAF66, 0x75DC}, //7467 #CJK UNIFIED IDEOGRAPH
    {0xAF67, 0x75DD}, //7468 #CJK UNIFIED IDEOGRAPH
    {0xAF68, 0x75DF}, //7469 #CJK UNIFIED IDEOGRAPH
    {0xAF69, 0x75E0}, //7470 #CJK UNIFIED IDEOGRAPH
    {0xAF6A, 0x75E1}, //7471 #CJK UNIFIED IDEOGRAPH
    {0xAF6B, 0x75E5}, //7472 #CJK UNIFIED IDEOGRAPH
    {0xAF6C, 0x75E9}, //7473 #CJK UNIFIED IDEOGRAPH
    {0xAF6D, 0x75EC}, //7474 #CJK UNIFIED IDEOGRAPH
    {0xAF6E, 0x75ED}, //7475 #CJK UNIFIED IDEOGRAPH
    {0xAF6F, 0x75EE}, //7476 #CJK UNIFIED IDEOGRAPH
    {0xAF70, 0x75EF}, //7477 #CJK UNIFIED IDEOGRAPH
    {0xAF71, 0x75F2}, //7478 #CJK UNIFIED IDEOGRAPH
    {0xAF72, 0x75F3}, //7479 #CJK UNIFIED IDEOGRAPH
    {0xAF73, 0x75F5}, //7480 #CJK UNIFIED IDEOGRAPH
    {0xAF74, 0x75F6}, //7481 #CJK UNIFIED IDEOGRAPH
    {0xAF75, 0x75F7}, //7482 #CJK UNIFIED IDEOGRAPH
    {0xAF76, 0x75F8}, //7483 #CJK UNIFIED IDEOGRAPH
    {0xAF77, 0x75FA}, //7484 #CJK UNIFIED IDEOGRAPH
    {0xAF78, 0x75FB}, //7485 #CJK UNIFIED IDEOGRAPH
    {0xAF79, 0x75FD}, //7486 #CJK UNIFIED IDEOGRAPH
    {0xAF7A, 0x75FE}, //7487 #CJK UNIFIED IDEOGRAPH
    {0xAF7B, 0x7602}, //7488 #CJK UNIFIED IDEOGRAPH
    {0xAF7C, 0x7604}, //7489 #CJK UNIFIED IDEOGRAPH
    {0xAF7D, 0x7606}, //7490 #CJK UNIFIED IDEOGRAPH
    {0xAF7E, 0x7607}, //7491 #CJK UNIFIED IDEOGRAPH
    {0xAF80, 0x7608}, //7492 #CJK UNIFIED IDEOGRAPH
    {0xAF81, 0x7609}, //7493 #CJK UNIFIED IDEOGRAPH
    {0xAF82, 0x760B}, //7494 #CJK UNIFIED IDEOGRAPH
    {0xAF83, 0x760D}, //7495 #CJK UNIFIED IDEOGRAPH
    {0xAF84, 0x760E}, //7496 #CJK UNIFIED IDEOGRAPH
    {0xAF85, 0x760F}, //7497 #CJK UNIFIED IDEOGRAPH
    {0xAF86, 0x7611}, //7498 #CJK UNIFIED IDEOGRAPH
    {0xAF87, 0x7612}, //7499 #CJK UNIFIED IDEOGRAPH
    {0xAF88, 0x7613}, //7500 #CJK UNIFIED IDEOGRAPH
    {0xAF89, 0x7614}, //7501 #CJK UNIFIED IDEOGRAPH
    {0xAF8A, 0x7616}, //7502 #CJK UNIFIED IDEOGRAPH
    {0xAF8B, 0x761A}, //7503 #CJK UNIFIED IDEOGRAPH
    {0xAF8C, 0x761C}, //7504 #CJK UNIFIED IDEOGRAPH
    {0xAF8D, 0x761D}, //7505 #CJK UNIFIED IDEOGRAPH
    {0xAF8E, 0x761E}, //7506 #CJK UNIFIED IDEOGRAPH
    {0xAF8F, 0x7621}, //7507 #CJK UNIFIED IDEOGRAPH
    {0xAF90, 0x7623}, //7508 #CJK UNIFIED IDEOGRAPH
    {0xAF91, 0x7627}, //7509 #CJK UNIFIED IDEOGRAPH
    {0xAF92, 0x7628}, //7510 #CJK UNIFIED IDEOGRAPH
    {0xAF93, 0x762C}, //7511 #CJK UNIFIED IDEOGRAPH
    {0xAF94, 0x762E}, //7512 #CJK UNIFIED IDEOGRAPH
    {0xAF95, 0x762F}, //7513 #CJK UNIFIED IDEOGRAPH
    {0xAF96, 0x7631}, //7514 #CJK UNIFIED IDEOGRAPH
    {0xAF97, 0x7632}, //7515 #CJK UNIFIED IDEOGRAPH
    {0xAF98, 0x7636}, //7516 #CJK UNIFIED IDEOGRAPH
    {0xAF99, 0x7637}, //7517 #CJK UNIFIED IDEOGRAPH
    {0xAF9A, 0x7639}, //7518 #CJK UNIFIED IDEOGRAPH
    {0xAF9B, 0x763A}, //7519 #CJK UNIFIED IDEOGRAPH
    {0xAF9C, 0x763B}, //7520 #CJK UNIFIED IDEOGRAPH
    {0xAF9D, 0x763D}, //7521 #CJK UNIFIED IDEOGRAPH
    {0xAF9E, 0x7641}, //7522 #CJK UNIFIED IDEOGRAPH
    {0xAF9F, 0x7642}, //7523 #CJK UNIFIED IDEOGRAPH
    {0xAFA0, 0x7644}, //7524 #CJK UNIFIED IDEOGRAPH
    {0xB040, 0x7645}, //7525 #CJK UNIFIED IDEOGRAPH
    {0xB041, 0x7646}, //7526 #CJK UNIFIED IDEOGRAPH
    {0xB042, 0x7647}, //7527 #CJK UNIFIED IDEOGRAPH
    {0xB043, 0x7648}, //7528 #CJK UNIFIED IDEOGRAPH
    {0xB044, 0x7649}, //7529 #CJK UNIFIED IDEOGRAPH
    {0xB045, 0x764A}, //7530 #CJK UNIFIED IDEOGRAPH
    {0xB046, 0x764B}, //7531 #CJK UNIFIED IDEOGRAPH
    {0xB047, 0x764E}, //7532 #CJK UNIFIED IDEOGRAPH
    {0xB048, 0x764F}, //7533 #CJK UNIFIED IDEOGRAPH
    {0xB049, 0x7650}, //7534 #CJK UNIFIED IDEOGRAPH
    {0xB04A, 0x7651}, //7535 #CJK UNIFIED IDEOGRAPH
    {0xB04B, 0x7652}, //7536 #CJK UNIFIED IDEOGRAPH
    {0xB04C, 0x7653}, //7537 #CJK UNIFIED IDEOGRAPH
    {0xB04D, 0x7655}, //7538 #CJK UNIFIED IDEOGRAPH
    {0xB04E, 0x7657}, //7539 #CJK UNIFIED IDEOGRAPH
    {0xB04F, 0x7658}, //7540 #CJK UNIFIED IDEOGRAPH
    {0xB050, 0x7659}, //7541 #CJK UNIFIED IDEOGRAPH
    {0xB051, 0x765A}, //7542 #CJK UNIFIED IDEOGRAPH
    {0xB052, 0x765B}, //7543 #CJK UNIFIED IDEOGRAPH
    {0xB053, 0x765D}, //7544 #CJK UNIFIED IDEOGRAPH
    {0xB054, 0x765F}, //7545 #CJK UNIFIED IDEOGRAPH
    {0xB055, 0x7660}, //7546 #CJK UNIFIED IDEOGRAPH
    {0xB056, 0x7661}, //7547 #CJK UNIFIED IDEOGRAPH
    {0xB057, 0x7662}, //7548 #CJK UNIFIED IDEOGRAPH
    {0xB058, 0x7664}, //7549 #CJK UNIFIED IDEOGRAPH
    {0xB059, 0x7665}, //7550 #CJK UNIFIED IDEOGRAPH
    {0xB05A, 0x7666}, //7551 #CJK UNIFIED IDEOGRAPH
    {0xB05B, 0x7667}, //7552 #CJK UNIFIED IDEOGRAPH
    {0xB05C, 0x7668}, //7553 #CJK UNIFIED IDEOGRAPH
    {0xB05D, 0x7669}, //7554 #CJK UNIFIED IDEOGRAPH
    {0xB05E, 0x766A}, //7555 #CJK UNIFIED IDEOGRAPH
    {0xB05F, 0x766C}, //7556 #CJK UNIFIED IDEOGRAPH
    {0xB060, 0x766D}, //7557 #CJK UNIFIED IDEOGRAPH
    {0xB061, 0x766E}, //7558 #CJK UNIFIED IDEOGRAPH
    {0xB062, 0x7670}, //7559 #CJK UNIFIED IDEOGRAPH
    {0xB063, 0x7671}, //7560 #CJK UNIFIED IDEOGRAPH
    {0xB064, 0x7672}, //7561 #CJK UNIFIED IDEOGRAPH
    {0xB065, 0x7673}, //7562 #CJK UNIFIED IDEOGRAPH
    {0xB066, 0x7674}, //7563 #CJK UNIFIED IDEOGRAPH
    {0xB067, 0x7675}, //7564 #CJK UNIFIED IDEOGRAPH
    {0xB068, 0x7676}, //7565 #CJK UNIFIED IDEOGRAPH
    {0xB069, 0x7677}, //7566 #CJK UNIFIED IDEOGRAPH
    {0xB06A, 0x7679}, //7567 #CJK UNIFIED IDEOGRAPH
    {0xB06B, 0x767A}, //7568 #CJK UNIFIED IDEOGRAPH
    {0xB06C, 0x767C}, //7569 #CJK UNIFIED IDEOGRAPH
    {0xB06D, 0x767F}, //7570 #CJK UNIFIED IDEOGRAPH
    {0xB06E, 0x7680}, //7571 #CJK UNIFIED IDEOGRAPH
    {0xB06F, 0x7681}, //7572 #CJK UNIFIED IDEOGRAPH
    {0xB070, 0x7683}, //7573 #CJK UNIFIED IDEOGRAPH
    {0xB071, 0x7685}, //7574 #CJK UNIFIED IDEOGRAPH
    {0xB072, 0x7689}, //7575 #CJK UNIFIED IDEOGRAPH
    {0xB073, 0x768A}, //7576 #CJK UNIFIED IDEOGRAPH
    {0xB074, 0x768C}, //7577 #CJK UNIFIED IDEOGRAPH
    {0xB075, 0x768D}, //7578 #CJK UNIFIED IDEOGRAPH
    {0xB076, 0x768F}, //7579 #CJK UNIFIED IDEOGRAPH
    {0xB077, 0x7690}, //7580 #CJK UNIFIED IDEOGRAPH
    {0xB078, 0x7692}, //7581 #CJK UNIFIED IDEOGRAPH
    {0xB079, 0x7694}, //7582 #CJK UNIFIED IDEOGRAPH
    {0xB07A, 0x7695}, //7583 #CJK UNIFIED IDEOGRAPH
    {0xB07B, 0x7697}, //7584 #CJK UNIFIED IDEOGRAPH
    {0xB07C, 0x7698}, //7585 #CJK UNIFIED IDEOGRAPH
    {0xB07D, 0x769A}, //7586 #CJK UNIFIED IDEOGRAPH
    {0xB07E, 0x769B}, //7587 #CJK UNIFIED IDEOGRAPH
    {0xB080, 0x769C}, //7588 #CJK UNIFIED IDEOGRAPH
    {0xB081, 0x769D}, //7589 #CJK UNIFIED IDEOGRAPH
    {0xB082, 0x769E}, //7590 #CJK UNIFIED IDEOGRAPH
    {0xB083, 0x769F}, //7591 #CJK UNIFIED IDEOGRAPH
    {0xB084, 0x76A0}, //7592 #CJK UNIFIED IDEOGRAPH
    {0xB085, 0x76A1}, //7593 #CJK UNIFIED IDEOGRAPH
    {0xB086, 0x76A2}, //7594 #CJK UNIFIED IDEOGRAPH
    {0xB087, 0x76A3}, //7595 #CJK UNIFIED IDEOGRAPH
    {0xB088, 0x76A5}, //7596 #CJK UNIFIED IDEOGRAPH
    {0xB089, 0x76A6}, //7597 #CJK UNIFIED IDEOGRAPH
    {0xB08A, 0x76A7}, //7598 #CJK UNIFIED IDEOGRAPH
    {0xB08B, 0x76A8}, //7599 #CJK UNIFIED IDEOGRAPH
    {0xB08C, 0x76A9}, //7600 #CJK UNIFIED IDEOGRAPH
    {0xB08D, 0x76AA}, //7601 #CJK UNIFIED IDEOGRAPH
    {0xB08E, 0x76AB}, //7602 #CJK UNIFIED IDEOGRAPH
    {0xB08F, 0x76AC}, //7603 #CJK UNIFIED IDEOGRAPH
    {0xB090, 0x76AD}, //7604 #CJK UNIFIED IDEOGRAPH
    {0xB091, 0x76AF}, //7605 #CJK UNIFIED IDEOGRAPH
    {0xB092, 0x76B0}, //7606 #CJK UNIFIED IDEOGRAPH
    {0xB093, 0x76B3}, //7607 #CJK UNIFIED IDEOGRAPH
    {0xB094, 0x76B5}, //7608 #CJK UNIFIED IDEOGRAPH
    {0xB095, 0x76B6}, //7609 #CJK UNIFIED IDEOGRAPH
    {0xB096, 0x76B7}, //7610 #CJK UNIFIED IDEOGRAPH
    {0xB097, 0x76B8}, //7611 #CJK UNIFIED IDEOGRAPH
    {0xB098, 0x76B9}, //7612 #CJK UNIFIED IDEOGRAPH
    {0xB099, 0x76BA}, //7613 #CJK UNIFIED IDEOGRAPH
    {0xB09A, 0x76BB}, //7614 #CJK UNIFIED IDEOGRAPH
    {0xB09B, 0x76BC}, //7615 #CJK UNIFIED IDEOGRAPH
    {0xB09C, 0x76BD}, //7616 #CJK UNIFIED IDEOGRAPH
    {0xB09D, 0x76BE}, //7617 #CJK UNIFIED IDEOGRAPH
    {0xB09E, 0x76C0}, //7618 #CJK UNIFIED IDEOGRAPH
    {0xB09F, 0x76C1}, //7619 #CJK UNIFIED IDEOGRAPH
    {0xB0A0, 0x76C3}, //7620 #CJK UNIFIED IDEOGRAPH
    {0xB0A1, 0x554A}, //7621 #CJK UNIFIED IDEOGRAPH
    {0xB0A2, 0x963F}, //7622 #CJK UNIFIED IDEOGRAPH
    {0xB0A3, 0x57C3}, //7623 #CJK UNIFIED IDEOGRAPH
    {0xB0A4, 0x6328}, //7624 #CJK UNIFIED IDEOGRAPH
    {0xB0A5, 0x54CE}, //7625 #CJK UNIFIED IDEOGRAPH
    {0xB0A6, 0x5509}, //7626 #CJK UNIFIED IDEOGRAPH
    {0xB0A7, 0x54C0}, //7627 #CJK UNIFIED IDEOGRAPH
    {0xB0A8, 0x7691}, //7628 #CJK UNIFIED IDEOGRAPH
    {0xB0A9, 0x764C}, //7629 #CJK UNIFIED IDEOGRAPH
    {0xB0AA, 0x853C}, //7630 #CJK UNIFIED IDEOGRAPH
    {0xB0AB, 0x77EE}, //7631 #CJK UNIFIED IDEOGRAPH
    {0xB0AC, 0x827E}, //7632 #CJK UNIFIED IDEOGRAPH
    {0xB0AD, 0x788D}, //7633 #CJK UNIFIED IDEOGRAPH
    {0xB0AE, 0x7231}, //7634 #CJK UNIFIED IDEOGRAPH
    {0xB0AF, 0x9698}, //7635 #CJK UNIFIED IDEOGRAPH
    {0xB0B0, 0x978D}, //7636 #CJK UNIFIED IDEOGRAPH
    {0xB0B1, 0x6C28}, //7637 #CJK UNIFIED IDEOGRAPH
    {0xB0B2, 0x5B89}, //7638 #CJK UNIFIED IDEOGRAPH
    {0xB0B3, 0x4FFA}, //7639 #CJK UNIFIED IDEOGRAPH
    {0xB0B4, 0x6309}, //7640 #CJK UNIFIED IDEOGRAPH
    {0xB0B5, 0x6697}, //7641 #CJK UNIFIED IDEOGRAPH
    {0xB0B6, 0x5CB8}, //7642 #CJK UNIFIED IDEOGRAPH
    {0xB0B7, 0x80FA}, //7643 #CJK UNIFIED IDEOGRAPH
    {0xB0B8, 0x6848}, //7644 #CJK UNIFIED IDEOGRAPH
    {0xB0B9, 0x80AE}, //7645 #CJK UNIFIED IDEOGRAPH
    {0xB0BA, 0x6602}, //7646 #CJK UNIFIED IDEOGRAPH
    {0xB0BB, 0x76CE}, //7647 #CJK UNIFIED IDEOGRAPH
    {0xB0BC, 0x51F9}, //7648 #CJK UNIFIED IDEOGRAPH
    {0xB0BD, 0x6556}, //7649 #CJK UNIFIED IDEOGRAPH
    {0xB0BE, 0x71AC}, //7650 #CJK UNIFIED IDEOGRAPH
    {0xB0BF, 0x7FF1}, //7651 #CJK UNIFIED IDEOGRAPH
    {0xB0C0, 0x8884}, //7652 #CJK UNIFIED IDEOGRAPH
    {0xB0C1, 0x50B2}, //7653 #CJK UNIFIED IDEOGRAPH
    {0xB0C2, 0x5965}, //7654 #CJK UNIFIED IDEOGRAPH
    {0xB0C3, 0x61CA}, //7655 #CJK UNIFIED IDEOGRAPH
    {0xB0C4, 0x6FB3}, //7656 #CJK UNIFIED IDEOGRAPH
    {0xB0C5, 0x82AD}, //7657 #CJK UNIFIED IDEOGRAPH
    {0xB0C6, 0x634C}, //7658 #CJK UNIFIED IDEOGRAPH
    {0xB0C7, 0x6252}, //7659 #CJK UNIFIED IDEOGRAPH
    {0xB0C8, 0x53ED}, //7660 #CJK UNIFIED IDEOGRAPH
    {0xB0C9, 0x5427}, //7661 #CJK UNIFIED IDEOGRAPH
    {0xB0CA, 0x7B06}, //7662 #CJK UNIFIED IDEOGRAPH
    {0xB0CB, 0x516B}, //7663 #CJK UNIFIED IDEOGRAPH
    {0xB0CC, 0x75A4}, //7664 #CJK UNIFIED IDEOGRAPH
    {0xB0CD, 0x5DF4}, //7665 #CJK UNIFIED IDEOGRAPH
    {0xB0CE, 0x62D4}, //7666 #CJK UNIFIED IDEOGRAPH
    {0xB0CF, 0x8DCB}, //7667 #CJK UNIFIED IDEOGRAPH
    {0xB0D0, 0x9776}, //7668 #CJK UNIFIED IDEOGRAPH
    {0xB0D1, 0x628A}, //7669 #CJK UNIFIED IDEOGRAPH
    {0xB0D2, 0x8019}, //7670 #CJK UNIFIED IDEOGRAPH
    {0xB0D3, 0x575D}, //7671 #CJK UNIFIED IDEOGRAPH
    {0xB0D4, 0x9738}, //7672 #CJK UNIFIED IDEOGRAPH
    {0xB0D5, 0x7F62}, //7673 #CJK UNIFIED IDEOGRAPH
    {0xB0D6, 0x7238}, //7674 #CJK UNIFIED IDEOGRAPH
    {0xB0D7, 0x767D}, //7675 #CJK UNIFIED IDEOGRAPH
    {0xB0D8, 0x67CF}, //7676 #CJK UNIFIED IDEOGRAPH
    {0xB0D9, 0x767E}, //7677 #CJK UNIFIED IDEOGRAPH
    {0xB0DA, 0x6446}, //7678 #CJK UNIFIED IDEOGRAPH
    {0xB0DB, 0x4F70}, //7679 #CJK UNIFIED IDEOGRAPH
    {0xB0DC, 0x8D25}, //7680 #CJK UNIFIED IDEOGRAPH
    {0xB0DD, 0x62DC}, //7681 #CJK UNIFIED IDEOGRAPH
    {0xB0DE, 0x7A17}, //7682 #CJK UNIFIED IDEOGRAPH
    {0xB0DF, 0x6591}, //7683 #CJK UNIFIED IDEOGRAPH
    {0xB0E0, 0x73ED}, //7684 #CJK UNIFIED IDEOGRAPH
    {0xB0E1, 0x642C}, //7685 #CJK UNIFIED IDEOGRAPH
    {0xB0E2, 0x6273}, //7686 #CJK UNIFIED IDEOGRAPH
    {0xB0E3, 0x822C}, //7687 #CJK UNIFIED IDEOGRAPH
    {0xB0E4, 0x9881}, //7688 #CJK UNIFIED IDEOGRAPH
    {0xB0E5, 0x677F}, //7689 #CJK UNIFIED IDEOGRAPH
    {0xB0E6, 0x7248}, //7690 #CJK UNIFIED IDEOGRAPH
    {0xB0E7, 0x626E}, //7691 #CJK UNIFIED IDEOGRAPH
    {0xB0E8, 0x62CC}, //7692 #CJK UNIFIED IDEOGRAPH
    {0xB0E9, 0x4F34}, //7693 #CJK UNIFIED IDEOGRAPH
    {0xB0EA, 0x74E3}, //7694 #CJK UNIFIED IDEOGRAPH
    {0xB0EB, 0x534A}, //7695 #CJK UNIFIED IDEOGRAPH
    {0xB0EC, 0x529E}, //7696 #CJK UNIFIED IDEOGRAPH
    {0xB0ED, 0x7ECA}, //7697 #CJK UNIFIED IDEOGRAPH
    {0xB0EE, 0x90A6}, //7698 #CJK UNIFIED IDEOGRAPH
    {0xB0EF, 0x5E2E}, //7699 #CJK UNIFIED IDEOGRAPH
    {0xB0F0, 0x6886}, //7700 #CJK UNIFIED IDEOGRAPH
    {0xB0F1, 0x699C}, //7701 #CJK UNIFIED IDEOGRAPH
    {0xB0F2, 0x8180}, //7702 #CJK UNIFIED IDEOGRAPH
    {0xB0F3, 0x7ED1}, //7703 #CJK UNIFIED IDEOGRAPH
    {0xB0F4, 0x68D2}, //7704 #CJK UNIFIED IDEOGRAPH
    {0xB0F5, 0x78C5}, //7705 #CJK UNIFIED IDEOGRAPH
    {0xB0F6, 0x868C}, //7706 #CJK UNIFIED IDEOGRAPH
    {0xB0F7, 0x9551}, //7707 #CJK UNIFIED IDEOGRAPH
    {0xB0F8, 0x508D}, //7708 #CJK UNIFIED IDEOGRAPH
    {0xB0F9, 0x8C24}, //7709 #CJK UNIFIED IDEOGRAPH
    {0xB0FA, 0x82DE}, //7710 #CJK UNIFIED IDEOGRAPH
    {0xB0FB, 0x80DE}, //7711 #CJK UNIFIED IDEOGRAPH
    {0xB0FC, 0x5305}, //7712 #CJK UNIFIED IDEOGRAPH
    {0xB0FD, 0x8912}, //7713 #CJK UNIFIED IDEOGRAPH
    {0xB0FE, 0x5265}, //7714 #CJK UNIFIED IDEOGRAPH
    {0xB140, 0x76C4}, //7715 #CJK UNIFIED IDEOGRAPH
    {0xB141, 0x76C7}, //7716 #CJK UNIFIED IDEOGRAPH
    {0xB142, 0x76C9}, //7717 #CJK UNIFIED IDEOGRAPH
    {0xB143, 0x76CB}, //7718 #CJK UNIFIED IDEOGRAPH
    {0xB144, 0x76CC}, //7719 #CJK UNIFIED IDEOGRAPH
    {0xB145, 0x76D3}, //7720 #CJK UNIFIED IDEOGRAPH
    {0xB146, 0x76D5}, //7721 #CJK UNIFIED IDEOGRAPH
    {0xB147, 0x76D9}, //7722 #CJK UNIFIED IDEOGRAPH
    {0xB148, 0x76DA}, //7723 #CJK UNIFIED IDEOGRAPH
    {0xB149, 0x76DC}, //7724 #CJK UNIFIED IDEOGRAPH
    {0xB14A, 0x76DD}, //7725 #CJK UNIFIED IDEOGRAPH
    {0xB14B, 0x76DE}, //7726 #CJK UNIFIED IDEOGRAPH
    {0xB14C, 0x76E0}, //7727 #CJK UNIFIED IDEOGRAPH
    {0xB14D, 0x76E1}, //7728 #CJK UNIFIED IDEOGRAPH
    {0xB14E, 0x76E2}, //7729 #CJK UNIFIED IDEOGRAPH
    {0xB14F, 0x76E3}, //7730 #CJK UNIFIED IDEOGRAPH
    {0xB150, 0x76E4}, //7731 #CJK UNIFIED IDEOGRAPH
    {0xB151, 0x76E6}, //7732 #CJK UNIFIED IDEOGRAPH
    {0xB152, 0x76E7}, //7733 #CJK UNIFIED IDEOGRAPH
    {0xB153, 0x76E8}, //7734 #CJK UNIFIED IDEOGRAPH
    {0xB154, 0x76E9}, //7735 #CJK UNIFIED IDEOGRAPH
    {0xB155, 0x76EA}, //7736 #CJK UNIFIED IDEOGRAPH
    {0xB156, 0x76EB}, //7737 #CJK UNIFIED IDEOGRAPH
    {0xB157, 0x76EC}, //7738 #CJK UNIFIED IDEOGRAPH
    {0xB158, 0x76ED}, //7739 #CJK UNIFIED IDEOGRAPH
    {0xB159, 0x76F0}, //7740 #CJK UNIFIED IDEOGRAPH
    {0xB15A, 0x76F3}, //7741 #CJK UNIFIED IDEOGRAPH
    {0xB15B, 0x76F5}, //7742 #CJK UNIFIED IDEOGRAPH
    {0xB15C, 0x76F6}, //7743 #CJK UNIFIED IDEOGRAPH
    {0xB15D, 0x76F7}, //7744 #CJK UNIFIED IDEOGRAPH
    {0xB15E, 0x76FA}, //7745 #CJK UNIFIED IDEOGRAPH
    {0xB15F, 0x76FB}, //7746 #CJK UNIFIED IDEOGRAPH
    {0xB160, 0x76FD}, //7747 #CJK UNIFIED IDEOGRAPH
    {0xB161, 0x76FF}, //7748 #CJK UNIFIED IDEOGRAPH
    {0xB162, 0x7700}, //7749 #CJK UNIFIED IDEOGRAPH
    {0xB163, 0x7702}, //7750 #CJK UNIFIED IDEOGRAPH
    {0xB164, 0x7703}, //7751 #CJK UNIFIED IDEOGRAPH
    {0xB165, 0x7705}, //7752 #CJK UNIFIED IDEOGRAPH
    {0xB166, 0x7706}, //7753 #CJK UNIFIED IDEOGRAPH
    {0xB167, 0x770A}, //7754 #CJK UNIFIED IDEOGRAPH
    {0xB168, 0x770C}, //7755 #CJK UNIFIED IDEOGRAPH
    {0xB169, 0x770E}, //7756 #CJK UNIFIED IDEOGRAPH
    {0xB16A, 0x770F}, //7757 #CJK UNIFIED IDEOGRAPH
    {0xB16B, 0x7710}, //7758 #CJK UNIFIED IDEOGRAPH
    {0xB16C, 0x7711}, //7759 #CJK UNIFIED IDEOGRAPH
    {0xB16D, 0x7712}, //7760 #CJK UNIFIED IDEOGRAPH
    {0xB16E, 0x7713}, //7761 #CJK UNIFIED IDEOGRAPH
    {0xB16F, 0x7714}, //7762 #CJK UNIFIED IDEOGRAPH
    {0xB170, 0x7715}, //7763 #CJK UNIFIED IDEOGRAPH
    {0xB171, 0x7716}, //7764 #CJK UNIFIED IDEOGRAPH
    {0xB172, 0x7717}, //7765 #CJK UNIFIED IDEOGRAPH
    {0xB173, 0x7718}, //7766 #CJK UNIFIED IDEOGRAPH
    {0xB174, 0x771B}, //7767 #CJK UNIFIED IDEOGRAPH
    {0xB175, 0x771C}, //7768 #CJK UNIFIED IDEOGRAPH
    {0xB176, 0x771D}, //7769 #CJK UNIFIED IDEOGRAPH
    {0xB177, 0x771E}, //7770 #CJK UNIFIED IDEOGRAPH
    {0xB178, 0x7721}, //7771 #CJK UNIFIED IDEOGRAPH
    {0xB179, 0x7723}, //7772 #CJK UNIFIED IDEOGRAPH
    {0xB17A, 0x7724}, //7773 #CJK UNIFIED IDEOGRAPH
    {0xB17B, 0x7725}, //7774 #CJK UNIFIED IDEOGRAPH
    {0xB17C, 0x7727}, //7775 #CJK UNIFIED IDEOGRAPH
    {0xB17D, 0x772A}, //7776 #CJK UNIFIED IDEOGRAPH
    {0xB17E, 0x772B}, //7777 #CJK UNIFIED IDEOGRAPH
    {0xB180, 0x772C}, //7778 #CJK UNIFIED IDEOGRAPH
    {0xB181, 0x772E}, //7779 #CJK UNIFIED IDEOGRAPH
    {0xB182, 0x7730}, //7780 #CJK UNIFIED IDEOGRAPH
    {0xB183, 0x7731}, //7781 #CJK UNIFIED IDEOGRAPH
    {0xB184, 0x7732}, //7782 #CJK UNIFIED IDEOGRAPH
    {0xB185, 0x7733}, //7783 #CJK UNIFIED IDEOGRAPH
    {0xB186, 0x7734}, //7784 #CJK UNIFIED IDEOGRAPH
    {0xB187, 0x7739}, //7785 #CJK UNIFIED IDEOGRAPH
    {0xB188, 0x773B}, //7786 #CJK UNIFIED IDEOGRAPH
    {0xB189, 0x773D}, //7787 #CJK UNIFIED IDEOGRAPH
    {0xB18A, 0x773E}, //7788 #CJK UNIFIED IDEOGRAPH
    {0xB18B, 0x773F}, //7789 #CJK UNIFIED IDEOGRAPH
    {0xB18C, 0x7742}, //7790 #CJK UNIFIED IDEOGRAPH
    {0xB18D, 0x7744}, //7791 #CJK UNIFIED IDEOGRAPH
    {0xB18E, 0x7745}, //7792 #CJK UNIFIED IDEOGRAPH
    {0xB18F, 0x7746}, //7793 #CJK UNIFIED IDEOGRAPH
    {0xB190, 0x7748}, //7794 #CJK UNIFIED IDEOGRAPH
    {0xB191, 0x7749}, //7795 #CJK UNIFIED IDEOGRAPH
    {0xB192, 0x774A}, //7796 #CJK UNIFIED IDEOGRAPH
    {0xB193, 0x774B}, //7797 #CJK UNIFIED IDEOGRAPH
    {0xB194, 0x774C}, //7798 #CJK UNIFIED IDEOGRAPH
    {0xB195, 0x774D}, //7799 #CJK UNIFIED IDEOGRAPH
    {0xB196, 0x774E}, //7800 #CJK UNIFIED IDEOGRAPH
    {0xB197, 0x774F}, //7801 #CJK UNIFIED IDEOGRAPH
    {0xB198, 0x7752}, //7802 #CJK UNIFIED IDEOGRAPH
    {0xB199, 0x7753}, //7803 #CJK UNIFIED IDEOGRAPH
    {0xB19A, 0x7754}, //7804 #CJK UNIFIED IDEOGRAPH
    {0xB19B, 0x7755}, //7805 #CJK UNIFIED IDEOGRAPH
    {0xB19C, 0x7756}, //7806 #CJK UNIFIED IDEOGRAPH
    {0xB19D, 0x7757}, //7807 #CJK UNIFIED IDEOGRAPH
    {0xB19E, 0x7758}, //7808 #CJK UNIFIED IDEOGRAPH
    {0xB19F, 0x7759}, //7809 #CJK UNIFIED IDEOGRAPH
    {0xB1A0, 0x775C}, //7810 #CJK UNIFIED IDEOGRAPH
    {0xB1A1, 0x8584}, //7811 #CJK UNIFIED IDEOGRAPH
    {0xB1A2, 0x96F9}, //7812 #CJK UNIFIED IDEOGRAPH
    {0xB1A3, 0x4FDD}, //7813 #CJK UNIFIED IDEOGRAPH
    {0xB1A4, 0x5821}, //7814 #CJK UNIFIED IDEOGRAPH
    {0xB1A5, 0x9971}, //7815 #CJK UNIFIED IDEOGRAPH
    {0xB1A6, 0x5B9D}, //7816 #CJK UNIFIED IDEOGRAPH
    {0xB1A7, 0x62B1}, //7817 #CJK UNIFIED IDEOGRAPH
    {0xB1A8, 0x62A5}, //7818 #CJK UNIFIED IDEOGRAPH
    {0xB1A9, 0x66B4}, //7819 #CJK UNIFIED IDEOGRAPH
    {0xB1AA, 0x8C79}, //7820 #CJK UNIFIED IDEOGRAPH
    {0xB1AB, 0x9C8D}, //7821 #CJK UNIFIED IDEOGRAPH
    {0xB1AC, 0x7206}, //7822 #CJK UNIFIED IDEOGRAPH
    {0xB1AD, 0x676F}, //7823 #CJK UNIFIED IDEOGRAPH
    {0xB1AE, 0x7891}, //7824 #CJK UNIFIED IDEOGRAPH
    {0xB1AF, 0x60B2}, //7825 #CJK UNIFIED IDEOGRAPH
    {0xB1B0, 0x5351}, //7826 #CJK UNIFIED IDEOGRAPH
    {0xB1B1, 0x5317}, //7827 #CJK UNIFIED IDEOGRAPH
    {0xB1B2, 0x8F88}, //7828 #CJK UNIFIED IDEOGRAPH
    {0xB1B3, 0x80CC}, //7829 #CJK UNIFIED IDEOGRAPH
    {0xB1B4, 0x8D1D}, //7830 #CJK UNIFIED IDEOGRAPH
    {0xB1B5, 0x94A1}, //7831 #CJK UNIFIED IDEOGRAPH
    {0xB1B6, 0x500D}, //7832 #CJK UNIFIED IDEOGRAPH
    {0xB1B7, 0x72C8}, //7833 #CJK UNIFIED IDEOGRAPH
    {0xB1B8, 0x5907}, //7834 #CJK UNIFIED IDEOGRAPH
    {0xB1B9, 0x60EB}, //7835 #CJK UNIFIED IDEOGRAPH
    {0xB1BA, 0x7119}, //7836 #CJK UNIFIED IDEOGRAPH
    {0xB1BB, 0x88AB}, //7837 #CJK UNIFIED IDEOGRAPH
    {0xB1BC, 0x5954}, //7838 #CJK UNIFIED IDEOGRAPH
    {0xB1BD, 0x82EF}, //7839 #CJK UNIFIED IDEOGRAPH
    {0xB1BE, 0x672C}, //7840 #CJK UNIFIED IDEOGRAPH
    {0xB1BF, 0x7B28}, //7841 #CJK UNIFIED IDEOGRAPH
    {0xB1C0, 0x5D29}, //7842 #CJK UNIFIED IDEOGRAPH
    {0xB1C1, 0x7EF7}, //7843 #CJK UNIFIED IDEOGRAPH
    {0xB1C2, 0x752D}, //7844 #CJK UNIFIED IDEOGRAPH
    {0xB1C3, 0x6CF5}, //7845 #CJK UNIFIED IDEOGRAPH
    {0xB1C4, 0x8E66}, //7846 #CJK UNIFIED IDEOGRAPH
    {0xB1C5, 0x8FF8}, //7847 #CJK UNIFIED IDEOGRAPH
    {0xB1C6, 0x903C}, //7848 #CJK UNIFIED IDEOGRAPH
    {0xB1C7, 0x9F3B}, //7849 #CJK UNIFIED IDEOGRAPH
    {0xB1C8, 0x6BD4}, //7850 #CJK UNIFIED IDEOGRAPH
    {0xB1C9, 0x9119}, //7851 #CJK UNIFIED IDEOGRAPH
    {0xB1CA, 0x7B14}, //7852 #CJK UNIFIED IDEOGRAPH
    {0xB1CB, 0x5F7C}, //7853 #CJK UNIFIED IDEOGRAPH
    {0xB1CC, 0x78A7}, //7854 #CJK UNIFIED IDEOGRAPH
    {0xB1CD, 0x84D6}, //7855 #CJK UNIFIED IDEOGRAPH
    {0xB1CE, 0x853D}, //7856 #CJK UNIFIED IDEOGRAPH
    {0xB1CF, 0x6BD5}, //7857 #CJK UNIFIED IDEOGRAPH
    {0xB1D0, 0x6BD9}, //7858 #CJK UNIFIED IDEOGRAPH
    {0xB1D1, 0x6BD6}, //7859 #CJK UNIFIED IDEOGRAPH
    {0xB1D2, 0x5E01}, //7860 #CJK UNIFIED IDEOGRAPH
    {0xB1D3, 0x5E87}, //7861 #CJK UNIFIED IDEOGRAPH
    {0xB1D4, 0x75F9}, //7862 #CJK UNIFIED IDEOGRAPH
    {0xB1D5, 0x95ED}, //7863 #CJK UNIFIED IDEOGRAPH
    {0xB1D6, 0x655D}, //7864 #CJK UNIFIED IDEOGRAPH
    {0xB1D7, 0x5F0A}, //7865 #CJK UNIFIED IDEOGRAPH
    {0xB1D8, 0x5FC5}, //7866 #CJK UNIFIED IDEOGRAPH
    {0xB1D9, 0x8F9F}, //7867 #CJK UNIFIED IDEOGRAPH
    {0xB1DA, 0x58C1}, //7868 #CJK UNIFIED IDEOGRAPH
    {0xB1DB, 0x81C2}, //7869 #CJK UNIFIED IDEOGRAPH
    {0xB1DC, 0x907F}, //7870 #CJK UNIFIED IDEOGRAPH
    {0xB1DD, 0x965B}, //7871 #CJK UNIFIED IDEOGRAPH
    {0xB1DE, 0x97AD}, //7872 #CJK UNIFIED IDEOGRAPH
    {0xB1DF, 0x8FB9}, //7873 #CJK UNIFIED IDEOGRAPH
    {0xB1E0, 0x7F16}, //7874 #CJK UNIFIED IDEOGRAPH
    {0xB1E1, 0x8D2C}, //7875 #CJK UNIFIED IDEOGRAPH
    {0xB1E2, 0x6241}, //7876 #CJK UNIFIED IDEOGRAPH
    {0xB1E3, 0x4FBF}, //7877 #CJK UNIFIED IDEOGRAPH
    {0xB1E4, 0x53D8}, //7878 #CJK UNIFIED IDEOGRAPH
    {0xB1E5, 0x535E}, //7879 #CJK UNIFIED IDEOGRAPH
    {0xB1E6, 0x8FA8}, //7880 #CJK UNIFIED IDEOGRAPH
    {0xB1E7, 0x8FA9}, //7881 #CJK UNIFIED IDEOGRAPH
    {0xB1E8, 0x8FAB}, //7882 #CJK UNIFIED IDEOGRAPH
    {0xB1E9, 0x904D}, //7883 #CJK UNIFIED IDEOGRAPH
    {0xB1EA, 0x6807}, //7884 #CJK UNIFIED IDEOGRAPH
    {0xB1EB, 0x5F6A}, //7885 #CJK UNIFIED IDEOGRAPH
    {0xB1EC, 0x8198}, //7886 #CJK UNIFIED IDEOGRAPH
    {0xB1ED, 0x8868}, //7887 #CJK UNIFIED IDEOGRAPH
    {0xB1EE, 0x9CD6}, //7888 #CJK UNIFIED IDEOGRAPH
    {0xB1EF, 0x618B}, //7889 #CJK UNIFIED IDEOGRAPH
    {0xB1F0, 0x522B}, //7890 #CJK UNIFIED IDEOGRAPH
    {0xB1F1, 0x762A}, //7891 #CJK UNIFIED IDEOGRAPH
    {0xB1F2, 0x5F6C}, //7892 #CJK UNIFIED IDEOGRAPH
    {0xB1F3, 0x658C}, //7893 #CJK UNIFIED IDEOGRAPH
    {0xB1F4, 0x6FD2}, //7894 #CJK UNIFIED IDEOGRAPH
    {0xB1F5, 0x6EE8}, //7895 #CJK UNIFIED IDEOGRAPH
    {0xB1F6, 0x5BBE}, //7896 #CJK UNIFIED IDEOGRAPH
    {0xB1F7, 0x6448}, //7897 #CJK UNIFIED IDEOGRAPH
    {0xB1F8, 0x5175}, //7898 #CJK UNIFIED IDEOGRAPH
    {0xB1F9, 0x51B0}, //7899 #CJK UNIFIED IDEOGRAPH
    {0xB1FA, 0x67C4}, //7900 #CJK UNIFIED IDEOGRAPH
    {0xB1FB, 0x4E19}, //7901 #CJK UNIFIED IDEOGRAPH
    {0xB1FC, 0x79C9}, //7902 #CJK UNIFIED IDEOGRAPH
    {0xB1FD, 0x997C}, //7903 #CJK UNIFIED IDEOGRAPH
    {0xB1FE, 0x70B3}, //7904 #CJK UNIFIED IDEOGRAPH
    {0xB240, 0x775D}, //7905 #CJK UNIFIED IDEOGRAPH
    {0xB241, 0x775E}, //7906 #CJK UNIFIED IDEOGRAPH
    {0xB242, 0x775F}, //7907 #CJK UNIFIED IDEOGRAPH
    {0xB243, 0x7760}, //7908 #CJK UNIFIED IDEOGRAPH
    {0xB244, 0x7764}, //7909 #CJK UNIFIED IDEOGRAPH
    {0xB245, 0x7767}, //7910 #CJK UNIFIED IDEOGRAPH
    {0xB246, 0x7769}, //7911 #CJK UNIFIED IDEOGRAPH
    {0xB247, 0x776A}, //7912 #CJK UNIFIED IDEOGRAPH
    {0xB248, 0x776D}, //7913 #CJK UNIFIED IDEOGRAPH
    {0xB249, 0x776E}, //7914 #CJK UNIFIED IDEOGRAPH
    {0xB24A, 0x776F}, //7915 #CJK UNIFIED IDEOGRAPH
    {0xB24B, 0x7770}, //7916 #CJK UNIFIED IDEOGRAPH
    {0xB24C, 0x7771}, //7917 #CJK UNIFIED IDEOGRAPH
    {0xB24D, 0x7772}, //7918 #CJK UNIFIED IDEOGRAPH
    {0xB24E, 0x7773}, //7919 #CJK UNIFIED IDEOGRAPH
    {0xB24F, 0x7774}, //7920 #CJK UNIFIED IDEOGRAPH
    {0xB250, 0x7775}, //7921 #CJK UNIFIED IDEOGRAPH
    {0xB251, 0x7776}, //7922 #CJK UNIFIED IDEOGRAPH
    {0xB252, 0x7777}, //7923 #CJK UNIFIED IDEOGRAPH
    {0xB253, 0x7778}, //7924 #CJK UNIFIED IDEOGRAPH
    {0xB254, 0x777A}, //7925 #CJK UNIFIED IDEOGRAPH
    {0xB255, 0x777B}, //7926 #CJK UNIFIED IDEOGRAPH
    {0xB256, 0x777C}, //7927 #CJK UNIFIED IDEOGRAPH
    {0xB257, 0x7781}, //7928 #CJK UNIFIED IDEOGRAPH
    {0xB258, 0x7782}, //7929 #CJK UNIFIED IDEOGRAPH
    {0xB259, 0x7783}, //7930 #CJK UNIFIED IDEOGRAPH
    {0xB25A, 0x7786}, //7931 #CJK UNIFIED IDEOGRAPH
    {0xB25B, 0x7787}, //7932 #CJK UNIFIED IDEOGRAPH
    {0xB25C, 0x7788}, //7933 #CJK UNIFIED IDEOGRAPH
    {0xB25D, 0x7789}, //7934 #CJK UNIFIED IDEOGRAPH
    {0xB25E, 0x778A}, //7935 #CJK UNIFIED IDEOGRAPH
    {0xB25F, 0x778B}, //7936 #CJK UNIFIED IDEOGRAPH
    {0xB260, 0x778F}, //7937 #CJK UNIFIED IDEOGRAPH
    {0xB261, 0x7790}, //7938 #CJK UNIFIED IDEOGRAPH
    {0xB262, 0x7793}, //7939 #CJK UNIFIED IDEOGRAPH
    {0xB263, 0x7794}, //7940 #CJK UNIFIED IDEOGRAPH
    {0xB264, 0x7795}, //7941 #CJK UNIFIED IDEOGRAPH
    {0xB265, 0x7796}, //7942 #CJK UNIFIED IDEOGRAPH
    {0xB266, 0x7797}, //7943 #CJK UNIFIED IDEOGRAPH
    {0xB267, 0x7798}, //7944 #CJK UNIFIED IDEOGRAPH
    {0xB268, 0x7799}, //7945 #CJK UNIFIED IDEOGRAPH
    {0xB269, 0x779A}, //7946 #CJK UNIFIED IDEOGRAPH
    {0xB26A, 0x779B}, //7947 #CJK UNIFIED IDEOGRAPH
    {0xB26B, 0x779C}, //7948 #CJK UNIFIED IDEOGRAPH
    {0xB26C, 0x779D}, //7949 #CJK UNIFIED IDEOGRAPH
    {0xB26D, 0x779E}, //7950 #CJK UNIFIED IDEOGRAPH
    {0xB26E, 0x77A1}, //7951 #CJK UNIFIED IDEOGRAPH
    {0xB26F, 0x77A3}, //7952 #CJK UNIFIED IDEOGRAPH
    {0xB270, 0x77A4}, //7953 #CJK UNIFIED IDEOGRAPH
    {0xB271, 0x77A6}, //7954 #CJK UNIFIED IDEOGRAPH
    {0xB272, 0x77A8}, //7955 #CJK UNIFIED IDEOGRAPH
    {0xB273, 0x77AB}, //7956 #CJK UNIFIED IDEOGRAPH
    {0xB274, 0x77AD}, //7957 #CJK UNIFIED IDEOGRAPH
    {0xB275, 0x77AE}, //7958 #CJK UNIFIED IDEOGRAPH
    {0xB276, 0x77AF}, //7959 #CJK UNIFIED IDEOGRAPH
    {0xB277, 0x77B1}, //7960 #CJK UNIFIED IDEOGRAPH
    {0xB278, 0x77B2}, //7961 #CJK UNIFIED IDEOGRAPH
    {0xB279, 0x77B4}, //7962 #CJK UNIFIED IDEOGRAPH
    {0xB27A, 0x77B6}, //7963 #CJK UNIFIED IDEOGRAPH
    {0xB27B, 0x77B7}, //7964 #CJK UNIFIED IDEOGRAPH
    {0xB27C, 0x77B8}, //7965 #CJK UNIFIED IDEOGRAPH
    {0xB27D, 0x77B9}, //7966 #CJK UNIFIED IDEOGRAPH
    {0xB27E, 0x77BA}, //7967 #CJK UNIFIED IDEOGRAPH
    {0xB280, 0x77BC}, //7968 #CJK UNIFIED IDEOGRAPH
    {0xB281, 0x77BE}, //7969 #CJK UNIFIED IDEOGRAPH
    {0xB282, 0x77C0}, //7970 #CJK UNIFIED IDEOGRAPH
    {0xB283, 0x77C1}, //7971 #CJK UNIFIED IDEOGRAPH
    {0xB284, 0x77C2}, //7972 #CJK UNIFIED IDEOGRAPH
    {0xB285, 0x77C3}, //7973 #CJK UNIFIED IDEOGRAPH
    {0xB286, 0x77C4}, //7974 #CJK UNIFIED IDEOGRAPH
    {0xB287, 0x77C5}, //7975 #CJK UNIFIED IDEOGRAPH
    {0xB288, 0x77C6}, //7976 #CJK UNIFIED IDEOGRAPH
    {0xB289, 0x77C7}, //7977 #CJK UNIFIED IDEOGRAPH
    {0xB28A, 0x77C8}, //7978 #CJK UNIFIED IDEOGRAPH
    {0xB28B, 0x77C9}, //7979 #CJK UNIFIED IDEOGRAPH
    {0xB28C, 0x77CA}, //7980 #CJK UNIFIED IDEOGRAPH
    {0xB28D, 0x77CB}, //7981 #CJK UNIFIED IDEOGRAPH
    {0xB28E, 0x77CC}, //7982 #CJK UNIFIED IDEOGRAPH
    {0xB28F, 0x77CE}, //7983 #CJK UNIFIED IDEOGRAPH
    {0xB290, 0x77CF}, //7984 #CJK UNIFIED IDEOGRAPH
    {0xB291, 0x77D0}, //7985 #CJK UNIFIED IDEOGRAPH
    {0xB292, 0x77D1}, //7986 #CJK UNIFIED IDEOGRAPH
    {0xB293, 0x77D2}, //7987 #CJK UNIFIED IDEOGRAPH
    {0xB294, 0x77D3}, //7988 #CJK UNIFIED IDEOGRAPH
    {0xB295, 0x77D4}, //7989 #CJK UNIFIED IDEOGRAPH
    {0xB296, 0x77D5}, //7990 #CJK UNIFIED IDEOGRAPH
    {0xB297, 0x77D6}, //7991 #CJK UNIFIED IDEOGRAPH
    {0xB298, 0x77D8}, //7992 #CJK UNIFIED IDEOGRAPH
    {0xB299, 0x77D9}, //7993 #CJK UNIFIED IDEOGRAPH
    {0xB29A, 0x77DA}, //7994 #CJK UNIFIED IDEOGRAPH
    {0xB29B, 0x77DD}, //7995 #CJK UNIFIED IDEOGRAPH
    {0xB29C, 0x77DE}, //7996 #CJK UNIFIED IDEOGRAPH
    {0xB29D, 0x77DF}, //7997 #CJK UNIFIED IDEOGRAPH
    {0xB29E, 0x77E0}, //7998 #CJK UNIFIED IDEOGRAPH
    {0xB29F, 0x77E1}, //7999 #CJK UNIFIED IDEOGRAPH
    {0xB2A0, 0x77E4}, //8000 #CJK UNIFIED IDEOGRAPH
    {0xB2A1, 0x75C5}, //8001 #CJK UNIFIED IDEOGRAPH
    {0xB2A2, 0x5E76}, //8002 #CJK UNIFIED IDEOGRAPH
    {0xB2A3, 0x73BB}, //8003 #CJK UNIFIED IDEOGRAPH
    {0xB2A4, 0x83E0}, //8004 #CJK UNIFIED IDEOGRAPH
    {0xB2A5, 0x64AD}, //8005 #CJK UNIFIED IDEOGRAPH
    {0xB2A6, 0x62E8}, //8006 #CJK UNIFIED IDEOGRAPH
    {0xB2A7, 0x94B5}, //8007 #CJK UNIFIED IDEOGRAPH
    {0xB2A8, 0x6CE2}, //8008 #CJK UNIFIED IDEOGRAPH
    {0xB2A9, 0x535A}, //8009 #CJK UNIFIED IDEOGRAPH
    {0xB2AA, 0x52C3}, //8010 #CJK UNIFIED IDEOGRAPH
    {0xB2AB, 0x640F}, //8011 #CJK UNIFIED IDEOGRAPH
    {0xB2AC, 0x94C2}, //8012 #CJK UNIFIED IDEOGRAPH
    {0xB2AD, 0x7B94}, //8013 #CJK UNIFIED IDEOGRAPH
    {0xB2AE, 0x4F2F}, //8014 #CJK UNIFIED IDEOGRAPH
    {0xB2AF, 0x5E1B}, //8015 #CJK UNIFIED IDEOGRAPH
    {0xB2B0, 0x8236}, //8016 #CJK UNIFIED IDEOGRAPH
    {0xB2B1, 0x8116}, //8017 #CJK UNIFIED IDEOGRAPH
    {0xB2B2, 0x818A}, //8018 #CJK UNIFIED IDEOGRAPH
    {0xB2B3, 0x6E24}, //8019 #CJK UNIFIED IDEOGRAPH
    {0xB2B4, 0x6CCA}, //8020 #CJK UNIFIED IDEOGRAPH
    {0xB2B5, 0x9A73}, //8021 #CJK UNIFIED IDEOGRAPH
    {0xB2B6, 0x6355}, //8022 #CJK UNIFIED IDEOGRAPH
    {0xB2B7, 0x535C}, //8023 #CJK UNIFIED IDEOGRAPH
    {0xB2B8, 0x54FA}, //8024 #CJK UNIFIED IDEOGRAPH
    {0xB2B9, 0x8865}, //8025 #CJK UNIFIED IDEOGRAPH
    {0xB2BA, 0x57E0}, //8026 #CJK UNIFIED IDEOGRAPH
    {0xB2BB, 0x4E0D}, //8027 #CJK UNIFIED IDEOGRAPH
    {0xB2BC, 0x5E03}, //8028 #CJK UNIFIED IDEOGRAPH
    {0xB2BD, 0x6B65}, //8029 #CJK UNIFIED IDEOGRAPH
    {0xB2BE, 0x7C3F}, //8030 #CJK UNIFIED IDEOGRAPH
    {0xB2BF, 0x90E8}, //8031 #CJK UNIFIED IDEOGRAPH
    {0xB2C0, 0x6016}, //8032 #CJK UNIFIED IDEOGRAPH
    {0xB2C1, 0x64E6}, //8033 #CJK UNIFIED IDEOGRAPH
    {0xB2C2, 0x731C}, //8034 #CJK UNIFIED IDEOGRAPH
    {0xB2C3, 0x88C1}, //8035 #CJK UNIFIED IDEOGRAPH
    {0xB2C4, 0x6750}, //8036 #CJK UNIFIED IDEOGRAPH
    {0xB2C5, 0x624D}, //8037 #CJK UNIFIED IDEOGRAPH
    {0xB2C6, 0x8D22}, //8038 #CJK UNIFIED IDEOGRAPH
    {0xB2C7, 0x776C}, //8039 #CJK UNIFIED IDEOGRAPH
    {0xB2C8, 0x8E29}, //8040 #CJK UNIFIED IDEOGRAPH
    {0xB2C9, 0x91C7}, //8041 #CJK UNIFIED IDEOGRAPH
    {0xB2CA, 0x5F69}, //8042 #CJK UNIFIED IDEOGRAPH
    {0xB2CB, 0x83DC}, //8043 #CJK UNIFIED IDEOGRAPH
    {0xB2CC, 0x8521}, //8044 #CJK UNIFIED IDEOGRAPH
    {0xB2CD, 0x9910}, //8045 #CJK UNIFIED IDEOGRAPH
    {0xB2CE, 0x53C2}, //8046 #CJK UNIFIED IDEOGRAPH
    {0xB2CF, 0x8695}, //8047 #CJK UNIFIED IDEOGRAPH
    {0xB2D0, 0x6B8B}, //8048 #CJK UNIFIED IDEOGRAPH
    {0xB2D1, 0x60ED}, //8049 #CJK UNIFIED IDEOGRAPH
    {0xB2D2, 0x60E8}, //8050 #CJK UNIFIED IDEOGRAPH
    {0xB2D3, 0x707F}, //8051 #CJK UNIFIED IDEOGRAPH
    {0xB2D4, 0x82CD}, //8052 #CJK UNIFIED IDEOGRAPH
    {0xB2D5, 0x8231}, //8053 #CJK UNIFIED IDEOGRAPH
    {0xB2D6, 0x4ED3}, //8054 #CJK UNIFIED IDEOGRAPH
    {0xB2D7, 0x6CA7}, //8055 #CJK UNIFIED IDEOGRAPH
    {0xB2D8, 0x85CF}, //8056 #CJK UNIFIED IDEOGRAPH
    {0xB2D9, 0x64CD}, //8057 #CJK UNIFIED IDEOGRAPH
    {0xB2DA, 0x7CD9}, //8058 #CJK UNIFIED IDEOGRAPH
    {0xB2DB, 0x69FD}, //8059 #CJK UNIFIED IDEOGRAPH
    {0xB2DC, 0x66F9}, //8060 #CJK UNIFIED IDEOGRAPH
    {0xB2DD, 0x8349}, //8061 #CJK UNIFIED IDEOGRAPH
    {0xB2DE, 0x5395}, //8062 #CJK UNIFIED IDEOGRAPH
    {0xB2DF, 0x7B56}, //8063 #CJK UNIFIED IDEOGRAPH
    {0xB2E0, 0x4FA7}, //8064 #CJK UNIFIED IDEOGRAPH
    {0xB2E1, 0x518C}, //8065 #CJK UNIFIED IDEOGRAPH
    {0xB2E2, 0x6D4B}, //8066 #CJK UNIFIED IDEOGRAPH
    {0xB2E3, 0x5C42}, //8067 #CJK UNIFIED IDEOGRAPH
    {0xB2E4, 0x8E6D}, //8068 #CJK UNIFIED IDEOGRAPH
    {0xB2E5, 0x63D2}, //8069 #CJK UNIFIED IDEOGRAPH
    {0xB2E6, 0x53C9}, //8070 #CJK UNIFIED IDEOGRAPH
    {0xB2E7, 0x832C}, //8071 #CJK UNIFIED IDEOGRAPH
    {0xB2E8, 0x8336}, //8072 #CJK UNIFIED IDEOGRAPH
    {0xB2E9, 0x67E5}, //8073 #CJK UNIFIED IDEOGRAPH
    {0xB2EA, 0x78B4}, //8074 #CJK UNIFIED IDEOGRAPH
    {0xB2EB, 0x643D}, //8075 #CJK UNIFIED IDEOGRAPH
    {0xB2EC, 0x5BDF}, //8076 #CJK UNIFIED IDEOGRAPH
    {0xB2ED, 0x5C94}, //8077 #CJK UNIFIED IDEOGRAPH
    {0xB2EE, 0x5DEE}, //8078 #CJK UNIFIED IDEOGRAPH
    {0xB2EF, 0x8BE7}, //8079 #CJK UNIFIED IDEOGRAPH
    {0xB2F0, 0x62C6}, //8080 #CJK UNIFIED IDEOGRAPH
    {0xB2F1, 0x67F4}, //8081 #CJK UNIFIED IDEOGRAPH
    {0xB2F2, 0x8C7A}, //8082 #CJK UNIFIED IDEOGRAPH
    {0xB2F3, 0x6400}, //8083 #CJK UNIFIED IDEOGRAPH
    {0xB2F4, 0x63BA}, //8084 #CJK UNIFIED IDEOGRAPH
    {0xB2F5, 0x8749}, //8085 #CJK UNIFIED IDEOGRAPH
    {0xB2F6, 0x998B}, //8086 #CJK UNIFIED IDEOGRAPH
    {0xB2F7, 0x8C17}, //8087 #CJK UNIFIED IDEOGRAPH
    {0xB2F8, 0x7F20}, //8088 #CJK UNIFIED IDEOGRAPH
    {0xB2F9, 0x94F2}, //8089 #CJK UNIFIED IDEOGRAPH
    {0xB2FA, 0x4EA7}, //8090 #CJK UNIFIED IDEOGRAPH
    {0xB2FB, 0x9610}, //8091 #CJK UNIFIED IDEOGRAPH
    {0xB2FC, 0x98A4}, //8092 #CJK UNIFIED IDEOGRAPH
    {0xB2FD, 0x660C}, //8093 #CJK UNIFIED IDEOGRAPH
    {0xB2FE, 0x7316}, //8094 #CJK UNIFIED IDEOGRAPH
    {0xB340, 0x77E6}, //8095 #CJK UNIFIED IDEOGRAPH
    {0xB341, 0x77E8}, //8096 #CJK UNIFIED IDEOGRAPH
    {0xB342, 0x77EA}, //8097 #CJK UNIFIED IDEOGRAPH
    {0xB343, 0x77EF}, //8098 #CJK UNIFIED IDEOGRAPH
    {0xB344, 0x77F0}, //8099 #CJK UNIFIED IDEOGRAPH
    {0xB345, 0x77F1}, //8100 #CJK UNIFIED IDEOGRAPH
    {0xB346, 0x77F2}, //8101 #CJK UNIFIED IDEOGRAPH
    {0xB347, 0x77F4}, //8102 #CJK UNIFIED IDEOGRAPH
    {0xB348, 0x77F5}, //8103 #CJK UNIFIED IDEOGRAPH
    {0xB349, 0x77F7}, //8104 #CJK UNIFIED IDEOGRAPH
    {0xB34A, 0x77F9}, //8105 #CJK UNIFIED IDEOGRAPH
    {0xB34B, 0x77FA}, //8106 #CJK UNIFIED IDEOGRAPH
    {0xB34C, 0x77FB}, //8107 #CJK UNIFIED IDEOGRAPH
    {0xB34D, 0x77FC}, //8108 #CJK UNIFIED IDEOGRAPH
    {0xB34E, 0x7803}, //8109 #CJK UNIFIED IDEOGRAPH
    {0xB34F, 0x7804}, //8110 #CJK UNIFIED IDEOGRAPH
    {0xB350, 0x7805}, //8111 #CJK UNIFIED IDEOGRAPH
    {0xB351, 0x7806}, //8112 #CJK UNIFIED IDEOGRAPH
    {0xB352, 0x7807}, //8113 #CJK UNIFIED IDEOGRAPH
    {0xB353, 0x7808}, //8114 #CJK UNIFIED IDEOGRAPH
    {0xB354, 0x780A}, //8115 #CJK UNIFIED IDEOGRAPH
    {0xB355, 0x780B}, //8116 #CJK UNIFIED IDEOGRAPH
    {0xB356, 0x780E}, //8117 #CJK UNIFIED IDEOGRAPH
    {0xB357, 0x780F}, //8118 #CJK UNIFIED IDEOGRAPH
    {0xB358, 0x7810}, //8119 #CJK UNIFIED IDEOGRAPH
    {0xB359, 0x7813}, //8120 #CJK UNIFIED IDEOGRAPH
    {0xB35A, 0x7815}, //8121 #CJK UNIFIED IDEOGRAPH
    {0xB35B, 0x7819}, //8122 #CJK UNIFIED IDEOGRAPH
    {0xB35C, 0x781B}, //8123 #CJK UNIFIED IDEOGRAPH
    {0xB35D, 0x781E}, //8124 #CJK UNIFIED IDEOGRAPH
    {0xB35E, 0x7820}, //8125 #CJK UNIFIED IDEOGRAPH
    {0xB35F, 0x7821}, //8126 #CJK UNIFIED IDEOGRAPH
    {0xB360, 0x7822}, //8127 #CJK UNIFIED IDEOGRAPH
    {0xB361, 0x7824}, //8128 #CJK UNIFIED IDEOGRAPH
    {0xB362, 0x7828}, //8129 #CJK UNIFIED IDEOGRAPH
    {0xB363, 0x782A}, //8130 #CJK UNIFIED IDEOGRAPH
    {0xB364, 0x782B}, //8131 #CJK UNIFIED IDEOGRAPH
    {0xB365, 0x782E}, //8132 #CJK UNIFIED IDEOGRAPH
    {0xB366, 0x782F}, //8133 #CJK UNIFIED IDEOGRAPH
    {0xB367, 0x7831}, //8134 #CJK UNIFIED IDEOGRAPH
    {0xB368, 0x7832}, //8135 #CJK UNIFIED IDEOGRAPH
    {0xB369, 0x7833}, //8136 #CJK UNIFIED IDEOGRAPH
    {0xB36A, 0x7835}, //8137 #CJK UNIFIED IDEOGRAPH
    {0xB36B, 0x7836}, //8138 #CJK UNIFIED IDEOGRAPH
    {0xB36C, 0x783D}, //8139 #CJK UNIFIED IDEOGRAPH
    {0xB36D, 0x783F}, //8140 #CJK UNIFIED IDEOGRAPH
    {0xB36E, 0x7841}, //8141 #CJK UNIFIED IDEOGRAPH
    {0xB36F, 0x7842}, //8142 #CJK UNIFIED IDEOGRAPH
    {0xB370, 0x7843}, //8143 #CJK UNIFIED IDEOGRAPH
    {0xB371, 0x7844}, //8144 #CJK UNIFIED IDEOGRAPH
    {0xB372, 0x7846}, //8145 #CJK UNIFIED IDEOGRAPH
    {0xB373, 0x7848}, //8146 #CJK UNIFIED IDEOGRAPH
    {0xB374, 0x7849}, //8147 #CJK UNIFIED IDEOGRAPH
    {0xB375, 0x784A}, //8148 #CJK UNIFIED IDEOGRAPH
    {0xB376, 0x784B}, //8149 #CJK UNIFIED IDEOGRAPH
    {0xB377, 0x784D}, //8150 #CJK UNIFIED IDEOGRAPH
    {0xB378, 0x784F}, //8151 #CJK UNIFIED IDEOGRAPH
    {0xB379, 0x7851}, //8152 #CJK UNIFIED IDEOGRAPH
    {0xB37A, 0x7853}, //8153 #CJK UNIFIED IDEOGRAPH
    {0xB37B, 0x7854}, //8154 #CJK UNIFIED IDEOGRAPH
    {0xB37C, 0x7858}, //8155 #CJK UNIFIED IDEOGRAPH
    {0xB37D, 0x7859}, //8156 #CJK UNIFIED IDEOGRAPH
    {0xB37E, 0x785A}, //8157 #CJK UNIFIED IDEOGRAPH
    {0xB380, 0x785B}, //8158 #CJK UNIFIED IDEOGRAPH
    {0xB381, 0x785C}, //8159 #CJK UNIFIED IDEOGRAPH
    {0xB382, 0x785E}, //8160 #CJK UNIFIED IDEOGRAPH
    {0xB383, 0x785F}, //8161 #CJK UNIFIED IDEOGRAPH
    {0xB384, 0x7860}, //8162 #CJK UNIFIED IDEOGRAPH
    {0xB385, 0x7861}, //8163 #CJK UNIFIED IDEOGRAPH
    {0xB386, 0x7862}, //8164 #CJK UNIFIED IDEOGRAPH
    {0xB387, 0x7863}, //8165 #CJK UNIFIED IDEOGRAPH
    {0xB388, 0x7864}, //8166 #CJK UNIFIED IDEOGRAPH
    {0xB389, 0x7865}, //8167 #CJK UNIFIED IDEOGRAPH
    {0xB38A, 0x7866}, //8168 #CJK UNIFIED IDEOGRAPH
    {0xB38B, 0x7867}, //8169 #CJK UNIFIED IDEOGRAPH
    {0xB38C, 0x7868}, //8170 #CJK UNIFIED IDEOGRAPH
    {0xB38D, 0x7869}, //8171 #CJK UNIFIED IDEOGRAPH
    {0xB38E, 0x786F}, //8172 #CJK UNIFIED IDEOGRAPH
    {0xB38F, 0x7870}, //8173 #CJK UNIFIED IDEOGRAPH
    {0xB390, 0x7871}, //8174 #CJK UNIFIED IDEOGRAPH
    {0xB391, 0x7872}, //8175 #CJK UNIFIED IDEOGRAPH
    {0xB392, 0x7873}, //8176 #CJK UNIFIED IDEOGRAPH
    {0xB393, 0x7874}, //8177 #CJK UNIFIED IDEOGRAPH
    {0xB394, 0x7875}, //8178 #CJK UNIFIED IDEOGRAPH
    {0xB395, 0x7876}, //8179 #CJK UNIFIED IDEOGRAPH
    {0xB396, 0x7878}, //8180 #CJK UNIFIED IDEOGRAPH
    {0xB397, 0x7879}, //8181 #CJK UNIFIED IDEOGRAPH
    {0xB398, 0x787A}, //8182 #CJK UNIFIED IDEOGRAPH
    {0xB399, 0x787B}, //8183 #CJK UNIFIED IDEOGRAPH
    {0xB39A, 0x787D}, //8184 #CJK UNIFIED IDEOGRAPH
    {0xB39B, 0x787E}, //8185 #CJK UNIFIED IDEOGRAPH
    {0xB39C, 0x787F}, //8186 #CJK UNIFIED IDEOGRAPH
    {0xB39D, 0x7880}, //8187 #CJK UNIFIED IDEOGRAPH
    {0xB39E, 0x7881}, //8188 #CJK UNIFIED IDEOGRAPH
    {0xB39F, 0x7882}, //8189 #CJK UNIFIED IDEOGRAPH
    {0xB3A0, 0x7883}, //8190 #CJK UNIFIED IDEOGRAPH
    {0xB3A1, 0x573A}, //8191 #CJK UNIFIED IDEOGRAPH
    {0xB3A2, 0x5C1D}, //8192 #CJK UNIFIED IDEOGRAPH
    {0xB3A3, 0x5E38}, //8193 #CJK UNIFIED IDEOGRAPH
    {0xB3A4, 0x957F}, //8194 #CJK UNIFIED IDEOGRAPH
    {0xB3A5, 0x507F}, //8195 #CJK UNIFIED IDEOGRAPH
    {0xB3A6, 0x80A0}, //8196 #CJK UNIFIED IDEOGRAPH
    {0xB3A7, 0x5382}, //8197 #CJK UNIFIED IDEOGRAPH
    {0xB3A8, 0x655E}, //8198 #CJK UNIFIED IDEOGRAPH
    {0xB3A9, 0x7545}, //8199 #CJK UNIFIED IDEOGRAPH
    {0xB3AA, 0x5531}, //8200 #CJK UNIFIED IDEOGRAPH
    {0xB3AB, 0x5021}, //8201 #CJK UNIFIED IDEOGRAPH
    {0xB3AC, 0x8D85}, //8202 #CJK UNIFIED IDEOGRAPH
    {0xB3AD, 0x6284}, //8203 #CJK UNIFIED IDEOGRAPH
    {0xB3AE, 0x949E}, //8204 #CJK UNIFIED IDEOGRAPH
    {0xB3AF, 0x671D}, //8205 #CJK UNIFIED IDEOGRAPH
    {0xB3B0, 0x5632}, //8206 #CJK UNIFIED IDEOGRAPH
    {0xB3B1, 0x6F6E}, //8207 #CJK UNIFIED IDEOGRAPH
    {0xB3B2, 0x5DE2}, //8208 #CJK UNIFIED IDEOGRAPH
    {0xB3B3, 0x5435}, //8209 #CJK UNIFIED IDEOGRAPH
    {0xB3B4, 0x7092}, //8210 #CJK UNIFIED IDEOGRAPH
    {0xB3B5, 0x8F66}, //8211 #CJK UNIFIED IDEOGRAPH
    {0xB3B6, 0x626F}, //8212 #CJK UNIFIED IDEOGRAPH
    {0xB3B7, 0x64A4}, //8213 #CJK UNIFIED IDEOGRAPH
    {0xB3B8, 0x63A3}, //8214 #CJK UNIFIED IDEOGRAPH
    {0xB3B9, 0x5F7B}, //8215 #CJK UNIFIED IDEOGRAPH
    {0xB3BA, 0x6F88}, //8216 #CJK UNIFIED IDEOGRAPH
    {0xB3BB, 0x90F4}, //8217 #CJK UNIFIED IDEOGRAPH
    {0xB3BC, 0x81E3}, //8218 #CJK UNIFIED IDEOGRAPH
    {0xB3BD, 0x8FB0}, //8219 #CJK UNIFIED IDEOGRAPH
    {0xB3BE, 0x5C18}, //8220 #CJK UNIFIED IDEOGRAPH
    {0xB3BF, 0x6668}, //8221 #CJK UNIFIED IDEOGRAPH
    {0xB3C0, 0x5FF1}, //8222 #CJK UNIFIED IDEOGRAPH
    {0xB3C1, 0x6C89}, //8223 #CJK UNIFIED IDEOGRAPH
    {0xB3C2, 0x9648}, //8224 #CJK UNIFIED IDEOGRAPH
    {0xB3C3, 0x8D81}, //8225 #CJK UNIFIED IDEOGRAPH
    {0xB3C4, 0x886C}, //8226 #CJK UNIFIED IDEOGRAPH
    {0xB3C5, 0x6491}, //8227 #CJK UNIFIED IDEOGRAPH
    {0xB3C6, 0x79F0}, //8228 #CJK UNIFIED IDEOGRAPH
    {0xB3C7, 0x57CE}, //8229 #CJK UNIFIED IDEOGRAPH
    {0xB3C8, 0x6A59}, //8230 #CJK UNIFIED IDEOGRAPH
    {0xB3C9, 0x6210}, //8231 #CJK UNIFIED IDEOGRAPH
    {0xB3CA, 0x5448}, //8232 #CJK UNIFIED IDEOGRAPH
    {0xB3CB, 0x4E58}, //8233 #CJK UNIFIED IDEOGRAPH
    {0xB3CC, 0x7A0B}, //8234 #CJK UNIFIED IDEOGRAPH
    {0xB3CD, 0x60E9}, //8235 #CJK UNIFIED IDEOGRAPH
    {0xB3CE, 0x6F84}, //8236 #CJK UNIFIED IDEOGRAPH
    {0xB3CF, 0x8BDA}, //8237 #CJK UNIFIED IDEOGRAPH
    {0xB3D0, 0x627F}, //8238 #CJK UNIFIED IDEOGRAPH
    {0xB3D1, 0x901E}, //8239 #CJK UNIFIED IDEOGRAPH
    {0xB3D2, 0x9A8B}, //8240 #CJK UNIFIED IDEOGRAPH
    {0xB3D3, 0x79E4}, //8241 #CJK UNIFIED IDEOGRAPH
    {0xB3D4, 0x5403}, //8242 #CJK UNIFIED IDEOGRAPH
    {0xB3D5, 0x75F4}, //8243 #CJK UNIFIED IDEOGRAPH
    {0xB3D6, 0x6301}, //8244 #CJK UNIFIED IDEOGRAPH
    {0xB3D7, 0x5319}, //8245 #CJK UNIFIED IDEOGRAPH
    {0xB3D8, 0x6C60}, //8246 #CJK UNIFIED IDEOGRAPH
    {0xB3D9, 0x8FDF}, //8247 #CJK UNIFIED IDEOGRAPH
    {0xB3DA, 0x5F1B}, //8248 #CJK UNIFIED IDEOGRAPH
    {0xB3DB, 0x9A70}, //8249 #CJK UNIFIED IDEOGRAPH
    {0xB3DC, 0x803B}, //8250 #CJK UNIFIED IDEOGRAPH
    {0xB3DD, 0x9F7F}, //8251 #CJK UNIFIED IDEOGRAPH
    {0xB3DE, 0x4F88}, //8252 #CJK UNIFIED IDEOGRAPH
    {0xB3DF, 0x5C3A}, //8253 #CJK UNIFIED IDEOGRAPH
    {0xB3E0, 0x8D64}, //8254 #CJK UNIFIED IDEOGRAPH
    {0xB3E1, 0x7FC5}, //8255 #CJK UNIFIED IDEOGRAPH
    {0xB3E2, 0x65A5}, //8256 #CJK UNIFIED IDEOGRAPH
    {0xB3E3, 0x70BD}, //8257 #CJK UNIFIED IDEOGRAPH
    {0xB3E4, 0x5145}, //8258 #CJK UNIFIED IDEOGRAPH
    {0xB3E5, 0x51B2}, //8259 #CJK UNIFIED IDEOGRAPH
    {0xB3E6, 0x866B}, //8260 #CJK UNIFIED IDEOGRAPH
    {0xB3E7, 0x5D07}, //8261 #CJK UNIFIED IDEOGRAPH
    {0xB3E8, 0x5BA0}, //8262 #CJK UNIFIED IDEOGRAPH
    {0xB3E9, 0x62BD}, //8263 #CJK UNIFIED IDEOGRAPH
    {0xB3EA, 0x916C}, //8264 #CJK UNIFIED IDEOGRAPH
    {0xB3EB, 0x7574}, //8265 #CJK UNIFIED IDEOGRAPH
    {0xB3EC, 0x8E0C}, //8266 #CJK UNIFIED IDEOGRAPH
    {0xB3ED, 0x7A20}, //8267 #CJK UNIFIED IDEOGRAPH
    {0xB3EE, 0x6101}, //8268 #CJK UNIFIED IDEOGRAPH
    {0xB3EF, 0x7B79}, //8269 #CJK UNIFIED IDEOGRAPH
    {0xB3F0, 0x4EC7}, //8270 #CJK UNIFIED IDEOGRAPH
    {0xB3F1, 0x7EF8}, //8271 #CJK UNIFIED IDEOGRAPH
    {0xB3F2, 0x7785}, //8272 #CJK UNIFIED IDEOGRAPH
    {0xB3F3, 0x4E11}, //8273 #CJK UNIFIED IDEOGRAPH
    {0xB3F4, 0x81ED}, //8274 #CJK UNIFIED IDEOGRAPH
    {0xB3F5, 0x521D}, //8275 #CJK UNIFIED IDEOGRAPH
    {0xB3F6, 0x51FA}, //8276 #CJK UNIFIED IDEOGRAPH
    {0xB3F7, 0x6A71}, //8277 #CJK UNIFIED IDEOGRAPH
    {0xB3F8, 0x53A8}, //8278 #CJK UNIFIED IDEOGRAPH
    {0xB3F9, 0x8E87}, //8279 #CJK UNIFIED IDEOGRAPH
    {0xB3FA, 0x9504}, //8280 #CJK UNIFIED IDEOGRAPH
    {0xB3FB, 0x96CF}, //8281 #CJK UNIFIED IDEOGRAPH
    {0xB3FC, 0x6EC1}, //8282 #CJK UNIFIED IDEOGRAPH
    {0xB3FD, 0x9664}, //8283 #CJK UNIFIED IDEOGRAPH
    {0xB3FE, 0x695A}, //8284 #CJK UNIFIED IDEOGRAPH
    {0xB440, 0x7884}, //8285 #CJK UNIFIED IDEOGRAPH
    {0xB441, 0x7885}, //8286 #CJK UNIFIED IDEOGRAPH
    {0xB442, 0x7886}, //8287 #CJK UNIFIED IDEOGRAPH
    {0xB443, 0x7888}, //8288 #CJK UNIFIED IDEOGRAPH
    {0xB444, 0x788A}, //8289 #CJK UNIFIED IDEOGRAPH
    {0xB445, 0x788B}, //8290 #CJK UNIFIED IDEOGRAPH
    {0xB446, 0x788F}, //8291 #CJK UNIFIED IDEOGRAPH
    {0xB447, 0x7890}, //8292 #CJK UNIFIED IDEOGRAPH
    {0xB448, 0x7892}, //8293 #CJK UNIFIED IDEOGRAPH
    {0xB449, 0x7894}, //8294 #CJK UNIFIED IDEOGRAPH
    {0xB44A, 0x7895}, //8295 #CJK UNIFIED IDEOGRAPH
    {0xB44B, 0x7896}, //8296 #CJK UNIFIED IDEOGRAPH
    {0xB44C, 0x7899}, //8297 #CJK UNIFIED IDEOGRAPH
    {0xB44D, 0x789D}, //8298 #CJK UNIFIED IDEOGRAPH
    {0xB44E, 0x789E}, //8299 #CJK UNIFIED IDEOGRAPH
    {0xB44F, 0x78A0}, //8300 #CJK UNIFIED IDEOGRAPH
    {0xB450, 0x78A2}, //8301 #CJK UNIFIED IDEOGRAPH
    {0xB451, 0x78A4}, //8302 #CJK UNIFIED IDEOGRAPH
    {0xB452, 0x78A6}, //8303 #CJK UNIFIED IDEOGRAPH
    {0xB453, 0x78A8}, //8304 #CJK UNIFIED IDEOGRAPH
    {0xB454, 0x78A9}, //8305 #CJK UNIFIED IDEOGRAPH
    {0xB455, 0x78AA}, //8306 #CJK UNIFIED IDEOGRAPH
    {0xB456, 0x78AB}, //8307 #CJK UNIFIED IDEOGRAPH
    {0xB457, 0x78AC}, //8308 #CJK UNIFIED IDEOGRAPH
    {0xB458, 0x78AD}, //8309 #CJK UNIFIED IDEOGRAPH
    {0xB459, 0x78AE}, //8310 #CJK UNIFIED IDEOGRAPH
    {0xB45A, 0x78AF}, //8311 #CJK UNIFIED IDEOGRAPH
    {0xB45B, 0x78B5}, //8312 #CJK UNIFIED IDEOGRAPH
    {0xB45C, 0x78B6}, //8313 #CJK UNIFIED IDEOGRAPH
    {0xB45D, 0x78B7}, //8314 #CJK UNIFIED IDEOGRAPH
    {0xB45E, 0x78B8}, //8315 #CJK UNIFIED IDEOGRAPH
    {0xB45F, 0x78BA}, //8316 #CJK UNIFIED IDEOGRAPH
    {0xB460, 0x78BB}, //8317 #CJK UNIFIED IDEOGRAPH
    {0xB461, 0x78BC}, //8318 #CJK UNIFIED IDEOGRAPH
    {0xB462, 0x78BD}, //8319 #CJK UNIFIED IDEOGRAPH
    {0xB463, 0x78BF}, //8320 #CJK UNIFIED IDEOGRAPH
    {0xB464, 0x78C0}, //8321 #CJK UNIFIED IDEOGRAPH
    {0xB465, 0x78C2}, //8322 #CJK UNIFIED IDEOGRAPH
    {0xB466, 0x78C3}, //8323 #CJK UNIFIED IDEOGRAPH
    {0xB467, 0x78C4}, //8324 #CJK UNIFIED IDEOGRAPH
    {0xB468, 0x78C6}, //8325 #CJK UNIFIED IDEOGRAPH
    {0xB469, 0x78C7}, //8326 #CJK UNIFIED IDEOGRAPH
    {0xB46A, 0x78C8}, //8327 #CJK UNIFIED IDEOGRAPH
    {0xB46B, 0x78CC}, //8328 #CJK UNIFIED IDEOGRAPH
    {0xB46C, 0x78CD}, //8329 #CJK UNIFIED IDEOGRAPH
    {0xB46D, 0x78CE}, //8330 #CJK UNIFIED IDEOGRAPH
    {0xB46E, 0x78CF}, //8331 #CJK UNIFIED IDEOGRAPH
    {0xB46F, 0x78D1}, //8332 #CJK UNIFIED IDEOGRAPH
    {0xB470, 0x78D2}, //8333 #CJK UNIFIED IDEOGRAPH
    {0xB471, 0x78D3}, //8334 #CJK UNIFIED IDEOGRAPH
    {0xB472, 0x78D6}, //8335 #CJK UNIFIED IDEOGRAPH
    {0xB473, 0x78D7}, //8336 #CJK UNIFIED IDEOGRAPH
    {0xB474, 0x78D8}, //8337 #CJK UNIFIED IDEOGRAPH
    {0xB475, 0x78DA}, //8338 #CJK UNIFIED IDEOGRAPH
    {0xB476, 0x78DB}, //8339 #CJK UNIFIED IDEOGRAPH
    {0xB477, 0x78DC}, //8340 #CJK UNIFIED IDEOGRAPH
    {0xB478, 0x78DD}, //8341 #CJK UNIFIED IDEOGRAPH
    {0xB479, 0x78DE}, //8342 #CJK UNIFIED IDEOGRAPH
    {0xB47A, 0x78DF}, //8343 #CJK UNIFIED IDEOGRAPH
    {0xB47B, 0x78E0}, //8344 #CJK UNIFIED IDEOGRAPH
    {0xB47C, 0x78E1}, //8345 #CJK UNIFIED IDEOGRAPH
    {0xB47D, 0x78E2}, //8346 #CJK UNIFIED IDEOGRAPH
    {0xB47E, 0x78E3}, //8347 #CJK UNIFIED IDEOGRAPH
    {0xB480, 0x78E4}, //8348 #CJK UNIFIED IDEOGRAPH
    {0xB481, 0x78E5}, //8349 #CJK UNIFIED IDEOGRAPH
    {0xB482, 0x78E6}, //8350 #CJK UNIFIED IDEOGRAPH
    {0xB483, 0x78E7}, //8351 #CJK UNIFIED IDEOGRAPH
    {0xB484, 0x78E9}, //8352 #CJK UNIFIED IDEOGRAPH
    {0xB485, 0x78EA}, //8353 #CJK UNIFIED IDEOGRAPH
    {0xB486, 0x78EB}, //8354 #CJK UNIFIED IDEOGRAPH
    {0xB487, 0x78ED}, //8355 #CJK UNIFIED IDEOGRAPH
    {0xB488, 0x78EE}, //8356 #CJK UNIFIED IDEOGRAPH
    {0xB489, 0x78EF}, //8357 #CJK UNIFIED IDEOGRAPH
    {0xB48A, 0x78F0}, //8358 #CJK UNIFIED IDEOGRAPH
    {0xB48B, 0x78F1}, //8359 #CJK UNIFIED IDEOGRAPH
    {0xB48C, 0x78F3}, //8360 #CJK UNIFIED IDEOGRAPH
    {0xB48D, 0x78F5}, //8361 #CJK UNIFIED IDEOGRAPH
    {0xB48E, 0x78F6}, //8362 #CJK UNIFIED IDEOGRAPH
    {0xB48F, 0x78F8}, //8363 #CJK UNIFIED IDEOGRAPH
    {0xB490, 0x78F9}, //8364 #CJK UNIFIED IDEOGRAPH
    {0xB491, 0x78FB}, //8365 #CJK UNIFIED IDEOGRAPH
    {0xB492, 0x78FC}, //8366 #CJK UNIFIED IDEOGRAPH
    {0xB493, 0x78FD}, //8367 #CJK UNIFIED IDEOGRAPH
    {0xB494, 0x78FE}, //8368 #CJK UNIFIED IDEOGRAPH
    {0xB495, 0x78FF}, //8369 #CJK UNIFIED IDEOGRAPH
    {0xB496, 0x7900}, //8370 #CJK UNIFIED IDEOGRAPH
    {0xB497, 0x7902}, //8371 #CJK UNIFIED IDEOGRAPH
    {0xB498, 0x7903}, //8372 #CJK UNIFIED IDEOGRAPH
    {0xB499, 0x7904}, //8373 #CJK UNIFIED IDEOGRAPH
    {0xB49A, 0x7906}, //8374 #CJK UNIFIED IDEOGRAPH
    {0xB49B, 0x7907}, //8375 #CJK UNIFIED IDEOGRAPH
    {0xB49C, 0x7908}, //8376 #CJK UNIFIED IDEOGRAPH
    {0xB49D, 0x7909}, //8377 #CJK UNIFIED IDEOGRAPH
    {0xB49E, 0x790A}, //8378 #CJK UNIFIED IDEOGRAPH
    {0xB49F, 0x790B}, //8379 #CJK UNIFIED IDEOGRAPH
    {0xB4A0, 0x790C}, //8380 #CJK UNIFIED IDEOGRAPH
    {0xB4A1, 0x7840}, //8381 #CJK UNIFIED IDEOGRAPH
    {0xB4A2, 0x50A8}, //8382 #CJK UNIFIED IDEOGRAPH
    {0xB4A3, 0x77D7}, //8383 #CJK UNIFIED IDEOGRAPH
    {0xB4A4, 0x6410}, //8384 #CJK UNIFIED IDEOGRAPH
    {0xB4A5, 0x89E6}, //8385 #CJK UNIFIED IDEOGRAPH
    {0xB4A6, 0x5904}, //8386 #CJK UNIFIED IDEOGRAPH
    {0xB4A7, 0x63E3}, //8387 #CJK UNIFIED IDEOGRAPH
    {0xB4A8, 0x5DDD}, //8388 #CJK UNIFIED IDEOGRAPH
    {0xB4A9, 0x7A7F}, //8389 #CJK UNIFIED IDEOGRAPH
    {0xB4AA, 0x693D}, //8390 #CJK UNIFIED IDEOGRAPH
    {0xB4AB, 0x4F20}, //8391 #CJK UNIFIED IDEOGRAPH
    {0xB4AC, 0x8239}, //8392 #CJK UNIFIED IDEOGRAPH
    {0xB4AD, 0x5598}, //8393 #CJK UNIFIED IDEOGRAPH
    {0xB4AE, 0x4E32}, //8394 #CJK UNIFIED IDEOGRAPH
    {0xB4AF, 0x75AE}, //8395 #CJK UNIFIED IDEOGRAPH
    {0xB4B0, 0x7A97}, //8396 #CJK UNIFIED IDEOGRAPH
    {0xB4B1, 0x5E62}, //8397 #CJK UNIFIED IDEOGRAPH
    {0xB4B2, 0x5E8A}, //8398 #CJK UNIFIED IDEOGRAPH
    {0xB4B3, 0x95EF}, //8399 #CJK UNIFIED IDEOGRAPH
    {0xB4B4, 0x521B}, //8400 #CJK UNIFIED IDEOGRAPH
    {0xB4B5, 0x5439}, //8401 #CJK UNIFIED IDEOGRAPH
    {0xB4B6, 0x708A}, //8402 #CJK UNIFIED IDEOGRAPH
    {0xB4B7, 0x6376}, //8403 #CJK UNIFIED IDEOGRAPH
    {0xB4B8, 0x9524}, //8404 #CJK UNIFIED IDEOGRAPH
    {0xB4B9, 0x5782}, //8405 #CJK UNIFIED IDEOGRAPH
    {0xB4BA, 0x6625}, //8406 #CJK UNIFIED IDEOGRAPH
    {0xB4BB, 0x693F}, //8407 #CJK UNIFIED IDEOGRAPH
    {0xB4BC, 0x9187}, //8408 #CJK UNIFIED IDEOGRAPH
    {0xB4BD, 0x5507}, //8409 #CJK UNIFIED IDEOGRAPH
    {0xB4BE, 0x6DF3}, //8410 #CJK UNIFIED IDEOGRAPH
    {0xB4BF, 0x7EAF}, //8411 #CJK UNIFIED IDEOGRAPH
    {0xB4C0, 0x8822}, //8412 #CJK UNIFIED IDEOGRAPH
    {0xB4C1, 0x6233}, //8413 #CJK UNIFIED IDEOGRAPH
    {0xB4C2, 0x7EF0}, //8414 #CJK UNIFIED IDEOGRAPH
    {0xB4C3, 0x75B5}, //8415 #CJK UNIFIED IDEOGRAPH
    {0xB4C4, 0x8328}, //8416 #CJK UNIFIED IDEOGRAPH
    {0xB4C5, 0x78C1}, //8417 #CJK UNIFIED IDEOGRAPH
    {0xB4C6, 0x96CC}, //8418 #CJK UNIFIED IDEOGRAPH
    {0xB4C7, 0x8F9E}, //8419 #CJK UNIFIED IDEOGRAPH
    {0xB4C8, 0x6148}, //8420 #CJK UNIFIED IDEOGRAPH
    {0xB4C9, 0x74F7}, //8421 #CJK UNIFIED IDEOGRAPH
    {0xB4CA, 0x8BCD}, //8422 #CJK UNIFIED IDEOGRAPH
    {0xB4CB, 0x6B64}, //8423 #CJK UNIFIED IDEOGRAPH
    {0xB4CC, 0x523A}, //8424 #CJK UNIFIED IDEOGRAPH
    {0xB4CD, 0x8D50}, //8425 #CJK UNIFIED IDEOGRAPH
    {0xB4CE, 0x6B21}, //8426 #CJK UNIFIED IDEOGRAPH
    {0xB4CF, 0x806A}, //8427 #CJK UNIFIED IDEOGRAPH
    {0xB4D0, 0x8471}, //8428 #CJK UNIFIED IDEOGRAPH
    {0xB4D1, 0x56F1}, //8429 #CJK UNIFIED IDEOGRAPH
    {0xB4D2, 0x5306}, //8430 #CJK UNIFIED IDEOGRAPH
    {0xB4D3, 0x4ECE}, //8431 #CJK UNIFIED IDEOGRAPH
    {0xB4D4, 0x4E1B}, //8432 #CJK UNIFIED IDEOGRAPH
    {0xB4D5, 0x51D1}, //8433 #CJK UNIFIED IDEOGRAPH
    {0xB4D6, 0x7C97}, //8434 #CJK UNIFIED IDEOGRAPH
    {0xB4D7, 0x918B}, //8435 #CJK UNIFIED IDEOGRAPH
    {0xB4D8, 0x7C07}, //8436 #CJK UNIFIED IDEOGRAPH
    {0xB4D9, 0x4FC3}, //8437 #CJK UNIFIED IDEOGRAPH
    {0xB4DA, 0x8E7F}, //8438 #CJK UNIFIED IDEOGRAPH
    {0xB4DB, 0x7BE1}, //8439 #CJK UNIFIED IDEOGRAPH
    {0xB4DC, 0x7A9C}, //8440 #CJK UNIFIED IDEOGRAPH
    {0xB4DD, 0x6467}, //8441 #CJK UNIFIED IDEOGRAPH
    {0xB4DE, 0x5D14}, //8442 #CJK UNIFIED IDEOGRAPH
    {0xB4DF, 0x50AC}, //8443 #CJK UNIFIED IDEOGRAPH
    {0xB4E0, 0x8106}, //8444 #CJK UNIFIED IDEOGRAPH
    {0xB4E1, 0x7601}, //8445 #CJK UNIFIED IDEOGRAPH
    {0xB4E2, 0x7CB9}, //8446 #CJK UNIFIED IDEOGRAPH
    {0xB4E3, 0x6DEC}, //8447 #CJK UNIFIED IDEOGRAPH
    {0xB4E4, 0x7FE0}, //8448 #CJK UNIFIED IDEOGRAPH
    {0xB4E5, 0x6751}, //8449 #CJK UNIFIED IDEOGRAPH
    {0xB4E6, 0x5B58}, //8450 #CJK UNIFIED IDEOGRAPH
    {0xB4E7, 0x5BF8}, //8451 #CJK UNIFIED IDEOGRAPH
    {0xB4E8, 0x78CB}, //8452 #CJK UNIFIED IDEOGRAPH
    {0xB4E9, 0x64AE}, //8453 #CJK UNIFIED IDEOGRAPH
    {0xB4EA, 0x6413}, //8454 #CJK UNIFIED IDEOGRAPH
    {0xB4EB, 0x63AA}, //8455 #CJK UNIFIED IDEOGRAPH
    {0xB4EC, 0x632B}, //8456 #CJK UNIFIED IDEOGRAPH
    {0xB4ED, 0x9519}, //8457 #CJK UNIFIED IDEOGRAPH
    {0xB4EE, 0x642D}, //8458 #CJK UNIFIED IDEOGRAPH
    {0xB4EF, 0x8FBE}, //8459 #CJK UNIFIED IDEOGRAPH
    {0xB4F0, 0x7B54}, //8460 #CJK UNIFIED IDEOGRAPH
    {0xB4F1, 0x7629}, //8461 #CJK UNIFIED IDEOGRAPH
    {0xB4F2, 0x6253}, //8462 #CJK UNIFIED IDEOGRAPH
    {0xB4F3, 0x5927}, //8463 #CJK UNIFIED IDEOGRAPH
    {0xB4F4, 0x5446}, //8464 #CJK UNIFIED IDEOGRAPH
    {0xB4F5, 0x6B79}, //8465 #CJK UNIFIED IDEOGRAPH
    {0xB4F6, 0x50A3}, //8466 #CJK UNIFIED IDEOGRAPH
    {0xB4F7, 0x6234}, //8467 #CJK UNIFIED IDEOGRAPH
    {0xB4F8, 0x5E26}, //8468 #CJK UNIFIED IDEOGRAPH
    {0xB4F9, 0x6B86}, //8469 #CJK UNIFIED IDEOGRAPH
    {0xB4FA, 0x4EE3}, //8470 #CJK UNIFIED IDEOGRAPH
    {0xB4FB, 0x8D37}, //8471 #CJK UNIFIED IDEOGRAPH
    {0xB4FC, 0x888B}, //8472 #CJK UNIFIED IDEOGRAPH
    {0xB4FD, 0x5F85}, //8473 #CJK UNIFIED IDEOGRAPH
    {0xB4FE, 0x902E}, //8474 #CJK UNIFIED IDEOGRAPH
    {0xB540, 0x790D}, //8475 #CJK UNIFIED IDEOGRAPH
    {0xB541, 0x790E}, //8476 #CJK UNIFIED IDEOGRAPH
    {0xB542, 0x790F}, //8477 #CJK UNIFIED IDEOGRAPH
    {0xB543, 0x7910}, //8478 #CJK UNIFIED IDEOGRAPH
    {0xB544, 0x7911}, //8479 #CJK UNIFIED IDEOGRAPH
    {0xB545, 0x7912}, //8480 #CJK UNIFIED IDEOGRAPH
    {0xB546, 0x7914}, //8481 #CJK UNIFIED IDEOGRAPH
    {0xB547, 0x7915}, //8482 #CJK UNIFIED IDEOGRAPH
    {0xB548, 0x7916}, //8483 #CJK UNIFIED IDEOGRAPH
    {0xB549, 0x7917}, //8484 #CJK UNIFIED IDEOGRAPH
    {0xB54A, 0x7918}, //8485 #CJK UNIFIED IDEOGRAPH
    {0xB54B, 0x7919}, //8486 #CJK UNIFIED IDEOGRAPH
    {0xB54C, 0x791A}, //8487 #CJK UNIFIED IDEOGRAPH
    {0xB54D, 0x791B}, //8488 #CJK UNIFIED IDEOGRAPH
    {0xB54E, 0x791C}, //8489 #CJK UNIFIED IDEOGRAPH
    {0xB54F, 0x791D}, //8490 #CJK UNIFIED IDEOGRAPH
    {0xB550, 0x791F}, //8491 #CJK UNIFIED IDEOGRAPH
    {0xB551, 0x7920}, //8492 #CJK UNIFIED IDEOGRAPH
    {0xB552, 0x7921}, //8493 #CJK UNIFIED IDEOGRAPH
    {0xB553, 0x7922}, //8494 #CJK UNIFIED IDEOGRAPH
    {0xB554, 0x7923}, //8495 #CJK UNIFIED IDEOGRAPH
    {0xB555, 0x7925}, //8496 #CJK UNIFIED IDEOGRAPH
    {0xB556, 0x7926}, //8497 #CJK UNIFIED IDEOGRAPH
    {0xB557, 0x7927}, //8498 #CJK UNIFIED IDEOGRAPH
    {0xB558, 0x7928}, //8499 #CJK UNIFIED IDEOGRAPH
    {0xB559, 0x7929}, //8500 #CJK UNIFIED IDEOGRAPH
    {0xB55A, 0x792A}, //8501 #CJK UNIFIED IDEOGRAPH
    {0xB55B, 0x792B}, //8502 #CJK UNIFIED IDEOGRAPH
    {0xB55C, 0x792C}, //8503 #CJK UNIFIED IDEOGRAPH
    {0xB55D, 0x792D}, //8504 #CJK UNIFIED IDEOGRAPH
    {0xB55E, 0x792E}, //8505 #CJK UNIFIED IDEOGRAPH
    {0xB55F, 0x792F}, //8506 #CJK UNIFIED IDEOGRAPH
    {0xB560, 0x7930}, //8507 #CJK UNIFIED IDEOGRAPH
    {0xB561, 0x7931}, //8508 #CJK UNIFIED IDEOGRAPH
    {0xB562, 0x7932}, //8509 #CJK UNIFIED IDEOGRAPH
    {0xB563, 0x7933}, //8510 #CJK UNIFIED IDEOGRAPH
    {0xB564, 0x7935}, //8511 #CJK UNIFIED IDEOGRAPH
    {0xB565, 0x7936}, //8512 #CJK UNIFIED IDEOGRAPH
    {0xB566, 0x7937}, //8513 #CJK UNIFIED IDEOGRAPH
    {0xB567, 0x7938}, //8514 #CJK UNIFIED IDEOGRAPH
    {0xB568, 0x7939}, //8515 #CJK UNIFIED IDEOGRAPH
    {0xB569, 0x793D}, //8516 #CJK UNIFIED IDEOGRAPH
    {0xB56A, 0x793F}, //8517 #CJK UNIFIED IDEOGRAPH
    {0xB56B, 0x7942}, //8518 #CJK UNIFIED IDEOGRAPH
    {0xB56C, 0x7943}, //8519 #CJK UNIFIED IDEOGRAPH
    {0xB56D, 0x7944}, //8520 #CJK UNIFIED IDEOGRAPH
    {0xB56E, 0x7945}, //8521 #CJK UNIFIED IDEOGRAPH
    {0xB56F, 0x7947}, //8522 #CJK UNIFIED IDEOGRAPH
    {0xB570, 0x794A}, //8523 #CJK UNIFIED IDEOGRAPH
    {0xB571, 0x794B}, //8524 #CJK UNIFIED IDEOGRAPH
    {0xB572, 0x794C}, //8525 #CJK UNIFIED IDEOGRAPH
    {0xB573, 0x794D}, //8526 #CJK UNIFIED IDEOGRAPH
    {0xB574, 0x794E}, //8527 #CJK UNIFIED IDEOGRAPH
    {0xB575, 0x794F}, //8528 #CJK UNIFIED IDEOGRAPH
    {0xB576, 0x7950}, //8529 #CJK UNIFIED IDEOGRAPH
    {0xB577, 0x7951}, //8530 #CJK UNIFIED IDEOGRAPH
    {0xB578, 0x7952}, //8531 #CJK UNIFIED IDEOGRAPH
    {0xB579, 0x7954}, //8532 #CJK UNIFIED IDEOGRAPH
    {0xB57A, 0x7955}, //8533 #CJK UNIFIED IDEOGRAPH
    {0xB57B, 0x7958}, //8534 #CJK UNIFIED IDEOGRAPH
    {0xB57C, 0x7959}, //8535 #CJK UNIFIED IDEOGRAPH
    {0xB57D, 0x7961}, //8536 #CJK UNIFIED IDEOGRAPH
    {0xB57E, 0x7963}, //8537 #CJK UNIFIED IDEOGRAPH
    {0xB580, 0x7964}, //8538 #CJK UNIFIED IDEOGRAPH
    {0xB581, 0x7966}, //8539 #CJK UNIFIED IDEOGRAPH
    {0xB582, 0x7969}, //8540 #CJK UNIFIED IDEOGRAPH
    {0xB583, 0x796A}, //8541 #CJK UNIFIED IDEOGRAPH
    {0xB584, 0x796B}, //8542 #CJK UNIFIED IDEOGRAPH
    {0xB585, 0x796C}, //8543 #CJK UNIFIED IDEOGRAPH
    {0xB586, 0x796E}, //8544 #CJK UNIFIED IDEOGRAPH
    {0xB587, 0x7970}, //8545 #CJK UNIFIED IDEOGRAPH
    {0xB588, 0x7971}, //8546 #CJK UNIFIED IDEOGRAPH
    {0xB589, 0x7972}, //8547 #CJK UNIFIED IDEOGRAPH
    {0xB58A, 0x7973}, //8548 #CJK UNIFIED IDEOGRAPH
    {0xB58B, 0x7974}, //8549 #CJK UNIFIED IDEOGRAPH
    {0xB58C, 0x7975}, //8550 #CJK UNIFIED IDEOGRAPH
    {0xB58D, 0x7976}, //8551 #CJK UNIFIED IDEOGRAPH
    {0xB58E, 0x7979}, //8552 #CJK UNIFIED IDEOGRAPH
    {0xB58F, 0x797B}, //8553 #CJK UNIFIED IDEOGRAPH
    {0xB590, 0x797C}, //8554 #CJK UNIFIED IDEOGRAPH
    {0xB591, 0x797D}, //8555 #CJK UNIFIED IDEOGRAPH
    {0xB592, 0x797E}, //8556 #CJK UNIFIED IDEOGRAPH
    {0xB593, 0x797F}, //8557 #CJK UNIFIED IDEOGRAPH
    {0xB594, 0x7982}, //8558 #CJK UNIFIED IDEOGRAPH
    {0xB595, 0x7983}, //8559 #CJK UNIFIED IDEOGRAPH
    {0xB596, 0x7986}, //8560 #CJK UNIFIED IDEOGRAPH
    {0xB597, 0x7987}, //8561 #CJK UNIFIED IDEOGRAPH
    {0xB598, 0x7988}, //8562 #CJK UNIFIED IDEOGRAPH
    {0xB599, 0x7989}, //8563 #CJK UNIFIED IDEOGRAPH
    {0xB59A, 0x798B}, //8564 #CJK UNIFIED IDEOGRAPH
    {0xB59B, 0x798C}, //8565 #CJK UNIFIED IDEOGRAPH
    {0xB59C, 0x798D}, //8566 #CJK UNIFIED IDEOGRAPH
    {0xB59D, 0x798E}, //8567 #CJK UNIFIED IDEOGRAPH
    {0xB59E, 0x7990}, //8568 #CJK UNIFIED IDEOGRAPH
    {0xB59F, 0x7991}, //8569 #CJK UNIFIED IDEOGRAPH
    {0xB5A0, 0x7992}, //8570 #CJK UNIFIED IDEOGRAPH
    {0xB5A1, 0x6020}, //8571 #CJK UNIFIED IDEOGRAPH
    {0xB5A2, 0x803D}, //8572 #CJK UNIFIED IDEOGRAPH
    {0xB5A3, 0x62C5}, //8573 #CJK UNIFIED IDEOGRAPH
    {0xB5A4, 0x4E39}, //8574 #CJK UNIFIED IDEOGRAPH
    {0xB5A5, 0x5355}, //8575 #CJK UNIFIED IDEOGRAPH
    {0xB5A6, 0x90F8}, //8576 #CJK UNIFIED IDEOGRAPH
    {0xB5A7, 0x63B8}, //8577 #CJK UNIFIED IDEOGRAPH
    {0xB5A8, 0x80C6}, //8578 #CJK UNIFIED IDEOGRAPH
    {0xB5A9, 0x65E6}, //8579 #CJK UNIFIED IDEOGRAPH
    {0xB5AA, 0x6C2E}, //8580 #CJK UNIFIED IDEOGRAPH
    {0xB5AB, 0x4F46}, //8581 #CJK UNIFIED IDEOGRAPH
    {0xB5AC, 0x60EE}, //8582 #CJK UNIFIED IDEOGRAPH
    {0xB5AD, 0x6DE1}, //8583 #CJK UNIFIED IDEOGRAPH
    {0xB5AE, 0x8BDE}, //8584 #CJK UNIFIED IDEOGRAPH
    {0xB5AF, 0x5F39}, //8585 #CJK UNIFIED IDEOGRAPH
    {0xB5B0, 0x86CB}, //8586 #CJK UNIFIED IDEOGRAPH
    {0xB5B1, 0x5F53}, //8587 #CJK UNIFIED IDEOGRAPH
    {0xB5B2, 0x6321}, //8588 #CJK UNIFIED IDEOGRAPH
    {0xB5B3, 0x515A}, //8589 #CJK UNIFIED IDEOGRAPH
    {0xB5B4, 0x8361}, //8590 #CJK UNIFIED IDEOGRAPH
    {0xB5B5, 0x6863}, //8591 #CJK UNIFIED IDEOGRAPH
    {0xB5B6, 0x5200}, //8592 #CJK UNIFIED IDEOGRAPH
    {0xB5B7, 0x6363}, //8593 #CJK UNIFIED IDEOGRAPH
    {0xB5B8, 0x8E48}, //8594 #CJK UNIFIED IDEOGRAPH
    {0xB5B9, 0x5012}, //8595 #CJK UNIFIED IDEOGRAPH
    {0xB5BA, 0x5C9B}, //8596 #CJK UNIFIED IDEOGRAPH
    {0xB5BB, 0x7977}, //8597 #CJK UNIFIED IDEOGRAPH
    {0xB5BC, 0x5BFC}, //8598 #CJK UNIFIED IDEOGRAPH
    {0xB5BD, 0x5230}, //8599 #CJK UNIFIED IDEOGRAPH
    {0xB5BE, 0x7A3B}, //8600 #CJK UNIFIED IDEOGRAPH
    {0xB5BF, 0x60BC}, //8601 #CJK UNIFIED IDEOGRAPH
    {0xB5C0, 0x9053}, //8602 #CJK UNIFIED IDEOGRAPH
    {0xB5C1, 0x76D7}, //8603 #CJK UNIFIED IDEOGRAPH
    {0xB5C2, 0x5FB7}, //8604 #CJK UNIFIED IDEOGRAPH
    {0xB5C3, 0x5F97}, //8605 #CJK UNIFIED IDEOGRAPH
    {0xB5C4, 0x7684}, //8606 #CJK UNIFIED IDEOGRAPH
    {0xB5C5, 0x8E6C}, //8607 #CJK UNIFIED IDEOGRAPH
    {0xB5C6, 0x706F}, //8608 #CJK UNIFIED IDEOGRAPH
    {0xB5C7, 0x767B}, //8609 #CJK UNIFIED IDEOGRAPH
    {0xB5C8, 0x7B49}, //8610 #CJK UNIFIED IDEOGRAPH
    {0xB5C9, 0x77AA}, //8611 #CJK UNIFIED IDEOGRAPH
    {0xB5CA, 0x51F3}, //8612 #CJK UNIFIED IDEOGRAPH
    {0xB5CB, 0x9093}, //8613 #CJK UNIFIED IDEOGRAPH
    {0xB5CC, 0x5824}, //8614 #CJK UNIFIED IDEOGRAPH
    {0xB5CD, 0x4F4E}, //8615 #CJK UNIFIED IDEOGRAPH
    {0xB5CE, 0x6EF4}, //8616 #CJK UNIFIED IDEOGRAPH
    {0xB5CF, 0x8FEA}, //8617 #CJK UNIFIED IDEOGRAPH
    {0xB5D0, 0x654C}, //8618 #CJK UNIFIED IDEOGRAPH
    {0xB5D1, 0x7B1B}, //8619 #CJK UNIFIED IDEOGRAPH
    {0xB5D2, 0x72C4}, //8620 #CJK UNIFIED IDEOGRAPH
    {0xB5D3, 0x6DA4}, //8621 #CJK UNIFIED IDEOGRAPH
    {0xB5D4, 0x7FDF}, //8622 #CJK UNIFIED IDEOGRAPH
    {0xB5D5, 0x5AE1}, //8623 #CJK UNIFIED IDEOGRAPH
    {0xB5D6, 0x62B5}, //8624 #CJK UNIFIED IDEOGRAPH
    {0xB5D7, 0x5E95}, //8625 #CJK UNIFIED IDEOGRAPH
    {0xB5D8, 0x5730}, //8626 #CJK UNIFIED IDEOGRAPH
    {0xB5D9, 0x8482}, //8627 #CJK UNIFIED IDEOGRAPH
    {0xB5DA, 0x7B2C}, //8628 #CJK UNIFIED IDEOGRAPH
    {0xB5DB, 0x5E1D}, //8629 #CJK UNIFIED IDEOGRAPH
    {0xB5DC, 0x5F1F}, //8630 #CJK UNIFIED IDEOGRAPH
    {0xB5DD, 0x9012}, //8631 #CJK UNIFIED IDEOGRAPH
    {0xB5DE, 0x7F14}, //8632 #CJK UNIFIED IDEOGRAPH
    {0xB5DF, 0x98A0}, //8633 #CJK UNIFIED IDEOGRAPH
    {0xB5E0, 0x6382}, //8634 #CJK UNIFIED IDEOGRAPH
    {0xB5E1, 0x6EC7}, //8635 #CJK UNIFIED IDEOGRAPH
    {0xB5E2, 0x7898}, //8636 #CJK UNIFIED IDEOGRAPH
    {0xB5E3, 0x70B9}, //8637 #CJK UNIFIED IDEOGRAPH
    {0xB5E4, 0x5178}, //8638 #CJK UNIFIED IDEOGRAPH
    {0xB5E5, 0x975B}, //8639 #CJK UNIFIED IDEOGRAPH
    {0xB5E6, 0x57AB}, //8640 #CJK UNIFIED IDEOGRAPH
    {0xB5E7, 0x7535}, //8641 #CJK UNIFIED IDEOGRAPH
    {0xB5E8, 0x4F43}, //8642 #CJK UNIFIED IDEOGRAPH
    {0xB5E9, 0x7538}, //8643 #CJK UNIFIED IDEOGRAPH
    {0xB5EA, 0x5E97}, //8644 #CJK UNIFIED IDEOGRAPH
    {0xB5EB, 0x60E6}, //8645 #CJK UNIFIED IDEOGRAPH
    {0xB5EC, 0x5960}, //8646 #CJK UNIFIED IDEOGRAPH
    {0xB5ED, 0x6DC0}, //8647 #CJK UNIFIED IDEOGRAPH
    {0xB5EE, 0x6BBF}, //8648 #CJK UNIFIED IDEOGRAPH
    {0xB5EF, 0x7889}, //8649 #CJK UNIFIED IDEOGRAPH
    {0xB5F0, 0x53FC}, //8650 #CJK UNIFIED IDEOGRAPH
    {0xB5F1, 0x96D5}, //8651 #CJK UNIFIED IDEOGRAPH
    {0xB5F2, 0x51CB}, //8652 #CJK UNIFIED IDEOGRAPH
    {0xB5F3, 0x5201}, //8653 #CJK UNIFIED IDEOGRAPH
    {0xB5F4, 0x6389}, //8654 #CJK UNIFIED IDEOGRAPH
    {0xB5F5, 0x540A}, //8655 #CJK UNIFIED IDEOGRAPH
    {0xB5F6, 0x9493}, //8656 #CJK UNIFIED IDEOGRAPH
    {0xB5F7, 0x8C03}, //8657 #CJK UNIFIED IDEOGRAPH
    {0xB5F8, 0x8DCC}, //8658 #CJK UNIFIED IDEOGRAPH
    {0xB5F9, 0x7239}, //8659 #CJK UNIFIED IDEOGRAPH
    {0xB5FA, 0x789F}, //8660 #CJK UNIFIED IDEOGRAPH
    {0xB5FB, 0x8776}, //8661 #CJK UNIFIED IDEOGRAPH
    {0xB5FC, 0x8FED}, //8662 #CJK UNIFIED IDEOGRAPH
    {0xB5FD, 0x8C0D}, //8663 #CJK UNIFIED IDEOGRAPH
    {0xB5FE, 0x53E0}, //8664 #CJK UNIFIED IDEOGRAPH
    {0xB640, 0x7993}, //8665 #CJK UNIFIED IDEOGRAPH
    {0xB641, 0x7994}, //8666 #CJK UNIFIED IDEOGRAPH
    {0xB642, 0x7995}, //8667 #CJK UNIFIED IDEOGRAPH
    {0xB643, 0x7996}, //8668 #CJK UNIFIED IDEOGRAPH
    {0xB644, 0x7997}, //8669 #CJK UNIFIED IDEOGRAPH
    {0xB645, 0x7998}, //8670 #CJK UNIFIED IDEOGRAPH
    {0xB646, 0x7999}, //8671 #CJK UNIFIED IDEOGRAPH
    {0xB647, 0x799B}, //8672 #CJK UNIFIED IDEOGRAPH
    {0xB648, 0x799C}, //8673 #CJK UNIFIED IDEOGRAPH
    {0xB649, 0x799D}, //8674 #CJK UNIFIED IDEOGRAPH
    {0xB64A, 0x799E}, //8675 #CJK UNIFIED IDEOGRAPH
    {0xB64B, 0x799F}, //8676 #CJK UNIFIED IDEOGRAPH
    {0xB64C, 0x79A0}, //8677 #CJK UNIFIED IDEOGRAPH
    {0xB64D, 0x79A1}, //8678 #CJK UNIFIED IDEOGRAPH
    {0xB64E, 0x79A2}, //8679 #CJK UNIFIED IDEOGRAPH
    {0xB64F, 0x79A3}, //8680 #CJK UNIFIED IDEOGRAPH
    {0xB650, 0x79A4}, //8681 #CJK UNIFIED IDEOGRAPH
    {0xB651, 0x79A5}, //8682 #CJK UNIFIED IDEOGRAPH
    {0xB652, 0x79A6}, //8683 #CJK UNIFIED IDEOGRAPH
    {0xB653, 0x79A8}, //8684 #CJK UNIFIED IDEOGRAPH
    {0xB654, 0x79A9}, //8685 #CJK UNIFIED IDEOGRAPH
    {0xB655, 0x79AA}, //8686 #CJK UNIFIED IDEOGRAPH
    {0xB656, 0x79AB}, //8687 #CJK UNIFIED IDEOGRAPH
    {0xB657, 0x79AC}, //8688 #CJK UNIFIED IDEOGRAPH
    {0xB658, 0x79AD}, //8689 #CJK UNIFIED IDEOGRAPH
    {0xB659, 0x79AE}, //8690 #CJK UNIFIED IDEOGRAPH
    {0xB65A, 0x79AF}, //8691 #CJK UNIFIED IDEOGRAPH
    {0xB65B, 0x79B0}, //8692 #CJK UNIFIED IDEOGRAPH
    {0xB65C, 0x79B1}, //8693 #CJK UNIFIED IDEOGRAPH
    {0xB65D, 0x79B2}, //8694 #CJK UNIFIED IDEOGRAPH
    {0xB65E, 0x79B4}, //8695 #CJK UNIFIED IDEOGRAPH
    {0xB65F, 0x79B5}, //8696 #CJK UNIFIED IDEOGRAPH
    {0xB660, 0x79B6}, //8697 #CJK UNIFIED IDEOGRAPH
    {0xB661, 0x79B7}, //8698 #CJK UNIFIED IDEOGRAPH
    {0xB662, 0x79B8}, //8699 #CJK UNIFIED IDEOGRAPH
    {0xB663, 0x79BC}, //8700 #CJK UNIFIED IDEOGRAPH
    {0xB664, 0x79BF}, //8701 #CJK UNIFIED IDEOGRAPH
    {0xB665, 0x79C2}, //8702 #CJK UNIFIED IDEOGRAPH
    {0xB666, 0x79C4}, //8703 #CJK UNIFIED IDEOGRAPH
    {0xB667, 0x79C5}, //8704 #CJK UNIFIED IDEOGRAPH
    {0xB668, 0x79C7}, //8705 #CJK UNIFIED IDEOGRAPH
    {0xB669, 0x79C8}, //8706 #CJK UNIFIED IDEOGRAPH
    {0xB66A, 0x79CA}, //8707 #CJK UNIFIED IDEOGRAPH
    {0xB66B, 0x79CC}, //8708 #CJK UNIFIED IDEOGRAPH
    {0xB66C, 0x79CE}, //8709 #CJK UNIFIED IDEOGRAPH
    {0xB66D, 0x79CF}, //8710 #CJK UNIFIED IDEOGRAPH
    {0xB66E, 0x79D0}, //8711 #CJK UNIFIED IDEOGRAPH
    {0xB66F, 0x79D3}, //8712 #CJK UNIFIED IDEOGRAPH
    {0xB670, 0x79D4}, //8713 #CJK UNIFIED IDEOGRAPH
    {0xB671, 0x79D6}, //8714 #CJK UNIFIED IDEOGRAPH
    {0xB672, 0x79D7}, //8715 #CJK UNIFIED IDEOGRAPH
    {0xB673, 0x79D9}, //8716 #CJK UNIFIED IDEOGRAPH
    {0xB674, 0x79DA}, //8717 #CJK UNIFIED IDEOGRAPH
    {0xB675, 0x79DB}, //8718 #CJK UNIFIED IDEOGRAPH
    {0xB676, 0x79DC}, //8719 #CJK UNIFIED IDEOGRAPH
    {0xB677, 0x79DD}, //8720 #CJK UNIFIED IDEOGRAPH
    {0xB678, 0x79DE}, //8721 #CJK UNIFIED IDEOGRAPH
    {0xB679, 0x79E0}, //8722 #CJK UNIFIED IDEOGRAPH
    {0xB67A, 0x79E1}, //8723 #CJK UNIFIED IDEOGRAPH
    {0xB67B, 0x79E2}, //8724 #CJK UNIFIED IDEOGRAPH
    {0xB67C, 0x79E5}, //8725 #CJK UNIFIED IDEOGRAPH
    {0xB67D, 0x79E8}, //8726 #CJK UNIFIED IDEOGRAPH
    {0xB67E, 0x79EA}, //8727 #CJK UNIFIED IDEOGRAPH
    {0xB680, 0x79EC}, //8728 #CJK UNIFIED IDEOGRAPH
    {0xB681, 0x79EE}, //8729 #CJK UNIFIED IDEOGRAPH
    {0xB682, 0x79F1}, //8730 #CJK UNIFIED IDEOGRAPH
    {0xB683, 0x79F2}, //8731 #CJK UNIFIED IDEOGRAPH
    {0xB684, 0x79F3}, //8732 #CJK UNIFIED IDEOGRAPH
    {0xB685, 0x79F4}, //8733 #CJK UNIFIED IDEOGRAPH
    {0xB686, 0x79F5}, //8734 #CJK UNIFIED IDEOGRAPH
    {0xB687, 0x79F6}, //8735 #CJK UNIFIED IDEOGRAPH
    {0xB688, 0x79F7}, //8736 #CJK UNIFIED IDEOGRAPH
    {0xB689, 0x79F9}, //8737 #CJK UNIFIED IDEOGRAPH
    {0xB68A, 0x79FA}, //8738 #CJK UNIFIED IDEOGRAPH
    {0xB68B, 0x79FC}, //8739 #CJK UNIFIED IDEOGRAPH
    {0xB68C, 0x79FE}, //8740 #CJK UNIFIED IDEOGRAPH
    {0xB68D, 0x79FF}, //8741 #CJK UNIFIED IDEOGRAPH
    {0xB68E, 0x7A01}, //8742 #CJK UNIFIED IDEOGRAPH
    {0xB68F, 0x7A04}, //8743 #CJK UNIFIED IDEOGRAPH
    {0xB690, 0x7A05}, //8744 #CJK UNIFIED IDEOGRAPH
    {0xB691, 0x7A07}, //8745 #CJK UNIFIED IDEOGRAPH
    {0xB692, 0x7A08}, //8746 #CJK UNIFIED IDEOGRAPH
    {0xB693, 0x7A09}, //8747 #CJK UNIFIED IDEOGRAPH
    {0xB694, 0x7A0A}, //8748 #CJK UNIFIED IDEOGRAPH
    {0xB695, 0x7A0C}, //8749 #CJK UNIFIED IDEOGRAPH
    {0xB696, 0x7A0F}, //8750 #CJK UNIFIED IDEOGRAPH
    {0xB697, 0x7A10}, //8751 #CJK UNIFIED IDEOGRAPH
    {0xB698, 0x7A11}, //8752 #CJK UNIFIED IDEOGRAPH
    {0xB699, 0x7A12}, //8753 #CJK UNIFIED IDEOGRAPH
    {0xB69A, 0x7A13}, //8754 #CJK UNIFIED IDEOGRAPH
    {0xB69B, 0x7A15}, //8755 #CJK UNIFIED IDEOGRAPH
    {0xB69C, 0x7A16}, //8756 #CJK UNIFIED IDEOGRAPH
    {0xB69D, 0x7A18}, //8757 #CJK UNIFIED IDEOGRAPH
    {0xB69E, 0x7A19}, //8758 #CJK UNIFIED IDEOGRAPH
    {0xB69F, 0x7A1B}, //8759 #CJK UNIFIED IDEOGRAPH
    {0xB6A0, 0x7A1C}, //8760 #CJK UNIFIED IDEOGRAPH
    {0xB6A1, 0x4E01}, //8761 #CJK UNIFIED IDEOGRAPH
    {0xB6A2, 0x76EF}, //8762 #CJK UNIFIED IDEOGRAPH
    {0xB6A3, 0x53EE}, //8763 #CJK UNIFIED IDEOGRAPH
    {0xB6A4, 0x9489}, //8764 #CJK UNIFIED IDEOGRAPH
    {0xB6A5, 0x9876}, //8765 #CJK UNIFIED IDEOGRAPH
    {0xB6A6, 0x9F0E}, //8766 #CJK UNIFIED IDEOGRAPH
    {0xB6A7, 0x952D}, //8767 #CJK UNIFIED IDEOGRAPH
    {0xB6A8, 0x5B9A}, //8768 #CJK UNIFIED IDEOGRAPH
    {0xB6A9, 0x8BA2}, //8769 #CJK UNIFIED IDEOGRAPH
    {0xB6AA, 0x4E22}, //8770 #CJK UNIFIED IDEOGRAPH
    {0xB6AB, 0x4E1C}, //8771 #CJK UNIFIED IDEOGRAPH
    {0xB6AC, 0x51AC}, //8772 #CJK UNIFIED IDEOGRAPH
    {0xB6AD, 0x8463}, //8773 #CJK UNIFIED IDEOGRAPH
    {0xB6AE, 0x61C2}, //8774 #CJK UNIFIED IDEOGRAPH
    {0xB6AF, 0x52A8}, //8775 #CJK UNIFIED IDEOGRAPH
    {0xB6B0, 0x680B}, //8776 #CJK UNIFIED IDEOGRAPH
    {0xB6B1, 0x4F97}, //8777 #CJK UNIFIED IDEOGRAPH
    {0xB6B2, 0x606B}, //8778 #CJK UNIFIED IDEOGRAPH
    {0xB6B3, 0x51BB}, //8779 #CJK UNIFIED IDEOGRAPH
    {0xB6B4, 0x6D1E}, //8780 #CJK UNIFIED IDEOGRAPH
    {0xB6B5, 0x515C}, //8781 #CJK UNIFIED IDEOGRAPH
    {0xB6B6, 0x6296}, //8782 #CJK UNIFIED IDEOGRAPH
    {0xB6B7, 0x6597}, //8783 #CJK UNIFIED IDEOGRAPH
    {0xB6B8, 0x9661}, //8784 #CJK UNIFIED IDEOGRAPH
    {0xB6B9, 0x8C46}, //8785 #CJK UNIFIED IDEOGRAPH
    {0xB6BA, 0x9017}, //8786 #CJK UNIFIED IDEOGRAPH
    {0xB6BB, 0x75D8}, //8787 #CJK UNIFIED IDEOGRAPH
    {0xB6BC, 0x90FD}, //8788 #CJK UNIFIED IDEOGRAPH
    {0xB6BD, 0x7763}, //8789 #CJK UNIFIED IDEOGRAPH
    {0xB6BE, 0x6BD2}, //8790 #CJK UNIFIED IDEOGRAPH
    {0xB6BF, 0x728A}, //8791 #CJK UNIFIED IDEOGRAPH
    {0xB6C0, 0x72EC}, //8792 #CJK UNIFIED IDEOGRAPH
    {0xB6C1, 0x8BFB}, //8793 #CJK UNIFIED IDEOGRAPH
    {0xB6C2, 0x5835}, //8794 #CJK UNIFIED IDEOGRAPH
    {0xB6C3, 0x7779}, //8795 #CJK UNIFIED IDEOGRAPH
    {0xB6C4, 0x8D4C}, //8796 #CJK UNIFIED IDEOGRAPH
    {0xB6C5, 0x675C}, //8797 #CJK UNIFIED IDEOGRAPH
    {0xB6C6, 0x9540}, //8798 #CJK UNIFIED IDEOGRAPH
    {0xB6C7, 0x809A}, //8799 #CJK UNIFIED IDEOGRAPH
    {0xB6C8, 0x5EA6}, //8800 #CJK UNIFIED IDEOGRAPH
    {0xB6C9, 0x6E21}, //8801 #CJK UNIFIED IDEOGRAPH
    {0xB6CA, 0x5992}, //8802 #CJK UNIFIED IDEOGRAPH
    {0xB6CB, 0x7AEF}, //8803 #CJK UNIFIED IDEOGRAPH
    {0xB6CC, 0x77ED}, //8804 #CJK UNIFIED IDEOGRAPH
    {0xB6CD, 0x953B}, //8805 #CJK UNIFIED IDEOGRAPH
    {0xB6CE, 0x6BB5}, //8806 #CJK UNIFIED IDEOGRAPH
    {0xB6CF, 0x65AD}, //8807 #CJK UNIFIED IDEOGRAPH
    {0xB6D0, 0x7F0E}, //8808 #CJK UNIFIED IDEOGRAPH
    {0xB6D1, 0x5806}, //8809 #CJK UNIFIED IDEOGRAPH
    {0xB6D2, 0x5151}, //8810 #CJK UNIFIED IDEOGRAPH
    {0xB6D3, 0x961F}, //8811 #CJK UNIFIED IDEOGRAPH
    {0xB6D4, 0x5BF9}, //8812 #CJK UNIFIED IDEOGRAPH
    {0xB6D5, 0x58A9}, //8813 #CJK UNIFIED IDEOGRAPH
    {0xB6D6, 0x5428}, //8814 #CJK UNIFIED IDEOGRAPH
    {0xB6D7, 0x8E72}, //8815 #CJK UNIFIED IDEOGRAPH
    {0xB6D8, 0x6566}, //8816 #CJK UNIFIED IDEOGRAPH
    {0xB6D9, 0x987F}, //8817 #CJK UNIFIED IDEOGRAPH
    {0xB6DA, 0x56E4}, //8818 #CJK UNIFIED IDEOGRAPH
    {0xB6DB, 0x949D}, //8819 #CJK UNIFIED IDEOGRAPH
    {0xB6DC, 0x76FE}, //8820 #CJK UNIFIED IDEOGRAPH
    {0xB6DD, 0x9041}, //8821 #CJK UNIFIED IDEOGRAPH
    {0xB6DE, 0x6387}, //8822 #CJK UNIFIED IDEOGRAPH
    {0xB6DF, 0x54C6}, //8823 #CJK UNIFIED IDEOGRAPH
    {0xB6E0, 0x591A}, //8824 #CJK UNIFIED IDEOGRAPH
    {0xB6E1, 0x593A}, //8825 #CJK UNIFIED IDEOGRAPH
    {0xB6E2, 0x579B}, //8826 #CJK UNIFIED IDEOGRAPH
    {0xB6E3, 0x8EB2}, //8827 #CJK UNIFIED IDEOGRAPH
    {0xB6E4, 0x6735}, //8828 #CJK UNIFIED IDEOGRAPH
    {0xB6E5, 0x8DFA}, //8829 #CJK UNIFIED IDEOGRAPH
    {0xB6E6, 0x8235}, //8830 #CJK UNIFIED IDEOGRAPH
    {0xB6E7, 0x5241}, //8831 #CJK UNIFIED IDEOGRAPH
    {0xB6E8, 0x60F0}, //8832 #CJK UNIFIED IDEOGRAPH
    {0xB6E9, 0x5815}, //8833 #CJK UNIFIED IDEOGRAPH
    {0xB6EA, 0x86FE}, //8834 #CJK UNIFIED IDEOGRAPH
    {0xB6EB, 0x5CE8}, //8835 #CJK UNIFIED IDEOGRAPH
    {0xB6EC, 0x9E45}, //8836 #CJK UNIFIED IDEOGRAPH
    {0xB6ED, 0x4FC4}, //8837 #CJK UNIFIED IDEOGRAPH
    {0xB6EE, 0x989D}, //8838 #CJK UNIFIED IDEOGRAPH
    {0xB6EF, 0x8BB9}, //8839 #CJK UNIFIED IDEOGRAPH
    {0xB6F0, 0x5A25}, //8840 #CJK UNIFIED IDEOGRAPH
    {0xB6F1, 0x6076}, //8841 #CJK UNIFIED IDEOGRAPH
    {0xB6F2, 0x5384}, //8842 #CJK UNIFIED IDEOGRAPH
    {0xB6F3, 0x627C}, //8843 #CJK UNIFIED IDEOGRAPH
    {0xB6F4, 0x904F}, //8844 #CJK UNIFIED IDEOGRAPH
    {0xB6F5, 0x9102}, //8845 #CJK UNIFIED IDEOGRAPH
    {0xB6F6, 0x997F}, //8846 #CJK UNIFIED IDEOGRAPH
    {0xB6F7, 0x6069}, //8847 #CJK UNIFIED IDEOGRAPH
    {0xB6F8, 0x800C}, //8848 #CJK UNIFIED IDEOGRAPH
    {0xB6F9, 0x513F}, //8849 #CJK UNIFIED IDEOGRAPH
    {0xB6FA, 0x8033}, //8850 #CJK UNIFIED IDEOGRAPH
    {0xB6FB, 0x5C14}, //8851 #CJK UNIFIED IDEOGRAPH
    {0xB6FC, 0x9975}, //8852 #CJK UNIFIED IDEOGRAPH
    {0xB6FD, 0x6D31}, //8853 #CJK UNIFIED IDEOGRAPH
    {0xB6FE, 0x4E8C}, //8854 #CJK UNIFIED IDEOGRAPH
    {0xB740, 0x7A1D}, //8855 #CJK UNIFIED IDEOGRAPH
    {0xB741, 0x7A1F}, //8856 #CJK UNIFIED IDEOGRAPH
    {0xB742, 0x7A21}, //8857 #CJK UNIFIED IDEOGRAPH
    {0xB743, 0x7A22}, //8858 #CJK UNIFIED IDEOGRAPH
    {0xB744, 0x7A24}, //8859 #CJK UNIFIED IDEOGRAPH
    {0xB745, 0x7A25}, //8860 #CJK UNIFIED IDEOGRAPH
    {0xB746, 0x7A26}, //8861 #CJK UNIFIED IDEOGRAPH
    {0xB747, 0x7A27}, //8862 #CJK UNIFIED IDEOGRAPH
    {0xB748, 0x7A28}, //8863 #CJK UNIFIED IDEOGRAPH
    {0xB749, 0x7A29}, //8864 #CJK UNIFIED IDEOGRAPH
    {0xB74A, 0x7A2A}, //8865 #CJK UNIFIED IDEOGRAPH
    {0xB74B, 0x7A2B}, //8866 #CJK UNIFIED IDEOGRAPH
    {0xB74C, 0x7A2C}, //8867 #CJK UNIFIED IDEOGRAPH
    {0xB74D, 0x7A2D}, //8868 #CJK UNIFIED IDEOGRAPH
    {0xB74E, 0x7A2E}, //8869 #CJK UNIFIED IDEOGRAPH
    {0xB74F, 0x7A2F}, //8870 #CJK UNIFIED IDEOGRAPH
    {0xB750, 0x7A30}, //8871 #CJK UNIFIED IDEOGRAPH
    {0xB751, 0x7A31}, //8872 #CJK UNIFIED IDEOGRAPH
    {0xB752, 0x7A32}, //8873 #CJK UNIFIED IDEOGRAPH
    {0xB753, 0x7A34}, //8874 #CJK UNIFIED IDEOGRAPH
    {0xB754, 0x7A35}, //8875 #CJK UNIFIED IDEOGRAPH
    {0xB755, 0x7A36}, //8876 #CJK UNIFIED IDEOGRAPH
    {0xB756, 0x7A38}, //8877 #CJK UNIFIED IDEOGRAPH
    {0xB757, 0x7A3A}, //8878 #CJK UNIFIED IDEOGRAPH
    {0xB758, 0x7A3E}, //8879 #CJK UNIFIED IDEOGRAPH
    {0xB759, 0x7A40}, //8880 #CJK UNIFIED IDEOGRAPH
    {0xB75A, 0x7A41}, //8881 #CJK UNIFIED IDEOGRAPH
    {0xB75B, 0x7A42}, //8882 #CJK UNIFIED IDEOGRAPH
    {0xB75C, 0x7A43}, //8883 #CJK UNIFIED IDEOGRAPH
    {0xB75D, 0x7A44}, //8884 #CJK UNIFIED IDEOGRAPH
    {0xB75E, 0x7A45}, //8885 #CJK UNIFIED IDEOGRAPH
    {0xB75F, 0x7A47}, //8886 #CJK UNIFIED IDEOGRAPH
    {0xB760, 0x7A48}, //8887 #CJK UNIFIED IDEOGRAPH
    {0xB761, 0x7A49}, //8888 #CJK UNIFIED IDEOGRAPH
    {0xB762, 0x7A4A}, //8889 #CJK UNIFIED IDEOGRAPH
    {0xB763, 0x7A4B}, //8890 #CJK UNIFIED IDEOGRAPH
    {0xB764, 0x7A4C}, //8891 #CJK UNIFIED IDEOGRAPH
    {0xB765, 0x7A4D}, //8892 #CJK UNIFIED IDEOGRAPH
    {0xB766, 0x7A4E}, //8893 #CJK UNIFIED IDEOGRAPH
    {0xB767, 0x7A4F}, //8894 #CJK UNIFIED IDEOGRAPH
    {0xB768, 0x7A50}, //8895 #CJK UNIFIED IDEOGRAPH
    {0xB769, 0x7A52}, //8896 #CJK UNIFIED IDEOGRAPH
    {0xB76A, 0x7A53}, //8897 #CJK UNIFIED IDEOGRAPH
    {0xB76B, 0x7A54}, //8898 #CJK UNIFIED IDEOGRAPH
    {0xB76C, 0x7A55}, //8899 #CJK UNIFIED IDEOGRAPH
    {0xB76D, 0x7A56}, //8900 #CJK UNIFIED IDEOGRAPH
    {0xB76E, 0x7A58}, //8901 #CJK UNIFIED IDEOGRAPH
    {0xB76F, 0x7A59}, //8902 #CJK UNIFIED IDEOGRAPH
    {0xB770, 0x7A5A}, //8903 #CJK UNIFIED IDEOGRAPH
    {0xB771, 0x7A5B}, //8904 #CJK UNIFIED IDEOGRAPH
    {0xB772, 0x7A5C}, //8905 #CJK UNIFIED IDEOGRAPH
    {0xB773, 0x7A5D}, //8906 #CJK UNIFIED IDEOGRAPH
    {0xB774, 0x7A5E}, //8907 #CJK UNIFIED IDEOGRAPH
    {0xB775, 0x7A5F}, //8908 #CJK UNIFIED IDEOGRAPH
    {0xB776, 0x7A60}, //8909 #CJK UNIFIED IDEOGRAPH
    {0xB777, 0x7A61}, //8910 #CJK UNIFIED IDEOGRAPH
    {0xB778, 0x7A62}, //8911 #CJK UNIFIED IDEOGRAPH
    {0xB779, 0x7A63}, //8912 #CJK UNIFIED IDEOGRAPH
    {0xB77A, 0x7A64}, //8913 #CJK UNIFIED IDEOGRAPH
    {0xB77B, 0x7A65}, //8914 #CJK UNIFIED IDEOGRAPH
    {0xB77C, 0x7A66}, //8915 #CJK UNIFIED IDEOGRAPH
    {0xB77D, 0x7A67}, //8916 #CJK UNIFIED IDEOGRAPH
    {0xB77E, 0x7A68}, //8917 #CJK UNIFIED IDEOGRAPH
    {0xB780, 0x7A69}, //8918 #CJK UNIFIED IDEOGRAPH
    {0xB781, 0x7A6A}, //8919 #CJK UNIFIED IDEOGRAPH
    {0xB782, 0x7A6B}, //8920 #CJK UNIFIED IDEOGRAPH
    {0xB783, 0x7A6C}, //8921 #CJK UNIFIED IDEOGRAPH
    {0xB784, 0x7A6D}, //8922 #CJK UNIFIED IDEOGRAPH
    {0xB785, 0x7A6E}, //8923 #CJK UNIFIED IDEOGRAPH
    {0xB786, 0x7A6F}, //8924 #CJK UNIFIED IDEOGRAPH
    {0xB787, 0x7A71}, //8925 #CJK UNIFIED IDEOGRAPH
    {0xB788, 0x7A72}, //8926 #CJK UNIFIED IDEOGRAPH
    {0xB789, 0x7A73}, //8927 #CJK UNIFIED IDEOGRAPH
    {0xB78A, 0x7A75}, //8928 #CJK UNIFIED IDEOGRAPH
    {0xB78B, 0x7A7B}, //8929 #CJK UNIFIED IDEOGRAPH
    {0xB78C, 0x7A7C}, //8930 #CJK UNIFIED IDEOGRAPH
    {0xB78D, 0x7A7D}, //8931 #CJK UNIFIED IDEOGRAPH
    {0xB78E, 0x7A7E}, //8932 #CJK UNIFIED IDEOGRAPH
    {0xB78F, 0x7A82}, //8933 #CJK UNIFIED IDEOGRAPH
    {0xB790, 0x7A85}, //8934 #CJK UNIFIED IDEOGRAPH
    {0xB791, 0x7A87}, //8935 #CJK UNIFIED IDEOGRAPH
    {0xB792, 0x7A89}, //8936 #CJK UNIFIED IDEOGRAPH
    {0xB793, 0x7A8A}, //8937 #CJK UNIFIED IDEOGRAPH
    {0xB794, 0x7A8B}, //8938 #CJK UNIFIED IDEOGRAPH
    {0xB795, 0x7A8C}, //8939 #CJK UNIFIED IDEOGRAPH
    {0xB796, 0x7A8E}, //8940 #CJK UNIFIED IDEOGRAPH
    {0xB797, 0x7A8F}, //8941 #CJK UNIFIED IDEOGRAPH
    {0xB798, 0x7A90}, //8942 #CJK UNIFIED IDEOGRAPH
    {0xB799, 0x7A93}, //8943 #CJK UNIFIED IDEOGRAPH
    {0xB79A, 0x7A94}, //8944 #CJK UNIFIED IDEOGRAPH
    {0xB79B, 0x7A99}, //8945 #CJK UNIFIED IDEOGRAPH
    {0xB79C, 0x7A9A}, //8946 #CJK UNIFIED IDEOGRAPH
    {0xB79D, 0x7A9B}, //8947 #CJK UNIFIED IDEOGRAPH
    {0xB79E, 0x7A9E}, //8948 #CJK UNIFIED IDEOGRAPH
    {0xB79F, 0x7AA1}, //8949 #CJK UNIFIED IDEOGRAPH
    {0xB7A0, 0x7AA2}, //8950 #CJK UNIFIED IDEOGRAPH
    {0xB7A1, 0x8D30}, //8951 #CJK UNIFIED IDEOGRAPH
    {0xB7A2, 0x53D1}, //8952 #CJK UNIFIED IDEOGRAPH
    {0xB7A3, 0x7F5A}, //8953 #CJK UNIFIED IDEOGRAPH
    {0xB7A4, 0x7B4F}, //8954 #CJK UNIFIED IDEOGRAPH
    {0xB7A5, 0x4F10}, //8955 #CJK UNIFIED IDEOGRAPH
    {0xB7A6, 0x4E4F}, //8956 #CJK UNIFIED IDEOGRAPH
    {0xB7A7, 0x9600}, //8957 #CJK UNIFIED IDEOGRAPH
    {0xB7A8, 0x6CD5}, //8958 #CJK UNIFIED IDEOGRAPH
    {0xB7A9, 0x73D0}, //8959 #CJK UNIFIED IDEOGRAPH
    {0xB7AA, 0x85E9}, //8960 #CJK UNIFIED IDEOGRAPH
    {0xB7AB, 0x5E06}, //8961 #CJK UNIFIED IDEOGRAPH
    {0xB7AC, 0x756A}, //8962 #CJK UNIFIED IDEOGRAPH
    {0xB7AD, 0x7FFB}, //8963 #CJK UNIFIED IDEOGRAPH
    {0xB7AE, 0x6A0A}, //8964 #CJK UNIFIED IDEOGRAPH
    {0xB7AF, 0x77FE}, //8965 #CJK UNIFIED IDEOGRAPH
    {0xB7B0, 0x9492}, //8966 #CJK UNIFIED IDEOGRAPH
    {0xB7B1, 0x7E41}, //8967 #CJK UNIFIED IDEOGRAPH
    {0xB7B2, 0x51E1}, //8968 #CJK UNIFIED IDEOGRAPH
    {0xB7B3, 0x70E6}, //8969 #CJK UNIFIED IDEOGRAPH
    {0xB7B4, 0x53CD}, //8970 #CJK UNIFIED IDEOGRAPH
    {0xB7B5, 0x8FD4}, //8971 #CJK UNIFIED IDEOGRAPH
    {0xB7B6, 0x8303}, //8972 #CJK UNIFIED IDEOGRAPH
    {0xB7B7, 0x8D29}, //8973 #CJK UNIFIED IDEOGRAPH
    {0xB7B8, 0x72AF}, //8974 #CJK UNIFIED IDEOGRAPH
    {0xB7B9, 0x996D}, //8975 #CJK UNIFIED IDEOGRAPH
    {0xB7BA, 0x6CDB}, //8976 #CJK UNIFIED IDEOGRAPH
    {0xB7BB, 0x574A}, //8977 #CJK UNIFIED IDEOGRAPH
    {0xB7BC, 0x82B3}, //8978 #CJK UNIFIED IDEOGRAPH
    {0xB7BD, 0x65B9}, //8979 #CJK UNIFIED IDEOGRAPH
    {0xB7BE, 0x80AA}, //8980 #CJK UNIFIED IDEOGRAPH
    {0xB7BF, 0x623F}, //8981 #CJK UNIFIED IDEOGRAPH
    {0xB7C0, 0x9632}, //8982 #CJK UNIFIED IDEOGRAPH
    {0xB7C1, 0x59A8}, //8983 #CJK UNIFIED IDEOGRAPH
    {0xB7C2, 0x4EFF}, //8984 #CJK UNIFIED IDEOGRAPH
    {0xB7C3, 0x8BBF}, //8985 #CJK UNIFIED IDEOGRAPH
    {0xB7C4, 0x7EBA}, //8986 #CJK UNIFIED IDEOGRAPH
    {0xB7C5, 0x653E}, //8987 #CJK UNIFIED IDEOGRAPH
    {0xB7C6, 0x83F2}, //8988 #CJK UNIFIED IDEOGRAPH
    {0xB7C7, 0x975E}, //8989 #CJK UNIFIED IDEOGRAPH
    {0xB7C8, 0x5561}, //8990 #CJK UNIFIED IDEOGRAPH
    {0xB7C9, 0x98DE}, //8991 #CJK UNIFIED IDEOGRAPH
    {0xB7CA, 0x80A5}, //8992 #CJK UNIFIED IDEOGRAPH
    {0xB7CB, 0x532A}, //8993 #CJK UNIFIED IDEOGRAPH
    {0xB7CC, 0x8BFD}, //8994 #CJK UNIFIED IDEOGRAPH
    {0xB7CD, 0x5420}, //8995 #CJK UNIFIED IDEOGRAPH
    {0xB7CE, 0x80BA}, //8996 #CJK UNIFIED IDEOGRAPH
    {0xB7CF, 0x5E9F}, //8997 #CJK UNIFIED IDEOGRAPH
    {0xB7D0, 0x6CB8}, //8998 #CJK UNIFIED IDEOGRAPH
    {0xB7D1, 0x8D39}, //8999 #CJK UNIFIED IDEOGRAPH
    {0xB7D2, 0x82AC}, //9000 #CJK UNIFIED IDEOGRAPH
    {0xB7D3, 0x915A}, //9001 #CJK UNIFIED IDEOGRAPH
    {0xB7D4, 0x5429}, //9002 #CJK UNIFIED IDEOGRAPH
    {0xB7D5, 0x6C1B}, //9003 #CJK UNIFIED IDEOGRAPH
    {0xB7D6, 0x5206}, //9004 #CJK UNIFIED IDEOGRAPH
    {0xB7D7, 0x7EB7}, //9005 #CJK UNIFIED IDEOGRAPH
    {0xB7D8, 0x575F}, //9006 #CJK UNIFIED IDEOGRAPH
    {0xB7D9, 0x711A}, //9007 #CJK UNIFIED IDEOGRAPH
    {0xB7DA, 0x6C7E}, //9008 #CJK UNIFIED IDEOGRAPH
    {0xB7DB, 0x7C89}, //9009 #CJK UNIFIED IDEOGRAPH
    {0xB7DC, 0x594B}, //9010 #CJK UNIFIED IDEOGRAPH
    {0xB7DD, 0x4EFD}, //9011 #CJK UNIFIED IDEOGRAPH
    {0xB7DE, 0x5FFF}, //9012 #CJK UNIFIED IDEOGRAPH
    {0xB7DF, 0x6124}, //9013 #CJK UNIFIED IDEOGRAPH
    {0xB7E0, 0x7CAA}, //9014 #CJK UNIFIED IDEOGRAPH
    {0xB7E1, 0x4E30}, //9015 #CJK UNIFIED IDEOGRAPH
    {0xB7E2, 0x5C01}, //9016 #CJK UNIFIED IDEOGRAPH
    {0xB7E3, 0x67AB}, //9017 #CJK UNIFIED IDEOGRAPH
    {0xB7E4, 0x8702}, //9018 #CJK UNIFIED IDEOGRAPH
    {0xB7E5, 0x5CF0}, //9019 #CJK UNIFIED IDEOGRAPH
    {0xB7E6, 0x950B}, //9020 #CJK UNIFIED IDEOGRAPH
    {0xB7E7, 0x98CE}, //9021 #CJK UNIFIED IDEOGRAPH
    {0xB7E8, 0x75AF}, //9022 #CJK UNIFIED IDEOGRAPH
    {0xB7E9, 0x70FD}, //9023 #CJK UNIFIED IDEOGRAPH
    {0xB7EA, 0x9022}, //9024 #CJK UNIFIED IDEOGRAPH
    {0xB7EB, 0x51AF}, //9025 #CJK UNIFIED IDEOGRAPH
    {0xB7EC, 0x7F1D}, //9026 #CJK UNIFIED IDEOGRAPH
    {0xB7ED, 0x8BBD}, //9027 #CJK UNIFIED IDEOGRAPH
    {0xB7EE, 0x5949}, //9028 #CJK UNIFIED IDEOGRAPH
    {0xB7EF, 0x51E4}, //9029 #CJK UNIFIED IDEOGRAPH
    {0xB7F0, 0x4F5B}, //9030 #CJK UNIFIED IDEOGRAPH
    {0xB7F1, 0x5426}, //9031 #CJK UNIFIED IDEOGRAPH
    {0xB7F2, 0x592B}, //9032 #CJK UNIFIED IDEOGRAPH
    {0xB7F3, 0x6577}, //9033 #CJK UNIFIED IDEOGRAPH
    {0xB7F4, 0x80A4}, //9034 #CJK UNIFIED IDEOGRAPH
    {0xB7F5, 0x5B75}, //9035 #CJK UNIFIED IDEOGRAPH
    {0xB7F6, 0x6276}, //9036 #CJK UNIFIED IDEOGRAPH
    {0xB7F7, 0x62C2}, //9037 #CJK UNIFIED IDEOGRAPH
    {0xB7F8, 0x8F90}, //9038 #CJK UNIFIED IDEOGRAPH
    {0xB7F9, 0x5E45}, //9039 #CJK UNIFIED IDEOGRAPH
    {0xB7FA, 0x6C1F}, //9040 #CJK UNIFIED IDEOGRAPH
    {0xB7FB, 0x7B26}, //9041 #CJK UNIFIED IDEOGRAPH
    {0xB7FC, 0x4F0F}, //9042 #CJK UNIFIED IDEOGRAPH
    {0xB7FD, 0x4FD8}, //9043 #CJK UNIFIED IDEOGRAPH
    {0xB7FE, 0x670D}, //9044 #CJK UNIFIED IDEOGRAPH
    {0xB840, 0x7AA3}, //9045 #CJK UNIFIED IDEOGRAPH
    {0xB841, 0x7AA4}, //9046 #CJK UNIFIED IDEOGRAPH
    {0xB842, 0x7AA7}, //9047 #CJK UNIFIED IDEOGRAPH
    {0xB843, 0x7AA9}, //9048 #CJK UNIFIED IDEOGRAPH
    {0xB844, 0x7AAA}, //9049 #CJK UNIFIED IDEOGRAPH
    {0xB845, 0x7AAB}, //9050 #CJK UNIFIED IDEOGRAPH
    {0xB846, 0x7AAE}, //9051 #CJK UNIFIED IDEOGRAPH
    {0xB847, 0x7AAF}, //9052 #CJK UNIFIED IDEOGRAPH
    {0xB848, 0x7AB0}, //9053 #CJK UNIFIED IDEOGRAPH
    {0xB849, 0x7AB1}, //9054 #CJK UNIFIED IDEOGRAPH
    {0xB84A, 0x7AB2}, //9055 #CJK UNIFIED IDEOGRAPH
    {0xB84B, 0x7AB4}, //9056 #CJK UNIFIED IDEOGRAPH
    {0xB84C, 0x7AB5}, //9057 #CJK UNIFIED IDEOGRAPH
    {0xB84D, 0x7AB6}, //9058 #CJK UNIFIED IDEOGRAPH
    {0xB84E, 0x7AB7}, //9059 #CJK UNIFIED IDEOGRAPH
    {0xB84F, 0x7AB8}, //9060 #CJK UNIFIED IDEOGRAPH
    {0xB850, 0x7AB9}, //9061 #CJK UNIFIED IDEOGRAPH
    {0xB851, 0x7ABA}, //9062 #CJK UNIFIED IDEOGRAPH
    {0xB852, 0x7ABB}, //9063 #CJK UNIFIED IDEOGRAPH
    {0xB853, 0x7ABC}, //9064 #CJK UNIFIED IDEOGRAPH
    {0xB854, 0x7ABD}, //9065 #CJK UNIFIED IDEOGRAPH
    {0xB855, 0x7ABE}, //9066 #CJK UNIFIED IDEOGRAPH
    {0xB856, 0x7AC0}, //9067 #CJK UNIFIED IDEOGRAPH
    {0xB857, 0x7AC1}, //9068 #CJK UNIFIED IDEOGRAPH
    {0xB858, 0x7AC2}, //9069 #CJK UNIFIED IDEOGRAPH
    {0xB859, 0x7AC3}, //9070 #CJK UNIFIED IDEOGRAPH
    {0xB85A, 0x7AC4}, //9071 #CJK UNIFIED IDEOGRAPH
    {0xB85B, 0x7AC5}, //9072 #CJK UNIFIED IDEOGRAPH
    {0xB85C, 0x7AC6}, //9073 #CJK UNIFIED IDEOGRAPH
    {0xB85D, 0x7AC7}, //9074 #CJK UNIFIED IDEOGRAPH
    {0xB85E, 0x7AC8}, //9075 #CJK UNIFIED IDEOGRAPH
    {0xB85F, 0x7AC9}, //9076 #CJK UNIFIED IDEOGRAPH
    {0xB860, 0x7ACA}, //9077 #CJK UNIFIED IDEOGRAPH
    {0xB861, 0x7ACC}, //9078 #CJK UNIFIED IDEOGRAPH
    {0xB862, 0x7ACD}, //9079 #CJK UNIFIED IDEOGRAPH
    {0xB863, 0x7ACE}, //9080 #CJK UNIFIED IDEOGRAPH
    {0xB864, 0x7ACF}, //9081 #CJK UNIFIED IDEOGRAPH
    {0xB865, 0x7AD0}, //9082 #CJK UNIFIED IDEOGRAPH
    {0xB866, 0x7AD1}, //9083 #CJK UNIFIED IDEOGRAPH
    {0xB867, 0x7AD2}, //9084 #CJK UNIFIED IDEOGRAPH
    {0xB868, 0x7AD3}, //9085 #CJK UNIFIED IDEOGRAPH
    {0xB869, 0x7AD4}, //9086 #CJK UNIFIED IDEOGRAPH
    {0xB86A, 0x7AD5}, //9087 #CJK UNIFIED IDEOGRAPH
    {0xB86B, 0x7AD7}, //9088 #CJK UNIFIED IDEOGRAPH
    {0xB86C, 0x7AD8}, //9089 #CJK UNIFIED IDEOGRAPH
    {0xB86D, 0x7ADA}, //9090 #CJK UNIFIED IDEOGRAPH
    {0xB86E, 0x7ADB}, //9091 #CJK UNIFIED IDEOGRAPH
    {0xB86F, 0x7ADC}, //9092 #CJK UNIFIED IDEOGRAPH
    {0xB870, 0x7ADD}, //9093 #CJK UNIFIED IDEOGRAPH
    {0xB871, 0x7AE1}, //9094 #CJK UNIFIED IDEOGRAPH
    {0xB872, 0x7AE2}, //9095 #CJK UNIFIED IDEOGRAPH
    {0xB873, 0x7AE4}, //9096 #CJK UNIFIED IDEOGRAPH
    {0xB874, 0x7AE7}, //9097 #CJK UNIFIED IDEOGRAPH
    {0xB875, 0x7AE8}, //9098 #CJK UNIFIED IDEOGRAPH
    {0xB876, 0x7AE9}, //9099 #CJK UNIFIED IDEOGRAPH
    {0xB877, 0x7AEA}, //9100 #CJK UNIFIED IDEOGRAPH
    {0xB878, 0x7AEB}, //9101 #CJK UNIFIED IDEOGRAPH
    {0xB879, 0x7AEC}, //9102 #CJK UNIFIED IDEOGRAPH
    {0xB87A, 0x7AEE}, //9103 #CJK UNIFIED IDEOGRAPH
    {0xB87B, 0x7AF0}, //9104 #CJK UNIFIED IDEOGRAPH
    {0xB87C, 0x7AF1}, //9105 #CJK UNIFIED IDEOGRAPH
    {0xB87D, 0x7AF2}, //9106 #CJK UNIFIED IDEOGRAPH
    {0xB87E, 0x7AF3}, //9107 #CJK UNIFIED IDEOGRAPH
    {0xB880, 0x7AF4}, //9108 #CJK UNIFIED IDEOGRAPH
    {0xB881, 0x7AF5}, //9109 #CJK UNIFIED IDEOGRAPH
    {0xB882, 0x7AF6}, //9110 #CJK UNIFIED IDEOGRAPH
    {0xB883, 0x7AF7}, //9111 #CJK UNIFIED IDEOGRAPH
    {0xB884, 0x7AF8}, //9112 #CJK UNIFIED IDEOGRAPH
    {0xB885, 0x7AFB}, //9113 #CJK UNIFIED IDEOGRAPH
    {0xB886, 0x7AFC}, //9114 #CJK UNIFIED IDEOGRAPH
    {0xB887, 0x7AFE}, //9115 #CJK UNIFIED IDEOGRAPH
    {0xB888, 0x7B00}, //9116 #CJK UNIFIED IDEOGRAPH
    {0xB889, 0x7B01}, //9117 #CJK UNIFIED IDEOGRAPH
    {0xB88A, 0x7B02}, //9118 #CJK UNIFIED IDEOGRAPH
    {0xB88B, 0x7B05}, //9119 #CJK UNIFIED IDEOGRAPH
    {0xB88C, 0x7B07}, //9120 #CJK UNIFIED IDEOGRAPH
    {0xB88D, 0x7B09}, //9121 #CJK UNIFIED IDEOGRAPH
    {0xB88E, 0x7B0C}, //9122 #CJK UNIFIED IDEOGRAPH
    {0xB88F, 0x7B0D}, //9123 #CJK UNIFIED IDEOGRAPH
    {0xB890, 0x7B0E}, //9124 #CJK UNIFIED IDEOGRAPH
    {0xB891, 0x7B10}, //9125 #CJK UNIFIED IDEOGRAPH
    {0xB892, 0x7B12}, //9126 #CJK UNIFIED IDEOGRAPH
    {0xB893, 0x7B13}, //9127 #CJK UNIFIED IDEOGRAPH
    {0xB894, 0x7B16}, //9128 #CJK UNIFIED IDEOGRAPH
    {0xB895, 0x7B17}, //9129 #CJK UNIFIED IDEOGRAPH
    {0xB896, 0x7B18}, //9130 #CJK UNIFIED IDEOGRAPH
    {0xB897, 0x7B1A}, //9131 #CJK UNIFIED IDEOGRAPH
    {0xB898, 0x7B1C}, //9132 #CJK UNIFIED IDEOGRAPH
    {0xB899, 0x7B1D}, //9133 #CJK UNIFIED IDEOGRAPH
    {0xB89A, 0x7B1F}, //9134 #CJK UNIFIED IDEOGRAPH
    {0xB89B, 0x7B21}, //9135 #CJK UNIFIED IDEOGRAPH
    {0xB89C, 0x7B22}, //9136 #CJK UNIFIED IDEOGRAPH
    {0xB89D, 0x7B23}, //9137 #CJK UNIFIED IDEOGRAPH
    {0xB89E, 0x7B27}, //9138 #CJK UNIFIED IDEOGRAPH
    {0xB89F, 0x7B29}, //9139 #CJK UNIFIED IDEOGRAPH
    {0xB8A0, 0x7B2D}, //9140 #CJK UNIFIED IDEOGRAPH
    {0xB8A1, 0x6D6E}, //9141 #CJK UNIFIED IDEOGRAPH
    {0xB8A2, 0x6DAA}, //9142 #CJK UNIFIED IDEOGRAPH
    {0xB8A3, 0x798F}, //9143 #CJK UNIFIED IDEOGRAPH
    {0xB8A4, 0x88B1}, //9144 #CJK UNIFIED IDEOGRAPH
    {0xB8A5, 0x5F17}, //9145 #CJK UNIFIED IDEOGRAPH
    {0xB8A6, 0x752B}, //9146 #CJK UNIFIED IDEOGRAPH
    {0xB8A7, 0x629A}, //9147 #CJK UNIFIED IDEOGRAPH
    {0xB8A8, 0x8F85}, //9148 #CJK UNIFIED IDEOGRAPH
    {0xB8A9, 0x4FEF}, //9149 #CJK UNIFIED IDEOGRAPH
    {0xB8AA, 0x91DC}, //9150 #CJK UNIFIED IDEOGRAPH
    {0xB8AB, 0x65A7}, //9151 #CJK UNIFIED IDEOGRAPH
    {0xB8AC, 0x812F}, //9152 #CJK UNIFIED IDEOGRAPH
    {0xB8AD, 0x8151}, //9153 #CJK UNIFIED IDEOGRAPH
    {0xB8AE, 0x5E9C}, //9154 #CJK UNIFIED IDEOGRAPH
    {0xB8AF, 0x8150}, //9155 #CJK UNIFIED IDEOGRAPH
    {0xB8B0, 0x8D74}, //9156 #CJK UNIFIED IDEOGRAPH
    {0xB8B1, 0x526F}, //9157 #CJK UNIFIED IDEOGRAPH
    {0xB8B2, 0x8986}, //9158 #CJK UNIFIED IDEOGRAPH
    {0xB8B3, 0x8D4B}, //9159 #CJK UNIFIED IDEOGRAPH
    {0xB8B4, 0x590D}, //9160 #CJK UNIFIED IDEOGRAPH
    {0xB8B5, 0x5085}, //9161 #CJK UNIFIED IDEOGRAPH
    {0xB8B6, 0x4ED8}, //9162 #CJK UNIFIED IDEOGRAPH
    {0xB8B7, 0x961C}, //9163 #CJK UNIFIED IDEOGRAPH
    {0xB8B8, 0x7236}, //9164 #CJK UNIFIED IDEOGRAPH
    {0xB8B9, 0x8179}, //9165 #CJK UNIFIED IDEOGRAPH
    {0xB8BA, 0x8D1F}, //9166 #CJK UNIFIED IDEOGRAPH
    {0xB8BB, 0x5BCC}, //9167 #CJK UNIFIED IDEOGRAPH
    {0xB8BC, 0x8BA3}, //9168 #CJK UNIFIED IDEOGRAPH
    {0xB8BD, 0x9644}, //9169 #CJK UNIFIED IDEOGRAPH
    {0xB8BE, 0x5987}, //9170 #CJK UNIFIED IDEOGRAPH
    {0xB8BF, 0x7F1A}, //9171 #CJK UNIFIED IDEOGRAPH
    {0xB8C0, 0x5490}, //9172 #CJK UNIFIED IDEOGRAPH
    {0xB8C1, 0x5676}, //9173 #CJK UNIFIED IDEOGRAPH
    {0xB8C2, 0x560E}, //9174 #CJK UNIFIED IDEOGRAPH
    {0xB8C3, 0x8BE5}, //9175 #CJK UNIFIED IDEOGRAPH
    {0xB8C4, 0x6539}, //9176 #CJK UNIFIED IDEOGRAPH
    {0xB8C5, 0x6982}, //9177 #CJK UNIFIED IDEOGRAPH
    {0xB8C6, 0x9499}, //9178 #CJK UNIFIED IDEOGRAPH
    {0xB8C7, 0x76D6}, //9179 #CJK UNIFIED IDEOGRAPH
    {0xB8C8, 0x6E89}, //9180 #CJK UNIFIED IDEOGRAPH
    {0xB8C9, 0x5E72}, //9181 #CJK UNIFIED IDEOGRAPH
    {0xB8CA, 0x7518}, //9182 #CJK UNIFIED IDEOGRAPH
    {0xB8CB, 0x6746}, //9183 #CJK UNIFIED IDEOGRAPH
    {0xB8CC, 0x67D1}, //9184 #CJK UNIFIED IDEOGRAPH
    {0xB8CD, 0x7AFF}, //9185 #CJK UNIFIED IDEOGRAPH
    {0xB8CE, 0x809D}, //9186 #CJK UNIFIED IDEOGRAPH
    {0xB8CF, 0x8D76}, //9187 #CJK UNIFIED IDEOGRAPH
    {0xB8D0, 0x611F}, //9188 #CJK UNIFIED IDEOGRAPH
    {0xB8D1, 0x79C6}, //9189 #CJK UNIFIED IDEOGRAPH
    {0xB8D2, 0x6562}, //9190 #CJK UNIFIED IDEOGRAPH
    {0xB8D3, 0x8D63}, //9191 #CJK UNIFIED IDEOGRAPH
    {0xB8D4, 0x5188}, //9192 #CJK UNIFIED IDEOGRAPH
    {0xB8D5, 0x521A}, //9193 #CJK UNIFIED IDEOGRAPH
    {0xB8D6, 0x94A2}, //9194 #CJK UNIFIED IDEOGRAPH
    {0xB8D7, 0x7F38}, //9195 #CJK UNIFIED IDEOGRAPH
    {0xB8D8, 0x809B}, //9196 #CJK UNIFIED IDEOGRAPH
    {0xB8D9, 0x7EB2}, //9197 #CJK UNIFIED IDEOGRAPH
    {0xB8DA, 0x5C97}, //9198 #CJK UNIFIED IDEOGRAPH
    {0xB8DB, 0x6E2F}, //9199 #CJK UNIFIED IDEOGRAPH
    {0xB8DC, 0x6760}, //9200 #CJK UNIFIED IDEOGRAPH
    {0xB8DD, 0x7BD9}, //9201 #CJK UNIFIED IDEOGRAPH
    {0xB8DE, 0x768B}, //9202 #CJK UNIFIED IDEOGRAPH
    {0xB8DF, 0x9AD8}, //9203 #CJK UNIFIED IDEOGRAPH
    {0xB8E0, 0x818F}, //9204 #CJK UNIFIED IDEOGRAPH
    {0xB8E1, 0x7F94}, //9205 #CJK UNIFIED IDEOGRAPH
    {0xB8E2, 0x7CD5}, //9206 #CJK UNIFIED IDEOGRAPH
    {0xB8E3, 0x641E}, //9207 #CJK UNIFIED IDEOGRAPH
    {0xB8E4, 0x9550}, //9208 #CJK UNIFIED IDEOGRAPH
    {0xB8E5, 0x7A3F}, //9209 #CJK UNIFIED IDEOGRAPH
    {0xB8E6, 0x544A}, //9210 #CJK UNIFIED IDEOGRAPH
    {0xB8E7, 0x54E5}, //9211 #CJK UNIFIED IDEOGRAPH
    {0xB8E8, 0x6B4C}, //9212 #CJK UNIFIED IDEOGRAPH
    {0xB8E9, 0x6401}, //9213 #CJK UNIFIED IDEOGRAPH
    {0xB8EA, 0x6208}, //9214 #CJK UNIFIED IDEOGRAPH
    {0xB8EB, 0x9E3D}, //9215 #CJK UNIFIED IDEOGRAPH
    {0xB8EC, 0x80F3}, //9216 #CJK UNIFIED IDEOGRAPH
    {0xB8ED, 0x7599}, //9217 #CJK UNIFIED IDEOGRAPH
    {0xB8EE, 0x5272}, //9218 #CJK UNIFIED IDEOGRAPH
    {0xB8EF, 0x9769}, //9219 #CJK UNIFIED IDEOGRAPH
    {0xB8F0, 0x845B}, //9220 #CJK UNIFIED IDEOGRAPH
    {0xB8F1, 0x683C}, //9221 #CJK UNIFIED IDEOGRAPH
    {0xB8F2, 0x86E4}, //9222 #CJK UNIFIED IDEOGRAPH
    {0xB8F3, 0x9601}, //9223 #CJK UNIFIED IDEOGRAPH
    {0xB8F4, 0x9694}, //9224 #CJK UNIFIED IDEOGRAPH
    {0xB8F5, 0x94EC}, //9225 #CJK UNIFIED IDEOGRAPH
    {0xB8F6, 0x4E2A}, //9226 #CJK UNIFIED IDEOGRAPH
    {0xB8F7, 0x5404}, //9227 #CJK UNIFIED IDEOGRAPH
    {0xB8F8, 0x7ED9}, //9228 #CJK UNIFIED IDEOGRAPH
    {0xB8F9, 0x6839}, //9229 #CJK UNIFIED IDEOGRAPH
    {0xB8FA, 0x8DDF}, //9230 #CJK UNIFIED IDEOGRAPH
    {0xB8FB, 0x8015}, //9231 #CJK UNIFIED IDEOGRAPH
    {0xB8FC, 0x66F4}, //9232 #CJK UNIFIED IDEOGRAPH
    {0xB8FD, 0x5E9A}, //9233 #CJK UNIFIED IDEOGRAPH
    {0xB8FE, 0x7FB9}, //9234 #CJK UNIFIED IDEOGRAPH
    {0xB940, 0x7B2F}, //9235 #CJK UNIFIED IDEOGRAPH
    {0xB941, 0x7B30}, //9236 #CJK UNIFIED IDEOGRAPH
    {0xB942, 0x7B32}, //9237 #CJK UNIFIED IDEOGRAPH
    {0xB943, 0x7B34}, //9238 #CJK UNIFIED IDEOGRAPH
    {0xB944, 0x7B35}, //9239 #CJK UNIFIED IDEOGRAPH
    {0xB945, 0x7B36}, //9240 #CJK UNIFIED IDEOGRAPH
    {0xB946, 0x7B37}, //9241 #CJK UNIFIED IDEOGRAPH
    {0xB947, 0x7B39}, //9242 #CJK UNIFIED IDEOGRAPH
    {0xB948, 0x7B3B}, //9243 #CJK UNIFIED IDEOGRAPH
    {0xB949, 0x7B3D}, //9244 #CJK UNIFIED IDEOGRAPH
    {0xB94A, 0x7B3F}, //9245 #CJK UNIFIED IDEOGRAPH
    {0xB94B, 0x7B40}, //9246 #CJK UNIFIED IDEOGRAPH
    {0xB94C, 0x7B41}, //9247 #CJK UNIFIED IDEOGRAPH
    {0xB94D, 0x7B42}, //9248 #CJK UNIFIED IDEOGRAPH
    {0xB94E, 0x7B43}, //9249 #CJK UNIFIED IDEOGRAPH
    {0xB94F, 0x7B44}, //9250 #CJK UNIFIED IDEOGRAPH
    {0xB950, 0x7B46}, //9251 #CJK UNIFIED IDEOGRAPH
    {0xB951, 0x7B48}, //9252 #CJK UNIFIED IDEOGRAPH
    {0xB952, 0x7B4A}, //9253 #CJK UNIFIED IDEOGRAPH
    {0xB953, 0x7B4D}, //9254 #CJK UNIFIED IDEOGRAPH
    {0xB954, 0x7B4E}, //9255 #CJK UNIFIED IDEOGRAPH
    {0xB955, 0x7B53}, //9256 #CJK UNIFIED IDEOGRAPH
    {0xB956, 0x7B55}, //9257 #CJK UNIFIED IDEOGRAPH
    {0xB957, 0x7B57}, //9258 #CJK UNIFIED IDEOGRAPH
    {0xB958, 0x7B59}, //9259 #CJK UNIFIED IDEOGRAPH
    {0xB959, 0x7B5C}, //9260 #CJK UNIFIED IDEOGRAPH
    {0xB95A, 0x7B5E}, //9261 #CJK UNIFIED IDEOGRAPH
    {0xB95B, 0x7B5F}, //9262 #CJK UNIFIED IDEOGRAPH
    {0xB95C, 0x7B61}, //9263 #CJK UNIFIED IDEOGRAPH
    {0xB95D, 0x7B63}, //9264 #CJK UNIFIED IDEOGRAPH
    {0xB95E, 0x7B64}, //9265 #CJK UNIFIED IDEOGRAPH
    {0xB95F, 0x7B65}, //9266 #CJK UNIFIED IDEOGRAPH
    {0xB960, 0x7B66}, //9267 #CJK UNIFIED IDEOGRAPH
    {0xB961, 0x7B67}, //9268 #CJK UNIFIED IDEOGRAPH
    {0xB962, 0x7B68}, //9269 #CJK UNIFIED IDEOGRAPH
    {0xB963, 0x7B69}, //9270 #CJK UNIFIED IDEOGRAPH
    {0xB964, 0x7B6A}, //9271 #CJK UNIFIED IDEOGRAPH
    {0xB965, 0x7B6B}, //9272 #CJK UNIFIED IDEOGRAPH
    {0xB966, 0x7B6C}, //9273 #CJK UNIFIED IDEOGRAPH
    {0xB967, 0x7B6D}, //9274 #CJK UNIFIED IDEOGRAPH
    {0xB968, 0x7B6F}, //9275 #CJK UNIFIED IDEOGRAPH
    {0xB969, 0x7B70}, //9276 #CJK UNIFIED IDEOGRAPH
    {0xB96A, 0x7B73}, //9277 #CJK UNIFIED IDEOGRAPH
    {0xB96B, 0x7B74}, //9278 #CJK UNIFIED IDEOGRAPH
    {0xB96C, 0x7B76}, //9279 #CJK UNIFIED IDEOGRAPH
    {0xB96D, 0x7B78}, //9280 #CJK UNIFIED IDEOGRAPH
    {0xB96E, 0x7B7A}, //9281 #CJK UNIFIED IDEOGRAPH
    {0xB96F, 0x7B7C}, //9282 #CJK UNIFIED IDEOGRAPH
    {0xB970, 0x7B7D}, //9283 #CJK UNIFIED IDEOGRAPH
    {0xB971, 0x7B7F}, //9284 #CJK UNIFIED IDEOGRAPH
    {0xB972, 0x7B81}, //9285 #CJK UNIFIED IDEOGRAPH
    {0xB973, 0x7B82}, //9286 #CJK UNIFIED IDEOGRAPH
    {0xB974, 0x7B83}, //9287 #CJK UNIFIED IDEOGRAPH
    {0xB975, 0x7B84}, //9288 #CJK UNIFIED IDEOGRAPH
    {0xB976, 0x7B86}, //9289 #CJK UNIFIED IDEOGRAPH
    {0xB977, 0x7B87}, //9290 #CJK UNIFIED IDEOGRAPH
    {0xB978, 0x7B88}, //9291 #CJK UNIFIED IDEOGRAPH
    {0xB979, 0x7B89}, //9292 #CJK UNIFIED IDEOGRAPH
    {0xB97A, 0x7B8A}, //9293 #CJK UNIFIED IDEOGRAPH
    {0xB97B, 0x7B8B}, //9294 #CJK UNIFIED IDEOGRAPH
    {0xB97C, 0x7B8C}, //9295 #CJK UNIFIED IDEOGRAPH
    {0xB97D, 0x7B8E}, //9296 #CJK UNIFIED IDEOGRAPH
    {0xB97E, 0x7B8F}, //9297 #CJK UNIFIED IDEOGRAPH
    {0xB980, 0x7B91}, //9298 #CJK UNIFIED IDEOGRAPH
    {0xB981, 0x7B92}, //9299 #CJK UNIFIED IDEOGRAPH
    {0xB982, 0x7B93}, //9300 #CJK UNIFIED IDEOGRAPH
    {0xB983, 0x7B96}, //9301 #CJK UNIFIED IDEOGRAPH
    {0xB984, 0x7B98}, //9302 #CJK UNIFIED IDEOGRAPH
    {0xB985, 0x7B99}, //9303 #CJK UNIFIED IDEOGRAPH
    {0xB986, 0x7B9A}, //9304 #CJK UNIFIED IDEOGRAPH
    {0xB987, 0x7B9B}, //9305 #CJK UNIFIED IDEOGRAPH
    {0xB988, 0x7B9E}, //9306 #CJK UNIFIED IDEOGRAPH
    {0xB989, 0x7B9F}, //9307 #CJK UNIFIED IDEOGRAPH
    {0xB98A, 0x7BA0}, //9308 #CJK UNIFIED IDEOGRAPH
    {0xB98B, 0x7BA3}, //9309 #CJK UNIFIED IDEOGRAPH
    {0xB98C, 0x7BA4}, //9310 #CJK UNIFIED IDEOGRAPH
    {0xB98D, 0x7BA5}, //9311 #CJK UNIFIED IDEOGRAPH
    {0xB98E, 0x7BAE}, //9312 #CJK UNIFIED IDEOGRAPH
    {0xB98F, 0x7BAF}, //9313 #CJK UNIFIED IDEOGRAPH
    {0xB990, 0x7BB0}, //9314 #CJK UNIFIED IDEOGRAPH
    {0xB991, 0x7BB2}, //9315 #CJK UNIFIED IDEOGRAPH
    {0xB992, 0x7BB3}, //9316 #CJK UNIFIED IDEOGRAPH
    {0xB993, 0x7BB5}, //9317 #CJK UNIFIED IDEOGRAPH
    {0xB994, 0x7BB6}, //9318 #CJK UNIFIED IDEOGRAPH
    {0xB995, 0x7BB7}, //9319 #CJK UNIFIED IDEOGRAPH
    {0xB996, 0x7BB9}, //9320 #CJK UNIFIED IDEOGRAPH
    {0xB997, 0x7BBA}, //9321 #CJK UNIFIED IDEOGRAPH
    {0xB998, 0x7BBB}, //9322 #CJK UNIFIED IDEOGRAPH
    {0xB999, 0x7BBC}, //9323 #CJK UNIFIED IDEOGRAPH
    {0xB99A, 0x7BBD}, //9324 #CJK UNIFIED IDEOGRAPH
    {0xB99B, 0x7BBE}, //9325 #CJK UNIFIED IDEOGRAPH
    {0xB99C, 0x7BBF}, //9326 #CJK UNIFIED IDEOGRAPH
    {0xB99D, 0x7BC0}, //9327 #CJK UNIFIED IDEOGRAPH
    {0xB99E, 0x7BC2}, //9328 #CJK UNIFIED IDEOGRAPH
    {0xB99F, 0x7BC3}, //9329 #CJK UNIFIED IDEOGRAPH
    {0xB9A0, 0x7BC4}, //9330 #CJK UNIFIED IDEOGRAPH
    {0xB9A1, 0x57C2}, //9331 #CJK UNIFIED IDEOGRAPH
    {0xB9A2, 0x803F}, //9332 #CJK UNIFIED IDEOGRAPH
    {0xB9A3, 0x6897}, //9333 #CJK UNIFIED IDEOGRAPH
    {0xB9A4, 0x5DE5}, //9334 #CJK UNIFIED IDEOGRAPH
    {0xB9A5, 0x653B}, //9335 #CJK UNIFIED IDEOGRAPH
    {0xB9A6, 0x529F}, //9336 #CJK UNIFIED IDEOGRAPH
    {0xB9A7, 0x606D}, //9337 #CJK UNIFIED IDEOGRAPH
    {0xB9A8, 0x9F9A}, //9338 #CJK UNIFIED IDEOGRAPH
    {0xB9A9, 0x4F9B}, //9339 #CJK UNIFIED IDEOGRAPH
    {0xB9AA, 0x8EAC}, //9340 #CJK UNIFIED IDEOGRAPH
    {0xB9AB, 0x516C}, //9341 #CJK UNIFIED IDEOGRAPH
    {0xB9AC, 0x5BAB}, //9342 #CJK UNIFIED IDEOGRAPH
    {0xB9AD, 0x5F13}, //9343 #CJK UNIFIED IDEOGRAPH
    {0xB9AE, 0x5DE9}, //9344 #CJK UNIFIED IDEOGRAPH
    {0xB9AF, 0x6C5E}, //9345 #CJK UNIFIED IDEOGRAPH
    {0xB9B0, 0x62F1}, //9346 #CJK UNIFIED IDEOGRAPH
    {0xB9B1, 0x8D21}, //9347 #CJK UNIFIED IDEOGRAPH
    {0xB9B2, 0x5171}, //9348 #CJK UNIFIED IDEOGRAPH
    {0xB9B3, 0x94A9}, //9349 #CJK UNIFIED IDEOGRAPH
    {0xB9B4, 0x52FE}, //9350 #CJK UNIFIED IDEOGRAPH
    {0xB9B5, 0x6C9F}, //9351 #CJK UNIFIED IDEOGRAPH
    {0xB9B6, 0x82DF}, //9352 #CJK UNIFIED IDEOGRAPH
    {0xB9B7, 0x72D7}, //9353 #CJK UNIFIED IDEOGRAPH
    {0xB9B8, 0x57A2}, //9354 #CJK UNIFIED IDEOGRAPH
    {0xB9B9, 0x6784}, //9355 #CJK UNIFIED IDEOGRAPH
    {0xB9BA, 0x8D2D}, //9356 #CJK UNIFIED IDEOGRAPH
    {0xB9BB, 0x591F}, //9357 #CJK UNIFIED IDEOGRAPH
    {0xB9BC, 0x8F9C}, //9358 #CJK UNIFIED IDEOGRAPH
    {0xB9BD, 0x83C7}, //9359 #CJK UNIFIED IDEOGRAPH
    {0xB9BE, 0x5495}, //9360 #CJK UNIFIED IDEOGRAPH
    {0xB9BF, 0x7B8D}, //9361 #CJK UNIFIED IDEOGRAPH
    {0xB9C0, 0x4F30}, //9362 #CJK UNIFIED IDEOGRAPH
    {0xB9C1, 0x6CBD}, //9363 #CJK UNIFIED IDEOGRAPH
    {0xB9C2, 0x5B64}, //9364 #CJK UNIFIED IDEOGRAPH
    {0xB9C3, 0x59D1}, //9365 #CJK UNIFIED IDEOGRAPH
    {0xB9C4, 0x9F13}, //9366 #CJK UNIFIED IDEOGRAPH
    {0xB9C5, 0x53E4}, //9367 #CJK UNIFIED IDEOGRAPH
    {0xB9C6, 0x86CA}, //9368 #CJK UNIFIED IDEOGRAPH
    {0xB9C7, 0x9AA8}, //9369 #CJK UNIFIED IDEOGRAPH
    {0xB9C8, 0x8C37}, //9370 #CJK UNIFIED IDEOGRAPH
    {0xB9C9, 0x80A1}, //9371 #CJK UNIFIED IDEOGRAPH
    {0xB9CA, 0x6545}, //9372 #CJK UNIFIED IDEOGRAPH
    {0xB9CB, 0x987E}, //9373 #CJK UNIFIED IDEOGRAPH
    {0xB9CC, 0x56FA}, //9374 #CJK UNIFIED IDEOGRAPH
    {0xB9CD, 0x96C7}, //9375 #CJK UNIFIED IDEOGRAPH
    {0xB9CE, 0x522E}, //9376 #CJK UNIFIED IDEOGRAPH
    {0xB9CF, 0x74DC}, //9377 #CJK UNIFIED IDEOGRAPH
    {0xB9D0, 0x5250}, //9378 #CJK UNIFIED IDEOGRAPH
    {0xB9D1, 0x5BE1}, //9379 #CJK UNIFIED IDEOGRAPH
    {0xB9D2, 0x6302}, //9380 #CJK UNIFIED IDEOGRAPH
    {0xB9D3, 0x8902}, //9381 #CJK UNIFIED IDEOGRAPH
    {0xB9D4, 0x4E56}, //9382 #CJK UNIFIED IDEOGRAPH
    {0xB9D5, 0x62D0}, //9383 #CJK UNIFIED IDEOGRAPH
    {0xB9D6, 0x602A}, //9384 #CJK UNIFIED IDEOGRAPH
    {0xB9D7, 0x68FA}, //9385 #CJK UNIFIED IDEOGRAPH
    {0xB9D8, 0x5173}, //9386 #CJK UNIFIED IDEOGRAPH
    {0xB9D9, 0x5B98}, //9387 #CJK UNIFIED IDEOGRAPH
    {0xB9DA, 0x51A0}, //9388 #CJK UNIFIED IDEOGRAPH
    {0xB9DB, 0x89C2}, //9389 #CJK UNIFIED IDEOGRAPH
    {0xB9DC, 0x7BA1}, //9390 #CJK UNIFIED IDEOGRAPH
    {0xB9DD, 0x9986}, //9391 #CJK UNIFIED IDEOGRAPH
    {0xB9DE, 0x7F50}, //9392 #CJK UNIFIED IDEOGRAPH
    {0xB9DF, 0x60EF}, //9393 #CJK UNIFIED IDEOGRAPH
    {0xB9E0, 0x704C}, //9394 #CJK UNIFIED IDEOGRAPH
    {0xB9E1, 0x8D2F}, //9395 #CJK UNIFIED IDEOGRAPH
    {0xB9E2, 0x5149}, //9396 #CJK UNIFIED IDEOGRAPH
    {0xB9E3, 0x5E7F}, //9397 #CJK UNIFIED IDEOGRAPH
    {0xB9E4, 0x901B}, //9398 #CJK UNIFIED IDEOGRAPH
    {0xB9E5, 0x7470}, //9399 #CJK UNIFIED IDEOGRAPH
    {0xB9E6, 0x89C4}, //9400 #CJK UNIFIED IDEOGRAPH
    {0xB9E7, 0x572D}, //9401 #CJK UNIFIED IDEOGRAPH
    {0xB9E8, 0x7845}, //9402 #CJK UNIFIED IDEOGRAPH
    {0xB9E9, 0x5F52}, //9403 #CJK UNIFIED IDEOGRAPH
    {0xB9EA, 0x9F9F}, //9404 #CJK UNIFIED IDEOGRAPH
    {0xB9EB, 0x95FA}, //9405 #CJK UNIFIED IDEOGRAPH
    {0xB9EC, 0x8F68}, //9406 #CJK UNIFIED IDEOGRAPH
    {0xB9ED, 0x9B3C}, //9407 #CJK UNIFIED IDEOGRAPH
    {0xB9EE, 0x8BE1}, //9408 #CJK UNIFIED IDEOGRAPH
    {0xB9EF, 0x7678}, //9409 #CJK UNIFIED IDEOGRAPH
    {0xB9F0, 0x6842}, //9410 #CJK UNIFIED IDEOGRAPH
    {0xB9F1, 0x67DC}, //9411 #CJK UNIFIED IDEOGRAPH
    {0xB9F2, 0x8DEA}, //9412 #CJK UNIFIED IDEOGRAPH
    {0xB9F3, 0x8D35}, //9413 #CJK UNIFIED IDEOGRAPH
    {0xB9F4, 0x523D}, //9414 #CJK UNIFIED IDEOGRAPH
    {0xB9F5, 0x8F8A}, //9415 #CJK UNIFIED IDEOGRAPH
    {0xB9F6, 0x6EDA}, //9416 #CJK UNIFIED IDEOGRAPH
    {0xB9F7, 0x68CD}, //9417 #CJK UNIFIED IDEOGRAPH
    {0xB9F8, 0x9505}, //9418 #CJK UNIFIED IDEOGRAPH
    {0xB9F9, 0x90ED}, //9419 #CJK UNIFIED IDEOGRAPH
    {0xB9FA, 0x56FD}, //9420 #CJK UNIFIED IDEOGRAPH
    {0xB9FB, 0x679C}, //9421 #CJK UNIFIED IDEOGRAPH
    {0xB9FC, 0x88F9}, //9422 #CJK UNIFIED IDEOGRAPH
    {0xB9FD, 0x8FC7}, //9423 #CJK UNIFIED IDEOGRAPH
    {0xB9FE, 0x54C8}, //9424 #CJK UNIFIED IDEOGRAPH
    {0xBA40, 0x7BC5}, //9425 #CJK UNIFIED IDEOGRAPH
    {0xBA41, 0x7BC8}, //9426 #CJK UNIFIED IDEOGRAPH
    {0xBA42, 0x7BC9}, //9427 #CJK UNIFIED IDEOGRAPH
    {0xBA43, 0x7BCA}, //9428 #CJK UNIFIED IDEOGRAPH
    {0xBA44, 0x7BCB}, //9429 #CJK UNIFIED IDEOGRAPH
    {0xBA45, 0x7BCD}, //9430 #CJK UNIFIED IDEOGRAPH
    {0xBA46, 0x7BCE}, //9431 #CJK UNIFIED IDEOGRAPH
    {0xBA47, 0x7BCF}, //9432 #CJK UNIFIED IDEOGRAPH
    {0xBA48, 0x7BD0}, //9433 #CJK UNIFIED IDEOGRAPH
    {0xBA49, 0x7BD2}, //9434 #CJK UNIFIED IDEOGRAPH
    {0xBA4A, 0x7BD4}, //9435 #CJK UNIFIED IDEOGRAPH
    {0xBA4B, 0x7BD5}, //9436 #CJK UNIFIED IDEOGRAPH
    {0xBA4C, 0x7BD6}, //9437 #CJK UNIFIED IDEOGRAPH
    {0xBA4D, 0x7BD7}, //9438 #CJK UNIFIED IDEOGRAPH
    {0xBA4E, 0x7BD8}, //9439 #CJK UNIFIED IDEOGRAPH
    {0xBA4F, 0x7BDB}, //9440 #CJK UNIFIED IDEOGRAPH
    {0xBA50, 0x7BDC}, //9441 #CJK UNIFIED IDEOGRAPH
    {0xBA51, 0x7BDE}, //9442 #CJK UNIFIED IDEOGRAPH
    {0xBA52, 0x7BDF}, //9443 #CJK UNIFIED IDEOGRAPH
    {0xBA53, 0x7BE0}, //9444 #CJK UNIFIED IDEOGRAPH
    {0xBA54, 0x7BE2}, //9445 #CJK UNIFIED IDEOGRAPH
    {0xBA55, 0x7BE3}, //9446 #CJK UNIFIED IDEOGRAPH
    {0xBA56, 0x7BE4}, //9447 #CJK UNIFIED IDEOGRAPH
    {0xBA57, 0x7BE7}, //9448 #CJK UNIFIED IDEOGRAPH
    {0xBA58, 0x7BE8}, //9449 #CJK UNIFIED IDEOGRAPH
    {0xBA59, 0x7BE9}, //9450 #CJK UNIFIED IDEOGRAPH
    {0xBA5A, 0x7BEB}, //9451 #CJK UNIFIED IDEOGRAPH
    {0xBA5B, 0x7BEC}, //9452 #CJK UNIFIED IDEOGRAPH
    {0xBA5C, 0x7BED}, //9453 #CJK UNIFIED IDEOGRAPH
    {0xBA5D, 0x7BEF}, //9454 #CJK UNIFIED IDEOGRAPH
    {0xBA5E, 0x7BF0}, //9455 #CJK UNIFIED IDEOGRAPH
    {0xBA5F, 0x7BF2}, //9456 #CJK UNIFIED IDEOGRAPH
    {0xBA60, 0x7BF3}, //9457 #CJK UNIFIED IDEOGRAPH
    {0xBA61, 0x7BF4}, //9458 #CJK UNIFIED IDEOGRAPH
    {0xBA62, 0x7BF5}, //9459 #CJK UNIFIED IDEOGRAPH
    {0xBA63, 0x7BF6}, //9460 #CJK UNIFIED IDEOGRAPH
    {0xBA64, 0x7BF8}, //9461 #CJK UNIFIED IDEOGRAPH
    {0xBA65, 0x7BF9}, //9462 #CJK UNIFIED IDEOGRAPH
    {0xBA66, 0x7BFA}, //9463 #CJK UNIFIED IDEOGRAPH
    {0xBA67, 0x7BFB}, //9464 #CJK UNIFIED IDEOGRAPH
    {0xBA68, 0x7BFD}, //9465 #CJK UNIFIED IDEOGRAPH
    {0xBA69, 0x7BFF}, //9466 #CJK UNIFIED IDEOGRAPH
    {0xBA6A, 0x7C00}, //9467 #CJK UNIFIED IDEOGRAPH
    {0xBA6B, 0x7C01}, //9468 #CJK UNIFIED IDEOGRAPH
    {0xBA6C, 0x7C02}, //9469 #CJK UNIFIED IDEOGRAPH
    {0xBA6D, 0x7C03}, //9470 #CJK UNIFIED IDEOGRAPH
    {0xBA6E, 0x7C04}, //9471 #CJK UNIFIED IDEOGRAPH
    {0xBA6F, 0x7C05}, //9472 #CJK UNIFIED IDEOGRAPH
    {0xBA70, 0x7C06}, //9473 #CJK UNIFIED IDEOGRAPH
    {0xBA71, 0x7C08}, //9474 #CJK UNIFIED IDEOGRAPH
    {0xBA72, 0x7C09}, //9475 #CJK UNIFIED IDEOGRAPH
    {0xBA73, 0x7C0A}, //9476 #CJK UNIFIED IDEOGRAPH
    {0xBA74, 0x7C0D}, //9477 #CJK UNIFIED IDEOGRAPH
    {0xBA75, 0x7C0E}, //9478 #CJK UNIFIED IDEOGRAPH
    {0xBA76, 0x7C10}, //9479 #CJK UNIFIED IDEOGRAPH
    {0xBA77, 0x7C11}, //9480 #CJK UNIFIED IDEOGRAPH
    {0xBA78, 0x7C12}, //9481 #CJK UNIFIED IDEOGRAPH
    {0xBA79, 0x7C13}, //9482 #CJK UNIFIED IDEOGRAPH
    {0xBA7A, 0x7C14}, //9483 #CJK UNIFIED IDEOGRAPH
    {0xBA7B, 0x7C15}, //9484 #CJK UNIFIED IDEOGRAPH
    {0xBA7C, 0x7C17}, //9485 #CJK UNIFIED IDEOGRAPH
    {0xBA7D, 0x7C18}, //9486 #CJK UNIFIED IDEOGRAPH
    {0xBA7E, 0x7C19}, //9487 #CJK UNIFIED IDEOGRAPH
    {0xBA80, 0x7C1A}, //9488 #CJK UNIFIED IDEOGRAPH
    {0xBA81, 0x7C1B}, //9489 #CJK UNIFIED IDEOGRAPH
    {0xBA82, 0x7C1C}, //9490 #CJK UNIFIED IDEOGRAPH
    {0xBA83, 0x7C1D}, //9491 #CJK UNIFIED IDEOGRAPH
    {0xBA84, 0x7C1E}, //9492 #CJK UNIFIED IDEOGRAPH
    {0xBA85, 0x7C20}, //9493 #CJK UNIFIED IDEOGRAPH
    {0xBA86, 0x7C21}, //9494 #CJK UNIFIED IDEOGRAPH
    {0xBA87, 0x7C22}, //9495 #CJK UNIFIED IDEOGRAPH
    {0xBA88, 0x7C23}, //9496 #CJK UNIFIED IDEOGRAPH
    {0xBA89, 0x7C24}, //9497 #CJK UNIFIED IDEOGRAPH
    {0xBA8A, 0x7C25}, //9498 #CJK UNIFIED IDEOGRAPH
    {0xBA8B, 0x7C28}, //9499 #CJK UNIFIED IDEOGRAPH
    {0xBA8C, 0x7C29}, //9500 #CJK UNIFIED IDEOGRAPH
    {0xBA8D, 0x7C2B}, //9501 #CJK UNIFIED IDEOGRAPH
    {0xBA8E, 0x7C2C}, //9502 #CJK UNIFIED IDEOGRAPH
    {0xBA8F, 0x7C2D}, //9503 #CJK UNIFIED IDEOGRAPH
    {0xBA90, 0x7C2E}, //9504 #CJK UNIFIED IDEOGRAPH
    {0xBA91, 0x7C2F}, //9505 #CJK UNIFIED IDEOGRAPH
    {0xBA92, 0x7C30}, //9506 #CJK UNIFIED IDEOGRAPH
    {0xBA93, 0x7C31}, //9507 #CJK UNIFIED IDEOGRAPH
    {0xBA94, 0x7C32}, //9508 #CJK UNIFIED IDEOGRAPH
    {0xBA95, 0x7C33}, //9509 #CJK UNIFIED IDEOGRAPH
    {0xBA96, 0x7C34}, //9510 #CJK UNIFIED IDEOGRAPH
    {0xBA97, 0x7C35}, //9511 #CJK UNIFIED IDEOGRAPH
    {0xBA98, 0x7C36}, //9512 #CJK UNIFIED IDEOGRAPH
    {0xBA99, 0x7C37}, //9513 #CJK UNIFIED IDEOGRAPH
    {0xBA9A, 0x7C39}, //9514 #CJK UNIFIED IDEOGRAPH
    {0xBA9B, 0x7C3A}, //9515 #CJK UNIFIED IDEOGRAPH
    {0xBA9C, 0x7C3B}, //9516 #CJK UNIFIED IDEOGRAPH
    {0xBA9D, 0x7C3C}, //9517 #CJK UNIFIED IDEOGRAPH
    {0xBA9E, 0x7C3D}, //9518 #CJK UNIFIED IDEOGRAPH
    {0xBA9F, 0x7C3E}, //9519 #CJK UNIFIED IDEOGRAPH
    {0xBAA0, 0x7C42}, //9520 #CJK UNIFIED IDEOGRAPH
    {0xBAA1, 0x9AB8}, //9521 #CJK UNIFIED IDEOGRAPH
    {0xBAA2, 0x5B69}, //9522 #CJK UNIFIED IDEOGRAPH
    {0xBAA3, 0x6D77}, //9523 #CJK UNIFIED IDEOGRAPH
    {0xBAA4, 0x6C26}, //9524 #CJK UNIFIED IDEOGRAPH
    {0xBAA5, 0x4EA5}, //9525 #CJK UNIFIED IDEOGRAPH
    {0xBAA6, 0x5BB3}, //9526 #CJK UNIFIED IDEOGRAPH
    {0xBAA7, 0x9A87}, //9527 #CJK UNIFIED IDEOGRAPH
    {0xBAA8, 0x9163}, //9528 #CJK UNIFIED IDEOGRAPH
    {0xBAA9, 0x61A8}, //9529 #CJK UNIFIED IDEOGRAPH
    {0xBAAA, 0x90AF}, //9530 #CJK UNIFIED IDEOGRAPH
    {0xBAAB, 0x97E9}, //9531 #CJK UNIFIED IDEOGRAPH
    {0xBAAC, 0x542B}, //9532 #CJK UNIFIED IDEOGRAPH
    {0xBAAD, 0x6DB5}, //9533 #CJK UNIFIED IDEOGRAPH
    {0xBAAE, 0x5BD2}, //9534 #CJK UNIFIED IDEOGRAPH
    {0xBAAF, 0x51FD}, //9535 #CJK UNIFIED IDEOGRAPH
    {0xBAB0, 0x558A}, //9536 #CJK UNIFIED IDEOGRAPH
    {0xBAB1, 0x7F55}, //9537 #CJK UNIFIED IDEOGRAPH
    {0xBAB2, 0x7FF0}, //9538 #CJK UNIFIED IDEOGRAPH
    {0xBAB3, 0x64BC}, //9539 #CJK UNIFIED IDEOGRAPH
    {0xBAB4, 0x634D}, //9540 #CJK UNIFIED IDEOGRAPH
    {0xBAB5, 0x65F1}, //9541 #CJK UNIFIED IDEOGRAPH
    {0xBAB6, 0x61BE}, //9542 #CJK UNIFIED IDEOGRAPH
    {0xBAB7, 0x608D}, //9543 #CJK UNIFIED IDEOGRAPH
    {0xBAB8, 0x710A}, //9544 #CJK UNIFIED IDEOGRAPH
    {0xBAB9, 0x6C57}, //9545 #CJK UNIFIED IDEOGRAPH
    {0xBABA, 0x6C49}, //9546 #CJK UNIFIED IDEOGRAPH
    {0xBABB, 0x592F}, //9547 #CJK UNIFIED IDEOGRAPH
    {0xBABC, 0x676D}, //9548 #CJK UNIFIED IDEOGRAPH
    {0xBABD, 0x822A}, //9549 #CJK UNIFIED IDEOGRAPH
    {0xBABE, 0x58D5}, //9550 #CJK UNIFIED IDEOGRAPH
    {0xBABF, 0x568E}, //9551 #CJK UNIFIED IDEOGRAPH
    {0xBAC0, 0x8C6A}, //9552 #CJK UNIFIED IDEOGRAPH
    {0xBAC1, 0x6BEB}, //9553 #CJK UNIFIED IDEOGRAPH
    {0xBAC2, 0x90DD}, //9554 #CJK UNIFIED IDEOGRAPH
    {0xBAC3, 0x597D}, //9555 #CJK UNIFIED IDEOGRAPH
    {0xBAC4, 0x8017}, //9556 #CJK UNIFIED IDEOGRAPH
    {0xBAC5, 0x53F7}, //9557 #CJK UNIFIED IDEOGRAPH
    {0xBAC6, 0x6D69}, //9558 #CJK UNIFIED IDEOGRAPH
    {0xBAC7, 0x5475}, //9559 #CJK UNIFIED IDEOGRAPH
    {0xBAC8, 0x559D}, //9560 #CJK UNIFIED IDEOGRAPH
    {0xBAC9, 0x8377}, //9561 #CJK UNIFIED IDEOGRAPH
    {0xBACA, 0x83CF}, //9562 #CJK UNIFIED IDEOGRAPH
    {0xBACB, 0x6838}, //9563 #CJK UNIFIED IDEOGRAPH
    {0xBACC, 0x79BE}, //9564 #CJK UNIFIED IDEOGRAPH
    {0xBACD, 0x548C}, //9565 #CJK UNIFIED IDEOGRAPH
    {0xBACE, 0x4F55}, //9566 #CJK UNIFIED IDEOGRAPH
    {0xBACF, 0x5408}, //9567 #CJK UNIFIED IDEOGRAPH
    {0xBAD0, 0x76D2}, //9568 #CJK UNIFIED IDEOGRAPH
    {0xBAD1, 0x8C89}, //9569 #CJK UNIFIED IDEOGRAPH
    {0xBAD2, 0x9602}, //9570 #CJK UNIFIED IDEOGRAPH
    {0xBAD3, 0x6CB3}, //9571 #CJK UNIFIED IDEOGRAPH
    {0xBAD4, 0x6DB8}, //9572 #CJK UNIFIED IDEOGRAPH
    {0xBAD5, 0x8D6B}, //9573 #CJK UNIFIED IDEOGRAPH
    {0xBAD6, 0x8910}, //9574 #CJK UNIFIED IDEOGRAPH
    {0xBAD7, 0x9E64}, //9575 #CJK UNIFIED IDEOGRAPH
    {0xBAD8, 0x8D3A}, //9576 #CJK UNIFIED IDEOGRAPH
    {0xBAD9, 0x563F}, //9577 #CJK UNIFIED IDEOGRAPH
    {0xBADA, 0x9ED1}, //9578 #CJK UNIFIED IDEOGRAPH
    {0xBADB, 0x75D5}, //9579 #CJK UNIFIED IDEOGRAPH
    {0xBADC, 0x5F88}, //9580 #CJK UNIFIED IDEOGRAPH
    {0xBADD, 0x72E0}, //9581 #CJK UNIFIED IDEOGRAPH
    {0xBADE, 0x6068}, //9582 #CJK UNIFIED IDEOGRAPH
    {0xBADF, 0x54FC}, //9583 #CJK UNIFIED IDEOGRAPH
    {0xBAE0, 0x4EA8}, //9584 #CJK UNIFIED IDEOGRAPH
    {0xBAE1, 0x6A2A}, //9585 #CJK UNIFIED IDEOGRAPH
    {0xBAE2, 0x8861}, //9586 #CJK UNIFIED IDEOGRAPH
    {0xBAE3, 0x6052}, //9587 #CJK UNIFIED IDEOGRAPH
    {0xBAE4, 0x8F70}, //9588 #CJK UNIFIED IDEOGRAPH
    {0xBAE5, 0x54C4}, //9589 #CJK UNIFIED IDEOGRAPH
    {0xBAE6, 0x70D8}, //9590 #CJK UNIFIED IDEOGRAPH
    {0xBAE7, 0x8679}, //9591 #CJK UNIFIED IDEOGRAPH
    {0xBAE8, 0x9E3F}, //9592 #CJK UNIFIED IDEOGRAPH
    {0xBAE9, 0x6D2A}, //9593 #CJK UNIFIED IDEOGRAPH
    {0xBAEA, 0x5B8F}, //9594 #CJK UNIFIED IDEOGRAPH
    {0xBAEB, 0x5F18}, //9595 #CJK UNIFIED IDEOGRAPH
    {0xBAEC, 0x7EA2}, //9596 #CJK UNIFIED IDEOGRAPH
    {0xBAED, 0x5589}, //9597 #CJK UNIFIED IDEOGRAPH
    {0xBAEE, 0x4FAF}, //9598 #CJK UNIFIED IDEOGRAPH
    {0xBAEF, 0x7334}, //9599 #CJK UNIFIED IDEOGRAPH
    {0xBAF0, 0x543C}, //9600 #CJK UNIFIED IDEOGRAPH
    {0xBAF1, 0x539A}, //9601 #CJK UNIFIED IDEOGRAPH
    {0xBAF2, 0x5019}, //9602 #CJK UNIFIED IDEOGRAPH
    {0xBAF3, 0x540E}, //9603 #CJK UNIFIED IDEOGRAPH
    {0xBAF4, 0x547C}, //9604 #CJK UNIFIED IDEOGRAPH
    {0xBAF5, 0x4E4E}, //9605 #CJK UNIFIED IDEOGRAPH
    {0xBAF6, 0x5FFD}, //9606 #CJK UNIFIED IDEOGRAPH
    {0xBAF7, 0x745A}, //9607 #CJK UNIFIED IDEOGRAPH
    {0xBAF8, 0x58F6}, //9608 #CJK UNIFIED IDEOGRAPH
    {0xBAF9, 0x846B}, //9609 #CJK UNIFIED IDEOGRAPH
    {0xBAFA, 0x80E1}, //9610 #CJK UNIFIED IDEOGRAPH
    {0xBAFB, 0x8774}, //9611 #CJK UNIFIED IDEOGRAPH
    {0xBAFC, 0x72D0}, //9612 #CJK UNIFIED IDEOGRAPH
    {0xBAFD, 0x7CCA}, //9613 #CJK UNIFIED IDEOGRAPH
    {0xBAFE, 0x6E56}, //9614 #CJK UNIFIED IDEOGRAPH
    {0xBB40, 0x7C43}, //9615 #CJK UNIFIED IDEOGRAPH
    {0xBB41, 0x7C44}, //9616 #CJK UNIFIED IDEOGRAPH
    {0xBB42, 0x7C45}, //9617 #CJK UNIFIED IDEOGRAPH
    {0xBB43, 0x7C46}, //9618 #CJK UNIFIED IDEOGRAPH
    {0xBB44, 0x7C47}, //9619 #CJK UNIFIED IDEOGRAPH
    {0xBB45, 0x7C48}, //9620 #CJK UNIFIED IDEOGRAPH
    {0xBB46, 0x7C49}, //9621 #CJK UNIFIED IDEOGRAPH
    {0xBB47, 0x7C4A}, //9622 #CJK UNIFIED IDEOGRAPH
    {0xBB48, 0x7C4B}, //9623 #CJK UNIFIED IDEOGRAPH
    {0xBB49, 0x7C4C}, //9624 #CJK UNIFIED IDEOGRAPH
    {0xBB4A, 0x7C4E}, //9625 #CJK UNIFIED IDEOGRAPH
    {0xBB4B, 0x7C4F}, //9626 #CJK UNIFIED IDEOGRAPH
    {0xBB4C, 0x7C50}, //9627 #CJK UNIFIED IDEOGRAPH
    {0xBB4D, 0x7C51}, //9628 #CJK UNIFIED IDEOGRAPH
    {0xBB4E, 0x7C52}, //9629 #CJK UNIFIED IDEOGRAPH
    {0xBB4F, 0x7C53}, //9630 #CJK UNIFIED IDEOGRAPH
    {0xBB50, 0x7C54}, //9631 #CJK UNIFIED IDEOGRAPH
    {0xBB51, 0x7C55}, //9632 #CJK UNIFIED IDEOGRAPH
    {0xBB52, 0x7C56}, //9633 #CJK UNIFIED IDEOGRAPH
    {0xBB53, 0x7C57}, //9634 #CJK UNIFIED IDEOGRAPH
    {0xBB54, 0x7C58}, //9635 #CJK UNIFIED IDEOGRAPH
    {0xBB55, 0x7C59}, //9636 #CJK UNIFIED IDEOGRAPH
    {0xBB56, 0x7C5A}, //9637 #CJK UNIFIED IDEOGRAPH
    {0xBB57, 0x7C5B}, //9638 #CJK UNIFIED IDEOGRAPH
    {0xBB58, 0x7C5C}, //9639 #CJK UNIFIED IDEOGRAPH
    {0xBB59, 0x7C5D}, //9640 #CJK UNIFIED IDEOGRAPH
    {0xBB5A, 0x7C5E}, //9641 #CJK UNIFIED IDEOGRAPH
    {0xBB5B, 0x7C5F}, //9642 #CJK UNIFIED IDEOGRAPH
    {0xBB5C, 0x7C60}, //9643 #CJK UNIFIED IDEOGRAPH
    {0xBB5D, 0x7C61}, //9644 #CJK UNIFIED IDEOGRAPH
    {0xBB5E, 0x7C62}, //9645 #CJK UNIFIED IDEOGRAPH
    {0xBB5F, 0x7C63}, //9646 #CJK UNIFIED IDEOGRAPH
    {0xBB60, 0x7C64}, //9647 #CJK UNIFIED IDEOGRAPH
    {0xBB61, 0x7C65}, //9648 #CJK UNIFIED IDEOGRAPH
    {0xBB62, 0x7C66}, //9649 #CJK UNIFIED IDEOGRAPH
    {0xBB63, 0x7C67}, //9650 #CJK UNIFIED IDEOGRAPH
    {0xBB64, 0x7C68}, //9651 #CJK UNIFIED IDEOGRAPH
    {0xBB65, 0x7C69}, //9652 #CJK UNIFIED IDEOGRAPH
    {0xBB66, 0x7C6A}, //9653 #CJK UNIFIED IDEOGRAPH
    {0xBB67, 0x7C6B}, //9654 #CJK UNIFIED IDEOGRAPH
    {0xBB68, 0x7C6C}, //9655 #CJK UNIFIED IDEOGRAPH
    {0xBB69, 0x7C6D}, //9656 #CJK UNIFIED IDEOGRAPH
    {0xBB6A, 0x7C6E}, //9657 #CJK UNIFIED IDEOGRAPH
    {0xBB6B, 0x7C6F}, //9658 #CJK UNIFIED IDEOGRAPH
    {0xBB6C, 0x7C70}, //9659 #CJK UNIFIED IDEOGRAPH
    {0xBB6D, 0x7C71}, //9660 #CJK UNIFIED IDEOGRAPH
    {0xBB6E, 0x7C72}, //9661 #CJK UNIFIED IDEOGRAPH
    {0xBB6F, 0x7C75}, //9662 #CJK UNIFIED IDEOGRAPH
    {0xBB70, 0x7C76}, //9663 #CJK UNIFIED IDEOGRAPH
    {0xBB71, 0x7C77}, //9664 #CJK UNIFIED IDEOGRAPH
    {0xBB72, 0x7C78}, //9665 #CJK UNIFIED IDEOGRAPH
    {0xBB73, 0x7C79}, //9666 #CJK UNIFIED IDEOGRAPH
    {0xBB74, 0x7C7A}, //9667 #CJK UNIFIED IDEOGRAPH
    {0xBB75, 0x7C7E}, //9668 #CJK UNIFIED IDEOGRAPH
    {0xBB76, 0x7C7F}, //9669 #CJK UNIFIED IDEOGRAPH
    {0xBB77, 0x7C80}, //9670 #CJK UNIFIED IDEOGRAPH
    {0xBB78, 0x7C81}, //9671 #CJK UNIFIED IDEOGRAPH
    {0xBB79, 0x7C82}, //9672 #CJK UNIFIED IDEOGRAPH
    {0xBB7A, 0x7C83}, //9673 #CJK UNIFIED IDEOGRAPH
    {0xBB7B, 0x7C84}, //9674 #CJK UNIFIED IDEOGRAPH
    {0xBB7C, 0x7C85}, //9675 #CJK UNIFIED IDEOGRAPH
    {0xBB7D, 0x7C86}, //9676 #CJK UNIFIED IDEOGRAPH
    {0xBB7E, 0x7C87}, //9677 #CJK UNIFIED IDEOGRAPH
    {0xBB80, 0x7C88}, //9678 #CJK UNIFIED IDEOGRAPH
    {0xBB81, 0x7C8A}, //9679 #CJK UNIFIED IDEOGRAPH
    {0xBB82, 0x7C8B}, //9680 #CJK UNIFIED IDEOGRAPH
    {0xBB83, 0x7C8C}, //9681 #CJK UNIFIED IDEOGRAPH
    {0xBB84, 0x7C8D}, //9682 #CJK UNIFIED IDEOGRAPH
    {0xBB85, 0x7C8E}, //9683 #CJK UNIFIED IDEOGRAPH
    {0xBB86, 0x7C8F}, //9684 #CJK UNIFIED IDEOGRAPH
    {0xBB87, 0x7C90}, //9685 #CJK UNIFIED IDEOGRAPH
    {0xBB88, 0x7C93}, //9686 #CJK UNIFIED IDEOGRAPH
    {0xBB89, 0x7C94}, //9687 #CJK UNIFIED IDEOGRAPH
    {0xBB8A, 0x7C96}, //9688 #CJK UNIFIED IDEOGRAPH
    {0xBB8B, 0x7C99}, //9689 #CJK UNIFIED IDEOGRAPH
    {0xBB8C, 0x7C9A}, //9690 #CJK UNIFIED IDEOGRAPH
    {0xBB8D, 0x7C9B}, //9691 #CJK UNIFIED IDEOGRAPH
    {0xBB8E, 0x7CA0}, //9692 #CJK UNIFIED IDEOGRAPH
    {0xBB8F, 0x7CA1}, //9693 #CJK UNIFIED IDEOGRAPH
    {0xBB90, 0x7CA3}, //9694 #CJK UNIFIED IDEOGRAPH
    {0xBB91, 0x7CA6}, //9695 #CJK UNIFIED IDEOGRAPH
    {0xBB92, 0x7CA7}, //9696 #CJK UNIFIED IDEOGRAPH
    {0xBB93, 0x7CA8}, //9697 #CJK UNIFIED IDEOGRAPH
    {0xBB94, 0x7CA9}, //9698 #CJK UNIFIED IDEOGRAPH
    {0xBB95, 0x7CAB}, //9699 #CJK UNIFIED IDEOGRAPH
    {0xBB96, 0x7CAC}, //9700 #CJK UNIFIED IDEOGRAPH
    {0xBB97, 0x7CAD}, //9701 #CJK UNIFIED IDEOGRAPH
    {0xBB98, 0x7CAF}, //9702 #CJK UNIFIED IDEOGRAPH
    {0xBB99, 0x7CB0}, //9703 #CJK UNIFIED IDEOGRAPH
    {0xBB9A, 0x7CB4}, //9704 #CJK UNIFIED IDEOGRAPH
    {0xBB9B, 0x7CB5}, //9705 #CJK UNIFIED IDEOGRAPH
    {0xBB9C, 0x7CB6}, //9706 #CJK UNIFIED IDEOGRAPH
    {0xBB9D, 0x7CB7}, //9707 #CJK UNIFIED IDEOGRAPH
    {0xBB9E, 0x7CB8}, //9708 #CJK UNIFIED IDEOGRAPH
    {0xBB9F, 0x7CBA}, //9709 #CJK UNIFIED IDEOGRAPH
    {0xBBA0, 0x7CBB}, //9710 #CJK UNIFIED IDEOGRAPH
    {0xBBA1, 0x5F27}, //9711 #CJK UNIFIED IDEOGRAPH
    {0xBBA2, 0x864E}, //9712 #CJK UNIFIED IDEOGRAPH
    {0xBBA3, 0x552C}, //9713 #CJK UNIFIED IDEOGRAPH
    {0xBBA4, 0x62A4}, //9714 #CJK UNIFIED IDEOGRAPH
    {0xBBA5, 0x4E92}, //9715 #CJK UNIFIED IDEOGRAPH
    {0xBBA6, 0x6CAA}, //9716 #CJK UNIFIED IDEOGRAPH
    {0xBBA7, 0x6237}, //9717 #CJK UNIFIED IDEOGRAPH
    {0xBBA8, 0x82B1}, //9718 #CJK UNIFIED IDEOGRAPH
    {0xBBA9, 0x54D7}, //9719 #CJK UNIFIED IDEOGRAPH
    {0xBBAA, 0x534E}, //9720 #CJK UNIFIED IDEOGRAPH
    {0xBBAB, 0x733E}, //9721 #CJK UNIFIED IDEOGRAPH
    {0xBBAC, 0x6ED1}, //9722 #CJK UNIFIED IDEOGRAPH
    {0xBBAD, 0x753B}, //9723 #CJK UNIFIED IDEOGRAPH
    {0xBBAE, 0x5212}, //9724 #CJK UNIFIED IDEOGRAPH
    {0xBBAF, 0x5316}, //9725 #CJK UNIFIED IDEOGRAPH
    {0xBBB0, 0x8BDD}, //9726 #CJK UNIFIED IDEOGRAPH
    {0xBBB1, 0x69D0}, //9727 #CJK UNIFIED IDEOGRAPH
    {0xBBB2, 0x5F8A}, //9728 #CJK UNIFIED IDEOGRAPH
    {0xBBB3, 0x6000}, //9729 #CJK UNIFIED IDEOGRAPH
    {0xBBB4, 0x6DEE}, //9730 #CJK UNIFIED IDEOGRAPH
    {0xBBB5, 0x574F}, //9731 #CJK UNIFIED IDEOGRAPH
    {0xBBB6, 0x6B22}, //9732 #CJK UNIFIED IDEOGRAPH
    {0xBBB7, 0x73AF}, //9733 #CJK UNIFIED IDEOGRAPH
    {0xBBB8, 0x6853}, //9734 #CJK UNIFIED IDEOGRAPH
    {0xBBB9, 0x8FD8}, //9735 #CJK UNIFIED IDEOGRAPH
    {0xBBBA, 0x7F13}, //9736 #CJK UNIFIED IDEOGRAPH
    {0xBBBB, 0x6362}, //9737 #CJK UNIFIED IDEOGRAPH
    {0xBBBC, 0x60A3}, //9738 #CJK UNIFIED IDEOGRAPH
    {0xBBBD, 0x5524}, //9739 #CJK UNIFIED IDEOGRAPH
    {0xBBBE, 0x75EA}, //9740 #CJK UNIFIED IDEOGRAPH
    {0xBBBF, 0x8C62}, //9741 #CJK UNIFIED IDEOGRAPH
    {0xBBC0, 0x7115}, //9742 #CJK UNIFIED IDEOGRAPH
    {0xBBC1, 0x6DA3}, //9743 #CJK UNIFIED IDEOGRAPH
    {0xBBC2, 0x5BA6}, //9744 #CJK UNIFIED IDEOGRAPH
    {0xBBC3, 0x5E7B}, //9745 #CJK UNIFIED IDEOGRAPH
    {0xBBC4, 0x8352}, //9746 #CJK UNIFIED IDEOGRAPH
    {0xBBC5, 0x614C}, //9747 #CJK UNIFIED IDEOGRAPH
    {0xBBC6, 0x9EC4}, //9748 #CJK UNIFIED IDEOGRAPH
    {0xBBC7, 0x78FA}, //9749 #CJK UNIFIED IDEOGRAPH
    {0xBBC8, 0x8757}, //9750 #CJK UNIFIED IDEOGRAPH
    {0xBBC9, 0x7C27}, //9751 #CJK UNIFIED IDEOGRAPH
    {0xBBCA, 0x7687}, //9752 #CJK UNIFIED IDEOGRAPH
    {0xBBCB, 0x51F0}, //9753 #CJK UNIFIED IDEOGRAPH
    {0xBBCC, 0x60F6}, //9754 #CJK UNIFIED IDEOGRAPH
    {0xBBCD, 0x714C}, //9755 #CJK UNIFIED IDEOGRAPH
    {0xBBCE, 0x6643}, //9756 #CJK UNIFIED IDEOGRAPH
    {0xBBCF, 0x5E4C}, //9757 #CJK UNIFIED IDEOGRAPH
    {0xBBD0, 0x604D}, //9758 #CJK UNIFIED IDEOGRAPH
    {0xBBD1, 0x8C0E}, //9759 #CJK UNIFIED IDEOGRAPH
    {0xBBD2, 0x7070}, //9760 #CJK UNIFIED IDEOGRAPH
    {0xBBD3, 0x6325}, //9761 #CJK UNIFIED IDEOGRAPH
    {0xBBD4, 0x8F89}, //9762 #CJK UNIFIED IDEOGRAPH
    {0xBBD5, 0x5FBD}, //9763 #CJK UNIFIED IDEOGRAPH
    {0xBBD6, 0x6062}, //9764 #CJK UNIFIED IDEOGRAPH
    {0xBBD7, 0x86D4}, //9765 #CJK UNIFIED IDEOGRAPH
    {0xBBD8, 0x56DE}, //9766 #CJK UNIFIED IDEOGRAPH
    {0xBBD9, 0x6BC1}, //9767 #CJK UNIFIED IDEOGRAPH
    {0xBBDA, 0x6094}, //9768 #CJK UNIFIED IDEOGRAPH
    {0xBBDB, 0x6167}, //9769 #CJK UNIFIED IDEOGRAPH
    {0xBBDC, 0x5349}, //9770 #CJK UNIFIED IDEOGRAPH
    {0xBBDD, 0x60E0}, //9771 #CJK UNIFIED IDEOGRAPH
    {0xBBDE, 0x6666}, //9772 #CJK UNIFIED IDEOGRAPH
    {0xBBDF, 0x8D3F}, //9773 #CJK UNIFIED IDEOGRAPH
    {0xBBE0, 0x79FD}, //9774 #CJK UNIFIED IDEOGRAPH
    {0xBBE1, 0x4F1A}, //9775 #CJK UNIFIED IDEOGRAPH
    {0xBBE2, 0x70E9}, //9776 #CJK UNIFIED IDEOGRAPH
    {0xBBE3, 0x6C47}, //9777 #CJK UNIFIED IDEOGRAPH
    {0xBBE4, 0x8BB3}, //9778 #CJK UNIFIED IDEOGRAPH
    {0xBBE5, 0x8BF2}, //9779 #CJK UNIFIED IDEOGRAPH
    {0xBBE6, 0x7ED8}, //9780 #CJK UNIFIED IDEOGRAPH
    {0xBBE7, 0x8364}, //9781 #CJK UNIFIED IDEOGRAPH
    {0xBBE8, 0x660F}, //9782 #CJK UNIFIED IDEOGRAPH
    {0xBBE9, 0x5A5A}, //9783 #CJK UNIFIED IDEOGRAPH
    {0xBBEA, 0x9B42}, //9784 #CJK UNIFIED IDEOGRAPH
    {0xBBEB, 0x6D51}, //9785 #CJK UNIFIED IDEOGRAPH
    {0xBBEC, 0x6DF7}, //9786 #CJK UNIFIED IDEOGRAPH
    {0xBBED, 0x8C41}, //9787 #CJK UNIFIED IDEOGRAPH
    {0xBBEE, 0x6D3B}, //9788 #CJK UNIFIED IDEOGRAPH
    {0xBBEF, 0x4F19}, //9789 #CJK UNIFIED IDEOGRAPH
    {0xBBF0, 0x706B}, //9790 #CJK UNIFIED IDEOGRAPH
    {0xBBF1, 0x83B7}, //9791 #CJK UNIFIED IDEOGRAPH
    {0xBBF2, 0x6216}, //9792 #CJK UNIFIED IDEOGRAPH
    {0xBBF3, 0x60D1}, //9793 #CJK UNIFIED IDEOGRAPH
    {0xBBF4, 0x970D}, //9794 #CJK UNIFIED IDEOGRAPH
    {0xBBF5, 0x8D27}, //9795 #CJK UNIFIED IDEOGRAPH
    {0xBBF6, 0x7978}, //9796 #CJK UNIFIED IDEOGRAPH
    {0xBBF7, 0x51FB}, //9797 #CJK UNIFIED IDEOGRAPH
    {0xBBF8, 0x573E}, //9798 #CJK UNIFIED IDEOGRAPH
    {0xBBF9, 0x57FA}, //9799 #CJK UNIFIED IDEOGRAPH
    {0xBBFA, 0x673A}, //9800 #CJK UNIFIED IDEOGRAPH
    {0xBBFB, 0x7578}, //9801 #CJK UNIFIED IDEOGRAPH
    {0xBBFC, 0x7A3D}, //9802 #CJK UNIFIED IDEOGRAPH
    {0xBBFD, 0x79EF}, //9803 #CJK UNIFIED IDEOGRAPH
    {0xBBFE, 0x7B95}, //9804 #CJK UNIFIED IDEOGRAPH
    {0xBC40, 0x7CBF}, //9805 #CJK UNIFIED IDEOGRAPH
    {0xBC41, 0x7CC0}, //9806 #CJK UNIFIED IDEOGRAPH
    {0xBC42, 0x7CC2}, //9807 #CJK UNIFIED IDEOGRAPH
    {0xBC43, 0x7CC3}, //9808 #CJK UNIFIED IDEOGRAPH
    {0xBC44, 0x7CC4}, //9809 #CJK UNIFIED IDEOGRAPH
    {0xBC45, 0x7CC6}, //9810 #CJK UNIFIED IDEOGRAPH
    {0xBC46, 0x7CC9}, //9811 #CJK UNIFIED IDEOGRAPH
    {0xBC47, 0x7CCB}, //9812 #CJK UNIFIED IDEOGRAPH
    {0xBC48, 0x7CCE}, //9813 #CJK UNIFIED IDEOGRAPH
    {0xBC49, 0x7CCF}, //9814 #CJK UNIFIED IDEOGRAPH
    {0xBC4A, 0x7CD0}, //9815 #CJK UNIFIED IDEOGRAPH
    {0xBC4B, 0x7CD1}, //9816 #CJK UNIFIED IDEOGRAPH
    {0xBC4C, 0x7CD2}, //9817 #CJK UNIFIED IDEOGRAPH
    {0xBC4D, 0x7CD3}, //9818 #CJK UNIFIED IDEOGRAPH
    {0xBC4E, 0x7CD4}, //9819 #CJK UNIFIED IDEOGRAPH
    {0xBC4F, 0x7CD8}, //9820 #CJK UNIFIED IDEOGRAPH
    {0xBC50, 0x7CDA}, //9821 #CJK UNIFIED IDEOGRAPH
    {0xBC51, 0x7CDB}, //9822 #CJK UNIFIED IDEOGRAPH
    {0xBC52, 0x7CDD}, //9823 #CJK UNIFIED IDEOGRAPH
    {0xBC53, 0x7CDE}, //9824 #CJK UNIFIED IDEOGRAPH
    {0xBC54, 0x7CE1}, //9825 #CJK UNIFIED IDEOGRAPH
    {0xBC55, 0x7CE2}, //9826 #CJK UNIFIED IDEOGRAPH
    {0xBC56, 0x7CE3}, //9827 #CJK UNIFIED IDEOGRAPH
    {0xBC57, 0x7CE4}, //9828 #CJK UNIFIED IDEOGRAPH
    {0xBC58, 0x7CE5}, //9829 #CJK UNIFIED IDEOGRAPH
    {0xBC59, 0x7CE6}, //9830 #CJK UNIFIED IDEOGRAPH
    {0xBC5A, 0x7CE7}, //9831 #CJK UNIFIED IDEOGRAPH
    {0xBC5B, 0x7CE9}, //9832 #CJK UNIFIED IDEOGRAPH
    {0xBC5C, 0x7CEA}, //9833 #CJK UNIFIED IDEOGRAPH
    {0xBC5D, 0x7CEB}, //9834 #CJK UNIFIED IDEOGRAPH
    {0xBC5E, 0x7CEC}, //9835 #CJK UNIFIED IDEOGRAPH
    {0xBC5F, 0x7CED}, //9836 #CJK UNIFIED IDEOGRAPH
    {0xBC60, 0x7CEE}, //9837 #CJK UNIFIED IDEOGRAPH
    {0xBC61, 0x7CF0}, //9838 #CJK UNIFIED IDEOGRAPH
    {0xBC62, 0x7CF1}, //9839 #CJK UNIFIED IDEOGRAPH
    {0xBC63, 0x7CF2}, //9840 #CJK UNIFIED IDEOGRAPH
    {0xBC64, 0x7CF3}, //9841 #CJK UNIFIED IDEOGRAPH
    {0xBC65, 0x7CF4}, //9842 #CJK UNIFIED IDEOGRAPH
    {0xBC66, 0x7CF5}, //9843 #CJK UNIFIED IDEOGRAPH
    {0xBC67, 0x7CF6}, //9844 #CJK UNIFIED IDEOGRAPH
    {0xBC68, 0x7CF7}, //9845 #CJK UNIFIED IDEOGRAPH
    {0xBC69, 0x7CF9}, //9846 #CJK UNIFIED IDEOGRAPH
    {0xBC6A, 0x7CFA}, //9847 #CJK UNIFIED IDEOGRAPH
    {0xBC6B, 0x7CFC}, //9848 #CJK UNIFIED IDEOGRAPH
    {0xBC6C, 0x7CFD}, //9849 #CJK UNIFIED IDEOGRAPH
    {0xBC6D, 0x7CFE}, //9850 #CJK UNIFIED IDEOGRAPH
    {0xBC6E, 0x7CFF}, //9851 #CJK UNIFIED IDEOGRAPH
    {0xBC6F, 0x7D00}, //9852 #CJK UNIFIED IDEOGRAPH
    {0xBC70, 0x7D01}, //9853 #CJK UNIFIED IDEOGRAPH
    {0xBC71, 0x7D02}, //9854 #CJK UNIFIED IDEOGRAPH
    {0xBC72, 0x7D03}, //9855 #CJK UNIFIED IDEOGRAPH
    {0xBC73, 0x7D04}, //9856 #CJK UNIFIED IDEOGRAPH
    {0xBC74, 0x7D05}, //9857 #CJK UNIFIED IDEOGRAPH
    {0xBC75, 0x7D06}, //9858 #CJK UNIFIED IDEOGRAPH
    {0xBC76, 0x7D07}, //9859 #CJK UNIFIED IDEOGRAPH
    {0xBC77, 0x7D08}, //9860 #CJK UNIFIED IDEOGRAPH
    {0xBC78, 0x7D09}, //9861 #CJK UNIFIED IDEOGRAPH
    {0xBC79, 0x7D0B}, //9862 #CJK UNIFIED IDEOGRAPH
    {0xBC7A, 0x7D0C}, //9863 #CJK UNIFIED IDEOGRAPH
    {0xBC7B, 0x7D0D}, //9864 #CJK UNIFIED IDEOGRAPH
    {0xBC7C, 0x7D0E}, //9865 #CJK UNIFIED IDEOGRAPH
    {0xBC7D, 0x7D0F}, //9866 #CJK UNIFIED IDEOGRAPH
    {0xBC7E, 0x7D10}, //9867 #CJK UNIFIED IDEOGRAPH
    {0xBC80, 0x7D11}, //9868 #CJK UNIFIED IDEOGRAPH
    {0xBC81, 0x7D12}, //9869 #CJK UNIFIED IDEOGRAPH
    {0xBC82, 0x7D13}, //9870 #CJK UNIFIED IDEOGRAPH
    {0xBC83, 0x7D14}, //9871 #CJK UNIFIED IDEOGRAPH
    {0xBC84, 0x7D15}, //9872 #CJK UNIFIED IDEOGRAPH
    {0xBC85, 0x7D16}, //9873 #CJK UNIFIED IDEOGRAPH
    {0xBC86, 0x7D17}, //9874 #CJK UNIFIED IDEOGRAPH
    {0xBC87, 0x7D18}, //9875 #CJK UNIFIED IDEOGRAPH
    {0xBC88, 0x7D19}, //9876 #CJK UNIFIED IDEOGRAPH
    {0xBC89, 0x7D1A}, //9877 #CJK UNIFIED IDEOGRAPH
    {0xBC8A, 0x7D1B}, //9878 #CJK UNIFIED IDEOGRAPH
    {0xBC8B, 0x7D1C}, //9879 #CJK UNIFIED IDEOGRAPH
    {0xBC8C, 0x7D1D}, //9880 #CJK UNIFIED IDEOGRAPH
    {0xBC8D, 0x7D1E}, //9881 #CJK UNIFIED IDEOGRAPH
    {0xBC8E, 0x7D1F}, //9882 #CJK UNIFIED IDEOGRAPH
    {0xBC8F, 0x7D21}, //9883 #CJK UNIFIED IDEOGRAPH
    {0xBC90, 0x7D23}, //9884 #CJK UNIFIED IDEOGRAPH
    {0xBC91, 0x7D24}, //9885 #CJK UNIFIED IDEOGRAPH
    {0xBC92, 0x7D25}, //9886 #CJK UNIFIED IDEOGRAPH
    {0xBC93, 0x7D26}, //9887 #CJK UNIFIED IDEOGRAPH
    {0xBC94, 0x7D28}, //9888 #CJK UNIFIED IDEOGRAPH
    {0xBC95, 0x7D29}, //9889 #CJK UNIFIED IDEOGRAPH
    {0xBC96, 0x7D2A}, //9890 #CJK UNIFIED IDEOGRAPH
    {0xBC97, 0x7D2C}, //9891 #CJK UNIFIED IDEOGRAPH
    {0xBC98, 0x7D2D}, //9892 #CJK UNIFIED IDEOGRAPH
    {0xBC99, 0x7D2E}, //9893 #CJK UNIFIED IDEOGRAPH
    {0xBC9A, 0x7D30}, //9894 #CJK UNIFIED IDEOGRAPH
    {0xBC9B, 0x7D31}, //9895 #CJK UNIFIED IDEOGRAPH
    {0xBC9C, 0x7D32}, //9896 #CJK UNIFIED IDEOGRAPH
    {0xBC9D, 0x7D33}, //9897 #CJK UNIFIED IDEOGRAPH
    {0xBC9E, 0x7D34}, //9898 #CJK UNIFIED IDEOGRAPH
    {0xBC9F, 0x7D35}, //9899 #CJK UNIFIED IDEOGRAPH
    {0xBCA0, 0x7D36}, //9900 #CJK UNIFIED IDEOGRAPH
    {0xBCA1, 0x808C}, //9901 #CJK UNIFIED IDEOGRAPH
    {0xBCA2, 0x9965}, //9902 #CJK UNIFIED IDEOGRAPH
    {0xBCA3, 0x8FF9}, //9903 #CJK UNIFIED IDEOGRAPH
    {0xBCA4, 0x6FC0}, //9904 #CJK UNIFIED IDEOGRAPH
    {0xBCA5, 0x8BA5}, //9905 #CJK UNIFIED IDEOGRAPH
    {0xBCA6, 0x9E21}, //9906 #CJK UNIFIED IDEOGRAPH
    {0xBCA7, 0x59EC}, //9907 #CJK UNIFIED IDEOGRAPH
    {0xBCA8, 0x7EE9}, //9908 #CJK UNIFIED IDEOGRAPH
    {0xBCA9, 0x7F09}, //9909 #CJK UNIFIED IDEOGRAPH
    {0xBCAA, 0x5409}, //9910 #CJK UNIFIED IDEOGRAPH
    {0xBCAB, 0x6781}, //9911 #CJK UNIFIED IDEOGRAPH
    {0xBCAC, 0x68D8}, //9912 #CJK UNIFIED IDEOGRAPH
    {0xBCAD, 0x8F91}, //9913 #CJK UNIFIED IDEOGRAPH
    {0xBCAE, 0x7C4D}, //9914 #CJK UNIFIED IDEOGRAPH
    {0xBCAF, 0x96C6}, //9915 #CJK UNIFIED IDEOGRAPH
    {0xBCB0, 0x53CA}, //9916 #CJK UNIFIED IDEOGRAPH
    {0xBCB1, 0x6025}, //9917 #CJK UNIFIED IDEOGRAPH
    {0xBCB2, 0x75BE}, //9918 #CJK UNIFIED IDEOGRAPH
    {0xBCB3, 0x6C72}, //9919 #CJK UNIFIED IDEOGRAPH
    {0xBCB4, 0x5373}, //9920 #CJK UNIFIED IDEOGRAPH
    {0xBCB5, 0x5AC9}, //9921 #CJK UNIFIED IDEOGRAPH
    {0xBCB6, 0x7EA7}, //9922 #CJK UNIFIED IDEOGRAPH
    {0xBCB7, 0x6324}, //9923 #CJK UNIFIED IDEOGRAPH
    {0xBCB8, 0x51E0}, //9924 #CJK UNIFIED IDEOGRAPH
    {0xBCB9, 0x810A}, //9925 #CJK UNIFIED IDEOGRAPH
    {0xBCBA, 0x5DF1}, //9926 #CJK UNIFIED IDEOGRAPH
    {0xBCBB, 0x84DF}, //9927 #CJK UNIFIED IDEOGRAPH
    {0xBCBC, 0x6280}, //9928 #CJK UNIFIED IDEOGRAPH
    {0xBCBD, 0x5180}, //9929 #CJK UNIFIED IDEOGRAPH
    {0xBCBE, 0x5B63}, //9930 #CJK UNIFIED IDEOGRAPH
    {0xBCBF, 0x4F0E}, //9931 #CJK UNIFIED IDEOGRAPH
    {0xBCC0, 0x796D}, //9932 #CJK UNIFIED IDEOGRAPH
    {0xBCC1, 0x5242}, //9933 #CJK UNIFIED IDEOGRAPH
    {0xBCC2, 0x60B8}, //9934 #CJK UNIFIED IDEOGRAPH
    {0xBCC3, 0x6D4E}, //9935 #CJK UNIFIED IDEOGRAPH
    {0xBCC4, 0x5BC4}, //9936 #CJK UNIFIED IDEOGRAPH
    {0xBCC5, 0x5BC2}, //9937 #CJK UNIFIED IDEOGRAPH
    {0xBCC6, 0x8BA1}, //9938 #CJK UNIFIED IDEOGRAPH
    {0xBCC7, 0x8BB0}, //9939 #CJK UNIFIED IDEOGRAPH
    {0xBCC8, 0x65E2}, //9940 #CJK UNIFIED IDEOGRAPH
    {0xBCC9, 0x5FCC}, //9941 #CJK UNIFIED IDEOGRAPH
    {0xBCCA, 0x9645}, //9942 #CJK UNIFIED IDEOGRAPH
    {0xBCCB, 0x5993}, //9943 #CJK UNIFIED IDEOGRAPH
    {0xBCCC, 0x7EE7}, //9944 #CJK UNIFIED IDEOGRAPH
    {0xBCCD, 0x7EAA}, //9945 #CJK UNIFIED IDEOGRAPH
    {0xBCCE, 0x5609}, //9946 #CJK UNIFIED IDEOGRAPH
    {0xBCCF, 0x67B7}, //9947 #CJK UNIFIED IDEOGRAPH
    {0xBCD0, 0x5939}, //9948 #CJK UNIFIED IDEOGRAPH
    {0xBCD1, 0x4F73}, //9949 #CJK UNIFIED IDEOGRAPH
    {0xBCD2, 0x5BB6}, //9950 #CJK UNIFIED IDEOGRAPH
    {0xBCD3, 0x52A0}, //9951 #CJK UNIFIED IDEOGRAPH
    {0xBCD4, 0x835A}, //9952 #CJK UNIFIED IDEOGRAPH
    {0xBCD5, 0x988A}, //9953 #CJK UNIFIED IDEOGRAPH
    {0xBCD6, 0x8D3E}, //9954 #CJK UNIFIED IDEOGRAPH
    {0xBCD7, 0x7532}, //9955 #CJK UNIFIED IDEOGRAPH
    {0xBCD8, 0x94BE}, //9956 #CJK UNIFIED IDEOGRAPH
    {0xBCD9, 0x5047}, //9957 #CJK UNIFIED IDEOGRAPH
    {0xBCDA, 0x7A3C}, //9958 #CJK UNIFIED IDEOGRAPH
    {0xBCDB, 0x4EF7}, //9959 #CJK UNIFIED IDEOGRAPH
    {0xBCDC, 0x67B6}, //9960 #CJK UNIFIED IDEOGRAPH
    {0xBCDD, 0x9A7E}, //9961 #CJK UNIFIED IDEOGRAPH
    {0xBCDE, 0x5AC1}, //9962 #CJK UNIFIED IDEOGRAPH
    {0xBCDF, 0x6B7C}, //9963 #CJK UNIFIED IDEOGRAPH
    {0xBCE0, 0x76D1}, //9964 #CJK UNIFIED IDEOGRAPH
    {0xBCE1, 0x575A}, //9965 #CJK UNIFIED IDEOGRAPH
    {0xBCE2, 0x5C16}, //9966 #CJK UNIFIED IDEOGRAPH
    {0xBCE3, 0x7B3A}, //9967 #CJK UNIFIED IDEOGRAPH
    {0xBCE4, 0x95F4}, //9968 #CJK UNIFIED IDEOGRAPH
    {0xBCE5, 0x714E}, //9969 #CJK UNIFIED IDEOGRAPH
    {0xBCE6, 0x517C}, //9970 #CJK UNIFIED IDEOGRAPH
    {0xBCE7, 0x80A9}, //9971 #CJK UNIFIED IDEOGRAPH
    {0xBCE8, 0x8270}, //9972 #CJK UNIFIED IDEOGRAPH
    {0xBCE9, 0x5978}, //9973 #CJK UNIFIED IDEOGRAPH
    {0xBCEA, 0x7F04}, //9974 #CJK UNIFIED IDEOGRAPH
    {0xBCEB, 0x8327}, //9975 #CJK UNIFIED IDEOGRAPH
    {0xBCEC, 0x68C0}, //9976 #CJK UNIFIED IDEOGRAPH
    {0xBCED, 0x67EC}, //9977 #CJK UNIFIED IDEOGRAPH
    {0xBCEE, 0x78B1}, //9978 #CJK UNIFIED IDEOGRAPH
    {0xBCEF, 0x7877}, //9979 #CJK UNIFIED IDEOGRAPH
    {0xBCF0, 0x62E3}, //9980 #CJK UNIFIED IDEOGRAPH
    {0xBCF1, 0x6361}, //9981 #CJK UNIFIED IDEOGRAPH
    {0xBCF2, 0x7B80}, //9982 #CJK UNIFIED IDEOGRAPH
    {0xBCF3, 0x4FED}, //9983 #CJK UNIFIED IDEOGRAPH
    {0xBCF4, 0x526A}, //9984 #CJK UNIFIED IDEOGRAPH
    {0xBCF5, 0x51CF}, //9985 #CJK UNIFIED IDEOGRAPH
    {0xBCF6, 0x8350}, //9986 #CJK UNIFIED IDEOGRAPH
    {0xBCF7, 0x69DB}, //9987 #CJK UNIFIED IDEOGRAPH
    {0xBCF8, 0x9274}, //9988 #CJK UNIFIED IDEOGRAPH
    {0xBCF9, 0x8DF5}, //9989 #CJK UNIFIED IDEOGRAPH
    {0xBCFA, 0x8D31}, //9990 #CJK UNIFIED IDEOGRAPH
    {0xBCFB, 0x89C1}, //9991 #CJK UNIFIED IDEOGRAPH
    {0xBCFC, 0x952E}, //9992 #CJK UNIFIED IDEOGRAPH
    {0xBCFD, 0x7BAD}, //9993 #CJK UNIFIED IDEOGRAPH
    {0xBCFE, 0x4EF6}, //9994 #CJK UNIFIED IDEOGRAPH
    {0xBD40, 0x7D37}, //9995 #CJK UNIFIED IDEOGRAPH
    {0xBD41, 0x7D38}, //9996 #CJK UNIFIED IDEOGRAPH
    {0xBD42, 0x7D39}, //9997 #CJK UNIFIED IDEOGRAPH
    {0xBD43, 0x7D3A}, //9998 #CJK UNIFIED IDEOGRAPH
    {0xBD44, 0x7D3B}, //9999 #CJK UNIFIED IDEOGRAPH
    {0xBD45, 0x7D3C}, //10000 #CJK UNIFIED IDEOGRAPH
    {0xBD46, 0x7D3D}, //10001 #CJK UNIFIED IDEOGRAPH
    {0xBD47, 0x7D3E}, //10002 #CJK UNIFIED IDEOGRAPH
    {0xBD48, 0x7D3F}, //10003 #CJK UNIFIED IDEOGRAPH
    {0xBD49, 0x7D40}, //10004 #CJK UNIFIED IDEOGRAPH
    {0xBD4A, 0x7D41}, //10005 #CJK UNIFIED IDEOGRAPH
    {0xBD4B, 0x7D42}, //10006 #CJK UNIFIED IDEOGRAPH
    {0xBD4C, 0x7D43}, //10007 #CJK UNIFIED IDEOGRAPH
    {0xBD4D, 0x7D44}, //10008 #CJK UNIFIED IDEOGRAPH
    {0xBD4E, 0x7D45}, //10009 #CJK UNIFIED IDEOGRAPH
    {0xBD4F, 0x7D46}, //10010 #CJK UNIFIED IDEOGRAPH
    {0xBD50, 0x7D47}, //10011 #CJK UNIFIED IDEOGRAPH
    {0xBD51, 0x7D48}, //10012 #CJK UNIFIED IDEOGRAPH
    {0xBD52, 0x7D49}, //10013 #CJK UNIFIED IDEOGRAPH
    {0xBD53, 0x7D4A}, //10014 #CJK UNIFIED IDEOGRAPH
    {0xBD54, 0x7D4B}, //10015 #CJK UNIFIED IDEOGRAPH
    {0xBD55, 0x7D4C}, //10016 #CJK UNIFIED IDEOGRAPH
    {0xBD56, 0x7D4D}, //10017 #CJK UNIFIED IDEOGRAPH
    {0xBD57, 0x7D4E}, //10018 #CJK UNIFIED IDEOGRAPH
    {0xBD58, 0x7D4F}, //10019 #CJK UNIFIED IDEOGRAPH
    {0xBD59, 0x7D50}, //10020 #CJK UNIFIED IDEOGRAPH
    {0xBD5A, 0x7D51}, //10021 #CJK UNIFIED IDEOGRAPH
    {0xBD5B, 0x7D52}, //10022 #CJK UNIFIED IDEOGRAPH
    {0xBD5C, 0x7D53}, //10023 #CJK UNIFIED IDEOGRAPH
    {0xBD5D, 0x7D54}, //10024 #CJK UNIFIED IDEOGRAPH
    {0xBD5E, 0x7D55}, //10025 #CJK UNIFIED IDEOGRAPH
    {0xBD5F, 0x7D56}, //10026 #CJK UNIFIED IDEOGRAPH
    {0xBD60, 0x7D57}, //10027 #CJK UNIFIED IDEOGRAPH
    {0xBD61, 0x7D58}, //10028 #CJK UNIFIED IDEOGRAPH
    {0xBD62, 0x7D59}, //10029 #CJK UNIFIED IDEOGRAPH
    {0xBD63, 0x7D5A}, //10030 #CJK UNIFIED IDEOGRAPH
    {0xBD64, 0x7D5B}, //10031 #CJK UNIFIED IDEOGRAPH
    {0xBD65, 0x7D5C}, //10032 #CJK UNIFIED IDEOGRAPH
    {0xBD66, 0x7D5D}, //10033 #CJK UNIFIED IDEOGRAPH
    {0xBD67, 0x7D5E}, //10034 #CJK UNIFIED IDEOGRAPH
    {0xBD68, 0x7D5F}, //10035 #CJK UNIFIED IDEOGRAPH
    {0xBD69, 0x7D60}, //10036 #CJK UNIFIED IDEOGRAPH
    {0xBD6A, 0x7D61}, //10037 #CJK UNIFIED IDEOGRAPH
    {0xBD6B, 0x7D62}, //10038 #CJK UNIFIED IDEOGRAPH
    {0xBD6C, 0x7D63}, //10039 #CJK UNIFIED IDEOGRAPH
    {0xBD6D, 0x7D64}, //10040 #CJK UNIFIED IDEOGRAPH
    {0xBD6E, 0x7D65}, //10041 #CJK UNIFIED IDEOGRAPH
    {0xBD6F, 0x7D66}, //10042 #CJK UNIFIED IDEOGRAPH
    {0xBD70, 0x7D67}, //10043 #CJK UNIFIED IDEOGRAPH
    {0xBD71, 0x7D68}, //10044 #CJK UNIFIED IDEOGRAPH
    {0xBD72, 0x7D69}, //10045 #CJK UNIFIED IDEOGRAPH
    {0xBD73, 0x7D6A}, //10046 #CJK UNIFIED IDEOGRAPH
    {0xBD74, 0x7D6B}, //10047 #CJK UNIFIED IDEOGRAPH
    {0xBD75, 0x7D6C}, //10048 #CJK UNIFIED IDEOGRAPH
    {0xBD76, 0x7D6D}, //10049 #CJK UNIFIED IDEOGRAPH
    {0xBD77, 0x7D6F}, //10050 #CJK UNIFIED IDEOGRAPH
    {0xBD78, 0x7D70}, //10051 #CJK UNIFIED IDEOGRAPH
    {0xBD79, 0x7D71}, //10052 #CJK UNIFIED IDEOGRAPH
    {0xBD7A, 0x7D72}, //10053 #CJK UNIFIED IDEOGRAPH
    {0xBD7B, 0x7D73}, //10054 #CJK UNIFIED IDEOGRAPH
    {0xBD7C, 0x7D74}, //10055 #CJK UNIFIED IDEOGRAPH
    {0xBD7D, 0x7D75}, //10056 #CJK UNIFIED IDEOGRAPH
    {0xBD7E, 0x7D76}, //10057 #CJK UNIFIED IDEOGRAPH
    {0xBD80, 0x7D78}, //10058 #CJK UNIFIED IDEOGRAPH
    {0xBD81, 0x7D79}, //10059 #CJK UNIFIED IDEOGRAPH
    {0xBD82, 0x7D7A}, //10060 #CJK UNIFIED IDEOGRAPH
    {0xBD83, 0x7D7B}, //10061 #CJK UNIFIED IDEOGRAPH
    {0xBD84, 0x7D7C}, //10062 #CJK UNIFIED IDEOGRAPH
    {0xBD85, 0x7D7D}, //10063 #CJK UNIFIED IDEOGRAPH
    {0xBD86, 0x7D7E}, //10064 #CJK UNIFIED IDEOGRAPH
    {0xBD87, 0x7D7F}, //10065 #CJK UNIFIED IDEOGRAPH
    {0xBD88, 0x7D80}, //10066 #CJK UNIFIED IDEOGRAPH
    {0xBD89, 0x7D81}, //10067 #CJK UNIFIED IDEOGRAPH
    {0xBD8A, 0x7D82}, //10068 #CJK UNIFIED IDEOGRAPH
    {0xBD8B, 0x7D83}, //10069 #CJK UNIFIED IDEOGRAPH
    {0xBD8C, 0x7D84}, //10070 #CJK UNIFIED IDEOGRAPH
    {0xBD8D, 0x7D85}, //10071 #CJK UNIFIED IDEOGRAPH
    {0xBD8E, 0x7D86}, //10072 #CJK UNIFIED IDEOGRAPH
    {0xBD8F, 0x7D87}, //10073 #CJK UNIFIED IDEOGRAPH
    {0xBD90, 0x7D88}, //10074 #CJK UNIFIED IDEOGRAPH
    {0xBD91, 0x7D89}, //10075 #CJK UNIFIED IDEOGRAPH
    {0xBD92, 0x7D8A}, //10076 #CJK UNIFIED IDEOGRAPH
    {0xBD93, 0x7D8B}, //10077 #CJK UNIFIED IDEOGRAPH
    {0xBD94, 0x7D8C}, //10078 #CJK UNIFIED IDEOGRAPH
    {0xBD95, 0x7D8D}, //10079 #CJK UNIFIED IDEOGRAPH
    {0xBD96, 0x7D8E}, //10080 #CJK UNIFIED IDEOGRAPH
    {0xBD97, 0x7D8F}, //10081 #CJK UNIFIED IDEOGRAPH
    {0xBD98, 0x7D90}, //10082 #CJK UNIFIED IDEOGRAPH
    {0xBD99, 0x7D91}, //10083 #CJK UNIFIED IDEOGRAPH
    {0xBD9A, 0x7D92}, //10084 #CJK UNIFIED IDEOGRAPH
    {0xBD9B, 0x7D93}, //10085 #CJK UNIFIED IDEOGRAPH
    {0xBD9C, 0x7D94}, //10086 #CJK UNIFIED IDEOGRAPH
    {0xBD9D, 0x7D95}, //10087 #CJK UNIFIED IDEOGRAPH
    {0xBD9E, 0x7D96}, //10088 #CJK UNIFIED IDEOGRAPH
    {0xBD9F, 0x7D97}, //10089 #CJK UNIFIED IDEOGRAPH
    {0xBDA0, 0x7D98}, //10090 #CJK UNIFIED IDEOGRAPH
    {0xBDA1, 0x5065}, //10091 #CJK UNIFIED IDEOGRAPH
    {0xBDA2, 0x8230}, //10092 #CJK UNIFIED IDEOGRAPH
    {0xBDA3, 0x5251}, //10093 #CJK UNIFIED IDEOGRAPH
    {0xBDA4, 0x996F}, //10094 #CJK UNIFIED IDEOGRAPH
    {0xBDA5, 0x6E10}, //10095 #CJK UNIFIED IDEOGRAPH
    {0xBDA6, 0x6E85}, //10096 #CJK UNIFIED IDEOGRAPH
    {0xBDA7, 0x6DA7}, //10097 #CJK UNIFIED IDEOGRAPH
    {0xBDA8, 0x5EFA}, //10098 #CJK UNIFIED IDEOGRAPH
    {0xBDA9, 0x50F5}, //10099 #CJK UNIFIED IDEOGRAPH
    {0xBDAA, 0x59DC}, //10100 #CJK UNIFIED IDEOGRAPH
    {0xBDAB, 0x5C06}, //10101 #CJK UNIFIED IDEOGRAPH
    {0xBDAC, 0x6D46}, //10102 #CJK UNIFIED IDEOGRAPH
    {0xBDAD, 0x6C5F}, //10103 #CJK UNIFIED IDEOGRAPH
    {0xBDAE, 0x7586}, //10104 #CJK UNIFIED IDEOGRAPH
    {0xBDAF, 0x848B}, //10105 #CJK UNIFIED IDEOGRAPH
    {0xBDB0, 0x6868}, //10106 #CJK UNIFIED IDEOGRAPH
    {0xBDB1, 0x5956}, //10107 #CJK UNIFIED IDEOGRAPH
    {0xBDB2, 0x8BB2}, //10108 #CJK UNIFIED IDEOGRAPH
    {0xBDB3, 0x5320}, //10109 #CJK UNIFIED IDEOGRAPH
    {0xBDB4, 0x9171}, //10110 #CJK UNIFIED IDEOGRAPH
    {0xBDB5, 0x964D}, //10111 #CJK UNIFIED IDEOGRAPH
    {0xBDB6, 0x8549}, //10112 #CJK UNIFIED IDEOGRAPH
    {0xBDB7, 0x6912}, //10113 #CJK UNIFIED IDEOGRAPH
    {0xBDB8, 0x7901}, //10114 #CJK UNIFIED IDEOGRAPH
    {0xBDB9, 0x7126}, //10115 #CJK UNIFIED IDEOGRAPH
    {0xBDBA, 0x80F6}, //10116 #CJK UNIFIED IDEOGRAPH
    {0xBDBB, 0x4EA4}, //10117 #CJK UNIFIED IDEOGRAPH
    {0xBDBC, 0x90CA}, //10118 #CJK UNIFIED IDEOGRAPH
    {0xBDBD, 0x6D47}, //10119 #CJK UNIFIED IDEOGRAPH
    {0xBDBE, 0x9A84}, //10120 #CJK UNIFIED IDEOGRAPH
    {0xBDBF, 0x5A07}, //10121 #CJK UNIFIED IDEOGRAPH
    {0xBDC0, 0x56BC}, //10122 #CJK UNIFIED IDEOGRAPH
    {0xBDC1, 0x6405}, //10123 #CJK UNIFIED IDEOGRAPH
    {0xBDC2, 0x94F0}, //10124 #CJK UNIFIED IDEOGRAPH
    {0xBDC3, 0x77EB}, //10125 #CJK UNIFIED IDEOGRAPH
    {0xBDC4, 0x4FA5}, //10126 #CJK UNIFIED IDEOGRAPH
    {0xBDC5, 0x811A}, //10127 #CJK UNIFIED IDEOGRAPH
    {0xBDC6, 0x72E1}, //10128 #CJK UNIFIED IDEOGRAPH
    {0xBDC7, 0x89D2}, //10129 #CJK UNIFIED IDEOGRAPH
    {0xBDC8, 0x997A}, //10130 #CJK UNIFIED IDEOGRAPH
    {0xBDC9, 0x7F34}, //10131 #CJK UNIFIED IDEOGRAPH
    {0xBDCA, 0x7EDE}, //10132 #CJK UNIFIED IDEOGRAPH
    {0xBDCB, 0x527F}, //10133 #CJK UNIFIED IDEOGRAPH
    {0xBDCC, 0x6559}, //10134 #CJK UNIFIED IDEOGRAPH
    {0xBDCD, 0x9175}, //10135 #CJK UNIFIED IDEOGRAPH
    {0xBDCE, 0x8F7F}, //10136 #CJK UNIFIED IDEOGRAPH
    {0xBDCF, 0x8F83}, //10137 #CJK UNIFIED IDEOGRAPH
    {0xBDD0, 0x53EB}, //10138 #CJK UNIFIED IDEOGRAPH
    {0xBDD1, 0x7A96}, //10139 #CJK UNIFIED IDEOGRAPH
    {0xBDD2, 0x63ED}, //10140 #CJK UNIFIED IDEOGRAPH
    {0xBDD3, 0x63A5}, //10141 #CJK UNIFIED IDEOGRAPH
    {0xBDD4, 0x7686}, //10142 #CJK UNIFIED IDEOGRAPH
    {0xBDD5, 0x79F8}, //10143 #CJK UNIFIED IDEOGRAPH
    {0xBDD6, 0x8857}, //10144 #CJK UNIFIED IDEOGRAPH
    {0xBDD7, 0x9636}, //10145 #CJK UNIFIED IDEOGRAPH
    {0xBDD8, 0x622A}, //10146 #CJK UNIFIED IDEOGRAPH
    {0xBDD9, 0x52AB}, //10147 #CJK UNIFIED IDEOGRAPH
    {0xBDDA, 0x8282}, //10148 #CJK UNIFIED IDEOGRAPH
    {0xBDDB, 0x6854}, //10149 #CJK UNIFIED IDEOGRAPH
    {0xBDDC, 0x6770}, //10150 #CJK UNIFIED IDEOGRAPH
    {0xBDDD, 0x6377}, //10151 #CJK UNIFIED IDEOGRAPH
    {0xBDDE, 0x776B}, //10152 #CJK UNIFIED IDEOGRAPH
    {0xBDDF, 0x7AED}, //10153 #CJK UNIFIED IDEOGRAPH
    {0xBDE0, 0x6D01}, //10154 #CJK UNIFIED IDEOGRAPH
    {0xBDE1, 0x7ED3}, //10155 #CJK UNIFIED IDEOGRAPH
    {0xBDE2, 0x89E3}, //10156 #CJK UNIFIED IDEOGRAPH
    {0xBDE3, 0x59D0}, //10157 #CJK UNIFIED IDEOGRAPH
    {0xBDE4, 0x6212}, //10158 #CJK UNIFIED IDEOGRAPH
    {0xBDE5, 0x85C9}, //10159 #CJK UNIFIED IDEOGRAPH
    {0xBDE6, 0x82A5}, //10160 #CJK UNIFIED IDEOGRAPH
    {0xBDE7, 0x754C}, //10161 #CJK UNIFIED IDEOGRAPH
    {0xBDE8, 0x501F}, //10162 #CJK UNIFIED IDEOGRAPH
    {0xBDE9, 0x4ECB}, //10163 #CJK UNIFIED IDEOGRAPH
    {0xBDEA, 0x75A5}, //10164 #CJK UNIFIED IDEOGRAPH
    {0xBDEB, 0x8BEB}, //10165 #CJK UNIFIED IDEOGRAPH
    {0xBDEC, 0x5C4A}, //10166 #CJK UNIFIED IDEOGRAPH
    {0xBDED, 0x5DFE}, //10167 #CJK UNIFIED IDEOGRAPH
    {0xBDEE, 0x7B4B}, //10168 #CJK UNIFIED IDEOGRAPH
    {0xBDEF, 0x65A4}, //10169 #CJK UNIFIED IDEOGRAPH
    {0xBDF0, 0x91D1}, //10170 #CJK UNIFIED IDEOGRAPH
    {0xBDF1, 0x4ECA}, //10171 #CJK UNIFIED IDEOGRAPH
    {0xBDF2, 0x6D25}, //10172 #CJK UNIFIED IDEOGRAPH
    {0xBDF3, 0x895F}, //10173 #CJK UNIFIED IDEOGRAPH
    {0xBDF4, 0x7D27}, //10174 #CJK UNIFIED IDEOGRAPH
    {0xBDF5, 0x9526}, //10175 #CJK UNIFIED IDEOGRAPH
    {0xBDF6, 0x4EC5}, //10176 #CJK UNIFIED IDEOGRAPH
    {0xBDF7, 0x8C28}, //10177 #CJK UNIFIED IDEOGRAPH
    {0xBDF8, 0x8FDB}, //10178 #CJK UNIFIED IDEOGRAPH
    {0xBDF9, 0x9773}, //10179 #CJK UNIFIED IDEOGRAPH
    {0xBDFA, 0x664B}, //10180 #CJK UNIFIED IDEOGRAPH
    {0xBDFB, 0x7981}, //10181 #CJK UNIFIED IDEOGRAPH
    {0xBDFC, 0x8FD1}, //10182 #CJK UNIFIED IDEOGRAPH
    {0xBDFD, 0x70EC}, //10183 #CJK UNIFIED IDEOGRAPH
    {0xBDFE, 0x6D78}, //10184 #CJK UNIFIED IDEOGRAPH
    {0xBE40, 0x7D99}, //10185 #CJK UNIFIED IDEOGRAPH
    {0xBE41, 0x7D9A}, //10186 #CJK UNIFIED IDEOGRAPH
    {0xBE42, 0x7D9B}, //10187 #CJK UNIFIED IDEOGRAPH
    {0xBE43, 0x7D9C}, //10188 #CJK UNIFIED IDEOGRAPH
    {0xBE44, 0x7D9D}, //10189 #CJK UNIFIED IDEOGRAPH
    {0xBE45, 0x7D9E}, //10190 #CJK UNIFIED IDEOGRAPH
    {0xBE46, 0x7D9F}, //10191 #CJK UNIFIED IDEOGRAPH
    {0xBE47, 0x7DA0}, //10192 #CJK UNIFIED IDEOGRAPH
    {0xBE48, 0x7DA1}, //10193 #CJK UNIFIED IDEOGRAPH
    {0xBE49, 0x7DA2}, //10194 #CJK UNIFIED IDEOGRAPH
    {0xBE4A, 0x7DA3}, //10195 #CJK UNIFIED IDEOGRAPH
    {0xBE4B, 0x7DA4}, //10196 #CJK UNIFIED IDEOGRAPH
    {0xBE4C, 0x7DA5}, //10197 #CJK UNIFIED IDEOGRAPH
    {0xBE4D, 0x7DA7}, //10198 #CJK UNIFIED IDEOGRAPH
    {0xBE4E, 0x7DA8}, //10199 #CJK UNIFIED IDEOGRAPH
    {0xBE4F, 0x7DA9}, //10200 #CJK UNIFIED IDEOGRAPH
    {0xBE50, 0x7DAA}, //10201 #CJK UNIFIED IDEOGRAPH
    {0xBE51, 0x7DAB}, //10202 #CJK UNIFIED IDEOGRAPH
    {0xBE52, 0x7DAC}, //10203 #CJK UNIFIED IDEOGRAPH
    {0xBE53, 0x7DAD}, //10204 #CJK UNIFIED IDEOGRAPH
    {0xBE54, 0x7DAF}, //10205 #CJK UNIFIED IDEOGRAPH
    {0xBE55, 0x7DB0}, //10206 #CJK UNIFIED IDEOGRAPH
    {0xBE56, 0x7DB1}, //10207 #CJK UNIFIED IDEOGRAPH
    {0xBE57, 0x7DB2}, //10208 #CJK UNIFIED IDEOGRAPH
    {0xBE58, 0x7DB3}, //10209 #CJK UNIFIED IDEOGRAPH
    {0xBE59, 0x7DB4}, //10210 #CJK UNIFIED IDEOGRAPH
    {0xBE5A, 0x7DB5}, //10211 #CJK UNIFIED IDEOGRAPH
    {0xBE5B, 0x7DB6}, //10212 #CJK UNIFIED IDEOGRAPH
    {0xBE5C, 0x7DB7}, //10213 #CJK UNIFIED IDEOGRAPH
    {0xBE5D, 0x7DB8}, //10214 #CJK UNIFIED IDEOGRAPH
    {0xBE5E, 0x7DB9}, //10215 #CJK UNIFIED IDEOGRAPH
    {0xBE5F, 0x7DBA}, //10216 #CJK UNIFIED IDEOGRAPH
    {0xBE60, 0x7DBB}, //10217 #CJK UNIFIED IDEOGRAPH
    {0xBE61, 0x7DBC}, //10218 #CJK UNIFIED IDEOGRAPH
    {0xBE62, 0x7DBD}, //10219 #CJK UNIFIED IDEOGRAPH
    {0xBE63, 0x7DBE}, //10220 #CJK UNIFIED IDEOGRAPH
    {0xBE64, 0x7DBF}, //10221 #CJK UNIFIED IDEOGRAPH
    {0xBE65, 0x7DC0}, //10222 #CJK UNIFIED IDEOGRAPH
    {0xBE66, 0x7DC1}, //10223 #CJK UNIFIED IDEOGRAPH
    {0xBE67, 0x7DC2}, //10224 #CJK UNIFIED IDEOGRAPH
    {0xBE68, 0x7DC3}, //10225 #CJK UNIFIED IDEOGRAPH
    {0xBE69, 0x7DC4}, //10226 #CJK UNIFIED IDEOGRAPH
    {0xBE6A, 0x7DC5}, //10227 #CJK UNIFIED IDEOGRAPH
    {0xBE6B, 0x7DC6}, //10228 #CJK UNIFIED IDEOGRAPH
    {0xBE6C, 0x7DC7}, //10229 #CJK UNIFIED IDEOGRAPH
    {0xBE6D, 0x7DC8}, //10230 #CJK UNIFIED IDEOGRAPH
    {0xBE6E, 0x7DC9}, //10231 #CJK UNIFIED IDEOGRAPH
    {0xBE6F, 0x7DCA}, //10232 #CJK UNIFIED IDEOGRAPH
    {0xBE70, 0x7DCB}, //10233 #CJK UNIFIED IDEOGRAPH
    {0xBE71, 0x7DCC}, //10234 #CJK UNIFIED IDEOGRAPH
    {0xBE72, 0x7DCD}, //10235 #CJK UNIFIED IDEOGRAPH
    {0xBE73, 0x7DCE}, //10236 #CJK UNIFIED IDEOGRAPH
    {0xBE74, 0x7DCF}, //10237 #CJK UNIFIED IDEOGRAPH
    {0xBE75, 0x7DD0}, //10238 #CJK UNIFIED IDEOGRAPH
    {0xBE76, 0x7DD1}, //10239 #CJK UNIFIED IDEOGRAPH
    {0xBE77, 0x7DD2}, //10240 #CJK UNIFIED IDEOGRAPH
    {0xBE78, 0x7DD3}, //10241 #CJK UNIFIED IDEOGRAPH
    {0xBE79, 0x7DD4}, //10242 #CJK UNIFIED IDEOGRAPH
    {0xBE7A, 0x7DD5}, //10243 #CJK UNIFIED IDEOGRAPH
    {0xBE7B, 0x7DD6}, //10244 #CJK UNIFIED IDEOGRAPH
    {0xBE7C, 0x7DD7}, //10245 #CJK UNIFIED IDEOGRAPH
    {0xBE7D, 0x7DD8}, //10246 #CJK UNIFIED IDEOGRAPH
    {0xBE7E, 0x7DD9}, //10247 #CJK UNIFIED IDEOGRAPH
    {0xBE80, 0x7DDA}, //10248 #CJK UNIFIED IDEOGRAPH
    {0xBE81, 0x7DDB}, //10249 #CJK UNIFIED IDEOGRAPH
    {0xBE82, 0x7DDC}, //10250 #CJK UNIFIED IDEOGRAPH
    {0xBE83, 0x7DDD}, //10251 #CJK UNIFIED IDEOGRAPH
    {0xBE84, 0x7DDE}, //10252 #CJK UNIFIED IDEOGRAPH
    {0xBE85, 0x7DDF}, //10253 #CJK UNIFIED IDEOGRAPH
    {0xBE86, 0x7DE0}, //10254 #CJK UNIFIED IDEOGRAPH
    {0xBE87, 0x7DE1}, //10255 #CJK UNIFIED IDEOGRAPH
    {0xBE88, 0x7DE2}, //10256 #CJK UNIFIED IDEOGRAPH
    {0xBE89, 0x7DE3}, //10257 #CJK UNIFIED IDEOGRAPH
    {0xBE8A, 0x7DE4}, //10258 #CJK UNIFIED IDEOGRAPH
    {0xBE8B, 0x7DE5}, //10259 #CJK UNIFIED IDEOGRAPH
    {0xBE8C, 0x7DE6}, //10260 #CJK UNIFIED IDEOGRAPH
    {0xBE8D, 0x7DE7}, //10261 #CJK UNIFIED IDEOGRAPH
    {0xBE8E, 0x7DE8}, //10262 #CJK UNIFIED IDEOGRAPH
    {0xBE8F, 0x7DE9}, //10263 #CJK UNIFIED IDEOGRAPH
    {0xBE90, 0x7DEA}, //10264 #CJK UNIFIED IDEOGRAPH
    {0xBE91, 0x7DEB}, //10265 #CJK UNIFIED IDEOGRAPH
    {0xBE92, 0x7DEC}, //10266 #CJK UNIFIED IDEOGRAPH
    {0xBE93, 0x7DED}, //10267 #CJK UNIFIED IDEOGRAPH
    {0xBE94, 0x7DEE}, //10268 #CJK UNIFIED IDEOGRAPH
    {0xBE95, 0x7DEF}, //10269 #CJK UNIFIED IDEOGRAPH
    {0xBE96, 0x7DF0}, //10270 #CJK UNIFIED IDEOGRAPH
    {0xBE97, 0x7DF1}, //10271 #CJK UNIFIED IDEOGRAPH
    {0xBE98, 0x7DF2}, //10272 #CJK UNIFIED IDEOGRAPH
    {0xBE99, 0x7DF3}, //10273 #CJK UNIFIED IDEOGRAPH
    {0xBE9A, 0x7DF4}, //10274 #CJK UNIFIED IDEOGRAPH
    {0xBE9B, 0x7DF5}, //10275 #CJK UNIFIED IDEOGRAPH
    {0xBE9C, 0x7DF6}, //10276 #CJK UNIFIED IDEOGRAPH
    {0xBE9D, 0x7DF7}, //10277 #CJK UNIFIED IDEOGRAPH
    {0xBE9E, 0x7DF8}, //10278 #CJK UNIFIED IDEOGRAPH
    {0xBE9F, 0x7DF9}, //10279 #CJK UNIFIED IDEOGRAPH
    {0xBEA0, 0x7DFA}, //10280 #CJK UNIFIED IDEOGRAPH
    {0xBEA1, 0x5C3D}, //10281 #CJK UNIFIED IDEOGRAPH
    {0xBEA2, 0x52B2}, //10282 #CJK UNIFIED IDEOGRAPH
    {0xBEA3, 0x8346}, //10283 #CJK UNIFIED IDEOGRAPH
    {0xBEA4, 0x5162}, //10284 #CJK UNIFIED IDEOGRAPH
    {0xBEA5, 0x830E}, //10285 #CJK UNIFIED IDEOGRAPH
    {0xBEA6, 0x775B}, //10286 #CJK UNIFIED IDEOGRAPH
    {0xBEA7, 0x6676}, //10287 #CJK UNIFIED IDEOGRAPH
    {0xBEA8, 0x9CB8}, //10288 #CJK UNIFIED IDEOGRAPH
    {0xBEA9, 0x4EAC}, //10289 #CJK UNIFIED IDEOGRAPH
    {0xBEAA, 0x60CA}, //10290 #CJK UNIFIED IDEOGRAPH
    {0xBEAB, 0x7CBE}, //10291 #CJK UNIFIED IDEOGRAPH
    {0xBEAC, 0x7CB3}, //10292 #CJK UNIFIED IDEOGRAPH
    {0xBEAD, 0x7ECF}, //10293 #CJK UNIFIED IDEOGRAPH
    {0xBEAE, 0x4E95}, //10294 #CJK UNIFIED IDEOGRAPH
    {0xBEAF, 0x8B66}, //10295 #CJK UNIFIED IDEOGRAPH
    {0xBEB0, 0x666F}, //10296 #CJK UNIFIED IDEOGRAPH
    {0xBEB1, 0x9888}, //10297 #CJK UNIFIED IDEOGRAPH
    {0xBEB2, 0x9759}, //10298 #CJK UNIFIED IDEOGRAPH
    {0xBEB3, 0x5883}, //10299 #CJK UNIFIED IDEOGRAPH
    {0xBEB4, 0x656C}, //10300 #CJK UNIFIED IDEOGRAPH
    {0xBEB5, 0x955C}, //10301 #CJK UNIFIED IDEOGRAPH
    {0xBEB6, 0x5F84}, //10302 #CJK UNIFIED IDEOGRAPH
    {0xBEB7, 0x75C9}, //10303 #CJK UNIFIED IDEOGRAPH
    {0xBEB8, 0x9756}, //10304 #CJK UNIFIED IDEOGRAPH
    {0xBEB9, 0x7ADF}, //10305 #CJK UNIFIED IDEOGRAPH
    {0xBEBA, 0x7ADE}, //10306 #CJK UNIFIED IDEOGRAPH
    {0xBEBB, 0x51C0}, //10307 #CJK UNIFIED IDEOGRAPH
    {0xBEBC, 0x70AF}, //10308 #CJK UNIFIED IDEOGRAPH
    {0xBEBD, 0x7A98}, //10309 #CJK UNIFIED IDEOGRAPH
    {0xBEBE, 0x63EA}, //10310 #CJK UNIFIED IDEOGRAPH
    {0xBEBF, 0x7A76}, //10311 #CJK UNIFIED IDEOGRAPH
    {0xBEC0, 0x7EA0}, //10312 #CJK UNIFIED IDEOGRAPH
    {0xBEC1, 0x7396}, //10313 #CJK UNIFIED IDEOGRAPH
    {0xBEC2, 0x97ED}, //10314 #CJK UNIFIED IDEOGRAPH
    {0xBEC3, 0x4E45}, //10315 #CJK UNIFIED IDEOGRAPH
    {0xBEC4, 0x7078}, //10316 #CJK UNIFIED IDEOGRAPH
    {0xBEC5, 0x4E5D}, //10317 #CJK UNIFIED IDEOGRAPH
    {0xBEC6, 0x9152}, //10318 #CJK UNIFIED IDEOGRAPH
    {0xBEC7, 0x53A9}, //10319 #CJK UNIFIED IDEOGRAPH
    {0xBEC8, 0x6551}, //10320 #CJK UNIFIED IDEOGRAPH
    {0xBEC9, 0x65E7}, //10321 #CJK UNIFIED IDEOGRAPH
    {0xBECA, 0x81FC}, //10322 #CJK UNIFIED IDEOGRAPH
    {0xBECB, 0x8205}, //10323 #CJK UNIFIED IDEOGRAPH
    {0xBECC, 0x548E}, //10324 #CJK UNIFIED IDEOGRAPH
    {0xBECD, 0x5C31}, //10325 #CJK UNIFIED IDEOGRAPH
    {0xBECE, 0x759A}, //10326 #CJK UNIFIED IDEOGRAPH
    {0xBECF, 0x97A0}, //10327 #CJK UNIFIED IDEOGRAPH
    {0xBED0, 0x62D8}, //10328 #CJK UNIFIED IDEOGRAPH
    {0xBED1, 0x72D9}, //10329 #CJK UNIFIED IDEOGRAPH
    {0xBED2, 0x75BD}, //10330 #CJK UNIFIED IDEOGRAPH
    {0xBED3, 0x5C45}, //10331 #CJK UNIFIED IDEOGRAPH
    {0xBED4, 0x9A79}, //10332 #CJK UNIFIED IDEOGRAPH
    {0xBED5, 0x83CA}, //10333 #CJK UNIFIED IDEOGRAPH
    {0xBED6, 0x5C40}, //10334 #CJK UNIFIED IDEOGRAPH
    {0xBED7, 0x5480}, //10335 #CJK UNIFIED IDEOGRAPH
    {0xBED8, 0x77E9}, //10336 #CJK UNIFIED IDEOGRAPH
    {0xBED9, 0x4E3E}, //10337 #CJK UNIFIED IDEOGRAPH
    {0xBEDA, 0x6CAE}, //10338 #CJK UNIFIED IDEOGRAPH
    {0xBEDB, 0x805A}, //10339 #CJK UNIFIED IDEOGRAPH
    {0xBEDC, 0x62D2}, //10340 #CJK UNIFIED IDEOGRAPH
    {0xBEDD, 0x636E}, //10341 #CJK UNIFIED IDEOGRAPH
    {0xBEDE, 0x5DE8}, //10342 #CJK UNIFIED IDEOGRAPH
    {0xBEDF, 0x5177}, //10343 #CJK UNIFIED IDEOGRAPH
    {0xBEE0, 0x8DDD}, //10344 #CJK UNIFIED IDEOGRAPH
    {0xBEE1, 0x8E1E}, //10345 #CJK UNIFIED IDEOGRAPH
    {0xBEE2, 0x952F}, //10346 #CJK UNIFIED IDEOGRAPH
    {0xBEE3, 0x4FF1}, //10347 #CJK UNIFIED IDEOGRAPH
    {0xBEE4, 0x53E5}, //10348 #CJK UNIFIED IDEOGRAPH
    {0xBEE5, 0x60E7}, //10349 #CJK UNIFIED IDEOGRAPH
    {0xBEE6, 0x70AC}, //10350 #CJK UNIFIED IDEOGRAPH
    {0xBEE7, 0x5267}, //10351 #CJK UNIFIED IDEOGRAPH
    {0xBEE8, 0x6350}, //10352 #CJK UNIFIED IDEOGRAPH
    {0xBEE9, 0x9E43}, //10353 #CJK UNIFIED IDEOGRAPH
    {0xBEEA, 0x5A1F}, //10354 #CJK UNIFIED IDEOGRAPH
    {0xBEEB, 0x5026}, //10355 #CJK UNIFIED IDEOGRAPH
    {0xBEEC, 0x7737}, //10356 #CJK UNIFIED IDEOGRAPH
    {0xBEED, 0x5377}, //10357 #CJK UNIFIED IDEOGRAPH
    {0xBEEE, 0x7EE2}, //10358 #CJK UNIFIED IDEOGRAPH
    {0xBEEF, 0x6485}, //10359 #CJK UNIFIED IDEOGRAPH
    {0xBEF0, 0x652B}, //10360 #CJK UNIFIED IDEOGRAPH
    {0xBEF1, 0x6289}, //10361 #CJK UNIFIED IDEOGRAPH
    {0xBEF2, 0x6398}, //10362 #CJK UNIFIED IDEOGRAPH
    {0xBEF3, 0x5014}, //10363 #CJK UNIFIED IDEOGRAPH
    {0xBEF4, 0x7235}, //10364 #CJK UNIFIED IDEOGRAPH
    {0xBEF5, 0x89C9}, //10365 #CJK UNIFIED IDEOGRAPH
    {0xBEF6, 0x51B3}, //10366 #CJK UNIFIED IDEOGRAPH
    {0xBEF7, 0x8BC0}, //10367 #CJK UNIFIED IDEOGRAPH
    {0xBEF8, 0x7EDD}, //10368 #CJK UNIFIED IDEOGRAPH
    {0xBEF9, 0x5747}, //10369 #CJK UNIFIED IDEOGRAPH
    {0xBEFA, 0x83CC}, //10370 #CJK UNIFIED IDEOGRAPH
    {0xBEFB, 0x94A7}, //10371 #CJK UNIFIED IDEOGRAPH
    {0xBEFC, 0x519B}, //10372 #CJK UNIFIED IDEOGRAPH
    {0xBEFD, 0x541B}, //10373 #CJK UNIFIED IDEOGRAPH
    {0xBEFE, 0x5CFB}, //10374 #CJK UNIFIED IDEOGRAPH
    {0xBF40, 0x7DFB}, //10375 #CJK UNIFIED IDEOGRAPH
    {0xBF41, 0x7DFC}, //10376 #CJK UNIFIED IDEOGRAPH
    {0xBF42, 0x7DFD}, //10377 #CJK UNIFIED IDEOGRAPH
    {0xBF43, 0x7DFE}, //10378 #CJK UNIFIED IDEOGRAPH
    {0xBF44, 0x7DFF}, //10379 #CJK UNIFIED IDEOGRAPH
    {0xBF45, 0x7E00}, //10380 #CJK UNIFIED IDEOGRAPH
    {0xBF46, 0x7E01}, //10381 #CJK UNIFIED IDEOGRAPH
    {0xBF47, 0x7E02}, //10382 #CJK UNIFIED IDEOGRAPH
    {0xBF48, 0x7E03}, //10383 #CJK UNIFIED IDEOGRAPH
    {0xBF49, 0x7E04}, //10384 #CJK UNIFIED IDEOGRAPH
    {0xBF4A, 0x7E05}, //10385 #CJK UNIFIED IDEOGRAPH
    {0xBF4B, 0x7E06}, //10386 #CJK UNIFIED IDEOGRAPH
    {0xBF4C, 0x7E07}, //10387 #CJK UNIFIED IDEOGRAPH
    {0xBF4D, 0x7E08}, //10388 #CJK UNIFIED IDEOGRAPH
    {0xBF4E, 0x7E09}, //10389 #CJK UNIFIED IDEOGRAPH
    {0xBF4F, 0x7E0A}, //10390 #CJK UNIFIED IDEOGRAPH
    {0xBF50, 0x7E0B}, //10391 #CJK UNIFIED IDEOGRAPH
    {0xBF51, 0x7E0C}, //10392 #CJK UNIFIED IDEOGRAPH
    {0xBF52, 0x7E0D}, //10393 #CJK UNIFIED IDEOGRAPH
    {0xBF53, 0x7E0E}, //10394 #CJK UNIFIED IDEOGRAPH
    {0xBF54, 0x7E0F}, //10395 #CJK UNIFIED IDEOGRAPH
    {0xBF55, 0x7E10}, //10396 #CJK UNIFIED IDEOGRAPH
    {0xBF56, 0x7E11}, //10397 #CJK UNIFIED IDEOGRAPH
    {0xBF57, 0x7E12}, //10398 #CJK UNIFIED IDEOGRAPH
    {0xBF58, 0x7E13}, //10399 #CJK UNIFIED IDEOGRAPH
    {0xBF59, 0x7E14}, //10400 #CJK UNIFIED IDEOGRAPH
    {0xBF5A, 0x7E15}, //10401 #CJK UNIFIED IDEOGRAPH
    {0xBF5B, 0x7E16}, //10402 #CJK UNIFIED IDEOGRAPH
    {0xBF5C, 0x7E17}, //10403 #CJK UNIFIED IDEOGRAPH
    {0xBF5D, 0x7E18}, //10404 #CJK UNIFIED IDEOGRAPH
    {0xBF5E, 0x7E19}, //10405 #CJK UNIFIED IDEOGRAPH
    {0xBF5F, 0x7E1A}, //10406 #CJK UNIFIED IDEOGRAPH
    {0xBF60, 0x7E1B}, //10407 #CJK UNIFIED IDEOGRAPH
    {0xBF61, 0x7E1C}, //10408 #CJK UNIFIED IDEOGRAPH
    {0xBF62, 0x7E1D}, //10409 #CJK UNIFIED IDEOGRAPH
    {0xBF63, 0x7E1E}, //10410 #CJK UNIFIED IDEOGRAPH
    {0xBF64, 0x7E1F}, //10411 #CJK UNIFIED IDEOGRAPH
    {0xBF65, 0x7E20}, //10412 #CJK UNIFIED IDEOGRAPH
    {0xBF66, 0x7E21}, //10413 #CJK UNIFIED IDEOGRAPH
    {0xBF67, 0x7E22}, //10414 #CJK UNIFIED IDEOGRAPH
    {0xBF68, 0x7E23}, //10415 #CJK UNIFIED IDEOGRAPH
    {0xBF69, 0x7E24}, //10416 #CJK UNIFIED IDEOGRAPH
    {0xBF6A, 0x7E25}, //10417 #CJK UNIFIED IDEOGRAPH
    {0xBF6B, 0x7E26}, //10418 #CJK UNIFIED IDEOGRAPH
    {0xBF6C, 0x7E27}, //10419 #CJK UNIFIED IDEOGRAPH
    {0xBF6D, 0x7E28}, //10420 #CJK UNIFIED IDEOGRAPH
    {0xBF6E, 0x7E29}, //10421 #CJK UNIFIED IDEOGRAPH
    {0xBF6F, 0x7E2A}, //10422 #CJK UNIFIED IDEOGRAPH
    {0xBF70, 0x7E2B}, //10423 #CJK UNIFIED IDEOGRAPH
    {0xBF71, 0x7E2C}, //10424 #CJK UNIFIED IDEOGRAPH
    {0xBF72, 0x7E2D}, //10425 #CJK UNIFIED IDEOGRAPH
    {0xBF73, 0x7E2E}, //10426 #CJK UNIFIED IDEOGRAPH
    {0xBF74, 0x7E2F}, //10427 #CJK UNIFIED IDEOGRAPH
    {0xBF75, 0x7E30}, //10428 #CJK UNIFIED IDEOGRAPH
    {0xBF76, 0x7E31}, //10429 #CJK UNIFIED IDEOGRAPH
    {0xBF77, 0x7E32}, //10430 #CJK UNIFIED IDEOGRAPH
    {0xBF78, 0x7E33}, //10431 #CJK UNIFIED IDEOGRAPH
    {0xBF79, 0x7E34}, //10432 #CJK UNIFIED IDEOGRAPH
    {0xBF7A, 0x7E35}, //10433 #CJK UNIFIED IDEOGRAPH
    {0xBF7B, 0x7E36}, //10434 #CJK UNIFIED IDEOGRAPH
    {0xBF7C, 0x7E37}, //10435 #CJK UNIFIED IDEOGRAPH
    {0xBF7D, 0x7E38}, //10436 #CJK UNIFIED IDEOGRAPH
    {0xBF7E, 0x7E39}, //10437 #CJK UNIFIED IDEOGRAPH
    {0xBF80, 0x7E3A}, //10438 #CJK UNIFIED IDEOGRAPH
    {0xBF81, 0x7E3C}, //10439 #CJK UNIFIED IDEOGRAPH
    {0xBF82, 0x7E3D}, //10440 #CJK UNIFIED IDEOGRAPH
    {0xBF83, 0x7E3E}, //10441 #CJK UNIFIED IDEOGRAPH
    {0xBF84, 0x7E3F}, //10442 #CJK UNIFIED IDEOGRAPH
    {0xBF85, 0x7E40}, //10443 #CJK UNIFIED IDEOGRAPH
    {0xBF86, 0x7E42}, //10444 #CJK UNIFIED IDEOGRAPH
    {0xBF87, 0x7E43}, //10445 #CJK UNIFIED IDEOGRAPH
    {0xBF88, 0x7E44}, //10446 #CJK UNIFIED IDEOGRAPH
    {0xBF89, 0x7E45}, //10447 #CJK UNIFIED IDEOGRAPH
    {0xBF8A, 0x7E46}, //10448 #CJK UNIFIED IDEOGRAPH
    {0xBF8B, 0x7E48}, //10449 #CJK UNIFIED IDEOGRAPH
    {0xBF8C, 0x7E49}, //10450 #CJK UNIFIED IDEOGRAPH
    {0xBF8D, 0x7E4A}, //10451 #CJK UNIFIED IDEOGRAPH
    {0xBF8E, 0x7E4B}, //10452 #CJK UNIFIED IDEOGRAPH
    {0xBF8F, 0x7E4C}, //10453 #CJK UNIFIED IDEOGRAPH
    {0xBF90, 0x7E4D}, //10454 #CJK UNIFIED IDEOGRAPH
    {0xBF91, 0x7E4E}, //10455 #CJK UNIFIED IDEOGRAPH
    {0xBF92, 0x7E4F}, //10456 #CJK UNIFIED IDEOGRAPH
    {0xBF93, 0x7E50}, //10457 #CJK UNIFIED IDEOGRAPH
    {0xBF94, 0x7E51}, //10458 #CJK UNIFIED IDEOGRAPH
    {0xBF95, 0x7E52}, //10459 #CJK UNIFIED IDEOGRAPH
    {0xBF96, 0x7E53}, //10460 #CJK UNIFIED IDEOGRAPH
    {0xBF97, 0x7E54}, //10461 #CJK UNIFIED IDEOGRAPH
    {0xBF98, 0x7E55}, //10462 #CJK UNIFIED IDEOGRAPH
    {0xBF99, 0x7E56}, //10463 #CJK UNIFIED IDEOGRAPH
    {0xBF9A, 0x7E57}, //10464 #CJK UNIFIED IDEOGRAPH
    {0xBF9B, 0x7E58}, //10465 #CJK UNIFIED IDEOGRAPH
    {0xBF9C, 0x7E59}, //10466 #CJK UNIFIED IDEOGRAPH
    {0xBF9D, 0x7E5A}, //10467 #CJK UNIFIED IDEOGRAPH
    {0xBF9E, 0x7E5B}, //10468 #CJK UNIFIED IDEOGRAPH
    {0xBF9F, 0x7E5C}, //10469 #CJK UNIFIED IDEOGRAPH
    {0xBFA0, 0x7E5D}, //10470 #CJK UNIFIED IDEOGRAPH
    {0xBFA1, 0x4FCA}, //10471 #CJK UNIFIED IDEOGRAPH
    {0xBFA2, 0x7AE3}, //10472 #CJK UNIFIED IDEOGRAPH
    {0xBFA3, 0x6D5A}, //10473 #CJK UNIFIED IDEOGRAPH
    {0xBFA4, 0x90E1}, //10474 #CJK UNIFIED IDEOGRAPH
    {0xBFA5, 0x9A8F}, //10475 #CJK UNIFIED IDEOGRAPH
    {0xBFA6, 0x5580}, //10476 #CJK UNIFIED IDEOGRAPH
    {0xBFA7, 0x5496}, //10477 #CJK UNIFIED IDEOGRAPH
    {0xBFA8, 0x5361}, //10478 #CJK UNIFIED IDEOGRAPH
    {0xBFA9, 0x54AF}, //10479 #CJK UNIFIED IDEOGRAPH
    {0xBFAA, 0x5F00}, //10480 #CJK UNIFIED IDEOGRAPH
    {0xBFAB, 0x63E9}, //10481 #CJK UNIFIED IDEOGRAPH
    {0xBFAC, 0x6977}, //10482 #CJK UNIFIED IDEOGRAPH
    {0xBFAD, 0x51EF}, //10483 #CJK UNIFIED IDEOGRAPH
    {0xBFAE, 0x6168}, //10484 #CJK UNIFIED IDEOGRAPH
    {0xBFAF, 0x520A}, //10485 #CJK UNIFIED IDEOGRAPH
    {0xBFB0, 0x582A}, //10486 #CJK UNIFIED IDEOGRAPH
    {0xBFB1, 0x52D8}, //10487 #CJK UNIFIED IDEOGRAPH
    {0xBFB2, 0x574E}, //10488 #CJK UNIFIED IDEOGRAPH
    {0xBFB3, 0x780D}, //10489 #CJK UNIFIED IDEOGRAPH
    {0xBFB4, 0x770B}, //10490 #CJK UNIFIED IDEOGRAPH
    {0xBFB5, 0x5EB7}, //10491 #CJK UNIFIED IDEOGRAPH
    {0xBFB6, 0x6177}, //10492 #CJK UNIFIED IDEOGRAPH
    {0xBFB7, 0x7CE0}, //10493 #CJK UNIFIED IDEOGRAPH
    {0xBFB8, 0x625B}, //10494 #CJK UNIFIED IDEOGRAPH
    {0xBFB9, 0x6297}, //10495 #CJK UNIFIED IDEOGRAPH
    {0xBFBA, 0x4EA2}, //10496 #CJK UNIFIED IDEOGRAPH
    {0xBFBB, 0x7095}, //10497 #CJK UNIFIED IDEOGRAPH
    {0xBFBC, 0x8003}, //10498 #CJK UNIFIED IDEOGRAPH
    {0xBFBD, 0x62F7}, //10499 #CJK UNIFIED IDEOGRAPH
    {0xBFBE, 0x70E4}, //10500 #CJK UNIFIED IDEOGRAPH
    {0xBFBF, 0x9760}, //10501 #CJK UNIFIED IDEOGRAPH
    {0xBFC0, 0x5777}, //10502 #CJK UNIFIED IDEOGRAPH
    {0xBFC1, 0x82DB}, //10503 #CJK UNIFIED IDEOGRAPH
    {0xBFC2, 0x67EF}, //10504 #CJK UNIFIED IDEOGRAPH
    {0xBFC3, 0x68F5}, //10505 #CJK UNIFIED IDEOGRAPH
    {0xBFC4, 0x78D5}, //10506 #CJK UNIFIED IDEOGRAPH
    {0xBFC5, 0x9897}, //10507 #CJK UNIFIED IDEOGRAPH
    {0xBFC6, 0x79D1}, //10508 #CJK UNIFIED IDEOGRAPH
    {0xBFC7, 0x58F3}, //10509 #CJK UNIFIED IDEOGRAPH
    {0xBFC8, 0x54B3}, //10510 #CJK UNIFIED IDEOGRAPH
    {0xBFC9, 0x53EF}, //10511 #CJK UNIFIED IDEOGRAPH
    {0xBFCA, 0x6E34}, //10512 #CJK UNIFIED IDEOGRAPH
    {0xBFCB, 0x514B}, //10513 #CJK UNIFIED IDEOGRAPH
    {0xBFCC, 0x523B}, //10514 #CJK UNIFIED IDEOGRAPH
    {0xBFCD, 0x5BA2}, //10515 #CJK UNIFIED IDEOGRAPH
    {0xBFCE, 0x8BFE}, //10516 #CJK UNIFIED IDEOGRAPH
    {0xBFCF, 0x80AF}, //10517 #CJK UNIFIED IDEOGRAPH
    {0xBFD0, 0x5543}, //10518 #CJK UNIFIED IDEOGRAPH
    {0xBFD1, 0x57A6}, //10519 #CJK UNIFIED IDEOGRAPH
    {0xBFD2, 0x6073}, //10520 #CJK UNIFIED IDEOGRAPH
    {0xBFD3, 0x5751}, //10521 #CJK UNIFIED IDEOGRAPH
    {0xBFD4, 0x542D}, //10522 #CJK UNIFIED IDEOGRAPH
    {0xBFD5, 0x7A7A}, //10523 #CJK UNIFIED IDEOGRAPH
    {0xBFD6, 0x6050}, //10524 #CJK UNIFIED IDEOGRAPH
    {0xBFD7, 0x5B54}, //10525 #CJK UNIFIED IDEOGRAPH
    {0xBFD8, 0x63A7}, //10526 #CJK UNIFIED IDEOGRAPH
    {0xBFD9, 0x62A0}, //10527 #CJK UNIFIED IDEOGRAPH
    {0xBFDA, 0x53E3}, //10528 #CJK UNIFIED IDEOGRAPH
    {0xBFDB, 0x6263}, //10529 #CJK UNIFIED IDEOGRAPH
    {0xBFDC, 0x5BC7}, //10530 #CJK UNIFIED IDEOGRAPH
    {0xBFDD, 0x67AF}, //10531 #CJK UNIFIED IDEOGRAPH
    {0xBFDE, 0x54ED}, //10532 #CJK UNIFIED IDEOGRAPH
    {0xBFDF, 0x7A9F}, //10533 #CJK UNIFIED IDEOGRAPH
    {0xBFE0, 0x82E6}, //10534 #CJK UNIFIED IDEOGRAPH
    {0xBFE1, 0x9177}, //10535 #CJK UNIFIED IDEOGRAPH
    {0xBFE2, 0x5E93}, //10536 #CJK UNIFIED IDEOGRAPH
    {0xBFE3, 0x88E4}, //10537 #CJK UNIFIED IDEOGRAPH
    {0xBFE4, 0x5938}, //10538 #CJK UNIFIED IDEOGRAPH
    {0xBFE5, 0x57AE}, //10539 #CJK UNIFIED IDEOGRAPH
    {0xBFE6, 0x630E}, //10540 #CJK UNIFIED IDEOGRAPH
    {0xBFE7, 0x8DE8}, //10541 #CJK UNIFIED IDEOGRAPH
    {0xBFE8, 0x80EF}, //10542 #CJK UNIFIED IDEOGRAPH
    {0xBFE9, 0x5757}, //10543 #CJK UNIFIED IDEOGRAPH
    {0xBFEA, 0x7B77}, //10544 #CJK UNIFIED IDEOGRAPH
    {0xBFEB, 0x4FA9}, //10545 #CJK UNIFIED IDEOGRAPH
    {0xBFEC, 0x5FEB}, //10546 #CJK UNIFIED IDEOGRAPH
    {0xBFED, 0x5BBD}, //10547 #CJK UNIFIED IDEOGRAPH
    {0xBFEE, 0x6B3E}, //10548 #CJK UNIFIED IDEOGRAPH
    {0xBFEF, 0x5321}, //10549 #CJK UNIFIED IDEOGRAPH
    {0xBFF0, 0x7B50}, //10550 #CJK UNIFIED IDEOGRAPH
    {0xBFF1, 0x72C2}, //10551 #CJK UNIFIED IDEOGRAPH
    {0xBFF2, 0x6846}, //10552 #CJK UNIFIED IDEOGRAPH
    {0xBFF3, 0x77FF}, //10553 #CJK UNIFIED IDEOGRAPH
    {0xBFF4, 0x7736}, //10554 #CJK UNIFIED IDEOGRAPH
    {0xBFF5, 0x65F7}, //10555 #CJK UNIFIED IDEOGRAPH
    {0xBFF6, 0x51B5}, //10556 #CJK UNIFIED IDEOGRAPH
    {0xBFF7, 0x4E8F}, //10557 #CJK UNIFIED IDEOGRAPH
    {0xBFF8, 0x76D4}, //10558 #CJK UNIFIED IDEOGRAPH
    {0xBFF9, 0x5CBF}, //10559 #CJK UNIFIED IDEOGRAPH
    {0xBFFA, 0x7AA5}, //10560 #CJK UNIFIED IDEOGRAPH
    {0xBFFB, 0x8475}, //10561 #CJK UNIFIED IDEOGRAPH
    {0xBFFC, 0x594E}, //10562 #CJK UNIFIED IDEOGRAPH
    {0xBFFD, 0x9B41}, //10563 #CJK UNIFIED IDEOGRAPH
    {0xBFFE, 0x5080}, //10564 #CJK UNIFIED IDEOGRAPH
    {0xC040, 0x7E5E}, //10565 #CJK UNIFIED IDEOGRAPH
    {0xC041, 0x7E5F}, //10566 #CJK UNIFIED IDEOGRAPH
    {0xC042, 0x7E60}, //10567 #CJK UNIFIED IDEOGRAPH
    {0xC043, 0x7E61}, //10568 #CJK UNIFIED IDEOGRAPH
    {0xC044, 0x7E62}, //10569 #CJK UNIFIED IDEOGRAPH
    {0xC045, 0x7E63}, //10570 #CJK UNIFIED IDEOGRAPH
    {0xC046, 0x7E64}, //10571 #CJK UNIFIED IDEOGRAPH
    {0xC047, 0x7E65}, //10572 #CJK UNIFIED IDEOGRAPH
    {0xC048, 0x7E66}, //10573 #CJK UNIFIED IDEOGRAPH
    {0xC049, 0x7E67}, //10574 #CJK UNIFIED IDEOGRAPH
    {0xC04A, 0x7E68}, //10575 #CJK UNIFIED IDEOGRAPH
    {0xC04B, 0x7E69}, //10576 #CJK UNIFIED IDEOGRAPH
    {0xC04C, 0x7E6A}, //10577 #CJK UNIFIED IDEOGRAPH
    {0xC04D, 0x7E6B}, //10578 #CJK UNIFIED IDEOGRAPH
    {0xC04E, 0x7E6C}, //10579 #CJK UNIFIED IDEOGRAPH
    {0xC04F, 0x7E6D}, //10580 #CJK UNIFIED IDEOGRAPH
    {0xC050, 0x7E6E}, //10581 #CJK UNIFIED IDEOGRAPH
    {0xC051, 0x7E6F}, //10582 #CJK UNIFIED IDEOGRAPH
    {0xC052, 0x7E70}, //10583 #CJK UNIFIED IDEOGRAPH
    {0xC053, 0x7E71}, //10584 #CJK UNIFIED IDEOGRAPH
    {0xC054, 0x7E72}, //10585 #CJK UNIFIED IDEOGRAPH
    {0xC055, 0x7E73}, //10586 #CJK UNIFIED IDEOGRAPH
    {0xC056, 0x7E74}, //10587 #CJK UNIFIED IDEOGRAPH
    {0xC057, 0x7E75}, //10588 #CJK UNIFIED IDEOGRAPH
    {0xC058, 0x7E76}, //10589 #CJK UNIFIED IDEOGRAPH
    {0xC059, 0x7E77}, //10590 #CJK UNIFIED IDEOGRAPH
    {0xC05A, 0x7E78}, //10591 #CJK UNIFIED IDEOGRAPH
    {0xC05B, 0x7E79}, //10592 #CJK UNIFIED IDEOGRAPH
    {0xC05C, 0x7E7A}, //10593 #CJK UNIFIED IDEOGRAPH
    {0xC05D, 0x7E7B}, //10594 #CJK UNIFIED IDEOGRAPH
    {0xC05E, 0x7E7C}, //10595 #CJK UNIFIED IDEOGRAPH
    {0xC05F, 0x7E7D}, //10596 #CJK UNIFIED IDEOGRAPH
    {0xC060, 0x7E7E}, //10597 #CJK UNIFIED IDEOGRAPH
    {0xC061, 0x7E7F}, //10598 #CJK UNIFIED IDEOGRAPH
    {0xC062, 0x7E80}, //10599 #CJK UNIFIED IDEOGRAPH
    {0xC063, 0x7E81}, //10600 #CJK UNIFIED IDEOGRAPH
    {0xC064, 0x7E83}, //10601 #CJK UNIFIED IDEOGRAPH
    {0xC065, 0x7E84}, //10602 #CJK UNIFIED IDEOGRAPH
    {0xC066, 0x7E85}, //10603 #CJK UNIFIED IDEOGRAPH
    {0xC067, 0x7E86}, //10604 #CJK UNIFIED IDEOGRAPH
    {0xC068, 0x7E87}, //10605 #CJK UNIFIED IDEOGRAPH
    {0xC069, 0x7E88}, //10606 #CJK UNIFIED IDEOGRAPH
    {0xC06A, 0x7E89}, //10607 #CJK UNIFIED IDEOGRAPH
    {0xC06B, 0x7E8A}, //10608 #CJK UNIFIED IDEOGRAPH
    {0xC06C, 0x7E8B}, //10609 #CJK UNIFIED IDEOGRAPH
    {0xC06D, 0x7E8C}, //10610 #CJK UNIFIED IDEOGRAPH
    {0xC06E, 0x7E8D}, //10611 #CJK UNIFIED IDEOGRAPH
    {0xC06F, 0x7E8E}, //10612 #CJK UNIFIED IDEOGRAPH
    {0xC070, 0x7E8F}, //10613 #CJK UNIFIED IDEOGRAPH
    {0xC071, 0x7E90}, //10614 #CJK UNIFIED IDEOGRAPH
    {0xC072, 0x7E91}, //10615 #CJK UNIFIED IDEOGRAPH
    {0xC073, 0x7E92}, //10616 #CJK UNIFIED IDEOGRAPH
    {0xC074, 0x7E93}, //10617 #CJK UNIFIED IDEOGRAPH
    {0xC075, 0x7E94}, //10618 #CJK UNIFIED IDEOGRAPH
    {0xC076, 0x7E95}, //10619 #CJK UNIFIED IDEOGRAPH
    {0xC077, 0x7E96}, //10620 #CJK UNIFIED IDEOGRAPH
    {0xC078, 0x7E97}, //10621 #CJK UNIFIED IDEOGRAPH
    {0xC079, 0x7E98}, //10622 #CJK UNIFIED IDEOGRAPH
    {0xC07A, 0x7E99}, //10623 #CJK UNIFIED IDEOGRAPH
    {0xC07B, 0x7E9A}, //10624 #CJK UNIFIED IDEOGRAPH
    {0xC07C, 0x7E9C}, //10625 #CJK UNIFIED IDEOGRAPH
    {0xC07D, 0x7E9D}, //10626 #CJK UNIFIED IDEOGRAPH
    {0xC07E, 0x7E9E}, //10627 #CJK UNIFIED IDEOGRAPH
    {0xC080, 0x7EAE}, //10628 #CJK UNIFIED IDEOGRAPH
    {0xC081, 0x7EB4}, //10629 #CJK UNIFIED IDEOGRAPH
    {0xC082, 0x7EBB}, //10630 #CJK UNIFIED IDEOGRAPH
    {0xC083, 0x7EBC}, //10631 #CJK UNIFIED IDEOGRAPH
    {0xC084, 0x7ED6}, //10632 #CJK UNIFIED IDEOGRAPH
    {0xC085, 0x7EE4}, //10633 #CJK UNIFIED IDEOGRAPH
    {0xC086, 0x7EEC}, //10634 #CJK UNIFIED IDEOGRAPH
    {0xC087, 0x7EF9}, //10635 #CJK UNIFIED IDEOGRAPH
    {0xC088, 0x7F0A}, //10636 #CJK UNIFIED IDEOGRAPH
    {0xC089, 0x7F10}, //10637 #CJK UNIFIED IDEOGRAPH
    {0xC08A, 0x7F1E}, //10638 #CJK UNIFIED IDEOGRAPH
    {0xC08B, 0x7F37}, //10639 #CJK UNIFIED IDEOGRAPH
    {0xC08C, 0x7F39}, //10640 #CJK UNIFIED IDEOGRAPH
    {0xC08D, 0x7F3B}, //10641 #CJK UNIFIED IDEOGRAPH
    {0xC08E, 0x7F3C}, //10642 #CJK UNIFIED IDEOGRAPH
    {0xC08F, 0x7F3D}, //10643 #CJK UNIFIED IDEOGRAPH
    {0xC090, 0x7F3E}, //10644 #CJK UNIFIED IDEOGRAPH
    {0xC091, 0x7F3F}, //10645 #CJK UNIFIED IDEOGRAPH
    {0xC092, 0x7F40}, //10646 #CJK UNIFIED IDEOGRAPH
    {0xC093, 0x7F41}, //10647 #CJK UNIFIED IDEOGRAPH
    {0xC094, 0x7F43}, //10648 #CJK UNIFIED IDEOGRAPH
    {0xC095, 0x7F46}, //10649 #CJK UNIFIED IDEOGRAPH
    {0xC096, 0x7F47}, //10650 #CJK UNIFIED IDEOGRAPH
    {0xC097, 0x7F48}, //10651 #CJK UNIFIED IDEOGRAPH
    {0xC098, 0x7F49}, //10652 #CJK UNIFIED IDEOGRAPH
    {0xC099, 0x7F4A}, //10653 #CJK UNIFIED IDEOGRAPH
    {0xC09A, 0x7F4B}, //10654 #CJK UNIFIED IDEOGRAPH
    {0xC09B, 0x7F4C}, //10655 #CJK UNIFIED IDEOGRAPH
    {0xC09C, 0x7F4D}, //10656 #CJK UNIFIED IDEOGRAPH
    {0xC09D, 0x7F4E}, //10657 #CJK UNIFIED IDEOGRAPH
    {0xC09E, 0x7F4F}, //10658 #CJK UNIFIED IDEOGRAPH
    {0xC09F, 0x7F52}, //10659 #CJK UNIFIED IDEOGRAPH
    {0xC0A0, 0x7F53}, //10660 #CJK UNIFIED IDEOGRAPH
    {0xC0A1, 0x9988}, //10661 #CJK UNIFIED IDEOGRAPH
    {0xC0A2, 0x6127}, //10662 #CJK UNIFIED IDEOGRAPH
    {0xC0A3, 0x6E83}, //10663 #CJK UNIFIED IDEOGRAPH
    {0xC0A4, 0x5764}, //10664 #CJK UNIFIED IDEOGRAPH
    {0xC0A5, 0x6606}, //10665 #CJK UNIFIED IDEOGRAPH
    {0xC0A6, 0x6346}, //10666 #CJK UNIFIED IDEOGRAPH
    {0xC0A7, 0x56F0}, //10667 #CJK UNIFIED IDEOGRAPH
    {0xC0A8, 0x62EC}, //10668 #CJK UNIFIED IDEOGRAPH
    {0xC0A9, 0x6269}, //10669 #CJK UNIFIED IDEOGRAPH
    {0xC0AA, 0x5ED3}, //10670 #CJK UNIFIED IDEOGRAPH
    {0xC0AB, 0x9614}, //10671 #CJK UNIFIED IDEOGRAPH
    {0xC0AC, 0x5783}, //10672 #CJK UNIFIED IDEOGRAPH
    {0xC0AD, 0x62C9}, //10673 #CJK UNIFIED IDEOGRAPH
    {0xC0AE, 0x5587}, //10674 #CJK UNIFIED IDEOGRAPH
    {0xC0AF, 0x8721}, //10675 #CJK UNIFIED IDEOGRAPH
    {0xC0B0, 0x814A}, //10676 #CJK UNIFIED IDEOGRAPH
    {0xC0B1, 0x8FA3}, //10677 #CJK UNIFIED IDEOGRAPH
    {0xC0B2, 0x5566}, //10678 #CJK UNIFIED IDEOGRAPH
    {0xC0B3, 0x83B1}, //10679 #CJK UNIFIED IDEOGRAPH
    {0xC0B4, 0x6765}, //10680 #CJK UNIFIED IDEOGRAPH
    {0xC0B5, 0x8D56}, //10681 #CJK UNIFIED IDEOGRAPH
    {0xC0B6, 0x84DD}, //10682 #CJK UNIFIED IDEOGRAPH
    {0xC0B7, 0x5A6A}, //10683 #CJK UNIFIED IDEOGRAPH
    {0xC0B8, 0x680F}, //10684 #CJK UNIFIED IDEOGRAPH
    {0xC0B9, 0x62E6}, //10685 #CJK UNIFIED IDEOGRAPH
    {0xC0BA, 0x7BEE}, //10686 #CJK UNIFIED IDEOGRAPH
    {0xC0BB, 0x9611}, //10687 #CJK UNIFIED IDEOGRAPH
    {0xC0BC, 0x5170}, //10688 #CJK UNIFIED IDEOGRAPH
    {0xC0BD, 0x6F9C}, //10689 #CJK UNIFIED IDEOGRAPH
    {0xC0BE, 0x8C30}, //10690 #CJK UNIFIED IDEOGRAPH
    {0xC0BF, 0x63FD}, //10691 #CJK UNIFIED IDEOGRAPH
    {0xC0C0, 0x89C8}, //10692 #CJK UNIFIED IDEOGRAPH
    {0xC0C1, 0x61D2}, //10693 #CJK UNIFIED IDEOGRAPH
    {0xC0C2, 0x7F06}, //10694 #CJK UNIFIED IDEOGRAPH
    {0xC0C3, 0x70C2}, //10695 #CJK UNIFIED IDEOGRAPH
    {0xC0C4, 0x6EE5}, //10696 #CJK UNIFIED IDEOGRAPH
    {0xC0C5, 0x7405}, //10697 #CJK UNIFIED IDEOGRAPH
    {0xC0C6, 0x6994}, //10698 #CJK UNIFIED IDEOGRAPH
    {0xC0C7, 0x72FC}, //10699 #CJK UNIFIED IDEOGRAPH
    {0xC0C8, 0x5ECA}, //10700 #CJK UNIFIED IDEOGRAPH
    {0xC0C9, 0x90CE}, //10701 #CJK UNIFIED IDEOGRAPH
    {0xC0CA, 0x6717}, //10702 #CJK UNIFIED IDEOGRAPH
    {0xC0CB, 0x6D6A}, //10703 #CJK UNIFIED IDEOGRAPH
    {0xC0CC, 0x635E}, //10704 #CJK UNIFIED IDEOGRAPH
    {0xC0CD, 0x52B3}, //10705 #CJK UNIFIED IDEOGRAPH
    {0xC0CE, 0x7262}, //10706 #CJK UNIFIED IDEOGRAPH
    {0xC0CF, 0x8001}, //10707 #CJK UNIFIED IDEOGRAPH
    {0xC0D0, 0x4F6C}, //10708 #CJK UNIFIED IDEOGRAPH
    {0xC0D1, 0x59E5}, //10709 #CJK UNIFIED IDEOGRAPH
    {0xC0D2, 0x916A}, //10710 #CJK UNIFIED IDEOGRAPH
    {0xC0D3, 0x70D9}, //10711 #CJK UNIFIED IDEOGRAPH
    {0xC0D4, 0x6D9D}, //10712 #CJK UNIFIED IDEOGRAPH
    {0xC0D5, 0x52D2}, //10713 #CJK UNIFIED IDEOGRAPH
    {0xC0D6, 0x4E50}, //10714 #CJK UNIFIED IDEOGRAPH
    {0xC0D7, 0x96F7}, //10715 #CJK UNIFIED IDEOGRAPH
    {0xC0D8, 0x956D}, //10716 #CJK UNIFIED IDEOGRAPH
    {0xC0D9, 0x857E}, //10717 #CJK UNIFIED IDEOGRAPH
    {0xC0DA, 0x78CA}, //10718 #CJK UNIFIED IDEOGRAPH
    {0xC0DB, 0x7D2F}, //10719 #CJK UNIFIED IDEOGRAPH
    {0xC0DC, 0x5121}, //10720 #CJK UNIFIED IDEOGRAPH
    {0xC0DD, 0x5792}, //10721 #CJK UNIFIED IDEOGRAPH
    {0xC0DE, 0x64C2}, //10722 #CJK UNIFIED IDEOGRAPH
    {0xC0DF, 0x808B}, //10723 #CJK UNIFIED IDEOGRAPH
    {0xC0E0, 0x7C7B}, //10724 #CJK UNIFIED IDEOGRAPH
    {0xC0E1, 0x6CEA}, //10725 #CJK UNIFIED IDEOGRAPH
    {0xC0E2, 0x68F1}, //10726 #CJK UNIFIED IDEOGRAPH
    {0xC0E3, 0x695E}, //10727 #CJK UNIFIED IDEOGRAPH
    {0xC0E4, 0x51B7}, //10728 #CJK UNIFIED IDEOGRAPH
    {0xC0E5, 0x5398}, //10729 #CJK UNIFIED IDEOGRAPH
    {0xC0E6, 0x68A8}, //10730 #CJK UNIFIED IDEOGRAPH
    {0xC0E7, 0x7281}, //10731 #CJK UNIFIED IDEOGRAPH
    {0xC0E8, 0x9ECE}, //10732 #CJK UNIFIED IDEOGRAPH
    {0xC0E9, 0x7BF1}, //10733 #CJK UNIFIED IDEOGRAPH
    {0xC0EA, 0x72F8}, //10734 #CJK UNIFIED IDEOGRAPH
    {0xC0EB, 0x79BB}, //10735 #CJK UNIFIED IDEOGRAPH
    {0xC0EC, 0x6F13}, //10736 #CJK UNIFIED IDEOGRAPH
    {0xC0ED, 0x7406}, //10737 #CJK UNIFIED IDEOGRAPH
    {0xC0EE, 0x674E}, //10738 #CJK UNIFIED IDEOGRAPH
    {0xC0EF, 0x91CC}, //10739 #CJK UNIFIED IDEOGRAPH
    {0xC0F0, 0x9CA4}, //10740 #CJK UNIFIED IDEOGRAPH
    {0xC0F1, 0x793C}, //10741 #CJK UNIFIED IDEOGRAPH
    {0xC0F2, 0x8389}, //10742 #CJK UNIFIED IDEOGRAPH
    {0xC0F3, 0x8354}, //10743 #CJK UNIFIED IDEOGRAPH
    {0xC0F4, 0x540F}, //10744 #CJK UNIFIED IDEOGRAPH
    {0xC0F5, 0x6817}, //10745 #CJK UNIFIED IDEOGRAPH
    {0xC0F6, 0x4E3D}, //10746 #CJK UNIFIED IDEOGRAPH
    {0xC0F7, 0x5389}, //10747 #CJK UNIFIED IDEOGRAPH
    {0xC0F8, 0x52B1}, //10748 #CJK UNIFIED IDEOGRAPH
    {0xC0F9, 0x783E}, //10749 #CJK UNIFIED IDEOGRAPH
    {0xC0FA, 0x5386}, //10750 #CJK UNIFIED IDEOGRAPH
    {0xC0FB, 0x5229}, //10751 #CJK UNIFIED IDEOGRAPH
    {0xC0FC, 0x5088}, //10752 #CJK UNIFIED IDEOGRAPH
    {0xC0FD, 0x4F8B}, //10753 #CJK UNIFIED IDEOGRAPH
    {0xC0FE, 0x4FD0}, //10754 #CJK UNIFIED IDEOGRAPH
    {0xC140, 0x7F56}, //10755 #CJK UNIFIED IDEOGRAPH
    {0xC141, 0x7F59}, //10756 #CJK UNIFIED IDEOGRAPH
    {0xC142, 0x7F5B}, //10757 #CJK UNIFIED IDEOGRAPH
    {0xC143, 0x7F5C}, //10758 #CJK UNIFIED IDEOGRAPH
    {0xC144, 0x7F5D}, //10759 #CJK UNIFIED IDEOGRAPH
    {0xC145, 0x7F5E}, //10760 #CJK UNIFIED IDEOGRAPH
    {0xC146, 0x7F60}, //10761 #CJK UNIFIED IDEOGRAPH
    {0xC147, 0x7F63}, //10762 #CJK UNIFIED IDEOGRAPH
    {0xC148, 0x7F64}, //10763 #CJK UNIFIED IDEOGRAPH
    {0xC149, 0x7F65}, //10764 #CJK UNIFIED IDEOGRAPH
    {0xC14A, 0x7F66}, //10765 #CJK UNIFIED IDEOGRAPH
    {0xC14B, 0x7F67}, //10766 #CJK UNIFIED IDEOGRAPH
    {0xC14C, 0x7F6B}, //10767 #CJK UNIFIED IDEOGRAPH
    {0xC14D, 0x7F6C}, //10768 #CJK UNIFIED IDEOGRAPH
    {0xC14E, 0x7F6D}, //10769 #CJK UNIFIED IDEOGRAPH
    {0xC14F, 0x7F6F}, //10770 #CJK UNIFIED IDEOGRAPH
    {0xC150, 0x7F70}, //10771 #CJK UNIFIED IDEOGRAPH
    {0xC151, 0x7F73}, //10772 #CJK UNIFIED IDEOGRAPH
    {0xC152, 0x7F75}, //10773 #CJK UNIFIED IDEOGRAPH
    {0xC153, 0x7F76}, //10774 #CJK UNIFIED IDEOGRAPH
    {0xC154, 0x7F77}, //10775 #CJK UNIFIED IDEOGRAPH
    {0xC155, 0x7F78}, //10776 #CJK UNIFIED IDEOGRAPH
    {0xC156, 0x7F7A}, //10777 #CJK UNIFIED IDEOGRAPH
    {0xC157, 0x7F7B}, //10778 #CJK UNIFIED IDEOGRAPH
    {0xC158, 0x7F7C}, //10779 #CJK UNIFIED IDEOGRAPH
    {0xC159, 0x7F7D}, //10780 #CJK UNIFIED IDEOGRAPH
    {0xC15A, 0x7F7F}, //10781 #CJK UNIFIED IDEOGRAPH
    {0xC15B, 0x7F80}, //10782 #CJK UNIFIED IDEOGRAPH
    {0xC15C, 0x7F82}, //10783 #CJK UNIFIED IDEOGRAPH
    {0xC15D, 0x7F83}, //10784 #CJK UNIFIED IDEOGRAPH
    {0xC15E, 0x7F84}, //10785 #CJK UNIFIED IDEOGRAPH
    {0xC15F, 0x7F85}, //10786 #CJK UNIFIED IDEOGRAPH
    {0xC160, 0x7F86}, //10787 #CJK UNIFIED IDEOGRAPH
    {0xC161, 0x7F87}, //10788 #CJK UNIFIED IDEOGRAPH
    {0xC162, 0x7F88}, //10789 #CJK UNIFIED IDEOGRAPH
    {0xC163, 0x7F89}, //10790 #CJK UNIFIED IDEOGRAPH
    {0xC164, 0x7F8B}, //10791 #CJK UNIFIED IDEOGRAPH
    {0xC165, 0x7F8D}, //10792 #CJK UNIFIED IDEOGRAPH
    {0xC166, 0x7F8F}, //10793 #CJK UNIFIED IDEOGRAPH
    {0xC167, 0x7F90}, //10794 #CJK UNIFIED IDEOGRAPH
    {0xC168, 0x7F91}, //10795 #CJK UNIFIED IDEOGRAPH
    {0xC169, 0x7F92}, //10796 #CJK UNIFIED IDEOGRAPH
    {0xC16A, 0x7F93}, //10797 #CJK UNIFIED IDEOGRAPH
    {0xC16B, 0x7F95}, //10798 #CJK UNIFIED IDEOGRAPH
    {0xC16C, 0x7F96}, //10799 #CJK UNIFIED IDEOGRAPH
    {0xC16D, 0x7F97}, //10800 #CJK UNIFIED IDEOGRAPH
    {0xC16E, 0x7F98}, //10801 #CJK UNIFIED IDEOGRAPH
    {0xC16F, 0x7F99}, //10802 #CJK UNIFIED IDEOGRAPH
    {0xC170, 0x7F9B}, //10803 #CJK UNIFIED IDEOGRAPH
    {0xC171, 0x7F9C}, //10804 #CJK UNIFIED IDEOGRAPH
    {0xC172, 0x7FA0}, //10805 #CJK UNIFIED IDEOGRAPH
    {0xC173, 0x7FA2}, //10806 #CJK UNIFIED IDEOGRAPH
    {0xC174, 0x7FA3}, //10807 #CJK UNIFIED IDEOGRAPH
    {0xC175, 0x7FA5}, //10808 #CJK UNIFIED IDEOGRAPH
    {0xC176, 0x7FA6}, //10809 #CJK UNIFIED IDEOGRAPH
    {0xC177, 0x7FA8}, //10810 #CJK UNIFIED IDEOGRAPH
    {0xC178, 0x7FA9}, //10811 #CJK UNIFIED IDEOGRAPH
    {0xC179, 0x7FAA}, //10812 #CJK UNIFIED IDEOGRAPH
    {0xC17A, 0x7FAB}, //10813 #CJK UNIFIED IDEOGRAPH
    {0xC17B, 0x7FAC}, //10814 #CJK UNIFIED IDEOGRAPH
    {0xC17C, 0x7FAD}, //10815 #CJK UNIFIED IDEOGRAPH
    {0xC17D, 0x7FAE}, //10816 #CJK UNIFIED IDEOGRAPH
    {0xC17E, 0x7FB1}, //10817 #CJK UNIFIED IDEOGRAPH
    {0xC180, 0x7FB3}, //10818 #CJK UNIFIED IDEOGRAPH
    {0xC181, 0x7FB4}, //10819 #CJK UNIFIED IDEOGRAPH
    {0xC182, 0x7FB5}, //10820 #CJK UNIFIED IDEOGRAPH
    {0xC183, 0x7FB6}, //10821 #CJK UNIFIED IDEOGRAPH
    {0xC184, 0x7FB7}, //10822 #CJK UNIFIED IDEOGRAPH
    {0xC185, 0x7FBA}, //10823 #CJK UNIFIED IDEOGRAPH
    {0xC186, 0x7FBB}, //10824 #CJK UNIFIED IDEOGRAPH
    {0xC187, 0x7FBE}, //10825 #CJK UNIFIED IDEOGRAPH
    {0xC188, 0x7FC0}, //10826 #CJK UNIFIED IDEOGRAPH
    {0xC189, 0x7FC2}, //10827 #CJK UNIFIED IDEOGRAPH
    {0xC18A, 0x7FC3}, //10828 #CJK UNIFIED IDEOGRAPH
    {0xC18B, 0x7FC4}, //10829 #CJK UNIFIED IDEOGRAPH
    {0xC18C, 0x7FC6}, //10830 #CJK UNIFIED IDEOGRAPH
    {0xC18D, 0x7FC7}, //10831 #CJK UNIFIED IDEOGRAPH
    {0xC18E, 0x7FC8}, //10832 #CJK UNIFIED IDEOGRAPH
    {0xC18F, 0x7FC9}, //10833 #CJK UNIFIED IDEOGRAPH
    {0xC190, 0x7FCB}, //10834 #CJK UNIFIED IDEOGRAPH
    {0xC191, 0x7FCD}, //10835 #CJK UNIFIED IDEOGRAPH
    {0xC192, 0x7FCF}, //10836 #CJK UNIFIED IDEOGRAPH
    {0xC193, 0x7FD0}, //10837 #CJK UNIFIED IDEOGRAPH
    {0xC194, 0x7FD1}, //10838 #CJK UNIFIED IDEOGRAPH
    {0xC195, 0x7FD2}, //10839 #CJK UNIFIED IDEOGRAPH
    {0xC196, 0x7FD3}, //10840 #CJK UNIFIED IDEOGRAPH
    {0xC197, 0x7FD6}, //10841 #CJK UNIFIED IDEOGRAPH
    {0xC198, 0x7FD7}, //10842 #CJK UNIFIED IDEOGRAPH
    {0xC199, 0x7FD9}, //10843 #CJK UNIFIED IDEOGRAPH
    {0xC19A, 0x7FDA}, //10844 #CJK UNIFIED IDEOGRAPH
    {0xC19B, 0x7FDB}, //10845 #CJK UNIFIED IDEOGRAPH
    {0xC19C, 0x7FDC}, //10846 #CJK UNIFIED IDEOGRAPH
    {0xC19D, 0x7FDD}, //10847 #CJK UNIFIED IDEOGRAPH
    {0xC19E, 0x7FDE}, //10848 #CJK UNIFIED IDEOGRAPH
    {0xC19F, 0x7FE2}, //10849 #CJK UNIFIED IDEOGRAPH
    {0xC1A0, 0x7FE3}, //10850 #CJK UNIFIED IDEOGRAPH
    {0xC1A1, 0x75E2}, //10851 #CJK UNIFIED IDEOGRAPH
    {0xC1A2, 0x7ACB}, //10852 #CJK UNIFIED IDEOGRAPH
    {0xC1A3, 0x7C92}, //10853 #CJK UNIFIED IDEOGRAPH
    {0xC1A4, 0x6CA5}, //10854 #CJK UNIFIED IDEOGRAPH
    {0xC1A5, 0x96B6}, //10855 #CJK UNIFIED IDEOGRAPH
    {0xC1A6, 0x529B}, //10856 #CJK UNIFIED IDEOGRAPH
    {0xC1A7, 0x7483}, //10857 #CJK UNIFIED IDEOGRAPH
    {0xC1A8, 0x54E9}, //10858 #CJK UNIFIED IDEOGRAPH
    {0xC1A9, 0x4FE9}, //10859 #CJK UNIFIED IDEOGRAPH
    {0xC1AA, 0x8054}, //10860 #CJK UNIFIED IDEOGRAPH
    {0xC1AB, 0x83B2}, //10861 #CJK UNIFIED IDEOGRAPH
    {0xC1AC, 0x8FDE}, //10862 #CJK UNIFIED IDEOGRAPH
    {0xC1AD, 0x9570}, //10863 #CJK UNIFIED IDEOGRAPH
    {0xC1AE, 0x5EC9}, //10864 #CJK UNIFIED IDEOGRAPH
    {0xC1AF, 0x601C}, //10865 #CJK UNIFIED IDEOGRAPH
    {0xC1B0, 0x6D9F}, //10866 #CJK UNIFIED IDEOGRAPH
    {0xC1B1, 0x5E18}, //10867 #CJK UNIFIED IDEOGRAPH
    {0xC1B2, 0x655B}, //10868 #CJK UNIFIED IDEOGRAPH
    {0xC1B3, 0x8138}, //10869 #CJK UNIFIED IDEOGRAPH
    {0xC1B4, 0x94FE}, //10870 #CJK UNIFIED IDEOGRAPH
    {0xC1B5, 0x604B}, //10871 #CJK UNIFIED IDEOGRAPH
    {0xC1B6, 0x70BC}, //10872 #CJK UNIFIED IDEOGRAPH
    {0xC1B7, 0x7EC3}, //10873 #CJK UNIFIED IDEOGRAPH
    {0xC1B8, 0x7CAE}, //10874 #CJK UNIFIED IDEOGRAPH
    {0xC1B9, 0x51C9}, //10875 #CJK UNIFIED IDEOGRAPH
    {0xC1BA, 0x6881}, //10876 #CJK UNIFIED IDEOGRAPH
    {0xC1BB, 0x7CB1}, //10877 #CJK UNIFIED IDEOGRAPH
    {0xC1BC, 0x826F}, //10878 #CJK UNIFIED IDEOGRAPH
    {0xC1BD, 0x4E24}, //10879 #CJK UNIFIED IDEOGRAPH
    {0xC1BE, 0x8F86}, //10880 #CJK UNIFIED IDEOGRAPH
    {0xC1BF, 0x91CF}, //10881 #CJK UNIFIED IDEOGRAPH
    {0xC1C0, 0x667E}, //10882 #CJK UNIFIED IDEOGRAPH
    {0xC1C1, 0x4EAE}, //10883 #CJK UNIFIED IDEOGRAPH
    {0xC1C2, 0x8C05}, //10884 #CJK UNIFIED IDEOGRAPH
    {0xC1C3, 0x64A9}, //10885 #CJK UNIFIED IDEOGRAPH
    {0xC1C4, 0x804A}, //10886 #CJK UNIFIED IDEOGRAPH
    {0xC1C5, 0x50DA}, //10887 #CJK UNIFIED IDEOGRAPH
    {0xC1C6, 0x7597}, //10888 #CJK UNIFIED IDEOGRAPH
    {0xC1C7, 0x71CE}, //10889 #CJK UNIFIED IDEOGRAPH
    {0xC1C8, 0x5BE5}, //10890 #CJK UNIFIED IDEOGRAPH
    {0xC1C9, 0x8FBD}, //10891 #CJK UNIFIED IDEOGRAPH
    {0xC1CA, 0x6F66}, //10892 #CJK UNIFIED IDEOGRAPH
    {0xC1CB, 0x4E86}, //10893 #CJK UNIFIED IDEOGRAPH
    {0xC1CC, 0x6482}, //10894 #CJK UNIFIED IDEOGRAPH
    {0xC1CD, 0x9563}, //10895 #CJK UNIFIED IDEOGRAPH
    {0xC1CE, 0x5ED6}, //10896 #CJK UNIFIED IDEOGRAPH
    {0xC1CF, 0x6599}, //10897 #CJK UNIFIED IDEOGRAPH
    {0xC1D0, 0x5217}, //10898 #CJK UNIFIED IDEOGRAPH
    {0xC1D1, 0x88C2}, //10899 #CJK UNIFIED IDEOGRAPH
    {0xC1D2, 0x70C8}, //10900 #CJK UNIFIED IDEOGRAPH
    {0xC1D3, 0x52A3}, //10901 #CJK UNIFIED IDEOGRAPH
    {0xC1D4, 0x730E}, //10902 #CJK UNIFIED IDEOGRAPH
    {0xC1D5, 0x7433}, //10903 #CJK UNIFIED IDEOGRAPH
    {0xC1D6, 0x6797}, //10904 #CJK UNIFIED IDEOGRAPH
    {0xC1D7, 0x78F7}, //10905 #CJK UNIFIED IDEOGRAPH
    {0xC1D8, 0x9716}, //10906 #CJK UNIFIED IDEOGRAPH
    {0xC1D9, 0x4E34}, //10907 #CJK UNIFIED IDEOGRAPH
    {0xC1DA, 0x90BB}, //10908 #CJK UNIFIED IDEOGRAPH
    {0xC1DB, 0x9CDE}, //10909 #CJK UNIFIED IDEOGRAPH
    {0xC1DC, 0x6DCB}, //10910 #CJK UNIFIED IDEOGRAPH
    {0xC1DD, 0x51DB}, //10911 #CJK UNIFIED IDEOGRAPH
    {0xC1DE, 0x8D41}, //10912 #CJK UNIFIED IDEOGRAPH
    {0xC1DF, 0x541D}, //10913 #CJK UNIFIED IDEOGRAPH
    {0xC1E0, 0x62CE}, //10914 #CJK UNIFIED IDEOGRAPH
    {0xC1E1, 0x73B2}, //10915 #CJK UNIFIED IDEOGRAPH
    {0xC1E2, 0x83F1}, //10916 #CJK UNIFIED IDEOGRAPH
    {0xC1E3, 0x96F6}, //10917 #CJK UNIFIED IDEOGRAPH
    {0xC1E4, 0x9F84}, //10918 #CJK UNIFIED IDEOGRAPH
    {0xC1E5, 0x94C3}, //10919 #CJK UNIFIED IDEOGRAPH
    {0xC1E6, 0x4F36}, //10920 #CJK UNIFIED IDEOGRAPH
    {0xC1E7, 0x7F9A}, //10921 #CJK UNIFIED IDEOGRAPH
    {0xC1E8, 0x51CC}, //10922 #CJK UNIFIED IDEOGRAPH
    {0xC1E9, 0x7075}, //10923 #CJK UNIFIED IDEOGRAPH
    {0xC1EA, 0x9675}, //10924 #CJK UNIFIED IDEOGRAPH
    {0xC1EB, 0x5CAD}, //10925 #CJK UNIFIED IDEOGRAPH
    {0xC1EC, 0x9886}, //10926 #CJK UNIFIED IDEOGRAPH
    {0xC1ED, 0x53E6}, //10927 #CJK UNIFIED IDEOGRAPH
    {0xC1EE, 0x4EE4}, //10928 #CJK UNIFIED IDEOGRAPH
    {0xC1EF, 0x6E9C}, //10929 #CJK UNIFIED IDEOGRAPH
    {0xC1F0, 0x7409}, //10930 #CJK UNIFIED IDEOGRAPH
    {0xC1F1, 0x69B4}, //10931 #CJK UNIFIED IDEOGRAPH
    {0xC1F2, 0x786B}, //10932 #CJK UNIFIED IDEOGRAPH
    {0xC1F3, 0x998F}, //10933 #CJK UNIFIED IDEOGRAPH
    {0xC1F4, 0x7559}, //10934 #CJK UNIFIED IDEOGRAPH
    {0xC1F5, 0x5218}, //10935 #CJK UNIFIED IDEOGRAPH
    {0xC1F6, 0x7624}, //10936 #CJK UNIFIED IDEOGRAPH
    {0xC1F7, 0x6D41}, //10937 #CJK UNIFIED IDEOGRAPH
    {0xC1F8, 0x67F3}, //10938 #CJK UNIFIED IDEOGRAPH
    {0xC1F9, 0x516D}, //10939 #CJK UNIFIED IDEOGRAPH
    {0xC1FA, 0x9F99}, //10940 #CJK UNIFIED IDEOGRAPH
    {0xC1FB, 0x804B}, //10941 #CJK UNIFIED IDEOGRAPH
    {0xC1FC, 0x5499}, //10942 #CJK UNIFIED IDEOGRAPH
    {0xC1FD, 0x7B3C}, //10943 #CJK UNIFIED IDEOGRAPH
    {0xC1FE, 0x7ABF}, //10944 #CJK UNIFIED IDEOGRAPH
    {0xC240, 0x7FE4}, //10945 #CJK UNIFIED IDEOGRAPH
    {0xC241, 0x7FE7}, //10946 #CJK UNIFIED IDEOGRAPH
    {0xC242, 0x7FE8}, //10947 #CJK UNIFIED IDEOGRAPH
    {0xC243, 0x7FEA}, //10948 #CJK UNIFIED IDEOGRAPH
    {0xC244, 0x7FEB}, //10949 #CJK UNIFIED IDEOGRAPH
    {0xC245, 0x7FEC}, //10950 #CJK UNIFIED IDEOGRAPH
    {0xC246, 0x7FED}, //10951 #CJK UNIFIED IDEOGRAPH
    {0xC247, 0x7FEF}, //10952 #CJK UNIFIED IDEOGRAPH
    {0xC248, 0x7FF2}, //10953 #CJK UNIFIED IDEOGRAPH
    {0xC249, 0x7FF4}, //10954 #CJK UNIFIED IDEOGRAPH
    {0xC24A, 0x7FF5}, //10955 #CJK UNIFIED IDEOGRAPH
    {0xC24B, 0x7FF6}, //10956 #CJK UNIFIED IDEOGRAPH
    {0xC24C, 0x7FF7}, //10957 #CJK UNIFIED IDEOGRAPH
    {0xC24D, 0x7FF8}, //10958 #CJK UNIFIED IDEOGRAPH
    {0xC24E, 0x7FF9}, //10959 #CJK UNIFIED IDEOGRAPH
    {0xC24F, 0x7FFA}, //10960 #CJK UNIFIED IDEOGRAPH
    {0xC250, 0x7FFD}, //10961 #CJK UNIFIED IDEOGRAPH
    {0xC251, 0x7FFE}, //10962 #CJK UNIFIED IDEOGRAPH
    {0xC252, 0x7FFF}, //10963 #CJK UNIFIED IDEOGRAPH
    {0xC253, 0x8002}, //10964 #CJK UNIFIED IDEOGRAPH
    {0xC254, 0x8007}, //10965 #CJK UNIFIED IDEOGRAPH
    {0xC255, 0x8008}, //10966 #CJK UNIFIED IDEOGRAPH
    {0xC256, 0x8009}, //10967 #CJK UNIFIED IDEOGRAPH
    {0xC257, 0x800A}, //10968 #CJK UNIFIED IDEOGRAPH
    {0xC258, 0x800E}, //10969 #CJK UNIFIED IDEOGRAPH
    {0xC259, 0x800F}, //10970 #CJK UNIFIED IDEOGRAPH
    {0xC25A, 0x8011}, //10971 #CJK UNIFIED IDEOGRAPH
    {0xC25B, 0x8013}, //10972 #CJK UNIFIED IDEOGRAPH
    {0xC25C, 0x801A}, //10973 #CJK UNIFIED IDEOGRAPH
    {0xC25D, 0x801B}, //10974 #CJK UNIFIED IDEOGRAPH
    {0xC25E, 0x801D}, //10975 #CJK UNIFIED IDEOGRAPH
    {0xC25F, 0x801E}, //10976 #CJK UNIFIED IDEOGRAPH
    {0xC260, 0x801F}, //10977 #CJK UNIFIED IDEOGRAPH
    {0xC261, 0x8021}, //10978 #CJK UNIFIED IDEOGRAPH
    {0xC262, 0x8023}, //10979 #CJK UNIFIED IDEOGRAPH
    {0xC263, 0x8024}, //10980 #CJK UNIFIED IDEOGRAPH
    {0xC264, 0x802B}, //10981 #CJK UNIFIED IDEOGRAPH
    {0xC265, 0x802C}, //10982 #CJK UNIFIED IDEOGRAPH
    {0xC266, 0x802D}, //10983 #CJK UNIFIED IDEOGRAPH
    {0xC267, 0x802E}, //10984 #CJK UNIFIED IDEOGRAPH
    {0xC268, 0x802F}, //10985 #CJK UNIFIED IDEOGRAPH
    {0xC269, 0x8030}, //10986 #CJK UNIFIED IDEOGRAPH
    {0xC26A, 0x8032}, //10987 #CJK UNIFIED IDEOGRAPH
    {0xC26B, 0x8034}, //10988 #CJK UNIFIED IDEOGRAPH
    {0xC26C, 0x8039}, //10989 #CJK UNIFIED IDEOGRAPH
    {0xC26D, 0x803A}, //10990 #CJK UNIFIED IDEOGRAPH
    {0xC26E, 0x803C}, //10991 #CJK UNIFIED IDEOGRAPH
    {0xC26F, 0x803E}, //10992 #CJK UNIFIED IDEOGRAPH
    {0xC270, 0x8040}, //10993 #CJK UNIFIED IDEOGRAPH
    {0xC271, 0x8041}, //10994 #CJK UNIFIED IDEOGRAPH
    {0xC272, 0x8044}, //10995 #CJK UNIFIED IDEOGRAPH
    {0xC273, 0x8045}, //10996 #CJK UNIFIED IDEOGRAPH
    {0xC274, 0x8047}, //10997 #CJK UNIFIED IDEOGRAPH
    {0xC275, 0x8048}, //10998 #CJK UNIFIED IDEOGRAPH
    {0xC276, 0x8049}, //10999 #CJK UNIFIED IDEOGRAPH
    {0xC277, 0x804E}, //11000 #CJK UNIFIED IDEOGRAPH
    {0xC278, 0x804F}, //11001 #CJK UNIFIED IDEOGRAPH
    {0xC279, 0x8050}, //11002 #CJK UNIFIED IDEOGRAPH
    {0xC27A, 0x8051}, //11003 #CJK UNIFIED IDEOGRAPH
    {0xC27B, 0x8053}, //11004 #CJK UNIFIED IDEOGRAPH
    {0xC27C, 0x8055}, //11005 #CJK UNIFIED IDEOGRAPH
    {0xC27D, 0x8056}, //11006 #CJK UNIFIED IDEOGRAPH
    {0xC27E, 0x8057}, //11007 #CJK UNIFIED IDEOGRAPH
    {0xC280, 0x8059}, //11008 #CJK UNIFIED IDEOGRAPH
    {0xC281, 0x805B}, //11009 #CJK UNIFIED IDEOGRAPH
    {0xC282, 0x805C}, //11010 #CJK UNIFIED IDEOGRAPH
    {0xC283, 0x805D}, //11011 #CJK UNIFIED IDEOGRAPH
    {0xC284, 0x805E}, //11012 #CJK UNIFIED IDEOGRAPH
    {0xC285, 0x805F}, //11013 #CJK UNIFIED IDEOGRAPH
    {0xC286, 0x8060}, //11014 #CJK UNIFIED IDEOGRAPH
    {0xC287, 0x8061}, //11015 #CJK UNIFIED IDEOGRAPH
    {0xC288, 0x8062}, //11016 #CJK UNIFIED IDEOGRAPH
    {0xC289, 0x8063}, //11017 #CJK UNIFIED IDEOGRAPH
    {0xC28A, 0x8064}, //11018 #CJK UNIFIED IDEOGRAPH
    {0xC28B, 0x8065}, //11019 #CJK UNIFIED IDEOGRAPH
    {0xC28C, 0x8066}, //11020 #CJK UNIFIED IDEOGRAPH
    {0xC28D, 0x8067}, //11021 #CJK UNIFIED IDEOGRAPH
    {0xC28E, 0x8068}, //11022 #CJK UNIFIED IDEOGRAPH
    {0xC28F, 0x806B}, //11023 #CJK UNIFIED IDEOGRAPH
    {0xC290, 0x806C}, //11024 #CJK UNIFIED IDEOGRAPH
    {0xC291, 0x806D}, //11025 #CJK UNIFIED IDEOGRAPH
    {0xC292, 0x806E}, //11026 #CJK UNIFIED IDEOGRAPH
    {0xC293, 0x806F}, //11027 #CJK UNIFIED IDEOGRAPH
    {0xC294, 0x8070}, //11028 #CJK UNIFIED IDEOGRAPH
    {0xC295, 0x8072}, //11029 #CJK UNIFIED IDEOGRAPH
    {0xC296, 0x8073}, //11030 #CJK UNIFIED IDEOGRAPH
    {0xC297, 0x8074}, //11031 #CJK UNIFIED IDEOGRAPH
    {0xC298, 0x8075}, //11032 #CJK UNIFIED IDEOGRAPH
    {0xC299, 0x8076}, //11033 #CJK UNIFIED IDEOGRAPH
    {0xC29A, 0x8077}, //11034 #CJK UNIFIED IDEOGRAPH
    {0xC29B, 0x8078}, //11035 #CJK UNIFIED IDEOGRAPH
    {0xC29C, 0x8079}, //11036 #CJK UNIFIED IDEOGRAPH
    {0xC29D, 0x807A}, //11037 #CJK UNIFIED IDEOGRAPH
    {0xC29E, 0x807B}, //11038 #CJK UNIFIED IDEOGRAPH
    {0xC29F, 0x807C}, //11039 #CJK UNIFIED IDEOGRAPH
    {0xC2A0, 0x807D}, //11040 #CJK UNIFIED IDEOGRAPH
    {0xC2A1, 0x9686}, //11041 #CJK UNIFIED IDEOGRAPH
    {0xC2A2, 0x5784}, //11042 #CJK UNIFIED IDEOGRAPH
    {0xC2A3, 0x62E2}, //11043 #CJK UNIFIED IDEOGRAPH
    {0xC2A4, 0x9647}, //11044 #CJK UNIFIED IDEOGRAPH
    {0xC2A5, 0x697C}, //11045 #CJK UNIFIED IDEOGRAPH
    {0xC2A6, 0x5A04}, //11046 #CJK UNIFIED IDEOGRAPH
    {0xC2A7, 0x6402}, //11047 #CJK UNIFIED IDEOGRAPH
    {0xC2A8, 0x7BD3}, //11048 #CJK UNIFIED IDEOGRAPH
    {0xC2A9, 0x6F0F}, //11049 #CJK UNIFIED IDEOGRAPH
    {0xC2AA, 0x964B}, //11050 #CJK UNIFIED IDEOGRAPH
    {0xC2AB, 0x82A6}, //11051 #CJK UNIFIED IDEOGRAPH
    {0xC2AC, 0x5362}, //11052 #CJK UNIFIED IDEOGRAPH
    {0xC2AD, 0x9885}, //11053 #CJK UNIFIED IDEOGRAPH
    {0xC2AE, 0x5E90}, //11054 #CJK UNIFIED IDEOGRAPH
    {0xC2AF, 0x7089}, //11055 #CJK UNIFIED IDEOGRAPH
    {0xC2B0, 0x63B3}, //11056 #CJK UNIFIED IDEOGRAPH
    {0xC2B1, 0x5364}, //11057 #CJK UNIFIED IDEOGRAPH
    {0xC2B2, 0x864F}, //11058 #CJK UNIFIED IDEOGRAPH
    {0xC2B3, 0x9C81}, //11059 #CJK UNIFIED IDEOGRAPH
    {0xC2B4, 0x9E93}, //11060 #CJK UNIFIED IDEOGRAPH
    {0xC2B5, 0x788C}, //11061 #CJK UNIFIED IDEOGRAPH
    {0xC2B6, 0x9732}, //11062 #CJK UNIFIED IDEOGRAPH
    {0xC2B7, 0x8DEF}, //11063 #CJK UNIFIED IDEOGRAPH
    {0xC2B8, 0x8D42}, //11064 #CJK UNIFIED IDEOGRAPH
    {0xC2B9, 0x9E7F}, //11065 #CJK UNIFIED IDEOGRAPH
    {0xC2BA, 0x6F5E}, //11066 #CJK UNIFIED IDEOGRAPH
    {0xC2BB, 0x7984}, //11067 #CJK UNIFIED IDEOGRAPH
    {0xC2BC, 0x5F55}, //11068 #CJK UNIFIED IDEOGRAPH
    {0xC2BD, 0x9646}, //11069 #CJK UNIFIED IDEOGRAPH
    {0xC2BE, 0x622E}, //11070 #CJK UNIFIED IDEOGRAPH
    {0xC2BF, 0x9A74}, //11071 #CJK UNIFIED IDEOGRAPH
    {0xC2C0, 0x5415}, //11072 #CJK UNIFIED IDEOGRAPH
    {0xC2C1, 0x94DD}, //11073 #CJK UNIFIED IDEOGRAPH
    {0xC2C2, 0x4FA3}, //11074 #CJK UNIFIED IDEOGRAPH
    {0xC2C3, 0x65C5}, //11075 #CJK UNIFIED IDEOGRAPH
    {0xC2C4, 0x5C65}, //11076 #CJK UNIFIED IDEOGRAPH
    {0xC2C5, 0x5C61}, //11077 #CJK UNIFIED IDEOGRAPH
    {0xC2C6, 0x7F15}, //11078 #CJK UNIFIED IDEOGRAPH
    {0xC2C7, 0x8651}, //11079 #CJK UNIFIED IDEOGRAPH
    {0xC2C8, 0x6C2F}, //11080 #CJK UNIFIED IDEOGRAPH
    {0xC2C9, 0x5F8B}, //11081 #CJK UNIFIED IDEOGRAPH
    {0xC2CA, 0x7387}, //11082 #CJK UNIFIED IDEOGRAPH
    {0xC2CB, 0x6EE4}, //11083 #CJK UNIFIED IDEOGRAPH
    {0xC2CC, 0x7EFF}, //11084 #CJK UNIFIED IDEOGRAPH
    {0xC2CD, 0x5CE6}, //11085 #CJK UNIFIED IDEOGRAPH
    {0xC2CE, 0x631B}, //11086 #CJK UNIFIED IDEOGRAPH
    {0xC2CF, 0x5B6A}, //11087 #CJK UNIFIED IDEOGRAPH
    {0xC2D0, 0x6EE6}, //11088 #CJK UNIFIED IDEOGRAPH
    {0xC2D1, 0x5375}, //11089 #CJK UNIFIED IDEOGRAPH
    {0xC2D2, 0x4E71}, //11090 #CJK UNIFIED IDEOGRAPH
    {0xC2D3, 0x63A0}, //11091 #CJK UNIFIED IDEOGRAPH
    {0xC2D4, 0x7565}, //11092 #CJK UNIFIED IDEOGRAPH
    {0xC2D5, 0x62A1}, //11093 #CJK UNIFIED IDEOGRAPH
    {0xC2D6, 0x8F6E}, //11094 #CJK UNIFIED IDEOGRAPH
    {0xC2D7, 0x4F26}, //11095 #CJK UNIFIED IDEOGRAPH
    {0xC2D8, 0x4ED1}, //11096 #CJK UNIFIED IDEOGRAPH
    {0xC2D9, 0x6CA6}, //11097 #CJK UNIFIED IDEOGRAPH
    {0xC2DA, 0x7EB6}, //11098 #CJK UNIFIED IDEOGRAPH
    {0xC2DB, 0x8BBA}, //11099 #CJK UNIFIED IDEOGRAPH
    {0xC2DC, 0x841D}, //11100 #CJK UNIFIED IDEOGRAPH
    {0xC2DD, 0x87BA}, //11101 #CJK UNIFIED IDEOGRAPH
    {0xC2DE, 0x7F57}, //11102 #CJK UNIFIED IDEOGRAPH
    {0xC2DF, 0x903B}, //11103 #CJK UNIFIED IDEOGRAPH
    {0xC2E0, 0x9523}, //11104 #CJK UNIFIED IDEOGRAPH
    {0xC2E1, 0x7BA9}, //11105 #CJK UNIFIED IDEOGRAPH
    {0xC2E2, 0x9AA1}, //11106 #CJK UNIFIED IDEOGRAPH
    {0xC2E3, 0x88F8}, //11107 #CJK UNIFIED IDEOGRAPH
    {0xC2E4, 0x843D}, //11108 #CJK UNIFIED IDEOGRAPH
    {0xC2E5, 0x6D1B}, //11109 #CJK UNIFIED IDEOGRAPH
    {0xC2E6, 0x9A86}, //11110 #CJK UNIFIED IDEOGRAPH
    {0xC2E7, 0x7EDC}, //11111 #CJK UNIFIED IDEOGRAPH
    {0xC2E8, 0x5988}, //11112 #CJK UNIFIED IDEOGRAPH
    {0xC2E9, 0x9EBB}, //11113 #CJK UNIFIED IDEOGRAPH
    {0xC2EA, 0x739B}, //11114 #CJK UNIFIED IDEOGRAPH
    {0xC2EB, 0x7801}, //11115 #CJK UNIFIED IDEOGRAPH
    {0xC2EC, 0x8682}, //11116 #CJK UNIFIED IDEOGRAPH
    {0xC2ED, 0x9A6C}, //11117 #CJK UNIFIED IDEOGRAPH
    {0xC2EE, 0x9A82}, //11118 #CJK UNIFIED IDEOGRAPH
    {0xC2EF, 0x561B}, //11119 #CJK UNIFIED IDEOGRAPH
    {0xC2F0, 0x5417}, //11120 #CJK UNIFIED IDEOGRAPH
    {0xC2F1, 0x57CB}, //11121 #CJK UNIFIED IDEOGRAPH
    {0xC2F2, 0x4E70}, //11122 #CJK UNIFIED IDEOGRAPH
    {0xC2F3, 0x9EA6}, //11123 #CJK UNIFIED IDEOGRAPH
    {0xC2F4, 0x5356}, //11124 #CJK UNIFIED IDEOGRAPH
    {0xC2F5, 0x8FC8}, //11125 #CJK UNIFIED IDEOGRAPH
    {0xC2F6, 0x8109}, //11126 #CJK UNIFIED IDEOGRAPH
    {0xC2F7, 0x7792}, //11127 #CJK UNIFIED IDEOGRAPH
    {0xC2F8, 0x9992}, //11128 #CJK UNIFIED IDEOGRAPH
    {0xC2F9, 0x86EE}, //11129 #CJK UNIFIED IDEOGRAPH
    {0xC2FA, 0x6EE1}, //11130 #CJK UNIFIED IDEOGRAPH
    {0xC2FB, 0x8513}, //11131 #CJK UNIFIED IDEOGRAPH
    {0xC2FC, 0x66FC}, //11132 #CJK UNIFIED IDEOGRAPH
    {0xC2FD, 0x6162}, //11133 #CJK UNIFIED IDEOGRAPH
    {0xC2FE, 0x6F2B}, //11134 #CJK UNIFIED IDEOGRAPH
    {0xC340, 0x807E}, //11135 #CJK UNIFIED IDEOGRAPH
    {0xC341, 0x8081}, //11136 #CJK UNIFIED IDEOGRAPH
    {0xC342, 0x8082}, //11137 #CJK UNIFIED IDEOGRAPH
    {0xC343, 0x8085}, //11138 #CJK UNIFIED IDEOGRAPH
    {0xC344, 0x8088}, //11139 #CJK UNIFIED IDEOGRAPH
    {0xC345, 0x808A}, //11140 #CJK UNIFIED IDEOGRAPH
    {0xC346, 0x808D}, //11141 #CJK UNIFIED IDEOGRAPH
    {0xC347, 0x808E}, //11142 #CJK UNIFIED IDEOGRAPH
    {0xC348, 0x808F}, //11143 #CJK UNIFIED IDEOGRAPH
    {0xC349, 0x8090}, //11144 #CJK UNIFIED IDEOGRAPH
    {0xC34A, 0x8091}, //11145 #CJK UNIFIED IDEOGRAPH
    {0xC34B, 0x8092}, //11146 #CJK UNIFIED IDEOGRAPH
    {0xC34C, 0x8094}, //11147 #CJK UNIFIED IDEOGRAPH
    {0xC34D, 0x8095}, //11148 #CJK UNIFIED IDEOGRAPH
    {0xC34E, 0x8097}, //11149 #CJK UNIFIED IDEOGRAPH
    {0xC34F, 0x8099}, //11150 #CJK UNIFIED IDEOGRAPH
    {0xC350, 0x809E}, //11151 #CJK UNIFIED IDEOGRAPH
    {0xC351, 0x80A3}, //11152 #CJK UNIFIED IDEOGRAPH
    {0xC352, 0x80A6}, //11153 #CJK UNIFIED IDEOGRAPH
    {0xC353, 0x80A7}, //11154 #CJK UNIFIED IDEOGRAPH
    {0xC354, 0x80A8}, //11155 #CJK UNIFIED IDEOGRAPH
    {0xC355, 0x80AC}, //11156 #CJK UNIFIED IDEOGRAPH
    {0xC356, 0x80B0}, //11157 #CJK UNIFIED IDEOGRAPH
    {0xC357, 0x80B3}, //11158 #CJK UNIFIED IDEOGRAPH
    {0xC358, 0x80B5}, //11159 #CJK UNIFIED IDEOGRAPH
    {0xC359, 0x80B6}, //11160 #CJK UNIFIED IDEOGRAPH
    {0xC35A, 0x80B8}, //11161 #CJK UNIFIED IDEOGRAPH
    {0xC35B, 0x80B9}, //11162 #CJK UNIFIED IDEOGRAPH
    {0xC35C, 0x80BB}, //11163 #CJK UNIFIED IDEOGRAPH
    {0xC35D, 0x80C5}, //11164 #CJK UNIFIED IDEOGRAPH
    {0xC35E, 0x80C7}, //11165 #CJK UNIFIED IDEOGRAPH
    {0xC35F, 0x80C8}, //11166 #CJK UNIFIED IDEOGRAPH
    {0xC360, 0x80C9}, //11167 #CJK UNIFIED IDEOGRAPH
    {0xC361, 0x80CA}, //11168 #CJK UNIFIED IDEOGRAPH
    {0xC362, 0x80CB}, //11169 #CJK UNIFIED IDEOGRAPH
    {0xC363, 0x80CF}, //11170 #CJK UNIFIED IDEOGRAPH
    {0xC364, 0x80D0}, //11171 #CJK UNIFIED IDEOGRAPH
    {0xC365, 0x80D1}, //11172 #CJK UNIFIED IDEOGRAPH
    {0xC366, 0x80D2}, //11173 #CJK UNIFIED IDEOGRAPH
    {0xC367, 0x80D3}, //11174 #CJK UNIFIED IDEOGRAPH
    {0xC368, 0x80D4}, //11175 #CJK UNIFIED IDEOGRAPH
    {0xC369, 0x80D5}, //11176 #CJK UNIFIED IDEOGRAPH
    {0xC36A, 0x80D8}, //11177 #CJK UNIFIED IDEOGRAPH
    {0xC36B, 0x80DF}, //11178 #CJK UNIFIED IDEOGRAPH
    {0xC36C, 0x80E0}, //11179 #CJK UNIFIED IDEOGRAPH
    {0xC36D, 0x80E2}, //11180 #CJK UNIFIED IDEOGRAPH
    {0xC36E, 0x80E3}, //11181 #CJK UNIFIED IDEOGRAPH
    {0xC36F, 0x80E6}, //11182 #CJK UNIFIED IDEOGRAPH
    {0xC370, 0x80EE}, //11183 #CJK UNIFIED IDEOGRAPH
    {0xC371, 0x80F5}, //11184 #CJK UNIFIED IDEOGRAPH
    {0xC372, 0x80F7}, //11185 #CJK UNIFIED IDEOGRAPH
    {0xC373, 0x80F9}, //11186 #CJK UNIFIED IDEOGRAPH
    {0xC374, 0x80FB}, //11187 #CJK UNIFIED IDEOGRAPH
    {0xC375, 0x80FE}, //11188 #CJK UNIFIED IDEOGRAPH
    {0xC376, 0x80FF}, //11189 #CJK UNIFIED IDEOGRAPH
    {0xC377, 0x8100}, //11190 #CJK UNIFIED IDEOGRAPH
    {0xC378, 0x8101}, //11191 #CJK UNIFIED IDEOGRAPH
    {0xC379, 0x8103}, //11192 #CJK UNIFIED IDEOGRAPH
    {0xC37A, 0x8104}, //11193 #CJK UNIFIED IDEOGRAPH
    {0xC37B, 0x8105}, //11194 #CJK UNIFIED IDEOGRAPH
    {0xC37C, 0x8107}, //11195 #CJK UNIFIED IDEOGRAPH
    {0xC37D, 0x8108}, //11196 #CJK UNIFIED IDEOGRAPH
    {0xC37E, 0x810B}, //11197 #CJK UNIFIED IDEOGRAPH
    {0xC380, 0x810C}, //11198 #CJK UNIFIED IDEOGRAPH
    {0xC381, 0x8115}, //11199 #CJK UNIFIED IDEOGRAPH
    {0xC382, 0x8117}, //11200 #CJK UNIFIED IDEOGRAPH
    {0xC383, 0x8119}, //11201 #CJK UNIFIED IDEOGRAPH
    {0xC384, 0x811B}, //11202 #CJK UNIFIED IDEOGRAPH
    {0xC385, 0x811C}, //11203 #CJK UNIFIED IDEOGRAPH
    {0xC386, 0x811D}, //11204 #CJK UNIFIED IDEOGRAPH
    {0xC387, 0x811F}, //11205 #CJK UNIFIED IDEOGRAPH
    {0xC388, 0x8120}, //11206 #CJK UNIFIED IDEOGRAPH
    {0xC389, 0x8121}, //11207 #CJK UNIFIED IDEOGRAPH
    {0xC38A, 0x8122}, //11208 #CJK UNIFIED IDEOGRAPH
    {0xC38B, 0x8123}, //11209 #CJK UNIFIED IDEOGRAPH
    {0xC38C, 0x8124}, //11210 #CJK UNIFIED IDEOGRAPH
    {0xC38D, 0x8125}, //11211 #CJK UNIFIED IDEOGRAPH
    {0xC38E, 0x8126}, //11212 #CJK UNIFIED IDEOGRAPH
    {0xC38F, 0x8127}, //11213 #CJK UNIFIED IDEOGRAPH
    {0xC390, 0x8128}, //11214 #CJK UNIFIED IDEOGRAPH
    {0xC391, 0x8129}, //11215 #CJK UNIFIED IDEOGRAPH
    {0xC392, 0x812A}, //11216 #CJK UNIFIED IDEOGRAPH
    {0xC393, 0x812B}, //11217 #CJK UNIFIED IDEOGRAPH
    {0xC394, 0x812D}, //11218 #CJK UNIFIED IDEOGRAPH
    {0xC395, 0x812E}, //11219 #CJK UNIFIED IDEOGRAPH
    {0xC396, 0x8130}, //11220 #CJK UNIFIED IDEOGRAPH
    {0xC397, 0x8133}, //11221 #CJK UNIFIED IDEOGRAPH
    {0xC398, 0x8134}, //11222 #CJK UNIFIED IDEOGRAPH
    {0xC399, 0x8135}, //11223 #CJK UNIFIED IDEOGRAPH
    {0xC39A, 0x8137}, //11224 #CJK UNIFIED IDEOGRAPH
    {0xC39B, 0x8139}, //11225 #CJK UNIFIED IDEOGRAPH
    {0xC39C, 0x813A}, //11226 #CJK UNIFIED IDEOGRAPH
    {0xC39D, 0x813B}, //11227 #CJK UNIFIED IDEOGRAPH
    {0xC39E, 0x813C}, //11228 #CJK UNIFIED IDEOGRAPH
    {0xC39F, 0x813D}, //11229 #CJK UNIFIED IDEOGRAPH
    {0xC3A0, 0x813F}, //11230 #CJK UNIFIED IDEOGRAPH
    {0xC3A1, 0x8C29}, //11231 #CJK UNIFIED IDEOGRAPH
    {0xC3A2, 0x8292}, //11232 #CJK UNIFIED IDEOGRAPH
    {0xC3A3, 0x832B}, //11233 #CJK UNIFIED IDEOGRAPH
    {0xC3A4, 0x76F2}, //11234 #CJK UNIFIED IDEOGRAPH
    {0xC3A5, 0x6C13}, //11235 #CJK UNIFIED IDEOGRAPH
    {0xC3A6, 0x5FD9}, //11236 #CJK UNIFIED IDEOGRAPH
    {0xC3A7, 0x83BD}, //11237 #CJK UNIFIED IDEOGRAPH
    {0xC3A8, 0x732B}, //11238 #CJK UNIFIED IDEOGRAPH
    {0xC3A9, 0x8305}, //11239 #CJK UNIFIED IDEOGRAPH
    {0xC3AA, 0x951A}, //11240 #CJK UNIFIED IDEOGRAPH
    {0xC3AB, 0x6BDB}, //11241 #CJK UNIFIED IDEOGRAPH
    {0xC3AC, 0x77DB}, //11242 #CJK UNIFIED IDEOGRAPH
    {0xC3AD, 0x94C6}, //11243 #CJK UNIFIED IDEOGRAPH
    {0xC3AE, 0x536F}, //11244 #CJK UNIFIED IDEOGRAPH
    {0xC3AF, 0x8302}, //11245 #CJK UNIFIED IDEOGRAPH
    {0xC3B0, 0x5192}, //11246 #CJK UNIFIED IDEOGRAPH
    {0xC3B1, 0x5E3D}, //11247 #CJK UNIFIED IDEOGRAPH
    {0xC3B2, 0x8C8C}, //11248 #CJK UNIFIED IDEOGRAPH
    {0xC3B3, 0x8D38}, //11249 #CJK UNIFIED IDEOGRAPH
    {0xC3B4, 0x4E48}, //11250 #CJK UNIFIED IDEOGRAPH
    {0xC3B5, 0x73AB}, //11251 #CJK UNIFIED IDEOGRAPH
    {0xC3B6, 0x679A}, //11252 #CJK UNIFIED IDEOGRAPH
    {0xC3B7, 0x6885}, //11253 #CJK UNIFIED IDEOGRAPH
    {0xC3B8, 0x9176}, //11254 #CJK UNIFIED IDEOGRAPH
    {0xC3B9, 0x9709}, //11255 #CJK UNIFIED IDEOGRAPH
    {0xC3BA, 0x7164}, //11256 #CJK UNIFIED IDEOGRAPH
    {0xC3BB, 0x6CA1}, //11257 #CJK UNIFIED IDEOGRAPH
    {0xC3BC, 0x7709}, //11258 #CJK UNIFIED IDEOGRAPH
    {0xC3BD, 0x5A92}, //11259 #CJK UNIFIED IDEOGRAPH
    {0xC3BE, 0x9541}, //11260 #CJK UNIFIED IDEOGRAPH
    {0xC3BF, 0x6BCF}, //11261 #CJK UNIFIED IDEOGRAPH
    {0xC3C0, 0x7F8E}, //11262 #CJK UNIFIED IDEOGRAPH
    {0xC3C1, 0x6627}, //11263 #CJK UNIFIED IDEOGRAPH
    {0xC3C2, 0x5BD0}, //11264 #CJK UNIFIED IDEOGRAPH
    {0xC3C3, 0x59B9}, //11265 #CJK UNIFIED IDEOGRAPH
    {0xC3C4, 0x5A9A}, //11266 #CJK UNIFIED IDEOGRAPH
    {0xC3C5, 0x95E8}, //11267 #CJK UNIFIED IDEOGRAPH
    {0xC3C6, 0x95F7}, //11268 #CJK UNIFIED IDEOGRAPH
    {0xC3C7, 0x4EEC}, //11269 #CJK UNIFIED IDEOGRAPH
    {0xC3C8, 0x840C}, //11270 #CJK UNIFIED IDEOGRAPH
    {0xC3C9, 0x8499}, //11271 #CJK UNIFIED IDEOGRAPH
    {0xC3CA, 0x6AAC}, //11272 #CJK UNIFIED IDEOGRAPH
    {0xC3CB, 0x76DF}, //11273 #CJK UNIFIED IDEOGRAPH
    {0xC3CC, 0x9530}, //11274 #CJK UNIFIED IDEOGRAPH
    {0xC3CD, 0x731B}, //11275 #CJK UNIFIED IDEOGRAPH
    {0xC3CE, 0x68A6}, //11276 #CJK UNIFIED IDEOGRAPH
    {0xC3CF, 0x5B5F}, //11277 #CJK UNIFIED IDEOGRAPH
    {0xC3D0, 0x772F}, //11278 #CJK UNIFIED IDEOGRAPH
    {0xC3D1, 0x919A}, //11279 #CJK UNIFIED IDEOGRAPH
    {0xC3D2, 0x9761}, //11280 #CJK UNIFIED IDEOGRAPH
    {0xC3D3, 0x7CDC}, //11281 #CJK UNIFIED IDEOGRAPH
    {0xC3D4, 0x8FF7}, //11282 #CJK UNIFIED IDEOGRAPH
    {0xC3D5, 0x8C1C}, //11283 #CJK UNIFIED IDEOGRAPH
    {0xC3D6, 0x5F25}, //11284 #CJK UNIFIED IDEOGRAPH
    {0xC3D7, 0x7C73}, //11285 #CJK UNIFIED IDEOGRAPH
    {0xC3D8, 0x79D8}, //11286 #CJK UNIFIED IDEOGRAPH
    {0xC3D9, 0x89C5}, //11287 #CJK UNIFIED IDEOGRAPH
    {0xC3DA, 0x6CCC}, //11288 #CJK UNIFIED IDEOGRAPH
    {0xC3DB, 0x871C}, //11289 #CJK UNIFIED IDEOGRAPH
    {0xC3DC, 0x5BC6}, //11290 #CJK UNIFIED IDEOGRAPH
    {0xC3DD, 0x5E42}, //11291 #CJK UNIFIED IDEOGRAPH
    {0xC3DE, 0x68C9}, //11292 #CJK UNIFIED IDEOGRAPH
    {0xC3DF, 0x7720}, //11293 #CJK UNIFIED IDEOGRAPH
    {0xC3E0, 0x7EF5}, //11294 #CJK UNIFIED IDEOGRAPH
    {0xC3E1, 0x5195}, //11295 #CJK UNIFIED IDEOGRAPH
    {0xC3E2, 0x514D}, //11296 #CJK UNIFIED IDEOGRAPH
    {0xC3E3, 0x52C9}, //11297 #CJK UNIFIED IDEOGRAPH
    {0xC3E4, 0x5A29}, //11298 #CJK UNIFIED IDEOGRAPH
    {0xC3E5, 0x7F05}, //11299 #CJK UNIFIED IDEOGRAPH
    {0xC3E6, 0x9762}, //11300 #CJK UNIFIED IDEOGRAPH
    {0xC3E7, 0x82D7}, //11301 #CJK UNIFIED IDEOGRAPH
    {0xC3E8, 0x63CF}, //11302 #CJK UNIFIED IDEOGRAPH
    {0xC3E9, 0x7784}, //11303 #CJK UNIFIED IDEOGRAPH
    {0xC3EA, 0x85D0}, //11304 #CJK UNIFIED IDEOGRAPH
    {0xC3EB, 0x79D2}, //11305 #CJK UNIFIED IDEOGRAPH
    {0xC3EC, 0x6E3A}, //11306 #CJK UNIFIED IDEOGRAPH
    {0xC3ED, 0x5E99}, //11307 #CJK UNIFIED IDEOGRAPH
    {0xC3EE, 0x5999}, //11308 #CJK UNIFIED IDEOGRAPH
    {0xC3EF, 0x8511}, //11309 #CJK UNIFIED IDEOGRAPH
    {0xC3F0, 0x706D}, //11310 #CJK UNIFIED IDEOGRAPH
    {0xC3F1, 0x6C11}, //11311 #CJK UNIFIED IDEOGRAPH
    {0xC3F2, 0x62BF}, //11312 #CJK UNIFIED IDEOGRAPH
    {0xC3F3, 0x76BF}, //11313 #CJK UNIFIED IDEOGRAPH
    {0xC3F4, 0x654F}, //11314 #CJK UNIFIED IDEOGRAPH
    {0xC3F5, 0x60AF}, //11315 #CJK UNIFIED IDEOGRAPH
    {0xC3F6, 0x95FD}, //11316 #CJK UNIFIED IDEOGRAPH
    {0xC3F7, 0x660E}, //11317 #CJK UNIFIED IDEOGRAPH
    {0xC3F8, 0x879F}, //11318 #CJK UNIFIED IDEOGRAPH
    {0xC3F9, 0x9E23}, //11319 #CJK UNIFIED IDEOGRAPH
    {0xC3FA, 0x94ED}, //11320 #CJK UNIFIED IDEOGRAPH
    {0xC3FB, 0x540D}, //11321 #CJK UNIFIED IDEOGRAPH
    {0xC3FC, 0x547D}, //11322 #CJK UNIFIED IDEOGRAPH
    {0xC3FD, 0x8C2C}, //11323 #CJK UNIFIED IDEOGRAPH
    {0xC3FE, 0x6478}, //11324 #CJK UNIFIED IDEOGRAPH
    {0xC440, 0x8140}, //11325 #CJK UNIFIED IDEOGRAPH
    {0xC441, 0x8141}, //11326 #CJK UNIFIED IDEOGRAPH
    {0xC442, 0x8142}, //11327 #CJK UNIFIED IDEOGRAPH
    {0xC443, 0x8143}, //11328 #CJK UNIFIED IDEOGRAPH
    {0xC444, 0x8144}, //11329 #CJK UNIFIED IDEOGRAPH
    {0xC445, 0x8145}, //11330 #CJK UNIFIED IDEOGRAPH
    {0xC446, 0x8147}, //11331 #CJK UNIFIED IDEOGRAPH
    {0xC447, 0x8149}, //11332 #CJK UNIFIED IDEOGRAPH
    {0xC448, 0x814D}, //11333 #CJK UNIFIED IDEOGRAPH
    {0xC449, 0x814E}, //11334 #CJK UNIFIED IDEOGRAPH
    {0xC44A, 0x814F}, //11335 #CJK UNIFIED IDEOGRAPH
    {0xC44B, 0x8152}, //11336 #CJK UNIFIED IDEOGRAPH
    {0xC44C, 0x8156}, //11337 #CJK UNIFIED IDEOGRAPH
    {0xC44D, 0x8157}, //11338 #CJK UNIFIED IDEOGRAPH
    {0xC44E, 0x8158}, //11339 #CJK UNIFIED IDEOGRAPH
    {0xC44F, 0x815B}, //11340 #CJK UNIFIED IDEOGRAPH
    {0xC450, 0x815C}, //11341 #CJK UNIFIED IDEOGRAPH
    {0xC451, 0x815D}, //11342 #CJK UNIFIED IDEOGRAPH
    {0xC452, 0x815E}, //11343 #CJK UNIFIED IDEOGRAPH
    {0xC453, 0x815F}, //11344 #CJK UNIFIED IDEOGRAPH
    {0xC454, 0x8161}, //11345 #CJK UNIFIED IDEOGRAPH
    {0xC455, 0x8162}, //11346 #CJK UNIFIED IDEOGRAPH
    {0xC456, 0x8163}, //11347 #CJK UNIFIED IDEOGRAPH
    {0xC457, 0x8164}, //11348 #CJK UNIFIED IDEOGRAPH
    {0xC458, 0x8166}, //11349 #CJK UNIFIED IDEOGRAPH
    {0xC459, 0x8168}, //11350 #CJK UNIFIED IDEOGRAPH
    {0xC45A, 0x816A}, //11351 #CJK UNIFIED IDEOGRAPH
    {0xC45B, 0x816B}, //11352 #CJK UNIFIED IDEOGRAPH
    {0xC45C, 0x816C}, //11353 #CJK UNIFIED IDEOGRAPH
    {0xC45D, 0x816F}, //11354 #CJK UNIFIED IDEOGRAPH
    {0xC45E, 0x8172}, //11355 #CJK UNIFIED IDEOGRAPH
    {0xC45F, 0x8173}, //11356 #CJK UNIFIED IDEOGRAPH
    {0xC460, 0x8175}, //11357 #CJK UNIFIED IDEOGRAPH
    {0xC461, 0x8176}, //11358 #CJK UNIFIED IDEOGRAPH
    {0xC462, 0x8177}, //11359 #CJK UNIFIED IDEOGRAPH
    {0xC463, 0x8178}, //11360 #CJK UNIFIED IDEOGRAPH
    {0xC464, 0x8181}, //11361 #CJK UNIFIED IDEOGRAPH
    {0xC465, 0x8183}, //11362 #CJK UNIFIED IDEOGRAPH
    {0xC466, 0x8184}, //11363 #CJK UNIFIED IDEOGRAPH
    {0xC467, 0x8185}, //11364 #CJK UNIFIED IDEOGRAPH
    {0xC468, 0x8186}, //11365 #CJK UNIFIED IDEOGRAPH
    {0xC469, 0x8187}, //11366 #CJK UNIFIED IDEOGRAPH
    {0xC46A, 0x8189}, //11367 #CJK UNIFIED IDEOGRAPH
    {0xC46B, 0x818B}, //11368 #CJK UNIFIED IDEOGRAPH
    {0xC46C, 0x818C}, //11369 #CJK UNIFIED IDEOGRAPH
    {0xC46D, 0x818D}, //11370 #CJK UNIFIED IDEOGRAPH
    {0xC46E, 0x818E}, //11371 #CJK UNIFIED IDEOGRAPH
    {0xC46F, 0x8190}, //11372 #CJK UNIFIED IDEOGRAPH
    {0xC470, 0x8192}, //11373 #CJK UNIFIED IDEOGRAPH
    {0xC471, 0x8193}, //11374 #CJK UNIFIED IDEOGRAPH
    {0xC472, 0x8194}, //11375 #CJK UNIFIED IDEOGRAPH
    {0xC473, 0x8195}, //11376 #CJK UNIFIED IDEOGRAPH
    {0xC474, 0x8196}, //11377 #CJK UNIFIED IDEOGRAPH
    {0xC475, 0x8197}, //11378 #CJK UNIFIED IDEOGRAPH
    {0xC476, 0x8199}, //11379 #CJK UNIFIED IDEOGRAPH
    {0xC477, 0x819A}, //11380 #CJK UNIFIED IDEOGRAPH
    {0xC478, 0x819E}, //11381 #CJK UNIFIED IDEOGRAPH
    {0xC479, 0x819F}, //11382 #CJK UNIFIED IDEOGRAPH
    {0xC47A, 0x81A0}, //11383 #CJK UNIFIED IDEOGRAPH
    {0xC47B, 0x81A1}, //11384 #CJK UNIFIED IDEOGRAPH
    {0xC47C, 0x81A2}, //11385 #CJK UNIFIED IDEOGRAPH
    {0xC47D, 0x81A4}, //11386 #CJK UNIFIED IDEOGRAPH
    {0xC47E, 0x81A5}, //11387 #CJK UNIFIED IDEOGRAPH
    {0xC480, 0x81A7}, //11388 #CJK UNIFIED IDEOGRAPH
    {0xC481, 0x81A9}, //11389 #CJK UNIFIED IDEOGRAPH
    {0xC482, 0x81AB}, //11390 #CJK UNIFIED IDEOGRAPH
    {0xC483, 0x81AC}, //11391 #CJK UNIFIED IDEOGRAPH
    {0xC484, 0x81AD}, //11392 #CJK UNIFIED IDEOGRAPH
    {0xC485, 0x81AE}, //11393 #CJK UNIFIED IDEOGRAPH
    {0xC486, 0x81AF}, //11394 #CJK UNIFIED IDEOGRAPH
    {0xC487, 0x81B0}, //11395 #CJK UNIFIED IDEOGRAPH
    {0xC488, 0x81B1}, //11396 #CJK UNIFIED IDEOGRAPH
    {0xC489, 0x81B2}, //11397 #CJK UNIFIED IDEOGRAPH
    {0xC48A, 0x81B4}, //11398 #CJK UNIFIED IDEOGRAPH
    {0xC48B, 0x81B5}, //11399 #CJK UNIFIED IDEOGRAPH
    {0xC48C, 0x81B6}, //11400 #CJK UNIFIED IDEOGRAPH
    {0xC48D, 0x81B7}, //11401 #CJK UNIFIED IDEOGRAPH
    {0xC48E, 0x81B8}, //11402 #CJK UNIFIED IDEOGRAPH
    {0xC48F, 0x81B9}, //11403 #CJK UNIFIED IDEOGRAPH
    {0xC490, 0x81BC}, //11404 #CJK UNIFIED IDEOGRAPH
    {0xC491, 0x81BD}, //11405 #CJK UNIFIED IDEOGRAPH
    {0xC492, 0x81BE}, //11406 #CJK UNIFIED IDEOGRAPH
    {0xC493, 0x81BF}, //11407 #CJK UNIFIED IDEOGRAPH
    {0xC494, 0x81C4}, //11408 #CJK UNIFIED IDEOGRAPH
    {0xC495, 0x81C5}, //11409 #CJK UNIFIED IDEOGRAPH
    {0xC496, 0x81C7}, //11410 #CJK UNIFIED IDEOGRAPH
    {0xC497, 0x81C8}, //11411 #CJK UNIFIED IDEOGRAPH
    {0xC498, 0x81C9}, //11412 #CJK UNIFIED IDEOGRAPH
    {0xC499, 0x81CB}, //11413 #CJK UNIFIED IDEOGRAPH
    {0xC49A, 0x81CD}, //11414 #CJK UNIFIED IDEOGRAPH
    {0xC49B, 0x81CE}, //11415 #CJK UNIFIED IDEOGRAPH
    {0xC49C, 0x81CF}, //11416 #CJK UNIFIED IDEOGRAPH
    {0xC49D, 0x81D0}, //11417 #CJK UNIFIED IDEOGRAPH
    {0xC49E, 0x81D1}, //11418 #CJK UNIFIED IDEOGRAPH
    {0xC49F, 0x81D2}, //11419 #CJK UNIFIED IDEOGRAPH
    {0xC4A0, 0x81D3}, //11420 #CJK UNIFIED IDEOGRAPH
    {0xC4A1, 0x6479}, //11421 #CJK UNIFIED IDEOGRAPH
    {0xC4A2, 0x8611}, //11422 #CJK UNIFIED IDEOGRAPH
    {0xC4A3, 0x6A21}, //11423 #CJK UNIFIED IDEOGRAPH
    {0xC4A4, 0x819C}, //11424 #CJK UNIFIED IDEOGRAPH
    {0xC4A5, 0x78E8}, //11425 #CJK UNIFIED IDEOGRAPH
    {0xC4A6, 0x6469}, //11426 #CJK UNIFIED IDEOGRAPH
    {0xC4A7, 0x9B54}, //11427 #CJK UNIFIED IDEOGRAPH
    {0xC4A8, 0x62B9}, //11428 #CJK UNIFIED IDEOGRAPH
    {0xC4A9, 0x672B}, //11429 #CJK UNIFIED IDEOGRAPH
    {0xC4AA, 0x83AB}, //11430 #CJK UNIFIED IDEOGRAPH
    {0xC4AB, 0x58A8}, //11431 #CJK UNIFIED IDEOGRAPH
    {0xC4AC, 0x9ED8}, //11432 #CJK UNIFIED IDEOGRAPH
    {0xC4AD, 0x6CAB}, //11433 #CJK UNIFIED IDEOGRAPH
    {0xC4AE, 0x6F20}, //11434 #CJK UNIFIED IDEOGRAPH
    {0xC4AF, 0x5BDE}, //11435 #CJK UNIFIED IDEOGRAPH
    {0xC4B0, 0x964C}, //11436 #CJK UNIFIED IDEOGRAPH
    {0xC4B1, 0x8C0B}, //11437 #CJK UNIFIED IDEOGRAPH
    {0xC4B2, 0x725F}, //11438 #CJK UNIFIED IDEOGRAPH
    {0xC4B3, 0x67D0}, //11439 #CJK UNIFIED IDEOGRAPH
    {0xC4B4, 0x62C7}, //11440 #CJK UNIFIED IDEOGRAPH
    {0xC4B5, 0x7261}, //11441 #CJK UNIFIED IDEOGRAPH
    {0xC4B6, 0x4EA9}, //11442 #CJK UNIFIED IDEOGRAPH
    {0xC4B7, 0x59C6}, //11443 #CJK UNIFIED IDEOGRAPH
    {0xC4B8, 0x6BCD}, //11444 #CJK UNIFIED IDEOGRAPH
    {0xC4B9, 0x5893}, //11445 #CJK UNIFIED IDEOGRAPH
    {0xC4BA, 0x66AE}, //11446 #CJK UNIFIED IDEOGRAPH
    {0xC4BB, 0x5E55}, //11447 #CJK UNIFIED IDEOGRAPH
    {0xC4BC, 0x52DF}, //11448 #CJK UNIFIED IDEOGRAPH
    {0xC4BD, 0x6155}, //11449 #CJK UNIFIED IDEOGRAPH
    {0xC4BE, 0x6728}, //11450 #CJK UNIFIED IDEOGRAPH
    {0xC4BF, 0x76EE}, //11451 #CJK UNIFIED IDEOGRAPH
    {0xC4C0, 0x7766}, //11452 #CJK UNIFIED IDEOGRAPH
    {0xC4C1, 0x7267}, //11453 #CJK UNIFIED IDEOGRAPH
    {0xC4C2, 0x7A46}, //11454 #CJK UNIFIED IDEOGRAPH
    {0xC4C3, 0x62FF}, //11455 #CJK UNIFIED IDEOGRAPH
    {0xC4C4, 0x54EA}, //11456 #CJK UNIFIED IDEOGRAPH
    {0xC4C5, 0x5450}, //11457 #CJK UNIFIED IDEOGRAPH
    {0xC4C6, 0x94A0}, //11458 #CJK UNIFIED IDEOGRAPH
    {0xC4C7, 0x90A3}, //11459 #CJK UNIFIED IDEOGRAPH
    {0xC4C8, 0x5A1C}, //11460 #CJK UNIFIED IDEOGRAPH
    {0xC4C9, 0x7EB3}, //11461 #CJK UNIFIED IDEOGRAPH
    {0xC4CA, 0x6C16}, //11462 #CJK UNIFIED IDEOGRAPH
    {0xC4CB, 0x4E43}, //11463 #CJK UNIFIED IDEOGRAPH
    {0xC4CC, 0x5976}, //11464 #CJK UNIFIED IDEOGRAPH
    {0xC4CD, 0x8010}, //11465 #CJK UNIFIED IDEOGRAPH
    {0xC4CE, 0x5948}, //11466 #CJK UNIFIED IDEOGRAPH
    {0xC4CF, 0x5357}, //11467 #CJK UNIFIED IDEOGRAPH
    {0xC4D0, 0x7537}, //11468 #CJK UNIFIED IDEOGRAPH
    {0xC4D1, 0x96BE}, //11469 #CJK UNIFIED IDEOGRAPH
    {0xC4D2, 0x56CA}, //11470 #CJK UNIFIED IDEOGRAPH
    {0xC4D3, 0x6320}, //11471 #CJK UNIFIED IDEOGRAPH
    {0xC4D4, 0x8111}, //11472 #CJK UNIFIED IDEOGRAPH
    {0xC4D5, 0x607C}, //11473 #CJK UNIFIED IDEOGRAPH
    {0xC4D6, 0x95F9}, //11474 #CJK UNIFIED IDEOGRAPH
    {0xC4D7, 0x6DD6}, //11475 #CJK UNIFIED IDEOGRAPH
    {0xC4D8, 0x5462}, //11476 #CJK UNIFIED IDEOGRAPH
    {0xC4D9, 0x9981}, //11477 #CJK UNIFIED IDEOGRAPH
    {0xC4DA, 0x5185}, //11478 #CJK UNIFIED IDEOGRAPH
    {0xC4DB, 0x5AE9}, //11479 #CJK UNIFIED IDEOGRAPH
    {0xC4DC, 0x80FD}, //11480 #CJK UNIFIED IDEOGRAPH
    {0xC4DD, 0x59AE}, //11481 #CJK UNIFIED IDEOGRAPH
    {0xC4DE, 0x9713}, //11482 #CJK UNIFIED IDEOGRAPH
    {0xC4DF, 0x502A}, //11483 #CJK UNIFIED IDEOGRAPH
    {0xC4E0, 0x6CE5}, //11484 #CJK UNIFIED IDEOGRAPH
    {0xC4E1, 0x5C3C}, //11485 #CJK UNIFIED IDEOGRAPH
    {0xC4E2, 0x62DF}, //11486 #CJK UNIFIED IDEOGRAPH
    {0xC4E3, 0x4F60}, //11487 #CJK UNIFIED IDEOGRAPH
    {0xC4E4, 0x533F}, //11488 #CJK UNIFIED IDEOGRAPH
    {0xC4E5, 0x817B}, //11489 #CJK UNIFIED IDEOGRAPH
    {0xC4E6, 0x9006}, //11490 #CJK UNIFIED IDEOGRAPH
    {0xC4E7, 0x6EBA}, //11491 #CJK UNIFIED IDEOGRAPH
    {0xC4E8, 0x852B}, //11492 #CJK UNIFIED IDEOGRAPH
    {0xC4E9, 0x62C8}, //11493 #CJK UNIFIED IDEOGRAPH
    {0xC4EA, 0x5E74}, //11494 #CJK UNIFIED IDEOGRAPH
    {0xC4EB, 0x78BE}, //11495 #CJK UNIFIED IDEOGRAPH
    {0xC4EC, 0x64B5}, //11496 #CJK UNIFIED IDEOGRAPH
    {0xC4ED, 0x637B}, //11497 #CJK UNIFIED IDEOGRAPH
    {0xC4EE, 0x5FF5}, //11498 #CJK UNIFIED IDEOGRAPH
    {0xC4EF, 0x5A18}, //11499 #CJK UNIFIED IDEOGRAPH
    {0xC4F0, 0x917F}, //11500 #CJK UNIFIED IDEOGRAPH
    {0xC4F1, 0x9E1F}, //11501 #CJK UNIFIED IDEOGRAPH
    {0xC4F2, 0x5C3F}, //11502 #CJK UNIFIED IDEOGRAPH
    {0xC4F3, 0x634F}, //11503 #CJK UNIFIED IDEOGRAPH
    {0xC4F4, 0x8042}, //11504 #CJK UNIFIED IDEOGRAPH
    {0xC4F5, 0x5B7D}, //11505 #CJK UNIFIED IDEOGRAPH
    {0xC4F6, 0x556E}, //11506 #CJK UNIFIED IDEOGRAPH
    {0xC4F7, 0x954A}, //11507 #CJK UNIFIED IDEOGRAPH
    {0xC4F8, 0x954D}, //11508 #CJK UNIFIED IDEOGRAPH
    {0xC4F9, 0x6D85}, //11509 #CJK UNIFIED IDEOGRAPH
    {0xC4FA, 0x60A8}, //11510 #CJK UNIFIED IDEOGRAPH
    {0xC4FB, 0x67E0}, //11511 #CJK UNIFIED IDEOGRAPH
    {0xC4FC, 0x72DE}, //11512 #CJK UNIFIED IDEOGRAPH
    {0xC4FD, 0x51DD}, //11513 #CJK UNIFIED IDEOGRAPH
    {0xC4FE, 0x5B81}, //11514 #CJK UNIFIED IDEOGRAPH
    {0xC540, 0x81D4}, //11515 #CJK UNIFIED IDEOGRAPH
    {0xC541, 0x81D5}, //11516 #CJK UNIFIED IDEOGRAPH
    {0xC542, 0x81D6}, //11517 #CJK UNIFIED IDEOGRAPH
    {0xC543, 0x81D7}, //11518 #CJK UNIFIED IDEOGRAPH
    {0xC544, 0x81D8}, //11519 #CJK UNIFIED IDEOGRAPH
    {0xC545, 0x81D9}, //11520 #CJK UNIFIED IDEOGRAPH
    {0xC546, 0x81DA}, //11521 #CJK UNIFIED IDEOGRAPH
    {0xC547, 0x81DB}, //11522 #CJK UNIFIED IDEOGRAPH
    {0xC548, 0x81DC}, //11523 #CJK UNIFIED IDEOGRAPH
    {0xC549, 0x81DD}, //11524 #CJK UNIFIED IDEOGRAPH
    {0xC54A, 0x81DE}, //11525 #CJK UNIFIED IDEOGRAPH
    {0xC54B, 0x81DF}, //11526 #CJK UNIFIED IDEOGRAPH
    {0xC54C, 0x81E0}, //11527 #CJK UNIFIED IDEOGRAPH
    {0xC54D, 0x81E1}, //11528 #CJK UNIFIED IDEOGRAPH
    {0xC54E, 0x81E2}, //11529 #CJK UNIFIED IDEOGRAPH
    {0xC54F, 0x81E4}, //11530 #CJK UNIFIED IDEOGRAPH
    {0xC550, 0x81E5}, //11531 #CJK UNIFIED IDEOGRAPH
    {0xC551, 0x81E6}, //11532 #CJK UNIFIED IDEOGRAPH
    {0xC552, 0x81E8}, //11533 #CJK UNIFIED IDEOGRAPH
    {0xC553, 0x81E9}, //11534 #CJK UNIFIED IDEOGRAPH
    {0xC554, 0x81EB}, //11535 #CJK UNIFIED IDEOGRAPH
    {0xC555, 0x81EE}, //11536 #CJK UNIFIED IDEOGRAPH
    {0xC556, 0x81EF}, //11537 #CJK UNIFIED IDEOGRAPH
    {0xC557, 0x81F0}, //11538 #CJK UNIFIED IDEOGRAPH
    {0xC558, 0x81F1}, //11539 #CJK UNIFIED IDEOGRAPH
    {0xC559, 0x81F2}, //11540 #CJK UNIFIED IDEOGRAPH
    {0xC55A, 0x81F5}, //11541 #CJK UNIFIED IDEOGRAPH
    {0xC55B, 0x81F6}, //11542 #CJK UNIFIED IDEOGRAPH
    {0xC55C, 0x81F7}, //11543 #CJK UNIFIED IDEOGRAPH
    {0xC55D, 0x81F8}, //11544 #CJK UNIFIED IDEOGRAPH
    {0xC55E, 0x81F9}, //11545 #CJK UNIFIED IDEOGRAPH
    {0xC55F, 0x81FA}, //11546 #CJK UNIFIED IDEOGRAPH
    {0xC560, 0x81FD}, //11547 #CJK UNIFIED IDEOGRAPH
    {0xC561, 0x81FF}, //11548 #CJK UNIFIED IDEOGRAPH
    {0xC562, 0x8203}, //11549 #CJK UNIFIED IDEOGRAPH
    {0xC563, 0x8207}, //11550 #CJK UNIFIED IDEOGRAPH
    {0xC564, 0x8208}, //11551 #CJK UNIFIED IDEOGRAPH
    {0xC565, 0x8209}, //11552 #CJK UNIFIED IDEOGRAPH
    {0xC566, 0x820A}, //11553 #CJK UNIFIED IDEOGRAPH
    {0xC567, 0x820B}, //11554 #CJK UNIFIED IDEOGRAPH
    {0xC568, 0x820E}, //11555 #CJK UNIFIED IDEOGRAPH
    {0xC569, 0x820F}, //11556 #CJK UNIFIED IDEOGRAPH
    {0xC56A, 0x8211}, //11557 #CJK UNIFIED IDEOGRAPH
    {0xC56B, 0x8213}, //11558 #CJK UNIFIED IDEOGRAPH
    {0xC56C, 0x8215}, //11559 #CJK UNIFIED IDEOGRAPH
    {0xC56D, 0x8216}, //11560 #CJK UNIFIED IDEOGRAPH
    {0xC56E, 0x8217}, //11561 #CJK UNIFIED IDEOGRAPH
    {0xC56F, 0x8218}, //11562 #CJK UNIFIED IDEOGRAPH
    {0xC570, 0x8219}, //11563 #CJK UNIFIED IDEOGRAPH
    {0xC571, 0x821A}, //11564 #CJK UNIFIED IDEOGRAPH
    {0xC572, 0x821D}, //11565 #CJK UNIFIED IDEOGRAPH
    {0xC573, 0x8220}, //11566 #CJK UNIFIED IDEOGRAPH
    {0xC574, 0x8224}, //11567 #CJK UNIFIED IDEOGRAPH
    {0xC575, 0x8225}, //11568 #CJK UNIFIED IDEOGRAPH
    {0xC576, 0x8226}, //11569 #CJK UNIFIED IDEOGRAPH
    {0xC577, 0x8227}, //11570 #CJK UNIFIED IDEOGRAPH
    {0xC578, 0x8229}, //11571 #CJK UNIFIED IDEOGRAPH
    {0xC579, 0x822E}, //11572 #CJK UNIFIED IDEOGRAPH
    {0xC57A, 0x8232}, //11573 #CJK UNIFIED IDEOGRAPH
    {0xC57B, 0x823A}, //11574 #CJK UNIFIED IDEOGRAPH
    {0xC57C, 0x823C}, //11575 #CJK UNIFIED IDEOGRAPH
    {0xC57D, 0x823D}, //11576 #CJK UNIFIED IDEOGRAPH
    {0xC57E, 0x823F}, //11577 #CJK UNIFIED IDEOGRAPH
    {0xC580, 0x8240}, //11578 #CJK UNIFIED IDEOGRAPH
    {0xC581, 0x8241}, //11579 #CJK UNIFIED IDEOGRAPH
    {0xC582, 0x8242}, //11580 #CJK UNIFIED IDEOGRAPH
    {0xC583, 0x8243}, //11581 #CJK UNIFIED IDEOGRAPH
    {0xC584, 0x8245}, //11582 #CJK UNIFIED IDEOGRAPH
    {0xC585, 0x8246}, //11583 #CJK UNIFIED IDEOGRAPH
    {0xC586, 0x8248}, //11584 #CJK UNIFIED IDEOGRAPH
    {0xC587, 0x824A}, //11585 #CJK UNIFIED IDEOGRAPH
    {0xC588, 0x824C}, //11586 #CJK UNIFIED IDEOGRAPH
    {0xC589, 0x824D}, //11587 #CJK UNIFIED IDEOGRAPH
    {0xC58A, 0x824E}, //11588 #CJK UNIFIED IDEOGRAPH
    {0xC58B, 0x8250}, //11589 #CJK UNIFIED IDEOGRAPH
    {0xC58C, 0x8251}, //11590 #CJK UNIFIED IDEOGRAPH
    {0xC58D, 0x8252}, //11591 #CJK UNIFIED IDEOGRAPH
    {0xC58E, 0x8253}, //11592 #CJK UNIFIED IDEOGRAPH
    {0xC58F, 0x8254}, //11593 #CJK UNIFIED IDEOGRAPH
    {0xC590, 0x8255}, //11594 #CJK UNIFIED IDEOGRAPH
    {0xC591, 0x8256}, //11595 #CJK UNIFIED IDEOGRAPH
    {0xC592, 0x8257}, //11596 #CJK UNIFIED IDEOGRAPH
    {0xC593, 0x8259}, //11597 #CJK UNIFIED IDEOGRAPH
    {0xC594, 0x825B}, //11598 #CJK UNIFIED IDEOGRAPH
    {0xC595, 0x825C}, //11599 #CJK UNIFIED IDEOGRAPH
    {0xC596, 0x825D}, //11600 #CJK UNIFIED IDEOGRAPH
    {0xC597, 0x825E}, //11601 #CJK UNIFIED IDEOGRAPH
    {0xC598, 0x8260}, //11602 #CJK UNIFIED IDEOGRAPH
    {0xC599, 0x8261}, //11603 #CJK UNIFIED IDEOGRAPH
    {0xC59A, 0x8262}, //11604 #CJK UNIFIED IDEOGRAPH
    {0xC59B, 0x8263}, //11605 #CJK UNIFIED IDEOGRAPH
    {0xC59C, 0x8264}, //11606 #CJK UNIFIED IDEOGRAPH
    {0xC59D, 0x8265}, //11607 #CJK UNIFIED IDEOGRAPH
    {0xC59E, 0x8266}, //11608 #CJK UNIFIED IDEOGRAPH
    {0xC59F, 0x8267}, //11609 #CJK UNIFIED IDEOGRAPH
    {0xC5A0, 0x8269}, //11610 #CJK UNIFIED IDEOGRAPH
    {0xC5A1, 0x62E7}, //11611 #CJK UNIFIED IDEOGRAPH
    {0xC5A2, 0x6CDE}, //11612 #CJK UNIFIED IDEOGRAPH
    {0xC5A3, 0x725B}, //11613 #CJK UNIFIED IDEOGRAPH
    {0xC5A4, 0x626D}, //11614 #CJK UNIFIED IDEOGRAPH
    {0xC5A5, 0x94AE}, //11615 #CJK UNIFIED IDEOGRAPH
    {0xC5A6, 0x7EBD}, //11616 #CJK UNIFIED IDEOGRAPH
    {0xC5A7, 0x8113}, //11617 #CJK UNIFIED IDEOGRAPH
    {0xC5A8, 0x6D53}, //11618 #CJK UNIFIED IDEOGRAPH
    {0xC5A9, 0x519C}, //11619 #CJK UNIFIED IDEOGRAPH
    {0xC5AA, 0x5F04}, //11620 #CJK UNIFIED IDEOGRAPH
    {0xC5AB, 0x5974}, //11621 #CJK UNIFIED IDEOGRAPH
    {0xC5AC, 0x52AA}, //11622 #CJK UNIFIED IDEOGRAPH
    {0xC5AD, 0x6012}, //11623 #CJK UNIFIED IDEOGRAPH
    {0xC5AE, 0x5973}, //11624 #CJK UNIFIED IDEOGRAPH
    {0xC5AF, 0x6696}, //11625 #CJK UNIFIED IDEOGRAPH
    {0xC5B0, 0x8650}, //11626 #CJK UNIFIED IDEOGRAPH
    {0xC5B1, 0x759F}, //11627 #CJK UNIFIED IDEOGRAPH
    {0xC5B2, 0x632A}, //11628 #CJK UNIFIED IDEOGRAPH
    {0xC5B3, 0x61E6}, //11629 #CJK UNIFIED IDEOGRAPH
    {0xC5B4, 0x7CEF}, //11630 #CJK UNIFIED IDEOGRAPH
    {0xC5B5, 0x8BFA}, //11631 #CJK UNIFIED IDEOGRAPH
    {0xC5B6, 0x54E6}, //11632 #CJK UNIFIED IDEOGRAPH
    {0xC5B7, 0x6B27}, //11633 #CJK UNIFIED IDEOGRAPH
    {0xC5B8, 0x9E25}, //11634 #CJK UNIFIED IDEOGRAPH
    {0xC5B9, 0x6BB4}, //11635 #CJK UNIFIED IDEOGRAPH
    {0xC5BA, 0x85D5}, //11636 #CJK UNIFIED IDEOGRAPH
    {0xC5BB, 0x5455}, //11637 #CJK UNIFIED IDEOGRAPH
    {0xC5BC, 0x5076}, //11638 #CJK UNIFIED IDEOGRAPH
    {0xC5BD, 0x6CA4}, //11639 #CJK UNIFIED IDEOGRAPH
    {0xC5BE, 0x556A}, //11640 #CJK UNIFIED IDEOGRAPH
    {0xC5BF, 0x8DB4}, //11641 #CJK UNIFIED IDEOGRAPH
    {0xC5C0, 0x722C}, //11642 #CJK UNIFIED IDEOGRAPH
    {0xC5C1, 0x5E15}, //11643 #CJK UNIFIED IDEOGRAPH
    {0xC5C2, 0x6015}, //11644 #CJK UNIFIED IDEOGRAPH
    {0xC5C3, 0x7436}, //11645 #CJK UNIFIED IDEOGRAPH
    {0xC5C4, 0x62CD}, //11646 #CJK UNIFIED IDEOGRAPH
    {0xC5C5, 0x6392}, //11647 #CJK UNIFIED IDEOGRAPH
    {0xC5C6, 0x724C}, //11648 #CJK UNIFIED IDEOGRAPH
    {0xC5C7, 0x5F98}, //11649 #CJK UNIFIED IDEOGRAPH
    {0xC5C8, 0x6E43}, //11650 #CJK UNIFIED IDEOGRAPH
    {0xC5C9, 0x6D3E}, //11651 #CJK UNIFIED IDEOGRAPH
    {0xC5CA, 0x6500}, //11652 #CJK UNIFIED IDEOGRAPH
    {0xC5CB, 0x6F58}, //11653 #CJK UNIFIED IDEOGRAPH
    {0xC5CC, 0x76D8}, //11654 #CJK UNIFIED IDEOGRAPH
    {0xC5CD, 0x78D0}, //11655 #CJK UNIFIED IDEOGRAPH
    {0xC5CE, 0x76FC}, //11656 #CJK UNIFIED IDEOGRAPH
    {0xC5CF, 0x7554}, //11657 #CJK UNIFIED IDEOGRAPH
    {0xC5D0, 0x5224}, //11658 #CJK UNIFIED IDEOGRAPH
    {0xC5D1, 0x53DB}, //11659 #CJK UNIFIED IDEOGRAPH
    {0xC5D2, 0x4E53}, //11660 #CJK UNIFIED IDEOGRAPH
    {0xC5D3, 0x5E9E}, //11661 #CJK UNIFIED IDEOGRAPH
    {0xC5D4, 0x65C1}, //11662 #CJK UNIFIED IDEOGRAPH
    {0xC5D5, 0x802A}, //11663 #CJK UNIFIED IDEOGRAPH
    {0xC5D6, 0x80D6}, //11664 #CJK UNIFIED IDEOGRAPH
    {0xC5D7, 0x629B}, //11665 #CJK UNIFIED IDEOGRAPH
    {0xC5D8, 0x5486}, //11666 #CJK UNIFIED IDEOGRAPH
    {0xC5D9, 0x5228}, //11667 #CJK UNIFIED IDEOGRAPH
    {0xC5DA, 0x70AE}, //11668 #CJK UNIFIED IDEOGRAPH
    {0xC5DB, 0x888D}, //11669 #CJK UNIFIED IDEOGRAPH
    {0xC5DC, 0x8DD1}, //11670 #CJK UNIFIED IDEOGRAPH
    {0xC5DD, 0x6CE1}, //11671 #CJK UNIFIED IDEOGRAPH
    {0xC5DE, 0x5478}, //11672 #CJK UNIFIED IDEOGRAPH
    {0xC5DF, 0x80DA}, //11673 #CJK UNIFIED IDEOGRAPH
    {0xC5E0, 0x57F9}, //11674 #CJK UNIFIED IDEOGRAPH
    {0xC5E1, 0x88F4}, //11675 #CJK UNIFIED IDEOGRAPH
    {0xC5E2, 0x8D54}, //11676 #CJK UNIFIED IDEOGRAPH
    {0xC5E3, 0x966A}, //11677 #CJK UNIFIED IDEOGRAPH
    {0xC5E4, 0x914D}, //11678 #CJK UNIFIED IDEOGRAPH
    {0xC5E5, 0x4F69}, //11679 #CJK UNIFIED IDEOGRAPH
    {0xC5E6, 0x6C9B}, //11680 #CJK UNIFIED IDEOGRAPH
    {0xC5E7, 0x55B7}, //11681 #CJK UNIFIED IDEOGRAPH
    {0xC5E8, 0x76C6}, //11682 #CJK UNIFIED IDEOGRAPH
    {0xC5E9, 0x7830}, //11683 #CJK UNIFIED IDEOGRAPH
    {0xC5EA, 0x62A8}, //11684 #CJK UNIFIED IDEOGRAPH
    {0xC5EB, 0x70F9}, //11685 #CJK UNIFIED IDEOGRAPH
    {0xC5EC, 0x6F8E}, //11686 #CJK UNIFIED IDEOGRAPH
    {0xC5ED, 0x5F6D}, //11687 #CJK UNIFIED IDEOGRAPH
    {0xC5EE, 0x84EC}, //11688 #CJK UNIFIED IDEOGRAPH
    {0xC5EF, 0x68DA}, //11689 #CJK UNIFIED IDEOGRAPH
    {0xC5F0, 0x787C}, //11690 #CJK UNIFIED IDEOGRAPH
    {0xC5F1, 0x7BF7}, //11691 #CJK UNIFIED IDEOGRAPH
    {0xC5F2, 0x81A8}, //11692 #CJK UNIFIED IDEOGRAPH
    {0xC5F3, 0x670B}, //11693 #CJK UNIFIED IDEOGRAPH
    {0xC5F4, 0x9E4F}, //11694 #CJK UNIFIED IDEOGRAPH
    {0xC5F5, 0x6367}, //11695 #CJK UNIFIED IDEOGRAPH
    {0xC5F6, 0x78B0}, //11696 #CJK UNIFIED IDEOGRAPH
    {0xC5F7, 0x576F}, //11697 #CJK UNIFIED IDEOGRAPH
    {0xC5F8, 0x7812}, //11698 #CJK UNIFIED IDEOGRAPH
    {0xC5F9, 0x9739}, //11699 #CJK UNIFIED IDEOGRAPH
    {0xC5FA, 0x6279}, //11700 #CJK UNIFIED IDEOGRAPH
    {0xC5FB, 0x62AB}, //11701 #CJK UNIFIED IDEOGRAPH
    {0xC5FC, 0x5288}, //11702 #CJK UNIFIED IDEOGRAPH
    {0xC5FD, 0x7435}, //11703 #CJK UNIFIED IDEOGRAPH
    {0xC5FE, 0x6BD7}, //11704 #CJK UNIFIED IDEOGRAPH
    {0xC640, 0x826A}, //11705 #CJK UNIFIED IDEOGRAPH
    {0xC641, 0x826B}, //11706 #CJK UNIFIED IDEOGRAPH
    {0xC642, 0x826C}, //11707 #CJK UNIFIED IDEOGRAPH
    {0xC643, 0x826D}, //11708 #CJK UNIFIED IDEOGRAPH
    {0xC644, 0x8271}, //11709 #CJK UNIFIED IDEOGRAPH
    {0xC645, 0x8275}, //11710 #CJK UNIFIED IDEOGRAPH
    {0xC646, 0x8276}, //11711 #CJK UNIFIED IDEOGRAPH
    {0xC647, 0x8277}, //11712 #CJK UNIFIED IDEOGRAPH
    {0xC648, 0x8278}, //11713 #CJK UNIFIED IDEOGRAPH
    {0xC649, 0x827B}, //11714 #CJK UNIFIED IDEOGRAPH
    {0xC64A, 0x827C}, //11715 #CJK UNIFIED IDEOGRAPH
    {0xC64B, 0x8280}, //11716 #CJK UNIFIED IDEOGRAPH
    {0xC64C, 0x8281}, //11717 #CJK UNIFIED IDEOGRAPH
    {0xC64D, 0x8283}, //11718 #CJK UNIFIED IDEOGRAPH
    {0xC64E, 0x8285}, //11719 #CJK UNIFIED IDEOGRAPH
    {0xC64F, 0x8286}, //11720 #CJK UNIFIED IDEOGRAPH
    {0xC650, 0x8287}, //11721 #CJK UNIFIED IDEOGRAPH
    {0xC651, 0x8289}, //11722 #CJK UNIFIED IDEOGRAPH
    {0xC652, 0x828C}, //11723 #CJK UNIFIED IDEOGRAPH
    {0xC653, 0x8290}, //11724 #CJK UNIFIED IDEOGRAPH
    {0xC654, 0x8293}, //11725 #CJK UNIFIED IDEOGRAPH
    {0xC655, 0x8294}, //11726 #CJK UNIFIED IDEOGRAPH
    {0xC656, 0x8295}, //11727 #CJK UNIFIED IDEOGRAPH
    {0xC657, 0x8296}, //11728 #CJK UNIFIED IDEOGRAPH
    {0xC658, 0x829A}, //11729 #CJK UNIFIED IDEOGRAPH
    {0xC659, 0x829B}, //11730 #CJK UNIFIED IDEOGRAPH
    {0xC65A, 0x829E}, //11731 #CJK UNIFIED IDEOGRAPH
    {0xC65B, 0x82A0}, //11732 #CJK UNIFIED IDEOGRAPH
    {0xC65C, 0x82A2}, //11733 #CJK UNIFIED IDEOGRAPH
    {0xC65D, 0x82A3}, //11734 #CJK UNIFIED IDEOGRAPH
    {0xC65E, 0x82A7}, //11735 #CJK UNIFIED IDEOGRAPH
    {0xC65F, 0x82B2}, //11736 #CJK UNIFIED IDEOGRAPH
    {0xC660, 0x82B5}, //11737 #CJK UNIFIED IDEOGRAPH
    {0xC661, 0x82B6}, //11738 #CJK UNIFIED IDEOGRAPH
    {0xC662, 0x82BA}, //11739 #CJK UNIFIED IDEOGRAPH
    {0xC663, 0x82BB}, //11740 #CJK UNIFIED IDEOGRAPH
    {0xC664, 0x82BC}, //11741 #CJK UNIFIED IDEOGRAPH
    {0xC665, 0x82BF}, //11742 #CJK UNIFIED IDEOGRAPH
    {0xC666, 0x82C0}, //11743 #CJK UNIFIED IDEOGRAPH
    {0xC667, 0x82C2}, //11744 #CJK UNIFIED IDEOGRAPH
    {0xC668, 0x82C3}, //11745 #CJK UNIFIED IDEOGRAPH
    {0xC669, 0x82C5}, //11746 #CJK UNIFIED IDEOGRAPH
    {0xC66A, 0x82C6}, //11747 #CJK UNIFIED IDEOGRAPH
    {0xC66B, 0x82C9}, //11748 #CJK UNIFIED IDEOGRAPH
    {0xC66C, 0x82D0}, //11749 #CJK UNIFIED IDEOGRAPH
    {0xC66D, 0x82D6}, //11750 #CJK UNIFIED IDEOGRAPH
    {0xC66E, 0x82D9}, //11751 #CJK UNIFIED IDEOGRAPH
    {0xC66F, 0x82DA}, //11752 #CJK UNIFIED IDEOGRAPH
    {0xC670, 0x82DD}, //11753 #CJK UNIFIED IDEOGRAPH
    {0xC671, 0x82E2}, //11754 #CJK UNIFIED IDEOGRAPH
    {0xC672, 0x82E7}, //11755 #CJK UNIFIED IDEOGRAPH
    {0xC673, 0x82E8}, //11756 #CJK UNIFIED IDEOGRAPH
    {0xC674, 0x82E9}, //11757 #CJK UNIFIED IDEOGRAPH
    {0xC675, 0x82EA}, //11758 #CJK UNIFIED IDEOGRAPH
    {0xC676, 0x82EC}, //11759 #CJK UNIFIED IDEOGRAPH
    {0xC677, 0x82ED}, //11760 #CJK UNIFIED IDEOGRAPH
    {0xC678, 0x82EE}, //11761 #CJK UNIFIED IDEOGRAPH
    {0xC679, 0x82F0}, //11762 #CJK UNIFIED IDEOGRAPH
    {0xC67A, 0x82F2}, //11763 #CJK UNIFIED IDEOGRAPH
    {0xC67B, 0x82F3}, //11764 #CJK UNIFIED IDEOGRAPH
    {0xC67C, 0x82F5}, //11765 #CJK UNIFIED IDEOGRAPH
    {0xC67D, 0x82F6}, //11766 #CJK UNIFIED IDEOGRAPH
    {0xC67E, 0x82F8}, //11767 #CJK UNIFIED IDEOGRAPH
    {0xC680, 0x82FA}, //11768 #CJK UNIFIED IDEOGRAPH
    {0xC681, 0x82FC}, //11769 #CJK UNIFIED IDEOGRAPH
    {0xC682, 0x82FD}, //11770 #CJK UNIFIED IDEOGRAPH
    {0xC683, 0x82FE}, //11771 #CJK UNIFIED IDEOGRAPH
    {0xC684, 0x82FF}, //11772 #CJK UNIFIED IDEOGRAPH
    {0xC685, 0x8300}, //11773 #CJK UNIFIED IDEOGRAPH
    {0xC686, 0x830A}, //11774 #CJK UNIFIED IDEOGRAPH
    {0xC687, 0x830B}, //11775 #CJK UNIFIED IDEOGRAPH
    {0xC688, 0x830D}, //11776 #CJK UNIFIED IDEOGRAPH
    {0xC689, 0x8310}, //11777 #CJK UNIFIED IDEOGRAPH
    {0xC68A, 0x8312}, //11778 #CJK UNIFIED IDEOGRAPH
    {0xC68B, 0x8313}, //11779 #CJK UNIFIED IDEOGRAPH
    {0xC68C, 0x8316}, //11780 #CJK UNIFIED IDEOGRAPH
    {0xC68D, 0x8318}, //11781 #CJK UNIFIED IDEOGRAPH
    {0xC68E, 0x8319}, //11782 #CJK UNIFIED IDEOGRAPH
    {0xC68F, 0x831D}, //11783 #CJK UNIFIED IDEOGRAPH
    {0xC690, 0x831E}, //11784 #CJK UNIFIED IDEOGRAPH
    {0xC691, 0x831F}, //11785 #CJK UNIFIED IDEOGRAPH
    {0xC692, 0x8320}, //11786 #CJK UNIFIED IDEOGRAPH
    {0xC693, 0x8321}, //11787 #CJK UNIFIED IDEOGRAPH
    {0xC694, 0x8322}, //11788 #CJK UNIFIED IDEOGRAPH
    {0xC695, 0x8323}, //11789 #CJK UNIFIED IDEOGRAPH
    {0xC696, 0x8324}, //11790 #CJK UNIFIED IDEOGRAPH
    {0xC697, 0x8325}, //11791 #CJK UNIFIED IDEOGRAPH
    {0xC698, 0x8326}, //11792 #CJK UNIFIED IDEOGRAPH
    {0xC699, 0x8329}, //11793 #CJK UNIFIED IDEOGRAPH
    {0xC69A, 0x832A}, //11794 #CJK UNIFIED IDEOGRAPH
    {0xC69B, 0x832E}, //11795 #CJK UNIFIED IDEOGRAPH
    {0xC69C, 0x8330}, //11796 #CJK UNIFIED IDEOGRAPH
    {0xC69D, 0x8332}, //11797 #CJK UNIFIED IDEOGRAPH
    {0xC69E, 0x8337}, //11798 #CJK UNIFIED IDEOGRAPH
    {0xC69F, 0x833B}, //11799 #CJK UNIFIED IDEOGRAPH
    {0xC6A0, 0x833D}, //11800 #CJK UNIFIED IDEOGRAPH
    {0xC6A1, 0x5564}, //11801 #CJK UNIFIED IDEOGRAPH
    {0xC6A2, 0x813E}, //11802 #CJK UNIFIED IDEOGRAPH
    {0xC6A3, 0x75B2}, //11803 #CJK UNIFIED IDEOGRAPH
    {0xC6A4, 0x76AE}, //11804 #CJK UNIFIED IDEOGRAPH
    {0xC6A5, 0x5339}, //11805 #CJK UNIFIED IDEOGRAPH
    {0xC6A6, 0x75DE}, //11806 #CJK UNIFIED IDEOGRAPH
    {0xC6A7, 0x50FB}, //11807 #CJK UNIFIED IDEOGRAPH
    {0xC6A8, 0x5C41}, //11808 #CJK UNIFIED IDEOGRAPH
    {0xC6A9, 0x8B6C}, //11809 #CJK UNIFIED IDEOGRAPH
    {0xC6AA, 0x7BC7}, //11810 #CJK UNIFIED IDEOGRAPH
    {0xC6AB, 0x504F}, //11811 #CJK UNIFIED IDEOGRAPH
    {0xC6AC, 0x7247}, //11812 #CJK UNIFIED IDEOGRAPH
    {0xC6AD, 0x9A97}, //11813 #CJK UNIFIED IDEOGRAPH
    {0xC6AE, 0x98D8}, //11814 #CJK UNIFIED IDEOGRAPH
    {0xC6AF, 0x6F02}, //11815 #CJK UNIFIED IDEOGRAPH
    {0xC6B0, 0x74E2}, //11816 #CJK UNIFIED IDEOGRAPH
    {0xC6B1, 0x7968}, //11817 #CJK UNIFIED IDEOGRAPH
    {0xC6B2, 0x6487}, //11818 #CJK UNIFIED IDEOGRAPH
    {0xC6B3, 0x77A5}, //11819 #CJK UNIFIED IDEOGRAPH
    {0xC6B4, 0x62FC}, //11820 #CJK UNIFIED IDEOGRAPH
    {0xC6B5, 0x9891}, //11821 #CJK UNIFIED IDEOGRAPH
    {0xC6B6, 0x8D2B}, //11822 #CJK UNIFIED IDEOGRAPH
    {0xC6B7, 0x54C1}, //11823 #CJK UNIFIED IDEOGRAPH
    {0xC6B8, 0x8058}, //11824 #CJK UNIFIED IDEOGRAPH
    {0xC6B9, 0x4E52}, //11825 #CJK UNIFIED IDEOGRAPH
    {0xC6BA, 0x576A}, //11826 #CJK UNIFIED IDEOGRAPH
    {0xC6BB, 0x82F9}, //11827 #CJK UNIFIED IDEOGRAPH
    {0xC6BC, 0x840D}, //11828 #CJK UNIFIED IDEOGRAPH
    {0xC6BD, 0x5E73}, //11829 #CJK UNIFIED IDEOGRAPH
    {0xC6BE, 0x51ED}, //11830 #CJK UNIFIED IDEOGRAPH
    {0xC6BF, 0x74F6}, //11831 #CJK UNIFIED IDEOGRAPH
    {0xC6C0, 0x8BC4}, //11832 #CJK UNIFIED IDEOGRAPH
    {0xC6C1, 0x5C4F}, //11833 #CJK UNIFIED IDEOGRAPH
    {0xC6C2, 0x5761}, //11834 #CJK UNIFIED IDEOGRAPH
    {0xC6C3, 0x6CFC}, //11835 #CJK UNIFIED IDEOGRAPH
    {0xC6C4, 0x9887}, //11836 #CJK UNIFIED IDEOGRAPH
    {0xC6C5, 0x5A46}, //11837 #CJK UNIFIED IDEOGRAPH
    {0xC6C6, 0x7834}, //11838 #CJK UNIFIED IDEOGRAPH
    {0xC6C7, 0x9B44}, //11839 #CJK UNIFIED IDEOGRAPH
    {0xC6C8, 0x8FEB}, //11840 #CJK UNIFIED IDEOGRAPH
    {0xC6C9, 0x7C95}, //11841 #CJK UNIFIED IDEOGRAPH
    {0xC6CA, 0x5256}, //11842 #CJK UNIFIED IDEOGRAPH
    {0xC6CB, 0x6251}, //11843 #CJK UNIFIED IDEOGRAPH
    {0xC6CC, 0x94FA}, //11844 #CJK UNIFIED IDEOGRAPH
    {0xC6CD, 0x4EC6}, //11845 #CJK UNIFIED IDEOGRAPH
    {0xC6CE, 0x8386}, //11846 #CJK UNIFIED IDEOGRAPH
    {0xC6CF, 0x8461}, //11847 #CJK UNIFIED IDEOGRAPH
    {0xC6D0, 0x83E9}, //11848 #CJK UNIFIED IDEOGRAPH
    {0xC6D1, 0x84B2}, //11849 #CJK UNIFIED IDEOGRAPH
    {0xC6D2, 0x57D4}, //11850 #CJK UNIFIED IDEOGRAPH
    {0xC6D3, 0x6734}, //11851 #CJK UNIFIED IDEOGRAPH
    {0xC6D4, 0x5703}, //11852 #CJK UNIFIED IDEOGRAPH
    {0xC6D5, 0x666E}, //11853 #CJK UNIFIED IDEOGRAPH
    {0xC6D6, 0x6D66}, //11854 #CJK UNIFIED IDEOGRAPH
    {0xC6D7, 0x8C31}, //11855 #CJK UNIFIED IDEOGRAPH
    {0xC6D8, 0x66DD}, //11856 #CJK UNIFIED IDEOGRAPH
    {0xC6D9, 0x7011}, //11857 #CJK UNIFIED IDEOGRAPH
    {0xC6DA, 0x671F}, //11858 #CJK UNIFIED IDEOGRAPH
    {0xC6DB, 0x6B3A}, //11859 #CJK UNIFIED IDEOGRAPH
    {0xC6DC, 0x6816}, //11860 #CJK UNIFIED IDEOGRAPH
    {0xC6DD, 0x621A}, //11861 #CJK UNIFIED IDEOGRAPH
    {0xC6DE, 0x59BB}, //11862 #CJK UNIFIED IDEOGRAPH
    {0xC6DF, 0x4E03}, //11863 #CJK UNIFIED IDEOGRAPH
    {0xC6E0, 0x51C4}, //11864 #CJK UNIFIED IDEOGRAPH
    {0xC6E1, 0x6F06}, //11865 #CJK UNIFIED IDEOGRAPH
    {0xC6E2, 0x67D2}, //11866 #CJK UNIFIED IDEOGRAPH
    {0xC6E3, 0x6C8F}, //11867 #CJK UNIFIED IDEOGRAPH
    {0xC6E4, 0x5176}, //11868 #CJK UNIFIED IDEOGRAPH
    {0xC6E5, 0x68CB}, //11869 #CJK UNIFIED IDEOGRAPH
    {0xC6E6, 0x5947}, //11870 #CJK UNIFIED IDEOGRAPH
    {0xC6E7, 0x6B67}, //11871 #CJK UNIFIED IDEOGRAPH
    {0xC6E8, 0x7566}, //11872 #CJK UNIFIED IDEOGRAPH
    {0xC6E9, 0x5D0E}, //11873 #CJK UNIFIED IDEOGRAPH
    {0xC6EA, 0x8110}, //11874 #CJK UNIFIED IDEOGRAPH
    {0xC6EB, 0x9F50}, //11875 #CJK UNIFIED IDEOGRAPH
    {0xC6EC, 0x65D7}, //11876 #CJK UNIFIED IDEOGRAPH
    {0xC6ED, 0x7948}, //11877 #CJK UNIFIED IDEOGRAPH
    {0xC6EE, 0x7941}, //11878 #CJK UNIFIED IDEOGRAPH
    {0xC6EF, 0x9A91}, //11879 #CJK UNIFIED IDEOGRAPH
    {0xC6F0, 0x8D77}, //11880 #CJK UNIFIED IDEOGRAPH
    {0xC6F1, 0x5C82}, //11881 #CJK UNIFIED IDEOGRAPH
    {0xC6F2, 0x4E5E}, //11882 #CJK UNIFIED IDEOGRAPH
    {0xC6F3, 0x4F01}, //11883 #CJK UNIFIED IDEOGRAPH
    {0xC6F4, 0x542F}, //11884 #CJK UNIFIED IDEOGRAPH
    {0xC6F5, 0x5951}, //11885 #CJK UNIFIED IDEOGRAPH
    {0xC6F6, 0x780C}, //11886 #CJK UNIFIED IDEOGRAPH
    {0xC6F7, 0x5668}, //11887 #CJK UNIFIED IDEOGRAPH
    {0xC6F8, 0x6C14}, //11888 #CJK UNIFIED IDEOGRAPH
    {0xC6F9, 0x8FC4}, //11889 #CJK UNIFIED IDEOGRAPH
    {0xC6FA, 0x5F03}, //11890 #CJK UNIFIED IDEOGRAPH
    {0xC6FB, 0x6C7D}, //11891 #CJK UNIFIED IDEOGRAPH
    {0xC6FC, 0x6CE3}, //11892 #CJK UNIFIED IDEOGRAPH
    {0xC6FD, 0x8BAB}, //11893 #CJK UNIFIED IDEOGRAPH
    {0xC6FE, 0x6390}, //11894 #CJK UNIFIED IDEOGRAPH
    {0xC740, 0x833E}, //11895 #CJK UNIFIED IDEOGRAPH
    {0xC741, 0x833F}, //11896 #CJK UNIFIED IDEOGRAPH
    {0xC742, 0x8341}, //11897 #CJK UNIFIED IDEOGRAPH
    {0xC743, 0x8342}, //11898 #CJK UNIFIED IDEOGRAPH
    {0xC744, 0x8344}, //11899 #CJK UNIFIED IDEOGRAPH
    {0xC745, 0x8345}, //11900 #CJK UNIFIED IDEOGRAPH
    {0xC746, 0x8348}, //11901 #CJK UNIFIED IDEOGRAPH
    {0xC747, 0x834A}, //11902 #CJK UNIFIED IDEOGRAPH
    {0xC748, 0x834B}, //11903 #CJK UNIFIED IDEOGRAPH
    {0xC749, 0x834C}, //11904 #CJK UNIFIED IDEOGRAPH
    {0xC74A, 0x834D}, //11905 #CJK UNIFIED IDEOGRAPH
    {0xC74B, 0x834E}, //11906 #CJK UNIFIED IDEOGRAPH
    {0xC74C, 0x8353}, //11907 #CJK UNIFIED IDEOGRAPH
    {0xC74D, 0x8355}, //11908 #CJK UNIFIED IDEOGRAPH
    {0xC74E, 0x8356}, //11909 #CJK UNIFIED IDEOGRAPH
    {0xC74F, 0x8357}, //11910 #CJK UNIFIED IDEOGRAPH
    {0xC750, 0x8358}, //11911 #CJK UNIFIED IDEOGRAPH
    {0xC751, 0x8359}, //11912 #CJK UNIFIED IDEOGRAPH
    {0xC752, 0x835D}, //11913 #CJK UNIFIED IDEOGRAPH
    {0xC753, 0x8362}, //11914 #CJK UNIFIED IDEOGRAPH
    {0xC754, 0x8370}, //11915 #CJK UNIFIED IDEOGRAPH
    {0xC755, 0x8371}, //11916 #CJK UNIFIED IDEOGRAPH
    {0xC756, 0x8372}, //11917 #CJK UNIFIED IDEOGRAPH
    {0xC757, 0x8373}, //11918 #CJK UNIFIED IDEOGRAPH
    {0xC758, 0x8374}, //11919 #CJK UNIFIED IDEOGRAPH
    {0xC759, 0x8375}, //11920 #CJK UNIFIED IDEOGRAPH
    {0xC75A, 0x8376}, //11921 #CJK UNIFIED IDEOGRAPH
    {0xC75B, 0x8379}, //11922 #CJK UNIFIED IDEOGRAPH
    {0xC75C, 0x837A}, //11923 #CJK UNIFIED IDEOGRAPH
    {0xC75D, 0x837E}, //11924 #CJK UNIFIED IDEOGRAPH
    {0xC75E, 0x837F}, //11925 #CJK UNIFIED IDEOGRAPH
    {0xC75F, 0x8380}, //11926 #CJK UNIFIED IDEOGRAPH
    {0xC760, 0x8381}, //11927 #CJK UNIFIED IDEOGRAPH
    {0xC761, 0x8382}, //11928 #CJK UNIFIED IDEOGRAPH
    {0xC762, 0x8383}, //11929 #CJK UNIFIED IDEOGRAPH
    {0xC763, 0x8384}, //11930 #CJK UNIFIED IDEOGRAPH
    {0xC764, 0x8387}, //11931 #CJK UNIFIED IDEOGRAPH
    {0xC765, 0x8388}, //11932 #CJK UNIFIED IDEOGRAPH
    {0xC766, 0x838A}, //11933 #CJK UNIFIED IDEOGRAPH
    {0xC767, 0x838B}, //11934 #CJK UNIFIED IDEOGRAPH
    {0xC768, 0x838C}, //11935 #CJK UNIFIED IDEOGRAPH
    {0xC769, 0x838D}, //11936 #CJK UNIFIED IDEOGRAPH
    {0xC76A, 0x838F}, //11937 #CJK UNIFIED IDEOGRAPH
    {0xC76B, 0x8390}, //11938 #CJK UNIFIED IDEOGRAPH
    {0xC76C, 0x8391}, //11939 #CJK UNIFIED IDEOGRAPH
    {0xC76D, 0x8394}, //11940 #CJK UNIFIED IDEOGRAPH
    {0xC76E, 0x8395}, //11941 #CJK UNIFIED IDEOGRAPH
    {0xC76F, 0x8396}, //11942 #CJK UNIFIED IDEOGRAPH
    {0xC770, 0x8397}, //11943 #CJK UNIFIED IDEOGRAPH
    {0xC771, 0x8399}, //11944 #CJK UNIFIED IDEOGRAPH
    {0xC772, 0x839A}, //11945 #CJK UNIFIED IDEOGRAPH
    {0xC773, 0x839D}, //11946 #CJK UNIFIED IDEOGRAPH
    {0xC774, 0x839F}, //11947 #CJK UNIFIED IDEOGRAPH
    {0xC775, 0x83A1}, //11948 #CJK UNIFIED IDEOGRAPH
    {0xC776, 0x83A2}, //11949 #CJK UNIFIED IDEOGRAPH
    {0xC777, 0x83A3}, //11950 #CJK UNIFIED IDEOGRAPH
    {0xC778, 0x83A4}, //11951 #CJK UNIFIED IDEOGRAPH
    {0xC779, 0x83A5}, //11952 #CJK UNIFIED IDEOGRAPH
    {0xC77A, 0x83A6}, //11953 #CJK UNIFIED IDEOGRAPH
    {0xC77B, 0x83A7}, //11954 #CJK UNIFIED IDEOGRAPH
    {0xC77C, 0x83AC}, //11955 #CJK UNIFIED IDEOGRAPH
    {0xC77D, 0x83AD}, //11956 #CJK UNIFIED IDEOGRAPH
    {0xC77E, 0x83AE}, //11957 #CJK UNIFIED IDEOGRAPH
    {0xC780, 0x83AF}, //11958 #CJK UNIFIED IDEOGRAPH
    {0xC781, 0x83B5}, //11959 #CJK UNIFIED IDEOGRAPH
    {0xC782, 0x83BB}, //11960 #CJK UNIFIED IDEOGRAPH
    {0xC783, 0x83BE}, //11961 #CJK UNIFIED IDEOGRAPH
    {0xC784, 0x83BF}, //11962 #CJK UNIFIED IDEOGRAPH
    {0xC785, 0x83C2}, //11963 #CJK UNIFIED IDEOGRAPH
    {0xC786, 0x83C3}, //11964 #CJK UNIFIED IDEOGRAPH
    {0xC787, 0x83C4}, //11965 #CJK UNIFIED IDEOGRAPH
    {0xC788, 0x83C6}, //11966 #CJK UNIFIED IDEOGRAPH
    {0xC789, 0x83C8}, //11967 #CJK UNIFIED IDEOGRAPH
    {0xC78A, 0x83C9}, //11968 #CJK UNIFIED IDEOGRAPH
    {0xC78B, 0x83CB}, //11969 #CJK UNIFIED IDEOGRAPH
    {0xC78C, 0x83CD}, //11970 #CJK UNIFIED IDEOGRAPH
    {0xC78D, 0x83CE}, //11971 #CJK UNIFIED IDEOGRAPH
    {0xC78E, 0x83D0}, //11972 #CJK UNIFIED IDEOGRAPH
    {0xC78F, 0x83D1}, //11973 #CJK UNIFIED IDEOGRAPH
    {0xC790, 0x83D2}, //11974 #CJK UNIFIED IDEOGRAPH
    {0xC791, 0x83D3}, //11975 #CJK UNIFIED IDEOGRAPH
    {0xC792, 0x83D5}, //11976 #CJK UNIFIED IDEOGRAPH
    {0xC793, 0x83D7}, //11977 #CJK UNIFIED IDEOGRAPH
    {0xC794, 0x83D9}, //11978 #CJK UNIFIED IDEOGRAPH
    {0xC795, 0x83DA}, //11979 #CJK UNIFIED IDEOGRAPH
    {0xC796, 0x83DB}, //11980 #CJK UNIFIED IDEOGRAPH
    {0xC797, 0x83DE}, //11981 #CJK UNIFIED IDEOGRAPH
    {0xC798, 0x83E2}, //11982 #CJK UNIFIED IDEOGRAPH
    {0xC799, 0x83E3}, //11983 #CJK UNIFIED IDEOGRAPH
    {0xC79A, 0x83E4}, //11984 #CJK UNIFIED IDEOGRAPH
    {0xC79B, 0x83E6}, //11985 #CJK UNIFIED IDEOGRAPH
    {0xC79C, 0x83E7}, //11986 #CJK UNIFIED IDEOGRAPH
    {0xC79D, 0x83E8}, //11987 #CJK UNIFIED IDEOGRAPH
    {0xC79E, 0x83EB}, //11988 #CJK UNIFIED IDEOGRAPH
    {0xC79F, 0x83EC}, //11989 #CJK UNIFIED IDEOGRAPH
    {0xC7A0, 0x83ED}, //11990 #CJK UNIFIED IDEOGRAPH
    {0xC7A1, 0x6070}, //11991 #CJK UNIFIED IDEOGRAPH
    {0xC7A2, 0x6D3D}, //11992 #CJK UNIFIED IDEOGRAPH
    {0xC7A3, 0x7275}, //11993 #CJK UNIFIED IDEOGRAPH
    {0xC7A4, 0x6266}, //11994 #CJK UNIFIED IDEOGRAPH
    {0xC7A5, 0x948E}, //11995 #CJK UNIFIED IDEOGRAPH
    {0xC7A6, 0x94C5}, //11996 #CJK UNIFIED IDEOGRAPH
    {0xC7A7, 0x5343}, //11997 #CJK UNIFIED IDEOGRAPH
    {0xC7A8, 0x8FC1}, //11998 #CJK UNIFIED IDEOGRAPH
    {0xC7A9, 0x7B7E}, //11999 #CJK UNIFIED IDEOGRAPH
    {0xC7AA, 0x4EDF}, //12000 #CJK UNIFIED IDEOGRAPH
    {0xC7AB, 0x8C26}, //12001 #CJK UNIFIED IDEOGRAPH
    {0xC7AC, 0x4E7E}, //12002 #CJK UNIFIED IDEOGRAPH
    {0xC7AD, 0x9ED4}, //12003 #CJK UNIFIED IDEOGRAPH
    {0xC7AE, 0x94B1}, //12004 #CJK UNIFIED IDEOGRAPH
    {0xC7AF, 0x94B3}, //12005 #CJK UNIFIED IDEOGRAPH
    {0xC7B0, 0x524D}, //12006 #CJK UNIFIED IDEOGRAPH
    {0xC7B1, 0x6F5C}, //12007 #CJK UNIFIED IDEOGRAPH
    {0xC7B2, 0x9063}, //12008 #CJK UNIFIED IDEOGRAPH
    {0xC7B3, 0x6D45}, //12009 #CJK UNIFIED IDEOGRAPH
    {0xC7B4, 0x8C34}, //12010 #CJK UNIFIED IDEOGRAPH
    {0xC7B5, 0x5811}, //12011 #CJK UNIFIED IDEOGRAPH
    {0xC7B6, 0x5D4C}, //12012 #CJK UNIFIED IDEOGRAPH
    {0xC7B7, 0x6B20}, //12013 #CJK UNIFIED IDEOGRAPH
    {0xC7B8, 0x6B49}, //12014 #CJK UNIFIED IDEOGRAPH
    {0xC7B9, 0x67AA}, //12015 #CJK UNIFIED IDEOGRAPH
    {0xC7BA, 0x545B}, //12016 #CJK UNIFIED IDEOGRAPH
    {0xC7BB, 0x8154}, //12017 #CJK UNIFIED IDEOGRAPH
    {0xC7BC, 0x7F8C}, //12018 #CJK UNIFIED IDEOGRAPH
    {0xC7BD, 0x5899}, //12019 #CJK UNIFIED IDEOGRAPH
    {0xC7BE, 0x8537}, //12020 #CJK UNIFIED IDEOGRAPH
    {0xC7BF, 0x5F3A}, //12021 #CJK UNIFIED IDEOGRAPH
    {0xC7C0, 0x62A2}, //12022 #CJK UNIFIED IDEOGRAPH
    {0xC7C1, 0x6A47}, //12023 #CJK UNIFIED IDEOGRAPH
    {0xC7C2, 0x9539}, //12024 #CJK UNIFIED IDEOGRAPH
    {0xC7C3, 0x6572}, //12025 #CJK UNIFIED IDEOGRAPH
    {0xC7C4, 0x6084}, //12026 #CJK UNIFIED IDEOGRAPH
    {0xC7C5, 0x6865}, //12027 #CJK UNIFIED IDEOGRAPH
    {0xC7C6, 0x77A7}, //12028 #CJK UNIFIED IDEOGRAPH
    {0xC7C7, 0x4E54}, //12029 #CJK UNIFIED IDEOGRAPH
    {0xC7C8, 0x4FA8}, //12030 #CJK UNIFIED IDEOGRAPH
    {0xC7C9, 0x5DE7}, //12031 #CJK UNIFIED IDEOGRAPH
    {0xC7CA, 0x9798}, //12032 #CJK UNIFIED IDEOGRAPH
    {0xC7CB, 0x64AC}, //12033 #CJK UNIFIED IDEOGRAPH
    {0xC7CC, 0x7FD8}, //12034 #CJK UNIFIED IDEOGRAPH
    {0xC7CD, 0x5CED}, //12035 #CJK UNIFIED IDEOGRAPH
    {0xC7CE, 0x4FCF}, //12036 #CJK UNIFIED IDEOGRAPH
    {0xC7CF, 0x7A8D}, //12037 #CJK UNIFIED IDEOGRAPH
    {0xC7D0, 0x5207}, //12038 #CJK UNIFIED IDEOGRAPH
    {0xC7D1, 0x8304}, //12039 #CJK UNIFIED IDEOGRAPH
    {0xC7D2, 0x4E14}, //12040 #CJK UNIFIED IDEOGRAPH
    {0xC7D3, 0x602F}, //12041 #CJK UNIFIED IDEOGRAPH
    {0xC7D4, 0x7A83}, //12042 #CJK UNIFIED IDEOGRAPH
    {0xC7D5, 0x94A6}, //12043 #CJK UNIFIED IDEOGRAPH
    {0xC7D6, 0x4FB5}, //12044 #CJK UNIFIED IDEOGRAPH
    {0xC7D7, 0x4EB2}, //12045 #CJK UNIFIED IDEOGRAPH
    {0xC7D8, 0x79E6}, //12046 #CJK UNIFIED IDEOGRAPH
    {0xC7D9, 0x7434}, //12047 #CJK UNIFIED IDEOGRAPH
    {0xC7DA, 0x52E4}, //12048 #CJK UNIFIED IDEOGRAPH
    {0xC7DB, 0x82B9}, //12049 #CJK UNIFIED IDEOGRAPH
    {0xC7DC, 0x64D2}, //12050 #CJK UNIFIED IDEOGRAPH
    {0xC7DD, 0x79BD}, //12051 #CJK UNIFIED IDEOGRAPH
    {0xC7DE, 0x5BDD}, //12052 #CJK UNIFIED IDEOGRAPH
    {0xC7DF, 0x6C81}, //12053 #CJK UNIFIED IDEOGRAPH
    {0xC7E0, 0x9752}, //12054 #CJK UNIFIED IDEOGRAPH
    {0xC7E1, 0x8F7B}, //12055 #CJK UNIFIED IDEOGRAPH
    {0xC7E2, 0x6C22}, //12056 #CJK UNIFIED IDEOGRAPH
    {0xC7E3, 0x503E}, //12057 #CJK UNIFIED IDEOGRAPH
    {0xC7E4, 0x537F}, //12058 #CJK UNIFIED IDEOGRAPH
    {0xC7E5, 0x6E05}, //12059 #CJK UNIFIED IDEOGRAPH
    {0xC7E6, 0x64CE}, //12060 #CJK UNIFIED IDEOGRAPH
    {0xC7E7, 0x6674}, //12061 #CJK UNIFIED IDEOGRAPH
    {0xC7E8, 0x6C30}, //12062 #CJK UNIFIED IDEOGRAPH
    {0xC7E9, 0x60C5}, //12063 #CJK UNIFIED IDEOGRAPH
    {0xC7EA, 0x9877}, //12064 #CJK UNIFIED IDEOGRAPH
    {0xC7EB, 0x8BF7}, //12065 #CJK UNIFIED IDEOGRAPH
    {0xC7EC, 0x5E86}, //12066 #CJK UNIFIED IDEOGRAPH
    {0xC7ED, 0x743C}, //12067 #CJK UNIFIED IDEOGRAPH
    {0xC7EE, 0x7A77}, //12068 #CJK UNIFIED IDEOGRAPH
    {0xC7EF, 0x79CB}, //12069 #CJK UNIFIED IDEOGRAPH
    {0xC7F0, 0x4E18}, //12070 #CJK UNIFIED IDEOGRAPH
    {0xC7F1, 0x90B1}, //12071 #CJK UNIFIED IDEOGRAPH
    {0xC7F2, 0x7403}, //12072 #CJK UNIFIED IDEOGRAPH
    {0xC7F3, 0x6C42}, //12073 #CJK UNIFIED IDEOGRAPH
    {0xC7F4, 0x56DA}, //12074 #CJK UNIFIED IDEOGRAPH
    {0xC7F5, 0x914B}, //12075 #CJK UNIFIED IDEOGRAPH
    {0xC7F6, 0x6CC5}, //12076 #CJK UNIFIED IDEOGRAPH
    {0xC7F7, 0x8D8B}, //12077 #CJK UNIFIED IDEOGRAPH
    {0xC7F8, 0x533A}, //12078 #CJK UNIFIED IDEOGRAPH
    {0xC7F9, 0x86C6}, //12079 #CJK UNIFIED IDEOGRAPH
    {0xC7FA, 0x66F2}, //12080 #CJK UNIFIED IDEOGRAPH
    {0xC7FB, 0x8EAF}, //12081 #CJK UNIFIED IDEOGRAPH
    {0xC7FC, 0x5C48}, //12082 #CJK UNIFIED IDEOGRAPH
    {0xC7FD, 0x9A71}, //12083 #CJK UNIFIED IDEOGRAPH
    {0xC7FE, 0x6E20}, //12084 #CJK UNIFIED IDEOGRAPH
    {0xC840, 0x83EE}, //12085 #CJK UNIFIED IDEOGRAPH
    {0xC841, 0x83EF}, //12086 #CJK UNIFIED IDEOGRAPH
    {0xC842, 0x83F3}, //12087 #CJK UNIFIED IDEOGRAPH
    {0xC843, 0x83F4}, //12088 #CJK UNIFIED IDEOGRAPH
    {0xC844, 0x83F5}, //12089 #CJK UNIFIED IDEOGRAPH
    {0xC845, 0x83F6}, //12090 #CJK UNIFIED IDEOGRAPH
    {0xC846, 0x83F7}, //12091 #CJK UNIFIED IDEOGRAPH
    {0xC847, 0x83FA}, //12092 #CJK UNIFIED IDEOGRAPH
    {0xC848, 0x83FB}, //12093 #CJK UNIFIED IDEOGRAPH
    {0xC849, 0x83FC}, //12094 #CJK UNIFIED IDEOGRAPH
    {0xC84A, 0x83FE}, //12095 #CJK UNIFIED IDEOGRAPH
    {0xC84B, 0x83FF}, //12096 #CJK UNIFIED IDEOGRAPH
    {0xC84C, 0x8400}, //12097 #CJK UNIFIED IDEOGRAPH
    {0xC84D, 0x8402}, //12098 #CJK UNIFIED IDEOGRAPH
    {0xC84E, 0x8405}, //12099 #CJK UNIFIED IDEOGRAPH
    {0xC84F, 0x8407}, //12100 #CJK UNIFIED IDEOGRAPH
    {0xC850, 0x8408}, //12101 #CJK UNIFIED IDEOGRAPH
    {0xC851, 0x8409}, //12102 #CJK UNIFIED IDEOGRAPH
    {0xC852, 0x840A}, //12103 #CJK UNIFIED IDEOGRAPH
    {0xC853, 0x8410}, //12104 #CJK UNIFIED IDEOGRAPH
    {0xC854, 0x8412}, //12105 #CJK UNIFIED IDEOGRAPH
    {0xC855, 0x8413}, //12106 #CJK UNIFIED IDEOGRAPH
    {0xC856, 0x8414}, //12107 #CJK UNIFIED IDEOGRAPH
    {0xC857, 0x8415}, //12108 #CJK UNIFIED IDEOGRAPH
    {0xC858, 0x8416}, //12109 #CJK UNIFIED IDEOGRAPH
    {0xC859, 0x8417}, //12110 #CJK UNIFIED IDEOGRAPH
    {0xC85A, 0x8419}, //12111 #CJK UNIFIED IDEOGRAPH
    {0xC85B, 0x841A}, //12112 #CJK UNIFIED IDEOGRAPH
    {0xC85C, 0x841B}, //12113 #CJK UNIFIED IDEOGRAPH
    {0xC85D, 0x841E}, //12114 #CJK UNIFIED IDEOGRAPH
    {0xC85E, 0x841F}, //12115 #CJK UNIFIED IDEOGRAPH
    {0xC85F, 0x8420}, //12116 #CJK UNIFIED IDEOGRAPH
    {0xC860, 0x8421}, //12117 #CJK UNIFIED IDEOGRAPH
    {0xC861, 0x8422}, //12118 #CJK UNIFIED IDEOGRAPH
    {0xC862, 0x8423}, //12119 #CJK UNIFIED IDEOGRAPH
    {0xC863, 0x8429}, //12120 #CJK UNIFIED IDEOGRAPH
    {0xC864, 0x842A}, //12121 #CJK UNIFIED IDEOGRAPH
    {0xC865, 0x842B}, //12122 #CJK UNIFIED IDEOGRAPH
    {0xC866, 0x842C}, //12123 #CJK UNIFIED IDEOGRAPH
    {0xC867, 0x842D}, //12124 #CJK UNIFIED IDEOGRAPH
    {0xC868, 0x842E}, //12125 #CJK UNIFIED IDEOGRAPH
    {0xC869, 0x842F}, //12126 #CJK UNIFIED IDEOGRAPH
    {0xC86A, 0x8430}, //12127 #CJK UNIFIED IDEOGRAPH
    {0xC86B, 0x8432}, //12128 #CJK UNIFIED IDEOGRAPH
    {0xC86C, 0x8433}, //12129 #CJK UNIFIED IDEOGRAPH
    {0xC86D, 0x8434}, //12130 #CJK UNIFIED IDEOGRAPH
    {0xC86E, 0x8435}, //12131 #CJK UNIFIED IDEOGRAPH
    {0xC86F, 0x8436}, //12132 #CJK UNIFIED IDEOGRAPH
    {0xC870, 0x8437}, //12133 #CJK UNIFIED IDEOGRAPH
    {0xC871, 0x8439}, //12134 #CJK UNIFIED IDEOGRAPH
    {0xC872, 0x843A}, //12135 #CJK UNIFIED IDEOGRAPH
    {0xC873, 0x843B}, //12136 #CJK UNIFIED IDEOGRAPH
    {0xC874, 0x843E}, //12137 #CJK UNIFIED IDEOGRAPH
    {0xC875, 0x843F}, //12138 #CJK UNIFIED IDEOGRAPH
    {0xC876, 0x8440}, //12139 #CJK UNIFIED IDEOGRAPH
    {0xC877, 0x8441}, //12140 #CJK UNIFIED IDEOGRAPH
    {0xC878, 0x8442}, //12141 #CJK UNIFIED IDEOGRAPH
    {0xC879, 0x8443}, //12142 #CJK UNIFIED IDEOGRAPH
    {0xC87A, 0x8444}, //12143 #CJK UNIFIED IDEOGRAPH
    {0xC87B, 0x8445}, //12144 #CJK UNIFIED IDEOGRAPH
    {0xC87C, 0x8447}, //12145 #CJK UNIFIED IDEOGRAPH
    {0xC87D, 0x8448}, //12146 #CJK UNIFIED IDEOGRAPH
    {0xC87E, 0x8449}, //12147 #CJK UNIFIED IDEOGRAPH
    {0xC880, 0x844A}, //12148 #CJK UNIFIED IDEOGRAPH
    {0xC881, 0x844B}, //12149 #CJK UNIFIED IDEOGRAPH
    {0xC882, 0x844C}, //12150 #CJK UNIFIED IDEOGRAPH
    {0xC883, 0x844D}, //12151 #CJK UNIFIED IDEOGRAPH
    {0xC884, 0x844E}, //12152 #CJK UNIFIED IDEOGRAPH
    {0xC885, 0x844F}, //12153 #CJK UNIFIED IDEOGRAPH
    {0xC886, 0x8450}, //12154 #CJK UNIFIED IDEOGRAPH
    {0xC887, 0x8452}, //12155 #CJK UNIFIED IDEOGRAPH
    {0xC888, 0x8453}, //12156 #CJK UNIFIED IDEOGRAPH
    {0xC889, 0x8454}, //12157 #CJK UNIFIED IDEOGRAPH
    {0xC88A, 0x8455}, //12158 #CJK UNIFIED IDEOGRAPH
    {0xC88B, 0x8456}, //12159 #CJK UNIFIED IDEOGRAPH
    {0xC88C, 0x8458}, //12160 #CJK UNIFIED IDEOGRAPH
    {0xC88D, 0x845D}, //12161 #CJK UNIFIED IDEOGRAPH
    {0xC88E, 0x845E}, //12162 #CJK UNIFIED IDEOGRAPH
    {0xC88F, 0x845F}, //12163 #CJK UNIFIED IDEOGRAPH
    {0xC890, 0x8460}, //12164 #CJK UNIFIED IDEOGRAPH
    {0xC891, 0x8462}, //12165 #CJK UNIFIED IDEOGRAPH
    {0xC892, 0x8464}, //12166 #CJK UNIFIED IDEOGRAPH
    {0xC893, 0x8465}, //12167 #CJK UNIFIED IDEOGRAPH
    {0xC894, 0x8466}, //12168 #CJK UNIFIED IDEOGRAPH
    {0xC895, 0x8467}, //12169 #CJK UNIFIED IDEOGRAPH
    {0xC896, 0x8468}, //12170 #CJK UNIFIED IDEOGRAPH
    {0xC897, 0x846A}, //12171 #CJK UNIFIED IDEOGRAPH
    {0xC898, 0x846E}, //12172 #CJK UNIFIED IDEOGRAPH
    {0xC899, 0x846F}, //12173 #CJK UNIFIED IDEOGRAPH
    {0xC89A, 0x8470}, //12174 #CJK UNIFIED IDEOGRAPH
    {0xC89B, 0x8472}, //12175 #CJK UNIFIED IDEOGRAPH
    {0xC89C, 0x8474}, //12176 #CJK UNIFIED IDEOGRAPH
    {0xC89D, 0x8477}, //12177 #CJK UNIFIED IDEOGRAPH
    {0xC89E, 0x8479}, //12178 #CJK UNIFIED IDEOGRAPH
    {0xC89F, 0x847B}, //12179 #CJK UNIFIED IDEOGRAPH
    {0xC8A0, 0x847C}, //12180 #CJK UNIFIED IDEOGRAPH
    {0xC8A1, 0x53D6}, //12181 #CJK UNIFIED IDEOGRAPH
    {0xC8A2, 0x5A36}, //12182 #CJK UNIFIED IDEOGRAPH
    {0xC8A3, 0x9F8B}, //12183 #CJK UNIFIED IDEOGRAPH
    {0xC8A4, 0x8DA3}, //12184 #CJK UNIFIED IDEOGRAPH
    {0xC8A5, 0x53BB}, //12185 #CJK UNIFIED IDEOGRAPH
    {0xC8A6, 0x5708}, //12186 #CJK UNIFIED IDEOGRAPH
    {0xC8A7, 0x98A7}, //12187 #CJK UNIFIED IDEOGRAPH
    {0xC8A8, 0x6743}, //12188 #CJK UNIFIED IDEOGRAPH
    {0xC8A9, 0x919B}, //12189 #CJK UNIFIED IDEOGRAPH
    {0xC8AA, 0x6CC9}, //12190 #CJK UNIFIED IDEOGRAPH
    {0xC8AB, 0x5168}, //12191 #CJK UNIFIED IDEOGRAPH
    {0xC8AC, 0x75CA}, //12192 #CJK UNIFIED IDEOGRAPH
    {0xC8AD, 0x62F3}, //12193 #CJK UNIFIED IDEOGRAPH
    {0xC8AE, 0x72AC}, //12194 #CJK UNIFIED IDEOGRAPH
    {0xC8AF, 0x5238}, //12195 #CJK UNIFIED IDEOGRAPH
    {0xC8B0, 0x529D}, //12196 #CJK UNIFIED IDEOGRAPH
    {0xC8B1, 0x7F3A}, //12197 #CJK UNIFIED IDEOGRAPH
    {0xC8B2, 0x7094}, //12198 #CJK UNIFIED IDEOGRAPH
    {0xC8B3, 0x7638}, //12199 #CJK UNIFIED IDEOGRAPH
    {0xC8B4, 0x5374}, //12200 #CJK UNIFIED IDEOGRAPH
    {0xC8B5, 0x9E4A}, //12201 #CJK UNIFIED IDEOGRAPH
    {0xC8B6, 0x69B7}, //12202 #CJK UNIFIED IDEOGRAPH
    {0xC8B7, 0x786E}, //12203 #CJK UNIFIED IDEOGRAPH
    {0xC8B8, 0x96C0}, //12204 #CJK UNIFIED IDEOGRAPH
    {0xC8B9, 0x88D9}, //12205 #CJK UNIFIED IDEOGRAPH
    {0xC8BA, 0x7FA4}, //12206 #CJK UNIFIED IDEOGRAPH
    {0xC8BB, 0x7136}, //12207 #CJK UNIFIED IDEOGRAPH
    {0xC8BC, 0x71C3}, //12208 #CJK UNIFIED IDEOGRAPH
    {0xC8BD, 0x5189}, //12209 #CJK UNIFIED IDEOGRAPH
    {0xC8BE, 0x67D3}, //12210 #CJK UNIFIED IDEOGRAPH
    {0xC8BF, 0x74E4}, //12211 #CJK UNIFIED IDEOGRAPH
    {0xC8C0, 0x58E4}, //12212 #CJK UNIFIED IDEOGRAPH
    {0xC8C1, 0x6518}, //12213 #CJK UNIFIED IDEOGRAPH
    {0xC8C2, 0x56B7}, //12214 #CJK UNIFIED IDEOGRAPH
    {0xC8C3, 0x8BA9}, //12215 #CJK UNIFIED IDEOGRAPH
    {0xC8C4, 0x9976}, //12216 #CJK UNIFIED IDEOGRAPH
    {0xC8C5, 0x6270}, //12217 #CJK UNIFIED IDEOGRAPH
    {0xC8C6, 0x7ED5}, //12218 #CJK UNIFIED IDEOGRAPH
    {0xC8C7, 0x60F9}, //12219 #CJK UNIFIED IDEOGRAPH
    {0xC8C8, 0x70ED}, //12220 #CJK UNIFIED IDEOGRAPH
    {0xC8C9, 0x58EC}, //12221 #CJK UNIFIED IDEOGRAPH
    {0xC8CA, 0x4EC1}, //12222 #CJK UNIFIED IDEOGRAPH
    {0xC8CB, 0x4EBA}, //12223 #CJK UNIFIED IDEOGRAPH
    {0xC8CC, 0x5FCD}, //12224 #CJK UNIFIED IDEOGRAPH
    {0xC8CD, 0x97E7}, //12225 #CJK UNIFIED IDEOGRAPH
    {0xC8CE, 0x4EFB}, //12226 #CJK UNIFIED IDEOGRAPH
    {0xC8CF, 0x8BA4}, //12227 #CJK UNIFIED IDEOGRAPH
    {0xC8D0, 0x5203}, //12228 #CJK UNIFIED IDEOGRAPH
    {0xC8D1, 0x598A}, //12229 #CJK UNIFIED IDEOGRAPH
    {0xC8D2, 0x7EAB}, //12230 #CJK UNIFIED IDEOGRAPH
    {0xC8D3, 0x6254}, //12231 #CJK UNIFIED IDEOGRAPH
    {0xC8D4, 0x4ECD}, //12232 #CJK UNIFIED IDEOGRAPH
    {0xC8D5, 0x65E5}, //12233 #CJK UNIFIED IDEOGRAPH
    {0xC8D6, 0x620E}, //12234 #CJK UNIFIED IDEOGRAPH
    {0xC8D7, 0x8338}, //12235 #CJK UNIFIED IDEOGRAPH
    {0xC8D8, 0x84C9}, //12236 #CJK UNIFIED IDEOGRAPH
    {0xC8D9, 0x8363}, //12237 #CJK UNIFIED IDEOGRAPH
    {0xC8DA, 0x878D}, //12238 #CJK UNIFIED IDEOGRAPH
    {0xC8DB, 0x7194}, //12239 #CJK UNIFIED IDEOGRAPH
    {0xC8DC, 0x6EB6}, //12240 #CJK UNIFIED IDEOGRAPH
    {0xC8DD, 0x5BB9}, //12241 #CJK UNIFIED IDEOGRAPH
    {0xC8DE, 0x7ED2}, //12242 #CJK UNIFIED IDEOGRAPH
    {0xC8DF, 0x5197}, //12243 #CJK UNIFIED IDEOGRAPH
    {0xC8E0, 0x63C9}, //12244 #CJK UNIFIED IDEOGRAPH
    {0xC8E1, 0x67D4}, //12245 #CJK UNIFIED IDEOGRAPH
    {0xC8E2, 0x8089}, //12246 #CJK UNIFIED IDEOGRAPH
    {0xC8E3, 0x8339}, //12247 #CJK UNIFIED IDEOGRAPH
    {0xC8E4, 0x8815}, //12248 #CJK UNIFIED IDEOGRAPH
    {0xC8E5, 0x5112}, //12249 #CJK UNIFIED IDEOGRAPH
    {0xC8E6, 0x5B7A}, //12250 #CJK UNIFIED IDEOGRAPH
    {0xC8E7, 0x5982}, //12251 #CJK UNIFIED IDEOGRAPH
    {0xC8E8, 0x8FB1}, //12252 #CJK UNIFIED IDEOGRAPH
    {0xC8E9, 0x4E73}, //12253 #CJK UNIFIED IDEOGRAPH
    {0xC8EA, 0x6C5D}, //12254 #CJK UNIFIED IDEOGRAPH
    {0xC8EB, 0x5165}, //12255 #CJK UNIFIED IDEOGRAPH
    {0xC8EC, 0x8925}, //12256 #CJK UNIFIED IDEOGRAPH
    {0xC8ED, 0x8F6F}, //12257 #CJK UNIFIED IDEOGRAPH
    {0xC8EE, 0x962E}, //12258 #CJK UNIFIED IDEOGRAPH
    {0xC8EF, 0x854A}, //12259 #CJK UNIFIED IDEOGRAPH
    {0xC8F0, 0x745E}, //12260 #CJK UNIFIED IDEOGRAPH
    {0xC8F1, 0x9510}, //12261 #CJK UNIFIED IDEOGRAPH
    {0xC8F2, 0x95F0}, //12262 #CJK UNIFIED IDEOGRAPH
    {0xC8F3, 0x6DA6}, //12263 #CJK UNIFIED IDEOGRAPH
    {0xC8F4, 0x82E5}, //12264 #CJK UNIFIED IDEOGRAPH
    {0xC8F5, 0x5F31}, //12265 #CJK UNIFIED IDEOGRAPH
    {0xC8F6, 0x6492}, //12266 #CJK UNIFIED IDEOGRAPH
    {0xC8F7, 0x6D12}, //12267 #CJK UNIFIED IDEOGRAPH
    {0xC8F8, 0x8428}, //12268 #CJK UNIFIED IDEOGRAPH
    {0xC8F9, 0x816E}, //12269 #CJK UNIFIED IDEOGRAPH
    {0xC8FA, 0x9CC3}, //12270 #CJK UNIFIED IDEOGRAPH
    {0xC8FB, 0x585E}, //12271 #CJK UNIFIED IDEOGRAPH
    {0xC8FC, 0x8D5B}, //12272 #CJK UNIFIED IDEOGRAPH
    {0xC8FD, 0x4E09}, //12273 #CJK UNIFIED IDEOGRAPH
    {0xC8FE, 0x53C1}, //12274 #CJK UNIFIED IDEOGRAPH
    {0xC940, 0x847D}, //12275 #CJK UNIFIED IDEOGRAPH
    {0xC941, 0x847E}, //12276 #CJK UNIFIED IDEOGRAPH
    {0xC942, 0x847F}, //12277 #CJK UNIFIED IDEOGRAPH
    {0xC943, 0x8480}, //12278 #CJK UNIFIED IDEOGRAPH
    {0xC944, 0x8481}, //12279 #CJK UNIFIED IDEOGRAPH
    {0xC945, 0x8483}, //12280 #CJK UNIFIED IDEOGRAPH
    {0xC946, 0x8484}, //12281 #CJK UNIFIED IDEOGRAPH
    {0xC947, 0x8485}, //12282 #CJK UNIFIED IDEOGRAPH
    {0xC948, 0x8486}, //12283 #CJK UNIFIED IDEOGRAPH
    {0xC949, 0x848A}, //12284 #CJK UNIFIED IDEOGRAPH
    {0xC94A, 0x848D}, //12285 #CJK UNIFIED IDEOGRAPH
    {0xC94B, 0x848F}, //12286 #CJK UNIFIED IDEOGRAPH
    {0xC94C, 0x8490}, //12287 #CJK UNIFIED IDEOGRAPH
    {0xC94D, 0x8491}, //12288 #CJK UNIFIED IDEOGRAPH
    {0xC94E, 0x8492}, //12289 #CJK UNIFIED IDEOGRAPH
    {0xC94F, 0x8493}, //12290 #CJK UNIFIED IDEOGRAPH
    {0xC950, 0x8494}, //12291 #CJK UNIFIED IDEOGRAPH
    {0xC951, 0x8495}, //12292 #CJK UNIFIED IDEOGRAPH
    {0xC952, 0x8496}, //12293 #CJK UNIFIED IDEOGRAPH
    {0xC953, 0x8498}, //12294 #CJK UNIFIED IDEOGRAPH
    {0xC954, 0x849A}, //12295 #CJK UNIFIED IDEOGRAPH
    {0xC955, 0x849B}, //12296 #CJK UNIFIED IDEOGRAPH
    {0xC956, 0x849D}, //12297 #CJK UNIFIED IDEOGRAPH
    {0xC957, 0x849E}, //12298 #CJK UNIFIED IDEOGRAPH
    {0xC958, 0x849F}, //12299 #CJK UNIFIED IDEOGRAPH
    {0xC959, 0x84A0}, //12300 #CJK UNIFIED IDEOGRAPH
    {0xC95A, 0x84A2}, //12301 #CJK UNIFIED IDEOGRAPH
    {0xC95B, 0x84A3}, //12302 #CJK UNIFIED IDEOGRAPH
    {0xC95C, 0x84A4}, //12303 #CJK UNIFIED IDEOGRAPH
    {0xC95D, 0x84A5}, //12304 #CJK UNIFIED IDEOGRAPH
    {0xC95E, 0x84A6}, //12305 #CJK UNIFIED IDEOGRAPH
    {0xC95F, 0x84A7}, //12306 #CJK UNIFIED IDEOGRAPH
    {0xC960, 0x84A8}, //12307 #CJK UNIFIED IDEOGRAPH
    {0xC961, 0x84A9}, //12308 #CJK UNIFIED IDEOGRAPH
    {0xC962, 0x84AA}, //12309 #CJK UNIFIED IDEOGRAPH
    {0xC963, 0x84AB}, //12310 #CJK UNIFIED IDEOGRAPH
    {0xC964, 0x84AC}, //12311 #CJK UNIFIED IDEOGRAPH
    {0xC965, 0x84AD}, //12312 #CJK UNIFIED IDEOGRAPH
    {0xC966, 0x84AE}, //12313 #CJK UNIFIED IDEOGRAPH
    {0xC967, 0x84B0}, //12314 #CJK UNIFIED IDEOGRAPH
    {0xC968, 0x84B1}, //12315 #CJK UNIFIED IDEOGRAPH
    {0xC969, 0x84B3}, //12316 #CJK UNIFIED IDEOGRAPH
    {0xC96A, 0x84B5}, //12317 #CJK UNIFIED IDEOGRAPH
    {0xC96B, 0x84B6}, //12318 #CJK UNIFIED IDEOGRAPH
    {0xC96C, 0x84B7}, //12319 #CJK UNIFIED IDEOGRAPH
    {0xC96D, 0x84BB}, //12320 #CJK UNIFIED IDEOGRAPH
    {0xC96E, 0x84BC}, //12321 #CJK UNIFIED IDEOGRAPH
    {0xC96F, 0x84BE}, //12322 #CJK UNIFIED IDEOGRAPH
    {0xC970, 0x84C0}, //12323 #CJK UNIFIED IDEOGRAPH
    {0xC971, 0x84C2}, //12324 #CJK UNIFIED IDEOGRAPH
    {0xC972, 0x84C3}, //12325 #CJK UNIFIED IDEOGRAPH
    {0xC973, 0x84C5}, //12326 #CJK UNIFIED IDEOGRAPH
    {0xC974, 0x84C6}, //12327 #CJK UNIFIED IDEOGRAPH
    {0xC975, 0x84C7}, //12328 #CJK UNIFIED IDEOGRAPH
    {0xC976, 0x84C8}, //12329 #CJK UNIFIED IDEOGRAPH
    {0xC977, 0x84CB}, //12330 #CJK UNIFIED IDEOGRAPH
    {0xC978, 0x84CC}, //12331 #CJK UNIFIED IDEOGRAPH
    {0xC979, 0x84CE}, //12332 #CJK UNIFIED IDEOGRAPH
    {0xC97A, 0x84CF}, //12333 #CJK UNIFIED IDEOGRAPH
    {0xC97B, 0x84D2}, //12334 #CJK UNIFIED IDEOGRAPH
    {0xC97C, 0x84D4}, //12335 #CJK UNIFIED IDEOGRAPH
    {0xC97D, 0x84D5}, //12336 #CJK UNIFIED IDEOGRAPH
    {0xC97E, 0x84D7}, //12337 #CJK UNIFIED IDEOGRAPH
    {0xC980, 0x84D8}, //12338 #CJK UNIFIED IDEOGRAPH
    {0xC981, 0x84D9}, //12339 #CJK UNIFIED IDEOGRAPH
    {0xC982, 0x84DA}, //12340 #CJK UNIFIED IDEOGRAPH
    {0xC983, 0x84DB}, //12341 #CJK UNIFIED IDEOGRAPH
    {0xC984, 0x84DC}, //12342 #CJK UNIFIED IDEOGRAPH
    {0xC985, 0x84DE}, //12343 #CJK UNIFIED IDEOGRAPH
    {0xC986, 0x84E1}, //12344 #CJK UNIFIED IDEOGRAPH
    {0xC987, 0x84E2}, //12345 #CJK UNIFIED IDEOGRAPH
    {0xC988, 0x84E4}, //12346 #CJK UNIFIED IDEOGRAPH
    {0xC989, 0x84E7}, //12347 #CJK UNIFIED IDEOGRAPH
    {0xC98A, 0x84E8}, //12348 #CJK UNIFIED IDEOGRAPH
    {0xC98B, 0x84E9}, //12349 #CJK UNIFIED IDEOGRAPH
    {0xC98C, 0x84EA}, //12350 #CJK UNIFIED IDEOGRAPH
    {0xC98D, 0x84EB}, //12351 #CJK UNIFIED IDEOGRAPH
    {0xC98E, 0x84ED}, //12352 #CJK UNIFIED IDEOGRAPH
    {0xC98F, 0x84EE}, //12353 #CJK UNIFIED IDEOGRAPH
    {0xC990, 0x84EF}, //12354 #CJK UNIFIED IDEOGRAPH
    {0xC991, 0x84F1}, //12355 #CJK UNIFIED IDEOGRAPH
    {0xC992, 0x84F2}, //12356 #CJK UNIFIED IDEOGRAPH
    {0xC993, 0x84F3}, //12357 #CJK UNIFIED IDEOGRAPH
    {0xC994, 0x84F4}, //12358 #CJK UNIFIED IDEOGRAPH
    {0xC995, 0x84F5}, //12359 #CJK UNIFIED IDEOGRAPH
    {0xC996, 0x84F6}, //12360 #CJK UNIFIED IDEOGRAPH
    {0xC997, 0x84F7}, //12361 #CJK UNIFIED IDEOGRAPH
    {0xC998, 0x84F8}, //12362 #CJK UNIFIED IDEOGRAPH
    {0xC999, 0x84F9}, //12363 #CJK UNIFIED IDEOGRAPH
    {0xC99A, 0x84FA}, //12364 #CJK UNIFIED IDEOGRAPH
    {0xC99B, 0x84FB}, //12365 #CJK UNIFIED IDEOGRAPH
    {0xC99C, 0x84FD}, //12366 #CJK UNIFIED IDEOGRAPH
    {0xC99D, 0x84FE}, //12367 #CJK UNIFIED IDEOGRAPH
    {0xC99E, 0x8500}, //12368 #CJK UNIFIED IDEOGRAPH
    {0xC99F, 0x8501}, //12369 #CJK UNIFIED IDEOGRAPH
    {0xC9A0, 0x8502}, //12370 #CJK UNIFIED IDEOGRAPH
    {0xC9A1, 0x4F1E}, //12371 #CJK UNIFIED IDEOGRAPH
    {0xC9A2, 0x6563}, //12372 #CJK UNIFIED IDEOGRAPH
    {0xC9A3, 0x6851}, //12373 #CJK UNIFIED IDEOGRAPH
    {0xC9A4, 0x55D3}, //12374 #CJK UNIFIED IDEOGRAPH
    {0xC9A5, 0x4E27}, //12375 #CJK UNIFIED IDEOGRAPH
    {0xC9A6, 0x6414}, //12376 #CJK UNIFIED IDEOGRAPH
    {0xC9A7, 0x9A9A}, //12377 #CJK UNIFIED IDEOGRAPH
    {0xC9A8, 0x626B}, //12378 #CJK UNIFIED IDEOGRAPH
    {0xC9A9, 0x5AC2}, //12379 #CJK UNIFIED IDEOGRAPH
    {0xC9AA, 0x745F}, //12380 #CJK UNIFIED IDEOGRAPH
    {0xC9AB, 0x8272}, //12381 #CJK UNIFIED IDEOGRAPH
    {0xC9AC, 0x6DA9}, //12382 #CJK UNIFIED IDEOGRAPH
    {0xC9AD, 0x68EE}, //12383 #CJK UNIFIED IDEOGRAPH
    {0xC9AE, 0x50E7}, //12384 #CJK UNIFIED IDEOGRAPH
    {0xC9AF, 0x838E}, //12385 #CJK UNIFIED IDEOGRAPH
    {0xC9B0, 0x7802}, //12386 #CJK UNIFIED IDEOGRAPH
    {0xC9B1, 0x6740}, //12387 #CJK UNIFIED IDEOGRAPH
    {0xC9B2, 0x5239}, //12388 #CJK UNIFIED IDEOGRAPH
    {0xC9B3, 0x6C99}, //12389 #CJK UNIFIED IDEOGRAPH
    {0xC9B4, 0x7EB1}, //12390 #CJK UNIFIED IDEOGRAPH
    {0xC9B5, 0x50BB}, //12391 #CJK UNIFIED IDEOGRAPH
    {0xC9B6, 0x5565}, //12392 #CJK UNIFIED IDEOGRAPH
    {0xC9B7, 0x715E}, //12393 #CJK UNIFIED IDEOGRAPH
    {0xC9B8, 0x7B5B}, //12394 #CJK UNIFIED IDEOGRAPH
    {0xC9B9, 0x6652}, //12395 #CJK UNIFIED IDEOGRAPH
    {0xC9BA, 0x73CA}, //12396 #CJK UNIFIED IDEOGRAPH
    {0xC9BB, 0x82EB}, //12397 #CJK UNIFIED IDEOGRAPH
    {0xC9BC, 0x6749}, //12398 #CJK UNIFIED IDEOGRAPH
    {0xC9BD, 0x5C71}, //12399 #CJK UNIFIED IDEOGRAPH
    {0xC9BE, 0x5220}, //12400 #CJK UNIFIED IDEOGRAPH
    {0xC9BF, 0x717D}, //12401 #CJK UNIFIED IDEOGRAPH
    {0xC9C0, 0x886B}, //12402 #CJK UNIFIED IDEOGRAPH
    {0xC9C1, 0x95EA}, //12403 #CJK UNIFIED IDEOGRAPH
    {0xC9C2, 0x9655}, //12404 #CJK UNIFIED IDEOGRAPH
    {0xC9C3, 0x64C5}, //12405 #CJK UNIFIED IDEOGRAPH
    {0xC9C4, 0x8D61}, //12406 #CJK UNIFIED IDEOGRAPH
    {0xC9C5, 0x81B3}, //12407 #CJK UNIFIED IDEOGRAPH
    {0xC9C6, 0x5584}, //12408 #CJK UNIFIED IDEOGRAPH
    {0xC9C7, 0x6C55}, //12409 #CJK UNIFIED IDEOGRAPH
    {0xC9C8, 0x6247}, //12410 #CJK UNIFIED IDEOGRAPH
    {0xC9C9, 0x7F2E}, //12411 #CJK UNIFIED IDEOGRAPH
    {0xC9CA, 0x5892}, //12412 #CJK UNIFIED IDEOGRAPH
    {0xC9CB, 0x4F24}, //12413 #CJK UNIFIED IDEOGRAPH
    {0xC9CC, 0x5546}, //12414 #CJK UNIFIED IDEOGRAPH
    {0xC9CD, 0x8D4F}, //12415 #CJK UNIFIED IDEOGRAPH
    {0xC9CE, 0x664C}, //12416 #CJK UNIFIED IDEOGRAPH
    {0xC9CF, 0x4E0A}, //12417 #CJK UNIFIED IDEOGRAPH
    {0xC9D0, 0x5C1A}, //12418 #CJK UNIFIED IDEOGRAPH
    {0xC9D1, 0x88F3}, //12419 #CJK UNIFIED IDEOGRAPH
    {0xC9D2, 0x68A2}, //12420 #CJK UNIFIED IDEOGRAPH
    {0xC9D3, 0x634E}, //12421 #CJK UNIFIED IDEOGRAPH
    {0xC9D4, 0x7A0D}, //12422 #CJK UNIFIED IDEOGRAPH
    {0xC9D5, 0x70E7}, //12423 #CJK UNIFIED IDEOGRAPH
    {0xC9D6, 0x828D}, //12424 #CJK UNIFIED IDEOGRAPH
    {0xC9D7, 0x52FA}, //12425 #CJK UNIFIED IDEOGRAPH
    {0xC9D8, 0x97F6}, //12426 #CJK UNIFIED IDEOGRAPH
    {0xC9D9, 0x5C11}, //12427 #CJK UNIFIED IDEOGRAPH
    {0xC9DA, 0x54E8}, //12428 #CJK UNIFIED IDEOGRAPH
    {0xC9DB, 0x90B5}, //12429 #CJK UNIFIED IDEOGRAPH
    {0xC9DC, 0x7ECD}, //12430 #CJK UNIFIED IDEOGRAPH
    {0xC9DD, 0x5962}, //12431 #CJK UNIFIED IDEOGRAPH
    {0xC9DE, 0x8D4A}, //12432 #CJK UNIFIED IDEOGRAPH
    {0xC9DF, 0x86C7}, //12433 #CJK UNIFIED IDEOGRAPH
    {0xC9E0, 0x820C}, //12434 #CJK UNIFIED IDEOGRAPH
    {0xC9E1, 0x820D}, //12435 #CJK UNIFIED IDEOGRAPH
    {0xC9E2, 0x8D66}, //12436 #CJK UNIFIED IDEOGRAPH
    {0xC9E3, 0x6444}, //12437 #CJK UNIFIED IDEOGRAPH
    {0xC9E4, 0x5C04}, //12438 #CJK UNIFIED IDEOGRAPH
    {0xC9E5, 0x6151}, //12439 #CJK UNIFIED IDEOGRAPH
    {0xC9E6, 0x6D89}, //12440 #CJK UNIFIED IDEOGRAPH
    {0xC9E7, 0x793E}, //12441 #CJK UNIFIED IDEOGRAPH
    {0xC9E8, 0x8BBE}, //12442 #CJK UNIFIED IDEOGRAPH
    {0xC9E9, 0x7837}, //12443 #CJK UNIFIED IDEOGRAPH
    {0xC9EA, 0x7533}, //12444 #CJK UNIFIED IDEOGRAPH
    {0xC9EB, 0x547B}, //12445 #CJK UNIFIED IDEOGRAPH
    {0xC9EC, 0x4F38}, //12446 #CJK UNIFIED IDEOGRAPH
    {0xC9ED, 0x8EAB}, //12447 #CJK UNIFIED IDEOGRAPH
    {0xC9EE, 0x6DF1}, //12448 #CJK UNIFIED IDEOGRAPH
    {0xC9EF, 0x5A20}, //12449 #CJK UNIFIED IDEOGRAPH
    {0xC9F0, 0x7EC5}, //12450 #CJK UNIFIED IDEOGRAPH
    {0xC9F1, 0x795E}, //12451 #CJK UNIFIED IDEOGRAPH
    {0xC9F2, 0x6C88}, //12452 #CJK UNIFIED IDEOGRAPH
    {0xC9F3, 0x5BA1}, //12453 #CJK UNIFIED IDEOGRAPH
    {0xC9F4, 0x5A76}, //12454 #CJK UNIFIED IDEOGRAPH
    {0xC9F5, 0x751A}, //12455 #CJK UNIFIED IDEOGRAPH
    {0xC9F6, 0x80BE}, //12456 #CJK UNIFIED IDEOGRAPH
    {0xC9F7, 0x614E}, //12457 #CJK UNIFIED IDEOGRAPH
    {0xC9F8, 0x6E17}, //12458 #CJK UNIFIED IDEOGRAPH
    {0xC9F9, 0x58F0}, //12459 #CJK UNIFIED IDEOGRAPH
    {0xC9FA, 0x751F}, //12460 #CJK UNIFIED IDEOGRAPH
    {0xC9FB, 0x7525}, //12461 #CJK UNIFIED IDEOGRAPH
    {0xC9FC, 0x7272}, //12462 #CJK UNIFIED IDEOGRAPH
    {0xC9FD, 0x5347}, //12463 #CJK UNIFIED IDEOGRAPH
    {0xC9FE, 0x7EF3}, //12464 #CJK UNIFIED IDEOGRAPH
    {0xCA40, 0x8503}, //12465 #CJK UNIFIED IDEOGRAPH
    {0xCA41, 0x8504}, //12466 #CJK UNIFIED IDEOGRAPH
    {0xCA42, 0x8505}, //12467 #CJK UNIFIED IDEOGRAPH
    {0xCA43, 0x8506}, //12468 #CJK UNIFIED IDEOGRAPH
    {0xCA44, 0x8507}, //12469 #CJK UNIFIED IDEOGRAPH
    {0xCA45, 0x8508}, //12470 #CJK UNIFIED IDEOGRAPH
    {0xCA46, 0x8509}, //12471 #CJK UNIFIED IDEOGRAPH
    {0xCA47, 0x850A}, //12472 #CJK UNIFIED IDEOGRAPH
    {0xCA48, 0x850B}, //12473 #CJK UNIFIED IDEOGRAPH
    {0xCA49, 0x850D}, //12474 #CJK UNIFIED IDEOGRAPH
    {0xCA4A, 0x850E}, //12475 #CJK UNIFIED IDEOGRAPH
    {0xCA4B, 0x850F}, //12476 #CJK UNIFIED IDEOGRAPH
    {0xCA4C, 0x8510}, //12477 #CJK UNIFIED IDEOGRAPH
    {0xCA4D, 0x8512}, //12478 #CJK UNIFIED IDEOGRAPH
    {0xCA4E, 0x8514}, //12479 #CJK UNIFIED IDEOGRAPH
    {0xCA4F, 0x8515}, //12480 #CJK UNIFIED IDEOGRAPH
    {0xCA50, 0x8516}, //12481 #CJK UNIFIED IDEOGRAPH
    {0xCA51, 0x8518}, //12482 #CJK UNIFIED IDEOGRAPH
    {0xCA52, 0x8519}, //12483 #CJK UNIFIED IDEOGRAPH
    {0xCA53, 0x851B}, //12484 #CJK UNIFIED IDEOGRAPH
    {0xCA54, 0x851C}, //12485 #CJK UNIFIED IDEOGRAPH
    {0xCA55, 0x851D}, //12486 #CJK UNIFIED IDEOGRAPH
    {0xCA56, 0x851E}, //12487 #CJK UNIFIED IDEOGRAPH
    {0xCA57, 0x8520}, //12488 #CJK UNIFIED IDEOGRAPH
    {0xCA58, 0x8522}, //12489 #CJK UNIFIED IDEOGRAPH
    {0xCA59, 0x8523}, //12490 #CJK UNIFIED IDEOGRAPH
    {0xCA5A, 0x8524}, //12491 #CJK UNIFIED IDEOGRAPH
    {0xCA5B, 0x8525}, //12492 #CJK UNIFIED IDEOGRAPH
    {0xCA5C, 0x8526}, //12493 #CJK UNIFIED IDEOGRAPH
    {0xCA5D, 0x8527}, //12494 #CJK UNIFIED IDEOGRAPH
    {0xCA5E, 0x8528}, //12495 #CJK UNIFIED IDEOGRAPH
    {0xCA5F, 0x8529}, //12496 #CJK UNIFIED IDEOGRAPH
    {0xCA60, 0x852A}, //12497 #CJK UNIFIED IDEOGRAPH
    {0xCA61, 0x852D}, //12498 #CJK UNIFIED IDEOGRAPH
    {0xCA62, 0x852E}, //12499 #CJK UNIFIED IDEOGRAPH
    {0xCA63, 0x852F}, //12500 #CJK UNIFIED IDEOGRAPH
    {0xCA64, 0x8530}, //12501 #CJK UNIFIED IDEOGRAPH
    {0xCA65, 0x8531}, //12502 #CJK UNIFIED IDEOGRAPH
    {0xCA66, 0x8532}, //12503 #CJK UNIFIED IDEOGRAPH
    {0xCA67, 0x8533}, //12504 #CJK UNIFIED IDEOGRAPH
    {0xCA68, 0x8534}, //12505 #CJK UNIFIED IDEOGRAPH
    {0xCA69, 0x8535}, //12506 #CJK UNIFIED IDEOGRAPH
    {0xCA6A, 0x8536}, //12507 #CJK UNIFIED IDEOGRAPH
    {0xCA6B, 0x853E}, //12508 #CJK UNIFIED IDEOGRAPH
    {0xCA6C, 0x853F}, //12509 #CJK UNIFIED IDEOGRAPH
    {0xCA6D, 0x8540}, //12510 #CJK UNIFIED IDEOGRAPH
    {0xCA6E, 0x8541}, //12511 #CJK UNIFIED IDEOGRAPH
    {0xCA6F, 0x8542}, //12512 #CJK UNIFIED IDEOGRAPH
    {0xCA70, 0x8544}, //12513 #CJK UNIFIED IDEOGRAPH
    {0xCA71, 0x8545}, //12514 #CJK UNIFIED IDEOGRAPH
    {0xCA72, 0x8546}, //12515 #CJK UNIFIED IDEOGRAPH
    {0xCA73, 0x8547}, //12516 #CJK UNIFIED IDEOGRAPH
    {0xCA74, 0x854B}, //12517 #CJK UNIFIED IDEOGRAPH
    {0xCA75, 0x854C}, //12518 #CJK UNIFIED IDEOGRAPH
    {0xCA76, 0x854D}, //12519 #CJK UNIFIED IDEOGRAPH
    {0xCA77, 0x854E}, //12520 #CJK UNIFIED IDEOGRAPH
    {0xCA78, 0x854F}, //12521 #CJK UNIFIED IDEOGRAPH
    {0xCA79, 0x8550}, //12522 #CJK UNIFIED IDEOGRAPH
    {0xCA7A, 0x8551}, //12523 #CJK UNIFIED IDEOGRAPH
    {0xCA7B, 0x8552}, //12524 #CJK UNIFIED IDEOGRAPH
    {0xCA7C, 0x8553}, //12525 #CJK UNIFIED IDEOGRAPH
    {0xCA7D, 0x8554}, //12526 #CJK UNIFIED IDEOGRAPH
    {0xCA7E, 0x8555}, //12527 #CJK UNIFIED IDEOGRAPH
    {0xCA80, 0x8557}, //12528 #CJK UNIFIED IDEOGRAPH
    {0xCA81, 0x8558}, //12529 #CJK UNIFIED IDEOGRAPH
    {0xCA82, 0x855A}, //12530 #CJK UNIFIED IDEOGRAPH
    {0xCA83, 0x855B}, //12531 #CJK UNIFIED IDEOGRAPH
    {0xCA84, 0x855C}, //12532 #CJK UNIFIED IDEOGRAPH
    {0xCA85, 0x855D}, //12533 #CJK UNIFIED IDEOGRAPH
    {0xCA86, 0x855F}, //12534 #CJK UNIFIED IDEOGRAPH
    {0xCA87, 0x8560}, //12535 #CJK UNIFIED IDEOGRAPH
    {0xCA88, 0x8561}, //12536 #CJK UNIFIED IDEOGRAPH
    {0xCA89, 0x8562}, //12537 #CJK UNIFIED IDEOGRAPH
    {0xCA8A, 0x8563}, //12538 #CJK UNIFIED IDEOGRAPH
    {0xCA8B, 0x8565}, //12539 #CJK UNIFIED IDEOGRAPH
    {0xCA8C, 0x8566}, //12540 #CJK UNIFIED IDEOGRAPH
    {0xCA8D, 0x8567}, //12541 #CJK UNIFIED IDEOGRAPH
    {0xCA8E, 0x8569}, //12542 #CJK UNIFIED IDEOGRAPH
    {0xCA8F, 0x856A}, //12543 #CJK UNIFIED IDEOGRAPH
    {0xCA90, 0x856B}, //12544 #CJK UNIFIED IDEOGRAPH
    {0xCA91, 0x856C}, //12545 #CJK UNIFIED IDEOGRAPH
    {0xCA92, 0x856D}, //12546 #CJK UNIFIED IDEOGRAPH
    {0xCA93, 0x856E}, //12547 #CJK UNIFIED IDEOGRAPH
    {0xCA94, 0x856F}, //12548 #CJK UNIFIED IDEOGRAPH
    {0xCA95, 0x8570}, //12549 #CJK UNIFIED IDEOGRAPH
    {0xCA96, 0x8571}, //12550 #CJK UNIFIED IDEOGRAPH
    {0xCA97, 0x8573}, //12551 #CJK UNIFIED IDEOGRAPH
    {0xCA98, 0x8575}, //12552 #CJK UNIFIED IDEOGRAPH
    {0xCA99, 0x8576}, //12553 #CJK UNIFIED IDEOGRAPH
    {0xCA9A, 0x8577}, //12554 #CJK UNIFIED IDEOGRAPH
    {0xCA9B, 0x8578}, //12555 #CJK UNIFIED IDEOGRAPH
    {0xCA9C, 0x857C}, //12556 #CJK UNIFIED IDEOGRAPH
    {0xCA9D, 0x857D}, //12557 #CJK UNIFIED IDEOGRAPH
    {0xCA9E, 0x857F}, //12558 #CJK UNIFIED IDEOGRAPH
    {0xCA9F, 0x8580}, //12559 #CJK UNIFIED IDEOGRAPH
    {0xCAA0, 0x8581}, //12560 #CJK UNIFIED IDEOGRAPH
    {0xCAA1, 0x7701}, //12561 #CJK UNIFIED IDEOGRAPH
    {0xCAA2, 0x76DB}, //12562 #CJK UNIFIED IDEOGRAPH
    {0xCAA3, 0x5269}, //12563 #CJK UNIFIED IDEOGRAPH
    {0xCAA4, 0x80DC}, //12564 #CJK UNIFIED IDEOGRAPH
    {0xCAA5, 0x5723}, //12565 #CJK UNIFIED IDEOGRAPH
    {0xCAA6, 0x5E08}, //12566 #CJK UNIFIED IDEOGRAPH
    {0xCAA7, 0x5931}, //12567 #CJK UNIFIED IDEOGRAPH
    {0xCAA8, 0x72EE}, //12568 #CJK UNIFIED IDEOGRAPH
    {0xCAA9, 0x65BD}, //12569 #CJK UNIFIED IDEOGRAPH
    {0xCAAA, 0x6E7F}, //12570 #CJK UNIFIED IDEOGRAPH
    {0xCAAB, 0x8BD7}, //12571 #CJK UNIFIED IDEOGRAPH
    {0xCAAC, 0x5C38}, //12572 #CJK UNIFIED IDEOGRAPH
    {0xCAAD, 0x8671}, //12573 #CJK UNIFIED IDEOGRAPH
    {0xCAAE, 0x5341}, //12574 #CJK UNIFIED IDEOGRAPH
    {0xCAAF, 0x77F3}, //12575 #CJK UNIFIED IDEOGRAPH
    {0xCAB0, 0x62FE}, //12576 #CJK UNIFIED IDEOGRAPH
    {0xCAB1, 0x65F6}, //12577 #CJK UNIFIED IDEOGRAPH
    {0xCAB2, 0x4EC0}, //12578 #CJK UNIFIED IDEOGRAPH
    {0xCAB3, 0x98DF}, //12579 #CJK UNIFIED IDEOGRAPH
    {0xCAB4, 0x8680}, //12580 #CJK UNIFIED IDEOGRAPH
    {0xCAB5, 0x5B9E}, //12581 #CJK UNIFIED IDEOGRAPH
    {0xCAB6, 0x8BC6}, //12582 #CJK UNIFIED IDEOGRAPH
    {0xCAB7, 0x53F2}, //12583 #CJK UNIFIED IDEOGRAPH
    {0xCAB8, 0x77E2}, //12584 #CJK UNIFIED IDEOGRAPH
    {0xCAB9, 0x4F7F}, //12585 #CJK UNIFIED IDEOGRAPH
    {0xCABA, 0x5C4E}, //12586 #CJK UNIFIED IDEOGRAPH
    {0xCABB, 0x9A76}, //12587 #CJK UNIFIED IDEOGRAPH
    {0xCABC, 0x59CB}, //12588 #CJK UNIFIED IDEOGRAPH
    {0xCABD, 0x5F0F}, //12589 #CJK UNIFIED IDEOGRAPH
    {0xCABE, 0x793A}, //12590 #CJK UNIFIED IDEOGRAPH
    {0xCABF, 0x58EB}, //12591 #CJK UNIFIED IDEOGRAPH
    {0xCAC0, 0x4E16}, //12592 #CJK UNIFIED IDEOGRAPH
    {0xCAC1, 0x67FF}, //12593 #CJK UNIFIED IDEOGRAPH
    {0xCAC2, 0x4E8B}, //12594 #CJK UNIFIED IDEOGRAPH
    {0xCAC3, 0x62ED}, //12595 #CJK UNIFIED IDEOGRAPH
    {0xCAC4, 0x8A93}, //12596 #CJK UNIFIED IDEOGRAPH
    {0xCAC5, 0x901D}, //12597 #CJK UNIFIED IDEOGRAPH
    {0xCAC6, 0x52BF}, //12598 #CJK UNIFIED IDEOGRAPH
    {0xCAC7, 0x662F}, //12599 #CJK UNIFIED IDEOGRAPH
    {0xCAC8, 0x55DC}, //12600 #CJK UNIFIED IDEOGRAPH
    {0xCAC9, 0x566C}, //12601 #CJK UNIFIED IDEOGRAPH
    {0xCACA, 0x9002}, //12602 #CJK UNIFIED IDEOGRAPH
    {0xCACB, 0x4ED5}, //12603 #CJK UNIFIED IDEOGRAPH
    {0xCACC, 0x4F8D}, //12604 #CJK UNIFIED IDEOGRAPH
    {0xCACD, 0x91CA}, //12605 #CJK UNIFIED IDEOGRAPH
    {0xCACE, 0x9970}, //12606 #CJK UNIFIED IDEOGRAPH
    {0xCACF, 0x6C0F}, //12607 #CJK UNIFIED IDEOGRAPH
    {0xCAD0, 0x5E02}, //12608 #CJK UNIFIED IDEOGRAPH
    {0xCAD1, 0x6043}, //12609 #CJK UNIFIED IDEOGRAPH
    {0xCAD2, 0x5BA4}, //12610 #CJK UNIFIED IDEOGRAPH
    {0xCAD3, 0x89C6}, //12611 #CJK UNIFIED IDEOGRAPH
    {0xCAD4, 0x8BD5}, //12612 #CJK UNIFIED IDEOGRAPH
    {0xCAD5, 0x6536}, //12613 #CJK UNIFIED IDEOGRAPH
    {0xCAD6, 0x624B}, //12614 #CJK UNIFIED IDEOGRAPH
    {0xCAD7, 0x9996}, //12615 #CJK UNIFIED IDEOGRAPH
    {0xCAD8, 0x5B88}, //12616 #CJK UNIFIED IDEOGRAPH
    {0xCAD9, 0x5BFF}, //12617 #CJK UNIFIED IDEOGRAPH
    {0xCADA, 0x6388}, //12618 #CJK UNIFIED IDEOGRAPH
    {0xCADB, 0x552E}, //12619 #CJK UNIFIED IDEOGRAPH
    {0xCADC, 0x53D7}, //12620 #CJK UNIFIED IDEOGRAPH
    {0xCADD, 0x7626}, //12621 #CJK UNIFIED IDEOGRAPH
    {0xCADE, 0x517D}, //12622 #CJK UNIFIED IDEOGRAPH
    {0xCADF, 0x852C}, //12623 #CJK UNIFIED IDEOGRAPH
    {0xCAE0, 0x67A2}, //12624 #CJK UNIFIED IDEOGRAPH
    {0xCAE1, 0x68B3}, //12625 #CJK UNIFIED IDEOGRAPH
    {0xCAE2, 0x6B8A}, //12626 #CJK UNIFIED IDEOGRAPH
    {0xCAE3, 0x6292}, //12627 #CJK UNIFIED IDEOGRAPH
    {0xCAE4, 0x8F93}, //12628 #CJK UNIFIED IDEOGRAPH
    {0xCAE5, 0x53D4}, //12629 #CJK UNIFIED IDEOGRAPH
    {0xCAE6, 0x8212}, //12630 #CJK UNIFIED IDEOGRAPH
    {0xCAE7, 0x6DD1}, //12631 #CJK UNIFIED IDEOGRAPH
    {0xCAE8, 0x758F}, //12632 #CJK UNIFIED IDEOGRAPH
    {0xCAE9, 0x4E66}, //12633 #CJK UNIFIED IDEOGRAPH
    {0xCAEA, 0x8D4E}, //12634 #CJK UNIFIED IDEOGRAPH
    {0xCAEB, 0x5B70}, //12635 #CJK UNIFIED IDEOGRAPH
    {0xCAEC, 0x719F}, //12636 #CJK UNIFIED IDEOGRAPH
    {0xCAED, 0x85AF}, //12637 #CJK UNIFIED IDEOGRAPH
    {0xCAEE, 0x6691}, //12638 #CJK UNIFIED IDEOGRAPH
    {0xCAEF, 0x66D9}, //12639 #CJK UNIFIED IDEOGRAPH
    {0xCAF0, 0x7F72}, //12640 #CJK UNIFIED IDEOGRAPH
    {0xCAF1, 0x8700}, //12641 #CJK UNIFIED IDEOGRAPH
    {0xCAF2, 0x9ECD}, //12642 #CJK UNIFIED IDEOGRAPH
    {0xCAF3, 0x9F20}, //12643 #CJK UNIFIED IDEOGRAPH
    {0xCAF4, 0x5C5E}, //12644 #CJK UNIFIED IDEOGRAPH
    {0xCAF5, 0x672F}, //12645 #CJK UNIFIED IDEOGRAPH
    {0xCAF6, 0x8FF0}, //12646 #CJK UNIFIED IDEOGRAPH
    {0xCAF7, 0x6811}, //12647 #CJK UNIFIED IDEOGRAPH
    {0xCAF8, 0x675F}, //12648 #CJK UNIFIED IDEOGRAPH
    {0xCAF9, 0x620D}, //12649 #CJK UNIFIED IDEOGRAPH
    {0xCAFA, 0x7AD6}, //12650 #CJK UNIFIED IDEOGRAPH
    {0xCAFB, 0x5885}, //12651 #CJK UNIFIED IDEOGRAPH
    {0xCAFC, 0x5EB6}, //12652 #CJK UNIFIED IDEOGRAPH
    {0xCAFD, 0x6570}, //12653 #CJK UNIFIED IDEOGRAPH
    {0xCAFE, 0x6F31}, //12654 #CJK UNIFIED IDEOGRAPH
    {0xCB40, 0x8582}, //12655 #CJK UNIFIED IDEOGRAPH
    {0xCB41, 0x8583}, //12656 #CJK UNIFIED IDEOGRAPH
    {0xCB42, 0x8586}, //12657 #CJK UNIFIED IDEOGRAPH
    {0xCB43, 0x8588}, //12658 #CJK UNIFIED IDEOGRAPH
    {0xCB44, 0x8589}, //12659 #CJK UNIFIED IDEOGRAPH
    {0xCB45, 0x858A}, //12660 #CJK UNIFIED IDEOGRAPH
    {0xCB46, 0x858B}, //12661 #CJK UNIFIED IDEOGRAPH
    {0xCB47, 0x858C}, //12662 #CJK UNIFIED IDEOGRAPH
    {0xCB48, 0x858D}, //12663 #CJK UNIFIED IDEOGRAPH
    {0xCB49, 0x858E}, //12664 #CJK UNIFIED IDEOGRAPH
    {0xCB4A, 0x8590}, //12665 #CJK UNIFIED IDEOGRAPH
    {0xCB4B, 0x8591}, //12666 #CJK UNIFIED IDEOGRAPH
    {0xCB4C, 0x8592}, //12667 #CJK UNIFIED IDEOGRAPH
    {0xCB4D, 0x8593}, //12668 #CJK UNIFIED IDEOGRAPH
    {0xCB4E, 0x8594}, //12669 #CJK UNIFIED IDEOGRAPH
    {0xCB4F, 0x8595}, //12670 #CJK UNIFIED IDEOGRAPH
    {0xCB50, 0x8596}, //12671 #CJK UNIFIED IDEOGRAPH
    {0xCB51, 0x8597}, //12672 #CJK UNIFIED IDEOGRAPH
    {0xCB52, 0x8598}, //12673 #CJK UNIFIED IDEOGRAPH
    {0xCB53, 0x8599}, //12674 #CJK UNIFIED IDEOGRAPH
    {0xCB54, 0x859A}, //12675 #CJK UNIFIED IDEOGRAPH
    {0xCB55, 0x859D}, //12676 #CJK UNIFIED IDEOGRAPH
    {0xCB56, 0x859E}, //12677 #CJK UNIFIED IDEOGRAPH
    {0xCB57, 0x859F}, //12678 #CJK UNIFIED IDEOGRAPH
    {0xCB58, 0x85A0}, //12679 #CJK UNIFIED IDEOGRAPH
    {0xCB59, 0x85A1}, //12680 #CJK UNIFIED IDEOGRAPH
    {0xCB5A, 0x85A2}, //12681 #CJK UNIFIED IDEOGRAPH
    {0xCB5B, 0x85A3}, //12682 #CJK UNIFIED IDEOGRAPH
    {0xCB5C, 0x85A5}, //12683 #CJK UNIFIED IDEOGRAPH
    {0xCB5D, 0x85A6}, //12684 #CJK UNIFIED IDEOGRAPH
    {0xCB5E, 0x85A7}, //12685 #CJK UNIFIED IDEOGRAPH
    {0xCB5F, 0x85A9}, //12686 #CJK UNIFIED IDEOGRAPH
    {0xCB60, 0x85AB}, //12687 #CJK UNIFIED IDEOGRAPH
    {0xCB61, 0x85AC}, //12688 #CJK UNIFIED IDEOGRAPH
    {0xCB62, 0x85AD}, //12689 #CJK UNIFIED IDEOGRAPH
    {0xCB63, 0x85B1}, //12690 #CJK UNIFIED IDEOGRAPH
    {0xCB64, 0x85B2}, //12691 #CJK UNIFIED IDEOGRAPH
    {0xCB65, 0x85B3}, //12692 #CJK UNIFIED IDEOGRAPH
    {0xCB66, 0x85B4}, //12693 #CJK UNIFIED IDEOGRAPH
    {0xCB67, 0x85B5}, //12694 #CJK UNIFIED IDEOGRAPH
    {0xCB68, 0x85B6}, //12695 #CJK UNIFIED IDEOGRAPH
    {0xCB69, 0x85B8}, //12696 #CJK UNIFIED IDEOGRAPH
    {0xCB6A, 0x85BA}, //12697 #CJK UNIFIED IDEOGRAPH
    {0xCB6B, 0x85BB}, //12698 #CJK UNIFIED IDEOGRAPH
    {0xCB6C, 0x85BC}, //12699 #CJK UNIFIED IDEOGRAPH
    {0xCB6D, 0x85BD}, //12700 #CJK UNIFIED IDEOGRAPH
    {0xCB6E, 0x85BE}, //12701 #CJK UNIFIED IDEOGRAPH
    {0xCB6F, 0x85BF}, //12702 #CJK UNIFIED IDEOGRAPH
    {0xCB70, 0x85C0}, //12703 #CJK UNIFIED IDEOGRAPH
    {0xCB71, 0x85C2}, //12704 #CJK UNIFIED IDEOGRAPH
    {0xCB72, 0x85C3}, //12705 #CJK UNIFIED IDEOGRAPH
    {0xCB73, 0x85C4}, //12706 #CJK UNIFIED IDEOGRAPH
    {0xCB74, 0x85C5}, //12707 #CJK UNIFIED IDEOGRAPH
    {0xCB75, 0x85C6}, //12708 #CJK UNIFIED IDEOGRAPH
    {0xCB76, 0x85C7}, //12709 #CJK UNIFIED IDEOGRAPH
    {0xCB77, 0x85C8}, //12710 #CJK UNIFIED IDEOGRAPH
    {0xCB78, 0x85CA}, //12711 #CJK UNIFIED IDEOGRAPH
    {0xCB79, 0x85CB}, //12712 #CJK UNIFIED IDEOGRAPH
    {0xCB7A, 0x85CC}, //12713 #CJK UNIFIED IDEOGRAPH
    {0xCB7B, 0x85CD}, //12714 #CJK UNIFIED IDEOGRAPH
    {0xCB7C, 0x85CE}, //12715 #CJK UNIFIED IDEOGRAPH
    {0xCB7D, 0x85D1}, //12716 #CJK UNIFIED IDEOGRAPH
    {0xCB7E, 0x85D2}, //12717 #CJK UNIFIED IDEOGRAPH
    {0xCB80, 0x85D4}, //12718 #CJK UNIFIED IDEOGRAPH
    {0xCB81, 0x85D6}, //12719 #CJK UNIFIED IDEOGRAPH
    {0xCB82, 0x85D7}, //12720 #CJK UNIFIED IDEOGRAPH
    {0xCB83, 0x85D8}, //12721 #CJK UNIFIED IDEOGRAPH
    {0xCB84, 0x85D9}, //12722 #CJK UNIFIED IDEOGRAPH
    {0xCB85, 0x85DA}, //12723 #CJK UNIFIED IDEOGRAPH
    {0xCB86, 0x85DB}, //12724 #CJK UNIFIED IDEOGRAPH
    {0xCB87, 0x85DD}, //12725 #CJK UNIFIED IDEOGRAPH
    {0xCB88, 0x85DE}, //12726 #CJK UNIFIED IDEOGRAPH
    {0xCB89, 0x85DF}, //12727 #CJK UNIFIED IDEOGRAPH
    {0xCB8A, 0x85E0}, //12728 #CJK UNIFIED IDEOGRAPH
    {0xCB8B, 0x85E1}, //12729 #CJK UNIFIED IDEOGRAPH
    {0xCB8C, 0x85E2}, //12730 #CJK UNIFIED IDEOGRAPH
    {0xCB8D, 0x85E3}, //12731 #CJK UNIFIED IDEOGRAPH
    {0xCB8E, 0x85E5}, //12732 #CJK UNIFIED IDEOGRAPH
    {0xCB8F, 0x85E6}, //12733 #CJK UNIFIED IDEOGRAPH
    {0xCB90, 0x85E7}, //12734 #CJK UNIFIED IDEOGRAPH
    {0xCB91, 0x85E8}, //12735 #CJK UNIFIED IDEOGRAPH
    {0xCB92, 0x85EA}, //12736 #CJK UNIFIED IDEOGRAPH
    {0xCB93, 0x85EB}, //12737 #CJK UNIFIED IDEOGRAPH
    {0xCB94, 0x85EC}, //12738 #CJK UNIFIED IDEOGRAPH
    {0xCB95, 0x85ED}, //12739 #CJK UNIFIED IDEOGRAPH
    {0xCB96, 0x85EE}, //12740 #CJK UNIFIED IDEOGRAPH
    {0xCB97, 0x85EF}, //12741 #CJK UNIFIED IDEOGRAPH
    {0xCB98, 0x85F0}, //12742 #CJK UNIFIED IDEOGRAPH
    {0xCB99, 0x85F1}, //12743 #CJK UNIFIED IDEOGRAPH
    {0xCB9A, 0x85F2}, //12744 #CJK UNIFIED IDEOGRAPH
    {0xCB9B, 0x85F3}, //12745 #CJK UNIFIED IDEOGRAPH
    {0xCB9C, 0x85F4}, //12746 #CJK UNIFIED IDEOGRAPH
    {0xCB9D, 0x85F5}, //12747 #CJK UNIFIED IDEOGRAPH
    {0xCB9E, 0x85F6}, //12748 #CJK UNIFIED IDEOGRAPH
    {0xCB9F, 0x85F7}, //12749 #CJK UNIFIED IDEOGRAPH
    {0xCBA0, 0x85F8}, //12750 #CJK UNIFIED IDEOGRAPH
    {0xCBA1, 0x6055}, //12751 #CJK UNIFIED IDEOGRAPH
    {0xCBA2, 0x5237}, //12752 #CJK UNIFIED IDEOGRAPH
    {0xCBA3, 0x800D}, //12753 #CJK UNIFIED IDEOGRAPH
    {0xCBA4, 0x6454}, //12754 #CJK UNIFIED IDEOGRAPH
    {0xCBA5, 0x8870}, //12755 #CJK UNIFIED IDEOGRAPH
    {0xCBA6, 0x7529}, //12756 #CJK UNIFIED IDEOGRAPH
    {0xCBA7, 0x5E05}, //12757 #CJK UNIFIED IDEOGRAPH
    {0xCBA8, 0x6813}, //12758 #CJK UNIFIED IDEOGRAPH
    {0xCBA9, 0x62F4}, //12759 #CJK UNIFIED IDEOGRAPH
    {0xCBAA, 0x971C}, //12760 #CJK UNIFIED IDEOGRAPH
    {0xCBAB, 0x53CC}, //12761 #CJK UNIFIED IDEOGRAPH
    {0xCBAC, 0x723D}, //12762 #CJK UNIFIED IDEOGRAPH
    {0xCBAD, 0x8C01}, //12763 #CJK UNIFIED IDEOGRAPH
    {0xCBAE, 0x6C34}, //12764 #CJK UNIFIED IDEOGRAPH
    {0xCBAF, 0x7761}, //12765 #CJK UNIFIED IDEOGRAPH
    {0xCBB0, 0x7A0E}, //12766 #CJK UNIFIED IDEOGRAPH
    {0xCBB1, 0x542E}, //12767 #CJK UNIFIED IDEOGRAPH
    {0xCBB2, 0x77AC}, //12768 #CJK UNIFIED IDEOGRAPH
    {0xCBB3, 0x987A}, //12769 #CJK UNIFIED IDEOGRAPH
    {0xCBB4, 0x821C}, //12770 #CJK UNIFIED IDEOGRAPH
    {0xCBB5, 0x8BF4}, //12771 #CJK UNIFIED IDEOGRAPH
    {0xCBB6, 0x7855}, //12772 #CJK UNIFIED IDEOGRAPH
    {0xCBB7, 0x6714}, //12773 #CJK UNIFIED IDEOGRAPH
    {0xCBB8, 0x70C1}, //12774 #CJK UNIFIED IDEOGRAPH
    {0xCBB9, 0x65AF}, //12775 #CJK UNIFIED IDEOGRAPH
    {0xCBBA, 0x6495}, //12776 #CJK UNIFIED IDEOGRAPH
    {0xCBBB, 0x5636}, //12777 #CJK UNIFIED IDEOGRAPH
    {0xCBBC, 0x601D}, //12778 #CJK UNIFIED IDEOGRAPH
    {0xCBBD, 0x79C1}, //12779 #CJK UNIFIED IDEOGRAPH
    {0xCBBE, 0x53F8}, //12780 #CJK UNIFIED IDEOGRAPH
    {0xCBBF, 0x4E1D}, //12781 #CJK UNIFIED IDEOGRAPH
    {0xCBC0, 0x6B7B}, //12782 #CJK UNIFIED IDEOGRAPH
    {0xCBC1, 0x8086}, //12783 #CJK UNIFIED IDEOGRAPH
    {0xCBC2, 0x5BFA}, //12784 #CJK UNIFIED IDEOGRAPH
    {0xCBC3, 0x55E3}, //12785 #CJK UNIFIED IDEOGRAPH
    {0xCBC4, 0x56DB}, //12786 #CJK UNIFIED IDEOGRAPH
    {0xCBC5, 0x4F3A}, //12787 #CJK UNIFIED IDEOGRAPH
    {0xCBC6, 0x4F3C}, //12788 #CJK UNIFIED IDEOGRAPH
    {0xCBC7, 0x9972}, //12789 #CJK UNIFIED IDEOGRAPH
    {0xCBC8, 0x5DF3}, //12790 #CJK UNIFIED IDEOGRAPH
    {0xCBC9, 0x677E}, //12791 #CJK UNIFIED IDEOGRAPH
    {0xCBCA, 0x8038}, //12792 #CJK UNIFIED IDEOGRAPH
    {0xCBCB, 0x6002}, //12793 #CJK UNIFIED IDEOGRAPH
    {0xCBCC, 0x9882}, //12794 #CJK UNIFIED IDEOGRAPH
    {0xCBCD, 0x9001}, //12795 #CJK UNIFIED IDEOGRAPH
    {0xCBCE, 0x5B8B}, //12796 #CJK UNIFIED IDEOGRAPH
    {0xCBCF, 0x8BBC}, //12797 #CJK UNIFIED IDEOGRAPH
    {0xCBD0, 0x8BF5}, //12798 #CJK UNIFIED IDEOGRAPH
    {0xCBD1, 0x641C}, //12799 #CJK UNIFIED IDEOGRAPH
    {0xCBD2, 0x8258}, //12800 #CJK UNIFIED IDEOGRAPH
    {0xCBD3, 0x64DE}, //12801 #CJK UNIFIED IDEOGRAPH
    {0xCBD4, 0x55FD}, //12802 #CJK UNIFIED IDEOGRAPH
    {0xCBD5, 0x82CF}, //12803 #CJK UNIFIED IDEOGRAPH
    {0xCBD6, 0x9165}, //12804 #CJK UNIFIED IDEOGRAPH
    {0xCBD7, 0x4FD7}, //12805 #CJK UNIFIED IDEOGRAPH
    {0xCBD8, 0x7D20}, //12806 #CJK UNIFIED IDEOGRAPH
    {0xCBD9, 0x901F}, //12807 #CJK UNIFIED IDEOGRAPH
    {0xCBDA, 0x7C9F}, //12808 #CJK UNIFIED IDEOGRAPH
    {0xCBDB, 0x50F3}, //12809 #CJK UNIFIED IDEOGRAPH
    {0xCBDC, 0x5851}, //12810 #CJK UNIFIED IDEOGRAPH
    {0xCBDD, 0x6EAF}, //12811 #CJK UNIFIED IDEOGRAPH
    {0xCBDE, 0x5BBF}, //12812 #CJK UNIFIED IDEOGRAPH
    {0xCBDF, 0x8BC9}, //12813 #CJK UNIFIED IDEOGRAPH
    {0xCBE0, 0x8083}, //12814 #CJK UNIFIED IDEOGRAPH
    {0xCBE1, 0x9178}, //12815 #CJK UNIFIED IDEOGRAPH
    {0xCBE2, 0x849C}, //12816 #CJK UNIFIED IDEOGRAPH
    {0xCBE3, 0x7B97}, //12817 #CJK UNIFIED IDEOGRAPH
    {0xCBE4, 0x867D}, //12818 #CJK UNIFIED IDEOGRAPH
    {0xCBE5, 0x968B}, //12819 #CJK UNIFIED IDEOGRAPH
    {0xCBE6, 0x968F}, //12820 #CJK UNIFIED IDEOGRAPH
    {0xCBE7, 0x7EE5}, //12821 #CJK UNIFIED IDEOGRAPH
    {0xCBE8, 0x9AD3}, //12822 #CJK UNIFIED IDEOGRAPH
    {0xCBE9, 0x788E}, //12823 #CJK UNIFIED IDEOGRAPH
    {0xCBEA, 0x5C81}, //12824 #CJK UNIFIED IDEOGRAPH
    {0xCBEB, 0x7A57}, //12825 #CJK UNIFIED IDEOGRAPH
    {0xCBEC, 0x9042}, //12826 #CJK UNIFIED IDEOGRAPH
    {0xCBED, 0x96A7}, //12827 #CJK UNIFIED IDEOGRAPH
    {0xCBEE, 0x795F}, //12828 #CJK UNIFIED IDEOGRAPH
    {0xCBEF, 0x5B59}, //12829 #CJK UNIFIED IDEOGRAPH
    {0xCBF0, 0x635F}, //12830 #CJK UNIFIED IDEOGRAPH
    {0xCBF1, 0x7B0B}, //12831 #CJK UNIFIED IDEOGRAPH
    {0xCBF2, 0x84D1}, //12832 #CJK UNIFIED IDEOGRAPH
    {0xCBF3, 0x68AD}, //12833 #CJK UNIFIED IDEOGRAPH
    {0xCBF4, 0x5506}, //12834 #CJK UNIFIED IDEOGRAPH
    {0xCBF5, 0x7F29}, //12835 #CJK UNIFIED IDEOGRAPH
    {0xCBF6, 0x7410}, //12836 #CJK UNIFIED IDEOGRAPH
    {0xCBF7, 0x7D22}, //12837 #CJK UNIFIED IDEOGRAPH
    {0xCBF8, 0x9501}, //12838 #CJK UNIFIED IDEOGRAPH
    {0xCBF9, 0x6240}, //12839 #CJK UNIFIED IDEOGRAPH
    {0xCBFA, 0x584C}, //12840 #CJK UNIFIED IDEOGRAPH
    {0xCBFB, 0x4ED6}, //12841 #CJK UNIFIED IDEOGRAPH
    {0xCBFC, 0x5B83}, //12842 #CJK UNIFIED IDEOGRAPH
    {0xCBFD, 0x5979}, //12843 #CJK UNIFIED IDEOGRAPH
    {0xCBFE, 0x5854}, //12844 #CJK UNIFIED IDEOGRAPH
    {0xCC40, 0x85F9}, //12845 #CJK UNIFIED IDEOGRAPH
    {0xCC41, 0x85FA}, //12846 #CJK UNIFIED IDEOGRAPH
    {0xCC42, 0x85FC}, //12847 #CJK UNIFIED IDEOGRAPH
    {0xCC43, 0x85FD}, //12848 #CJK UNIFIED IDEOGRAPH
    {0xCC44, 0x85FE}, //12849 #CJK UNIFIED IDEOGRAPH
    {0xCC45, 0x8600}, //12850 #CJK UNIFIED IDEOGRAPH
    {0xCC46, 0x8601}, //12851 #CJK UNIFIED IDEOGRAPH
    {0xCC47, 0x8602}, //12852 #CJK UNIFIED IDEOGRAPH
    {0xCC48, 0x8603}, //12853 #CJK UNIFIED IDEOGRAPH
    {0xCC49, 0x8604}, //12854 #CJK UNIFIED IDEOGRAPH
    {0xCC4A, 0x8606}, //12855 #CJK UNIFIED IDEOGRAPH
    {0xCC4B, 0x8607}, //12856 #CJK UNIFIED IDEOGRAPH
    {0xCC4C, 0x8608}, //12857 #CJK UNIFIED IDEOGRAPH
    {0xCC4D, 0x8609}, //12858 #CJK UNIFIED IDEOGRAPH
    {0xCC4E, 0x860A}, //12859 #CJK UNIFIED IDEOGRAPH
    {0xCC4F, 0x860B}, //12860 #CJK UNIFIED IDEOGRAPH
    {0xCC50, 0x860C}, //12861 #CJK UNIFIED IDEOGRAPH
    {0xCC51, 0x860D}, //12862 #CJK UNIFIED IDEOGRAPH
    {0xCC52, 0x860E}, //12863 #CJK UNIFIED IDEOGRAPH
    {0xCC53, 0x860F}, //12864 #CJK UNIFIED IDEOGRAPH
    {0xCC54, 0x8610}, //12865 #CJK UNIFIED IDEOGRAPH
    {0xCC55, 0x8612}, //12866 #CJK UNIFIED IDEOGRAPH
    {0xCC56, 0x8613}, //12867 #CJK UNIFIED IDEOGRAPH
    {0xCC57, 0x8614}, //12868 #CJK UNIFIED IDEOGRAPH
    {0xCC58, 0x8615}, //12869 #CJK UNIFIED IDEOGRAPH
    {0xCC59, 0x8617}, //12870 #CJK UNIFIED IDEOGRAPH
    {0xCC5A, 0x8618}, //12871 #CJK UNIFIED IDEOGRAPH
    {0xCC5B, 0x8619}, //12872 #CJK UNIFIED IDEOGRAPH
    {0xCC5C, 0x861A}, //12873 #CJK UNIFIED IDEOGRAPH
    {0xCC5D, 0x861B}, //12874 #CJK UNIFIED IDEOGRAPH
    {0xCC5E, 0x861C}, //12875 #CJK UNIFIED IDEOGRAPH
    {0xCC5F, 0x861D}, //12876 #CJK UNIFIED IDEOGRAPH
    {0xCC60, 0x861E}, //12877 #CJK UNIFIED IDEOGRAPH
    {0xCC61, 0x861F}, //12878 #CJK UNIFIED IDEOGRAPH
    {0xCC62, 0x8620}, //12879 #CJK UNIFIED IDEOGRAPH
    {0xCC63, 0x8621}, //12880 #CJK UNIFIED IDEOGRAPH
    {0xCC64, 0x8622}, //12881 #CJK UNIFIED IDEOGRAPH
    {0xCC65, 0x8623}, //12882 #CJK UNIFIED IDEOGRAPH
    {0xCC66, 0x8624}, //12883 #CJK UNIFIED IDEOGRAPH
    {0xCC67, 0x8625}, //12884 #CJK UNIFIED IDEOGRAPH
    {0xCC68, 0x8626}, //12885 #CJK UNIFIED IDEOGRAPH
    {0xCC69, 0x8628}, //12886 #CJK UNIFIED IDEOGRAPH
    {0xCC6A, 0x862A}, //12887 #CJK UNIFIED IDEOGRAPH
    {0xCC6B, 0x862B}, //12888 #CJK UNIFIED IDEOGRAPH
    {0xCC6C, 0x862C}, //12889 #CJK UNIFIED IDEOGRAPH
    {0xCC6D, 0x862D}, //12890 #CJK UNIFIED IDEOGRAPH
    {0xCC6E, 0x862E}, //12891 #CJK UNIFIED IDEOGRAPH
    {0xCC6F, 0x862F}, //12892 #CJK UNIFIED IDEOGRAPH
    {0xCC70, 0x8630}, //12893 #CJK UNIFIED IDEOGRAPH
    {0xCC71, 0x8631}, //12894 #CJK UNIFIED IDEOGRAPH
    {0xCC72, 0x8632}, //12895 #CJK UNIFIED IDEOGRAPH
    {0xCC73, 0x8633}, //12896 #CJK UNIFIED IDEOGRAPH
    {0xCC74, 0x8634}, //12897 #CJK UNIFIED IDEOGRAPH
    {0xCC75, 0x8635}, //12898 #CJK UNIFIED IDEOGRAPH
    {0xCC76, 0x8636}, //12899 #CJK UNIFIED IDEOGRAPH
    {0xCC77, 0x8637}, //12900 #CJK UNIFIED IDEOGRAPH
    {0xCC78, 0x8639}, //12901 #CJK UNIFIED IDEOGRAPH
    {0xCC79, 0x863A}, //12902 #CJK UNIFIED IDEOGRAPH
    {0xCC7A, 0x863B}, //12903 #CJK UNIFIED IDEOGRAPH
    {0xCC7B, 0x863D}, //12904 #CJK UNIFIED IDEOGRAPH
    {0xCC7C, 0x863E}, //12905 #CJK UNIFIED IDEOGRAPH
    {0xCC7D, 0x863F}, //12906 #CJK UNIFIED IDEOGRAPH
    {0xCC7E, 0x8640}, //12907 #CJK UNIFIED IDEOGRAPH
    {0xCC80, 0x8641}, //12908 #CJK UNIFIED IDEOGRAPH
    {0xCC81, 0x8642}, //12909 #CJK UNIFIED IDEOGRAPH
    {0xCC82, 0x8643}, //12910 #CJK UNIFIED IDEOGRAPH
    {0xCC83, 0x8644}, //12911 #CJK UNIFIED IDEOGRAPH
    {0xCC84, 0x8645}, //12912 #CJK UNIFIED IDEOGRAPH
    {0xCC85, 0x8646}, //12913 #CJK UNIFIED IDEOGRAPH
    {0xCC86, 0x8647}, //12914 #CJK UNIFIED IDEOGRAPH
    {0xCC87, 0x8648}, //12915 #CJK UNIFIED IDEOGRAPH
    {0xCC88, 0x8649}, //12916 #CJK UNIFIED IDEOGRAPH
    {0xCC89, 0x864A}, //12917 #CJK UNIFIED IDEOGRAPH
    {0xCC8A, 0x864B}, //12918 #CJK UNIFIED IDEOGRAPH
    {0xCC8B, 0x864C}, //12919 #CJK UNIFIED IDEOGRAPH
    {0xCC8C, 0x8652}, //12920 #CJK UNIFIED IDEOGRAPH
    {0xCC8D, 0x8653}, //12921 #CJK UNIFIED IDEOGRAPH
    {0xCC8E, 0x8655}, //12922 #CJK UNIFIED IDEOGRAPH
    {0xCC8F, 0x8656}, //12923 #CJK UNIFIED IDEOGRAPH
    {0xCC90, 0x8657}, //12924 #CJK UNIFIED IDEOGRAPH
    {0xCC91, 0x8658}, //12925 #CJK UNIFIED IDEOGRAPH
    {0xCC92, 0x8659}, //12926 #CJK UNIFIED IDEOGRAPH
    {0xCC93, 0x865B}, //12927 #CJK UNIFIED IDEOGRAPH
    {0xCC94, 0x865C}, //12928 #CJK UNIFIED IDEOGRAPH
    {0xCC95, 0x865D}, //12929 #CJK UNIFIED IDEOGRAPH
    {0xCC96, 0x865F}, //12930 #CJK UNIFIED IDEOGRAPH
    {0xCC97, 0x8660}, //12931 #CJK UNIFIED IDEOGRAPH
    {0xCC98, 0x8661}, //12932 #CJK UNIFIED IDEOGRAPH
    {0xCC99, 0x8663}, //12933 #CJK UNIFIED IDEOGRAPH
    {0xCC9A, 0x8664}, //12934 #CJK UNIFIED IDEOGRAPH
    {0xCC9B, 0x8665}, //12935 #CJK UNIFIED IDEOGRAPH
    {0xCC9C, 0x8666}, //12936 #CJK UNIFIED IDEOGRAPH
    {0xCC9D, 0x8667}, //12937 #CJK UNIFIED IDEOGRAPH
    {0xCC9E, 0x8668}, //12938 #CJK UNIFIED IDEOGRAPH
    {0xCC9F, 0x8669}, //12939 #CJK UNIFIED IDEOGRAPH
    {0xCCA0, 0x866A}, //12940 #CJK UNIFIED IDEOGRAPH
    {0xCCA1, 0x736D}, //12941 #CJK UNIFIED IDEOGRAPH
    {0xCCA2, 0x631E}, //12942 #CJK UNIFIED IDEOGRAPH
    {0xCCA3, 0x8E4B}, //12943 #CJK UNIFIED IDEOGRAPH
    {0xCCA4, 0x8E0F}, //12944 #CJK UNIFIED IDEOGRAPH
    {0xCCA5, 0x80CE}, //12945 #CJK UNIFIED IDEOGRAPH
    {0xCCA6, 0x82D4}, //12946 #CJK UNIFIED IDEOGRAPH
    {0xCCA7, 0x62AC}, //12947 #CJK UNIFIED IDEOGRAPH
    {0xCCA8, 0x53F0}, //12948 #CJK UNIFIED IDEOGRAPH
    {0xCCA9, 0x6CF0}, //12949 #CJK UNIFIED IDEOGRAPH
    {0xCCAA, 0x915E}, //12950 #CJK UNIFIED IDEOGRAPH
    {0xCCAB, 0x592A}, //12951 #CJK UNIFIED IDEOGRAPH
    {0xCCAC, 0x6001}, //12952 #CJK UNIFIED IDEOGRAPH
    {0xCCAD, 0x6C70}, //12953 #CJK UNIFIED IDEOGRAPH
    {0xCCAE, 0x574D}, //12954 #CJK UNIFIED IDEOGRAPH
    {0xCCAF, 0x644A}, //12955 #CJK UNIFIED IDEOGRAPH
    {0xCCB0, 0x8D2A}, //12956 #CJK UNIFIED IDEOGRAPH
    {0xCCB1, 0x762B}, //12957 #CJK UNIFIED IDEOGRAPH
    {0xCCB2, 0x6EE9}, //12958 #CJK UNIFIED IDEOGRAPH
    {0xCCB3, 0x575B}, //12959 #CJK UNIFIED IDEOGRAPH
    {0xCCB4, 0x6A80}, //12960 #CJK UNIFIED IDEOGRAPH
    {0xCCB5, 0x75F0}, //12961 #CJK UNIFIED IDEOGRAPH
    {0xCCB6, 0x6F6D}, //12962 #CJK UNIFIED IDEOGRAPH
    {0xCCB7, 0x8C2D}, //12963 #CJK UNIFIED IDEOGRAPH
    {0xCCB8, 0x8C08}, //12964 #CJK UNIFIED IDEOGRAPH
    {0xCCB9, 0x5766}, //12965 #CJK UNIFIED IDEOGRAPH
    {0xCCBA, 0x6BEF}, //12966 #CJK UNIFIED IDEOGRAPH
    {0xCCBB, 0x8892}, //12967 #CJK UNIFIED IDEOGRAPH
    {0xCCBC, 0x78B3}, //12968 #CJK UNIFIED IDEOGRAPH
    {0xCCBD, 0x63A2}, //12969 #CJK UNIFIED IDEOGRAPH
    {0xCCBE, 0x53F9}, //12970 #CJK UNIFIED IDEOGRAPH
    {0xCCBF, 0x70AD}, //12971 #CJK UNIFIED IDEOGRAPH
    {0xCCC0, 0x6C64}, //12972 #CJK UNIFIED IDEOGRAPH
    {0xCCC1, 0x5858}, //12973 #CJK UNIFIED IDEOGRAPH
    {0xCCC2, 0x642A}, //12974 #CJK UNIFIED IDEOGRAPH
    {0xCCC3, 0x5802}, //12975 #CJK UNIFIED IDEOGRAPH
    {0xCCC4, 0x68E0}, //12976 #CJK UNIFIED IDEOGRAPH
    {0xCCC5, 0x819B}, //12977 #CJK UNIFIED IDEOGRAPH
    {0xCCC6, 0x5510}, //12978 #CJK UNIFIED IDEOGRAPH
    {0xCCC7, 0x7CD6}, //12979 #CJK UNIFIED IDEOGRAPH
    {0xCCC8, 0x5018}, //12980 #CJK UNIFIED IDEOGRAPH
    {0xCCC9, 0x8EBA}, //12981 #CJK UNIFIED IDEOGRAPH
    {0xCCCA, 0x6DCC}, //12982 #CJK UNIFIED IDEOGRAPH
    {0xCCCB, 0x8D9F}, //12983 #CJK UNIFIED IDEOGRAPH
    {0xCCCC, 0x70EB}, //12984 #CJK UNIFIED IDEOGRAPH
    {0xCCCD, 0x638F}, //12985 #CJK UNIFIED IDEOGRAPH
    {0xCCCE, 0x6D9B}, //12986 #CJK UNIFIED IDEOGRAPH
    {0xCCCF, 0x6ED4}, //12987 #CJK UNIFIED IDEOGRAPH
    {0xCCD0, 0x7EE6}, //12988 #CJK UNIFIED IDEOGRAPH
    {0xCCD1, 0x8404}, //12989 #CJK UNIFIED IDEOGRAPH
    {0xCCD2, 0x6843}, //12990 #CJK UNIFIED IDEOGRAPH
    {0xCCD3, 0x9003}, //12991 #CJK UNIFIED IDEOGRAPH
    {0xCCD4, 0x6DD8}, //12992 #CJK UNIFIED IDEOGRAPH
    {0xCCD5, 0x9676}, //12993 #CJK UNIFIED IDEOGRAPH
    {0xCCD6, 0x8BA8}, //12994 #CJK UNIFIED IDEOGRAPH
    {0xCCD7, 0x5957}, //12995 #CJK UNIFIED IDEOGRAPH
    {0xCCD8, 0x7279}, //12996 #CJK UNIFIED IDEOGRAPH
    {0xCCD9, 0x85E4}, //12997 #CJK UNIFIED IDEOGRAPH
    {0xCCDA, 0x817E}, //12998 #CJK UNIFIED IDEOGRAPH
    {0xCCDB, 0x75BC}, //12999 #CJK UNIFIED IDEOGRAPH
    {0xCCDC, 0x8A8A}, //13000 #CJK UNIFIED IDEOGRAPH
    {0xCCDD, 0x68AF}, //13001 #CJK UNIFIED IDEOGRAPH
    {0xCCDE, 0x5254}, //13002 #CJK UNIFIED IDEOGRAPH
    {0xCCDF, 0x8E22}, //13003 #CJK UNIFIED IDEOGRAPH
    {0xCCE0, 0x9511}, //13004 #CJK UNIFIED IDEOGRAPH
    {0xCCE1, 0x63D0}, //13005 #CJK UNIFIED IDEOGRAPH
    {0xCCE2, 0x9898}, //13006 #CJK UNIFIED IDEOGRAPH
    {0xCCE3, 0x8E44}, //13007 #CJK UNIFIED IDEOGRAPH
    {0xCCE4, 0x557C}, //13008 #CJK UNIFIED IDEOGRAPH
    {0xCCE5, 0x4F53}, //13009 #CJK UNIFIED IDEOGRAPH
    {0xCCE6, 0x66FF}, //13010 #CJK UNIFIED IDEOGRAPH
    {0xCCE7, 0x568F}, //13011 #CJK UNIFIED IDEOGRAPH
    {0xCCE8, 0x60D5}, //13012 #CJK UNIFIED IDEOGRAPH
    {0xCCE9, 0x6D95}, //13013 #CJK UNIFIED IDEOGRAPH
    {0xCCEA, 0x5243}, //13014 #CJK UNIFIED IDEOGRAPH
    {0xCCEB, 0x5C49}, //13015 #CJK UNIFIED IDEOGRAPH
    {0xCCEC, 0x5929}, //13016 #CJK UNIFIED IDEOGRAPH
    {0xCCED, 0x6DFB}, //13017 #CJK UNIFIED IDEOGRAPH
    {0xCCEE, 0x586B}, //13018 #CJK UNIFIED IDEOGRAPH
    {0xCCEF, 0x7530}, //13019 #CJK UNIFIED IDEOGRAPH
    {0xCCF0, 0x751C}, //13020 #CJK UNIFIED IDEOGRAPH
    {0xCCF1, 0x606C}, //13021 #CJK UNIFIED IDEOGRAPH
    {0xCCF2, 0x8214}, //13022 #CJK UNIFIED IDEOGRAPH
    {0xCCF3, 0x8146}, //13023 #CJK UNIFIED IDEOGRAPH
    {0xCCF4, 0x6311}, //13024 #CJK UNIFIED IDEOGRAPH
    {0xCCF5, 0x6761}, //13025 #CJK UNIFIED IDEOGRAPH
    {0xCCF6, 0x8FE2}, //13026 #CJK UNIFIED IDEOGRAPH
    {0xCCF7, 0x773A}, //13027 #CJK UNIFIED IDEOGRAPH
    {0xCCF8, 0x8DF3}, //13028 #CJK UNIFIED IDEOGRAPH
    {0xCCF9, 0x8D34}, //13029 #CJK UNIFIED IDEOGRAPH
    {0xCCFA, 0x94C1}, //13030 #CJK UNIFIED IDEOGRAPH
    {0xCCFB, 0x5E16}, //13031 #CJK UNIFIED IDEOGRAPH
    {0xCCFC, 0x5385}, //13032 #CJK UNIFIED IDEOGRAPH
    {0xCCFD, 0x542C}, //13033 #CJK UNIFIED IDEOGRAPH
    {0xCCFE, 0x70C3}, //13034 #CJK UNIFIED IDEOGRAPH
    {0xCD40, 0x866D}, //13035 #CJK UNIFIED IDEOGRAPH
    {0xCD41, 0x866F}, //13036 #CJK UNIFIED IDEOGRAPH
    {0xCD42, 0x8670}, //13037 #CJK UNIFIED IDEOGRAPH
    {0xCD43, 0x8672}, //13038 #CJK UNIFIED IDEOGRAPH
    {0xCD44, 0x8673}, //13039 #CJK UNIFIED IDEOGRAPH
    {0xCD45, 0x8674}, //13040 #CJK UNIFIED IDEOGRAPH
    {0xCD46, 0x8675}, //13041 #CJK UNIFIED IDEOGRAPH
    {0xCD47, 0x8676}, //13042 #CJK UNIFIED IDEOGRAPH
    {0xCD48, 0x8677}, //13043 #CJK UNIFIED IDEOGRAPH
    {0xCD49, 0x8678}, //13044 #CJK UNIFIED IDEOGRAPH
    {0xCD4A, 0x8683}, //13045 #CJK UNIFIED IDEOGRAPH
    {0xCD4B, 0x8684}, //13046 #CJK UNIFIED IDEOGRAPH
    {0xCD4C, 0x8685}, //13047 #CJK UNIFIED IDEOGRAPH
    {0xCD4D, 0x8686}, //13048 #CJK UNIFIED IDEOGRAPH
    {0xCD4E, 0x8687}, //13049 #CJK UNIFIED IDEOGRAPH
    {0xCD4F, 0x8688}, //13050 #CJK UNIFIED IDEOGRAPH
    {0xCD50, 0x8689}, //13051 #CJK UNIFIED IDEOGRAPH
    {0xCD51, 0x868E}, //13052 #CJK UNIFIED IDEOGRAPH
    {0xCD52, 0x868F}, //13053 #CJK UNIFIED IDEOGRAPH
    {0xCD53, 0x8690}, //13054 #CJK UNIFIED IDEOGRAPH
    {0xCD54, 0x8691}, //13055 #CJK UNIFIED IDEOGRAPH
    {0xCD55, 0x8692}, //13056 #CJK UNIFIED IDEOGRAPH
    {0xCD56, 0x8694}, //13057 #CJK UNIFIED IDEOGRAPH
    {0xCD57, 0x8696}, //13058 #CJK UNIFIED IDEOGRAPH
    {0xCD58, 0x8697}, //13059 #CJK UNIFIED IDEOGRAPH
    {0xCD59, 0x8698}, //13060 #CJK UNIFIED IDEOGRAPH
    {0xCD5A, 0x8699}, //13061 #CJK UNIFIED IDEOGRAPH
    {0xCD5B, 0x869A}, //13062 #CJK UNIFIED IDEOGRAPH
    {0xCD5C, 0x869B}, //13063 #CJK UNIFIED IDEOGRAPH
    {0xCD5D, 0x869E}, //13064 #CJK UNIFIED IDEOGRAPH
    {0xCD5E, 0x869F}, //13065 #CJK UNIFIED IDEOGRAPH
    {0xCD5F, 0x86A0}, //13066 #CJK UNIFIED IDEOGRAPH
    {0xCD60, 0x86A1}, //13067 #CJK UNIFIED IDEOGRAPH
    {0xCD61, 0x86A2}, //13068 #CJK UNIFIED IDEOGRAPH
    {0xCD62, 0x86A5}, //13069 #CJK UNIFIED IDEOGRAPH
    {0xCD63, 0x86A6}, //13070 #CJK UNIFIED IDEOGRAPH
    {0xCD64, 0x86AB}, //13071 #CJK UNIFIED IDEOGRAPH
    {0xCD65, 0x86AD}, //13072 #CJK UNIFIED IDEOGRAPH
    {0xCD66, 0x86AE}, //13073 #CJK UNIFIED IDEOGRAPH
    {0xCD67, 0x86B2}, //13074 #CJK UNIFIED IDEOGRAPH
    {0xCD68, 0x86B3}, //13075 #CJK UNIFIED IDEOGRAPH
    {0xCD69, 0x86B7}, //13076 #CJK UNIFIED IDEOGRAPH
    {0xCD6A, 0x86B8}, //13077 #CJK UNIFIED IDEOGRAPH
    {0xCD6B, 0x86B9}, //13078 #CJK UNIFIED IDEOGRAPH
    {0xCD6C, 0x86BB}, //13079 #CJK UNIFIED IDEOGRAPH
    {0xCD6D, 0x86BC}, //13080 #CJK UNIFIED IDEOGRAPH
    {0xCD6E, 0x86BD}, //13081 #CJK UNIFIED IDEOGRAPH
    {0xCD6F, 0x86BE}, //13082 #CJK UNIFIED IDEOGRAPH
    {0xCD70, 0x86BF}, //13083 #CJK UNIFIED IDEOGRAPH
    {0xCD71, 0x86C1}, //13084 #CJK UNIFIED IDEOGRAPH
    {0xCD72, 0x86C2}, //13085 #CJK UNIFIED IDEOGRAPH
    {0xCD73, 0x86C3}, //13086 #CJK UNIFIED IDEOGRAPH
    {0xCD74, 0x86C5}, //13087 #CJK UNIFIED IDEOGRAPH
    {0xCD75, 0x86C8}, //13088 #CJK UNIFIED IDEOGRAPH
    {0xCD76, 0x86CC}, //13089 #CJK UNIFIED IDEOGRAPH
    {0xCD77, 0x86CD}, //13090 #CJK UNIFIED IDEOGRAPH
    {0xCD78, 0x86D2}, //13091 #CJK UNIFIED IDEOGRAPH
    {0xCD79, 0x86D3}, //13092 #CJK UNIFIED IDEOGRAPH
    {0xCD7A, 0x86D5}, //13093 #CJK UNIFIED IDEOGRAPH
    {0xCD7B, 0x86D6}, //13094 #CJK UNIFIED IDEOGRAPH
    {0xCD7C, 0x86D7}, //13095 #CJK UNIFIED IDEOGRAPH
    {0xCD7D, 0x86DA}, //13096 #CJK UNIFIED IDEOGRAPH
    {0xCD7E, 0x86DC}, //13097 #CJK UNIFIED IDEOGRAPH
    {0xCD80, 0x86DD}, //13098 #CJK UNIFIED IDEOGRAPH
    {0xCD81, 0x86E0}, //13099 #CJK UNIFIED IDEOGRAPH
    {0xCD82, 0x86E1}, //13100 #CJK UNIFIED IDEOGRAPH
    {0xCD83, 0x86E2}, //13101 #CJK UNIFIED IDEOGRAPH
    {0xCD84, 0x86E3}, //13102 #CJK UNIFIED IDEOGRAPH
    {0xCD85, 0x86E5}, //13103 #CJK UNIFIED IDEOGRAPH
    {0xCD86, 0x86E6}, //13104 #CJK UNIFIED IDEOGRAPH
    {0xCD87, 0x86E7}, //13105 #CJK UNIFIED IDEOGRAPH
    {0xCD88, 0x86E8}, //13106 #CJK UNIFIED IDEOGRAPH
    {0xCD89, 0x86EA}, //13107 #CJK UNIFIED IDEOGRAPH
    {0xCD8A, 0x86EB}, //13108 #CJK UNIFIED IDEOGRAPH
    {0xCD8B, 0x86EC}, //13109 #CJK UNIFIED IDEOGRAPH
    {0xCD8C, 0x86EF}, //13110 #CJK UNIFIED IDEOGRAPH
    {0xCD8D, 0x86F5}, //13111 #CJK UNIFIED IDEOGRAPH
    {0xCD8E, 0x86F6}, //13112 #CJK UNIFIED IDEOGRAPH
    {0xCD8F, 0x86F7}, //13113 #CJK UNIFIED IDEOGRAPH
    {0xCD90, 0x86FA}, //13114 #CJK UNIFIED IDEOGRAPH
    {0xCD91, 0x86FB}, //13115 #CJK UNIFIED IDEOGRAPH
    {0xCD92, 0x86FC}, //13116 #CJK UNIFIED IDEOGRAPH
    {0xCD93, 0x86FD}, //13117 #CJK UNIFIED IDEOGRAPH
    {0xCD94, 0x86FF}, //13118 #CJK UNIFIED IDEOGRAPH
    {0xCD95, 0x8701}, //13119 #CJK UNIFIED IDEOGRAPH
    {0xCD96, 0x8704}, //13120 #CJK UNIFIED IDEOGRAPH
    {0xCD97, 0x8705}, //13121 #CJK UNIFIED IDEOGRAPH
    {0xCD98, 0x8706}, //13122 #CJK UNIFIED IDEOGRAPH
    {0xCD99, 0x870B}, //13123 #CJK UNIFIED IDEOGRAPH
    {0xCD9A, 0x870C}, //13124 #CJK UNIFIED IDEOGRAPH
    {0xCD9B, 0x870E}, //13125 #CJK UNIFIED IDEOGRAPH
    {0xCD9C, 0x870F}, //13126 #CJK UNIFIED IDEOGRAPH
    {0xCD9D, 0x8710}, //13127 #CJK UNIFIED IDEOGRAPH
    {0xCD9E, 0x8711}, //13128 #CJK UNIFIED IDEOGRAPH
    {0xCD9F, 0x8714}, //13129 #CJK UNIFIED IDEOGRAPH
    {0xCDA0, 0x8716}, //13130 #CJK UNIFIED IDEOGRAPH
    {0xCDA1, 0x6C40}, //13131 #CJK UNIFIED IDEOGRAPH
    {0xCDA2, 0x5EF7}, //13132 #CJK UNIFIED IDEOGRAPH
    {0xCDA3, 0x505C}, //13133 #CJK UNIFIED IDEOGRAPH
    {0xCDA4, 0x4EAD}, //13134 #CJK UNIFIED IDEOGRAPH
    {0xCDA5, 0x5EAD}, //13135 #CJK UNIFIED IDEOGRAPH
    {0xCDA6, 0x633A}, //13136 #CJK UNIFIED IDEOGRAPH
    {0xCDA7, 0x8247}, //13137 #CJK UNIFIED IDEOGRAPH
    {0xCDA8, 0x901A}, //13138 #CJK UNIFIED IDEOGRAPH
    {0xCDA9, 0x6850}, //13139 #CJK UNIFIED IDEOGRAPH
    {0xCDAA, 0x916E}, //13140 #CJK UNIFIED IDEOGRAPH
    {0xCDAB, 0x77B3}, //13141 #CJK UNIFIED IDEOGRAPH
    {0xCDAC, 0x540C}, //13142 #CJK UNIFIED IDEOGRAPH
    {0xCDAD, 0x94DC}, //13143 #CJK UNIFIED IDEOGRAPH
    {0xCDAE, 0x5F64}, //13144 #CJK UNIFIED IDEOGRAPH
    {0xCDAF, 0x7AE5}, //13145 #CJK UNIFIED IDEOGRAPH
    {0xCDB0, 0x6876}, //13146 #CJK UNIFIED IDEOGRAPH
    {0xCDB1, 0x6345}, //13147 #CJK UNIFIED IDEOGRAPH
    {0xCDB2, 0x7B52}, //13148 #CJK UNIFIED IDEOGRAPH
    {0xCDB3, 0x7EDF}, //13149 #CJK UNIFIED IDEOGRAPH
    {0xCDB4, 0x75DB}, //13150 #CJK UNIFIED IDEOGRAPH
    {0xCDB5, 0x5077}, //13151 #CJK UNIFIED IDEOGRAPH
    {0xCDB6, 0x6295}, //13152 #CJK UNIFIED IDEOGRAPH
    {0xCDB7, 0x5934}, //13153 #CJK UNIFIED IDEOGRAPH
    {0xCDB8, 0x900F}, //13154 #CJK UNIFIED IDEOGRAPH
    {0xCDB9, 0x51F8}, //13155 #CJK UNIFIED IDEOGRAPH
    {0xCDBA, 0x79C3}, //13156 #CJK UNIFIED IDEOGRAPH
    {0xCDBB, 0x7A81}, //13157 #CJK UNIFIED IDEOGRAPH
    {0xCDBC, 0x56FE}, //13158 #CJK UNIFIED IDEOGRAPH
    {0xCDBD, 0x5F92}, //13159 #CJK UNIFIED IDEOGRAPH
    {0xCDBE, 0x9014}, //13160 #CJK UNIFIED IDEOGRAPH
    {0xCDBF, 0x6D82}, //13161 #CJK UNIFIED IDEOGRAPH
    {0xCDC0, 0x5C60}, //13162 #CJK UNIFIED IDEOGRAPH
    {0xCDC1, 0x571F}, //13163 #CJK UNIFIED IDEOGRAPH
    {0xCDC2, 0x5410}, //13164 #CJK UNIFIED IDEOGRAPH
    {0xCDC3, 0x5154}, //13165 #CJK UNIFIED IDEOGRAPH
    {0xCDC4, 0x6E4D}, //13166 #CJK UNIFIED IDEOGRAPH
    {0xCDC5, 0x56E2}, //13167 #CJK UNIFIED IDEOGRAPH
    {0xCDC6, 0x63A8}, //13168 #CJK UNIFIED IDEOGRAPH
    {0xCDC7, 0x9893}, //13169 #CJK UNIFIED IDEOGRAPH
    {0xCDC8, 0x817F}, //13170 #CJK UNIFIED IDEOGRAPH
    {0xCDC9, 0x8715}, //13171 #CJK UNIFIED IDEOGRAPH
    {0xCDCA, 0x892A}, //13172 #CJK UNIFIED IDEOGRAPH
    {0xCDCB, 0x9000}, //13173 #CJK UNIFIED IDEOGRAPH
    {0xCDCC, 0x541E}, //13174 #CJK UNIFIED IDEOGRAPH
    {0xCDCD, 0x5C6F}, //13175 #CJK UNIFIED IDEOGRAPH
    {0xCDCE, 0x81C0}, //13176 #CJK UNIFIED IDEOGRAPH
    {0xCDCF, 0x62D6}, //13177 #CJK UNIFIED IDEOGRAPH
    {0xCDD0, 0x6258}, //13178 #CJK UNIFIED IDEOGRAPH
    {0xCDD1, 0x8131}, //13179 #CJK UNIFIED IDEOGRAPH
    {0xCDD2, 0x9E35}, //13180 #CJK UNIFIED IDEOGRAPH
    {0xCDD3, 0x9640}, //13181 #CJK UNIFIED IDEOGRAPH
    {0xCDD4, 0x9A6E}, //13182 #CJK UNIFIED IDEOGRAPH
    {0xCDD5, 0x9A7C}, //13183 #CJK UNIFIED IDEOGRAPH
    {0xCDD6, 0x692D}, //13184 #CJK UNIFIED IDEOGRAPH
    {0xCDD7, 0x59A5}, //13185 #CJK UNIFIED IDEOGRAPH
    {0xCDD8, 0x62D3}, //13186 #CJK UNIFIED IDEOGRAPH
    {0xCDD9, 0x553E}, //13187 #CJK UNIFIED IDEOGRAPH
    {0xCDDA, 0x6316}, //13188 #CJK UNIFIED IDEOGRAPH
    {0xCDDB, 0x54C7}, //13189 #CJK UNIFIED IDEOGRAPH
    {0xCDDC, 0x86D9}, //13190 #CJK UNIFIED IDEOGRAPH
    {0xCDDD, 0x6D3C}, //13191 #CJK UNIFIED IDEOGRAPH
    {0xCDDE, 0x5A03}, //13192 #CJK UNIFIED IDEOGRAPH
    {0xCDDF, 0x74E6}, //13193 #CJK UNIFIED IDEOGRAPH
    {0xCDE0, 0x889C}, //13194 #CJK UNIFIED IDEOGRAPH
    {0xCDE1, 0x6B6A}, //13195 #CJK UNIFIED IDEOGRAPH
    {0xCDE2, 0x5916}, //13196 #CJK UNIFIED IDEOGRAPH
    {0xCDE3, 0x8C4C}, //13197 #CJK UNIFIED IDEOGRAPH
    {0xCDE4, 0x5F2F}, //13198 #CJK UNIFIED IDEOGRAPH
    {0xCDE5, 0x6E7E}, //13199 #CJK UNIFIED IDEOGRAPH
    {0xCDE6, 0x73A9}, //13200 #CJK UNIFIED IDEOGRAPH
    {0xCDE7, 0x987D}, //13201 #CJK UNIFIED IDEOGRAPH
    {0xCDE8, 0x4E38}, //13202 #CJK UNIFIED IDEOGRAPH
    {0xCDE9, 0x70F7}, //13203 #CJK UNIFIED IDEOGRAPH
    {0xCDEA, 0x5B8C}, //13204 #CJK UNIFIED IDEOGRAPH
    {0xCDEB, 0x7897}, //13205 #CJK UNIFIED IDEOGRAPH
    {0xCDEC, 0x633D}, //13206 #CJK UNIFIED IDEOGRAPH
    {0xCDED, 0x665A}, //13207 #CJK UNIFIED IDEOGRAPH
    {0xCDEE, 0x7696}, //13208 #CJK UNIFIED IDEOGRAPH
    {0xCDEF, 0x60CB}, //13209 #CJK UNIFIED IDEOGRAPH
    {0xCDF0, 0x5B9B}, //13210 #CJK UNIFIED IDEOGRAPH
    {0xCDF1, 0x5A49}, //13211 #CJK UNIFIED IDEOGRAPH
    {0xCDF2, 0x4E07}, //13212 #CJK UNIFIED IDEOGRAPH
    {0xCDF3, 0x8155}, //13213 #CJK UNIFIED IDEOGRAPH
    {0xCDF4, 0x6C6A}, //13214 #CJK UNIFIED IDEOGRAPH
    {0xCDF5, 0x738B}, //13215 #CJK UNIFIED IDEOGRAPH
    {0xCDF6, 0x4EA1}, //13216 #CJK UNIFIED IDEOGRAPH
    {0xCDF7, 0x6789}, //13217 #CJK UNIFIED IDEOGRAPH
    {0xCDF8, 0x7F51}, //13218 #CJK UNIFIED IDEOGRAPH
    {0xCDF9, 0x5F80}, //13219 #CJK UNIFIED IDEOGRAPH
    {0xCDFA, 0x65FA}, //13220 #CJK UNIFIED IDEOGRAPH
    {0xCDFB, 0x671B}, //13221 #CJK UNIFIED IDEOGRAPH
    {0xCDFC, 0x5FD8}, //13222 #CJK UNIFIED IDEOGRAPH
    {0xCDFD, 0x5984}, //13223 #CJK UNIFIED IDEOGRAPH
    {0xCDFE, 0x5A01}, //13224 #CJK UNIFIED IDEOGRAPH
    {0xCE40, 0x8719}, //13225 #CJK UNIFIED IDEOGRAPH
    {0xCE41, 0x871B}, //13226 #CJK UNIFIED IDEOGRAPH
    {0xCE42, 0x871D}, //13227 #CJK UNIFIED IDEOGRAPH
    {0xCE43, 0x871F}, //13228 #CJK UNIFIED IDEOGRAPH
    {0xCE44, 0x8720}, //13229 #CJK UNIFIED IDEOGRAPH
    {0xCE45, 0x8724}, //13230 #CJK UNIFIED IDEOGRAPH
    {0xCE46, 0x8726}, //13231 #CJK UNIFIED IDEOGRAPH
    {0xCE47, 0x8727}, //13232 #CJK UNIFIED IDEOGRAPH
    {0xCE48, 0x8728}, //13233 #CJK UNIFIED IDEOGRAPH
    {0xCE49, 0x872A}, //13234 #CJK UNIFIED IDEOGRAPH
    {0xCE4A, 0x872B}, //13235 #CJK UNIFIED IDEOGRAPH
    {0xCE4B, 0x872C}, //13236 #CJK UNIFIED IDEOGRAPH
    {0xCE4C, 0x872D}, //13237 #CJK UNIFIED IDEOGRAPH
    {0xCE4D, 0x872F}, //13238 #CJK UNIFIED IDEOGRAPH
    {0xCE4E, 0x8730}, //13239 #CJK UNIFIED IDEOGRAPH
    {0xCE4F, 0x8732}, //13240 #CJK UNIFIED IDEOGRAPH
    {0xCE50, 0x8733}, //13241 #CJK UNIFIED IDEOGRAPH
    {0xCE51, 0x8735}, //13242 #CJK UNIFIED IDEOGRAPH
    {0xCE52, 0x8736}, //13243 #CJK UNIFIED IDEOGRAPH
    {0xCE53, 0x8738}, //13244 #CJK UNIFIED IDEOGRAPH
    {0xCE54, 0x8739}, //13245 #CJK UNIFIED IDEOGRAPH
    {0xCE55, 0x873A}, //13246 #CJK UNIFIED IDEOGRAPH
    {0xCE56, 0x873C}, //13247 #CJK UNIFIED IDEOGRAPH
    {0xCE57, 0x873D}, //13248 #CJK UNIFIED IDEOGRAPH
    {0xCE58, 0x8740}, //13249 #CJK UNIFIED IDEOGRAPH
    {0xCE59, 0x8741}, //13250 #CJK UNIFIED IDEOGRAPH
    {0xCE5A, 0x8742}, //13251 #CJK UNIFIED IDEOGRAPH
    {0xCE5B, 0x8743}, //13252 #CJK UNIFIED IDEOGRAPH
    {0xCE5C, 0x8744}, //13253 #CJK UNIFIED IDEOGRAPH
    {0xCE5D, 0x8745}, //13254 #CJK UNIFIED IDEOGRAPH
    {0xCE5E, 0x8746}, //13255 #CJK UNIFIED IDEOGRAPH
    {0xCE5F, 0x874A}, //13256 #CJK UNIFIED IDEOGRAPH
    {0xCE60, 0x874B}, //13257 #CJK UNIFIED IDEOGRAPH
    {0xCE61, 0x874D}, //13258 #CJK UNIFIED IDEOGRAPH
    {0xCE62, 0x874F}, //13259 #CJK UNIFIED IDEOGRAPH
    {0xCE63, 0x8750}, //13260 #CJK UNIFIED IDEOGRAPH
    {0xCE64, 0x8751}, //13261 #CJK UNIFIED IDEOGRAPH
    {0xCE65, 0x8752}, //13262 #CJK UNIFIED IDEOGRAPH
    {0xCE66, 0x8754}, //13263 #CJK UNIFIED IDEOGRAPH
    {0xCE67, 0x8755}, //13264 #CJK UNIFIED IDEOGRAPH
    {0xCE68, 0x8756}, //13265 #CJK UNIFIED IDEOGRAPH
    {0xCE69, 0x8758}, //13266 #CJK UNIFIED IDEOGRAPH
    {0xCE6A, 0x875A}, //13267 #CJK UNIFIED IDEOGRAPH
    {0xCE6B, 0x875B}, //13268 #CJK UNIFIED IDEOGRAPH
    {0xCE6C, 0x875C}, //13269 #CJK UNIFIED IDEOGRAPH
    {0xCE6D, 0x875D}, //13270 #CJK UNIFIED IDEOGRAPH
    {0xCE6E, 0x875E}, //13271 #CJK UNIFIED IDEOGRAPH
    {0xCE6F, 0x875F}, //13272 #CJK UNIFIED IDEOGRAPH
    {0xCE70, 0x8761}, //13273 #CJK UNIFIED IDEOGRAPH
    {0xCE71, 0x8762}, //13274 #CJK UNIFIED IDEOGRAPH
    {0xCE72, 0x8766}, //13275 #CJK UNIFIED IDEOGRAPH
    {0xCE73, 0x8767}, //13276 #CJK UNIFIED IDEOGRAPH
    {0xCE74, 0x8768}, //13277 #CJK UNIFIED IDEOGRAPH
    {0xCE75, 0x8769}, //13278 #CJK UNIFIED IDEOGRAPH
    {0xCE76, 0x876A}, //13279 #CJK UNIFIED IDEOGRAPH
    {0xCE77, 0x876B}, //13280 #CJK UNIFIED IDEOGRAPH
    {0xCE78, 0x876C}, //13281 #CJK UNIFIED IDEOGRAPH
    {0xCE79, 0x876D}, //13282 #CJK UNIFIED IDEOGRAPH
    {0xCE7A, 0x876F}, //13283 #CJK UNIFIED IDEOGRAPH
    {0xCE7B, 0x8771}, //13284 #CJK UNIFIED IDEOGRAPH
    {0xCE7C, 0x8772}, //13285 #CJK UNIFIED IDEOGRAPH
    {0xCE7D, 0x8773}, //13286 #CJK UNIFIED IDEOGRAPH
    {0xCE7E, 0x8775}, //13287 #CJK UNIFIED IDEOGRAPH
    {0xCE80, 0x8777}, //13288 #CJK UNIFIED IDEOGRAPH
    {0xCE81, 0x8778}, //13289 #CJK UNIFIED IDEOGRAPH
    {0xCE82, 0x8779}, //13290 #CJK UNIFIED IDEOGRAPH
    {0xCE83, 0x877A}, //13291 #CJK UNIFIED IDEOGRAPH
    {0xCE84, 0x877F}, //13292 #CJK UNIFIED IDEOGRAPH
    {0xCE85, 0x8780}, //13293 #CJK UNIFIED IDEOGRAPH
    {0xCE86, 0x8781}, //13294 #CJK UNIFIED IDEOGRAPH
    {0xCE87, 0x8784}, //13295 #CJK UNIFIED IDEOGRAPH
    {0xCE88, 0x8786}, //13296 #CJK UNIFIED IDEOGRAPH
    {0xCE89, 0x8787}, //13297 #CJK UNIFIED IDEOGRAPH
    {0xCE8A, 0x8789}, //13298 #CJK UNIFIED IDEOGRAPH
    {0xCE8B, 0x878A}, //13299 #CJK UNIFIED IDEOGRAPH
    {0xCE8C, 0x878C}, //13300 #CJK UNIFIED IDEOGRAPH
    {0xCE8D, 0x878E}, //13301 #CJK UNIFIED IDEOGRAPH
    {0xCE8E, 0x878F}, //13302 #CJK UNIFIED IDEOGRAPH
    {0xCE8F, 0x8790}, //13303 #CJK UNIFIED IDEOGRAPH
    {0xCE90, 0x8791}, //13304 #CJK UNIFIED IDEOGRAPH
    {0xCE91, 0x8792}, //13305 #CJK UNIFIED IDEOGRAPH
    {0xCE92, 0x8794}, //13306 #CJK UNIFIED IDEOGRAPH
    {0xCE93, 0x8795}, //13307 #CJK UNIFIED IDEOGRAPH
    {0xCE94, 0x8796}, //13308 #CJK UNIFIED IDEOGRAPH
    {0xCE95, 0x8798}, //13309 #CJK UNIFIED IDEOGRAPH
    {0xCE96, 0x8799}, //13310 #CJK UNIFIED IDEOGRAPH
    {0xCE97, 0x879A}, //13311 #CJK UNIFIED IDEOGRAPH
    {0xCE98, 0x879B}, //13312 #CJK UNIFIED IDEOGRAPH
    {0xCE99, 0x879C}, //13313 #CJK UNIFIED IDEOGRAPH
    {0xCE9A, 0x879D}, //13314 #CJK UNIFIED IDEOGRAPH
    {0xCE9B, 0x879E}, //13315 #CJK UNIFIED IDEOGRAPH
    {0xCE9C, 0x87A0}, //13316 #CJK UNIFIED IDEOGRAPH
    {0xCE9D, 0x87A1}, //13317 #CJK UNIFIED IDEOGRAPH
    {0xCE9E, 0x87A2}, //13318 #CJK UNIFIED IDEOGRAPH
    {0xCE9F, 0x87A3}, //13319 #CJK UNIFIED IDEOGRAPH
    {0xCEA0, 0x87A4}, //13320 #CJK UNIFIED IDEOGRAPH
    {0xCEA1, 0x5DCD}, //13321 #CJK UNIFIED IDEOGRAPH
    {0xCEA2, 0x5FAE}, //13322 #CJK UNIFIED IDEOGRAPH
    {0xCEA3, 0x5371}, //13323 #CJK UNIFIED IDEOGRAPH
    {0xCEA4, 0x97E6}, //13324 #CJK UNIFIED IDEOGRAPH
    {0xCEA5, 0x8FDD}, //13325 #CJK UNIFIED IDEOGRAPH
    {0xCEA6, 0x6845}, //13326 #CJK UNIFIED IDEOGRAPH
    {0xCEA7, 0x56F4}, //13327 #CJK UNIFIED IDEOGRAPH
    {0xCEA8, 0x552F}, //13328 #CJK UNIFIED IDEOGRAPH
    {0xCEA9, 0x60DF}, //13329 #CJK UNIFIED IDEOGRAPH
    {0xCEAA, 0x4E3A}, //13330 #CJK UNIFIED IDEOGRAPH
    {0xCEAB, 0x6F4D}, //13331 #CJK UNIFIED IDEOGRAPH
    {0xCEAC, 0x7EF4}, //13332 #CJK UNIFIED IDEOGRAPH
    {0xCEAD, 0x82C7}, //13333 #CJK UNIFIED IDEOGRAPH
    {0xCEAE, 0x840E}, //13334 #CJK UNIFIED IDEOGRAPH
    {0xCEAF, 0x59D4}, //13335 #CJK UNIFIED IDEOGRAPH
    {0xCEB0, 0x4F1F}, //13336 #CJK UNIFIED IDEOGRAPH
    {0xCEB1, 0x4F2A}, //13337 #CJK UNIFIED IDEOGRAPH
    {0xCEB2, 0x5C3E}, //13338 #CJK UNIFIED IDEOGRAPH
    {0xCEB3, 0x7EAC}, //13339 #CJK UNIFIED IDEOGRAPH
    {0xCEB4, 0x672A}, //13340 #CJK UNIFIED IDEOGRAPH
    {0xCEB5, 0x851A}, //13341 #CJK UNIFIED IDEOGRAPH
    {0xCEB6, 0x5473}, //13342 #CJK UNIFIED IDEOGRAPH
    {0xCEB7, 0x754F}, //13343 #CJK UNIFIED IDEOGRAPH
    {0xCEB8, 0x80C3}, //13344 #CJK UNIFIED IDEOGRAPH
    {0xCEB9, 0x5582}, //13345 #CJK UNIFIED IDEOGRAPH
    {0xCEBA, 0x9B4F}, //13346 #CJK UNIFIED IDEOGRAPH
    {0xCEBB, 0x4F4D}, //13347 #CJK UNIFIED IDEOGRAPH
    {0xCEBC, 0x6E2D}, //13348 #CJK UNIFIED IDEOGRAPH
    {0xCEBD, 0x8C13}, //13349 #CJK UNIFIED IDEOGRAPH
    {0xCEBE, 0x5C09}, //13350 #CJK UNIFIED IDEOGRAPH
    {0xCEBF, 0x6170}, //13351 #CJK UNIFIED IDEOGRAPH
    {0xCEC0, 0x536B}, //13352 #CJK UNIFIED IDEOGRAPH
    {0xCEC1, 0x761F}, //13353 #CJK UNIFIED IDEOGRAPH
    {0xCEC2, 0x6E29}, //13354 #CJK UNIFIED IDEOGRAPH
    {0xCEC3, 0x868A}, //13355 #CJK UNIFIED IDEOGRAPH
    {0xCEC4, 0x6587}, //13356 #CJK UNIFIED IDEOGRAPH
    {0xCEC5, 0x95FB}, //13357 #CJK UNIFIED IDEOGRAPH
    {0xCEC6, 0x7EB9}, //13358 #CJK UNIFIED IDEOGRAPH
    {0xCEC7, 0x543B}, //13359 #CJK UNIFIED IDEOGRAPH
    {0xCEC8, 0x7A33}, //13360 #CJK UNIFIED IDEOGRAPH
    {0xCEC9, 0x7D0A}, //13361 #CJK UNIFIED IDEOGRAPH
    {0xCECA, 0x95EE}, //13362 #CJK UNIFIED IDEOGRAPH
    {0xCECB, 0x55E1}, //13363 #CJK UNIFIED IDEOGRAPH
    {0xCECC, 0x7FC1}, //13364 #CJK UNIFIED IDEOGRAPH
    {0xCECD, 0x74EE}, //13365 #CJK UNIFIED IDEOGRAPH
    {0xCECE, 0x631D}, //13366 #CJK UNIFIED IDEOGRAPH
    {0xCECF, 0x8717}, //13367 #CJK UNIFIED IDEOGRAPH
    {0xCED0, 0x6DA1}, //13368 #CJK UNIFIED IDEOGRAPH
    {0xCED1, 0x7A9D}, //13369 #CJK UNIFIED IDEOGRAPH
    {0xCED2, 0x6211}, //13370 #CJK UNIFIED IDEOGRAPH
    {0xCED3, 0x65A1}, //13371 #CJK UNIFIED IDEOGRAPH
    {0xCED4, 0x5367}, //13372 #CJK UNIFIED IDEOGRAPH
    {0xCED5, 0x63E1}, //13373 #CJK UNIFIED IDEOGRAPH
    {0xCED6, 0x6C83}, //13374 #CJK UNIFIED IDEOGRAPH
    {0xCED7, 0x5DEB}, //13375 #CJK UNIFIED IDEOGRAPH
    {0xCED8, 0x545C}, //13376 #CJK UNIFIED IDEOGRAPH
    {0xCED9, 0x94A8}, //13377 #CJK UNIFIED IDEOGRAPH
    {0xCEDA, 0x4E4C}, //13378 #CJK UNIFIED IDEOGRAPH
    {0xCEDB, 0x6C61}, //13379 #CJK UNIFIED IDEOGRAPH
    {0xCEDC, 0x8BEC}, //13380 #CJK UNIFIED IDEOGRAPH
    {0xCEDD, 0x5C4B}, //13381 #CJK UNIFIED IDEOGRAPH
    {0xCEDE, 0x65E0}, //13382 #CJK UNIFIED IDEOGRAPH
    {0xCEDF, 0x829C}, //13383 #CJK UNIFIED IDEOGRAPH
    {0xCEE0, 0x68A7}, //13384 #CJK UNIFIED IDEOGRAPH
    {0xCEE1, 0x543E}, //13385 #CJK UNIFIED IDEOGRAPH
    {0xCEE2, 0x5434}, //13386 #CJK UNIFIED IDEOGRAPH
    {0xCEE3, 0x6BCB}, //13387 #CJK UNIFIED IDEOGRAPH
    {0xCEE4, 0x6B66}, //13388 #CJK UNIFIED IDEOGRAPH
    {0xCEE5, 0x4E94}, //13389 #CJK UNIFIED IDEOGRAPH
    {0xCEE6, 0x6342}, //13390 #CJK UNIFIED IDEOGRAPH
    {0xCEE7, 0x5348}, //13391 #CJK UNIFIED IDEOGRAPH
    {0xCEE8, 0x821E}, //13392 #CJK UNIFIED IDEOGRAPH
    {0xCEE9, 0x4F0D}, //13393 #CJK UNIFIED IDEOGRAPH
    {0xCEEA, 0x4FAE}, //13394 #CJK UNIFIED IDEOGRAPH
    {0xCEEB, 0x575E}, //13395 #CJK UNIFIED IDEOGRAPH
    {0xCEEC, 0x620A}, //13396 #CJK UNIFIED IDEOGRAPH
    {0xCEED, 0x96FE}, //13397 #CJK UNIFIED IDEOGRAPH
    {0xCEEE, 0x6664}, //13398 #CJK UNIFIED IDEOGRAPH
    {0xCEEF, 0x7269}, //13399 #CJK UNIFIED IDEOGRAPH
    {0xCEF0, 0x52FF}, //13400 #CJK UNIFIED IDEOGRAPH
    {0xCEF1, 0x52A1}, //13401 #CJK UNIFIED IDEOGRAPH
    {0xCEF2, 0x609F}, //13402 #CJK UNIFIED IDEOGRAPH
    {0xCEF3, 0x8BEF}, //13403 #CJK UNIFIED IDEOGRAPH
    {0xCEF4, 0x6614}, //13404 #CJK UNIFIED IDEOGRAPH
    {0xCEF5, 0x7199}, //13405 #CJK UNIFIED IDEOGRAPH
    {0xCEF6, 0x6790}, //13406 #CJK UNIFIED IDEOGRAPH
    {0xCEF7, 0x897F}, //13407 #CJK UNIFIED IDEOGRAPH
    {0xCEF8, 0x7852}, //13408 #CJK UNIFIED IDEOGRAPH
    {0xCEF9, 0x77FD}, //13409 #CJK UNIFIED IDEOGRAPH
    {0xCEFA, 0x6670}, //13410 #CJK UNIFIED IDEOGRAPH
    {0xCEFB, 0x563B}, //13411 #CJK UNIFIED IDEOGRAPH
    {0xCEFC, 0x5438}, //13412 #CJK UNIFIED IDEOGRAPH
    {0xCEFD, 0x9521}, //13413 #CJK UNIFIED IDEOGRAPH
    {0xCEFE, 0x727A}, //13414 #CJK UNIFIED IDEOGRAPH
    {0xCF40, 0x87A5}, //13415 #CJK UNIFIED IDEOGRAPH
    {0xCF41, 0x87A6}, //13416 #CJK UNIFIED IDEOGRAPH
    {0xCF42, 0x87A7}, //13417 #CJK UNIFIED IDEOGRAPH
    {0xCF43, 0x87A9}, //13418 #CJK UNIFIED IDEOGRAPH
    {0xCF44, 0x87AA}, //13419 #CJK UNIFIED IDEOGRAPH
    {0xCF45, 0x87AE}, //13420 #CJK UNIFIED IDEOGRAPH
    {0xCF46, 0x87B0}, //13421 #CJK UNIFIED IDEOGRAPH
    {0xCF47, 0x87B1}, //13422 #CJK UNIFIED IDEOGRAPH
    {0xCF48, 0x87B2}, //13423 #CJK UNIFIED IDEOGRAPH
    {0xCF49, 0x87B4}, //13424 #CJK UNIFIED IDEOGRAPH
    {0xCF4A, 0x87B6}, //13425 #CJK UNIFIED IDEOGRAPH
    {0xCF4B, 0x87B7}, //13426 #CJK UNIFIED IDEOGRAPH
    {0xCF4C, 0x87B8}, //13427 #CJK UNIFIED IDEOGRAPH
    {0xCF4D, 0x87B9}, //13428 #CJK UNIFIED IDEOGRAPH
    {0xCF4E, 0x87BB}, //13429 #CJK UNIFIED IDEOGRAPH
    {0xCF4F, 0x87BC}, //13430 #CJK UNIFIED IDEOGRAPH
    {0xCF50, 0x87BE}, //13431 #CJK UNIFIED IDEOGRAPH
    {0xCF51, 0x87BF}, //13432 #CJK UNIFIED IDEOGRAPH
    {0xCF52, 0x87C1}, //13433 #CJK UNIFIED IDEOGRAPH
    {0xCF53, 0x87C2}, //13434 #CJK UNIFIED IDEOGRAPH
    {0xCF54, 0x87C3}, //13435 #CJK UNIFIED IDEOGRAPH
    {0xCF55, 0x87C4}, //13436 #CJK UNIFIED IDEOGRAPH
    {0xCF56, 0x87C5}, //13437 #CJK UNIFIED IDEOGRAPH
    {0xCF57, 0x87C7}, //13438 #CJK UNIFIED IDEOGRAPH
    {0xCF58, 0x87C8}, //13439 #CJK UNIFIED IDEOGRAPH
    {0xCF59, 0x87C9}, //13440 #CJK UNIFIED IDEOGRAPH
    {0xCF5A, 0x87CC}, //13441 #CJK UNIFIED IDEOGRAPH
    {0xCF5B, 0x87CD}, //13442 #CJK UNIFIED IDEOGRAPH
    {0xCF5C, 0x87CE}, //13443 #CJK UNIFIED IDEOGRAPH
    {0xCF5D, 0x87CF}, //13444 #CJK UNIFIED IDEOGRAPH
    {0xCF5E, 0x87D0}, //13445 #CJK UNIFIED IDEOGRAPH
    {0xCF5F, 0x87D4}, //13446 #CJK UNIFIED IDEOGRAPH
    {0xCF60, 0x87D5}, //13447 #CJK UNIFIED IDEOGRAPH
    {0xCF61, 0x87D6}, //13448 #CJK UNIFIED IDEOGRAPH
    {0xCF62, 0x87D7}, //13449 #CJK UNIFIED IDEOGRAPH
    {0xCF63, 0x87D8}, //13450 #CJK UNIFIED IDEOGRAPH
    {0xCF64, 0x87D9}, //13451 #CJK UNIFIED IDEOGRAPH
    {0xCF65, 0x87DA}, //13452 #CJK UNIFIED IDEOGRAPH
    {0xCF66, 0x87DC}, //13453 #CJK UNIFIED IDEOGRAPH
    {0xCF67, 0x87DD}, //13454 #CJK UNIFIED IDEOGRAPH
    {0xCF68, 0x87DE}, //13455 #CJK UNIFIED IDEOGRAPH
    {0xCF69, 0x87DF}, //13456 #CJK UNIFIED IDEOGRAPH
    {0xCF6A, 0x87E1}, //13457 #CJK UNIFIED IDEOGRAPH
    {0xCF6B, 0x87E2}, //13458 #CJK UNIFIED IDEOGRAPH
    {0xCF6C, 0x87E3}, //13459 #CJK UNIFIED IDEOGRAPH
    {0xCF6D, 0x87E4}, //13460 #CJK UNIFIED IDEOGRAPH
    {0xCF6E, 0x87E6}, //13461 #CJK UNIFIED IDEOGRAPH
    {0xCF6F, 0x87E7}, //13462 #CJK UNIFIED IDEOGRAPH
    {0xCF70, 0x87E8}, //13463 #CJK UNIFIED IDEOGRAPH
    {0xCF71, 0x87E9}, //13464 #CJK UNIFIED IDEOGRAPH
    {0xCF72, 0x87EB}, //13465 #CJK UNIFIED IDEOGRAPH
    {0xCF73, 0x87EC}, //13466 #CJK UNIFIED IDEOGRAPH
    {0xCF74, 0x87ED}, //13467 #CJK UNIFIED IDEOGRAPH
    {0xCF75, 0x87EF}, //13468 #CJK UNIFIED IDEOGRAPH
    {0xCF76, 0x87F0}, //13469 #CJK UNIFIED IDEOGRAPH
    {0xCF77, 0x87F1}, //13470 #CJK UNIFIED IDEOGRAPH
    {0xCF78, 0x87F2}, //13471 #CJK UNIFIED IDEOGRAPH
    {0xCF79, 0x87F3}, //13472 #CJK UNIFIED IDEOGRAPH
    {0xCF7A, 0x87F4}, //13473 #CJK UNIFIED IDEOGRAPH
    {0xCF7B, 0x87F5}, //13474 #CJK UNIFIED IDEOGRAPH
    {0xCF7C, 0x87F6}, //13475 #CJK UNIFIED IDEOGRAPH
    {0xCF7D, 0x87F7}, //13476 #CJK UNIFIED IDEOGRAPH
    {0xCF7E, 0x87F8}, //13477 #CJK UNIFIED IDEOGRAPH
    {0xCF80, 0x87FA}, //13478 #CJK UNIFIED IDEOGRAPH
    {0xCF81, 0x87FB}, //13479 #CJK UNIFIED IDEOGRAPH
    {0xCF82, 0x87FC}, //13480 #CJK UNIFIED IDEOGRAPH
    {0xCF83, 0x87FD}, //13481 #CJK UNIFIED IDEOGRAPH
    {0xCF84, 0x87FF}, //13482 #CJK UNIFIED IDEOGRAPH
    {0xCF85, 0x8800}, //13483 #CJK UNIFIED IDEOGRAPH
    {0xCF86, 0x8801}, //13484 #CJK UNIFIED IDEOGRAPH
    {0xCF87, 0x8802}, //13485 #CJK UNIFIED IDEOGRAPH
    {0xCF88, 0x8804}, //13486 #CJK UNIFIED IDEOGRAPH
    {0xCF89, 0x8805}, //13487 #CJK UNIFIED IDEOGRAPH
    {0xCF8A, 0x8806}, //13488 #CJK UNIFIED IDEOGRAPH
    {0xCF8B, 0x8807}, //13489 #CJK UNIFIED IDEOGRAPH
    {0xCF8C, 0x8808}, //13490 #CJK UNIFIED IDEOGRAPH
    {0xCF8D, 0x8809}, //13491 #CJK UNIFIED IDEOGRAPH
    {0xCF8E, 0x880B}, //13492 #CJK UNIFIED IDEOGRAPH
    {0xCF8F, 0x880C}, //13493 #CJK UNIFIED IDEOGRAPH
    {0xCF90, 0x880D}, //13494 #CJK UNIFIED IDEOGRAPH
    {0xCF91, 0x880E}, //13495 #CJK UNIFIED IDEOGRAPH
    {0xCF92, 0x880F}, //13496 #CJK UNIFIED IDEOGRAPH
    {0xCF93, 0x8810}, //13497 #CJK UNIFIED IDEOGRAPH
    {0xCF94, 0x8811}, //13498 #CJK UNIFIED IDEOGRAPH
    {0xCF95, 0x8812}, //13499 #CJK UNIFIED IDEOGRAPH
    {0xCF96, 0x8814}, //13500 #CJK UNIFIED IDEOGRAPH
    {0xCF97, 0x8817}, //13501 #CJK UNIFIED IDEOGRAPH
    {0xCF98, 0x8818}, //13502 #CJK UNIFIED IDEOGRAPH
    {0xCF99, 0x8819}, //13503 #CJK UNIFIED IDEOGRAPH
    {0xCF9A, 0x881A}, //13504 #CJK UNIFIED IDEOGRAPH
    {0xCF9B, 0x881C}, //13505 #CJK UNIFIED IDEOGRAPH
    {0xCF9C, 0x881D}, //13506 #CJK UNIFIED IDEOGRAPH
    {0xCF9D, 0x881E}, //13507 #CJK UNIFIED IDEOGRAPH
    {0xCF9E, 0x881F}, //13508 #CJK UNIFIED IDEOGRAPH
    {0xCF9F, 0x8820}, //13509 #CJK UNIFIED IDEOGRAPH
    {0xCFA0, 0x8823}, //13510 #CJK UNIFIED IDEOGRAPH
    {0xCFA1, 0x7A00}, //13511 #CJK UNIFIED IDEOGRAPH
    {0xCFA2, 0x606F}, //13512 #CJK UNIFIED IDEOGRAPH
    {0xCFA3, 0x5E0C}, //13513 #CJK UNIFIED IDEOGRAPH
    {0xCFA4, 0x6089}, //13514 #CJK UNIFIED IDEOGRAPH
    {0xCFA5, 0x819D}, //13515 #CJK UNIFIED IDEOGRAPH
    {0xCFA6, 0x5915}, //13516 #CJK UNIFIED IDEOGRAPH
    {0xCFA7, 0x60DC}, //13517 #CJK UNIFIED IDEOGRAPH
    {0xCFA8, 0x7184}, //13518 #CJK UNIFIED IDEOGRAPH
    {0xCFA9, 0x70EF}, //13519 #CJK UNIFIED IDEOGRAPH
    {0xCFAA, 0x6EAA}, //13520 #CJK UNIFIED IDEOGRAPH
    {0xCFAB, 0x6C50}, //13521 #CJK UNIFIED IDEOGRAPH
    {0xCFAC, 0x7280}, //13522 #CJK UNIFIED IDEOGRAPH
    {0xCFAD, 0x6A84}, //13523 #CJK UNIFIED IDEOGRAPH
    {0xCFAE, 0x88AD}, //13524 #CJK UNIFIED IDEOGRAPH
    {0xCFAF, 0x5E2D}, //13525 #CJK UNIFIED IDEOGRAPH
    {0xCFB0, 0x4E60}, //13526 #CJK UNIFIED IDEOGRAPH
    {0xCFB1, 0x5AB3}, //13527 #CJK UNIFIED IDEOGRAPH
    {0xCFB2, 0x559C}, //13528 #CJK UNIFIED IDEOGRAPH
    {0xCFB3, 0x94E3}, //13529 #CJK UNIFIED IDEOGRAPH
    {0xCFB4, 0x6D17}, //13530 #CJK UNIFIED IDEOGRAPH
    {0xCFB5, 0x7CFB}, //13531 #CJK UNIFIED IDEOGRAPH
    {0xCFB6, 0x9699}, //13532 #CJK UNIFIED IDEOGRAPH
    {0xCFB7, 0x620F}, //13533 #CJK UNIFIED IDEOGRAPH
    {0xCFB8, 0x7EC6}, //13534 #CJK UNIFIED IDEOGRAPH
    {0xCFB9, 0x778E}, //13535 #CJK UNIFIED IDEOGRAPH
    {0xCFBA, 0x867E}, //13536 #CJK UNIFIED IDEOGRAPH
    {0xCFBB, 0x5323}, //13537 #CJK UNIFIED IDEOGRAPH
    {0xCFBC, 0x971E}, //13538 #CJK UNIFIED IDEOGRAPH
    {0xCFBD, 0x8F96}, //13539 #CJK UNIFIED IDEOGRAPH
    {0xCFBE, 0x6687}, //13540 #CJK UNIFIED IDEOGRAPH
    {0xCFBF, 0x5CE1}, //13541 #CJK UNIFIED IDEOGRAPH
    {0xCFC0, 0x4FA0}, //13542 #CJK UNIFIED IDEOGRAPH
    {0xCFC1, 0x72ED}, //13543 #CJK UNIFIED IDEOGRAPH
    {0xCFC2, 0x4E0B}, //13544 #CJK UNIFIED IDEOGRAPH
    {0xCFC3, 0x53A6}, //13545 #CJK UNIFIED IDEOGRAPH
    {0xCFC4, 0x590F}, //13546 #CJK UNIFIED IDEOGRAPH
    {0xCFC5, 0x5413}, //13547 #CJK UNIFIED IDEOGRAPH
    {0xCFC6, 0x6380}, //13548 #CJK UNIFIED IDEOGRAPH
    {0xCFC7, 0x9528}, //13549 #CJK UNIFIED IDEOGRAPH
    {0xCFC8, 0x5148}, //13550 #CJK UNIFIED IDEOGRAPH
    {0xCFC9, 0x4ED9}, //13551 #CJK UNIFIED IDEOGRAPH
    {0xCFCA, 0x9C9C}, //13552 #CJK UNIFIED IDEOGRAPH
    {0xCFCB, 0x7EA4}, //13553 #CJK UNIFIED IDEOGRAPH
    {0xCFCC, 0x54B8}, //13554 #CJK UNIFIED IDEOGRAPH
    {0xCFCD, 0x8D24}, //13555 #CJK UNIFIED IDEOGRAPH
    {0xCFCE, 0x8854}, //13556 #CJK UNIFIED IDEOGRAPH
    {0xCFCF, 0x8237}, //13557 #CJK UNIFIED IDEOGRAPH
    {0xCFD0, 0x95F2}, //13558 #CJK UNIFIED IDEOGRAPH
    {0xCFD1, 0x6D8E}, //13559 #CJK UNIFIED IDEOGRAPH
    {0xCFD2, 0x5F26}, //13560 #CJK UNIFIED IDEOGRAPH
    {0xCFD3, 0x5ACC}, //13561 #CJK UNIFIED IDEOGRAPH
    {0xCFD4, 0x663E}, //13562 #CJK UNIFIED IDEOGRAPH
    {0xCFD5, 0x9669}, //13563 #CJK UNIFIED IDEOGRAPH
    {0xCFD6, 0x73B0}, //13564 #CJK UNIFIED IDEOGRAPH
    {0xCFD7, 0x732E}, //13565 #CJK UNIFIED IDEOGRAPH
    {0xCFD8, 0x53BF}, //13566 #CJK UNIFIED IDEOGRAPH
    {0xCFD9, 0x817A}, //13567 #CJK UNIFIED IDEOGRAPH
    {0xCFDA, 0x9985}, //13568 #CJK UNIFIED IDEOGRAPH
    {0xCFDB, 0x7FA1}, //13569 #CJK UNIFIED IDEOGRAPH
    {0xCFDC, 0x5BAA}, //13570 #CJK UNIFIED IDEOGRAPH
    {0xCFDD, 0x9677}, //13571 #CJK UNIFIED IDEOGRAPH
    {0xCFDE, 0x9650}, //13572 #CJK UNIFIED IDEOGRAPH
    {0xCFDF, 0x7EBF}, //13573 #CJK UNIFIED IDEOGRAPH
    {0xCFE0, 0x76F8}, //13574 #CJK UNIFIED IDEOGRAPH
    {0xCFE1, 0x53A2}, //13575 #CJK UNIFIED IDEOGRAPH
    {0xCFE2, 0x9576}, //13576 #CJK UNIFIED IDEOGRAPH
    {0xCFE3, 0x9999}, //13577 #CJK UNIFIED IDEOGRAPH
    {0xCFE4, 0x7BB1}, //13578 #CJK UNIFIED IDEOGRAPH
    {0xCFE5, 0x8944}, //13579 #CJK UNIFIED IDEOGRAPH
    {0xCFE6, 0x6E58}, //13580 #CJK UNIFIED IDEOGRAPH
    {0xCFE7, 0x4E61}, //13581 #CJK UNIFIED IDEOGRAPH
    {0xCFE8, 0x7FD4}, //13582 #CJK UNIFIED IDEOGRAPH
    {0xCFE9, 0x7965}, //13583 #CJK UNIFIED IDEOGRAPH
    {0xCFEA, 0x8BE6}, //13584 #CJK UNIFIED IDEOGRAPH
    {0xCFEB, 0x60F3}, //13585 #CJK UNIFIED IDEOGRAPH
    {0xCFEC, 0x54CD}, //13586 #CJK UNIFIED IDEOGRAPH
    {0xCFED, 0x4EAB}, //13587 #CJK UNIFIED IDEOGRAPH
    {0xCFEE, 0x9879}, //13588 #CJK UNIFIED IDEOGRAPH
    {0xCFEF, 0x5DF7}, //13589 #CJK UNIFIED IDEOGRAPH
    {0xCFF0, 0x6A61}, //13590 #CJK UNIFIED IDEOGRAPH
    {0xCFF1, 0x50CF}, //13591 #CJK UNIFIED IDEOGRAPH
    {0xCFF2, 0x5411}, //13592 #CJK UNIFIED IDEOGRAPH
    {0xCFF3, 0x8C61}, //13593 #CJK UNIFIED IDEOGRAPH
    {0xCFF4, 0x8427}, //13594 #CJK UNIFIED IDEOGRAPH
    {0xCFF5, 0x785D}, //13595 #CJK UNIFIED IDEOGRAPH
    {0xCFF6, 0x9704}, //13596 #CJK UNIFIED IDEOGRAPH
    {0xCFF7, 0x524A}, //13597 #CJK UNIFIED IDEOGRAPH
    {0xCFF8, 0x54EE}, //13598 #CJK UNIFIED IDEOGRAPH
    {0xCFF9, 0x56A3}, //13599 #CJK UNIFIED IDEOGRAPH
    {0xCFFA, 0x9500}, //13600 #CJK UNIFIED IDEOGRAPH
    {0xCFFB, 0x6D88}, //13601 #CJK UNIFIED IDEOGRAPH
    {0xCFFC, 0x5BB5}, //13602 #CJK UNIFIED IDEOGRAPH
    {0xCFFD, 0x6DC6}, //13603 #CJK UNIFIED IDEOGRAPH
    {0xCFFE, 0x6653}, //13604 #CJK UNIFIED IDEOGRAPH
    {0xD040, 0x8824}, //13605 #CJK UNIFIED IDEOGRAPH
    {0xD041, 0x8825}, //13606 #CJK UNIFIED IDEOGRAPH
    {0xD042, 0x8826}, //13607 #CJK UNIFIED IDEOGRAPH
    {0xD043, 0x8827}, //13608 #CJK UNIFIED IDEOGRAPH
    {0xD044, 0x8828}, //13609 #CJK UNIFIED IDEOGRAPH
    {0xD045, 0x8829}, //13610 #CJK UNIFIED IDEOGRAPH
    {0xD046, 0x882A}, //13611 #CJK UNIFIED IDEOGRAPH
    {0xD047, 0x882B}, //13612 #CJK UNIFIED IDEOGRAPH
    {0xD048, 0x882C}, //13613 #CJK UNIFIED IDEOGRAPH
    {0xD049, 0x882D}, //13614 #CJK UNIFIED IDEOGRAPH
    {0xD04A, 0x882E}, //13615 #CJK UNIFIED IDEOGRAPH
    {0xD04B, 0x882F}, //13616 #CJK UNIFIED IDEOGRAPH
    {0xD04C, 0x8830}, //13617 #CJK UNIFIED IDEOGRAPH
    {0xD04D, 0x8831}, //13618 #CJK UNIFIED IDEOGRAPH
    {0xD04E, 0x8833}, //13619 #CJK UNIFIED IDEOGRAPH
    {0xD04F, 0x8834}, //13620 #CJK UNIFIED IDEOGRAPH
    {0xD050, 0x8835}, //13621 #CJK UNIFIED IDEOGRAPH
    {0xD051, 0x8836}, //13622 #CJK UNIFIED IDEOGRAPH
    {0xD052, 0x8837}, //13623 #CJK UNIFIED IDEOGRAPH
    {0xD053, 0x8838}, //13624 #CJK UNIFIED IDEOGRAPH
    {0xD054, 0x883A}, //13625 #CJK UNIFIED IDEOGRAPH
    {0xD055, 0x883B}, //13626 #CJK UNIFIED IDEOGRAPH
    {0xD056, 0x883D}, //13627 #CJK UNIFIED IDEOGRAPH
    {0xD057, 0x883E}, //13628 #CJK UNIFIED IDEOGRAPH
    {0xD058, 0x883F}, //13629 #CJK UNIFIED IDEOGRAPH
    {0xD059, 0x8841}, //13630 #CJK UNIFIED IDEOGRAPH
    {0xD05A, 0x8842}, //13631 #CJK UNIFIED IDEOGRAPH
    {0xD05B, 0x8843}, //13632 #CJK UNIFIED IDEOGRAPH
    {0xD05C, 0x8846}, //13633 #CJK UNIFIED IDEOGRAPH
    {0xD05D, 0x8847}, //13634 #CJK UNIFIED IDEOGRAPH
    {0xD05E, 0x8848}, //13635 #CJK UNIFIED IDEOGRAPH
    {0xD05F, 0x8849}, //13636 #CJK UNIFIED IDEOGRAPH
    {0xD060, 0x884A}, //13637 #CJK UNIFIED IDEOGRAPH
    {0xD061, 0x884B}, //13638 #CJK UNIFIED IDEOGRAPH
    {0xD062, 0x884E}, //13639 #CJK UNIFIED IDEOGRAPH
    {0xD063, 0x884F}, //13640 #CJK UNIFIED IDEOGRAPH
    {0xD064, 0x8850}, //13641 #CJK UNIFIED IDEOGRAPH
    {0xD065, 0x8851}, //13642 #CJK UNIFIED IDEOGRAPH
    {0xD066, 0x8852}, //13643 #CJK UNIFIED IDEOGRAPH
    {0xD067, 0x8853}, //13644 #CJK UNIFIED IDEOGRAPH
    {0xD068, 0x8855}, //13645 #CJK UNIFIED IDEOGRAPH
    {0xD069, 0x8856}, //13646 #CJK UNIFIED IDEOGRAPH
    {0xD06A, 0x8858}, //13647 #CJK UNIFIED IDEOGRAPH
    {0xD06B, 0x885A}, //13648 #CJK UNIFIED IDEOGRAPH
    {0xD06C, 0x885B}, //13649 #CJK UNIFIED IDEOGRAPH
    {0xD06D, 0x885C}, //13650 #CJK UNIFIED IDEOGRAPH
    {0xD06E, 0x885D}, //13651 #CJK UNIFIED IDEOGRAPH
    {0xD06F, 0x885E}, //13652 #CJK UNIFIED IDEOGRAPH
    {0xD070, 0x885F}, //13653 #CJK UNIFIED IDEOGRAPH
    {0xD071, 0x8860}, //13654 #CJK UNIFIED IDEOGRAPH
    {0xD072, 0x8866}, //13655 #CJK UNIFIED IDEOGRAPH
    {0xD073, 0x8867}, //13656 #CJK UNIFIED IDEOGRAPH
    {0xD074, 0x886A}, //13657 #CJK UNIFIED IDEOGRAPH
    {0xD075, 0x886D}, //13658 #CJK UNIFIED IDEOGRAPH
    {0xD076, 0x886F}, //13659 #CJK UNIFIED IDEOGRAPH
    {0xD077, 0x8871}, //13660 #CJK UNIFIED IDEOGRAPH
    {0xD078, 0x8873}, //13661 #CJK UNIFIED IDEOGRAPH
    {0xD079, 0x8874}, //13662 #CJK UNIFIED IDEOGRAPH
    {0xD07A, 0x8875}, //13663 #CJK UNIFIED IDEOGRAPH
    {0xD07B, 0x8876}, //13664 #CJK UNIFIED IDEOGRAPH
    {0xD07C, 0x8878}, //13665 #CJK UNIFIED IDEOGRAPH
    {0xD07D, 0x8879}, //13666 #CJK UNIFIED IDEOGRAPH
    {0xD07E, 0x887A}, //13667 #CJK UNIFIED IDEOGRAPH
    {0xD080, 0x887B}, //13668 #CJK UNIFIED IDEOGRAPH
    {0xD081, 0x887C}, //13669 #CJK UNIFIED IDEOGRAPH
    {0xD082, 0x8880}, //13670 #CJK UNIFIED IDEOGRAPH
    {0xD083, 0x8883}, //13671 #CJK UNIFIED IDEOGRAPH
    {0xD084, 0x8886}, //13672 #CJK UNIFIED IDEOGRAPH
    {0xD085, 0x8887}, //13673 #CJK UNIFIED IDEOGRAPH
    {0xD086, 0x8889}, //13674 #CJK UNIFIED IDEOGRAPH
    {0xD087, 0x888A}, //13675 #CJK UNIFIED IDEOGRAPH
    {0xD088, 0x888C}, //13676 #CJK UNIFIED IDEOGRAPH
    {0xD089, 0x888E}, //13677 #CJK UNIFIED IDEOGRAPH
    {0xD08A, 0x888F}, //13678 #CJK UNIFIED IDEOGRAPH
    {0xD08B, 0x8890}, //13679 #CJK UNIFIED IDEOGRAPH
    {0xD08C, 0x8891}, //13680 #CJK UNIFIED IDEOGRAPH
    {0xD08D, 0x8893}, //13681 #CJK UNIFIED IDEOGRAPH
    {0xD08E, 0x8894}, //13682 #CJK UNIFIED IDEOGRAPH
    {0xD08F, 0x8895}, //13683 #CJK UNIFIED IDEOGRAPH
    {0xD090, 0x8897}, //13684 #CJK UNIFIED IDEOGRAPH
    {0xD091, 0x8898}, //13685 #CJK UNIFIED IDEOGRAPH
    {0xD092, 0x8899}, //13686 #CJK UNIFIED IDEOGRAPH
    {0xD093, 0x889A}, //13687 #CJK UNIFIED IDEOGRAPH
    {0xD094, 0x889B}, //13688 #CJK UNIFIED IDEOGRAPH
    {0xD095, 0x889D}, //13689 #CJK UNIFIED IDEOGRAPH
    {0xD096, 0x889E}, //13690 #CJK UNIFIED IDEOGRAPH
    {0xD097, 0x889F}, //13691 #CJK UNIFIED IDEOGRAPH
    {0xD098, 0x88A0}, //13692 #CJK UNIFIED IDEOGRAPH
    {0xD099, 0x88A1}, //13693 #CJK UNIFIED IDEOGRAPH
    {0xD09A, 0x88A3}, //13694 #CJK UNIFIED IDEOGRAPH
    {0xD09B, 0x88A5}, //13695 #CJK UNIFIED IDEOGRAPH
    {0xD09C, 0x88A6}, //13696 #CJK UNIFIED IDEOGRAPH
    {0xD09D, 0x88A7}, //13697 #CJK UNIFIED IDEOGRAPH
    {0xD09E, 0x88A8}, //13698 #CJK UNIFIED IDEOGRAPH
    {0xD09F, 0x88A9}, //13699 #CJK UNIFIED IDEOGRAPH
    {0xD0A0, 0x88AA}, //13700 #CJK UNIFIED IDEOGRAPH
    {0xD0A1, 0x5C0F}, //13701 #CJK UNIFIED IDEOGRAPH
    {0xD0A2, 0x5B5D}, //13702 #CJK UNIFIED IDEOGRAPH
    {0xD0A3, 0x6821}, //13703 #CJK UNIFIED IDEOGRAPH
    {0xD0A4, 0x8096}, //13704 #CJK UNIFIED IDEOGRAPH
    {0xD0A5, 0x5578}, //13705 #CJK UNIFIED IDEOGRAPH
    {0xD0A6, 0x7B11}, //13706 #CJK UNIFIED IDEOGRAPH
    {0xD0A7, 0x6548}, //13707 #CJK UNIFIED IDEOGRAPH
    {0xD0A8, 0x6954}, //13708 #CJK UNIFIED IDEOGRAPH
    {0xD0A9, 0x4E9B}, //13709 #CJK UNIFIED IDEOGRAPH
    {0xD0AA, 0x6B47}, //13710 #CJK UNIFIED IDEOGRAPH
    {0xD0AB, 0x874E}, //13711 #CJK UNIFIED IDEOGRAPH
    {0xD0AC, 0x978B}, //13712 #CJK UNIFIED IDEOGRAPH
    {0xD0AD, 0x534F}, //13713 #CJK UNIFIED IDEOGRAPH
    {0xD0AE, 0x631F}, //13714 #CJK UNIFIED IDEOGRAPH
    {0xD0AF, 0x643A}, //13715 #CJK UNIFIED IDEOGRAPH
    {0xD0B0, 0x90AA}, //13716 #CJK UNIFIED IDEOGRAPH
    {0xD0B1, 0x659C}, //13717 #CJK UNIFIED IDEOGRAPH
    {0xD0B2, 0x80C1}, //13718 #CJK UNIFIED IDEOGRAPH
    {0xD0B3, 0x8C10}, //13719 #CJK UNIFIED IDEOGRAPH
    {0xD0B4, 0x5199}, //13720 #CJK UNIFIED IDEOGRAPH
    {0xD0B5, 0x68B0}, //13721 #CJK UNIFIED IDEOGRAPH
    {0xD0B6, 0x5378}, //13722 #CJK UNIFIED IDEOGRAPH
    {0xD0B7, 0x87F9}, //13723 #CJK UNIFIED IDEOGRAPH
    {0xD0B8, 0x61C8}, //13724 #CJK UNIFIED IDEOGRAPH
    {0xD0B9, 0x6CC4}, //13725 #CJK UNIFIED IDEOGRAPH
    {0xD0BA, 0x6CFB}, //13726 #CJK UNIFIED IDEOGRAPH
    {0xD0BB, 0x8C22}, //13727 #CJK UNIFIED IDEOGRAPH
    {0xD0BC, 0x5C51}, //13728 #CJK UNIFIED IDEOGRAPH
    {0xD0BD, 0x85AA}, //13729 #CJK UNIFIED IDEOGRAPH
    {0xD0BE, 0x82AF}, //13730 #CJK UNIFIED IDEOGRAPH
    {0xD0BF, 0x950C}, //13731 #CJK UNIFIED IDEOGRAPH
    {0xD0C0, 0x6B23}, //13732 #CJK UNIFIED IDEOGRAPH
    {0xD0C1, 0x8F9B}, //13733 #CJK UNIFIED IDEOGRAPH
    {0xD0C2, 0x65B0}, //13734 #CJK UNIFIED IDEOGRAPH
    {0xD0C3, 0x5FFB}, //13735 #CJK UNIFIED IDEOGRAPH
    {0xD0C4, 0x5FC3}, //13736 #CJK UNIFIED IDEOGRAPH
    {0xD0C5, 0x4FE1}, //13737 #CJK UNIFIED IDEOGRAPH
    {0xD0C6, 0x8845}, //13738 #CJK UNIFIED IDEOGRAPH
    {0xD0C7, 0x661F}, //13739 #CJK UNIFIED IDEOGRAPH
    {0xD0C8, 0x8165}, //13740 #CJK UNIFIED IDEOGRAPH
    {0xD0C9, 0x7329}, //13741 #CJK UNIFIED IDEOGRAPH
    {0xD0CA, 0x60FA}, //13742 #CJK UNIFIED IDEOGRAPH
    {0xD0CB, 0x5174}, //13743 #CJK UNIFIED IDEOGRAPH
    {0xD0CC, 0x5211}, //13744 #CJK UNIFIED IDEOGRAPH
    {0xD0CD, 0x578B}, //13745 #CJK UNIFIED IDEOGRAPH
    {0xD0CE, 0x5F62}, //13746 #CJK UNIFIED IDEOGRAPH
    {0xD0CF, 0x90A2}, //13747 #CJK UNIFIED IDEOGRAPH
    {0xD0D0, 0x884C}, //13748 #CJK UNIFIED IDEOGRAPH
    {0xD0D1, 0x9192}, //13749 #CJK UNIFIED IDEOGRAPH
    {0xD0D2, 0x5E78}, //13750 #CJK UNIFIED IDEOGRAPH
    {0xD0D3, 0x674F}, //13751 #CJK UNIFIED IDEOGRAPH
    {0xD0D4, 0x6027}, //13752 #CJK UNIFIED IDEOGRAPH
    {0xD0D5, 0x59D3}, //13753 #CJK UNIFIED IDEOGRAPH
    {0xD0D6, 0x5144}, //13754 #CJK UNIFIED IDEOGRAPH
    {0xD0D7, 0x51F6}, //13755 #CJK UNIFIED IDEOGRAPH
    {0xD0D8, 0x80F8}, //13756 #CJK UNIFIED IDEOGRAPH
    {0xD0D9, 0x5308}, //13757 #CJK UNIFIED IDEOGRAPH
    {0xD0DA, 0x6C79}, //13758 #CJK UNIFIED IDEOGRAPH
    {0xD0DB, 0x96C4}, //13759 #CJK UNIFIED IDEOGRAPH
    {0xD0DC, 0x718A}, //13760 #CJK UNIFIED IDEOGRAPH
    {0xD0DD, 0x4F11}, //13761 #CJK UNIFIED IDEOGRAPH
    {0xD0DE, 0x4FEE}, //13762 #CJK UNIFIED IDEOGRAPH
    {0xD0DF, 0x7F9E}, //13763 #CJK UNIFIED IDEOGRAPH
    {0xD0E0, 0x673D}, //13764 #CJK UNIFIED IDEOGRAPH
    {0xD0E1, 0x55C5}, //13765 #CJK UNIFIED IDEOGRAPH
    {0xD0E2, 0x9508}, //13766 #CJK UNIFIED IDEOGRAPH
    {0xD0E3, 0x79C0}, //13767 #CJK UNIFIED IDEOGRAPH
    {0xD0E4, 0x8896}, //13768 #CJK UNIFIED IDEOGRAPH
    {0xD0E5, 0x7EE3}, //13769 #CJK UNIFIED IDEOGRAPH
    {0xD0E6, 0x589F}, //13770 #CJK UNIFIED IDEOGRAPH
    {0xD0E7, 0x620C}, //13771 #CJK UNIFIED IDEOGRAPH
    {0xD0E8, 0x9700}, //13772 #CJK UNIFIED IDEOGRAPH
    {0xD0E9, 0x865A}, //13773 #CJK UNIFIED IDEOGRAPH
    {0xD0EA, 0x5618}, //13774 #CJK UNIFIED IDEOGRAPH
    {0xD0EB, 0x987B}, //13775 #CJK UNIFIED IDEOGRAPH
    {0xD0EC, 0x5F90}, //13776 #CJK UNIFIED IDEOGRAPH
    {0xD0ED, 0x8BB8}, //13777 #CJK UNIFIED IDEOGRAPH
    {0xD0EE, 0x84C4}, //13778 #CJK UNIFIED IDEOGRAPH
    {0xD0EF, 0x9157}, //13779 #CJK UNIFIED IDEOGRAPH
    {0xD0F0, 0x53D9}, //13780 #CJK UNIFIED IDEOGRAPH
    {0xD0F1, 0x65ED}, //13781 #CJK UNIFIED IDEOGRAPH
    {0xD0F2, 0x5E8F}, //13782 #CJK UNIFIED IDEOGRAPH
    {0xD0F3, 0x755C}, //13783 #CJK UNIFIED IDEOGRAPH
    {0xD0F4, 0x6064}, //13784 #CJK UNIFIED IDEOGRAPH
    {0xD0F5, 0x7D6E}, //13785 #CJK UNIFIED IDEOGRAPH
    {0xD0F6, 0x5A7F}, //13786 #CJK UNIFIED IDEOGRAPH
    {0xD0F7, 0x7EEA}, //13787 #CJK UNIFIED IDEOGRAPH
    {0xD0F8, 0x7EED}, //13788 #CJK UNIFIED IDEOGRAPH
    {0xD0F9, 0x8F69}, //13789 #CJK UNIFIED IDEOGRAPH
    {0xD0FA, 0x55A7}, //13790 #CJK UNIFIED IDEOGRAPH
    {0xD0FB, 0x5BA3}, //13791 #CJK UNIFIED IDEOGRAPH
    {0xD0FC, 0x60AC}, //13792 #CJK UNIFIED IDEOGRAPH
    {0xD0FD, 0x65CB}, //13793 #CJK UNIFIED IDEOGRAPH
    {0xD0FE, 0x7384}, //13794 #CJK UNIFIED IDEOGRAPH
    {0xD140, 0x88AC}, //13795 #CJK UNIFIED IDEOGRAPH
    {0xD141, 0x88AE}, //13796 #CJK UNIFIED IDEOGRAPH
    {0xD142, 0x88AF}, //13797 #CJK UNIFIED IDEOGRAPH
    {0xD143, 0x88B0}, //13798 #CJK UNIFIED IDEOGRAPH
    {0xD144, 0x88B2}, //13799 #CJK UNIFIED IDEOGRAPH
    {0xD145, 0x88B3}, //13800 #CJK UNIFIED IDEOGRAPH
    {0xD146, 0x88B4}, //13801 #CJK UNIFIED IDEOGRAPH
    {0xD147, 0x88B5}, //13802 #CJK UNIFIED IDEOGRAPH
    {0xD148, 0x88B6}, //13803 #CJK UNIFIED IDEOGRAPH
    {0xD149, 0x88B8}, //13804 #CJK UNIFIED IDEOGRAPH
    {0xD14A, 0x88B9}, //13805 #CJK UNIFIED IDEOGRAPH
    {0xD14B, 0x88BA}, //13806 #CJK UNIFIED IDEOGRAPH
    {0xD14C, 0x88BB}, //13807 #CJK UNIFIED IDEOGRAPH
    {0xD14D, 0x88BD}, //13808 #CJK UNIFIED IDEOGRAPH
    {0xD14E, 0x88BE}, //13809 #CJK UNIFIED IDEOGRAPH
    {0xD14F, 0x88BF}, //13810 #CJK UNIFIED IDEOGRAPH
    {0xD150, 0x88C0}, //13811 #CJK UNIFIED IDEOGRAPH
    {0xD151, 0x88C3}, //13812 #CJK UNIFIED IDEOGRAPH
    {0xD152, 0x88C4}, //13813 #CJK UNIFIED IDEOGRAPH
    {0xD153, 0x88C7}, //13814 #CJK UNIFIED IDEOGRAPH
    {0xD154, 0x88C8}, //13815 #CJK UNIFIED IDEOGRAPH
    {0xD155, 0x88CA}, //13816 #CJK UNIFIED IDEOGRAPH
    {0xD156, 0x88CB}, //13817 #CJK UNIFIED IDEOGRAPH
    {0xD157, 0x88CC}, //13818 #CJK UNIFIED IDEOGRAPH
    {0xD158, 0x88CD}, //13819 #CJK UNIFIED IDEOGRAPH
    {0xD159, 0x88CF}, //13820 #CJK UNIFIED IDEOGRAPH
    {0xD15A, 0x88D0}, //13821 #CJK UNIFIED IDEOGRAPH
    {0xD15B, 0x88D1}, //13822 #CJK UNIFIED IDEOGRAPH
    {0xD15C, 0x88D3}, //13823 #CJK UNIFIED IDEOGRAPH
    {0xD15D, 0x88D6}, //13824 #CJK UNIFIED IDEOGRAPH
    {0xD15E, 0x88D7}, //13825 #CJK UNIFIED IDEOGRAPH
    {0xD15F, 0x88DA}, //13826 #CJK UNIFIED IDEOGRAPH
    {0xD160, 0x88DB}, //13827 #CJK UNIFIED IDEOGRAPH
    {0xD161, 0x88DC}, //13828 #CJK UNIFIED IDEOGRAPH
    {0xD162, 0x88DD}, //13829 #CJK UNIFIED IDEOGRAPH
    {0xD163, 0x88DE}, //13830 #CJK UNIFIED IDEOGRAPH
    {0xD164, 0x88E0}, //13831 #CJK UNIFIED IDEOGRAPH
    {0xD165, 0x88E1}, //13832 #CJK UNIFIED IDEOGRAPH
    {0xD166, 0x88E6}, //13833 #CJK UNIFIED IDEOGRAPH
    {0xD167, 0x88E7}, //13834 #CJK UNIFIED IDEOGRAPH
    {0xD168, 0x88E9}, //13835 #CJK UNIFIED IDEOGRAPH
    {0xD169, 0x88EA}, //13836 #CJK UNIFIED IDEOGRAPH
    {0xD16A, 0x88EB}, //13837 #CJK UNIFIED IDEOGRAPH
    {0xD16B, 0x88EC}, //13838 #CJK UNIFIED IDEOGRAPH
    {0xD16C, 0x88ED}, //13839 #CJK UNIFIED IDEOGRAPH
    {0xD16D, 0x88EE}, //13840 #CJK UNIFIED IDEOGRAPH
    {0xD16E, 0x88EF}, //13841 #CJK UNIFIED IDEOGRAPH
    {0xD16F, 0x88F2}, //13842 #CJK UNIFIED IDEOGRAPH
    {0xD170, 0x88F5}, //13843 #CJK UNIFIED IDEOGRAPH
    {0xD171, 0x88F6}, //13844 #CJK UNIFIED IDEOGRAPH
    {0xD172, 0x88F7}, //13845 #CJK UNIFIED IDEOGRAPH
    {0xD173, 0x88FA}, //13846 #CJK UNIFIED IDEOGRAPH
    {0xD174, 0x88FB}, //13847 #CJK UNIFIED IDEOGRAPH
    {0xD175, 0x88FD}, //13848 #CJK UNIFIED IDEOGRAPH
    {0xD176, 0x88FF}, //13849 #CJK UNIFIED IDEOGRAPH
    {0xD177, 0x8900}, //13850 #CJK UNIFIED IDEOGRAPH
    {0xD178, 0x8901}, //13851 #CJK UNIFIED IDEOGRAPH
    {0xD179, 0x8903}, //13852 #CJK UNIFIED IDEOGRAPH
    {0xD17A, 0x8904}, //13853 #CJK UNIFIED IDEOGRAPH
    {0xD17B, 0x8905}, //13854 #CJK UNIFIED IDEOGRAPH
    {0xD17C, 0x8906}, //13855 #CJK UNIFIED IDEOGRAPH
    {0xD17D, 0x8907}, //13856 #CJK UNIFIED IDEOGRAPH
    {0xD17E, 0x8908}, //13857 #CJK UNIFIED IDEOGRAPH
    {0xD180, 0x8909}, //13858 #CJK UNIFIED IDEOGRAPH
    {0xD181, 0x890B}, //13859 #CJK UNIFIED IDEOGRAPH
    {0xD182, 0x890C}, //13860 #CJK UNIFIED IDEOGRAPH
    {0xD183, 0x890D}, //13861 #CJK UNIFIED IDEOGRAPH
    {0xD184, 0x890E}, //13862 #CJK UNIFIED IDEOGRAPH
    {0xD185, 0x890F}, //13863 #CJK UNIFIED IDEOGRAPH
    {0xD186, 0x8911}, //13864 #CJK UNIFIED IDEOGRAPH
    {0xD187, 0x8914}, //13865 #CJK UNIFIED IDEOGRAPH
    {0xD188, 0x8915}, //13866 #CJK UNIFIED IDEOGRAPH
    {0xD189, 0x8916}, //13867 #CJK UNIFIED IDEOGRAPH
    {0xD18A, 0x8917}, //13868 #CJK UNIFIED IDEOGRAPH
    {0xD18B, 0x8918}, //13869 #CJK UNIFIED IDEOGRAPH
    {0xD18C, 0x891C}, //13870 #CJK UNIFIED IDEOGRAPH
    {0xD18D, 0x891D}, //13871 #CJK UNIFIED IDEOGRAPH
    {0xD18E, 0x891E}, //13872 #CJK UNIFIED IDEOGRAPH
    {0xD18F, 0x891F}, //13873 #CJK UNIFIED IDEOGRAPH
    {0xD190, 0x8920}, //13874 #CJK UNIFIED IDEOGRAPH
    {0xD191, 0x8922}, //13875 #CJK UNIFIED IDEOGRAPH
    {0xD192, 0x8923}, //13876 #CJK UNIFIED IDEOGRAPH
    {0xD193, 0x8924}, //13877 #CJK UNIFIED IDEOGRAPH
    {0xD194, 0x8926}, //13878 #CJK UNIFIED IDEOGRAPH
    {0xD195, 0x8927}, //13879 #CJK UNIFIED IDEOGRAPH
    {0xD196, 0x8928}, //13880 #CJK UNIFIED IDEOGRAPH
    {0xD197, 0x8929}, //13881 #CJK UNIFIED IDEOGRAPH
    {0xD198, 0x892C}, //13882 #CJK UNIFIED IDEOGRAPH
    {0xD199, 0x892D}, //13883 #CJK UNIFIED IDEOGRAPH
    {0xD19A, 0x892E}, //13884 #CJK UNIFIED IDEOGRAPH
    {0xD19B, 0x892F}, //13885 #CJK UNIFIED IDEOGRAPH
    {0xD19C, 0x8931}, //13886 #CJK UNIFIED IDEOGRAPH
    {0xD19D, 0x8932}, //13887 #CJK UNIFIED IDEOGRAPH
    {0xD19E, 0x8933}, //13888 #CJK UNIFIED IDEOGRAPH
    {0xD19F, 0x8935}, //13889 #CJK UNIFIED IDEOGRAPH
    {0xD1A0, 0x8937}, //13890 #CJK UNIFIED IDEOGRAPH
    {0xD1A1, 0x9009}, //13891 #CJK UNIFIED IDEOGRAPH
    {0xD1A2, 0x7663}, //13892 #CJK UNIFIED IDEOGRAPH
    {0xD1A3, 0x7729}, //13893 #CJK UNIFIED IDEOGRAPH
    {0xD1A4, 0x7EDA}, //13894 #CJK UNIFIED IDEOGRAPH
    {0xD1A5, 0x9774}, //13895 #CJK UNIFIED IDEOGRAPH
    {0xD1A6, 0x859B}, //13896 #CJK UNIFIED IDEOGRAPH
    {0xD1A7, 0x5B66}, //13897 #CJK UNIFIED IDEOGRAPH
    {0xD1A8, 0x7A74}, //13898 #CJK UNIFIED IDEOGRAPH
    {0xD1A9, 0x96EA}, //13899 #CJK UNIFIED IDEOGRAPH
    {0xD1AA, 0x8840}, //13900 #CJK UNIFIED IDEOGRAPH
    {0xD1AB, 0x52CB}, //13901 #CJK UNIFIED IDEOGRAPH
    {0xD1AC, 0x718F}, //13902 #CJK UNIFIED IDEOGRAPH
    {0xD1AD, 0x5FAA}, //13903 #CJK UNIFIED IDEOGRAPH
    {0xD1AE, 0x65EC}, //13904 #CJK UNIFIED IDEOGRAPH
    {0xD1AF, 0x8BE2}, //13905 #CJK UNIFIED IDEOGRAPH
    {0xD1B0, 0x5BFB}, //13906 #CJK UNIFIED IDEOGRAPH
    {0xD1B1, 0x9A6F}, //13907 #CJK UNIFIED IDEOGRAPH
    {0xD1B2, 0x5DE1}, //13908 #CJK UNIFIED IDEOGRAPH
    {0xD1B3, 0x6B89}, //13909 #CJK UNIFIED IDEOGRAPH
    {0xD1B4, 0x6C5B}, //13910 #CJK UNIFIED IDEOGRAPH
    {0xD1B5, 0x8BAD}, //13911 #CJK UNIFIED IDEOGRAPH
    {0xD1B6, 0x8BAF}, //13912 #CJK UNIFIED IDEOGRAPH
    {0xD1B7, 0x900A}, //13913 #CJK UNIFIED IDEOGRAPH
    {0xD1B8, 0x8FC5}, //13914 #CJK UNIFIED IDEOGRAPH
    {0xD1B9, 0x538B}, //13915 #CJK UNIFIED IDEOGRAPH
    {0xD1BA, 0x62BC}, //13916 #CJK UNIFIED IDEOGRAPH
    {0xD1BB, 0x9E26}, //13917 #CJK UNIFIED IDEOGRAPH
    {0xD1BC, 0x9E2D}, //13918 #CJK UNIFIED IDEOGRAPH
    {0xD1BD, 0x5440}, //13919 #CJK UNIFIED IDEOGRAPH
    {0xD1BE, 0x4E2B}, //13920 #CJK UNIFIED IDEOGRAPH
    {0xD1BF, 0x82BD}, //13921 #CJK UNIFIED IDEOGRAPH
    {0xD1C0, 0x7259}, //13922 #CJK UNIFIED IDEOGRAPH
    {0xD1C1, 0x869C}, //13923 #CJK UNIFIED IDEOGRAPH
    {0xD1C2, 0x5D16}, //13924 #CJK UNIFIED IDEOGRAPH
    {0xD1C3, 0x8859}, //13925 #CJK UNIFIED IDEOGRAPH
    {0xD1C4, 0x6DAF}, //13926 #CJK UNIFIED IDEOGRAPH
    {0xD1C5, 0x96C5}, //13927 #CJK UNIFIED IDEOGRAPH
    {0xD1C6, 0x54D1}, //13928 #CJK UNIFIED IDEOGRAPH
    {0xD1C7, 0x4E9A}, //13929 #CJK UNIFIED IDEOGRAPH
    {0xD1C8, 0x8BB6}, //13930 #CJK UNIFIED IDEOGRAPH
    {0xD1C9, 0x7109}, //13931 #CJK UNIFIED IDEOGRAPH
    {0xD1CA, 0x54BD}, //13932 #CJK UNIFIED IDEOGRAPH
    {0xD1CB, 0x9609}, //13933 #CJK UNIFIED IDEOGRAPH
    {0xD1CC, 0x70DF}, //13934 #CJK UNIFIED IDEOGRAPH
    {0xD1CD, 0x6DF9}, //13935 #CJK UNIFIED IDEOGRAPH
    {0xD1CE, 0x76D0}, //13936 #CJK UNIFIED IDEOGRAPH
    {0xD1CF, 0x4E25}, //13937 #CJK UNIFIED IDEOGRAPH
    {0xD1D0, 0x7814}, //13938 #CJK UNIFIED IDEOGRAPH
    {0xD1D1, 0x8712}, //13939 #CJK UNIFIED IDEOGRAPH
    {0xD1D2, 0x5CA9}, //13940 #CJK UNIFIED IDEOGRAPH
    {0xD1D3, 0x5EF6}, //13941 #CJK UNIFIED IDEOGRAPH
    {0xD1D4, 0x8A00}, //13942 #CJK UNIFIED IDEOGRAPH
    {0xD1D5, 0x989C}, //13943 #CJK UNIFIED IDEOGRAPH
    {0xD1D6, 0x960E}, //13944 #CJK UNIFIED IDEOGRAPH
    {0xD1D7, 0x708E}, //13945 #CJK UNIFIED IDEOGRAPH
    {0xD1D8, 0x6CBF}, //13946 #CJK UNIFIED IDEOGRAPH
    {0xD1D9, 0x5944}, //13947 #CJK UNIFIED IDEOGRAPH
    {0xD1DA, 0x63A9}, //13948 #CJK UNIFIED IDEOGRAPH
    {0xD1DB, 0x773C}, //13949 #CJK UNIFIED IDEOGRAPH
    {0xD1DC, 0x884D}, //13950 #CJK UNIFIED IDEOGRAPH
    {0xD1DD, 0x6F14}, //13951 #CJK UNIFIED IDEOGRAPH
    {0xD1DE, 0x8273}, //13952 #CJK UNIFIED IDEOGRAPH
    {0xD1DF, 0x5830}, //13953 #CJK UNIFIED IDEOGRAPH
    {0xD1E0, 0x71D5}, //13954 #CJK UNIFIED IDEOGRAPH
    {0xD1E1, 0x538C}, //13955 #CJK UNIFIED IDEOGRAPH
    {0xD1E2, 0x781A}, //13956 #CJK UNIFIED IDEOGRAPH
    {0xD1E3, 0x96C1}, //13957 #CJK UNIFIED IDEOGRAPH
    {0xD1E4, 0x5501}, //13958 #CJK UNIFIED IDEOGRAPH
    {0xD1E5, 0x5F66}, //13959 #CJK UNIFIED IDEOGRAPH
    {0xD1E6, 0x7130}, //13960 #CJK UNIFIED IDEOGRAPH
    {0xD1E7, 0x5BB4}, //13961 #CJK UNIFIED IDEOGRAPH
    {0xD1E8, 0x8C1A}, //13962 #CJK UNIFIED IDEOGRAPH
    {0xD1E9, 0x9A8C}, //13963 #CJK UNIFIED IDEOGRAPH
    {0xD1EA, 0x6B83}, //13964 #CJK UNIFIED IDEOGRAPH
    {0xD1EB, 0x592E}, //13965 #CJK UNIFIED IDEOGRAPH
    {0xD1EC, 0x9E2F}, //13966 #CJK UNIFIED IDEOGRAPH
    {0xD1ED, 0x79E7}, //13967 #CJK UNIFIED IDEOGRAPH
    {0xD1EE, 0x6768}, //13968 #CJK UNIFIED IDEOGRAPH
    {0xD1EF, 0x626C}, //13969 #CJK UNIFIED IDEOGRAPH
    {0xD1F0, 0x4F6F}, //13970 #CJK UNIFIED IDEOGRAPH
    {0xD1F1, 0x75A1}, //13971 #CJK UNIFIED IDEOGRAPH
    {0xD1F2, 0x7F8A}, //13972 #CJK UNIFIED IDEOGRAPH
    {0xD1F3, 0x6D0B}, //13973 #CJK UNIFIED IDEOGRAPH
    {0xD1F4, 0x9633}, //13974 #CJK UNIFIED IDEOGRAPH
    {0xD1F5, 0x6C27}, //13975 #CJK UNIFIED IDEOGRAPH
    {0xD1F6, 0x4EF0}, //13976 #CJK UNIFIED IDEOGRAPH
    {0xD1F7, 0x75D2}, //13977 #CJK UNIFIED IDEOGRAPH
    {0xD1F8, 0x517B}, //13978 #CJK UNIFIED IDEOGRAPH
    {0xD1F9, 0x6837}, //13979 #CJK UNIFIED IDEOGRAPH
    {0xD1FA, 0x6F3E}, //13980 #CJK UNIFIED IDEOGRAPH
    {0xD1FB, 0x9080}, //13981 #CJK UNIFIED IDEOGRAPH
    {0xD1FC, 0x8170}, //13982 #CJK UNIFIED IDEOGRAPH
    {0xD1FD, 0x5996}, //13983 #CJK UNIFIED IDEOGRAPH
    {0xD1FE, 0x7476}, //13984 #CJK UNIFIED IDEOGRAPH
    {0xD240, 0x8938}, //13985 #CJK UNIFIED IDEOGRAPH
    {0xD241, 0x8939}, //13986 #CJK UNIFIED IDEOGRAPH
    {0xD242, 0x893A}, //13987 #CJK UNIFIED IDEOGRAPH
    {0xD243, 0x893B}, //13988 #CJK UNIFIED IDEOGRAPH
    {0xD244, 0x893C}, //13989 #CJK UNIFIED IDEOGRAPH
    {0xD245, 0x893D}, //13990 #CJK UNIFIED IDEOGRAPH
    {0xD246, 0x893E}, //13991 #CJK UNIFIED IDEOGRAPH
    {0xD247, 0x893F}, //13992 #CJK UNIFIED IDEOGRAPH
    {0xD248, 0x8940}, //13993 #CJK UNIFIED IDEOGRAPH
    {0xD249, 0x8942}, //13994 #CJK UNIFIED IDEOGRAPH
    {0xD24A, 0x8943}, //13995 #CJK UNIFIED IDEOGRAPH
    {0xD24B, 0x8945}, //13996 #CJK UNIFIED IDEOGRAPH
    {0xD24C, 0x8946}, //13997 #CJK UNIFIED IDEOGRAPH
    {0xD24D, 0x8947}, //13998 #CJK UNIFIED IDEOGRAPH
    {0xD24E, 0x8948}, //13999 #CJK UNIFIED IDEOGRAPH
    {0xD24F, 0x8949}, //14000 #CJK UNIFIED IDEOGRAPH
    {0xD250, 0x894A}, //14001 #CJK UNIFIED IDEOGRAPH
    {0xD251, 0x894B}, //14002 #CJK UNIFIED IDEOGRAPH
    {0xD252, 0x894C}, //14003 #CJK UNIFIED IDEOGRAPH
    {0xD253, 0x894D}, //14004 #CJK UNIFIED IDEOGRAPH
    {0xD254, 0x894E}, //14005 #CJK UNIFIED IDEOGRAPH
    {0xD255, 0x894F}, //14006 #CJK UNIFIED IDEOGRAPH
    {0xD256, 0x8950}, //14007 #CJK UNIFIED IDEOGRAPH
    {0xD257, 0x8951}, //14008 #CJK UNIFIED IDEOGRAPH
    {0xD258, 0x8952}, //14009 #CJK UNIFIED IDEOGRAPH
    {0xD259, 0x8953}, //14010 #CJK UNIFIED IDEOGRAPH
    {0xD25A, 0x8954}, //14011 #CJK UNIFIED IDEOGRAPH
    {0xD25B, 0x8955}, //14012 #CJK UNIFIED IDEOGRAPH
    {0xD25C, 0x8956}, //14013 #CJK UNIFIED IDEOGRAPH
    {0xD25D, 0x8957}, //14014 #CJK UNIFIED IDEOGRAPH
    {0xD25E, 0x8958}, //14015 #CJK UNIFIED IDEOGRAPH
    {0xD25F, 0x8959}, //14016 #CJK UNIFIED IDEOGRAPH
    {0xD260, 0x895A}, //14017 #CJK UNIFIED IDEOGRAPH
    {0xD261, 0x895B}, //14018 #CJK UNIFIED IDEOGRAPH
    {0xD262, 0x895C}, //14019 #CJK UNIFIED IDEOGRAPH
    {0xD263, 0x895D}, //14020 #CJK UNIFIED IDEOGRAPH
    {0xD264, 0x8960}, //14021 #CJK UNIFIED IDEOGRAPH
    {0xD265, 0x8961}, //14022 #CJK UNIFIED IDEOGRAPH
    {0xD266, 0x8962}, //14023 #CJK UNIFIED IDEOGRAPH
    {0xD267, 0x8963}, //14024 #CJK UNIFIED IDEOGRAPH
    {0xD268, 0x8964}, //14025 #CJK UNIFIED IDEOGRAPH
    {0xD269, 0x8965}, //14026 #CJK UNIFIED IDEOGRAPH
    {0xD26A, 0x8967}, //14027 #CJK UNIFIED IDEOGRAPH
    {0xD26B, 0x8968}, //14028 #CJK UNIFIED IDEOGRAPH
    {0xD26C, 0x8969}, //14029 #CJK UNIFIED IDEOGRAPH
    {0xD26D, 0x896A}, //14030 #CJK UNIFIED IDEOGRAPH
    {0xD26E, 0x896B}, //14031 #CJK UNIFIED IDEOGRAPH
    {0xD26F, 0x896C}, //14032 #CJK UNIFIED IDEOGRAPH
    {0xD270, 0x896D}, //14033 #CJK UNIFIED IDEOGRAPH
    {0xD271, 0x896E}, //14034 #CJK UNIFIED IDEOGRAPH
    {0xD272, 0x896F}, //14035 #CJK UNIFIED IDEOGRAPH
    {0xD273, 0x8970}, //14036 #CJK UNIFIED IDEOGRAPH
    {0xD274, 0x8971}, //14037 #CJK UNIFIED IDEOGRAPH
    {0xD275, 0x8972}, //14038 #CJK UNIFIED IDEOGRAPH
    {0xD276, 0x8973}, //14039 #CJK UNIFIED IDEOGRAPH
    {0xD277, 0x8974}, //14040 #CJK UNIFIED IDEOGRAPH
    {0xD278, 0x8975}, //14041 #CJK UNIFIED IDEOGRAPH
    {0xD279, 0x8976}, //14042 #CJK UNIFIED IDEOGRAPH
    {0xD27A, 0x8977}, //14043 #CJK UNIFIED IDEOGRAPH
    {0xD27B, 0x8978}, //14044 #CJK UNIFIED IDEOGRAPH
    {0xD27C, 0x8979}, //14045 #CJK UNIFIED IDEOGRAPH
    {0xD27D, 0x897A}, //14046 #CJK UNIFIED IDEOGRAPH
    {0xD27E, 0x897C}, //14047 #CJK UNIFIED IDEOGRAPH
    {0xD280, 0x897D}, //14048 #CJK UNIFIED IDEOGRAPH
    {0xD281, 0x897E}, //14049 #CJK UNIFIED IDEOGRAPH
    {0xD282, 0x8980}, //14050 #CJK UNIFIED IDEOGRAPH
    {0xD283, 0x8982}, //14051 #CJK UNIFIED IDEOGRAPH
    {0xD284, 0x8984}, //14052 #CJK UNIFIED IDEOGRAPH
    {0xD285, 0x8985}, //14053 #CJK UNIFIED IDEOGRAPH
    {0xD286, 0x8987}, //14054 #CJK UNIFIED IDEOGRAPH
    {0xD287, 0x8988}, //14055 #CJK UNIFIED IDEOGRAPH
    {0xD288, 0x8989}, //14056 #CJK UNIFIED IDEOGRAPH
    {0xD289, 0x898A}, //14057 #CJK UNIFIED IDEOGRAPH
    {0xD28A, 0x898B}, //14058 #CJK UNIFIED IDEOGRAPH
    {0xD28B, 0x898C}, //14059 #CJK UNIFIED IDEOGRAPH
    {0xD28C, 0x898D}, //14060 #CJK UNIFIED IDEOGRAPH
    {0xD28D, 0x898E}, //14061 #CJK UNIFIED IDEOGRAPH
    {0xD28E, 0x898F}, //14062 #CJK UNIFIED IDEOGRAPH
    {0xD28F, 0x8990}, //14063 #CJK UNIFIED IDEOGRAPH
    {0xD290, 0x8991}, //14064 #CJK UNIFIED IDEOGRAPH
    {0xD291, 0x8992}, //14065 #CJK UNIFIED IDEOGRAPH
    {0xD292, 0x8993}, //14066 #CJK UNIFIED IDEOGRAPH
    {0xD293, 0x8994}, //14067 #CJK UNIFIED IDEOGRAPH
    {0xD294, 0x8995}, //14068 #CJK UNIFIED IDEOGRAPH
    {0xD295, 0x8996}, //14069 #CJK UNIFIED IDEOGRAPH
    {0xD296, 0x8997}, //14070 #CJK UNIFIED IDEOGRAPH
    {0xD297, 0x8998}, //14071 #CJK UNIFIED IDEOGRAPH
    {0xD298, 0x8999}, //14072 #CJK UNIFIED IDEOGRAPH
    {0xD299, 0x899A}, //14073 #CJK UNIFIED IDEOGRAPH
    {0xD29A, 0x899B}, //14074 #CJK UNIFIED IDEOGRAPH
    {0xD29B, 0x899C}, //14075 #CJK UNIFIED IDEOGRAPH
    {0xD29C, 0x899D}, //14076 #CJK UNIFIED IDEOGRAPH
    {0xD29D, 0x899E}, //14077 #CJK UNIFIED IDEOGRAPH
    {0xD29E, 0x899F}, //14078 #CJK UNIFIED IDEOGRAPH
    {0xD29F, 0x89A0}, //14079 #CJK UNIFIED IDEOGRAPH
    {0xD2A0, 0x89A1}, //14080 #CJK UNIFIED IDEOGRAPH
    {0xD2A1, 0x6447}, //14081 #CJK UNIFIED IDEOGRAPH
    {0xD2A2, 0x5C27}, //14082 #CJK UNIFIED IDEOGRAPH
    {0xD2A3, 0x9065}, //14083 #CJK UNIFIED IDEOGRAPH
    {0xD2A4, 0x7A91}, //14084 #CJK UNIFIED IDEOGRAPH
    {0xD2A5, 0x8C23}, //14085 #CJK UNIFIED IDEOGRAPH
    {0xD2A6, 0x59DA}, //14086 #CJK UNIFIED IDEOGRAPH
    {0xD2A7, 0x54AC}, //14087 #CJK UNIFIED IDEOGRAPH
    {0xD2A8, 0x8200}, //14088 #CJK UNIFIED IDEOGRAPH
    {0xD2A9, 0x836F}, //14089 #CJK UNIFIED IDEOGRAPH
    {0xD2AA, 0x8981}, //14090 #CJK UNIFIED IDEOGRAPH
    {0xD2AB, 0x8000}, //14091 #CJK UNIFIED IDEOGRAPH
    {0xD2AC, 0x6930}, //14092 #CJK UNIFIED IDEOGRAPH
    {0xD2AD, 0x564E}, //14093 #CJK UNIFIED IDEOGRAPH
    {0xD2AE, 0x8036}, //14094 #CJK UNIFIED IDEOGRAPH
    {0xD2AF, 0x7237}, //14095 #CJK UNIFIED IDEOGRAPH
    {0xD2B0, 0x91CE}, //14096 #CJK UNIFIED IDEOGRAPH
    {0xD2B1, 0x51B6}, //14097 #CJK UNIFIED IDEOGRAPH
    {0xD2B2, 0x4E5F}, //14098 #CJK UNIFIED IDEOGRAPH
    {0xD2B3, 0x9875}, //14099 #CJK UNIFIED IDEOGRAPH
    {0xD2B4, 0x6396}, //14100 #CJK UNIFIED IDEOGRAPH
    {0xD2B5, 0x4E1A}, //14101 #CJK UNIFIED IDEOGRAPH
    {0xD2B6, 0x53F6}, //14102 #CJK UNIFIED IDEOGRAPH
    {0xD2B7, 0x66F3}, //14103 #CJK UNIFIED IDEOGRAPH
    {0xD2B8, 0x814B}, //14104 #CJK UNIFIED IDEOGRAPH
    {0xD2B9, 0x591C}, //14105 #CJK UNIFIED IDEOGRAPH
    {0xD2BA, 0x6DB2}, //14106 #CJK UNIFIED IDEOGRAPH
    {0xD2BB, 0x4E00}, //14107 #CJK UNIFIED IDEOGRAPH
    {0xD2BC, 0x58F9}, //14108 #CJK UNIFIED IDEOGRAPH
    {0xD2BD, 0x533B}, //14109 #CJK UNIFIED IDEOGRAPH
    {0xD2BE, 0x63D6}, //14110 #CJK UNIFIED IDEOGRAPH
    {0xD2BF, 0x94F1}, //14111 #CJK UNIFIED IDEOGRAPH
    {0xD2C0, 0x4F9D}, //14112 #CJK UNIFIED IDEOGRAPH
    {0xD2C1, 0x4F0A}, //14113 #CJK UNIFIED IDEOGRAPH
    {0xD2C2, 0x8863}, //14114 #CJK UNIFIED IDEOGRAPH
    {0xD2C3, 0x9890}, //14115 #CJK UNIFIED IDEOGRAPH
    {0xD2C4, 0x5937}, //14116 #CJK UNIFIED IDEOGRAPH
    {0xD2C5, 0x9057}, //14117 #CJK UNIFIED IDEOGRAPH
    {0xD2C6, 0x79FB}, //14118 #CJK UNIFIED IDEOGRAPH
    {0xD2C7, 0x4EEA}, //14119 #CJK UNIFIED IDEOGRAPH
    {0xD2C8, 0x80F0}, //14120 #CJK UNIFIED IDEOGRAPH
    {0xD2C9, 0x7591}, //14121 #CJK UNIFIED IDEOGRAPH
    {0xD2CA, 0x6C82}, //14122 #CJK UNIFIED IDEOGRAPH
    {0xD2CB, 0x5B9C}, //14123 #CJK UNIFIED IDEOGRAPH
    {0xD2CC, 0x59E8}, //14124 #CJK UNIFIED IDEOGRAPH
    {0xD2CD, 0x5F5D}, //14125 #CJK UNIFIED IDEOGRAPH
    {0xD2CE, 0x6905}, //14126 #CJK UNIFIED IDEOGRAPH
    {0xD2CF, 0x8681}, //14127 #CJK UNIFIED IDEOGRAPH
    {0xD2D0, 0x501A}, //14128 #CJK UNIFIED IDEOGRAPH
    {0xD2D1, 0x5DF2}, //14129 #CJK UNIFIED IDEOGRAPH
    {0xD2D2, 0x4E59}, //14130 #CJK UNIFIED IDEOGRAPH
    {0xD2D3, 0x77E3}, //14131 #CJK UNIFIED IDEOGRAPH
    {0xD2D4, 0x4EE5}, //14132 #CJK UNIFIED IDEOGRAPH
    {0xD2D5, 0x827A}, //14133 #CJK UNIFIED IDEOGRAPH
    {0xD2D6, 0x6291}, //14134 #CJK UNIFIED IDEOGRAPH
    {0xD2D7, 0x6613}, //14135 #CJK UNIFIED IDEOGRAPH
    {0xD2D8, 0x9091}, //14136 #CJK UNIFIED IDEOGRAPH
    {0xD2D9, 0x5C79}, //14137 #CJK UNIFIED IDEOGRAPH
    {0xD2DA, 0x4EBF}, //14138 #CJK UNIFIED IDEOGRAPH
    {0xD2DB, 0x5F79}, //14139 #CJK UNIFIED IDEOGRAPH
    {0xD2DC, 0x81C6}, //14140 #CJK UNIFIED IDEOGRAPH
    {0xD2DD, 0x9038}, //14141 #CJK UNIFIED IDEOGRAPH
    {0xD2DE, 0x8084}, //14142 #CJK UNIFIED IDEOGRAPH
    {0xD2DF, 0x75AB}, //14143 #CJK UNIFIED IDEOGRAPH
    {0xD2E0, 0x4EA6}, //14144 #CJK UNIFIED IDEOGRAPH
    {0xD2E1, 0x88D4}, //14145 #CJK UNIFIED IDEOGRAPH
    {0xD2E2, 0x610F}, //14146 #CJK UNIFIED IDEOGRAPH
    {0xD2E3, 0x6BC5}, //14147 #CJK UNIFIED IDEOGRAPH
    {0xD2E4, 0x5FC6}, //14148 #CJK UNIFIED IDEOGRAPH
    {0xD2E5, 0x4E49}, //14149 #CJK UNIFIED IDEOGRAPH
    {0xD2E6, 0x76CA}, //14150 #CJK UNIFIED IDEOGRAPH
    {0xD2E7, 0x6EA2}, //14151 #CJK UNIFIED IDEOGRAPH
    {0xD2E8, 0x8BE3}, //14152 #CJK UNIFIED IDEOGRAPH
    {0xD2E9, 0x8BAE}, //14153 #CJK UNIFIED IDEOGRAPH
    {0xD2EA, 0x8C0A}, //14154 #CJK UNIFIED IDEOGRAPH
    {0xD2EB, 0x8BD1}, //14155 #CJK UNIFIED IDEOGRAPH
    {0xD2EC, 0x5F02}, //14156 #CJK UNIFIED IDEOGRAPH
    {0xD2ED, 0x7FFC}, //14157 #CJK UNIFIED IDEOGRAPH
    {0xD2EE, 0x7FCC}, //14158 #CJK UNIFIED IDEOGRAPH
    {0xD2EF, 0x7ECE}, //14159 #CJK UNIFIED IDEOGRAPH
    {0xD2F0, 0x8335}, //14160 #CJK UNIFIED IDEOGRAPH
    {0xD2F1, 0x836B}, //14161 #CJK UNIFIED IDEOGRAPH
    {0xD2F2, 0x56E0}, //14162 #CJK UNIFIED IDEOGRAPH
    {0xD2F3, 0x6BB7}, //14163 #CJK UNIFIED IDEOGRAPH
    {0xD2F4, 0x97F3}, //14164 #CJK UNIFIED IDEOGRAPH
    {0xD2F5, 0x9634}, //14165 #CJK UNIFIED IDEOGRAPH
    {0xD2F6, 0x59FB}, //14166 #CJK UNIFIED IDEOGRAPH
    {0xD2F7, 0x541F}, //14167 #CJK UNIFIED IDEOGRAPH
    {0xD2F8, 0x94F6}, //14168 #CJK UNIFIED IDEOGRAPH
    {0xD2F9, 0x6DEB}, //14169 #CJK UNIFIED IDEOGRAPH
    {0xD2FA, 0x5BC5}, //14170 #CJK UNIFIED IDEOGRAPH
    {0xD2FB, 0x996E}, //14171 #CJK UNIFIED IDEOGRAPH
    {0xD2FC, 0x5C39}, //14172 #CJK UNIFIED IDEOGRAPH
    {0xD2FD, 0x5F15}, //14173 #CJK UNIFIED IDEOGRAPH
    {0xD2FE, 0x9690}, //14174 #CJK UNIFIED IDEOGRAPH
    {0xD340, 0x89A2}, //14175 #CJK UNIFIED IDEOGRAPH
    {0xD341, 0x89A3}, //14176 #CJK UNIFIED IDEOGRAPH
    {0xD342, 0x89A4}, //14177 #CJK UNIFIED IDEOGRAPH
    {0xD343, 0x89A5}, //14178 #CJK UNIFIED IDEOGRAPH
    {0xD344, 0x89A6}, //14179 #CJK UNIFIED IDEOGRAPH
    {0xD345, 0x89A7}, //14180 #CJK UNIFIED IDEOGRAPH
    {0xD346, 0x89A8}, //14181 #CJK UNIFIED IDEOGRAPH
    {0xD347, 0x89A9}, //14182 #CJK UNIFIED IDEOGRAPH
    {0xD348, 0x89AA}, //14183 #CJK UNIFIED IDEOGRAPH
    {0xD349, 0x89AB}, //14184 #CJK UNIFIED IDEOGRAPH
    {0xD34A, 0x89AC}, //14185 #CJK UNIFIED IDEOGRAPH
    {0xD34B, 0x89AD}, //14186 #CJK UNIFIED IDEOGRAPH
    {0xD34C, 0x89AE}, //14187 #CJK UNIFIED IDEOGRAPH
    {0xD34D, 0x89AF}, //14188 #CJK UNIFIED IDEOGRAPH
    {0xD34E, 0x89B0}, //14189 #CJK UNIFIED IDEOGRAPH
    {0xD34F, 0x89B1}, //14190 #CJK UNIFIED IDEOGRAPH
    {0xD350, 0x89B2}, //14191 #CJK UNIFIED IDEOGRAPH
    {0xD351, 0x89B3}, //14192 #CJK UNIFIED IDEOGRAPH
    {0xD352, 0x89B4}, //14193 #CJK UNIFIED IDEOGRAPH
    {0xD353, 0x89B5}, //14194 #CJK UNIFIED IDEOGRAPH
    {0xD354, 0x89B6}, //14195 #CJK UNIFIED IDEOGRAPH
    {0xD355, 0x89B7}, //14196 #CJK UNIFIED IDEOGRAPH
    {0xD356, 0x89B8}, //14197 #CJK UNIFIED IDEOGRAPH
    {0xD357, 0x89B9}, //14198 #CJK UNIFIED IDEOGRAPH
    {0xD358, 0x89BA}, //14199 #CJK UNIFIED IDEOGRAPH
    {0xD359, 0x89BB}, //14200 #CJK UNIFIED IDEOGRAPH
    {0xD35A, 0x89BC}, //14201 #CJK UNIFIED IDEOGRAPH
    {0xD35B, 0x89BD}, //14202 #CJK UNIFIED IDEOGRAPH
    {0xD35C, 0x89BE}, //14203 #CJK UNIFIED IDEOGRAPH
    {0xD35D, 0x89BF}, //14204 #CJK UNIFIED IDEOGRAPH
    {0xD35E, 0x89C0}, //14205 #CJK UNIFIED IDEOGRAPH
    {0xD35F, 0x89C3}, //14206 #CJK UNIFIED IDEOGRAPH
    {0xD360, 0x89CD}, //14207 #CJK UNIFIED IDEOGRAPH
    {0xD361, 0x89D3}, //14208 #CJK UNIFIED IDEOGRAPH
    {0xD362, 0x89D4}, //14209 #CJK UNIFIED IDEOGRAPH
    {0xD363, 0x89D5}, //14210 #CJK UNIFIED IDEOGRAPH
    {0xD364, 0x89D7}, //14211 #CJK UNIFIED IDEOGRAPH
    {0xD365, 0x89D8}, //14212 #CJK UNIFIED IDEOGRAPH
    {0xD366, 0x89D9}, //14213 #CJK UNIFIED IDEOGRAPH
    {0xD367, 0x89DB}, //14214 #CJK UNIFIED IDEOGRAPH
    {0xD368, 0x89DD}, //14215 #CJK UNIFIED IDEOGRAPH
    {0xD369, 0x89DF}, //14216 #CJK UNIFIED IDEOGRAPH
    {0xD36A, 0x89E0}, //14217 #CJK UNIFIED IDEOGRAPH
    {0xD36B, 0x89E1}, //14218 #CJK UNIFIED IDEOGRAPH
    {0xD36C, 0x89E2}, //14219 #CJK UNIFIED IDEOGRAPH
    {0xD36D, 0x89E4}, //14220 #CJK UNIFIED IDEOGRAPH
    {0xD36E, 0x89E7}, //14221 #CJK UNIFIED IDEOGRAPH
    {0xD36F, 0x89E8}, //14222 #CJK UNIFIED IDEOGRAPH
    {0xD370, 0x89E9}, //14223 #CJK UNIFIED IDEOGRAPH
    {0xD371, 0x89EA}, //14224 #CJK UNIFIED IDEOGRAPH
    {0xD372, 0x89EC}, //14225 #CJK UNIFIED IDEOGRAPH
    {0xD373, 0x89ED}, //14226 #CJK UNIFIED IDEOGRAPH
    {0xD374, 0x89EE}, //14227 #CJK UNIFIED IDEOGRAPH
    {0xD375, 0x89F0}, //14228 #CJK UNIFIED IDEOGRAPH
    {0xD376, 0x89F1}, //14229 #CJK UNIFIED IDEOGRAPH
    {0xD377, 0x89F2}, //14230 #CJK UNIFIED IDEOGRAPH
    {0xD378, 0x89F4}, //14231 #CJK UNIFIED IDEOGRAPH
    {0xD379, 0x89F5}, //14232 #CJK UNIFIED IDEOGRAPH
    {0xD37A, 0x89F6}, //14233 #CJK UNIFIED IDEOGRAPH
    {0xD37B, 0x89F7}, //14234 #CJK UNIFIED IDEOGRAPH
    {0xD37C, 0x89F8}, //14235 #CJK UNIFIED IDEOGRAPH
    {0xD37D, 0x89F9}, //14236 #CJK UNIFIED IDEOGRAPH
    {0xD37E, 0x89FA}, //14237 #CJK UNIFIED IDEOGRAPH
    {0xD380, 0x89FB}, //14238 #CJK UNIFIED IDEOGRAPH
    {0xD381, 0x89FC}, //14239 #CJK UNIFIED IDEOGRAPH
    {0xD382, 0x89FD}, //14240 #CJK UNIFIED IDEOGRAPH
    {0xD383, 0x89FE}, //14241 #CJK UNIFIED IDEOGRAPH
    {0xD384, 0x89FF}, //14242 #CJK UNIFIED IDEOGRAPH
    {0xD385, 0x8A01}, //14243 #CJK UNIFIED IDEOGRAPH
    {0xD386, 0x8A02}, //14244 #CJK UNIFIED IDEOGRAPH
    {0xD387, 0x8A03}, //14245 #CJK UNIFIED IDEOGRAPH
    {0xD388, 0x8A04}, //14246 #CJK UNIFIED IDEOGRAPH
    {0xD389, 0x8A05}, //14247 #CJK UNIFIED IDEOGRAPH
    {0xD38A, 0x8A06}, //14248 #CJK UNIFIED IDEOGRAPH
    {0xD38B, 0x8A08}, //14249 #CJK UNIFIED IDEOGRAPH
    {0xD38C, 0x8A09}, //14250 #CJK UNIFIED IDEOGRAPH
    {0xD38D, 0x8A0A}, //14251 #CJK UNIFIED IDEOGRAPH
    {0xD38E, 0x8A0B}, //14252 #CJK UNIFIED IDEOGRAPH
    {0xD38F, 0x8A0C}, //14253 #CJK UNIFIED IDEOGRAPH
    {0xD390, 0x8A0D}, //14254 #CJK UNIFIED IDEOGRAPH
    {0xD391, 0x8A0E}, //14255 #CJK UNIFIED IDEOGRAPH
    {0xD392, 0x8A0F}, //14256 #CJK UNIFIED IDEOGRAPH
    {0xD393, 0x8A10}, //14257 #CJK UNIFIED IDEOGRAPH
    {0xD394, 0x8A11}, //14258 #CJK UNIFIED IDEOGRAPH
    {0xD395, 0x8A12}, //14259 #CJK UNIFIED IDEOGRAPH
    {0xD396, 0x8A13}, //14260 #CJK UNIFIED IDEOGRAPH
    {0xD397, 0x8A14}, //14261 #CJK UNIFIED IDEOGRAPH
    {0xD398, 0x8A15}, //14262 #CJK UNIFIED IDEOGRAPH
    {0xD399, 0x8A16}, //14263 #CJK UNIFIED IDEOGRAPH
    {0xD39A, 0x8A17}, //14264 #CJK UNIFIED IDEOGRAPH
    {0xD39B, 0x8A18}, //14265 #CJK UNIFIED IDEOGRAPH
    {0xD39C, 0x8A19}, //14266 #CJK UNIFIED IDEOGRAPH
    {0xD39D, 0x8A1A}, //14267 #CJK UNIFIED IDEOGRAPH
    {0xD39E, 0x8A1B}, //14268 #CJK UNIFIED IDEOGRAPH
    {0xD39F, 0x8A1C}, //14269 #CJK UNIFIED IDEOGRAPH
    {0xD3A0, 0x8A1D}, //14270 #CJK UNIFIED IDEOGRAPH
    {0xD3A1, 0x5370}, //14271 #CJK UNIFIED IDEOGRAPH
    {0xD3A2, 0x82F1}, //14272 #CJK UNIFIED IDEOGRAPH
    {0xD3A3, 0x6A31}, //14273 #CJK UNIFIED IDEOGRAPH
    {0xD3A4, 0x5A74}, //14274 #CJK UNIFIED IDEOGRAPH
    {0xD3A5, 0x9E70}, //14275 #CJK UNIFIED IDEOGRAPH
    {0xD3A6, 0x5E94}, //14276 #CJK UNIFIED IDEOGRAPH
    {0xD3A7, 0x7F28}, //14277 #CJK UNIFIED IDEOGRAPH
    {0xD3A8, 0x83B9}, //14278 #CJK UNIFIED IDEOGRAPH
    {0xD3A9, 0x8424}, //14279 #CJK UNIFIED IDEOGRAPH
    {0xD3AA, 0x8425}, //14280 #CJK UNIFIED IDEOGRAPH
    {0xD3AB, 0x8367}, //14281 #CJK UNIFIED IDEOGRAPH
    {0xD3AC, 0x8747}, //14282 #CJK UNIFIED IDEOGRAPH
    {0xD3AD, 0x8FCE}, //14283 #CJK UNIFIED IDEOGRAPH
    {0xD3AE, 0x8D62}, //14284 #CJK UNIFIED IDEOGRAPH
    {0xD3AF, 0x76C8}, //14285 #CJK UNIFIED IDEOGRAPH
    {0xD3B0, 0x5F71}, //14286 #CJK UNIFIED IDEOGRAPH
    {0xD3B1, 0x9896}, //14287 #CJK UNIFIED IDEOGRAPH
    {0xD3B2, 0x786C}, //14288 #CJK UNIFIED IDEOGRAPH
    {0xD3B3, 0x6620}, //14289 #CJK UNIFIED IDEOGRAPH
    {0xD3B4, 0x54DF}, //14290 #CJK UNIFIED IDEOGRAPH
    {0xD3B5, 0x62E5}, //14291 #CJK UNIFIED IDEOGRAPH
    {0xD3B6, 0x4F63}, //14292 #CJK UNIFIED IDEOGRAPH
    {0xD3B7, 0x81C3}, //14293 #CJK UNIFIED IDEOGRAPH
    {0xD3B8, 0x75C8}, //14294 #CJK UNIFIED IDEOGRAPH
    {0xD3B9, 0x5EB8}, //14295 #CJK UNIFIED IDEOGRAPH
    {0xD3BA, 0x96CD}, //14296 #CJK UNIFIED IDEOGRAPH
    {0xD3BB, 0x8E0A}, //14297 #CJK UNIFIED IDEOGRAPH
    {0xD3BC, 0x86F9}, //14298 #CJK UNIFIED IDEOGRAPH
    {0xD3BD, 0x548F}, //14299 #CJK UNIFIED IDEOGRAPH
    {0xD3BE, 0x6CF3}, //14300 #CJK UNIFIED IDEOGRAPH
    {0xD3BF, 0x6D8C}, //14301 #CJK UNIFIED IDEOGRAPH
    {0xD3C0, 0x6C38}, //14302 #CJK UNIFIED IDEOGRAPH
    {0xD3C1, 0x607F}, //14303 #CJK UNIFIED IDEOGRAPH
    {0xD3C2, 0x52C7}, //14304 #CJK UNIFIED IDEOGRAPH
    {0xD3C3, 0x7528}, //14305 #CJK UNIFIED IDEOGRAPH
    {0xD3C4, 0x5E7D}, //14306 #CJK UNIFIED IDEOGRAPH
    {0xD3C5, 0x4F18}, //14307 #CJK UNIFIED IDEOGRAPH
    {0xD3C6, 0x60A0}, //14308 #CJK UNIFIED IDEOGRAPH
    {0xD3C7, 0x5FE7}, //14309 #CJK UNIFIED IDEOGRAPH
    {0xD3C8, 0x5C24}, //14310 #CJK UNIFIED IDEOGRAPH
    {0xD3C9, 0x7531}, //14311 #CJK UNIFIED IDEOGRAPH
    {0xD3CA, 0x90AE}, //14312 #CJK UNIFIED IDEOGRAPH
    {0xD3CB, 0x94C0}, //14313 #CJK UNIFIED IDEOGRAPH
    {0xD3CC, 0x72B9}, //14314 #CJK UNIFIED IDEOGRAPH
    {0xD3CD, 0x6CB9}, //14315 #CJK UNIFIED IDEOGRAPH
    {0xD3CE, 0x6E38}, //14316 #CJK UNIFIED IDEOGRAPH
    {0xD3CF, 0x9149}, //14317 #CJK UNIFIED IDEOGRAPH
    {0xD3D0, 0x6709}, //14318 #CJK UNIFIED IDEOGRAPH
    {0xD3D1, 0x53CB}, //14319 #CJK UNIFIED IDEOGRAPH
    {0xD3D2, 0x53F3}, //14320 #CJK UNIFIED IDEOGRAPH
    {0xD3D3, 0x4F51}, //14321 #CJK UNIFIED IDEOGRAPH
    {0xD3D4, 0x91C9}, //14322 #CJK UNIFIED IDEOGRAPH
    {0xD3D5, 0x8BF1}, //14323 #CJK UNIFIED IDEOGRAPH
    {0xD3D6, 0x53C8}, //14324 #CJK UNIFIED IDEOGRAPH
    {0xD3D7, 0x5E7C}, //14325 #CJK UNIFIED IDEOGRAPH
    {0xD3D8, 0x8FC2}, //14326 #CJK UNIFIED IDEOGRAPH
    {0xD3D9, 0x6DE4}, //14327 #CJK UNIFIED IDEOGRAPH
    {0xD3DA, 0x4E8E}, //14328 #CJK UNIFIED IDEOGRAPH
    {0xD3DB, 0x76C2}, //14329 #CJK UNIFIED IDEOGRAPH
    {0xD3DC, 0x6986}, //14330 #CJK UNIFIED IDEOGRAPH
    {0xD3DD, 0x865E}, //14331 #CJK UNIFIED IDEOGRAPH
    {0xD3DE, 0x611A}, //14332 #CJK UNIFIED IDEOGRAPH
    {0xD3DF, 0x8206}, //14333 #CJK UNIFIED IDEOGRAPH
    {0xD3E0, 0x4F59}, //14334 #CJK UNIFIED IDEOGRAPH
    {0xD3E1, 0x4FDE}, //14335 #CJK UNIFIED IDEOGRAPH
    {0xD3E2, 0x903E}, //14336 #CJK UNIFIED IDEOGRAPH
    {0xD3E3, 0x9C7C}, //14337 #CJK UNIFIED IDEOGRAPH
    {0xD3E4, 0x6109}, //14338 #CJK UNIFIED IDEOGRAPH
    {0xD3E5, 0x6E1D}, //14339 #CJK UNIFIED IDEOGRAPH
    {0xD3E6, 0x6E14}, //14340 #CJK UNIFIED IDEOGRAPH
    {0xD3E7, 0x9685}, //14341 #CJK UNIFIED IDEOGRAPH
    {0xD3E8, 0x4E88}, //14342 #CJK UNIFIED IDEOGRAPH
    {0xD3E9, 0x5A31}, //14343 #CJK UNIFIED IDEOGRAPH
    {0xD3EA, 0x96E8}, //14344 #CJK UNIFIED IDEOGRAPH
    {0xD3EB, 0x4E0E}, //14345 #CJK UNIFIED IDEOGRAPH
    {0xD3EC, 0x5C7F}, //14346 #CJK UNIFIED IDEOGRAPH
    {0xD3ED, 0x79B9}, //14347 #CJK UNIFIED IDEOGRAPH
    {0xD3EE, 0x5B87}, //14348 #CJK UNIFIED IDEOGRAPH
    {0xD3EF, 0x8BED}, //14349 #CJK UNIFIED IDEOGRAPH
    {0xD3F0, 0x7FBD}, //14350 #CJK UNIFIED IDEOGRAPH
    {0xD3F1, 0x7389}, //14351 #CJK UNIFIED IDEOGRAPH
    {0xD3F2, 0x57DF}, //14352 #CJK UNIFIED IDEOGRAPH
    {0xD3F3, 0x828B}, //14353 #CJK UNIFIED IDEOGRAPH
    {0xD3F4, 0x90C1}, //14354 #CJK UNIFIED IDEOGRAPH
    {0xD3F5, 0x5401}, //14355 #CJK UNIFIED IDEOGRAPH
    {0xD3F6, 0x9047}, //14356 #CJK UNIFIED IDEOGRAPH
    {0xD3F7, 0x55BB}, //14357 #CJK UNIFIED IDEOGRAPH
    {0xD3F8, 0x5CEA}, //14358 #CJK UNIFIED IDEOGRAPH
    {0xD3F9, 0x5FA1}, //14359 #CJK UNIFIED IDEOGRAPH
    {0xD3FA, 0x6108}, //14360 #CJK UNIFIED IDEOGRAPH
    {0xD3FB, 0x6B32}, //14361 #CJK UNIFIED IDEOGRAPH
    {0xD3FC, 0x72F1}, //14362 #CJK UNIFIED IDEOGRAPH
    {0xD3FD, 0x80B2}, //14363 #CJK UNIFIED IDEOGRAPH
    {0xD3FE, 0x8A89}, //14364 #CJK UNIFIED IDEOGRAPH
    {0xD440, 0x8A1E}, //14365 #CJK UNIFIED IDEOGRAPH
    {0xD441, 0x8A1F}, //14366 #CJK UNIFIED IDEOGRAPH
    {0xD442, 0x8A20}, //14367 #CJK UNIFIED IDEOGRAPH
    {0xD443, 0x8A21}, //14368 #CJK UNIFIED IDEOGRAPH
    {0xD444, 0x8A22}, //14369 #CJK UNIFIED IDEOGRAPH
    {0xD445, 0x8A23}, //14370 #CJK UNIFIED IDEOGRAPH
    {0xD446, 0x8A24}, //14371 #CJK UNIFIED IDEOGRAPH
    {0xD447, 0x8A25}, //14372 #CJK UNIFIED IDEOGRAPH
    {0xD448, 0x8A26}, //14373 #CJK UNIFIED IDEOGRAPH
    {0xD449, 0x8A27}, //14374 #CJK UNIFIED IDEOGRAPH
    {0xD44A, 0x8A28}, //14375 #CJK UNIFIED IDEOGRAPH
    {0xD44B, 0x8A29}, //14376 #CJK UNIFIED IDEOGRAPH
    {0xD44C, 0x8A2A}, //14377 #CJK UNIFIED IDEOGRAPH
    {0xD44D, 0x8A2B}, //14378 #CJK UNIFIED IDEOGRAPH
    {0xD44E, 0x8A2C}, //14379 #CJK UNIFIED IDEOGRAPH
    {0xD44F, 0x8A2D}, //14380 #CJK UNIFIED IDEOGRAPH
    {0xD450, 0x8A2E}, //14381 #CJK UNIFIED IDEOGRAPH
    {0xD451, 0x8A2F}, //14382 #CJK UNIFIED IDEOGRAPH
    {0xD452, 0x8A30}, //14383 #CJK UNIFIED IDEOGRAPH
    {0xD453, 0x8A31}, //14384 #CJK UNIFIED IDEOGRAPH
    {0xD454, 0x8A32}, //14385 #CJK UNIFIED IDEOGRAPH
    {0xD455, 0x8A33}, //14386 #CJK UNIFIED IDEOGRAPH
    {0xD456, 0x8A34}, //14387 #CJK UNIFIED IDEOGRAPH
    {0xD457, 0x8A35}, //14388 #CJK UNIFIED IDEOGRAPH
    {0xD458, 0x8A36}, //14389 #CJK UNIFIED IDEOGRAPH
    {0xD459, 0x8A37}, //14390 #CJK UNIFIED IDEOGRAPH
    {0xD45A, 0x8A38}, //14391 #CJK UNIFIED IDEOGRAPH
    {0xD45B, 0x8A39}, //14392 #CJK UNIFIED IDEOGRAPH
    {0xD45C, 0x8A3A}, //14393 #CJK UNIFIED IDEOGRAPH
    {0xD45D, 0x8A3B}, //14394 #CJK UNIFIED IDEOGRAPH
    {0xD45E, 0x8A3C}, //14395 #CJK UNIFIED IDEOGRAPH
    {0xD45F, 0x8A3D}, //14396 #CJK UNIFIED IDEOGRAPH
    {0xD460, 0x8A3F}, //14397 #CJK UNIFIED IDEOGRAPH
    {0xD461, 0x8A40}, //14398 #CJK UNIFIED IDEOGRAPH
    {0xD462, 0x8A41}, //14399 #CJK UNIFIED IDEOGRAPH
    {0xD463, 0x8A42}, //14400 #CJK UNIFIED IDEOGRAPH
    {0xD464, 0x8A43}, //14401 #CJK UNIFIED IDEOGRAPH
    {0xD465, 0x8A44}, //14402 #CJK UNIFIED IDEOGRAPH
    {0xD466, 0x8A45}, //14403 #CJK UNIFIED IDEOGRAPH
    {0xD467, 0x8A46}, //14404 #CJK UNIFIED IDEOGRAPH
    {0xD468, 0x8A47}, //14405 #CJK UNIFIED IDEOGRAPH
    {0xD469, 0x8A49}, //14406 #CJK UNIFIED IDEOGRAPH
    {0xD46A, 0x8A4A}, //14407 #CJK UNIFIED IDEOGRAPH
    {0xD46B, 0x8A4B}, //14408 #CJK UNIFIED IDEOGRAPH
    {0xD46C, 0x8A4C}, //14409 #CJK UNIFIED IDEOGRAPH
    {0xD46D, 0x8A4D}, //14410 #CJK UNIFIED IDEOGRAPH
    {0xD46E, 0x8A4E}, //14411 #CJK UNIFIED IDEOGRAPH
    {0xD46F, 0x8A4F}, //14412 #CJK UNIFIED IDEOGRAPH
    {0xD470, 0x8A50}, //14413 #CJK UNIFIED IDEOGRAPH
    {0xD471, 0x8A51}, //14414 #CJK UNIFIED IDEOGRAPH
    {0xD472, 0x8A52}, //14415 #CJK UNIFIED IDEOGRAPH
    {0xD473, 0x8A53}, //14416 #CJK UNIFIED IDEOGRAPH
    {0xD474, 0x8A54}, //14417 #CJK UNIFIED IDEOGRAPH
    {0xD475, 0x8A55}, //14418 #CJK UNIFIED IDEOGRAPH
    {0xD476, 0x8A56}, //14419 #CJK UNIFIED IDEOGRAPH
    {0xD477, 0x8A57}, //14420 #CJK UNIFIED IDEOGRAPH
    {0xD478, 0x8A58}, //14421 #CJK UNIFIED IDEOGRAPH
    {0xD479, 0x8A59}, //14422 #CJK UNIFIED IDEOGRAPH
    {0xD47A, 0x8A5A}, //14423 #CJK UNIFIED IDEOGRAPH
    {0xD47B, 0x8A5B}, //14424 #CJK UNIFIED IDEOGRAPH
    {0xD47C, 0x8A5C}, //14425 #CJK UNIFIED IDEOGRAPH
    {0xD47D, 0x8A5D}, //14426 #CJK UNIFIED IDEOGRAPH
    {0xD47E, 0x8A5E}, //14427 #CJK UNIFIED IDEOGRAPH
    {0xD480, 0x8A5F}, //14428 #CJK UNIFIED IDEOGRAPH
    {0xD481, 0x8A60}, //14429 #CJK UNIFIED IDEOGRAPH
    {0xD482, 0x8A61}, //14430 #CJK UNIFIED IDEOGRAPH
    {0xD483, 0x8A62}, //14431 #CJK UNIFIED IDEOGRAPH
    {0xD484, 0x8A63}, //14432 #CJK UNIFIED IDEOGRAPH
    {0xD485, 0x8A64}, //14433 #CJK UNIFIED IDEOGRAPH
    {0xD486, 0x8A65}, //14434 #CJK UNIFIED IDEOGRAPH
    {0xD487, 0x8A66}, //14435 #CJK UNIFIED IDEOGRAPH
    {0xD488, 0x8A67}, //14436 #CJK UNIFIED IDEOGRAPH
    {0xD489, 0x8A68}, //14437 #CJK UNIFIED IDEOGRAPH
    {0xD48A, 0x8A69}, //14438 #CJK UNIFIED IDEOGRAPH
    {0xD48B, 0x8A6A}, //14439 #CJK UNIFIED IDEOGRAPH
    {0xD48C, 0x8A6B}, //14440 #CJK UNIFIED IDEOGRAPH
    {0xD48D, 0x8A6C}, //14441 #CJK UNIFIED IDEOGRAPH
    {0xD48E, 0x8A6D}, //14442 #CJK UNIFIED IDEOGRAPH
    {0xD48F, 0x8A6E}, //14443 #CJK UNIFIED IDEOGRAPH
    {0xD490, 0x8A6F}, //14444 #CJK UNIFIED IDEOGRAPH
    {0xD491, 0x8A70}, //14445 #CJK UNIFIED IDEOGRAPH
    {0xD492, 0x8A71}, //14446 #CJK UNIFIED IDEOGRAPH
    {0xD493, 0x8A72}, //14447 #CJK UNIFIED IDEOGRAPH
    {0xD494, 0x8A73}, //14448 #CJK UNIFIED IDEOGRAPH
    {0xD495, 0x8A74}, //14449 #CJK UNIFIED IDEOGRAPH
    {0xD496, 0x8A75}, //14450 #CJK UNIFIED IDEOGRAPH
    {0xD497, 0x8A76}, //14451 #CJK UNIFIED IDEOGRAPH
    {0xD498, 0x8A77}, //14452 #CJK UNIFIED IDEOGRAPH
    {0xD499, 0x8A78}, //14453 #CJK UNIFIED IDEOGRAPH
    {0xD49A, 0x8A7A}, //14454 #CJK UNIFIED IDEOGRAPH
    {0xD49B, 0x8A7B}, //14455 #CJK UNIFIED IDEOGRAPH
    {0xD49C, 0x8A7C}, //14456 #CJK UNIFIED IDEOGRAPH
    {0xD49D, 0x8A7D}, //14457 #CJK UNIFIED IDEOGRAPH
    {0xD49E, 0x8A7E}, //14458 #CJK UNIFIED IDEOGRAPH
    {0xD49F, 0x8A7F}, //14459 #CJK UNIFIED IDEOGRAPH
    {0xD4A0, 0x8A80}, //14460 #CJK UNIFIED IDEOGRAPH
    {0xD4A1, 0x6D74}, //14461 #CJK UNIFIED IDEOGRAPH
    {0xD4A2, 0x5BD3}, //14462 #CJK UNIFIED IDEOGRAPH
    {0xD4A3, 0x88D5}, //14463 #CJK UNIFIED IDEOGRAPH
    {0xD4A4, 0x9884}, //14464 #CJK UNIFIED IDEOGRAPH
    {0xD4A5, 0x8C6B}, //14465 #CJK UNIFIED IDEOGRAPH
    {0xD4A6, 0x9A6D}, //14466 #CJK UNIFIED IDEOGRAPH
    {0xD4A7, 0x9E33}, //14467 #CJK UNIFIED IDEOGRAPH
    {0xD4A8, 0x6E0A}, //14468 #CJK UNIFIED IDEOGRAPH
    {0xD4A9, 0x51A4}, //14469 #CJK UNIFIED IDEOGRAPH
    {0xD4AA, 0x5143}, //14470 #CJK UNIFIED IDEOGRAPH
    {0xD4AB, 0x57A3}, //14471 #CJK UNIFIED IDEOGRAPH
    {0xD4AC, 0x8881}, //14472 #CJK UNIFIED IDEOGRAPH
    {0xD4AD, 0x539F}, //14473 #CJK UNIFIED IDEOGRAPH
    {0xD4AE, 0x63F4}, //14474 #CJK UNIFIED IDEOGRAPH
    {0xD4AF, 0x8F95}, //14475 #CJK UNIFIED IDEOGRAPH
    {0xD4B0, 0x56ED}, //14476 #CJK UNIFIED IDEOGRAPH
    {0xD4B1, 0x5458}, //14477 #CJK UNIFIED IDEOGRAPH
    {0xD4B2, 0x5706}, //14478 #CJK UNIFIED IDEOGRAPH
    {0xD4B3, 0x733F}, //14479 #CJK UNIFIED IDEOGRAPH
    {0xD4B4, 0x6E90}, //14480 #CJK UNIFIED IDEOGRAPH
    {0xD4B5, 0x7F18}, //14481 #CJK UNIFIED IDEOGRAPH
    {0xD4B6, 0x8FDC}, //14482 #CJK UNIFIED IDEOGRAPH
    {0xD4B7, 0x82D1}, //14483 #CJK UNIFIED IDEOGRAPH
    {0xD4B8, 0x613F}, //14484 #CJK UNIFIED IDEOGRAPH
    {0xD4B9, 0x6028}, //14485 #CJK UNIFIED IDEOGRAPH
    {0xD4BA, 0x9662}, //14486 #CJK UNIFIED IDEOGRAPH
    {0xD4BB, 0x66F0}, //14487 #CJK UNIFIED IDEOGRAPH
    {0xD4BC, 0x7EA6}, //14488 #CJK UNIFIED IDEOGRAPH
    {0xD4BD, 0x8D8A}, //14489 #CJK UNIFIED IDEOGRAPH
    {0xD4BE, 0x8DC3}, //14490 #CJK UNIFIED IDEOGRAPH
    {0xD4BF, 0x94A5}, //14491 #CJK UNIFIED IDEOGRAPH
    {0xD4C0, 0x5CB3}, //14492 #CJK UNIFIED IDEOGRAPH
    {0xD4C1, 0x7CA4}, //14493 #CJK UNIFIED IDEOGRAPH
    {0xD4C2, 0x6708}, //14494 #CJK UNIFIED IDEOGRAPH
    {0xD4C3, 0x60A6}, //14495 #CJK UNIFIED IDEOGRAPH
    {0xD4C4, 0x9605}, //14496 #CJK UNIFIED IDEOGRAPH
    {0xD4C5, 0x8018}, //14497 #CJK UNIFIED IDEOGRAPH
    {0xD4C6, 0x4E91}, //14498 #CJK UNIFIED IDEOGRAPH
    {0xD4C7, 0x90E7}, //14499 #CJK UNIFIED IDEOGRAPH
    {0xD4C8, 0x5300}, //14500 #CJK UNIFIED IDEOGRAPH
    {0xD4C9, 0x9668}, //14501 #CJK UNIFIED IDEOGRAPH
    {0xD4CA, 0x5141}, //14502 #CJK UNIFIED IDEOGRAPH
    {0xD4CB, 0x8FD0}, //14503 #CJK UNIFIED IDEOGRAPH
    {0xD4CC, 0x8574}, //14504 #CJK UNIFIED IDEOGRAPH
    {0xD4CD, 0x915D}, //14505 #CJK UNIFIED IDEOGRAPH
    {0xD4CE, 0x6655}, //14506 #CJK UNIFIED IDEOGRAPH
    {0xD4CF, 0x97F5}, //14507 #CJK UNIFIED IDEOGRAPH
    {0xD4D0, 0x5B55}, //14508 #CJK UNIFIED IDEOGRAPH
    {0xD4D1, 0x531D}, //14509 #CJK UNIFIED IDEOGRAPH
    {0xD4D2, 0x7838}, //14510 #CJK UNIFIED IDEOGRAPH
    {0xD4D3, 0x6742}, //14511 #CJK UNIFIED IDEOGRAPH
    {0xD4D4, 0x683D}, //14512 #CJK UNIFIED IDEOGRAPH
    {0xD4D5, 0x54C9}, //14513 #CJK UNIFIED IDEOGRAPH
    {0xD4D6, 0x707E}, //14514 #CJK UNIFIED IDEOGRAPH
    {0xD4D7, 0x5BB0}, //14515 #CJK UNIFIED IDEOGRAPH
    {0xD4D8, 0x8F7D}, //14516 #CJK UNIFIED IDEOGRAPH
    {0xD4D9, 0x518D}, //14517 #CJK UNIFIED IDEOGRAPH
    {0xD4DA, 0x5728}, //14518 #CJK UNIFIED IDEOGRAPH
    {0xD4DB, 0x54B1}, //14519 #CJK UNIFIED IDEOGRAPH
    {0xD4DC, 0x6512}, //14520 #CJK UNIFIED IDEOGRAPH
    {0xD4DD, 0x6682}, //14521 #CJK UNIFIED IDEOGRAPH
    {0xD4DE, 0x8D5E}, //14522 #CJK UNIFIED IDEOGRAPH
    {0xD4DF, 0x8D43}, //14523 #CJK UNIFIED IDEOGRAPH
    {0xD4E0, 0x810F}, //14524 #CJK UNIFIED IDEOGRAPH
    {0xD4E1, 0x846C}, //14525 #CJK UNIFIED IDEOGRAPH
    {0xD4E2, 0x906D}, //14526 #CJK UNIFIED IDEOGRAPH
    {0xD4E3, 0x7CDF}, //14527 #CJK UNIFIED IDEOGRAPH
    {0xD4E4, 0x51FF}, //14528 #CJK UNIFIED IDEOGRAPH
    {0xD4E5, 0x85FB}, //14529 #CJK UNIFIED IDEOGRAPH
    {0xD4E6, 0x67A3}, //14530 #CJK UNIFIED IDEOGRAPH
    {0xD4E7, 0x65E9}, //14531 #CJK UNIFIED IDEOGRAPH
    {0xD4E8, 0x6FA1}, //14532 #CJK UNIFIED IDEOGRAPH
    {0xD4E9, 0x86A4}, //14533 #CJK UNIFIED IDEOGRAPH
    {0xD4EA, 0x8E81}, //14534 #CJK UNIFIED IDEOGRAPH
    {0xD4EB, 0x566A}, //14535 #CJK UNIFIED IDEOGRAPH
    {0xD4EC, 0x9020}, //14536 #CJK UNIFIED IDEOGRAPH
    {0xD4ED, 0x7682}, //14537 #CJK UNIFIED IDEOGRAPH
    {0xD4EE, 0x7076}, //14538 #CJK UNIFIED IDEOGRAPH
    {0xD4EF, 0x71E5}, //14539 #CJK UNIFIED IDEOGRAPH
    {0xD4F0, 0x8D23}, //14540 #CJK UNIFIED IDEOGRAPH
    {0xD4F1, 0x62E9}, //14541 #CJK UNIFIED IDEOGRAPH
    {0xD4F2, 0x5219}, //14542 #CJK UNIFIED IDEOGRAPH
    {0xD4F3, 0x6CFD}, //14543 #CJK UNIFIED IDEOGRAPH
    {0xD4F4, 0x8D3C}, //14544 #CJK UNIFIED IDEOGRAPH
    {0xD4F5, 0x600E}, //14545 #CJK UNIFIED IDEOGRAPH
    {0xD4F6, 0x589E}, //14546 #CJK UNIFIED IDEOGRAPH
    {0xD4F7, 0x618E}, //14547 #CJK UNIFIED IDEOGRAPH
    {0xD4F8, 0x66FE}, //14548 #CJK UNIFIED IDEOGRAPH
    {0xD4F9, 0x8D60}, //14549 #CJK UNIFIED IDEOGRAPH
    {0xD4FA, 0x624E}, //14550 #CJK UNIFIED IDEOGRAPH
    {0xD4FB, 0x55B3}, //14551 #CJK UNIFIED IDEOGRAPH
    {0xD4FC, 0x6E23}, //14552 #CJK UNIFIED IDEOGRAPH
    {0xD4FD, 0x672D}, //14553 #CJK UNIFIED IDEOGRAPH
    {0xD4FE, 0x8F67}, //14554 #CJK UNIFIED IDEOGRAPH
    {0xD540, 0x8A81}, //14555 #CJK UNIFIED IDEOGRAPH
    {0xD541, 0x8A82}, //14556 #CJK UNIFIED IDEOGRAPH
    {0xD542, 0x8A83}, //14557 #CJK UNIFIED IDEOGRAPH
    {0xD543, 0x8A84}, //14558 #CJK UNIFIED IDEOGRAPH
    {0xD544, 0x8A85}, //14559 #CJK UNIFIED IDEOGRAPH
    {0xD545, 0x8A86}, //14560 #CJK UNIFIED IDEOGRAPH
    {0xD546, 0x8A87}, //14561 #CJK UNIFIED IDEOGRAPH
    {0xD547, 0x8A88}, //14562 #CJK UNIFIED IDEOGRAPH
    {0xD548, 0x8A8B}, //14563 #CJK UNIFIED IDEOGRAPH
    {0xD549, 0x8A8C}, //14564 #CJK UNIFIED IDEOGRAPH
    {0xD54A, 0x8A8D}, //14565 #CJK UNIFIED IDEOGRAPH
    {0xD54B, 0x8A8E}, //14566 #CJK UNIFIED IDEOGRAPH
    {0xD54C, 0x8A8F}, //14567 #CJK UNIFIED IDEOGRAPH
    {0xD54D, 0x8A90}, //14568 #CJK UNIFIED IDEOGRAPH
    {0xD54E, 0x8A91}, //14569 #CJK UNIFIED IDEOGRAPH
    {0xD54F, 0x8A92}, //14570 #CJK UNIFIED IDEOGRAPH
    {0xD550, 0x8A94}, //14571 #CJK UNIFIED IDEOGRAPH
    {0xD551, 0x8A95}, //14572 #CJK UNIFIED IDEOGRAPH
    {0xD552, 0x8A96}, //14573 #CJK UNIFIED IDEOGRAPH
    {0xD553, 0x8A97}, //14574 #CJK UNIFIED IDEOGRAPH
    {0xD554, 0x8A98}, //14575 #CJK UNIFIED IDEOGRAPH
    {0xD555, 0x8A99}, //14576 #CJK UNIFIED IDEOGRAPH
    {0xD556, 0x8A9A}, //14577 #CJK UNIFIED IDEOGRAPH
    {0xD557, 0x8A9B}, //14578 #CJK UNIFIED IDEOGRAPH
    {0xD558, 0x8A9C}, //14579 #CJK UNIFIED IDEOGRAPH
    {0xD559, 0x8A9D}, //14580 #CJK UNIFIED IDEOGRAPH
    {0xD55A, 0x8A9E}, //14581 #CJK UNIFIED IDEOGRAPH
    {0xD55B, 0x8A9F}, //14582 #CJK UNIFIED IDEOGRAPH
    {0xD55C, 0x8AA0}, //14583 #CJK UNIFIED IDEOGRAPH
    {0xD55D, 0x8AA1}, //14584 #CJK UNIFIED IDEOGRAPH
    {0xD55E, 0x8AA2}, //14585 #CJK UNIFIED IDEOGRAPH
    {0xD55F, 0x8AA3}, //14586 #CJK UNIFIED IDEOGRAPH
    {0xD560, 0x8AA4}, //14587 #CJK UNIFIED IDEOGRAPH
    {0xD561, 0x8AA5}, //14588 #CJK UNIFIED IDEOGRAPH
    {0xD562, 0x8AA6}, //14589 #CJK UNIFIED IDEOGRAPH
    {0xD563, 0x8AA7}, //14590 #CJK UNIFIED IDEOGRAPH
    {0xD564, 0x8AA8}, //14591 #CJK UNIFIED IDEOGRAPH
    {0xD565, 0x8AA9}, //14592 #CJK UNIFIED IDEOGRAPH
    {0xD566, 0x8AAA}, //14593 #CJK UNIFIED IDEOGRAPH
    {0xD567, 0x8AAB}, //14594 #CJK UNIFIED IDEOGRAPH
    {0xD568, 0x8AAC}, //14595 #CJK UNIFIED IDEOGRAPH
    {0xD569, 0x8AAD}, //14596 #CJK UNIFIED IDEOGRAPH
    {0xD56A, 0x8AAE}, //14597 #CJK UNIFIED IDEOGRAPH
    {0xD56B, 0x8AAF}, //14598 #CJK UNIFIED IDEOGRAPH
    {0xD56C, 0x8AB0}, //14599 #CJK UNIFIED IDEOGRAPH
    {0xD56D, 0x8AB1}, //14600 #CJK UNIFIED IDEOGRAPH
    {0xD56E, 0x8AB2}, //14601 #CJK UNIFIED IDEOGRAPH
    {0xD56F, 0x8AB3}, //14602 #CJK UNIFIED IDEOGRAPH
    {0xD570, 0x8AB4}, //14603 #CJK UNIFIED IDEOGRAPH
    {0xD571, 0x8AB5}, //14604 #CJK UNIFIED IDEOGRAPH
    {0xD572, 0x8AB6}, //14605 #CJK UNIFIED IDEOGRAPH
    {0xD573, 0x8AB7}, //14606 #CJK UNIFIED IDEOGRAPH
    {0xD574, 0x8AB8}, //14607 #CJK UNIFIED IDEOGRAPH
    {0xD575, 0x8AB9}, //14608 #CJK UNIFIED IDEOGRAPH
    {0xD576, 0x8ABA}, //14609 #CJK UNIFIED IDEOGRAPH
    {0xD577, 0x8ABB}, //14610 #CJK UNIFIED IDEOGRAPH
    {0xD578, 0x8ABC}, //14611 #CJK UNIFIED IDEOGRAPH
    {0xD579, 0x8ABD}, //14612 #CJK UNIFIED IDEOGRAPH
    {0xD57A, 0x8ABE}, //14613 #CJK UNIFIED IDEOGRAPH
    {0xD57B, 0x8ABF}, //14614 #CJK UNIFIED IDEOGRAPH
    {0xD57C, 0x8AC0}, //14615 #CJK UNIFIED IDEOGRAPH
    {0xD57D, 0x8AC1}, //14616 #CJK UNIFIED IDEOGRAPH
    {0xD57E, 0x8AC2}, //14617 #CJK UNIFIED IDEOGRAPH
    {0xD580, 0x8AC3}, //14618 #CJK UNIFIED IDEOGRAPH
    {0xD581, 0x8AC4}, //14619 #CJK UNIFIED IDEOGRAPH
    {0xD582, 0x8AC5}, //14620 #CJK UNIFIED IDEOGRAPH
    {0xD583, 0x8AC6}, //14621 #CJK UNIFIED IDEOGRAPH
    {0xD584, 0x8AC7}, //14622 #CJK UNIFIED IDEOGRAPH
    {0xD585, 0x8AC8}, //14623 #CJK UNIFIED IDEOGRAPH
    {0xD586, 0x8AC9}, //14624 #CJK UNIFIED IDEOGRAPH
    {0xD587, 0x8ACA}, //14625 #CJK UNIFIED IDEOGRAPH
    {0xD588, 0x8ACB}, //14626 #CJK UNIFIED IDEOGRAPH
    {0xD589, 0x8ACC}, //14627 #CJK UNIFIED IDEOGRAPH
    {0xD58A, 0x8ACD}, //14628 #CJK UNIFIED IDEOGRAPH
    {0xD58B, 0x8ACE}, //14629 #CJK UNIFIED IDEOGRAPH
    {0xD58C, 0x8ACF}, //14630 #CJK UNIFIED IDEOGRAPH
    {0xD58D, 0x8AD0}, //14631 #CJK UNIFIED IDEOGRAPH
    {0xD58E, 0x8AD1}, //14632 #CJK UNIFIED IDEOGRAPH
    {0xD58F, 0x8AD2}, //14633 #CJK UNIFIED IDEOGRAPH
    {0xD590, 0x8AD3}, //14634 #CJK UNIFIED IDEOGRAPH
    {0xD591, 0x8AD4}, //14635 #CJK UNIFIED IDEOGRAPH
    {0xD592, 0x8AD5}, //14636 #CJK UNIFIED IDEOGRAPH
    {0xD593, 0x8AD6}, //14637 #CJK UNIFIED IDEOGRAPH
    {0xD594, 0x8AD7}, //14638 #CJK UNIFIED IDEOGRAPH
    {0xD595, 0x8AD8}, //14639 #CJK UNIFIED IDEOGRAPH
    {0xD596, 0x8AD9}, //14640 #CJK UNIFIED IDEOGRAPH
    {0xD597, 0x8ADA}, //14641 #CJK UNIFIED IDEOGRAPH
    {0xD598, 0x8ADB}, //14642 #CJK UNIFIED IDEOGRAPH
    {0xD599, 0x8ADC}, //14643 #CJK UNIFIED IDEOGRAPH
    {0xD59A, 0x8ADD}, //14644 #CJK UNIFIED IDEOGRAPH
    {0xD59B, 0x8ADE}, //14645 #CJK UNIFIED IDEOGRAPH
    {0xD59C, 0x8ADF}, //14646 #CJK UNIFIED IDEOGRAPH
    {0xD59D, 0x8AE0}, //14647 #CJK UNIFIED IDEOGRAPH
    {0xD59E, 0x8AE1}, //14648 #CJK UNIFIED IDEOGRAPH
    {0xD59F, 0x8AE2}, //14649 #CJK UNIFIED IDEOGRAPH
    {0xD5A0, 0x8AE3}, //14650 #CJK UNIFIED IDEOGRAPH
    {0xD5A1, 0x94E1}, //14651 #CJK UNIFIED IDEOGRAPH
    {0xD5A2, 0x95F8}, //14652 #CJK UNIFIED IDEOGRAPH
    {0xD5A3, 0x7728}, //14653 #CJK UNIFIED IDEOGRAPH
    {0xD5A4, 0x6805}, //14654 #CJK UNIFIED IDEOGRAPH
    {0xD5A5, 0x69A8}, //14655 #CJK UNIFIED IDEOGRAPH
    {0xD5A6, 0x548B}, //14656 #CJK UNIFIED IDEOGRAPH
    {0xD5A7, 0x4E4D}, //14657 #CJK UNIFIED IDEOGRAPH
    {0xD5A8, 0x70B8}, //14658 #CJK UNIFIED IDEOGRAPH
    {0xD5A9, 0x8BC8}, //14659 #CJK UNIFIED IDEOGRAPH
    {0xD5AA, 0x6458}, //14660 #CJK UNIFIED IDEOGRAPH
    {0xD5AB, 0x658B}, //14661 #CJK UNIFIED IDEOGRAPH
    {0xD5AC, 0x5B85}, //14662 #CJK UNIFIED IDEOGRAPH
    {0xD5AD, 0x7A84}, //14663 #CJK UNIFIED IDEOGRAPH
    {0xD5AE, 0x503A}, //14664 #CJK UNIFIED IDEOGRAPH
    {0xD5AF, 0x5BE8}, //14665 #CJK UNIFIED IDEOGRAPH
    {0xD5B0, 0x77BB}, //14666 #CJK UNIFIED IDEOGRAPH
    {0xD5B1, 0x6BE1}, //14667 #CJK UNIFIED IDEOGRAPH
    {0xD5B2, 0x8A79}, //14668 #CJK UNIFIED IDEOGRAPH
    {0xD5B3, 0x7C98}, //14669 #CJK UNIFIED IDEOGRAPH
    {0xD5B4, 0x6CBE}, //14670 #CJK UNIFIED IDEOGRAPH
    {0xD5B5, 0x76CF}, //14671 #CJK UNIFIED IDEOGRAPH
    {0xD5B6, 0x65A9}, //14672 #CJK UNIFIED IDEOGRAPH
    {0xD5B7, 0x8F97}, //14673 #CJK UNIFIED IDEOGRAPH
    {0xD5B8, 0x5D2D}, //14674 #CJK UNIFIED IDEOGRAPH
    {0xD5B9, 0x5C55}, //14675 #CJK UNIFIED IDEOGRAPH
    {0xD5BA, 0x8638}, //14676 #CJK UNIFIED IDEOGRAPH
    {0xD5BB, 0x6808}, //14677 #CJK UNIFIED IDEOGRAPH
    {0xD5BC, 0x5360}, //14678 #CJK UNIFIED IDEOGRAPH
    {0xD5BD, 0x6218}, //14679 #CJK UNIFIED IDEOGRAPH
    {0xD5BE, 0x7AD9}, //14680 #CJK UNIFIED IDEOGRAPH
    {0xD5BF, 0x6E5B}, //14681 #CJK UNIFIED IDEOGRAPH
    {0xD5C0, 0x7EFD}, //14682 #CJK UNIFIED IDEOGRAPH
    {0xD5C1, 0x6A1F}, //14683 #CJK UNIFIED IDEOGRAPH
    {0xD5C2, 0x7AE0}, //14684 #CJK UNIFIED IDEOGRAPH
    {0xD5C3, 0x5F70}, //14685 #CJK UNIFIED IDEOGRAPH
    {0xD5C4, 0x6F33}, //14686 #CJK UNIFIED IDEOGRAPH
    {0xD5C5, 0x5F20}, //14687 #CJK UNIFIED IDEOGRAPH
    {0xD5C6, 0x638C}, //14688 #CJK UNIFIED IDEOGRAPH
    {0xD5C7, 0x6DA8}, //14689 #CJK UNIFIED IDEOGRAPH
    {0xD5C8, 0x6756}, //14690 #CJK UNIFIED IDEOGRAPH
    {0xD5C9, 0x4E08}, //14691 #CJK UNIFIED IDEOGRAPH
    {0xD5CA, 0x5E10}, //14692 #CJK UNIFIED IDEOGRAPH
    {0xD5CB, 0x8D26}, //14693 #CJK UNIFIED IDEOGRAPH
    {0xD5CC, 0x4ED7}, //14694 #CJK UNIFIED IDEOGRAPH
    {0xD5CD, 0x80C0}, //14695 #CJK UNIFIED IDEOGRAPH
    {0xD5CE, 0x7634}, //14696 #CJK UNIFIED IDEOGRAPH
    {0xD5CF, 0x969C}, //14697 #CJK UNIFIED IDEOGRAPH
    {0xD5D0, 0x62DB}, //14698 #CJK UNIFIED IDEOGRAPH
    {0xD5D1, 0x662D}, //14699 #CJK UNIFIED IDEOGRAPH
    {0xD5D2, 0x627E}, //14700 #CJK UNIFIED IDEOGRAPH
    {0xD5D3, 0x6CBC}, //14701 #CJK UNIFIED IDEOGRAPH
    {0xD5D4, 0x8D75}, //14702 #CJK UNIFIED IDEOGRAPH
    {0xD5D5, 0x7167}, //14703 #CJK UNIFIED IDEOGRAPH
    {0xD5D6, 0x7F69}, //14704 #CJK UNIFIED IDEOGRAPH
    {0xD5D7, 0x5146}, //14705 #CJK UNIFIED IDEOGRAPH
    {0xD5D8, 0x8087}, //14706 #CJK UNIFIED IDEOGRAPH
    {0xD5D9, 0x53EC}, //14707 #CJK UNIFIED IDEOGRAPH
    {0xD5DA, 0x906E}, //14708 #CJK UNIFIED IDEOGRAPH
    {0xD5DB, 0x6298}, //14709 #CJK UNIFIED IDEOGRAPH
    {0xD5DC, 0x54F2}, //14710 #CJK UNIFIED IDEOGRAPH
    {0xD5DD, 0x86F0}, //14711 #CJK UNIFIED IDEOGRAPH
    {0xD5DE, 0x8F99}, //14712 #CJK UNIFIED IDEOGRAPH
    {0xD5DF, 0x8005}, //14713 #CJK UNIFIED IDEOGRAPH
    {0xD5E0, 0x9517}, //14714 #CJK UNIFIED IDEOGRAPH
    {0xD5E1, 0x8517}, //14715 #CJK UNIFIED IDEOGRAPH
    {0xD5E2, 0x8FD9}, //14716 #CJK UNIFIED IDEOGRAPH
    {0xD5E3, 0x6D59}, //14717 #CJK UNIFIED IDEOGRAPH
    {0xD5E4, 0x73CD}, //14718 #CJK UNIFIED IDEOGRAPH
    {0xD5E5, 0x659F}, //14719 #CJK UNIFIED IDEOGRAPH
    {0xD5E6, 0x771F}, //14720 #CJK UNIFIED IDEOGRAPH
    {0xD5E7, 0x7504}, //14721 #CJK UNIFIED IDEOGRAPH
    {0xD5E8, 0x7827}, //14722 #CJK UNIFIED IDEOGRAPH
    {0xD5E9, 0x81FB}, //14723 #CJK UNIFIED IDEOGRAPH
    {0xD5EA, 0x8D1E}, //14724 #CJK UNIFIED IDEOGRAPH
    {0xD5EB, 0x9488}, //14725 #CJK UNIFIED IDEOGRAPH
    {0xD5EC, 0x4FA6}, //14726 #CJK UNIFIED IDEOGRAPH
    {0xD5ED, 0x6795}, //14727 #CJK UNIFIED IDEOGRAPH
    {0xD5EE, 0x75B9}, //14728 #CJK UNIFIED IDEOGRAPH
    {0xD5EF, 0x8BCA}, //14729 #CJK UNIFIED IDEOGRAPH
    {0xD5F0, 0x9707}, //14730 #CJK UNIFIED IDEOGRAPH
    {0xD5F1, 0x632F}, //14731 #CJK UNIFIED IDEOGRAPH
    {0xD5F2, 0x9547}, //14732 #CJK UNIFIED IDEOGRAPH
    {0xD5F3, 0x9635}, //14733 #CJK UNIFIED IDEOGRAPH
    {0xD5F4, 0x84B8}, //14734 #CJK UNIFIED IDEOGRAPH
    {0xD5F5, 0x6323}, //14735 #CJK UNIFIED IDEOGRAPH
    {0xD5F6, 0x7741}, //14736 #CJK UNIFIED IDEOGRAPH
    {0xD5F7, 0x5F81}, //14737 #CJK UNIFIED IDEOGRAPH
    {0xD5F8, 0x72F0}, //14738 #CJK UNIFIED IDEOGRAPH
    {0xD5F9, 0x4E89}, //14739 #CJK UNIFIED IDEOGRAPH
    {0xD5FA, 0x6014}, //14740 #CJK UNIFIED IDEOGRAPH
    {0xD5FB, 0x6574}, //14741 #CJK UNIFIED IDEOGRAPH
    {0xD5FC, 0x62EF}, //14742 #CJK UNIFIED IDEOGRAPH
    {0xD5FD, 0x6B63}, //14743 #CJK UNIFIED IDEOGRAPH
    {0xD5FE, 0x653F}, //14744 #CJK UNIFIED IDEOGRAPH
    {0xD640, 0x8AE4}, //14745 #CJK UNIFIED IDEOGRAPH
    {0xD641, 0x8AE5}, //14746 #CJK UNIFIED IDEOGRAPH
    {0xD642, 0x8AE6}, //14747 #CJK UNIFIED IDEOGRAPH
    {0xD643, 0x8AE7}, //14748 #CJK UNIFIED IDEOGRAPH
    {0xD644, 0x8AE8}, //14749 #CJK UNIFIED IDEOGRAPH
    {0xD645, 0x8AE9}, //14750 #CJK UNIFIED IDEOGRAPH
    {0xD646, 0x8AEA}, //14751 #CJK UNIFIED IDEOGRAPH
    {0xD647, 0x8AEB}, //14752 #CJK UNIFIED IDEOGRAPH
    {0xD648, 0x8AEC}, //14753 #CJK UNIFIED IDEOGRAPH
    {0xD649, 0x8AED}, //14754 #CJK UNIFIED IDEOGRAPH
    {0xD64A, 0x8AEE}, //14755 #CJK UNIFIED IDEOGRAPH
    {0xD64B, 0x8AEF}, //14756 #CJK UNIFIED IDEOGRAPH
    {0xD64C, 0x8AF0}, //14757 #CJK UNIFIED IDEOGRAPH
    {0xD64D, 0x8AF1}, //14758 #CJK UNIFIED IDEOGRAPH
    {0xD64E, 0x8AF2}, //14759 #CJK UNIFIED IDEOGRAPH
    {0xD64F, 0x8AF3}, //14760 #CJK UNIFIED IDEOGRAPH
    {0xD650, 0x8AF4}, //14761 #CJK UNIFIED IDEOGRAPH
    {0xD651, 0x8AF5}, //14762 #CJK UNIFIED IDEOGRAPH
    {0xD652, 0x8AF6}, //14763 #CJK UNIFIED IDEOGRAPH
    {0xD653, 0x8AF7}, //14764 #CJK UNIFIED IDEOGRAPH
    {0xD654, 0x8AF8}, //14765 #CJK UNIFIED IDEOGRAPH
    {0xD655, 0x8AF9}, //14766 #CJK UNIFIED IDEOGRAPH
    {0xD656, 0x8AFA}, //14767 #CJK UNIFIED IDEOGRAPH
    {0xD657, 0x8AFB}, //14768 #CJK UNIFIED IDEOGRAPH
    {0xD658, 0x8AFC}, //14769 #CJK UNIFIED IDEOGRAPH
    {0xD659, 0x8AFD}, //14770 #CJK UNIFIED IDEOGRAPH
    {0xD65A, 0x8AFE}, //14771 #CJK UNIFIED IDEOGRAPH
    {0xD65B, 0x8AFF}, //14772 #CJK UNIFIED IDEOGRAPH
    {0xD65C, 0x8B00}, //14773 #CJK UNIFIED IDEOGRAPH
    {0xD65D, 0x8B01}, //14774 #CJK UNIFIED IDEOGRAPH
    {0xD65E, 0x8B02}, //14775 #CJK UNIFIED IDEOGRAPH
    {0xD65F, 0x8B03}, //14776 #CJK UNIFIED IDEOGRAPH
    {0xD660, 0x8B04}, //14777 #CJK UNIFIED IDEOGRAPH
    {0xD661, 0x8B05}, //14778 #CJK UNIFIED IDEOGRAPH
    {0xD662, 0x8B06}, //14779 #CJK UNIFIED IDEOGRAPH
    {0xD663, 0x8B08}, //14780 #CJK UNIFIED IDEOGRAPH
    {0xD664, 0x8B09}, //14781 #CJK UNIFIED IDEOGRAPH
    {0xD665, 0x8B0A}, //14782 #CJK UNIFIED IDEOGRAPH
    {0xD666, 0x8B0B}, //14783 #CJK UNIFIED IDEOGRAPH
    {0xD667, 0x8B0C}, //14784 #CJK UNIFIED IDEOGRAPH
    {0xD668, 0x8B0D}, //14785 #CJK UNIFIED IDEOGRAPH
    {0xD669, 0x8B0E}, //14786 #CJK UNIFIED IDEOGRAPH
    {0xD66A, 0x8B0F}, //14787 #CJK UNIFIED IDEOGRAPH
    {0xD66B, 0x8B10}, //14788 #CJK UNIFIED IDEOGRAPH
    {0xD66C, 0x8B11}, //14789 #CJK UNIFIED IDEOGRAPH
    {0xD66D, 0x8B12}, //14790 #CJK UNIFIED IDEOGRAPH
    {0xD66E, 0x8B13}, //14791 #CJK UNIFIED IDEOGRAPH
    {0xD66F, 0x8B14}, //14792 #CJK UNIFIED IDEOGRAPH
    {0xD670, 0x8B15}, //14793 #CJK UNIFIED IDEOGRAPH
    {0xD671, 0x8B16}, //14794 #CJK UNIFIED IDEOGRAPH
    {0xD672, 0x8B17}, //14795 #CJK UNIFIED IDEOGRAPH
    {0xD673, 0x8B18}, //14796 #CJK UNIFIED IDEOGRAPH
    {0xD674, 0x8B19}, //14797 #CJK UNIFIED IDEOGRAPH
    {0xD675, 0x8B1A}, //14798 #CJK UNIFIED IDEOGRAPH
    {0xD676, 0x8B1B}, //14799 #CJK UNIFIED IDEOGRAPH
    {0xD677, 0x8B1C}, //14800 #CJK UNIFIED IDEOGRAPH
    {0xD678, 0x8B1D}, //14801 #CJK UNIFIED IDEOGRAPH
    {0xD679, 0x8B1E}, //14802 #CJK UNIFIED IDEOGRAPH
    {0xD67A, 0x8B1F}, //14803 #CJK UNIFIED IDEOGRAPH
    {0xD67B, 0x8B20}, //14804 #CJK UNIFIED IDEOGRAPH
    {0xD67C, 0x8B21}, //14805 #CJK UNIFIED IDEOGRAPH
    {0xD67D, 0x8B22}, //14806 #CJK UNIFIED IDEOGRAPH
    {0xD67E, 0x8B23}, //14807 #CJK UNIFIED IDEOGRAPH
    {0xD680, 0x8B24}, //14808 #CJK UNIFIED IDEOGRAPH
    {0xD681, 0x8B25}, //14809 #CJK UNIFIED IDEOGRAPH
    {0xD682, 0x8B27}, //14810 #CJK UNIFIED IDEOGRAPH
    {0xD683, 0x8B28}, //14811 #CJK UNIFIED IDEOGRAPH
    {0xD684, 0x8B29}, //14812 #CJK UNIFIED IDEOGRAPH
    {0xD685, 0x8B2A}, //14813 #CJK UNIFIED IDEOGRAPH
    {0xD686, 0x8B2B}, //14814 #CJK UNIFIED IDEOGRAPH
    {0xD687, 0x8B2C}, //14815 #CJK UNIFIED IDEOGRAPH
    {0xD688, 0x8B2D}, //14816 #CJK UNIFIED IDEOGRAPH
    {0xD689, 0x8B2E}, //14817 #CJK UNIFIED IDEOGRAPH
    {0xD68A, 0x8B2F}, //14818 #CJK UNIFIED IDEOGRAPH
    {0xD68B, 0x8B30}, //14819 #CJK UNIFIED IDEOGRAPH
    {0xD68C, 0x8B31}, //14820 #CJK UNIFIED IDEOGRAPH
    {0xD68D, 0x8B32}, //14821 #CJK UNIFIED IDEOGRAPH
    {0xD68E, 0x8B33}, //14822 #CJK UNIFIED IDEOGRAPH
    {0xD68F, 0x8B34}, //14823 #CJK UNIFIED IDEOGRAPH
    {0xD690, 0x8B35}, //14824 #CJK UNIFIED IDEOGRAPH
    {0xD691, 0x8B36}, //14825 #CJK UNIFIED IDEOGRAPH
    {0xD692, 0x8B37}, //14826 #CJK UNIFIED IDEOGRAPH
    {0xD693, 0x8B38}, //14827 #CJK UNIFIED IDEOGRAPH
    {0xD694, 0x8B39}, //14828 #CJK UNIFIED IDEOGRAPH
    {0xD695, 0x8B3A}, //14829 #CJK UNIFIED IDEOGRAPH
    {0xD696, 0x8B3B}, //14830 #CJK UNIFIED IDEOGRAPH
    {0xD697, 0x8B3C}, //14831 #CJK UNIFIED IDEOGRAPH
    {0xD698, 0x8B3D}, //14832 #CJK UNIFIED IDEOGRAPH
    {0xD699, 0x8B3E}, //14833 #CJK UNIFIED IDEOGRAPH
    {0xD69A, 0x8B3F}, //14834 #CJK UNIFIED IDEOGRAPH
    {0xD69B, 0x8B40}, //14835 #CJK UNIFIED IDEOGRAPH
    {0xD69C, 0x8B41}, //14836 #CJK UNIFIED IDEOGRAPH
    {0xD69D, 0x8B42}, //14837 #CJK UNIFIED IDEOGRAPH
    {0xD69E, 0x8B43}, //14838 #CJK UNIFIED IDEOGRAPH
    {0xD69F, 0x8B44}, //14839 #CJK UNIFIED IDEOGRAPH
    {0xD6A0, 0x8B45}, //14840 #CJK UNIFIED IDEOGRAPH
    {0xD6A1, 0x5E27}, //14841 #CJK UNIFIED IDEOGRAPH
    {0xD6A2, 0x75C7}, //14842 #CJK UNIFIED IDEOGRAPH
    {0xD6A3, 0x90D1}, //14843 #CJK UNIFIED IDEOGRAPH
    {0xD6A4, 0x8BC1}, //14844 #CJK UNIFIED IDEOGRAPH
    {0xD6A5, 0x829D}, //14845 #CJK UNIFIED IDEOGRAPH
    {0xD6A6, 0x679D}, //14846 #CJK UNIFIED IDEOGRAPH
    {0xD6A7, 0x652F}, //14847 #CJK UNIFIED IDEOGRAPH
    {0xD6A8, 0x5431}, //14848 #CJK UNIFIED IDEOGRAPH
    {0xD6A9, 0x8718}, //14849 #CJK UNIFIED IDEOGRAPH
    {0xD6AA, 0x77E5}, //14850 #CJK UNIFIED IDEOGRAPH
    {0xD6AB, 0x80A2}, //14851 #CJK UNIFIED IDEOGRAPH
    {0xD6AC, 0x8102}, //14852 #CJK UNIFIED IDEOGRAPH
    {0xD6AD, 0x6C41}, //14853 #CJK UNIFIED IDEOGRAPH
    {0xD6AE, 0x4E4B}, //14854 #CJK UNIFIED IDEOGRAPH
    {0xD6AF, 0x7EC7}, //14855 #CJK UNIFIED IDEOGRAPH
    {0xD6B0, 0x804C}, //14856 #CJK UNIFIED IDEOGRAPH
    {0xD6B1, 0x76F4}, //14857 #CJK UNIFIED IDEOGRAPH
    {0xD6B2, 0x690D}, //14858 #CJK UNIFIED IDEOGRAPH
    {0xD6B3, 0x6B96}, //14859 #CJK UNIFIED IDEOGRAPH
    {0xD6B4, 0x6267}, //14860 #CJK UNIFIED IDEOGRAPH
    {0xD6B5, 0x503C}, //14861 #CJK UNIFIED IDEOGRAPH
    {0xD6B6, 0x4F84}, //14862 #CJK UNIFIED IDEOGRAPH
    {0xD6B7, 0x5740}, //14863 #CJK UNIFIED IDEOGRAPH
    {0xD6B8, 0x6307}, //14864 #CJK UNIFIED IDEOGRAPH
    {0xD6B9, 0x6B62}, //14865 #CJK UNIFIED IDEOGRAPH
    {0xD6BA, 0x8DBE}, //14866 #CJK UNIFIED IDEOGRAPH
    {0xD6BB, 0x53EA}, //14867 #CJK UNIFIED IDEOGRAPH
    {0xD6BC, 0x65E8}, //14868 #CJK UNIFIED IDEOGRAPH
    {0xD6BD, 0x7EB8}, //14869 #CJK UNIFIED IDEOGRAPH
    {0xD6BE, 0x5FD7}, //14870 #CJK UNIFIED IDEOGRAPH
    {0xD6BF, 0x631A}, //14871 #CJK UNIFIED IDEOGRAPH
    {0xD6C0, 0x63B7}, //14872 #CJK UNIFIED IDEOGRAPH
    {0xD6C1, 0x81F3}, //14873 #CJK UNIFIED IDEOGRAPH
    {0xD6C2, 0x81F4}, //14874 #CJK UNIFIED IDEOGRAPH
    {0xD6C3, 0x7F6E}, //14875 #CJK UNIFIED IDEOGRAPH
    {0xD6C4, 0x5E1C}, //14876 #CJK UNIFIED IDEOGRAPH
    {0xD6C5, 0x5CD9}, //14877 #CJK UNIFIED IDEOGRAPH
    {0xD6C6, 0x5236}, //14878 #CJK UNIFIED IDEOGRAPH
    {0xD6C7, 0x667A}, //14879 #CJK UNIFIED IDEOGRAPH
    {0xD6C8, 0x79E9}, //14880 #CJK UNIFIED IDEOGRAPH
    {0xD6C9, 0x7A1A}, //14881 #CJK UNIFIED IDEOGRAPH
    {0xD6CA, 0x8D28}, //14882 #CJK UNIFIED IDEOGRAPH
    {0xD6CB, 0x7099}, //14883 #CJK UNIFIED IDEOGRAPH
    {0xD6CC, 0x75D4}, //14884 #CJK UNIFIED IDEOGRAPH
    {0xD6CD, 0x6EDE}, //14885 #CJK UNIFIED IDEOGRAPH
    {0xD6CE, 0x6CBB}, //14886 #CJK UNIFIED IDEOGRAPH
    {0xD6CF, 0x7A92}, //14887 #CJK UNIFIED IDEOGRAPH
    {0xD6D0, 0x4E2D}, //14888 #CJK UNIFIED IDEOGRAPH
    {0xD6D1, 0x76C5}, //14889 #CJK UNIFIED IDEOGRAPH
    {0xD6D2, 0x5FE0}, //14890 #CJK UNIFIED IDEOGRAPH
    {0xD6D3, 0x949F}, //14891 #CJK UNIFIED IDEOGRAPH
    {0xD6D4, 0x8877}, //14892 #CJK UNIFIED IDEOGRAPH
    {0xD6D5, 0x7EC8}, //14893 #CJK UNIFIED IDEOGRAPH
    {0xD6D6, 0x79CD}, //14894 #CJK UNIFIED IDEOGRAPH
    {0xD6D7, 0x80BF}, //14895 #CJK UNIFIED IDEOGRAPH
    {0xD6D8, 0x91CD}, //14896 #CJK UNIFIED IDEOGRAPH
    {0xD6D9, 0x4EF2}, //14897 #CJK UNIFIED IDEOGRAPH
    {0xD6DA, 0x4F17}, //14898 #CJK UNIFIED IDEOGRAPH
    {0xD6DB, 0x821F}, //14899 #CJK UNIFIED IDEOGRAPH
    {0xD6DC, 0x5468}, //14900 #CJK UNIFIED IDEOGRAPH
    {0xD6DD, 0x5DDE}, //14901 #CJK UNIFIED IDEOGRAPH
    {0xD6DE, 0x6D32}, //14902 #CJK UNIFIED IDEOGRAPH
    {0xD6DF, 0x8BCC}, //14903 #CJK UNIFIED IDEOGRAPH
    {0xD6E0, 0x7CA5}, //14904 #CJK UNIFIED IDEOGRAPH
    {0xD6E1, 0x8F74}, //14905 #CJK UNIFIED IDEOGRAPH
    {0xD6E2, 0x8098}, //14906 #CJK UNIFIED IDEOGRAPH
    {0xD6E3, 0x5E1A}, //14907 #CJK UNIFIED IDEOGRAPH
    {0xD6E4, 0x5492}, //14908 #CJK UNIFIED IDEOGRAPH
    {0xD6E5, 0x76B1}, //14909 #CJK UNIFIED IDEOGRAPH
    {0xD6E6, 0x5B99}, //14910 #CJK UNIFIED IDEOGRAPH
    {0xD6E7, 0x663C}, //14911 #CJK UNIFIED IDEOGRAPH
    {0xD6E8, 0x9AA4}, //14912 #CJK UNIFIED IDEOGRAPH
    {0xD6E9, 0x73E0}, //14913 #CJK UNIFIED IDEOGRAPH
    {0xD6EA, 0x682A}, //14914 #CJK UNIFIED IDEOGRAPH
    {0xD6EB, 0x86DB}, //14915 #CJK UNIFIED IDEOGRAPH
    {0xD6EC, 0x6731}, //14916 #CJK UNIFIED IDEOGRAPH
    {0xD6ED, 0x732A}, //14917 #CJK UNIFIED IDEOGRAPH
    {0xD6EE, 0x8BF8}, //14918 #CJK UNIFIED IDEOGRAPH
    {0xD6EF, 0x8BDB}, //14919 #CJK UNIFIED IDEOGRAPH
    {0xD6F0, 0x9010}, //14920 #CJK UNIFIED IDEOGRAPH
    {0xD6F1, 0x7AF9}, //14921 #CJK UNIFIED IDEOGRAPH
    {0xD6F2, 0x70DB}, //14922 #CJK UNIFIED IDEOGRAPH
    {0xD6F3, 0x716E}, //14923 #CJK UNIFIED IDEOGRAPH
    {0xD6F4, 0x62C4}, //14924 #CJK UNIFIED IDEOGRAPH
    {0xD6F5, 0x77A9}, //14925 #CJK UNIFIED IDEOGRAPH
    {0xD6F6, 0x5631}, //14926 #CJK UNIFIED IDEOGRAPH
    {0xD6F7, 0x4E3B}, //14927 #CJK UNIFIED IDEOGRAPH
    {0xD6F8, 0x8457}, //14928 #CJK UNIFIED IDEOGRAPH
    {0xD6F9, 0x67F1}, //14929 #CJK UNIFIED IDEOGRAPH
    {0xD6FA, 0x52A9}, //14930 #CJK UNIFIED IDEOGRAPH
    {0xD6FB, 0x86C0}, //14931 #CJK UNIFIED IDEOGRAPH
    {0xD6FC, 0x8D2E}, //14932 #CJK UNIFIED IDEOGRAPH
    {0xD6FD, 0x94F8}, //14933 #CJK UNIFIED IDEOGRAPH
    {0xD6FE, 0x7B51}, //14934 #CJK UNIFIED IDEOGRAPH
    {0xD740, 0x8B46}, //14935 #CJK UNIFIED IDEOGRAPH
    {0xD741, 0x8B47}, //14936 #CJK UNIFIED IDEOGRAPH
    {0xD742, 0x8B48}, //14937 #CJK UNIFIED IDEOGRAPH
    {0xD743, 0x8B49}, //14938 #CJK UNIFIED IDEOGRAPH
    {0xD744, 0x8B4A}, //14939 #CJK UNIFIED IDEOGRAPH
    {0xD745, 0x8B4B}, //14940 #CJK UNIFIED IDEOGRAPH
    {0xD746, 0x8B4C}, //14941 #CJK UNIFIED IDEOGRAPH
    {0xD747, 0x8B4D}, //14942 #CJK UNIFIED IDEOGRAPH
    {0xD748, 0x8B4E}, //14943 #CJK UNIFIED IDEOGRAPH
    {0xD749, 0x8B4F}, //14944 #CJK UNIFIED IDEOGRAPH
    {0xD74A, 0x8B50}, //14945 #CJK UNIFIED IDEOGRAPH
    {0xD74B, 0x8B51}, //14946 #CJK UNIFIED IDEOGRAPH
    {0xD74C, 0x8B52}, //14947 #CJK UNIFIED IDEOGRAPH
    {0xD74D, 0x8B53}, //14948 #CJK UNIFIED IDEOGRAPH
    {0xD74E, 0x8B54}, //14949 #CJK UNIFIED IDEOGRAPH
    {0xD74F, 0x8B55}, //14950 #CJK UNIFIED IDEOGRAPH
    {0xD750, 0x8B56}, //14951 #CJK UNIFIED IDEOGRAPH
    {0xD751, 0x8B57}, //14952 #CJK UNIFIED IDEOGRAPH
    {0xD752, 0x8B58}, //14953 #CJK UNIFIED IDEOGRAPH
    {0xD753, 0x8B59}, //14954 #CJK UNIFIED IDEOGRAPH
    {0xD754, 0x8B5A}, //14955 #CJK UNIFIED IDEOGRAPH
    {0xD755, 0x8B5B}, //14956 #CJK UNIFIED IDEOGRAPH
    {0xD756, 0x8B5C}, //14957 #CJK UNIFIED IDEOGRAPH
    {0xD757, 0x8B5D}, //14958 #CJK UNIFIED IDEOGRAPH
    {0xD758, 0x8B5E}, //14959 #CJK UNIFIED IDEOGRAPH
    {0xD759, 0x8B5F}, //14960 #CJK UNIFIED IDEOGRAPH
    {0xD75A, 0x8B60}, //14961 #CJK UNIFIED IDEOGRAPH
    {0xD75B, 0x8B61}, //14962 #CJK UNIFIED IDEOGRAPH
    {0xD75C, 0x8B62}, //14963 #CJK UNIFIED IDEOGRAPH
    {0xD75D, 0x8B63}, //14964 #CJK UNIFIED IDEOGRAPH
    {0xD75E, 0x8B64}, //14965 #CJK UNIFIED IDEOGRAPH
    {0xD75F, 0x8B65}, //14966 #CJK UNIFIED IDEOGRAPH
    {0xD760, 0x8B67}, //14967 #CJK UNIFIED IDEOGRAPH
    {0xD761, 0x8B68}, //14968 #CJK UNIFIED IDEOGRAPH
    {0xD762, 0x8B69}, //14969 #CJK UNIFIED IDEOGRAPH
    {0xD763, 0x8B6A}, //14970 #CJK UNIFIED IDEOGRAPH
    {0xD764, 0x8B6B}, //14971 #CJK UNIFIED IDEOGRAPH
    {0xD765, 0x8B6D}, //14972 #CJK UNIFIED IDEOGRAPH
    {0xD766, 0x8B6E}, //14973 #CJK UNIFIED IDEOGRAPH
    {0xD767, 0x8B6F}, //14974 #CJK UNIFIED IDEOGRAPH
    {0xD768, 0x8B70}, //14975 #CJK UNIFIED IDEOGRAPH
    {0xD769, 0x8B71}, //14976 #CJK UNIFIED IDEOGRAPH
    {0xD76A, 0x8B72}, //14977 #CJK UNIFIED IDEOGRAPH
    {0xD76B, 0x8B73}, //14978 #CJK UNIFIED IDEOGRAPH
    {0xD76C, 0x8B74}, //14979 #CJK UNIFIED IDEOGRAPH
    {0xD76D, 0x8B75}, //14980 #CJK UNIFIED IDEOGRAPH
    {0xD76E, 0x8B76}, //14981 #CJK UNIFIED IDEOGRAPH
    {0xD76F, 0x8B77}, //14982 #CJK UNIFIED IDEOGRAPH
    {0xD770, 0x8B78}, //14983 #CJK UNIFIED IDEOGRAPH
    {0xD771, 0x8B79}, //14984 #CJK UNIFIED IDEOGRAPH
    {0xD772, 0x8B7A}, //14985 #CJK UNIFIED IDEOGRAPH
    {0xD773, 0x8B7B}, //14986 #CJK UNIFIED IDEOGRAPH
    {0xD774, 0x8B7C}, //14987 #CJK UNIFIED IDEOGRAPH
    {0xD775, 0x8B7D}, //14988 #CJK UNIFIED IDEOGRAPH
    {0xD776, 0x8B7E}, //14989 #CJK UNIFIED IDEOGRAPH
    {0xD777, 0x8B7F}, //14990 #CJK UNIFIED IDEOGRAPH
    {0xD778, 0x8B80}, //14991 #CJK UNIFIED IDEOGRAPH
    {0xD779, 0x8B81}, //14992 #CJK UNIFIED IDEOGRAPH
    {0xD77A, 0x8B82}, //14993 #CJK UNIFIED IDEOGRAPH
    {0xD77B, 0x8B83}, //14994 #CJK UNIFIED IDEOGRAPH
    {0xD77C, 0x8B84}, //14995 #CJK UNIFIED IDEOGRAPH
    {0xD77D, 0x8B85}, //14996 #CJK UNIFIED IDEOGRAPH
    {0xD77E, 0x8B86}, //14997 #CJK UNIFIED IDEOGRAPH
    {0xD780, 0x8B87}, //14998 #CJK UNIFIED IDEOGRAPH
    {0xD781, 0x8B88}, //14999 #CJK UNIFIED IDEOGRAPH
    {0xD782, 0x8B89}, //15000 #CJK UNIFIED IDEOGRAPH
    {0xD783, 0x8B8A}, //15001 #CJK UNIFIED IDEOGRAPH
    {0xD784, 0x8B8B}, //15002 #CJK UNIFIED IDEOGRAPH
    {0xD785, 0x8B8C}, //15003 #CJK UNIFIED IDEOGRAPH
    {0xD786, 0x8B8D}, //15004 #CJK UNIFIED IDEOGRAPH
    {0xD787, 0x8B8E}, //15005 #CJK UNIFIED IDEOGRAPH
    {0xD788, 0x8B8F}, //15006 #CJK UNIFIED IDEOGRAPH
    {0xD789, 0x8B90}, //15007 #CJK UNIFIED IDEOGRAPH
    {0xD78A, 0x8B91}, //15008 #CJK UNIFIED IDEOGRAPH
    {0xD78B, 0x8B92}, //15009 #CJK UNIFIED IDEOGRAPH
    {0xD78C, 0x8B93}, //15010 #CJK UNIFIED IDEOGRAPH
    {0xD78D, 0x8B94}, //15011 #CJK UNIFIED IDEOGRAPH
    {0xD78E, 0x8B95}, //15012 #CJK UNIFIED IDEOGRAPH
    {0xD78F, 0x8B96}, //15013 #CJK UNIFIED IDEOGRAPH
    {0xD790, 0x8B97}, //15014 #CJK UNIFIED IDEOGRAPH
    {0xD791, 0x8B98}, //15015 #CJK UNIFIED IDEOGRAPH
    {0xD792, 0x8B99}, //15016 #CJK UNIFIED IDEOGRAPH
    {0xD793, 0x8B9A}, //15017 #CJK UNIFIED IDEOGRAPH
    {0xD794, 0x8B9B}, //15018 #CJK UNIFIED IDEOGRAPH
    {0xD795, 0x8B9C}, //15019 #CJK UNIFIED IDEOGRAPH
    {0xD796, 0x8B9D}, //15020 #CJK UNIFIED IDEOGRAPH
    {0xD797, 0x8B9E}, //15021 #CJK UNIFIED IDEOGRAPH
    {0xD798, 0x8B9F}, //15022 #CJK UNIFIED IDEOGRAPH
    {0xD799, 0x8BAC}, //15023 #CJK UNIFIED IDEOGRAPH
    {0xD79A, 0x8BB1}, //15024 #CJK UNIFIED IDEOGRAPH
    {0xD79B, 0x8BBB}, //15025 #CJK UNIFIED IDEOGRAPH
    {0xD79C, 0x8BC7}, //15026 #CJK UNIFIED IDEOGRAPH
    {0xD79D, 0x8BD0}, //15027 #CJK UNIFIED IDEOGRAPH
    {0xD79E, 0x8BEA}, //15028 #CJK UNIFIED IDEOGRAPH
    {0xD79F, 0x8C09}, //15029 #CJK UNIFIED IDEOGRAPH
    {0xD7A0, 0x8C1E}, //15030 #CJK UNIFIED IDEOGRAPH
    {0xD7A1, 0x4F4F}, //15031 #CJK UNIFIED IDEOGRAPH
    {0xD7A2, 0x6CE8}, //15032 #CJK UNIFIED IDEOGRAPH
    {0xD7A3, 0x795D}, //15033 #CJK UNIFIED IDEOGRAPH
    {0xD7A4, 0x9A7B}, //15034 #CJK UNIFIED IDEOGRAPH
    {0xD7A5, 0x6293}, //15035 #CJK UNIFIED IDEOGRAPH
    {0xD7A6, 0x722A}, //15036 #CJK UNIFIED IDEOGRAPH
    {0xD7A7, 0x62FD}, //15037 #CJK UNIFIED IDEOGRAPH
    {0xD7A8, 0x4E13}, //15038 #CJK UNIFIED IDEOGRAPH
    {0xD7A9, 0x7816}, //15039 #CJK UNIFIED IDEOGRAPH
    {0xD7AA, 0x8F6C}, //15040 #CJK UNIFIED IDEOGRAPH
    {0xD7AB, 0x64B0}, //15041 #CJK UNIFIED IDEOGRAPH
    {0xD7AC, 0x8D5A}, //15042 #CJK UNIFIED IDEOGRAPH
    {0xD7AD, 0x7BC6}, //15043 #CJK UNIFIED IDEOGRAPH
    {0xD7AE, 0x6869}, //15044 #CJK UNIFIED IDEOGRAPH
    {0xD7AF, 0x5E84}, //15045 #CJK UNIFIED IDEOGRAPH
    {0xD7B0, 0x88C5}, //15046 #CJK UNIFIED IDEOGRAPH
    {0xD7B1, 0x5986}, //15047 #CJK UNIFIED IDEOGRAPH
    {0xD7B2, 0x649E}, //15048 #CJK UNIFIED IDEOGRAPH
    {0xD7B3, 0x58EE}, //15049 #CJK UNIFIED IDEOGRAPH
    {0xD7B4, 0x72B6}, //15050 #CJK UNIFIED IDEOGRAPH
    {0xD7B5, 0x690E}, //15051 #CJK UNIFIED IDEOGRAPH
    {0xD7B6, 0x9525}, //15052 #CJK UNIFIED IDEOGRAPH
    {0xD7B7, 0x8FFD}, //15053 #CJK UNIFIED IDEOGRAPH
    {0xD7B8, 0x8D58}, //15054 #CJK UNIFIED IDEOGRAPH
    {0xD7B9, 0x5760}, //15055 #CJK UNIFIED IDEOGRAPH
    {0xD7BA, 0x7F00}, //15056 #CJK UNIFIED IDEOGRAPH
    {0xD7BB, 0x8C06}, //15057 #CJK UNIFIED IDEOGRAPH
    {0xD7BC, 0x51C6}, //15058 #CJK UNIFIED IDEOGRAPH
    {0xD7BD, 0x6349}, //15059 #CJK UNIFIED IDEOGRAPH
    {0xD7BE, 0x62D9}, //15060 #CJK UNIFIED IDEOGRAPH
    {0xD7BF, 0x5353}, //15061 #CJK UNIFIED IDEOGRAPH
    {0xD7C0, 0x684C}, //15062 #CJK UNIFIED IDEOGRAPH
    {0xD7C1, 0x7422}, //15063 #CJK UNIFIED IDEOGRAPH
    {0xD7C2, 0x8301}, //15064 #CJK UNIFIED IDEOGRAPH
    {0xD7C3, 0x914C}, //15065 #CJK UNIFIED IDEOGRAPH
    {0xD7C4, 0x5544}, //15066 #CJK UNIFIED IDEOGRAPH
    {0xD7C5, 0x7740}, //15067 #CJK UNIFIED IDEOGRAPH
    {0xD7C6, 0x707C}, //15068 #CJK UNIFIED IDEOGRAPH
    {0xD7C7, 0x6D4A}, //15069 #CJK UNIFIED IDEOGRAPH
    {0xD7C8, 0x5179}, //15070 #CJK UNIFIED IDEOGRAPH
    {0xD7C9, 0x54A8}, //15071 #CJK UNIFIED IDEOGRAPH
    {0xD7CA, 0x8D44}, //15072 #CJK UNIFIED IDEOGRAPH
    {0xD7CB, 0x59FF}, //15073 #CJK UNIFIED IDEOGRAPH
    {0xD7CC, 0x6ECB}, //15074 #CJK UNIFIED IDEOGRAPH
    {0xD7CD, 0x6DC4}, //15075 #CJK UNIFIED IDEOGRAPH
    {0xD7CE, 0x5B5C}, //15076 #CJK UNIFIED IDEOGRAPH
    {0xD7CF, 0x7D2B}, //15077 #CJK UNIFIED IDEOGRAPH
    {0xD7D0, 0x4ED4}, //15078 #CJK UNIFIED IDEOGRAPH
    {0xD7D1, 0x7C7D}, //15079 #CJK UNIFIED IDEOGRAPH
    {0xD7D2, 0x6ED3}, //15080 #CJK UNIFIED IDEOGRAPH
    {0xD7D3, 0x5B50}, //15081 #CJK UNIFIED IDEOGRAPH
    {0xD7D4, 0x81EA}, //15082 #CJK UNIFIED IDEOGRAPH
    {0xD7D5, 0x6E0D}, //15083 #CJK UNIFIED IDEOGRAPH
    {0xD7D6, 0x5B57}, //15084 #CJK UNIFIED IDEOGRAPH
    {0xD7D7, 0x9B03}, //15085 #CJK UNIFIED IDEOGRAPH
    {0xD7D8, 0x68D5}, //15086 #CJK UNIFIED IDEOGRAPH
    {0xD7D9, 0x8E2A}, //15087 #CJK UNIFIED IDEOGRAPH
    {0xD7DA, 0x5B97}, //15088 #CJK UNIFIED IDEOGRAPH
    {0xD7DB, 0x7EFC}, //15089 #CJK UNIFIED IDEOGRAPH
    {0xD7DC, 0x603B}, //15090 #CJK UNIFIED IDEOGRAPH
    {0xD7DD, 0x7EB5}, //15091 #CJK UNIFIED IDEOGRAPH
    {0xD7DE, 0x90B9}, //15092 #CJK UNIFIED IDEOGRAPH
    {0xD7DF, 0x8D70}, //15093 #CJK UNIFIED IDEOGRAPH
    {0xD7E0, 0x594F}, //15094 #CJK UNIFIED IDEOGRAPH
    {0xD7E1, 0x63CD}, //15095 #CJK UNIFIED IDEOGRAPH
    {0xD7E2, 0x79DF}, //15096 #CJK UNIFIED IDEOGRAPH
    {0xD7E3, 0x8DB3}, //15097 #CJK UNIFIED IDEOGRAPH
    {0xD7E4, 0x5352}, //15098 #CJK UNIFIED IDEOGRAPH
    {0xD7E5, 0x65CF}, //15099 #CJK UNIFIED IDEOGRAPH
    {0xD7E6, 0x7956}, //15100 #CJK UNIFIED IDEOGRAPH
    {0xD7E7, 0x8BC5}, //15101 #CJK UNIFIED IDEOGRAPH
    {0xD7E8, 0x963B}, //15102 #CJK UNIFIED IDEOGRAPH
    {0xD7E9, 0x7EC4}, //15103 #CJK UNIFIED IDEOGRAPH
    {0xD7EA, 0x94BB}, //15104 #CJK UNIFIED IDEOGRAPH
    {0xD7EB, 0x7E82}, //15105 #CJK UNIFIED IDEOGRAPH
    {0xD7EC, 0x5634}, //15106 #CJK UNIFIED IDEOGRAPH
    {0xD7ED, 0x9189}, //15107 #CJK UNIFIED IDEOGRAPH
    {0xD7EE, 0x6700}, //15108 #CJK UNIFIED IDEOGRAPH
    {0xD7EF, 0x7F6A}, //15109 #CJK UNIFIED IDEOGRAPH
    {0xD7F0, 0x5C0A}, //15110 #CJK UNIFIED IDEOGRAPH
    {0xD7F1, 0x9075}, //15111 #CJK UNIFIED IDEOGRAPH
    {0xD7F2, 0x6628}, //15112 #CJK UNIFIED IDEOGRAPH
    {0xD7F3, 0x5DE6}, //15113 #CJK UNIFIED IDEOGRAPH
    {0xD7F4, 0x4F50}, //15114 #CJK UNIFIED IDEOGRAPH
    {0xD7F5, 0x67DE}, //15115 #CJK UNIFIED IDEOGRAPH
    {0xD7F6, 0x505A}, //15116 #CJK UNIFIED IDEOGRAPH
    {0xD7F7, 0x4F5C}, //15117 #CJK UNIFIED IDEOGRAPH
    {0xD7F8, 0x5750}, //15118 #CJK UNIFIED IDEOGRAPH
    {0xD7F9, 0x5EA7}, //15119 #CJK UNIFIED IDEOGRAPH
    {0xD840, 0x8C38}, //15120 #CJK UNIFIED IDEOGRAPH
    {0xD841, 0x8C39}, //15121 #CJK UNIFIED IDEOGRAPH
    {0xD842, 0x8C3A}, //15122 #CJK UNIFIED IDEOGRAPH
    {0xD843, 0x8C3B}, //15123 #CJK UNIFIED IDEOGRAPH
    {0xD844, 0x8C3C}, //15124 #CJK UNIFIED IDEOGRAPH
    {0xD845, 0x8C3D}, //15125 #CJK UNIFIED IDEOGRAPH
    {0xD846, 0x8C3E}, //15126 #CJK UNIFIED IDEOGRAPH
    {0xD847, 0x8C3F}, //15127 #CJK UNIFIED IDEOGRAPH
    {0xD848, 0x8C40}, //15128 #CJK UNIFIED IDEOGRAPH
    {0xD849, 0x8C42}, //15129 #CJK UNIFIED IDEOGRAPH
    {0xD84A, 0x8C43}, //15130 #CJK UNIFIED IDEOGRAPH
    {0xD84B, 0x8C44}, //15131 #CJK UNIFIED IDEOGRAPH
    {0xD84C, 0x8C45}, //15132 #CJK UNIFIED IDEOGRAPH
    {0xD84D, 0x8C48}, //15133 #CJK UNIFIED IDEOGRAPH
    {0xD84E, 0x8C4A}, //15134 #CJK UNIFIED IDEOGRAPH
    {0xD84F, 0x8C4B}, //15135 #CJK UNIFIED IDEOGRAPH
    {0xD850, 0x8C4D}, //15136 #CJK UNIFIED IDEOGRAPH
    {0xD851, 0x8C4E}, //15137 #CJK UNIFIED IDEOGRAPH
    {0xD852, 0x8C4F}, //15138 #CJK UNIFIED IDEOGRAPH
    {0xD853, 0x8C50}, //15139 #CJK UNIFIED IDEOGRAPH
    {0xD854, 0x8C51}, //15140 #CJK UNIFIED IDEOGRAPH
    {0xD855, 0x8C52}, //15141 #CJK UNIFIED IDEOGRAPH
    {0xD856, 0x8C53}, //15142 #CJK UNIFIED IDEOGRAPH
    {0xD857, 0x8C54}, //15143 #CJK UNIFIED IDEOGRAPH
    {0xD858, 0x8C56}, //15144 #CJK UNIFIED IDEOGRAPH
    {0xD859, 0x8C57}, //15145 #CJK UNIFIED IDEOGRAPH
    {0xD85A, 0x8C58}, //15146 #CJK UNIFIED IDEOGRAPH
    {0xD85B, 0x8C59}, //15147 #CJK UNIFIED IDEOGRAPH
    {0xD85C, 0x8C5B}, //15148 #CJK UNIFIED IDEOGRAPH
    {0xD85D, 0x8C5C}, //15149 #CJK UNIFIED IDEOGRAPH
    {0xD85E, 0x8C5D}, //15150 #CJK UNIFIED IDEOGRAPH
    {0xD85F, 0x8C5E}, //15151 #CJK UNIFIED IDEOGRAPH
    {0xD860, 0x8C5F}, //15152 #CJK UNIFIED IDEOGRAPH
    {0xD861, 0x8C60}, //15153 #CJK UNIFIED IDEOGRAPH
    {0xD862, 0x8C63}, //15154 #CJK UNIFIED IDEOGRAPH
    {0xD863, 0x8C64}, //15155 #CJK UNIFIED IDEOGRAPH
    {0xD864, 0x8C65}, //15156 #CJK UNIFIED IDEOGRAPH
    {0xD865, 0x8C66}, //15157 #CJK UNIFIED IDEOGRAPH
    {0xD866, 0x8C67}, //15158 #CJK UNIFIED IDEOGRAPH
    {0xD867, 0x8C68}, //15159 #CJK UNIFIED IDEOGRAPH
    {0xD868, 0x8C69}, //15160 #CJK UNIFIED IDEOGRAPH
    {0xD869, 0x8C6C}, //15161 #CJK UNIFIED IDEOGRAPH
    {0xD86A, 0x8C6D}, //15162 #CJK UNIFIED IDEOGRAPH
    {0xD86B, 0x8C6E}, //15163 #CJK UNIFIED IDEOGRAPH
    {0xD86C, 0x8C6F}, //15164 #CJK UNIFIED IDEOGRAPH
    {0xD86D, 0x8C70}, //15165 #CJK UNIFIED IDEOGRAPH
    {0xD86E, 0x8C71}, //15166 #CJK UNIFIED IDEOGRAPH
    {0xD86F, 0x8C72}, //15167 #CJK UNIFIED IDEOGRAPH
    {0xD870, 0x8C74}, //15168 #CJK UNIFIED IDEOGRAPH
    {0xD871, 0x8C75}, //15169 #CJK UNIFIED IDEOGRAPH
    {0xD872, 0x8C76}, //15170 #CJK UNIFIED IDEOGRAPH
    {0xD873, 0x8C77}, //15171 #CJK UNIFIED IDEOGRAPH
    {0xD874, 0x8C7B}, //15172 #CJK UNIFIED IDEOGRAPH
    {0xD875, 0x8C7C}, //15173 #CJK UNIFIED IDEOGRAPH
    {0xD876, 0x8C7D}, //15174 #CJK UNIFIED IDEOGRAPH
    {0xD877, 0x8C7E}, //15175 #CJK UNIFIED IDEOGRAPH
    {0xD878, 0x8C7F}, //15176 #CJK UNIFIED IDEOGRAPH
    {0xD879, 0x8C80}, //15177 #CJK UNIFIED IDEOGRAPH
    {0xD87A, 0x8C81}, //15178 #CJK UNIFIED IDEOGRAPH
    {0xD87B, 0x8C83}, //15179 #CJK UNIFIED IDEOGRAPH
    {0xD87C, 0x8C84}, //15180 #CJK UNIFIED IDEOGRAPH
    {0xD87D, 0x8C86}, //15181 #CJK UNIFIED IDEOGRAPH
    {0xD87E, 0x8C87}, //15182 #CJK UNIFIED IDEOGRAPH
    {0xD880, 0x8C88}, //15183 #CJK UNIFIED IDEOGRAPH
    {0xD881, 0x8C8B}, //15184 #CJK UNIFIED IDEOGRAPH
    {0xD882, 0x8C8D}, //15185 #CJK UNIFIED IDEOGRAPH
    {0xD883, 0x8C8E}, //15186 #CJK UNIFIED IDEOGRAPH
    {0xD884, 0x8C8F}, //15187 #CJK UNIFIED IDEOGRAPH
    {0xD885, 0x8C90}, //15188 #CJK UNIFIED IDEOGRAPH
    {0xD886, 0x8C91}, //15189 #CJK UNIFIED IDEOGRAPH
    {0xD887, 0x8C92}, //15190 #CJK UNIFIED IDEOGRAPH
    {0xD888, 0x8C93}, //15191 #CJK UNIFIED IDEOGRAPH
    {0xD889, 0x8C95}, //15192 #CJK UNIFIED IDEOGRAPH
    {0xD88A, 0x8C96}, //15193 #CJK UNIFIED IDEOGRAPH
    {0xD88B, 0x8C97}, //15194 #CJK UNIFIED IDEOGRAPH
    {0xD88C, 0x8C99}, //15195 #CJK UNIFIED IDEOGRAPH
    {0xD88D, 0x8C9A}, //15196 #CJK UNIFIED IDEOGRAPH
    {0xD88E, 0x8C9B}, //15197 #CJK UNIFIED IDEOGRAPH
    {0xD88F, 0x8C9C}, //15198 #CJK UNIFIED IDEOGRAPH
    {0xD890, 0x8C9D}, //15199 #CJK UNIFIED IDEOGRAPH
    {0xD891, 0x8C9E}, //15200 #CJK UNIFIED IDEOGRAPH
    {0xD892, 0x8C9F}, //15201 #CJK UNIFIED IDEOGRAPH
    {0xD893, 0x8CA0}, //15202 #CJK UNIFIED IDEOGRAPH
    {0xD894, 0x8CA1}, //15203 #CJK UNIFIED IDEOGRAPH
    {0xD895, 0x8CA2}, //15204 #CJK UNIFIED IDEOGRAPH
    {0xD896, 0x8CA3}, //15205 #CJK UNIFIED IDEOGRAPH
    {0xD897, 0x8CA4}, //15206 #CJK UNIFIED IDEOGRAPH
    {0xD898, 0x8CA5}, //15207 #CJK UNIFIED IDEOGRAPH
    {0xD899, 0x8CA6}, //15208 #CJK UNIFIED IDEOGRAPH
    {0xD89A, 0x8CA7}, //15209 #CJK UNIFIED IDEOGRAPH
    {0xD89B, 0x8CA8}, //15210 #CJK UNIFIED IDEOGRAPH
    {0xD89C, 0x8CA9}, //15211 #CJK UNIFIED IDEOGRAPH
    {0xD89D, 0x8CAA}, //15212 #CJK UNIFIED IDEOGRAPH
    {0xD89E, 0x8CAB}, //15213 #CJK UNIFIED IDEOGRAPH
    {0xD89F, 0x8CAC}, //15214 #CJK UNIFIED IDEOGRAPH
    {0xD8A0, 0x8CAD}, //15215 #CJK UNIFIED IDEOGRAPH
    {0xD8A1, 0x4E8D}, //15216 #CJK UNIFIED IDEOGRAPH
    {0xD8A2, 0x4E0C}, //15217 #CJK UNIFIED IDEOGRAPH
    {0xD8A3, 0x5140}, //15218 #CJK UNIFIED IDEOGRAPH
    {0xD8A4, 0x4E10}, //15219 #CJK UNIFIED IDEOGRAPH
    {0xD8A5, 0x5EFF}, //15220 #CJK UNIFIED IDEOGRAPH
    {0xD8A6, 0x5345}, //15221 #CJK UNIFIED IDEOGRAPH
    {0xD8A7, 0x4E15}, //15222 #CJK UNIFIED IDEOGRAPH
    {0xD8A8, 0x4E98}, //15223 #CJK UNIFIED IDEOGRAPH
    {0xD8A9, 0x4E1E}, //15224 #CJK UNIFIED IDEOGRAPH
    {0xD8AA, 0x9B32}, //15225 #CJK UNIFIED IDEOGRAPH
    {0xD8AB, 0x5B6C}, //15226 #CJK UNIFIED IDEOGRAPH
    {0xD8AC, 0x5669}, //15227 #CJK UNIFIED IDEOGRAPH
    {0xD8AD, 0x4E28}, //15228 #CJK UNIFIED IDEOGRAPH
    {0xD8AE, 0x79BA}, //15229 #CJK UNIFIED IDEOGRAPH
    {0xD8AF, 0x4E3F}, //15230 #CJK UNIFIED IDEOGRAPH
    {0xD8B0, 0x5315}, //15231 #CJK UNIFIED IDEOGRAPH
    {0xD8B1, 0x4E47}, //15232 #CJK UNIFIED IDEOGRAPH
    {0xD8B2, 0x592D}, //15233 #CJK UNIFIED IDEOGRAPH
    {0xD8B3, 0x723B}, //15234 #CJK UNIFIED IDEOGRAPH
    {0xD8B4, 0x536E}, //15235 #CJK UNIFIED IDEOGRAPH
    {0xD8B5, 0x6C10}, //15236 #CJK UNIFIED IDEOGRAPH
    {0xD8B6, 0x56DF}, //15237 #CJK UNIFIED IDEOGRAPH
    {0xD8B7, 0x80E4}, //15238 #CJK UNIFIED IDEOGRAPH
    {0xD8B8, 0x9997}, //15239 #CJK UNIFIED IDEOGRAPH
    {0xD8B9, 0x6BD3}, //15240 #CJK UNIFIED IDEOGRAPH
    {0xD8BA, 0x777E}, //15241 #CJK UNIFIED IDEOGRAPH
    {0xD8BB, 0x9F17}, //15242 #CJK UNIFIED IDEOGRAPH
    {0xD8BC, 0x4E36}, //15243 #CJK UNIFIED IDEOGRAPH
    {0xD8BD, 0x4E9F}, //15244 #CJK UNIFIED IDEOGRAPH
    {0xD8BE, 0x9F10}, //15245 #CJK UNIFIED IDEOGRAPH
    {0xD8BF, 0x4E5C}, //15246 #CJK UNIFIED IDEOGRAPH
    {0xD8C0, 0x4E69}, //15247 #CJK UNIFIED IDEOGRAPH
    {0xD8C1, 0x4E93}, //15248 #CJK UNIFIED IDEOGRAPH
    {0xD8C2, 0x8288}, //15249 #CJK UNIFIED IDEOGRAPH
    {0xD8C3, 0x5B5B}, //15250 #CJK UNIFIED IDEOGRAPH
    {0xD8C4, 0x556C}, //15251 #CJK UNIFIED IDEOGRAPH
    {0xD8C5, 0x560F}, //15252 #CJK UNIFIED IDEOGRAPH
    {0xD8C6, 0x4EC4}, //15253 #CJK UNIFIED IDEOGRAPH
    {0xD8C7, 0x538D}, //15254 #CJK UNIFIED IDEOGRAPH
    {0xD8C8, 0x539D}, //15255 #CJK UNIFIED IDEOGRAPH
    {0xD8C9, 0x53A3}, //15256 #CJK UNIFIED IDEOGRAPH
    {0xD8CA, 0x53A5}, //15257 #CJK UNIFIED IDEOGRAPH
    {0xD8CB, 0x53AE}, //15258 #CJK UNIFIED IDEOGRAPH
    {0xD8CC, 0x9765}, //15259 #CJK UNIFIED IDEOGRAPH
    {0xD8CD, 0x8D5D}, //15260 #CJK UNIFIED IDEOGRAPH
    {0xD8CE, 0x531A}, //15261 #CJK UNIFIED IDEOGRAPH
    {0xD8CF, 0x53F5}, //15262 #CJK UNIFIED IDEOGRAPH
    {0xD8D0, 0x5326}, //15263 #CJK UNIFIED IDEOGRAPH
    {0xD8D1, 0x532E}, //15264 #CJK UNIFIED IDEOGRAPH
    {0xD8D2, 0x533E}, //15265 #CJK UNIFIED IDEOGRAPH
    {0xD8D3, 0x8D5C}, //15266 #CJK UNIFIED IDEOGRAPH
    {0xD8D4, 0x5366}, //15267 #CJK UNIFIED IDEOGRAPH
    {0xD8D5, 0x5363}, //15268 #CJK UNIFIED IDEOGRAPH
    {0xD8D6, 0x5202}, //15269 #CJK UNIFIED IDEOGRAPH
    {0xD8D7, 0x5208}, //15270 #CJK UNIFIED IDEOGRAPH
    {0xD8D8, 0x520E}, //15271 #CJK UNIFIED IDEOGRAPH
    {0xD8D9, 0x522D}, //15272 #CJK UNIFIED IDEOGRAPH
    {0xD8DA, 0x5233}, //15273 #CJK UNIFIED IDEOGRAPH
    {0xD8DB, 0x523F}, //15274 #CJK UNIFIED IDEOGRAPH
    {0xD8DC, 0x5240}, //15275 #CJK UNIFIED IDEOGRAPH
    {0xD8DD, 0x524C}, //15276 #CJK UNIFIED IDEOGRAPH
    {0xD8DE, 0x525E}, //15277 #CJK UNIFIED IDEOGRAPH
    {0xD8DF, 0x5261}, //15278 #CJK UNIFIED IDEOGRAPH
    {0xD8E0, 0x525C}, //15279 #CJK UNIFIED IDEOGRAPH
    {0xD8E1, 0x84AF}, //15280 #CJK UNIFIED IDEOGRAPH
    {0xD8E2, 0x527D}, //15281 #CJK UNIFIED IDEOGRAPH
    {0xD8E3, 0x5282}, //15282 #CJK UNIFIED IDEOGRAPH
    {0xD8E4, 0x5281}, //15283 #CJK UNIFIED IDEOGRAPH
    {0xD8E5, 0x5290}, //15284 #CJK UNIFIED IDEOGRAPH
    {0xD8E6, 0x5293}, //15285 #CJK UNIFIED IDEOGRAPH
    {0xD8E7, 0x5182}, //15286 #CJK UNIFIED IDEOGRAPH
    {0xD8E8, 0x7F54}, //15287 #CJK UNIFIED IDEOGRAPH
    {0xD8E9, 0x4EBB}, //15288 #CJK UNIFIED IDEOGRAPH
    {0xD8EA, 0x4EC3}, //15289 #CJK UNIFIED IDEOGRAPH
    {0xD8EB, 0x4EC9}, //15290 #CJK UNIFIED IDEOGRAPH
    {0xD8EC, 0x4EC2}, //15291 #CJK UNIFIED IDEOGRAPH
    {0xD8ED, 0x4EE8}, //15292 #CJK UNIFIED IDEOGRAPH
    {0xD8EE, 0x4EE1}, //15293 #CJK UNIFIED IDEOGRAPH
    {0xD8EF, 0x4EEB}, //15294 #CJK UNIFIED IDEOGRAPH
    {0xD8F0, 0x4EDE}, //15295 #CJK UNIFIED IDEOGRAPH
    {0xD8F1, 0x4F1B}, //15296 #CJK UNIFIED IDEOGRAPH
    {0xD8F2, 0x4EF3}, //15297 #CJK UNIFIED IDEOGRAPH
    {0xD8F3, 0x4F22}, //15298 #CJK UNIFIED IDEOGRAPH
    {0xD8F4, 0x4F64}, //15299 #CJK UNIFIED IDEOGRAPH
    {0xD8F5, 0x4EF5}, //15300 #CJK UNIFIED IDEOGRAPH
    {0xD8F6, 0x4F25}, //15301 #CJK UNIFIED IDEOGRAPH
    {0xD8F7, 0x4F27}, //15302 #CJK UNIFIED IDEOGRAPH
    {0xD8F8, 0x4F09}, //15303 #CJK UNIFIED IDEOGRAPH
    {0xD8F9, 0x4F2B}, //15304 #CJK UNIFIED IDEOGRAPH
    {0xD8FA, 0x4F5E}, //15305 #CJK UNIFIED IDEOGRAPH
    {0xD8FB, 0x4F67}, //15306 #CJK UNIFIED IDEOGRAPH
    {0xD8FC, 0x6538}, //15307 #CJK UNIFIED IDEOGRAPH
    {0xD8FD, 0x4F5A}, //15308 #CJK UNIFIED IDEOGRAPH
    {0xD8FE, 0x4F5D}, //15309 #CJK UNIFIED IDEOGRAPH
    {0xD940, 0x8CAE}, //15310 #CJK UNIFIED IDEOGRAPH
    {0xD941, 0x8CAF}, //15311 #CJK UNIFIED IDEOGRAPH
    {0xD942, 0x8CB0}, //15312 #CJK UNIFIED IDEOGRAPH
    {0xD943, 0x8CB1}, //15313 #CJK UNIFIED IDEOGRAPH
    {0xD944, 0x8CB2}, //15314 #CJK UNIFIED IDEOGRAPH
    {0xD945, 0x8CB3}, //15315 #CJK UNIFIED IDEOGRAPH
    {0xD946, 0x8CB4}, //15316 #CJK UNIFIED IDEOGRAPH
    {0xD947, 0x8CB5}, //15317 #CJK UNIFIED IDEOGRAPH
    {0xD948, 0x8CB6}, //15318 #CJK UNIFIED IDEOGRAPH
    {0xD949, 0x8CB7}, //15319 #CJK UNIFIED IDEOGRAPH
    {0xD94A, 0x8CB8}, //15320 #CJK UNIFIED IDEOGRAPH
    {0xD94B, 0x8CB9}, //15321 #CJK UNIFIED IDEOGRAPH
    {0xD94C, 0x8CBA}, //15322 #CJK UNIFIED IDEOGRAPH
    {0xD94D, 0x8CBB}, //15323 #CJK UNIFIED IDEOGRAPH
    {0xD94E, 0x8CBC}, //15324 #CJK UNIFIED IDEOGRAPH
    {0xD94F, 0x8CBD}, //15325 #CJK UNIFIED IDEOGRAPH
    {0xD950, 0x8CBE}, //15326 #CJK UNIFIED IDEOGRAPH
    {0xD951, 0x8CBF}, //15327 #CJK UNIFIED IDEOGRAPH
    {0xD952, 0x8CC0}, //15328 #CJK UNIFIED IDEOGRAPH
    {0xD953, 0x8CC1}, //15329 #CJK UNIFIED IDEOGRAPH
    {0xD954, 0x8CC2}, //15330 #CJK UNIFIED IDEOGRAPH
    {0xD955, 0x8CC3}, //15331 #CJK UNIFIED IDEOGRAPH
    {0xD956, 0x8CC4}, //15332 #CJK UNIFIED IDEOGRAPH
    {0xD957, 0x8CC5}, //15333 #CJK UNIFIED IDEOGRAPH
    {0xD958, 0x8CC6}, //15334 #CJK UNIFIED IDEOGRAPH
    {0xD959, 0x8CC7}, //15335 #CJK UNIFIED IDEOGRAPH
    {0xD95A, 0x8CC8}, //15336 #CJK UNIFIED IDEOGRAPH
    {0xD95B, 0x8CC9}, //15337 #CJK UNIFIED IDEOGRAPH
    {0xD95C, 0x8CCA}, //15338 #CJK UNIFIED IDEOGRAPH
    {0xD95D, 0x8CCB}, //15339 #CJK UNIFIED IDEOGRAPH
    {0xD95E, 0x8CCC}, //15340 #CJK UNIFIED IDEOGRAPH
    {0xD95F, 0x8CCD}, //15341 #CJK UNIFIED IDEOGRAPH
    {0xD960, 0x8CCE}, //15342 #CJK UNIFIED IDEOGRAPH
    {0xD961, 0x8CCF}, //15343 #CJK UNIFIED IDEOGRAPH
    {0xD962, 0x8CD0}, //15344 #CJK UNIFIED IDEOGRAPH
    {0xD963, 0x8CD1}, //15345 #CJK UNIFIED IDEOGRAPH
    {0xD964, 0x8CD2}, //15346 #CJK UNIFIED IDEOGRAPH
    {0xD965, 0x8CD3}, //15347 #CJK UNIFIED IDEOGRAPH
    {0xD966, 0x8CD4}, //15348 #CJK UNIFIED IDEOGRAPH
    {0xD967, 0x8CD5}, //15349 #CJK UNIFIED IDEOGRAPH
    {0xD968, 0x8CD6}, //15350 #CJK UNIFIED IDEOGRAPH
    {0xD969, 0x8CD7}, //15351 #CJK UNIFIED IDEOGRAPH
    {0xD96A, 0x8CD8}, //15352 #CJK UNIFIED IDEOGRAPH
    {0xD96B, 0x8CD9}, //15353 #CJK UNIFIED IDEOGRAPH
    {0xD96C, 0x8CDA}, //15354 #CJK UNIFIED IDEOGRAPH
    {0xD96D, 0x8CDB}, //15355 #CJK UNIFIED IDEOGRAPH
    {0xD96E, 0x8CDC}, //15356 #CJK UNIFIED IDEOGRAPH
    {0xD96F, 0x8CDD}, //15357 #CJK UNIFIED IDEOGRAPH
    {0xD970, 0x8CDE}, //15358 #CJK UNIFIED IDEOGRAPH
    {0xD971, 0x8CDF}, //15359 #CJK UNIFIED IDEOGRAPH
    {0xD972, 0x8CE0}, //15360 #CJK UNIFIED IDEOGRAPH
    {0xD973, 0x8CE1}, //15361 #CJK UNIFIED IDEOGRAPH
    {0xD974, 0x8CE2}, //15362 #CJK UNIFIED IDEOGRAPH
    {0xD975, 0x8CE3}, //15363 #CJK UNIFIED IDEOGRAPH
    {0xD976, 0x8CE4}, //15364 #CJK UNIFIED IDEOGRAPH
    {0xD977, 0x8CE5}, //15365 #CJK UNIFIED IDEOGRAPH
    {0xD978, 0x8CE6}, //15366 #CJK UNIFIED IDEOGRAPH
    {0xD979, 0x8CE7}, //15367 #CJK UNIFIED IDEOGRAPH
    {0xD97A, 0x8CE8}, //15368 #CJK UNIFIED IDEOGRAPH
    {0xD97B, 0x8CE9}, //15369 #CJK UNIFIED IDEOGRAPH
    {0xD97C, 0x8CEA}, //15370 #CJK UNIFIED IDEOGRAPH
    {0xD97D, 0x8CEB}, //15371 #CJK UNIFIED IDEOGRAPH
    {0xD97E, 0x8CEC}, //15372 #CJK UNIFIED IDEOGRAPH
    {0xD980, 0x8CED}, //15373 #CJK UNIFIED IDEOGRAPH
    {0xD981, 0x8CEE}, //15374 #CJK UNIFIED IDEOGRAPH
    {0xD982, 0x8CEF}, //15375 #CJK UNIFIED IDEOGRAPH
    {0xD983, 0x8CF0}, //15376 #CJK UNIFIED IDEOGRAPH
    {0xD984, 0x8CF1}, //15377 #CJK UNIFIED IDEOGRAPH
    {0xD985, 0x8CF2}, //15378 #CJK UNIFIED IDEOGRAPH
    {0xD986, 0x8CF3}, //15379 #CJK UNIFIED IDEOGRAPH
    {0xD987, 0x8CF4}, //15380 #CJK UNIFIED IDEOGRAPH
    {0xD988, 0x8CF5}, //15381 #CJK UNIFIED IDEOGRAPH
    {0xD989, 0x8CF6}, //15382 #CJK UNIFIED IDEOGRAPH
    {0xD98A, 0x8CF7}, //15383 #CJK UNIFIED IDEOGRAPH
    {0xD98B, 0x8CF8}, //15384 #CJK UNIFIED IDEOGRAPH
    {0xD98C, 0x8CF9}, //15385 #CJK UNIFIED IDEOGRAPH
    {0xD98D, 0x8CFA}, //15386 #CJK UNIFIED IDEOGRAPH
    {0xD98E, 0x8CFB}, //15387 #CJK UNIFIED IDEOGRAPH
    {0xD98F, 0x8CFC}, //15388 #CJK UNIFIED IDEOGRAPH
    {0xD990, 0x8CFD}, //15389 #CJK UNIFIED IDEOGRAPH
    {0xD991, 0x8CFE}, //15390 #CJK UNIFIED IDEOGRAPH
    {0xD992, 0x8CFF}, //15391 #CJK UNIFIED IDEOGRAPH
    {0xD993, 0x8D00}, //15392 #CJK UNIFIED IDEOGRAPH
    {0xD994, 0x8D01}, //15393 #CJK UNIFIED IDEOGRAPH
    {0xD995, 0x8D02}, //15394 #CJK UNIFIED IDEOGRAPH
    {0xD996, 0x8D03}, //15395 #CJK UNIFIED IDEOGRAPH
    {0xD997, 0x8D04}, //15396 #CJK UNIFIED IDEOGRAPH
    {0xD998, 0x8D05}, //15397 #CJK UNIFIED IDEOGRAPH
    {0xD999, 0x8D06}, //15398 #CJK UNIFIED IDEOGRAPH
    {0xD99A, 0x8D07}, //15399 #CJK UNIFIED IDEOGRAPH
    {0xD99B, 0x8D08}, //15400 #CJK UNIFIED IDEOGRAPH
    {0xD99C, 0x8D09}, //15401 #CJK UNIFIED IDEOGRAPH
    {0xD99D, 0x8D0A}, //15402 #CJK UNIFIED IDEOGRAPH
    {0xD99E, 0x8D0B}, //15403 #CJK UNIFIED IDEOGRAPH
    {0xD99F, 0x8D0C}, //15404 #CJK UNIFIED IDEOGRAPH
    {0xD9A0, 0x8D0D}, //15405 #CJK UNIFIED IDEOGRAPH
    {0xD9A1, 0x4F5F}, //15406 #CJK UNIFIED IDEOGRAPH
    {0xD9A2, 0x4F57}, //15407 #CJK UNIFIED IDEOGRAPH
    {0xD9A3, 0x4F32}, //15408 #CJK UNIFIED IDEOGRAPH
    {0xD9A4, 0x4F3D}, //15409 #CJK UNIFIED IDEOGRAPH
    {0xD9A5, 0x4F76}, //15410 #CJK UNIFIED IDEOGRAPH
    {0xD9A6, 0x4F74}, //15411 #CJK UNIFIED IDEOGRAPH
    {0xD9A7, 0x4F91}, //15412 #CJK UNIFIED IDEOGRAPH
    {0xD9A8, 0x4F89}, //15413 #CJK UNIFIED IDEOGRAPH
    {0xD9A9, 0x4F83}, //15414 #CJK UNIFIED IDEOGRAPH
    {0xD9AA, 0x4F8F}, //15415 #CJK UNIFIED IDEOGRAPH
    {0xD9AB, 0x4F7E}, //15416 #CJK UNIFIED IDEOGRAPH
    {0xD9AC, 0x4F7B}, //15417 #CJK UNIFIED IDEOGRAPH
    {0xD9AD, 0x4FAA}, //15418 #CJK UNIFIED IDEOGRAPH
    {0xD9AE, 0x4F7C}, //15419 #CJK UNIFIED IDEOGRAPH
    {0xD9AF, 0x4FAC}, //15420 #CJK UNIFIED IDEOGRAPH
    {0xD9B0, 0x4F94}, //15421 #CJK UNIFIED IDEOGRAPH
    {0xD9B1, 0x4FE6}, //15422 #CJK UNIFIED IDEOGRAPH
    {0xD9B2, 0x4FE8}, //15423 #CJK UNIFIED IDEOGRAPH
    {0xD9B3, 0x4FEA}, //15424 #CJK UNIFIED IDEOGRAPH
    {0xD9B4, 0x4FC5}, //15425 #CJK UNIFIED IDEOGRAPH
    {0xD9B5, 0x4FDA}, //15426 #CJK UNIFIED IDEOGRAPH
    {0xD9B6, 0x4FE3}, //15427 #CJK UNIFIED IDEOGRAPH
    {0xD9B7, 0x4FDC}, //15428 #CJK UNIFIED IDEOGRAPH
    {0xD9B8, 0x4FD1}, //15429 #CJK UNIFIED IDEOGRAPH
    {0xD9B9, 0x4FDF}, //15430 #CJK UNIFIED IDEOGRAPH
    {0xD9BA, 0x4FF8}, //15431 #CJK UNIFIED IDEOGRAPH
    {0xD9BB, 0x5029}, //15432 #CJK UNIFIED IDEOGRAPH
    {0xD9BC, 0x504C}, //15433 #CJK UNIFIED IDEOGRAPH
    {0xD9BD, 0x4FF3}, //15434 #CJK UNIFIED IDEOGRAPH
    {0xD9BE, 0x502C}, //15435 #CJK UNIFIED IDEOGRAPH
    {0xD9BF, 0x500F}, //15436 #CJK UNIFIED IDEOGRAPH
    {0xD9C0, 0x502E}, //15437 #CJK UNIFIED IDEOGRAPH
    {0xD9C1, 0x502D}, //15438 #CJK UNIFIED IDEOGRAPH
    {0xD9C2, 0x4FFE}, //15439 #CJK UNIFIED IDEOGRAPH
    {0xD9C3, 0x501C}, //15440 #CJK UNIFIED IDEOGRAPH
    {0xD9C4, 0x500C}, //15441 #CJK UNIFIED IDEOGRAPH
    {0xD9C5, 0x5025}, //15442 #CJK UNIFIED IDEOGRAPH
    {0xD9C6, 0x5028}, //15443 #CJK UNIFIED IDEOGRAPH
    {0xD9C7, 0x507E}, //15444 #CJK UNIFIED IDEOGRAPH
    {0xD9C8, 0x5043}, //15445 #CJK UNIFIED IDEOGRAPH
    {0xD9C9, 0x5055}, //15446 #CJK UNIFIED IDEOGRAPH
    {0xD9CA, 0x5048}, //15447 #CJK UNIFIED IDEOGRAPH
    {0xD9CB, 0x504E}, //15448 #CJK UNIFIED IDEOGRAPH
    {0xD9CC, 0x506C}, //15449 #CJK UNIFIED IDEOGRAPH
    {0xD9CD, 0x507B}, //15450 #CJK UNIFIED IDEOGRAPH
    {0xD9CE, 0x50A5}, //15451 #CJK UNIFIED IDEOGRAPH
    {0xD9CF, 0x50A7}, //15452 #CJK UNIFIED IDEOGRAPH
    {0xD9D0, 0x50A9}, //15453 #CJK UNIFIED IDEOGRAPH
    {0xD9D1, 0x50BA}, //15454 #CJK UNIFIED IDEOGRAPH
    {0xD9D2, 0x50D6}, //15455 #CJK UNIFIED IDEOGRAPH
    {0xD9D3, 0x5106}, //15456 #CJK UNIFIED IDEOGRAPH
    {0xD9D4, 0x50ED}, //15457 #CJK UNIFIED IDEOGRAPH
    {0xD9D5, 0x50EC}, //15458 #CJK UNIFIED IDEOGRAPH
    {0xD9D6, 0x50E6}, //15459 #CJK UNIFIED IDEOGRAPH
    {0xD9D7, 0x50EE}, //15460 #CJK UNIFIED IDEOGRAPH
    {0xD9D8, 0x5107}, //15461 #CJK UNIFIED IDEOGRAPH
    {0xD9D9, 0x510B}, //15462 #CJK UNIFIED IDEOGRAPH
    {0xD9DA, 0x4EDD}, //15463 #CJK UNIFIED IDEOGRAPH
    {0xD9DB, 0x6C3D}, //15464 #CJK UNIFIED IDEOGRAPH
    {0xD9DC, 0x4F58}, //15465 #CJK UNIFIED IDEOGRAPH
    {0xD9DD, 0x4F65}, //15466 #CJK UNIFIED IDEOGRAPH
    {0xD9DE, 0x4FCE}, //15467 #CJK UNIFIED IDEOGRAPH
    {0xD9DF, 0x9FA0}, //15468 #CJK UNIFIED IDEOGRAPH
    {0xD9E0, 0x6C46}, //15469 #CJK UNIFIED IDEOGRAPH
    {0xD9E1, 0x7C74}, //15470 #CJK UNIFIED IDEOGRAPH
    {0xD9E2, 0x516E}, //15471 #CJK UNIFIED IDEOGRAPH
    {0xD9E3, 0x5DFD}, //15472 #CJK UNIFIED IDEOGRAPH
    {0xD9E4, 0x9EC9}, //15473 #CJK UNIFIED IDEOGRAPH
    {0xD9E5, 0x9998}, //15474 #CJK UNIFIED IDEOGRAPH
    {0xD9E6, 0x5181}, //15475 #CJK UNIFIED IDEOGRAPH
    {0xD9E7, 0x5914}, //15476 #CJK UNIFIED IDEOGRAPH
    {0xD9E8, 0x52F9}, //15477 #CJK UNIFIED IDEOGRAPH
    {0xD9E9, 0x530D}, //15478 #CJK UNIFIED IDEOGRAPH
    {0xD9EA, 0x8A07}, //15479 #CJK UNIFIED IDEOGRAPH
    {0xD9EB, 0x5310}, //15480 #CJK UNIFIED IDEOGRAPH
    {0xD9EC, 0x51EB}, //15481 #CJK UNIFIED IDEOGRAPH
    {0xD9ED, 0x5919}, //15482 #CJK UNIFIED IDEOGRAPH
    {0xD9EE, 0x5155}, //15483 #CJK UNIFIED IDEOGRAPH
    {0xD9EF, 0x4EA0}, //15484 #CJK UNIFIED IDEOGRAPH
    {0xD9F0, 0x5156}, //15485 #CJK UNIFIED IDEOGRAPH
    {0xD9F1, 0x4EB3}, //15486 #CJK UNIFIED IDEOGRAPH
    {0xD9F2, 0x886E}, //15487 #CJK UNIFIED IDEOGRAPH
    {0xD9F3, 0x88A4}, //15488 #CJK UNIFIED IDEOGRAPH
    {0xD9F4, 0x4EB5}, //15489 #CJK UNIFIED IDEOGRAPH
    {0xD9F5, 0x8114}, //15490 #CJK UNIFIED IDEOGRAPH
    {0xD9F6, 0x88D2}, //15491 #CJK UNIFIED IDEOGRAPH
    {0xD9F7, 0x7980}, //15492 #CJK UNIFIED IDEOGRAPH
    {0xD9F8, 0x5B34}, //15493 #CJK UNIFIED IDEOGRAPH
    {0xD9F9, 0x8803}, //15494 #CJK UNIFIED IDEOGRAPH
    {0xD9FA, 0x7FB8}, //15495 #CJK UNIFIED IDEOGRAPH
    {0xD9FB, 0x51AB}, //15496 #CJK UNIFIED IDEOGRAPH
    {0xD9FC, 0x51B1}, //15497 #CJK UNIFIED IDEOGRAPH
    {0xD9FD, 0x51BD}, //15498 #CJK UNIFIED IDEOGRAPH
    {0xD9FE, 0x51BC}, //15499 #CJK UNIFIED IDEOGRAPH
    {0xDA40, 0x8D0E}, //15500 #CJK UNIFIED IDEOGRAPH
    {0xDA41, 0x8D0F}, //15501 #CJK UNIFIED IDEOGRAPH
    {0xDA42, 0x8D10}, //15502 #CJK UNIFIED IDEOGRAPH
    {0xDA43, 0x8D11}, //15503 #CJK UNIFIED IDEOGRAPH
    {0xDA44, 0x8D12}, //15504 #CJK UNIFIED IDEOGRAPH
    {0xDA45, 0x8D13}, //15505 #CJK UNIFIED IDEOGRAPH
    {0xDA46, 0x8D14}, //15506 #CJK UNIFIED IDEOGRAPH
    {0xDA47, 0x8D15}, //15507 #CJK UNIFIED IDEOGRAPH
    {0xDA48, 0x8D16}, //15508 #CJK UNIFIED IDEOGRAPH
    {0xDA49, 0x8D17}, //15509 #CJK UNIFIED IDEOGRAPH
    {0xDA4A, 0x8D18}, //15510 #CJK UNIFIED IDEOGRAPH
    {0xDA4B, 0x8D19}, //15511 #CJK UNIFIED IDEOGRAPH
    {0xDA4C, 0x8D1A}, //15512 #CJK UNIFIED IDEOGRAPH
    {0xDA4D, 0x8D1B}, //15513 #CJK UNIFIED IDEOGRAPH
    {0xDA4E, 0x8D1C}, //15514 #CJK UNIFIED IDEOGRAPH
    {0xDA4F, 0x8D20}, //15515 #CJK UNIFIED IDEOGRAPH
    {0xDA50, 0x8D51}, //15516 #CJK UNIFIED IDEOGRAPH
    {0xDA51, 0x8D52}, //15517 #CJK UNIFIED IDEOGRAPH
    {0xDA52, 0x8D57}, //15518 #CJK UNIFIED IDEOGRAPH
    {0xDA53, 0x8D5F}, //15519 #CJK UNIFIED IDEOGRAPH
    {0xDA54, 0x8D65}, //15520 #CJK UNIFIED IDEOGRAPH
    {0xDA55, 0x8D68}, //15521 #CJK UNIFIED IDEOGRAPH
    {0xDA56, 0x8D69}, //15522 #CJK UNIFIED IDEOGRAPH
    {0xDA57, 0x8D6A}, //15523 #CJK UNIFIED IDEOGRAPH
    {0xDA58, 0x8D6C}, //15524 #CJK UNIFIED IDEOGRAPH
    {0xDA59, 0x8D6E}, //15525 #CJK UNIFIED IDEOGRAPH
    {0xDA5A, 0x8D6F}, //15526 #CJK UNIFIED IDEOGRAPH
    {0xDA5B, 0x8D71}, //15527 #CJK UNIFIED IDEOGRAPH
    {0xDA5C, 0x8D72}, //15528 #CJK UNIFIED IDEOGRAPH
    {0xDA5D, 0x8D78}, //15529 #CJK UNIFIED IDEOGRAPH
    {0xDA5E, 0x8D79}, //15530 #CJK UNIFIED IDEOGRAPH
    {0xDA5F, 0x8D7A}, //15531 #CJK UNIFIED IDEOGRAPH
    {0xDA60, 0x8D7B}, //15532 #CJK UNIFIED IDEOGRAPH
    {0xDA61, 0x8D7C}, //15533 #CJK UNIFIED IDEOGRAPH
    {0xDA62, 0x8D7D}, //15534 #CJK UNIFIED IDEOGRAPH
    {0xDA63, 0x8D7E}, //15535 #CJK UNIFIED IDEOGRAPH
    {0xDA64, 0x8D7F}, //15536 #CJK UNIFIED IDEOGRAPH
    {0xDA65, 0x8D80}, //15537 #CJK UNIFIED IDEOGRAPH
    {0xDA66, 0x8D82}, //15538 #CJK UNIFIED IDEOGRAPH
    {0xDA67, 0x8D83}, //15539 #CJK UNIFIED IDEOGRAPH
    {0xDA68, 0x8D86}, //15540 #CJK UNIFIED IDEOGRAPH
    {0xDA69, 0x8D87}, //15541 #CJK UNIFIED IDEOGRAPH
    {0xDA6A, 0x8D88}, //15542 #CJK UNIFIED IDEOGRAPH
    {0xDA6B, 0x8D89}, //15543 #CJK UNIFIED IDEOGRAPH
    {0xDA6C, 0x8D8C}, //15544 #CJK UNIFIED IDEOGRAPH
    {0xDA6D, 0x8D8D}, //15545 #CJK UNIFIED IDEOGRAPH
    {0xDA6E, 0x8D8E}, //15546 #CJK UNIFIED IDEOGRAPH
    {0xDA6F, 0x8D8F}, //15547 #CJK UNIFIED IDEOGRAPH
    {0xDA70, 0x8D90}, //15548 #CJK UNIFIED IDEOGRAPH
    {0xDA71, 0x8D92}, //15549 #CJK UNIFIED IDEOGRAPH
    {0xDA72, 0x8D93}, //15550 #CJK UNIFIED IDEOGRAPH
    {0xDA73, 0x8D95}, //15551 #CJK UNIFIED IDEOGRAPH
    {0xDA74, 0x8D96}, //15552 #CJK UNIFIED IDEOGRAPH
    {0xDA75, 0x8D97}, //15553 #CJK UNIFIED IDEOGRAPH
    {0xDA76, 0x8D98}, //15554 #CJK UNIFIED IDEOGRAPH
    {0xDA77, 0x8D99}, //15555 #CJK UNIFIED IDEOGRAPH
    {0xDA78, 0x8D9A}, //15556 #CJK UNIFIED IDEOGRAPH
    {0xDA79, 0x8D9B}, //15557 #CJK UNIFIED IDEOGRAPH
    {0xDA7A, 0x8D9C}, //15558 #CJK UNIFIED IDEOGRAPH
    {0xDA7B, 0x8D9D}, //15559 #CJK UNIFIED IDEOGRAPH
    {0xDA7C, 0x8D9E}, //15560 #CJK UNIFIED IDEOGRAPH
    {0xDA7D, 0x8DA0}, //15561 #CJK UNIFIED IDEOGRAPH
    {0xDA7E, 0x8DA1}, //15562 #CJK UNIFIED IDEOGRAPH
    {0xDA80, 0x8DA2}, //15563 #CJK UNIFIED IDEOGRAPH
    {0xDA81, 0x8DA4}, //15564 #CJK UNIFIED IDEOGRAPH
    {0xDA82, 0x8DA5}, //15565 #CJK UNIFIED IDEOGRAPH
    {0xDA83, 0x8DA6}, //15566 #CJK UNIFIED IDEOGRAPH
    {0xDA84, 0x8DA7}, //15567 #CJK UNIFIED IDEOGRAPH
    {0xDA85, 0x8DA8}, //15568 #CJK UNIFIED IDEOGRAPH
    {0xDA86, 0x8DA9}, //15569 #CJK UNIFIED IDEOGRAPH
    {0xDA87, 0x8DAA}, //15570 #CJK UNIFIED IDEOGRAPH
    {0xDA88, 0x8DAB}, //15571 #CJK UNIFIED IDEOGRAPH
    {0xDA89, 0x8DAC}, //15572 #CJK UNIFIED IDEOGRAPH
    {0xDA8A, 0x8DAD}, //15573 #CJK UNIFIED IDEOGRAPH
    {0xDA8B, 0x8DAE}, //15574 #CJK UNIFIED IDEOGRAPH
    {0xDA8C, 0x8DAF}, //15575 #CJK UNIFIED IDEOGRAPH
    {0xDA8D, 0x8DB0}, //15576 #CJK UNIFIED IDEOGRAPH
    {0xDA8E, 0x8DB2}, //15577 #CJK UNIFIED IDEOGRAPH
    {0xDA8F, 0x8DB6}, //15578 #CJK UNIFIED IDEOGRAPH
    {0xDA90, 0x8DB7}, //15579 #CJK UNIFIED IDEOGRAPH
    {0xDA91, 0x8DB9}, //15580 #CJK UNIFIED IDEOGRAPH
    {0xDA92, 0x8DBB}, //15581 #CJK UNIFIED IDEOGRAPH
    {0xDA93, 0x8DBD}, //15582 #CJK UNIFIED IDEOGRAPH
    {0xDA94, 0x8DC0}, //15583 #CJK UNIFIED IDEOGRAPH
    {0xDA95, 0x8DC1}, //15584 #CJK UNIFIED IDEOGRAPH
    {0xDA96, 0x8DC2}, //15585 #CJK UNIFIED IDEOGRAPH
    {0xDA97, 0x8DC5}, //15586 #CJK UNIFIED IDEOGRAPH
    {0xDA98, 0x8DC7}, //15587 #CJK UNIFIED IDEOGRAPH
    {0xDA99, 0x8DC8}, //15588 #CJK UNIFIED IDEOGRAPH
    {0xDA9A, 0x8DC9}, //15589 #CJK UNIFIED IDEOGRAPH
    {0xDA9B, 0x8DCA}, //15590 #CJK UNIFIED IDEOGRAPH
    {0xDA9C, 0x8DCD}, //15591 #CJK UNIFIED IDEOGRAPH
    {0xDA9D, 0x8DD0}, //15592 #CJK UNIFIED IDEOGRAPH
    {0xDA9E, 0x8DD2}, //15593 #CJK UNIFIED IDEOGRAPH
    {0xDA9F, 0x8DD3}, //15594 #CJK UNIFIED IDEOGRAPH
    {0xDAA0, 0x8DD4}, //15595 #CJK UNIFIED IDEOGRAPH
    {0xDAA1, 0x51C7}, //15596 #CJK UNIFIED IDEOGRAPH
    {0xDAA2, 0x5196}, //15597 #CJK UNIFIED IDEOGRAPH
    {0xDAA3, 0x51A2}, //15598 #CJK UNIFIED IDEOGRAPH
    {0xDAA4, 0x51A5}, //15599 #CJK UNIFIED IDEOGRAPH
    {0xDAA5, 0x8BA0}, //15600 #CJK UNIFIED IDEOGRAPH
    {0xDAA6, 0x8BA6}, //15601 #CJK UNIFIED IDEOGRAPH
    {0xDAA7, 0x8BA7}, //15602 #CJK UNIFIED IDEOGRAPH
    {0xDAA8, 0x8BAA}, //15603 #CJK UNIFIED IDEOGRAPH
    {0xDAA9, 0x8BB4}, //15604 #CJK UNIFIED IDEOGRAPH
    {0xDAAA, 0x8BB5}, //15605 #CJK UNIFIED IDEOGRAPH
    {0xDAAB, 0x8BB7}, //15606 #CJK UNIFIED IDEOGRAPH
    {0xDAAC, 0x8BC2}, //15607 #CJK UNIFIED IDEOGRAPH
    {0xDAAD, 0x8BC3}, //15608 #CJK UNIFIED IDEOGRAPH
    {0xDAAE, 0x8BCB}, //15609 #CJK UNIFIED IDEOGRAPH
    {0xDAAF, 0x8BCF}, //15610 #CJK UNIFIED IDEOGRAPH
    {0xDAB0, 0x8BCE}, //15611 #CJK UNIFIED IDEOGRAPH
    {0xDAB1, 0x8BD2}, //15612 #CJK UNIFIED IDEOGRAPH
    {0xDAB2, 0x8BD3}, //15613 #CJK UNIFIED IDEOGRAPH
    {0xDAB3, 0x8BD4}, //15614 #CJK UNIFIED IDEOGRAPH
    {0xDAB4, 0x8BD6}, //15615 #CJK UNIFIED IDEOGRAPH
    {0xDAB5, 0x8BD8}, //15616 #CJK UNIFIED IDEOGRAPH
    {0xDAB6, 0x8BD9}, //15617 #CJK UNIFIED IDEOGRAPH
    {0xDAB7, 0x8BDC}, //15618 #CJK UNIFIED IDEOGRAPH
    {0xDAB8, 0x8BDF}, //15619 #CJK UNIFIED IDEOGRAPH
    {0xDAB9, 0x8BE0}, //15620 #CJK UNIFIED IDEOGRAPH
    {0xDABA, 0x8BE4}, //15621 #CJK UNIFIED IDEOGRAPH
    {0xDABB, 0x8BE8}, //15622 #CJK UNIFIED IDEOGRAPH
    {0xDABC, 0x8BE9}, //15623 #CJK UNIFIED IDEOGRAPH
    {0xDABD, 0x8BEE}, //15624 #CJK UNIFIED IDEOGRAPH
    {0xDABE, 0x8BF0}, //15625 #CJK UNIFIED IDEOGRAPH
    {0xDABF, 0x8BF3}, //15626 #CJK UNIFIED IDEOGRAPH
    {0xDAC0, 0x8BF6}, //15627 #CJK UNIFIED IDEOGRAPH
    {0xDAC1, 0x8BF9}, //15628 #CJK UNIFIED IDEOGRAPH
    {0xDAC2, 0x8BFC}, //15629 #CJK UNIFIED IDEOGRAPH
    {0xDAC3, 0x8BFF}, //15630 #CJK UNIFIED IDEOGRAPH
    {0xDAC4, 0x8C00}, //15631 #CJK UNIFIED IDEOGRAPH
    {0xDAC5, 0x8C02}, //15632 #CJK UNIFIED IDEOGRAPH
    {0xDAC6, 0x8C04}, //15633 #CJK UNIFIED IDEOGRAPH
    {0xDAC7, 0x8C07}, //15634 #CJK UNIFIED IDEOGRAPH
    {0xDAC8, 0x8C0C}, //15635 #CJK UNIFIED IDEOGRAPH
    {0xDAC9, 0x8C0F}, //15636 #CJK UNIFIED IDEOGRAPH
    {0xDACA, 0x8C11}, //15637 #CJK UNIFIED IDEOGRAPH
    {0xDACB, 0x8C12}, //15638 #CJK UNIFIED IDEOGRAPH
    {0xDACC, 0x8C14}, //15639 #CJK UNIFIED IDEOGRAPH
    {0xDACD, 0x8C15}, //15640 #CJK UNIFIED IDEOGRAPH
    {0xDACE, 0x8C16}, //15641 #CJK UNIFIED IDEOGRAPH
    {0xDACF, 0x8C19}, //15642 #CJK UNIFIED IDEOGRAPH
    {0xDAD0, 0x8C1B}, //15643 #CJK UNIFIED IDEOGRAPH
    {0xDAD1, 0x8C18}, //15644 #CJK UNIFIED IDEOGRAPH
    {0xDAD2, 0x8C1D}, //15645 #CJK UNIFIED IDEOGRAPH
    {0xDAD3, 0x8C1F}, //15646 #CJK UNIFIED IDEOGRAPH
    {0xDAD4, 0x8C20}, //15647 #CJK UNIFIED IDEOGRAPH
    {0xDAD5, 0x8C21}, //15648 #CJK UNIFIED IDEOGRAPH
    {0xDAD6, 0x8C25}, //15649 #CJK UNIFIED IDEOGRAPH
    {0xDAD7, 0x8C27}, //15650 #CJK UNIFIED IDEOGRAPH
    {0xDAD8, 0x8C2A}, //15651 #CJK UNIFIED IDEOGRAPH
    {0xDAD9, 0x8C2B}, //15652 #CJK UNIFIED IDEOGRAPH
    {0xDADA, 0x8C2E}, //15653 #CJK UNIFIED IDEOGRAPH
    {0xDADB, 0x8C2F}, //15654 #CJK UNIFIED IDEOGRAPH
    {0xDADC, 0x8C32}, //15655 #CJK UNIFIED IDEOGRAPH
    {0xDADD, 0x8C33}, //15656 #CJK UNIFIED IDEOGRAPH
    {0xDADE, 0x8C35}, //15657 #CJK UNIFIED IDEOGRAPH
    {0xDADF, 0x8C36}, //15658 #CJK UNIFIED IDEOGRAPH
    {0xDAE0, 0x5369}, //15659 #CJK UNIFIED IDEOGRAPH
    {0xDAE1, 0x537A}, //15660 #CJK UNIFIED IDEOGRAPH
    {0xDAE2, 0x961D}, //15661 #CJK UNIFIED IDEOGRAPH
    {0xDAE3, 0x9622}, //15662 #CJK UNIFIED IDEOGRAPH
    {0xDAE4, 0x9621}, //15663 #CJK UNIFIED IDEOGRAPH
    {0xDAE5, 0x9631}, //15664 #CJK UNIFIED IDEOGRAPH
    {0xDAE6, 0x962A}, //15665 #CJK UNIFIED IDEOGRAPH
    {0xDAE7, 0x963D}, //15666 #CJK UNIFIED IDEOGRAPH
    {0xDAE8, 0x963C}, //15667 #CJK UNIFIED IDEOGRAPH
    {0xDAE9, 0x9642}, //15668 #CJK UNIFIED IDEOGRAPH
    {0xDAEA, 0x9649}, //15669 #CJK UNIFIED IDEOGRAPH
    {0xDAEB, 0x9654}, //15670 #CJK UNIFIED IDEOGRAPH
    {0xDAEC, 0x965F}, //15671 #CJK UNIFIED IDEOGRAPH
    {0xDAED, 0x9667}, //15672 #CJK UNIFIED IDEOGRAPH
    {0xDAEE, 0x966C}, //15673 #CJK UNIFIED IDEOGRAPH
    {0xDAEF, 0x9672}, //15674 #CJK UNIFIED IDEOGRAPH
    {0xDAF0, 0x9674}, //15675 #CJK UNIFIED IDEOGRAPH
    {0xDAF1, 0x9688}, //15676 #CJK UNIFIED IDEOGRAPH
    {0xDAF2, 0x968D}, //15677 #CJK UNIFIED IDEOGRAPH
    {0xDAF3, 0x9697}, //15678 #CJK UNIFIED IDEOGRAPH
    {0xDAF4, 0x96B0}, //15679 #CJK UNIFIED IDEOGRAPH
    {0xDAF5, 0x9097}, //15680 #CJK UNIFIED IDEOGRAPH
    {0xDAF6, 0x909B}, //15681 #CJK UNIFIED IDEOGRAPH
    {0xDAF7, 0x909D}, //15682 #CJK UNIFIED IDEOGRAPH
    {0xDAF8, 0x9099}, //15683 #CJK UNIFIED IDEOGRAPH
    {0xDAF9, 0x90AC}, //15684 #CJK UNIFIED IDEOGRAPH
    {0xDAFA, 0x90A1}, //15685 #CJK UNIFIED IDEOGRAPH
    {0xDAFB, 0x90B4}, //15686 #CJK UNIFIED IDEOGRAPH
    {0xDAFC, 0x90B3}, //15687 #CJK UNIFIED IDEOGRAPH
    {0xDAFD, 0x90B6}, //15688 #CJK UNIFIED IDEOGRAPH
    {0xDAFE, 0x90BA}, //15689 #CJK UNIFIED IDEOGRAPH
    {0xDB40, 0x8DD5}, //15690 #CJK UNIFIED IDEOGRAPH
    {0xDB41, 0x8DD8}, //15691 #CJK UNIFIED IDEOGRAPH
    {0xDB42, 0x8DD9}, //15692 #CJK UNIFIED IDEOGRAPH
    {0xDB43, 0x8DDC}, //15693 #CJK UNIFIED IDEOGRAPH
    {0xDB44, 0x8DE0}, //15694 #CJK UNIFIED IDEOGRAPH
    {0xDB45, 0x8DE1}, //15695 #CJK UNIFIED IDEOGRAPH
    {0xDB46, 0x8DE2}, //15696 #CJK UNIFIED IDEOGRAPH
    {0xDB47, 0x8DE5}, //15697 #CJK UNIFIED IDEOGRAPH
    {0xDB48, 0x8DE6}, //15698 #CJK UNIFIED IDEOGRAPH
    {0xDB49, 0x8DE7}, //15699 #CJK UNIFIED IDEOGRAPH
    {0xDB4A, 0x8DE9}, //15700 #CJK UNIFIED IDEOGRAPH
    {0xDB4B, 0x8DED}, //15701 #CJK UNIFIED IDEOGRAPH
    {0xDB4C, 0x8DEE}, //15702 #CJK UNIFIED IDEOGRAPH
    {0xDB4D, 0x8DF0}, //15703 #CJK UNIFIED IDEOGRAPH
    {0xDB4E, 0x8DF1}, //15704 #CJK UNIFIED IDEOGRAPH
    {0xDB4F, 0x8DF2}, //15705 #CJK UNIFIED IDEOGRAPH
    {0xDB50, 0x8DF4}, //15706 #CJK UNIFIED IDEOGRAPH
    {0xDB51, 0x8DF6}, //15707 #CJK UNIFIED IDEOGRAPH
    {0xDB52, 0x8DFC}, //15708 #CJK UNIFIED IDEOGRAPH
    {0xDB53, 0x8DFE}, //15709 #CJK UNIFIED IDEOGRAPH
    {0xDB54, 0x8DFF}, //15710 #CJK UNIFIED IDEOGRAPH
    {0xDB55, 0x8E00}, //15711 #CJK UNIFIED IDEOGRAPH
    {0xDB56, 0x8E01}, //15712 #CJK UNIFIED IDEOGRAPH
    {0xDB57, 0x8E02}, //15713 #CJK UNIFIED IDEOGRAPH
    {0xDB58, 0x8E03}, //15714 #CJK UNIFIED IDEOGRAPH
    {0xDB59, 0x8E04}, //15715 #CJK UNIFIED IDEOGRAPH
    {0xDB5A, 0x8E06}, //15716 #CJK UNIFIED IDEOGRAPH
    {0xDB5B, 0x8E07}, //15717 #CJK UNIFIED IDEOGRAPH
    {0xDB5C, 0x8E08}, //15718 #CJK UNIFIED IDEOGRAPH
    {0xDB5D, 0x8E0B}, //15719 #CJK UNIFIED IDEOGRAPH
    {0xDB5E, 0x8E0D}, //15720 #CJK UNIFIED IDEOGRAPH
    {0xDB5F, 0x8E0E}, //15721 #CJK UNIFIED IDEOGRAPH
    {0xDB60, 0x8E10}, //15722 #CJK UNIFIED IDEOGRAPH
    {0xDB61, 0x8E11}, //15723 #CJK UNIFIED IDEOGRAPH
    {0xDB62, 0x8E12}, //15724 #CJK UNIFIED IDEOGRAPH
    {0xDB63, 0x8E13}, //15725 #CJK UNIFIED IDEOGRAPH
    {0xDB64, 0x8E15}, //15726 #CJK UNIFIED IDEOGRAPH
    {0xDB65, 0x8E16}, //15727 #CJK UNIFIED IDEOGRAPH
    {0xDB66, 0x8E17}, //15728 #CJK UNIFIED IDEOGRAPH
    {0xDB67, 0x8E18}, //15729 #CJK UNIFIED IDEOGRAPH
    {0xDB68, 0x8E19}, //15730 #CJK UNIFIED IDEOGRAPH
    {0xDB69, 0x8E1A}, //15731 #CJK UNIFIED IDEOGRAPH
    {0xDB6A, 0x8E1B}, //15732 #CJK UNIFIED IDEOGRAPH
    {0xDB6B, 0x8E1C}, //15733 #CJK UNIFIED IDEOGRAPH
    {0xDB6C, 0x8E20}, //15734 #CJK UNIFIED IDEOGRAPH
    {0xDB6D, 0x8E21}, //15735 #CJK UNIFIED IDEOGRAPH
    {0xDB6E, 0x8E24}, //15736 #CJK UNIFIED IDEOGRAPH
    {0xDB6F, 0x8E25}, //15737 #CJK UNIFIED IDEOGRAPH
    {0xDB70, 0x8E26}, //15738 #CJK UNIFIED IDEOGRAPH
    {0xDB71, 0x8E27}, //15739 #CJK UNIFIED IDEOGRAPH
    {0xDB72, 0x8E28}, //15740 #CJK UNIFIED IDEOGRAPH
    {0xDB73, 0x8E2B}, //15741 #CJK UNIFIED IDEOGRAPH
    {0xDB74, 0x8E2D}, //15742 #CJK UNIFIED IDEOGRAPH
    {0xDB75, 0x8E30}, //15743 #CJK UNIFIED IDEOGRAPH
    {0xDB76, 0x8E32}, //15744 #CJK UNIFIED IDEOGRAPH
    {0xDB77, 0x8E33}, //15745 #CJK UNIFIED IDEOGRAPH
    {0xDB78, 0x8E34}, //15746 #CJK UNIFIED IDEOGRAPH
    {0xDB79, 0x8E36}, //15747 #CJK UNIFIED IDEOGRAPH
    {0xDB7A, 0x8E37}, //15748 #CJK UNIFIED IDEOGRAPH
    {0xDB7B, 0x8E38}, //15749 #CJK UNIFIED IDEOGRAPH
    {0xDB7C, 0x8E3B}, //15750 #CJK UNIFIED IDEOGRAPH
    {0xDB7D, 0x8E3C}, //15751 #CJK UNIFIED IDEOGRAPH
    {0xDB7E, 0x8E3E}, //15752 #CJK UNIFIED IDEOGRAPH
    {0xDB80, 0x8E3F}, //15753 #CJK UNIFIED IDEOGRAPH
    {0xDB81, 0x8E43}, //15754 #CJK UNIFIED IDEOGRAPH
    {0xDB82, 0x8E45}, //15755 #CJK UNIFIED IDEOGRAPH
    {0xDB83, 0x8E46}, //15756 #CJK UNIFIED IDEOGRAPH
    {0xDB84, 0x8E4C}, //15757 #CJK UNIFIED IDEOGRAPH
    {0xDB85, 0x8E4D}, //15758 #CJK UNIFIED IDEOGRAPH
    {0xDB86, 0x8E4E}, //15759 #CJK UNIFIED IDEOGRAPH
    {0xDB87, 0x8E4F}, //15760 #CJK UNIFIED IDEOGRAPH
    {0xDB88, 0x8E50}, //15761 #CJK UNIFIED IDEOGRAPH
    {0xDB89, 0x8E53}, //15762 #CJK UNIFIED IDEOGRAPH
    {0xDB8A, 0x8E54}, //15763 #CJK UNIFIED IDEOGRAPH
    {0xDB8B, 0x8E55}, //15764 #CJK UNIFIED IDEOGRAPH
    {0xDB8C, 0x8E56}, //15765 #CJK UNIFIED IDEOGRAPH
    {0xDB8D, 0x8E57}, //15766 #CJK UNIFIED IDEOGRAPH
    {0xDB8E, 0x8E58}, //15767 #CJK UNIFIED IDEOGRAPH
    {0xDB8F, 0x8E5A}, //15768 #CJK UNIFIED IDEOGRAPH
    {0xDB90, 0x8E5B}, //15769 #CJK UNIFIED IDEOGRAPH
    {0xDB91, 0x8E5C}, //15770 #CJK UNIFIED IDEOGRAPH
    {0xDB92, 0x8E5D}, //15771 #CJK UNIFIED IDEOGRAPH
    {0xDB93, 0x8E5E}, //15772 #CJK UNIFIED IDEOGRAPH
    {0xDB94, 0x8E5F}, //15773 #CJK UNIFIED IDEOGRAPH
    {0xDB95, 0x8E60}, //15774 #CJK UNIFIED IDEOGRAPH
    {0xDB96, 0x8E61}, //15775 #CJK UNIFIED IDEOGRAPH
    {0xDB97, 0x8E62}, //15776 #CJK UNIFIED IDEOGRAPH
    {0xDB98, 0x8E63}, //15777 #CJK UNIFIED IDEOGRAPH
    {0xDB99, 0x8E64}, //15778 #CJK UNIFIED IDEOGRAPH
    {0xDB9A, 0x8E65}, //15779 #CJK UNIFIED IDEOGRAPH
    {0xDB9B, 0x8E67}, //15780 #CJK UNIFIED IDEOGRAPH
    {0xDB9C, 0x8E68}, //15781 #CJK UNIFIED IDEOGRAPH
    {0xDB9D, 0x8E6A}, //15782 #CJK UNIFIED IDEOGRAPH
    {0xDB9E, 0x8E6B}, //15783 #CJK UNIFIED IDEOGRAPH
    {0xDB9F, 0x8E6E}, //15784 #CJK UNIFIED IDEOGRAPH
    {0xDBA0, 0x8E71}, //15785 #CJK UNIFIED IDEOGRAPH
    {0xDBA1, 0x90B8}, //15786 #CJK UNIFIED IDEOGRAPH
    {0xDBA2, 0x90B0}, //15787 #CJK UNIFIED IDEOGRAPH
    {0xDBA3, 0x90CF}, //15788 #CJK UNIFIED IDEOGRAPH
    {0xDBA4, 0x90C5}, //15789 #CJK UNIFIED IDEOGRAPH
    {0xDBA5, 0x90BE}, //15790 #CJK UNIFIED IDEOGRAPH
    {0xDBA6, 0x90D0}, //15791 #CJK UNIFIED IDEOGRAPH
    {0xDBA7, 0x90C4}, //15792 #CJK UNIFIED IDEOGRAPH
    {0xDBA8, 0x90C7}, //15793 #CJK UNIFIED IDEOGRAPH
    {0xDBA9, 0x90D3}, //15794 #CJK UNIFIED IDEOGRAPH
    {0xDBAA, 0x90E6}, //15795 #CJK UNIFIED IDEOGRAPH
    {0xDBAB, 0x90E2}, //15796 #CJK UNIFIED IDEOGRAPH
    {0xDBAC, 0x90DC}, //15797 #CJK UNIFIED IDEOGRAPH
    {0xDBAD, 0x90D7}, //15798 #CJK UNIFIED IDEOGRAPH
    {0xDBAE, 0x90DB}, //15799 #CJK UNIFIED IDEOGRAPH
    {0xDBAF, 0x90EB}, //15800 #CJK UNIFIED IDEOGRAPH
    {0xDBB0, 0x90EF}, //15801 #CJK UNIFIED IDEOGRAPH
    {0xDBB1, 0x90FE}, //15802 #CJK UNIFIED IDEOGRAPH
    {0xDBB2, 0x9104}, //15803 #CJK UNIFIED IDEOGRAPH
    {0xDBB3, 0x9122}, //15804 #CJK UNIFIED IDEOGRAPH
    {0xDBB4, 0x911E}, //15805 #CJK UNIFIED IDEOGRAPH
    {0xDBB5, 0x9123}, //15806 #CJK UNIFIED IDEOGRAPH
    {0xDBB6, 0x9131}, //15807 #CJK UNIFIED IDEOGRAPH
    {0xDBB7, 0x912F}, //15808 #CJK UNIFIED IDEOGRAPH
    {0xDBB8, 0x9139}, //15809 #CJK UNIFIED IDEOGRAPH
    {0xDBB9, 0x9143}, //15810 #CJK UNIFIED IDEOGRAPH
    {0xDBBA, 0x9146}, //15811 #CJK UNIFIED IDEOGRAPH
    {0xDBBB, 0x520D}, //15812 #CJK UNIFIED IDEOGRAPH
    {0xDBBC, 0x5942}, //15813 #CJK UNIFIED IDEOGRAPH
    {0xDBBD, 0x52A2}, //15814 #CJK UNIFIED IDEOGRAPH
    {0xDBBE, 0x52AC}, //15815 #CJK UNIFIED IDEOGRAPH
    {0xDBBF, 0x52AD}, //15816 #CJK UNIFIED IDEOGRAPH
    {0xDBC0, 0x52BE}, //15817 #CJK UNIFIED IDEOGRAPH
    {0xDBC1, 0x54FF}, //15818 #CJK UNIFIED IDEOGRAPH
    {0xDBC2, 0x52D0}, //15819 #CJK UNIFIED IDEOGRAPH
    {0xDBC3, 0x52D6}, //15820 #CJK UNIFIED IDEOGRAPH
    {0xDBC4, 0x52F0}, //15821 #CJK UNIFIED IDEOGRAPH
    {0xDBC5, 0x53DF}, //15822 #CJK UNIFIED IDEOGRAPH
    {0xDBC6, 0x71EE}, //15823 #CJK UNIFIED IDEOGRAPH
    {0xDBC7, 0x77CD}, //15824 #CJK UNIFIED IDEOGRAPH
    {0xDBC8, 0x5EF4}, //15825 #CJK UNIFIED IDEOGRAPH
    {0xDBC9, 0x51F5}, //15826 #CJK UNIFIED IDEOGRAPH
    {0xDBCA, 0x51FC}, //15827 #CJK UNIFIED IDEOGRAPH
    {0xDBCB, 0x9B2F}, //15828 #CJK UNIFIED IDEOGRAPH
    {0xDBCC, 0x53B6}, //15829 #CJK UNIFIED IDEOGRAPH
    {0xDBCD, 0x5F01}, //15830 #CJK UNIFIED IDEOGRAPH
    {0xDBCE, 0x755A}, //15831 #CJK UNIFIED IDEOGRAPH
    {0xDBCF, 0x5DEF}, //15832 #CJK UNIFIED IDEOGRAPH
    {0xDBD0, 0x574C}, //15833 #CJK UNIFIED IDEOGRAPH
    {0xDBD1, 0x57A9}, //15834 #CJK UNIFIED IDEOGRAPH
    {0xDBD2, 0x57A1}, //15835 #CJK UNIFIED IDEOGRAPH
    {0xDBD3, 0x587E}, //15836 #CJK UNIFIED IDEOGRAPH
    {0xDBD4, 0x58BC}, //15837 #CJK UNIFIED IDEOGRAPH
    {0xDBD5, 0x58C5}, //15838 #CJK UNIFIED IDEOGRAPH
    {0xDBD6, 0x58D1}, //15839 #CJK UNIFIED IDEOGRAPH
    {0xDBD7, 0x5729}, //15840 #CJK UNIFIED IDEOGRAPH
    {0xDBD8, 0x572C}, //15841 #CJK UNIFIED IDEOGRAPH
    {0xDBD9, 0x572A}, //15842 #CJK UNIFIED IDEOGRAPH
    {0xDBDA, 0x5733}, //15843 #CJK UNIFIED IDEOGRAPH
    {0xDBDB, 0x5739}, //15844 #CJK UNIFIED IDEOGRAPH
    {0xDBDC, 0x572E}, //15845 #CJK UNIFIED IDEOGRAPH
    {0xDBDD, 0x572F}, //15846 #CJK UNIFIED IDEOGRAPH
    {0xDBDE, 0x575C}, //15847 #CJK UNIFIED IDEOGRAPH
    {0xDBDF, 0x573B}, //15848 #CJK UNIFIED IDEOGRAPH
    {0xDBE0, 0x5742}, //15849 #CJK UNIFIED IDEOGRAPH
    {0xDBE1, 0x5769}, //15850 #CJK UNIFIED IDEOGRAPH
    {0xDBE2, 0x5785}, //15851 #CJK UNIFIED IDEOGRAPH
    {0xDBE3, 0x576B}, //15852 #CJK UNIFIED IDEOGRAPH
    {0xDBE4, 0x5786}, //15853 #CJK UNIFIED IDEOGRAPH
    {0xDBE5, 0x577C}, //15854 #CJK UNIFIED IDEOGRAPH
    {0xDBE6, 0x577B}, //15855 #CJK UNIFIED IDEOGRAPH
    {0xDBE7, 0x5768}, //15856 #CJK UNIFIED IDEOGRAPH
    {0xDBE8, 0x576D}, //15857 #CJK UNIFIED IDEOGRAPH
    {0xDBE9, 0x5776}, //15858 #CJK UNIFIED IDEOGRAPH
    {0xDBEA, 0x5773}, //15859 #CJK UNIFIED IDEOGRAPH
    {0xDBEB, 0x57AD}, //15860 #CJK UNIFIED IDEOGRAPH
    {0xDBEC, 0x57A4}, //15861 #CJK UNIFIED IDEOGRAPH
    {0xDBED, 0x578C}, //15862 #CJK UNIFIED IDEOGRAPH
    {0xDBEE, 0x57B2}, //15863 #CJK UNIFIED IDEOGRAPH
    {0xDBEF, 0x57CF}, //15864 #CJK UNIFIED IDEOGRAPH
    {0xDBF0, 0x57A7}, //15865 #CJK UNIFIED IDEOGRAPH
    {0xDBF1, 0x57B4}, //15866 #CJK UNIFIED IDEOGRAPH
    {0xDBF2, 0x5793}, //15867 #CJK UNIFIED IDEOGRAPH
    {0xDBF3, 0x57A0}, //15868 #CJK UNIFIED IDEOGRAPH
    {0xDBF4, 0x57D5}, //15869 #CJK UNIFIED IDEOGRAPH
    {0xDBF5, 0x57D8}, //15870 #CJK UNIFIED IDEOGRAPH
    {0xDBF6, 0x57DA}, //15871 #CJK UNIFIED IDEOGRAPH
    {0xDBF7, 0x57D9}, //15872 #CJK UNIFIED IDEOGRAPH
    {0xDBF8, 0x57D2}, //15873 #CJK UNIFIED IDEOGRAPH
    {0xDBF9, 0x57B8}, //15874 #CJK UNIFIED IDEOGRAPH
    {0xDBFA, 0x57F4}, //15875 #CJK UNIFIED IDEOGRAPH
    {0xDBFB, 0x57EF}, //15876 #CJK UNIFIED IDEOGRAPH
    {0xDBFC, 0x57F8}, //15877 #CJK UNIFIED IDEOGRAPH
    {0xDBFD, 0x57E4}, //15878 #CJK UNIFIED IDEOGRAPH
    {0xDBFE, 0x57DD}, //15879 #CJK UNIFIED IDEOGRAPH
    {0xDC40, 0x8E73}, //15880 #CJK UNIFIED IDEOGRAPH
    {0xDC41, 0x8E75}, //15881 #CJK UNIFIED IDEOGRAPH
    {0xDC42, 0x8E77}, //15882 #CJK UNIFIED IDEOGRAPH
    {0xDC43, 0x8E78}, //15883 #CJK UNIFIED IDEOGRAPH
    {0xDC44, 0x8E79}, //15884 #CJK UNIFIED IDEOGRAPH
    {0xDC45, 0x8E7A}, //15885 #CJK UNIFIED IDEOGRAPH
    {0xDC46, 0x8E7B}, //15886 #CJK UNIFIED IDEOGRAPH
    {0xDC47, 0x8E7D}, //15887 #CJK UNIFIED IDEOGRAPH
    {0xDC48, 0x8E7E}, //15888 #CJK UNIFIED IDEOGRAPH
    {0xDC49, 0x8E80}, //15889 #CJK UNIFIED IDEOGRAPH
    {0xDC4A, 0x8E82}, //15890 #CJK UNIFIED IDEOGRAPH
    {0xDC4B, 0x8E83}, //15891 #CJK UNIFIED IDEOGRAPH
    {0xDC4C, 0x8E84}, //15892 #CJK UNIFIED IDEOGRAPH
    {0xDC4D, 0x8E86}, //15893 #CJK UNIFIED IDEOGRAPH
    {0xDC4E, 0x8E88}, //15894 #CJK UNIFIED IDEOGRAPH
    {0xDC4F, 0x8E89}, //15895 #CJK UNIFIED IDEOGRAPH
    {0xDC50, 0x8E8A}, //15896 #CJK UNIFIED IDEOGRAPH
    {0xDC51, 0x8E8B}, //15897 #CJK UNIFIED IDEOGRAPH
    {0xDC52, 0x8E8C}, //15898 #CJK UNIFIED IDEOGRAPH
    {0xDC53, 0x8E8D}, //15899 #CJK UNIFIED IDEOGRAPH
    {0xDC54, 0x8E8E}, //15900 #CJK UNIFIED IDEOGRAPH
    {0xDC55, 0x8E91}, //15901 #CJK UNIFIED IDEOGRAPH
    {0xDC56, 0x8E92}, //15902 #CJK UNIFIED IDEOGRAPH
    {0xDC57, 0x8E93}, //15903 #CJK UNIFIED IDEOGRAPH
    {0xDC58, 0x8E95}, //15904 #CJK UNIFIED IDEOGRAPH
    {0xDC59, 0x8E96}, //15905 #CJK UNIFIED IDEOGRAPH
    {0xDC5A, 0x8E97}, //15906 #CJK UNIFIED IDEOGRAPH
    {0xDC5B, 0x8E98}, //15907 #CJK UNIFIED IDEOGRAPH
    {0xDC5C, 0x8E99}, //15908 #CJK UNIFIED IDEOGRAPH
    {0xDC5D, 0x8E9A}, //15909 #CJK UNIFIED IDEOGRAPH
    {0xDC5E, 0x8E9B}, //15910 #CJK UNIFIED IDEOGRAPH
    {0xDC5F, 0x8E9D}, //15911 #CJK UNIFIED IDEOGRAPH
    {0xDC60, 0x8E9F}, //15912 #CJK UNIFIED IDEOGRAPH
    {0xDC61, 0x8EA0}, //15913 #CJK UNIFIED IDEOGRAPH
    {0xDC62, 0x8EA1}, //15914 #CJK UNIFIED IDEOGRAPH
    {0xDC63, 0x8EA2}, //15915 #CJK UNIFIED IDEOGRAPH
    {0xDC64, 0x8EA3}, //15916 #CJK UNIFIED IDEOGRAPH
    {0xDC65, 0x8EA4}, //15917 #CJK UNIFIED IDEOGRAPH
    {0xDC66, 0x8EA5}, //15918 #CJK UNIFIED IDEOGRAPH
    {0xDC67, 0x8EA6}, //15919 #CJK UNIFIED IDEOGRAPH
    {0xDC68, 0x8EA7}, //15920 #CJK UNIFIED IDEOGRAPH
    {0xDC69, 0x8EA8}, //15921 #CJK UNIFIED IDEOGRAPH
    {0xDC6A, 0x8EA9}, //15922 #CJK UNIFIED IDEOGRAPH
    {0xDC6B, 0x8EAA}, //15923 #CJK UNIFIED IDEOGRAPH
    {0xDC6C, 0x8EAD}, //15924 #CJK UNIFIED IDEOGRAPH
    {0xDC6D, 0x8EAE}, //15925 #CJK UNIFIED IDEOGRAPH
    {0xDC6E, 0x8EB0}, //15926 #CJK UNIFIED IDEOGRAPH
    {0xDC6F, 0x8EB1}, //15927 #CJK UNIFIED IDEOGRAPH
    {0xDC70, 0x8EB3}, //15928 #CJK UNIFIED IDEOGRAPH
    {0xDC71, 0x8EB4}, //15929 #CJK UNIFIED IDEOGRAPH
    {0xDC72, 0x8EB5}, //15930 #CJK UNIFIED IDEOGRAPH
    {0xDC73, 0x8EB6}, //15931 #CJK UNIFIED IDEOGRAPH
    {0xDC74, 0x8EB7}, //15932 #CJK UNIFIED IDEOGRAPH
    {0xDC75, 0x8EB8}, //15933 #CJK UNIFIED IDEOGRAPH
    {0xDC76, 0x8EB9}, //15934 #CJK UNIFIED IDEOGRAPH
    {0xDC77, 0x8EBB}, //15935 #CJK UNIFIED IDEOGRAPH
    {0xDC78, 0x8EBC}, //15936 #CJK UNIFIED IDEOGRAPH
    {0xDC79, 0x8EBD}, //15937 #CJK UNIFIED IDEOGRAPH
    {0xDC7A, 0x8EBE}, //15938 #CJK UNIFIED IDEOGRAPH
    {0xDC7B, 0x8EBF}, //15939 #CJK UNIFIED IDEOGRAPH
    {0xDC7C, 0x8EC0}, //15940 #CJK UNIFIED IDEOGRAPH
    {0xDC7D, 0x8EC1}, //15941 #CJK UNIFIED IDEOGRAPH
    {0xDC7E, 0x8EC2}, //15942 #CJK UNIFIED IDEOGRAPH
    {0xDC80, 0x8EC3}, //15943 #CJK UNIFIED IDEOGRAPH
    {0xDC81, 0x8EC4}, //15944 #CJK UNIFIED IDEOGRAPH
    {0xDC82, 0x8EC5}, //15945 #CJK UNIFIED IDEOGRAPH
    {0xDC83, 0x8EC6}, //15946 #CJK UNIFIED IDEOGRAPH
    {0xDC84, 0x8EC7}, //15947 #CJK UNIFIED IDEOGRAPH
    {0xDC85, 0x8EC8}, //15948 #CJK UNIFIED IDEOGRAPH
    {0xDC86, 0x8EC9}, //15949 #CJK UNIFIED IDEOGRAPH
    {0xDC87, 0x8ECA}, //15950 #CJK UNIFIED IDEOGRAPH
    {0xDC88, 0x8ECB}, //15951 #CJK UNIFIED IDEOGRAPH
    {0xDC89, 0x8ECC}, //15952 #CJK UNIFIED IDEOGRAPH
    {0xDC8A, 0x8ECD}, //15953 #CJK UNIFIED IDEOGRAPH
    {0xDC8B, 0x8ECF}, //15954 #CJK UNIFIED IDEOGRAPH
    {0xDC8C, 0x8ED0}, //15955 #CJK UNIFIED IDEOGRAPH
    {0xDC8D, 0x8ED1}, //15956 #CJK UNIFIED IDEOGRAPH
    {0xDC8E, 0x8ED2}, //15957 #CJK UNIFIED IDEOGRAPH
    {0xDC8F, 0x8ED3}, //15958 #CJK UNIFIED IDEOGRAPH
    {0xDC90, 0x8ED4}, //15959 #CJK UNIFIED IDEOGRAPH
    {0xDC91, 0x8ED5}, //15960 #CJK UNIFIED IDEOGRAPH
    {0xDC92, 0x8ED6}, //15961 #CJK UNIFIED IDEOGRAPH
    {0xDC93, 0x8ED7}, //15962 #CJK UNIFIED IDEOGRAPH
    {0xDC94, 0x8ED8}, //15963 #CJK UNIFIED IDEOGRAPH
    {0xDC95, 0x8ED9}, //15964 #CJK UNIFIED IDEOGRAPH
    {0xDC96, 0x8EDA}, //15965 #CJK UNIFIED IDEOGRAPH
    {0xDC97, 0x8EDB}, //15966 #CJK UNIFIED IDEOGRAPH
    {0xDC98, 0x8EDC}, //15967 #CJK UNIFIED IDEOGRAPH
    {0xDC99, 0x8EDD}, //15968 #CJK UNIFIED IDEOGRAPH
    {0xDC9A, 0x8EDE}, //15969 #CJK UNIFIED IDEOGRAPH
    {0xDC9B, 0x8EDF}, //15970 #CJK UNIFIED IDEOGRAPH
    {0xDC9C, 0x8EE0}, //15971 #CJK UNIFIED IDEOGRAPH
    {0xDC9D, 0x8EE1}, //15972 #CJK UNIFIED IDEOGRAPH
    {0xDC9E, 0x8EE2}, //15973 #CJK UNIFIED IDEOGRAPH
    {0xDC9F, 0x8EE3}, //15974 #CJK UNIFIED IDEOGRAPH
    {0xDCA0, 0x8EE4}, //15975 #CJK UNIFIED IDEOGRAPH
    {0xDCA1, 0x580B}, //15976 #CJK UNIFIED IDEOGRAPH
    {0xDCA2, 0x580D}, //15977 #CJK UNIFIED IDEOGRAPH
    {0xDCA3, 0x57FD}, //15978 #CJK UNIFIED IDEOGRAPH
    {0xDCA4, 0x57ED}, //15979 #CJK UNIFIED IDEOGRAPH
    {0xDCA5, 0x5800}, //15980 #CJK UNIFIED IDEOGRAPH
    {0xDCA6, 0x581E}, //15981 #CJK UNIFIED IDEOGRAPH
    {0xDCA7, 0x5819}, //15982 #CJK UNIFIED IDEOGRAPH
    {0xDCA8, 0x5844}, //15983 #CJK UNIFIED IDEOGRAPH
    {0xDCA9, 0x5820}, //15984 #CJK UNIFIED IDEOGRAPH
    {0xDCAA, 0x5865}, //15985 #CJK UNIFIED IDEOGRAPH
    {0xDCAB, 0x586C}, //15986 #CJK UNIFIED IDEOGRAPH
    {0xDCAC, 0x5881}, //15987 #CJK UNIFIED IDEOGRAPH
    {0xDCAD, 0x5889}, //15988 #CJK UNIFIED IDEOGRAPH
    {0xDCAE, 0x589A}, //15989 #CJK UNIFIED IDEOGRAPH
    {0xDCAF, 0x5880}, //15990 #CJK UNIFIED IDEOGRAPH
    {0xDCB0, 0x99A8}, //15991 #CJK UNIFIED IDEOGRAPH
    {0xDCB1, 0x9F19}, //15992 #CJK UNIFIED IDEOGRAPH
    {0xDCB2, 0x61FF}, //15993 #CJK UNIFIED IDEOGRAPH
    {0xDCB3, 0x8279}, //15994 #CJK UNIFIED IDEOGRAPH
    {0xDCB4, 0x827D}, //15995 #CJK UNIFIED IDEOGRAPH
    {0xDCB5, 0x827F}, //15996 #CJK UNIFIED IDEOGRAPH
    {0xDCB6, 0x828F}, //15997 #CJK UNIFIED IDEOGRAPH
    {0xDCB7, 0x828A}, //15998 #CJK UNIFIED IDEOGRAPH
    {0xDCB8, 0x82A8}, //15999 #CJK UNIFIED IDEOGRAPH
    {0xDCB9, 0x8284}, //16000 #CJK UNIFIED IDEOGRAPH
    {0xDCBA, 0x828E}, //16001 #CJK UNIFIED IDEOGRAPH
    {0xDCBB, 0x8291}, //16002 #CJK UNIFIED IDEOGRAPH
    {0xDCBC, 0x8297}, //16003 #CJK UNIFIED IDEOGRAPH
    {0xDCBD, 0x8299}, //16004 #CJK UNIFIED IDEOGRAPH
    {0xDCBE, 0x82AB}, //16005 #CJK UNIFIED IDEOGRAPH
    {0xDCBF, 0x82B8}, //16006 #CJK UNIFIED IDEOGRAPH
    {0xDCC0, 0x82BE}, //16007 #CJK UNIFIED IDEOGRAPH
    {0xDCC1, 0x82B0}, //16008 #CJK UNIFIED IDEOGRAPH
    {0xDCC2, 0x82C8}, //16009 #CJK UNIFIED IDEOGRAPH
    {0xDCC3, 0x82CA}, //16010 #CJK UNIFIED IDEOGRAPH
    {0xDCC4, 0x82E3}, //16011 #CJK UNIFIED IDEOGRAPH
    {0xDCC5, 0x8298}, //16012 #CJK UNIFIED IDEOGRAPH
    {0xDCC6, 0x82B7}, //16013 #CJK UNIFIED IDEOGRAPH
    {0xDCC7, 0x82AE}, //16014 #CJK UNIFIED IDEOGRAPH
    {0xDCC8, 0x82CB}, //16015 #CJK UNIFIED IDEOGRAPH
    {0xDCC9, 0x82CC}, //16016 #CJK UNIFIED IDEOGRAPH
    {0xDCCA, 0x82C1}, //16017 #CJK UNIFIED IDEOGRAPH
    {0xDCCB, 0x82A9}, //16018 #CJK UNIFIED IDEOGRAPH
    {0xDCCC, 0x82B4}, //16019 #CJK UNIFIED IDEOGRAPH
    {0xDCCD, 0x82A1}, //16020 #CJK UNIFIED IDEOGRAPH
    {0xDCCE, 0x82AA}, //16021 #CJK UNIFIED IDEOGRAPH
    {0xDCCF, 0x829F}, //16022 #CJK UNIFIED IDEOGRAPH
    {0xDCD0, 0x82C4}, //16023 #CJK UNIFIED IDEOGRAPH
    {0xDCD1, 0x82CE}, //16024 #CJK UNIFIED IDEOGRAPH
    {0xDCD2, 0x82A4}, //16025 #CJK UNIFIED IDEOGRAPH
    {0xDCD3, 0x82E1}, //16026 #CJK UNIFIED IDEOGRAPH
    {0xDCD4, 0x8309}, //16027 #CJK UNIFIED IDEOGRAPH
    {0xDCD5, 0x82F7}, //16028 #CJK UNIFIED IDEOGRAPH
    {0xDCD6, 0x82E4}, //16029 #CJK UNIFIED IDEOGRAPH
    {0xDCD7, 0x830F}, //16030 #CJK UNIFIED IDEOGRAPH
    {0xDCD8, 0x8307}, //16031 #CJK UNIFIED IDEOGRAPH
    {0xDCD9, 0x82DC}, //16032 #CJK UNIFIED IDEOGRAPH
    {0xDCDA, 0x82F4}, //16033 #CJK UNIFIED IDEOGRAPH
    {0xDCDB, 0x82D2}, //16034 #CJK UNIFIED IDEOGRAPH
    {0xDCDC, 0x82D8}, //16035 #CJK UNIFIED IDEOGRAPH
    {0xDCDD, 0x830C}, //16036 #CJK UNIFIED IDEOGRAPH
    {0xDCDE, 0x82FB}, //16037 #CJK UNIFIED IDEOGRAPH
    {0xDCDF, 0x82D3}, //16038 #CJK UNIFIED IDEOGRAPH
    {0xDCE0, 0x8311}, //16039 #CJK UNIFIED IDEOGRAPH
    {0xDCE1, 0x831A}, //16040 #CJK UNIFIED IDEOGRAPH
    {0xDCE2, 0x8306}, //16041 #CJK UNIFIED IDEOGRAPH
    {0xDCE3, 0x8314}, //16042 #CJK UNIFIED IDEOGRAPH
    {0xDCE4, 0x8315}, //16043 #CJK UNIFIED IDEOGRAPH
    {0xDCE5, 0x82E0}, //16044 #CJK UNIFIED IDEOGRAPH
    {0xDCE6, 0x82D5}, //16045 #CJK UNIFIED IDEOGRAPH
    {0xDCE7, 0x831C}, //16046 #CJK UNIFIED IDEOGRAPH
    {0xDCE8, 0x8351}, //16047 #CJK UNIFIED IDEOGRAPH
    {0xDCE9, 0x835B}, //16048 #CJK UNIFIED IDEOGRAPH
    {0xDCEA, 0x835C}, //16049 #CJK UNIFIED IDEOGRAPH
    {0xDCEB, 0x8308}, //16050 #CJK UNIFIED IDEOGRAPH
    {0xDCEC, 0x8392}, //16051 #CJK UNIFIED IDEOGRAPH
    {0xDCED, 0x833C}, //16052 #CJK UNIFIED IDEOGRAPH
    {0xDCEE, 0x8334}, //16053 #CJK UNIFIED IDEOGRAPH
    {0xDCEF, 0x8331}, //16054 #CJK UNIFIED IDEOGRAPH
    {0xDCF0, 0x839B}, //16055 #CJK UNIFIED IDEOGRAPH
    {0xDCF1, 0x835E}, //16056 #CJK UNIFIED IDEOGRAPH
    {0xDCF2, 0x832F}, //16057 #CJK UNIFIED IDEOGRAPH
    {0xDCF3, 0x834F}, //16058 #CJK UNIFIED IDEOGRAPH
    {0xDCF4, 0x8347}, //16059 #CJK UNIFIED IDEOGRAPH
    {0xDCF5, 0x8343}, //16060 #CJK UNIFIED IDEOGRAPH
    {0xDCF6, 0x835F}, //16061 #CJK UNIFIED IDEOGRAPH
    {0xDCF7, 0x8340}, //16062 #CJK UNIFIED IDEOGRAPH
    {0xDCF8, 0x8317}, //16063 #CJK UNIFIED IDEOGRAPH
    {0xDCF9, 0x8360}, //16064 #CJK UNIFIED IDEOGRAPH
    {0xDCFA, 0x832D}, //16065 #CJK UNIFIED IDEOGRAPH
    {0xDCFB, 0x833A}, //16066 #CJK UNIFIED IDEOGRAPH
    {0xDCFC, 0x8333}, //16067 #CJK UNIFIED IDEOGRAPH
    {0xDCFD, 0x8366}, //16068 #CJK UNIFIED IDEOGRAPH
    {0xDCFE, 0x8365}, //16069 #CJK UNIFIED IDEOGRAPH
    {0xDD40, 0x8EE5}, //16070 #CJK UNIFIED IDEOGRAPH
    {0xDD41, 0x8EE6}, //16071 #CJK UNIFIED IDEOGRAPH
    {0xDD42, 0x8EE7}, //16072 #CJK UNIFIED IDEOGRAPH
    {0xDD43, 0x8EE8}, //16073 #CJK UNIFIED IDEOGRAPH
    {0xDD44, 0x8EE9}, //16074 #CJK UNIFIED IDEOGRAPH
    {0xDD45, 0x8EEA}, //16075 #CJK UNIFIED IDEOGRAPH
    {0xDD46, 0x8EEB}, //16076 #CJK UNIFIED IDEOGRAPH
    {0xDD47, 0x8EEC}, //16077 #CJK UNIFIED IDEOGRAPH
    {0xDD48, 0x8EED}, //16078 #CJK UNIFIED IDEOGRAPH
    {0xDD49, 0x8EEE}, //16079 #CJK UNIFIED IDEOGRAPH
    {0xDD4A, 0x8EEF}, //16080 #CJK UNIFIED IDEOGRAPH
    {0xDD4B, 0x8EF0}, //16081 #CJK UNIFIED IDEOGRAPH
    {0xDD4C, 0x8EF1}, //16082 #CJK UNIFIED IDEOGRAPH
    {0xDD4D, 0x8EF2}, //16083 #CJK UNIFIED IDEOGRAPH
    {0xDD4E, 0x8EF3}, //16084 #CJK UNIFIED IDEOGRAPH
    {0xDD4F, 0x8EF4}, //16085 #CJK UNIFIED IDEOGRAPH
    {0xDD50, 0x8EF5}, //16086 #CJK UNIFIED IDEOGRAPH
    {0xDD51, 0x8EF6}, //16087 #CJK UNIFIED IDEOGRAPH
    {0xDD52, 0x8EF7}, //16088 #CJK UNIFIED IDEOGRAPH
    {0xDD53, 0x8EF8}, //16089 #CJK UNIFIED IDEOGRAPH
    {0xDD54, 0x8EF9}, //16090 #CJK UNIFIED IDEOGRAPH
    {0xDD55, 0x8EFA}, //16091 #CJK UNIFIED IDEOGRAPH
    {0xDD56, 0x8EFB}, //16092 #CJK UNIFIED IDEOGRAPH
    {0xDD57, 0x8EFC}, //16093 #CJK UNIFIED IDEOGRAPH
    {0xDD58, 0x8EFD}, //16094 #CJK UNIFIED IDEOGRAPH
    {0xDD59, 0x8EFE}, //16095 #CJK UNIFIED IDEOGRAPH
    {0xDD5A, 0x8EFF}, //16096 #CJK UNIFIED IDEOGRAPH
    {0xDD5B, 0x8F00}, //16097 #CJK UNIFIED IDEOGRAPH
    {0xDD5C, 0x8F01}, //16098 #CJK UNIFIED IDEOGRAPH
    {0xDD5D, 0x8F02}, //16099 #CJK UNIFIED IDEOGRAPH
    {0xDD5E, 0x8F03}, //16100 #CJK UNIFIED IDEOGRAPH
    {0xDD5F, 0x8F04}, //16101 #CJK UNIFIED IDEOGRAPH
    {0xDD60, 0x8F05}, //16102 #CJK UNIFIED IDEOGRAPH
    {0xDD61, 0x8F06}, //16103 #CJK UNIFIED IDEOGRAPH
    {0xDD62, 0x8F07}, //16104 #CJK UNIFIED IDEOGRAPH
    {0xDD63, 0x8F08}, //16105 #CJK UNIFIED IDEOGRAPH
    {0xDD64, 0x8F09}, //16106 #CJK UNIFIED IDEOGRAPH
    {0xDD65, 0x8F0A}, //16107 #CJK UNIFIED IDEOGRAPH
    {0xDD66, 0x8F0B}, //16108 #CJK UNIFIED IDEOGRAPH
    {0xDD67, 0x8F0C}, //16109 #CJK UNIFIED IDEOGRAPH
    {0xDD68, 0x8F0D}, //16110 #CJK UNIFIED IDEOGRAPH
    {0xDD69, 0x8F0E}, //16111 #CJK UNIFIED IDEOGRAPH
    {0xDD6A, 0x8F0F}, //16112 #CJK UNIFIED IDEOGRAPH
    {0xDD6B, 0x8F10}, //16113 #CJK UNIFIED IDEOGRAPH
    {0xDD6C, 0x8F11}, //16114 #CJK UNIFIED IDEOGRAPH
    {0xDD6D, 0x8F12}, //16115 #CJK UNIFIED IDEOGRAPH
    {0xDD6E, 0x8F13}, //16116 #CJK UNIFIED IDEOGRAPH
    {0xDD6F, 0x8F14}, //16117 #CJK UNIFIED IDEOGRAPH
    {0xDD70, 0x8F15}, //16118 #CJK UNIFIED IDEOGRAPH
    {0xDD71, 0x8F16}, //16119 #CJK UNIFIED IDEOGRAPH
    {0xDD72, 0x8F17}, //16120 #CJK UNIFIED IDEOGRAPH
    {0xDD73, 0x8F18}, //16121 #CJK UNIFIED IDEOGRAPH
    {0xDD74, 0x8F19}, //16122 #CJK UNIFIED IDEOGRAPH
    {0xDD75, 0x8F1A}, //16123 #CJK UNIFIED IDEOGRAPH
    {0xDD76, 0x8F1B}, //16124 #CJK UNIFIED IDEOGRAPH
    {0xDD77, 0x8F1C}, //16125 #CJK UNIFIED IDEOGRAPH
    {0xDD78, 0x8F1D}, //16126 #CJK UNIFIED IDEOGRAPH
    {0xDD79, 0x8F1E}, //16127 #CJK UNIFIED IDEOGRAPH
    {0xDD7A, 0x8F1F}, //16128 #CJK UNIFIED IDEOGRAPH
    {0xDD7B, 0x8F20}, //16129 #CJK UNIFIED IDEOGRAPH
    {0xDD7C, 0x8F21}, //16130 #CJK UNIFIED IDEOGRAPH
    {0xDD7D, 0x8F22}, //16131 #CJK UNIFIED IDEOGRAPH
    {0xDD7E, 0x8F23}, //16132 #CJK UNIFIED IDEOGRAPH
    {0xDD80, 0x8F24}, //16133 #CJK UNIFIED IDEOGRAPH
    {0xDD81, 0x8F25}, //16134 #CJK UNIFIED IDEOGRAPH
    {0xDD82, 0x8F26}, //16135 #CJK UNIFIED IDEOGRAPH
    {0xDD83, 0x8F27}, //16136 #CJK UNIFIED IDEOGRAPH
    {0xDD84, 0x8F28}, //16137 #CJK UNIFIED IDEOGRAPH
    {0xDD85, 0x8F29}, //16138 #CJK UNIFIED IDEOGRAPH
    {0xDD86, 0x8F2A}, //16139 #CJK UNIFIED IDEOGRAPH
    {0xDD87, 0x8F2B}, //16140 #CJK UNIFIED IDEOGRAPH
    {0xDD88, 0x8F2C}, //16141 #CJK UNIFIED IDEOGRAPH
    {0xDD89, 0x8F2D}, //16142 #CJK UNIFIED IDEOGRAPH
    {0xDD8A, 0x8F2E}, //16143 #CJK UNIFIED IDEOGRAPH
    {0xDD8B, 0x8F2F}, //16144 #CJK UNIFIED IDEOGRAPH
    {0xDD8C, 0x8F30}, //16145 #CJK UNIFIED IDEOGRAPH
    {0xDD8D, 0x8F31}, //16146 #CJK UNIFIED IDEOGRAPH
    {0xDD8E, 0x8F32}, //16147 #CJK UNIFIED IDEOGRAPH
    {0xDD8F, 0x8F33}, //16148 #CJK UNIFIED IDEOGRAPH
    {0xDD90, 0x8F34}, //16149 #CJK UNIFIED IDEOGRAPH
    {0xDD91, 0x8F35}, //16150 #CJK UNIFIED IDEOGRAPH
    {0xDD92, 0x8F36}, //16151 #CJK UNIFIED IDEOGRAPH
    {0xDD93, 0x8F37}, //16152 #CJK UNIFIED IDEOGRAPH
    {0xDD94, 0x8F38}, //16153 #CJK UNIFIED IDEOGRAPH
    {0xDD95, 0x8F39}, //16154 #CJK UNIFIED IDEOGRAPH
    {0xDD96, 0x8F3A}, //16155 #CJK UNIFIED IDEOGRAPH
    {0xDD97, 0x8F3B}, //16156 #CJK UNIFIED IDEOGRAPH
    {0xDD98, 0x8F3C}, //16157 #CJK UNIFIED IDEOGRAPH
    {0xDD99, 0x8F3D}, //16158 #CJK UNIFIED IDEOGRAPH
    {0xDD9A, 0x8F3E}, //16159 #CJK UNIFIED IDEOGRAPH
    {0xDD9B, 0x8F3F}, //16160 #CJK UNIFIED IDEOGRAPH
    {0xDD9C, 0x8F40}, //16161 #CJK UNIFIED IDEOGRAPH
    {0xDD9D, 0x8F41}, //16162 #CJK UNIFIED IDEOGRAPH
    {0xDD9E, 0x8F42}, //16163 #CJK UNIFIED IDEOGRAPH
    {0xDD9F, 0x8F43}, //16164 #CJK UNIFIED IDEOGRAPH
    {0xDDA0, 0x8F44}, //16165 #CJK UNIFIED IDEOGRAPH
    {0xDDA1, 0x8368}, //16166 #CJK UNIFIED IDEOGRAPH
    {0xDDA2, 0x831B}, //16167 #CJK UNIFIED IDEOGRAPH
    {0xDDA3, 0x8369}, //16168 #CJK UNIFIED IDEOGRAPH
    {0xDDA4, 0x836C}, //16169 #CJK UNIFIED IDEOGRAPH
    {0xDDA5, 0x836A}, //16170 #CJK UNIFIED IDEOGRAPH
    {0xDDA6, 0x836D}, //16171 #CJK UNIFIED IDEOGRAPH
    {0xDDA7, 0x836E}, //16172 #CJK UNIFIED IDEOGRAPH
    {0xDDA8, 0x83B0}, //16173 #CJK UNIFIED IDEOGRAPH
    {0xDDA9, 0x8378}, //16174 #CJK UNIFIED IDEOGRAPH
    {0xDDAA, 0x83B3}, //16175 #CJK UNIFIED IDEOGRAPH
    {0xDDAB, 0x83B4}, //16176 #CJK UNIFIED IDEOGRAPH
    {0xDDAC, 0x83A0}, //16177 #CJK UNIFIED IDEOGRAPH
    {0xDDAD, 0x83AA}, //16178 #CJK UNIFIED IDEOGRAPH
    {0xDDAE, 0x8393}, //16179 #CJK UNIFIED IDEOGRAPH
    {0xDDAF, 0x839C}, //16180 #CJK UNIFIED IDEOGRAPH
    {0xDDB0, 0x8385}, //16181 #CJK UNIFIED IDEOGRAPH
    {0xDDB1, 0x837C}, //16182 #CJK UNIFIED IDEOGRAPH
    {0xDDB2, 0x83B6}, //16183 #CJK UNIFIED IDEOGRAPH
    {0xDDB3, 0x83A9}, //16184 #CJK UNIFIED IDEOGRAPH
    {0xDDB4, 0x837D}, //16185 #CJK UNIFIED IDEOGRAPH
    {0xDDB5, 0x83B8}, //16186 #CJK UNIFIED IDEOGRAPH
    {0xDDB6, 0x837B}, //16187 #CJK UNIFIED IDEOGRAPH
    {0xDDB7, 0x8398}, //16188 #CJK UNIFIED IDEOGRAPH
    {0xDDB8, 0x839E}, //16189 #CJK UNIFIED IDEOGRAPH
    {0xDDB9, 0x83A8}, //16190 #CJK UNIFIED IDEOGRAPH
    {0xDDBA, 0x83BA}, //16191 #CJK UNIFIED IDEOGRAPH
    {0xDDBB, 0x83BC}, //16192 #CJK UNIFIED IDEOGRAPH
    {0xDDBC, 0x83C1}, //16193 #CJK UNIFIED IDEOGRAPH
    {0xDDBD, 0x8401}, //16194 #CJK UNIFIED IDEOGRAPH
    {0xDDBE, 0x83E5}, //16195 #CJK UNIFIED IDEOGRAPH
    {0xDDBF, 0x83D8}, //16196 #CJK UNIFIED IDEOGRAPH
    {0xDDC0, 0x5807}, //16197 #CJK UNIFIED IDEOGRAPH
    {0xDDC1, 0x8418}, //16198 #CJK UNIFIED IDEOGRAPH
    {0xDDC2, 0x840B}, //16199 #CJK UNIFIED IDEOGRAPH
    {0xDDC3, 0x83DD}, //16200 #CJK UNIFIED IDEOGRAPH
    {0xDDC4, 0x83FD}, //16201 #CJK UNIFIED IDEOGRAPH
    {0xDDC5, 0x83D6}, //16202 #CJK UNIFIED IDEOGRAPH
    {0xDDC6, 0x841C}, //16203 #CJK UNIFIED IDEOGRAPH
    {0xDDC7, 0x8438}, //16204 #CJK UNIFIED IDEOGRAPH
    {0xDDC8, 0x8411}, //16205 #CJK UNIFIED IDEOGRAPH
    {0xDDC9, 0x8406}, //16206 #CJK UNIFIED IDEOGRAPH
    {0xDDCA, 0x83D4}, //16207 #CJK UNIFIED IDEOGRAPH
    {0xDDCB, 0x83DF}, //16208 #CJK UNIFIED IDEOGRAPH
    {0xDDCC, 0x840F}, //16209 #CJK UNIFIED IDEOGRAPH
    {0xDDCD, 0x8403}, //16210 #CJK UNIFIED IDEOGRAPH
    {0xDDCE, 0x83F8}, //16211 #CJK UNIFIED IDEOGRAPH
    {0xDDCF, 0x83F9}, //16212 #CJK UNIFIED IDEOGRAPH
    {0xDDD0, 0x83EA}, //16213 #CJK UNIFIED IDEOGRAPH
    {0xDDD1, 0x83C5}, //16214 #CJK UNIFIED IDEOGRAPH
    {0xDDD2, 0x83C0}, //16215 #CJK UNIFIED IDEOGRAPH
    {0xDDD3, 0x8426}, //16216 #CJK UNIFIED IDEOGRAPH
    {0xDDD4, 0x83F0}, //16217 #CJK UNIFIED IDEOGRAPH
    {0xDDD5, 0x83E1}, //16218 #CJK UNIFIED IDEOGRAPH
    {0xDDD6, 0x845C}, //16219 #CJK UNIFIED IDEOGRAPH
    {0xDDD7, 0x8451}, //16220 #CJK UNIFIED IDEOGRAPH
    {0xDDD8, 0x845A}, //16221 #CJK UNIFIED IDEOGRAPH
    {0xDDD9, 0x8459}, //16222 #CJK UNIFIED IDEOGRAPH
    {0xDDDA, 0x8473}, //16223 #CJK UNIFIED IDEOGRAPH
    {0xDDDB, 0x8487}, //16224 #CJK UNIFIED IDEOGRAPH
    {0xDDDC, 0x8488}, //16225 #CJK UNIFIED IDEOGRAPH
    {0xDDDD, 0x847A}, //16226 #CJK UNIFIED IDEOGRAPH
    {0xDDDE, 0x8489}, //16227 #CJK UNIFIED IDEOGRAPH
    {0xDDDF, 0x8478}, //16228 #CJK UNIFIED IDEOGRAPH
    {0xDDE0, 0x843C}, //16229 #CJK UNIFIED IDEOGRAPH
    {0xDDE1, 0x8446}, //16230 #CJK UNIFIED IDEOGRAPH
    {0xDDE2, 0x8469}, //16231 #CJK UNIFIED IDEOGRAPH
    {0xDDE3, 0x8476}, //16232 #CJK UNIFIED IDEOGRAPH
    {0xDDE4, 0x848C}, //16233 #CJK UNIFIED IDEOGRAPH
    {0xDDE5, 0x848E}, //16234 #CJK UNIFIED IDEOGRAPH
    {0xDDE6, 0x8431}, //16235 #CJK UNIFIED IDEOGRAPH
    {0xDDE7, 0x846D}, //16236 #CJK UNIFIED IDEOGRAPH
    {0xDDE8, 0x84C1}, //16237 #CJK UNIFIED IDEOGRAPH
    {0xDDE9, 0x84CD}, //16238 #CJK UNIFIED IDEOGRAPH
    {0xDDEA, 0x84D0}, //16239 #CJK UNIFIED IDEOGRAPH
    {0xDDEB, 0x84E6}, //16240 #CJK UNIFIED IDEOGRAPH
    {0xDDEC, 0x84BD}, //16241 #CJK UNIFIED IDEOGRAPH
    {0xDDED, 0x84D3}, //16242 #CJK UNIFIED IDEOGRAPH
    {0xDDEE, 0x84CA}, //16243 #CJK UNIFIED IDEOGRAPH
    {0xDDEF, 0x84BF}, //16244 #CJK UNIFIED IDEOGRAPH
    {0xDDF0, 0x84BA}, //16245 #CJK UNIFIED IDEOGRAPH
    {0xDDF1, 0x84E0}, //16246 #CJK UNIFIED IDEOGRAPH
    {0xDDF2, 0x84A1}, //16247 #CJK UNIFIED IDEOGRAPH
    {0xDDF3, 0x84B9}, //16248 #CJK UNIFIED IDEOGRAPH
    {0xDDF4, 0x84B4}, //16249 #CJK UNIFIED IDEOGRAPH
    {0xDDF5, 0x8497}, //16250 #CJK UNIFIED IDEOGRAPH
    {0xDDF6, 0x84E5}, //16251 #CJK UNIFIED IDEOGRAPH
    {0xDDF7, 0x84E3}, //16252 #CJK UNIFIED IDEOGRAPH
    {0xDDF8, 0x850C}, //16253 #CJK UNIFIED IDEOGRAPH
    {0xDDF9, 0x750D}, //16254 #CJK UNIFIED IDEOGRAPH
    {0xDDFA, 0x8538}, //16255 #CJK UNIFIED IDEOGRAPH
    {0xDDFB, 0x84F0}, //16256 #CJK UNIFIED IDEOGRAPH
    {0xDDFC, 0x8539}, //16257 #CJK UNIFIED IDEOGRAPH
    {0xDDFD, 0x851F}, //16258 #CJK UNIFIED IDEOGRAPH
    {0xDDFE, 0x853A}, //16259 #CJK UNIFIED IDEOGRAPH
    {0xDE40, 0x8F45}, //16260 #CJK UNIFIED IDEOGRAPH
    {0xDE41, 0x8F46}, //16261 #CJK UNIFIED IDEOGRAPH
    {0xDE42, 0x8F47}, //16262 #CJK UNIFIED IDEOGRAPH
    {0xDE43, 0x8F48}, //16263 #CJK UNIFIED IDEOGRAPH
    {0xDE44, 0x8F49}, //16264 #CJK UNIFIED IDEOGRAPH
    {0xDE45, 0x8F4A}, //16265 #CJK UNIFIED IDEOGRAPH
    {0xDE46, 0x8F4B}, //16266 #CJK UNIFIED IDEOGRAPH
    {0xDE47, 0x8F4C}, //16267 #CJK UNIFIED IDEOGRAPH
    {0xDE48, 0x8F4D}, //16268 #CJK UNIFIED IDEOGRAPH
    {0xDE49, 0x8F4E}, //16269 #CJK UNIFIED IDEOGRAPH
    {0xDE4A, 0x8F4F}, //16270 #CJK UNIFIED IDEOGRAPH
    {0xDE4B, 0x8F50}, //16271 #CJK UNIFIED IDEOGRAPH
    {0xDE4C, 0x8F51}, //16272 #CJK UNIFIED IDEOGRAPH
    {0xDE4D, 0x8F52}, //16273 #CJK UNIFIED IDEOGRAPH
    {0xDE4E, 0x8F53}, //16274 #CJK UNIFIED IDEOGRAPH
    {0xDE4F, 0x8F54}, //16275 #CJK UNIFIED IDEOGRAPH
    {0xDE50, 0x8F55}, //16276 #CJK UNIFIED IDEOGRAPH
    {0xDE51, 0x8F56}, //16277 #CJK UNIFIED IDEOGRAPH
    {0xDE52, 0x8F57}, //16278 #CJK UNIFIED IDEOGRAPH
    {0xDE53, 0x8F58}, //16279 #CJK UNIFIED IDEOGRAPH
    {0xDE54, 0x8F59}, //16280 #CJK UNIFIED IDEOGRAPH
    {0xDE55, 0x8F5A}, //16281 #CJK UNIFIED IDEOGRAPH
    {0xDE56, 0x8F5B}, //16282 #CJK UNIFIED IDEOGRAPH
    {0xDE57, 0x8F5C}, //16283 #CJK UNIFIED IDEOGRAPH
    {0xDE58, 0x8F5D}, //16284 #CJK UNIFIED IDEOGRAPH
    {0xDE59, 0x8F5E}, //16285 #CJK UNIFIED IDEOGRAPH
    {0xDE5A, 0x8F5F}, //16286 #CJK UNIFIED IDEOGRAPH
    {0xDE5B, 0x8F60}, //16287 #CJK UNIFIED IDEOGRAPH
    {0xDE5C, 0x8F61}, //16288 #CJK UNIFIED IDEOGRAPH
    {0xDE5D, 0x8F62}, //16289 #CJK UNIFIED IDEOGRAPH
    {0xDE5E, 0x8F63}, //16290 #CJK UNIFIED IDEOGRAPH
    {0xDE5F, 0x8F64}, //16291 #CJK UNIFIED IDEOGRAPH
    {0xDE60, 0x8F65}, //16292 #CJK UNIFIED IDEOGRAPH
    {0xDE61, 0x8F6A}, //16293 #CJK UNIFIED IDEOGRAPH
    {0xDE62, 0x8F80}, //16294 #CJK UNIFIED IDEOGRAPH
    {0xDE63, 0x8F8C}, //16295 #CJK UNIFIED IDEOGRAPH
    {0xDE64, 0x8F92}, //16296 #CJK UNIFIED IDEOGRAPH
    {0xDE65, 0x8F9D}, //16297 #CJK UNIFIED IDEOGRAPH
    {0xDE66, 0x8FA0}, //16298 #CJK UNIFIED IDEOGRAPH
    {0xDE67, 0x8FA1}, //16299 #CJK UNIFIED IDEOGRAPH
    {0xDE68, 0x8FA2}, //16300 #CJK UNIFIED IDEOGRAPH
    {0xDE69, 0x8FA4}, //16301 #CJK UNIFIED IDEOGRAPH
    {0xDE6A, 0x8FA5}, //16302 #CJK UNIFIED IDEOGRAPH
    {0xDE6B, 0x8FA6}, //16303 #CJK UNIFIED IDEOGRAPH
    {0xDE6C, 0x8FA7}, //16304 #CJK UNIFIED IDEOGRAPH
    {0xDE6D, 0x8FAA}, //16305 #CJK UNIFIED IDEOGRAPH
    {0xDE6E, 0x8FAC}, //16306 #CJK UNIFIED IDEOGRAPH
    {0xDE6F, 0x8FAD}, //16307 #CJK UNIFIED IDEOGRAPH
    {0xDE70, 0x8FAE}, //16308 #CJK UNIFIED IDEOGRAPH
    {0xDE71, 0x8FAF}, //16309 #CJK UNIFIED IDEOGRAPH
    {0xDE72, 0x8FB2}, //16310 #CJK UNIFIED IDEOGRAPH
    {0xDE73, 0x8FB3}, //16311 #CJK UNIFIED IDEOGRAPH
    {0xDE74, 0x8FB4}, //16312 #CJK UNIFIED IDEOGRAPH
    {0xDE75, 0x8FB5}, //16313 #CJK UNIFIED IDEOGRAPH
    {0xDE76, 0x8FB7}, //16314 #CJK UNIFIED IDEOGRAPH
    {0xDE77, 0x8FB8}, //16315 #CJK UNIFIED IDEOGRAPH
    {0xDE78, 0x8FBA}, //16316 #CJK UNIFIED IDEOGRAPH
    {0xDE79, 0x8FBB}, //16317 #CJK UNIFIED IDEOGRAPH
    {0xDE7A, 0x8FBC}, //16318 #CJK UNIFIED IDEOGRAPH
    {0xDE7B, 0x8FBF}, //16319 #CJK UNIFIED IDEOGRAPH
    {0xDE7C, 0x8FC0}, //16320 #CJK UNIFIED IDEOGRAPH
    {0xDE7D, 0x8FC3}, //16321 #CJK UNIFIED IDEOGRAPH
    {0xDE7E, 0x8FC6}, //16322 #CJK UNIFIED IDEOGRAPH
    {0xDE80, 0x8FC9}, //16323 #CJK UNIFIED IDEOGRAPH
    {0xDE81, 0x8FCA}, //16324 #CJK UNIFIED IDEOGRAPH
    {0xDE82, 0x8FCB}, //16325 #CJK UNIFIED IDEOGRAPH
    {0xDE83, 0x8FCC}, //16326 #CJK UNIFIED IDEOGRAPH
    {0xDE84, 0x8FCD}, //16327 #CJK UNIFIED IDEOGRAPH
    {0xDE85, 0x8FCF}, //16328 #CJK UNIFIED IDEOGRAPH
    {0xDE86, 0x8FD2}, //16329 #CJK UNIFIED IDEOGRAPH
    {0xDE87, 0x8FD6}, //16330 #CJK UNIFIED IDEOGRAPH
    {0xDE88, 0x8FD7}, //16331 #CJK UNIFIED IDEOGRAPH
    {0xDE89, 0x8FDA}, //16332 #CJK UNIFIED IDEOGRAPH
    {0xDE8A, 0x8FE0}, //16333 #CJK UNIFIED IDEOGRAPH
    {0xDE8B, 0x8FE1}, //16334 #CJK UNIFIED IDEOGRAPH
    {0xDE8C, 0x8FE3}, //16335 #CJK UNIFIED IDEOGRAPH
    {0xDE8D, 0x8FE7}, //16336 #CJK UNIFIED IDEOGRAPH
    {0xDE8E, 0x8FEC}, //16337 #CJK UNIFIED IDEOGRAPH
    {0xDE8F, 0x8FEF}, //16338 #CJK UNIFIED IDEOGRAPH
    {0xDE90, 0x8FF1}, //16339 #CJK UNIFIED IDEOGRAPH
    {0xDE91, 0x8FF2}, //16340 #CJK UNIFIED IDEOGRAPH
    {0xDE92, 0x8FF4}, //16341 #CJK UNIFIED IDEOGRAPH
    {0xDE93, 0x8FF5}, //16342 #CJK UNIFIED IDEOGRAPH
    {0xDE94, 0x8FF6}, //16343 #CJK UNIFIED IDEOGRAPH
    {0xDE95, 0x8FFA}, //16344 #CJK UNIFIED IDEOGRAPH
    {0xDE96, 0x8FFB}, //16345 #CJK UNIFIED IDEOGRAPH
    {0xDE97, 0x8FFC}, //16346 #CJK UNIFIED IDEOGRAPH
    {0xDE98, 0x8FFE}, //16347 #CJK UNIFIED IDEOGRAPH
    {0xDE99, 0x8FFF}, //16348 #CJK UNIFIED IDEOGRAPH
    {0xDE9A, 0x9007}, //16349 #CJK UNIFIED IDEOGRAPH
    {0xDE9B, 0x9008}, //16350 #CJK UNIFIED IDEOGRAPH
    {0xDE9C, 0x900C}, //16351 #CJK UNIFIED IDEOGRAPH
    {0xDE9D, 0x900E}, //16352 #CJK UNIFIED IDEOGRAPH
    {0xDE9E, 0x9013}, //16353 #CJK UNIFIED IDEOGRAPH
    {0xDE9F, 0x9015}, //16354 #CJK UNIFIED IDEOGRAPH
    {0xDEA0, 0x9018}, //16355 #CJK UNIFIED IDEOGRAPH
    {0xDEA1, 0x8556}, //16356 #CJK UNIFIED IDEOGRAPH
    {0xDEA2, 0x853B}, //16357 #CJK UNIFIED IDEOGRAPH
    {0xDEA3, 0x84FF}, //16358 #CJK UNIFIED IDEOGRAPH
    {0xDEA4, 0x84FC}, //16359 #CJK UNIFIED IDEOGRAPH
    {0xDEA5, 0x8559}, //16360 #CJK UNIFIED IDEOGRAPH
    {0xDEA6, 0x8548}, //16361 #CJK UNIFIED IDEOGRAPH
    {0xDEA7, 0x8568}, //16362 #CJK UNIFIED IDEOGRAPH
    {0xDEA8, 0x8564}, //16363 #CJK UNIFIED IDEOGRAPH
    {0xDEA9, 0x855E}, //16364 #CJK UNIFIED IDEOGRAPH
    {0xDEAA, 0x857A}, //16365 #CJK UNIFIED IDEOGRAPH
    {0xDEAB, 0x77A2}, //16366 #CJK UNIFIED IDEOGRAPH
    {0xDEAC, 0x8543}, //16367 #CJK UNIFIED IDEOGRAPH
    {0xDEAD, 0x8572}, //16368 #CJK UNIFIED IDEOGRAPH
    {0xDEAE, 0x857B}, //16369 #CJK UNIFIED IDEOGRAPH
    {0xDEAF, 0x85A4}, //16370 #CJK UNIFIED IDEOGRAPH
    {0xDEB0, 0x85A8}, //16371 #CJK UNIFIED IDEOGRAPH
    {0xDEB1, 0x8587}, //16372 #CJK UNIFIED IDEOGRAPH
    {0xDEB2, 0x858F}, //16373 #CJK UNIFIED IDEOGRAPH
    {0xDEB3, 0x8579}, //16374 #CJK UNIFIED IDEOGRAPH
    {0xDEB4, 0x85AE}, //16375 #CJK UNIFIED IDEOGRAPH
    {0xDEB5, 0x859C}, //16376 #CJK UNIFIED IDEOGRAPH
    {0xDEB6, 0x8585}, //16377 #CJK UNIFIED IDEOGRAPH
    {0xDEB7, 0x85B9}, //16378 #CJK UNIFIED IDEOGRAPH
    {0xDEB8, 0x85B7}, //16379 #CJK UNIFIED IDEOGRAPH
    {0xDEB9, 0x85B0}, //16380 #CJK UNIFIED IDEOGRAPH
    {0xDEBA, 0x85D3}, //16381 #CJK UNIFIED IDEOGRAPH
    {0xDEBB, 0x85C1}, //16382 #CJK UNIFIED IDEOGRAPH
    {0xDEBC, 0x85DC}, //16383 #CJK UNIFIED IDEOGRAPH
    {0xDEBD, 0x85FF}, //16384 #CJK UNIFIED IDEOGRAPH
    {0xDEBE, 0x8627}, //16385 #CJK UNIFIED IDEOGRAPH
    {0xDEBF, 0x8605}, //16386 #CJK UNIFIED IDEOGRAPH
    {0xDEC0, 0x8629}, //16387 #CJK UNIFIED IDEOGRAPH
    {0xDEC1, 0x8616}, //16388 #CJK UNIFIED IDEOGRAPH
    {0xDEC2, 0x863C}, //16389 #CJK UNIFIED IDEOGRAPH
    {0xDEC3, 0x5EFE}, //16390 #CJK UNIFIED IDEOGRAPH
    {0xDEC4, 0x5F08}, //16391 #CJK UNIFIED IDEOGRAPH
    {0xDEC5, 0x593C}, //16392 #CJK UNIFIED IDEOGRAPH
    {0xDEC6, 0x5941}, //16393 #CJK UNIFIED IDEOGRAPH
    {0xDEC7, 0x8037}, //16394 #CJK UNIFIED IDEOGRAPH
    {0xDEC8, 0x5955}, //16395 #CJK UNIFIED IDEOGRAPH
    {0xDEC9, 0x595A}, //16396 #CJK UNIFIED IDEOGRAPH
    {0xDECA, 0x5958}, //16397 #CJK UNIFIED IDEOGRAPH
    {0xDECB, 0x530F}, //16398 #CJK UNIFIED IDEOGRAPH
    {0xDECC, 0x5C22}, //16399 #CJK UNIFIED IDEOGRAPH
    {0xDECD, 0x5C25}, //16400 #CJK UNIFIED IDEOGRAPH
    {0xDECE, 0x5C2C}, //16401 #CJK UNIFIED IDEOGRAPH
    {0xDECF, 0x5C34}, //16402 #CJK UNIFIED IDEOGRAPH
    {0xDED0, 0x624C}, //16403 #CJK UNIFIED IDEOGRAPH
    {0xDED1, 0x626A}, //16404 #CJK UNIFIED IDEOGRAPH
    {0xDED2, 0x629F}, //16405 #CJK UNIFIED IDEOGRAPH
    {0xDED3, 0x62BB}, //16406 #CJK UNIFIED IDEOGRAPH
    {0xDED4, 0x62CA}, //16407 #CJK UNIFIED IDEOGRAPH
    {0xDED5, 0x62DA}, //16408 #CJK UNIFIED IDEOGRAPH
    {0xDED6, 0x62D7}, //16409 #CJK UNIFIED IDEOGRAPH
    {0xDED7, 0x62EE}, //16410 #CJK UNIFIED IDEOGRAPH
    {0xDED8, 0x6322}, //16411 #CJK UNIFIED IDEOGRAPH
    {0xDED9, 0x62F6}, //16412 #CJK UNIFIED IDEOGRAPH
    {0xDEDA, 0x6339}, //16413 #CJK UNIFIED IDEOGRAPH
    {0xDEDB, 0x634B}, //16414 #CJK UNIFIED IDEOGRAPH
    {0xDEDC, 0x6343}, //16415 #CJK UNIFIED IDEOGRAPH
    {0xDEDD, 0x63AD}, //16416 #CJK UNIFIED IDEOGRAPH
    {0xDEDE, 0x63F6}, //16417 #CJK UNIFIED IDEOGRAPH
    {0xDEDF, 0x6371}, //16418 #CJK UNIFIED IDEOGRAPH
    {0xDEE0, 0x637A}, //16419 #CJK UNIFIED IDEOGRAPH
    {0xDEE1, 0x638E}, //16420 #CJK UNIFIED IDEOGRAPH
    {0xDEE2, 0x63B4}, //16421 #CJK UNIFIED IDEOGRAPH
    {0xDEE3, 0x636D}, //16422 #CJK UNIFIED IDEOGRAPH
    {0xDEE4, 0x63AC}, //16423 #CJK UNIFIED IDEOGRAPH
    {0xDEE5, 0x638A}, //16424 #CJK UNIFIED IDEOGRAPH
    {0xDEE6, 0x6369}, //16425 #CJK UNIFIED IDEOGRAPH
    {0xDEE7, 0x63AE}, //16426 #CJK UNIFIED IDEOGRAPH
    {0xDEE8, 0x63BC}, //16427 #CJK UNIFIED IDEOGRAPH
    {0xDEE9, 0x63F2}, //16428 #CJK UNIFIED IDEOGRAPH
    {0xDEEA, 0x63F8}, //16429 #CJK UNIFIED IDEOGRAPH
    {0xDEEB, 0x63E0}, //16430 #CJK UNIFIED IDEOGRAPH
    {0xDEEC, 0x63FF}, //16431 #CJK UNIFIED IDEOGRAPH
    {0xDEED, 0x63C4}, //16432 #CJK UNIFIED IDEOGRAPH
    {0xDEEE, 0x63DE}, //16433 #CJK UNIFIED IDEOGRAPH
    {0xDEEF, 0x63CE}, //16434 #CJK UNIFIED IDEOGRAPH
    {0xDEF0, 0x6452}, //16435 #CJK UNIFIED IDEOGRAPH
    {0xDEF1, 0x63C6}, //16436 #CJK UNIFIED IDEOGRAPH
    {0xDEF2, 0x63BE}, //16437 #CJK UNIFIED IDEOGRAPH
    {0xDEF3, 0x6445}, //16438 #CJK UNIFIED IDEOGRAPH
    {0xDEF4, 0x6441}, //16439 #CJK UNIFIED IDEOGRAPH
    {0xDEF5, 0x640B}, //16440 #CJK UNIFIED IDEOGRAPH
    {0xDEF6, 0x641B}, //16441 #CJK UNIFIED IDEOGRAPH
    {0xDEF7, 0x6420}, //16442 #CJK UNIFIED IDEOGRAPH
    {0xDEF8, 0x640C}, //16443 #CJK UNIFIED IDEOGRAPH
    {0xDEF9, 0x6426}, //16444 #CJK UNIFIED IDEOGRAPH
    {0xDEFA, 0x6421}, //16445 #CJK UNIFIED IDEOGRAPH
    {0xDEFB, 0x645E}, //16446 #CJK UNIFIED IDEOGRAPH
    {0xDEFC, 0x6484}, //16447 #CJK UNIFIED IDEOGRAPH
    {0xDEFD, 0x646D}, //16448 #CJK UNIFIED IDEOGRAPH
    {0xDEFE, 0x6496}, //16449 #CJK UNIFIED IDEOGRAPH
    {0xDF40, 0x9019}, //16450 #CJK UNIFIED IDEOGRAPH
    {0xDF41, 0x901C}, //16451 #CJK UNIFIED IDEOGRAPH
    {0xDF42, 0x9023}, //16452 #CJK UNIFIED IDEOGRAPH
    {0xDF43, 0x9024}, //16453 #CJK UNIFIED IDEOGRAPH
    {0xDF44, 0x9025}, //16454 #CJK UNIFIED IDEOGRAPH
    {0xDF45, 0x9027}, //16455 #CJK UNIFIED IDEOGRAPH
    {0xDF46, 0x9028}, //16456 #CJK UNIFIED IDEOGRAPH
    {0xDF47, 0x9029}, //16457 #CJK UNIFIED IDEOGRAPH
    {0xDF48, 0x902A}, //16458 #CJK UNIFIED IDEOGRAPH
    {0xDF49, 0x902B}, //16459 #CJK UNIFIED IDEOGRAPH
    {0xDF4A, 0x902C}, //16460 #CJK UNIFIED IDEOGRAPH
    {0xDF4B, 0x9030}, //16461 #CJK UNIFIED IDEOGRAPH
    {0xDF4C, 0x9031}, //16462 #CJK UNIFIED IDEOGRAPH
    {0xDF4D, 0x9032}, //16463 #CJK UNIFIED IDEOGRAPH
    {0xDF4E, 0x9033}, //16464 #CJK UNIFIED IDEOGRAPH
    {0xDF4F, 0x9034}, //16465 #CJK UNIFIED IDEOGRAPH
    {0xDF50, 0x9037}, //16466 #CJK UNIFIED IDEOGRAPH
    {0xDF51, 0x9039}, //16467 #CJK UNIFIED IDEOGRAPH
    {0xDF52, 0x903A}, //16468 #CJK UNIFIED IDEOGRAPH
    {0xDF53, 0x903D}, //16469 #CJK UNIFIED IDEOGRAPH
    {0xDF54, 0x903F}, //16470 #CJK UNIFIED IDEOGRAPH
    {0xDF55, 0x9040}, //16471 #CJK UNIFIED IDEOGRAPH
    {0xDF56, 0x9043}, //16472 #CJK UNIFIED IDEOGRAPH
    {0xDF57, 0x9045}, //16473 #CJK UNIFIED IDEOGRAPH
    {0xDF58, 0x9046}, //16474 #CJK UNIFIED IDEOGRAPH
    {0xDF59, 0x9048}, //16475 #CJK UNIFIED IDEOGRAPH
    {0xDF5A, 0x9049}, //16476 #CJK UNIFIED IDEOGRAPH
    {0xDF5B, 0x904A}, //16477 #CJK UNIFIED IDEOGRAPH
    {0xDF5C, 0x904B}, //16478 #CJK UNIFIED IDEOGRAPH
    {0xDF5D, 0x904C}, //16479 #CJK UNIFIED IDEOGRAPH
    {0xDF5E, 0x904E}, //16480 #CJK UNIFIED IDEOGRAPH
    {0xDF5F, 0x9054}, //16481 #CJK UNIFIED IDEOGRAPH
    {0xDF60, 0x9055}, //16482 #CJK UNIFIED IDEOGRAPH
    {0xDF61, 0x9056}, //16483 #CJK UNIFIED IDEOGRAPH
    {0xDF62, 0x9059}, //16484 #CJK UNIFIED IDEOGRAPH
    {0xDF63, 0x905A}, //16485 #CJK UNIFIED IDEOGRAPH
    {0xDF64, 0x905C}, //16486 #CJK UNIFIED IDEOGRAPH
    {0xDF65, 0x905D}, //16487 #CJK UNIFIED IDEOGRAPH
    {0xDF66, 0x905E}, //16488 #CJK UNIFIED IDEOGRAPH
    {0xDF67, 0x905F}, //16489 #CJK UNIFIED IDEOGRAPH
    {0xDF68, 0x9060}, //16490 #CJK UNIFIED IDEOGRAPH
    {0xDF69, 0x9061}, //16491 #CJK UNIFIED IDEOGRAPH
    {0xDF6A, 0x9064}, //16492 #CJK UNIFIED IDEOGRAPH
    {0xDF6B, 0x9066}, //16493 #CJK UNIFIED IDEOGRAPH
    {0xDF6C, 0x9067}, //16494 #CJK UNIFIED IDEOGRAPH
    {0xDF6D, 0x9069}, //16495 #CJK UNIFIED IDEOGRAPH
    {0xDF6E, 0x906A}, //16496 #CJK UNIFIED IDEOGRAPH
    {0xDF6F, 0x906B}, //16497 #CJK UNIFIED IDEOGRAPH
    {0xDF70, 0x906C}, //16498 #CJK UNIFIED IDEOGRAPH
    {0xDF71, 0x906F}, //16499 #CJK UNIFIED IDEOGRAPH
    {0xDF72, 0x9070}, //16500 #CJK UNIFIED IDEOGRAPH
    {0xDF73, 0x9071}, //16501 #CJK UNIFIED IDEOGRAPH
    {0xDF74, 0x9072}, //16502 #CJK UNIFIED IDEOGRAPH
    {0xDF75, 0x9073}, //16503 #CJK UNIFIED IDEOGRAPH
    {0xDF76, 0x9076}, //16504 #CJK UNIFIED IDEOGRAPH
    {0xDF77, 0x9077}, //16505 #CJK UNIFIED IDEOGRAPH
    {0xDF78, 0x9078}, //16506 #CJK UNIFIED IDEOGRAPH
    {0xDF79, 0x9079}, //16507 #CJK UNIFIED IDEOGRAPH
    {0xDF7A, 0x907A}, //16508 #CJK UNIFIED IDEOGRAPH
    {0xDF7B, 0x907B}, //16509 #CJK UNIFIED IDEOGRAPH
    {0xDF7C, 0x907C}, //16510 #CJK UNIFIED IDEOGRAPH
    {0xDF7D, 0x907E}, //16511 #CJK UNIFIED IDEOGRAPH
    {0xDF7E, 0x9081}, //16512 #CJK UNIFIED IDEOGRAPH
    {0xDF80, 0x9084}, //16513 #CJK UNIFIED IDEOGRAPH
    {0xDF81, 0x9085}, //16514 #CJK UNIFIED IDEOGRAPH
    {0xDF82, 0x9086}, //16515 #CJK UNIFIED IDEOGRAPH
    {0xDF83, 0x9087}, //16516 #CJK UNIFIED IDEOGRAPH
    {0xDF84, 0x9089}, //16517 #CJK UNIFIED IDEOGRAPH
    {0xDF85, 0x908A}, //16518 #CJK UNIFIED IDEOGRAPH
    {0xDF86, 0x908C}, //16519 #CJK UNIFIED IDEOGRAPH
    {0xDF87, 0x908D}, //16520 #CJK UNIFIED IDEOGRAPH
    {0xDF88, 0x908E}, //16521 #CJK UNIFIED IDEOGRAPH
    {0xDF89, 0x908F}, //16522 #CJK UNIFIED IDEOGRAPH
    {0xDF8A, 0x9090}, //16523 #CJK UNIFIED IDEOGRAPH
    {0xDF8B, 0x9092}, //16524 #CJK UNIFIED IDEOGRAPH
    {0xDF8C, 0x9094}, //16525 #CJK UNIFIED IDEOGRAPH
    {0xDF8D, 0x9096}, //16526 #CJK UNIFIED IDEOGRAPH
    {0xDF8E, 0x9098}, //16527 #CJK UNIFIED IDEOGRAPH
    {0xDF8F, 0x909A}, //16528 #CJK UNIFIED IDEOGRAPH
    {0xDF90, 0x909C}, //16529 #CJK UNIFIED IDEOGRAPH
    {0xDF91, 0x909E}, //16530 #CJK UNIFIED IDEOGRAPH
    {0xDF92, 0x909F}, //16531 #CJK UNIFIED IDEOGRAPH
    {0xDF93, 0x90A0}, //16532 #CJK UNIFIED IDEOGRAPH
    {0xDF94, 0x90A4}, //16533 #CJK UNIFIED IDEOGRAPH
    {0xDF95, 0x90A5}, //16534 #CJK UNIFIED IDEOGRAPH
    {0xDF96, 0x90A7}, //16535 #CJK UNIFIED IDEOGRAPH
    {0xDF97, 0x90A8}, //16536 #CJK UNIFIED IDEOGRAPH
    {0xDF98, 0x90A9}, //16537 #CJK UNIFIED IDEOGRAPH
    {0xDF99, 0x90AB}, //16538 #CJK UNIFIED IDEOGRAPH
    {0xDF9A, 0x90AD}, //16539 #CJK UNIFIED IDEOGRAPH
    {0xDF9B, 0x90B2}, //16540 #CJK UNIFIED IDEOGRAPH
    {0xDF9C, 0x90B7}, //16541 #CJK UNIFIED IDEOGRAPH
    {0xDF9D, 0x90BC}, //16542 #CJK UNIFIED IDEOGRAPH
    {0xDF9E, 0x90BD}, //16543 #CJK UNIFIED IDEOGRAPH
    {0xDF9F, 0x90BF}, //16544 #CJK UNIFIED IDEOGRAPH
    {0xDFA0, 0x90C0}, //16545 #CJK UNIFIED IDEOGRAPH
    {0xDFA1, 0x647A}, //16546 #CJK UNIFIED IDEOGRAPH
    {0xDFA2, 0x64B7}, //16547 #CJK UNIFIED IDEOGRAPH
    {0xDFA3, 0x64B8}, //16548 #CJK UNIFIED IDEOGRAPH
    {0xDFA4, 0x6499}, //16549 #CJK UNIFIED IDEOGRAPH
    {0xDFA5, 0x64BA}, //16550 #CJK UNIFIED IDEOGRAPH
    {0xDFA6, 0x64C0}, //16551 #CJK UNIFIED IDEOGRAPH
    {0xDFA7, 0x64D0}, //16552 #CJK UNIFIED IDEOGRAPH
    {0xDFA8, 0x64D7}, //16553 #CJK UNIFIED IDEOGRAPH
    {0xDFA9, 0x64E4}, //16554 #CJK UNIFIED IDEOGRAPH
    {0xDFAA, 0x64E2}, //16555 #CJK UNIFIED IDEOGRAPH
    {0xDFAB, 0x6509}, //16556 #CJK UNIFIED IDEOGRAPH
    {0xDFAC, 0x6525}, //16557 #CJK UNIFIED IDEOGRAPH
    {0xDFAD, 0x652E}, //16558 #CJK UNIFIED IDEOGRAPH
    {0xDFAE, 0x5F0B}, //16559 #CJK UNIFIED IDEOGRAPH
    {0xDFAF, 0x5FD2}, //16560 #CJK UNIFIED IDEOGRAPH
    {0xDFB0, 0x7519}, //16561 #CJK UNIFIED IDEOGRAPH
    {0xDFB1, 0x5F11}, //16562 #CJK UNIFIED IDEOGRAPH
    {0xDFB2, 0x535F}, //16563 #CJK UNIFIED IDEOGRAPH
    {0xDFB3, 0x53F1}, //16564 #CJK UNIFIED IDEOGRAPH
    {0xDFB4, 0x53FD}, //16565 #CJK UNIFIED IDEOGRAPH
    {0xDFB5, 0x53E9}, //16566 #CJK UNIFIED IDEOGRAPH
    {0xDFB6, 0x53E8}, //16567 #CJK UNIFIED IDEOGRAPH
    {0xDFB7, 0x53FB}, //16568 #CJK UNIFIED IDEOGRAPH
    {0xDFB8, 0x5412}, //16569 #CJK UNIFIED IDEOGRAPH
    {0xDFB9, 0x5416}, //16570 #CJK UNIFIED IDEOGRAPH
    {0xDFBA, 0x5406}, //16571 #CJK UNIFIED IDEOGRAPH
    {0xDFBB, 0x544B}, //16572 #CJK UNIFIED IDEOGRAPH
    {0xDFBC, 0x5452}, //16573 #CJK UNIFIED IDEOGRAPH
    {0xDFBD, 0x5453}, //16574 #CJK UNIFIED IDEOGRAPH
    {0xDFBE, 0x5454}, //16575 #CJK UNIFIED IDEOGRAPH
    {0xDFBF, 0x5456}, //16576 #CJK UNIFIED IDEOGRAPH
    {0xDFC0, 0x5443}, //16577 #CJK UNIFIED IDEOGRAPH
    {0xDFC1, 0x5421}, //16578 #CJK UNIFIED IDEOGRAPH
    {0xDFC2, 0x5457}, //16579 #CJK UNIFIED IDEOGRAPH
    {0xDFC3, 0x5459}, //16580 #CJK UNIFIED IDEOGRAPH
    {0xDFC4, 0x5423}, //16581 #CJK UNIFIED IDEOGRAPH
    {0xDFC5, 0x5432}, //16582 #CJK UNIFIED IDEOGRAPH
    {0xDFC6, 0x5482}, //16583 #CJK UNIFIED IDEOGRAPH
    {0xDFC7, 0x5494}, //16584 #CJK UNIFIED IDEOGRAPH
    {0xDFC8, 0x5477}, //16585 #CJK UNIFIED IDEOGRAPH
    {0xDFC9, 0x5471}, //16586 #CJK UNIFIED IDEOGRAPH
    {0xDFCA, 0x5464}, //16587 #CJK UNIFIED IDEOGRAPH
    {0xDFCB, 0x549A}, //16588 #CJK UNIFIED IDEOGRAPH
    {0xDFCC, 0x549B}, //16589 #CJK UNIFIED IDEOGRAPH
    {0xDFCD, 0x5484}, //16590 #CJK UNIFIED IDEOGRAPH
    {0xDFCE, 0x5476}, //16591 #CJK UNIFIED IDEOGRAPH
    {0xDFCF, 0x5466}, //16592 #CJK UNIFIED IDEOGRAPH
    {0xDFD0, 0x549D}, //16593 #CJK UNIFIED IDEOGRAPH
    {0xDFD1, 0x54D0}, //16594 #CJK UNIFIED IDEOGRAPH
    {0xDFD2, 0x54AD}, //16595 #CJK UNIFIED IDEOGRAPH
    {0xDFD3, 0x54C2}, //16596 #CJK UNIFIED IDEOGRAPH
    {0xDFD4, 0x54B4}, //16597 #CJK UNIFIED IDEOGRAPH
    {0xDFD5, 0x54D2}, //16598 #CJK UNIFIED IDEOGRAPH
    {0xDFD6, 0x54A7}, //16599 #CJK UNIFIED IDEOGRAPH
    {0xDFD7, 0x54A6}, //16600 #CJK UNIFIED IDEOGRAPH
    {0xDFD8, 0x54D3}, //16601 #CJK UNIFIED IDEOGRAPH
    {0xDFD9, 0x54D4}, //16602 #CJK UNIFIED IDEOGRAPH
    {0xDFDA, 0x5472}, //16603 #CJK UNIFIED IDEOGRAPH
    {0xDFDB, 0x54A3}, //16604 #CJK UNIFIED IDEOGRAPH
    {0xDFDC, 0x54D5}, //16605 #CJK UNIFIED IDEOGRAPH
    {0xDFDD, 0x54BB}, //16606 #CJK UNIFIED IDEOGRAPH
    {0xDFDE, 0x54BF}, //16607 #CJK UNIFIED IDEOGRAPH
    {0xDFDF, 0x54CC}, //16608 #CJK UNIFIED IDEOGRAPH
    {0xDFE0, 0x54D9}, //16609 #CJK UNIFIED IDEOGRAPH
    {0xDFE1, 0x54DA}, //16610 #CJK UNIFIED IDEOGRAPH
    {0xDFE2, 0x54DC}, //16611 #CJK UNIFIED IDEOGRAPH
    {0xDFE3, 0x54A9}, //16612 #CJK UNIFIED IDEOGRAPH
    {0xDFE4, 0x54AA}, //16613 #CJK UNIFIED IDEOGRAPH
    {0xDFE5, 0x54A4}, //16614 #CJK UNIFIED IDEOGRAPH
    {0xDFE6, 0x54DD}, //16615 #CJK UNIFIED IDEOGRAPH
    {0xDFE7, 0x54CF}, //16616 #CJK UNIFIED IDEOGRAPH
    {0xDFE8, 0x54DE}, //16617 #CJK UNIFIED IDEOGRAPH
    {0xDFE9, 0x551B}, //16618 #CJK UNIFIED IDEOGRAPH
    {0xDFEA, 0x54E7}, //16619 #CJK UNIFIED IDEOGRAPH
    {0xDFEB, 0x5520}, //16620 #CJK UNIFIED IDEOGRAPH
    {0xDFEC, 0x54FD}, //16621 #CJK UNIFIED IDEOGRAPH
    {0xDFED, 0x5514}, //16622 #CJK UNIFIED IDEOGRAPH
    {0xDFEE, 0x54F3}, //16623 #CJK UNIFIED IDEOGRAPH
    {0xDFEF, 0x5522}, //16624 #CJK UNIFIED IDEOGRAPH
    {0xDFF0, 0x5523}, //16625 #CJK UNIFIED IDEOGRAPH
    {0xDFF1, 0x550F}, //16626 #CJK UNIFIED IDEOGRAPH
    {0xDFF2, 0x5511}, //16627 #CJK UNIFIED IDEOGRAPH
    {0xDFF3, 0x5527}, //16628 #CJK UNIFIED IDEOGRAPH
    {0xDFF4, 0x552A}, //16629 #CJK UNIFIED IDEOGRAPH
    {0xDFF5, 0x5567}, //16630 #CJK UNIFIED IDEOGRAPH
    {0xDFF6, 0x558F}, //16631 #CJK UNIFIED IDEOGRAPH
    {0xDFF7, 0x55B5}, //16632 #CJK UNIFIED IDEOGRAPH
    {0xDFF8, 0x5549}, //16633 #CJK UNIFIED IDEOGRAPH
    {0xDFF9, 0x556D}, //16634 #CJK UNIFIED IDEOGRAPH
    {0xDFFA, 0x5541}, //16635 #CJK UNIFIED IDEOGRAPH
    {0xDFFB, 0x5555}, //16636 #CJK UNIFIED IDEOGRAPH
    {0xDFFC, 0x553F}, //16637 #CJK UNIFIED IDEOGRAPH
    {0xDFFD, 0x5550}, //16638 #CJK UNIFIED IDEOGRAPH
    {0xDFFE, 0x553C}, //16639 #CJK UNIFIED IDEOGRAPH
    {0xE040, 0x90C2}, //16640 #CJK UNIFIED IDEOGRAPH
    {0xE041, 0x90C3}, //16641 #CJK UNIFIED IDEOGRAPH
    {0xE042, 0x90C6}, //16642 #CJK UNIFIED IDEOGRAPH
    {0xE043, 0x90C8}, //16643 #CJK UNIFIED IDEOGRAPH
    {0xE044, 0x90C9}, //16644 #CJK UNIFIED IDEOGRAPH
    {0xE045, 0x90CB}, //16645 #CJK UNIFIED IDEOGRAPH
    {0xE046, 0x90CC}, //16646 #CJK UNIFIED IDEOGRAPH
    {0xE047, 0x90CD}, //16647 #CJK UNIFIED IDEOGRAPH
    {0xE048, 0x90D2}, //16648 #CJK UNIFIED IDEOGRAPH
    {0xE049, 0x90D4}, //16649 #CJK UNIFIED IDEOGRAPH
    {0xE04A, 0x90D5}, //16650 #CJK UNIFIED IDEOGRAPH
    {0xE04B, 0x90D6}, //16651 #CJK UNIFIED IDEOGRAPH
    {0xE04C, 0x90D8}, //16652 #CJK UNIFIED IDEOGRAPH
    {0xE04D, 0x90D9}, //16653 #CJK UNIFIED IDEOGRAPH
    {0xE04E, 0x90DA}, //16654 #CJK UNIFIED IDEOGRAPH
    {0xE04F, 0x90DE}, //16655 #CJK UNIFIED IDEOGRAPH
    {0xE050, 0x90DF}, //16656 #CJK UNIFIED IDEOGRAPH
    {0xE051, 0x90E0}, //16657 #CJK UNIFIED IDEOGRAPH
    {0xE052, 0x90E3}, //16658 #CJK UNIFIED IDEOGRAPH
    {0xE053, 0x90E4}, //16659 #CJK UNIFIED IDEOGRAPH
    {0xE054, 0x90E5}, //16660 #CJK UNIFIED IDEOGRAPH
    {0xE055, 0x90E9}, //16661 #CJK UNIFIED IDEOGRAPH
    {0xE056, 0x90EA}, //16662 #CJK UNIFIED IDEOGRAPH
    {0xE057, 0x90EC}, //16663 #CJK UNIFIED IDEOGRAPH
    {0xE058, 0x90EE}, //16664 #CJK UNIFIED IDEOGRAPH
    {0xE059, 0x90F0}, //16665 #CJK UNIFIED IDEOGRAPH
    {0xE05A, 0x90F1}, //16666 #CJK UNIFIED IDEOGRAPH
    {0xE05B, 0x90F2}, //16667 #CJK UNIFIED IDEOGRAPH
    {0xE05C, 0x90F3}, //16668 #CJK UNIFIED IDEOGRAPH
    {0xE05D, 0x90F5}, //16669 #CJK UNIFIED IDEOGRAPH
    {0xE05E, 0x90F6}, //16670 #CJK UNIFIED IDEOGRAPH
    {0xE05F, 0x90F7}, //16671 #CJK UNIFIED IDEOGRAPH
    {0xE060, 0x90F9}, //16672 #CJK UNIFIED IDEOGRAPH
    {0xE061, 0x90FA}, //16673 #CJK UNIFIED IDEOGRAPH
    {0xE062, 0x90FB}, //16674 #CJK UNIFIED IDEOGRAPH
    {0xE063, 0x90FC}, //16675 #CJK UNIFIED IDEOGRAPH
    {0xE064, 0x90FF}, //16676 #CJK UNIFIED IDEOGRAPH
    {0xE065, 0x9100}, //16677 #CJK UNIFIED IDEOGRAPH
    {0xE066, 0x9101}, //16678 #CJK UNIFIED IDEOGRAPH
    {0xE067, 0x9103}, //16679 #CJK UNIFIED IDEOGRAPH
    {0xE068, 0x9105}, //16680 #CJK UNIFIED IDEOGRAPH
    {0xE069, 0x9106}, //16681 #CJK UNIFIED IDEOGRAPH
    {0xE06A, 0x9107}, //16682 #CJK UNIFIED IDEOGRAPH
    {0xE06B, 0x9108}, //16683 #CJK UNIFIED IDEOGRAPH
    {0xE06C, 0x9109}, //16684 #CJK UNIFIED IDEOGRAPH
    {0xE06D, 0x910A}, //16685 #CJK UNIFIED IDEOGRAPH
    {0xE06E, 0x910B}, //16686 #CJK UNIFIED IDEOGRAPH
    {0xE06F, 0x910C}, //16687 #CJK UNIFIED IDEOGRAPH
    {0xE070, 0x910D}, //16688 #CJK UNIFIED IDEOGRAPH
    {0xE071, 0x910E}, //16689 #CJK UNIFIED IDEOGRAPH
    {0xE072, 0x910F}, //16690 #CJK UNIFIED IDEOGRAPH
    {0xE073, 0x9110}, //16691 #CJK UNIFIED IDEOGRAPH
    {0xE074, 0x9111}, //16692 #CJK UNIFIED IDEOGRAPH
    {0xE075, 0x9112}, //16693 #CJK UNIFIED IDEOGRAPH
    {0xE076, 0x9113}, //16694 #CJK UNIFIED IDEOGRAPH
    {0xE077, 0x9114}, //16695 #CJK UNIFIED IDEOGRAPH
    {0xE078, 0x9115}, //16696 #CJK UNIFIED IDEOGRAPH
    {0xE079, 0x9116}, //16697 #CJK UNIFIED IDEOGRAPH
    {0xE07A, 0x9117}, //16698 #CJK UNIFIED IDEOGRAPH
    {0xE07B, 0x9118}, //16699 #CJK UNIFIED IDEOGRAPH
    {0xE07C, 0x911A}, //16700 #CJK UNIFIED IDEOGRAPH
    {0xE07D, 0x911B}, //16701 #CJK UNIFIED IDEOGRAPH
    {0xE07E, 0x911C}, //16702 #CJK UNIFIED IDEOGRAPH
    {0xE080, 0x911D}, //16703 #CJK UNIFIED IDEOGRAPH
    {0xE081, 0x911F}, //16704 #CJK UNIFIED IDEOGRAPH
    {0xE082, 0x9120}, //16705 #CJK UNIFIED IDEOGRAPH
    {0xE083, 0x9121}, //16706 #CJK UNIFIED IDEOGRAPH
    {0xE084, 0x9124}, //16707 #CJK UNIFIED IDEOGRAPH
    {0xE085, 0x9125}, //16708 #CJK UNIFIED IDEOGRAPH
    {0xE086, 0x9126}, //16709 #CJK UNIFIED IDEOGRAPH
    {0xE087, 0x9127}, //16710 #CJK UNIFIED IDEOGRAPH
    {0xE088, 0x9128}, //16711 #CJK UNIFIED IDEOGRAPH
    {0xE089, 0x9129}, //16712 #CJK UNIFIED IDEOGRAPH
    {0xE08A, 0x912A}, //16713 #CJK UNIFIED IDEOGRAPH
    {0xE08B, 0x912B}, //16714 #CJK UNIFIED IDEOGRAPH
    {0xE08C, 0x912C}, //16715 #CJK UNIFIED IDEOGRAPH
    {0xE08D, 0x912D}, //16716 #CJK UNIFIED IDEOGRAPH
    {0xE08E, 0x912E}, //16717 #CJK UNIFIED IDEOGRAPH
    {0xE08F, 0x9130}, //16718 #CJK UNIFIED IDEOGRAPH
    {0xE090, 0x9132}, //16719 #CJK UNIFIED IDEOGRAPH
    {0xE091, 0x9133}, //16720 #CJK UNIFIED IDEOGRAPH
    {0xE092, 0x9134}, //16721 #CJK UNIFIED IDEOGRAPH
    {0xE093, 0x9135}, //16722 #CJK UNIFIED IDEOGRAPH
    {0xE094, 0x9136}, //16723 #CJK UNIFIED IDEOGRAPH
    {0xE095, 0x9137}, //16724 #CJK UNIFIED IDEOGRAPH
    {0xE096, 0x9138}, //16725 #CJK UNIFIED IDEOGRAPH
    {0xE097, 0x913A}, //16726 #CJK UNIFIED IDEOGRAPH
    {0xE098, 0x913B}, //16727 #CJK UNIFIED IDEOGRAPH
    {0xE099, 0x913C}, //16728 #CJK UNIFIED IDEOGRAPH
    {0xE09A, 0x913D}, //16729 #CJK UNIFIED IDEOGRAPH
    {0xE09B, 0x913E}, //16730 #CJK UNIFIED IDEOGRAPH
    {0xE09C, 0x913F}, //16731 #CJK UNIFIED IDEOGRAPH
    {0xE09D, 0x9140}, //16732 #CJK UNIFIED IDEOGRAPH
    {0xE09E, 0x9141}, //16733 #CJK UNIFIED IDEOGRAPH
    {0xE09F, 0x9142}, //16734 #CJK UNIFIED IDEOGRAPH
    {0xE0A0, 0x9144}, //16735 #CJK UNIFIED IDEOGRAPH
    {0xE0A1, 0x5537}, //16736 #CJK UNIFIED IDEOGRAPH
    {0xE0A2, 0x5556}, //16737 #CJK UNIFIED IDEOGRAPH
    {0xE0A3, 0x5575}, //16738 #CJK UNIFIED IDEOGRAPH
    {0xE0A4, 0x5576}, //16739 #CJK UNIFIED IDEOGRAPH
    {0xE0A5, 0x5577}, //16740 #CJK UNIFIED IDEOGRAPH
    {0xE0A6, 0x5533}, //16741 #CJK UNIFIED IDEOGRAPH
    {0xE0A7, 0x5530}, //16742 #CJK UNIFIED IDEOGRAPH
    {0xE0A8, 0x555C}, //16743 #CJK UNIFIED IDEOGRAPH
    {0xE0A9, 0x558B}, //16744 #CJK UNIFIED IDEOGRAPH
    {0xE0AA, 0x55D2}, //16745 #CJK UNIFIED IDEOGRAPH
    {0xE0AB, 0x5583}, //16746 #CJK UNIFIED IDEOGRAPH
    {0xE0AC, 0x55B1}, //16747 #CJK UNIFIED IDEOGRAPH
    {0xE0AD, 0x55B9}, //16748 #CJK UNIFIED IDEOGRAPH
    {0xE0AE, 0x5588}, //16749 #CJK UNIFIED IDEOGRAPH
    {0xE0AF, 0x5581}, //16750 #CJK UNIFIED IDEOGRAPH
    {0xE0B0, 0x559F}, //16751 #CJK UNIFIED IDEOGRAPH
    {0xE0B1, 0x557E}, //16752 #CJK UNIFIED IDEOGRAPH
    {0xE0B2, 0x55D6}, //16753 #CJK UNIFIED IDEOGRAPH
    {0xE0B3, 0x5591}, //16754 #CJK UNIFIED IDEOGRAPH
    {0xE0B4, 0x557B}, //16755 #CJK UNIFIED IDEOGRAPH
    {0xE0B5, 0x55DF}, //16756 #CJK UNIFIED IDEOGRAPH
    {0xE0B6, 0x55BD}, //16757 #CJK UNIFIED IDEOGRAPH
    {0xE0B7, 0x55BE}, //16758 #CJK UNIFIED IDEOGRAPH
    {0xE0B8, 0x5594}, //16759 #CJK UNIFIED IDEOGRAPH
    {0xE0B9, 0x5599}, //16760 #CJK UNIFIED IDEOGRAPH
    {0xE0BA, 0x55EA}, //16761 #CJK UNIFIED IDEOGRAPH
    {0xE0BB, 0x55F7}, //16762 #CJK UNIFIED IDEOGRAPH
    {0xE0BC, 0x55C9}, //16763 #CJK UNIFIED IDEOGRAPH
    {0xE0BD, 0x561F}, //16764 #CJK UNIFIED IDEOGRAPH
    {0xE0BE, 0x55D1}, //16765 #CJK UNIFIED IDEOGRAPH
    {0xE0BF, 0x55EB}, //16766 #CJK UNIFIED IDEOGRAPH
    {0xE0C0, 0x55EC}, //16767 #CJK UNIFIED IDEOGRAPH
    {0xE0C1, 0x55D4}, //16768 #CJK UNIFIED IDEOGRAPH
    {0xE0C2, 0x55E6}, //16769 #CJK UNIFIED IDEOGRAPH
    {0xE0C3, 0x55DD}, //16770 #CJK UNIFIED IDEOGRAPH
    {0xE0C4, 0x55C4}, //16771 #CJK UNIFIED IDEOGRAPH
    {0xE0C5, 0x55EF}, //16772 #CJK UNIFIED IDEOGRAPH
    {0xE0C6, 0x55E5}, //16773 #CJK UNIFIED IDEOGRAPH
    {0xE0C7, 0x55F2}, //16774 #CJK UNIFIED IDEOGRAPH
    {0xE0C8, 0x55F3}, //16775 #CJK UNIFIED IDEOGRAPH
    {0xE0C9, 0x55CC}, //16776 #CJK UNIFIED IDEOGRAPH
    {0xE0CA, 0x55CD}, //16777 #CJK UNIFIED IDEOGRAPH
    {0xE0CB, 0x55E8}, //16778 #CJK UNIFIED IDEOGRAPH
    {0xE0CC, 0x55F5}, //16779 #CJK UNIFIED IDEOGRAPH
    {0xE0CD, 0x55E4}, //16780 #CJK UNIFIED IDEOGRAPH
    {0xE0CE, 0x8F94}, //16781 #CJK UNIFIED IDEOGRAPH
    {0xE0CF, 0x561E}, //16782 #CJK UNIFIED IDEOGRAPH
    {0xE0D0, 0x5608}, //16783 #CJK UNIFIED IDEOGRAPH
    {0xE0D1, 0x560C}, //16784 #CJK UNIFIED IDEOGRAPH
    {0xE0D2, 0x5601}, //16785 #CJK UNIFIED IDEOGRAPH
    {0xE0D3, 0x5624}, //16786 #CJK UNIFIED IDEOGRAPH
    {0xE0D4, 0x5623}, //16787 #CJK UNIFIED IDEOGRAPH
    {0xE0D5, 0x55FE}, //16788 #CJK UNIFIED IDEOGRAPH
    {0xE0D6, 0x5600}, //16789 #CJK UNIFIED IDEOGRAPH
    {0xE0D7, 0x5627}, //16790 #CJK UNIFIED IDEOGRAPH
    {0xE0D8, 0x562D}, //16791 #CJK UNIFIED IDEOGRAPH
    {0xE0D9, 0x5658}, //16792 #CJK UNIFIED IDEOGRAPH
    {0xE0DA, 0x5639}, //16793 #CJK UNIFIED IDEOGRAPH
    {0xE0DB, 0x5657}, //16794 #CJK UNIFIED IDEOGRAPH
    {0xE0DC, 0x562C}, //16795 #CJK UNIFIED IDEOGRAPH
    {0xE0DD, 0x564D}, //16796 #CJK UNIFIED IDEOGRAPH
    {0xE0DE, 0x5662}, //16797 #CJK UNIFIED IDEOGRAPH
    {0xE0DF, 0x5659}, //16798 #CJK UNIFIED IDEOGRAPH
    {0xE0E0, 0x565C}, //16799 #CJK UNIFIED IDEOGRAPH
    {0xE0E1, 0x564C}, //16800 #CJK UNIFIED IDEOGRAPH
    {0xE0E2, 0x5654}, //16801 #CJK UNIFIED IDEOGRAPH
    {0xE0E3, 0x5686}, //16802 #CJK UNIFIED IDEOGRAPH
    {0xE0E4, 0x5664}, //16803 #CJK UNIFIED IDEOGRAPH
    {0xE0E5, 0x5671}, //16804 #CJK UNIFIED IDEOGRAPH
    {0xE0E6, 0x566B}, //16805 #CJK UNIFIED IDEOGRAPH
    {0xE0E7, 0x567B}, //16806 #CJK UNIFIED IDEOGRAPH
    {0xE0E8, 0x567C}, //16807 #CJK UNIFIED IDEOGRAPH
    {0xE0E9, 0x5685}, //16808 #CJK UNIFIED IDEOGRAPH
    {0xE0EA, 0x5693}, //16809 #CJK UNIFIED IDEOGRAPH
    {0xE0EB, 0x56AF}, //16810 #CJK UNIFIED IDEOGRAPH
    {0xE0EC, 0x56D4}, //16811 #CJK UNIFIED IDEOGRAPH
    {0xE0ED, 0x56D7}, //16812 #CJK UNIFIED IDEOGRAPH
    {0xE0EE, 0x56DD}, //16813 #CJK UNIFIED IDEOGRAPH
    {0xE0EF, 0x56E1}, //16814 #CJK UNIFIED IDEOGRAPH
    {0xE0F0, 0x56F5}, //16815 #CJK UNIFIED IDEOGRAPH
    {0xE0F1, 0x56EB}, //16816 #CJK UNIFIED IDEOGRAPH
    {0xE0F2, 0x56F9}, //16817 #CJK UNIFIED IDEOGRAPH
    {0xE0F3, 0x56FF}, //16818 #CJK UNIFIED IDEOGRAPH
    {0xE0F4, 0x5704}, //16819 #CJK UNIFIED IDEOGRAPH
    {0xE0F5, 0x570A}, //16820 #CJK UNIFIED IDEOGRAPH
    {0xE0F6, 0x5709}, //16821 #CJK UNIFIED IDEOGRAPH
    {0xE0F7, 0x571C}, //16822 #CJK UNIFIED IDEOGRAPH
    {0xE0F8, 0x5E0F}, //16823 #CJK UNIFIED IDEOGRAPH
    {0xE0F9, 0x5E19}, //16824 #CJK UNIFIED IDEOGRAPH
    {0xE0FA, 0x5E14}, //16825 #CJK UNIFIED IDEOGRAPH
    {0xE0FB, 0x5E11}, //16826 #CJK UNIFIED IDEOGRAPH
    {0xE0FC, 0x5E31}, //16827 #CJK UNIFIED IDEOGRAPH
    {0xE0FD, 0x5E3B}, //16828 #CJK UNIFIED IDEOGRAPH
    {0xE0FE, 0x5E3C}, //16829 #CJK UNIFIED IDEOGRAPH
    {0xE140, 0x9145}, //16830 #CJK UNIFIED IDEOGRAPH
    {0xE141, 0x9147}, //16831 #CJK UNIFIED IDEOGRAPH
    {0xE142, 0x9148}, //16832 #CJK UNIFIED IDEOGRAPH
    {0xE143, 0x9151}, //16833 #CJK UNIFIED IDEOGRAPH
    {0xE144, 0x9153}, //16834 #CJK UNIFIED IDEOGRAPH
    {0xE145, 0x9154}, //16835 #CJK UNIFIED IDEOGRAPH
    {0xE146, 0x9155}, //16836 #CJK UNIFIED IDEOGRAPH
    {0xE147, 0x9156}, //16837 #CJK UNIFIED IDEOGRAPH
    {0xE148, 0x9158}, //16838 #CJK UNIFIED IDEOGRAPH
    {0xE149, 0x9159}, //16839 #CJK UNIFIED IDEOGRAPH
    {0xE14A, 0x915B}, //16840 #CJK UNIFIED IDEOGRAPH
    {0xE14B, 0x915C}, //16841 #CJK UNIFIED IDEOGRAPH
    {0xE14C, 0x915F}, //16842 #CJK UNIFIED IDEOGRAPH
    {0xE14D, 0x9160}, //16843 #CJK UNIFIED IDEOGRAPH
    {0xE14E, 0x9166}, //16844 #CJK UNIFIED IDEOGRAPH
    {0xE14F, 0x9167}, //16845 #CJK UNIFIED IDEOGRAPH
    {0xE150, 0x9168}, //16846 #CJK UNIFIED IDEOGRAPH
    {0xE151, 0x916B}, //16847 #CJK UNIFIED IDEOGRAPH
    {0xE152, 0x916D}, //16848 #CJK UNIFIED IDEOGRAPH
    {0xE153, 0x9173}, //16849 #CJK UNIFIED IDEOGRAPH
    {0xE154, 0x917A}, //16850 #CJK UNIFIED IDEOGRAPH
    {0xE155, 0x917B}, //16851 #CJK UNIFIED IDEOGRAPH
    {0xE156, 0x917C}, //16852 #CJK UNIFIED IDEOGRAPH
    {0xE157, 0x9180}, //16853 #CJK UNIFIED IDEOGRAPH
    {0xE158, 0x9181}, //16854 #CJK UNIFIED IDEOGRAPH
    {0xE159, 0x9182}, //16855 #CJK UNIFIED IDEOGRAPH
    {0xE15A, 0x9183}, //16856 #CJK UNIFIED IDEOGRAPH
    {0xE15B, 0x9184}, //16857 #CJK UNIFIED IDEOGRAPH
    {0xE15C, 0x9186}, //16858 #CJK UNIFIED IDEOGRAPH
    {0xE15D, 0x9188}, //16859 #CJK UNIFIED IDEOGRAPH
    {0xE15E, 0x918A}, //16860 #CJK UNIFIED IDEOGRAPH
    {0xE15F, 0x918E}, //16861 #CJK UNIFIED IDEOGRAPH
    {0xE160, 0x918F}, //16862 #CJK UNIFIED IDEOGRAPH
    {0xE161, 0x9193}, //16863 #CJK UNIFIED IDEOGRAPH
    {0xE162, 0x9194}, //16864 #CJK UNIFIED IDEOGRAPH
    {0xE163, 0x9195}, //16865 #CJK UNIFIED IDEOGRAPH
    {0xE164, 0x9196}, //16866 #CJK UNIFIED IDEOGRAPH
    {0xE165, 0x9197}, //16867 #CJK UNIFIED IDEOGRAPH
    {0xE166, 0x9198}, //16868 #CJK UNIFIED IDEOGRAPH
    {0xE167, 0x9199}, //16869 #CJK UNIFIED IDEOGRAPH
    {0xE168, 0x919C}, //16870 #CJK UNIFIED IDEOGRAPH
    {0xE169, 0x919D}, //16871 #CJK UNIFIED IDEOGRAPH
    {0xE16A, 0x919E}, //16872 #CJK UNIFIED IDEOGRAPH
    {0xE16B, 0x919F}, //16873 #CJK UNIFIED IDEOGRAPH
    {0xE16C, 0x91A0}, //16874 #CJK UNIFIED IDEOGRAPH
    {0xE16D, 0x91A1}, //16875 #CJK UNIFIED IDEOGRAPH
    {0xE16E, 0x91A4}, //16876 #CJK UNIFIED IDEOGRAPH
    {0xE16F, 0x91A5}, //16877 #CJK UNIFIED IDEOGRAPH
    {0xE170, 0x91A6}, //16878 #CJK UNIFIED IDEOGRAPH
    {0xE171, 0x91A7}, //16879 #CJK UNIFIED IDEOGRAPH
    {0xE172, 0x91A8}, //16880 #CJK UNIFIED IDEOGRAPH
    {0xE173, 0x91A9}, //16881 #CJK UNIFIED IDEOGRAPH
    {0xE174, 0x91AB}, //16882 #CJK UNIFIED IDEOGRAPH
    {0xE175, 0x91AC}, //16883 #CJK UNIFIED IDEOGRAPH
    {0xE176, 0x91B0}, //16884 #CJK UNIFIED IDEOGRAPH
    {0xE177, 0x91B1}, //16885 #CJK UNIFIED IDEOGRAPH
    {0xE178, 0x91B2}, //16886 #CJK UNIFIED IDEOGRAPH
    {0xE179, 0x91B3}, //16887 #CJK UNIFIED IDEOGRAPH
    {0xE17A, 0x91B6}, //16888 #CJK UNIFIED IDEOGRAPH
    {0xE17B, 0x91B7}, //16889 #CJK UNIFIED IDEOGRAPH
    {0xE17C, 0x91B8}, //16890 #CJK UNIFIED IDEOGRAPH
    {0xE17D, 0x91B9}, //16891 #CJK UNIFIED IDEOGRAPH
    {0xE17E, 0x91BB}, //16892 #CJK UNIFIED IDEOGRAPH
    {0xE180, 0x91BC}, //16893 #CJK UNIFIED IDEOGRAPH
    {0xE181, 0x91BD}, //16894 #CJK UNIFIED IDEOGRAPH
    {0xE182, 0x91BE}, //16895 #CJK UNIFIED IDEOGRAPH
    {0xE183, 0x91BF}, //16896 #CJK UNIFIED IDEOGRAPH
    {0xE184, 0x91C0}, //16897 #CJK UNIFIED IDEOGRAPH
    {0xE185, 0x91C1}, //16898 #CJK UNIFIED IDEOGRAPH
    {0xE186, 0x91C2}, //16899 #CJK UNIFIED IDEOGRAPH
    {0xE187, 0x91C3}, //16900 #CJK UNIFIED IDEOGRAPH
    {0xE188, 0x91C4}, //16901 #CJK UNIFIED IDEOGRAPH
    {0xE189, 0x91C5}, //16902 #CJK UNIFIED IDEOGRAPH
    {0xE18A, 0x91C6}, //16903 #CJK UNIFIED IDEOGRAPH
    {0xE18B, 0x91C8}, //16904 #CJK UNIFIED IDEOGRAPH
    {0xE18C, 0x91CB}, //16905 #CJK UNIFIED IDEOGRAPH
    {0xE18D, 0x91D0}, //16906 #CJK UNIFIED IDEOGRAPH
    {0xE18E, 0x91D2}, //16907 #CJK UNIFIED IDEOGRAPH
    {0xE18F, 0x91D3}, //16908 #CJK UNIFIED IDEOGRAPH
    {0xE190, 0x91D4}, //16909 #CJK UNIFIED IDEOGRAPH
    {0xE191, 0x91D5}, //16910 #CJK UNIFIED IDEOGRAPH
    {0xE192, 0x91D6}, //16911 #CJK UNIFIED IDEOGRAPH
    {0xE193, 0x91D7}, //16912 #CJK UNIFIED IDEOGRAPH
    {0xE194, 0x91D8}, //16913 #CJK UNIFIED IDEOGRAPH
    {0xE195, 0x91D9}, //16914 #CJK UNIFIED IDEOGRAPH
    {0xE196, 0x91DA}, //16915 #CJK UNIFIED IDEOGRAPH
    {0xE197, 0x91DB}, //16916 #CJK UNIFIED IDEOGRAPH
    {0xE198, 0x91DD}, //16917 #CJK UNIFIED IDEOGRAPH
    {0xE199, 0x91DE}, //16918 #CJK UNIFIED IDEOGRAPH
    {0xE19A, 0x91DF}, //16919 #CJK UNIFIED IDEOGRAPH
    {0xE19B, 0x91E0}, //16920 #CJK UNIFIED IDEOGRAPH
    {0xE19C, 0x91E1}, //16921 #CJK UNIFIED IDEOGRAPH
    {0xE19D, 0x91E2}, //16922 #CJK UNIFIED IDEOGRAPH
    {0xE19E, 0x91E3}, //16923 #CJK UNIFIED IDEOGRAPH
    {0xE19F, 0x91E4}, //16924 #CJK UNIFIED IDEOGRAPH
    {0xE1A0, 0x91E5}, //16925 #CJK UNIFIED IDEOGRAPH
    {0xE1A1, 0x5E37}, //16926 #CJK UNIFIED IDEOGRAPH
    {0xE1A2, 0x5E44}, //16927 #CJK UNIFIED IDEOGRAPH
    {0xE1A3, 0x5E54}, //16928 #CJK UNIFIED IDEOGRAPH
    {0xE1A4, 0x5E5B}, //16929 #CJK UNIFIED IDEOGRAPH
    {0xE1A5, 0x5E5E}, //16930 #CJK UNIFIED IDEOGRAPH
    {0xE1A6, 0x5E61}, //16931 #CJK UNIFIED IDEOGRAPH
    {0xE1A7, 0x5C8C}, //16932 #CJK UNIFIED IDEOGRAPH
    {0xE1A8, 0x5C7A}, //16933 #CJK UNIFIED IDEOGRAPH
    {0xE1A9, 0x5C8D}, //16934 #CJK UNIFIED IDEOGRAPH
    {0xE1AA, 0x5C90}, //16935 #CJK UNIFIED IDEOGRAPH
    {0xE1AB, 0x5C96}, //16936 #CJK UNIFIED IDEOGRAPH
    {0xE1AC, 0x5C88}, //16937 #CJK UNIFIED IDEOGRAPH
    {0xE1AD, 0x5C98}, //16938 #CJK UNIFIED IDEOGRAPH
    {0xE1AE, 0x5C99}, //16939 #CJK UNIFIED IDEOGRAPH
    {0xE1AF, 0x5C91}, //16940 #CJK UNIFIED IDEOGRAPH
    {0xE1B0, 0x5C9A}, //16941 #CJK UNIFIED IDEOGRAPH
    {0xE1B1, 0x5C9C}, //16942 #CJK UNIFIED IDEOGRAPH
    {0xE1B2, 0x5CB5}, //16943 #CJK UNIFIED IDEOGRAPH
    {0xE1B3, 0x5CA2}, //16944 #CJK UNIFIED IDEOGRAPH
    {0xE1B4, 0x5CBD}, //16945 #CJK UNIFIED IDEOGRAPH
    {0xE1B5, 0x5CAC}, //16946 #CJK UNIFIED IDEOGRAPH
    {0xE1B6, 0x5CAB}, //16947 #CJK UNIFIED IDEOGRAPH
    {0xE1B7, 0x5CB1}, //16948 #CJK UNIFIED IDEOGRAPH
    {0xE1B8, 0x5CA3}, //16949 #CJK UNIFIED IDEOGRAPH
    {0xE1B9, 0x5CC1}, //16950 #CJK UNIFIED IDEOGRAPH
    {0xE1BA, 0x5CB7}, //16951 #CJK UNIFIED IDEOGRAPH
    {0xE1BB, 0x5CC4}, //16952 #CJK UNIFIED IDEOGRAPH
    {0xE1BC, 0x5CD2}, //16953 #CJK UNIFIED IDEOGRAPH
    {0xE1BD, 0x5CE4}, //16954 #CJK UNIFIED IDEOGRAPH
    {0xE1BE, 0x5CCB}, //16955 #CJK UNIFIED IDEOGRAPH
    {0xE1BF, 0x5CE5}, //16956 #CJK UNIFIED IDEOGRAPH
    {0xE1C0, 0x5D02}, //16957 #CJK UNIFIED IDEOGRAPH
    {0xE1C1, 0x5D03}, //16958 #CJK UNIFIED IDEOGRAPH
    {0xE1C2, 0x5D27}, //16959 #CJK UNIFIED IDEOGRAPH
    {0xE1C3, 0x5D26}, //16960 #CJK UNIFIED IDEOGRAPH
    {0xE1C4, 0x5D2E}, //16961 #CJK UNIFIED IDEOGRAPH
    {0xE1C5, 0x5D24}, //16962 #CJK UNIFIED IDEOGRAPH
    {0xE1C6, 0x5D1E}, //16963 #CJK UNIFIED IDEOGRAPH
    {0xE1C7, 0x5D06}, //16964 #CJK UNIFIED IDEOGRAPH
    {0xE1C8, 0x5D1B}, //16965 #CJK UNIFIED IDEOGRAPH
    {0xE1C9, 0x5D58}, //16966 #CJK UNIFIED IDEOGRAPH
    {0xE1CA, 0x5D3E}, //16967 #CJK UNIFIED IDEOGRAPH
    {0xE1CB, 0x5D34}, //16968 #CJK UNIFIED IDEOGRAPH
    {0xE1CC, 0x5D3D}, //16969 #CJK UNIFIED IDEOGRAPH
    {0xE1CD, 0x5D6C}, //16970 #CJK UNIFIED IDEOGRAPH
    {0xE1CE, 0x5D5B}, //16971 #CJK UNIFIED IDEOGRAPH
    {0xE1CF, 0x5D6F}, //16972 #CJK UNIFIED IDEOGRAPH
    {0xE1D0, 0x5D5D}, //16973 #CJK UNIFIED IDEOGRAPH
    {0xE1D1, 0x5D6B}, //16974 #CJK UNIFIED IDEOGRAPH
    {0xE1D2, 0x5D4B}, //16975 #CJK UNIFIED IDEOGRAPH
    {0xE1D3, 0x5D4A}, //16976 #CJK UNIFIED IDEOGRAPH
    {0xE1D4, 0x5D69}, //16977 #CJK UNIFIED IDEOGRAPH
    {0xE1D5, 0x5D74}, //16978 #CJK UNIFIED IDEOGRAPH
    {0xE1D6, 0x5D82}, //16979 #CJK UNIFIED IDEOGRAPH
    {0xE1D7, 0x5D99}, //16980 #CJK UNIFIED IDEOGRAPH
    {0xE1D8, 0x5D9D}, //16981 #CJK UNIFIED IDEOGRAPH
    {0xE1D9, 0x8C73}, //16982 #CJK UNIFIED IDEOGRAPH
    {0xE1DA, 0x5DB7}, //16983 #CJK UNIFIED IDEOGRAPH
    {0xE1DB, 0x5DC5}, //16984 #CJK UNIFIED IDEOGRAPH
    {0xE1DC, 0x5F73}, //16985 #CJK UNIFIED IDEOGRAPH
    {0xE1DD, 0x5F77}, //16986 #CJK UNIFIED IDEOGRAPH
    {0xE1DE, 0x5F82}, //16987 #CJK UNIFIED IDEOGRAPH
    {0xE1DF, 0x5F87}, //16988 #CJK UNIFIED IDEOGRAPH
    {0xE1E0, 0x5F89}, //16989 #CJK UNIFIED IDEOGRAPH
    {0xE1E1, 0x5F8C}, //16990 #CJK UNIFIED IDEOGRAPH
    {0xE1E2, 0x5F95}, //16991 #CJK UNIFIED IDEOGRAPH
    {0xE1E3, 0x5F99}, //16992 #CJK UNIFIED IDEOGRAPH
    {0xE1E4, 0x5F9C}, //16993 #CJK UNIFIED IDEOGRAPH
    {0xE1E5, 0x5FA8}, //16994 #CJK UNIFIED IDEOGRAPH
    {0xE1E6, 0x5FAD}, //16995 #CJK UNIFIED IDEOGRAPH
    {0xE1E7, 0x5FB5}, //16996 #CJK UNIFIED IDEOGRAPH
    {0xE1E8, 0x5FBC}, //16997 #CJK UNIFIED IDEOGRAPH
    {0xE1E9, 0x8862}, //16998 #CJK UNIFIED IDEOGRAPH
    {0xE1EA, 0x5F61}, //16999 #CJK UNIFIED IDEOGRAPH
    {0xE1EB, 0x72AD}, //17000 #CJK UNIFIED IDEOGRAPH
    {0xE1EC, 0x72B0}, //17001 #CJK UNIFIED IDEOGRAPH
    {0xE1ED, 0x72B4}, //17002 #CJK UNIFIED IDEOGRAPH
    {0xE1EE, 0x72B7}, //17003 #CJK UNIFIED IDEOGRAPH
    {0xE1EF, 0x72B8}, //17004 #CJK UNIFIED IDEOGRAPH
    {0xE1F0, 0x72C3}, //17005 #CJK UNIFIED IDEOGRAPH
    {0xE1F1, 0x72C1}, //17006 #CJK UNIFIED IDEOGRAPH
    {0xE1F2, 0x72CE}, //17007 #CJK UNIFIED IDEOGRAPH
    {0xE1F3, 0x72CD}, //17008 #CJK UNIFIED IDEOGRAPH
    {0xE1F4, 0x72D2}, //17009 #CJK UNIFIED IDEOGRAPH
    {0xE1F5, 0x72E8}, //17010 #CJK UNIFIED IDEOGRAPH
    {0xE1F6, 0x72EF}, //17011 #CJK UNIFIED IDEOGRAPH
    {0xE1F7, 0x72E9}, //17012 #CJK UNIFIED IDEOGRAPH
    {0xE1F8, 0x72F2}, //17013 #CJK UNIFIED IDEOGRAPH
    {0xE1F9, 0x72F4}, //17014 #CJK UNIFIED IDEOGRAPH
    {0xE1FA, 0x72F7}, //17015 #CJK UNIFIED IDEOGRAPH
    {0xE1FB, 0x7301}, //17016 #CJK UNIFIED IDEOGRAPH
    {0xE1FC, 0x72F3}, //17017 #CJK UNIFIED IDEOGRAPH
    {0xE1FD, 0x7303}, //17018 #CJK UNIFIED IDEOGRAPH
    {0xE1FE, 0x72FA}, //17019 #CJK UNIFIED IDEOGRAPH
    {0xE240, 0x91E6}, //17020 #CJK UNIFIED IDEOGRAPH
    {0xE241, 0x91E7}, //17021 #CJK UNIFIED IDEOGRAPH
    {0xE242, 0x91E8}, //17022 #CJK UNIFIED IDEOGRAPH
    {0xE243, 0x91E9}, //17023 #CJK UNIFIED IDEOGRAPH
    {0xE244, 0x91EA}, //17024 #CJK UNIFIED IDEOGRAPH
    {0xE245, 0x91EB}, //17025 #CJK UNIFIED IDEOGRAPH
    {0xE246, 0x91EC}, //17026 #CJK UNIFIED IDEOGRAPH
    {0xE247, 0x91ED}, //17027 #CJK UNIFIED IDEOGRAPH
    {0xE248, 0x91EE}, //17028 #CJK UNIFIED IDEOGRAPH
    {0xE249, 0x91EF}, //17029 #CJK UNIFIED IDEOGRAPH
    {0xE24A, 0x91F0}, //17030 #CJK UNIFIED IDEOGRAPH
    {0xE24B, 0x91F1}, //17031 #CJK UNIFIED IDEOGRAPH
    {0xE24C, 0x91F2}, //17032 #CJK UNIFIED IDEOGRAPH
    {0xE24D, 0x91F3}, //17033 #CJK UNIFIED IDEOGRAPH
    {0xE24E, 0x91F4}, //17034 #CJK UNIFIED IDEOGRAPH
    {0xE24F, 0x91F5}, //17035 #CJK UNIFIED IDEOGRAPH
    {0xE250, 0x91F6}, //17036 #CJK UNIFIED IDEOGRAPH
    {0xE251, 0x91F7}, //17037 #CJK UNIFIED IDEOGRAPH
    {0xE252, 0x91F8}, //17038 #CJK UNIFIED IDEOGRAPH
    {0xE253, 0x91F9}, //17039 #CJK UNIFIED IDEOGRAPH
    {0xE254, 0x91FA}, //17040 #CJK UNIFIED IDEOGRAPH
    {0xE255, 0x91FB}, //17041 #CJK UNIFIED IDEOGRAPH
    {0xE256, 0x91FC}, //17042 #CJK UNIFIED IDEOGRAPH
    {0xE257, 0x91FD}, //17043 #CJK UNIFIED IDEOGRAPH
    {0xE258, 0x91FE}, //17044 #CJK UNIFIED IDEOGRAPH
    {0xE259, 0x91FF}, //17045 #CJK UNIFIED IDEOGRAPH
    {0xE25A, 0x9200}, //17046 #CJK UNIFIED IDEOGRAPH
    {0xE25B, 0x9201}, //17047 #CJK UNIFIED IDEOGRAPH
    {0xE25C, 0x9202}, //17048 #CJK UNIFIED IDEOGRAPH
    {0xE25D, 0x9203}, //17049 #CJK UNIFIED IDEOGRAPH
    {0xE25E, 0x9204}, //17050 #CJK UNIFIED IDEOGRAPH
    {0xE25F, 0x9205}, //17051 #CJK UNIFIED IDEOGRAPH
    {0xE260, 0x9206}, //17052 #CJK UNIFIED IDEOGRAPH
    {0xE261, 0x9207}, //17053 #CJK UNIFIED IDEOGRAPH
    {0xE262, 0x9208}, //17054 #CJK UNIFIED IDEOGRAPH
    {0xE263, 0x9209}, //17055 #CJK UNIFIED IDEOGRAPH
    {0xE264, 0x920A}, //17056 #CJK UNIFIED IDEOGRAPH
    {0xE265, 0x920B}, //17057 #CJK UNIFIED IDEOGRAPH
    {0xE266, 0x920C}, //17058 #CJK UNIFIED IDEOGRAPH
    {0xE267, 0x920D}, //17059 #CJK UNIFIED IDEOGRAPH
    {0xE268, 0x920E}, //17060 #CJK UNIFIED IDEOGRAPH
    {0xE269, 0x920F}, //17061 #CJK UNIFIED IDEOGRAPH
    {0xE26A, 0x9210}, //17062 #CJK UNIFIED IDEOGRAPH
    {0xE26B, 0x9211}, //17063 #CJK UNIFIED IDEOGRAPH
    {0xE26C, 0x9212}, //17064 #CJK UNIFIED IDEOGRAPH
    {0xE26D, 0x9213}, //17065 #CJK UNIFIED IDEOGRAPH
    {0xE26E, 0x9214}, //17066 #CJK UNIFIED IDEOGRAPH
    {0xE26F, 0x9215}, //17067 #CJK UNIFIED IDEOGRAPH
    {0xE270, 0x9216}, //17068 #CJK UNIFIED IDEOGRAPH
    {0xE271, 0x9217}, //17069 #CJK UNIFIED IDEOGRAPH
    {0xE272, 0x9218}, //17070 #CJK UNIFIED IDEOGRAPH
    {0xE273, 0x9219}, //17071 #CJK UNIFIED IDEOGRAPH
    {0xE274, 0x921A}, //17072 #CJK UNIFIED IDEOGRAPH
    {0xE275, 0x921B}, //17073 #CJK UNIFIED IDEOGRAPH
    {0xE276, 0x921C}, //17074 #CJK UNIFIED IDEOGRAPH
    {0xE277, 0x921D}, //17075 #CJK UNIFIED IDEOGRAPH
    {0xE278, 0x921E}, //17076 #CJK UNIFIED IDEOGRAPH
    {0xE279, 0x921F}, //17077 #CJK UNIFIED IDEOGRAPH
    {0xE27A, 0x9220}, //17078 #CJK UNIFIED IDEOGRAPH
    {0xE27B, 0x9221}, //17079 #CJK UNIFIED IDEOGRAPH
    {0xE27C, 0x9222}, //17080 #CJK UNIFIED IDEOGRAPH
    {0xE27D, 0x9223}, //17081 #CJK UNIFIED IDEOGRAPH
    {0xE27E, 0x9224}, //17082 #CJK UNIFIED IDEOGRAPH
    {0xE280, 0x9225}, //17083 #CJK UNIFIED IDEOGRAPH
    {0xE281, 0x9226}, //17084 #CJK UNIFIED IDEOGRAPH
    {0xE282, 0x9227}, //17085 #CJK UNIFIED IDEOGRAPH
    {0xE283, 0x9228}, //17086 #CJK UNIFIED IDEOGRAPH
    {0xE284, 0x9229}, //17087 #CJK UNIFIED IDEOGRAPH
    {0xE285, 0x922A}, //17088 #CJK UNIFIED IDEOGRAPH
    {0xE286, 0x922B}, //17089 #CJK UNIFIED IDEOGRAPH
    {0xE287, 0x922C}, //17090 #CJK UNIFIED IDEOGRAPH
    {0xE288, 0x922D}, //17091 #CJK UNIFIED IDEOGRAPH
    {0xE289, 0x922E}, //17092 #CJK UNIFIED IDEOGRAPH
    {0xE28A, 0x922F}, //17093 #CJK UNIFIED IDEOGRAPH
    {0xE28B, 0x9230}, //17094 #CJK UNIFIED IDEOGRAPH
    {0xE28C, 0x9231}, //17095 #CJK UNIFIED IDEOGRAPH
    {0xE28D, 0x9232}, //17096 #CJK UNIFIED IDEOGRAPH
    {0xE28E, 0x9233}, //17097 #CJK UNIFIED IDEOGRAPH
    {0xE28F, 0x9234}, //17098 #CJK UNIFIED IDEOGRAPH
    {0xE290, 0x9235}, //17099 #CJK UNIFIED IDEOGRAPH
    {0xE291, 0x9236}, //17100 #CJK UNIFIED IDEOGRAPH
    {0xE292, 0x9237}, //17101 #CJK UNIFIED IDEOGRAPH
    {0xE293, 0x9238}, //17102 #CJK UNIFIED IDEOGRAPH
    {0xE294, 0x9239}, //17103 #CJK UNIFIED IDEOGRAPH
    {0xE295, 0x923A}, //17104 #CJK UNIFIED IDEOGRAPH
    {0xE296, 0x923B}, //17105 #CJK UNIFIED IDEOGRAPH
    {0xE297, 0x923C}, //17106 #CJK UNIFIED IDEOGRAPH
    {0xE298, 0x923D}, //17107 #CJK UNIFIED IDEOGRAPH
    {0xE299, 0x923E}, //17108 #CJK UNIFIED IDEOGRAPH
    {0xE29A, 0x923F}, //17109 #CJK UNIFIED IDEOGRAPH
    {0xE29B, 0x9240}, //17110 #CJK UNIFIED IDEOGRAPH
    {0xE29C, 0x9241}, //17111 #CJK UNIFIED IDEOGRAPH
    {0xE29D, 0x9242}, //17112 #CJK UNIFIED IDEOGRAPH
    {0xE29E, 0x9243}, //17113 #CJK UNIFIED IDEOGRAPH
    {0xE29F, 0x9244}, //17114 #CJK UNIFIED IDEOGRAPH
    {0xE2A0, 0x9245}, //17115 #CJK UNIFIED IDEOGRAPH
    {0xE2A1, 0x72FB}, //17116 #CJK UNIFIED IDEOGRAPH
    {0xE2A2, 0x7317}, //17117 #CJK UNIFIED IDEOGRAPH
    {0xE2A3, 0x7313}, //17118 #CJK UNIFIED IDEOGRAPH
    {0xE2A4, 0x7321}, //17119 #CJK UNIFIED IDEOGRAPH
    {0xE2A5, 0x730A}, //17120 #CJK UNIFIED IDEOGRAPH
    {0xE2A6, 0x731E}, //17121 #CJK UNIFIED IDEOGRAPH
    {0xE2A7, 0x731D}, //17122 #CJK UNIFIED IDEOGRAPH
    {0xE2A8, 0x7315}, //17123 #CJK UNIFIED IDEOGRAPH
    {0xE2A9, 0x7322}, //17124 #CJK UNIFIED IDEOGRAPH
    {0xE2AA, 0x7339}, //17125 #CJK UNIFIED IDEOGRAPH
    {0xE2AB, 0x7325}, //17126 #CJK UNIFIED IDEOGRAPH
    {0xE2AC, 0x732C}, //17127 #CJK UNIFIED IDEOGRAPH
    {0xE2AD, 0x7338}, //17128 #CJK UNIFIED IDEOGRAPH
    {0xE2AE, 0x7331}, //17129 #CJK UNIFIED IDEOGRAPH
    {0xE2AF, 0x7350}, //17130 #CJK UNIFIED IDEOGRAPH
    {0xE2B0, 0x734D}, //17131 #CJK UNIFIED IDEOGRAPH
    {0xE2B1, 0x7357}, //17132 #CJK UNIFIED IDEOGRAPH
    {0xE2B2, 0x7360}, //17133 #CJK UNIFIED IDEOGRAPH
    {0xE2B3, 0x736C}, //17134 #CJK UNIFIED IDEOGRAPH
    {0xE2B4, 0x736F}, //17135 #CJK UNIFIED IDEOGRAPH
    {0xE2B5, 0x737E}, //17136 #CJK UNIFIED IDEOGRAPH
    {0xE2B6, 0x821B}, //17137 #CJK UNIFIED IDEOGRAPH
    {0xE2B7, 0x5925}, //17138 #CJK UNIFIED IDEOGRAPH
    {0xE2B8, 0x98E7}, //17139 #CJK UNIFIED IDEOGRAPH
    {0xE2B9, 0x5924}, //17140 #CJK UNIFIED IDEOGRAPH
    {0xE2BA, 0x5902}, //17141 #CJK UNIFIED IDEOGRAPH
    {0xE2BB, 0x9963}, //17142 #CJK UNIFIED IDEOGRAPH
    {0xE2BC, 0x9967}, //17143 #CJK UNIFIED IDEOGRAPH
    {0xE2BD, 0x9968}, //17144 #CJK UNIFIED IDEOGRAPH
    {0xE2BE, 0x9969}, //17145 #CJK UNIFIED IDEOGRAPH
    {0xE2BF, 0x996A}, //17146 #CJK UNIFIED IDEOGRAPH
    {0xE2C0, 0x996B}, //17147 #CJK UNIFIED IDEOGRAPH
    {0xE2C1, 0x996C}, //17148 #CJK UNIFIED IDEOGRAPH
    {0xE2C2, 0x9974}, //17149 #CJK UNIFIED IDEOGRAPH
    {0xE2C3, 0x9977}, //17150 #CJK UNIFIED IDEOGRAPH
    {0xE2C4, 0x997D}, //17151 #CJK UNIFIED IDEOGRAPH
    {0xE2C5, 0x9980}, //17152 #CJK UNIFIED IDEOGRAPH
    {0xE2C6, 0x9984}, //17153 #CJK UNIFIED IDEOGRAPH
    {0xE2C7, 0x9987}, //17154 #CJK UNIFIED IDEOGRAPH
    {0xE2C8, 0x998A}, //17155 #CJK UNIFIED IDEOGRAPH
    {0xE2C9, 0x998D}, //17156 #CJK UNIFIED IDEOGRAPH
    {0xE2CA, 0x9990}, //17157 #CJK UNIFIED IDEOGRAPH
    {0xE2CB, 0x9991}, //17158 #CJK UNIFIED IDEOGRAPH
    {0xE2CC, 0x9993}, //17159 #CJK UNIFIED IDEOGRAPH
    {0xE2CD, 0x9994}, //17160 #CJK UNIFIED IDEOGRAPH
    {0xE2CE, 0x9995}, //17161 #CJK UNIFIED IDEOGRAPH
    {0xE2CF, 0x5E80}, //17162 #CJK UNIFIED IDEOGRAPH
    {0xE2D0, 0x5E91}, //17163 #CJK UNIFIED IDEOGRAPH
    {0xE2D1, 0x5E8B}, //17164 #CJK UNIFIED IDEOGRAPH
    {0xE2D2, 0x5E96}, //17165 #CJK UNIFIED IDEOGRAPH
    {0xE2D3, 0x5EA5}, //17166 #CJK UNIFIED IDEOGRAPH
    {0xE2D4, 0x5EA0}, //17167 #CJK UNIFIED IDEOGRAPH
    {0xE2D5, 0x5EB9}, //17168 #CJK UNIFIED IDEOGRAPH
    {0xE2D6, 0x5EB5}, //17169 #CJK UNIFIED IDEOGRAPH
    {0xE2D7, 0x5EBE}, //17170 #CJK UNIFIED IDEOGRAPH
    {0xE2D8, 0x5EB3}, //17171 #CJK UNIFIED IDEOGRAPH
    {0xE2D9, 0x8D53}, //17172 #CJK UNIFIED IDEOGRAPH
    {0xE2DA, 0x5ED2}, //17173 #CJK UNIFIED IDEOGRAPH
    {0xE2DB, 0x5ED1}, //17174 #CJK UNIFIED IDEOGRAPH
    {0xE2DC, 0x5EDB}, //17175 #CJK UNIFIED IDEOGRAPH
    {0xE2DD, 0x5EE8}, //17176 #CJK UNIFIED IDEOGRAPH
    {0xE2DE, 0x5EEA}, //17177 #CJK UNIFIED IDEOGRAPH
    {0xE2DF, 0x81BA}, //17178 #CJK UNIFIED IDEOGRAPH
    {0xE2E0, 0x5FC4}, //17179 #CJK UNIFIED IDEOGRAPH
    {0xE2E1, 0x5FC9}, //17180 #CJK UNIFIED IDEOGRAPH
    {0xE2E2, 0x5FD6}, //17181 #CJK UNIFIED IDEOGRAPH
    {0xE2E3, 0x5FCF}, //17182 #CJK UNIFIED IDEOGRAPH
    {0xE2E4, 0x6003}, //17183 #CJK UNIFIED IDEOGRAPH
    {0xE2E5, 0x5FEE}, //17184 #CJK UNIFIED IDEOGRAPH
    {0xE2E6, 0x6004}, //17185 #CJK UNIFIED IDEOGRAPH
    {0xE2E7, 0x5FE1}, //17186 #CJK UNIFIED IDEOGRAPH
    {0xE2E8, 0x5FE4}, //17187 #CJK UNIFIED IDEOGRAPH
    {0xE2E9, 0x5FFE}, //17188 #CJK UNIFIED IDEOGRAPH
    {0xE2EA, 0x6005}, //17189 #CJK UNIFIED IDEOGRAPH
    {0xE2EB, 0x6006}, //17190 #CJK UNIFIED IDEOGRAPH
    {0xE2EC, 0x5FEA}, //17191 #CJK UNIFIED IDEOGRAPH
    {0xE2ED, 0x5FED}, //17192 #CJK UNIFIED IDEOGRAPH
    {0xE2EE, 0x5FF8}, //17193 #CJK UNIFIED IDEOGRAPH
    {0xE2EF, 0x6019}, //17194 #CJK UNIFIED IDEOGRAPH
    {0xE2F0, 0x6035}, //17195 #CJK UNIFIED IDEOGRAPH
    {0xE2F1, 0x6026}, //17196 #CJK UNIFIED IDEOGRAPH
    {0xE2F2, 0x601B}, //17197 #CJK UNIFIED IDEOGRAPH
    {0xE2F3, 0x600F}, //17198 #CJK UNIFIED IDEOGRAPH
    {0xE2F4, 0x600D}, //17199 #CJK UNIFIED IDEOGRAPH
    {0xE2F5, 0x6029}, //17200 #CJK UNIFIED IDEOGRAPH
    {0xE2F6, 0x602B}, //17201 #CJK UNIFIED IDEOGRAPH
    {0xE2F7, 0x600A}, //17202 #CJK UNIFIED IDEOGRAPH
    {0xE2F8, 0x603F}, //17203 #CJK UNIFIED IDEOGRAPH
    {0xE2F9, 0x6021}, //17204 #CJK UNIFIED IDEOGRAPH
    {0xE2FA, 0x6078}, //17205 #CJK UNIFIED IDEOGRAPH
    {0xE2FB, 0x6079}, //17206 #CJK UNIFIED IDEOGRAPH
    {0xE2FC, 0x607B}, //17207 #CJK UNIFIED IDEOGRAPH
    {0xE2FD, 0x607A}, //17208 #CJK UNIFIED IDEOGRAPH
    {0xE2FE, 0x6042}, //17209 #CJK UNIFIED IDEOGRAPH
    {0xE340, 0x9246}, //17210 #CJK UNIFIED IDEOGRAPH
    {0xE341, 0x9247}, //17211 #CJK UNIFIED IDEOGRAPH
    {0xE342, 0x9248}, //17212 #CJK UNIFIED IDEOGRAPH
    {0xE343, 0x9249}, //17213 #CJK UNIFIED IDEOGRAPH
    {0xE344, 0x924A}, //17214 #CJK UNIFIED IDEOGRAPH
    {0xE345, 0x924B}, //17215 #CJK UNIFIED IDEOGRAPH
    {0xE346, 0x924C}, //17216 #CJK UNIFIED IDEOGRAPH
    {0xE347, 0x924D}, //17217 #CJK UNIFIED IDEOGRAPH
    {0xE348, 0x924E}, //17218 #CJK UNIFIED IDEOGRAPH
    {0xE349, 0x924F}, //17219 #CJK UNIFIED IDEOGRAPH
    {0xE34A, 0x9250}, //17220 #CJK UNIFIED IDEOGRAPH
    {0xE34B, 0x9251}, //17221 #CJK UNIFIED IDEOGRAPH
    {0xE34C, 0x9252}, //17222 #CJK UNIFIED IDEOGRAPH
    {0xE34D, 0x9253}, //17223 #CJK UNIFIED IDEOGRAPH
    {0xE34E, 0x9254}, //17224 #CJK UNIFIED IDEOGRAPH
    {0xE34F, 0x9255}, //17225 #CJK UNIFIED IDEOGRAPH
    {0xE350, 0x9256}, //17226 #CJK UNIFIED IDEOGRAPH
    {0xE351, 0x9257}, //17227 #CJK UNIFIED IDEOGRAPH
    {0xE352, 0x9258}, //17228 #CJK UNIFIED IDEOGRAPH
    {0xE353, 0x9259}, //17229 #CJK UNIFIED IDEOGRAPH
    {0xE354, 0x925A}, //17230 #CJK UNIFIED IDEOGRAPH
    {0xE355, 0x925B}, //17231 #CJK UNIFIED IDEOGRAPH
    {0xE356, 0x925C}, //17232 #CJK UNIFIED IDEOGRAPH
    {0xE357, 0x925D}, //17233 #CJK UNIFIED IDEOGRAPH
    {0xE358, 0x925E}, //17234 #CJK UNIFIED IDEOGRAPH
    {0xE359, 0x925F}, //17235 #CJK UNIFIED IDEOGRAPH
    {0xE35A, 0x9260}, //17236 #CJK UNIFIED IDEOGRAPH
    {0xE35B, 0x9261}, //17237 #CJK UNIFIED IDEOGRAPH
    {0xE35C, 0x9262}, //17238 #CJK UNIFIED IDEOGRAPH
    {0xE35D, 0x9263}, //17239 #CJK UNIFIED IDEOGRAPH
    {0xE35E, 0x9264}, //17240 #CJK UNIFIED IDEOGRAPH
    {0xE35F, 0x9265}, //17241 #CJK UNIFIED IDEOGRAPH
    {0xE360, 0x9266}, //17242 #CJK UNIFIED IDEOGRAPH
    {0xE361, 0x9267}, //17243 #CJK UNIFIED IDEOGRAPH
    {0xE362, 0x9268}, //17244 #CJK UNIFIED IDEOGRAPH
    {0xE363, 0x9269}, //17245 #CJK UNIFIED IDEOGRAPH
    {0xE364, 0x926A}, //17246 #CJK UNIFIED IDEOGRAPH
    {0xE365, 0x926B}, //17247 #CJK UNIFIED IDEOGRAPH
    {0xE366, 0x926C}, //17248 #CJK UNIFIED IDEOGRAPH
    {0xE367, 0x926D}, //17249 #CJK UNIFIED IDEOGRAPH
    {0xE368, 0x926E}, //17250 #CJK UNIFIED IDEOGRAPH
    {0xE369, 0x926F}, //17251 #CJK UNIFIED IDEOGRAPH
    {0xE36A, 0x9270}, //17252 #CJK UNIFIED IDEOGRAPH
    {0xE36B, 0x9271}, //17253 #CJK UNIFIED IDEOGRAPH
    {0xE36C, 0x9272}, //17254 #CJK UNIFIED IDEOGRAPH
    {0xE36D, 0x9273}, //17255 #CJK UNIFIED IDEOGRAPH
    {0xE36E, 0x9275}, //17256 #CJK UNIFIED IDEOGRAPH
    {0xE36F, 0x9276}, //17257 #CJK UNIFIED IDEOGRAPH
    {0xE370, 0x9277}, //17258 #CJK UNIFIED IDEOGRAPH
    {0xE371, 0x9278}, //17259 #CJK UNIFIED IDEOGRAPH
    {0xE372, 0x9279}, //17260 #CJK UNIFIED IDEOGRAPH
    {0xE373, 0x927A}, //17261 #CJK UNIFIED IDEOGRAPH
    {0xE374, 0x927B}, //17262 #CJK UNIFIED IDEOGRAPH
    {0xE375, 0x927C}, //17263 #CJK UNIFIED IDEOGRAPH
    {0xE376, 0x927D}, //17264 #CJK UNIFIED IDEOGRAPH
    {0xE377, 0x927E}, //17265 #CJK UNIFIED IDEOGRAPH
    {0xE378, 0x927F}, //17266 #CJK UNIFIED IDEOGRAPH
    {0xE379, 0x9280}, //17267 #CJK UNIFIED IDEOGRAPH
    {0xE37A, 0x9281}, //17268 #CJK UNIFIED IDEOGRAPH
    {0xE37B, 0x9282}, //17269 #CJK UNIFIED IDEOGRAPH
    {0xE37C, 0x9283}, //17270 #CJK UNIFIED IDEOGRAPH
    {0xE37D, 0x9284}, //17271 #CJK UNIFIED IDEOGRAPH
    {0xE37E, 0x9285}, //17272 #CJK UNIFIED IDEOGRAPH
    {0xE380, 0x9286}, //17273 #CJK UNIFIED IDEOGRAPH
    {0xE381, 0x9287}, //17274 #CJK UNIFIED IDEOGRAPH
    {0xE382, 0x9288}, //17275 #CJK UNIFIED IDEOGRAPH
    {0xE383, 0x9289}, //17276 #CJK UNIFIED IDEOGRAPH
    {0xE384, 0x928A}, //17277 #CJK UNIFIED IDEOGRAPH
    {0xE385, 0x928B}, //17278 #CJK UNIFIED IDEOGRAPH
    {0xE386, 0x928C}, //17279 #CJK UNIFIED IDEOGRAPH
    {0xE387, 0x928D}, //17280 #CJK UNIFIED IDEOGRAPH
    {0xE388, 0x928F}, //17281 #CJK UNIFIED IDEOGRAPH
    {0xE389, 0x9290}, //17282 #CJK UNIFIED IDEOGRAPH
    {0xE38A, 0x9291}, //17283 #CJK UNIFIED IDEOGRAPH
    {0xE38B, 0x9292}, //17284 #CJK UNIFIED IDEOGRAPH
    {0xE38C, 0x9293}, //17285 #CJK UNIFIED IDEOGRAPH
    {0xE38D, 0x9294}, //17286 #CJK UNIFIED IDEOGRAPH
    {0xE38E, 0x9295}, //17287 #CJK UNIFIED IDEOGRAPH
    {0xE38F, 0x9296}, //17288 #CJK UNIFIED IDEOGRAPH
    {0xE390, 0x9297}, //17289 #CJK UNIFIED IDEOGRAPH
    {0xE391, 0x9298}, //17290 #CJK UNIFIED IDEOGRAPH
    {0xE392, 0x9299}, //17291 #CJK UNIFIED IDEOGRAPH
    {0xE393, 0x929A}, //17292 #CJK UNIFIED IDEOGRAPH
    {0xE394, 0x929B}, //17293 #CJK UNIFIED IDEOGRAPH
    {0xE395, 0x929C}, //17294 #CJK UNIFIED IDEOGRAPH
    {0xE396, 0x929D}, //17295 #CJK UNIFIED IDEOGRAPH
    {0xE397, 0x929E}, //17296 #CJK UNIFIED IDEOGRAPH
    {0xE398, 0x929F}, //17297 #CJK UNIFIED IDEOGRAPH
    {0xE399, 0x92A0}, //17298 #CJK UNIFIED IDEOGRAPH
    {0xE39A, 0x92A1}, //17299 #CJK UNIFIED IDEOGRAPH
    {0xE39B, 0x92A2}, //17300 #CJK UNIFIED IDEOGRAPH
    {0xE39C, 0x92A3}, //17301 #CJK UNIFIED IDEOGRAPH
    {0xE39D, 0x92A4}, //17302 #CJK UNIFIED IDEOGRAPH
    {0xE39E, 0x92A5}, //17303 #CJK UNIFIED IDEOGRAPH
    {0xE39F, 0x92A6}, //17304 #CJK UNIFIED IDEOGRAPH
    {0xE3A0, 0x92A7}, //17305 #CJK UNIFIED IDEOGRAPH
    {0xE3A1, 0x606A}, //17306 #CJK UNIFIED IDEOGRAPH
    {0xE3A2, 0x607D}, //17307 #CJK UNIFIED IDEOGRAPH
    {0xE3A3, 0x6096}, //17308 #CJK UNIFIED IDEOGRAPH
    {0xE3A4, 0x609A}, //17309 #CJK UNIFIED IDEOGRAPH
    {0xE3A5, 0x60AD}, //17310 #CJK UNIFIED IDEOGRAPH
    {0xE3A6, 0x609D}, //17311 #CJK UNIFIED IDEOGRAPH
    {0xE3A7, 0x6083}, //17312 #CJK UNIFIED IDEOGRAPH
    {0xE3A8, 0x6092}, //17313 #CJK UNIFIED IDEOGRAPH
    {0xE3A9, 0x608C}, //17314 #CJK UNIFIED IDEOGRAPH
    {0xE3AA, 0x609B}, //17315 #CJK UNIFIED IDEOGRAPH
    {0xE3AB, 0x60EC}, //17316 #CJK UNIFIED IDEOGRAPH
    {0xE3AC, 0x60BB}, //17317 #CJK UNIFIED IDEOGRAPH
    {0xE3AD, 0x60B1}, //17318 #CJK UNIFIED IDEOGRAPH
    {0xE3AE, 0x60DD}, //17319 #CJK UNIFIED IDEOGRAPH
    {0xE3AF, 0x60D8}, //17320 #CJK UNIFIED IDEOGRAPH
    {0xE3B0, 0x60C6}, //17321 #CJK UNIFIED IDEOGRAPH
    {0xE3B1, 0x60DA}, //17322 #CJK UNIFIED IDEOGRAPH
    {0xE3B2, 0x60B4}, //17323 #CJK UNIFIED IDEOGRAPH
    {0xE3B3, 0x6120}, //17324 #CJK UNIFIED IDEOGRAPH
    {0xE3B4, 0x6126}, //17325 #CJK UNIFIED IDEOGRAPH
    {0xE3B5, 0x6115}, //17326 #CJK UNIFIED IDEOGRAPH
    {0xE3B6, 0x6123}, //17327 #CJK UNIFIED IDEOGRAPH
    {0xE3B7, 0x60F4}, //17328 #CJK UNIFIED IDEOGRAPH
    {0xE3B8, 0x6100}, //17329 #CJK UNIFIED IDEOGRAPH
    {0xE3B9, 0x610E}, //17330 #CJK UNIFIED IDEOGRAPH
    {0xE3BA, 0x612B}, //17331 #CJK UNIFIED IDEOGRAPH
    {0xE3BB, 0x614A}, //17332 #CJK UNIFIED IDEOGRAPH
    {0xE3BC, 0x6175}, //17333 #CJK UNIFIED IDEOGRAPH
    {0xE3BD, 0x61AC}, //17334 #CJK UNIFIED IDEOGRAPH
    {0xE3BE, 0x6194}, //17335 #CJK UNIFIED IDEOGRAPH
    {0xE3BF, 0x61A7}, //17336 #CJK UNIFIED IDEOGRAPH
    {0xE3C0, 0x61B7}, //17337 #CJK UNIFIED IDEOGRAPH
    {0xE3C1, 0x61D4}, //17338 #CJK UNIFIED IDEOGRAPH
    {0xE3C2, 0x61F5}, //17339 #CJK UNIFIED IDEOGRAPH
    {0xE3C3, 0x5FDD}, //17340 #CJK UNIFIED IDEOGRAPH
    {0xE3C4, 0x96B3}, //17341 #CJK UNIFIED IDEOGRAPH
    {0xE3C5, 0x95E9}, //17342 #CJK UNIFIED IDEOGRAPH
    {0xE3C6, 0x95EB}, //17343 #CJK UNIFIED IDEOGRAPH
    {0xE3C7, 0x95F1}, //17344 #CJK UNIFIED IDEOGRAPH
    {0xE3C8, 0x95F3}, //17345 #CJK UNIFIED IDEOGRAPH
    {0xE3C9, 0x95F5}, //17346 #CJK UNIFIED IDEOGRAPH
    {0xE3CA, 0x95F6}, //17347 #CJK UNIFIED IDEOGRAPH
    {0xE3CB, 0x95FC}, //17348 #CJK UNIFIED IDEOGRAPH
    {0xE3CC, 0x95FE}, //17349 #CJK UNIFIED IDEOGRAPH
    {0xE3CD, 0x9603}, //17350 #CJK UNIFIED IDEOGRAPH
    {0xE3CE, 0x9604}, //17351 #CJK UNIFIED IDEOGRAPH
    {0xE3CF, 0x9606}, //17352 #CJK UNIFIED IDEOGRAPH
    {0xE3D0, 0x9608}, //17353 #CJK UNIFIED IDEOGRAPH
    {0xE3D1, 0x960A}, //17354 #CJK UNIFIED IDEOGRAPH
    {0xE3D2, 0x960B}, //17355 #CJK UNIFIED IDEOGRAPH
    {0xE3D3, 0x960C}, //17356 #CJK UNIFIED IDEOGRAPH
    {0xE3D4, 0x960D}, //17357 #CJK UNIFIED IDEOGRAPH
    {0xE3D5, 0x960F}, //17358 #CJK UNIFIED IDEOGRAPH
    {0xE3D6, 0x9612}, //17359 #CJK UNIFIED IDEOGRAPH
    {0xE3D7, 0x9615}, //17360 #CJK UNIFIED IDEOGRAPH
    {0xE3D8, 0x9616}, //17361 #CJK UNIFIED IDEOGRAPH
    {0xE3D9, 0x9617}, //17362 #CJK UNIFIED IDEOGRAPH
    {0xE3DA, 0x9619}, //17363 #CJK UNIFIED IDEOGRAPH
    {0xE3DB, 0x961A}, //17364 #CJK UNIFIED IDEOGRAPH
    {0xE3DC, 0x4E2C}, //17365 #CJK UNIFIED IDEOGRAPH
    {0xE3DD, 0x723F}, //17366 #CJK UNIFIED IDEOGRAPH
    {0xE3DE, 0x6215}, //17367 #CJK UNIFIED IDEOGRAPH
    {0xE3DF, 0x6C35}, //17368 #CJK UNIFIED IDEOGRAPH
    {0xE3E0, 0x6C54}, //17369 #CJK UNIFIED IDEOGRAPH
    {0xE3E1, 0x6C5C}, //17370 #CJK UNIFIED IDEOGRAPH
    {0xE3E2, 0x6C4A}, //17371 #CJK UNIFIED IDEOGRAPH
    {0xE3E3, 0x6CA3}, //17372 #CJK UNIFIED IDEOGRAPH
    {0xE3E4, 0x6C85}, //17373 #CJK UNIFIED IDEOGRAPH
    {0xE3E5, 0x6C90}, //17374 #CJK UNIFIED IDEOGRAPH
    {0xE3E6, 0x6C94}, //17375 #CJK UNIFIED IDEOGRAPH
    {0xE3E7, 0x6C8C}, //17376 #CJK UNIFIED IDEOGRAPH
    {0xE3E8, 0x6C68}, //17377 #CJK UNIFIED IDEOGRAPH
    {0xE3E9, 0x6C69}, //17378 #CJK UNIFIED IDEOGRAPH
    {0xE3EA, 0x6C74}, //17379 #CJK UNIFIED IDEOGRAPH
    {0xE3EB, 0x6C76}, //17380 #CJK UNIFIED IDEOGRAPH
    {0xE3EC, 0x6C86}, //17381 #CJK UNIFIED IDEOGRAPH
    {0xE3ED, 0x6CA9}, //17382 #CJK UNIFIED IDEOGRAPH
    {0xE3EE, 0x6CD0}, //17383 #CJK UNIFIED IDEOGRAPH
    {0xE3EF, 0x6CD4}, //17384 #CJK UNIFIED IDEOGRAPH
    {0xE3F0, 0x6CAD}, //17385 #CJK UNIFIED IDEOGRAPH
    {0xE3F1, 0x6CF7}, //17386 #CJK UNIFIED IDEOGRAPH
    {0xE3F2, 0x6CF8}, //17387 #CJK UNIFIED IDEOGRAPH
    {0xE3F3, 0x6CF1}, //17388 #CJK UNIFIED IDEOGRAPH
    {0xE3F4, 0x6CD7}, //17389 #CJK UNIFIED IDEOGRAPH
    {0xE3F5, 0x6CB2}, //17390 #CJK UNIFIED IDEOGRAPH
    {0xE3F6, 0x6CE0}, //17391 #CJK UNIFIED IDEOGRAPH
    {0xE3F7, 0x6CD6}, //17392 #CJK UNIFIED IDEOGRAPH
    {0xE3F8, 0x6CFA}, //17393 #CJK UNIFIED IDEOGRAPH
    {0xE3F9, 0x6CEB}, //17394 #CJK UNIFIED IDEOGRAPH
    {0xE3FA, 0x6CEE}, //17395 #CJK UNIFIED IDEOGRAPH
    {0xE3FB, 0x6CB1}, //17396 #CJK UNIFIED IDEOGRAPH
    {0xE3FC, 0x6CD3}, //17397 #CJK UNIFIED IDEOGRAPH
    {0xE3FD, 0x6CEF}, //17398 #CJK UNIFIED IDEOGRAPH
    {0xE3FE, 0x6CFE}, //17399 #CJK UNIFIED IDEOGRAPH
    {0xE440, 0x92A8}, //17400 #CJK UNIFIED IDEOGRAPH
    {0xE441, 0x92A9}, //17401 #CJK UNIFIED IDEOGRAPH
    {0xE442, 0x92AA}, //17402 #CJK UNIFIED IDEOGRAPH
    {0xE443, 0x92AB}, //17403 #CJK UNIFIED IDEOGRAPH
    {0xE444, 0x92AC}, //17404 #CJK UNIFIED IDEOGRAPH
    {0xE445, 0x92AD}, //17405 #CJK UNIFIED IDEOGRAPH
    {0xE446, 0x92AF}, //17406 #CJK UNIFIED IDEOGRAPH
    {0xE447, 0x92B0}, //17407 #CJK UNIFIED IDEOGRAPH
    {0xE448, 0x92B1}, //17408 #CJK UNIFIED IDEOGRAPH
    {0xE449, 0x92B2}, //17409 #CJK UNIFIED IDEOGRAPH
    {0xE44A, 0x92B3}, //17410 #CJK UNIFIED IDEOGRAPH
    {0xE44B, 0x92B4}, //17411 #CJK UNIFIED IDEOGRAPH
    {0xE44C, 0x92B5}, //17412 #CJK UNIFIED IDEOGRAPH
    {0xE44D, 0x92B6}, //17413 #CJK UNIFIED IDEOGRAPH
    {0xE44E, 0x92B7}, //17414 #CJK UNIFIED IDEOGRAPH
    {0xE44F, 0x92B8}, //17415 #CJK UNIFIED IDEOGRAPH
    {0xE450, 0x92B9}, //17416 #CJK UNIFIED IDEOGRAPH
    {0xE451, 0x92BA}, //17417 #CJK UNIFIED IDEOGRAPH
    {0xE452, 0x92BB}, //17418 #CJK UNIFIED IDEOGRAPH
    {0xE453, 0x92BC}, //17419 #CJK UNIFIED IDEOGRAPH
    {0xE454, 0x92BD}, //17420 #CJK UNIFIED IDEOGRAPH
    {0xE455, 0x92BE}, //17421 #CJK UNIFIED IDEOGRAPH
    {0xE456, 0x92BF}, //17422 #CJK UNIFIED IDEOGRAPH
    {0xE457, 0x92C0}, //17423 #CJK UNIFIED IDEOGRAPH
    {0xE458, 0x92C1}, //17424 #CJK UNIFIED IDEOGRAPH
    {0xE459, 0x92C2}, //17425 #CJK UNIFIED IDEOGRAPH
    {0xE45A, 0x92C3}, //17426 #CJK UNIFIED IDEOGRAPH
    {0xE45B, 0x92C4}, //17427 #CJK UNIFIED IDEOGRAPH
    {0xE45C, 0x92C5}, //17428 #CJK UNIFIED IDEOGRAPH
    {0xE45D, 0x92C6}, //17429 #CJK UNIFIED IDEOGRAPH
    {0xE45E, 0x92C7}, //17430 #CJK UNIFIED IDEOGRAPH
    {0xE45F, 0x92C9}, //17431 #CJK UNIFIED IDEOGRAPH
    {0xE460, 0x92CA}, //17432 #CJK UNIFIED IDEOGRAPH
    {0xE461, 0x92CB}, //17433 #CJK UNIFIED IDEOGRAPH
    {0xE462, 0x92CC}, //17434 #CJK UNIFIED IDEOGRAPH
    {0xE463, 0x92CD}, //17435 #CJK UNIFIED IDEOGRAPH
    {0xE464, 0x92CE}, //17436 #CJK UNIFIED IDEOGRAPH
    {0xE465, 0x92CF}, //17437 #CJK UNIFIED IDEOGRAPH
    {0xE466, 0x92D0}, //17438 #CJK UNIFIED IDEOGRAPH
    {0xE467, 0x92D1}, //17439 #CJK UNIFIED IDEOGRAPH
    {0xE468, 0x92D2}, //17440 #CJK UNIFIED IDEOGRAPH
    {0xE469, 0x92D3}, //17441 #CJK UNIFIED IDEOGRAPH
    {0xE46A, 0x92D4}, //17442 #CJK UNIFIED IDEOGRAPH
    {0xE46B, 0x92D5}, //17443 #CJK UNIFIED IDEOGRAPH
    {0xE46C, 0x92D6}, //17444 #CJK UNIFIED IDEOGRAPH
    {0xE46D, 0x92D7}, //17445 #CJK UNIFIED IDEOGRAPH
    {0xE46E, 0x92D8}, //17446 #CJK UNIFIED IDEOGRAPH
    {0xE46F, 0x92D9}, //17447 #CJK UNIFIED IDEOGRAPH
    {0xE470, 0x92DA}, //17448 #CJK UNIFIED IDEOGRAPH
    {0xE471, 0x92DB}, //17449 #CJK UNIFIED IDEOGRAPH
    {0xE472, 0x92DC}, //17450 #CJK UNIFIED IDEOGRAPH
    {0xE473, 0x92DD}, //17451 #CJK UNIFIED IDEOGRAPH
    {0xE474, 0x92DE}, //17452 #CJK UNIFIED IDEOGRAPH
    {0xE475, 0x92DF}, //17453 #CJK UNIFIED IDEOGRAPH
    {0xE476, 0x92E0}, //17454 #CJK UNIFIED IDEOGRAPH
    {0xE477, 0x92E1}, //17455 #CJK UNIFIED IDEOGRAPH
    {0xE478, 0x92E2}, //17456 #CJK UNIFIED IDEOGRAPH
    {0xE479, 0x92E3}, //17457 #CJK UNIFIED IDEOGRAPH
    {0xE47A, 0x92E4}, //17458 #CJK UNIFIED IDEOGRAPH
    {0xE47B, 0x92E5}, //17459 #CJK UNIFIED IDEOGRAPH
    {0xE47C, 0x92E6}, //17460 #CJK UNIFIED IDEOGRAPH
    {0xE47D, 0x92E7}, //17461 #CJK UNIFIED IDEOGRAPH
    {0xE47E, 0x92E8}, //17462 #CJK UNIFIED IDEOGRAPH
    {0xE480, 0x92E9}, //17463 #CJK UNIFIED IDEOGRAPH
    {0xE481, 0x92EA}, //17464 #CJK UNIFIED IDEOGRAPH
    {0xE482, 0x92EB}, //17465 #CJK UNIFIED IDEOGRAPH
    {0xE483, 0x92EC}, //17466 #CJK UNIFIED IDEOGRAPH
    {0xE484, 0x92ED}, //17467 #CJK UNIFIED IDEOGRAPH
    {0xE485, 0x92EE}, //17468 #CJK UNIFIED IDEOGRAPH
    {0xE486, 0x92EF}, //17469 #CJK UNIFIED IDEOGRAPH
    {0xE487, 0x92F0}, //17470 #CJK UNIFIED IDEOGRAPH
    {0xE488, 0x92F1}, //17471 #CJK UNIFIED IDEOGRAPH
    {0xE489, 0x92F2}, //17472 #CJK UNIFIED IDEOGRAPH
    {0xE48A, 0x92F3}, //17473 #CJK UNIFIED IDEOGRAPH
    {0xE48B, 0x92F4}, //17474 #CJK UNIFIED IDEOGRAPH
    {0xE48C, 0x92F5}, //17475 #CJK UNIFIED IDEOGRAPH
    {0xE48D, 0x92F6}, //17476 #CJK UNIFIED IDEOGRAPH
    {0xE48E, 0x92F7}, //17477 #CJK UNIFIED IDEOGRAPH
    {0xE48F, 0x92F8}, //17478 #CJK UNIFIED IDEOGRAPH
    {0xE490, 0x92F9}, //17479 #CJK UNIFIED IDEOGRAPH
    {0xE491, 0x92FA}, //17480 #CJK UNIFIED IDEOGRAPH
    {0xE492, 0x92FB}, //17481 #CJK UNIFIED IDEOGRAPH
    {0xE493, 0x92FC}, //17482 #CJK UNIFIED IDEOGRAPH
    {0xE494, 0x92FD}, //17483 #CJK UNIFIED IDEOGRAPH
    {0xE495, 0x92FE}, //17484 #CJK UNIFIED IDEOGRAPH
    {0xE496, 0x92FF}, //17485 #CJK UNIFIED IDEOGRAPH
    {0xE497, 0x9300}, //17486 #CJK UNIFIED IDEOGRAPH
    {0xE498, 0x9301}, //17487 #CJK UNIFIED IDEOGRAPH
    {0xE499, 0x9302}, //17488 #CJK UNIFIED IDEOGRAPH
    {0xE49A, 0x9303}, //17489 #CJK UNIFIED IDEOGRAPH
    {0xE49B, 0x9304}, //17490 #CJK UNIFIED IDEOGRAPH
    {0xE49C, 0x9305}, //17491 #CJK UNIFIED IDEOGRAPH
    {0xE49D, 0x9306}, //17492 #CJK UNIFIED IDEOGRAPH
    {0xE49E, 0x9307}, //17493 #CJK UNIFIED IDEOGRAPH
    {0xE49F, 0x9308}, //17494 #CJK UNIFIED IDEOGRAPH
    {0xE4A0, 0x9309}, //17495 #CJK UNIFIED IDEOGRAPH
    {0xE4A1, 0x6D39}, //17496 #CJK UNIFIED IDEOGRAPH
    {0xE4A2, 0x6D27}, //17497 #CJK UNIFIED IDEOGRAPH
    {0xE4A3, 0x6D0C}, //17498 #CJK UNIFIED IDEOGRAPH
    {0xE4A4, 0x6D43}, //17499 #CJK UNIFIED IDEOGRAPH
    {0xE4A5, 0x6D48}, //17500 #CJK UNIFIED IDEOGRAPH
    {0xE4A6, 0x6D07}, //17501 #CJK UNIFIED IDEOGRAPH
    {0xE4A7, 0x6D04}, //17502 #CJK UNIFIED IDEOGRAPH
    {0xE4A8, 0x6D19}, //17503 #CJK UNIFIED IDEOGRAPH
    {0xE4A9, 0x6D0E}, //17504 #CJK UNIFIED IDEOGRAPH
    {0xE4AA, 0x6D2B}, //17505 #CJK UNIFIED IDEOGRAPH
    {0xE4AB, 0x6D4D}, //17506 #CJK UNIFIED IDEOGRAPH
    {0xE4AC, 0x6D2E}, //17507 #CJK UNIFIED IDEOGRAPH
    {0xE4AD, 0x6D35}, //17508 #CJK UNIFIED IDEOGRAPH
    {0xE4AE, 0x6D1A}, //17509 #CJK UNIFIED IDEOGRAPH
    {0xE4AF, 0x6D4F}, //17510 #CJK UNIFIED IDEOGRAPH
    {0xE4B0, 0x6D52}, //17511 #CJK UNIFIED IDEOGRAPH
    {0xE4B1, 0x6D54}, //17512 #CJK UNIFIED IDEOGRAPH
    {0xE4B2, 0x6D33}, //17513 #CJK UNIFIED IDEOGRAPH
    {0xE4B3, 0x6D91}, //17514 #CJK UNIFIED IDEOGRAPH
    {0xE4B4, 0x6D6F}, //17515 #CJK UNIFIED IDEOGRAPH
    {0xE4B5, 0x6D9E}, //17516 #CJK UNIFIED IDEOGRAPH
    {0xE4B6, 0x6DA0}, //17517 #CJK UNIFIED IDEOGRAPH
    {0xE4B7, 0x6D5E}, //17518 #CJK UNIFIED IDEOGRAPH
    {0xE4B8, 0x6D93}, //17519 #CJK UNIFIED IDEOGRAPH
    {0xE4B9, 0x6D94}, //17520 #CJK UNIFIED IDEOGRAPH
    {0xE4BA, 0x6D5C}, //17521 #CJK UNIFIED IDEOGRAPH
    {0xE4BB, 0x6D60}, //17522 #CJK UNIFIED IDEOGRAPH
    {0xE4BC, 0x6D7C}, //17523 #CJK UNIFIED IDEOGRAPH
    {0xE4BD, 0x6D63}, //17524 #CJK UNIFIED IDEOGRAPH
    {0xE4BE, 0x6E1A}, //17525 #CJK UNIFIED IDEOGRAPH
    {0xE4BF, 0x6DC7}, //17526 #CJK UNIFIED IDEOGRAPH
    {0xE4C0, 0x6DC5}, //17527 #CJK UNIFIED IDEOGRAPH
    {0xE4C1, 0x6DDE}, //17528 #CJK UNIFIED IDEOGRAPH
    {0xE4C2, 0x6E0E}, //17529 #CJK UNIFIED IDEOGRAPH
    {0xE4C3, 0x6DBF}, //17530 #CJK UNIFIED IDEOGRAPH
    {0xE4C4, 0x6DE0}, //17531 #CJK UNIFIED IDEOGRAPH
    {0xE4C5, 0x6E11}, //17532 #CJK UNIFIED IDEOGRAPH
    {0xE4C6, 0x6DE6}, //17533 #CJK UNIFIED IDEOGRAPH
    {0xE4C7, 0x6DDD}, //17534 #CJK UNIFIED IDEOGRAPH
    {0xE4C8, 0x6DD9}, //17535 #CJK UNIFIED IDEOGRAPH
    {0xE4C9, 0x6E16}, //17536 #CJK UNIFIED IDEOGRAPH
    {0xE4CA, 0x6DAB}, //17537 #CJK UNIFIED IDEOGRAPH
    {0xE4CB, 0x6E0C}, //17538 #CJK UNIFIED IDEOGRAPH
    {0xE4CC, 0x6DAE}, //17539 #CJK UNIFIED IDEOGRAPH
    {0xE4CD, 0x6E2B}, //17540 #CJK UNIFIED IDEOGRAPH
    {0xE4CE, 0x6E6E}, //17541 #CJK UNIFIED IDEOGRAPH
    {0xE4CF, 0x6E4E}, //17542 #CJK UNIFIED IDEOGRAPH
    {0xE4D0, 0x6E6B}, //17543 #CJK UNIFIED IDEOGRAPH
    {0xE4D1, 0x6EB2}, //17544 #CJK UNIFIED IDEOGRAPH
    {0xE4D2, 0x6E5F}, //17545 #CJK UNIFIED IDEOGRAPH
    {0xE4D3, 0x6E86}, //17546 #CJK UNIFIED IDEOGRAPH
    {0xE4D4, 0x6E53}, //17547 #CJK UNIFIED IDEOGRAPH
    {0xE4D5, 0x6E54}, //17548 #CJK UNIFIED IDEOGRAPH
    {0xE4D6, 0x6E32}, //17549 #CJK UNIFIED IDEOGRAPH
    {0xE4D7, 0x6E25}, //17550 #CJK UNIFIED IDEOGRAPH
    {0xE4D8, 0x6E44}, //17551 #CJK UNIFIED IDEOGRAPH
    {0xE4D9, 0x6EDF}, //17552 #CJK UNIFIED IDEOGRAPH
    {0xE4DA, 0x6EB1}, //17553 #CJK UNIFIED IDEOGRAPH
    {0xE4DB, 0x6E98}, //17554 #CJK UNIFIED IDEOGRAPH
    {0xE4DC, 0x6EE0}, //17555 #CJK UNIFIED IDEOGRAPH
    {0xE4DD, 0x6F2D}, //17556 #CJK UNIFIED IDEOGRAPH
    {0xE4DE, 0x6EE2}, //17557 #CJK UNIFIED IDEOGRAPH
    {0xE4DF, 0x6EA5}, //17558 #CJK UNIFIED IDEOGRAPH
    {0xE4E0, 0x6EA7}, //17559 #CJK UNIFIED IDEOGRAPH
    {0xE4E1, 0x6EBD}, //17560 #CJK UNIFIED IDEOGRAPH
    {0xE4E2, 0x6EBB}, //17561 #CJK UNIFIED IDEOGRAPH
    {0xE4E3, 0x6EB7}, //17562 #CJK UNIFIED IDEOGRAPH
    {0xE4E4, 0x6ED7}, //17563 #CJK UNIFIED IDEOGRAPH
    {0xE4E5, 0x6EB4}, //17564 #CJK UNIFIED IDEOGRAPH
    {0xE4E6, 0x6ECF}, //17565 #CJK UNIFIED IDEOGRAPH
    {0xE4E7, 0x6E8F}, //17566 #CJK UNIFIED IDEOGRAPH
    {0xE4E8, 0x6EC2}, //17567 #CJK UNIFIED IDEOGRAPH
    {0xE4E9, 0x6E9F}, //17568 #CJK UNIFIED IDEOGRAPH
    {0xE4EA, 0x6F62}, //17569 #CJK UNIFIED IDEOGRAPH
    {0xE4EB, 0x6F46}, //17570 #CJK UNIFIED IDEOGRAPH
    {0xE4EC, 0x6F47}, //17571 #CJK UNIFIED IDEOGRAPH
    {0xE4ED, 0x6F24}, //17572 #CJK UNIFIED IDEOGRAPH
    {0xE4EE, 0x6F15}, //17573 #CJK UNIFIED IDEOGRAPH
    {0xE4EF, 0x6EF9}, //17574 #CJK UNIFIED IDEOGRAPH
    {0xE4F0, 0x6F2F}, //17575 #CJK UNIFIED IDEOGRAPH
    {0xE4F1, 0x6F36}, //17576 #CJK UNIFIED IDEOGRAPH
    {0xE4F2, 0x6F4B}, //17577 #CJK UNIFIED IDEOGRAPH
    {0xE4F3, 0x6F74}, //17578 #CJK UNIFIED IDEOGRAPH
    {0xE4F4, 0x6F2A}, //17579 #CJK UNIFIED IDEOGRAPH
    {0xE4F5, 0x6F09}, //17580 #CJK UNIFIED IDEOGRAPH
    {0xE4F6, 0x6F29}, //17581 #CJK UNIFIED IDEOGRAPH
    {0xE4F7, 0x6F89}, //17582 #CJK UNIFIED IDEOGRAPH
    {0xE4F8, 0x6F8D}, //17583 #CJK UNIFIED IDEOGRAPH
    {0xE4F9, 0x6F8C}, //17584 #CJK UNIFIED IDEOGRAPH
    {0xE4FA, 0x6F78}, //17585 #CJK UNIFIED IDEOGRAPH
    {0xE4FB, 0x6F72}, //17586 #CJK UNIFIED IDEOGRAPH
    {0xE4FC, 0x6F7C}, //17587 #CJK UNIFIED IDEOGRAPH
    {0xE4FD, 0x6F7A}, //17588 #CJK UNIFIED IDEOGRAPH
    {0xE4FE, 0x6FD1}, //17589 #CJK UNIFIED IDEOGRAPH
    {0xE540, 0x930A}, //17590 #CJK UNIFIED IDEOGRAPH
    {0xE541, 0x930B}, //17591 #CJK UNIFIED IDEOGRAPH
    {0xE542, 0x930C}, //17592 #CJK UNIFIED IDEOGRAPH
    {0xE543, 0x930D}, //17593 #CJK UNIFIED IDEOGRAPH
    {0xE544, 0x930E}, //17594 #CJK UNIFIED IDEOGRAPH
    {0xE545, 0x930F}, //17595 #CJK UNIFIED IDEOGRAPH
    {0xE546, 0x9310}, //17596 #CJK UNIFIED IDEOGRAPH
    {0xE547, 0x9311}, //17597 #CJK UNIFIED IDEOGRAPH
    {0xE548, 0x9312}, //17598 #CJK UNIFIED IDEOGRAPH
    {0xE549, 0x9313}, //17599 #CJK UNIFIED IDEOGRAPH
    {0xE54A, 0x9314}, //17600 #CJK UNIFIED IDEOGRAPH
    {0xE54B, 0x9315}, //17601 #CJK UNIFIED IDEOGRAPH
    {0xE54C, 0x9316}, //17602 #CJK UNIFIED IDEOGRAPH
    {0xE54D, 0x9317}, //17603 #CJK UNIFIED IDEOGRAPH
    {0xE54E, 0x9318}, //17604 #CJK UNIFIED IDEOGRAPH
    {0xE54F, 0x9319}, //17605 #CJK UNIFIED IDEOGRAPH
    {0xE550, 0x931A}, //17606 #CJK UNIFIED IDEOGRAPH
    {0xE551, 0x931B}, //17607 #CJK UNIFIED IDEOGRAPH
    {0xE552, 0x931C}, //17608 #CJK UNIFIED IDEOGRAPH
    {0xE553, 0x931D}, //17609 #CJK UNIFIED IDEOGRAPH
    {0xE554, 0x931E}, //17610 #CJK UNIFIED IDEOGRAPH
    {0xE555, 0x931F}, //17611 #CJK UNIFIED IDEOGRAPH
    {0xE556, 0x9320}, //17612 #CJK UNIFIED IDEOGRAPH
    {0xE557, 0x9321}, //17613 #CJK UNIFIED IDEOGRAPH
    {0xE558, 0x9322}, //17614 #CJK UNIFIED IDEOGRAPH
    {0xE559, 0x9323}, //17615 #CJK UNIFIED IDEOGRAPH
    {0xE55A, 0x9324}, //17616 #CJK UNIFIED IDEOGRAPH
    {0xE55B, 0x9325}, //17617 #CJK UNIFIED IDEOGRAPH
    {0xE55C, 0x9326}, //17618 #CJK UNIFIED IDEOGRAPH
    {0xE55D, 0x9327}, //17619 #CJK UNIFIED IDEOGRAPH
    {0xE55E, 0x9328}, //17620 #CJK UNIFIED IDEOGRAPH
    {0xE55F, 0x9329}, //17621 #CJK UNIFIED IDEOGRAPH
    {0xE560, 0x932A}, //17622 #CJK UNIFIED IDEOGRAPH
    {0xE561, 0x932B}, //17623 #CJK UNIFIED IDEOGRAPH
    {0xE562, 0x932C}, //17624 #CJK UNIFIED IDEOGRAPH
    {0xE563, 0x932D}, //17625 #CJK UNIFIED IDEOGRAPH
    {0xE564, 0x932E}, //17626 #CJK UNIFIED IDEOGRAPH
    {0xE565, 0x932F}, //17627 #CJK UNIFIED IDEOGRAPH
    {0xE566, 0x9330}, //17628 #CJK UNIFIED IDEOGRAPH
    {0xE567, 0x9331}, //17629 #CJK UNIFIED IDEOGRAPH
    {0xE568, 0x9332}, //17630 #CJK UNIFIED IDEOGRAPH
    {0xE569, 0x9333}, //17631 #CJK UNIFIED IDEOGRAPH
    {0xE56A, 0x9334}, //17632 #CJK UNIFIED IDEOGRAPH
    {0xE56B, 0x9335}, //17633 #CJK UNIFIED IDEOGRAPH
    {0xE56C, 0x9336}, //17634 #CJK UNIFIED IDEOGRAPH
    {0xE56D, 0x9337}, //17635 #CJK UNIFIED IDEOGRAPH
    {0xE56E, 0x9338}, //17636 #CJK UNIFIED IDEOGRAPH
    {0xE56F, 0x9339}, //17637 #CJK UNIFIED IDEOGRAPH
    {0xE570, 0x933A}, //17638 #CJK UNIFIED IDEOGRAPH
    {0xE571, 0x933B}, //17639 #CJK UNIFIED IDEOGRAPH
    {0xE572, 0x933C}, //17640 #CJK UNIFIED IDEOGRAPH
    {0xE573, 0x933D}, //17641 #CJK UNIFIED IDEOGRAPH
    {0xE574, 0x933F}, //17642 #CJK UNIFIED IDEOGRAPH
    {0xE575, 0x9340}, //17643 #CJK UNIFIED IDEOGRAPH
    {0xE576, 0x9341}, //17644 #CJK UNIFIED IDEOGRAPH
    {0xE577, 0x9342}, //17645 #CJK UNIFIED IDEOGRAPH
    {0xE578, 0x9343}, //17646 #CJK UNIFIED IDEOGRAPH
    {0xE579, 0x9344}, //17647 #CJK UNIFIED IDEOGRAPH
    {0xE57A, 0x9345}, //17648 #CJK UNIFIED IDEOGRAPH
    {0xE57B, 0x9346}, //17649 #CJK UNIFIED IDEOGRAPH
    {0xE57C, 0x9347}, //17650 #CJK UNIFIED IDEOGRAPH
    {0xE57D, 0x9348}, //17651 #CJK UNIFIED IDEOGRAPH
    {0xE57E, 0x9349}, //17652 #CJK UNIFIED IDEOGRAPH
    {0xE580, 0x934A}, //17653 #CJK UNIFIED IDEOGRAPH
    {0xE581, 0x934B}, //17654 #CJK UNIFIED IDEOGRAPH
    {0xE582, 0x934C}, //17655 #CJK UNIFIED IDEOGRAPH
    {0xE583, 0x934D}, //17656 #CJK UNIFIED IDEOGRAPH
    {0xE584, 0x934E}, //17657 #CJK UNIFIED IDEOGRAPH
    {0xE585, 0x934F}, //17658 #CJK UNIFIED IDEOGRAPH
    {0xE586, 0x9350}, //17659 #CJK UNIFIED IDEOGRAPH
    {0xE587, 0x9351}, //17660 #CJK UNIFIED IDEOGRAPH
    {0xE588, 0x9352}, //17661 #CJK UNIFIED IDEOGRAPH
    {0xE589, 0x9353}, //17662 #CJK UNIFIED IDEOGRAPH
    {0xE58A, 0x9354}, //17663 #CJK UNIFIED IDEOGRAPH
    {0xE58B, 0x9355}, //17664 #CJK UNIFIED IDEOGRAPH
    {0xE58C, 0x9356}, //17665 #CJK UNIFIED IDEOGRAPH
    {0xE58D, 0x9357}, //17666 #CJK UNIFIED IDEOGRAPH
    {0xE58E, 0x9358}, //17667 #CJK UNIFIED IDEOGRAPH
    {0xE58F, 0x9359}, //17668 #CJK UNIFIED IDEOGRAPH
    {0xE590, 0x935A}, //17669 #CJK UNIFIED IDEOGRAPH
    {0xE591, 0x935B}, //17670 #CJK UNIFIED IDEOGRAPH
    {0xE592, 0x935C}, //17671 #CJK UNIFIED IDEOGRAPH
    {0xE593, 0x935D}, //17672 #CJK UNIFIED IDEOGRAPH
    {0xE594, 0x935E}, //17673 #CJK UNIFIED IDEOGRAPH
    {0xE595, 0x935F}, //17674 #CJK UNIFIED IDEOGRAPH
    {0xE596, 0x9360}, //17675 #CJK UNIFIED IDEOGRAPH
    {0xE597, 0x9361}, //17676 #CJK UNIFIED IDEOGRAPH
    {0xE598, 0x9362}, //17677 #CJK UNIFIED IDEOGRAPH
    {0xE599, 0x9363}, //17678 #CJK UNIFIED IDEOGRAPH
    {0xE59A, 0x9364}, //17679 #CJK UNIFIED IDEOGRAPH
    {0xE59B, 0x9365}, //17680 #CJK UNIFIED IDEOGRAPH
    {0xE59C, 0x9366}, //17681 #CJK UNIFIED IDEOGRAPH
    {0xE59D, 0x9367}, //17682 #CJK UNIFIED IDEOGRAPH
    {0xE59E, 0x9368}, //17683 #CJK UNIFIED IDEOGRAPH
    {0xE59F, 0x9369}, //17684 #CJK UNIFIED IDEOGRAPH
    {0xE5A0, 0x936B}, //17685 #CJK UNIFIED IDEOGRAPH
    {0xE5A1, 0x6FC9}, //17686 #CJK UNIFIED IDEOGRAPH
    {0xE5A2, 0x6FA7}, //17687 #CJK UNIFIED IDEOGRAPH
    {0xE5A3, 0x6FB9}, //17688 #CJK UNIFIED IDEOGRAPH
    {0xE5A4, 0x6FB6}, //17689 #CJK UNIFIED IDEOGRAPH
    {0xE5A5, 0x6FC2}, //17690 #CJK UNIFIED IDEOGRAPH
    {0xE5A6, 0x6FE1}, //17691 #CJK UNIFIED IDEOGRAPH
    {0xE5A7, 0x6FEE}, //17692 #CJK UNIFIED IDEOGRAPH
    {0xE5A8, 0x6FDE}, //17693 #CJK UNIFIED IDEOGRAPH
    {0xE5A9, 0x6FE0}, //17694 #CJK UNIFIED IDEOGRAPH
    {0xE5AA, 0x6FEF}, //17695 #CJK UNIFIED IDEOGRAPH
    {0xE5AB, 0x701A}, //17696 #CJK UNIFIED IDEOGRAPH
    {0xE5AC, 0x7023}, //17697 #CJK UNIFIED IDEOGRAPH
    {0xE5AD, 0x701B}, //17698 #CJK UNIFIED IDEOGRAPH
    {0xE5AE, 0x7039}, //17699 #CJK UNIFIED IDEOGRAPH
    {0xE5AF, 0x7035}, //17700 #CJK UNIFIED IDEOGRAPH
    {0xE5B0, 0x704F}, //17701 #CJK UNIFIED IDEOGRAPH
    {0xE5B1, 0x705E}, //17702 #CJK UNIFIED IDEOGRAPH
    {0xE5B2, 0x5B80}, //17703 #CJK UNIFIED IDEOGRAPH
    {0xE5B3, 0x5B84}, //17704 #CJK UNIFIED IDEOGRAPH
    {0xE5B4, 0x5B95}, //17705 #CJK UNIFIED IDEOGRAPH
    {0xE5B5, 0x5B93}, //17706 #CJK UNIFIED IDEOGRAPH
    {0xE5B6, 0x5BA5}, //17707 #CJK UNIFIED IDEOGRAPH
    {0xE5B7, 0x5BB8}, //17708 #CJK UNIFIED IDEOGRAPH
    {0xE5B8, 0x752F}, //17709 #CJK UNIFIED IDEOGRAPH
    {0xE5B9, 0x9A9E}, //17710 #CJK UNIFIED IDEOGRAPH
    {0xE5BA, 0x6434}, //17711 #CJK UNIFIED IDEOGRAPH
    {0xE5BB, 0x5BE4}, //17712 #CJK UNIFIED IDEOGRAPH
    {0xE5BC, 0x5BEE}, //17713 #CJK UNIFIED IDEOGRAPH
    {0xE5BD, 0x8930}, //17714 #CJK UNIFIED IDEOGRAPH
    {0xE5BE, 0x5BF0}, //17715 #CJK UNIFIED IDEOGRAPH
    {0xE5BF, 0x8E47}, //17716 #CJK UNIFIED IDEOGRAPH
    {0xE5C0, 0x8B07}, //17717 #CJK UNIFIED IDEOGRAPH
    {0xE5C1, 0x8FB6}, //17718 #CJK UNIFIED IDEOGRAPH
    {0xE5C2, 0x8FD3}, //17719 #CJK UNIFIED IDEOGRAPH
    {0xE5C3, 0x8FD5}, //17720 #CJK UNIFIED IDEOGRAPH
    {0xE5C4, 0x8FE5}, //17721 #CJK UNIFIED IDEOGRAPH
    {0xE5C5, 0x8FEE}, //17722 #CJK UNIFIED IDEOGRAPH
    {0xE5C6, 0x8FE4}, //17723 #CJK UNIFIED IDEOGRAPH
    {0xE5C7, 0x8FE9}, //17724 #CJK UNIFIED IDEOGRAPH
    {0xE5C8, 0x8FE6}, //17725 #CJK UNIFIED IDEOGRAPH
    {0xE5C9, 0x8FF3}, //17726 #CJK UNIFIED IDEOGRAPH
    {0xE5CA, 0x8FE8}, //17727 #CJK UNIFIED IDEOGRAPH
    {0xE5CB, 0x9005}, //17728 #CJK UNIFIED IDEOGRAPH
    {0xE5CC, 0x9004}, //17729 #CJK UNIFIED IDEOGRAPH
    {0xE5CD, 0x900B}, //17730 #CJK UNIFIED IDEOGRAPH
    {0xE5CE, 0x9026}, //17731 #CJK UNIFIED IDEOGRAPH
    {0xE5CF, 0x9011}, //17732 #CJK UNIFIED IDEOGRAPH
    {0xE5D0, 0x900D}, //17733 #CJK UNIFIED IDEOGRAPH
    {0xE5D1, 0x9016}, //17734 #CJK UNIFIED IDEOGRAPH
    {0xE5D2, 0x9021}, //17735 #CJK UNIFIED IDEOGRAPH
    {0xE5D3, 0x9035}, //17736 #CJK UNIFIED IDEOGRAPH
    {0xE5D4, 0x9036}, //17737 #CJK UNIFIED IDEOGRAPH
    {0xE5D5, 0x902D}, //17738 #CJK UNIFIED IDEOGRAPH
    {0xE5D6, 0x902F}, //17739 #CJK UNIFIED IDEOGRAPH
    {0xE5D7, 0x9044}, //17740 #CJK UNIFIED IDEOGRAPH
    {0xE5D8, 0x9051}, //17741 #CJK UNIFIED IDEOGRAPH
    {0xE5D9, 0x9052}, //17742 #CJK UNIFIED IDEOGRAPH
    {0xE5DA, 0x9050}, //17743 #CJK UNIFIED IDEOGRAPH
    {0xE5DB, 0x9068}, //17744 #CJK UNIFIED IDEOGRAPH
    {0xE5DC, 0x9058}, //17745 #CJK UNIFIED IDEOGRAPH
    {0xE5DD, 0x9062}, //17746 #CJK UNIFIED IDEOGRAPH
    {0xE5DE, 0x905B}, //17747 #CJK UNIFIED IDEOGRAPH
    {0xE5DF, 0x66B9}, //17748 #CJK UNIFIED IDEOGRAPH
    {0xE5E0, 0x9074}, //17749 #CJK UNIFIED IDEOGRAPH
    {0xE5E1, 0x907D}, //17750 #CJK UNIFIED IDEOGRAPH
    {0xE5E2, 0x9082}, //17751 #CJK UNIFIED IDEOGRAPH
    {0xE5E3, 0x9088}, //17752 #CJK UNIFIED IDEOGRAPH
    {0xE5E4, 0x9083}, //17753 #CJK UNIFIED IDEOGRAPH
    {0xE5E5, 0x908B}, //17754 #CJK UNIFIED IDEOGRAPH
    {0xE5E6, 0x5F50}, //17755 #CJK UNIFIED IDEOGRAPH
    {0xE5E7, 0x5F57}, //17756 #CJK UNIFIED IDEOGRAPH
    {0xE5E8, 0x5F56}, //17757 #CJK UNIFIED IDEOGRAPH
    {0xE5E9, 0x5F58}, //17758 #CJK UNIFIED IDEOGRAPH
    {0xE5EA, 0x5C3B}, //17759 #CJK UNIFIED IDEOGRAPH
    {0xE5EB, 0x54AB}, //17760 #CJK UNIFIED IDEOGRAPH
    {0xE5EC, 0x5C50}, //17761 #CJK UNIFIED IDEOGRAPH
    {0xE5ED, 0x5C59}, //17762 #CJK UNIFIED IDEOGRAPH
    {0xE5EE, 0x5B71}, //17763 #CJK UNIFIED IDEOGRAPH
    {0xE5EF, 0x5C63}, //17764 #CJK UNIFIED IDEOGRAPH
    {0xE5F0, 0x5C66}, //17765 #CJK UNIFIED IDEOGRAPH
    {0xE5F1, 0x7FBC}, //17766 #CJK UNIFIED IDEOGRAPH
    {0xE5F2, 0x5F2A}, //17767 #CJK UNIFIED IDEOGRAPH
    {0xE5F3, 0x5F29}, //17768 #CJK UNIFIED IDEOGRAPH
    {0xE5F4, 0x5F2D}, //17769 #CJK UNIFIED IDEOGRAPH
    {0xE5F5, 0x8274}, //17770 #CJK UNIFIED IDEOGRAPH
    {0xE5F6, 0x5F3C}, //17771 #CJK UNIFIED IDEOGRAPH
    {0xE5F7, 0x9B3B}, //17772 #CJK UNIFIED IDEOGRAPH
    {0xE5F8, 0x5C6E}, //17773 #CJK UNIFIED IDEOGRAPH
    {0xE5F9, 0x5981}, //17774 #CJK UNIFIED IDEOGRAPH
    {0xE5FA, 0x5983}, //17775 #CJK UNIFIED IDEOGRAPH
    {0xE5FB, 0x598D}, //17776 #CJK UNIFIED IDEOGRAPH
    {0xE5FC, 0x59A9}, //17777 #CJK UNIFIED IDEOGRAPH
    {0xE5FD, 0x59AA}, //17778 #CJK UNIFIED IDEOGRAPH
    {0xE5FE, 0x59A3}, //17779 #CJK UNIFIED IDEOGRAPH
    {0xE640, 0x936C}, //17780 #CJK UNIFIED IDEOGRAPH
    {0xE641, 0x936D}, //17781 #CJK UNIFIED IDEOGRAPH
    {0xE642, 0x936E}, //17782 #CJK UNIFIED IDEOGRAPH
    {0xE643, 0x936F}, //17783 #CJK UNIFIED IDEOGRAPH
    {0xE644, 0x9370}, //17784 #CJK UNIFIED IDEOGRAPH
    {0xE645, 0x9371}, //17785 #CJK UNIFIED IDEOGRAPH
    {0xE646, 0x9372}, //17786 #CJK UNIFIED IDEOGRAPH
    {0xE647, 0x9373}, //17787 #CJK UNIFIED IDEOGRAPH
    {0xE648, 0x9374}, //17788 #CJK UNIFIED IDEOGRAPH
    {0xE649, 0x9375}, //17789 #CJK UNIFIED IDEOGRAPH
    {0xE64A, 0x9376}, //17790 #CJK UNIFIED IDEOGRAPH
    {0xE64B, 0x9377}, //17791 #CJK UNIFIED IDEOGRAPH
    {0xE64C, 0x9378}, //17792 #CJK UNIFIED IDEOGRAPH
    {0xE64D, 0x9379}, //17793 #CJK UNIFIED IDEOGRAPH
    {0xE64E, 0x937A}, //17794 #CJK UNIFIED IDEOGRAPH
    {0xE64F, 0x937B}, //17795 #CJK UNIFIED IDEOGRAPH
    {0xE650, 0x937C}, //17796 #CJK UNIFIED IDEOGRAPH
    {0xE651, 0x937D}, //17797 #CJK UNIFIED IDEOGRAPH
    {0xE652, 0x937E}, //17798 #CJK UNIFIED IDEOGRAPH
    {0xE653, 0x937F}, //17799 #CJK UNIFIED IDEOGRAPH
    {0xE654, 0x9380}, //17800 #CJK UNIFIED IDEOGRAPH
    {0xE655, 0x9381}, //17801 #CJK UNIFIED IDEOGRAPH
    {0xE656, 0x9382}, //17802 #CJK UNIFIED IDEOGRAPH
    {0xE657, 0x9383}, //17803 #CJK UNIFIED IDEOGRAPH
    {0xE658, 0x9384}, //17804 #CJK UNIFIED IDEOGRAPH
    {0xE659, 0x9385}, //17805 #CJK UNIFIED IDEOGRAPH
    {0xE65A, 0x9386}, //17806 #CJK UNIFIED IDEOGRAPH
    {0xE65B, 0x9387}, //17807 #CJK UNIFIED IDEOGRAPH
    {0xE65C, 0x9388}, //17808 #CJK UNIFIED IDEOGRAPH
    {0xE65D, 0x9389}, //17809 #CJK UNIFIED IDEOGRAPH
    {0xE65E, 0x938A}, //17810 #CJK UNIFIED IDEOGRAPH
    {0xE65F, 0x938B}, //17811 #CJK UNIFIED IDEOGRAPH
    {0xE660, 0x938C}, //17812 #CJK UNIFIED IDEOGRAPH
    {0xE661, 0x938D}, //17813 #CJK UNIFIED IDEOGRAPH
    {0xE662, 0x938E}, //17814 #CJK UNIFIED IDEOGRAPH
    {0xE663, 0x9390}, //17815 #CJK UNIFIED IDEOGRAPH
    {0xE664, 0x9391}, //17816 #CJK UNIFIED IDEOGRAPH
    {0xE665, 0x9392}, //17817 #CJK UNIFIED IDEOGRAPH
    {0xE666, 0x9393}, //17818 #CJK UNIFIED IDEOGRAPH
    {0xE667, 0x9394}, //17819 #CJK UNIFIED IDEOGRAPH
    {0xE668, 0x9395}, //17820 #CJK UNIFIED IDEOGRAPH
    {0xE669, 0x9396}, //17821 #CJK UNIFIED IDEOGRAPH
    {0xE66A, 0x9397}, //17822 #CJK UNIFIED IDEOGRAPH
    {0xE66B, 0x9398}, //17823 #CJK UNIFIED IDEOGRAPH
    {0xE66C, 0x9399}, //17824 #CJK UNIFIED IDEOGRAPH
    {0xE66D, 0x939A}, //17825 #CJK UNIFIED IDEOGRAPH
    {0xE66E, 0x939B}, //17826 #CJK UNIFIED IDEOGRAPH
    {0xE66F, 0x939C}, //17827 #CJK UNIFIED IDEOGRAPH
    {0xE670, 0x939D}, //17828 #CJK UNIFIED IDEOGRAPH
    {0xE671, 0x939E}, //17829 #CJK UNIFIED IDEOGRAPH
    {0xE672, 0x939F}, //17830 #CJK UNIFIED IDEOGRAPH
    {0xE673, 0x93A0}, //17831 #CJK UNIFIED IDEOGRAPH
    {0xE674, 0x93A1}, //17832 #CJK UNIFIED IDEOGRAPH
    {0xE675, 0x93A2}, //17833 #CJK UNIFIED IDEOGRAPH
    {0xE676, 0x93A3}, //17834 #CJK UNIFIED IDEOGRAPH
    {0xE677, 0x93A4}, //17835 #CJK UNIFIED IDEOGRAPH
    {0xE678, 0x93A5}, //17836 #CJK UNIFIED IDEOGRAPH
    {0xE679, 0x93A6}, //17837 #CJK UNIFIED IDEOGRAPH
    {0xE67A, 0x93A7}, //17838 #CJK UNIFIED IDEOGRAPH
    {0xE67B, 0x93A8}, //17839 #CJK UNIFIED IDEOGRAPH
    {0xE67C, 0x93A9}, //17840 #CJK UNIFIED IDEOGRAPH
    {0xE67D, 0x93AA}, //17841 #CJK UNIFIED IDEOGRAPH
    {0xE67E, 0x93AB}, //17842 #CJK UNIFIED IDEOGRAPH
    {0xE680, 0x93AC}, //17843 #CJK UNIFIED IDEOGRAPH
    {0xE681, 0x93AD}, //17844 #CJK UNIFIED IDEOGRAPH
    {0xE682, 0x93AE}, //17845 #CJK UNIFIED IDEOGRAPH
    {0xE683, 0x93AF}, //17846 #CJK UNIFIED IDEOGRAPH
    {0xE684, 0x93B0}, //17847 #CJK UNIFIED IDEOGRAPH
    {0xE685, 0x93B1}, //17848 #CJK UNIFIED IDEOGRAPH
    {0xE686, 0x93B2}, //17849 #CJK UNIFIED IDEOGRAPH
    {0xE687, 0x93B3}, //17850 #CJK UNIFIED IDEOGRAPH
    {0xE688, 0x93B4}, //17851 #CJK UNIFIED IDEOGRAPH
    {0xE689, 0x93B5}, //17852 #CJK UNIFIED IDEOGRAPH
    {0xE68A, 0x93B6}, //17853 #CJK UNIFIED IDEOGRAPH
    {0xE68B, 0x93B7}, //17854 #CJK UNIFIED IDEOGRAPH
    {0xE68C, 0x93B8}, //17855 #CJK UNIFIED IDEOGRAPH
    {0xE68D, 0x93B9}, //17856 #CJK UNIFIED IDEOGRAPH
    {0xE68E, 0x93BA}, //17857 #CJK UNIFIED IDEOGRAPH
    {0xE68F, 0x93BB}, //17858 #CJK UNIFIED IDEOGRAPH
    {0xE690, 0x93BC}, //17859 #CJK UNIFIED IDEOGRAPH
    {0xE691, 0x93BD}, //17860 #CJK UNIFIED IDEOGRAPH
    {0xE692, 0x93BE}, //17861 #CJK UNIFIED IDEOGRAPH
    {0xE693, 0x93BF}, //17862 #CJK UNIFIED IDEOGRAPH
    {0xE694, 0x93C0}, //17863 #CJK UNIFIED IDEOGRAPH
    {0xE695, 0x93C1}, //17864 #CJK UNIFIED IDEOGRAPH
    {0xE696, 0x93C2}, //17865 #CJK UNIFIED IDEOGRAPH
    {0xE697, 0x93C3}, //17866 #CJK UNIFIED IDEOGRAPH
    {0xE698, 0x93C4}, //17867 #CJK UNIFIED IDEOGRAPH
    {0xE699, 0x93C5}, //17868 #CJK UNIFIED IDEOGRAPH
    {0xE69A, 0x93C6}, //17869 #CJK UNIFIED IDEOGRAPH
    {0xE69B, 0x93C7}, //17870 #CJK UNIFIED IDEOGRAPH
    {0xE69C, 0x93C8}, //17871 #CJK UNIFIED IDEOGRAPH
    {0xE69D, 0x93C9}, //17872 #CJK UNIFIED IDEOGRAPH
    {0xE69E, 0x93CB}, //17873 #CJK UNIFIED IDEOGRAPH
    {0xE69F, 0x93CC}, //17874 #CJK UNIFIED IDEOGRAPH
    {0xE6A0, 0x93CD}, //17875 #CJK UNIFIED IDEOGRAPH
    {0xE6A1, 0x5997}, //17876 #CJK UNIFIED IDEOGRAPH
    {0xE6A2, 0x59CA}, //17877 #CJK UNIFIED IDEOGRAPH
    {0xE6A3, 0x59AB}, //17878 #CJK UNIFIED IDEOGRAPH
    {0xE6A4, 0x599E}, //17879 #CJK UNIFIED IDEOGRAPH
    {0xE6A5, 0x59A4}, //17880 #CJK UNIFIED IDEOGRAPH
    {0xE6A6, 0x59D2}, //17881 #CJK UNIFIED IDEOGRAPH
    {0xE6A7, 0x59B2}, //17882 #CJK UNIFIED IDEOGRAPH
    {0xE6A8, 0x59AF}, //17883 #CJK UNIFIED IDEOGRAPH
    {0xE6A9, 0x59D7}, //17884 #CJK UNIFIED IDEOGRAPH
    {0xE6AA, 0x59BE}, //17885 #CJK UNIFIED IDEOGRAPH
    {0xE6AB, 0x5A05}, //17886 #CJK UNIFIED IDEOGRAPH
    {0xE6AC, 0x5A06}, //17887 #CJK UNIFIED IDEOGRAPH
    {0xE6AD, 0x59DD}, //17888 #CJK UNIFIED IDEOGRAPH
    {0xE6AE, 0x5A08}, //17889 #CJK UNIFIED IDEOGRAPH
    {0xE6AF, 0x59E3}, //17890 #CJK UNIFIED IDEOGRAPH
    {0xE6B0, 0x59D8}, //17891 #CJK UNIFIED IDEOGRAPH
    {0xE6B1, 0x59F9}, //17892 #CJK UNIFIED IDEOGRAPH
    {0xE6B2, 0x5A0C}, //17893 #CJK UNIFIED IDEOGRAPH
    {0xE6B3, 0x5A09}, //17894 #CJK UNIFIED IDEOGRAPH
    {0xE6B4, 0x5A32}, //17895 #CJK UNIFIED IDEOGRAPH
    {0xE6B5, 0x5A34}, //17896 #CJK UNIFIED IDEOGRAPH
    {0xE6B6, 0x5A11}, //17897 #CJK UNIFIED IDEOGRAPH
    {0xE6B7, 0x5A23}, //17898 #CJK UNIFIED IDEOGRAPH
    {0xE6B8, 0x5A13}, //17899 #CJK UNIFIED IDEOGRAPH
    {0xE6B9, 0x5A40}, //17900 #CJK UNIFIED IDEOGRAPH
    {0xE6BA, 0x5A67}, //17901 #CJK UNIFIED IDEOGRAPH
    {0xE6BB, 0x5A4A}, //17902 #CJK UNIFIED IDEOGRAPH
    {0xE6BC, 0x5A55}, //17903 #CJK UNIFIED IDEOGRAPH
    {0xE6BD, 0x5A3C}, //17904 #CJK UNIFIED IDEOGRAPH
    {0xE6BE, 0x5A62}, //17905 #CJK UNIFIED IDEOGRAPH
    {0xE6BF, 0x5A75}, //17906 #CJK UNIFIED IDEOGRAPH
    {0xE6C0, 0x80EC}, //17907 #CJK UNIFIED IDEOGRAPH
    {0xE6C1, 0x5AAA}, //17908 #CJK UNIFIED IDEOGRAPH
    {0xE6C2, 0x5A9B}, //17909 #CJK UNIFIED IDEOGRAPH
    {0xE6C3, 0x5A77}, //17910 #CJK UNIFIED IDEOGRAPH
    {0xE6C4, 0x5A7A}, //17911 #CJK UNIFIED IDEOGRAPH
    {0xE6C5, 0x5ABE}, //17912 #CJK UNIFIED IDEOGRAPH
    {0xE6C6, 0x5AEB}, //17913 #CJK UNIFIED IDEOGRAPH
    {0xE6C7, 0x5AB2}, //17914 #CJK UNIFIED IDEOGRAPH
    {0xE6C8, 0x5AD2}, //17915 #CJK UNIFIED IDEOGRAPH
    {0xE6C9, 0x5AD4}, //17916 #CJK UNIFIED IDEOGRAPH
    {0xE6CA, 0x5AB8}, //17917 #CJK UNIFIED IDEOGRAPH
    {0xE6CB, 0x5AE0}, //17918 #CJK UNIFIED IDEOGRAPH
    {0xE6CC, 0x5AE3}, //17919 #CJK UNIFIED IDEOGRAPH
    {0xE6CD, 0x5AF1}, //17920 #CJK UNIFIED IDEOGRAPH
    {0xE6CE, 0x5AD6}, //17921 #CJK UNIFIED IDEOGRAPH
    {0xE6CF, 0x5AE6}, //17922 #CJK UNIFIED IDEOGRAPH
    {0xE6D0, 0x5AD8}, //17923 #CJK UNIFIED IDEOGRAPH
    {0xE6D1, 0x5ADC}, //17924 #CJK UNIFIED IDEOGRAPH
    {0xE6D2, 0x5B09}, //17925 #CJK UNIFIED IDEOGRAPH
    {0xE6D3, 0x5B17}, //17926 #CJK UNIFIED IDEOGRAPH
    {0xE6D4, 0x5B16}, //17927 #CJK UNIFIED IDEOGRAPH
    {0xE6D5, 0x5B32}, //17928 #CJK UNIFIED IDEOGRAPH
    {0xE6D6, 0x5B37}, //17929 #CJK UNIFIED IDEOGRAPH
    {0xE6D7, 0x5B40}, //17930 #CJK UNIFIED IDEOGRAPH
    {0xE6D8, 0x5C15}, //17931 #CJK UNIFIED IDEOGRAPH
    {0xE6D9, 0x5C1C}, //17932 #CJK UNIFIED IDEOGRAPH
    {0xE6DA, 0x5B5A}, //17933 #CJK UNIFIED IDEOGRAPH
    {0xE6DB, 0x5B65}, //17934 #CJK UNIFIED IDEOGRAPH
    {0xE6DC, 0x5B73}, //17935 #CJK UNIFIED IDEOGRAPH
    {0xE6DD, 0x5B51}, //17936 #CJK UNIFIED IDEOGRAPH
    {0xE6DE, 0x5B53}, //17937 #CJK UNIFIED IDEOGRAPH
    {0xE6DF, 0x5B62}, //17938 #CJK UNIFIED IDEOGRAPH
    {0xE6E0, 0x9A75}, //17939 #CJK UNIFIED IDEOGRAPH
    {0xE6E1, 0x9A77}, //17940 #CJK UNIFIED IDEOGRAPH
    {0xE6E2, 0x9A78}, //17941 #CJK UNIFIED IDEOGRAPH
    {0xE6E3, 0x9A7A}, //17942 #CJK UNIFIED IDEOGRAPH
    {0xE6E4, 0x9A7F}, //17943 #CJK UNIFIED IDEOGRAPH
    {0xE6E5, 0x9A7D}, //17944 #CJK UNIFIED IDEOGRAPH
    {0xE6E6, 0x9A80}, //17945 #CJK UNIFIED IDEOGRAPH
    {0xE6E7, 0x9A81}, //17946 #CJK UNIFIED IDEOGRAPH
    {0xE6E8, 0x9A85}, //17947 #CJK UNIFIED IDEOGRAPH
    {0xE6E9, 0x9A88}, //17948 #CJK UNIFIED IDEOGRAPH
    {0xE6EA, 0x9A8A}, //17949 #CJK UNIFIED IDEOGRAPH
    {0xE6EB, 0x9A90}, //17950 #CJK UNIFIED IDEOGRAPH
    {0xE6EC, 0x9A92}, //17951 #CJK UNIFIED IDEOGRAPH
    {0xE6ED, 0x9A93}, //17952 #CJK UNIFIED IDEOGRAPH
    {0xE6EE, 0x9A96}, //17953 #CJK UNIFIED IDEOGRAPH
    {0xE6EF, 0x9A98}, //17954 #CJK UNIFIED IDEOGRAPH
    {0xE6F0, 0x9A9B}, //17955 #CJK UNIFIED IDEOGRAPH
    {0xE6F1, 0x9A9C}, //17956 #CJK UNIFIED IDEOGRAPH
    {0xE6F2, 0x9A9D}, //17957 #CJK UNIFIED IDEOGRAPH
    {0xE6F3, 0x9A9F}, //17958 #CJK UNIFIED IDEOGRAPH
    {0xE6F4, 0x9AA0}, //17959 #CJK UNIFIED IDEOGRAPH
    {0xE6F5, 0x9AA2}, //17960 #CJK UNIFIED IDEOGRAPH
    {0xE6F6, 0x9AA3}, //17961 #CJK UNIFIED IDEOGRAPH
    {0xE6F7, 0x9AA5}, //17962 #CJK UNIFIED IDEOGRAPH
    {0xE6F8, 0x9AA7}, //17963 #CJK UNIFIED IDEOGRAPH
    {0xE6F9, 0x7E9F}, //17964 #CJK UNIFIED IDEOGRAPH
    {0xE6FA, 0x7EA1}, //17965 #CJK UNIFIED IDEOGRAPH
    {0xE6FB, 0x7EA3}, //17966 #CJK UNIFIED IDEOGRAPH
    {0xE6FC, 0x7EA5}, //17967 #CJK UNIFIED IDEOGRAPH
    {0xE6FD, 0x7EA8}, //17968 #CJK UNIFIED IDEOGRAPH
    {0xE6FE, 0x7EA9}, //17969 #CJK UNIFIED IDEOGRAPH
    {0xE740, 0x93CE}, //17970 #CJK UNIFIED IDEOGRAPH
    {0xE741, 0x93CF}, //17971 #CJK UNIFIED IDEOGRAPH
    {0xE742, 0x93D0}, //17972 #CJK UNIFIED IDEOGRAPH
    {0xE743, 0x93D1}, //17973 #CJK UNIFIED IDEOGRAPH
    {0xE744, 0x93D2}, //17974 #CJK UNIFIED IDEOGRAPH
    {0xE745, 0x93D3}, //17975 #CJK UNIFIED IDEOGRAPH
    {0xE746, 0x93D4}, //17976 #CJK UNIFIED IDEOGRAPH
    {0xE747, 0x93D5}, //17977 #CJK UNIFIED IDEOGRAPH
    {0xE748, 0x93D7}, //17978 #CJK UNIFIED IDEOGRAPH
    {0xE749, 0x93D8}, //17979 #CJK UNIFIED IDEOGRAPH
    {0xE74A, 0x93D9}, //17980 #CJK UNIFIED IDEOGRAPH
    {0xE74B, 0x93DA}, //17981 #CJK UNIFIED IDEOGRAPH
    {0xE74C, 0x93DB}, //17982 #CJK UNIFIED IDEOGRAPH
    {0xE74D, 0x93DC}, //17983 #CJK UNIFIED IDEOGRAPH
    {0xE74E, 0x93DD}, //17984 #CJK UNIFIED IDEOGRAPH
    {0xE74F, 0x93DE}, //17985 #CJK UNIFIED IDEOGRAPH
    {0xE750, 0x93DF}, //17986 #CJK UNIFIED IDEOGRAPH
    {0xE751, 0x93E0}, //17987 #CJK UNIFIED IDEOGRAPH
    {0xE752, 0x93E1}, //17988 #CJK UNIFIED IDEOGRAPH
    {0xE753, 0x93E2}, //17989 #CJK UNIFIED IDEOGRAPH
    {0xE754, 0x93E3}, //17990 #CJK UNIFIED IDEOGRAPH
    {0xE755, 0x93E4}, //17991 #CJK UNIFIED IDEOGRAPH
    {0xE756, 0x93E5}, //17992 #CJK UNIFIED IDEOGRAPH
    {0xE757, 0x93E6}, //17993 #CJK UNIFIED IDEOGRAPH
    {0xE758, 0x93E7}, //17994 #CJK UNIFIED IDEOGRAPH
    {0xE759, 0x93E8}, //17995 #CJK UNIFIED IDEOGRAPH
    {0xE75A, 0x93E9}, //17996 #CJK UNIFIED IDEOGRAPH
    {0xE75B, 0x93EA}, //17997 #CJK UNIFIED IDEOGRAPH
    {0xE75C, 0x93EB}, //17998 #CJK UNIFIED IDEOGRAPH
    {0xE75D, 0x93EC}, //17999 #CJK UNIFIED IDEOGRAPH
    {0xE75E, 0x93ED}, //18000 #CJK UNIFIED IDEOGRAPH
    {0xE75F, 0x93EE}, //18001 #CJK UNIFIED IDEOGRAPH
    {0xE760, 0x93EF}, //18002 #CJK UNIFIED IDEOGRAPH
    {0xE761, 0x93F0}, //18003 #CJK UNIFIED IDEOGRAPH
    {0xE762, 0x93F1}, //18004 #CJK UNIFIED IDEOGRAPH
    {0xE763, 0x93F2}, //18005 #CJK UNIFIED IDEOGRAPH
    {0xE764, 0x93F3}, //18006 #CJK UNIFIED IDEOGRAPH
    {0xE765, 0x93F4}, //18007 #CJK UNIFIED IDEOGRAPH
    {0xE766, 0x93F5}, //18008 #CJK UNIFIED IDEOGRAPH
    {0xE767, 0x93F6}, //18009 #CJK UNIFIED IDEOGRAPH
    {0xE768, 0x93F7}, //18010 #CJK UNIFIED IDEOGRAPH
    {0xE769, 0x93F8}, //18011 #CJK UNIFIED IDEOGRAPH
    {0xE76A, 0x93F9}, //18012 #CJK UNIFIED IDEOGRAPH
    {0xE76B, 0x93FA}, //18013 #CJK UNIFIED IDEOGRAPH
    {0xE76C, 0x93FB}, //18014 #CJK UNIFIED IDEOGRAPH
    {0xE76D, 0x93FC}, //18015 #CJK UNIFIED IDEOGRAPH
    {0xE76E, 0x93FD}, //18016 #CJK UNIFIED IDEOGRAPH
    {0xE76F, 0x93FE}, //18017 #CJK UNIFIED IDEOGRAPH
    {0xE770, 0x93FF}, //18018 #CJK UNIFIED IDEOGRAPH
    {0xE771, 0x9400}, //18019 #CJK UNIFIED IDEOGRAPH
    {0xE772, 0x9401}, //18020 #CJK UNIFIED IDEOGRAPH
    {0xE773, 0x9402}, //18021 #CJK UNIFIED IDEOGRAPH
    {0xE774, 0x9403}, //18022 #CJK UNIFIED IDEOGRAPH
    {0xE775, 0x9404}, //18023 #CJK UNIFIED IDEOGRAPH
    {0xE776, 0x9405}, //18024 #CJK UNIFIED IDEOGRAPH
    {0xE777, 0x9406}, //18025 #CJK UNIFIED IDEOGRAPH
    {0xE778, 0x9407}, //18026 #CJK UNIFIED IDEOGRAPH
    {0xE779, 0x9408}, //18027 #CJK UNIFIED IDEOGRAPH
    {0xE77A, 0x9409}, //18028 #CJK UNIFIED IDEOGRAPH
    {0xE77B, 0x940A}, //18029 #CJK UNIFIED IDEOGRAPH
    {0xE77C, 0x940B}, //18030 #CJK UNIFIED IDEOGRAPH
    {0xE77D, 0x940C}, //18031 #CJK UNIFIED IDEOGRAPH
    {0xE77E, 0x940D}, //18032 #CJK UNIFIED IDEOGRAPH
    {0xE780, 0x940E}, //18033 #CJK UNIFIED IDEOGRAPH
    {0xE781, 0x940F}, //18034 #CJK UNIFIED IDEOGRAPH
    {0xE782, 0x9410}, //18035 #CJK UNIFIED IDEOGRAPH
    {0xE783, 0x9411}, //18036 #CJK UNIFIED IDEOGRAPH
    {0xE784, 0x9412}, //18037 #CJK UNIFIED IDEOGRAPH
    {0xE785, 0x9413}, //18038 #CJK UNIFIED IDEOGRAPH
    {0xE786, 0x9414}, //18039 #CJK UNIFIED IDEOGRAPH
    {0xE787, 0x9415}, //18040 #CJK UNIFIED IDEOGRAPH
    {0xE788, 0x9416}, //18041 #CJK UNIFIED IDEOGRAPH
    {0xE789, 0x9417}, //18042 #CJK UNIFIED IDEOGRAPH
    {0xE78A, 0x9418}, //18043 #CJK UNIFIED IDEOGRAPH
    {0xE78B, 0x9419}, //18044 #CJK UNIFIED IDEOGRAPH
    {0xE78C, 0x941A}, //18045 #CJK UNIFIED IDEOGRAPH
    {0xE78D, 0x941B}, //18046 #CJK UNIFIED IDEOGRAPH
    {0xE78E, 0x941C}, //18047 #CJK UNIFIED IDEOGRAPH
    {0xE78F, 0x941D}, //18048 #CJK UNIFIED IDEOGRAPH
    {0xE790, 0x941E}, //18049 #CJK UNIFIED IDEOGRAPH
    {0xE791, 0x941F}, //18050 #CJK UNIFIED IDEOGRAPH
    {0xE792, 0x9420}, //18051 #CJK UNIFIED IDEOGRAPH
    {0xE793, 0x9421}, //18052 #CJK UNIFIED IDEOGRAPH
    {0xE794, 0x9422}, //18053 #CJK UNIFIED IDEOGRAPH
    {0xE795, 0x9423}, //18054 #CJK UNIFIED IDEOGRAPH
    {0xE796, 0x9424}, //18055 #CJK UNIFIED IDEOGRAPH
    {0xE797, 0x9425}, //18056 #CJK UNIFIED IDEOGRAPH
    {0xE798, 0x9426}, //18057 #CJK UNIFIED IDEOGRAPH
    {0xE799, 0x9427}, //18058 #CJK UNIFIED IDEOGRAPH
    {0xE79A, 0x9428}, //18059 #CJK UNIFIED IDEOGRAPH
    {0xE79B, 0x9429}, //18060 #CJK UNIFIED IDEOGRAPH
    {0xE79C, 0x942A}, //18061 #CJK UNIFIED IDEOGRAPH
    {0xE79D, 0x942B}, //18062 #CJK UNIFIED IDEOGRAPH
    {0xE79E, 0x942C}, //18063 #CJK UNIFIED IDEOGRAPH
    {0xE79F, 0x942D}, //18064 #CJK UNIFIED IDEOGRAPH
    {0xE7A0, 0x942E}, //18065 #CJK UNIFIED IDEOGRAPH
    {0xE7A1, 0x7EAD}, //18066 #CJK UNIFIED IDEOGRAPH
    {0xE7A2, 0x7EB0}, //18067 #CJK UNIFIED IDEOGRAPH
    {0xE7A3, 0x7EBE}, //18068 #CJK UNIFIED IDEOGRAPH
    {0xE7A4, 0x7EC0}, //18069 #CJK UNIFIED IDEOGRAPH
    {0xE7A5, 0x7EC1}, //18070 #CJK UNIFIED IDEOGRAPH
    {0xE7A6, 0x7EC2}, //18071 #CJK UNIFIED IDEOGRAPH
    {0xE7A7, 0x7EC9}, //18072 #CJK UNIFIED IDEOGRAPH
    {0xE7A8, 0x7ECB}, //18073 #CJK UNIFIED IDEOGRAPH
    {0xE7A9, 0x7ECC}, //18074 #CJK UNIFIED IDEOGRAPH
    {0xE7AA, 0x7ED0}, //18075 #CJK UNIFIED IDEOGRAPH
    {0xE7AB, 0x7ED4}, //18076 #CJK UNIFIED IDEOGRAPH
    {0xE7AC, 0x7ED7}, //18077 #CJK UNIFIED IDEOGRAPH
    {0xE7AD, 0x7EDB}, //18078 #CJK UNIFIED IDEOGRAPH
    {0xE7AE, 0x7EE0}, //18079 #CJK UNIFIED IDEOGRAPH
    {0xE7AF, 0x7EE1}, //18080 #CJK UNIFIED IDEOGRAPH
    {0xE7B0, 0x7EE8}, //18081 #CJK UNIFIED IDEOGRAPH
    {0xE7B1, 0x7EEB}, //18082 #CJK UNIFIED IDEOGRAPH
    {0xE7B2, 0x7EEE}, //18083 #CJK UNIFIED IDEOGRAPH
    {0xE7B3, 0x7EEF}, //18084 #CJK UNIFIED IDEOGRAPH
    {0xE7B4, 0x7EF1}, //18085 #CJK UNIFIED IDEOGRAPH
    {0xE7B5, 0x7EF2}, //18086 #CJK UNIFIED IDEOGRAPH
    {0xE7B6, 0x7F0D}, //18087 #CJK UNIFIED IDEOGRAPH
    {0xE7B7, 0x7EF6}, //18088 #CJK UNIFIED IDEOGRAPH
    {0xE7B8, 0x7EFA}, //18089 #CJK UNIFIED IDEOGRAPH
    {0xE7B9, 0x7EFB}, //18090 #CJK UNIFIED IDEOGRAPH
    {0xE7BA, 0x7EFE}, //18091 #CJK UNIFIED IDEOGRAPH
    {0xE7BB, 0x7F01}, //18092 #CJK UNIFIED IDEOGRAPH
    {0xE7BC, 0x7F02}, //18093 #CJK UNIFIED IDEOGRAPH
    {0xE7BD, 0x7F03}, //18094 #CJK UNIFIED IDEOGRAPH
    {0xE7BE, 0x7F07}, //18095 #CJK UNIFIED IDEOGRAPH
    {0xE7BF, 0x7F08}, //18096 #CJK UNIFIED IDEOGRAPH
    {0xE7C0, 0x7F0B}, //18097 #CJK UNIFIED IDEOGRAPH
    {0xE7C1, 0x7F0C}, //18098 #CJK UNIFIED IDEOGRAPH
    {0xE7C2, 0x7F0F}, //18099 #CJK UNIFIED IDEOGRAPH
    {0xE7C3, 0x7F11}, //18100 #CJK UNIFIED IDEOGRAPH
    {0xE7C4, 0x7F12}, //18101 #CJK UNIFIED IDEOGRAPH
    {0xE7C5, 0x7F17}, //18102 #CJK UNIFIED IDEOGRAPH
    {0xE7C6, 0x7F19}, //18103 #CJK UNIFIED IDEOGRAPH
    {0xE7C7, 0x7F1C}, //18104 #CJK UNIFIED IDEOGRAPH
    {0xE7C8, 0x7F1B}, //18105 #CJK UNIFIED IDEOGRAPH
    {0xE7C9, 0x7F1F}, //18106 #CJK UNIFIED IDEOGRAPH
    {0xE7CA, 0x7F21}, //18107 #CJK UNIFIED IDEOGRAPH
    {0xE7CB, 0x7F22}, //18108 #CJK UNIFIED IDEOGRAPH
    {0xE7CC, 0x7F23}, //18109 #CJK UNIFIED IDEOGRAPH
    {0xE7CD, 0x7F24}, //18110 #CJK UNIFIED IDEOGRAPH
    {0xE7CE, 0x7F25}, //18111 #CJK UNIFIED IDEOGRAPH
    {0xE7CF, 0x7F26}, //18112 #CJK UNIFIED IDEOGRAPH
    {0xE7D0, 0x7F27}, //18113 #CJK UNIFIED IDEOGRAPH
    {0xE7D1, 0x7F2A}, //18114 #CJK UNIFIED IDEOGRAPH
    {0xE7D2, 0x7F2B}, //18115 #CJK UNIFIED IDEOGRAPH
    {0xE7D3, 0x7F2C}, //18116 #CJK UNIFIED IDEOGRAPH
    {0xE7D4, 0x7F2D}, //18117 #CJK UNIFIED IDEOGRAPH
    {0xE7D5, 0x7F2F}, //18118 #CJK UNIFIED IDEOGRAPH
    {0xE7D6, 0x7F30}, //18119 #CJK UNIFIED IDEOGRAPH
    {0xE7D7, 0x7F31}, //18120 #CJK UNIFIED IDEOGRAPH
    {0xE7D8, 0x7F32}, //18121 #CJK UNIFIED IDEOGRAPH
    {0xE7D9, 0x7F33}, //18122 #CJK UNIFIED IDEOGRAPH
    {0xE7DA, 0x7F35}, //18123 #CJK UNIFIED IDEOGRAPH
    {0xE7DB, 0x5E7A}, //18124 #CJK UNIFIED IDEOGRAPH
    {0xE7DC, 0x757F}, //18125 #CJK UNIFIED IDEOGRAPH
    {0xE7DD, 0x5DDB}, //18126 #CJK UNIFIED IDEOGRAPH
    {0xE7DE, 0x753E}, //18127 #CJK UNIFIED IDEOGRAPH
    {0xE7DF, 0x9095}, //18128 #CJK UNIFIED IDEOGRAPH
    {0xE7E0, 0x738E}, //18129 #CJK UNIFIED IDEOGRAPH
    {0xE7E1, 0x7391}, //18130 #CJK UNIFIED IDEOGRAPH
    {0xE7E2, 0x73AE}, //18131 #CJK UNIFIED IDEOGRAPH
    {0xE7E3, 0x73A2}, //18132 #CJK UNIFIED IDEOGRAPH
    {0xE7E4, 0x739F}, //18133 #CJK UNIFIED IDEOGRAPH
    {0xE7E5, 0x73CF}, //18134 #CJK UNIFIED IDEOGRAPH
    {0xE7E6, 0x73C2}, //18135 #CJK UNIFIED IDEOGRAPH
    {0xE7E7, 0x73D1}, //18136 #CJK UNIFIED IDEOGRAPH
    {0xE7E8, 0x73B7}, //18137 #CJK UNIFIED IDEOGRAPH
    {0xE7E9, 0x73B3}, //18138 #CJK UNIFIED IDEOGRAPH
    {0xE7EA, 0x73C0}, //18139 #CJK UNIFIED IDEOGRAPH
    {0xE7EB, 0x73C9}, //18140 #CJK UNIFIED IDEOGRAPH
    {0xE7EC, 0x73C8}, //18141 #CJK UNIFIED IDEOGRAPH
    {0xE7ED, 0x73E5}, //18142 #CJK UNIFIED IDEOGRAPH
    {0xE7EE, 0x73D9}, //18143 #CJK UNIFIED IDEOGRAPH
    {0xE7EF, 0x987C}, //18144 #CJK UNIFIED IDEOGRAPH
    {0xE7F0, 0x740A}, //18145 #CJK UNIFIED IDEOGRAPH
    {0xE7F1, 0x73E9}, //18146 #CJK UNIFIED IDEOGRAPH
    {0xE7F2, 0x73E7}, //18147 #CJK UNIFIED IDEOGRAPH
    {0xE7F3, 0x73DE}, //18148 #CJK UNIFIED IDEOGRAPH
    {0xE7F4, 0x73BA}, //18149 #CJK UNIFIED IDEOGRAPH
    {0xE7F5, 0x73F2}, //18150 #CJK UNIFIED IDEOGRAPH
    {0xE7F6, 0x740F}, //18151 #CJK UNIFIED IDEOGRAPH
    {0xE7F7, 0x742A}, //18152 #CJK UNIFIED IDEOGRAPH
    {0xE7F8, 0x745B}, //18153 #CJK UNIFIED IDEOGRAPH
    {0xE7F9, 0x7426}, //18154 #CJK UNIFIED IDEOGRAPH
    {0xE7FA, 0x7425}, //18155 #CJK UNIFIED IDEOGRAPH
    {0xE7FB, 0x7428}, //18156 #CJK UNIFIED IDEOGRAPH
    {0xE7FC, 0x7430}, //18157 #CJK UNIFIED IDEOGRAPH
    {0xE7FD, 0x742E}, //18158 #CJK UNIFIED IDEOGRAPH
    {0xE7FE, 0x742C}, //18159 #CJK UNIFIED IDEOGRAPH
    {0xE840, 0x942F}, //18160 #CJK UNIFIED IDEOGRAPH
    {0xE841, 0x9430}, //18161 #CJK UNIFIED IDEOGRAPH
    {0xE842, 0x9431}, //18162 #CJK UNIFIED IDEOGRAPH
    {0xE843, 0x9432}, //18163 #CJK UNIFIED IDEOGRAPH
    {0xE844, 0x9433}, //18164 #CJK UNIFIED IDEOGRAPH
    {0xE845, 0x9434}, //18165 #CJK UNIFIED IDEOGRAPH
    {0xE846, 0x9435}, //18166 #CJK UNIFIED IDEOGRAPH
    {0xE847, 0x9436}, //18167 #CJK UNIFIED IDEOGRAPH
    {0xE848, 0x9437}, //18168 #CJK UNIFIED IDEOGRAPH
    {0xE849, 0x9438}, //18169 #CJK UNIFIED IDEOGRAPH
    {0xE84A, 0x9439}, //18170 #CJK UNIFIED IDEOGRAPH
    {0xE84B, 0x943A}, //18171 #CJK UNIFIED IDEOGRAPH
    {0xE84C, 0x943B}, //18172 #CJK UNIFIED IDEOGRAPH
    {0xE84D, 0x943C}, //18173 #CJK UNIFIED IDEOGRAPH
    {0xE84E, 0x943D}, //18174 #CJK UNIFIED IDEOGRAPH
    {0xE84F, 0x943F}, //18175 #CJK UNIFIED IDEOGRAPH
    {0xE850, 0x9440}, //18176 #CJK UNIFIED IDEOGRAPH
    {0xE851, 0x9441}, //18177 #CJK UNIFIED IDEOGRAPH
    {0xE852, 0x9442}, //18178 #CJK UNIFIED IDEOGRAPH
    {0xE853, 0x9443}, //18179 #CJK UNIFIED IDEOGRAPH
    {0xE854, 0x9444}, //18180 #CJK UNIFIED IDEOGRAPH
    {0xE855, 0x9445}, //18181 #CJK UNIFIED IDEOGRAPH
    {0xE856, 0x9446}, //18182 #CJK UNIFIED IDEOGRAPH
    {0xE857, 0x9447}, //18183 #CJK UNIFIED IDEOGRAPH
    {0xE858, 0x9448}, //18184 #CJK UNIFIED IDEOGRAPH
    {0xE859, 0x9449}, //18185 #CJK UNIFIED IDEOGRAPH
    {0xE85A, 0x944A}, //18186 #CJK UNIFIED IDEOGRAPH
    {0xE85B, 0x944B}, //18187 #CJK UNIFIED IDEOGRAPH
    {0xE85C, 0x944C}, //18188 #CJK UNIFIED IDEOGRAPH
    {0xE85D, 0x944D}, //18189 #CJK UNIFIED IDEOGRAPH
    {0xE85E, 0x944E}, //18190 #CJK UNIFIED IDEOGRAPH
    {0xE85F, 0x944F}, //18191 #CJK UNIFIED IDEOGRAPH
    {0xE860, 0x9450}, //18192 #CJK UNIFIED IDEOGRAPH
    {0xE861, 0x9451}, //18193 #CJK UNIFIED IDEOGRAPH
    {0xE862, 0x9452}, //18194 #CJK UNIFIED IDEOGRAPH
    {0xE863, 0x9453}, //18195 #CJK UNIFIED IDEOGRAPH
    {0xE864, 0x9454}, //18196 #CJK UNIFIED IDEOGRAPH
    {0xE865, 0x9455}, //18197 #CJK UNIFIED IDEOGRAPH
    {0xE866, 0x9456}, //18198 #CJK UNIFIED IDEOGRAPH
    {0xE867, 0x9457}, //18199 #CJK UNIFIED IDEOGRAPH
    {0xE868, 0x9458}, //18200 #CJK UNIFIED IDEOGRAPH
    {0xE869, 0x9459}, //18201 #CJK UNIFIED IDEOGRAPH
    {0xE86A, 0x945A}, //18202 #CJK UNIFIED IDEOGRAPH
    {0xE86B, 0x945B}, //18203 #CJK UNIFIED IDEOGRAPH
    {0xE86C, 0x945C}, //18204 #CJK UNIFIED IDEOGRAPH
    {0xE86D, 0x945D}, //18205 #CJK UNIFIED IDEOGRAPH
    {0xE86E, 0x945E}, //18206 #CJK UNIFIED IDEOGRAPH
    {0xE86F, 0x945F}, //18207 #CJK UNIFIED IDEOGRAPH
    {0xE870, 0x9460}, //18208 #CJK UNIFIED IDEOGRAPH
    {0xE871, 0x9461}, //18209 #CJK UNIFIED IDEOGRAPH
    {0xE872, 0x9462}, //18210 #CJK UNIFIED IDEOGRAPH
    {0xE873, 0x9463}, //18211 #CJK UNIFIED IDEOGRAPH
    {0xE874, 0x9464}, //18212 #CJK UNIFIED IDEOGRAPH
    {0xE875, 0x9465}, //18213 #CJK UNIFIED IDEOGRAPH
    {0xE876, 0x9466}, //18214 #CJK UNIFIED IDEOGRAPH
    {0xE877, 0x9467}, //18215 #CJK UNIFIED IDEOGRAPH
    {0xE878, 0x9468}, //18216 #CJK UNIFIED IDEOGRAPH
    {0xE879, 0x9469}, //18217 #CJK UNIFIED IDEOGRAPH
    {0xE87A, 0x946A}, //18218 #CJK UNIFIED IDEOGRAPH
    {0xE87B, 0x946C}, //18219 #CJK UNIFIED IDEOGRAPH
    {0xE87C, 0x946D}, //18220 #CJK UNIFIED IDEOGRAPH
    {0xE87D, 0x946E}, //18221 #CJK UNIFIED IDEOGRAPH
    {0xE87E, 0x946F}, //18222 #CJK UNIFIED IDEOGRAPH
    {0xE880, 0x9470}, //18223 #CJK UNIFIED IDEOGRAPH
    {0xE881, 0x9471}, //18224 #CJK UNIFIED IDEOGRAPH
    {0xE882, 0x9472}, //18225 #CJK UNIFIED IDEOGRAPH
    {0xE883, 0x9473}, //18226 #CJK UNIFIED IDEOGRAPH
    {0xE884, 0x9474}, //18227 #CJK UNIFIED IDEOGRAPH
    {0xE885, 0x9475}, //18228 #CJK UNIFIED IDEOGRAPH
    {0xE886, 0x9476}, //18229 #CJK UNIFIED IDEOGRAPH
    {0xE887, 0x9477}, //18230 #CJK UNIFIED IDEOGRAPH
    {0xE888, 0x9478}, //18231 #CJK UNIFIED IDEOGRAPH
    {0xE889, 0x9479}, //18232 #CJK UNIFIED IDEOGRAPH
    {0xE88A, 0x947A}, //18233 #CJK UNIFIED IDEOGRAPH
    {0xE88B, 0x947B}, //18234 #CJK UNIFIED IDEOGRAPH
    {0xE88C, 0x947C}, //18235 #CJK UNIFIED IDEOGRAPH
    {0xE88D, 0x947D}, //18236 #CJK UNIFIED IDEOGRAPH
    {0xE88E, 0x947E}, //18237 #CJK UNIFIED IDEOGRAPH
    {0xE88F, 0x947F}, //18238 #CJK UNIFIED IDEOGRAPH
    {0xE890, 0x9480}, //18239 #CJK UNIFIED IDEOGRAPH
    {0xE891, 0x9481}, //18240 #CJK UNIFIED IDEOGRAPH
    {0xE892, 0x9482}, //18241 #CJK UNIFIED IDEOGRAPH
    {0xE893, 0x9483}, //18242 #CJK UNIFIED IDEOGRAPH
    {0xE894, 0x9484}, //18243 #CJK UNIFIED IDEOGRAPH
    {0xE895, 0x9491}, //18244 #CJK UNIFIED IDEOGRAPH
    {0xE896, 0x9496}, //18245 #CJK UNIFIED IDEOGRAPH
    {0xE897, 0x9498}, //18246 #CJK UNIFIED IDEOGRAPH
    {0xE898, 0x94C7}, //18247 #CJK UNIFIED IDEOGRAPH
    {0xE899, 0x94CF}, //18248 #CJK UNIFIED IDEOGRAPH
    {0xE89A, 0x94D3}, //18249 #CJK UNIFIED IDEOGRAPH
    {0xE89B, 0x94D4}, //18250 #CJK UNIFIED IDEOGRAPH
    {0xE89C, 0x94DA}, //18251 #CJK UNIFIED IDEOGRAPH
    {0xE89D, 0x94E6}, //18252 #CJK UNIFIED IDEOGRAPH
    {0xE89E, 0x94FB}, //18253 #CJK UNIFIED IDEOGRAPH
    {0xE89F, 0x951C}, //18254 #CJK UNIFIED IDEOGRAPH
    {0xE8A0, 0x9520}, //18255 #CJK UNIFIED IDEOGRAPH
    {0xE8A1, 0x741B}, //18256 #CJK UNIFIED IDEOGRAPH
    {0xE8A2, 0x741A}, //18257 #CJK UNIFIED IDEOGRAPH
    {0xE8A3, 0x7441}, //18258 #CJK UNIFIED IDEOGRAPH
    {0xE8A4, 0x745C}, //18259 #CJK UNIFIED IDEOGRAPH
    {0xE8A5, 0x7457}, //18260 #CJK UNIFIED IDEOGRAPH
    {0xE8A6, 0x7455}, //18261 #CJK UNIFIED IDEOGRAPH
    {0xE8A7, 0x7459}, //18262 #CJK UNIFIED IDEOGRAPH
    {0xE8A8, 0x7477}, //18263 #CJK UNIFIED IDEOGRAPH
    {0xE8A9, 0x746D}, //18264 #CJK UNIFIED IDEOGRAPH
    {0xE8AA, 0x747E}, //18265 #CJK UNIFIED IDEOGRAPH
    {0xE8AB, 0x749C}, //18266 #CJK UNIFIED IDEOGRAPH
    {0xE8AC, 0x748E}, //18267 #CJK UNIFIED IDEOGRAPH
    {0xE8AD, 0x7480}, //18268 #CJK UNIFIED IDEOGRAPH
    {0xE8AE, 0x7481}, //18269 #CJK UNIFIED IDEOGRAPH
    {0xE8AF, 0x7487}, //18270 #CJK UNIFIED IDEOGRAPH
    {0xE8B0, 0x748B}, //18271 #CJK UNIFIED IDEOGRAPH
    {0xE8B1, 0x749E}, //18272 #CJK UNIFIED IDEOGRAPH
    {0xE8B2, 0x74A8}, //18273 #CJK UNIFIED IDEOGRAPH
    {0xE8B3, 0x74A9}, //18274 #CJK UNIFIED IDEOGRAPH
    {0xE8B4, 0x7490}, //18275 #CJK UNIFIED IDEOGRAPH
    {0xE8B5, 0x74A7}, //18276 #CJK UNIFIED IDEOGRAPH
    {0xE8B6, 0x74D2}, //18277 #CJK UNIFIED IDEOGRAPH
    {0xE8B7, 0x74BA}, //18278 #CJK UNIFIED IDEOGRAPH
    {0xE8B8, 0x97EA}, //18279 #CJK UNIFIED IDEOGRAPH
    {0xE8B9, 0x97EB}, //18280 #CJK UNIFIED IDEOGRAPH
    {0xE8BA, 0x97EC}, //18281 #CJK UNIFIED IDEOGRAPH
    {0xE8BB, 0x674C}, //18282 #CJK UNIFIED IDEOGRAPH
    {0xE8BC, 0x6753}, //18283 #CJK UNIFIED IDEOGRAPH
    {0xE8BD, 0x675E}, //18284 #CJK UNIFIED IDEOGRAPH
    {0xE8BE, 0x6748}, //18285 #CJK UNIFIED IDEOGRAPH
    {0xE8BF, 0x6769}, //18286 #CJK UNIFIED IDEOGRAPH
    {0xE8C0, 0x67A5}, //18287 #CJK UNIFIED IDEOGRAPH
    {0xE8C1, 0x6787}, //18288 #CJK UNIFIED IDEOGRAPH
    {0xE8C2, 0x676A}, //18289 #CJK UNIFIED IDEOGRAPH
    {0xE8C3, 0x6773}, //18290 #CJK UNIFIED IDEOGRAPH
    {0xE8C4, 0x6798}, //18291 #CJK UNIFIED IDEOGRAPH
    {0xE8C5, 0x67A7}, //18292 #CJK UNIFIED IDEOGRAPH
    {0xE8C6, 0x6775}, //18293 #CJK UNIFIED IDEOGRAPH
    {0xE8C7, 0x67A8}, //18294 #CJK UNIFIED IDEOGRAPH
    {0xE8C8, 0x679E}, //18295 #CJK UNIFIED IDEOGRAPH
    {0xE8C9, 0x67AD}, //18296 #CJK UNIFIED IDEOGRAPH
    {0xE8CA, 0x678B}, //18297 #CJK UNIFIED IDEOGRAPH
    {0xE8CB, 0x6777}, //18298 #CJK UNIFIED IDEOGRAPH
    {0xE8CC, 0x677C}, //18299 #CJK UNIFIED IDEOGRAPH
    {0xE8CD, 0x67F0}, //18300 #CJK UNIFIED IDEOGRAPH
    {0xE8CE, 0x6809}, //18301 #CJK UNIFIED IDEOGRAPH
    {0xE8CF, 0x67D8}, //18302 #CJK UNIFIED IDEOGRAPH
    {0xE8D0, 0x680A}, //18303 #CJK UNIFIED IDEOGRAPH
    {0xE8D1, 0x67E9}, //18304 #CJK UNIFIED IDEOGRAPH
    {0xE8D2, 0x67B0}, //18305 #CJK UNIFIED IDEOGRAPH
    {0xE8D3, 0x680C}, //18306 #CJK UNIFIED IDEOGRAPH
    {0xE8D4, 0x67D9}, //18307 #CJK UNIFIED IDEOGRAPH
    {0xE8D5, 0x67B5}, //18308 #CJK UNIFIED IDEOGRAPH
    {0xE8D6, 0x67DA}, //18309 #CJK UNIFIED IDEOGRAPH
    {0xE8D7, 0x67B3}, //18310 #CJK UNIFIED IDEOGRAPH
    {0xE8D8, 0x67DD}, //18311 #CJK UNIFIED IDEOGRAPH
    {0xE8D9, 0x6800}, //18312 #CJK UNIFIED IDEOGRAPH
    {0xE8DA, 0x67C3}, //18313 #CJK UNIFIED IDEOGRAPH
    {0xE8DB, 0x67B8}, //18314 #CJK UNIFIED IDEOGRAPH
    {0xE8DC, 0x67E2}, //18315 #CJK UNIFIED IDEOGRAPH
    {0xE8DD, 0x680E}, //18316 #CJK UNIFIED IDEOGRAPH
    {0xE8DE, 0x67C1}, //18317 #CJK UNIFIED IDEOGRAPH
    {0xE8DF, 0x67FD}, //18318 #CJK UNIFIED IDEOGRAPH
    {0xE8E0, 0x6832}, //18319 #CJK UNIFIED IDEOGRAPH
    {0xE8E1, 0x6833}, //18320 #CJK UNIFIED IDEOGRAPH
    {0xE8E2, 0x6860}, //18321 #CJK UNIFIED IDEOGRAPH
    {0xE8E3, 0x6861}, //18322 #CJK UNIFIED IDEOGRAPH
    {0xE8E4, 0x684E}, //18323 #CJK UNIFIED IDEOGRAPH
    {0xE8E5, 0x6862}, //18324 #CJK UNIFIED IDEOGRAPH
    {0xE8E6, 0x6844}, //18325 #CJK UNIFIED IDEOGRAPH
    {0xE8E7, 0x6864}, //18326 #CJK UNIFIED IDEOGRAPH
    {0xE8E8, 0x6883}, //18327 #CJK UNIFIED IDEOGRAPH
    {0xE8E9, 0x681D}, //18328 #CJK UNIFIED IDEOGRAPH
    {0xE8EA, 0x6855}, //18329 #CJK UNIFIED IDEOGRAPH
    {0xE8EB, 0x6866}, //18330 #CJK UNIFIED IDEOGRAPH
    {0xE8EC, 0x6841}, //18331 #CJK UNIFIED IDEOGRAPH
    {0xE8ED, 0x6867}, //18332 #CJK UNIFIED IDEOGRAPH
    {0xE8EE, 0x6840}, //18333 #CJK UNIFIED IDEOGRAPH
    {0xE8EF, 0x683E}, //18334 #CJK UNIFIED IDEOGRAPH
    {0xE8F0, 0x684A}, //18335 #CJK UNIFIED IDEOGRAPH
    {0xE8F1, 0x6849}, //18336 #CJK UNIFIED IDEOGRAPH
    {0xE8F2, 0x6829}, //18337 #CJK UNIFIED IDEOGRAPH
    {0xE8F3, 0x68B5}, //18338 #CJK UNIFIED IDEOGRAPH
    {0xE8F4, 0x688F}, //18339 #CJK UNIFIED IDEOGRAPH
    {0xE8F5, 0x6874}, //18340 #CJK UNIFIED IDEOGRAPH
    {0xE8F6, 0x6877}, //18341 #CJK UNIFIED IDEOGRAPH
    {0xE8F7, 0x6893}, //18342 #CJK UNIFIED IDEOGRAPH
    {0xE8F8, 0x686B}, //18343 #CJK UNIFIED IDEOGRAPH
    {0xE8F9, 0x68C2}, //18344 #CJK UNIFIED IDEOGRAPH
    {0xE8FA, 0x696E}, //18345 #CJK UNIFIED IDEOGRAPH
    {0xE8FB, 0x68FC}, //18346 #CJK UNIFIED IDEOGRAPH
    {0xE8FC, 0x691F}, //18347 #CJK UNIFIED IDEOGRAPH
    {0xE8FD, 0x6920}, //18348 #CJK UNIFIED IDEOGRAPH
    {0xE8FE, 0x68F9}, //18349 #CJK UNIFIED IDEOGRAPH
    {0xE940, 0x9527}, //18350 #CJK UNIFIED IDEOGRAPH
    {0xE941, 0x9533}, //18351 #CJK UNIFIED IDEOGRAPH
    {0xE942, 0x953D}, //18352 #CJK UNIFIED IDEOGRAPH
    {0xE943, 0x9543}, //18353 #CJK UNIFIED IDEOGRAPH
    {0xE944, 0x9548}, //18354 #CJK UNIFIED IDEOGRAPH
    {0xE945, 0x954B}, //18355 #CJK UNIFIED IDEOGRAPH
    {0xE946, 0x9555}, //18356 #CJK UNIFIED IDEOGRAPH
    {0xE947, 0x955A}, //18357 #CJK UNIFIED IDEOGRAPH
    {0xE948, 0x9560}, //18358 #CJK UNIFIED IDEOGRAPH
    {0xE949, 0x956E}, //18359 #CJK UNIFIED IDEOGRAPH
    {0xE94A, 0x9574}, //18360 #CJK UNIFIED IDEOGRAPH
    {0xE94B, 0x9575}, //18361 #CJK UNIFIED IDEOGRAPH
    {0xE94C, 0x9577}, //18362 #CJK UNIFIED IDEOGRAPH
    {0xE94D, 0x9578}, //18363 #CJK UNIFIED IDEOGRAPH
    {0xE94E, 0x9579}, //18364 #CJK UNIFIED IDEOGRAPH
    {0xE94F, 0x957A}, //18365 #CJK UNIFIED IDEOGRAPH
    {0xE950, 0x957B}, //18366 #CJK UNIFIED IDEOGRAPH
    {0xE951, 0x957C}, //18367 #CJK UNIFIED IDEOGRAPH
    {0xE952, 0x957D}, //18368 #CJK UNIFIED IDEOGRAPH
    {0xE953, 0x957E}, //18369 #CJK UNIFIED IDEOGRAPH
    {0xE954, 0x9580}, //18370 #CJK UNIFIED IDEOGRAPH
    {0xE955, 0x9581}, //18371 #CJK UNIFIED IDEOGRAPH
    {0xE956, 0x9582}, //18372 #CJK UNIFIED IDEOGRAPH
    {0xE957, 0x9583}, //18373 #CJK UNIFIED IDEOGRAPH
    {0xE958, 0x9584}, //18374 #CJK UNIFIED IDEOGRAPH
    {0xE959, 0x9585}, //18375 #CJK UNIFIED IDEOGRAPH
    {0xE95A, 0x9586}, //18376 #CJK UNIFIED IDEOGRAPH
    {0xE95B, 0x9587}, //18377 #CJK UNIFIED IDEOGRAPH
    {0xE95C, 0x9588}, //18378 #CJK UNIFIED IDEOGRAPH
    {0xE95D, 0x9589}, //18379 #CJK UNIFIED IDEOGRAPH
    {0xE95E, 0x958A}, //18380 #CJK UNIFIED IDEOGRAPH
    {0xE95F, 0x958B}, //18381 #CJK UNIFIED IDEOGRAPH
    {0xE960, 0x958C}, //18382 #CJK UNIFIED IDEOGRAPH
    {0xE961, 0x958D}, //18383 #CJK UNIFIED IDEOGRAPH
    {0xE962, 0x958E}, //18384 #CJK UNIFIED IDEOGRAPH
    {0xE963, 0x958F}, //18385 #CJK UNIFIED IDEOGRAPH
    {0xE964, 0x9590}, //18386 #CJK UNIFIED IDEOGRAPH
    {0xE965, 0x9591}, //18387 #CJK UNIFIED IDEOGRAPH
    {0xE966, 0x9592}, //18388 #CJK UNIFIED IDEOGRAPH
    {0xE967, 0x9593}, //18389 #CJK UNIFIED IDEOGRAPH
    {0xE968, 0x9594}, //18390 #CJK UNIFIED IDEOGRAPH
    {0xE969, 0x9595}, //18391 #CJK UNIFIED IDEOGRAPH
    {0xE96A, 0x9596}, //18392 #CJK UNIFIED IDEOGRAPH
    {0xE96B, 0x9597}, //18393 #CJK UNIFIED IDEOGRAPH
    {0xE96C, 0x9598}, //18394 #CJK UNIFIED IDEOGRAPH
    {0xE96D, 0x9599}, //18395 #CJK UNIFIED IDEOGRAPH
    {0xE96E, 0x959A}, //18396 #CJK UNIFIED IDEOGRAPH
    {0xE96F, 0x959B}, //18397 #CJK UNIFIED IDEOGRAPH
    {0xE970, 0x959C}, //18398 #CJK UNIFIED IDEOGRAPH
    {0xE971, 0x959D}, //18399 #CJK UNIFIED IDEOGRAPH
    {0xE972, 0x959E}, //18400 #CJK UNIFIED IDEOGRAPH
    {0xE973, 0x959F}, //18401 #CJK UNIFIED IDEOGRAPH
    {0xE974, 0x95A0}, //18402 #CJK UNIFIED IDEOGRAPH
    {0xE975, 0x95A1}, //18403 #CJK UNIFIED IDEOGRAPH
    {0xE976, 0x95A2}, //18404 #CJK UNIFIED IDEOGRAPH
    {0xE977, 0x95A3}, //18405 #CJK UNIFIED IDEOGRAPH
    {0xE978, 0x95A4}, //18406 #CJK UNIFIED IDEOGRAPH
    {0xE979, 0x95A5}, //18407 #CJK UNIFIED IDEOGRAPH
    {0xE97A, 0x95A6}, //18408 #CJK UNIFIED IDEOGRAPH
    {0xE97B, 0x95A7}, //18409 #CJK UNIFIED IDEOGRAPH
    {0xE97C, 0x95A8}, //18410 #CJK UNIFIED IDEOGRAPH
    {0xE97D, 0x95A9}, //18411 #CJK UNIFIED IDEOGRAPH
    {0xE97E, 0x95AA}, //18412 #CJK UNIFIED IDEOGRAPH
    {0xE980, 0x95AB}, //18413 #CJK UNIFIED IDEOGRAPH
    {0xE981, 0x95AC}, //18414 #CJK UNIFIED IDEOGRAPH
    {0xE982, 0x95AD}, //18415 #CJK UNIFIED IDEOGRAPH
    {0xE983, 0x95AE}, //18416 #CJK UNIFIED IDEOGRAPH
    {0xE984, 0x95AF}, //18417 #CJK UNIFIED IDEOGRAPH
    {0xE985, 0x95B0}, //18418 #CJK UNIFIED IDEOGRAPH
    {0xE986, 0x95B1}, //18419 #CJK UNIFIED IDEOGRAPH
    {0xE987, 0x95B2}, //18420 #CJK UNIFIED IDEOGRAPH
    {0xE988, 0x95B3}, //18421 #CJK UNIFIED IDEOGRAPH
    {0xE989, 0x95B4}, //18422 #CJK UNIFIED IDEOGRAPH
    {0xE98A, 0x95B5}, //18423 #CJK UNIFIED IDEOGRAPH
    {0xE98B, 0x95B6}, //18424 #CJK UNIFIED IDEOGRAPH
    {0xE98C, 0x95B7}, //18425 #CJK UNIFIED IDEOGRAPH
    {0xE98D, 0x95B8}, //18426 #CJK UNIFIED IDEOGRAPH
    {0xE98E, 0x95B9}, //18427 #CJK UNIFIED IDEOGRAPH
    {0xE98F, 0x95BA}, //18428 #CJK UNIFIED IDEOGRAPH
    {0xE990, 0x95BB}, //18429 #CJK UNIFIED IDEOGRAPH
    {0xE991, 0x95BC}, //18430 #CJK UNIFIED IDEOGRAPH
    {0xE992, 0x95BD}, //18431 #CJK UNIFIED IDEOGRAPH
    {0xE993, 0x95BE}, //18432 #CJK UNIFIED IDEOGRAPH
    {0xE994, 0x95BF}, //18433 #CJK UNIFIED IDEOGRAPH
    {0xE995, 0x95C0}, //18434 #CJK UNIFIED IDEOGRAPH
    {0xE996, 0x95C1}, //18435 #CJK UNIFIED IDEOGRAPH
    {0xE997, 0x95C2}, //18436 #CJK UNIFIED IDEOGRAPH
    {0xE998, 0x95C3}, //18437 #CJK UNIFIED IDEOGRAPH
    {0xE999, 0x95C4}, //18438 #CJK UNIFIED IDEOGRAPH
    {0xE99A, 0x95C5}, //18439 #CJK UNIFIED IDEOGRAPH
    {0xE99B, 0x95C6}, //18440 #CJK UNIFIED IDEOGRAPH
    {0xE99C, 0x95C7}, //18441 #CJK UNIFIED IDEOGRAPH
    {0xE99D, 0x95C8}, //18442 #CJK UNIFIED IDEOGRAPH
    {0xE99E, 0x95C9}, //18443 #CJK UNIFIED IDEOGRAPH
    {0xE99F, 0x95CA}, //18444 #CJK UNIFIED IDEOGRAPH
    {0xE9A0, 0x95CB}, //18445 #CJK UNIFIED IDEOGRAPH
    {0xE9A1, 0x6924}, //18446 #CJK UNIFIED IDEOGRAPH
    {0xE9A2, 0x68F0}, //18447 #CJK UNIFIED IDEOGRAPH
    {0xE9A3, 0x690B}, //18448 #CJK UNIFIED IDEOGRAPH
    {0xE9A4, 0x6901}, //18449 #CJK UNIFIED IDEOGRAPH
    {0xE9A5, 0x6957}, //18450 #CJK UNIFIED IDEOGRAPH
    {0xE9A6, 0x68E3}, //18451 #CJK UNIFIED IDEOGRAPH
    {0xE9A7, 0x6910}, //18452 #CJK UNIFIED IDEOGRAPH
    {0xE9A8, 0x6971}, //18453 #CJK UNIFIED IDEOGRAPH
    {0xE9A9, 0x6939}, //18454 #CJK UNIFIED IDEOGRAPH
    {0xE9AA, 0x6960}, //18455 #CJK UNIFIED IDEOGRAPH
    {0xE9AB, 0x6942}, //18456 #CJK UNIFIED IDEOGRAPH
    {0xE9AC, 0x695D}, //18457 #CJK UNIFIED IDEOGRAPH
    {0xE9AD, 0x6984}, //18458 #CJK UNIFIED IDEOGRAPH
    {0xE9AE, 0x696B}, //18459 #CJK UNIFIED IDEOGRAPH
    {0xE9AF, 0x6980}, //18460 #CJK UNIFIED IDEOGRAPH
    {0xE9B0, 0x6998}, //18461 #CJK UNIFIED IDEOGRAPH
    {0xE9B1, 0x6978}, //18462 #CJK UNIFIED IDEOGRAPH
    {0xE9B2, 0x6934}, //18463 #CJK UNIFIED IDEOGRAPH
    {0xE9B3, 0x69CC}, //18464 #CJK UNIFIED IDEOGRAPH
    {0xE9B4, 0x6987}, //18465 #CJK UNIFIED IDEOGRAPH
    {0xE9B5, 0x6988}, //18466 #CJK UNIFIED IDEOGRAPH
    {0xE9B6, 0x69CE}, //18467 #CJK UNIFIED IDEOGRAPH
    {0xE9B7, 0x6989}, //18468 #CJK UNIFIED IDEOGRAPH
    {0xE9B8, 0x6966}, //18469 #CJK UNIFIED IDEOGRAPH
    {0xE9B9, 0x6963}, //18470 #CJK UNIFIED IDEOGRAPH
    {0xE9BA, 0x6979}, //18471 #CJK UNIFIED IDEOGRAPH
    {0xE9BB, 0x699B}, //18472 #CJK UNIFIED IDEOGRAPH
    {0xE9BC, 0x69A7}, //18473 #CJK UNIFIED IDEOGRAPH
    {0xE9BD, 0x69BB}, //18474 #CJK UNIFIED IDEOGRAPH
    {0xE9BE, 0x69AB}, //18475 #CJK UNIFIED IDEOGRAPH
    {0xE9BF, 0x69AD}, //18476 #CJK UNIFIED IDEOGRAPH
    {0xE9C0, 0x69D4}, //18477 #CJK UNIFIED IDEOGRAPH
    {0xE9C1, 0x69B1}, //18478 #CJK UNIFIED IDEOGRAPH
    {0xE9C2, 0x69C1}, //18479 #CJK UNIFIED IDEOGRAPH
    {0xE9C3, 0x69CA}, //18480 #CJK UNIFIED IDEOGRAPH
    {0xE9C4, 0x69DF}, //18481 #CJK UNIFIED IDEOGRAPH
    {0xE9C5, 0x6995}, //18482 #CJK UNIFIED IDEOGRAPH
    {0xE9C6, 0x69E0}, //18483 #CJK UNIFIED IDEOGRAPH
    {0xE9C7, 0x698D}, //18484 #CJK UNIFIED IDEOGRAPH
    {0xE9C8, 0x69FF}, //18485 #CJK UNIFIED IDEOGRAPH
    {0xE9C9, 0x6A2F}, //18486 #CJK UNIFIED IDEOGRAPH
    {0xE9CA, 0x69ED}, //18487 #CJK UNIFIED IDEOGRAPH
    {0xE9CB, 0x6A17}, //18488 #CJK UNIFIED IDEOGRAPH
    {0xE9CC, 0x6A18}, //18489 #CJK UNIFIED IDEOGRAPH
    {0xE9CD, 0x6A65}, //18490 #CJK UNIFIED IDEOGRAPH
    {0xE9CE, 0x69F2}, //18491 #CJK UNIFIED IDEOGRAPH
    {0xE9CF, 0x6A44}, //18492 #CJK UNIFIED IDEOGRAPH
    {0xE9D0, 0x6A3E}, //18493 #CJK UNIFIED IDEOGRAPH
    {0xE9D1, 0x6AA0}, //18494 #CJK UNIFIED IDEOGRAPH
    {0xE9D2, 0x6A50}, //18495 #CJK UNIFIED IDEOGRAPH
    {0xE9D3, 0x6A5B}, //18496 #CJK UNIFIED IDEOGRAPH
    {0xE9D4, 0x6A35}, //18497 #CJK UNIFIED IDEOGRAPH
    {0xE9D5, 0x6A8E}, //18498 #CJK UNIFIED IDEOGRAPH
    {0xE9D6, 0x6A79}, //18499 #CJK UNIFIED IDEOGRAPH
    {0xE9D7, 0x6A3D}, //18500 #CJK UNIFIED IDEOGRAPH
    {0xE9D8, 0x6A28}, //18501 #CJK UNIFIED IDEOGRAPH
    {0xE9D9, 0x6A58}, //18502 #CJK UNIFIED IDEOGRAPH
    {0xE9DA, 0x6A7C}, //18503 #CJK UNIFIED IDEOGRAPH
    {0xE9DB, 0x6A91}, //18504 #CJK UNIFIED IDEOGRAPH
    {0xE9DC, 0x6A90}, //18505 #CJK UNIFIED IDEOGRAPH
    {0xE9DD, 0x6AA9}, //18506 #CJK UNIFIED IDEOGRAPH
    {0xE9DE, 0x6A97}, //18507 #CJK UNIFIED IDEOGRAPH
    {0xE9DF, 0x6AAB}, //18508 #CJK UNIFIED IDEOGRAPH
    {0xE9E0, 0x7337}, //18509 #CJK UNIFIED IDEOGRAPH
    {0xE9E1, 0x7352}, //18510 #CJK UNIFIED IDEOGRAPH
    {0xE9E2, 0x6B81}, //18511 #CJK UNIFIED IDEOGRAPH
    {0xE9E3, 0x6B82}, //18512 #CJK UNIFIED IDEOGRAPH
    {0xE9E4, 0x6B87}, //18513 #CJK UNIFIED IDEOGRAPH
    {0xE9E5, 0x6B84}, //18514 #CJK UNIFIED IDEOGRAPH
    {0xE9E6, 0x6B92}, //18515 #CJK UNIFIED IDEOGRAPH
    {0xE9E7, 0x6B93}, //18516 #CJK UNIFIED IDEOGRAPH
    {0xE9E8, 0x6B8D}, //18517 #CJK UNIFIED IDEOGRAPH
    {0xE9E9, 0x6B9A}, //18518 #CJK UNIFIED IDEOGRAPH
    {0xE9EA, 0x6B9B}, //18519 #CJK UNIFIED IDEOGRAPH
    {0xE9EB, 0x6BA1}, //18520 #CJK UNIFIED IDEOGRAPH
    {0xE9EC, 0x6BAA}, //18521 #CJK UNIFIED IDEOGRAPH
    {0xE9ED, 0x8F6B}, //18522 #CJK UNIFIED IDEOGRAPH
    {0xE9EE, 0x8F6D}, //18523 #CJK UNIFIED IDEOGRAPH
    {0xE9EF, 0x8F71}, //18524 #CJK UNIFIED IDEOGRAPH
    {0xE9F0, 0x8F72}, //18525 #CJK UNIFIED IDEOGRAPH
    {0xE9F1, 0x8F73}, //18526 #CJK UNIFIED IDEOGRAPH
    {0xE9F2, 0x8F75}, //18527 #CJK UNIFIED IDEOGRAPH
    {0xE9F3, 0x8F76}, //18528 #CJK UNIFIED IDEOGRAPH
    {0xE9F4, 0x8F78}, //18529 #CJK UNIFIED IDEOGRAPH
    {0xE9F5, 0x8F77}, //18530 #CJK UNIFIED IDEOGRAPH
    {0xE9F6, 0x8F79}, //18531 #CJK UNIFIED IDEOGRAPH
    {0xE9F7, 0x8F7A}, //18532 #CJK UNIFIED IDEOGRAPH
    {0xE9F8, 0x8F7C}, //18533 #CJK UNIFIED IDEOGRAPH
    {0xE9F9, 0x8F7E}, //18534 #CJK UNIFIED IDEOGRAPH
    {0xE9FA, 0x8F81}, //18535 #CJK UNIFIED IDEOGRAPH
    {0xE9FB, 0x8F82}, //18536 #CJK UNIFIED IDEOGRAPH
    {0xE9FC, 0x8F84}, //18537 #CJK UNIFIED IDEOGRAPH
    {0xE9FD, 0x8F87}, //18538 #CJK UNIFIED IDEOGRAPH
    {0xE9FE, 0x8F8B}, //18539 #CJK UNIFIED IDEOGRAPH
    {0xEA40, 0x95CC}, //18540 #CJK UNIFIED IDEOGRAPH
    {0xEA41, 0x95CD}, //18541 #CJK UNIFIED IDEOGRAPH
    {0xEA42, 0x95CE}, //18542 #CJK UNIFIED IDEOGRAPH
    {0xEA43, 0x95CF}, //18543 #CJK UNIFIED IDEOGRAPH
    {0xEA44, 0x95D0}, //18544 #CJK UNIFIED IDEOGRAPH
    {0xEA45, 0x95D1}, //18545 #CJK UNIFIED IDEOGRAPH
    {0xEA46, 0x95D2}, //18546 #CJK UNIFIED IDEOGRAPH
    {0xEA47, 0x95D3}, //18547 #CJK UNIFIED IDEOGRAPH
    {0xEA48, 0x95D4}, //18548 #CJK UNIFIED IDEOGRAPH
    {0xEA49, 0x95D5}, //18549 #CJK UNIFIED IDEOGRAPH
    {0xEA4A, 0x95D6}, //18550 #CJK UNIFIED IDEOGRAPH
    {0xEA4B, 0x95D7}, //18551 #CJK UNIFIED IDEOGRAPH
    {0xEA4C, 0x95D8}, //18552 #CJK UNIFIED IDEOGRAPH
    {0xEA4D, 0x95D9}, //18553 #CJK UNIFIED IDEOGRAPH
    {0xEA4E, 0x95DA}, //18554 #CJK UNIFIED IDEOGRAPH
    {0xEA4F, 0x95DB}, //18555 #CJK UNIFIED IDEOGRAPH
    {0xEA50, 0x95DC}, //18556 #CJK UNIFIED IDEOGRAPH
    {0xEA51, 0x95DD}, //18557 #CJK UNIFIED IDEOGRAPH
    {0xEA52, 0x95DE}, //18558 #CJK UNIFIED IDEOGRAPH
    {0xEA53, 0x95DF}, //18559 #CJK UNIFIED IDEOGRAPH
    {0xEA54, 0x95E0}, //18560 #CJK UNIFIED IDEOGRAPH
    {0xEA55, 0x95E1}, //18561 #CJK UNIFIED IDEOGRAPH
    {0xEA56, 0x95E2}, //18562 #CJK UNIFIED IDEOGRAPH
    {0xEA57, 0x95E3}, //18563 #CJK UNIFIED IDEOGRAPH
    {0xEA58, 0x95E4}, //18564 #CJK UNIFIED IDEOGRAPH
    {0xEA59, 0x95E5}, //18565 #CJK UNIFIED IDEOGRAPH
    {0xEA5A, 0x95E6}, //18566 #CJK UNIFIED IDEOGRAPH
    {0xEA5B, 0x95E7}, //18567 #CJK UNIFIED IDEOGRAPH
    {0xEA5C, 0x95EC}, //18568 #CJK UNIFIED IDEOGRAPH
    {0xEA5D, 0x95FF}, //18569 #CJK UNIFIED IDEOGRAPH
    {0xEA5E, 0x9607}, //18570 #CJK UNIFIED IDEOGRAPH
    {0xEA5F, 0x9613}, //18571 #CJK UNIFIED IDEOGRAPH
    {0xEA60, 0x9618}, //18572 #CJK UNIFIED IDEOGRAPH
    {0xEA61, 0x961B}, //18573 #CJK UNIFIED IDEOGRAPH
    {0xEA62, 0x961E}, //18574 #CJK UNIFIED IDEOGRAPH
    {0xEA63, 0x9620}, //18575 #CJK UNIFIED IDEOGRAPH
    {0xEA64, 0x9623}, //18576 #CJK UNIFIED IDEOGRAPH
    {0xEA65, 0x9624}, //18577 #CJK UNIFIED IDEOGRAPH
    {0xEA66, 0x9625}, //18578 #CJK UNIFIED IDEOGRAPH
    {0xEA67, 0x9626}, //18579 #CJK UNIFIED IDEOGRAPH
    {0xEA68, 0x9627}, //18580 #CJK UNIFIED IDEOGRAPH
    {0xEA69, 0x9628}, //18581 #CJK UNIFIED IDEOGRAPH
    {0xEA6A, 0x9629}, //18582 #CJK UNIFIED IDEOGRAPH
    {0xEA6B, 0x962B}, //18583 #CJK UNIFIED IDEOGRAPH
    {0xEA6C, 0x962C}, //18584 #CJK UNIFIED IDEOGRAPH
    {0xEA6D, 0x962D}, //18585 #CJK UNIFIED IDEOGRAPH
    {0xEA6E, 0x962F}, //18586 #CJK UNIFIED IDEOGRAPH
    {0xEA6F, 0x9630}, //18587 #CJK UNIFIED IDEOGRAPH
    {0xEA70, 0x9637}, //18588 #CJK UNIFIED IDEOGRAPH
    {0xEA71, 0x9638}, //18589 #CJK UNIFIED IDEOGRAPH
    {0xEA72, 0x9639}, //18590 #CJK UNIFIED IDEOGRAPH
    {0xEA73, 0x963A}, //18591 #CJK UNIFIED IDEOGRAPH
    {0xEA74, 0x963E}, //18592 #CJK UNIFIED IDEOGRAPH
    {0xEA75, 0x9641}, //18593 #CJK UNIFIED IDEOGRAPH
    {0xEA76, 0x9643}, //18594 #CJK UNIFIED IDEOGRAPH
    {0xEA77, 0x964A}, //18595 #CJK UNIFIED IDEOGRAPH
    {0xEA78, 0x964E}, //18596 #CJK UNIFIED IDEOGRAPH
    {0xEA79, 0x964F}, //18597 #CJK UNIFIED IDEOGRAPH
    {0xEA7A, 0x9651}, //18598 #CJK UNIFIED IDEOGRAPH
    {0xEA7B, 0x9652}, //18599 #CJK UNIFIED IDEOGRAPH
    {0xEA7C, 0x9653}, //18600 #CJK UNIFIED IDEOGRAPH
    {0xEA7D, 0x9656}, //18601 #CJK UNIFIED IDEOGRAPH
    {0xEA7E, 0x9657}, //18602 #CJK UNIFIED IDEOGRAPH
    {0xEA80, 0x9658}, //18603 #CJK UNIFIED IDEOGRAPH
    {0xEA81, 0x9659}, //18604 #CJK UNIFIED IDEOGRAPH
    {0xEA82, 0x965A}, //18605 #CJK UNIFIED IDEOGRAPH
    {0xEA83, 0x965C}, //18606 #CJK UNIFIED IDEOGRAPH
    {0xEA84, 0x965D}, //18607 #CJK UNIFIED IDEOGRAPH
    {0xEA85, 0x965E}, //18608 #CJK UNIFIED IDEOGRAPH
    {0xEA86, 0x9660}, //18609 #CJK UNIFIED IDEOGRAPH
    {0xEA87, 0x9663}, //18610 #CJK UNIFIED IDEOGRAPH
    {0xEA88, 0x9665}, //18611 #CJK UNIFIED IDEOGRAPH
    {0xEA89, 0x9666}, //18612 #CJK UNIFIED IDEOGRAPH
    {0xEA8A, 0x966B}, //18613 #CJK UNIFIED IDEOGRAPH
    {0xEA8B, 0x966D}, //18614 #CJK UNIFIED IDEOGRAPH
    {0xEA8C, 0x966E}, //18615 #CJK UNIFIED IDEOGRAPH
    {0xEA8D, 0x966F}, //18616 #CJK UNIFIED IDEOGRAPH
    {0xEA8E, 0x9670}, //18617 #CJK UNIFIED IDEOGRAPH
    {0xEA8F, 0x9671}, //18618 #CJK UNIFIED IDEOGRAPH
    {0xEA90, 0x9673}, //18619 #CJK UNIFIED IDEOGRAPH
    {0xEA91, 0x9678}, //18620 #CJK UNIFIED IDEOGRAPH
    {0xEA92, 0x9679}, //18621 #CJK UNIFIED IDEOGRAPH
    {0xEA93, 0x967A}, //18622 #CJK UNIFIED IDEOGRAPH
    {0xEA94, 0x967B}, //18623 #CJK UNIFIED IDEOGRAPH
    {0xEA95, 0x967C}, //18624 #CJK UNIFIED IDEOGRAPH
    {0xEA96, 0x967D}, //18625 #CJK UNIFIED IDEOGRAPH
    {0xEA97, 0x967E}, //18626 #CJK UNIFIED IDEOGRAPH
    {0xEA98, 0x967F}, //18627 #CJK UNIFIED IDEOGRAPH
    {0xEA99, 0x9680}, //18628 #CJK UNIFIED IDEOGRAPH
    {0xEA9A, 0x9681}, //18629 #CJK UNIFIED IDEOGRAPH
    {0xEA9B, 0x9682}, //18630 #CJK UNIFIED IDEOGRAPH
    {0xEA9C, 0x9683}, //18631 #CJK UNIFIED IDEOGRAPH
    {0xEA9D, 0x9684}, //18632 #CJK UNIFIED IDEOGRAPH
    {0xEA9E, 0x9687}, //18633 #CJK UNIFIED IDEOGRAPH
    {0xEA9F, 0x9689}, //18634 #CJK UNIFIED IDEOGRAPH
    {0xEAA0, 0x968A}, //18635 #CJK UNIFIED IDEOGRAPH
    {0xEAA1, 0x8F8D}, //18636 #CJK UNIFIED IDEOGRAPH
    {0xEAA2, 0x8F8E}, //18637 #CJK UNIFIED IDEOGRAPH
    {0xEAA3, 0x8F8F}, //18638 #CJK UNIFIED IDEOGRAPH
    {0xEAA4, 0x8F98}, //18639 #CJK UNIFIED IDEOGRAPH
    {0xEAA5, 0x8F9A}, //18640 #CJK UNIFIED IDEOGRAPH
    {0xEAA6, 0x8ECE}, //18641 #CJK UNIFIED IDEOGRAPH
    {0xEAA7, 0x620B}, //18642 #CJK UNIFIED IDEOGRAPH
    {0xEAA8, 0x6217}, //18643 #CJK UNIFIED IDEOGRAPH
    {0xEAA9, 0x621B}, //18644 #CJK UNIFIED IDEOGRAPH
    {0xEAAA, 0x621F}, //18645 #CJK UNIFIED IDEOGRAPH
    {0xEAAB, 0x6222}, //18646 #CJK UNIFIED IDEOGRAPH
    {0xEAAC, 0x6221}, //18647 #CJK UNIFIED IDEOGRAPH
    {0xEAAD, 0x6225}, //18648 #CJK UNIFIED IDEOGRAPH
    {0xEAAE, 0x6224}, //18649 #CJK UNIFIED IDEOGRAPH
    {0xEAAF, 0x622C}, //18650 #CJK UNIFIED IDEOGRAPH
    {0xEAB0, 0x81E7}, //18651 #CJK UNIFIED IDEOGRAPH
    {0xEAB1, 0x74EF}, //18652 #CJK UNIFIED IDEOGRAPH
    {0xEAB2, 0x74F4}, //18653 #CJK UNIFIED IDEOGRAPH
    {0xEAB3, 0x74FF}, //18654 #CJK UNIFIED IDEOGRAPH
    {0xEAB4, 0x750F}, //18655 #CJK UNIFIED IDEOGRAPH
    {0xEAB5, 0x7511}, //18656 #CJK UNIFIED IDEOGRAPH
    {0xEAB6, 0x7513}, //18657 #CJK UNIFIED IDEOGRAPH
    {0xEAB7, 0x6534}, //18658 #CJK UNIFIED IDEOGRAPH
    {0xEAB8, 0x65EE}, //18659 #CJK UNIFIED IDEOGRAPH
    {0xEAB9, 0x65EF}, //18660 #CJK UNIFIED IDEOGRAPH
    {0xEABA, 0x65F0}, //18661 #CJK UNIFIED IDEOGRAPH
    {0xEABB, 0x660A}, //18662 #CJK UNIFIED IDEOGRAPH
    {0xEABC, 0x6619}, //18663 #CJK UNIFIED IDEOGRAPH
    {0xEABD, 0x6772}, //18664 #CJK UNIFIED IDEOGRAPH
    {0xEABE, 0x6603}, //18665 #CJK UNIFIED IDEOGRAPH
    {0xEABF, 0x6615}, //18666 #CJK UNIFIED IDEOGRAPH
    {0xEAC0, 0x6600}, //18667 #CJK UNIFIED IDEOGRAPH
    {0xEAC1, 0x7085}, //18668 #CJK UNIFIED IDEOGRAPH
    {0xEAC2, 0x66F7}, //18669 #CJK UNIFIED IDEOGRAPH
    {0xEAC3, 0x661D}, //18670 #CJK UNIFIED IDEOGRAPH
    {0xEAC4, 0x6634}, //18671 #CJK UNIFIED IDEOGRAPH
    {0xEAC5, 0x6631}, //18672 #CJK UNIFIED IDEOGRAPH
    {0xEAC6, 0x6636}, //18673 #CJK UNIFIED IDEOGRAPH
    {0xEAC7, 0x6635}, //18674 #CJK UNIFIED IDEOGRAPH
    {0xEAC8, 0x8006}, //18675 #CJK UNIFIED IDEOGRAPH
    {0xEAC9, 0x665F}, //18676 #CJK UNIFIED IDEOGRAPH
    {0xEACA, 0x6654}, //18677 #CJK UNIFIED IDEOGRAPH
    {0xEACB, 0x6641}, //18678 #CJK UNIFIED IDEOGRAPH
    {0xEACC, 0x664F}, //18679 #CJK UNIFIED IDEOGRAPH
    {0xEACD, 0x6656}, //18680 #CJK UNIFIED IDEOGRAPH
    {0xEACE, 0x6661}, //18681 #CJK UNIFIED IDEOGRAPH
    {0xEACF, 0x6657}, //18682 #CJK UNIFIED IDEOGRAPH
    {0xEAD0, 0x6677}, //18683 #CJK UNIFIED IDEOGRAPH
    {0xEAD1, 0x6684}, //18684 #CJK UNIFIED IDEOGRAPH
    {0xEAD2, 0x668C}, //18685 #CJK UNIFIED IDEOGRAPH
    {0xEAD3, 0x66A7}, //18686 #CJK UNIFIED IDEOGRAPH
    {0xEAD4, 0x669D}, //18687 #CJK UNIFIED IDEOGRAPH
    {0xEAD5, 0x66BE}, //18688 #CJK UNIFIED IDEOGRAPH
    {0xEAD6, 0x66DB}, //18689 #CJK UNIFIED IDEOGRAPH
    {0xEAD7, 0x66DC}, //18690 #CJK UNIFIED IDEOGRAPH
    {0xEAD8, 0x66E6}, //18691 #CJK UNIFIED IDEOGRAPH
    {0xEAD9, 0x66E9}, //18692 #CJK UNIFIED IDEOGRAPH
    {0xEADA, 0x8D32}, //18693 #CJK UNIFIED IDEOGRAPH
    {0xEADB, 0x8D33}, //18694 #CJK UNIFIED IDEOGRAPH
    {0xEADC, 0x8D36}, //18695 #CJK UNIFIED IDEOGRAPH
    {0xEADD, 0x8D3B}, //18696 #CJK UNIFIED IDEOGRAPH
    {0xEADE, 0x8D3D}, //18697 #CJK UNIFIED IDEOGRAPH
    {0xEADF, 0x8D40}, //18698 #CJK UNIFIED IDEOGRAPH
    {0xEAE0, 0x8D45}, //18699 #CJK UNIFIED IDEOGRAPH
    {0xEAE1, 0x8D46}, //18700 #CJK UNIFIED IDEOGRAPH
    {0xEAE2, 0x8D48}, //18701 #CJK UNIFIED IDEOGRAPH
    {0xEAE3, 0x8D49}, //18702 #CJK UNIFIED IDEOGRAPH
    {0xEAE4, 0x8D47}, //18703 #CJK UNIFIED IDEOGRAPH
    {0xEAE5, 0x8D4D}, //18704 #CJK UNIFIED IDEOGRAPH
    {0xEAE6, 0x8D55}, //18705 #CJK UNIFIED IDEOGRAPH
    {0xEAE7, 0x8D59}, //18706 #CJK UNIFIED IDEOGRAPH
    {0xEAE8, 0x89C7}, //18707 #CJK UNIFIED IDEOGRAPH
    {0xEAE9, 0x89CA}, //18708 #CJK UNIFIED IDEOGRAPH
    {0xEAEA, 0x89CB}, //18709 #CJK UNIFIED IDEOGRAPH
    {0xEAEB, 0x89CC}, //18710 #CJK UNIFIED IDEOGRAPH
    {0xEAEC, 0x89CE}, //18711 #CJK UNIFIED IDEOGRAPH
    {0xEAED, 0x89CF}, //18712 #CJK UNIFIED IDEOGRAPH
    {0xEAEE, 0x89D0}, //18713 #CJK UNIFIED IDEOGRAPH
    {0xEAEF, 0x89D1}, //18714 #CJK UNIFIED IDEOGRAPH
    {0xEAF0, 0x726E}, //18715 #CJK UNIFIED IDEOGRAPH
    {0xEAF1, 0x729F}, //18716 #CJK UNIFIED IDEOGRAPH
    {0xEAF2, 0x725D}, //18717 #CJK UNIFIED IDEOGRAPH
    {0xEAF3, 0x7266}, //18718 #CJK UNIFIED IDEOGRAPH
    {0xEAF4, 0x726F}, //18719 #CJK UNIFIED IDEOGRAPH
    {0xEAF5, 0x727E}, //18720 #CJK UNIFIED IDEOGRAPH
    {0xEAF6, 0x727F}, //18721 #CJK UNIFIED IDEOGRAPH
    {0xEAF7, 0x7284}, //18722 #CJK UNIFIED IDEOGRAPH
    {0xEAF8, 0x728B}, //18723 #CJK UNIFIED IDEOGRAPH
    {0xEAF9, 0x728D}, //18724 #CJK UNIFIED IDEOGRAPH
    {0xEAFA, 0x728F}, //18725 #CJK UNIFIED IDEOGRAPH
    {0xEAFB, 0x7292}, //18726 #CJK UNIFIED IDEOGRAPH
    {0xEAFC, 0x6308}, //18727 #CJK UNIFIED IDEOGRAPH
    {0xEAFD, 0x6332}, //18728 #CJK UNIFIED IDEOGRAPH
    {0xEAFE, 0x63B0}, //18729 #CJK UNIFIED IDEOGRAPH
    {0xEB40, 0x968C}, //18730 #CJK UNIFIED IDEOGRAPH
    {0xEB41, 0x968E}, //18731 #CJK UNIFIED IDEOGRAPH
    {0xEB42, 0x9691}, //18732 #CJK UNIFIED IDEOGRAPH
    {0xEB43, 0x9692}, //18733 #CJK UNIFIED IDEOGRAPH
    {0xEB44, 0x9693}, //18734 #CJK UNIFIED IDEOGRAPH
    {0xEB45, 0x9695}, //18735 #CJK UNIFIED IDEOGRAPH
    {0xEB46, 0x9696}, //18736 #CJK UNIFIED IDEOGRAPH
    {0xEB47, 0x969A}, //18737 #CJK UNIFIED IDEOGRAPH
    {0xEB48, 0x969B}, //18738 #CJK UNIFIED IDEOGRAPH
    {0xEB49, 0x969D}, //18739 #CJK UNIFIED IDEOGRAPH
    {0xEB4A, 0x969E}, //18740 #CJK UNIFIED IDEOGRAPH
    {0xEB4B, 0x969F}, //18741 #CJK UNIFIED IDEOGRAPH
    {0xEB4C, 0x96A0}, //18742 #CJK UNIFIED IDEOGRAPH
    {0xEB4D, 0x96A1}, //18743 #CJK UNIFIED IDEOGRAPH
    {0xEB4E, 0x96A2}, //18744 #CJK UNIFIED IDEOGRAPH
    {0xEB4F, 0x96A3}, //18745 #CJK UNIFIED IDEOGRAPH
    {0xEB50, 0x96A4}, //18746 #CJK UNIFIED IDEOGRAPH
    {0xEB51, 0x96A5}, //18747 #CJK UNIFIED IDEOGRAPH
    {0xEB52, 0x96A6}, //18748 #CJK UNIFIED IDEOGRAPH
    {0xEB53, 0x96A8}, //18749 #CJK UNIFIED IDEOGRAPH
    {0xEB54, 0x96A9}, //18750 #CJK UNIFIED IDEOGRAPH
    {0xEB55, 0x96AA}, //18751 #CJK UNIFIED IDEOGRAPH
    {0xEB56, 0x96AB}, //18752 #CJK UNIFIED IDEOGRAPH
    {0xEB57, 0x96AC}, //18753 #CJK UNIFIED IDEOGRAPH
    {0xEB58, 0x96AD}, //18754 #CJK UNIFIED IDEOGRAPH
    {0xEB59, 0x96AE}, //18755 #CJK UNIFIED IDEOGRAPH
    {0xEB5A, 0x96AF}, //18756 #CJK UNIFIED IDEOGRAPH
    {0xEB5B, 0x96B1}, //18757 #CJK UNIFIED IDEOGRAPH
    {0xEB5C, 0x96B2}, //18758 #CJK UNIFIED IDEOGRAPH
    {0xEB5D, 0x96B4}, //18759 #CJK UNIFIED IDEOGRAPH
    {0xEB5E, 0x96B5}, //18760 #CJK UNIFIED IDEOGRAPH
    {0xEB5F, 0x96B7}, //18761 #CJK UNIFIED IDEOGRAPH
    {0xEB60, 0x96B8}, //18762 #CJK UNIFIED IDEOGRAPH
    {0xEB61, 0x96BA}, //18763 #CJK UNIFIED IDEOGRAPH
    {0xEB62, 0x96BB}, //18764 #CJK UNIFIED IDEOGRAPH
    {0xEB63, 0x96BF}, //18765 #CJK UNIFIED IDEOGRAPH
    {0xEB64, 0x96C2}, //18766 #CJK UNIFIED IDEOGRAPH
    {0xEB65, 0x96C3}, //18767 #CJK UNIFIED IDEOGRAPH
    {0xEB66, 0x96C8}, //18768 #CJK UNIFIED IDEOGRAPH
    {0xEB67, 0x96CA}, //18769 #CJK UNIFIED IDEOGRAPH
    {0xEB68, 0x96CB}, //18770 #CJK UNIFIED IDEOGRAPH
    {0xEB69, 0x96D0}, //18771 #CJK UNIFIED IDEOGRAPH
    {0xEB6A, 0x96D1}, //18772 #CJK UNIFIED IDEOGRAPH
    {0xEB6B, 0x96D3}, //18773 #CJK UNIFIED IDEOGRAPH
    {0xEB6C, 0x96D4}, //18774 #CJK UNIFIED IDEOGRAPH
    {0xEB6D, 0x96D6}, //18775 #CJK UNIFIED IDEOGRAPH
    {0xEB6E, 0x96D7}, //18776 #CJK UNIFIED IDEOGRAPH
    {0xEB6F, 0x96D8}, //18777 #CJK UNIFIED IDEOGRAPH
    {0xEB70, 0x96D9}, //18778 #CJK UNIFIED IDEOGRAPH
    {0xEB71, 0x96DA}, //18779 #CJK UNIFIED IDEOGRAPH
    {0xEB72, 0x96DB}, //18780 #CJK UNIFIED IDEOGRAPH
    {0xEB73, 0x96DC}, //18781 #CJK UNIFIED IDEOGRAPH
    {0xEB74, 0x96DD}, //18782 #CJK UNIFIED IDEOGRAPH
    {0xEB75, 0x96DE}, //18783 #CJK UNIFIED IDEOGRAPH
    {0xEB76, 0x96DF}, //18784 #CJK UNIFIED IDEOGRAPH
    {0xEB77, 0x96E1}, //18785 #CJK UNIFIED IDEOGRAPH
    {0xEB78, 0x96E2}, //18786 #CJK UNIFIED IDEOGRAPH
    {0xEB79, 0x96E3}, //18787 #CJK UNIFIED IDEOGRAPH
    {0xEB7A, 0x96E4}, //18788 #CJK UNIFIED IDEOGRAPH
    {0xEB7B, 0x96E5}, //18789 #CJK UNIFIED IDEOGRAPH
    {0xEB7C, 0x96E6}, //18790 #CJK UNIFIED IDEOGRAPH
    {0xEB7D, 0x96E7}, //18791 #CJK UNIFIED IDEOGRAPH
    {0xEB7E, 0x96EB}, //18792 #CJK UNIFIED IDEOGRAPH
    {0xEB80, 0x96EC}, //18793 #CJK UNIFIED IDEOGRAPH
    {0xEB81, 0x96ED}, //18794 #CJK UNIFIED IDEOGRAPH
    {0xEB82, 0x96EE}, //18795 #CJK UNIFIED IDEOGRAPH
    {0xEB83, 0x96F0}, //18796 #CJK UNIFIED IDEOGRAPH
    {0xEB84, 0x96F1}, //18797 #CJK UNIFIED IDEOGRAPH
    {0xEB85, 0x96F2}, //18798 #CJK UNIFIED IDEOGRAPH
    {0xEB86, 0x96F4}, //18799 #CJK UNIFIED IDEOGRAPH
    {0xEB87, 0x96F5}, //18800 #CJK UNIFIED IDEOGRAPH
    {0xEB88, 0x96F8}, //18801 #CJK UNIFIED IDEOGRAPH
    {0xEB89, 0x96FA}, //18802 #CJK UNIFIED IDEOGRAPH
    {0xEB8A, 0x96FB}, //18803 #CJK UNIFIED IDEOGRAPH
    {0xEB8B, 0x96FC}, //18804 #CJK UNIFIED IDEOGRAPH
    {0xEB8C, 0x96FD}, //18805 #CJK UNIFIED IDEOGRAPH
    {0xEB8D, 0x96FF}, //18806 #CJK UNIFIED IDEOGRAPH
    {0xEB8E, 0x9702}, //18807 #CJK UNIFIED IDEOGRAPH
    {0xEB8F, 0x9703}, //18808 #CJK UNIFIED IDEOGRAPH
    {0xEB90, 0x9705}, //18809 #CJK UNIFIED IDEOGRAPH
    {0xEB91, 0x970A}, //18810 #CJK UNIFIED IDEOGRAPH
    {0xEB92, 0x970B}, //18811 #CJK UNIFIED IDEOGRAPH
    {0xEB93, 0x970C}, //18812 #CJK UNIFIED IDEOGRAPH
    {0xEB94, 0x9710}, //18813 #CJK UNIFIED IDEOGRAPH
    {0xEB95, 0x9711}, //18814 #CJK UNIFIED IDEOGRAPH
    {0xEB96, 0x9712}, //18815 #CJK UNIFIED IDEOGRAPH
    {0xEB97, 0x9714}, //18816 #CJK UNIFIED IDEOGRAPH
    {0xEB98, 0x9715}, //18817 #CJK UNIFIED IDEOGRAPH
    {0xEB99, 0x9717}, //18818 #CJK UNIFIED IDEOGRAPH
    {0xEB9A, 0x9718}, //18819 #CJK UNIFIED IDEOGRAPH
    {0xEB9B, 0x9719}, //18820 #CJK UNIFIED IDEOGRAPH
    {0xEB9C, 0x971A}, //18821 #CJK UNIFIED IDEOGRAPH
    {0xEB9D, 0x971B}, //18822 #CJK UNIFIED IDEOGRAPH
    {0xEB9E, 0x971D}, //18823 #CJK UNIFIED IDEOGRAPH
    {0xEB9F, 0x971F}, //18824 #CJK UNIFIED IDEOGRAPH
    {0xEBA0, 0x9720}, //18825 #CJK UNIFIED IDEOGRAPH
    {0xEBA1, 0x643F}, //18826 #CJK UNIFIED IDEOGRAPH
    {0xEBA2, 0x64D8}, //18827 #CJK UNIFIED IDEOGRAPH
    {0xEBA3, 0x8004}, //18828 #CJK UNIFIED IDEOGRAPH
    {0xEBA4, 0x6BEA}, //18829 #CJK UNIFIED IDEOGRAPH
    {0xEBA5, 0x6BF3}, //18830 #CJK UNIFIED IDEOGRAPH
    {0xEBA6, 0x6BFD}, //18831 #CJK UNIFIED IDEOGRAPH
    {0xEBA7, 0x6BF5}, //18832 #CJK UNIFIED IDEOGRAPH
    {0xEBA8, 0x6BF9}, //18833 #CJK UNIFIED IDEOGRAPH
    {0xEBA9, 0x6C05}, //18834 #CJK UNIFIED IDEOGRAPH
    {0xEBAA, 0x6C07}, //18835 #CJK UNIFIED IDEOGRAPH
    {0xEBAB, 0x6C06}, //18836 #CJK UNIFIED IDEOGRAPH
    {0xEBAC, 0x6C0D}, //18837 #CJK UNIFIED IDEOGRAPH
    {0xEBAD, 0x6C15}, //18838 #CJK UNIFIED IDEOGRAPH
    {0xEBAE, 0x6C18}, //18839 #CJK UNIFIED IDEOGRAPH
    {0xEBAF, 0x6C19}, //18840 #CJK UNIFIED IDEOGRAPH
    {0xEBB0, 0x6C1A}, //18841 #CJK UNIFIED IDEOGRAPH
    {0xEBB1, 0x6C21}, //18842 #CJK UNIFIED IDEOGRAPH
    {0xEBB2, 0x6C29}, //18843 #CJK UNIFIED IDEOGRAPH
    {0xEBB3, 0x6C24}, //18844 #CJK UNIFIED IDEOGRAPH
    {0xEBB4, 0x6C2A}, //18845 #CJK UNIFIED IDEOGRAPH
    {0xEBB5, 0x6C32}, //18846 #CJK UNIFIED IDEOGRAPH
    {0xEBB6, 0x6535}, //18847 #CJK UNIFIED IDEOGRAPH
    {0xEBB7, 0x6555}, //18848 #CJK UNIFIED IDEOGRAPH
    {0xEBB8, 0x656B}, //18849 #CJK UNIFIED IDEOGRAPH
    {0xEBB9, 0x724D}, //18850 #CJK UNIFIED IDEOGRAPH
    {0xEBBA, 0x7252}, //18851 #CJK UNIFIED IDEOGRAPH
    {0xEBBB, 0x7256}, //18852 #CJK UNIFIED IDEOGRAPH
    {0xEBBC, 0x7230}, //18853 #CJK UNIFIED IDEOGRAPH
    {0xEBBD, 0x8662}, //18854 #CJK UNIFIED IDEOGRAPH
    {0xEBBE, 0x5216}, //18855 #CJK UNIFIED IDEOGRAPH
    {0xEBBF, 0x809F}, //18856 #CJK UNIFIED IDEOGRAPH
    {0xEBC0, 0x809C}, //18857 #CJK UNIFIED IDEOGRAPH
    {0xEBC1, 0x8093}, //18858 #CJK UNIFIED IDEOGRAPH
    {0xEBC2, 0x80BC}, //18859 #CJK UNIFIED IDEOGRAPH
    {0xEBC3, 0x670A}, //18860 #CJK UNIFIED IDEOGRAPH
    {0xEBC4, 0x80BD}, //18861 #CJK UNIFIED IDEOGRAPH
    {0xEBC5, 0x80B1}, //18862 #CJK UNIFIED IDEOGRAPH
    {0xEBC6, 0x80AB}, //18863 #CJK UNIFIED IDEOGRAPH
    {0xEBC7, 0x80AD}, //18864 #CJK UNIFIED IDEOGRAPH
    {0xEBC8, 0x80B4}, //18865 #CJK UNIFIED IDEOGRAPH
    {0xEBC9, 0x80B7}, //18866 #CJK UNIFIED IDEOGRAPH
    {0xEBCA, 0x80E7}, //18867 #CJK UNIFIED IDEOGRAPH
    {0xEBCB, 0x80E8}, //18868 #CJK UNIFIED IDEOGRAPH
    {0xEBCC, 0x80E9}, //18869 #CJK UNIFIED IDEOGRAPH
    {0xEBCD, 0x80EA}, //18870 #CJK UNIFIED IDEOGRAPH
    {0xEBCE, 0x80DB}, //18871 #CJK UNIFIED IDEOGRAPH
    {0xEBCF, 0x80C2}, //18872 #CJK UNIFIED IDEOGRAPH
    {0xEBD0, 0x80C4}, //18873 #CJK UNIFIED IDEOGRAPH
    {0xEBD1, 0x80D9}, //18874 #CJK UNIFIED IDEOGRAPH
    {0xEBD2, 0x80CD}, //18875 #CJK UNIFIED IDEOGRAPH
    {0xEBD3, 0x80D7}, //18876 #CJK UNIFIED IDEOGRAPH
    {0xEBD4, 0x6710}, //18877 #CJK UNIFIED IDEOGRAPH
    {0xEBD5, 0x80DD}, //18878 #CJK UNIFIED IDEOGRAPH
    {0xEBD6, 0x80EB}, //18879 #CJK UNIFIED IDEOGRAPH
    {0xEBD7, 0x80F1}, //18880 #CJK UNIFIED IDEOGRAPH
    {0xEBD8, 0x80F4}, //18881 #CJK UNIFIED IDEOGRAPH
    {0xEBD9, 0x80ED}, //18882 #CJK UNIFIED IDEOGRAPH
    {0xEBDA, 0x810D}, //18883 #CJK UNIFIED IDEOGRAPH
    {0xEBDB, 0x810E}, //18884 #CJK UNIFIED IDEOGRAPH
    {0xEBDC, 0x80F2}, //18885 #CJK UNIFIED IDEOGRAPH
    {0xEBDD, 0x80FC}, //18886 #CJK UNIFIED IDEOGRAPH
    {0xEBDE, 0x6715}, //18887 #CJK UNIFIED IDEOGRAPH
    {0xEBDF, 0x8112}, //18888 #CJK UNIFIED IDEOGRAPH
    {0xEBE0, 0x8C5A}, //18889 #CJK UNIFIED IDEOGRAPH
    {0xEBE1, 0x8136}, //18890 #CJK UNIFIED IDEOGRAPH
    {0xEBE2, 0x811E}, //18891 #CJK UNIFIED IDEOGRAPH
    {0xEBE3, 0x812C}, //18892 #CJK UNIFIED IDEOGRAPH
    {0xEBE4, 0x8118}, //18893 #CJK UNIFIED IDEOGRAPH
    {0xEBE5, 0x8132}, //18894 #CJK UNIFIED IDEOGRAPH
    {0xEBE6, 0x8148}, //18895 #CJK UNIFIED IDEOGRAPH
    {0xEBE7, 0x814C}, //18896 #CJK UNIFIED IDEOGRAPH
    {0xEBE8, 0x8153}, //18897 #CJK UNIFIED IDEOGRAPH
    {0xEBE9, 0x8174}, //18898 #CJK UNIFIED IDEOGRAPH
    {0xEBEA, 0x8159}, //18899 #CJK UNIFIED IDEOGRAPH
    {0xEBEB, 0x815A}, //18900 #CJK UNIFIED IDEOGRAPH
    {0xEBEC, 0x8171}, //18901 #CJK UNIFIED IDEOGRAPH
    {0xEBED, 0x8160}, //18902 #CJK UNIFIED IDEOGRAPH
    {0xEBEE, 0x8169}, //18903 #CJK UNIFIED IDEOGRAPH
    {0xEBEF, 0x817C}, //18904 #CJK UNIFIED IDEOGRAPH
    {0xEBF0, 0x817D}, //18905 #CJK UNIFIED IDEOGRAPH
    {0xEBF1, 0x816D}, //18906 #CJK UNIFIED IDEOGRAPH
    {0xEBF2, 0x8167}, //18907 #CJK UNIFIED IDEOGRAPH
    {0xEBF3, 0x584D}, //18908 #CJK UNIFIED IDEOGRAPH
    {0xEBF4, 0x5AB5}, //18909 #CJK UNIFIED IDEOGRAPH
    {0xEBF5, 0x8188}, //18910 #CJK UNIFIED IDEOGRAPH
    {0xEBF6, 0x8182}, //18911 #CJK UNIFIED IDEOGRAPH
    {0xEBF7, 0x8191}, //18912 #CJK UNIFIED IDEOGRAPH
    {0xEBF8, 0x6ED5}, //18913 #CJK UNIFIED IDEOGRAPH
    {0xEBF9, 0x81A3}, //18914 #CJK UNIFIED IDEOGRAPH
    {0xEBFA, 0x81AA}, //18915 #CJK UNIFIED IDEOGRAPH
    {0xEBFB, 0x81CC}, //18916 #CJK UNIFIED IDEOGRAPH
    {0xEBFC, 0x6726}, //18917 #CJK UNIFIED IDEOGRAPH
    {0xEBFD, 0x81CA}, //18918 #CJK UNIFIED IDEOGRAPH
    {0xEBFE, 0x81BB}, //18919 #CJK UNIFIED IDEOGRAPH
    {0xEC40, 0x9721}, //18920 #CJK UNIFIED IDEOGRAPH
    {0xEC41, 0x9722}, //18921 #CJK UNIFIED IDEOGRAPH
    {0xEC42, 0x9723}, //18922 #CJK UNIFIED IDEOGRAPH
    {0xEC43, 0x9724}, //18923 #CJK UNIFIED IDEOGRAPH
    {0xEC44, 0x9725}, //18924 #CJK UNIFIED IDEOGRAPH
    {0xEC45, 0x9726}, //18925 #CJK UNIFIED IDEOGRAPH
    {0xEC46, 0x9727}, //18926 #CJK UNIFIED IDEOGRAPH
    {0