/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapred.lib.aggregate;

import java.io.IOException;
import java.util.ArrayList;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.mapred.FileInputFormat;
import org.apache.hadoop.mapred.FileOutputFormat;
import org.apache.hadoop.mapred.JobClient;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.SequenceFileInputFormat;
import org.apache.hadoop.mapred.TextInputFormat;
import org.apache.hadoop.mapred.TextOutputFormat;
import org.apache.hadoop.mapred.jobcontrol.Job;
import org.apache.hadoop.mapred.jobcontrol.JobControl;
import org.apache.hadoop.mapred.lib.aggregate.ValueAggregator;
import org.apache.hadoop.mapred.lib.aggregate.ValueAggregatorCombiner;
import org.apache.hadoop.mapred.lib.aggregate.ValueAggregatorDescriptor;
import org.apache.hadoop.mapred.lib.aggregate.ValueAggregatorMapper;
import org.apache.hadoop.mapred.lib.aggregate.ValueAggregatorReducer;
import org.apache.hadoop.util.GenericOptionsParser;

public class ValueAggregatorJob {
    public static JobControl createValueAggregatorJobs(String[] args, Class<? extends ValueAggregatorDescriptor>[] descriptors) throws IOException {
        JobControl theControl = new JobControl("ValueAggregatorJobs");
        ArrayList<Job> dependingJobs = new ArrayList<Job>();
        JobConf aJobConf = ValueAggregatorJob.createValueAggregatorJob(args);
        if (descriptors != null) {
            ValueAggregatorJob.setAggregatorDescriptors(aJobConf, descriptors);
        }
        Job aJob = new Job(aJobConf, dependingJobs);
        theControl.addJob(aJob);
        return theControl;
    }

    public static JobControl createValueAggregatorJobs(String[] args) throws IOException {
        return ValueAggregatorJob.createValueAggregatorJobs(args, null);
    }

    public static JobConf createValueAggregatorJob(String[] args) throws IOException {
        String userJarFile;
        Configuration conf = new Configuration();
        GenericOptionsParser genericParser = new GenericOptionsParser(conf, args);
        if ((args = genericParser.getRemainingArgs()).length < 2) {
            System.out.println("usage: inputDirs outDir [numOfReducer [textinputformat|seq [specfile [jobName]]]]");
            GenericOptionsParser.printGenericCommandUsage(System.out);
            System.exit(1);
        }
        String inputDir = args[0];
        String outputDir = args[1];
        int numOfReducers = 1;
        if (args.length > 2) {
            numOfReducers = Integer.parseInt(args[2]);
        }
        Class theInputFormat = TextInputFormat.class;
        theInputFormat = args.length > 3 && args[3].compareToIgnoreCase("textinputformat") == 0 ? TextInputFormat.class : SequenceFileInputFormat.class;
        Path specFile = null;
        if (args.length > 4) {
            specFile = new Path(args[4]);
        }
        String jobName = "";
        if (args.length > 5) {
            jobName = args[5];
        }
        JobConf theJob = new JobConf(conf);
        if (specFile != null) {
            theJob.addResource(specFile);
        }
        if ((userJarFile = theJob.get("user.jar.file")) == null) {
            theJob.setJarByClass(ValueAggregator.class);
        } else {
            theJob.setJar(userJarFile);
        }
        theJob.setJobName("ValueAggregatorJob: " + jobName);
        FileInputFormat.addInputPaths(theJob, inputDir);
        theJob.setInputFormat(theInputFormat);
        theJob.setMapperClass(ValueAggregatorMapper.class);
        FileOutputFormat.setOutputPath(theJob, new Path(outputDir));
        theJob.setOutputFormat(TextOutputFormat.class);
        theJob.setMapOutputKeyClass(Text.class);
        theJob.setMapOutputValueClass(Text.class);
        theJob.setOutputKeyClass(Text.class);
        theJob.setOutputValueClass(Text.class);
        theJob.setReducerClass(ValueAggregatorReducer.class);
        theJob.setCombinerClass(ValueAggregatorCombiner.class);
        theJob.setNumMapTasks(1);
        theJob.setNumReduceTasks(numOfReducers);
        return theJob;
    }

    public static JobConf createValueAggregatorJob(String[] args, Class<? extends ValueAggregatorDescriptor>[] descriptors) throws IOException {
        JobConf job = ValueAggregatorJob.createValueAggregatorJob(args);
        ValueAggregatorJob.setAggregatorDescriptors(job, descriptors);
        return job;
    }

    public static void setAggregatorDescriptors(JobConf job, Class<? extends ValueAggregatorDescriptor>[] descriptors) {
        job.setInt("aggregator.descriptor.num", descriptors.length);
        for (int i = 0; i < descriptors.length; ++i) {
            job.set("aggregator.descriptor." + i, "UserDefined," + descriptors[i].getName());
        }
    }

    public static void main(String[] args) throws IOException {
        JobConf job = ValueAggregatorJob.createValueAggregatorJob(args);
        JobClient.runJob(job);
    }
}

