/*
 * Copyright (c) 2016 Vivid Solutions.
 *
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License 2.0
 * and Eclipse Distribution License v. 1.0 which accompanies this distribution.
 * The Eclipse Public License is available at http://www.eclipse.org/legal/epl-v20.html
 * and the Eclipse Distribution License is available at
 *
 * http://www.eclipse.org/org/documents/edl-v10.php.
 */

package org.locationtech.jtstest.testbuilder.ui.style;

import java.awt.Graphics2D;
import java.awt.geom.Point2D;

import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.LineString;
import org.locationtech.jtstest.testbuilder.ui.Viewport;


public abstract class LineEndStyle extends LineStringStyle  {
    private boolean start;

    public LineEndStyle(boolean start) {               
        this.start = start;
    }    

    protected void paintLineString(LineString lineString, int lineType, Viewport viewport, Graphics2D graphics
        ) throws Exception {
        if (lineString.isEmpty()) {
            return;
        }

        paint(start ? lineString.getCoordinateN(0)
                    : lineString.getCoordinateN(lineString.getNumPoints() - 1),
            start ? lineString.getCoordinateN(1)
                  : lineString.getCoordinateN(lineString.getNumPoints() - 2),
            viewport, graphics);
    }

    private void paint(Coordinate terminal, Coordinate next, Viewport viewport,
        Graphics2D graphics) throws Exception {
        paint(viewport.toView(new Point2D.Double(terminal.x, terminal.y)),
            viewport.toView(new Point2D.Double(next.x, next.y)), viewport,
            graphics);
    }

    protected abstract void paint(Point2D terminal, Point2D next,
        Viewport viewport, Graphics2D graphics) throws Exception;

    
}
