// Copyright (c) 2000 Stephen Williams (steve@icarus.com)
//
//    This source code is free software; you can redistribute it
//    and/or modify it in source code form under the terms of the GNU
//    General Public License as published by the Free Software
//    Foundation; either version 2 of the License, or (at your option)
//    any later version.
//
//    This program is distributed in the hope that it will be useful,
//    but WITHOUT ANY WARRANTY; without even the implied warranty of
//    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//    GNU General Public License for more details.
//
//    You should have received a copy of the GNU General Public License
//    along with this program; if not, write to the Free Software
//    Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA
//

// This tests tasks being able to write to output parameters that
// are memory words. This is legal as val[0] is a valid l-value.
// In addition, it catches binding issues. Note the common name
// of the val parameter and the val memory.


module test;
   reg [31:0] val[1:0], tmp;


  task testT;
    output [31:0] val;
  begin
    val = 1234;
  end
  endtask

  initial begin
     testT(val[0]);
     if (val[0] === 1234)
       $display("PASSED");
     else
       $display("FAILED -- val[0] == %b",val[0]);

  end
endmodule
