/*
* Copyright (c) 2018, Intel Corporation
*
* Permission is hereby granted, free of charge, to any person obtaining a
* copy of this software and associated documentation files (the "Software"),
* to deal in the Software without restriction, including without limitation
* the rights to use, copy, modify, merge, publish, distribute, sublicense,
* and/or sell copies of the Software, and to permit persons to whom the
* Software is furnished to do so, subject to the following conditions:
*
* The above copyright notice and this permission notice shall be included
* in all copies or substantial portions of the Software.
*
* THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS
* OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
* FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL
* THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR
* OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE,
* ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR
* OTHER DEALINGS IN THE SOFTWARE.
*/
#ifndef __TEST_DATA_CAPS_H__
#define __TEST_DATA_CAPS_H__

#include <map>
#include <string>
#include <string.h>
#include "driver_loader.h"

struct MapFeatureIDComparer
{
    bool operator()(const DeviceConfig &Left, const DeviceConfig &Right) const
    {
        return memcmp(&Left, &Right, sizeof(Right)) < 0;
    }
};

class CapsTestData
{
public:

    CapsTestData();

    std::vector<FeatureID>& GetRefFeatureIDTable(DeviceConfig platform)
    {
        return m_mapPlatformRefFeatureIDs[platform];
    }

private:

    void InitRefFeatureIDMap();

private:

    std::map<DeviceConfig, std::vector<FeatureID>, MapFeatureIDComparer> m_mapPlatformRefFeatureIDs;
};

#endif // __TEST_DATA_CAPS_H__
