{- This module was generated from data in the Kate syntax
   highlighting file sgml.xml, version 1.02, by  -}

module Text.Highlighting.Kate.Syntax.Sgml
          (highlight, parseExpression, syntaxName, syntaxExtensions)
where
import Text.Highlighting.Kate.Types
import Text.Highlighting.Kate.Common
import Text.ParserCombinators.Parsec hiding (State)
import Control.Monad.State
import Data.Char (isSpace)

-- | Full name of language.
syntaxName :: String
syntaxName = "SGML"

-- | Filename extensions for this language.
syntaxExtensions :: String
syntaxExtensions = "*.sgml"

-- | Highlight source code using this syntax definition.
highlight :: String -> [SourceLine]
highlight input = evalState (mapM parseSourceLine $ lines input) startingState

parseSourceLine :: String -> State SyntaxState SourceLine
parseSourceLine = mkParseSourceLine (parseExpression Nothing)

-- | Parse an expression using appropriate local context.
parseExpression :: Maybe (String,String)
                -> KateParser Token
parseExpression mbcontext = do
  (lang,cont) <- maybe currentContext return mbcontext
  result <- parseRules (lang,cont)
  optional $ do eof
                updateState $ \st -> st{ synStPrevChar = '\n' }
                pEndLine
  return result

startingState = SyntaxState {synStContexts = [("SGML","Normal Text")], synStLineNumber = 0, synStPrevChar = '\n', synStPrevNonspace = False, synStCaseSensitive = True, synStKeywordCaseSensitive = False, synStCaptures = []}

pEndLine = do
  updateState $ \st -> st{ synStPrevNonspace = False }
  context <- currentContext
  contexts <- synStContexts `fmap` getState
  if length contexts >= 2
    then case context of
      ("SGML","Normal Text") -> return ()
      ("SGML","Attribute") -> return ()
      ("SGML","Value") -> return ()
      ("SGML","Value 2") -> return ()
      ("SGML","Comment") -> return ()
      _ -> return ()
    else return ()

withAttribute attr txt = do
  when (null txt) $ fail "Parser matched no text"
  updateState $ \st -> st { synStPrevChar = last txt
                          , synStPrevNonspace = synStPrevNonspace st || not (all isSpace txt) }
  return (attr, txt)


regex_'3c'5cs'2a'5c'2f'3f'5cs'2a'5ba'2dzA'2dZ'5f'3a'5d'5ba'2dzA'2dZ0'2d9'2e'5f'3a'2d'5d'2a = compileRegex "<\\s*\\/?\\s*[a-zA-Z_:][a-zA-Z0-9._:-]*"
regex_'5cs'2a'3d'5cs'2a = compileRegex "\\s*=\\s*"

parseRules ("SGML","Normal Text") =
  (((pString False "<!--" >>= withAttribute CommentTok) >>~ pushContext ("SGML","Comment"))
   <|>
   ((pRegExpr regex_'3c'5cs'2a'5c'2f'3f'5cs'2a'5ba'2dzA'2dZ'5f'3a'5d'5ba'2dzA'2dZ0'2d9'2e'5f'3a'2d'5d'2a >>= withAttribute KeywordTok) >>~ pushContext ("SGML","Attribute"))
   <|>
   (currentContext >>= \x -> guard (x == ("SGML","Normal Text")) >> pDefault >>= withAttribute NormalTok))

parseRules ("SGML","Attribute") =
  (((pDetect2Chars False '/' '>' >>= withAttribute KeywordTok) >>~ (popContext))
   <|>
   ((pDetectChar False '>' >>= withAttribute KeywordTok) >>~ (popContext))
   <|>
   ((pRegExpr regex_'5cs'2a'3d'5cs'2a >>= withAttribute NormalTok) >>~ pushContext ("SGML","Value"))
   <|>
   (currentContext >>= \x -> guard (x == ("SGML","Attribute")) >> pDefault >>= withAttribute OtherTok))

parseRules ("SGML","Value") =
  (((pDetect2Chars False '/' '>' >>= withAttribute KeywordTok) >>~ (popContext >> popContext))
   <|>
   ((pDetectChar False '>' >>= withAttribute KeywordTok) >>~ (popContext >> popContext))
   <|>
   ((pDetectChar False '"' >>= withAttribute DataTypeTok) >>~ pushContext ("SGML","Value 2"))
   <|>
   (currentContext >>= \x -> guard (x == ("SGML","Value")) >> pDefault >>= withAttribute DataTypeTok))

parseRules ("SGML","Value 2") =
  (((pDetectChar False '"' >>= withAttribute DataTypeTok) >>~ (popContext >> popContext))
   <|>
   (currentContext >>= \x -> guard (x == ("SGML","Value 2")) >> pDefault >>= withAttribute DataTypeTok))

parseRules ("SGML","Comment") =
  (((pString False "-->" >>= withAttribute CommentTok) >>~ (popContext))
   <|>
   (currentContext >>= \x -> guard (x == ("SGML","Comment")) >> pDefault >>= withAttribute CommentTok))


parseRules x = parseRules ("SGML","Normal Text") <|> fail ("Unknown context" ++ show x)
