// Copyright (C) 2000-2007, Luca Padovani <padovani@sti.uniurb.it>.
// 
// This file is part of GtkMathView, a flexible, high-quality rendering
// engine for MathML documents.
// 
// GtkMathView is free software; you can redistribute it and/or modify it
// under the terms of the GNU Lesser General Public License as published
// by the Free Software Foundation; either version 3 of the License, or
// (at your option) any later version.
// 
// GtkMathView is distributed in the hope that it will be useful, but
// WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// Lesser General Public License for more details.
// 
// You should have received a copy of the GNU Lesser General Public License
// along with this program.  If not, see <http://www.gnu.org/licenses/>.

#include "TFM.hh"

static TFM::Font font = {
"CMTI",

  0xee,
  "TeX text",
  0x00800000,
  0x23d16690,
  7,
  128
};

static TFM::Dimension dimension[] = {
  { 0x01, "slant", 0x00040000 },
  { 0x02, "space", 0x000624fc },
  { 0x03, "space_stretch", 0x0002a222 },
  { 0x04, "space_shrink", 0x0001c16c },
  { 0x05, "x_height", 0x0006e38e },
  { 0x06, "quad", 0x00118e3c },
  { 0x07, "extra_space", 0x0001c16c }
};


static TFM::Kerning C_0b_Kerning[] = {
  { 0x21, 0x0001b6c2 },
  { 0x27, 0x0001b6c2 },
  { 0x29, 0x0001b6c2 },
  { 0x3f, 0x0001b6c2 },
  { 0x5d, 0x0001b6c2 }
};

static TFM::Kerning C_20_Kerning[] = {
  { 0x4c, 0xfffa816a },
  { 0x6c, 0xfffb9c70 }
};

static TFM::Kerning C_27_Kerning[] = {
  { 0x21, 0x0001c16c },
  { 0x3f, 0x0001c16c }
};

static TFM::Kerning C_41_Kerning[] = {
  { 0x43, 0xffff8fa4 },
  { 0x47, 0xffff8fa4 },
  { 0x4f, 0xffff8fa4 },
  { 0x51, 0xffff8fa4 },
  { 0x54, 0xfffeaeee },
  { 0x55, 0xffff8fa4 },
  { 0x56, 0xfffe3e94 },
  { 0x57, 0xfffe3e94 },
  { 0x59, 0xfffeaeee },
  { 0x61, 0xffff1f4a },
  { 0x62, 0xffff8fa4 },
  { 0x63, 0xffff1f4a },
  { 0x64, 0xffff1f4a },
  { 0x65, 0xffff1f4a },
  { 0x67, 0xffff1f4a },
  { 0x68, 0xffff8fa4 },
  { 0x69, 0xffff8fa4 },
  { 0x6b, 0xffff8fa4 },
  { 0x6c, 0xffff8fa4 },
  { 0x6d, 0xffff8fa4 },
  { 0x6e, 0xffff8fa4 },
  { 0x6f, 0xffff1f4a },
  { 0x71, 0xffff1f4a },
  { 0x72, 0xffff8fa4 },
  { 0x74, 0xffff8fa4 },
  { 0x75, 0xffff8fa4 },
  { 0x76, 0xffff8fa4 },
  { 0x77, 0xffff8fa4 }
};

static TFM::Kerning C_44_Kerning[] = {
  { 0x41, 0xffff8fa4 },
  { 0x56, 0xffff8fa4 },
  { 0x57, 0xffff8fa4 },
  { 0x58, 0xffff8fa4 },
  { 0x59, 0xffff8fa4 }
};

static TFM::Kerning C_46_Kerning[] = {
  { 0x41, 0xfffe3e94 },
  { 0x43, 0xffff8fa4 },
  { 0x47, 0xffff8fa4 },
  { 0x4f, 0xffff8fa4 },
  { 0x51, 0xffff8fa4 },
  { 0x61, 0xfffeaeee },
  { 0x65, 0xfffeaeee },
  { 0x6f, 0xfffeaeee },
  { 0x72, 0xfffeaeee },
  { 0x75, 0xfffeaeee }
};

static TFM::Kerning C_4b_Kerning[] = {
  { 0x43, 0xffff8fa4 },
  { 0x47, 0xffff8fa4 },
  { 0x4f, 0xffff8fa4 },
  { 0x51, 0xffff8fa4 }
};

static TFM::Kerning C_4c_Kerning[] = {
  { 0x54, 0xfffeaeee },
  { 0x56, 0xfffe3e94 },
  { 0x57, 0xfffe3e94 },
  { 0x59, 0xfffeaeee },
  { 0x61, 0xffff1f4a },
  { 0x63, 0xffff1f4a },
  { 0x64, 0xffff1f4a },
  { 0x65, 0xffff1f4a },
  { 0x67, 0xffff1f4a },
  { 0x6f, 0xffff1f4a },
  { 0x71, 0xffff1f4a }
};

static TFM::Kerning C_4f_Kerning[] = {
  { 0x41, 0xffff8fa4 },
  { 0x56, 0xffff8fa4 },
  { 0x57, 0xffff8fa4 },
  { 0x58, 0xffff8fa4 },
  { 0x59, 0xffff8fa4 }
};

static TFM::Kerning C_50_Kerning[] = {
  { 0x41, 0xfffeaeee }
};

static TFM::Kerning C_52_Kerning[] = {
  { 0x43, 0xffff8fa4 },
  { 0x47, 0xffff8fa4 },
  { 0x4f, 0xffff8fa4 },
  { 0x51, 0xffff8fa4 },
  { 0x54, 0xfffeaeee },
  { 0x55, 0xffff8fa4 },
  { 0x56, 0xfffe3e94 },
  { 0x57, 0xfffe3e94 },
  { 0x59, 0xfffeaeee },
  { 0x61, 0xffff1f4a },
  { 0x62, 0xffff8fa4 },
  { 0x63, 0xffff1f4a },
  { 0x64, 0xffff1f4a },
  { 0x65, 0xffff1f4a },
  { 0x67, 0xffff1f4a },
  { 0x68, 0xffff8fa4 },
  { 0x69, 0xffff8fa4 },
  { 0x6b, 0xffff8fa4 },
  { 0x6c, 0xffff8fa4 },
  { 0x6d, 0xffff8fa4 },
  { 0x6e, 0xffff8fa4 },
  { 0x6f, 0xffff1f4a },
  { 0x71, 0xffff1f4a },
  { 0x72, 0xffff8fa4 },
  { 0x74, 0xffff8fa4 },
  { 0x75, 0xffff8fa4 },
  { 0x76, 0xffff8fa4 },
  { 0x77, 0xffff8fa4 }
};

static TFM::Kerning C_54_Kerning[] = {
  { 0x41, 0xfffeaeee },
  { 0x61, 0xfffeaeee },
  { 0x65, 0xfffeaeee },
  { 0x6f, 0xfffeaeee },
  { 0x72, 0xfffeaeee },
  { 0x75, 0xfffeaeee },
  { 0x79, 0xfffeaeee }
};

static TFM::Kerning C_56_Kerning[] = {
  { 0x41, 0xfffe3e94 },
  { 0x43, 0xffff8fa4 },
  { 0x47, 0xffff8fa4 },
  { 0x4f, 0xffff8fa4 },
  { 0x51, 0xffff8fa4 },
  { 0x61, 0xfffeaeee },
  { 0x65, 0xfffeaeee },
  { 0x6f, 0xfffeaeee },
  { 0x72, 0xfffeaeee },
  { 0x75, 0xfffeaeee }
};

static TFM::Kerning C_57_Kerning[] = {
  { 0x41, 0xfffeaeee }
};

static TFM::Kerning C_58_Kerning[] = {
  { 0x43, 0xffff8fa4 },
  { 0x47, 0xffff8fa4 },
  { 0x4f, 0xffff8fa4 },
  { 0x51, 0xffff8fa4 }
};

static TFM::Kerning C_59_Kerning[] = {
  { 0x41, 0xfffeaeee },
  { 0x61, 0xfffeaeee },
  { 0x65, 0xfffeaeee },
  { 0x6f, 0xfffeaeee },
  { 0x72, 0xfffeaeee },
  { 0x75, 0xfffeaeee }
};

static TFM::Kerning C_62_Kerning[] = {
  { 0x61, 0xffff1f4a },
  { 0x63, 0xffff1f4a },
  { 0x64, 0xffff1f4a },
  { 0x65, 0xffff1f4a },
  { 0x67, 0xffff1f4a },
  { 0x6f, 0xffff1f4a },
  { 0x71, 0xffff1f4a }
};

static TFM::Kerning C_63_Kerning[] = {
  { 0x61, 0xffff1f4a },
  { 0x63, 0xffff1f4a },
  { 0x64, 0xffff1f4a },
  { 0x65, 0xffff1f4a },
  { 0x67, 0xffff1f4a },
  { 0x6f, 0xffff1f4a },
  { 0x71, 0xffff1f4a }
};

static TFM::Kerning C_64_Kerning[] = {
  { 0x6c, 0x0000e0b6 }
};

static TFM::Kerning C_65_Kerning[] = {
  { 0x61, 0xffff1f4a },
  { 0x63, 0xffff1f4a },
  { 0x64, 0xffff1f4a },
  { 0x65, 0xffff1f4a },
  { 0x67, 0xffff1f4a },
  { 0x6f, 0xffff1f4a },
  { 0x71, 0xffff1f4a }
};

static TFM::Kerning C_66_Kerning[] = {
  { 0x21, 0x0001b6c2 },
  { 0x27, 0x0001b6c2 },
  { 0x29, 0x0001b6c2 },
  { 0x3f, 0x0001b6c2 },
  { 0x5d, 0x0001b6c2 }
};

static TFM::Kerning C_6c_Kerning[] = {
  { 0x6c, 0x0000e0b6 }
};

static TFM::Kerning C_6e_Kerning[] = {
  { 0x27, 0xfffe3e94 }
};

static TFM::Kerning C_6f_Kerning[] = {
  { 0x61, 0xffff1f4a },
  { 0x63, 0xffff1f4a },
  { 0x64, 0xffff1f4a },
  { 0x65, 0xffff1f4a },
  { 0x67, 0xffff1f4a },
  { 0x6f, 0xffff1f4a },
  { 0x71, 0xffff1f4a }
};

static TFM::Kerning C_70_Kerning[] = {
  { 0x61, 0xffff1f4a },
  { 0x63, 0xffff1f4a },
  { 0x64, 0xffff1f4a },
  { 0x65, 0xffff1f4a },
  { 0x67, 0xffff1f4a },
  { 0x6f, 0xffff1f4a },
  { 0x71, 0xffff1f4a }
};

static TFM::Kerning C_72_Kerning[] = {
  { 0x61, 0xffff1f4a },
  { 0x63, 0xffff1f4a },
  { 0x64, 0xffff1f4a },
  { 0x65, 0xffff1f4a },
  { 0x67, 0xffff1f4a },
  { 0x6f, 0xffff1f4a },
  { 0x71, 0xffff1f4a }
};

static TFM::Kerning C_77_Kerning[] = {
  { 0x6c, 0x0000e0b6 }
};

static TFM::Ligature C_0b_Ligature[] = {
  { 0x69, 0x00, 0x0e },
  { 0x6c, 0x00, 0x0f }
};

static TFM::Ligature C_21_Ligature[] = {
  { 0x60, 0x00, 0x3c }
};

static TFM::Ligature C_27_Ligature[] = {
  { 0x27, 0x00, 0x22 }
};

static TFM::Ligature C_2d_Ligature[] = {
  { 0x2d, 0x00, 0x7b }
};

static TFM::Ligature C_3f_Ligature[] = {
  { 0x60, 0x00, 0x3e }
};

static TFM::Ligature C_60_Ligature[] = {
  { 0x60, 0x00, 0x5c }
};

static TFM::Ligature C_66_Ligature[] = {
  { 0x66, 0x00, 0x0b },
  { 0x69, 0x00, 0x0c },
  { 0x6c, 0x00, 0x0d }
};

static TFM::Ligature C_7b_Ligature[] = {
  { 0x2d, 0x00, 0x7c }
};


static TFM::Character character[] = {
  { 0x00, 0x000ac2da, 0x000aeeee, 0x00000000, 0x000112b4, 0, 0, 0, 0 },
  { 0x01, 0x000e0b62, 0x000aeeee, 0x00000000, 0x00000000, 0, 0, 0, 0 },
  { 0x02, 0x000d2aac, 0x000aeeee, 0x00000000, 0x0000d82e, 0, 0, 0, 0 },
  { 0x03, 0x000bdde0, 0x000aeeee, 0x00000000, 0x00000000, 0, 0, 0, 0 },
  { 0x04, 0x000b6940, 0x000aeeee, 0x00000000, 0x0000838e, 0, 0, 0, 0 },
  { 0x05, 0x000cbe96, 0x000aeeee, 0x00000000, 0x000085b2, 0, 0, 0, 0 },
  { 0x06, 0x000c49f6, 0x000aeeee, 0x00000000, 0x0000d82e, 0, 0, 0, 0 },
  { 0x07, 0x000d2aac, 0x000aeeee, 0x00000000, 0x0000838e, 0, 0, 0, 0 },
  { 0x08, 0x000c49f6, 0x000aeeee, 0x00000000, 0x0000ed82, 0, 0, 0, 0 },
  { 0x09, 0x000d2aac, 0x000aeeee, 0x00000000, 0x0000838e, 0, 0, 0, 0 },
  { 0x0a, 0x000c49f6, 0x000aeeee, 0x00000000, 0x00013334, 0, 0, 0, 0 },
  { 0x0b, 0x000a888e, 0x000b1c72, 0x00031c72, 0x000104fc, 5, C_0b_Kerning, 2, C_0b_Ligature },
  { 0x0c, 0x0009a7da, 0x000b1c72, 0x00031c72, 0x000104fc, 0, 0, 0, 0 },
  { 0x0d, 0x000a1834, 0x000b1c72, 0x00031c72, 0x000104fc, 0, 0, 0, 0 },
  { 0x0e, 0x000f244c, 0x000b1c72, 0x00031c72, 0x000104fc, 0, 0, 0, 0 },
  { 0x0f, 0x000f5c7a, 0x000b1c72, 0x00031c72, 0x000104fc, 0, 0, 0, 0 },
  { 0x10, 0x00054446, 0x0006e38e, 0x00000000, 0x00006c16, 0, 0, 0, 0 },
  { 0x11, 0x0005b4a2, 0x0006e38e, 0x00031c72, 0x000085b2, 0, 0, 0, 0 },
  { 0x12, 0x0008c71e, 0x000b1c72, 0x00000000, 0x00000000, 0, 0, 0, 0 },
  { 0x13, 0x0008c71e, 0x000b1c72, 0x00000000, 0x00008fa4, 0, 0, 0, 0 },
  { 0x14, 0x0008c71e, 0x000a0e3a, 0x00000000, 0x0001488a, 0, 0, 0, 0 },
  { 0x15, 0x0008c71e, 0x000b1c72, 0x00000000, 0x00000000, 0, 0, 0, 0 },
  { 0x16, 0x0008c71e, 0x0009360a, 0x00000000, 0x0001488a, 0, 0, 0, 0 },
  { 0x17, 0x000e26e2, 0x000b1c72, 0x00000000, 0x00000000, 0, 0, 0, 0 },
  { 0x18, 0x0007e668, 0x00000000, 0x0002b8e4, 0x00000000, 0, 0, 0, 0 },
  { 0x19, 0x0009377c, 0x000b1c72, 0x00031c72, 0x00014888, 0, 0, 0, 0 },
  { 0x1a, 0x000c49f6, 0x0006e38e, 0x00000000, 0x00013334, 0, 0, 0, 0 },
  { 0x1b, 0x000c49f6, 0x0006e38e, 0x00000000, 0x00013334, 0, 0, 0, 0 },
  { 0x1c, 0x0008c71e, 0x000871c8, 0x00018e3a, 0x000085b2, 0, 0, 0, 0 },
  { 0x1d, 0x000f2668, 0x000aeeee, 0x00000000, 0x0000d82e, 0, 0, 0, 0 },
  { 0x1e, 0x0010e7d4, 0x000aeeee, 0x00000000, 0x0000d82e, 0, 0, 0, 0 },
  { 0x1f, 0x000d2aac, 0x000bb60a, 0x0000c71c, 0x0000d82e, 0, 0, 0, 0 },
  { 0x20, 0x00046390, 0x0006e38e, 0x00000000, 0x00000000, 2, C_20_Kerning, 0, 0 },
  { 0x21, 0x00054446, 0x000b1c72, 0x00000000, 0x0000f4e8, 0, 0, 1, C_21_Ligature },
  { 0x22, 0x0008ccce, 0x000b1c72, 0x00000000, 0x0000f4e8, 0, 0, 0, 0 },
  { 0x23, 0x000e0b62, 0x000b1c72, 0x00031c70, 0x000112b4, 0, 0, 0, 0 },
  { 0x24, 0x000d0e3a, 0x000b1c72, 0x00000000, 0x00000000, 0, 0, 0, 0 },
  { 0x25, 0x000e0b62, 0x000c0000, 0x0000e38e, 0x00013334, 0, 0, 0, 0 },
  { 0x26, 0x000d2aac, 0x000b1c72, 0x00000000, 0x00008fa4, 0, 0, 0, 0 },
  { 0x27, 0x00054446, 0x000b1c72, 0x00000000, 0x0000f4e8, 2, C_27_Kerning, 1, C_27_Ligature },
  { 0x28, 0x000705b2, 0x000c0000, 0x00040000, 0x0000d82e, 0, 0, 0, 0 },
  { 0x29, 0x000705b2, 0x000c0000, 0x00040000, 0x00008fa4, 0, 0, 0, 0 },
  { 0x2a, 0x0008c71e, 0x000c0000, 0x00000000, 0x00006c16, 0, 0, 0, 0 },
  { 0x2b, 0x000d2aac, 0x0009360a, 0x00014444, 0x00008fa4, 0, 0, 0, 0 },
  { 0x2c, 0x00054446, 0x0001c71c, 0x00031c72, 0x00000000, 0, 0, 0, 0 },
  { 0x2d, 0x000624fc, 0x0006e38e, 0x00000000, 0x00006c16, 0, 0, 1, C_2d_Ligature },
  { 0x2e, 0x00054446, 0x0001c71c, 0x00000000, 0x00000000, 0, 0, 0, 0 },
  { 0x2f, 0x0008c71e, 0x000c0000, 0x00040000, 0x0000d82e, 0, 0, 0, 0 },
  { 0x30, 0x0008c71e, 0x000a4fa6, 0x00000000, 0x00014888, 0, 0, 0, 0 },
  { 0x31, 0x0008c71e, 0x000a4fa6, 0x00000000, 0x00014888, 0, 0, 0, 0 },
  { 0x32, 0x0008c71e, 0x000a4fa6, 0x00000000, 0x00014888, 0, 0, 0, 0 },
  { 0x33, 0x0008c71e, 0x000a4fa6, 0x00000000, 0x00014888, 0, 0, 0, 0 },
  { 0x34, 0x0008c71e, 0x000a4fa6, 0x00031c72, 0x00014888, 0, 0, 0, 0 },
  { 0x35, 0x0008c71e, 0x000a4fa6, 0x00000000, 0x00014888, 0, 0, 0, 0 },
  { 0x36, 0x0008c71e, 0x000a4fa6, 0x00000000, 0x00014888, 0, 0, 0, 0 },
  { 0x37, 0x0008c71e, 0x000a4fa6, 0x00031c72, 0x00014888, 0, 0, 0, 0 },
  { 0x38, 0x0008c71e, 0x000a4fa6, 0x00000000, 0x00014888, 0, 0, 0, 0 },
  { 0x39, 0x0008c71e, 0x000a4fa6, 0x00000000, 0x00014888, 0, 0, 0, 0 },
  { 0x3a, 0x00054446, 0x0006e38e, 0x00000000, 0x0000db06, 0, 0, 0, 0 },
  { 0x3b, 0x00054446, 0x0006e38e, 0x00031c72, 0x0000db06, 0, 0, 0, 0 },
  { 0x3c, 0x00054446, 0x00080000, 0x00031c72, 0x00012222, 0, 0, 0, 0 },
  { 0x3d, 0x000d2aac, 0x00060c3c, 0xfffe0c3c, 0x000112b4, 0, 0, 0, 0 },
  { 0x3e, 0x0008c71e, 0x00080000, 0x00031c72, 0x00000000, 0, 0, 0, 0 },
  { 0x3f, 0x0008c71e, 0x000b1c72, 0x00000000, 0x0000ed82, 0, 0, 1, C_3f_Ligature },
  { 0x40, 0x000d2aac, 0x000b1c72, 0x00000000, 0x0000f4e8, 0, 0, 0, 0 },
  { 0x41, 0x000cbe96, 0x000aeeee, 0x00000000, 0x00000000, 28, C_41_Kerning, 0, 0 },
  { 0x42, 0x000c13ec, 0x000aeeee, 0x00000000, 0x00013334, 0, 0, 0, 0 },
  { 0x43, 0x000c49f6, 0x000aeeee, 0x00000000, 0x0001488a, 0, 0, 0, 0 },
  { 0x44, 0x000cf4a2, 0x000aeeee, 0x00000000, 0x0000d82e, 5, C_44_Kerning, 0, 0 },
  { 0x45, 0x000ba390, 0x000aeeee, 0x00000000, 0x0000d82e, 0, 0, 0, 0 },
  { 0x46, 0x000b3336, 0x000aeeee, 0x00000000, 0x000112b4, 10, C_46_Kerning, 0, 0 },
  { 0x47, 0x000d47d4, 0x000aeeee, 0x00000000, 0x00000000, 0, 0, 0, 0 },
  { 0x48, 0x000cbe96, 0x000aeeee, 0x00000000, 0x000085b2, 0, 0, 0, 0 },
  { 0x49, 0x0006999c, 0x000aeeee, 0x00000000, 0x00008fa4, 0, 0, 0, 0 },
  { 0x4a, 0x0009016e, 0x000aeeee, 0x00000000, 0x00012222, 0, 0, 0, 0 },
  { 0x4b, 0x000d2ef2, 0x000aeeee, 0x00000000, 0x0001488a, 4, C_4b_Kerning, 0, 0 },
  { 0x4c, 0x000ac2da, 0x000aeeee, 0x00000000, 0x00000000, 11, C_4c_Kerning, 0, 0 },
  { 0x4d, 0x000f60b8, 0x000aeeee, 0x00000000, 0x000085b2, 0, 0, 0, 0 },
  { 0x4e, 0x000cbe96, 0x000aeeee, 0x00000000, 0x000085b2, 0, 0, 0, 0 },
  { 0x4f, 0x000d2aac, 0x000aeeee, 0x00000000, 0x0000d82e, 5, C_4f_Kerning, 0, 0 },
  { 0x50, 0x000ba390, 0x000aeeee, 0x00000000, 0x00013334, 1, C_50_Kerning, 0, 0 },
  { 0x51, 0x000d2aac, 0x000aeeee, 0x00031c72, 0x0000d82e, 0, 0, 0, 0 },
  { 0x52, 0x000c8446, 0x000aeeee, 0x00000000, 0x0000838e, 28, C_52_Kerning, 0, 0 },
  { 0x53, 0x0009a7d4, 0x000aeeee, 0x00000000, 0x0000db06, 0, 0, 0, 0 },
  { 0x54, 0x000c49f6, 0x000aeeee, 0x00000000, 0x000112b4, 7, C_54_Kerning, 0, 0 },
  { 0x55, 0x000cbe96, 0x000aeeee, 0x00000000, 0x000085b2, 0, 0, 0, 0 },
  { 0x56, 0x000cbe96, 0x000aeeee, 0x00000000, 0x0000ed82, 10, C_56_Kerning, 0, 0 },
  { 0x57, 0x00112224, 0x000aeeee, 0x00000000, 0x0000ed82, 1, C_57_Kerning, 0, 0 },
  { 0x58, 0x000cbe96, 0x000aeeee, 0x00000000, 0x00008fa4, 4, C_58_Kerning, 0, 0 },
  { 0x59, 0x000cbe96, 0x000aeeee, 0x00000000, 0x0000fb06, 6, C_59_Kerning, 0, 0 },
  { 0x5a, 0x000a888a, 0x000aeeee, 0x00000000, 0x0001488a, 0, 0, 0, 0 },
  { 0x5b, 0x00054446, 0x000c0000, 0x00040000, 0x0000f4e8, 0, 0, 0, 0 },
  { 0x5c, 0x0008ccce, 0x000b1c72, 0x00000000, 0x0000db06, 0, 0, 0, 0 },
  { 0x5d, 0x00054446, 0x000c0000, 0x00040000, 0x00012222, 0, 0, 0, 0 },
  { 0x5e, 0x0008c71e, 0x000b1c72, 0x00000000, 0x000104fc, 0, 0, 0, 0 },
  { 0x5f, 0x00054446, 0x000abaec, 0x00000000, 0x00008fa4, 0, 0, 0, 0 },
  { 0x60, 0x00054446, 0x000b1c72, 0x00000000, 0x0000f4e8, 0, 0, 1, C_60_Ligature },
  { 0x61, 0x0008c71e, 0x0006e38e, 0x00000000, 0x00006c16, 0, 0, 0, 0 },
  { 0x62, 0x0007e668, 0x000b1c72, 0x00000000, 0x0000fb06, 7, C_62_Kerning, 0, 0 },
  { 0x63, 0x0007e668, 0x0006e38e, 0x00000000, 0x0000d82e, 7, C_63_Kerning, 0, 0 },
  { 0x64, 0x0008c71e, 0x000b1c72, 0x00000000, 0x000104fc, 1, C_64_Kerning, 0, 0 },
  { 0x65, 0x0007e668, 0x0006e38e, 0x00000000, 0x00013334, 7, C_65_Kerning, 0, 0 },
  { 0x66, 0x00054448, 0x000b1c72, 0x00031c72, 0x000104fc, 5, C_66_Kerning, 3, C_66_Ligature },
  { 0x67, 0x0007e668, 0x0006e38e, 0x00031c72, 0x0000838e, 0, 0, 0, 0 },
  { 0x68, 0x0008c71e, 0x000b1c72, 0x00000000, 0x00006c16, 0, 0, 0, 0 },
  { 0x69, 0x00054446, 0x000a820a, 0x00000000, 0x0000fb06, 0, 0, 0, 0 },
  { 0x6a, 0x00054446, 0x000a820a, 0x00031c72, 0x00000000, 0, 0, 0, 0 },
  { 0x6b, 0x0007e668, 0x000b1c72, 0x00000000, 0x00006c16, 0, 0, 0, 0 },
  { 0x6c, 0x00046390, 0x000b1c72, 0x00000000, 0x000104fc, 1, C_6c_Kerning, 0, 0 },
  { 0x6d, 0x000e0b62, 0x0006e38e, 0x00000000, 0x00006c16, 0, 0, 0, 0 },
  { 0x6e, 0x0009a7d4, 0x0006e38e, 0x00000000, 0x00006c16, 1, C_6e_Kerning, 0, 0 },
  { 0x6f, 0x0008c71e, 0x0006e38e, 0x00000000, 0x0000fb06, 7, C_6f_Kerning, 0, 0 },
  { 0x70, 0x0008c71e, 0x0006e38e, 0x00031c72, 0x0000fb06, 7, C_70_Kerning, 0, 0 },
  { 0x71, 0x0007e668, 0x0006e38e, 0x00031c72, 0x0000838e, 0, 0, 0, 0 },
  { 0x72, 0x00073de0, 0x0006e38e, 0x00000000, 0x00006c16, 7, C_72_Kerning, 0, 0 },
  { 0x73, 0x000705b2, 0x0006e38e, 0x00000000, 0x00014888, 0, 0, 0, 0 },
  { 0x74, 0x0005b4a2, 0x0009d75e, 0x00000000, 0x0000db06, 0, 0, 0, 0 },
  { 0x75, 0x0009377a, 0x0006e38e, 0x00000000, 0x00006c16, 0, 0, 0, 0 },
  { 0x76, 0x0007e668, 0x0006e38e, 0x00000000, 0x00006c16, 0, 0, 0, 0 },
  { 0x77, 0x000b6940, 0x0006e38e, 0x00000000, 0x00006c16, 1, C_77_Kerning, 0, 0 },
  { 0x78, 0x0007eaae, 0x0006e38e, 0x00000000, 0x0000fb06, 0, 0, 0, 0 },
  { 0x79, 0x000856c4, 0x0006e38e, 0x00031c72, 0x0000838e, 0, 0, 0, 0 },
  { 0x7a, 0x000705b4, 0x0006e38e, 0x00000000, 0x000104fc, 0, 0, 0, 0 },
  { 0x7b, 0x0008c71e, 0x0006e38e, 0x00000000, 0x0000ed82, 0, 0, 1, C_7b_Ligature },
  { 0x7c, 0x00118e3c, 0x0006e38e, 0x00000000, 0x0000ed82, 0, 0, 0, 0 },
  { 0x7d, 0x0008c71e, 0x000b1c72, 0x00000000, 0x0000ed82, 0, 0, 0, 0 },
  { 0x7e, 0x0008c71e, 0x000abaec, 0x00000000, 0x000085b2, 0, 0, 0, 0 },
  { 0x7f, 0x0008c71e, 0x000abaec, 0x00000000, 0x000112b4, 0, 0, 0, 0 }
};

void
cmti8_tables(TFM::Font*& _font, TFM::Dimension*& _dimension, TFM::Character*& _character)
{
  _font = &font;
  _dimension = dimension;
  _character = character;
}
