# gozerbot/examples.py
#
#

"""
    examples is a dict of example objects.

"""

__copyright__ = 'this file is in the public domain'

# ==============
# IMPORT SECTION


# basic imports
import re

# END IMPORT
# ==========

# ============
# LOCK SECTION

# no locks

# END LOCK
# ========

class Example(object):

    """
        an example.

        :param descr: description of the example
        :type descr: string
        :param ex: the example
        :type ex: string

    """

    def __init__(self, descr, ex):
        self.descr = descr
        self.example = ex

class Examples(dict):

    """
        examples object is a dict.

    """

    def add(self, name, descr, ex):

        """
            add description and example.

            :param name: name of the example
            :type name: string
            :param descr: description of the example
            :type descr: string
            :param ex: the example
            :type ex: string

            .. literalinclude:: ../../gozerbot/examples.py
                :pyobject: Examples.add

        """

        self[name.lower()] = Example(descr, ex)

    def size(self):
 
        """
            return size of examples dict.

            :rtype: integer

            .. literalinclude:: ../../gozerbot/examples.py
                :pyobject: Examples.size

        """

        return len(self.keys())

    def getexamples(self):

        """
            get all examples in list.

            :rtype: list

            .. literalinclude:: ../../gozerbot/examples.py
                :pyobject: Examples.getexamples
        """

        result = []
        for i in self.values():
            ex = i.example.lower()
            exampleslist = re.split('\d\)', ex)
            for example in exampleslist:
                if example:
                    result.append(example.strip())
        return result

# ============
# INIT SECTION

# main examples object
examples = Examples()

# END INIT
# ========
