// Code generated by protoc-gen-gogo.
// source: messages.proto
// DO NOT EDIT!

package mesosproto

import proto "github.com/gogo/protobuf/proto"
import fmt "fmt"
import math "math"

// discarding unused import gogoproto "github.com/gogo/protobuf/gogoproto"

// Reference imports to suppress errors if they are not otherwise used.
var _ = proto.Marshal
var _ = fmt.Errorf
var _ = math.Inf

type StatusUpdateRecord_Type int32

const (
	StatusUpdateRecord_UPDATE StatusUpdateRecord_Type = 0
	StatusUpdateRecord_ACK    StatusUpdateRecord_Type = 1
)

var StatusUpdateRecord_Type_name = map[int32]string{
	0: "UPDATE",
	1: "ACK",
}
var StatusUpdateRecord_Type_value = map[string]int32{
	"UPDATE": 0,
	"ACK":    1,
}

func (x StatusUpdateRecord_Type) Enum() *StatusUpdateRecord_Type {
	p := new(StatusUpdateRecord_Type)
	*p = x
	return p
}
func (x StatusUpdateRecord_Type) String() string {
	return proto.EnumName(StatusUpdateRecord_Type_name, int32(x))
}
func (x *StatusUpdateRecord_Type) UnmarshalJSON(data []byte) error {
	value, err := proto.UnmarshalJSONEnum(StatusUpdateRecord_Type_value, data, "StatusUpdateRecord_Type")
	if err != nil {
		return err
	}
	*x = StatusUpdateRecord_Type(value)
	return nil
}

// TODO(benh): It would be great if this could just be a
// TaskInfo wherever it gets used! However, doing so would
// require adding the framework_id field, the executor_id field, and
// the state field into TaskInfo though (or send them another
// way). Also, one performance reason why we don't do that now is
// because storing whatever data is coupled with a TaskInfo
// could be large and unnecessary.
// TODO(bmahler): Add executor_uuid here, and send it to the master. This will
// allow us to expose executor work directories for tasks in the webui when
// looking from the master level. Currently only the slave knows which run the
// task belongs to.
type Task struct {
	Name        *string       `protobuf:"bytes,1,req,name=name" json:"name,omitempty"`
	TaskId      *TaskID       `protobuf:"bytes,2,req,name=task_id" json:"task_id,omitempty"`
	FrameworkId *FrameworkID  `protobuf:"bytes,3,req,name=framework_id" json:"framework_id,omitempty"`
	ExecutorId  *ExecutorID   `protobuf:"bytes,4,opt,name=executor_id" json:"executor_id,omitempty"`
	SlaveId     *SlaveID      `protobuf:"bytes,5,req,name=slave_id" json:"slave_id,omitempty"`
	State       *TaskState    `protobuf:"varint,6,req,name=state,enum=mesosproto.TaskState" json:"state,omitempty"`
	Resources   []*Resource   `protobuf:"bytes,7,rep,name=resources" json:"resources,omitempty"`
	Statuses    []*TaskStatus `protobuf:"bytes,8,rep,name=statuses" json:"statuses,omitempty"`
	// These fields correspond to the state and uuid of the latest
	// status update forwarded to the master.
	// NOTE: Either both the fields must be set or both must be unset.
	StatusUpdateState *TaskState `protobuf:"varint,9,opt,name=status_update_state,enum=mesosproto.TaskState" json:"status_update_state,omitempty"`
	StatusUpdateUuid  []byte     `protobuf:"bytes,10,opt,name=status_update_uuid" json:"status_update_uuid,omitempty"`
	Labels            *Labels    `protobuf:"bytes,11,opt,name=labels" json:"labels,omitempty"`
	// Service discovery information for the task. It is not interpreted
	// or acted upon by Mesos. It is up to a service discovery system
	// to use this information as needed and to handle tasks without
	// service discovery information.
	Discovery        *DiscoveryInfo `protobuf:"bytes,12,opt,name=discovery" json:"discovery,omitempty"`
	XXX_unrecognized []byte         `json:"-"`
}

func (m *Task) Reset()         { *m = Task{} }
func (m *Task) String() string { return proto.CompactTextString(m) }
func (*Task) ProtoMessage()    {}

func (m *Task) GetName() string {
	if m != nil && m.Name != nil {
		return *m.Name
	}
	return ""
}

func (m *Task) GetTaskId() *TaskID {
	if m != nil {
		return m.TaskId
	}
	return nil
}

func (m *Task) GetFrameworkId() *FrameworkID {
	if m != nil {
		return m.FrameworkId
	}
	return nil
}

func (m *Task) GetExecutorId() *ExecutorID {
	if m != nil {
		return m.ExecutorId
	}
	return nil
}

func (m *Task) GetSlaveId() *SlaveID {
	if m != nil {
		return m.SlaveId
	}
	return nil
}

func (m *Task) GetState() TaskState {
	if m != nil && m.State != nil {
		return *m.State
	}
	return TaskState_TASK_STAGING
}

func (m *Task) GetResources() []*Resource {
	if m != nil {
		return m.Resources
	}
	return nil
}

func (m *Task) GetStatuses() []*TaskStatus {
	if m != nil {
		return m.Statuses
	}
	return nil
}

func (m *Task) GetStatusUpdateState() TaskState {
	if m != nil && m.StatusUpdateState != nil {
		return *m.StatusUpdateState
	}
	return TaskState_TASK_STAGING
}

func (m *Task) GetStatusUpdateUuid() []byte {
	if m != nil {
		return m.StatusUpdateUuid
	}
	return nil
}

func (m *Task) GetLabels() *Labels {
	if m != nil {
		return m.Labels
	}
	return nil
}

func (m *Task) GetDiscovery() *DiscoveryInfo {
	if m != nil {
		return m.Discovery
	}
	return nil
}

// TODO(vinod): Create a new UUID message type.
type StatusUpdate struct {
	FrameworkId *FrameworkID `protobuf:"bytes,1,req,name=framework_id" json:"framework_id,omitempty"`
	ExecutorId  *ExecutorID  `protobuf:"bytes,2,opt,name=executor_id" json:"executor_id,omitempty"`
	SlaveId     *SlaveID     `protobuf:"bytes,3,opt,name=slave_id" json:"slave_id,omitempty"`
	Status      *TaskStatus  `protobuf:"bytes,4,req,name=status" json:"status,omitempty"`
	Timestamp   *float64     `protobuf:"fixed64,5,req,name=timestamp" json:"timestamp,omitempty"`
	// This is being deprecated in favor of TaskStatus.uuid. In 0.23.0,
	// we set the TaskStatus 'uuid' in the executor driver for all
	// retryable status updates.
	Uuid []byte `protobuf:"bytes,6,opt,name=uuid" json:"uuid,omitempty"`
	// This corresponds to the latest state of the task according to the
	// slave. Note that this state might be different than the state in
	// 'status' because status update manager queues updates. In other
	// words, 'status' corresponds to the update at top of the queue and
	// 'latest_state' corresponds to the update at bottom of the queue.
	LatestState      *TaskState `protobuf:"varint,7,opt,name=latest_state,enum=mesosproto.TaskState" json:"latest_state,omitempty"`
	XXX_unrecognized []byte     `json:"-"`
}

func (m *StatusUpdate) Reset()         { *m = StatusUpdate{} }
func (m *StatusUpdate) String() string { return proto.CompactTextString(m) }
func (*StatusUpdate) ProtoMessage()    {}

func (m *StatusUpdate) GetFrameworkId() *FrameworkID {
	if m != nil {
		return m.FrameworkId
	}
	return nil
}

func (m *StatusUpdate) GetExecutorId() *ExecutorID {
	if m != nil {
		return m.ExecutorId
	}
	return nil
}

func (m *StatusUpdate) GetSlaveId() *SlaveID {
	if m != nil {
		return m.SlaveId
	}
	return nil
}

func (m *StatusUpdate) GetStatus() *TaskStatus {
	if m != nil {
		return m.Status
	}
	return nil
}

func (m *StatusUpdate) GetTimestamp() float64 {
	if m != nil && m.Timestamp != nil {
		return *m.Timestamp
	}
	return 0
}

func (m *StatusUpdate) GetUuid() []byte {
	if m != nil {
		return m.Uuid
	}
	return nil
}

func (m *StatusUpdate) GetLatestState() TaskState {
	if m != nil && m.LatestState != nil {
		return *m.LatestState
	}
	return TaskState_TASK_STAGING
}

// This message encapsulates how we checkpoint a status update to disk.
// NOTE: If type == UPDATE, the 'update' field is required.
// NOTE: If type == ACK, the 'uuid' field is required.
type StatusUpdateRecord struct {
	Type             *StatusUpdateRecord_Type `protobuf:"varint,1,req,name=type,enum=mesosproto.StatusUpdateRecord_Type" json:"type,omitempty"`
	Update           *StatusUpdate            `protobuf:"bytes,2,opt,name=update" json:"update,omitempty"`
	Uuid             []byte                   `protobuf:"bytes,3,opt,name=uuid" json:"uuid,omitempty"`
	XXX_unrecognized []byte                   `json:"-"`
}

func (m *StatusUpdateRecord) Reset()         { *m = StatusUpdateRecord{} }
func (m *StatusUpdateRecord) String() string { return proto.CompactTextString(m) }
func (*StatusUpdateRecord) ProtoMessage()    {}

func (m *StatusUpdateRecord) GetType() StatusUpdateRecord_Type {
	if m != nil && m.Type != nil {
		return *m.Type
	}
	return StatusUpdateRecord_UPDATE
}

func (m *StatusUpdateRecord) GetUpdate() *StatusUpdate {
	if m != nil {
		return m.Update
	}
	return nil
}

func (m *StatusUpdateRecord) GetUuid() []byte {
	if m != nil {
		return m.Uuid
	}
	return nil
}

type SubmitSchedulerRequest struct {
	Name             *string `protobuf:"bytes,1,req,name=name" json:"name,omitempty"`
	XXX_unrecognized []byte  `json:"-"`
}

func (m *SubmitSchedulerRequest) Reset()         { *m = SubmitSchedulerRequest{} }
func (m *SubmitSchedulerRequest) String() string { return proto.CompactTextString(m) }
func (*SubmitSchedulerRequest) ProtoMessage()    {}

func (m *SubmitSchedulerRequest) GetName() string {
	if m != nil && m.Name != nil {
		return *m.Name
	}
	return ""
}

type SubmitSchedulerResponse struct {
	Okay             *bool  `protobuf:"varint,1,req,name=okay" json:"okay,omitempty"`
	XXX_unrecognized []byte `json:"-"`
}

func (m *SubmitSchedulerResponse) Reset()         { *m = SubmitSchedulerResponse{} }
func (m *SubmitSchedulerResponse) String() string { return proto.CompactTextString(m) }
func (*SubmitSchedulerResponse) ProtoMessage()    {}

func (m *SubmitSchedulerResponse) GetOkay() bool {
	if m != nil && m.Okay != nil {
		return *m.Okay
	}
	return false
}

type ExecutorToFrameworkMessage struct {
	SlaveId          *SlaveID     `protobuf:"bytes,1,req,name=slave_id" json:"slave_id,omitempty"`
	FrameworkId      *FrameworkID `protobuf:"bytes,2,req,name=framework_id" json:"framework_id,omitempty"`
	ExecutorId       *ExecutorID  `protobuf:"bytes,3,req,name=executor_id" json:"executor_id,omitempty"`
	Data             []byte       `protobuf:"bytes,4,req,name=data" json:"data,omitempty"`
	XXX_unrecognized []byte       `json:"-"`
}

func (m *ExecutorToFrameworkMessage) Reset()         { *m = ExecutorToFrameworkMessage{} }
func (m *ExecutorToFrameworkMessage) String() string { return proto.CompactTextString(m) }
func (*ExecutorToFrameworkMessage) ProtoMessage()    {}

func (m *ExecutorToFrameworkMessage) GetSlaveId() *SlaveID {
	if m != nil {
		return m.SlaveId
	}
	return nil
}

func (m *ExecutorToFrameworkMessage) GetFrameworkId() *FrameworkID {
	if m != nil {
		return m.FrameworkId
	}
	return nil
}

func (m *ExecutorToFrameworkMessage) GetExecutorId() *ExecutorID {
	if m != nil {
		return m.ExecutorId
	}
	return nil
}

func (m *ExecutorToFrameworkMessage) GetData() []byte {
	if m != nil {
		return m.Data
	}
	return nil
}

type FrameworkToExecutorMessage struct {
	SlaveId          *SlaveID     `protobuf:"bytes,1,req,name=slave_id" json:"slave_id,omitempty"`
	FrameworkId      *FrameworkID `protobuf:"bytes,2,req,name=framework_id" json:"framework_id,omitempty"`
	ExecutorId       *ExecutorID  `protobuf:"bytes,3,req,name=executor_id" json:"executor_id,omitempty"`
	Data             []byte       `protobuf:"bytes,4,req,name=data" json:"data,omitempty"`
	XXX_unrecognized []byte       `json:"-"`
}

func (m *FrameworkToExecutorMessage) Reset()         { *m = FrameworkToExecutorMessage{} }
func (m *FrameworkToExecutorMessage) String() string { return proto.CompactTextString(m) }
func (*FrameworkToExecutorMessage) ProtoMessage()    {}

func (m *FrameworkToExecutorMessage) GetSlaveId() *SlaveID {
	if m != nil {
		return m.SlaveId
	}
	return nil
}

func (m *FrameworkToExecutorMessage) GetFrameworkId() *FrameworkID {
	if m != nil {
		return m.FrameworkId
	}
	return nil
}

func (m *FrameworkToExecutorMessage) GetExecutorId() *ExecutorID {
	if m != nil {
		return m.ExecutorId
	}
	return nil
}

func (m *FrameworkToExecutorMessage) GetData() []byte {
	if m != nil {
		return m.Data
	}
	return nil
}

type RegisterFrameworkMessage struct {
	Framework        *FrameworkInfo `protobuf:"bytes,1,req,name=framework" json:"framework,omitempty"`
	XXX_unrecognized []byte         `json:"-"`
}

func (m *RegisterFrameworkMessage) Reset()         { *m = RegisterFrameworkMessage{} }
func (m *RegisterFrameworkMessage) String() string { return proto.CompactTextString(m) }
func (*RegisterFrameworkMessage) ProtoMessage()    {}

func (m *RegisterFrameworkMessage) GetFramework() *FrameworkInfo {
	if m != nil {
		return m.Framework
	}
	return nil
}

type ReregisterFrameworkMessage struct {
	Framework        *FrameworkInfo `protobuf:"bytes,2,req,name=framework" json:"framework,omitempty"`
	Failover         *bool          `protobuf:"varint,3,req,name=failover" json:"failover,omitempty"`
	XXX_unrecognized []byte         `json:"-"`
}

func (m *ReregisterFrameworkMessage) Reset()         { *m = ReregisterFrameworkMessage{} }
func (m *ReregisterFrameworkMessage) String() string { return proto.CompactTextString(m) }
func (*ReregisterFrameworkMessage) ProtoMessage()    {}

func (m *ReregisterFrameworkMessage) GetFramework() *FrameworkInfo {
	if m != nil {
		return m.Framework
	}
	return nil
}

func (m *ReregisterFrameworkMessage) GetFailover() bool {
	if m != nil && m.Failover != nil {
		return *m.Failover
	}
	return false
}

type FrameworkRegisteredMessage struct {
	FrameworkId      *FrameworkID `protobuf:"bytes,1,req,name=framework_id" json:"framework_id,omitempty"`
	MasterInfo       *MasterInfo  `protobuf:"bytes,2,req,name=master_info" json:"master_info,omitempty"`
	XXX_unrecognized []byte       `json:"-"`
}

func (m *FrameworkRegisteredMessage) Reset()         { *m = FrameworkRegisteredMessage{} }
func (m *FrameworkRegisteredMessage) String() string { return proto.CompactTextString(m) }
func (*FrameworkRegisteredMessage) ProtoMessage()    {}

func (m *FrameworkRegisteredMessage) GetFrameworkId() *FrameworkID {
	if m != nil {
		return m.FrameworkId
	}
	return nil
}

func (m *FrameworkRegisteredMessage) GetMasterInfo() *MasterInfo {
	if m != nil {
		return m.MasterInfo
	}
	return nil
}

type FrameworkReregisteredMessage struct {
	FrameworkId      *FrameworkID `protobuf:"bytes,1,req,name=framework_id" json:"framework_id,omitempty"`
	MasterInfo       *MasterInfo  `protobuf:"bytes,2,req,name=master_info" json:"master_info,omitempty"`
	XXX_unrecognized []byte       `json:"-"`
}

func (m *FrameworkReregisteredMessage) Reset()         { *m = FrameworkReregisteredMessage{} }
func (m *FrameworkReregisteredMessage) String() string { return proto.CompactTextString(m) }
func (*FrameworkReregisteredMessage) ProtoMessage()    {}

func (m *FrameworkReregisteredMessage) GetFrameworkId() *FrameworkID {
	if m != nil {
		return m.FrameworkId
	}
	return nil
}

func (m *FrameworkReregisteredMessage) GetMasterInfo() *MasterInfo {
	if m != nil {
		return m.MasterInfo
	}
	return nil
}

type UnregisterFrameworkMessage struct {
	FrameworkId      *FrameworkID `protobuf:"bytes,1,req,name=framework_id" json:"framework_id,omitempty"`
	XXX_unrecognized []byte       `json:"-"`
}

func (m *UnregisterFrameworkMessage) Reset()         { *m = UnregisterFrameworkMessage{} }
func (m *UnregisterFrameworkMessage) String() string { return proto.CompactTextString(m) }
func (*UnregisterFrameworkMessage) ProtoMessage()    {}

func (m *UnregisterFrameworkMessage) GetFrameworkId() *FrameworkID {
	if m != nil {
		return m.FrameworkId
	}
	return nil
}

type DeactivateFrameworkMessage struct {
	FrameworkId      *FrameworkID `protobuf:"bytes,1,req,name=framework_id" json:"framework_id,omitempty"`
	XXX_unrecognized []byte       `json:"-"`
}

func (m *DeactivateFrameworkMessage) Reset()         { *m = DeactivateFrameworkMessage{} }
func (m *DeactivateFrameworkMessage) String() string { return proto.CompactTextString(m) }
func (*DeactivateFrameworkMessage) ProtoMessage()    {}

func (m *DeactivateFrameworkMessage) GetFrameworkId() *FrameworkID {
	if m != nil {
		return m.FrameworkId
	}
	return nil
}

type ResourceRequestMessage struct {
	FrameworkId      *FrameworkID `protobuf:"bytes,1,req,name=framework_id" json:"framework_id,omitempty"`
	Requests         []*Request   `protobuf:"bytes,2,rep,name=requests" json:"requests,omitempty"`
	XXX_unrecognized []byte       `json:"-"`
}

func (m *ResourceRequestMessage) Reset()         { *m = ResourceRequestMessage{} }
func (m *ResourceRequestMessage) String() string { return proto.CompactTextString(m) }
func (*ResourceRequestMessage) ProtoMessage()    {}

func (m *ResourceRequestMessage) GetFrameworkId() *FrameworkID {
	if m != nil {
		return m.FrameworkId
	}
	return nil
}

func (m *ResourceRequestMessage) GetRequests() []*Request {
	if m != nil {
		return m.Requests
	}
	return nil
}

type ResourceOffersMessage struct {
	Offers           []*Offer `protobuf:"bytes,1,rep,name=offers" json:"offers,omitempty"`
	Pids             []string `protobuf:"bytes,2,rep,name=pids" json:"pids,omitempty"`
	XXX_unrecognized []byte   `json:"-"`
}

func (m *ResourceOffersMessage) Reset()         { *m = ResourceOffersMessage{} }
func (m *ResourceOffersMessage) String() string { return proto.CompactTextString(m) }
func (*ResourceOffersMessage) ProtoMessage()    {}

func (m *ResourceOffersMessage) GetOffers() []*Offer {
	if m != nil {
		return m.Offers
	}
	return nil
}

func (m *ResourceOffersMessage) GetPids() []string {
	if m != nil {
		return m.Pids
	}
	return nil
}

type LaunchTasksMessage struct {
	FrameworkId      *FrameworkID `protobuf:"bytes,1,req,name=framework_id" json:"framework_id,omitempty"`
	Tasks            []*TaskInfo  `protobuf:"bytes,3,rep,name=tasks" json:"tasks,omitempty"`
	Filters          *Filters     `protobuf:"bytes,5,req,name=filters" json:"filters,omitempty"`
	OfferIds         []*OfferID   `protobuf:"bytes,6,rep,name=offer_ids" json:"offer_ids,omitempty"`
	XXX_unrecognized []byte       `json:"-"`
}

func (m *LaunchTasksMessage) Reset()         { *m = LaunchTasksMessage{} }
func (m *LaunchTasksMessage) String() string { return proto.CompactTextString(m) }
func (*LaunchTasksMessage) ProtoMessage()    {}

func (m *LaunchTasksMessage) GetFrameworkId() *FrameworkID {
	if m != nil {
		return m.FrameworkId
	}
	return nil
}

func (m *LaunchTasksMessage) GetTasks() []*TaskInfo {
	if m != nil {
		return m.Tasks
	}
	return nil
}

func (m *LaunchTasksMessage) GetFilters() *Filters {
	if m != nil {
		return m.Filters
	}
	return nil
}

func (m *LaunchTasksMessage) GetOfferIds() []*OfferID {
	if m != nil {
		return m.OfferIds
	}
	return nil
}

type RescindResourceOfferMessage struct {
	OfferId          *OfferID `protobuf:"bytes,1,req,name=offer_id" json:"offer_id,omitempty"`
	XXX_unrecognized []byte   `json:"-"`
}

func (m *RescindResourceOfferMessage) Reset()         { *m = RescindResourceOfferMessage{} }
func (m *RescindResourceOfferMessage) String() string { return proto.CompactTextString(m) }
func (*RescindResourceOfferMessage) ProtoMessage()    {}

func (m *RescindResourceOfferMessage) GetOfferId() *OfferID {
	if m != nil {
		return m.OfferId
	}
	return nil
}

type ReviveOffersMessage struct {
	FrameworkId      *FrameworkID `protobuf:"bytes,1,req,name=framework_id" json:"framework_id,omitempty"`
	XXX_unrecognized []byte       `json:"-"`
}

func (m *ReviveOffersMessage) Reset()         { *m = ReviveOffersMessage{} }
func (m *ReviveOffersMessage) String() string { return proto.CompactTextString(m) }
func (*ReviveOffersMessage) ProtoMessage()    {}

func (m *ReviveOffersMessage) GetFrameworkId() *FrameworkID {
	if m != nil {
		return m.FrameworkId
	}
	return nil
}

type RunTaskMessage struct {
	// TODO(karya): Remove framework_id after MESOS-2559 has shipped.
	FrameworkId      *FrameworkID   `protobuf:"bytes,1,opt,name=framework_id" json:"framework_id,omitempty"`
	Framework        *FrameworkInfo `protobuf:"bytes,2,req,name=framework" json:"framework,omitempty"`
	Pid              *string        `protobuf:"bytes,3,req,name=pid" json:"pid,omitempty"`
	Task             *TaskInfo      `protobuf:"bytes,4,req,name=task" json:"task,omitempty"`
	XXX_unrecognized []byte         `json:"-"`
}

func (m *RunTaskMessage) Reset()         { *m = RunTaskMessage{} }
func (m *RunTaskMessage) String() string { return proto.CompactTextString(m) }
func (*RunTaskMessage) ProtoMessage()    {}

func (m *RunTaskMessage) GetFrameworkId() *FrameworkID {
	if m != nil {
		return m.FrameworkId
	}
	return nil
}

func (m *RunTaskMessage) GetFramework() *FrameworkInfo {
	if m != nil {
		return m.Framework
	}
	return nil
}

func (m *RunTaskMessage) GetPid() string {
	if m != nil && m.Pid != nil {
		return *m.Pid
	}
	return ""
}

func (m *RunTaskMessage) GetTask() *TaskInfo {
	if m != nil {
		return m.Task
	}
	return nil
}

type KillTaskMessage struct {
	// TODO(bmahler): Include the SlaveID here to improve the Master's
	// ability to respond for non-activated slaves.
	FrameworkId      *FrameworkID `protobuf:"bytes,1,req,name=framework_id" json:"framework_id,omitempty"`
	TaskId           *TaskID      `protobuf:"bytes,2,req,name=task_id" json:"task_id,omitempty"`
	XXX_unrecognized []byte       `json:"-"`
}

func (m *KillTaskMessage) Reset()         { *m = KillTaskMessage{} }
func (m *KillTaskMessage) String() string { return proto.CompactTextString(m) }
func (*KillTaskMessage) ProtoMessage()    {}

func (m *KillTaskMessage) GetFrameworkId() *FrameworkID {
	if m != nil {
		return m.FrameworkId
	}
	return nil
}

func (m *KillTaskMessage) GetTaskId() *TaskID {
	if m != nil {
		return m.TaskId
	}
	return nil
}

// NOTE: If 'pid' is present, scheduler driver sends an
// acknowledgement to the pid.
type StatusUpdateMessage struct {
	Update           *StatusUpdate `protobuf:"bytes,1,req,name=update" json:"update,omitempty"`
	Pid              *string       `protobuf:"bytes,2,opt,name=pid" json:"pid,omitempty"`
	XXX_unrecognized []byte        `json:"-"`
}

func (m *StatusUpdateMessage) Reset()         { *m = StatusUpdateMessage{} }
func (m *StatusUpdateMessage) String() string { return proto.CompactTextString(m) }
func (*StatusUpdateMessage) ProtoMessage()    {}

func (m *StatusUpdateMessage) GetUpdate() *StatusUpdate {
	if m != nil {
		return m.Update
	}
	return nil
}

func (m *StatusUpdateMessage) GetPid() string {
	if m != nil && m.Pid != nil {
		return *m.Pid
	}
	return ""
}

type StatusUpdateAcknowledgementMessage struct {
	SlaveId          *SlaveID     `protobuf:"bytes,1,req,name=slave_id" json:"slave_id,omitempty"`
	FrameworkId      *FrameworkID `protobuf:"bytes,2,req,name=framework_id" json:"framework_id,omitempty"`
	TaskId           *TaskID      `protobuf:"bytes,3,req,name=task_id" json:"task_id,omitempty"`
	Uuid             []byte       `protobuf:"bytes,4,req,name=uuid" json:"uuid,omitempty"`
	XXX_unrecognized []byte       `json:"-"`
}

func (m *StatusUpdateAcknowledgementMessage) Reset()         { *m = StatusUpdateAcknowledgementMessage{} }
func (m *StatusUpdateAcknowledgementMessage) String() string { return proto.CompactTextString(m) }
func (*StatusUpdateAcknowledgementMessage) ProtoMessage()    {}

func (m *StatusUpdateAcknowledgementMessage) GetSlaveId() *SlaveID {
	if m != nil {
		return m.SlaveId
	}
	return nil
}

func (m *StatusUpdateAcknowledgementMessage) GetFrameworkId() *FrameworkID {
	if m != nil {
		return m.FrameworkId
	}
	return nil
}

func (m *StatusUpdateAcknowledgementMessage) GetTaskId() *TaskID {
	if m != nil {
		return m.TaskId
	}
	return nil
}

func (m *StatusUpdateAcknowledgementMessage) GetUuid() []byte {
	if m != nil {
		return m.Uuid
	}
	return nil
}

type LostSlaveMessage struct {
	SlaveId          *SlaveID `protobuf:"bytes,1,req,name=slave_id" json:"slave_id,omitempty"`
	XXX_unrecognized []byte   `json:"-"`
}

func (m *LostSlaveMessage) Reset()         { *m = LostSlaveMessage{} }
func (m *LostSlaveMessage) String() string { return proto.CompactTextString(m) }
func (*LostSlaveMessage) ProtoMessage()    {}

func (m *LostSlaveMessage) GetSlaveId() *SlaveID {
	if m != nil {
		return m.SlaveId
	}
	return nil
}

// Allows the framework to query the status for non-terminal tasks.
// This causes the master to send back the latest task status for
// each task in 'statuses', if possible. Tasks that are no longer
// known will result in a TASK_LOST update. If statuses is empty,
// then the master will send the latest status for each task
// currently known.
type ReconcileTasksMessage struct {
	FrameworkId      *FrameworkID  `protobuf:"bytes,1,req,name=framework_id" json:"framework_id,omitempty"`
	Statuses         []*TaskStatus `protobuf:"bytes,2,rep,name=statuses" json:"statuses,omitempty"`
	XXX_unrecognized []byte        `json:"-"`
}

func (m *ReconcileTasksMessage) Reset()         { *m = ReconcileTasksMessage{} }
func (m *ReconcileTasksMessage) String() string { return proto.CompactTextString(m) }
func (*ReconcileTasksMessage) ProtoMessage()    {}

func (m *ReconcileTasksMessage) GetFrameworkId() *FrameworkID {
	if m != nil {
		return m.FrameworkId
	}
	return nil
}

func (m *ReconcileTasksMessage) GetStatuses() []*TaskStatus {
	if m != nil {
		return m.Statuses
	}
	return nil
}

type FrameworkErrorMessage struct {
	Message          *string `protobuf:"bytes,2,req,name=message" json:"message,omitempty"`
	XXX_unrecognized []byte  `json:"-"`
}

func (m *FrameworkErrorMessage) Reset()         { *m = FrameworkErrorMessage{} }
func (m *FrameworkErrorMessage) String() string { return proto.CompactTextString(m) }
func (*FrameworkErrorMessage) ProtoMessage()    {}

func (m *FrameworkErrorMessage) GetMessage() string {
	if m != nil && m.Message != nil {
		return *m.Message
	}
	return ""
}

type RegisterSlaveMessage struct {
	Slave *SlaveInfo `protobuf:"bytes,1,req,name=slave" json:"slave,omitempty"`
	// Resources that are checkpointed by the slave (e.g., persistent
	// volume or dynamic reservation). Frameworks need to release
	// checkpointed resources explicitly.
	CheckpointedResources []*Resource `protobuf:"bytes,3,rep,name=checkpointed_resources" json:"checkpointed_resources,omitempty"`
	// NOTE: This is a hack for the master to detect the slave's
	// version. If unset the slave is < 0.21.0.
	// TODO(bmahler): Do proper versioning: MESOS-986.
	Version          *string `protobuf:"bytes,2,opt,name=version" json:"version,omitempty"`
	XXX_unrecognized []byte  `json:"-"`
}

func (m *RegisterSlaveMessage) Reset()         { *m = RegisterSlaveMessage{} }
func (m *RegisterSlaveMessage) String() string { return proto.CompactTextString(m) }
func (*RegisterSlaveMessage) ProtoMessage()    {}

func (m *RegisterSlaveMessage) GetSlave() *SlaveInfo {
	if m != nil {
		return m.Slave
	}
	return nil
}

func (m *RegisterSlaveMessage) GetCheckpointedResources() []*Resource {
	if m != nil {
		return m.CheckpointedResources
	}
	return nil
}

func (m *RegisterSlaveMessage) GetVersion() string {
	if m != nil && m.Version != nil {
		return *m.Version
	}
	return ""
}

type ReregisterSlaveMessage struct {
	Slave *SlaveInfo `protobuf:"bytes,2,req,name=slave" json:"slave,omitempty"`
	// Resources that are checkpointed by the slave (e.g., persistent
	// volume or dynamic reservation). Frameworks need to release
	// checkpointed resources explicitly.
	CheckpointedResources []*Resource          `protobuf:"bytes,7,rep,name=checkpointed_resources" json:"checkpointed_resources,omitempty"`
	ExecutorInfos         []*ExecutorInfo      `protobuf:"bytes,4,rep,name=executor_infos" json:"executor_infos,omitempty"`
	Tasks                 []*Task              `protobuf:"bytes,3,rep,name=tasks" json:"tasks,omitempty"`
	CompletedFrameworks   []*Archive_Framework `protobuf:"bytes,5,rep,name=completed_frameworks" json:"completed_frameworks,omitempty"`
	// NOTE: This is a hack for the master to detect the slave's
	// version. If unset the slave is < 0.21.0.
	// TODO(bmahler): Do proper versioning: MESOS-986.
	Version          *string `protobuf:"bytes,6,opt,name=version" json:"version,omitempty"`
	XXX_unrecognized []byte  `json:"-"`
}

func (m *ReregisterSlaveMessage) Reset()         { *m = ReregisterSlaveMessage{} }
func (m *ReregisterSlaveMessage) String() string { return proto.CompactTextString(m) }
func (*ReregisterSlaveMessage) ProtoMessage()    {}

func (m *ReregisterSlaveMessage) GetSlave() *SlaveInfo {
	if m != nil {
		return m.Slave
	}
	return nil
}

func (m *ReregisterSlaveMessage) GetCheckpointedResources() []*Resource {
	if m != nil {
		return m.CheckpointedResources
	}
	return nil
}

func (m *ReregisterSlaveMessage) GetExecutorInfos() []*ExecutorInfo {
	if m != nil {
		return m.ExecutorInfos
	}
	return nil
}

func (m *ReregisterSlaveMessage) GetTasks() []*Task {
	if m != nil {
		return m.Tasks
	}
	return nil
}

func (m *ReregisterSlaveMessage) GetCompletedFrameworks() []*Archive_Framework {
	if m != nil {
		return m.CompletedFrameworks
	}
	return nil
}

func (m *ReregisterSlaveMessage) GetVersion() string {
	if m != nil && m.Version != nil {
		return *m.Version
	}
	return ""
}

type SlaveRegisteredMessage struct {
	SlaveId          *SlaveID               `protobuf:"bytes,1,req,name=slave_id" json:"slave_id,omitempty"`
	Connection       *MasterSlaveConnection `protobuf:"bytes,2,opt,name=connection" json:"connection,omitempty"`
	XXX_unrecognized []byte                 `json:"-"`
}

func (m *SlaveRegisteredMessage) Reset()         { *m = SlaveRegisteredMessage{} }
func (m *SlaveRegisteredMessage) String() string { return proto.CompactTextString(m) }
func (*SlaveRegisteredMessage) ProtoMessage()    {}

func (m *SlaveRegisteredMessage) GetSlaveId() *SlaveID {
	if m != nil {
		return m.SlaveId
	}
	return nil
}

func (m *SlaveRegisteredMessage) GetConnection() *MasterSlaveConnection {
	if m != nil {
		return m.Connection
	}
	return nil
}

type SlaveReregisteredMessage struct {
	SlaveId          *SlaveID                 `protobuf:"bytes,1,req,name=slave_id" json:"slave_id,omitempty"`
	Reconciliations  []*ReconcileTasksMessage `protobuf:"bytes,2,rep,name=reconciliations" json:"reconciliations,omitempty"`
	Connection       *MasterSlaveConnection   `protobuf:"bytes,3,opt,name=connection" json:"connection,omitempty"`
	XXX_unrecognized []byte                   `json:"-"`
}

func (m *SlaveReregisteredMessage) Reset()         { *m = SlaveReregisteredMessage{} }
func (m *SlaveReregisteredMessage) String() string { return proto.CompactTextString(m) }
func (*SlaveReregisteredMessage) ProtoMessage()    {}

func (m *SlaveReregisteredMessage) GetSlaveId() *SlaveID {
	if m != nil {
		return m.SlaveId
	}
	return nil
}

func (m *SlaveReregisteredMessage) GetReconciliations() []*ReconcileTasksMessage {
	if m != nil {
		return m.Reconciliations
	}
	return nil
}

func (m *SlaveReregisteredMessage) GetConnection() *MasterSlaveConnection {
	if m != nil {
		return m.Connection
	}
	return nil
}

type UnregisterSlaveMessage struct {
	SlaveId          *SlaveID `protobuf:"bytes,1,req,name=slave_id" json:"slave_id,omitempty"`
	XXX_unrecognized []byte   `json:"-"`
}

func (m *UnregisterSlaveMessage) Reset()         { *m = UnregisterSlaveMessage{} }
func (m *UnregisterSlaveMessage) String() string { return proto.CompactTextString(m) }
func (*UnregisterSlaveMessage) ProtoMessage()    {}

func (m *UnregisterSlaveMessage) GetSlaveId() *SlaveID {
	if m != nil {
		return m.SlaveId
	}
	return nil
}

type MasterSlaveConnection struct {
	// Product of max_slave_ping_timeouts * slave_ping_timeout.
	// If no pings are received within the total timeout,
	// the master will remove the slave.
	TotalPingTimeoutSeconds *float64 `protobuf:"fixed64,1,opt,name=total_ping_timeout_seconds" json:"total_ping_timeout_seconds,omitempty"`
	XXX_unrecognized        []byte   `json:"-"`
}

func (m *MasterSlaveConnection) Reset()         { *m = MasterSlaveConnection{} }
func (m *MasterSlaveConnection) String() string { return proto.CompactTextString(m) }
func (*MasterSlaveConnection) ProtoMessage()    {}

func (m *MasterSlaveConnection) GetTotalPingTimeoutSeconds() float64 {
	if m != nil && m.TotalPingTimeoutSeconds != nil {
		return *m.TotalPingTimeoutSeconds
	}
	return 0
}

// This message is periodically sent by the master to the slave.
// If the slave is connected to the master, "connected" is true.
type PingSlaveMessage struct {
	Connected        *bool  `protobuf:"varint,1,req,name=connected" json:"connected,omitempty"`
	XXX_unrecognized []byte `json:"-"`
}

func (m *PingSlaveMessage) Reset()         { *m = PingSlaveMessage{} }
func (m *PingSlaveMessage) String() string { return proto.CompactTextString(m) }
func (*PingSlaveMessage) ProtoMessage()    {}

func (m *PingSlaveMessage) GetConnected() bool {
	if m != nil && m.Connected != nil {
		return *m.Connected
	}
	return false
}

// This message is sent by the slave to the master in response to the
// PingSlaveMessage.
type PongSlaveMessage struct {
	XXX_unrecognized []byte `json:"-"`
}

func (m *PongSlaveMessage) Reset()         { *m = PongSlaveMessage{} }
func (m *PongSlaveMessage) String() string { return proto.CompactTextString(m) }
func (*PongSlaveMessage) ProtoMessage()    {}

// Tells a slave to shut down all executors of the given framework.
type ShutdownFrameworkMessage struct {
	FrameworkId      *FrameworkID `protobuf:"bytes,1,req,name=framework_id" json:"framework_id,omitempty"`
	XXX_unrecognized []byte       `json:"-"`
}

func (m *ShutdownFrameworkMessage) Reset()         { *m = ShutdownFrameworkMessage{} }
func (m *ShutdownFrameworkMessage) String() string { return proto.CompactTextString(m) }
func (*ShutdownFrameworkMessage) ProtoMessage()    {}

func (m *ShutdownFrameworkMessage) GetFrameworkId() *FrameworkID {
	if m != nil {
		return m.FrameworkId
	}
	return nil
}

// Tells a slave (and consequently executor) to shutdown an executor.
type ShutdownExecutorMessage struct {
	// TODO(vinod): Make these fields required. These are made optional
	// for backwards compatibility between 0.23.0 slave and pre 0.23.0
	// executor driver.
	ExecutorId       *ExecutorID  `protobuf:"bytes,1,opt,name=executor_id" json:"executor_id,omitempty"`
	FrameworkId      *FrameworkID `protobuf:"bytes,2,opt,name=framework_id" json:"framework_id,omitempty"`
	XXX_unrecognized []byte       `json:"-"`
}

func (m *ShutdownExecutorMessage) Reset()         { *m = ShutdownExecutorMessage{} }
func (m *ShutdownExecutorMessage) String() string { return proto.CompactTextString(m) }
func (*ShutdownExecutorMessage) ProtoMessage()    {}

func (m *ShutdownExecutorMessage) GetExecutorId() *ExecutorID {
	if m != nil {
		return m.ExecutorId
	}
	return nil
}

func (m *ShutdownExecutorMessage) GetFrameworkId() *FrameworkID {
	if m != nil {
		return m.FrameworkId
	}
	return nil
}

type UpdateFrameworkMessage struct {
	FrameworkId      *FrameworkID `protobuf:"bytes,1,req,name=framework_id" json:"framework_id,omitempty"`
	Pid              *string      `protobuf:"bytes,2,req,name=pid" json:"pid,omitempty"`
	XXX_unrecognized []byte       `json:"-"`
}

func (m *UpdateFrameworkMessage) Reset()         { *m = UpdateFrameworkMessage{} }
func (m *UpdateFrameworkMessage) String() string { return proto.CompactTextString(m) }
func (*UpdateFrameworkMessage) ProtoMessage()    {}

func (m *UpdateFrameworkMessage) GetFrameworkId() *FrameworkID {
	if m != nil {
		return m.FrameworkId
	}
	return nil
}

func (m *UpdateFrameworkMessage) GetPid() string {
	if m != nil && m.Pid != nil {
		return *m.Pid
	}
	return ""
}

// This message is sent to the slave whenever there is an update of
// the resources that need to be checkpointed (e.g., persistent volume
// or dynamic reservation).
type CheckpointResourcesMessage struct {
	Resources        []*Resource `protobuf:"bytes,1,rep,name=resources" json:"resources,omitempty"`
	XXX_unrecognized []byte      `json:"-"`
}

func (m *CheckpointResourcesMessage) Reset()         { *m = CheckpointResourcesMessage{} }
func (m *CheckpointResourcesMessage) String() string { return proto.CompactTextString(m) }
func (*CheckpointResourcesMessage) ProtoMessage()    {}

func (m *CheckpointResourcesMessage) GetResources() []*Resource {
	if m != nil {
		return m.Resources
	}
	return nil
}

// This message is sent by the slave to the master to inform the
// master about the total amount of oversubscribed (allocated and
// allocatable) resources.
type UpdateSlaveMessage struct {
	SlaveId                 *SlaveID    `protobuf:"bytes,1,req,name=slave_id" json:"slave_id,omitempty"`
	OversubscribedResources []*Resource `protobuf:"bytes,2,rep,name=oversubscribed_resources" json:"oversubscribed_resources,omitempty"`
	XXX_unrecognized        []byte      `json:"-"`
}

func (m *UpdateSlaveMessage) Reset()         { *m = UpdateSlaveMessage{} }
func (m *UpdateSlaveMessage) String() string { return proto.CompactTextString(m) }
func (*UpdateSlaveMessage) ProtoMessage()    {}

func (m *UpdateSlaveMessage) GetSlaveId() *SlaveID {
	if m != nil {
		return m.SlaveId
	}
	return nil
}

func (m *UpdateSlaveMessage) GetOversubscribedResources() []*Resource {
	if m != nil {
		return m.OversubscribedResources
	}
	return nil
}

type RegisterExecutorMessage struct {
	FrameworkId      *FrameworkID `protobuf:"bytes,1,req,name=framework_id" json:"framework_id,omitempty"`
	ExecutorId       *ExecutorID  `protobuf:"bytes,2,req,name=executor_id" json:"executor_id,omitempty"`
	XXX_unrecognized []byte       `json:"-"`
}

func (m *RegisterExecutorMessage) Reset()         { *m = RegisterExecutorMessage{} }
func (m *RegisterExecutorMessage) String() string { return proto.CompactTextString(m) }
func (*RegisterExecutorMessage) ProtoMessage()    {}

func (m *RegisterExecutorMessage) GetFrameworkId() *FrameworkID {
	if m != nil {
		return m.FrameworkId
	}
	return nil
}

func (m *RegisterExecutorMessage) GetExecutorId() *ExecutorID {
	if m != nil {
		return m.ExecutorId
	}
	return nil
}

type ExecutorRegisteredMessage struct {
	ExecutorInfo     *ExecutorInfo  `protobuf:"bytes,2,req,name=executor_info" json:"executor_info,omitempty"`
	FrameworkId      *FrameworkID   `protobuf:"bytes,3,req,name=framework_id" json:"framework_id,omitempty"`
	FrameworkInfo    *FrameworkInfo `protobuf:"bytes,4,req,name=framework_info" json:"framework_info,omitempty"`
	SlaveId          *SlaveID       `protobuf:"bytes,5,req,name=slave_id" json:"slave_id,omitempty"`
	SlaveInfo        *SlaveInfo     `protobuf:"bytes,6,req,name=slave_info" json:"slave_info,omitempty"`
	XXX_unrecognized []byte         `json:"-"`
}

func (m *ExecutorRegisteredMessage) Reset()         { *m = ExecutorRegisteredMessage{} }
func (m *ExecutorRegisteredMessage) String() string { return proto.CompactTextString(m) }
func (*ExecutorRegisteredMessage) ProtoMessage()    {}

func (m *ExecutorRegisteredMessage) GetExecutorInfo() *ExecutorInfo {
	if m != nil {
		return m.ExecutorInfo
	}
	return nil
}

func (m *ExecutorRegisteredMessage) GetFrameworkId() *FrameworkID {
	if m != nil {
		return m.FrameworkId
	}
	return nil
}

func (m *ExecutorRegisteredMessage) GetFrameworkInfo() *FrameworkInfo {
	if m != nil {
		return m.FrameworkInfo
	}
	return nil
}

func (m *ExecutorRegisteredMessage) GetSlaveId() *SlaveID {
	if m != nil {
		return m.SlaveId
	}
	return nil
}

func (m *ExecutorRegisteredMessage) GetSlaveInfo() *SlaveInfo {
	if m != nil {
		return m.SlaveInfo
	}
	return nil
}

type ExecutorReregisteredMessage struct {
	SlaveId          *SlaveID   `protobuf:"bytes,1,req,name=slave_id" json:"slave_id,omitempty"`
	SlaveInfo        *SlaveInfo `protobuf:"bytes,2,req,name=slave_info" json:"slave_info,omitempty"`
	XXX_unrecognized []byte     `json:"-"`
}

func (m *ExecutorReregisteredMessage) Reset()         { *m = ExecutorReregisteredMessage{} }
func (m *ExecutorReregisteredMessage) String() string { return proto.CompactTextString(m) }
func (*ExecutorReregisteredMessage) ProtoMessage()    {}

func (m *ExecutorReregisteredMessage) GetSlaveId() *SlaveID {
	if m != nil {
		return m.SlaveId
	}
	return nil
}

func (m *ExecutorReregisteredMessage) GetSlaveInfo() *SlaveInfo {
	if m != nil {
		return m.SlaveInfo
	}
	return nil
}

type ExitedExecutorMessage struct {
	SlaveId          *SlaveID     `protobuf:"bytes,1,req,name=slave_id" json:"slave_id,omitempty"`
	FrameworkId      *FrameworkID `protobuf:"bytes,2,req,name=framework_id" json:"framework_id,omitempty"`
	ExecutorId       *ExecutorID  `protobuf:"bytes,3,req,name=executor_id" json:"executor_id,omitempty"`
	Status           *int32       `protobuf:"varint,4,req,name=status" json:"status,omitempty"`
	XXX_unrecognized []byte       `json:"-"`
}

func (m *ExitedExecutorMessage) Reset()         { *m = ExitedExecutorMessage{} }
func (m *ExitedExecutorMessage) String() string { return proto.CompactTextString(m) }
func (*ExitedExecutorMessage) ProtoMessage()    {}

func (m *ExitedExecutorMessage) GetSlaveId() *SlaveID {
	if m != nil {
		return m.SlaveId
	}
	return nil
}

func (m *ExitedExecutorMessage) GetFrameworkId() *FrameworkID {
	if m != nil {
		return m.FrameworkId
	}
	return nil
}

func (m *ExitedExecutorMessage) GetExecutorId() *ExecutorID {
	if m != nil {
		return m.ExecutorId
	}
	return nil
}

func (m *ExitedExecutorMessage) GetStatus() int32 {
	if m != nil && m.Status != nil {
		return *m.Status
	}
	return 0
}

type ReconnectExecutorMessage struct {
	SlaveId          *SlaveID `protobuf:"bytes,1,req,name=slave_id" json:"slave_id,omitempty"`
	XXX_unrecognized []byte   `json:"-"`
}

func (m *ReconnectExecutorMessage) Reset()         { *m = ReconnectExecutorMessage{} }
func (m *ReconnectExecutorMessage) String() string { return proto.CompactTextString(m) }
func (*ReconnectExecutorMessage) ProtoMessage()    {}

func (m *ReconnectExecutorMessage) GetSlaveId() *SlaveID {
	if m != nil {
		return m.SlaveId
	}
	return nil
}

type ReregisterExecutorMessage struct {
	ExecutorId       *ExecutorID     `protobuf:"bytes,1,req,name=executor_id" json:"executor_id,omitempty"`
	FrameworkId      *FrameworkID    `protobuf:"bytes,2,req,name=framework_id" json:"framework_id,omitempty"`
	Tasks            []*TaskInfo     `protobuf:"bytes,3,rep,name=tasks" json:"tasks,omitempty"`
	Updates          []*StatusUpdate `protobuf:"bytes,4,rep,name=updates" json:"updates,omitempty"`
	XXX_unrecognized []byte          `json:"-"`
}

func (m *ReregisterExecutorMessage) Reset()         { *m = ReregisterExecutorMessage{} }
func (m *ReregisterExecutorMessage) String() string { return proto.CompactTextString(m) }
func (*ReregisterExecutorMessage) ProtoMessage()    {}

func (m *ReregisterExecutorMessage) GetExecutorId() *ExecutorID {
	if m != nil {
		return m.ExecutorId
	}
	return nil
}

func (m *ReregisterExecutorMessage) GetFrameworkId() *FrameworkID {
	if m != nil {
		return m.FrameworkId
	}
	return nil
}

func (m *ReregisterExecutorMessage) GetTasks() []*TaskInfo {
	if m != nil {
		return m.Tasks
	}
	return nil
}

func (m *ReregisterExecutorMessage) GetUpdates() []*StatusUpdate {
	if m != nil {
		return m.Updates
	}
	return nil
}

type ShutdownMessage struct {
	Message          *string `protobuf:"bytes,1,opt,name=message" json:"message,omitempty"`
	XXX_unrecognized []byte  `json:"-"`
}

func (m *ShutdownMessage) Reset()         { *m = ShutdownMessage{} }
func (m *ShutdownMessage) String() string { return proto.CompactTextString(m) }
func (*ShutdownMessage) ProtoMessage()    {}

func (m *ShutdownMessage) GetMessage() string {
	if m != nil && m.Message != nil {
		return *m.Message
	}
	return ""
}

// *
// Describes Completed Frameworks, etc. for archival.
type Archive struct {
	Frameworks       []*Archive_Framework `protobuf:"bytes,1,rep,name=frameworks" json:"frameworks,omitempty"`
	XXX_unrecognized []byte               `json:"-"`
}

func (m *Archive) Reset()         { *m = Archive{} }
func (m *Archive) String() string { return proto.CompactTextString(m) }
func (*Archive) ProtoMessage()    {}

func (m *Archive) GetFrameworks() []*Archive_Framework {
	if m != nil {
		return m.Frameworks
	}
	return nil
}

type Archive_Framework struct {
	FrameworkInfo    *FrameworkInfo `protobuf:"bytes,1,req,name=framework_info" json:"framework_info,omitempty"`
	Pid              *string        `protobuf:"bytes,2,opt,name=pid" json:"pid,omitempty"`
	Tasks            []*Task        `protobuf:"bytes,3,rep,name=tasks" json:"tasks,omitempty"`
	XXX_unrecognized []byte         `json:"-"`
}

func (m *Archive_Framework) Reset()         { *m = Archive_Framework{} }
func (m *Archive_Framework) String() string { return proto.CompactTextString(m) }
func (*Archive_Framework) ProtoMessage()    {}

func (m *Archive_Framework) GetFrameworkInfo() *FrameworkInfo {
	if m != nil {
		return m.FrameworkInfo
	}
	return nil
}

func (m *Archive_Framework) GetPid() string {
	if m != nil && m.Pid != nil {
		return *m.Pid
	}
	return ""
}

func (m *Archive_Framework) GetTasks() []*Task {
	if m != nil {
		return m.Tasks
	}
	return nil
}

// Message describing task current health status that is sent by
// the task health checker to the command executor.
// The command executor reports the task status back to the
// on each receive. If the health checker configured faiure
// condition meets, then kill_task flag will be set to true which
// the executor on message receive will kill the task.
type TaskHealthStatus struct {
	TaskId  *TaskID `protobuf:"bytes,1,req,name=task_id" json:"task_id,omitempty"`
	Healthy *bool   `protobuf:"varint,2,req,name=healthy" json:"healthy,omitempty"`
	// Flag to initiate task kill.
	KillTask *bool `protobuf:"varint,3,opt,name=kill_task,def=0" json:"kill_task,omitempty"`
	// Number of consecutive counts in current status.
	// This will not be populated if task is healthy.
	ConsecutiveFailures *int32 `protobuf:"varint,4,opt,name=consecutive_failures" json:"consecutive_failures,omitempty"`
	XXX_unrecognized    []byte `json:"-"`
}

func (m *TaskHealthStatus) Reset()         { *m = TaskHealthStatus{} }
func (m *TaskHealthStatus) String() string { return proto.CompactTextString(m) }
func (*TaskHealthStatus) ProtoMessage()    {}

const Default_TaskHealthStatus_KillTask bool = false

func (m *TaskHealthStatus) GetTaskId() *TaskID {
	if m != nil {
		return m.TaskId
	}
	return nil
}

func (m *TaskHealthStatus) GetHealthy() bool {
	if m != nil && m.Healthy != nil {
		return *m.Healthy
	}
	return false
}

func (m *TaskHealthStatus) GetKillTask() bool {
	if m != nil && m.KillTask != nil {
		return *m.KillTask
	}
	return Default_TaskHealthStatus_KillTask
}

func (m *TaskHealthStatus) GetConsecutiveFailures() int32 {
	if m != nil && m.ConsecutiveFailures != nil {
		return *m.ConsecutiveFailures
	}
	return 0
}

// *
// Message to signal completion of an event within a module.
type HookExecuted struct {
	Module           *string `protobuf:"bytes,1,opt,name=module" json:"module,omitempty"`
	XXX_unrecognized []byte  `json:"-"`
}

func (m *HookExecuted) Reset()         { *m = HookExecuted{} }
func (m *HookExecuted) String() string { return proto.CompactTextString(m) }
func (*HookExecuted) ProtoMessage()    {}

func (m *HookExecuted) GetModule() string {
	if m != nil && m.Module != nil {
		return *m.Module
	}
	return ""
}

func init() {
	proto.RegisterEnum("mesosproto.StatusUpdateRecord_Type", StatusUpdateRecord_Type_name, StatusUpdateRecord_Type_value)
}
