# .NET Home

This repository is a starting point to learn about and engage in .NET and .NET open source projects.

This repo is not an official .NET Framework support location, however, we will respond to issues filed here as best we can. Please file .NET Core product issues at [dotnet/core](https://github.com/dotnet/core/issues) and ASP.NET Core product issues at [aspnet/home](https://github.com/aspnet/home/issues).

You can try out the [.NET Framework 4.7.1](https://github.com/Microsoft/dotnet/blob/master/releases/net471/README.md) at the [.NET Framework Early Access](https://github.com/microsoft/dotnet-framework-early-access) site.

## In this repository

- [.NET Framework Release Notes](releases/README.md)
- [.NET Framework Documentation](Documentation/README.md)
- [.NET Open Source Developer Projects](dotnet-developer-projects.md)
- [.NET Open Source Consumer Projects](dotnet-consumer-projects.md)
- [Free Services & Tools for Open Source .NET Projects](dotnet-free-oss-services.md)

Please contribute to this repository via [pull requests](https://github.com/Microsoft/dotnet/pulls)

## Finding .NET Open Source Projects

Here are some excellent community-maintained lists of projects:

- [Awesome .NET!](https://github.com/quozd/awesome-dotnet)
- [ASP.NET Core Library and Framework Support](https://github.com/jpsingleton/ANCLAFS)

There are many projects that you can use and contribute to, some of which are listed below. Please do contribute to these projects!

### .NET Core

- [.NET Core (dotnet/core)](https://github.com/dotnet/core)
- [.NET Core docs (dotnet/docs)](https://github.com/dotnet/docs)
- [ASP.NET Core (aspnet/home)](https://github.com/aspnet/home)
- [ASP.NET Core docs (aspnet/Docs)](https://github.com/aspnet/Docs)
- [Roslyn Compiler Platform (dotnet/roslyn)](https://github.com/dotnet/roslyn)
- [EntityFramework (aspnet/entityframework)](https://github.com/aspnet/EntityFramework)

### .NET Framework

- [.NET Framework docs (dotnet/docs)](https://github.com/dotnet/docs)
- [.NET Framework source code - read-only subset (microsoft/referencesource)](https://github.com/microsoft/referencesource)

### Xamarin

- [Xamarin iOS + macOS (xamarin-macios)](https://github.com/xamarin/xamarin-macios)
- [Xamarin Android (xamarin/xamarin-android)](https://github.com/xamarin/xamarin-android)
- [Xamarin Forms (xamarin/Xamarin.Forms)](https://github.com/xamarin/Xamarin.Forms)
- [Mono Project](https://github.com/mono/)

### Community

Here is a short list of projects to check out:

* [Orleans](https://github.com/dotnet/orleans)
* [Exceptionless](https://github.com/exceptionless/Exceptionless)
* [Glimpse](https://github.com/Glimpse/Glimpse)
* [JSON.NET](https://github.com/JamesNK/Newtonsoft.Json)
* [Mobius: C# API for Apache Spark](https://github.com/Microsoft/Mobius)
* [MonoGame](https://github.com/MonoGame/MonoGame)
* [MVVM Cross](https://github.com/MvvmCross/MvvmCross)
* [ReactiveUI](https://github.com/reactiveui/ReactiveUI)

There are additional templates available for `dotnet new`. For more info see [Available templates for dotnet new](https://github.com/dotnet/templating/wiki/Available-templates-for-dotnet-new)

## .NET Foundation

Many .NET open source projects are part of the
[.NET Foundation](http://www.dotnetfoundation.org/projects). Microsoft has contributed many projects, including ASP.NET Core and 
.NET Core. You may want to consider [joining the .NET Foundation](https://dotnetfoundation.org/get-involved).

Check out the [.NET Foundation Forums](http://forums.dotnetfoundation.org/) to see what others are talking about or start a new discussion to ask a question or make a point. 

## License

This repository is licensed with the [MIT](LICENSE) license.
