// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package databasemigrationservice_test

import (
	"fmt"
	"strings"
	"time"

	"github.com/aws/aws-sdk-go/aws"
	"github.com/aws/aws-sdk-go/aws/awserr"
	"github.com/aws/aws-sdk-go/aws/session"
	"github.com/aws/aws-sdk-go/service/databasemigrationservice"
)

var _ time.Duration
var _ strings.Reader
var _ aws.Config

func parseTime(layout, value string) *time.Time {
	t, err := time.Parse(layout, value)
	if err != nil {
		panic(err)
	}
	return &t
}

// Add tags to resource
// Adds metadata tags to an AWS DMS resource, including replication instance, endpoint,
// security group, and migration task. These tags can also be used with cost allocation
// reporting to track cost associated with AWS DMS resources, or used in a Condition
// statement in an IAM policy for AWS DMS.
func ExampleDatabaseMigrationService_AddTagsToResource_shared00() {
	svc := databasemigrationservice.New(session.New())
	input := &databasemigrationservice.AddTagsToResourceInput{
		ResourceArn: aws.String("arn:aws:dms:us-east-1:123456789012:endpoint:ASXWXJZLNWNT5HTWCGV2BUJQ7E"),
		Tags: []*databasemigrationservice.Tag{
			{
				Key:   aws.String("Acount"),
				Value: aws.String("1633456"),
			},
		},
	}

	result, err := svc.AddTagsToResource(input)
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			case databasemigrationservice.ErrCodeResourceNotFoundFault:
				fmt.Println(databasemigrationservice.ErrCodeResourceNotFoundFault, aerr.Error())
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// Create Data Provider
// Creates the data provider with the specified parameters.
func ExampleDatabaseMigrationService_CreateDataProvider_shared00() {
	svc := databasemigrationservice.New(session.New())
	input := &databasemigrationservice.CreateDataProviderInput{
		DataProviderName: aws.String("sqlServer-dev"),
		Description:      aws.String("description"),
		Engine:           aws.String("sqlserver"),
		Settings: &databasemigrationservice.DataProviderSettings{
			MicrosoftSqlServerSettings: &databasemigrationservice.MicrosoftSqlServerDataProviderSettings{
				DatabaseName: aws.String("DatabaseName"),
				Port:         aws.Int64(11112),
				ServerName:   aws.String("ServerName2"),
				SslMode:      aws.String("none"),
			},
		},
		Tags: []*databasemigrationservice.Tag{
			{
				Key:   aws.String("access"),
				Value: aws.String("authorizedusers"),
			},
		},
	}

	result, err := svc.CreateDataProvider(input)
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			case databasemigrationservice.ErrCodeResourceQuotaExceededFault:
				fmt.Println(databasemigrationservice.ErrCodeResourceQuotaExceededFault, aerr.Error())
			case databasemigrationservice.ErrCodeAccessDeniedFault:
				fmt.Println(databasemigrationservice.ErrCodeAccessDeniedFault, aerr.Error())
			case databasemigrationservice.ErrCodeResourceAlreadyExistsFault:
				fmt.Println(databasemigrationservice.ErrCodeResourceAlreadyExistsFault, aerr.Error())
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// Create endpoint
// Creates an endpoint using the provided settings.
func ExampleDatabaseMigrationService_CreateEndpoint_shared00() {
	svc := databasemigrationservice.New(session.New())
	input := &databasemigrationservice.CreateEndpointInput{
		CertificateArn:            aws.String(""),
		DatabaseName:              aws.String("testdb"),
		EndpointIdentifier:        aws.String("test-endpoint-1"),
		EndpointType:              aws.String("source"),
		EngineName:                aws.String("mysql"),
		ExtraConnectionAttributes: aws.String(""),
		KmsKeyId:                  aws.String("arn:aws:kms:us-east-1:123456789012:key/4c1731d6-5435-ed4d-be13-d53411a7cfbd"),
		Password:                  aws.String("pasword"),
		Port:                      aws.Int64(3306),
		ServerName:                aws.String("mydb.cx1llnox7iyx.us-west-2.rds.amazonaws.com"),
		SslMode:                   aws.String("require"),
		Tags: []*databasemigrationservice.Tag{
			{
				Key:   aws.String("Acount"),
				Value: aws.String("143327655"),
			},
		},
		Username: aws.String("username"),
	}

	result, err := svc.CreateEndpoint(input)
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			case databasemigrationservice.ErrCodeKMSKeyNotAccessibleFault:
				fmt.Println(databasemigrationservice.ErrCodeKMSKeyNotAccessibleFault, aerr.Error())
			case databasemigrationservice.ErrCodeResourceAlreadyExistsFault:
				fmt.Println(databasemigrationservice.ErrCodeResourceAlreadyExistsFault, aerr.Error())
			case databasemigrationservice.ErrCodeResourceQuotaExceededFault:
				fmt.Println(databasemigrationservice.ErrCodeResourceQuotaExceededFault, aerr.Error())
			case databasemigrationservice.ErrCodeInvalidResourceStateFault:
				fmt.Println(databasemigrationservice.ErrCodeInvalidResourceStateFault, aerr.Error())
			case databasemigrationservice.ErrCodeResourceNotFoundFault:
				fmt.Println(databasemigrationservice.ErrCodeResourceNotFoundFault, aerr.Error())
			case databasemigrationservice.ErrCodeAccessDeniedFault:
				fmt.Println(databasemigrationservice.ErrCodeAccessDeniedFault, aerr.Error())
			case databasemigrationservice.ErrCodeS3AccessDeniedFault:
				fmt.Println(databasemigrationservice.ErrCodeS3AccessDeniedFault, aerr.Error())
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// Create Instance Profile
// Creates the instance profile using the specified parameters.
func ExampleDatabaseMigrationService_CreateInstanceProfile_shared00() {
	svc := databasemigrationservice.New(session.New())
	input := &databasemigrationservice.CreateInstanceProfileInput{
		Description:           aws.String("Description"),
		InstanceProfileName:   aws.String("my-instance-profile"),
		KmsKeyArn:             aws.String("arn:aws:kms:us-east-1:012345678901:key/01234567-89ab-cdef-0123-456789abcdef"),
		NetworkType:           aws.String("DUAL"),
		PubliclyAccessible:    aws.Bool(true),
		SubnetGroupIdentifier: aws.String("my-subnet-group"),
		Tags: []*databasemigrationservice.Tag{
			{
				Key:   aws.String("access"),
				Value: aws.String("authorizedusers"),
			},
		},
	}

	result, err := svc.CreateInstanceProfile(input)
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			case databasemigrationservice.ErrCodeAccessDeniedFault:
				fmt.Println(databasemigrationservice.ErrCodeAccessDeniedFault, aerr.Error())
			case databasemigrationservice.ErrCodeResourceAlreadyExistsFault:
				fmt.Println(databasemigrationservice.ErrCodeResourceAlreadyExistsFault, aerr.Error())
			case databasemigrationservice.ErrCodeResourceNotFoundFault:
				fmt.Println(databasemigrationservice.ErrCodeResourceNotFoundFault, aerr.Error())
			case databasemigrationservice.ErrCodeResourceQuotaExceededFault:
				fmt.Println(databasemigrationservice.ErrCodeResourceQuotaExceededFault, aerr.Error())
			case databasemigrationservice.ErrCodeInvalidResourceStateFault:
				fmt.Println(databasemigrationservice.ErrCodeInvalidResourceStateFault, aerr.Error())
			case databasemigrationservice.ErrCodeKMSKeyNotAccessibleFault:
				fmt.Println(databasemigrationservice.ErrCodeKMSKeyNotAccessibleFault, aerr.Error())
			case databasemigrationservice.ErrCodeS3ResourceNotFoundFault:
				fmt.Println(databasemigrationservice.ErrCodeS3ResourceNotFoundFault, aerr.Error())
			case databasemigrationservice.ErrCodeS3AccessDeniedFault:
				fmt.Println(databasemigrationservice.ErrCodeS3AccessDeniedFault, aerr.Error())
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// Create Migration Project
// Creates the migration project with the specified parameters.
func ExampleDatabaseMigrationService_CreateMigrationProject_shared00() {
	svc := databasemigrationservice.New(session.New())
	input := &databasemigrationservice.CreateMigrationProjectInput{
		Description:               aws.String("description"),
		InstanceProfileIdentifier: aws.String("ip-au-17"),
		MigrationProjectName:      aws.String("my-migration-project"),
		SchemaConversionApplicationAttributes: &databasemigrationservice.SCApplicationAttributes{
			S3BucketPath:    aws.String("arn:aws:s3:::mylogin-bucket"),
			S3BucketRoleArn: aws.String("arn:aws:iam::012345678901:role/Admin"),
		},
		SourceDataProviderDescriptors: []*databasemigrationservice.DataProviderDescriptorDefinition{
			{
				DataProviderIdentifier:      aws.String("arn:aws:dms:us-east-1:012345678901:data-provider:EXAMPLEABCDEFGHIJKLMNOPQRSTUVWXYZ012345"),
				SecretsManagerAccessRoleArn: aws.String("arn:aws:iam::012345678901:role/myuser-admin-access"),
				SecretsManagerSecretId:      aws.String("arn:aws:secretsmanager:us-east-1:012345678901:secret:myorg/example1/ALL.SOURCE.ORACLE_12-A1B2C3"),
			},
		},
		Tags: []*databasemigrationservice.Tag{
			{
				Key:   aws.String("access"),
				Value: aws.String("authorizedusers"),
			},
		},
		TargetDataProviderDescriptors: []*databasemigrationservice.DataProviderDescriptorDefinition{
			{
				DataProviderIdentifier:      aws.String("arn:aws:dms:us-east-1:012345678901:data-provider:EXAMPLEABCDEFGHIJKLMNOPQRSTUVWXYZ012345"),
				SecretsManagerAccessRoleArn: aws.String("arn:aws:iam::012345678901:role/myuser-admin-access"),
				SecretsManagerSecretId:      aws.String("arn:aws:secretsmanager:us-east-1:012345678901:secret:myorg/example1/TARGET.postgresql-A1B2C3"),
			},
		},
		TransformationRules: aws.String("{\"key0\":\"value0\",\"key1\":\"value1\",\"key2\":\"value2\"}"),
	}

	result, err := svc.CreateMigrationProject(input)
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			case databasemigrationservice.ErrCodeAccessDeniedFault:
				fmt.Println(databasemigrationservice.ErrCodeAccessDeniedFault, aerr.Error())
			case databasemigrationservice.ErrCodeResourceAlreadyExistsFault:
				fmt.Println(databasemigrationservice.ErrCodeResourceAlreadyExistsFault, aerr.Error())
			case databasemigrationservice.ErrCodeResourceQuotaExceededFault:
				fmt.Println(databasemigrationservice.ErrCodeResourceQuotaExceededFault, aerr.Error())
			case databasemigrationservice.ErrCodeResourceNotFoundFault:
				fmt.Println(databasemigrationservice.ErrCodeResourceNotFoundFault, aerr.Error())
			case databasemigrationservice.ErrCodeS3ResourceNotFoundFault:
				fmt.Println(databasemigrationservice.ErrCodeS3ResourceNotFoundFault, aerr.Error())
			case databasemigrationservice.ErrCodeS3AccessDeniedFault:
				fmt.Println(databasemigrationservice.ErrCodeS3AccessDeniedFault, aerr.Error())
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// Create replication instance
// Creates the replication instance using the specified parameters.
func ExampleDatabaseMigrationService_CreateReplicationInstance_shared00() {
	svc := databasemigrationservice.New(session.New())
	input := &databasemigrationservice.CreateReplicationInstanceInput{
		AllocatedStorage:                 aws.Int64(123),
		AutoMinorVersionUpgrade:          aws.Bool(true),
		AvailabilityZone:                 aws.String(""),
		EngineVersion:                    aws.String(""),
		KmsKeyId:                         aws.String(""),
		MultiAZ:                          aws.Bool(true),
		PreferredMaintenanceWindow:       aws.String(""),
		PubliclyAccessible:               aws.Bool(true),
		ReplicationInstanceClass:         aws.String(""),
		ReplicationInstanceIdentifier:    aws.String(""),
		ReplicationSubnetGroupIdentifier: aws.String(""),
		Tags: []*databasemigrationservice.Tag{
			{
				Key:   aws.String("string"),
				Value: aws.String("string"),
			},
		},
	}

	result, err := svc.CreateReplicationInstance(input)
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			case databasemigrationservice.ErrCodeAccessDeniedFault:
				fmt.Println(databasemigrationservice.ErrCodeAccessDeniedFault, aerr.Error())
			case databasemigrationservice.ErrCodeResourceAlreadyExistsFault:
				fmt.Println(databasemigrationservice.ErrCodeResourceAlreadyExistsFault, aerr.Error())
			case databasemigrationservice.ErrCodeInsufficientResourceCapacityFault:
				fmt.Println(databasemigrationservice.ErrCodeInsufficientResourceCapacityFault, aerr.Error())
			case databasemigrationservice.ErrCodeResourceQuotaExceededFault:
				fmt.Println(databasemigrationservice.ErrCodeResourceQuotaExceededFault, aerr.Error())
			case databasemigrationservice.ErrCodeStorageQuotaExceededFault:
				fmt.Println(databasemigrationservice.ErrCodeStorageQuotaExceededFault, aerr.Error())
			case databasemigrationservice.ErrCodeResourceNotFoundFault:
				fmt.Println(databasemigrationservice.ErrCodeResourceNotFoundFault, aerr.Error())
			case databasemigrationservice.ErrCodeReplicationSubnetGroupDoesNotCoverEnoughAZs:
				fmt.Println(databasemigrationservice.ErrCodeReplicationSubnetGroupDoesNotCoverEnoughAZs, aerr.Error())
			case databasemigrationservice.ErrCodeInvalidResourceStateFault:
				fmt.Println(databasemigrationservice.ErrCodeInvalidResourceStateFault, aerr.Error())
			case databasemigrationservice.ErrCodeInvalidSubnet:
				fmt.Println(databasemigrationservice.ErrCodeInvalidSubnet, aerr.Error())
			case databasemigrationservice.ErrCodeKMSKeyNotAccessibleFault:
				fmt.Println(databasemigrationservice.ErrCodeKMSKeyNotAccessibleFault, aerr.Error())
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// Create replication subnet group
// Creates a replication subnet group given a list of the subnet IDs in a VPC.
func ExampleDatabaseMigrationService_CreateReplicationSubnetGroup_shared00() {
	svc := databasemigrationservice.New(session.New())
	input := &databasemigrationservice.CreateReplicationSubnetGroupInput{
		ReplicationSubnetGroupDescription: aws.String("US West subnet group"),
		ReplicationSubnetGroupIdentifier:  aws.String("us-west-2ab-vpc-215ds366"),
		SubnetIds: []*string{
			aws.String("subnet-e145356n"),
			aws.String("subnet-58f79200"),
		},
		Tags: []*databasemigrationservice.Tag{
			{
				Key:   aws.String("Acount"),
				Value: aws.String("145235"),
			},
		},
	}

	result, err := svc.CreateReplicationSubnetGroup(input)
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			case databasemigrationservice.ErrCodeAccessDeniedFault:
				fmt.Println(databasemigrationservice.ErrCodeAccessDeniedFault, aerr.Error())
			case databasemigrationservice.ErrCodeResourceAlreadyExistsFault:
				fmt.Println(databasemigrationservice.ErrCodeResourceAlreadyExistsFault, aerr.Error())
			case databasemigrationservice.ErrCodeResourceNotFoundFault:
				fmt.Println(databasemigrationservice.ErrCodeResourceNotFoundFault, aerr.Error())
			case databasemigrationservice.ErrCodeResourceQuotaExceededFault:
				fmt.Println(databasemigrationservice.ErrCodeResourceQuotaExceededFault, aerr.Error())
			case databasemigrationservice.ErrCodeReplicationSubnetGroupDoesNotCoverEnoughAZs:
				fmt.Println(databasemigrationservice.ErrCodeReplicationSubnetGroupDoesNotCoverEnoughAZs, aerr.Error())
			case databasemigrationservice.ErrCodeInvalidSubnet:
				fmt.Println(databasemigrationservice.ErrCodeInvalidSubnet, aerr.Error())
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// Create replication task
// Creates a replication task using the specified parameters.
func ExampleDatabaseMigrationService_CreateReplicationTask_shared00() {
	svc := databasemigrationservice.New(session.New())
	input := &databasemigrationservice.CreateReplicationTaskInput{
		CdcStartTime:              parseTime("2006-01-02T15:04:05.999999999Z", "2016-12-14T18:25:43Z"),
		MigrationType:             aws.String("full-load"),
		ReplicationInstanceArn:    aws.String("arn:aws:dms:us-east-1:123456789012:rep:6UTDJGBOUS3VI3SUWA66XFJCJQ"),
		ReplicationTaskIdentifier: aws.String("task1"),
		ReplicationTaskSettings:   aws.String(""),
		SourceEndpointArn:         aws.String("arn:aws:dms:us-east-1:123456789012:endpoint:ZW5UAN6P4E77EC7YWHK4RZZ3BE"),
		TableMappings:             aws.String("file://mappingfile.json"),
		Tags: []*databasemigrationservice.Tag{
			{
				Key:   aws.String("Acount"),
				Value: aws.String("24352226"),
			},
		},
		TargetEndpointArn: aws.String("arn:aws:dms:us-east-1:123456789012:endpoint:ASXWXJZLNWNT5HTWCGV2BUJQ7E"),
	}

	result, err := svc.CreateReplicationTask(input)
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			case databasemigrationservice.ErrCodeAccessDeniedFault:
				fmt.Println(databasemigrationservice.ErrCodeAccessDeniedFault, aerr.Error())
			case databasemigrationservice.ErrCodeInvalidResourceStateFault:
				fmt.Println(databasemigrationservice.ErrCodeInvalidResourceStateFault, aerr.Error())
			case databasemigrationservice.ErrCodeResourceAlreadyExistsFault:
				fmt.Println(databasemigrationservice.ErrCodeResourceAlreadyExistsFault, aerr.Error())
			case databasemigrationservice.ErrCodeResourceNotFoundFault:
				fmt.Println(databasemigrationservice.ErrCodeResourceNotFoundFault, aerr.Error())
			case databasemigrationservice.ErrCodeKMSKeyNotAccessibleFault:
				fmt.Println(databasemigrationservice.ErrCodeKMSKeyNotAccessibleFault, aerr.Error())
			case databasemigrationservice.ErrCodeResourceQuotaExceededFault:
				fmt.Println(databasemigrationservice.ErrCodeResourceQuotaExceededFault, aerr.Error())
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// Delete Certificate
// Deletes the specified certificate.
func ExampleDatabaseMigrationService_DeleteCertificate_shared00() {
	svc := databasemigrationservice.New(session.New())
	input := &databasemigrationservice.DeleteCertificateInput{
		CertificateArn: aws.String("arn:aws:dms:us-east-1:123456789012:rep:6UTDJGBOUSM457DE6XFJCJQ"),
	}

	result, err := svc.DeleteCertificate(input)
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			case databasemigrationservice.ErrCodeResourceNotFoundFault:
				fmt.Println(databasemigrationservice.ErrCodeResourceNotFoundFault, aerr.Error())
			case databasemigrationservice.ErrCodeInvalidResourceStateFault:
				fmt.Println(databasemigrationservice.ErrCodeInvalidResourceStateFault, aerr.Error())
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// Delete Connection
// Deletes the connection between the replication instance and the endpoint.
func ExampleDatabaseMigrationService_DeleteConnection_shared00() {
	svc := databasemigrationservice.New(session.New())
	input := &databasemigrationservice.DeleteConnectionInput{
		EndpointArn:            aws.String("arn:aws:dms:us-east-1:123456789012:endpoint:RAAR3R22XSH46S3PWLC3NJAWKM"),
		ReplicationInstanceArn: aws.String("arn:aws:dms:us-east-1:123456789012:rep:6UTDJGBOUS3VI3SUWA66XFJCJQ"),
	}

	result, err := svc.DeleteConnection(input)
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			case databasemigrationservice.ErrCodeAccessDeniedFault:
				fmt.Println(databasemigrationservice.ErrCodeAccessDeniedFault, aerr.Error())
			case databasemigrationservice.ErrCodeResourceNotFoundFault:
				fmt.Println(databasemigrationservice.ErrCodeResourceNotFoundFault, aerr.Error())
			case databasemigrationservice.ErrCodeInvalidResourceStateFault:
				fmt.Println(databasemigrationservice.ErrCodeInvalidResourceStateFault, aerr.Error())
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// Delete Data Provider
// Deletes the specified data provider.
func ExampleDatabaseMigrationService_DeleteDataProvider_shared00() {
	svc := databasemigrationservice.New(session.New())
	input := &databasemigrationservice.DeleteDataProviderInput{
		DataProviderIdentifier: aws.String("arn:aws:dms:us-east-1:012345678901:data-provider:EXAMPLEABCDEFGHIJKLMNOPQRSTUVWXYZ012345"),
	}

	result, err := svc.DeleteDataProvider(input)
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			case databasemigrationservice.ErrCodeAccessDeniedFault:
				fmt.Println(databasemigrationservice.ErrCodeAccessDeniedFault, aerr.Error())
			case databasemigrationservice.ErrCodeResourceNotFoundFault:
				fmt.Println(databasemigrationservice.ErrCodeResourceNotFoundFault, aerr.Error())
			case databasemigrationservice.ErrCodeInvalidResourceStateFault:
				fmt.Println(databasemigrationservice.ErrCodeInvalidResourceStateFault, aerr.Error())
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// Delete Endpoint
// Deletes the specified endpoint. All tasks associated with the endpoint must be deleted
// before you can delete the endpoint.
func ExampleDatabaseMigrationService_DeleteEndpoint_shared00() {
	svc := databasemigrationservice.New(session.New())
	input := &databasemigrationservice.DeleteEndpointInput{
		EndpointArn: aws.String("arn:aws:dms:us-east-1:123456789012:endpoint:RAAR3R22XSH46S3PWLC3NJAWKM"),
	}

	result, err := svc.DeleteEndpoint(input)
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			case databasemigrationservice.ErrCodeResourceNotFoundFault:
				fmt.Println(databasemigrationservice.ErrCodeResourceNotFoundFault, aerr.Error())
			case databasemigrationservice.ErrCodeInvalidResourceStateFault:
				fmt.Println(databasemigrationservice.ErrCodeInvalidResourceStateFault, aerr.Error())
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// Delete Instance Profile
// Deletes the specified instance profile.
func ExampleDatabaseMigrationService_DeleteInstanceProfile_shared00() {
	svc := databasemigrationservice.New(session.New())
	input := &databasemigrationservice.DeleteInstanceProfileInput{
		InstanceProfileIdentifier: aws.String("arn:aws:dms:us-east-1:012345678901:instance-profile:EXAMPLEABCDEFGHIJKLMNOPQRSTUVWXYZ012345"),
	}

	result, err := svc.DeleteInstanceProfile(input)
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			case databasemigrationservice.ErrCodeAccessDeniedFault:
				fmt.Println(databasemigrationservice.ErrCodeAccessDeniedFault, aerr.Error())
			case databasemigrationservice.ErrCodeResourceNotFoundFault:
				fmt.Println(databasemigrationservice.ErrCodeResourceNotFoundFault, aerr.Error())
			case databasemigrationservice.ErrCodeInvalidResourceStateFault:
				fmt.Println(databasemigrationservice.ErrCodeInvalidResourceStateFault, aerr.Error())
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// Delete Migration Project
// Deletes the specified migration project.
func ExampleDatabaseMigrationService_DeleteMigrationProject_shared00() {
	svc := databasemigrationservice.New(session.New())
	input := &databasemigrationservice.DeleteMigrationProjectInput{
		MigrationProjectIdentifier: aws.String("arn:aws:dms:us-east-1:012345678901:migration-project:EXAMPLEABCDEFGHIJKLMNOPQRSTUVWXYZ012345"),
	}

	result, err := svc.DeleteMigrationProject(input)
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			case databasemigrationservice.ErrCodeAccessDeniedFault:
				fmt.Println(databasemigrationservice.ErrCodeAccessDeniedFault, aerr.Error())
			case databasemigrationservice.ErrCodeResourceNotFoundFault:
				fmt.Println(databasemigrationservice.ErrCodeResourceNotFoundFault, aerr.Error())
			case databasemigrationservice.ErrCodeInvalidResourceStateFault:
				fmt.Println(databasemigrationservice.ErrCodeInvalidResourceStateFault, aerr.Error())
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// Delete Replication Instance
// Deletes the specified replication instance. You must delete any migration tasks that
// are associated with the replication instance before you can delete it.
func ExampleDatabaseMigrationService_DeleteReplicationInstance_shared00() {
	svc := databasemigrationservice.New(session.New())
	input := &databasemigrationservice.DeleteReplicationInstanceInput{
		ReplicationInstanceArn: aws.String("arn:aws:dms:us-east-1:123456789012:rep:6UTDJGBOUS3VI3SUWA66XFJCJQ"),
	}

	result, err := svc.DeleteReplicationInstance(input)
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			case databasemigrationservice.ErrCodeInvalidResourceStateFault:
				fmt.Println(databasemigrationservice.ErrCodeInvalidResourceStateFault, aerr.Error())
			case databasemigrationservice.ErrCodeResourceNotFoundFault:
				fmt.Println(databasemigrationservice.ErrCodeResourceNotFoundFault, aerr.Error())
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// Delete Replication Subnet Group
// Deletes a replication subnet group.
func ExampleDatabaseMigrationService_DeleteReplicationSubnetGroup_shared00() {
	svc := databasemigrationservice.New(session.New())
	input := &databasemigrationservice.DeleteReplicationSubnetGroupInput{
		ReplicationSubnetGroupIdentifier: aws.String("us-west-2ab-vpc-215ds366"),
	}

	result, err := svc.DeleteReplicationSubnetGroup(input)
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			case databasemigrationservice.ErrCodeInvalidResourceStateFault:
				fmt.Println(databasemigrationservice.ErrCodeInvalidResourceStateFault, aerr.Error())
			case databasemigrationservice.ErrCodeResourceNotFoundFault:
				fmt.Println(databasemigrationservice.ErrCodeResourceNotFoundFault, aerr.Error())
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// Delete Replication Task
// Deletes the specified replication task.
func ExampleDatabaseMigrationService_DeleteReplicationTask_shared00() {
	svc := databasemigrationservice.New(session.New())
	input := &databasemigrationservice.DeleteReplicationTaskInput{
		ReplicationTaskArn: aws.String("arn:aws:dms:us-east-1:123456789012:rep:6UTDJGBOUS3VI3SUWA66XFJCJQ"),
	}

	result, err := svc.DeleteReplicationTask(input)
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			case databasemigrationservice.ErrCodeResourceNotFoundFault:
				fmt.Println(databasemigrationservice.ErrCodeResourceNotFoundFault, aerr.Error())
			case databasemigrationservice.ErrCodeInvalidResourceStateFault:
				fmt.Println(databasemigrationservice.ErrCodeInvalidResourceStateFault, aerr.Error())
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// Describe acount attributes
// Lists all of the AWS DMS attributes for a customer account. The attributes include
// AWS DMS quotas for the account, such as the number of replication instances allowed.
// The description for a quota includes the quota name, current usage toward that quota,
// and the quota's maximum value. This operation does not take any parameters.
func ExampleDatabaseMigrationService_DescribeAccountAttributes_shared00() {
	svc := databasemigrationservice.New(session.New())
	input := &databasemigrationservice.DescribeAccountAttributesInput{}

	result, err := svc.DescribeAccountAttributes(input)
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// Describe certificates
// Provides a description of the certificate.
func ExampleDatabaseMigrationService_DescribeCertificates_shared00() {
	svc := databasemigrationservice.New(session.New())
	input := &databasemigrationservice.DescribeCertificatesInput{
		Filters: []*databasemigrationservice.Filter{
			{
				Name: aws.String("string"),
				Values: []*string{
					aws.String("string"),
					aws.String("string"),
				},
			},
		},
		Marker:     aws.String(""),
		MaxRecords: aws.Int64(123),
	}

	result, err := svc.DescribeCertificates(input)
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			case databasemigrationservice.ErrCodeResourceNotFoundFault:
				fmt.Println(databasemigrationservice.ErrCodeResourceNotFoundFault, aerr.Error())
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// Describe connections
// Describes the status of the connections that have been made between the replication
// instance and an endpoint. Connections are created when you test an endpoint.
func ExampleDatabaseMigrationService_DescribeConnections_shared00() {
	svc := databasemigrationservice.New(session.New())
	input := &databasemigrationservice.DescribeConnectionsInput{
		Filters: []*databasemigrationservice.Filter{
			{
				Name: aws.String("string"),
				Values: []*string{
					aws.String("string"),
					aws.String("string"),
				},
			},
		},
		Marker:     aws.String(""),
		MaxRecords: aws.Int64(123),
	}

	result, err := svc.DescribeConnections(input)
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			case databasemigrationservice.ErrCodeResourceNotFoundFault:
				fmt.Println(databasemigrationservice.ErrCodeResourceNotFoundFault, aerr.Error())
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// Describe Conversion Configuration
// Returns configuration parameters for a schema conversion project.
func ExampleDatabaseMigrationService_DescribeConversionConfiguration_shared00() {
	svc := databasemigrationservice.New(session.New())
	input := &databasemigrationservice.DescribeConversionConfigurationInput{
		MigrationProjectIdentifier: aws.String("arn:aws:dms:us-east-1:012345678901:migration-project:EXAMPLEABCDEFGHIJKLMNOPQRSTUVWXYZ012345"),
	}

	result, err := svc.DescribeConversionConfiguration(input)
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			case databasemigrationservice.ErrCodeResourceNotFoundFault:
				fmt.Println(databasemigrationservice.ErrCodeResourceNotFoundFault, aerr.Error())
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// Describe Data Providers
//

func ExampleDatabaseMigrationService_DescribeDataProviders_shared00() {
	svc := databasemigrationservice.New(session.New())
	input := &databasemigrationservice.DescribeDataProvidersInput{
		Filters: []*databasemigrationservice.Filter{
			{
				Name: aws.String("data-provider-identifier"),
				Values: []*string{
					aws.String("arn:aws:dms:us-east-1:012345678901:data-provider:EXAMPLEABCDEFGHIJKLMNOPQRSTUVWXYZ012345"),
				},
			},
		},
		Marker:     aws.String("EXAMPLEABCDEFGHIJKLMNOPQRSTUVWXYZ012345"),
		MaxRecords: aws.Int64(20),
	}

	result, err := svc.DescribeDataProviders(input)
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			case databasemigrationservice.ErrCodeResourceNotFoundFault:
				fmt.Println(databasemigrationservice.ErrCodeResourceNotFoundFault, aerr.Error())
			case databasemigrationservice.ErrCodeAccessDeniedFault:
				fmt.Println(databasemigrationservice.ErrCodeAccessDeniedFault, aerr.Error())
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// Describe endpoint types
// Returns information about the type of endpoints available.
func ExampleDatabaseMigrationService_DescribeEndpointTypes_shared00() {
	svc := databasemigrationservice.New(session.New())
	input := &databasemigrationservice.DescribeEndpointTypesInput{
		Filters: []*databasemigrationservice.Filter{
			{
				Name: aws.String("string"),
				Values: []*string{
					aws.String("string"),
					aws.String("string"),
				},
			},
		},
		Marker:     aws.String(""),
		MaxRecords: aws.Int64(123),
	}

	result, err := svc.DescribeEndpointTypes(input)
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// Describe endpoints
// Returns information about the endpoints for your account in the current region.
func ExampleDatabaseMigrationService_DescribeEndpoints_shared00() {
	svc := databasemigrationservice.New(session.New())
	input := &databasemigrationservice.DescribeEndpointsInput{
		Filters: []*databasemigrationservice.Filter{
			{
				Name: aws.String("string"),
				Values: []*string{
					aws.String("string"),
					aws.String("string"),
				},
			},
		},
		Marker:     aws.String(""),
		MaxRecords: aws.Int64(123),
	}

	result, err := svc.DescribeEndpoints(input)
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			case databasemigrationservice.ErrCodeResourceNotFoundFault:
				fmt.Println(databasemigrationservice.ErrCodeResourceNotFoundFault, aerr.Error())
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// Describe Extension Pack Associations
// Returns a paginated list of extension pack associations for the specified migration
// project.
func ExampleDatabaseMigrationService_DescribeExtensionPackAssociations_shared00() {
	svc := databasemigrationservice.New(session.New())
	input := &databasemigrationservice.DescribeExtensionPackAssociationsInput{
		Filters: []*databasemigrationservice.Filter{
			{
				Name: aws.String("instance-profile-identifier"),
				Values: []*string{
					aws.String("arn:aws:dms:us-east-1:012345678901:instance-profile:EXAMPLEABCDEFGHIJKLMNOPQRSTUVWXYZ012345"),
				},
			},
		},
		Marker:                     aws.String("0123456789abcdefghijklmnopqrs"),
		MaxRecords:                 aws.Int64(20),
		MigrationProjectIdentifier: aws.String("arn:aws:dms:us-east-1:012345678901:migration-project:0123456789ABCDEFGHIJKLMNOPQRSTUVWXYZ012"),
	}

	result, err := svc.DescribeExtensionPackAssociations(input)
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// Describe Instance Profiles
// Returns a paginated list of instance profiles for your account in the current region.
func ExampleDatabaseMigrationService_DescribeInstanceProfiles_shared00() {
	svc := databasemigrationservice.New(session.New())
	input := &databasemigrationservice.DescribeInstanceProfilesInput{
		Filters: []*databasemigrationservice.Filter{
			{
				Name: aws.String("instance-profile-identifier"),
				Values: []*string{
					aws.String("arn:aws:dms:us-east-1:012345678901:instance-profile:EXAMPLEABCDEFGHIJKLMNOPQRSTUVWXYZ012345"),
				},
			},
		},
		Marker:     aws.String("0123456789abcdefghijklmnopqrs"),
		MaxRecords: aws.Int64(20),
	}

	result, err := svc.DescribeInstanceProfiles(input)
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			case databasemigrationservice.ErrCodeResourceNotFoundFault:
				fmt.Println(databasemigrationservice.ErrCodeResourceNotFoundFault, aerr.Error())
			case databasemigrationservice.ErrCodeAccessDeniedFault:
				fmt.Println(databasemigrationservice.ErrCodeAccessDeniedFault, aerr.Error())
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// Describe Metadata Model Assessments
// Returns a paginated list of metadata model assessments for your account in the current
// region.
func ExampleDatabaseMigrationService_DescribeMetadataModelAssessments_shared00() {
	svc := databasemigrationservice.New(session.New())
	input := &databasemigrationservice.DescribeMetadataModelAssessmentsInput{
		Filters: []*databasemigrationservice.Filter{
			{
				Name: aws.String("my-migration-project"),
				Values: []*string{
					aws.String("arn:aws:dms:us-east-1:012345678901:migration-project:0123456789ABCDEFGHIJKLMNOPQRSTUVWXYZ012"),
				},
			},
		},
		Marker:                     aws.String("0123456789abcdefghijklmnopqrs"),
		MaxRecords:                 aws.Int64(20),
		MigrationProjectIdentifier: aws.String(""),
	}

	result, err := svc.DescribeMetadataModelAssessments(input)
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			case databasemigrationservice.ErrCodeResourceNotFoundFault:
				fmt.Println(databasemigrationservice.ErrCodeResourceNotFoundFault, aerr.Error())
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// Describe Metadata Model Conversions
// Returns a paginated list of metadata model conversions for a migration project.
func ExampleDatabaseMigrationService_DescribeMetadataModelConversions_shared00() {
	svc := databasemigrationservice.New(session.New())
	input := &databasemigrationservice.DescribeMetadataModelConversionsInput{
		Filters: []*databasemigrationservice.Filter{
			{
				Name: aws.String("request-id"),
				Values: []*string{
					aws.String("01234567-89ab-cdef-0123-456789abcdef"),
				},
			},
		},
		Marker:                     aws.String("EXAMPLEABCDEFGHIJKLMNOPQRSTUVWXYZ123456"),
		MaxRecords:                 aws.Int64(123),
		MigrationProjectIdentifier: aws.String("arn:aws:dms:us-east-1:012345678901:migration-project:EXAMPLEABCDEFGHIJKLMNOPQRSTUVWXYZ012345"),
	}

	result, err := svc.DescribeMetadataModelConversions(input)
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			case databasemigrationservice.ErrCodeResourceNotFoundFault:
				fmt.Println(databasemigrationservice.ErrCodeResourceNotFoundFault, aerr.Error())
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// Describe Metadata Model Exports As Script
// Returns a paginated list of metadata model exports.
func ExampleDatabaseMigrationService_DescribeMetadataModelExportsAsScript_shared00() {
	svc := databasemigrationservice.New(session.New())
	input := &databasemigrationservice.DescribeMetadataModelExportsAsScriptInput{
		Filters: []*databasemigrationservice.Filter{
			{
				Name: aws.String("request-id"),
				Values: []*string{
					aws.String("01234567-89ab-cdef-0123-456789abcdef"),
				},
			},
		},
		Marker:                     aws.String("0123456789abcdefghijklmnopqrs"),
		MaxRecords:                 aws.Int64(20),
		MigrationProjectIdentifier: aws.String("arn:aws:dms:us-east-1:012345678901:migration-project:0123456789ABCDEFGHIJKLMNOPQRSTUVWXYZ012"),
	}

	result, err := svc.DescribeMetadataModelExportsAsScript(input)
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			case databasemigrationservice.ErrCodeResourceNotFoundFault:
				fmt.Println(databasemigrationservice.ErrCodeResourceNotFoundFault, aerr.Error())
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// Describe Metadata Model Exports To Target
// Returns a paginated list of metadata model exports.
func ExampleDatabaseMigrationService_DescribeMetadataModelExportsToTarget_shared00() {
	svc := databasemigrationservice.New(session.New())
	input := &databasemigrationservice.DescribeMetadataModelExportsToTargetInput{
		Filters: []*databasemigrationservice.Filter{
			{
				Name: aws.String("request-id"),
				Values: []*string{
					aws.String("01234567-89ab-cdef-0123-456789abcdef"),
				},
			},
		},
		Marker:                     aws.String("0123456789abcdefghijklmnopqrs"),
		MaxRecords:                 aws.Int64(20),
		MigrationProjectIdentifier: aws.String("arn:aws:dms:us-east-1:012345678901:migration-project:0123456789ABCDEFGHIJKLMNOPQRSTUVWXYZ012"),
	}

	result, err := svc.DescribeMetadataModelExportsToTarget(input)
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			case databasemigrationservice.ErrCodeResourceNotFoundFault:
				fmt.Println(databasemigrationservice.ErrCodeResourceNotFoundFault, aerr.Error())
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// Describe Metadata Model Imports
// Returns a paginated list of metadata model imports.
func ExampleDatabaseMigrationService_DescribeMetadataModelImports_shared00() {
	svc := databasemigrationservice.New(session.New())
	input := &databasemigrationservice.DescribeMetadataModelImportsInput{
		Filters: []*databasemigrationservice.Filter{
			{
				Name: aws.String("request-id"),
				Values: []*string{
					aws.String("01234567-89ab-cdef-0123-456789abcdef"),
				},
			},
		},
		Marker:                     aws.String("0123456789abcdefghijklmnopqrs"),
		MaxRecords:                 aws.Int64(20),
		MigrationProjectIdentifier: aws.String("arn:aws:dms:us-east-1:012345678901:migration-project:0123456789ABCDEFGHIJKLMNOPQRSTUVWXYZ012"),
	}

	result, err := svc.DescribeMetadataModelImports(input)
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			case databasemigrationservice.ErrCodeResourceNotFoundFault:
				fmt.Println(databasemigrationservice.ErrCodeResourceNotFoundFault, aerr.Error())
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// Describe Migration Projects
// Returns a paginated list of migration projects for your account in the current region.
func ExampleDatabaseMigrationService_DescribeMigrationProjects_shared00() {
	svc := databasemigrationservice.New(session.New())
	input := &databasemigrationservice.DescribeMigrationProjectsInput{
		Filters: []*databasemigrationservice.Filter{
			{
				Name: aws.String("migration-project-identifier"),
				Values: []*string{
					aws.String("arn:aws:dms:us-east-1:012345678901:migration-project:EXAMPLEABCDEFGHIJKLMNOPQRSTUVWXYZ12345678901"),
				},
			},
		},
		Marker:     aws.String("EXAMPLEABCDEFGHIJKLMNOPQRSTUVWXYZ123456"),
		MaxRecords: aws.Int64(20),
	}

	result, err := svc.DescribeMigrationProjects(input)
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			case databasemigrationservice.ErrCodeResourceNotFoundFault:
				fmt.Println(databasemigrationservice.ErrCodeResourceNotFoundFault, aerr.Error())
			case databasemigrationservice.ErrCodeAccessDeniedFault:
				fmt.Println(databasemigrationservice.ErrCodeAccessDeniedFault, aerr.Error())
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// Describe orderable replication instances
// Returns information about the replication instance types that can be created in the
// specified region.
func ExampleDatabaseMigrationService_DescribeOrderableReplicationInstances_shared00() {
	svc := databasemigrationservice.New(session.New())
	input := &databasemigrationservice.DescribeOrderableReplicationInstancesInput{
		Marker:     aws.String(""),
		MaxRecords: aws.Int64(123),
	}

	result, err := svc.DescribeOrderableReplicationInstances(input)
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// Describe refresh schema status
// Returns the status of the refresh-schemas operation.
func ExampleDatabaseMigrationService_DescribeRefreshSchemasStatus_shared00() {
	svc := databasemigrationservice.New(session.New())
	input := &databasemigrationservice.DescribeRefreshSchemasStatusInput{
		EndpointArn: aws.String(""),
	}

	result, err := svc.DescribeRefreshSchemasStatus(input)
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			case databasemigrationservice.ErrCodeInvalidResourceStateFault:
				fmt.Println(databasemigrationservice.ErrCodeInvalidResourceStateFault, aerr.Error())
			case databasemigrationservice.ErrCodeResourceNotFoundFault:
				fmt.Println(databasemigrationservice.ErrCodeResourceNotFoundFault, aerr.Error())
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// Describe replication instances
// Returns the status of the refresh-schemas operation.
func ExampleDatabaseMigrationService_DescribeReplicationInstances_shared00() {
	svc := databasemigrationservice.New(session.New())
	input := &databasemigrationservice.DescribeReplicationInstancesInput{
		Filters: []*databasemigrationservice.Filter{
			{
				Name: aws.String("string"),
				Values: []*string{
					aws.String("string"),
					aws.String("string"),
				},
			},
		},
		Marker:     aws.String(""),
		MaxRecords: aws.Int64(123),
	}

	result, err := svc.DescribeReplicationInstances(input)
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			case databasemigrationservice.ErrCodeResourceNotFoundFault:
				fmt.Println(databasemigrationservice.ErrCodeResourceNotFoundFault, aerr.Error())
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// Describe replication subnet groups
// Returns information about the replication subnet groups.
func ExampleDatabaseMigrationService_DescribeReplicationSubnetGroups_shared00() {
	svc := databasemigrationservice.New(session.New())
	input := &databasemigrationservice.DescribeReplicationSubnetGroupsInput{
		Filters: []*databasemigrationservice.Filter{
			{
				Name: aws.String("string"),
				Values: []*string{
					aws.String("string"),
					aws.String("string"),
				},
			},
		},
		Marker:     aws.String(""),
		MaxRecords: aws.Int64(123),
	}

	result, err := svc.DescribeReplicationSubnetGroups(input)
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			case databasemigrationservice.ErrCodeResourceNotFoundFault:
				fmt.Println(databasemigrationservice.ErrCodeResourceNotFoundFault, aerr.Error())
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// Describe replication tasks
// Returns information about replication tasks for your account in the current region.
func ExampleDatabaseMigrationService_DescribeReplicationTasks_shared00() {
	svc := databasemigrationservice.New(session.New())
	input := &databasemigrationservice.DescribeReplicationTasksInput{
		Filters: []*databasemigrationservice.Filter{
			{
				Name: aws.String("string"),
				Values: []*string{
					aws.String("string"),
					aws.String("string"),
				},
			},
		},
		Marker:     aws.String(""),
		MaxRecords: aws.Int64(123),
	}

	result, err := svc.DescribeReplicationTasks(input)
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			case databasemigrationservice.ErrCodeResourceNotFoundFault:
				fmt.Println(databasemigrationservice.ErrCodeResourceNotFoundFault, aerr.Error())
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// Describe schemas
// Returns information about the schema for the specified endpoint.
func ExampleDatabaseMigrationService_DescribeSchemas_shared00() {
	svc := databasemigrationservice.New(session.New())
	input := &databasemigrationservice.DescribeSchemasInput{
		EndpointArn: aws.String(""),
		Marker:      aws.String(""),
		MaxRecords:  aws.Int64(123),
	}

	result, err := svc.DescribeSchemas(input)
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			case databasemigrationservice.ErrCodeInvalidResourceStateFault:
				fmt.Println(databasemigrationservice.ErrCodeInvalidResourceStateFault, aerr.Error())
			case databasemigrationservice.ErrCodeResourceNotFoundFault:
				fmt.Println(databasemigrationservice.ErrCodeResourceNotFoundFault, aerr.Error())
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// Describe table statistics
// Returns table statistics on the database migration task, including table name, rows
// inserted, rows updated, and rows deleted.
func ExampleDatabaseMigrationService_DescribeTableStatistics_shared00() {
	svc := databasemigrationservice.New(session.New())
	input := &databasemigrationservice.DescribeTableStatisticsInput{
		Marker:             aws.String(""),
		MaxRecords:         aws.Int64(123),
		ReplicationTaskArn: aws.String(""),
	}

	result, err := svc.DescribeTableStatistics(input)
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			case databasemigrationservice.ErrCodeResourceNotFoundFault:
				fmt.Println(databasemigrationservice.ErrCodeResourceNotFoundFault, aerr.Error())
			case databasemigrationservice.ErrCodeInvalidResourceStateFault:
				fmt.Println(databasemigrationservice.ErrCodeInvalidResourceStateFault, aerr.Error())
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// Export Metadata Model Assessment
// Saves a copy of a database migration assessment report to your S3 bucket. DMS can
// save your assessment report as a comma-separated value (CSV) or a PDF file.
func ExampleDatabaseMigrationService_ExportMetadataModelAssessment_shared00() {
	svc := databasemigrationservice.New(session.New())
	input := &databasemigrationservice.ExportMetadataModelAssessmentInput{
		AssessmentReportTypes: []*string{
			aws.String("pdf"),
		},
		FileName:                   aws.String("file"),
		MigrationProjectIdentifier: aws.String("arn:aws:dms:us-east-1:012345678901:migration-project:0123456789ABCDEFGHIJKLMNOPQRSTUVWXYZ012"),
		SelectionRules:             aws.String("{\"rules\": [{\"rule-type\": \"selection\",\"rule-id\": \"1\",\"rule-name\": \"1\",\"object-locator\": {\"server-name\": \"aurora-pg.cluster-a1b2c3d4e5f6.us-east-1.rds.amazonaws.com\", \"schema-name\": \"schema1\", \"table-name\": \"Cities\"},\"rule-action\": \"explicit\"} ]}"),
	}

	result, err := svc.ExportMetadataModelAssessment(input)
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			case databasemigrationservice.ErrCodeResourceNotFoundFault:
				fmt.Println(databasemigrationservice.ErrCodeResourceNotFoundFault, aerr.Error())
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// Import certificate
// Uploads the specified certificate.
func ExampleDatabaseMigrationService_ImportCertificate_shared00() {
	svc := databasemigrationservice.New(session.New())
	input := &databasemigrationservice.ImportCertificateInput{
		CertificateIdentifier: aws.String(""),
		CertificatePem:        aws.String(""),
	}

	result, err := svc.ImportCertificate(input)
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			case databasemigrationservice.ErrCodeResourceAlreadyExistsFault:
				fmt.Println(databasemigrationservice.ErrCodeResourceAlreadyExistsFault, aerr.Error())
			case databasemigrationservice.ErrCodeInvalidCertificateFault:
				fmt.Println(databasemigrationservice.ErrCodeInvalidCertificateFault, aerr.Error())
			case databasemigrationservice.ErrCodeResourceQuotaExceededFault:
				fmt.Println(databasemigrationservice.ErrCodeResourceQuotaExceededFault, aerr.Error())
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// List tags for resource
// Lists all tags for an AWS DMS resource.
func ExampleDatabaseMigrationService_ListTagsForResource_shared00() {
	svc := databasemigrationservice.New(session.New())
	input := &databasemigrationservice.ListTagsForResourceInput{
		ResourceArn: aws.String(""),
	}

	result, err := svc.ListTagsForResource(input)
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			case databasemigrationservice.ErrCodeResourceNotFoundFault:
				fmt.Println(databasemigrationservice.ErrCodeResourceNotFoundFault, aerr.Error())
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// Modify Conversion Configuration
// Modifies the specified schema conversion configuration using the provided parameters.
func ExampleDatabaseMigrationService_ModifyConversionConfiguration_shared00() {
	svc := databasemigrationservice.New(session.New())
	input := &databasemigrationservice.ModifyConversionConfigurationInput{
		ConversionConfiguration:    aws.String("{\"Common project settings\":{\"ShowSeverityLevelInSql\":\"CRITICAL\"},\"ORACLE_TO_POSTGRESQL\" : {\"ToTimeZone\":false,\"LastDayBuiltinFunctionOracle\":false,   \"NextDayBuiltinFunctionOracle\":false,\"ConvertProceduresToFunction\":false,\"NvlBuiltinFunctionOracle\":false,\"DbmsAssertBuiltinFunctionOracle\":false}}"),
		MigrationProjectIdentifier: aws.String("arn:aws:dms:us-east-1:012345678901:migration-project:0123456789ABCDEFGHIJKLMNOPQRSTUVWXYZ012"),
	}

	result, err := svc.ModifyConversionConfiguration(input)
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			case databasemigrationservice.ErrCodeResourceNotFoundFault:
				fmt.Println(databasemigrationservice.ErrCodeResourceNotFoundFault, aerr.Error())
			case databasemigrationservice.ErrCodeInvalidResourceStateFault:
				fmt.Println(databasemigrationservice.ErrCodeInvalidResourceStateFault, aerr.Error())
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// Modify Data Provider
// Modifies the specified data provider using the provided settings.
func ExampleDatabaseMigrationService_ModifyDataProvider_shared00() {
	svc := databasemigrationservice.New(session.New())
	input := &databasemigrationservice.ModifyDataProviderInput{
		DataProviderIdentifier: aws.String("arn:aws:dms:us-east-1:012345678901:data-provider:EXAMPLEABCDEFGHIJKLMNOPQRSTUVWXYZ012345"),
		DataProviderName:       aws.String("new-name"),
		Description:            aws.String("description"),
		Engine:                 aws.String("sqlserver"),
		Settings: &databasemigrationservice.DataProviderSettings{
			MicrosoftSqlServerSettings: &databasemigrationservice.MicrosoftSqlServerDataProviderSettings{
				DatabaseName: aws.String("DatabaseName"),
				Port:         aws.Int64(11112),
				ServerName:   aws.String("ServerName2"),
				SslMode:      aws.String("none"),
			},
		},
	}

	result, err := svc.ModifyDataProvider(input)
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			case databasemigrationservice.ErrCodeAccessDeniedFault:
				fmt.Println(databasemigrationservice.ErrCodeAccessDeniedFault, aerr.Error())
			case databasemigrationservice.ErrCodeResourceNotFoundFault:
				fmt.Println(databasemigrationservice.ErrCodeResourceNotFoundFault, aerr.Error())
			case databasemigrationservice.ErrCodeInvalidResourceStateFault:
				fmt.Println(databasemigrationservice.ErrCodeInvalidResourceStateFault, aerr.Error())
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// Modify endpoint
// Modifies the specified endpoint.
func ExampleDatabaseMigrationService_ModifyEndpoint_shared00() {
	svc := databasemigrationservice.New(session.New())
	input := &databasemigrationservice.ModifyEndpointInput{
		CertificateArn:            aws.String(""),
		DatabaseName:              aws.String(""),
		EndpointArn:               aws.String(""),
		EndpointIdentifier:        aws.String(""),
		EndpointType:              aws.String("source"),
		EngineName:                aws.String(""),
		ExtraConnectionAttributes: aws.String(""),
		Password:                  aws.String(""),
		Port:                      aws.Int64(123),
		ServerName:                aws.String(""),
		SslMode:                   aws.String("require"),
		Username:                  aws.String(""),
	}

	result, err := svc.ModifyEndpoint(input)
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			case databasemigrationservice.ErrCodeInvalidResourceStateFault:
				fmt.Println(databasemigrationservice.ErrCodeInvalidResourceStateFault, aerr.Error())
			case databasemigrationservice.ErrCodeResourceNotFoundFault:
				fmt.Println(databasemigrationservice.ErrCodeResourceNotFoundFault, aerr.Error())
			case databasemigrationservice.ErrCodeResourceAlreadyExistsFault:
				fmt.Println(databasemigrationservice.ErrCodeResourceAlreadyExistsFault, aerr.Error())
			case databasemigrationservice.ErrCodeKMSKeyNotAccessibleFault:
				fmt.Println(databasemigrationservice.ErrCodeKMSKeyNotAccessibleFault, aerr.Error())
			case databasemigrationservice.ErrCodeAccessDeniedFault:
				fmt.Println(databasemigrationservice.ErrCodeAccessDeniedFault, aerr.Error())
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// Modify Instance Profile
// Modifies the specified instance profile using the provided parameters.
func ExampleDatabaseMigrationService_ModifyInstanceProfile_shared00() {
	svc := databasemigrationservice.New(session.New())
	input := &databasemigrationservice.ModifyInstanceProfileInput{
		AvailabilityZone:          aws.String(""),
		Description:               aws.String(""),
		InstanceProfileIdentifier: aws.String(""),
		InstanceProfileName:       aws.String(""),
		KmsKeyArn:                 aws.String(""),
		NetworkType:               aws.String(""),
		PubliclyAccessible:        aws.Bool(true),
		SubnetGroupIdentifier:     aws.String(""),
	}

	result, err := svc.ModifyInstanceProfile(input)
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			case databasemigrationservice.ErrCodeAccessDeniedFault:
				fmt.Println(databasemigrationservice.ErrCodeAccessDeniedFault, aerr.Error())
			case databasemigrationservice.ErrCodeResourceNotFoundFault:
				fmt.Println(databasemigrationservice.ErrCodeResourceNotFoundFault, aerr.Error())
			case databasemigrationservice.ErrCodeInvalidResourceStateFault:
				fmt.Println(databasemigrationservice.ErrCodeInvalidResourceStateFault, aerr.Error())
			case databasemigrationservice.ErrCodeKMSKeyNotAccessibleFault:
				fmt.Println(databasemigrationservice.ErrCodeKMSKeyNotAccessibleFault, aerr.Error())
			case databasemigrationservice.ErrCodeS3ResourceNotFoundFault:
				fmt.Println(databasemigrationservice.ErrCodeS3ResourceNotFoundFault, aerr.Error())
			case databasemigrationservice.ErrCodeS3AccessDeniedFault:
				fmt.Println(databasemigrationservice.ErrCodeS3AccessDeniedFault, aerr.Error())
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// Modify Migration Project
// Modifies the specified migration project using the provided parameters.
func ExampleDatabaseMigrationService_ModifyMigrationProject_shared00() {
	svc := databasemigrationservice.New(session.New())
	input := &databasemigrationservice.ModifyMigrationProjectInput{
		Description:                aws.String("description"),
		InstanceProfileIdentifier:  aws.String("my-instance-profile"),
		MigrationProjectIdentifier: aws.String("arn:aws:dms:us-east-1:012345678901:migration-project:EXAMPLEABCDEFGHIJKLMNOPQRSTUVWXYZ012345"),
		MigrationProjectName:       aws.String("new-name"),
		SchemaConversionApplicationAttributes: &databasemigrationservice.SCApplicationAttributes{
			S3BucketPath:    aws.String("arn:aws:s3:::myuser-bucket"),
			S3BucketRoleArn: aws.String("arn:aws:iam::012345678901:role/Admin"),
		},
		SourceDataProviderDescriptors: []*databasemigrationservice.DataProviderDescriptorDefinition{
			{
				DataProviderIdentifier:      aws.String("arn:aws:dms:us-east-1:012345678901:data-provider:EXAMPLEABCDEFGHIJKLMNOPQRSTUVWXYZ012345"),
				SecretsManagerAccessRoleArn: aws.String("arn:aws:iam::012345678901:role/myuser-admin-access"),
				SecretsManagerSecretId:      aws.String("arn:aws:secretsmanager:us-east-1:012345678901:secret:myorg/myuser/ALL.SOURCE.ORACLE_12-A1B2C3"),
			},
		},
		TargetDataProviderDescriptors: []*databasemigrationservice.DataProviderDescriptorDefinition{
			{
				DataProviderIdentifier:      aws.String("arn:aws:dms:us-east-1:012345678901:data-provider:EXAMPLEABCDEFGHIJKLMNOPQRSTUVWXYZ012345"),
				SecretsManagerAccessRoleArn: aws.String("arn:aws:iam::012345678901:role/myuser-admin-access"),
				SecretsManagerSecretId:      aws.String("arn:aws:secretsmanager:us-east-1:012345678901:secret:myorg/myuser/TARGET.postgresql-A1B2C3"),
			},
		},
	}

	result, err := svc.ModifyMigrationProject(input)
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			case databasemigrationservice.ErrCodeAccessDeniedFault:
				fmt.Println(databasemigrationservice.ErrCodeAccessDeniedFault, aerr.Error())
			case databasemigrationservice.ErrCodeResourceNotFoundFault:
				fmt.Println(databasemigrationservice.ErrCodeResourceNotFoundFault, aerr.Error())
			case databasemigrationservice.ErrCodeInvalidResourceStateFault:
				fmt.Println(databasemigrationservice.ErrCodeInvalidResourceStateFault, aerr.Error())
			case databasemigrationservice.ErrCodeS3ResourceNotFoundFault:
				fmt.Println(databasemigrationservice.ErrCodeS3ResourceNotFoundFault, aerr.Error())
			case databasemigrationservice.ErrCodeS3AccessDeniedFault:
				fmt.Println(databasemigrationservice.ErrCodeS3AccessDeniedFault, aerr.Error())
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// Modify replication instance
// Modifies the replication instance to apply new settings. You can change one or more
// parameters by specifying these parameters and the new values in the request. Some
// settings are applied during the maintenance window.
func ExampleDatabaseMigrationService_ModifyReplicationInstance_shared00() {
	svc := databasemigrationservice.New(session.New())
	input := &databasemigrationservice.ModifyReplicationInstanceInput{
		AllocatedStorage:              aws.Int64(123),
		AllowMajorVersionUpgrade:      aws.Bool(true),
		ApplyImmediately:              aws.Bool(true),
		AutoMinorVersionUpgrade:       aws.Bool(true),
		EngineVersion:                 aws.String("1.5.0"),
		MultiAZ:                       aws.Bool(true),
		PreferredMaintenanceWindow:    aws.String("sun:06:00-sun:14:00"),
		ReplicationInstanceArn:        aws.String("arn:aws:dms:us-east-1:123456789012:rep:6UTDJGBOUS3VI3SUWA66XFJCJQ"),
		ReplicationInstanceClass:      aws.String("dms.t2.micro"),
		ReplicationInstanceIdentifier: aws.String("test-rep-1"),
	}

	result, err := svc.ModifyReplicationInstance(input)
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			case databasemigrationservice.ErrCodeAccessDeniedFault:
				fmt.Println(databasemigrationservice.ErrCodeAccessDeniedFault, aerr.Error())
			case databasemigrationservice.ErrCodeInvalidResourceStateFault:
				fmt.Println(databasemigrationservice.ErrCodeInvalidResourceStateFault, aerr.Error())
			case databasemigrationservice.ErrCodeResourceAlreadyExistsFault:
				fmt.Println(databasemigrationservice.ErrCodeResourceAlreadyExistsFault, aerr.Error())
			case databasemigrationservice.ErrCodeResourceNotFoundFault:
				fmt.Println(databasemigrationservice.ErrCodeResourceNotFoundFault, aerr.Error())
			case databasemigrationservice.ErrCodeInsufficientResourceCapacityFault:
				fmt.Println(databasemigrationservice.ErrCodeInsufficientResourceCapacityFault, aerr.Error())
			case databasemigrationservice.ErrCodeStorageQuotaExceededFault:
				fmt.Println(databasemigrationservice.ErrCodeStorageQuotaExceededFault, aerr.Error())
			case databasemigrationservice.ErrCodeUpgradeDependencyFailureFault:
				fmt.Println(databasemigrationservice.ErrCodeUpgradeDependencyFailureFault, aerr.Error())
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// Modify replication subnet group
// Modifies the settings for the specified replication subnet group.
func ExampleDatabaseMigrationService_ModifyReplicationSubnetGroup_shared00() {
	svc := databasemigrationservice.New(session.New())
	input := &databasemigrationservice.ModifyReplicationSubnetGroupInput{
		ReplicationSubnetGroupDescription: aws.String(""),
		ReplicationSubnetGroupIdentifier:  aws.String(""),
	}

	result, err := svc.ModifyReplicationSubnetGroup(input)
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			case databasemigrationservice.ErrCodeAccessDeniedFault:
				fmt.Println(databasemigrationservice.ErrCodeAccessDeniedFault, aerr.Error())
			case databasemigrationservice.ErrCodeResourceNotFoundFault:
				fmt.Println(databasemigrationservice.ErrCodeResourceNotFoundFault, aerr.Error())
			case databasemigrationservice.ErrCodeResourceQuotaExceededFault:
				fmt.Println(databasemigrationservice.ErrCodeResourceQuotaExceededFault, aerr.Error())
			case databasemigrationservice.ErrCodeSubnetAlreadyInUse:
				fmt.Println(databasemigrationservice.ErrCodeSubnetAlreadyInUse, aerr.Error())
			case databasemigrationservice.ErrCodeReplicationSubnetGroupDoesNotCoverEnoughAZs:
				fmt.Println(databasemigrationservice.ErrCodeReplicationSubnetGroupDoesNotCoverEnoughAZs, aerr.Error())
			case databasemigrationservice.ErrCodeInvalidSubnet:
				fmt.Println(databasemigrationservice.ErrCodeInvalidSubnet, aerr.Error())
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// Refresh schema
// Populates the schema for the specified endpoint. This is an asynchronous operation
// and can take several minutes. You can check the status of this operation by calling
// the describe-refresh-schemas-status operation.
func ExampleDatabaseMigrationService_RefreshSchemas_shared00() {
	svc := databasemigrationservice.New(session.New())
	input := &databasemigrationservice.RefreshSchemasInput{
		EndpointArn:            aws.String(""),
		ReplicationInstanceArn: aws.String(""),
	}

	result, err := svc.RefreshSchemas(input)
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			case databasemigrationservice.ErrCodeInvalidResourceStateFault:
				fmt.Println(databasemigrationservice.ErrCodeInvalidResourceStateFault, aerr.Error())
			case databasemigrationservice.ErrCodeResourceNotFoundFault:
				fmt.Println(databasemigrationservice.ErrCodeResourceNotFoundFault, aerr.Error())
			case databasemigrationservice.ErrCodeKMSKeyNotAccessibleFault:
				fmt.Println(databasemigrationservice.ErrCodeKMSKeyNotAccessibleFault, aerr.Error())
			case databasemigrationservice.ErrCodeResourceQuotaExceededFault:
				fmt.Println(databasemigrationservice.ErrCodeResourceQuotaExceededFault, aerr.Error())
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// Remove tags from resource
// Removes metadata tags from an AWS DMS resource.
func ExampleDatabaseMigrationService_RemoveTagsFromResource_shared00() {
	svc := databasemigrationservice.New(session.New())
	input := &databasemigrationservice.RemoveTagsFromResourceInput{
		ResourceArn: aws.String("arn:aws:dms:us-east-1:123456789012:endpoint:ASXWXJZLNWNT5HTWCGV2BUJQ7E"),
	}

	result, err := svc.RemoveTagsFromResource(input)
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			case databasemigrationservice.ErrCodeResourceNotFoundFault:
				fmt.Println(databasemigrationservice.ErrCodeResourceNotFoundFault, aerr.Error())
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// Start Extension Pack Association
// Applies the extension pack to your target database.
func ExampleDatabaseMigrationService_StartExtensionPackAssociation_shared00() {
	svc := databasemigrationservice.New(session.New())
	input := &databasemigrationservice.StartExtensionPackAssociationInput{
		MigrationProjectIdentifier: aws.String("arn:aws:dms:us-east-1:012345678901:migration-project:0123456789ABCDEFGHIJKLMNOPQRSTUVWXYZ012"),
	}

	result, err := svc.StartExtensionPackAssociation(input)
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			case databasemigrationservice.ErrCodeAccessDeniedFault:
				fmt.Println(databasemigrationservice.ErrCodeAccessDeniedFault, aerr.Error())
			case databasemigrationservice.ErrCodeInvalidResourceStateFault:
				fmt.Println(databasemigrationservice.ErrCodeInvalidResourceStateFault, aerr.Error())
			case databasemigrationservice.ErrCodeResourceAlreadyExistsFault:
				fmt.Println(databasemigrationservice.ErrCodeResourceAlreadyExistsFault, aerr.Error())
			case databasemigrationservice.ErrCodeResourceNotFoundFault:
				fmt.Println(databasemigrationservice.ErrCodeResourceNotFoundFault, aerr.Error())
			case databasemigrationservice.ErrCodeKMSKeyNotAccessibleFault:
				fmt.Println(databasemigrationservice.ErrCodeKMSKeyNotAccessibleFault, aerr.Error())
			case databasemigrationservice.ErrCodeResourceQuotaExceededFault:
				fmt.Println(databasemigrationservice.ErrCodeResourceQuotaExceededFault, aerr.Error())
			case databasemigrationservice.ErrCodeS3ResourceNotFoundFault:
				fmt.Println(databasemigrationservice.ErrCodeS3ResourceNotFoundFault, aerr.Error())
			case databasemigrationservice.ErrCodeS3AccessDeniedFault:
				fmt.Println(databasemigrationservice.ErrCodeS3AccessDeniedFault, aerr.Error())
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// Start Metadata Model Assessment
// Creates a database migration assessment report by assessing the migration complexity
// for
//
//	your source database.
func ExampleDatabaseMigrationService_StartMetadataModelAssessment_shared00() {
	svc := databasemigrationservice.New(session.New())
	input := &databasemigrationservice.StartMetadataModelAssessmentInput{
		MigrationProjectIdentifier: aws.String("arn:aws:dms:us-east-1:012345678901:migration-project:0123456789ABCDEFGHIJKLMNOPQRSTUVWXYZ012"),
		SelectionRules:             aws.String("{\"rules\": [{\"rule-type\": \"selection\",\"rule-id\": \"1\",\"rule-name\": \"1\",\"object-locator\": {\"server-name\": \"aurora-pg.cluster-0a1b2c3d4e5f.us-east-1.rds.amazonaws.com\", \"schema-name\": \"schema1\", \"table-name\": \"Cities\"},\"rule-action\": \"explicit\"} ]}"),
	}

	result, err := svc.StartMetadataModelAssessment(input)
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			case databasemigrationservice.ErrCodeAccessDeniedFault:
				fmt.Println(databasemigrationservice.ErrCodeAccessDeniedFault, aerr.Error())
			case databasemigrationservice.ErrCodeInvalidResourceStateFault:
				fmt.Println(databasemigrationservice.ErrCodeInvalidResourceStateFault, aerr.Error())
			case databasemigrationservice.ErrCodeResourceAlreadyExistsFault:
				fmt.Println(databasemigrationservice.ErrCodeResourceAlreadyExistsFault, aerr.Error())
			case databasemigrationservice.ErrCodeResourceNotFoundFault:
				fmt.Println(databasemigrationservice.ErrCodeResourceNotFoundFault, aerr.Error())
			case databasemigrationservice.ErrCodeKMSKeyNotAccessibleFault:
				fmt.Println(databasemigrationservice.ErrCodeKMSKeyNotAccessibleFault, aerr.Error())
			case databasemigrationservice.ErrCodeResourceQuotaExceededFault:
				fmt.Println(databasemigrationservice.ErrCodeResourceQuotaExceededFault, aerr.Error())
			case databasemigrationservice.ErrCodeS3ResourceNotFoundFault:
				fmt.Println(databasemigrationservice.ErrCodeS3ResourceNotFoundFault, aerr.Error())
			case databasemigrationservice.ErrCodeS3AccessDeniedFault:
				fmt.Println(databasemigrationservice.ErrCodeS3AccessDeniedFault, aerr.Error())
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// Start Metadata Model Conversion
// Converts your source database objects to a format compatible with the target database.
func ExampleDatabaseMigrationService_StartMetadataModelConversion_shared00() {
	svc := databasemigrationservice.New(session.New())
	input := &databasemigrationservice.StartMetadataModelConversionInput{
		MigrationProjectIdentifier: aws.String("arn:aws:dms:us-east-1:012345678901:migration-project:0123456789ABCDEFGHIJKLMNOPQRSTUVWXYZ012"),
		SelectionRules:             aws.String("{\"rules\": [{\"rule-type\": \"selection\",\"rule-id\": \"1\",\"rule-name\": \"1\",\"object-locator\": {\"server-name\": \"aurora-pg.cluster-0a1b2c3d4e5f.us-east-1.rds.amazonaws.com\", \"schema-name\": \"schema1\", \"table-name\": \"Cities\"},\"rule-action\": \"explicit\"} ]}"),
	}

	result, err := svc.StartMetadataModelConversion(input)
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			case databasemigrationservice.ErrCodeAccessDeniedFault:
				fmt.Println(databasemigrationservice.ErrCodeAccessDeniedFault, aerr.Error())
			case databasemigrationservice.ErrCodeInvalidResourceStateFault:
				fmt.Println(databasemigrationservice.ErrCodeInvalidResourceStateFault, aerr.Error())
			case databasemigrationservice.ErrCodeResourceAlreadyExistsFault:
				fmt.Println(databasemigrationservice.ErrCodeResourceAlreadyExistsFault, aerr.Error())
			case databasemigrationservice.ErrCodeResourceNotFoundFault:
				fmt.Println(databasemigrationservice.ErrCodeResourceNotFoundFault, aerr.Error())
			case databasemigrationservice.ErrCodeKMSKeyNotAccessibleFault:
				fmt.Println(databasemigrationservice.ErrCodeKMSKeyNotAccessibleFault, aerr.Error())
			case databasemigrationservice.ErrCodeResourceQuotaExceededFault:
				fmt.Println(databasemigrationservice.ErrCodeResourceQuotaExceededFault, aerr.Error())
			case databasemigrationservice.ErrCodeS3ResourceNotFoundFault:
				fmt.Println(databasemigrationservice.ErrCodeS3ResourceNotFoundFault, aerr.Error())
			case databasemigrationservice.ErrCodeS3AccessDeniedFault:
				fmt.Println(databasemigrationservice.ErrCodeS3AccessDeniedFault, aerr.Error())
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// Start Metadata Model Export As Script
// Saves your converted code to a file as a SQL script, and stores this file on your
// S3 bucket.
func ExampleDatabaseMigrationService_StartMetadataModelExportAsScript_shared00() {
	svc := databasemigrationservice.New(session.New())
	input := &databasemigrationservice.StartMetadataModelExportAsScriptInput{
		FileName:                   aws.String("FILE"),
		MigrationProjectIdentifier: aws.String("arn:aws:dms:us-east-1:012345678901:migration-project:0123456789ABCDEFGHIJKLMNOPQRSTUVWXYZ012"),
		Origin:                     aws.String("SOURCE"),
		SelectionRules:             aws.String("{\"rules\": [{\"rule-type\": \"selection\",\"rule-id\": \"1\",\"rule-name\": \"1\",\"object-locator\": {\"server-name\": \"aurora-pg.cluster-0a1b2c3d4e5f.us-east-1.rds.amazonaws.com\", \"schema-name\": \"schema1\", \"table-name\": \"Cities\"},\"rule-action\": \"explicit\"} ]}"),
	}

	result, err := svc.StartMetadataModelExportAsScript(input)
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			case databasemigrationservice.ErrCodeAccessDeniedFault:
				fmt.Println(databasemigrationservice.ErrCodeAccessDeniedFault, aerr.Error())
			case databasemigrationservice.ErrCodeInvalidResourceStateFault:
				fmt.Println(databasemigrationservice.ErrCodeInvalidResourceStateFault, aerr.Error())
			case databasemigrationservice.ErrCodeResourceAlreadyExistsFault:
				fmt.Println(databasemigrationservice.ErrCodeResourceAlreadyExistsFault, aerr.Error())
			case databasemigrationservice.ErrCodeResourceNotFoundFault:
				fmt.Println(databasemigrationservice.ErrCodeResourceNotFoundFault, aerr.Error())
			case databasemigrationservice.ErrCodeKMSKeyNotAccessibleFault:
				fmt.Println(databasemigrationservice.ErrCodeKMSKeyNotAccessibleFault, aerr.Error())
			case databasemigrationservice.ErrCodeResourceQuotaExceededFault:
				fmt.Println(databasemigrationservice.ErrCodeResourceQuotaExceededFault, aerr.Error())
			case databasemigrationservice.ErrCodeS3ResourceNotFoundFault:
				fmt.Println(databasemigrationservice.ErrCodeS3ResourceNotFoundFault, aerr.Error())
			case databasemigrationservice.ErrCodeS3AccessDeniedFault:
				fmt.Println(databasemigrationservice.ErrCodeS3AccessDeniedFault, aerr.Error())
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// Start Metadata Model Export To Target
// Applies converted database objects to your target database.
func ExampleDatabaseMigrationService_StartMetadataModelExportToTarget_shared00() {
	svc := databasemigrationservice.New(session.New())
	input := &databasemigrationservice.StartMetadataModelExportToTargetInput{
		MigrationProjectIdentifier: aws.String("arn:aws:dms:us-east-1:012345678901:migration-project:EXAMPLEABCDEFGHIJKLMNOPQRSTUVWXYZ012345"),
		OverwriteExtensionPack:     aws.Bool(true),
		SelectionRules:             aws.String("{\"rules\": [{\"rule-type\": \"selection\",\"rule-id\": \"1\",\"rule-name\": \"1\",\"object-locator\": {\"server-name\": \"aurora-pg.cluster-a1b2c3d4e5f6.us-east-1.rds.amazonaws.com\", \"schema-name\": \"schema1\", \"table-name\": \"Cities\"},\"rule-action\": \"explicit\"} ]}"),
	}

	result, err := svc.StartMetadataModelExportToTarget(input)
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			case databasemigrationservice.ErrCodeAccessDeniedFault:
				fmt.Println(databasemigrationservice.ErrCodeAccessDeniedFault, aerr.Error())
			case databasemigrationservice.ErrCodeInvalidResourceStateFault:
				fmt.Println(databasemigrationservice.ErrCodeInvalidResourceStateFault, aerr.Error())
			case databasemigrationservice.ErrCodeResourceAlreadyExistsFault:
				fmt.Println(databasemigrationservice.ErrCodeResourceAlreadyExistsFault, aerr.Error())
			case databasemigrationservice.ErrCodeResourceNotFoundFault:
				fmt.Println(databasemigrationservice.ErrCodeResourceNotFoundFault, aerr.Error())
			case databasemigrationservice.ErrCodeKMSKeyNotAccessibleFault:
				fmt.Println(databasemigrationservice.ErrCodeKMSKeyNotAccessibleFault, aerr.Error())
			case databasemigrationservice.ErrCodeResourceQuotaExceededFault:
				fmt.Println(databasemigrationservice.ErrCodeResourceQuotaExceededFault, aerr.Error())
			case databasemigrationservice.ErrCodeS3ResourceNotFoundFault:
				fmt.Println(databasemigrationservice.ErrCodeS3ResourceNotFoundFault, aerr.Error())
			case databasemigrationservice.ErrCodeS3AccessDeniedFault:
				fmt.Println(databasemigrationservice.ErrCodeS3AccessDeniedFault, aerr.Error())
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// Start Metadata Model Import
// Loads the metadata for all the dependent database objects of the parent object.
func ExampleDatabaseMigrationService_StartMetadataModelImport_shared00() {
	svc := databasemigrationservice.New(session.New())
	input := &databasemigrationservice.StartMetadataModelImportInput{
		MigrationProjectIdentifier: aws.String("arn:aws:dms:us-east-1:012345678901:migration-project:0123456789ABCDEFGHIJKLMNOPQRSTUVWXYZ012"),
		Origin:                     aws.String("SOURCE"),
		Refresh:                    aws.Bool(false),
		SelectionRules:             aws.String("{\"rules\": [{\"rule-type\": \"selection\",\"rule-id\": \"1\",\"rule-name\": \"1\",\"object-locator\": {\"server-name\": \"aurora-pg.cluster-0a1b2c3d4e5f.us-east-1.rds.amazonaws.com\", \"schema-name\": \"schema1\", \"table-name\": \"Cities\"},\"rule-action\": \"explicit\"} ]}"),
	}

	result, err := svc.StartMetadataModelImport(input)
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			case databasemigrationservice.ErrCodeAccessDeniedFault:
				fmt.Println(databasemigrationservice.ErrCodeAccessDeniedFault, aerr.Error())
			case databasemigrationservice.ErrCodeInvalidResourceStateFault:
				fmt.Println(databasemigrationservice.ErrCodeInvalidResourceStateFault, aerr.Error())
			case databasemigrationservice.ErrCodeResourceAlreadyExistsFault:
				fmt.Println(databasemigrationservice.ErrCodeResourceAlreadyExistsFault, aerr.Error())
			case databasemigrationservice.ErrCodeResourceNotFoundFault:
				fmt.Println(databasemigrationservice.ErrCodeResourceNotFoundFault, aerr.Error())
			case databasemigrationservice.ErrCodeKMSKeyNotAccessibleFault:
				fmt.Println(databasemigrationservice.ErrCodeKMSKeyNotAccessibleFault, aerr.Error())
			case databasemigrationservice.ErrCodeResourceQuotaExceededFault:
				fmt.Println(databasemigrationservice.ErrCodeResourceQuotaExceededFault, aerr.Error())
			case databasemigrationservice.ErrCodeS3ResourceNotFoundFault:
				fmt.Println(databasemigrationservice.ErrCodeS3ResourceNotFoundFault, aerr.Error())
			case databasemigrationservice.ErrCodeS3AccessDeniedFault:
				fmt.Println(databasemigrationservice.ErrCodeS3AccessDeniedFault, aerr.Error())
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// Start replication task
// Starts the replication task.
func ExampleDatabaseMigrationService_StartReplicationTask_shared00() {
	svc := databasemigrationservice.New(session.New())
	input := &databasemigrationservice.StartReplicationTaskInput{
		CdcStartTime:             parseTime("2006-01-02T15:04:05.999999999Z", "2016-12-14T13:33:20Z"),
		ReplicationTaskArn:       aws.String("arn:aws:dms:us-east-1:123456789012:rep:6UTDJGBOUS3VI3SUWA66XFJCJQ"),
		StartReplicationTaskType: aws.String("start-replication"),
	}

	result, err := svc.StartReplicationTask(input)
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			case databasemigrationservice.ErrCodeResourceNotFoundFault:
				fmt.Println(databasemigrationservice.ErrCodeResourceNotFoundFault, aerr.Error())
			case databasemigrationservice.ErrCodeInvalidResourceStateFault:
				fmt.Println(databasemigrationservice.ErrCodeInvalidResourceStateFault, aerr.Error())
			case databasemigrationservice.ErrCodeAccessDeniedFault:
				fmt.Println(databasemigrationservice.ErrCodeAccessDeniedFault, aerr.Error())
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// Stop replication task
// Stops the replication task.
func ExampleDatabaseMigrationService_StopReplicationTask_shared00() {
	svc := databasemigrationservice.New(session.New())
	input := &databasemigrationservice.StopReplicationTaskInput{
		ReplicationTaskArn: aws.String("arn:aws:dms:us-east-1:123456789012:endpoint:ASXWXJZLNWNT5HTWCGV2BUJQ7E"),
	}

	result, err := svc.StopReplicationTask(input)
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			case databasemigrationservice.ErrCodeResourceNotFoundFault:
				fmt.Println(databasemigrationservice.ErrCodeResourceNotFoundFault, aerr.Error())
			case databasemigrationservice.ErrCodeInvalidResourceStateFault:
				fmt.Println(databasemigrationservice.ErrCodeInvalidResourceStateFault, aerr.Error())
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// Test conection
// Tests the connection between the replication instance and the endpoint.
func ExampleDatabaseMigrationService_TestConnection_shared00() {
	svc := databasemigrationservice.New(session.New())
	input := &databasemigrationservice.TestConnectionInput{
		EndpointArn:            aws.String("arn:aws:dms:us-east-1:123456789012:endpoint:RAAR3R22XSH46S3PWLC3NJAWKM"),
		ReplicationInstanceArn: aws.String("arn:aws:dms:us-east-1:123456789012:rep:6UTDJGBOUS3VI3SUWA66XFJCJQ"),
	}

	result, err := svc.TestConnection(input)
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			case databasemigrationservice.ErrCodeResourceNotFoundFault:
				fmt.Println(databasemigrationservice.ErrCodeResourceNotFoundFault, aerr.Error())
			case databasemigrationservice.ErrCodeInvalidResourceStateFault:
				fmt.Println(databasemigrationservice.ErrCodeInvalidResourceStateFault, aerr.Error())
			case databasemigrationservice.ErrCodeKMSKeyNotAccessibleFault:
				fmt.Println(databasemigrationservice.ErrCodeKMSKeyNotAccessibleFault, aerr.Error())
			case databasemigrationservice.ErrCodeResourceQuotaExceededFault:
				fmt.Println(databasemigrationservice.ErrCodeResourceQuotaExceededFault, aerr.Error())
			case databasemigrationservice.ErrCodeAccessDeniedFault:
				fmt.Println(databasemigrationservice.ErrCodeAccessDeniedFault, aerr.Error())
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}
