// Copyright 2019-present Facebook Inc. All rights reserved.
// This source code is licensed under the Apache 2.0 license found
// in the LICENSE file in the root directory of this source tree.

// Code generated by ent, DO NOT EDIT.

package ent

import (
	"context"
	"fmt"

	"entgo.io/ent/dialect/sql"
	"entgo.io/ent/dialect/sql/sqlgraph"
	"entgo.io/ent/entc/integration/edgeschema/ent/predicate"
	"entgo.io/ent/entc/integration/edgeschema/ent/usergroup"
	"entgo.io/ent/schema/field"
)

// UserGroupDelete is the builder for deleting a UserGroup entity.
type UserGroupDelete struct {
	config
	hooks    []Hook
	mutation *UserGroupMutation
}

// Where appends a list predicates to the UserGroupDelete builder.
func (ugd *UserGroupDelete) Where(ps ...predicate.UserGroup) *UserGroupDelete {
	ugd.mutation.Where(ps...)
	return ugd
}

// Exec executes the deletion query and returns how many vertices were deleted.
func (ugd *UserGroupDelete) Exec(ctx context.Context) (int, error) {
	var (
		err      error
		affected int
	)
	if len(ugd.hooks) == 0 {
		affected, err = ugd.sqlExec(ctx)
	} else {
		var mut Mutator = MutateFunc(func(ctx context.Context, m Mutation) (Value, error) {
			mutation, ok := m.(*UserGroupMutation)
			if !ok {
				return nil, fmt.Errorf("unexpected mutation type %T", m)
			}
			ugd.mutation = mutation
			affected, err = ugd.sqlExec(ctx)
			mutation.done = true
			return affected, err
		})
		for i := len(ugd.hooks) - 1; i >= 0; i-- {
			if ugd.hooks[i] == nil {
				return 0, fmt.Errorf("ent: uninitialized hook (forgotten import ent/runtime?)")
			}
			mut = ugd.hooks[i](mut)
		}
		if _, err := mut.Mutate(ctx, ugd.mutation); err != nil {
			return 0, err
		}
	}
	return affected, err
}

// ExecX is like Exec, but panics if an error occurs.
func (ugd *UserGroupDelete) ExecX(ctx context.Context) int {
	n, err := ugd.Exec(ctx)
	if err != nil {
		panic(err)
	}
	return n
}

func (ugd *UserGroupDelete) sqlExec(ctx context.Context) (int, error) {
	_spec := &sqlgraph.DeleteSpec{
		Node: &sqlgraph.NodeSpec{
			Table: usergroup.Table,
			ID: &sqlgraph.FieldSpec{
				Type:   field.TypeInt,
				Column: usergroup.FieldID,
			},
		},
	}
	if ps := ugd.mutation.predicates; len(ps) > 0 {
		_spec.Predicate = func(selector *sql.Selector) {
			for i := range ps {
				ps[i](selector)
			}
		}
	}
	affected, err := sqlgraph.DeleteNodes(ctx, ugd.driver, _spec)
	if err != nil && sqlgraph.IsConstraintError(err) {
		err = &ConstraintError{msg: err.Error(), wrap: err}
	}
	return affected, err
}

// UserGroupDeleteOne is the builder for deleting a single UserGroup entity.
type UserGroupDeleteOne struct {
	ugd *UserGroupDelete
}

// Exec executes the deletion query.
func (ugdo *UserGroupDeleteOne) Exec(ctx context.Context) error {
	n, err := ugdo.ugd.Exec(ctx)
	switch {
	case err != nil:
		return err
	case n == 0:
		return &NotFoundError{usergroup.Label}
	default:
		return nil
	}
}

// ExecX is like Exec, but panics if an error occurs.
func (ugdo *UserGroupDeleteOne) ExecX(ctx context.Context) {
	ugdo.ugd.ExecX(ctx)
}
