// Copyright 2017 The Go Authors. All rights reserved.
// Use of this source code is governed by a BSD-style
// license that can be found in the LICENSE file.

// DO NOT EDIT THIS FILE. GENERATED BY mkdoc.sh.
// Edit the documentation in other files and rerun mkdoc.sh to generate this one.

// Dep is a tool for managing dependencies for Go projects
//
// Usage: "dep [command]"
//
// Commands:
//
//   init     Initialize a new project with manifest and lock files
//   status   Report the status of the project's dependencies
//   ensure   Ensure a dependency is safely vendored in the project
//   prune    Prune the vendor tree of unused packages
//   version  Show the dep version information
//
// Examples:
//   dep init                               set up a new project
//   dep ensure                             install the project's dependencies
//   dep ensure -update                     update the locked versions of all dependencies
//   dep ensure -add github.com/pkg/errors  add a dependency to the project
//
// Use "dep help [command]" for more information about a command.
//
// Initialize a new project with manifest and lock files
//
// Usage:
//
//  init [root]
//
// Initialize the project at filepath root by parsing its dependencies, writing
// manifest and lock files, and vendoring the dependencies. If root isn't
// specified, use the current directory.
//
// When configuration for another dependency management tool is detected, it is
// imported into the initial manifest and lock. Use the -skip-tools flag to
// disable this behavior. The following external tools are supported:
// glide, godep, vndr, govend, gb, gvt, glock.
//
// Any dependencies that are not constrained by external configuration use the
// GOPATH analysis below.
//
// By default, the dependencies are resolved over the network. A version will be
// selected from the versions available from the upstream source per the following
// algorithm:
//
//  - Tags conforming to semver (sorted by semver rules)
//  - Default branch(es) (sorted lexicographically)
//  - Non-semver tags (sorted lexicographically)
//
// An alternate mode can be activated by passing -gopath. In this mode, the version
// of each dependency will reflect the current state of the GOPATH. If a dependency
// doesn't exist in the GOPATH, a version will be selected based on the above
// network version selection algorithm.
//
// A Gopkg.toml file will be written with inferred version constraints for all
// direct dependencies. Gopkg.lock will be written with precise versions, and
// vendor/ will be populated with the precise versions written to Gopkg.lock.
//
//
// Report the status of the project's dependencies
//
// Usage:
//
//  status [package...]
//
// With no arguments, print the status of each dependency of the project.
//
//   PROJECT     Import path
//   CONSTRAINT  Version constraint, from the manifest
//   VERSION     Version chosen, from the lock
//   REVISION    VCS revision of the chosen version
//   LATEST      Latest VCS revision available
//   PKGS USED   Number of packages from this project that are actually used
//
// With one or more explicitly specified packages, or with the -detailed flag,
// print an extended status output for each dependency of the project.
//
//   TODO    Another column description
//   FOOBAR  Another column description
//
// Status returns exit code zero if all dependencies are in a "good state".
//
//
// Ensure a dependency is safely vendored in the project
//
// Usage:
//
//  ensure [-update | -add] [-no-vendor | -vendor-only] [-dry-run] [<spec>...]
//
// Project spec:
//
//   <import path>[:alt source URL][@<constraint>]
//
//
// Ensure gets a project into a complete, reproducible, and likely compilable state:
//
//   * All non-stdlib imports are fulfilled
//   * All rules in Gopkg.toml are respected
//   * Gopkg.lock records precise versions for all dependencies
//   * vendor/ is populated according to Gopkg.lock
//
// Ensure has fast techniques to determine that some of these steps may be
// unnecessary. If that determination is made, ensure may skip some steps. Flags
// may be passed to bypass these checks; -vendor-only will allow an out-of-date
// Gopkg.lock to populate vendor/, and -no-vendor will update Gopkg.lock (if
// needed), but never touch vendor/.
//
// The effect of passing project spec arguments varies slightly depending on the
// combination of flags that are passed.
//
//
// Examples:
//
//   dep ensure                                 Populate vendor from existing Gopkg.toml and Gopkg.lock
//   dep ensure -add github.com/pkg/foo         Introduce a named dependency at its newest version
//   dep ensure -add github.com/pkg/foo@^1.0.1  Introduce a named dependency with a particular constraint
//
// For more detailed usage examples, see dep ensure -examples.
//
//
// Prune the vendor tree of unused packages
//
// Usage:
//
//  prune
//
// Prune is used to remove unused packages from your vendor tree.
//
// STABILITY NOTICE: this command creates problems for vendor/ verification. As
// such, it may be removed and/or moved out into a separate project later on.
//
//
// Show the dep version information
//
// Usage:
//
//  version
//
package main
