/*
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS HEADER.
 * 
 * Copyright 1997-2007 Sun Microsystems, Inc. All rights reserved.
 * 
 * The contents of this file are subject to the terms of either the GNU
 * General Public License Version 2 only ("GPL") or the Common Development
 * and Distribution License("CDDL") (collectively, the "License").  You
 * may not use this file except in compliance with the License. You can obtain
 * a copy of the License at https://glassfish.dev.java.net/public/CDDL+GPL.html
 * or glassfish/bootstrap/legal/LICENSE.txt.  See the License for the specific
 * language governing permissions and limitations under the License.
 * 
 * When distributing the software, include this License Header Notice in each
 * file and include the License file at glassfish/bootstrap/legal/LICENSE.txt.
 * Sun designates this particular file as subject to the "Classpath" exception
 * as provided by Sun in the GPL Version 2 section of the License file that
 * accompanied this code.  If applicable, add the following below the License
 * Header, with the fields enclosed by brackets [] replaced by your own
 * identifying information: "Portions Copyrighted [year]
 * [name of copyright owner]"
 * 
 * Contributor(s):
 * 
 * If you wish your version of this file to be governed by only the CDDL or
 * only the GPL Version 2, indicate your decision by adding "[Contributor]
 * elects to include this software in this distribution under the [CDDL or GPL
 * Version 2] license."  If you don't indicate a single choice of license, a
 * recipient has the option to distribute your version of this file under
 * either the CDDL, the GPL Version 2 or to extend the choice of license to
 * its licensees as provided above.  However, if you add GPL Version 2 code
 * and therefore, elected the GPL Version 2 license, then the option applies
 * only if the new code is made subject to such option by the copyright
 * holder.
 */

/**
 * PROPRIETARY/CONFIDENTIAL.  Use of this product is subject to license terms.
 *
 * Copyright 2000-2001 by iPlanet/Sun Microsystems, Inc.,
 * 901 San Antonio Road, Palo Alto, California, 94303, U.S.A.
 * All rights reserved.
 */
package com.sun.enterprise.server;

import javax.naming.InitialContext;

import com.sun.enterprise.config.ConfigContext;
import com.sun.enterprise.config.ConfigException;
import com.sun.enterprise.config.serverbeans.Server;
import com.sun.enterprise.instance.InstanceEnvironment;
import com.sun.enterprise.server.pluggable.PluggableFeatureFactory;

import com.sun.enterprise.InvocationManager;
import com.sun.enterprise.admin.monitor.registry.MonitoringRegistry;

/**
 * ServerContext interface: the server-wide runtime environment created by
 * ApplicationServer and shared by its subsystems such as the web container
 * or EJB container.
 */
public interface ServerContext {

    /** 
     * Get the server command-line arguments
     *
     * @return  the server command-line arguments
     */
    public String[] getCmdLineArgs();

    /**
     * Get a factory for supported pluggable features. The server can support
     * many pluggable features in different editions. This factory allows access
     * to specialized implementation of features.
     */
    public PluggableFeatureFactory getPluggableFeatureFactory();

    /** XXX: begin should move these to Config API */

    /**
     * Get server install root
     *
     * @return  the server install root
     */
    public String getInstallRoot();

    /**
     * Get the server instance name
     *
     * @return  the server instance name
     */
    public String getInstanceName();

    /**
     * Get a URL representation of server configuration
     *
     * @return    the URL to the server configuration
     */
    public String getServerConfigURL();

    /** XXX: end should move these to Config API */
    
    /**
     * Get the server configuration context.
     *
     * @return  the config context for this server instance
     */
    public ConfigContext getConfigContext();
    
    /**
     * Get the server configuration bean.
     *
     * @return  the server config bean
     */
    public com.sun.enterprise.config.serverbeans.Server getConfigBean() 
            throws ConfigException;
    
    /** 
     * Get the initial naming context.
     *
     * @return    the initial naming context
     */
    public InitialContext getInitialContext();

    /**
     * Get the classloader that loads .jars in $instance/lib and classes
     * in $instance/lib/classes.
     *
     * @return  the common class loader for this instance
     */
    public ClassLoader getCommonClassLoader();

    /**
     * Returns the shared class loader for this server instance.
     *
     * @return    the shared class loader 
     */
    public ClassLoader getSharedClassLoader();

    /**
     * Get the parent class loader for the life cycle modules.
     *
     * @return  the parent class loader for the life cycle modules
     */
    public ClassLoader getLifecycleParentClassLoader();

    /**
     * Returns the environment object for this instance.
     *
     *  @return    the environment object for this server instance
     */
    public InstanceEnvironment getInstanceEnvironment();

    /**
     * get the J2EE Server invocation manager
     *
     * @return InvocationManager
     */
    public InvocationManager getInvocationManager();

    /**
     * get the default domain name
     *
     * @return String default domain name
     */
    public String getDefaultDomainName();
    
    /**
     * Returns the MonitoringRegistry implementation used for registration of
     * monitoring stats.
     * @return      instance of MonitoringRegistry 
     */
    public MonitoringRegistry getMonitoringRegistry();
}
