/*
 * Decompiled with CFR 0.152.
 */
package gmonitor.logdata;

import gmonitor.logdata.BinaryBlock;
import gmonitor.logdata.OIDDefElement;
import gmonitor.logdata.UTY;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;

public class OIDDefBlock
extends BinaryBlock {
    protected ArrayList definition = new ArrayList();

    public static OIDDefBlock newInstance(InputStream inputStream, int n) throws IOException {
        OIDDefBlock oIDDefBlock = new OIDDefBlock();
        oIDDefBlock.deserialize(inputStream, n);
        return oIDDefBlock;
    }

    public int getCount() {
        return this.definition.size();
    }

    protected void parse_binary_block(InputStream inputStream) throws IOException {
        int n;
        byte[] byArray = new byte[STRLEN];
        for (int i = 0; i < this.size; i += n + 1) {
            OIDDefElement oIDDefElement = new OIDDefElement();
            n = this.readBytesWithNull(inputStream, byArray);
            oIDDefElement.setOID(UTY.byte2String(byArray, 0, n));
            i += n + 1;
            n = this.readBytesWithNull(inputStream, byArray);
            oIDDefElement.setNickname(UTY.byte2String(byArray, 0, n));
            this.definition.add(oIDDefElement);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String toString() {
        StringBuffer stringBuffer = new StringBuffer("# OIDDefBlock");
        ArrayList arrayList = this.definition;
        synchronized (arrayList) {
            int n = this.definition.size();
            for (int i = 0; i < n; ++i) {
                OIDDefElement oIDDefElement = (OIDDefElement)this.definition.get(i);
                stringBuffer.append('\n');
                stringBuffer.append(oIDDefElement.toString(i));
            }
        }
        return stringBuffer.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getOIDIndex(String string) {
        int n = -1;
        ArrayList arrayList = this.definition;
        synchronized (arrayList) {
            for (int i = 0; i < this.definition.size(); ++i) {
                OIDDefElement oIDDefElement = (OIDDefElement)this.definition.get(i);
                String string2 = oIDDefElement.getNameAndNick();
                if (!string2.equals(string)) continue;
                n = i;
                break;
            }
        }
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getOIDIndexNext(String string, int n) {
        int n2 = -1;
        if (string == null) {
            return n2;
        }
        ArrayList arrayList = this.definition;
        synchronized (arrayList) {
            for (int i = 0; i < this.definition.size(); ++i) {
                OIDDefElement oIDDefElement = (OIDDefElement)this.definition.get(i);
                String string2 = oIDDefElement.getNameAndNick();
                if (!string2.equals(string)) continue;
                if (n <= 1) {
                    n2 = i;
                    break;
                }
                --n;
            }
        }
        return n2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public OIDDefElement getOIDDefElement(int n) {
        OIDDefElement oIDDefElement = null;
        ArrayList arrayList = this.definition;
        synchronized (arrayList) {
            oIDDefElement = (OIDDefElement)this.definition.get(n);
        }
        return oIDDefElement;
    }

    public boolean containsEvent(String string) {
        int n = this.getOIDIndex(string);
        return n >= 0;
    }
}

