// ----------------------------------------------------------------------------
// cty-dat.cxx
//
// Copyright (C) 2018
//		David Freese, W1HKJ
//
// This file is part of fldigi.
//
// Fldigi is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Fldigi is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with fldigi.  If not, see <http://www.gnu.org/licenses/>.
// ----------------------------------------------------------------------------

// internal data file string that is the latest cty.dat as of the 
// publishing date of the software

#include <config.h>
#include <string>

std::string s_ctydat = 
"Sov Mil Order of Malta:   15:  28:  EU:   41.90:   -12.43:    -1.0:  1A:\n\
    1A;\n\
Spratly Islands:          26:  50:  AS:    9.88:  -114.23:    -8.0:  1S:\n\
    9M0,BM9S,BN9S,BO9S,BP9S,BQ9S,BU9S,BV9S,BW9S,BX9S;\n\
Monaco:                   14:  27:  EU:   43.73:    -7.40:    -1.0:  3A:\n\
    3A;\n\
Agalega & St. Brandon:    39:  53:  AF:  -10.45:   -56.67:    -4.0:  3B6:\n\
    3B6,3B7;\n\
Mauritius:                39:  53:  AF:  -20.35:   -57.50:    -4.0:  3B8:\n\
    3B8;\n\
Rodriguez Island:         39:  53:  AF:  -19.70:   -63.42:    -4.0:  3B9:\n\
    3B9;\n\
Equatorial Guinea:        36:  47:  AF:    1.70:   -10.33:    -1.0:  3C:\n\
    3C;\n\
Annobon Island:           36:  52:  AF:   -1.43:    -5.62:    -1.0:  3C0:\n\
    3C0;\n\
Fiji:                     32:  56:  OC:  -17.78:  -177.92:   -12.0:  3D2:\n\
    3D2;\n\
Conway Reef:              32:  56:  OC:  -22.00:  -175.00:   -12.0:  3D2/c:\n\
    =3D2CR;\n\
Rotuma Island:            32:  56:  OC:  -12.48:  -177.08:   -12.0:  3D2/r:\n\
    =3D2RI;\n\
Swaziland:                38:  57:  AF:  -26.65:   -31.48:    -2.0:  3DA:\n\
    3DA;\n\
Tunisia:                  33:  37:  AF:   35.40:    -9.32:    -1.0:  3V:\n\
    3V,TS;\n\
Vietnam:                  26:  49:  AS:   15.80:  -107.90:    -7.0:  3W:\n\
    3W,XV;\n\
Guinea:                   35:  46:  AF:   11.00:    10.68:     0.0:  3X:\n\
    3X;\n\
Bouvet:                   38:  67:  AF:  -54.42:    -3.38:    -1.0:  3Y/b:\n\
    =3Y0E;\n\
Peter 1 Island:           12:  72:  SA:  -68.77:    90.58:     4.0:  3Y/p:\n\
    =3Y0X;\n\
Azerbaijan:               21:  29:  AS:   40.45:   -47.37:    -4.0:  4J:\n\
    4J,4K;\n\
Georgia:                  21:  29:  AS:   42.00:   -45.00:    -4.0:  4L:\n\
    4L;\n\
Montenegro:               15:  28:  EU:   42.50:   -19.28:    -1.0:  4O:\n\
    4O;\n\
Sri Lanka:                22:  41:  AS:    7.60:   -80.70:    -5.5:  4S:\n\
    4P,4Q,4R,4S;\n\
ITU HQ:                   14:  28:  EU:   46.17:    -6.05:    -1.0:  4U1I:\n\
    =4U1ITU,=4U1WRC;\n\
United Nations HQ:        05:  08:  NA:   40.75:    73.97:     5.0:  4U1U:\n\
    =4U1UN;\n\
Vienna Intl Ctr:          15:  28:  EU:   48.20:   -16.30:    -1.0:  *4U1V:\n\
    =4U0R,=4U1A,=4U1VIC,=4U2U,=4Y1A,=C7A;\n\
Timor - Leste:            28:  54:  OC:   -8.80:  -126.05:    -9.0:  4W:\n\
    4W;\n\
Israel:                   20:  39:  AS:   31.32:   -34.82:    -2.0:  4X:\n\
    4X,4Z;\n\
Libya:                    34:  38:  AF:   27.20:   -16.60:    -2.0:  5A:\n\
    5A;\n\
Cyprus:                   20:  39:  AS:   35.00:   -33.00:    -2.0:  5B:\n\
    5B,C4,H2,P3;\n\
Tanzania:                 37:  53:  AF:   -5.75:   -33.92:    -3.0:  5H:\n\
    5H,5I;\n\
Nigeria:                  35:  46:  AF:    9.87:    -7.55:    -1.0:  5N:\n\
    5N,5O;\n\
Madagascar:               39:  53:  AF:  -19.00:   -46.58:    -3.0:  5R:\n\
    5R,5S,6X;\n\
Mauritania:               35:  46:  AF:   20.60:    10.50:     0.0:  5T:\n\
    5T;\n\
Niger:                    35:  46:  AF:   17.63:    -9.43:    -1.0:  5U:\n\
    5U;\n\
Togo:                     35:  46:  AF:    8.40:    -1.28:     0.0:  5V:\n\
    5V;\n\
Samoa:                    32:  62:  OC:  -13.93:   171.70:   -13.0:  5W:\n\
    5W;\n\
Uganda:                   37:  48:  AF:    1.92:   -32.60:    -3.0:  5X:\n\
    5X;\n\
Kenya:                    37:  48:  AF:    0.32:   -38.15:    -3.0:  5Z:\n\
    5Y,5Z;\n\
Senegal:                  35:  46:  AF:   15.20:    14.63:     0.0:  6W:\n\
    6V,6W;\n\
Jamaica:                  08:  11:  NA:   18.20:    77.47:     5.0:  6Y:\n\
    6Y;\n\
Yemen:                    21:  39:  AS:   15.65:   -48.12:    -3.0:  7O:\n\
    7O,=VERSION;\n\
Lesotho:                  38:  57:  AF:  -29.22:   -27.88:    -2.0:  7P:\n\
    7P;\n\
Malawi:                   37:  53:  AF:  -14.00:   -34.00:    -2.0:  7Q:\n\
    7Q;\n\
Algeria:                  33:  37:  AF:   28.00:    -2.00:    -1.0:  7X:\n\
    7R,7T,7U,7V,7W,7X,7Y;\n\
Barbados:                 08:  11:  NA:   13.18:    59.53:     4.0:  8P:\n\
    8P;\n\
Maldives:                 22:  41:  AS:    4.15:   -73.45:    -5.0:  8Q:\n\
    8Q;\n\
Guyana:                   09:  12:  SA:    6.02:    59.45:     4.0:  8R:\n\
    8R;\n\
Croatia:                  15:  28:  EU:   45.18:   -15.30:    -1.0:  9A:\n\
    9A;\n\
Ghana:                    35:  46:  AF:    7.70:     1.57:     0.0:  9G:\n\
    9G;\n\
Malta:                    15:  28:  EU:   35.88:   -14.42:    -1.0:  9H:\n\
    9H;\n\
Zambia:                   36:  53:  AF:  -14.22:   -26.73:    -2.0:  9J:\n\
    9I,9J;\n\
Kuwait:                   21:  39:  AS:   29.38:   -47.38:    -3.0:  9K:\n\
    9K,NLD;\n\
Sierra Leone:             35:  46:  AF:    8.50:    13.25:     0.0:  9L:\n\
    9L;\n\
West Malaysia:            28:  54:  AS:    3.95:  -102.23:    -8.0:  9M2:\n\
    9M,9W;\n\
East Malaysia:            28:  54:  OC:    2.68:  -113.32:    -8.0:  9M6:\n\
    9M6,9M8,9W6,9W8,=9M4CKT,=9M4CRB,=9M4CRP;\n\
Nepal:                    22:  42:  AS:   27.70:   -85.33:   -5.75:  9N:\n\
    9N;\n\
Dem. Rep. of the Congo:   36:  52:  AF:   -3.12:   -23.03:    -1.0:  9Q:\n\
    9O,9P,9Q,9R,9S,9T;\n\
Burundi:                  36:  52:  AF:   -3.17:   -29.78:    -2.0:  9U:\n\
    9U;\n\
Singapore:                28:  54:  AS:    1.37:  -103.78:    -8.0:  9V:\n\
    9V,S6;\n\
Rwanda:                   36:  52:  AF:   -1.75:   -29.82:    -2.0:  9X:\n\
    9X;\n\
Trinidad & Tobago:        09:  11:  SA:   10.38:    61.28:     4.0:  9Y:\n\
    9Y,9Z;\n\
Botswana:                 38:  57:  AF:  -22.00:   -24.00:    -2.0:  A2:\n\
    8O,A2;\n\
Tonga:                    32:  62:  OC:  -21.22:   175.13:   -13.0:  A3:\n\
    A3;\n\
Oman:                     21:  39:  AS:   23.60:   -58.55:    -4.0:  A4:\n\
    A4;\n\
Bhutan:                   22:  41:  AS:   27.40:   -90.18:    -6.0:  A5:\n\
    A5;\n\
United Arab Emirates:     21:  39:  AS:   24.00:   -54.00:    -4.0:  A6:\n\
    A6;\n\
Qatar:                    21:  39:  AS:   25.25:   -51.13:    -3.0:  A7:\n\
    A7;\n\
Bahrain:                  21:  39:  AS:   26.03:   -50.53:    -3.0:  A9:\n\
    A9;\n\
Pakistan:                 21:  41:  AS:   30.00:   -70.00:    -5.0:  AP:\n\
    6P,6Q,6R,6S,AP,AQ,AR,AS;\n\
Scarborough Reef:         27:  50:  AS:   15.08:  -117.72:    -8.0:  BS7:\n\
    =BS7H;\n\
Taiwan:                   24:  44:  AS:   23.72:  -120.88:    -8.0:  BV:\n\
    BM,BN,BO,BP,BQ,BU,BV,BW,BX;\n\
Pratas Island:            24:  44:  AS:   20.70:  -116.70:    -8.0:  BV9P:\n\
    BM9P,BN9P,BO9P,BP9P,BQ9P,BU9P,BV9P,BW9P,BX9P;\n\
China:                    24:  44:  AS:   36.00:  -102.00:    -8.0:  BY:\n\
    3H,3H0(23)[42],3H9(23)[43],3I,3I0(23)[42],3I9(23)[43],3J,3J0(23)[42],\n\
    3J9(23)[43],3K,3K0(23)[42],3K9(23)[43],3L,3L0(23)[42],3L9(23)[43],3M,\n\
    3M0(23)[42],3M9(23)[43],3N,3N0(23)[42],3N9(23)[43],3O,3O0(23)[42],\n\
    3O9(23)[43],3P,3P0(23)[42],3P9(23)[43],3Q,3Q0(23)[42],3Q9(23)[43],3R,\n\
    3R0(23)[42],3R9(23)[43],3S,3S0(23)[42],3S9(23)[43],3T,3T0(23)[42],\n\
    3T9(23)[43],3U,3U0(23)[42],3U9(23)[43],B0(23)[42],B2,B3,B4,B5,B6,B7,B8,\n\
    B9(23)[43],BA,BA0(23)[42],BA9(23)[43],BD,BD0(23)[42],BD9(23)[43],BG,\n\
    BG0(23)[42],BG9(23)[43],BH,BH0(23)[42],BH9(23)[43],BI,BI0(23)[42],\n\
    BI9(23)[43],BJ,BJ0(23)[42],BJ9(23)[43],BL,BL0(23)[42],BL9(23)[43],BT,\n\
    BT0(23)[42],BT9(23)[43],BY,BY0(23)[42],BY9(23)[43],BZ,BZ0(23)[42],\n\
    BZ9(23)[43],XS,XS0(23)[42],XS9(23)[43],B1,B2A[33],B2B[33],B2C[33],B2D[33],\n\
    B2E[33],B2F[33],B2G[33],B2H[33],B2I[33],B2J[33],B2K[33],B2L[33],B2M[33],\n\
    B2N[33],B2O[33],B2P[33],B3G(23)[33],B3H(23)[33],B3I(23)[33],B3J(23)[33],\n\
    B3K(23)[33],B3L(23)[33],B6Q[43],B6R[43],B6S[43],B6T[43],B6U[43],B6V[43],\n\
    B6W[43],B6X[43],B7A[43],B7B[43],B7C[43],B7D[43],B7E[43],B7F[43],B7G[43],\n\
    B7H[43],B7Q[43],B7R[43],B7S[43],B7T[43],B7U[43],B7V[43],B7W[43],B7X[43],\n\
    B8A[43],B8B[43],B8C[43],B8D[43],B8E[43],B8F[43],B8G[43],B8H[43],B8I[43],\n\
    B8J[43],B8K[43],B8L[43],B8M[43],B8N[43],B8O[43],B8P[43],B8Q[43],B8R[43],\n\
    B8S[43],B8T[43],B8U[43],B8V[43],B8W[43],B8X[43],B9A(24)[43],B9B(24)[43],\n\
    B9C(24)[43],B9D(24)[43],B9E(24)[43],B9F(24)[43],B9S(23)[42],B9T(23)[42],\n\
    B9U(23)[42],B9V(23)[42],B9W(23)[42],B9X(23)[42],BA2A[33],BA2B[33],\n\
    BA2C[33],BA2D[33],BA2E[33],BA2F[33],BA2G[33],BA2H[33],BA2I[33],BA2J[33],\n\
    BA2K[33],BA2L[33],BA2M[33],BA2N[33],BA2O[33],BA2P[33],BA3G(23)[33],\n\
    BA3H(23)[33],BA3I(23)[33],BA3J(23)[33],BA3K(23)[33],BA3L(23)[33],BA6Q[43],\n\
    BA6R[43],BA6S[43],BA6T[43],BA6U[43],BA6V[43],BA6W[43],BA6X[43],BA7A[43],\n\
    BA7B[43],BA7C[43],BA7D[43],BA7E[43],BA7F[43],BA7G[43],BA7H[43],BA7Q[43],\n\
    BA7R[43],BA7S[43],BA7T[43],BA7U[43],BA7V[43],BA7W[43],BA7X[43],BA8A[43],\n\
    BA8B[43],BA8C[43],BA8D[43],BA8E[43],BA8F[43],BA8G[43],BA8H[43],BA8I[43],\n\
    BA8J[43],BA8K[43],BA8L[43],BA8M[43],BA8N[43],BA8O[43],BA8P[43],BA8Q[43],\n\
    BA8R[43],BA8S[43],BA8T[43],BA8U[43],BA8V[43],BA8W[43],BA8X[43],\n\
    BA9A(24)[43],BA9B(24)[43],BA9C(24)[43],BA9D(24)[43],BA9E(24)[43],\n\
    BA9F(24)[43],BA9S(23)[42],BA9T(23)[42],BA9U(23)[42],BA9V(23)[42],\n\
    BA9W(23)[42],BA9X(23)[42],BD2A[33],BD2B[33],BD2C[33],BD2D[33],BD2E[33],\n\
    BD2F[33],BD2G[33],BD2H[33],BD2I[33],BD2J[33],BD2K[33],BD2L[33],BD2M[33],\n\
    BD2N[33],BD2O[33],BD2P[33],BD3G(23)[33],BD3H(23)[33],BD3I(23)[33],\n\
    BD3J(23)[33],BD3K(23)[33],BD3L(23)[33],BD6Q[43],BD6R[43],BD6S[43],\n\
    BD6T[43],BD6U[43],BD6V[43],BD6W[43],BD6X[43],BD7A[43],BD7B[43],BD7C[43],\n\
    BD7D[43],BD7E[43],BD7F[43],BD7G[43],BD7H[43],BD7Q[43],BD7R[43],BD7S[43],\n\
    BD7T[43],BD7U[43],BD7V[43],BD7W[43],BD7X[43],BD8A[43],BD8B[43],BD8C[43],\n\
    BD8D[43],BD8E[43],BD8F[43],BD8G[43],BD8H[43],BD8I[43],BD8J[43],BD8K[43],\n\
    BD8L[43],BD8M[43],BD8N[43],BD8O[43],BD8P[43],BD8Q[43],BD8R[43],BD8S[43],\n\
    BD8T[43],BD8U[43],BD8V[43],BD8W[43],BD8X[43],BD9A(24)[43],BD9B(24)[43],\n\
    BD9C(24)[43],BD9D(24)[43],BD9E(24)[43],BD9F(24)[43],BD9S(23)[42],\n\
    BD9T(23)[42],BD9U(23)[42],BD9V(23)[42],BD9W(23)[42],BD9X(23)[42],BG2A[33],\n\
    BG2B[33],BG2C[33],BG2D[33],BG2E[33],BG2F[33],BG2G[33],BG2H[33],BG2I[33],\n\
    BG2J[33],BG2K[33],BG2L[33],BG2M[33],BG2N[33],BG2O[33],BG2P[33],\n\
    BG3G(23)[33],BG3H(23)[33],BG3I(23)[33],BG3J(23)[33],BG3K(23)[33],\n\
    BG3L(23)[33],BG6Q[43],BG6R[43],BG6S[43],BG6T[43],BG6U[43],BG6V[43],\n\
    BG6W[43],BG6X[43],BG7A[43],BG7B[43],BG7C[43],BG7D[43],BG7E[43],BG7F[43],\n\
    BG7G[43],BG7H[43],BG7Q[43],BG7R[43],BG7S[43],BG7T[43],BG7U[43],BG7V[43],\n\
    BG7W[43],BG7X[43],BG8A[43],BG8B[43],BG8C[43],BG8D[43],BG8E[43],BG8F[43],\n\
    BG8G[43],BG8H[43],BG8I[43],BG8J[43],BG8K[43],BG8L[43],BG8M[43],BG8N[43],\n\
    BG8O[43],BG8P[43],BG8Q[43],BG8R[43],BG8S[43],BG8T[43],BG8U[43],BG8V[43],\n\
    BG8W[43],BG8X[43],BG9A(24)[43],BG9B(24)[43],BG9C(24)[43],BG9D(24)[43],\n\
    BG9E(24)[43],BG9F(24)[43],BG9S(23)[42],BG9T(23)[42],BG9U(23)[42],\n\
    BG9V(23)[42],BG9W(23)[42],BG9X(23)[42],BH2A[33],BH2B[33],BH2C[33],\n\
    BH2D[33],BH2E[33],BH2F[33],BH2G[33],BH2H[33],BH2I[33],BH2J[33],BH2K[33],\n\
    BH2L[33],BH2M[33],BH2N[33],BH2O[33],BH2P[33],BH3G(23)[33],BH3H(23)[33],\n\
    BH3I(23)[33],BH3J(23)[33],BH3K(23)[33],BH3L(23)[33],BH6Q[43],BH6R[43],\n\
    BH6S[43],BH6T[43],BH6U[43],BH6V[43],BH6W[43],BH6X[43],BH7A[43],BH7B[43],\n\
    BH7C[43],BH7D[43],BH7E[43],BH7F[43],BH7G[43],BH7H[43],BH7Q[43],BH7R[43],\n\
    BH7S[43],BH7T[43],BH7U[43],BH7V[43],BH7W[43],BH7X[43],BH8A[43],BH8B[43],\n\
    BH8C[43],BH8D[43],BH8E[43],BH8F[43],BH8G[43],BH8H[43],BH8I[43],BH8J[43],\n\
    BH8K[43],BH8L[43],BH8M[43],BH8N[43],BH8O[43],BH8P[43],BH8Q[43],BH8R[43],\n\
    BH8S[43],BH8T[43],BH8U[43],BH8V[43],BH8W[43],BH8X[43],BH9A(24)[43],\n\
    BH9B(24)[43],BH9C(24)[43],BH9D(24)[43],BH9E(24)[43],BH9F(24)[43],\n\
    BH9S(23)[42],BH9T(23)[42],BH9U(23)[42],BH9V(23)[42],BH9W(23)[42],\n\
    BH9X(23)[42],BI2A[33],BI2B[33],BI2C[33],BI2D[33],BI2E[33],BI2F[33],\n\
    BI2G[33],BI2H[33],BI2I[33],BI2J[33],BI2K[33],BI2L[33],BI2M[33],BI2N[33],\n\
    BI2O[33],BI2P[33],BI3G(23)[33],BI3H(23)[33],BI3I(23)[33],BI3J(23)[33],\n\
    BI3K(23)[33],BI3L(23)[33],BI6Q[43],BI6R[43],BI6S[43],BI6T[43],BI6U[43],\n\
    BI6V[43],BI6W[43],BI6X[43],BI7A[43],BI7B[43],BI7C[43],BI7D[43],BI7E[43],\n\
    BI7F[43],BI7G[43],BI7H[43],BI7Q[43],BI7R[43],BI7S[43],BI7T[43],BI7U[43],\n\
    BI7V[43],BI7W[43],BI7X[43],BI8A[43],BI8B[43],BI8C[43],BI8D[43],BI8E[43],\n\
    BI8F[43],BI8G[43],BI8H[43],BI8I[43],BI8J[43],BI8K[43],BI8L[43],BI8M[43],\n\
    BI8N[43],BI8O[43],BI8P[43],BI8Q[43],BI8R[43],BI8S[43],BI8T[43],BI8U[43],\n\
    BI8V[43],BI8W[43],BI8X[43],BI9A(24)[43],BI9B(24)[43],BI9C(24)[43],\n\
    BI9D(24)[43],BI9E(24)[43],BI9F(24)[43],BI9S(23)[42],BI9T(23)[42],\n\
    BI9U(23)[42],BI9V(23)[42],BI9W(23)[42],BI9X(23)[42],BJ2A[33],BJ2B[33],\n\
    BJ2C[33],BJ2D[33],BJ2E[33],BJ2F[33],BJ2G[33],BJ2H[33],BJ2I[33],BJ2J[33],\n\
    BJ2K[33],BJ2L[33],BJ2M[33],BJ2N[33],BJ2O[33],BJ2P[33],BJ3G(23)[33],\n\
    BJ3H(23)[33],BJ3I(23)[33],BJ3J(23)[33],BJ3K(23)[33],BJ3L(23)[33],BJ6Q[43],\n\
    BJ6R[43],BJ6S[43],BJ6T[43],BJ6U[43],BJ6V[43],BJ6W[43],BJ6X[43],BJ7A[43],\n\
    BJ7B[43],BJ7C[43],BJ7D[43],BJ7E[43],BJ7F[43],BJ7G[43],BJ7H[43],BJ7Q[43],\n\
    BJ7R[43],BJ7S[43],BJ7T[43],BJ7U[43],BJ7V[43],BJ7W[43],BJ7X[43],BJ8A[43],\n\
    BJ8B[43],BJ8C[43],BJ8D[43],BJ8E[43],BJ8F[43],BJ8G[43],BJ8H[43],BJ8I[43],\n\
    BJ8J[43],BJ8K[43],BJ8L[43],BJ8M[43],BJ8N[43],BJ8O[43],BJ8P[43],BJ8Q[43],\n\
    BJ8R[43],BJ8S[43],BJ8T[43],BJ8U[43],BJ8V[43],BJ8W[43],BJ8X[43],\n\
    BJ9A(24)[43],BJ9B(24)[43],BJ9C(24)[43],BJ9D(24)[43],BJ9E(24)[43],\n\
    BJ9F(24)[43],BJ9S(23)[42],BJ9T(23)[42],BJ9U(23)[42],BJ9V(23)[42],\n\
    BJ9W(23)[42],BJ9X(23)[42],BL2A[33],BL2B[33],BL2C[33],BL2D[33],BL2E[33],\n\
    BL2F[33],BL2G[33],BL2H[33],BL2I[33],BL2J[33],BL2K[33],BL2L[33],BL2M[33],\n\
    BL2N[33],BL2O[33],BL2P[33],BL3G(23)[33],BL3H(23)[33],BL3I(23)[33],\n\
    BL3J(23)[33],BL3K(23)[33],BL3L(23)[33],BL6Q[43],BL6R[43],BL6S[43],\n\
    BL6T[43],BL6U[43],BL6V[43],BL6W[43],BL6X[43],BL7A[43],BL7B[43],BL7C[43],\n\
    BL7D[43],BL7E[43],BL7F[43],BL7G[43],BL7H[43],BL7Q[43],BL7R[43],BL7S[43],\n\
    BL7T[43],BL7U[43],BL7V[43],BL7W[43],BL7X[43],BL8A[43],BL8B[43],BL8C[43],\n\
    BL8D[43],BL8E[43],BL8F[43],BL8G[43],BL8H[43],BL8I[43],BL8J[43],BL8K[43],\n\
    BL8L[43],BL8M[43],BL8N[43],BL8O[43],BL8P[43],BL8Q[43],BL8R[43],BL8S[43],\n\
    BL8T[43],BL8U[43],BL8V[43],BL8W[43],BL8X[43],BL9A(24)[43],BL9B(24)[43],\n\
    BL9C(24)[43],BL9D(24)[43],BL9E(24)[43],BL9F(24)[43],BL9S(23)[42],\n\
    BL9T(23)[42],BL9U(23)[42],BL9V(23)[42],BL9W(23)[42],BL9X(23)[42],BT2A[33],\n\
    BT2B[33],BT2C[33],BT2D[33],BT2E[33],BT2F[33],BT2G[33],BT2H[33],BT2I[33],\n\
    BT2J[33],BT2K[33],BT2L[33],BT2M[33],BT2N[33],BT2O[33],BT2P[33],\n\
    BT3G(23)[33],BT3H(23)[33],BT3I(23)[33],BT3J(23)[33],BT3K(23)[33],\n\
    BT3L(23)[33],BT6Q[43],BT6R[43],BT6S[43],BT6T[43],BT6U[43],BT6V[43],\n\
    BT6W[43],BT6X[43],BT7A[43],BT7B[43],BT7C[43],BT7D[43],BT7E[43],BT7F[43],\n\
    BT7G[43],BT7H[43],BT7Q[43],BT7R[43],BT7S[43],BT7T[43],BT7U[43],BT7V[43],\n\
    BT7W[43],BT7X[43],BT8A[43],BT8B[43],BT8C[43],BT8D[43],BT8E[43],BT8F[43],\n\
    BT8G[43],BT8H[43],BT8I[43],BT8J[43],BT8K[43],BT8L[43],BT8M[43],BT8N[43],\n\
    BT8O[43],BT8P[43],BT8Q[43],BT8R[43],BT8S[43],BT8T[43],BT8U[43],BT8V[43],\n\
    BT8W[43],BT8X[43],BT9A(24)[43],BT9B(24)[43],BT9C(24)[43],BT9D(24)[43],\n\
    BT9E(24)[43],BT9F(24)[43],BT9S(23)[42],BT9T(23)[42],BT9U(23)[42],\n\
    BT9V(23)[42],BT9W(23)[42],BT9X(23)[42],BY2A[33],BY2B[33],BY2C[33],\n\
    BY2D[33],BY2E[33],BY2F[33],BY2G[33],BY2H[33],BY2I[33],BY2J[33],BY2K[33],\n\
    BY2L[33],BY2M[33],BY2N[33],BY2O[33],BY2P[33],BY3G(23)[33],BY3H(23)[33],\n\
    BY3I(23)[33],BY3J(23)[33],BY3K(23)[33],BY3L(23)[33],BY6Q[43],BY6R[43],\n\
    BY6S[43],BY6T[43],BY6U[43],BY6V[43],BY6W[43],BY6X[43],BY7A[43],BY7B[43],\n\
    BY7C[43],BY7D[43],BY7E[43],BY7F[43],BY7G[43],BY7H[43],BY7Q[43],BY7R[43],\n\
    BY7S[43],BY7T[43],BY7U[43],BY7V[43],BY7W[43],BY7X[43],BY8A[43],BY8B[43],\n\
    BY8C[43],BY8D[43],BY8E[43],BY8F[43],BY8G[43],BY8H[43],BY8I[43],BY8J[43],\n\
    BY8K[43],BY8L[43],BY8M[43],BY8N[43],BY8O[43],BY8P[43],BY8Q[43],BY8R[43],\n\
    BY8S[43],BY8T[43],BY8U[43],BY8V[43],BY8W[43],BY8X[43],BY9A(24)[43],\n\
    BY9B(24)[43],BY9C(24)[43],BY9D(24)[43],BY9E(24)[43],BY9F(24)[43],\n\
    BY9S(23)[42],BY9T(23)[42],BY9U(23)[42],BY9V(23)[42],BY9W(23)[42],\n\
    BY9X(23)[42],BZ2A[33],BZ2B[33],BZ2C[33],BZ2D[33],BZ2E[33],BZ2F[33],\n\
    BZ2G[33],BZ2H[33],BZ2I[33],BZ2J[33],BZ2K[33],BZ2L[33],BZ2M[33],BZ2N[33],\n\
    BZ2O[33],BZ2P[33],BZ3G(23)[33],BZ3H(23)[33],BZ3I(23)[33],BZ3J(23)[33],\n\
    BZ3K(23)[33],BZ3L(23)[33],BZ6Q[43],BZ6R[43],BZ6S[43],BZ6T[43],BZ6U[43],\n\
    BZ6V[43],BZ6W[43],BZ6X[43],BZ7A[43],BZ7B[43],BZ7C[43],BZ7D[43],BZ7E[43],\n\
    BZ7F[43],BZ7G[43],BZ7H[43],BZ7Q[43],BZ7R[43],BZ7S[43],BZ7T[43],BZ7U[43],\n\
    BZ7V[43],BZ7W[43],BZ7X[43],BZ8A[43],BZ8B[43],BZ8C[43],BZ8D[43],BZ8E[43],\n\
    BZ8F[43],BZ8G[43],BZ8H[43],BZ8I[43],BZ8J[43],BZ8K[43],BZ8L[43],BZ8M[43],\n\
    BZ8N[43],BZ8O[43],BZ8P[43],BZ8Q[43],BZ8R[43],BZ8S[43],BZ8T[43],BZ8U[43],\n\
    BZ8V[43],BZ8W[43],BZ8X[43],BZ9A(24)[43],BZ9B(24)[43],BZ9C(24)[43],\n\
    BZ9D(24)[43],BZ9E(24)[43],BZ9F(24)[43],BZ9S(23)[42],BZ9T(23)[42],\n\
    BZ9U(23)[42],BZ9V(23)[42],BZ9W(23)[42],BZ9X(23)[42],=BG9XD/7;\n\
Nauru:                    31:  65:  OC:   -0.52:  -166.92:   -12.0:  C2:\n\
    C2;\n\
Andorra:                  14:  27:  EU:   42.58:    -1.62:    -1.0:  C3:\n\
    C3;\n\
The Gambia:               35:  46:  AF:   13.40:    16.38:     0.0:  C5:\n\
    C5;\n\
Bahamas:                  08:  11:  NA:   24.25:    76.00:     5.0:  C6:\n\
    C6;\n\
Mozambique:               37:  53:  AF:  -18.25:   -35.00:    -2.0:  C9:\n\
    C8,C9;\n\
Chile:                    12:  14:  SA:  -30.00:    71.00:     4.0:  CE:\n\
    3G,CA,CB,CC,CD,CE,XQ,XR,3G7[16],3G8[16],CA7[16],CA8[16],CB7[16],CB8[16],\n\
    CC7[16],CC8[16],CD7[16],CD8[16],CE7[16],CE8[16],XQ7[16],XQ8[16],XR7[16],\n\
    XR8[16],=CE6PGO[16],=XQ6CFX[16],=XQ6OA[16],=XR6F[16];\n\
San Felix & San Ambrosio: 12:  14:  SA:  -26.28:    80.07:     4.0:  CE0X:\n\
    3G0X,CA0X,CB0X,CC0X,CD0X,CE0X,XQ0X,XR0X;\n\
Easter Island:            12:  63:  SA:  -27.10:   109.37:     6.0:  CE0Y:\n\
    3G0,CA0,CB0,CC0,CD0,CE0,XQ0,XR0;\n\
Juan Fernandez Islands:   12:  14:  SA:  -33.60:    78.85:     4.0:  CE0Z:\n\
    3G0Z,CA0Z,CB0Z,CC0Z,CD0Z,CE0I,CE0Z,XQ0Z,XR0Z;\n\
Antarctica:               13:  74:  SA:  -90.00:     0.00:     0.0:  CE9:\n\
    3Y[73],AX0(39)[69],AY1Z[73],AY2Z[73],AY3Z[73],AY4Z[73],AY5Z[73],AY6Z[73],\n\
    AY7Z[73],AY8Z[73],AY9Z[73],FT0Y(30)[70],FT1Y(30)[70],FT2Y(30)[70],\n\
    FT3Y(30)[70],FT4Y(30)[70],FT5Y(30)[70],FT6Y(30)[70],FT7Y(30)[70],\n\
    FT8Y(30)[70],LU1Z[73],LU2Z[73],LU3Z[73],LU4Z[73],LU5Z[73],LU6Z[73],\n\
    LU7Z[73],LU8Z[73],LU9Z[73],RI1AN(29)[69],VI0(39)[69],VK0(39)[69],\n\
    ZL5(30)[71],ZM5(30)[71],ZS7(38)[67],=8J1RL(39)[67],=DP0GVN(38)[67],\n\
    =DP1POL(38)[67],=EM1U[73],=EM1UA[73],=IA0/IZ1KHY/P(29)[70],=KC4AAA(39),\n\
    =KC4AAC[73],=KC4USB(12),=KC4USV(30)[71],=RI1ANC(29)[70],=RI1ANZ(39)[69],\n\
    =VP8CTR[73];\n\
Cuba:                     08:  11:  NA:   21.50:    80.00:     5.0:  CM:\n\
    CL,CM,CO,T4;\n\
Morocco:                  33:  37:  AF:   32.00:     5.00:     0.0:  CN:\n\
    5C,5D,5E,5F,5G,CN;\n\
Bolivia:                  10:  12:  SA:  -17.00:    65.00:     4.0:  CP:\n\
    CP,CP2[14],CP3[14],CP4[14],CP5[14],CP6[14],CP7[14];\n\
Portugal:                 14:  37:  EU:   39.50:     8.00:     0.0:  CT:\n\
    CQ,CR,CS,CT;\n\
Madeira Islands:          33:  36:  AF:   32.75:    16.95:     0.0:  CT3:\n\
    CQ2,CQ3,CQ9,CR3,CR9,CS3,CS9,CT3,CT9;\n\
Azores:                   14:  36:  EU:   38.70:    27.23:     1.0:  CU:\n\
    CQ1,CQ8,CR1,CR2,CR8,CS4,CS8,CT8,CU;\n\
Uruguay:                  13:  14:  SA:  -33.00:    56.00:     3.0:  CX:\n\
    CV,CW,CX;\n\
Sable Island:             05:  09:  NA:   43.93:    59.90:     4.0:  CY0:\n\
    CY0;\n\
St. Paul Island:          05:  09:  NA:   47.00:    60.00:     4.0:  CY9:\n\
    CY9;\n\
Angola:                   36:  52:  AF:  -12.50:   -18.50:    -1.0:  D2:\n\
    D2,D3;\n\
Cape Verde:               35:  46:  AF:   16.00:    24.00:     1.0:  D4:\n\
    D4;\n\
Comoros:                  39:  53:  AF:  -11.63:   -43.30:    -3.0:  D6:\n\
    D6;\n\
Fed. Rep. of Germany:     14:  28:  EU:   51.00:   -10.00:    -1.0:  DL:\n\
    DA,DB,DC,DD,DE,DF,DG,DH,DI,DJ,DK,DL,DM,DN,DO,DP,DQ,DR,Y2,Y3,Y4,Y5,Y6,Y7,\n\
    Y8,Y9;\n\
Philippines:              27:  50:  OC:   13.00:  -122.00:    -8.0:  DU:\n\
    4D,4E,4F,4G,4H,4I,DU,DV,DW,DX,DY,DZ;\n\
Eritrea:                  37:  48:  AF:   15.00:   -39.00:    -3.0:  E3:\n\
    E3;\n\
Palestine:                20:  39:  AS:   31.28:   -34.27:    -2.0:  E4:\n\
    E4;\n\
North Cook Islands:       32:  62:  OC:  -10.02:   161.08:    10.0:  E5/n:\n\
    =E51PT,=E51WL[63];\n\
South Cook Islands:       32:  63:  OC:  -21.90:   157.93:    10.0:  E5/s:\n\
    E5;\n\
Niue:                     32:  62:  OC:  -19.03:   169.85:    11.0:  E6:\n\
    E6;\n\
Bosnia-Herzegovina:       15:  28:  EU:   44.32:   -17.57:    -1.0:  E7:\n\
    E7;\n\
Spain:                    14:  37:  EU:   40.37:     4.88:    -1.0:  EA:\n\
    AM,AN,AO,EA,EB,EC,ED,EE,EF,EG,EH,=EA1RCI/KD,=EA1URO/KD,=EA2EZ/P,=EA3HSD/P,\n\
    =EA5CC/P,=EA5EZ/P,=EA9HU;\n\
Balearic Islands:         14:  37:  EU:   39.60:    -2.95:    -1.0:  EA6:\n\
    AM6,AN6,AO6,EA6,EB6,EC6,ED6,EE6,EF6,EG6,EH6,=AM70URE/6;\n\
Canary Islands:           33:  36:  AF:   28.32:    15.85:     0.0:  EA8:\n\
    AM8,AN8,AO8,EA8,EB8,EC8,ED8,EE8,EF8,EG8,EH8,=AM70URE/8;\n\
Ceuta & Melilla:          33:  37:  AF:   35.90:     5.27:    -1.0:  EA9:\n\
    AM9,AN9,AO9,EA9,EB9,EC9,ED9,EE9,EF9,EG9,EH9,=AM70URE/9,=EA9PD/P;\n\
Ireland:                  14:  27:  EU:   53.13:     8.02:     0.0:  EI:\n\
    EI,EJ;\n\
Armenia:                  21:  29:  AS:   40.40:   -44.90:    -4.0:  EK:\n\
    EK;\n\
Liberia:                  35:  46:  AF:    6.50:     9.50:     0.0:  EL:\n\
    5L,5M,6Z,A8,D5,EL;\n\
Iran:                     21:  40:  AS:   32.00:   -53.00:    -3.5:  EP:\n\
    9B,9C,9D,EP,EQ;\n\
Moldova:                  16:  29:  EU:   47.00:   -29.00:    -2.0:  ER:\n\
    ER;\n\
Estonia:                  15:  29:  EU:   59.00:   -25.00:    -2.0:  ES:\n\
    ES;\n\
Ethiopia:                 37:  48:  AF:    9.00:   -39.00:    -3.0:  ET:\n\
    9E,9F,ET;\n\
Belarus:                  16:  29:  EU:   54.00:   -28.00:    -2.0:  EU:\n\
    EU,EV,EW;\n\
Kyrgyzstan:               17:  30:  AS:   41.70:   -74.13:    -6.0:  EX:\n\
    EX,EX0P[31],EX0Q[31],EX2P[31],EX2Q[31],EX6P[31],EX6Q[31],EX7P[31],\n\
    EX7Q[31],EX8P[31],EX8Q[31];\n\
Tajikistan:               17:  30:  AS:   38.82:   -71.22:    -5.0:  EY:\n\
    EY;\n\
Turkmenistan:             17:  30:  AS:   38.00:   -58.00:    -5.0:  EZ:\n\
    EZ;\n\
France:                   14:  27:  EU:   46.00:    -2.00:    -1.0:  F:\n\
    F,HW,HX,HY,TH,TM,TP,TQ,TV;\n\
Guadeloupe:               08:  11:  NA:   16.13:    61.67:     4.0:  FG:\n\
    FG,=TO1T;\n\
Mayotte:                  39:  53:  AF:  -12.88:   -45.15:    -3.0:  FH:\n\
    FH;\n\
St. Barthelemy:           08:  11:  NA:   17.90:    62.83:     4.0:  FJ:\n\
    FJ;\n\
New Caledonia:            32:  56:  OC:  -21.50:  -165.50:   -11.0:  FK:\n\
    FK;\n\
Chesterfield Islands:     30:  56:  OC:  -19.87:  -158.32:   -11.0:  FK/c:\n\
    =TX3X;\n\
Martinique:               08:  11:  NA:   14.70:    61.03:     4.0:  FM:\n\
    FM,=TO5A,=TO5T,=TO7A;\n\
French Polynesia:         32:  63:  OC:  -17.65:   149.40:    10.0:  FO:\n\
    FO;\n\
Austral Islands:          32:  63:  OC:  -23.37:   149.48:    10.0:  FO/a:\n\
    =TX2A;\n\
Clipperton Island:        07:  10:  NA:   10.28:   109.22:     8.0:  FO/c:\n\
    =TX5P;\n\
Marquesas Islands:        31:  63:  OC:   -8.92:   140.07:     9.5:  FO/m:\n\
    =TX5EG;\n\
St. Pierre & Miquelon:    05:  09:  NA:   46.77:    56.20:     3.0:  FP:\n\
    FP,=TO5M;\n\
Reunion Island:           39:  53:  AF:  -21.12:   -55.48:    -4.0:  FR:\n\
    FR;\n\
St. Martin:               08:  11:  NA:   18.08:    63.03:     4.0:  FS:\n\
    FS;\n\
Glorioso Islands:         39:  53:  AF:  -11.55:   -47.28:    -4.0:  FT/g:\n\
    FT0G,FT1G,FT2G,FT3G,FT4G,FT5G,FT6G,FT7G,FT8G,FT9G;\n\
Juan de Nova, Europa:     39:  53:  AF:  -17.05:   -42.72:    -3.0:  FT/j:\n\
    FT0E,FT0J,FT1E,FT1J,FT2E,FT2J,FT3E,FT3J,FT4E,FT4J,FT6E,FT6J,FT7E,FT7J,\n\
    FT8E,FT8J,FT9E,FT9J;\n\
Tromelin Island:          39:  53:  AF:  -15.88:   -54.50:    -4.0:  FT/t:\n\
    FT0T,FT1T,FT2T,FT3T,FT4T,FT5T,FT6T,FT7T,FT8T,FT9T;\n\
Crozet Island:            39:  68:  AF:  -46.42:   -51.75:    -5.0:  FT/w:\n\
    FT0W,FT4W,FT5W,FT8W;\n\
Kerguelen Islands:        39:  68:  AF:  -49.00:   -69.27:    -5.0:  FT/x:\n\
    FT0X,FT2X,FT4X,FT5X,FT8X;\n\
Amsterdam & St. Paul Is.: 39:  68:  AF:  -37.85:   -77.53:    -5.0:  FT/z:\n\
    FT0Z,FT1Z,FT2Z,FT3Z,FT4Z,FT5Z,FT6Z,FT7Z,FT8Z;\n\
Wallis & Futuna Islands:  32:  62:  OC:  -13.30:   176.20:   -12.0:  FW:\n\
    FW,TW;\n\
French Guiana:            09:  12:  SA:    4.00:    53.00:     3.0:  FY:\n\
    FY,=TO1A;\n\
England:                  14:  27:  EU:   52.77:     1.47:     0.0:  G:\n\
    2E,G,M;\n\
Isle of Man:              14:  27:  EU:   54.20:     4.53:     0.0:  GD:\n\
    2D,GD,GT,MD,MT,=GB19CIM;\n\
Northern Ireland:         14:  27:  EU:   54.73:     6.68:     0.0:  GI:\n\
    2I,GI,GN,MI,MN,=GB19CGI,=GB19CNI,=GB2MAC,=GB3NGI,=GB4SOS,=GB4UAS;\n\
Jersey:                   14:  27:  EU:   49.22:     2.18:     0.0:  GJ:\n\
    2J,GH,GJ,MH,MJ,=GB19CJ;\n\
Shetland Islands:         14:  27:  EU:   60.50:     1.50:     0.0:  *GM/s:\n\
    =2M0BDR,=2M0BDT,=2M0CPN,=2M0GFC,=2M0SEG,=2M0SPX,=2M0ZET,=GB0DAW,=GB2DAW,\n\
    =GB2ELH,=GB3LER,=GB3LER/B,=GB4LER,=GM0AVR,=GM0CXQ,=GM0EKM,=GM0GFL,=GM0ILB,\n\
    =GM0JDB,=GM1FGN,=GM1KKI,=GM1ZNR,=GM3WHT,=GM3ZET,=GM4IPK,=GM4JPI,=GM4LBE,\n\
    =GM4LER,=GM4PXG,=GM4SLV,=GM4SSA,=GM4WXQ,=GM4ZHL,=GM6RQW,=GM6YQA,=GM7AFE,\n\
    =GM7GWW,=GM8LNH,=GM8MMA,=GM8YEC,=GS3ZET,=MM0LSM,=MM0NQY,=MM0VIK,=MM0XAU,\n\
    =MM0ZAL,=MM0ZCG,=MM0ZRC,=MM1FJM,=MM3VQO,=MM5PSL,=MM5YLO,=MM6BDU,=MM6BZQ,\n\
    =MM6IKB,=MM6IMB,=MM6MFA,=MM6PTE,=MM6SJK,=MM6YLO,=MM6ZBG,=MM6ZDW,=MM8A,\n\
    =MS0ZCG,=MS0ZET;\n\
Scotland:                 14:  27:  EU:   56.82:     4.18:     0.0:  GM:\n\
    2A,2M,GM,GS,MA,MM,MS,=GB0DAW,=GB0SSB,=GB19CGM,=GB19CS,=GB2DAW,=GB2ELH,\n\
    =GB2JCM,=GB2KDR,=GB2MOF,=GB2NMM,=GB2OL,=GB2OWM,=GB2RDR,=GB3ANG,=GB3LER,\n\
    =GB3LER/B,=GB4LER;\n\
Guernsey:                 14:  27:  EU:   49.45:     2.58:     0.0:  GU:\n\
    2U,GP,GU,MP,MU,=GB19CG;\n\
Wales:                    14:  27:  EU:   52.28:     3.73:     0.0:  GW:\n\
    2W,GC,GW,MC,MW,=GB0ATM,=GB19CGW,=GB19CW,=GB19SG,=GB2HMM,=GB2IMD,=GB2ORM,\n\
    =GB2TD,=GB2VK;\n\
Solomon Islands:          28:  51:  OC:   -9.00:  -160.00:   -11.0:  H4:\n\
    H4;\n\
Temotu Province:          32:  51:  OC:  -10.72:  -165.80:   -11.0:  H40:\n\
    H40;\n\
Hungary:                  15:  28:  EU:   47.12:   -19.28:    -1.0:  HA:\n\
    HA,HG;\n\
Switzerland:              14:  28:  EU:   46.87:    -8.12:    -1.0:  HB:\n\
    HB,HE;\n\
Liechtenstein:            14:  28:  EU:   47.13:    -9.57:    -1.0:  HB0:\n\
    HB0,HE0;\n\
Ecuador:                  10:  12:  SA:   -1.40:    78.40:     5.0:  HC:\n\
    HC,HD;\n\
Galapagos Islands:        10:  12:  SA:   -0.78:    91.03:     6.0:  HC8:\n\
    HC8,HD8;\n\
Haiti:                    08:  11:  NA:   19.02:    72.18:     5.0:  HH:\n\
    4V,HH;\n\
Dominican Republic:       08:  11:  NA:   19.13:    70.68:     4.0:  HI:\n\
    HI;\n\
Colombia:                 09:  12:  SA:    5.00:    74.00:     5.0:  HK:\n\
    5J,5K,HJ,HK;\n\
San Andres & Providencia: 07:  11:  NA:   12.55:    81.72:     5.0:  HK0/a:\n\
    5J0,5K0,HJ0,HK0;\n\
Malpelo Island:           09:  12:  SA:    3.98:    81.58:     5.0:  HK0/m:\n\
    HJ0M,HK0M,=HK0TU;\n\
Republic of Korea:        25:  44:  AS:   36.23:  -127.90:    -9.0:  HL:\n\
    6K,6L,6M,6N,D7,D8,D9,DS,DT,HL,KL9K;\n\
Panama:                   07:  11:  NA:    9.00:    80.00:     5.0:  HP:\n\
    3E,3F,H3,H8,H9,HO,HP;\n\
Honduras:                 07:  11:  NA:   15.00:    87.00:     6.0:  HR:\n\
    HQ,HR;\n\
Thailand:                 26:  49:  AS:   12.60:   -99.70:    -7.0:  HS:\n\
    E2,HS;\n\
Vatican City:             15:  28:  EU:   41.90:   -12.47:    -1.0:  HV:\n\
    HV;\n\
Saudi Arabia:             21:  39:  AS:   24.20:   -43.83:    -3.0:  HZ:\n\
    7Z,8Z,HZ;\n\
Italy:                    15:  28:  EU:   42.82:   -12.58:    -1.0:  I:\n\
    I,=4U0WFP,=4U1GSC,=4U5F,=4U73B;\n\
African Italy:            33:  37:  AF:   35.67:   -12.67:    -1.0:  *IG9:\n\
    IG9,IH9;\n\
Sardinia:                 15:  28:  EU:   40.15:    -9.27:    -1.0:  IS:\n\
    IM0,IS,IW0U,IW0V,IW0W,IW0X,IW0Y,IW0Z,=II0ICH,=II0IDP,=II0M,=II0SRE,=IQ0AG,\n\
    =IQ0AH,=IQ0AH/P,=IQ0AI,=IQ0AK,=IQ0AL,=IQ0AM,=IQ0EH,=IQ0HO,=IQ0ID,=IQ0ID/P,\n\
    =IQ0NU,=IQ0NU/P,=IQ0NV,=IQ0NV/P,=IQ0OG,=IQ0OH,=IQ0QP,=IQ0SS,=IY0GA;\n\
Sicily:                   15:  28:  EU:   37.50:   -14.00:    -1.0:  *IT9:\n\
    IB9,ID9,IE9,IF9,II9,IJ9,IO9,IQ9,IR9,IT9,IU9,IW9,IY9,=II0GDF/9;\n\
Djibouti:                 37:  48:  AF:   11.75:   -42.35:    -3.0:  J2:\n\
    J2;\n\
Grenada:                  08:  11:  NA:   12.13:    61.68:     4.0:  J3:\n\
    J3;\n\
Guinea-Bissau:            35:  46:  AF:   12.02:    14.80:     0.0:  J5:\n\
    J5;\n\
St. Lucia:                08:  11:  NA:   13.87:    61.00:     4.0:  J6:\n\
    J6;\n\
Dominica:                 08:  11:  NA:   15.43:    61.35:     4.0:  J7:\n\
    J7;\n\
St. Vincent:              08:  11:  NA:   13.23:    61.20:     4.0:  J8:\n\
    J8;\n\
Japan:                    25:  45:  AS:   36.40:  -138.38:    -9.0:  JA:\n\
    7J,7K,7L,7M,7N,8J,8K,8L,8M,8N,JA,JE,JF,JG,JH,JI,JJ,JK,JL,JM,JN,JO,JP,JQ,\n\
    JR,JS;\n\
Minami Torishima:         27:  90:  OC:   24.28:  -153.97:   -10.0:  JD/m:\n\
    =JD1YAA,=JG1RHN/JD1,=JG8NQJ/JD1;\n\
Ogasawara:                27:  45:  AS:   27.05:  -142.20:    -9.0:  JD/o:\n\
    JD1;\n\
Mongolia:                 23:  32:  AS:   46.77:  -102.17:    -7.0:  JT:\n\
    JT,JU,JV,JT2[33],JT3[33],JU2[33],JU3[33],JV2[33],JV3[33];\n\
Svalbard:                 40:  18:  EU:   78.00:   -16.00:    -1.0:  JW:\n\
    JW;\n\
Bear Island:              40:  18:  EU:   74.43:   -19.08:    -1.0:  *JW/b:\n\
    =JW/LB2PG;\n\
Jan Mayen:                40:  18:  EU:   71.05:     8.28:     1.0:  JX:\n\
    JX;\n\
Jordan:                   20:  39:  AS:   31.18:   -36.42:    -2.0:  JY:\n\
    JY;\n\
United States:            05:  08:  NA:   37.53:    91.67:     5.0:  K:\n\
    AA,AB,AC,AD,AE,AF,AG,AI,AJ,AK,K,N,W,=4U1WB(5)[8],=AA0O(5)[8],=AA2IL(3)[6],\n\
    =AA4DD(4)[8],=AA4R(4)[8],=AA7TV(4)[7],=AA9HQ(5)[8],=AB4B(4)[8],\n\
    =AB4EJ(4)[8],=AB4GG(4)[8],=AB4IQ(4)[8],=AB4KJ(4)[8],=AB5OR(4)[8],\n\
    =AB8RL(5)[8],=AB9DU(4)[7],=AC4CA(4)[7],=AC4G(4)[8],=AC4GW(4)[8],\n\
    =AC6WI(5)[8],=AC6ZM(4)[8],=AC7AF(4)[7],=AC7P(4)[7],=AC8Y(5)[8],\n\
    =AD1C(4)[7],=AD4EB(4)[8],=AD4TA(4)[8],=AD8J(5)[8],=AE7AP(4)[6],\n\
    =AG1RL(3)[6],=AG4W(4)[8],=AG5Z(4)[8],=AH0U(3)[6],=AH2O(5)[8],=AH6AX(5)[8],\n\
    =AI4DB(4)[8],=AI9K(4)[7],=AJ4A(4)[8],=AJ4F(4)[7],=AJ7G(5)[8],=AL0A(5)[8],\n\
    =AL4B(4)[8],=AL7GI(4)[8],=AL7RF(3)[6],=G8ERJ(5)[8],=K0ACP(4)[8],\n\
    =K0AU(3)[6],=K0EJ(4)[8],=K0IP(3)[6],=K0LUZ(5)[8],=K0NW(3)[6],=K0PJ(4)[8],\n\
    =K0SN(4)[6],=K0TQ(4)[8],=K0ZR(5)[8],=K1DW(4)[7],=K1GU(4)[8],=K1KD(4)[7],\n\
    =K1LT(4)[8],=K1PQS(4)[7],=K2DSW(4)[7],=K2GMY(3)[6],=K2KR(4)[7],\n\
    =K2PM(4)[8],=K2PO(3)[6],=K2RD(3)[6],=K2UR(4)[8],=K2VV(4)[7],=K3DMG(4)[8],\n\
    =K3EST(3)[6],=K3IE(4)[8],=K3JWI(4)[8],=K3PA(4)[7],=K3WT(4)[7],\n\
    =K3WYC(3)[6],=K3YP(4)[8],=K4AB(4)[8],=K4AFE(4)[8],=K4AMC(4)[8],\n\
    =K4AVX(4)[8],=K4BX(4)[8],=K4CWW(4)[8],=K4DG(4)[7],=K4DXV(4)[8],\n\
    =K4FN(4)[8],=K4FT(4)[8],=K4HAL(4)[8],=K4IE(4)[8],=K4IU(4)[7],=K4LPQ(4)[8],\n\
    =K4MMW(4)[8],=K4OAQ(4)[8],=K4OWR(4)[8],=K4RO(4)[8],=K4TCG(4)[8],\n\
    =K4TZ(4)[8],=K4WG(4)[8],=K4WI(4)[8],=K4WW(4)[8],=K4XU(3)[6],=K4YJ(4)[8],\n\
    =K4ZGB(4)[8],=K5AUP(5)[8],=K5EK(5)[8],=K5KG(5)[8],=K5OA(3)[6],\n\
    =K5VIP(5)[8],=K5WK(4)[8],=K5ZD(5)[8],=K5ZM(3)[6],=K6XT(4)[7],=K7ABV(4)[6],\n\
    =K7BV(5)[8],=K7CS(4)[8],=K7DR(4)[8],=K7IA(4)[7],=K7JOE(4)[8],=K7OM(5)[8],\n\
    =K7QA(4)[6],=K7SCX(4)[7],=K7SV(5)[8],=K7TD(4)[7],=K7VU(4)[7],=K7ZYV(4)[8],\n\
    =K8AC(5)[8],=K8ARY(5)[8],=K8CN(5)[8],=K8FU(4)[7],=K8GU(5)[8],=K8IA(3)[6],\n\
    =K8JQ(5)[8],=K8LBQ(5)[8],=K8LF(5)[8],=K8LS(4)[7],=K8NYG(5)[8],=K8PO(5)[8],\n\
    =K8SYH(5)[8],=K9DR(4)[7],=K9DU(4)[7],=K9JF(3)[6],=K9JM(3)[6],=K9OM(5)[8],\n\
    =K9OR(4)[7],=K9OZ(4)[7],=K9RS(5)[8],=K9WA(4)[7],=K9WZB(3)[6],=K9YC(3)[6],\n\
    =KA1KIX(4)[8],=KA3DRR(3)[6],=KA3MTT(4)[8],=KA4BVG(4)[8],=KA4GAV(4)[7],\n\
    =KA4OTB(4)[8],=KA5DWI(3)[6],=KA8HDE(4)[7],=KA8Q(5)[8],=KA9FOX(4)[7],\n\
    =KA9VVQ(4)[7],=KB7Q(4)[6],=KB8KMH(5)[8],=KB8V(5)[8],=KB9S(4)[7],\n\
    =KC2LM(4)[7],=KC4HW(4)[8],=KC4NX(4)[8],=KC4SAW(4)[8],=KC4TEO(4)[8],\n\
    =KC4WQ(4)[8],=KC6X(4)[7],=KC7QY(4)[7],=KC9K(4)[7],=KD0EE(4)[8],\n\
    =KD2KW(4)[7],=KD4ADC(4)[8],=KD5DD(4)[8],=KD5M(5)[8],=KD9BSO(4)[7],\n\
    =KD9LA(5)[8],=KE0L(4)[8],=KE0YI(4)[8],=KE1B(3)[6],=KE2VB(3)[6],\n\
    =KE3K(4)[8],=KE4KY(4)[8],=KE8FT(3)[6],=KF4AV(4)[8],=KF5BA(4)[8],\n\
    =KF5MU(4)[8],=KG4CUY(4)[8],=KG5HVO(4)[8],=KG6MC(5)[8],=KH2D(5)[8],\n\
    =KH2GM(5)[8],=KH6CT(5)[8],=KH6M(5)[8],=KH6VM(3)[6],=KH6XS(3)[6],\n\
    =KI6DY(4)[7],=KI6QDH(4)[7],=KJ4AOM(4)[8],=KJ4IWZ(4)[8],=KJ4KKD(4)[8],\n\
    =KJ4M(4)[8],=KK9A(5)[8],=KK9N(4)[7],=KL0MP(5)[8],=KL2RA(4)[7],\n\
    =KL4CZ(4)[6],=KL7IKV(3)[6],=KL7JR(5)[8],=KL7QW(4)[7],=KL7SK(3)[6],\n\
    =KM4FO(4)[8],=KM4JA(4)[8],=KM7W(4)[6],=KM9R(3)[6],=KN1CBR(4)[7],\n\
    =KN4DUA(4)[8],=KN4FRG(4)[7],=KN8U(5)[8],=KO0Z(4)[8],=KO4OL(4)[8],\n\
    =KO9V(4)[7],=KP2XX(4)[7],=KP4KD(5)[8],=KP4M(5)[8],=KQ9J(4)[7],=KR4F(4)[8],\n\
    =KS0CW(5)[8],=KS4L(4)[8],=KS4X(4)[8],=KS7T(4)[6],=KS9W(4)[7],=KT3M(4)[7],\n\
    =KT4O(4)[8],=KT4RR(4)[8],=KU1CW(3)[6],=KU8E(5)[8],=KV8S(4)[7],=KW4J(4)[8],\n\
    =KW7D(4)[7],=KX4FR(4)[8],=KX4WB(4)[8],=KX4X(4)[8],=KY0Q(4)[8],=KY4F(4)[8],\n\
    =KY4KD(4)[8],=KZ1W(3)[6],=KZ9V(4)[7],=N1JM(3)[6],=N1RU(4)[8],=N1XK(4)[7],\n\
    =N2AU(3)[6],=N2BJ(4)[8],=N2IC(4)[7],=N2NS(3)[6],=N3BB(4)[7],=N3BUO(4)[7],\n\
    =N3CI(4)[7],=N3RC(3)[6],=N3ZZ(3)[6],=N4ARO(4)[8],=N4AU(4)[8],=N4BAA(4)[8],\n\
    =N4BCB(4)[8],=N4BCD(4)[8],=N4DW(4)[8],=N4HAI(4)[8],=N4HID(4)[8],\n\
    =N4KC(4)[8],=N4KG(4)[8],=N4KH(4)[8],=N4NA(4)[8],=N4NO(4)[8],=N4OGW(4)[8],\n\
    =N4QS(4)[8],=N4SL(4)[6],=N4TZ(4)[8],=N4UC(4)[8],=N4UW(4)[8],=N4VI(4)[7],\n\
    =N4VV(4)[8],=N4WE(4)[8],=N4ZY(4)[8],=N4ZZ(4)[8],=N5CR(3)[6],=N5CW(4)[8],\n\
    =N5DX(5)[8],=N5RP(4)[8],=N5SMQ(5)[8],=N5TB(5)[8],=N5TOO(5)[8],=N5YT(4)[8],\n\
    =N5ZO(3)[6],=N6AR(5)[8],=N6DW(5)[8],=N6FS(4)[8],=N6PAT(5)[8],=N7DF(4)[7],\n\
    =N7DR(4)[7],=N7FLT(4)[6],=N7IP(4)[6],=N7IV(4)[7],=N7MZW(4)[7],=N7NG(4)[7],\n\
    =N7RCS(5)[8],=N7US(4)[8],=N7WY(4)[7],=N7ZZ(4)[8],=N8AID(5)[8],=N8GU(5)[8],\n\
    =N8II(5)[8],=N8NA(5)[8],=N8OO(4)[7],=N8PR(5)[8],=N8RA(5)[8],=N8WXQ(5)[8],\n\
    =N9CIQ(4)[7],=N9GB(4)[7],=N9JF(4)[7],=N9NA(3)[6],=N9NB(5)[8],=N9NC(5)[8],\n\
    =N9NM(4)[7],=N9RV(4)[6],=N9SB(4)[7],=N9VPV(4)[7],=NA2CC(3)[6],=NA4K(4)[8],\n\
    =NA5NN(4)[8],=NA9RB(4)[7],=ND2T(3)[6],=ND3N(4)[8],=ND4Y(4)[8],=NE8P(5)[8],\n\
    =NE9U(4)[7],=NF4J(4)[8],=NH6T(4)[8],=NI7R(5)[8],=NJ8J(5)[8],=NK8Q(5)[8],\n\
    =NL7CQ(4)[7],=NL7D(3)[6],=NL7QC(4)[7],=NL7XM(5)[8],=NN1N(4)[7],\n\
    =NN4SA(4)[8],=NN5O(4)[8],=NN7A(4)[7],=NN7CW(5)[8],=NO9E(5)[8],\n\
    =NP2GG(5)[8],=NP3K(5)[8],=NQ6N(4)[8],=NR5W(3)[6],=NR7DX(4)[6],=NS4X(4)[8],\n\
    =NW7R(5)[8],=NW8U(5)[8],=NX1P(3)[6],=NY6DX(5)[8],=W0BR(5)[8],=W0CN(5)[8],\n\
    =W0JX(4)[8],=W0MHK(5)[8],=W0PV(5)[8],=W0QQG(5)[8],=W0RIC(3)[6],\n\
    =W0SK(4)[8],=W0ZP(4)[8],=W1GKT(4)[8],=W1NN(4)[8],=W1PDI(4)[8],=W1PR(3)[6],\n\
    =W1RH(3)[6],=W1SRD(3)[6],=W2ACY(4)[7],=W2FV(3)[6],=W2GS(4)[7],\n\
    =W2VJN(3)[6],=W3DQN(4)[7],=W3HDH(4)[8],=W3HKK(4)[8],=W3TB(4)[8],\n\
    =W4BCG(4)[8],=W4DAN(4)[8],=W4ER(4)[8],=W4GKM(4)[8],=W4GZX(4)[8],\n\
    =W4JSI(4)[8],=W4KW(4)[8],=W4LC(4)[8],=W4LID(4)[8],=W4NBS(4)[8],\n\
    =W4NI(4)[8],=W4NZ(4)[8],=W4PF(4)[8],=W4TLK(4)[8],=W4TTM(4)[8],\n\
    =W4UAL(4)[8],=W4UT(4)[8],=W5HIO(4)[8],=W5JR(5)[8],=W5MX(4)[8],=W5NZ(4)[8],\n\
    =W5UE(4)[8],=W5VE(5)[8],=W5VS(5)[8],=W5XB(5)[8],=W6GMT(4)[7],=W6KGP(4)[7],\n\
    =W6LFB(4)[7],=W6NWS(5)[8],=W6RLL(3)[7],=W6UB(4)[8],=W6XR(5)[8],\n\
    =W6YTG(5)[8],=W7DO(5)[8],=W7EE(4)[6],=W7HJ(5)[8],=W7IGC(5)[8],=W7II(4)[7],\n\
    =W7IY(5)[8],=W7KF(4)[6],=W7RY(4)[7],=W7SE(4)[7],=W7UT(4)[7],=W7XU(4)[7],\n\
    =W8AT(5)[8],=W8FJ(5)[8],=W8FN(4)[7],=W8HAP(5)[8],=W8HGH(5)[8],=W8KA(3)[6],\n\
    =W8LYJ(5)[8],=W8OV(4)[7],=W8TK(3)[6],=W8WEJ(5)[8],=W9CF(3)[6],=W9DC(5)[8],\n\
    =W9ET(4)[7],=W9IL(5)[8],=W9JA(4)[7],=W9JEF(4)[7],=W9KKN(3)[6],\n\
    =W9LHG(4)[7],=W9MAF(4)[7],=W9PL(3)[6],=W9RM(4)[7],=W9RNY(4)[7],\n\
    =WA0WWW(3)[6],=WA1FCN(4)[8],=WA1UJU(4)[8],=WA2VYA(4)[7],=WA3C(4)[8],\n\
    =WA4JA(4)[8],=WA5POK(4)[8],=WA8KAN(5)[8],=WA8OJR(5)[8],=WA8ZBT(4)[7],\n\
    =WB2JEP(3)[6],=WB3JFS(3)[6],=WB4YDL(4)[8],=WB4YDY(4)[8],=WB7S(4)[7],\n\
    =WB8BPU(5)[8],=WB8IMY(5)[8],=WB8YYY(5)[8],=WB9QAF(4)[7],=WC7S(4)[7],\n\
    =WD5F(5)[8],=WE6EZ(4)[7],=WF3H(4)[7],=WF7T(4)[8],=WF9A(5)[8],=WH0AI(4)[7],\n\
    =WH6AQ(5)[8],=WH6LE(5)[8],=WH7R(4)[7],=WI4T(4)[7],=WJ9B(3)[6],\n\
    =WL7OU(4)[7],=WM5DX(4)[8],=WN1G(4)[8],=WN7S(5)[8],=WP2B(4)[7],\n\
    =WP3ME(5)[8],=WQ3U(3)[6],=WQ5L(4)[8],=WQ9T(4)[7],=WR3O(4)[8],=WR5J(3)[6],\n\
    =WS6K(4)[8],=WS6X(5)[8],=WS9M(5)[8],=WT2P(4)[8],=WT8WV(5)[8],=WU0B(5)[8],\n\
    =WU9B(3)[6],=WV4P(4)[8],=WV8SW(5)[8],=WW4R(4)[8],=WW5M(4)[8],=WX4W(4)[8],\n\
    =WX5S(3)[6],=WY6K(4)[7],=WY7FD(4)[7],=WZ1Y(4)[7],=WZ4F(4)[8],=WZ7I(5)[8],\n\
    =WZ8T(3)[6];\n\
Guantanamo Bay:           08:  11:  NA:   20.00:    75.00:     5.0:  KG4:\n\
    KG4,=KG4AY,=KG4WH;\n\
Mariana Islands:          27:  64:  OC:   15.18:  -145.72:   -10.0:  KH0:\n\
    AH0,KH0,NH0,WH0,=K0W,=K8KH,=K8RN,=NH2B;\n\
Baker & Howland Islands:  31:  61:  OC:    0.00:   176.00:    12.0:  KH1:\n\
    AH1,KH1,NH1,WH1;\n\
Guam:                     27:  64:  OC:   13.37:  -144.70:   -10.0:  KH2:\n\
    AH2,KH2,NH2,WH2,=AH0FM,=KA1I,=KB5OXR,=KF7BMU,=KG6DX,=KG6JDX,=KH0UM,\n\
    =KK6GVF,=NH0Q;\n\
Johnston Island:          31:  61:  OC:   16.72:   169.53:    10.0:  KH3:\n\
    AH3,KH3,NH3,WH3;\n\
Midway Island:            31:  61:  OC:   28.20:   177.37:    11.0:  KH4:\n\
    AH4,KH4,NH4,WH4;\n\
Palmyra & Jarvis Islands: 31:  61:  OC:    5.87:   162.07:    11.0:  KH5:\n\
    AH5,KH5,NH5,WH5;\n\
Hawaii:                   31:  61:  OC:   21.12:   157.48:    10.0:  KH6:\n\
    AH6,AH7,KH6,KH7,NH6,NH7,WH6,WH7,=AA7LE,=AC7N,=AC9PT,=AK2J,=K2GT,=K3NW,\n\
    =K4XS,=K6BU,=K6MIO,=K9FD,=KA7BSK,=KB1UHL,=KB6EGA,=KB6INB,=KB7WDC,=KC0YIH,\n\
    =KC9KEX,=KD6NVX,=KE4DYE,=KE7FJA,=KE7LWN,=KE7QML,=KF6RLP,=KF7IJL,=KH0WJ,\n\
    =KH3AE,=KH8Z,=KI4YOG,=KI7QZQ,=KK6GM,=KK6QAI,=KK6RM,=KL0TK,=KM6IK,=KQ6M,\n\
    =N1CBF,=N1TEE,=N1VOP,=N3FUR,=N3GWR,=N4ERA,=W6KEV,=W7NX,=W7OO,=WA6IIQ,\n\
    =WA6JJQ,=WA8JQP,=WB0TZQ,=WB4JTT,=WB6PIO,=WB8NCD,=WD0LFN,=WY6F;\n\
Kure Island:              31:  61:  OC:   29.00:   178.00:    10.0:  KH7K:\n\
    AH7K,KH7K,NH7K,WH7K;\n\
American Samoa:           32:  62:  OC:  -14.32:   170.78:    11.0:  KH8:\n\
    AH8,KH8,NH8,WH8;\n\
Swains Island:            32:  62:  OC:  -11.05:   171.25:    11.0:  KH8/s:\n\
    =KH8S/NA6M;\n\
Wake Island:              31:  65:  OC:   19.28:  -166.63:   -12.0:  KH9:\n\
    AH9,KH9,NH9,WH9;\n\
Alaska:                   01:  01:  NA:   61.40:   148.87:     8.0:  KL:\n\
    AL,KL,NL,WL,=K1KAO,=K4HOE,=K7SGA,=KA1NCN,=KB3CYB,=KB4DX,=KC0YSW,=KC1KPL,\n\
    =KC5YOX,=KC5ZAA,=KD0JJB,=KD5WYP,=KD7BBX,=KF3L,=KF6IAO,=KF6RMG,=KF7GKY,\n\
    =KG5MIO,=KG7JVJ,=KG7OUF,=KI6BGR,=KJ6DCH,=KM6NOL,=KN4HGD,=KW1W,=N1NDA,\n\
    =N1TX,=N6ZZX,=N7DBN,=N7IA,=N8SUG,=NM0H,=NW7F,=W3MKG,=WH6DPL;\n\
Navassa Island:           08:  11:  NA:   18.40:    75.00:     5.0:  KP1:\n\
    KP1,NP1,WP1;\n\
US Virgin Islands:        08:  11:  NA:   17.73:    64.80:     4.0:  KP2:\n\
    KP2,NP2,WP2,=K8RF,=KV4FZ,=W4LIS;\n\
Puerto Rico:              08:  11:  NA:   18.18:    66.55:     4.0:  KP4:\n\
    KP3,KP4,NP3,NP4,WP3,WP4,=AA0WX,=K4LCR,=KB0JRR,=KC2TE,=KC2VCR,=KC8BFN,\n\
    =KD2KPC,=KD9GIZ,=KG4GYO,=KK4DCX,=KP2Z,=N4CIE,=N6NVD;\n\
Desecheo Island:          08:  11:  NA:   18.08:    67.88:     4.0:  KP5:\n\
    KP5,NP5,WP5;\n\
Norway:                   14:  18:  EU:   61.00:    -9.00:    -1.0:  LA:\n\
    LA,LB,LC,LD,LE,LF,LG,LH,LI,LJ,LK,LL,LM,LN;\n\
Argentina:                13:  14:  SA:  -34.80:    65.92:     3.0:  LU:\n\
    AY,AZ,L1,L2,L3,L4,L5,L6,L7,L8,L9,LO,LP,LQ,LR,LS,LT,LU,LV,LW,AY0V[16],\n\
    AY0W[16],AY0X[16],AY0Y[16],AY1V[16],AY1W[16],AY1X[16],AY1Y[16],AY2V[16],\n\
    AY2W[16],AY2X[16],AY2Y[16],AY3V[16],AY3W[16],AY3X[16],AY3Y[16],AY4V[16],\n\
    AY4W[16],AY4X[16],AY4Y[16],AY5V[16],AY5W[16],AY5X[16],AY5Y[16],AY6V[16],\n\
    AY6W[16],AY6X[16],AY6Y[16],AY7V[16],AY7W[16],AY7X[16],AY7Y[16],AY8V[16],\n\
    AY8W[16],AY8X[16],AY8Y[16],AY9V[16],AY9W[16],AY9X[16],AY9Y[16],AZ0V[16],\n\
    AZ0W[16],AZ0X[16],AZ0Y[16],AZ1V[16],AZ1W[16],AZ1X[16],AZ1Y[16],AZ2V[16],\n\
    AZ2W[16],AZ2X[16],AZ2Y[16],AZ3V[16],AZ3W[16],AZ3X[16],AZ3Y[16],AZ4V[16],\n\
    AZ4W[16],AZ4X[16],AZ4Y[16],AZ5V[16],AZ5W[16],AZ5X[16],AZ5Y[16],AZ6V[16],\n\
    AZ6W[16],AZ6X[16],AZ6Y[16],AZ7V[16],AZ7W[16],AZ7X[16],AZ7Y[16],AZ8V[16],\n\
    AZ8W[16],AZ8X[16],AZ8Y[16],AZ9V[16],AZ9W[16],AZ9X[16],AZ9Y[16],L20V[16],\n\
    L20W[16],L20X[16],L20Y[16],L21V[16],L21W[16],L21X[16],L21Y[16],L22V[16],\n\
    L22W[16],L22X[16],L22Y[16],L23V[16],L23W[16],L23X[16],L23Y[16],L24V[16],\n\
    L24W[16],L24X[16],L24Y[16],L25V[16],L25W[16],L25X[16],L25Y[16],L26V[16],\n\
    L26W[16],L26X[16],L26Y[16],L27V[16],L27W[16],L27X[16],L27Y[16],L28V[16],\n\
    L28W[16],L28X[16],L28Y[16],L29V[16],L29W[16],L29X[16],L29Y[16],L30V[16],\n\
    L30W[16],L30X[16],L30Y[16],L31V[16],L31W[16],L31X[16],L31Y[16],L32V[16],\n\
    L32W[16],L32X[16],L32Y[16],L33V[16],L33W[16],L33X[16],L33Y[16],L34V[16],\n\
    L34W[16],L34X[16],L34Y[16],L35V[16],L35W[16],L35X[16],L35Y[16],L36V[16],\n\
    L36W[16],L36X[16],L36Y[16],L37V[16],L37W[16],L37X[16],L37Y[16],L38V[16],\n\
    L38W[16],L38X[16],L38Y[16],L39V[16],L39W[16],L39X[16],L39Y[16],L40V[16],\n\
    L40W[16],L40X[16],L40Y[16],L41V[16],L41W[16],L41X[16],L41Y[16],L42V[16],\n\
    L42W[16],L42X[16],L42Y[16],L43V[16],L43W[16],L43X[16],L43Y[16],L44V[16],\n\
    L44W[16],L44X[16],L44Y[16],L45V[16],L45W[16],L45X[16],L45Y[16],L46V[16],\n\
    L46W[16],L46X[16],L46Y[16],L47V[16],L47W[16],L47X[16],L47Y[16],L48V[16],\n\
    L48W[16],L48X[16],L48Y[16],L49V[16],L49W[16],L49X[16],L49Y[16],L50V[16],\n\
    L50W[16],L50X[16],L50Y[16],L51V[16],L51W[16],L51X[16],L51Y[16],L52V[16],\n\
    L52W[16],L52X[16],L52Y[16],L53V[16],L53W[16],L53X[16],L53Y[16],L54V[16],\n\
    L54W[16],L54X[16],L54Y[16],L55V[16],L55W[16],L55X[16],L55Y[16],L56V[16],\n\
    L56W[16],L56X[16],L56Y[16],L57V[16],L57W[16],L57X[16],L57Y[16],L58V[16],\n\
    L58W[16],L58X[16],L58Y[16],L59V[16],L59W[16],L59X[16],L59Y[16],L60V[16],\n\
    L60W[16],L60X[16],L60Y[16],L61V[16],L61W[16],L61X[16],L61Y[16],L62V[16],\n\
    L62W[16],L62X[16],L62Y[16],L63V[16],L63W[16],L63X[16],L63Y[16],L64V[16],\n\
    L64W[16],L64X[16],L64Y[16],L65V[16],L65W[16],L65X[16],L65Y[16],L66V[16],\n\
    L66W[16],L66X[16],L66Y[16],L67V[16],L67W[16],L67X[16],L67Y[16],L68V[16],\n\
    L68W[16],L68X[16],L68Y[16],L69V[16],L69W[16],L69X[16],L69Y[16],L70V[16],\n\
    L70W[16],L70X[16],L70Y[16],L71V[16],L71W[16],L71X[16],L71Y[16],L72V[16],\n\
    L72W[16],L72X[16],L72Y[16],L73V[16],L73W[16],L73X[16],L73Y[16],L74V[16],\n\
    L74W[16],L74X[16],L74Y[16],L75V[16],L75W[16],L75X[16],L75Y[16],L76V[16],\n\
    L76W[16],L76X[16],L76Y[16],L77V[16],L77W[16],L77X[16],L77Y[16],L78V[16],\n\
    L78W[16],L78X[16],L78Y[16],L79V[16],L79W[16],L79X[16],L79Y[16],L80V[16],\n\
    L80W[16],L80X[16],L80Y[16],L81V[16],L81W[16],L81X[16],L81Y[16],L82V[16],\n\
    L82W[16],L82X[16],L82Y[16],L83V[16],L83W[16],L83X[16],L83Y[16],L84V[16],\n\
    L84W[16],L84X[16],L84Y[16],L85V[16],L85W[16],L85X[16],L85Y[16],L86V[16],\n\
    L86W[16],L86X[16],L86Y[16],L87V[16],L87W[16],L87X[16],L87Y[16],L88V[16],\n\
    L88W[16],L88X[16],L88Y[16],L89V[16],L89W[16],L89X[16],L89Y[16],L90V[16],\n\
    L90W[16],L90X[16],L90Y[16],L91V[16],L91W[16],L91X[16],L91Y[16],L92V[16],\n\
    L92W[16],L92X[16],L92Y[16],L93V[16],L93W[16],L93X[16],L93Y[16],L94V[16],\n\
    L94W[16],L94X[16],L94Y[16],L95V[16],L95W[16],L95X[16],L95Y[16],L96V[16],\n\
    L96W[16],L96X[16],L96Y[16],L97V[16],L97W[16],L97X[16],L97Y[16],L98V[16],\n\
    L98W[16],L98X[16],L98Y[16],L99V[16],L99W[16],L99X[16],L99Y[16],LO0V[16],\n\
    LO0W[16],LO0X[16],LO0Y[16],LO1V[16],LO1W[16],LO1X[16],LO1Y[16],LO2V[16],\n\
    LO2W[16],LO2X[16],LO2Y[16],LO3V[16],LO3W[16],LO3X[16],LO3Y[16],LO4V[16],\n\
    LO4W[16],LO4X[16],LO4Y[16],LO5V[16],LO5W[16],LO5X[16],LO5Y[16],LO6V[16],\n\
    LO6W[16],LO6X[16],LO6Y[16],LO7V[16],LO7W[16],LO7X[16],LO7Y[16],LO8V[16],\n\
    LO8W[16],LO8X[16],LO8Y[16],LO9V[16],LO9W[16],LO9X[16],LO9Y[16],LP0V[16],\n\
    LP0W[16],LP0X[16],LP0Y[16],LP1V[16],LP1W[16],LP1X[16],LP1Y[16],LP2V[16],\n\
    LP2W[16],LP2X[16],LP2Y[16],LP3V[16],LP3W[16],LP3X[16],LP3Y[16],LP4V[16],\n\
    LP4W[16],LP4X[16],LP4Y[16],LP5V[16],LP5W[16],LP5X[16],LP5Y[16],LP6V[16],\n\
    LP6W[16],LP6X[16],LP6Y[16],LP7V[16],LP7W[16],LP7X[16],LP7Y[16],LP8V[16],\n\
    LP8W[16],LP8X[16],LP8Y[16],LP9V[16],LP9W[16],LP9X[16],LP9Y[16],LQ0V[16],\n\
    LQ0W[16],LQ0X[16],LQ0Y[16],LQ1V[16],LQ1W[16],LQ1X[16],LQ1Y[16],LQ2V[16],\n\
    LQ2W[16],LQ2X[16],LQ2Y[16],LQ3V[16],LQ3W[16],LQ3X[16],LQ3Y[16],LQ4V[16],\n\
    LQ4W[16],LQ4X[16],LQ4Y[16],LQ5V[16],LQ5W[16],LQ5X[16],LQ5Y[16],LQ6V[16],\n\
    LQ6W[16],LQ6X[16],LQ6Y[16],LQ7V[16],LQ7W[16],LQ7X[16],LQ7Y[16],LQ8V[16],\n\
    LQ8W[16],LQ8X[16],LQ8Y[16],LQ9V[16],LQ9W[16],LQ9X[16],LQ9Y[16],LR0V[16],\n\
    LR0W[16],LR0X[16],LR0Y[16],LR1V[16],LR1W[16],LR1X[16],LR1Y[16],LR2V[16],\n\
    LR2W[16],LR2X[16],LR2Y[16],LR3V[16],LR3W[16],LR3X[16],LR3Y[16],LR4V[16],\n\
    LR4W[16],LR4X[16],LR4Y[16],LR5V[16],LR5W[16],LR5X[16],LR5Y[16],LR6V[16],\n\
    LR6W[16],LR6X[16],LR6Y[16],LR7V[16],LR7W[16],LR7X[16],LR7Y[16],LR8V[16],\n\
    LR8W[16],LR8X[16],LR8Y[16],LR9V[16],LR9W[16],LR9X[16],LR9Y[16],LS0V[16],\n\
    LS0W[16],LS0X[16],LS0Y[16],LS1V[16],LS1W[16],LS1X[16],LS1Y[16],LS2V[16],\n\
    LS2W[16],LS2X[16],LS2Y[16],LS3V[16],LS3W[16],LS3X[16],LS3Y[16],LS4V[16],\n\
    LS4W[16],LS4X[16],LS4Y[16],LS5V[16],LS5W[16],LS5X[16],LS5Y[16],LS6V[16],\n\
    LS6W[16],LS6X[16],LS6Y[16],LS7V[16],LS7W[16],LS7X[16],LS7Y[16],LS8V[16],\n\
    LS8W[16],LS8X[16],LS8Y[16],LS9V[16],LS9W[16],LS9X[16],LS9Y[16],LT0V[16],\n\
    LT0W[16],LT0X[16],LT0Y[16],LT1V[16],LT1W[16],LT1X[16],LT1Y[16],LT2V[16],\n\
    LT2W[16],LT2X[16],LT2Y[16],LT3V[16],LT3W[16],LT3X[16],LT3Y[16],LT4V[16],\n\
    LT4W[16],LT4X[16],LT4Y[16],LT5V[16],LT5W[16],LT5X[16],LT5Y[16],LT6V[16],\n\
    LT6W[16],LT6X[16],LT6Y[16],LT7V[16],LT7W[16],LT7X[16],LT7Y[16],LT8V[16],\n\
    LT8W[16],LT8X[16],LT8Y[16],LT9V[16],LT9W[16],LT9X[16],LT9Y[16],LU0V[16],\n\
    LU0W[16],LU0X[16],LU0Y[16],LU1V[16],LU1W[16],LU1X[16],LU1Y[16],LU2V[16],\n\
    LU2W[16],LU2X[16],LU2Y[16],LU3V[16],LU3W[16],LU3X[16],LU3Y[16],LU4V[16],\n\
    LU4W[16],LU4X[16],LU4Y[16],LU5V[16],LU5W[16],LU5X[16],LU5Y[16],LU6V[16],\n\
    LU6W[16],LU6X[16],LU6Y[16],LU7V[16],LU7W[16],LU7X[16],LU7Y[16],LU8V[16],\n\
    LU8W[16],LU8X[16],LU8Y[16],LU9V[16],LU9W[16],LU9X[16],LU9Y[16],LV0V[16],\n\
    LV0W[16],LV0X[16],LV0Y[16],LV1V[16],LV1W[16],LV1X[16],LV1Y[16],LV2V[16],\n\
    LV2W[16],LV2X[16],LV2Y[16],LV3V[16],LV3W[16],LV3X[16],LV3Y[16],LV4V[16],\n\
    LV4W[16],LV4X[16],LV4Y[16],LV5V[16],LV5W[16],LV5X[16],LV5Y[16],LV6V[16],\n\
    LV6W[16],LV6X[16],LV6Y[16],LV7V[16],LV7W[16],LV7X[16],LV7Y[16],LV8V[16],\n\
    LV8W[16],LV8X[16],LV8Y[16],LV9V[16],LV9W[16],LV9X[16],LV9Y[16],LW0V[16],\n\
    LW0W[16],LW0X[16],LW0Y[16],LW1V[16],LW1W[16],LW1X[16],LW1Y[16],LW2V[16],\n\
    LW2W[16],LW2X[16],LW2Y[16],LW3V[16],LW3W[16],LW3X[16],LW3Y[16],LW4V[16],\n\
    LW4W[16],LW4X[16],LW4Y[16],LW5V[16],LW5W[16],LW5X[16],LW5Y[16],LW6V[16],\n\
    LW6W[16],LW6X[16],LW6Y[16],LW7V[16],LW7W[16],LW7X[16],LW7Y[16],LW8V[16],\n\
    LW8W[16],LW8X[16],LW8Y[16],LW9V[16],LW9W[16],LW9X[16],LW9Y[16],\n\
    =LU1AW/X[16],=LU2DVI/H,=LU3AJL/H,=LU3EFL/D,=LU3HKA/H,=LU3HL/H,\n\
    =LU3YA/V[16],=LU5FYX/H,=LU7HA/H,=LU7HBL/H,=LU8HH/H,=LU8VCC/V[16],\n\
    =LW4HCL/H;\n\
Luxembourg:               14:  27:  EU:   50.00:    -6.00:    -1.0:  LX:\n\
    LX;\n\
Lithuania:                15:  29:  EU:   55.45:   -23.63:    -2.0:  LY:\n\
    LY;\n\
Bulgaria:                 20:  28:  EU:   42.83:   -25.08:    -2.0:  LZ:\n\
    LZ;\n\
Peru:                     10:  12:  SA:  -10.00:    76.00:     5.0:  OA:\n\
    4T,OA,OB,OC;\n\
Lebanon:                  20:  39:  AS:   33.83:   -35.83:    -2.0:  OD:\n\
    OD;\n\
Austria:                  15:  28:  EU:   47.33:   -13.33:    -1.0:  OE:\n\
    OE,=4U0R,=4U1A,=4U1VIC,=4U2U,=4Y1A,=C7A;\n\
Finland:                  15:  18:  EU:   63.78:   -27.08:    -2.0:  OH:\n\
    OF,OG,OH,OI,OJ;\n\
Aland Islands:            15:  18:  EU:   60.13:   -20.37:    -2.0:  OH0:\n\
    OF0,OG0,OH0,OI0;\n\
Market Reef:              15:  18:  EU:   60.00:   -19.00:    -2.0:  OJ0:\n\
    OJ0;\n\
Czech Republic:           15:  28:  EU:   50.00:   -16.00:    -1.0:  OK:\n\
    OK,OL;\n\
Slovak Republic:          15:  28:  EU:   49.00:   -20.00:    -1.0:  OM:\n\
    OM;\n\
Belgium:                  14:  27:  EU:   50.70:    -4.85:    -1.0:  ON:\n\
    ON,OO,OP,OQ,OR,OS,OT,=ON3BLB/YL;\n\
Greenland:                40:  05:  NA:   74.00:    42.78:     3.0:  OX:\n\
    OX,XP;\n\
Faroe Islands:            14:  18:  EU:   62.07:     6.93:     0.0:  OY:\n\
    OW,OY;\n\
Denmark:                  14:  18:  EU:   56.00:   -10.00:    -1.0:  OZ:\n\
    5P,5Q,OU,OV,OZ;\n\
Papua New Guinea:         28:  51:  OC:   -9.50:  -147.12:   -10.0:  P2:\n\
    P2;\n\
Aruba:                    09:  11:  SA:   12.53:    69.98:     4.0:  P4:\n\
    P4;\n\
DPR of Korea:             25:  44:  AS:   39.78:  -126.30:    -9.0:  P5:\n\
    P5,P6,P7,P8,P9;\n\
Netherlands:              14:  27:  EU:   52.28:    -5.47:    -1.0:  PA:\n\
    PA,PB,PC,PD,PE,PF,PG,PH,PI;\n\
Curacao:                  09:  11:  SA:   12.17:    69.00:     4.0:  PJ2:\n\
    PJ2;\n\
Bonaire:                  09:  11:  SA:   12.20:    68.25:     4.0:  PJ4:\n\
    PJ4;\n\
Saba & St. Eustatius:     08:  11:  NA:   17.57:    63.10:     4.0:  PJ5:\n\
    PJ5,PJ6;\n\
Sint Maarten:             08:  11:  NA:   18.07:    63.07:     4.0:  PJ7:\n\
    PJ0,PJ7,PJ8;\n\
Brazil:                   11:  15:  SA:  -10.00:    53.00:     3.0:  PY:\n\
    PP,PQ,PR,PS,PT,PU,PV,PW,PX,PY,ZV,ZW,ZX,ZY,ZZ,PP6[13],PP7[13],PP8[12],\n\
    PQ2[13],PQ8[13],PR7[13],PR8[13],PS7[13],PS8[13],PT2[13],PT7[13],PT8[12],\n\
    PV8[12],PW8[12],PY6[13],PY7[13],PY8[13],PY9[13];\n\
Fernando de Noronha:      11:  13:  SA:   -3.85:    32.43:     2.0:  PY0F:\n\
    PP0F,PP0ZF,PQ0F,PQ0ZF,PR0F,PR0ZF,PS0F,PS0ZF,PT0F,PT0ZF,PU0F,PU0ZF,PV0F,\n\
    PV0ZF,PW0F,PW0ZF,PX0F,PX0ZF,PY0F,PY0Z,ZV0F,ZV0ZF,ZW0F,ZW0ZF,ZX0F,ZX0ZF,\n\
    ZY0F,ZY0Z,ZZ0F,ZZ0ZF,PP0R,PP0ZR,PQ0R,PQ0ZR,PR0R,PR0ZR,PS0R,PS0ZR,PT0R,\n\
    PT0ZR,PU0R,PU0ZR,PV0R,PV0ZR,PW0R,PW0ZR,PX0R,PX0ZR,PY0R,ZV0R,ZV0ZR,ZW0R,\n\
    ZW0ZR,ZX0R,ZX0ZR,ZY0R,ZZ0R,ZZ0ZR;\n\
St. Peter & St. Paul:     11:  13:  SA:    0.00:    29.00:     2.0:  PY0S:\n\
    PP0S,PP0ZS,PQ0S,PQ0ZS,PR0S,PR0ZS,PS0S,PS0ZS,PT0S,PT0ZS,PU0S,PU0ZS,PV0S,\n\
    PV0ZS,PW0S,PW0ZS,PX0S,PX0ZS,PY0S,PY0ZS,ZV0S,ZV0ZS,ZW0S,ZW0ZS,ZX0S,ZX0ZS,\n\
    ZY0S,ZY0ZS,ZZ0S,ZZ0ZS;\n\
Trindade & Martim Vaz:    11:  15:  SA:  -20.50:    29.32:     2.0:  PY0T:\n\
    PP0T,PP0ZT,PQ0T,PQ0ZT,PR0T,PR0ZT,PS0T,PS0ZT,PT0T,PT0ZT,PU0T,PU0ZT,PV0T,\n\
    PV0ZT,PW0T,PW0ZT,PX0T,PX0ZT,PY0T,PY0ZT,ZV0T,ZV0ZT,ZW0T,ZW0ZT,ZX0T,ZX0ZT,\n\
    ZY0T,ZY0ZT,ZZ0T,ZZ0ZT;\n\
Suriname:                 09:  12:  SA:    4.00:    56.00:     3.0:  PZ:\n\
    PZ;\n\
Franz Josef Land:         40:  75:  EU:   80.68:   -49.92:    -3.0:  R1FJ:\n\
    RI1F;\n\
Western Sahara:           33:  46:  AF:   24.82:    13.85:     0.0:  S0:\n\
    S0;\n\
Bangladesh:               22:  41:  AS:   24.12:   -89.65:    -6.0:  S2:\n\
    S2,S3;\n\
Slovenia:                 15:  28:  EU:   46.00:   -14.00:    -1.0:  S5:\n\
    S5;\n\
Seychelles:               39:  53:  AF:   -4.67:   -55.47:    -4.0:  S7:\n\
    S7;\n\
Sao Tome & Principe:      36:  47:  AF:    0.22:    -6.57:     0.0:  S9:\n\
    S9;\n\
Sweden:                   14:  18:  EU:   61.20:   -14.57:    -1.0:  SM:\n\
    7S,8S,SA,SB,SC,SD,SE,SF,SG,SH,SI,SJ,SK,SL,SM;\n\
Poland:                   15:  28:  EU:   52.28:   -18.67:    -1.0:  SP:\n\
    3Z,HF,SN,SO,SP,SQ,SR;\n\
Sudan:                    34:  48:  AF:   14.47:   -28.62:    -3.0:  ST:\n\
    6T,6U,ST;\n\
Egypt:                    34:  38:  AF:   26.28:   -28.60:    -2.0:  SU:\n\
    6A,6B,SS,SU;\n\
Greece:                   20:  28:  EU:   39.78:   -21.78:    -2.0:  SV:\n\
    J4,SV,SW,SX,SY,SZ,=SV94MIKIS,=SV94THEO,=SX94MIKIS,=SX94THEO;\n\
Mount Athos:              20:  28:  EU:   40.00:   -24.00:    -2.0:  SV/a:\n\
    =SV2ASP/A,=SV2RSG/A;\n\
Dodecanese:               20:  28:  EU:   36.17:   -27.93:    -2.0:  SV5:\n\
    J45,SV5,SW5,SX5,SY5,SZ5;\n\
Crete:                    20:  28:  EU:   35.23:   -24.78:    -2.0:  SV9:\n\
    J49,SV9,SW9,SX9,SY9,SZ9;\n\
Tuvalu:                   31:  65:  OC:   -8.50:  -179.20:   -12.0:  T2:\n\
    T2;\n\
Western Kiribati:         31:  65:  OC:    1.42:  -173.00:   -12.0:  T30:\n\
    T30;\n\
Central Kiribati:         31:  62:  OC:   -2.83:   171.72:   -13.0:  T31:\n\
    T31;\n\
Eastern Kiribati:         31:  61:  OC:    1.80:   157.35:   -14.0:  T32:\n\
    T32;\n\
Banaba Island:            31:  65:  OC:   -0.88:  -169.53:   -12.0:  T33:\n\
    T33;\n\
Somalia:                  37:  48:  AF:    2.03:   -45.35:    -3.0:  T5:\n\
    6O,T5;\n\
San Marino:               15:  28:  EU:   43.95:   -12.45:    -1.0:  T7:\n\
    T7;\n\
Palau:                    27:  64:  OC:    7.45:  -134.53:    -9.0:  T8:\n\
    T8;\n\
Asiatic Turkey:           20:  39:  AS:   39.18:   -35.65:    -2.0:  TA:\n\
    TA,TB,TC,YM,=TA1BZ/2,=TA1D/4;\n\
European Turkey:          20:  39:  EU:   41.02:   -28.97:    -2.0:  *TA1:\n\
    TA1,TB1,TC1,YM1,=TA6CQ/1;\n\
Iceland:                  40:  17:  EU:   64.80:    18.73:     0.0:  TF:\n\
    TF;\n\
Guatemala:                07:  11:  NA:   15.50:    90.30:     6.0:  TG:\n\
    TD,TG;\n\
Costa Rica:               07:  11:  NA:   10.00:    84.00:     6.0:  TI:\n\
    TE,TI;\n\
Cocos Island:             07:  11:  NA:    5.52:    87.05:     6.0:  TI9:\n\
    TE9,TI9;\n\
Cameroon:                 36:  47:  AF:    5.38:   -11.87:    -1.0:  TJ:\n\
    TJ;\n\
Corsica:                  15:  28:  EU:   42.00:    -9.00:    -1.0:  TK:\n\
    TK;\n\
Central African Republic: 36:  47:  AF:    6.75:   -20.33:    -1.0:  TL:\n\
    TL;\n\
Republic of the Congo:    36:  52:  AF:   -1.02:   -15.37:    -1.0:  TN:\n\
    TN;\n\
Gabon:                    36:  52:  AF:   -0.37:   -11.73:    -1.0:  TR:\n\
    TR;\n\
Chad:                     36:  47:  AF:   15.80:   -18.17:    -1.0:  TT:\n\
    TT;\n\
Cote d'Ivoire:            35:  46:  AF:    7.58:     5.80:     0.0:  TU:\n\
    TU;\n\
Benin:                    35:  46:  AF:    9.87:    -2.25:    -1.0:  TY:\n\
    TY;\n\
Mali:                     35:  46:  AF:   18.00:     2.58:     0.0:  TZ:\n\
    TZ;\n\
European Russia:          16:  29:  EU:   53.65:   -41.37:    -4.0:  UA:\n\
    R,U,R1I(17)[20],R1N[19],R1O[19],R1P[20],R1Z[19],R4H[30],R4I[30],R4W[30],\n\
    R8F(17)[30],R8G(17)[30],R8X(17)[20],R9F(17)[30],R9G(17)[30],R9X(17)[20],\n\
    RA1I(17)[20],RA1N[19],RA1O[19],RA1P[20],RA1Z[19],RA4H[30],RA4I[30],\n\
    RA4W[30],RA8F(17)[30],RA8G(17)[30],RA8X(17)[20],RA9F(17)[30],RA9G(17)[30],\n\
    RA9X(17)[20],RC1I(17)[20],RC1N[19],RC1O[19],RC1P[20],RC1Z[19],RC4H[30],\n\
    RC4I[30],RC4W[30],RC8F(17)[30],RC8G(17)[30],RC8X(17)[20],RC9F(17)[30],\n\
    RC9G(17)[30],RC9X(17)[20],RD1I(17)[20],RD1N[19],RD1O[19],RD1P[20],\n\
    RD1Z[19],RD4H[30],RD4I[30],RD4W[30],RD8F(17)[30],RD8G(17)[30],\n\
    RD8X(17)[20],RD9F(17)[30],RD9G(17)[30],RD9X(17)[20],RE1I(17)[20],RE1N[19],\n\
    RE1O[19],RE1P[20],RE1Z[19],RE4H[30],RE4I[30],RE4W[30],RE8F(17)[30],\n\
    RE8G(17)[30],RE8X(17)[20],RE9F(17)[30],RE9G(17)[30],RE9X(17)[20],\n\
    RF1I(17)[20],RF1N[19],RF1O[19],RF1P[20],RF1Z[19],RF4H[30],RF4I[30],\n\
    RF4W[30],RF8F(17)[30],RF8G(17)[30],RF8X(17)[20],RF9F(17)[30],RF9G(17)[30],\n\
    RF9X(17)[20],RG1I(17)[20],RG1N[19],RG1O[19],RG1P[20],RG1Z[19],RG4H[30],\n\
    RG4I[30],RG4W[30],RG8F(17)[30],RG8G(17)[30],RG8X(17)[20],RG9F(17)[30],\n\
    RG9G(17)[30],RG9X(17)[20],RI8X(17)[20],RI9X(17)[20],RJ1I(17)[20],RJ1N[19],\n\
    RJ1O[19],RJ1P[20],RJ1Z[19],RJ4H[30],RJ4I[30],RJ4W[30],RJ8F(17)[30],\n\
    RJ8G(17)[30],RJ8X(17)[20],RJ9F(17)[30],RJ9G(17)[30],RJ9X(17)[20],\n\
    RK1I(17)[20],RK1N[19],RK1O[19],RK1P[20],RK1Z[19],RK4H[30],RK4I[30],\n\
    RK4W[30],RK8F(17)[30],RK8G(17)[30],RK8X(17)[20],RK9F(17)[30],RK9G(17)[30],\n\
    RK9X(17)[20],RL1I(17)[20],RL1N[19],RL1O[19],RL1P[20],RL1Z[19],RL4H[30],\n\
    RL4I[30],RL4W[30],RL8F(17)[30],RL8G(17)[30],RL8X(17)[20],RL9F(17)[30],\n\
    RL9G(17)[30],RL9X(17)[20],RM1I(17)[20],RM1N[19],RM1O[19],RM1P[20],\n\
    RM1Z[19],RM4H[30],RM4I[30],RM4W[30],RM8F(17)[30],RM8G(17)[30],\n\
    RM8X(17)[20],RM9F(17)[30],RM9G(17)[30],RM9X(17)[20],RN1I(17)[20],RN1N[19],\n\
    RN1O[19],RN1P[20],RN1Z[19],RN4H[30],RN4I[30],RN4W[30],RN8F(17)[30],\n\
    RN8G(17)[30],RN8X(17)[20],RN9F(17)[30],RN9G(17)[30],RN9X(17)[20],\n\
    RO1I(17)[20],RO1N[19],RO1O[19],RO1P[20],RO1Z[19],RO4H[30],RO4I[30],\n\
    RO4W[30],RO8F(17)[30],RO8G(17)[30],RO8X(17)[20],RO9F(17)[30],RO9G(17)[30],\n\
    RO9X(17)[20],RQ1I(17)[20],RQ1N[19],RQ1O[19],RQ1P[20],RQ1Z[19],RQ4H[30],\n\
    RQ4I[30],RQ4W[30],RQ8F(17)[30],RQ8G(17)[30],RQ8X(17)[20],RQ9F(17)[30],\n\
    RQ9G(17)[30],RQ9X(17)[20],RT1I(17)[20],RT1N[19],RT1O[19],RT1P[20],\n\
    RT1Z[19],RT4H[30],RT4I[30],RT4W[30],RT8F(17)[30],RT8G(17)[30],\n\
    RT8X(17)[20],RT9F(17)[30],RT9G(17)[30],RT9X(17)[20],RU1I(17)[20],RU1N[19],\n\
    RU1O[19],RU1P[20],RU1Z[19],RU4H[30],RU4I[30],RU4W[30],RU8F(17)[30],\n\
    RU8G(17)[30],RU8X(17)[20],RU9F(17)[30],RU9G(17)[30],RU9X(17)[20],\n\
    RV1I(17)[20],RV1N[19],RV1O[19],RV1P[20],RV1Z[19],RV4H[30],RV4I[30],\n\
    RV4W[30],RV8F(17)[30],RV8G(17)[30],RV8X(17)[20],RV9F(17)[30],RV9G(17)[30],\n\
    RV9X(17)[20],RW1I(17)[20],RW1N[19],RW1O[19],RW1P[20],RW1Z[19],RW4H[30],\n\
    RW4I[30],RW4W[30],RW8F(17)[30],RW8G(17)[30],RW8X(17)[20],RW9F(17)[30],\n\
    RW9G(17)[30],RW9X(17)[20],RX1I(17)[20],RX1N[19],RX1O[19],RX1P[20],\n\
    RX1Z[19],RX4H[30],RX4I[30],RX4W[30],RX8F(17)[30],RX8G(17)[30],\n\
    RX8X(17)[20],RX9F(17)[30],RX9G(17)[30],RX9X(17)[20],RY1I(17)[20],RY1N[19],\n\
    RY1O[19],RY1P[20],RY1Z[19],RY4H[30],RY4I[30],RY4W[30],RY8F(17)[30],\n\
    RY8G(17)[30],RY8X(17)[20],RY9F(17)[30],RY9G(17)[30],RY9X(17)[20],\n\
    RZ1I(17)[20],RZ1N[19],RZ1O[19],RZ1P[20],RZ1Z[19],RZ4H[30],RZ4I[30],\n\
    RZ4W[30],RZ8F(17)[30],RZ8G(17)[30],RZ8X(17)[20],RZ9F(17)[30],RZ9G(17)[30],\n\
    RZ9X(17)[20],U1I(17)[20],U1N[19],U1O[19],U1P[20],U1Z[19],U4H[30],U4I[30],\n\
    U4W[30],U8F(17)[30],U8G(17)[30],U8X(17)[20],U9F(17)[30],U9G(17)[30],\n\
    U9X(17)[20],UA1I(17)[20],UA1N[19],UA1O[19],UA1P[20],UA1Z[19],UA4H[30],\n\
    UA4I[30],UA4W[30],UA8F(17)[30],UA8G(17)[30],UA8X(17)[20],UA9F(17)[30],\n\
    UA9G(17)[30],UA9X(17)[20],UB1I(17)[20],UB1N[19],UB1O[19],UB1P[20],\n\
    UB1Z[19],UB4H[30],UB4I[30],UB4W[30],UB8F(17)[30],UB8G(17)[30],\n\
    UB8X(17)[20],UB9F(17)[30],UB9G(17)[30],UB9X(17)[20],UC1I(17)[20],UC1N[19],\n\
    UC1O[19],UC1P[20],UC1Z[19],UC4H[30],UC4I[30],UC4W[30],UC8F(17)[30],\n\
    UC8G(17)[30],UC8X(17)[20],UC9F(17)[30],UC9G(17)[30],UC9X(17)[20],\n\
    UD1I(17)[20],UD1N[19],UD1O[19],UD1P[20],UD1Z[19],UD4H[30],UD4I[30],\n\
    UD4W[30],UD8F(17)[30],UD8G(17)[30],UD8X(17)[20],UD9F(17)[30],UD9G(17)[30],\n\
    UD9X(17)[20],UE1I(17)[20],UE1N[19],UE1O[19],UE1P[20],UE1Z[19],UE4H[30],\n\
    UE4I[30],UE4W[30],UE8F(17)[30],UE8G(17)[30],UE8X(17)[20],UE9F(17)[30],\n\
    UE9G(17)[30],UE9X(17)[20],UF1I(17)[20],UF1N[19],UF1O[19],UF1P[20],\n\
    UF1Z[19],UF4H[30],UF4I[30],UF4W[30],UF8F(17)[30],UF8G(17)[30],\n\
    UF8X(17)[20],UF9F(17)[30],UF9G(17)[30],UF9X(17)[20],UG1I(17)[20],UG1N[19],\n\
    UG1O[19],UG1P[20],UG1Z[19],UG4H[30],UG4I[30],UG4W[30],UG8F(17)[30],\n\
    UG8G(17)[30],UG8X(17)[20],UG9F(17)[30],UG9G(17)[30],UG9X(17)[20],\n\
    UH1I(17)[20],UH1N[19],UH1O[19],UH1P[20],UH1Z[19],UH4H[30],UH4I[30],\n\
    UH4W[30],UH8F(17)[30],UH8G(17)[30],UH8X(17)[20],UH9F(17)[30],UH9G(17)[30],\n\
    UH9X(17)[20],UI1I(17)[20],UI1N[19],UI1O[19],UI1P[20],UI1Z[19],UI4H[30],\n\
    UI4I[30],UI4W[30],UI8F(17)[30],UI8G(17)[30],UI8X(17)[20],UI9F(17)[30],\n\
    UI9G(17)[30],UI9X(17)[20],=R0AGD/6,=UA0ZL/6,=R3ARS/4[30],=R4HAT[29],\n\
    =R4HC[29],=R4HCE[29],=R4HCZ[29],=R4HD[29],=R4HDC[29],=R4HDR[29],=R4HL[29],\n\
    =R4IC[29],=R4ID[29],=R4II[29],=R4IK[29],=R4IM[29],=R4IN[29],=R4IO[29],\n\
    =R4IT[29],=R85AAL,=R8MB/1(17)[20],=R9CMA/4,=R9CZ/3,=RA3X/1(17)[20],\n\
    =RA4HL[29],=RA4NCC[30],=RA9KD/6,=RA9SGI/1,=RC4HT[29],=RC4I[29],=RJ4I[29],\n\
    =RJ4P[30],=RK4HM[29],=RK75OP[19],=RM4I[29],=RM4R[30],=RN4HFJ[29],\n\
    =RN4HIF[29],=RT9K/6,=RT9T/1,=RT9T/3,=RU4HD[29],=RU4HP[29],=RU4I[29],\n\
    =RU9MU/1,=RW4HM[29],=RW4HTK[29],=RW4HW[29],=RW4HZ[29],=RW9WJ/4[30],\n\
    =RZ9SZ/3,=UA4H[29],=UA4HBM[29],=UA4HGL[29],=UA4HIP[29],=UA4HRZ[29],\n\
    =UA4HY[29],=UA4NF[30],=UA4PN[30],=UC4I[29],=UI4I[29];\n\
Kaliningrad:              15:  29:  EU:   54.72:   -20.52:    -3.0:  UA2:\n\
    R2F,R2K,RA2,RC2F,RC2K,RD2F,RD2K,RE2F,RE2K,RF2F,RF2K,RG2F,RG2K,RJ2F,RJ2K,\n\
    RK2F,RK2K,RL2F,RL2K,RM2F,RM2K,RN2F,RN2K,RO2F,RO2K,RQ2F,RQ2K,RT2F,RT2K,\n\
    RU2F,RU2K,RV2F,RV2K,RW2F,RW2K,RX2F,RX2K,RY2F,RY2K,RZ2F,RZ2K,U2F,U2K,UA2,\n\
    UB2,UC2,UD2,UE2,UF2,UG2,UH2,UI2,=R2MWO;\n\
Asiatic Russia:           17:  30:  AS:   55.88:   -84.08:    -7.0:  UA9:\n\
    R0,R8(17)[30],R9,RA0,RA8(17)[30],RA9,RC0,RC8(17)[30],RC9,RD0,RD8(17)[30],\n\
    RD9,RE0,RE8(17)[30],RE9,RF0,RF8(17)[30],RF9,RG0,RG8(17)[30],RG9,RI0,\n\
    RI8(17)[30],RI9,RJ0,RJ8(17)[30],RJ9,RK0,RK8(17)[30],RK9,RL0,RL8(17)[30],\n\
    RL9,RM0,RM8(17)[30],RM9,RN0,RN8(17)[30],RN9,RO0,RO8(17)[30],RO9,RQ0,\n\
    RQ8(17)[30],RQ9,RT0,RT8(17)[30],RT9,RU0,RU8(17)[30],RU9,RV0,RV8(17)[30],\n\
    RV9,RW0,RW8(17)[30],RW9,RX0,RX8(17)[30],RX9,RY0,RY8(17)[30],RY9,RZ0,\n\
    RZ8(17)[30],RZ9,U0,U8(17)[30],U9,UA0,UA8(17)[30],UA9,UB0,UB8(17)[30],UB9,\n\
    UC0,UC8(17)[30],UC9,UD0,UD8(17)[30],UD9,UE0,UE8(17)[30],UE9,UF0,\n\
    UF8(17)[30],UF9,UG0,UG8(17)[30],UG9,UH0,UH8(17)[30],UH9,UI0,UI8(17)[30],\n\
    UI9,R0T(18)[32],R8H(18)[31],R8I(18)[31],R8O(18)[31],R8P(18)[31],\n\
    R8S(16)[30],R8T(16)[30],R8U(18)[31],R8V(18)[31],R8W(16)[30],R8Y(18)[31],\n\
    R8Z(18)[31],R9I(18)[31],R9M(17)[30],R9P(18)[31],R9S(16),R9T(16),\n\
    R9V(18)[31],R9W(16),RA0T(18)[32],RA8H(18)[31],RA8I(18)[31],RA8O(18)[31],\n\
    RA8P(18)[31],RA8S(16)[30],RA8T(16)[30],RA8U(18)[31],RA8V(18)[31],\n\
    RA8W(16)[30],RA8Y(18)[31],RA8Z(18)[31],RA9I(18)[31],RA9M(17)[30],\n\
    RA9P(18)[31],RA9S(16),RA9T(16),RA9V(18)[31],RA9W(16),RC0T(18)[32],\n\
    RC8H(18)[31],RC8I(18)[31],RC8O(18)[31],RC8P(18)[31],RC8S(16)[30],\n\
    RC8T(16)[30],RC8U(18)[31],RC8V(18)[31],RC8W(16)[30],RC8Y(18)[31],\n\
    RC8Z(18)[31],RC9I(18)[31],RC9M(17)[30],RC9P(18)[31],RC9S(16),RC9T(16),\n\
    RC9V(18)[31],RC9W(16),RD0T(18)[32],RD8H(18)[31],RD8I(18)[31],RD8O(18)[31],\n\
    RD8P(18)[31],RD8S(16)[30],RD8T(16)[30],RD8U(18)[31],RD8V(18)[31],\n\
    RD8W(16)[30],RD8Y(18)[31],RD8Z(18)[31],RD9I(18)[31],RD9M(17)[30],\n\
    RD9P(18)[31],RD9S(16),RD9T(16),RD9V(18)[31],RD9W(16),RE0T(18)[32],\n\
    RE8H(18)[31],RE8I(18)[31],RE8O(18)[31],RE8P(18)[31],RE8S(16)[30],\n\
    RE8T(16)[30],RE8U(18)[31],RE8V(18)[31],RE8W(16)[30],RE8Y(18)[31],\n\
    RE8Z(18)[31],RE9I(18)[31],RE9M(17)[30],RE9P(18)[31],RE9S(16),RE9T(16),\n\
    RE9V(18)[31],RE9W(16),RF0T(18)[32],RF8H(18)[31],RF8I(18)[31],RF8O(18)[31],\n\
    RF8P(18)[31],RF8S(16)[30],RF8T(16)[30],RF8U(18)[31],RF8V(18)[31],\n\
    RF8W(16)[30],RF8Y(18)[31],RF8Z(18)[31],RF9I(18)[31],RF9M(17)[30],\n\
    RF9P(18)[31],RF9S(16),RF9T(16),RF9V(18)[31],RF9W(16),RG0T(18)[32],\n\
    RG8H(18)[31],RG8I(18)[31],RG8O(18)[31],RG8P(18)[31],RG8S(16)[30],\n\
    RG8T(16)[30],RG8U(18)[31],RG8V(18)[31],RG8W(16)[30],RG8Y(18)[31],\n\
    RG8Z(18)[31],RG9I(18)[31],RG9M(17)[30],RG9P(18)[31],RG9S(16),RG9T(16),\n\
    RG9V(18)[31],RG9W(16),RJ0T(18)[32],RJ8H(18)[31],RJ8I(18)[31],RJ8O(18)[31],\n\
    RJ8P(18)[31],RJ8S(16)[30],RJ8T(16)[30],RJ8U(18)[31],RJ8V(18)[31],\n\
    RJ8W(16)[30],RJ8Y(18)[31],RJ8Z(18)[31],RJ9I(18)[31],RJ9M(17)[30],\n\
    RJ9P(18)[31],RJ9S(16),RJ9T(16),RJ9V(18)[31],RJ9W(16),RK0T(18)[32],\n\
    RK8H(18)[31],RK8I(18)[31],RK8O(18)[31],RK8P(18)[31],RK8S(16)[30],\n\
    RK8T(16)[30],RK8U(18)[31],RK8V(18)[31],RK8W(16)[30],RK8Y(18)[31],\n\
    RK8Z(18)[31],RK9I(18)[31],RK9M(17)[30],RK9P(18)[31],RK9S(16),RK9T(16),\n\
    RK9V(18)[31],RK9W(16),RL0T(18)[32],RL8H(18)[31],RL8I(18)[31],RL8O(18)[31],\n\
    RL8P(18)[31],RL8S(16)[30],RL8T(16)[30],RL8U(18)[31],RL8V(18)[31],\n\
    RL8W(16)[30],RL8Y(18)[31],RL8Z(18)[31],RL9I(18)[31],RL9M(17)[30],\n\
    RL9P(18)[31],RL9S(16),RL9T(16),RL9V(18)[31],RL9W(16),RM0T(18)[32],\n\
    RM8H(18)[31],RM8I(18)[31],RM8O(18)[31],RM8P(18)[31],RM8S(16)[30],\n\
    RM8T(16)[30],RM8U(18)[31],RM8V(18)[31],RM8W(16)[30],RM8Y(18)[31],\n\
    RM8Z(18)[31],RM9I(18)[31],RM9M(17)[30],RM9P(18)[31],RM9S(16),RM9T(16),\n\
    RM9V(18)[31],RM9W(16),RN0T(18)[32],RN8H(18)[31],RN8I(18)[31],RN8O(18)[31],\n\
    RN8P(18)[31],RN8S(16)[30],RN8T(16)[30],RN8U(18)[31],RN8V(18)[31],\n\
    RN8W(16)[30],RN8Y(18)[31],RN8Z(18)[31],RN9I(18)[31],RN9M(17)[30],\n\
    RN9P(18)[31],RN9S(16),RN9T(16),RN9V(18)[31],RN9W(16),RO0T(18)[32],\n\
    RO8H(18)[31],RO8I(18)[31],RO8O(18)[31],RO8P(18)[31],RO8S(16)[30],\n\
    RO8T(16)[30],RO8U(18)[31],RO8V(18)[31],RO8W(16)[30],RO8Y(18)[31],\n\
    RO8Z(18)[31],RO9I(18)[31],RO9M(17)[30],RO9P(18)[31],RO9S(16),RO9T(16),\n\
    RO9V(18)[31],RO9W(16),RQ0T(18)[32],RQ8H(18)[31],RQ8I(18)[31],RQ8O(18)[31],\n\
    RQ8P(18)[31],RQ8S(16)[30],RQ8T(16)[30],RQ8U(18)[31],RQ8V(18)[31],\n\
    RQ8W(16)[30],RQ8Y(18)[31],RQ8Z(18)[31],RQ9I(18)[31],RQ9M(17)[30],\n\
    RQ9P(18)[31],RQ9S(16),RQ9T(16),RQ9V(18)[31],RQ9W(16),RT0T(18)[32],\n\
    RT8H(18)[31],RT8I(18)[31],RT8O(18)[31],RT8P(18)[31],RT8S(16)[30],\n\
    RT8T(16)[30],RT8U(18)[31],RT8V(18)[31],RT8W(16)[30],RT8Y(18)[31],\n\
    RT8Z(18)[31],RT9I(18)[31],RT9M(17)[30],RT9P(18)[31],RT9S(16),RT9T(16),\n\
    RT9V(18)[31],RT9W(16),RU0T(18)[32],RU8H(18)[31],RU8I(18)[31],RU8O(18)[31],\n\
    RU8P(18)[31],RU8S(16)[30],RU8T(16)[30],RU8U(18)[31],RU8V(18)[31],\n\
    RU8W(16)[30],RU8Y(18)[31],RU8Z(18)[31],RU9I(18)[31],RU9M(17)[30],\n\
    RU9P(18)[31],RU9S(16),RU9T(16),RU9V(18)[31],RU9W(16),RV0T(18)[32],\n\
    RV8H(18)[31],RV8I(18)[31],RV8O(18)[31],RV8P(18)[31],RV8S(16)[30],\n\
    RV8T(16)[30],RV8U(18)[31],RV8V(18)[31],RV8W(16)[30],RV8Y(18)[31],\n\
    RV8Z(18)[31],RV9I(18)[31],RV9M(17)[30],RV9P(18)[31],RV9S(16),RV9T(16),\n\
    RV9V(18)[31],RV9W(16),RW0T(18)[32],RW8H(18)[31],RW8I(18)[31],RW8O(18)[31],\n\
    RW8P(18)[31],RW8S(16)[30],RW8T(16)[30],RW8U(18)[31],RW8V(18)[31],\n\
    RW8W(16)[30],RW8Y(18)[31],RW8Z(18)[31],RW9I(18)[31],RW9M(17)[30],\n\
    RW9P(18)[31],RW9S(16),RW9T(16),RW9V(18)[31],RW9W(16),RX0T(18)[32],\n\
    RX8H(18)[31],RX8I(18)[31],RX8O(18)[31],RX8P(18)[31],RX8S(16)[30],\n\
    RX8T(16)[30],RX8U(18)[31],RX8V(18)[31],RX8W(16)[30],RX8Y(18)[31],\n\
    RX8Z(18)[31],RX9I(18)[31],RX9M(17)[30],RX9P(18)[31],RX9S(16),RX9T(16),\n\
    RX9V(18)[31],RX9W(16),RY0T(18)[32],RY8H(18)[31],RY8I(18)[31],RY8O(18)[31],\n\
    RY8P(18)[31],RY8S(16)[30],RY8T(16)[30],RY8U(18)[31],RY8V(18)[31],\n\
    RY8W(16)[30],RY8Y(18)[31],RY8Z(18)[31],RY9I(18)[31],RY9M(17)[30],\n\
    RY9P(18)[31],RY9S(16),RY9T(16),RY9V(18)[31],RY9W(16),RZ0T(18)[32],\n\
    RZ8H(18)[31],RZ8I(18)[31],RZ8O(18)[31],RZ8P(18)[31],RZ8S(16)[30],\n\
    RZ8T(16)[30],RZ8U(18)[31],RZ8V(18)[31],RZ8W(16)[30],RZ8Y(18)[31],\n\
    RZ8Z(18)[31],RZ9I(18)[31],RZ9M(17)[30],RZ9P(18)[31],RZ9S(16),RZ9T(16),\n\
    RZ9V(18)[31],RZ9W(16),U0T(18)[32],U8H(18)[31],U8I(18)[31],U8O(18)[31],\n\
    U8P(18)[31],U8S(16)[30],U8T(16)[30],U8U(18)[31],U8V(18)[31],U8W(16)[30],\n\
    U8Y(18)[31],U8Z(18)[31],U9I(18)[31],U9M(17)[30],U9P(18)[31],U9S(16),\n\
    U9T(16),U9V(18)[31],U9W(16),UA0T(18)[32],UA8H(18)[31],UA8I(18)[31],\n\
    UA8O(18)[31],UA8P(18)[31],UA8S(16)[30],UA8T(16)[30],UA8U(18)[31],\n\
    UA8V(18)[31],UA8W(16)[30],UA8Y(18)[31],UA8Z(18)[31],UA9I(18)[31],\n\
    UA9M(17)[30],UA9P(18)[31],UA9S(16),UA9T(16),UA9V(18)[31],UA9W(16),\n\
    UB0T(18)[32],UB8H(18)[31],UB8I(18)[31],UB8O(18)[31],UB8P(18)[31],\n\
    UB8S(16)[30],UB8T(16)[30],UB8U(18)[31],UB8V(18)[31],UB8W(16)[30],\n\
    UB8Y(18)[31],UB8Z(18)[31],UB9I(18)[31],UB9M(17)[30],UB9P(18)[31],UB9S(16),\n\
    UB9T(16),UB9V(18)[31],UB9W(16),UC0T(18)[32],UC8H(18)[31],UC8I(18)[31],\n\
    UC8O(18)[31],UC8P(18)[31],UC8S(16)[30],UC8T(16)[30],UC8U(18)[31],\n\
    UC8V(18)[31],UC8W(16)[30],UC8Y(18)[31],UC8Z(18)[31],UC9I(18)[31],\n\
    UC9M(17)[30],UC9P(18)[31],UC9S(16),UC9T(16),UC9V(18)[31],UC9W(16),\n\
    UD0T(18)[32],UD8H(18)[31],UD8I(18)[31],UD8O(18)[31],UD8P(18)[31],\n\
    UD8S(16)[30],UD8T(16)[30],UD8U(18)[31],UD8V(18)[31],UD8W(16)[30],\n\
    UD8Y(18)[31],UD8Z(18)[31],UD9I(18)[31],UD9M(17)[30],UD9P(18)[31],UD9S(16),\n\
    UD9T(16),UD9V(18)[31],UD9W(16),UE0T(18)[32],UE8H(18)[31],UE8I(18)[31],\n\
    UE8O(18)[31],UE8P(18)[31],UE8S(16)[30],UE8T(16)[30],UE8U(18)[31],\n\
    UE8V(18)[31],UE8W(16)[30],UE8Y(18)[31],UE8Z(18)[31],UE9I(18)[31],\n\
    UE9M(17)[30],UE9P(18)[31],UE9S(16),UE9T(16),UE9V(18)[31],UE9W(16),\n\
    UF0T(18)[32],UF8H(18)[31],UF8I(18)[31],UF8O(18)[31],UF8P(18)[31],\n\
    UF8S(16)[30],UF8T(16)[30],UF8U(18)[31],UF8V(18)[31],UF8W(16)[30],\n\
    UF8Y(18)[31],UF8Z(18)[31],UF9I(18)[31],UF9M(17)[30],UF9P(18)[31],UF9S(16),\n\
    UF9T(16),UF9V(18)[31],UF9W(16),UG0T(18)[32],UG8H(18)[31],UG8I(18)[31],\n\
    UG8O(18)[31],UG8P(18)[31],UG8S(16)[30],UG8T(16)[30],UG8U(18)[31],\n\
    UG8V(18)[31],UG8W(16)[30],UG8Y(18)[31],UG8Z(18)[31],UG9I(18)[31],\n\
    UG9M(17)[30],UG9P(18)[31],UG9S(16),UG9T(16),UG9V(18)[31],UG9W(16),\n\
    UH0T(18)[32],UH8H(18)[31],UH8I(18)[31],UH8O(18)[31],UH8P(18)[31],\n\
    UH8S(16)[30],UH8T(16)[30],UH8U(18)[31],UH8V(18)[31],UH8W(16)[30],\n\
    UH8Y(18)[31],UH8Z(18)[31],UH9I(18)[31],UH9M(17)[30],UH9P(18)[31],UH9S(16),\n\
    UH9T(16),UH9V(18)[31],UH9W(16),UI0T(18)[32],UI8H(18)[31],UI8I(18)[31],\n\
    UI8O(18)[31],UI8P(18)[31],UI8S(16)[30],UI8T(16)[30],UI8U(18)[31],\n\
    UI8V(18)[31],UI8W(16)[30],UI8Y(18)[31],UI8Z(18)[31],UI9I(18)[31],\n\
    UI9M(17)[30],UI9P(18)[31],UI9S(16),UI9T(16),UI9V(18)[31],UI9W(16),\n\
    =RA0QK/8(17)[30],=UD6AOP/0,=R0WX/P(23)[32],=R2019CG(16),=R205NEW(19)[25],\n\
    =R26RRC(19)[34],=R2ET/9(18)[31],=R53ICGA(16),=R53ICGB(16),=R53ICGC(16),\n\
    =R53ICGF(16),=R53ICGJ(16),=R53ICGS(16),=R53ICGV(16),=R53ICGW(16),\n\
    =R63RRC(18)[32],=R66IOTA(19)[34],=RA/DF8DX(18)[31],=RA/DJ8QP(18)[31],\n\
    =RA3DS/P(18)[31],=RA4RU/9[20],=RD0L/9(18)[31],=RK4PA/9[20],=RN9S(16),\n\
    =RO9S(16),=RQ73QQ(19)[23],=RT9S(16),=RT9W(16),=RU9MV/0(19)[25],\n\
    =RW1AI/9(18)[22],=RW3YC/9(18)[32],=RW4YA/9(18)[32],=RW9WJ/P(16),\n\
    =RZ1CWC/8(17)[30],=RZ5D/9(18)[31],=UA3A/P(18)[31];\n\
Uzbekistan:               17:  30:  AS:   41.40:   -63.97:    -5.0:  UK:\n\
    UJ,UK,UL,UM;\n\
Kazakhstan:               17:  30:  AS:   48.17:   -65.18:    -5.0:  UN:\n\
    UN,UO,UP,UQ,UN0F[31],UN0G[31],UN0J[31],UN0Q[31],UN2F[31],UN2G[31],\n\
    UN2J[31],UN2Q[31],UN3F[31],UN3G[31],UN3J[31],UN3Q[31],UN4F[31],UN4G[31],\n\
    UN4J[31],UN4Q[31],UN5F[31],UN5G[31],UN5J[31],UN5Q[31],UN6F[31],UN6G[31],\n\
    UN6J[31],UN6Q[31],UN7F[31],UN7G[31],UN7J[31],UN7Q[31],UN8F[31],UN8G[31],\n\
    UN8J[31],UN8Q[31],UN9F[31],UN9G[31],UN9J[31],UN9Q[31],UO0F[31],UO0G[31],\n\
    UO0J[31],UO0Q[31],UO1F[31],UO1G[31],UO1J[31],UO1Q[31],UO2F[31],UO2G[31],\n\
    UO2J[31],UO2Q[31],UO3F[31],UO3G[31],UO3J[31],UO3Q[31],UO4F[31],UO4G[31],\n\
    UO4J[31],UO4Q[31],UO5F[31],UO5G[31],UO5J[31],UO5Q[31],UO6F[31],UO6G[31],\n\
    UO6J[31],UO6Q[31],UO7F[31],UO7G[31],UO7J[31],UO7Q[31],UO8F[31],UO8G[31],\n\
    UO8J[31],UO8Q[31],UO9F[31],UO9G[31],UO9J[31],UO9Q[31],UP0F[31],UP0G[31],\n\
    UP0J[31],UP0Q[31],UP1F[31],UP1G[31],UP1J[31],UP1Q[31],UP2F[31],UP2G[31],\n\
    UP2J[31],UP2Q[31],UP3F[31],UP3G[31],UP3J[31],UP3Q[31],UP4F[31],UP4G[31],\n\
    UP4J[31],UP4Q[31],UP5F[31],UP5G[31],UP5J[31],UP5Q[31],UP6F[31],UP6G[31],\n\
    UP6J[31],UP6Q[31],UP7F[31],UP7G[31],UP7J[31],UP7Q[31],UP8F[31],UP8G[31],\n\
    UP8J[31],UP8Q[31],UP9F[31],UP9G[31],UP9J[31],UP9Q[31],UQ0F[31],UQ0G[31],\n\
    UQ0J[31],UQ0Q[31],UQ1F[31],UQ1G[31],UQ1J[31],UQ1Q[31],UQ2F[31],UQ2G[31],\n\
    UQ2J[31],UQ2Q[31],UQ3F[31],UQ3G[31],UQ3J[31],UQ3Q[31],UQ4F[31],UQ4G[31],\n\
    UQ4J[31],UQ4Q[31],UQ5F[31],UQ5G[31],UQ5J[31],UQ5Q[31],UQ6F[31],UQ6G[31],\n\
    UQ6J[31],UQ6Q[31],UQ7F[31],UQ7G[31],UQ7J[31],UQ7Q[31],UQ8F[31],UQ8G[31],\n\
    UQ8J[31],UQ8Q[31],UQ9F[31],UQ9G[31],UQ9J[31],UQ9Q[31];\n\
Ukraine:                  16:  29:  EU:   50.00:   -30.00:    -2.0:  UR:\n\
    EM,EN,EO,U5,UR,US,UT,UU,UV,UW,UX,UY,UZ;\n\
Antigua & Barbuda:        08:  11:  NA:   17.07:    61.80:     4.0:  V2:\n\
    V2;\n\
Belize:                   07:  11:  NA:   16.97:    88.67:     6.0:  V3:\n\
    V3;\n\
St. Kitts & Nevis:        08:  11:  NA:   17.37:    62.78:     4.0:  V4:\n\
    V4;\n\
Namibia:                  38:  57:  AF:  -22.00:   -17.00:    -1.0:  V5:\n\
    V5;\n\
Micronesia:               27:  65:  OC:    6.88:  -158.20:   -10.0:  V6:\n\
    V6;\n\
Marshall Islands:         31:  65:  OC:    9.08:  -167.33:   -12.0:  V7:\n\
    V7;\n\
Brunei Darussalam:        28:  54:  OC:    4.50:  -114.60:    -8.0:  V8:\n\
    V8;\n\
Canada:                   05:  09:  NA:   44.35:    78.75:     5.0:  VE:\n\
    CF,CG,CJ,CK,VA,VB,VC,VE,VG,VX,VY9,XL,XM,CF2[4],CG2[4],CH1,CH2(2),\n\
    CI0(2)[4],CI1(1)[2],CI2,CJ2[4],CK2[4],CY1,CY2(2),CZ0(2)[4],CZ1(1)[2],CZ2,\n\
    VA2[4],VB2[4],VC2[4],VD1,VD2(2),VE2[4],VF0(2)[4],VF1(1)[2],VF2,VG2[4],VO1,\n\
    VO2(2),VX2[4],VY0(2)[4],VY1(1)[2],VY2,XJ1,XJ2(2),XK0(2)[4],XK1(1)[2],XK2,\n\
    XL2[4],XM2[4],XN1,XN2(2),XO0(2)[4],XO1(1)[2],XO2,=VER20190630,\n\
    =VA2VVV(2)[4],=VA3ELE/2(2)[4],=VA7XW/VE2(2)[4],=VE2CSI(2)[4],\n\
    =VE2EKA(2)[4],=VE2FK[9],=VE2IDX(2)[4],=VE2IM(2)[4],=VE2KK(2)[4],\n\
    =VE2NN(2)[4],=VE2TKH(2)[4],=VE2TWO(2)[4],=VE7ACN/VE2(2)[4],=VE8AT(2)[4],\n\
    =VY0AA(4)[3],=VY0PW(4)[3];\n\
Australia:                30:  59:  OC:  -23.70:  -132.33:   -10.0:  VK:\n\
    AX,VH,VI,VJ,VK,VL,VM,VN,VZ,AX4[55],VH4[55],VI4[55],VJ4[55],VK4[55],\n\
    VL4[55],VM4[55],VN4[55],VZ4[55],=VK4VXX,=VK4VXX/6(29)[58],=VK6MB/2,\n\
    =VK6MB/3;\n\
Heard Island:             39:  68:  AF:  -53.08:   -73.50:    -5.0:  VK0H:\n\
    =VK0EK;\n\
Macquarie Island:         30:  60:  OC:  -54.60:  -158.88:   -10.0:  VK0M:\n\
    =VK0AI;\n\
Cocos (Keeling) Islands:  29:  54:  OC:  -12.15:   -96.82:    -6.5:  VK9C:\n\
    AX9C,AX9Y,VH9C,VH9Y,VI9C,VI9Y,VJ9C,VJ9Y,VK9C,VK9FC,VK9KC,VK9Y,VK9ZY,VL9C,\n\
    VL9Y,VM9C,VM9Y,VN9C,VN9Y,VZ9C,VZ9Y;\n\
Lord Howe Island:         30:  60:  OC:  -31.55:  -159.08:   -10.5:  VK9L:\n\
    AX9L,VH9L,VI9L,VJ9L,VK9FL,VK9L,VK9ZL,VL9L,VM9L,VN9L,VZ9L,=VK3YQS/9,\n\
    =VK3YQS/VK9,=VK9APX;\n\
Mellish Reef:             30:  56:  OC:  -17.40:  -155.85:   -10.0:  VK9M:\n\
    AX9M,VH9M,VI9M,VJ9M,VK9M,VL9M,VM9M,VN9M,VZ9M;\n\
Norfolk Island:           32:  60:  OC:  -29.03:  -167.93:   -11.5:  VK9N:\n\
    AX9,VH9,VI9,VJ9,VK9,VL9,VM9,VN9,VZ9;\n\
Willis Island:            30:  55:  OC:  -16.22:  -150.02:   -10.0:  VK9W:\n\
    AX9W,AX9Z,VH9W,VH9Z,VI9W,VI9Z,VJ9W,VJ9Z,VK9FW,VK9W,VK9Z,VL9W,VL9Z,VM9W,\n\
    VM9Z,VN9W,VN9Z,VZ9W,VZ9Z;\n\
Christmas Island:         29:  54:  OC:  -10.48:  -105.63:    -7.0:  VK9X:\n\
    AX9X,VH9X,VI9X,VJ9X,VK9FX,VK9KX,VK9X,VL9X,VM9X,VN9X,VZ9X;\n\
Anguilla:                 08:  11:  NA:   18.23:    63.00:     4.0:  VP2E:\n\
    VP2E;\n\
Montserrat:               08:  11:  NA:   16.75:    62.18:     4.0:  VP2M:\n\
    VP2M;\n\
British Virgin Islands:   08:  11:  NA:   18.33:    64.75:     4.0:  VP2V:\n\
    VP2V;\n\
Turks & Caicos Islands:   08:  11:  NA:   21.77:    71.75:     5.0:  VP5:\n\
    VP5,VQ5;\n\
Pitcairn Island:          32:  63:  OC:  -25.07:   130.10:     8.0:  VP6:\n\
    VP6;\n\
Ducie Island:             32:  63:  OC:  -24.70:   124.80:     8.0:  VP6/d:\n\
    =VP6D;\n\
Falkland Islands:         13:  16:  SA:  -51.63:    58.72:     4.0:  VP8:\n\
    VP8;\n\
South Georgia Island:     13:  73:  SA:  -54.48:    37.08:     2.0:  VP8/g:\n\
    =VP8CA;\n\
South Shetland Islands:   13:  73:  SA:  -62.08:    58.67:     4.0:  VP8/h:\n\
    CE9,XR9,=HF0POL,=RI1ANF;\n\
South Orkney Islands:     13:  73:  SA:  -60.60:    45.55:     3.0:  VP8/o:\n\
    =LU4ZD;\n\
South Sandwich Islands:   13:  73:  SA:  -58.43:    26.33:     2.0:  VP8/s:\n\
    =VP8DXU;\n\
Bermuda:                  05:  11:  NA:   32.32:    64.73:     4.0:  VP9:\n\
    VP9;\n\
Chagos Islands:           39:  41:  AF:   -7.32:   -72.42:    -6.0:  VQ9:\n\
    VQ9;\n\
Hong Kong:                24:  44:  AS:   22.28:  -114.18:    -8.0:  VR:\n\
    VR;\n\
India:                    22:  41:  AS:   22.50:   -77.58:    -5.5:  VU:\n\
    8T,8U,8V,8W,8X,8Y,AT,AU,AV,AW,VT,VU,VV,VW;\n\
Andaman & Nicobar Is.:    26:  49:  AS:   12.37:   -92.78:    -5.5:  VU4:\n\
    VU4;\n\
Lakshadweep Islands:      22:  41:  AS:   11.23:   -72.78:    -5.5:  VU7:\n\
    VU7;\n\
Mexico:                   06:  10:  NA:   21.32:   100.23:     6.0:  XE:\n\
    4A,4B,4C,6D,6E,6F,6G,6H,6I,6J,XA,XB,XC,XD,XE,XF,XG,XH,XI;\n\
Revillagigedo:            06:  10:  NA:   18.77:   110.97:     7.0:  XF4:\n\
    4A4,4B4,4C4,6D4,6E4,6F4,6G4,6H4,6I4,6J4,XA4,XB4,XC4,XD4,XE4,XF4,XG4,XH4,\n\
    XI4;\n\
Burkina Faso:             35:  46:  AF:   12.00:     2.00:     0.0:  XT:\n\
    XT;\n\
Cambodia:                 26:  49:  AS:   12.93:  -105.13:    -7.0:  XU:\n\
    XU;\n\
Laos:                     26:  49:  AS:   18.20:  -104.55:    -7.0:  XW:\n\
    XW;\n\
Macao:                    24:  44:  AS:   22.10:  -113.50:    -8.0:  XX9:\n\
    XX9;\n\
Myanmar:                  26:  49:  AS:   20.00:   -96.37:    -6.5:  XZ:\n\
    XY,XZ;\n\
Afghanistan:              21:  40:  AS:   34.70:   -65.80:    -4.5:  YA:\n\
    T6,YA;\n\
Indonesia:                28:  51:  OC:   -7.30:  -109.88:    -7.0:  YB:\n\
    7A,7B,7C,7D,7E,7F,7G,7H,7I,8A,8B,8C,8D,8E,8F,8G,8H,8I,PK,PL,PM,PN,PO,YB,\n\
    YC,YD,YE,YF,YG,YH,YB0[54],YB1[54],YB2[54],YB3[54],YB4[54],YB5[54],YB6[54],\n\
    YB7[54],YB8[54],YC0[54],YC1[54],YC2[54],YC3[54],YC4[54],YC5[54],YC6[54],\n\
    YC7[54],YC8[54],YD0[54],YD1[54],YD2[54],YD3[54],YD4[54],YD5[54],YD6[54],\n\
    YD7[54],YD8[54],YE0[54],YE1[54],YE2[54],YE3[54],YE4[54],YE5[54],YE6[54],\n\
    YE7[54],YE8[54],YF0[54],YF1[54],YF2[54],YF3[54],YF4[54],YF5[54],YF6[54],\n\
    YF7[54],YF8[54],YG0[54],YG1[54],YG2[54],YG3[54],YG4[54],YG5[54],YG6[54],\n\
    YG7[54],YG8[54],YH0[54],YH1[54],YH2[54],YH3[54],YH4[54],YH5[54],YH6[54],\n\
    YH7[54],YH8[54];\n\
Iraq:                     21:  39:  AS:   33.92:   -42.78:    -3.0:  YI:\n\
    HN,YI;\n\
Vanuatu:                  32:  56:  OC:  -17.67:  -168.38:   -11.0:  YJ:\n\
    YJ;\n\
Syria:                    20:  39:  AS:   35.38:   -38.20:    -2.0:  YK:\n\
    6C,YK;\n\
Latvia:                   15:  29:  EU:   57.03:   -24.65:    -2.0:  YL:\n\
    YL;\n\
Nicaragua:                07:  11:  NA:   12.88:    85.05:     6.0:  YN:\n\
    H6,H7,HT,YN;\n\
Romania:                  20:  28:  EU:   45.78:   -24.70:    -2.0:  YO:\n\
    YO,YP,YQ,YR;\n\
El Salvador:              07:  11:  NA:   14.00:    89.00:     6.0:  YS:\n\
    HU,YS;\n\
Serbia:                   15:  28:  EU:   44.00:   -21.00:    -1.0:  YU:\n\
    YT,YU;\n\
Venezuela:                09:  12:  SA:    8.00:    66.00:     4.5:  YV:\n\
    4M,YV,YW,YX,YY;\n\
Aves Island:              08:  11:  NA:   15.67:    63.60:     4.0:  YV0:\n\
    4M0,YV0,YW0,YX0,YY0;\n\
Zimbabwe:                 38:  53:  AF:  -18.00:   -31.00:    -2.0:  Z2:\n\
    Z2;\n\
North Macedonia:          15:  28:  EU:   41.60:   -21.65:    -1.0:  Z3:\n\
    Z3;\n\
Republic of Kosovo:       15:  28:  EU:   42.67:   -21.17:    -1.0:  Z6:\n\
    Z6;\n\
Republic of South Sudan:  34:  48:  AF:    4.85:   -31.60:    -3.0:  Z8:\n\
    Z8;\n\
Albania:                  15:  28:  EU:   41.00:   -20.00:    -1.0:  ZA:\n\
    ZA;\n\
Gibraltar:                14:  37:  EU:   36.15:     5.37:    -1.0:  ZB:\n\
    ZB,ZG;\n\
UK Base Areas on Cyprus:  20:  39:  AS:   35.32:   -33.57:    -2.0:  ZC4:\n\
    ZC4;\n\
St. Helena:               36:  66:  AF:  -15.97:     5.72:     0.0:  ZD7:\n\
    ZD7;\n\
Ascension Island:         36:  66:  AF:   -7.93:    14.37:     0.0:  ZD8:\n\
    ZD8;\n\
Tristan da Cunha & Gough: 38:  66:  AF:  -37.13:    12.30:     0.0:  ZD9:\n\
    ZD9;\n\
Cayman Islands:           08:  11:  NA:   19.32:    81.22:     5.0:  ZF:\n\
    ZF;\n\
Tokelau Islands:          31:  62:  OC:   -9.40:   171.20:   -13.0:  ZK3:\n\
    ZK3;\n\
New Zealand:              32:  60:  OC:  -41.83:  -173.27:   -12.0:  ZL:\n\
    ZK,ZL,ZL50,ZM;\n\
Chatham Islands:          32:  60:  OC:  -43.85:   176.48:  -12.75:  ZL7:\n\
    ZL7,ZM7;\n\
Kermadec Islands:         32:  60:  OC:  -29.25:   177.92:   -12.0:  ZL8:\n\
    ZL8,ZM8;\n\
N.Z. Subantarctic Is.:    32:  60:  OC:  -51.62:  -167.62:   -12.0:  ZL9:\n\
    ZL9;\n\
Paraguay:                 11:  14:  SA:  -25.27:    57.67:     4.0:  ZP:\n\
    ZP;\n\
South Africa:             38:  57:  AF:  -29.07:   -22.63:    -2.0:  ZS:\n\
    H5,S4,S8,V9,ZR,ZS,ZT,ZU;\n\
Pr. Edward & Marion Is.:  38:  57:  AF:  -46.88:   -37.72:    -3.0:  ZS8:\n\
    ZR8,ZS8,ZT8,ZU8;"
;


