# ESSTRA Core

The ESSTRA Core intervenes in the compilation process to gather information
about all source and header files involved, embedding this data as metadata in
the resulting binary file.

## Status of This Version

The ESSTRA Core is currently being developed on Ubuntu 22.04 with GCC 11.4.0
installed on an x86\_64 PC.

In this version, the ESSTRA Core creates an ELF section named `.esstra` in
the resulting binary file compiled with GCC. This section contains information
about all files involved in the compilation, including their full paths and
SHA-1 hashes.

Please note that the specifications and features of the ESSTRA Core, including
the name of the ELF section, data formats, and the content of the metadata, as
well as the input/output specifications of each tool, are tentative and may
change in future versions.

## How to Build and Install

Before building the GCC plugin, you need to install a specific package on your
system.  For Debian/Ubuntu, first the version of GCC:

```sh
$ gcc --version
gcc (Ubuntu 11.4.0-1ubuntu1~22.04) 11.4.0
...
```

In this case, the major version is 11, so install the package named
`gcc-11-plugin-dev`:

```sh
$ sudo apt install gcc-11-plugin-dev
```

After that, run `make` in the this directory:

```sh
$ make
```

If there are no errors, a file named `esstracore.so` will be generated.
This is the GCC plugin "the ESSTRA Core."

To install the ESSTRA Core on your system, run the following command:

```sh
$ sudo make install
```

The `esstracore.so` file will then be installed in
`/usr/local/lib/gcc/<gcc-arch>/<gcc-major-version>/plugin/`.

## How to Use

To use the ESSTRA Core, specify the path of `esstracore.so` using the option
`-fplugin=` of `gcc` or `g++`.

For example, if you compile a source file `hello.c` or `hello.cpp`
with `gcc` or `g++` to generate a binary file `hello`, type:

```sh
$ gcc -fplugin=/usr/local/lib/gcc/x86_64-linux-gnu/11/plugin/esstracore.so hello.c -o hello
or
$ g++ -fplugin=/usr/local/lib/gcc/x86_64-linux-gnu/11/plugin/esstracore.so hello.cpp -o hello
```

The generated binary file `hello` has metadata embedded by the ESSTRA Core.

Use the [ESSTRA Utility](/util/README.md) to access metadata embedded in binary
files.

Note that this does not affect the behavior of the binary file itself.

## Installing a Spec File

It can be quite annoying to specify `-fplugin=....` for every `gcc`/`g++`
invocation. If you want to apply the ESSTRA Core to any `gcc`/`g++` occurrence,
simply type:

```sh
$ sudo make install-specs
```

This command installs a
[GCC spec file](https://gcc.gnu.org/onlinedocs/gcc/Spec-Files.html)
on your system, which enables the option
`-fplugin=/usr/local/lib/gcc/<gcc-arch>/<gcc-major-version>/plugin/esstracore.so`
by default. Therefore, compiling anything with GCC as usual:

```sh
$ gcc hello.c -o hello
```

will generate a binary file with metadata embedded by the ESSTRA Core.

This feature is very useful if you compile open source (or closed source, or
any other) projects and want the information generated by the ESSTRA Core for
them.  You do not need to modify Makefiles, CMakeList.txts, build.ninjas,
meson.builds, etc.

However, please note that installing the spec file will cause every
`gcc`/`g++` call to be intervened by the ESSTRA Core system-wide.

To disable this, type:

```sh
$ sudo make uninstall-specs
```

to remove the spec file.

## Known Issues

Here is the list of known issues in the current version:

* **LTO option prevents metadata generation**
  - **Description**: When using the LTO option (`-flto`) with `gcc`/`g++`,
    the generated binaries do not contain the expected metadata.
  - **Workaround**: Remove the LTO option.

## License

See the [LICENSE](../LICENSE) file.
